/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/Log","sap/base/util/extend","sap/ui/core/date/UI5Date","sap/ui/core/format/DateFormat","sap/ui/model/FormatException","sap/ui/model/ParseException","sap/ui/model/ValidateException","sap/ui/model/odata/type/ODataType"],function(t,e,n,o,r,i,a,u){"use strict";var s={__edmType:"Edm.Time",ms:86398e3},l={format:g,parse:c};function p(t){return sap.ui.getCore().getLibraryResourceBundle().getText("EnterTime",[t.formatValue(s,"string")])}function m(t){return typeof t==="object"&&t.__edmType==="Edm.Time"&&typeof t.ms==="number"}function f(e,n){var o;e.oConstraints=undefined;if(n){o=n.nullable;if(o===false||o==="false"){e.oConstraints={nullable:false}}else if(o!==undefined&&o!==true&&o!=="true"){t.warning("Illegal nullable: "+o,null,e.getName())}}}function c(t){if(!m(t)){throw new r("Illegal sap.ui.model.odata.type.Time value: "+d(t))}return new Date(t.ms)}function g(t){return{__edmType:"Edm.Time",ms:((t.getUTCHours()*60+t.getUTCMinutes())*60+t.getUTCSeconds())*1e3+t.getUTCMilliseconds()}}function d(t){try{return JSON.stringify(t)}catch(e){return String(t)}}var h=u.extend("sap.ui.model.odata.type.Time",{constructor:function(t,e){u.apply(this,arguments);f(this,e);this.oFormatOptions=t}});h.prototype.formatValue=function(t,e){if(t===undefined||t===null){return null}switch(this.getPrimitiveType(e)){case"any":return t;case"string":return this.getFormat().format(c(t));default:throw new r("Don't know how to format "+this.getName()+" to "+e)}};h.prototype.getDateValue=function(t){var e;if(!t){return null}e=n.getInstance(t.ms);e.setFullYear(1970,0,1);e.setHours(e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds(),e.getUTCMilliseconds());return e};h.prototype.getFormat=function(){if(!this.oFormat){var t=e({strictParsing:true},this.oFormatOptions);t.UTC=true;this.oFormat=o.getTimeInstance(t)}return this.oFormat};h.prototype.getISOStringFromModelValue=function(t){if(!t){return null}return n.getInstance(t.ms).toISOString().slice(11,-1)};h.prototype.getModelFormat=function(){return l};h.prototype.getModelValue=function(t){var e;if(t===null){e=null}else{n.checkDate(t);e=n.getInstance(0);e.setUTCHours(t.getHours(),t.getMinutes(),t.getSeconds(),t.getMilliseconds());e=g(e)}this.validateValue(e);return e};h.prototype.getModelValueFromISOString=function(t){if(!t){return null}return g(n.getInstance("1970-01-01T"+t+"Z"))};h.prototype.getName=function(){return"sap.ui.model.odata.type.Time"};h.prototype.parseValue=function(t,e){var n;if(t===""||t===null){return null}if(this.getPrimitiveType(e)!=="string"){throw new i("Don't know how to parse "+this.getName()+" from "+e)}n=this.getFormat().parse(t);if(!n){throw new i(p(this))}return g(n)};h.prototype.validateValue=function(t){if(t===null){if(this.oConstraints&&this.oConstraints.nullable===false){throw new a(p(this))}return}if(!m(t)){throw new a("Illegal "+this.getName()+" value: "+d(t))}};h.prototype._handleLocalizationChange=function(){this.oFormat=null};return h});
//# sourceMappingURL=Time.js.map