/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/assert","sap/base/Log","sap/base/util/deepEqual","sap/base/util/each","sap/base/util/isEmptyObject","sap/base/util/uid","sap/ui/model/ChangeReason","sap/ui/model/Context","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/model/FilterProcessor","sap/ui/model/FilterType","sap/ui/model/ListBinding","sap/ui/model/Sorter","sap/ui/model/SorterProcessor","sap/ui/model/odata/CountMode","sap/ui/model/odata/Filter","sap/ui/model/odata/ODataUtils","sap/ui/model/odata/OperationMode"],function(e,t,s,i,a,n,r,o,h,l,d,u,f,p,c,g,C,y,m){"use strict";var b="sap.ui.model.odata.v2.ODataListBinding",P=["changeSetId","error","expand","groupId","inactive","success"];var x=f.extend("sap.ui.model.odata.v2.ODataListBinding",{constructor:function(e,t,s,i,a,n){f.apply(this,arguments);this.sFilterParams=null;this.sSortParams=null;this.sCustomParams=this.oModel.createCustomParams(this.mParameters);this.mCustomParams=n&&n.custom;this.iLength=0;this.bPendingChange=false;this.aAllKeys=null;this.aKeys=[];this.sCountMode=n&&n.countMode||this.oModel.sDefaultCountMode;this.sOperationMode=n&&n.operationMode||this.oModel.sDefaultOperationMode;this.bUsePreliminaryContext=n&&n.usePreliminaryContext||e.bPreliminaryContext;if(!this.bUsePreliminaryContext&&s&&s.isPreliminary&&s.isPreliminary()){this.oContext=s=undefined}this.bRefresh=false;this.bNeedsUpdate=false;this.bDataAvailable=false;this.bIgnoreSuspend=false;this.bPendingRefresh=false;this.sGroupId=undefined;this.sRefreshGroupId=undefined;this.bLengthRequested=false;this.bUseExtendedChangeDetection=false;this.bFaultTolerant=n&&n.faultTolerant;this.bLengthFinal=false;this.iLastEndIndex=0;this.aLastContexts=null;this.aLastContextData=null;this.bInitial=true;this.mRequestHandles={};this.oCountHandle=null;this.bSkipDataEvents=false;this.bUseExpandedList=false;this.oCombinedFilter=null;this.sDeepPath=e.resolveDeep(t,s);this.bCanonicalRequest=n&&n.bCanonicalRequest;this.mNormalizeCache={};this.bTransitionMessagesOnly=!!(n&&n.transitionMessagesOnly);this.sCreatedEntitiesKey=n&&n.createdEntitiesKey||"";this.oCreatedPersistedToRemove=new Set;this.bRemovePersistedCreatedAfterRefresh=false;this.oModel.checkFilter(this.aApplicationFilters);if(n&&(n.batchGroupId||n.groupId)){this.sGroupId=n.groupId||n.batchGroupId}this.iThreshold=n&&n.threshold||0;this.bThresholdRejected=false;if(this.sCountMode==g.None){this.bThresholdRejected=true}if(!this.checkExpandedList()){this._removePersistedCreatedContexts();this.resetData()}this._reassignCreateActivate()},metadata:{publicMethods:["getLength"]}});x.prototype.attachCreateActivate=function(e,t){this.attachEvent("createActivate",e,t)};x.prototype.detachCreateActivate=function(e,t){this.detachEvent("createActivate",e,t)};x.prototype._updateLastStartAndLength=function(e,t,s,i){if(i){this._checkKeepCurrentSupported(s)}else{this.iLastStartIndex=e;this.iLastLength=t;this.iLastMaximumPrefetchSize=s}};x.prototype.getAllCurrentContexts=function(){var e=this._getCreatedContexts(),t=this;this.aKeys.forEach(function(s){e.push(t.oModel.getContext("/"+s))});return e};x.prototype.getContextByIndex=function(e){return this._getContexts(e,1)[0]};x.prototype.getContexts=function(e,t,s,i){var a,n,o;if(this.bInitial){return[]}if(!this.bLengthFinal&&this.sOperationMode==m.Auto&&(this.sCountMode==g.Request||this.sCountMode==g.Both)){if(!this.bLengthRequested){this._getLength();this.bLengthRequested=true}return[]}if(!this.bLengthFinal&&!this.bPendingRequest&&!this.bLengthRequested){this._getLength();this.bLengthRequested=true}this._updateLastStartAndLength(e,t,s,i);if(!e){e=0}if(!t){t=this._getMaximumLength()}if(!s){s=0}if(this.sOperationMode==m.Auto){if(this.iThreshold>=0){s=Math.max(this.iThreshold,s)}}a=this._getContexts(e,t);if(this.oCombinedFilter===h.NONE||this._hasTransientParentContext()){}else if(this.useClientMode()){if(!this.aAllKeys&&!this.bPendingRequest&&this.oModel.getServiceMetadata()){this.loadData();a.dataRequested=true}}else{o=this._getSkipAndTop(e,t,s);if(this.oModel.getServiceMetadata()){if(!this.bPendingRequest&&o){this.loadData(o.skip,o.top);a.dataRequested=true}}}if(this.isFirstCreateAtEnd()&&this.bPendingRequest&&a.length&&a[0].isTransient()!==undefined){a.length=0}if(this.bRefresh){this.bRefresh=false;if(!a.dataRequested&&a.length>0){this._fireChange({reason:r.Change})}}else if(!i){n=[];for(var l=0;l<a.length;l++){n.push(this.getContextData(a[l]))}if(this.bUseExtendedChangeDetection){if(this.aLastContexts&&e<this.iLastEndIndex){a.diff=this.diffData(this.aLastContextData,n)}}this.iLastEndIndex=e+t;this.aLastContexts=a.slice(0);this.aLastContextData=n}return a};x.prototype.getCurrentContexts=function(){return this.aLastContexts||[]};x.prototype.getEntryKey=function(e){return e.getPath()};x.prototype.getEntryData=function(e){return JSON.stringify(e.getObject(this.mParameters))};x.prototype._getContexts=function(e,t){var s,i,a,n,r=this.isFirstCreateAtEnd(),o=[],h=this._getCreatedContexts(),l=h.length,d=this.oModel.resolveDeep(this.sPath,this.oContext);if(!e){e=0}if(!t){t=this._getMaximumLength()}a=e+t;for(i=e;i<a;i+=1){if(!r&&i<l){s=h[i]}else if(r&&i>=this.iLength){if(i-this.iLength>=l){break}s=h[i-this.iLength]}else{n=this.aKeys[r?i:i-l];if(!n){break}s=this.oModel.getContext("/"+n,d+n.substr(n.indexOf("(")))}o.push(s)}return o};x.prototype.setContext=function(e){var s,i,a=e&&e.isRefreshForced(),n=e&&e.isPreliminary(),h=e&&e.isUpdated();if(this.bInitial||!this.isRelative()){return}if(n&&!this.bUsePreliminaryContext){return}if(h&&this.bUsePreliminaryContext&&this.oContext===e){this._fireChange({reason:r.Context});return}if(o.hasChanged(this.oContext,e)){s=this.isResolved()&&!this._hasTransientParentWithoutSubContexts();this.oContext=e;i=this.getResolvedPath();this.sDeepPath=this.oModel.resolveDeep(this.sPath,this.oContext);if(!this._checkPathType()){t.error("List Binding is not bound against a list for "+i,undefined,b)}this.checkDataState();if(!i||this._hasTransientParentWithoutSubContexts()){this.aAllKeys=null;this.aKeys=[];this.iLength=0;this.bLengthFinal=true;this.abortPendingRequest(true,true);if(s){this._fireChange({reason:r.Context})}return}this._initSortersFilters();if(this.checkExpandedList()&&!a){this.abortPendingRequest();this._fireChange({reason:r.Context})}else{this._removePersistedCreatedContexts();this._refresh()}}};x.prototype._cleanupCreatedPersisted=function(){var e=false,t=this.oModel._getObject(this.sPath,this.oContext),s=this;function i(t){s.oModel._discardEntityChanges(t,true);e=true}if(this.oCreatedPersistedToRemove.size&&!this.bSuspended){this.oCreatedPersistedToRemove.forEach(i);this.oCreatedPersistedToRemove.clear()}if(t&&t.sideEffects){this._getCreatedPersistedContexts().forEach(function(e){var a=s.oModel.getKey(e);if(!t.includes(a)){if(s.bSuspended){s.oCreatedPersistedToRemove.add(a)}else{i(a)}}})}return e};x.prototype.checkExpandedList=function(e){var t,s=this.oModel._getObject(this.sPath,this.oContext),i=this.bUseExpandedList,a=this;if(!this.isResolved()||s===undefined||!this._isExpandedListUsable()){this.bUseExpandedList=false;this.aExpandRefs=undefined;return false}else{this.bUseExpandedList=true;if(Array.isArray(s)){if(!e&&(this.oModel._isReloadNeeded("/"+s[0],this.mParameters)||this.oModel._isReloadNeeded("/"+s[s.length-1],this.mParameters))){this.bUseExpandedList=false;this.aExpandRefs=undefined;return false}this.aExpandRefs=s;if(s.sideEffects){t=this._getCreatedPersistedContexts().map(function(e){return a.oModel.getKey(e)});if(t.length){s=s.filter(function(e){return!t.includes(e)})}}this.aAllKeys=s;this.iLength=s.length;this.bLengthFinal=true;this.bDataAvailable=true;this._initSortersFilters();this.applyFilter();this.applySort();if(this.aExpandRefs.sideEffects&&!i){this.aExpandRefs=undefined;this.bUseExpandedList=false;return this.bUseExpandedList}}else{this.aExpandRefs=undefined;this.aAllKeys=null;this.aKeys=[];this.iLength=0;this.bLengthFinal=true;this.bDataAvailable=true}return true}};x.prototype.updateExpandedList=function(e){if(this.aExpandRefs){for(var t=0;t<e.length;t++){this.aExpandRefs[t]=e[t]}this.aExpandRefs.length=e.length}};x.prototype.useClientMode=function(){return this.sOperationMode===m.Client||this.sOperationMode===m.Auto&&!this.bThresholdRejected||this.sOperationMode!==m.Server&&this.bUseExpandedList};x.prototype._addFilterQueryOption=function(e,t){var s=this._getCreatedPersistedExcludeFilter();if(this.sFilterParams&&t){if(s){e.push("$filter=("+this.sFilterParams.slice(8)+")%20and%20"+s)}else{e.push(this.sFilterParams)}}else if(s){e.push("$filter="+s)}};x.prototype._getCreatedPersistedContexts=function(){return this._getCreatedContexts().filter(function(e){return!e.isTransient()})};x.prototype._getCreatedPersistedExcludeFilter=function(){var e,t,s=this._getCreatedPersistedContexts(),i=this;if(s.length>0){t=s.map(function(e){var t=e.getPath();return i._getFilterForPredicate(t.slice(t.indexOf("(")))});e="not("+y._createFilterParams(t.length===1?t[0]:new h({filters:t}),this.oModel.oMetadata,this.oEntityType)+")"}return e};x.prototype.loadData=function(e,t){var s,a,o=n(),h=false,l=this.oModel.iSizeLimit,d=this.sPath,u=this.bRemovePersistedCreatedAfterRefresh,f=[],p=this.useClientMode(),c=this;function C(){var s=[];if(t){s.push("$skip="+e+"&$top="+t)}else{e=0}if(c.sSortParams){s.push(c.sSortParams)}c._addFilterQueryOption(s,!p);if(c.sCustomParams){s.push(c.sCustomParams)}if(c.sCountMode==g.InlineRepeat||!c.bLengthFinal&&(c.sCountMode===g.Inline||c.sCountMode===g.Both)){s.push("$inlinecount=allpages");h=true}else{h=false}return s}function y(s){if(h&&s.__count!==undefined){c.iLength=parseInt(s.__count);c.bLengthFinal=true;if(c.sOperationMode==m.Auto){if(c.iLength<=c.mParameters.threshold){c.bThresholdRejected=false}else{c.bThresholdRejected=true;delete c.mRequestHandles[o];c.bPendingRequest=false;c.bNeedsUpdate=true;return}}}if(p){if(!e){c.aKeys=[]}i(s.results,function(t,s){c.aKeys[e+t]=c.oModel._getKey(s)});f.push(s.results);if(s.__next&&c.aKeys.length<l){e=c.aKeys.length;t=l-e;a.urlParameters=C();c.mRequestHandles[o]=c.oModel.read(c.sPath,a);return}c.updateExpandedList(c.aKeys);c.aAllKeys=c.aKeys.slice();c.iLength=c.aKeys.length;c.bLengthFinal=true;c.applyFilter();c.applySort()}else if(s.results.length>0){i(s.results,function(t,s){c.aKeys[e+t]=c.oModel._getKey(s)});if(c.iLength<e+s.results.length){c.iLength=e+s.results.length;c.bLengthFinal=false}if(!s.__next&&(s.results.length<t||t===undefined)){c.iLength=e+s.results.length;c.bLengthFinal=true}}else{if(c.bFaultTolerant&&s.__next){c.iLength=e;c.bLengthFinal=true}if(e===0){c.iLength=0;c.aKeys=[];c.bLengthFinal=true}if(e===c.iLength){c.bLengthFinal=true}}delete c.mRequestHandles[o];c.bPendingRequest=false;c.bNeedsUpdate=true;c.bIgnoreSuspend=true;if(u){c._removePersistedCreatedContexts()}c.oModel.callAfterUpdate(function(){if(f.length>1){c.fireDataReceived({data:{__count:String(c.iLength),results:Array.prototype.concat.apply([],f)}})}else{c.fireDataReceived({data:s})}})}function b(e){var t=e.statusCode==0;delete c.mRequestHandles[o];c.bPendingRequest=false;if(c.bFaultTolerant){c.iLength=c.aKeys.length;c.bLengthFinal=true;c.bDataAvailable=true}else if(!t){c.aKeys=[];c.aAllKeys=[];c.iLength=0;c.bLengthFinal=true;c.bDataAvailable=true;c._fireChange({reason:r.Change})}if(!c.bSkipDataEvents){c.fireDataReceived()}}if(this.isRelative()){d=this.getResolvedPath()}if(d){this.bPendingRequest=true;if(!this.bSkipDataEvents){this.fireDataRequested()}this.bSkipDataEvents=false;s=this.sRefreshGroupId?this.sRefreshGroupId:this.sGroupId;a={headers:this.bTransitionMessagesOnly?{"sap-messages":"transientOnly"}:undefined,context:this.oContext,groupId:s,urlParameters:C(),success:y,error:b,canonicalRequest:this.bCanonicalRequest,updateAggregatedMessages:this.bRefresh};this.mRequestHandles[o]=this.oModel.read(this.sPath,a)}};x.prototype.isLengthFinal=function(){return this.bLengthFinal};x.prototype.getLength=function(){var e=this.iLength+this._getCreatedContexts().length;if(this.bLengthFinal||this.iLength===0){return e}return e+(this.iLastMaximumPrefetchSize||this.iLastLength||10)};x.prototype._getLength=function(){var e,s,a=[],n=this;if(this.sCountMode!==g.Request&&this.sCountMode!==g.Both){return}this._addFilterQueryOption(a,this.sOperationMode!==m.Auto);if(this.mParameters&&this.mParameters.custom){var o={custom:{}};i(this.mParameters.custom,function(e,t){o.custom[e]=t});a.push(this.oModel.createCustomParams(o))}function h(e){n.iLength=parseInt(e);n.bLengthFinal=true;n.bLengthRequested=true;n.oCountHandle=null;if(n.sOperationMode==m.Auto){if(n.iLength<=n.mParameters.threshold){n.bThresholdRejected=false}else{n.bThresholdRejected=true}n._fireChange({reason:r.Change})}}function l(e){delete n.mRequestHandles[s];var i="Request for $count failed: "+e.message;if(e.response){i+=", "+e.response.statusCode+", "+e.response.statusText+", "+e.response.body}t.warning(i,undefined,b)}s=this.getResolvedPath();if(s){e=this.sRefreshGroupId?this.sRefreshGroupId:this.sGroupId;this.oCountHandle=this.oModel.read(this.sPath+"/$count",{context:this.oContext,withCredentials:this.oModel.bWithCredentials,groupId:e,urlParameters:a,success:h,error:l,canonicalRequest:this.bCanonicalRequest})}};x.prototype._getMaximumLength=function(){var e=this.oModel.iSizeLimit;if(this.bLengthFinal){e=Math.min(e,this.iLength+this._getCreatedContexts().length)}return e};x.prototype.refresh=function(e,t){if(typeof e==="string"){t=e;e=false}this._removePersistedCreatedContexts();this.sRefreshGroupId=t;this.bRemovePersistedCreatedAfterRefresh=true;this._refresh(e);this.sRefreshGroupId=undefined;this.bRemovePersistedCreatedAfterRefresh=false};x.prototype._refresh=function(e,t,s){var a,n,o=false;if(this._hasTransientParentWithoutSubContexts()){return}if(!e){if(s){n=this.getResolvedPath();if(n){a=this.oModel.oMetadata._getEntityTypeByPath(n);if(a&&a.entityType in s){o=true}}}if(t&&!o){i(this.aKeys,function(e,s){if(s in t){o=true;return false}return true})}if(!t&&!s){o=true}}if(e||o){if(this.bSuspended&&!this.bIgnoreSuspend&&!e){this.bPendingRefresh=true;return}this.bPendingRefresh=false;this.abortPendingRequest(true);this.resetData();this._fireRefresh({reason:r.Refresh})}};x.prototype._fireRefresh=function(e){if(this.getResolvedPath()){this.bRefresh=true;this.fireEvent("refresh",e)}};x.prototype._checkPathType=function(){var e=this.getResolvedPath();if(e){if(!this._mPathType||!this._mPathType[e]){this._mPathType={};var t=e.lastIndexOf("/");var s,i;if(t>1){i=this.oModel.oMetadata._getEntityTypeByPath(e.substring(0,t));if(i){s=this.oModel.oMetadata._getEntityAssociationEnd(i,e.substring(t+1));if(s&&s.multiplicity==="*"){this._mPathType[e]=true}}}else if(t===0){var a,n=e.substring(1);a=this.oModel.oMetadata._findEntitySetByName(n);if(a){this._mPathType[e]=true}else{var r=this.oModel.oMetadata._getFunctionImportMetadataByName(n);for(var o=0;o<r.length;o++){var h=r[o];if(h.entitySet){a=this.oModel.oMetadata._findEntitySetByName(h.entitySet);if(a){this._mPathType[e]=true}}}}}}return!!this._mPathType[e]}return true};x.prototype.initialize=function(){if(this.oModel.oMetadata&&this.oModel.oMetadata.isLoaded()&&this.bInitial&&!this._hasTransientParentWithoutSubContexts()){if(!this._checkPathType()){t.error("List Binding is not bound against a list for "+this.getResolvedPath(),undefined,b)}this.bInitial=false;this._initSortersFilters();if(!this.bSuspended){if(this.bDataAvailable){this._fireChange({reason:r.Change})}else{this.resetData();this._fireRefresh({reason:r.Refresh})}}this.checkDataState()}return this};x.prototype.checkUpdate=function(e,t){var a,n,o,h,l,d=false,u=this.sChangeReason?this.sChangeReason:r.Change,f=this._cleanupCreatedPersisted(),p=this;if(this.bSuspended&&!this.bIgnoreSuspend&&!e||this.bPendingRequest){return}if(this.bInitial){if(this.oContext&&this.oContext.isUpdated()){this.initialize()}return}this.bIgnoreSuspend=false;if(!e&&!this.bNeedsUpdate){l=this.aExpandRefs;h=this.aKeys.slice();o=this.checkExpandedList(true);if(!o&&this.useClientMode()){this.applyFilter();this.applySort()}if(!s(l,this.aExpandRefs)){d=true}else if(t){if(this.aKeys.length!==h.length){d=true}else{for(var c in t){if(this.aKeys.indexOf(c)>-1||h.indexOf(c)>-1){d=true;break}}}}else{d=true}if(d&&this.aLastContexts){d=false;a=this._getContexts(this.iLastStartIndex,this.iLastLength);if(this.aLastContexts.length!==a.length){d=true}else{i(this.aLastContextData,function(e,t){n=p.getContextData(a[e]);if(t!==n){d=true;return false}return true})}}}if(e||d||this.bNeedsUpdate||f){this.bNeedsUpdate=false;this._fireChange({reason:u})}this.sChangeReason=undefined};x.prototype.resetData=function(){this.aKeys=[];this.aAllKeys=null;this.iLength=0;this.bLengthFinal=this.oCombinedFilter===h.NONE||this._hasTransientParentContext()||!this.isResolved();this.sChangeReason=undefined;this.bDataAvailable=false;this.bLengthRequested=false;this.bThresholdRejected=false;if(this.sCountMode==g.None){this.bThresholdRejected=true}};x.prototype.abortPendingRequest=function(e,t){if(!a(this.mRequestHandles)){this.bSkipDataEvents=!t;i(this.mRequestHandles,function(e,t){t.abort()});if(e&&this.oCountHandle){this.oCountHandle.abort()}this.mRequestHandles={};this.bPendingRequest=false}};x.prototype.getDownloadUrl=function(e){var t=[],s;if(this.oCombinedFilter===h.NONE){return null}if(e){t.push("$format="+encodeURIComponent(e))}if(this.sSortParams){t.push(this.sSortParams)}else if(this.aSorters.length&&this.useClientMode()){t.push(y.createSortParams(this.aSorters))}if(this.sFilterParams){t.push(this.sFilterParams)}else if(this.oCombinedFilter&&this.useClientMode()){t.push(y.createFilterParams(this.oCombinedFilter,this.oModel.oMetadata,this.oEntityType))}if(this.sCustomParams){t.push(this.sCustomParams)}s=this.getResolvedPath();return s&&this.oModel._createRequestUrl(s,null,t)};x.prototype._moveCreatedPersistedToAllKeys=function(){var e=this,t=this._getCreatedPersistedContexts().map(function(t){return e.oModel.getKey(t)});if(t.length){this.aAllKeys=this.aAllKeys.concat(t);this._removePersistedCreatedContexts();return true}return false};x.prototype.sort=function(e,t){var s=false;this.bIgnoreSuspend=true;if(!e){e=[]}if(e instanceof p){e=[e]}this.aSorters=e;if(!this.useClientMode()){this.createSortParams(e)}if(!this.bInitial){this.addComparators(e,true);if(this.useClientMode()){if(this.aAllKeys){if(this._moveCreatedPersistedToAllKeys()||!e.length){this.applyFilter()}this.applySort();this._fireChange({reason:r.Sort})}else{this.sChangeReason=r.Sort}}else{this.iLength+=this._removePersistedCreatedContexts().length;this.aKeys=[];this.abortPendingRequest(false);this.sChangeReason=r.Sort;this._fireRefresh({reason:this.sChangeReason})}this._fireSort({sorter:e});s=true}if(t){return s}else{return this}};x.prototype.addComparators=function(s,i){var a,n,r=this.oEntityType,o;if(!r){t.warning("Cannot determine sort/filter comparators, as entity type of the collection is unknown!",undefined,b);return}s.forEach(function(t){if(t.aFilters){this.addComparators(t.aFilters)}else if(!t.fnCompare){a=this.oModel.oMetadata._getPropertyMetadata(r,t.sPath);n=a&&a.type;e(a,"PropertyType for property "+t.sPath+" of EntityType "+r.name+" not found!");o=y.getComparator(n);if(i){t.fnCompare=v(o)}else{t.fnCompare=o;R(n,t)}}}.bind(this))};function v(e){return function(t,s){if(t===s){return 0}if(t===null){return-1}if(s===null){return 1}return e(t,s)}}function R(e,t){switch(e){case"Edm.Decimal":case"Edm.Int64":if(typeof t.oValue1=="number"){t.oValue1=t.oValue1.toString()}if(typeof t.oValue2=="number"){t.oValue2=t.oValue2.toString()}break;case"Edm.Byte":case"Edm.Int16":case"Edm.Int32":case"Edm.SByte":if(typeof t.oValue1=="string"){t.oValue1=parseInt(t.oValue1)}if(typeof t.oValue2=="string"){t.oValue2=parseInt(t.oValue2)}break;case"Edm.Float":case"Edm.Single":case"Edm.Double":if(typeof t.oValue1=="string"){t.oValue1=parseFloat(t.oValue1)}if(typeof t.oValue2=="string"){t.oValue2=parseFloat(t.oValue2)}break;default:}}x.prototype.applySort=function(){var e=this,t;this.aKeys=c.apply(this.aKeys,this.aSorters,function(s,i){t=e.oModel.getContext("/"+s);return e.oModel.getProperty(i,t)})};x.prototype.createSortParams=function(e){this.sSortParams=y.createSortParams(e)};x.prototype.filter=function(e,t,s){var i=false;this.bIgnoreSuspend=true;if(!e){e=[]}if(e instanceof h){e=[e]}this.oModel.checkFilter(e);if(t===u.Application){this.aApplicationFilters=e}else{this.aFilters=e}if(!this.aFilters||!Array.isArray(this.aFilters)){this.aFilters=[]}if(!this.aApplicationFilters||!Array.isArray(this.aApplicationFilters)){this.aApplicationFilters=[]}this.convertFilters();this.oCombinedFilter=d.combineFilters(this.aFilters,this.aApplicationFilters);if(!this.useClientMode()&&this.oCombinedFilter!==h.NONE){this.createFilterParams(this.oCombinedFilter)}if(!this.bInitial){if(this.oCombinedFilter!==h.NONE){this.addComparators(this.aFilters);this.addComparators(this.aApplicationFilters)}if(this.useClientMode()){if(this.aAllKeys){this._moveCreatedPersistedToAllKeys();this.applyFilter();this.applySort();this._fireChange({reason:r.Filter})}else{this.sChangeReason=r.Filter}}else{this._removePersistedCreatedContexts();this.resetData();this.abortPendingRequest(true);this.sChangeReason=r.Filter;this._fireRefresh({reason:this.sChangeReason})}if(t===u.Application){this._fireFilter({filters:this.aApplicationFilters})}else{this._fireFilter({filters:this.aFilters})}i=true}if(s){return i}else{return this}};x.prototype.convertFilters=function(){this.aFilters=this.aFilters.map(function(e){return e instanceof C?e.convert():e});this.aApplicationFilters=this.aApplicationFilters.map(function(e){return e instanceof C?e.convert():e})};x.prototype.applyFilter=function(){var e=this,t;this.oCombinedFilter=d.combineFilters(this.aFilters,this.aApplicationFilters);this.aKeys=d.apply(this.aAllKeys,this.oCombinedFilter,function(s,i){t=e.oModel.getContext("/"+s);return e.oModel.getProperty(i,t)},this.mNormalizeCache);this.iLength=this.aKeys.length};x.prototype.createFilterParams=function(e){this.sFilterParams=y.createFilterParams(e,this.oModel.oMetadata,this.oEntityType)};x.prototype._initSortersFilters=function(){var e=this.getResolvedPath();if(!e){return}this.oEntityType=this._getEntityType();this.addComparators(this.aSorters,true);this.addComparators(this.aFilters);this.addComparators(this.aApplicationFilters);this.convertFilters();this.oCombinedFilter=d.combineFilters(this.aFilters,this.aApplicationFilters);if(!this.useClientMode()){this.createSortParams(this.aSorters);this.createFilterParams(this.oCombinedFilter)}};x.prototype._getEntityType=function(){var t=this.getResolvedPath();if(t){var s=this.oModel.oMetadata._getEntityTypeByPath(t);e(s,"EntityType for path "+t+" could not be found!");return s}return undefined};x.prototype.resume=function(){this.bIgnoreSuspend=false;this.bSuspended=false;if(this.bPendingRefresh){this._refresh()}else{this.checkUpdate()}};x.prototype.suspend=function(){if(this.bInitial){this.bPendingRefresh=true}f.prototype.suspend.apply(this,arguments)};x.prototype._checkDataStateMessages=function(e,t){if(t){e.setModelMessages(this.oModel.getMessagesByPath(this.sDeepPath,true))}};x.prototype._getFilterForPredicate=function(e){var t=[],s=e.slice(1,-1).split(","),i=this;s.forEach(function(e){var s=e.split("="),a=s[0],n=s[1];if(s.length===1){n=a;a=i.oModel.oMetadata.getKeyPropertyNamesByPath(i.sDeepPath)[0]}t.push(new h(a,l.EQ,y.parseValue(decodeURIComponent(n))))});if(t.length===1){return t[0]}return new h({and:true,filters:t})};x.prototype.create=function(e,t,s){var i,a,n,o={context:this.oContext,properties:e},h=this.isFirstCreateAtEnd();t=!!t;if(h===undefined){h=t}if(h&&!this.bLengthFinal){throw new Error("Must know the final length to create at the end")}Object.keys(s||{}).forEach(function(e){if(!P.includes(e)){throw new Error("Parameter '"+e+"' is not supported")}});if(this.bUseExpandedList){throw new Error("The collection has been read via $expand while reading the parent"+" entity")}if(!this.oModel.oMetadata.isLoaded()){throw new Error("Metadata is not loaded")}n=this.getResolvedPath();a=this.oModel._getCreatedContextsCache();Object.assign(o,s);if(!this._hasTransientParentContext()){o.refreshAfterChange=false;if(!("expand"in o)&&this.mParameters){o.expand=this.mParameters.expand}}i=this.oModel.createEntry(this.sPath,o);a.addContext(i,n,this.sCreatedEntitiesKey,t);if(o.inactive){i.fetchActivationStarted().then(this.fireCreateActivate.bind(this,i)).catch(this.oModel.getReporter(b))}this._fireChange({reason:r.Add});return i};x.prototype.requestFilterForMessages=function(e){var t=this.sDeepPath,s=null,i=[],a=new Set,n=this.getResolvedPath(),r=false,o=this;function l(e){return d.every(t=>!e.startsWith(t))}if(!n){return Promise.resolve(null)}const d=this._getCreatedContexts().map(e=>e.getDeepPath());this.oModel.getMessagesByPath(t,true).forEach(function(s){var i;if(!e||e(s)){s.aFullTargets.forEach(function(e){if(e.startsWith(t)){if(l(e)){i=e.slice(t.length).split("/")[0];if(i){a.add(i)}}else{r=true}}})}});a.forEach(function(e){i.push(o._getFilterForPredicate(e))});if(i.length===1){s=i[0]}else if(i.length>1){s=new h({filters:i})}else if(r){s=h.NONE}return Promise.resolve(s)};x.prototype.isFirstCreateAtEnd=function(){return this.oModel._getCreatedContextsCache().isAtEnd(this.getResolvedPath(),this.sCreatedEntitiesKey)};x.prototype._getCreatedContexts=function(){return this.oModel._getCreatedContextsCache().getContexts(this.getResolvedPath(),this.sCreatedEntitiesKey)};x.prototype._getSkipAndTop=function(e,t,s){var i,a,n=this._getCreatedContexts(),r=this.isFirstCreateAtEnd()===false,o=r&&this.aKeys.length?n.concat(this.aKeys):this.aKeys,h=this.bLengthFinal?this.iLength:undefined;if(r&&h){h+=n.length}a=y._getReadIntervals(o,e,t,s,h);i=y._mergeIntervals(a);if(i&&r&&this.aKeys.length){i.start-=n.length;i.end-=n.length}return i&&{skip:i.start,top:i.end-i.start}};x.prototype._removePersistedCreatedContexts=function(){return this.oModel._getCreatedContextsCache().removePersistedContexts(this.getResolvedPath(),this.sCreatedEntitiesKey)};x.prototype.getCount=function(){if(!this.isLengthFinal()){return undefined}return this.getLength()-this._getCreatedContexts().filter(function(e){return e.isInactive()}).length};x.prototype._hasTransientParentContext=function(){return this.isRelative()&&!!(this.oContext&&this.oContext.isTransient&&this.oContext.isTransient())};x.prototype._hasTransientParentWithoutSubContexts=function(){return this._hasTransientParentContext()&&!this._getCreatedContexts().length};x.prototype._isExpandedListUsable=function(){if(this.mCustomParams||this.sOperationMode===m.Server&&(this.aApplicationFilters.length>0||this.aFilters.length>0||this.aSorters.length>0)){return false}return true};x.prototype._refreshForSideEffects=function(e,t){var s=!this._hasTransientParentContext()&&e.has(this.oEntityType);if(s&&!this._isExpandedListUsable()){this.sRefreshGroupId=t;this._refresh();this.sRefreshGroupId=undefined}return s};x.prototype._reassignCreateActivate=function(){var e=this;this._getCreatedContexts().forEach(function(t){if(t.isInactive()){t.fetchActivationStarted().then(e.fireCreateActivate.bind(e,t)).catch(e.oModel.getReporter(b))}})};x.prototype.fireCreateActivate=function(e){if(!this.bIsBeingDestroyed){if(this.fireEvent("createActivate",{context:e},true)){e.finishActivation();this._fireChange({reason:r.Change})}else{e.cancelActivation();e.fetchActivationStarted().then(this.fireCreateActivate.bind(this,e)).catch(this.oModel.getReporter(b))}}};return x});
//# sourceMappingURL=ODataListBinding.js.map