/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./ODataContextBinding","./ODataListBinding","./ODataMetaModel","./ODataPropertyBinding","./SubmitMode","./lib/_GroupLock","./lib/_Helper","./lib/_MetadataRequestor","./lib/_Parser","./lib/_Requestor","sap/base/assert","sap/base/Log","sap/ui/base/SyncPromise","sap/ui/core/Configuration","sap/ui/core/library","sap/ui/core/Messaging","sap/ui/core/Rendering","sap/ui/core/Supportability","sap/ui/core/cache/CacheManager","sap/ui/core/message/Message","sap/ui/model/BindingMode","sap/ui/model/Context","sap/ui/model/Model","sap/ui/model/odata/OperationMode","sap/ui/thirdparty/URI"],function(e,t,r,i,o,n,s,a,u,p,d,h,c,f,l,g,y,m,v,w,E,b,M,P,R){"use strict";var B="sap.ui.model.odata.v4.ODataModel",C=["$count","$expand","$filter","$levels","$orderby","$search","$select"],q=["$$groupId","$$patchWithoutSideEffects","$$updateGroupId"],I=l.MessageType,$=[undefined,I.Success,I.Information,I.Warning,I.Error],D={dataReceived:true,dataRequested:true,messageChange:true,propertyChange:true,sessionTimeout:true},O={annotationURI:true,autoExpandSelect:true,earlyRequests:true,groupId:true,groupProperties:true,httpHeaders:true,ignoreAnnotationsFromMetadata:true,metadataUrlParams:true,odataVersion:true,operationMode:true,serviceUrl:true,sharedRequests:true,supportReferences:true,synchronizationMode:true,updateGroupId:true,withCredentials:true},k=["$apply","$count","$expand","$filter","$orderby","$search","$select"],G=/^[ -~]+$/,T=M.extend("sap.ui.model.odata.v4.ODataModel",{constructor:A});function A(e){var t,i,n=f.getLanguageTag(),u,d,h,c,l,y,v=this;M.call(this);e=e||{};if("synchronizationMode"in e&&e.synchronizationMode!=="None"){throw new Error("Synchronization mode must be 'None'")}u=e.odataVersion||"4.0";this.sODataVersion=u;if(u!=="4.0"&&u!=="2.0"){throw new Error("Unsupported value for parameter odataVersion: "+u)}for(d in e){if(!(d in O)){throw new Error("Unsupported parameter: "+d)}}c=e.serviceUrl;if(!c){throw new Error("Missing service root URL")}l=new R(c);if(l.path()[l.path().length-1]!=="/"){throw new Error("Service root URL must end with '/'")}if(e.operationMode&&e.operationMode!==P.Server){throw new Error("Unsupported operation mode: "+e.operationMode)}this.sOperationMode=e.operationMode;y=this.buildQueryOptions(l.query(true),false,true);this.mUriParameters=y;if(m.isStatisticsEnabled()){y=Object.assign({"sap-statistics":true},y)}this.sServiceUrl=l.query("").toString();this.sGroupId=e.groupId;if(this.sGroupId===undefined){this.sGroupId="$auto"}if(this.sGroupId!=="$auto"&&this.sGroupId!=="$direct"){throw new Error("Group ID must be '$auto' or '$direct'")}s.checkGroupId(e.updateGroupId,false,"Invalid update group ID: ");this.sUpdateGroupId=e.updateGroupId||this.getGroupId();this.mGroupProperties={};for(t in e.groupProperties){s.checkGroupId(t,true);i=e.groupProperties[t];if(typeof i!=="object"||Object.keys(i).length!==1||!(i.submit in o)){throw new Error("Group '"+t+"' has invalid properties: '"+i+"'")}}this.mGroupProperties=s.clone(e.groupProperties)||{};this.mGroupProperties.$auto={submit:o.Auto};this.mGroupProperties.$direct={submit:o.Direct};if(e.autoExpandSelect!==undefined&&typeof e.autoExpandSelect!=="boolean"){throw new Error("Value for autoExpandSelect must be true or false")}this.bAutoExpandSelect=e.autoExpandSelect===true;if("sharedRequests"in e&&e.sharedRequests!==true){throw new Error("Value for sharedRequests must be true")}this.bSharedRequests=e.sharedRequests===true;this.bIgnoreETag=false;if("ignoreAnnotationsFromMetadata"in e&&e.ignoreAnnotationsFromMetadata!==true){throw new Error("Value for ignoreAnnotationsFromMetadata must be true")}this.mHeaders={"Accept-Language":n};this.mMetadataHeaders={"Accept-Language":n};h=Object.assign({},y,e.metadataUrlParams);this.oMetaModel=new r(a.create(this.mMetadataHeaders,u,e.ignoreAnnotationsFromMetadata,h,e.withCredentials),this.sServiceUrl+"$metadata",e.annotationURI,this,e.supportReferences,h["sap-language"]);this.oInterface={fetchEntityContainer:this.oMetaModel.fetchEntityContainer.bind(this.oMetaModel),fetchMetadata:this.oMetaModel.fetchObject.bind(this.oMetaModel),fireDataReceived:this.fireDataReceived.bind(this),fireDataRequested:this.fireDataRequested.bind(this),fireSessionTimeout:function(){v.fireEvent("sessionTimeout")},getGroupProperty:this.getGroupProperty.bind(this),getMessagesByPath:this.getMessagesByPath.bind(this),getOptimisticBatchEnabler:this.getOptimisticBatchEnabler.bind(this),getReporter:this.getReporter.bind(this),isIgnoreETag:function(){return v.bIgnoreETag},onCreateGroup:function(e){if(v.isAutoGroup(e)){v.addPrerenderingTask(v._submitBatch.bind(v,e,true))}},reportStateMessages:this.reportStateMessages.bind(this),reportTransitionMessages:this.reportTransitionMessages.bind(this),updateMessages:function(e,t){g.updateMessages(e,t)}};this.oRequestor=p.create(this.sServiceUrl,this.oInterface,this.mHeaders,y,u,e.withCredentials);this.changeHttpHeaders(e.httpHeaders);this.bEarlyRequests=e.earlyRequests;if(this.bEarlyRequests){this.oMetaModel.fetchEntityContainer(true);this.initializeSecurityToken();this.oRequestor.sendOptimisticBatch()}this.aAllBindings=[];this.mKeepAliveBindingsByPath={};this.mSupportedBindingModes={OneTime:true,OneWay:true};if(e.sharedRequests){this.sDefaultBindingMode=E.OneWay}else{this.sDefaultBindingMode=E.TwoWay;this.mSupportedBindingModes.TwoWay=true}this.aPrerenderingTasks=null;this.fnOptimisticBatchEnabler=null;this.mPath2DataReceivedError={};this.mPath2DataRequestedCount={}}T.prototype._submitBatch=function(e,t){var r=this;return this.oRequestor.submitBatch(e).catch(function(e){r.reportError("$batch failed",B,e);if(!t){throw e}})};T.prototype.addPrerenderingTask=function(e,t){var r,i,o=this;function n(e){clearTimeout(i);while(e.length){e.shift()()}if(o.aPrerenderingTasks===e){o.aPrerenderingTasks=null}}if(!this.aPrerenderingTasks){this.aPrerenderingTasks=[];r=n.bind(null,this.aPrerenderingTasks);y.addPrerenderingTask(r);i=setTimeout(function(){i=setTimeout(r,0)},0)}if(t){this.aPrerenderingTasks.unshift(e)}else{this.aPrerenderingTasks.push(e)}};T.prototype.attachDataReceived=function(e,t){return this.attachEvent("dataReceived",e,t)};T.prototype.attachDataRequested=function(e,t){return this.attachEvent("dataRequested",e,t)};T.prototype.attachEvent=function(e,t,r,i){if(!(e in D)){throw new Error("Unsupported event '"+e+"': v4.ODataModel#attachEvent")}return M.prototype.attachEvent.apply(this,arguments)};T.prototype.attachSessionTimeout=function(e,t){return this.attachEvent("sessionTimeout",e,t)};T.prototype.bindContext=function(t,r,i){return new e(this,t,r,i)};T.prototype.bindingCreated=function(e){this.aAllBindings.push(e)};T.prototype.bindingDestroyed=function(e){var t=this.aAllBindings.indexOf(e);if(t<0){throw new Error("Unknown "+e)}this.aAllBindings.splice(t,1)};T.prototype.bindList=function(e,r,i,o,n){return new t(this,e,r,i,o,n)};T.prototype.bindProperty=function(e,t,r){return new i(this,e,t,r)};T.prototype.bindTree=function(e,t,r,i,o){throw new Error("Unsupported operation: v4.ODataModel#bindTree")};T.prototype.buildQueryOptions=function(e,t,r){var i,o=Object.assign({},e);function n(e,r,i){var o,a,p,d=e[r];if(!t||!i.includes(r)){throw new Error("System query option "+r+" is not supported")}if((r==="$expand"||r==="$select")&&typeof d==="string"){d=u.parseSystemQueryOption(r+"="+d)[r];e[r]=d}if(r==="$expand"){d=e[r]=s.clone(d);for(p in d){a=d[p];if(a===null||typeof a!=="object"){a=d[p]={}}for(o in a){n(a,o,C)}}}else if(r==="$count"){if(typeof d==="boolean"){if(!d){delete e.$count}}else{switch(typeof d==="string"&&d.toLowerCase()){case"false":delete e.$count;break;case"true":e.$count=true;break;default:throw new Error("Invalid value for $count: "+d)}}}}if(e){for(i in e){if(i.startsWith("$$")){delete o[i]}else if(i[0]==="@"){throw new Error("Parameter "+i+" is not supported")}else if(i[0]==="$"){n(o,i,k)}else if(!r&&i.startsWith("sap-")&&!i.startsWith("sap-valid-")){throw new Error("Custom query option "+i+" is not supported")}}}return o};T.prototype.changeHttpHeaders=function(e){var t,r,i={},o,n;this.oRequestor.checkHeaderNames(e);for(n in e){r=n.toLowerCase();o=e[n];if(i[r]){throw new Error("Duplicate header "+n)}else if(!(typeof o==="string"&&G.test(o)||o===undefined)){throw new Error("Unsupported value for header '"+n+"': "+o)}else{if(r==="x-csrf-token"){n="X-CSRF-Token"}i[r]={key:n,value:o}}}this.oRequestor.checkForOpenRequests();for(n in this.mHeaders){r=n.toLowerCase();t=i[r];if(t){delete this.mHeaders[n];delete this.mMetadataHeaders[n];if(t.value!==undefined){this.mHeaders[t.key]=t.value;this.mMetadataHeaders[t.key]=t.value}delete i[r]}}for(n in i){t=i[n];if(t.value!==undefined){this.mHeaders[t.key]=t.value;if(n!=="x-csrf-token"){this.mMetadataHeaders[t.key]=t.value}}}};T.prototype.checkBatchGroupId=function(e){s.checkGroupId(e);if(this.isDirectGroup(e)){throw new Error("Group ID does not use batch requests: "+e)}};T.prototype.clearSessionContext=function(){this.oRequestor.clearSessionContext()};T.prototype.createBindingContext=function(e,t){var r,i,o,n,s;function a(e){var t=e.indexOf("."),r=e.indexOf("/");return t>0&&(r<0||t<r)}if(arguments.length>2){throw new Error("Only the parameters sPath and oContext are supported")}if(t&&t.getBinding){throw new Error("Unsupported type: oContext must be of type sap.ui.model.Context, "+"but was sap.ui.model.odata.v4.Context")}n=this.resolve(e,t);if(n===undefined){throw new Error("Cannot create binding context from relative path '"+e+"' without context")}s=n.indexOf("#");if(s>=0){r=n.slice(0,s);o=n.slice(s+1);if(o[0]==="#"){o=o.slice(1)}else if(r.length>1&&o[0]!=="@"&&a(o)){return new b(this,n)}if(o[0]==="/"){o="."+o}i=this.oMetaModel.getMetaContext(r);return this.oMetaModel.createBindingContext(o,i)}return new b(this,n)};T.prototype.createUI5Message=function(e,t,r,i=e){var o=typeof e.target==="string",n=e.longtextUrl,a,u=this;function p(e){return u.normalizeMessageTarget(e[0]==="/"?e:s.buildPath("/"+t,r,e))}if(o){t=t&&t.split("?")[0];a=[p(e.target)];if(e.additionalTargets){e.additionalTargets.forEach(function(e){a.push(p(e))})}}if(n&&t){n=s.makeAbsolute(n,this.sServiceUrl+t)}return new w({code:e.code,descriptionUrl:n||undefined,message:e.message,persistent:!o||e.transition,processor:this,target:o?a:"",technical:e.technical,technicalDetails:s.createTechnicalDetails(i),type:$[e.numericSeverity]||I.None})};T.prototype.delete=function(e,t,r){var i,o,n=this;if(typeof e==="string"){if(e[0]!=="/"){throw new Error("Invalid path: "+e)}i=true;o=Promise.resolve([e,"*"])}else{o=Promise.all([e.fetchCanonicalPath(),e.fetchValue("@odata.etag",null,true)])}s.checkGroupId(t);t=t||this.getUpdateGroupId();if(this.isApiGroup(t)){throw new Error("Illegal update group ID: "+t)}return o.then(function(o){return n.oRequestor.request("DELETE",o[0].slice(1)+s.buildQuery(n.mUriParameters),n.lockGroup(t,n,true,true),{"If-Match":o[1]}).catch(function(e){if(r||!(e.status===404||i&&e.status===412)){n.reportError("Failed to delete "+o[0],B,e);throw e}}).then(function(){if(i){n.aAllBindings.forEach(function(t){t.onDelete(e)})}})})};T.prototype.destroy=function(){this.oMetaModel.destroy();this.oRequestor.destroy();this.mHeaders=undefined;this.mMetadataHeaders=undefined;return M.prototype.destroy.apply(this,arguments)};T.prototype.destroyBindingContext=function(){throw new Error("Unsupported operation: v4.ODataModel#destroyBindingContext")};T.prototype.detachDataReceived=function(e,t){return this.detachEvent("dataReceived",e,t)};T.prototype.detachDataRequested=function(e,t){return this.detachEvent("dataRequested",e,t)};T.prototype.detachSessionTimeout=function(e,t){return this.detachEvent("sessionTimeout",e,t)};T.prototype.fetchKeyPredicate=function(e,t){var r={};return this.oRequestor.fetchType(r,e).then(function(){return s.getKeyPredicate(t,e,r)})};T.prototype.filterMatchingMessages=function(e,t){return s.hasPathPrefix(e,t)?this.mMessages[e]:[]};T.prototype.fireDataReceived=function(e,t){if(!(t in this.mPath2DataRequestedCount)){throw new Error("Received more data than requested")}this.mPath2DataRequestedCount[t]-=1;this.mPath2DataReceivedError[t]=this.mPath2DataReceivedError[t]||e;if(this.mPath2DataRequestedCount[t]===0){this.fireEvent("dataReceived",this.mPath2DataReceivedError[t]?{error:this.mPath2DataReceivedError[t],path:t}:{data:{},path:t});delete this.mPath2DataReceivedError[t];delete this.mPath2DataRequestedCount[t]}};T.prototype.fireDataRequested=function(e){if(e in this.mPath2DataRequestedCount){this.mPath2DataRequestedCount[e]+=1}else{this.mPath2DataRequestedCount[e]=1;this.fireEvent("dataRequested",{path:e})}};T.prototype.getAllBindings=function(){return this.aAllBindings.slice()};T.prototype.getContext=function(){throw new Error("Unsupported operation: v4.ODataModel#getContext")};T.prototype.getDependentBindings=function(e){return this.aAllBindings.filter(function(t){var r=t.getContext();return t.isRelative()&&(r===e||r&&r.getBinding&&r.getBinding()===e)})};T.prototype.getGroupId=function(){return this.sGroupId};T.prototype.getGroupProperty=function(e,t){switch(t){case"submit":if(e.startsWith("$auto.")){return o.Auto}return this.mGroupProperties[e]?this.mGroupProperties[e].submit:o.API;default:throw new Error("Unsupported group property: '"+t+"'")}};T.prototype.getHttpHeaders=function(e){var t=Object.assign({},this.mHeaders);if(!e){delete t["SAP-ContextId"]}if(t["X-CSRF-Token"]===null){delete t["X-CSRF-Token"]}return t};T.prototype.getKeyPredicate=s.createGetMethod("fetchKeyPredicate",true);T.prototype.getMessages=function(e){return this.getMessagesByPath(e.getPath(),true).sort(w.compare)};T.prototype.getMetaModel=function(){return this.oMetaModel};T.prototype.getObject=function(){throw new Error("Unsupported operation: v4.ODataModel#getObject")};T.prototype.getODataVersion=function(){return this.sODataVersion};T.prototype.getOriginalProperty=function(){throw new Error("Unsupported operation: v4.ODataModel#getOriginalProperty")};T.prototype.getProperty=function(){throw new Error("Unsupported operation: v4.ODataModel#getProperty")};T.prototype.getKeepAliveContext=function(e,t,r){var i,o,n;if(!this.bAutoExpandSelect){throw new Error("Missing parameter autoExpandSelect")}if(e[0]!=="/"){throw new Error("Not a list context path to an entity: "+e)}r=r||{};Object.keys(r).forEach(function(e){if(e.startsWith("sap-")&&!e.startsWith("sap-valid-")||e[0]==="$"&&!q.includes(e)){throw new Error("Invalid parameter: "+e)}});n=e.slice(0,s.getPredicateIndex(e));i=this.mKeepAliveBindingsByPath[n];if(!i){o=this.aAllBindings.filter(function(e){if(e.mParameters&&e.mParameters.$$getKeepAliveContext){e.removeCachesAndMessages(n.slice(1),true)}return e.isKeepAliveBindingFor&&e.isKeepAliveBindingFor(n)});if(o.length>1){throw new Error("Multiple bindings with $$getKeepAliveContext for: "+e)}i=o[0];if(!i){i=this.bindList(n,undefined,undefined,undefined,r);this.mKeepAliveBindingsByPath[n]=i}}return i.getKeepAliveContext(e,t,r.$$groupId)};T.prototype.getUpdateGroupId=function(){return this.sUpdateGroupId};T.prototype.getReporter=function(){var e=this;return function(t){if(!t.$reported){e.reportError(t.message,B,t)}}};T.prototype.getServiceUrl=function(){return this.sServiceUrl};T.prototype.hasPendingChanges=function(e){if(e!==undefined){this.checkBatchGroupId(e);if(this.isAutoGroup(e)&&this.oRequestor.hasPendingChanges("$parked."+e)){return true}}return this.oRequestor.hasPendingChanges(e)};T.prototype.initializeSecurityToken=function(){this.oRequestor.refreshSecurityToken().catch(function(){})};T.prototype.isApiGroup=function(e){return this.getGroupProperty(e,"submit")===o.API};T.prototype.isAutoGroup=function(e){return this.getGroupProperty(e,"submit")===o.Auto};T.prototype.isDirectGroup=function(e){return this.getGroupProperty(e,"submit")===o.Direct};T.prototype.isList=function(){throw new Error("Unsupported operation: v4.ODataModel#isList")};T.prototype.lock=function(e){var t;if(!this.isAutoGroup(e)){throw new Error("Group ID does not use automatic batch requests: "+e)}t=this.lockGroup(e,this,true);return{isLocked:function(){return t.isLocked()},unlock:function(){t.unlock()}}};T.prototype.lockGroup=function(e,t,r,i,o){return this.oRequestor.lockGroup(e,t,r,i,o)};T.prototype.refresh=function(e){if(typeof e==="boolean"){throw new Error("Unsupported parameter bForceUpdate")}s.checkGroupId(e);this.getBindings().forEach(function(t){if(t.isRoot()){t.refresh(t.isSuspended()?undefined:e)}})};T.prototype.releaseKeepAliveBinding=function(e){var t=this.mKeepAliveBindingsByPath[e];if(t){delete this.mKeepAliveBindingsByPath[e];return t}};T.prototype.reportError=function(e,t,r){var i;if(r.canceled==="noDebugLog"){return}i=r.stack.includes(r.message)?r.stack:r.message+"\n"+r.stack;if(r.canceled){h.debug(e,i,t);return}h.error(e,i,t);if(r.$reported){return}r.$reported=true;this.reportTransitionMessages(s.extractMessages(r),r.resourcePath)};T.prototype.reportStateMessages=function(e,t,r){var i="/"+e,o=[],n=[],a=this;Object.keys(t).forEach(function(r){t[r].forEach(function(t){o.push(a.createUI5Message(t,e,r))})});(r||[""]).forEach(function(e){var t=s.buildPath(i,e);Object.keys(a.mMessages).forEach(function(e){if(e===t||e.startsWith(t+"/")||e.startsWith(t+"(")){n=n.concat(a.mMessages[e].filter(function(e){return!e.persistent}))}})});if(o.length||n.length){g.updateMessages(n,o)}};T.prototype.reportTransitionMessages=function(e,t){var r,i;if(!e.length){return}if(t){const e=this.getMetaModel();r="/"+t.split("?")[0];const o=s.getMetaPath(r);const n=e.getObject(o);if(Array.isArray(n)){i=e.getObject(o+"/@$ui5.overload/0");r=r.slice(0,r.lastIndexOf("/"))}}g.updateMessages(undefined,e.map(e=>{const o=e;if(i){e=s.clone(e);s.adjustTargets(e,i,undefined,r)}e.transition=true;return this.createUI5Message(e,t,undefined,o)}))};T.prototype.normalizeMessageTarget=function(e){var t,r,i="",o=this;if(e.includes("$uid=")){return e}t=e.split("/").map(function(e){var t,n=e.indexOf("("),a,p,d;function h(e){if(e in p){return encodeURIComponent(decodeURIComponent(p[e]))}r=true}if(n<0){i=s.buildPath(i,e);return e}t=e.slice(0,n);i=s.buildPath(i,t);p=u.parseKeyPredicate(e.slice(n));if(""in p){return t+"("+h("")+")"}d=o.oMetaModel.getObject("/"+i+"/");if(!(d&&d.$Key)){r=true;return e}a=d.$Key.map(function(e){var t=h(e);return d.$Key.length>1?e+"="+t:t});return t+"("+a.join(",")+")"}).join("/");return r?e:t};T.prototype.requestCanonicalPath=function(e){d(e.getModel()===this,"oEntityContext must belong to this model");return e.requestCanonicalPath()};T.prototype.requestKeyPredicate=s.createRequestMethod("fetchKeyPredicate");T.prototype.requestSideEffects=function(e,t){if(!t.length){return undefined}return c.all(this.aAllBindings.filter(function(e){return e.isRoot()}).map(function(r){return r.requestAbsoluteSideEffects(e,t)}))};T.prototype.resetChanges=function(e){e=e||this.sUpdateGroupId;this.checkBatchGroupId(e);if(this.isAutoGroup(e)){this.oRequestor.cancelChanges("$parked."+e);this.oRequestor.cancelChanges("$inactive."+e,true)}this.oRequestor.cancelChanges(e);this.aAllBindings.forEach(function(t){if(e===t.getUpdateGroupId()){t.resetInvalidDataState()}})};T.prototype.resolve=function(e,t){var r;if(e&&e[0]==="/"){r=e}else if(t){r=t.getPath();if(e){if(!r.endsWith("/")){r+="/"}r+=e}}if(r&&r!=="/"&&r[r.length-1]==="/"&&!r.includes("#")){r=r.slice(0,r.length-1)}return r};T.prototype.setIgnoreETag=function(e){this.bIgnoreETag=e};T.prototype.setLegacySyntax=function(){throw new Error("Unsupported operation: v4.ODataModel#setLegacySyntax")};T.prototype.getOptimisticBatchEnabler=function(){return this.fnOptimisticBatchEnabler};T.prototype.setOptimisticBatchEnabler=function(e){if(!this.bEarlyRequests){throw new Error("The earlyRequests model parameter is not set")}if(this.oRequestor.isBatchSent()){throw new Error("The setter is called after a non-optimistic batch is sent")}if(typeof e!=="function"){throw new Error("The given fnOptimisticBatchEnabler parameter is not a function")}if(this.fnOptimisticBatchEnabler){throw new Error("The setter is called more than once")}this.fnOptimisticBatchEnabler=e};T.prototype.submitBatch=function(e){var t=this;this.checkBatchGroupId(e);if(this.isAutoGroup(e)){this.oRequestor.relocateAll("$parked."+e,e)}this.oRequestor.addChangeSet(e);return new Promise(function(r){t.addPrerenderingTask(function(){r(t._submitBatch(e))})})};T.prototype.toString=function(){return B+": "+this.sServiceUrl};T.prototype.waitForKeepAliveBinding=function(e){if(e.mParameters?.$$getKeepAliveContext){const t=this.mKeepAliveBindingsByPath[e.getResolvedPath()];if(t){return t.oCachePromise}}return c.resolve()};T.prototype.withUnresolvedBindings=function(e,t){return this.aAllBindings.filter(function(e){return!e.isResolved()}).some(function(r){return r[e](t)})};T.cleanUpOptimisticBatch=function(e){return v.delWithFilters({olderThan:e,prefix:"sap.ui.model.odata.v4.optimisticBatch:"})};return T});
//# sourceMappingURL=ODataModel.js.map