/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./_GroupLock","./_Helper","./_Requestor","sap/base/Log","sap/ui/base/SyncPromise","sap/ui/model/odata/ODataUtils"],function(e,t,i,n,s,r){"use strict";var o="sap.ui.model.odata.v4.lib._Cache",a=/\(\$uid=[-\w]+\)$/,u=/^\$inactive\./,h="@com.sap.vocabularies.Common.v1.Messages",c=/^-?\d+$/,l=/^([^(]*)(\(.*\))$/;function d(e,t){return t===""||e===t||e.startsWith(t+"/")}function f(e,t,i,n,s,r){this.iActiveUsages=1;this.mChangeListeners={};this.mChangeRequests={};this.sOriginalResourcePath=s||t;this.iInactiveSince=Infinity;this.mEditUrl2PatchPromise={};this.oPendingRequestsPromise=null;this.mPostRequests={};this.sReportedMessagesPath=undefined;this.oRequestor=e;this.bSentRequest=false;this.bSortExpandSelect=n;this.setResourcePath(t);this.setQueryOptions(i);this.bSharedRequest=r}f.prototype._delete=function(i,n,r,o,a){var u=r.split("/"),h=u.pop(),l=u.join("/"),d=this;this.checkSharedRequest();return this.fetchValue(e.$cached,l).then(function(e){var r,u=h?e[h]||e.$byPredicate[h]:e,f,p,g,P,m=c.test(h)?Number(h):undefined,y=t.getPrivateAnnotation(u,"predicate"),v=t.buildPath(l,Array.isArray(e)?y:h),$=d.oRequestor.getModelInterface(),R,E=t.getPrivateAnnotation(u,"transient"),q=t.getPrivateAnnotation(u,"transientPredicate");function b(){t.removeByPath(d.mChangeRequests,v,R);if(g.length){$.updateMessages(undefined,g)}delete u["@$ui5.context.isDeleted"];if(Array.isArray(e)){m=r.index;const t=e.$deleted.indexOf(r);if(m!==undefined){d.restoreElement(m,u,t,undefined,e,l)}e.$deleted.splice(t,1)}if(d.iActiveUsages){a(m,1)}else if(m===undefined&&d.reset){d.reset([])}}if(E){if(typeof E!=="string"){throw new Error("No 'delete' allowed while waiting for server response")}if(e.$postBodyCollection){e.$postBodyCollection.splice(m,1);d.removeElement(m,q,e,l);a(m,-1);f=new Error("Deleted from deep create");f.canceled=true;t.getPrivateAnnotation(u,"reject")(f);t.cancelNestedCreates(u,"Deleted from deep create")}else{d.oRequestor.removePost(E,u)}return undefined}g=$.getMessagesByPath(t.buildPath("/",d.sResourcePath,v),true);$.updateMessages(g);u["@$ui5.context.isDeleted"]=true;if(Array.isArray(e)){r=d.addDeleted(e,m,y,i,!!q);d.removeElement(m,y,e,l)}a(m,-1);if(i){p=i.getGroupId();d.oRequestor.relocateAll("$parked."+p,p,u)}P={"If-Match":o||u};n+=d.oRequestor.buildQueryString(d.sMetaPath,d.mQueryOptions,true);R=i?d.oRequestor.request("DELETE",n,i,P,undefined,undefined,b,undefined,t.buildPath(d.sOriginalResourcePath,v)):s.resolve();t.addByPath(d.mChangeRequests,v,R);return R.catch(function(e){if(e.status!==404){throw e}}).then(function(){t.removeByPath(d.mChangeRequests,v,R);if(Array.isArray(e)){e.$deleted.splice(e.$deleted.indexOf(r),1);delete e.$byPredicate[y];delete e.$byPredicate[q]}else if(h){t.updateExisting(d.mChangeListeners,l,e,t.makeUpdateData([h],null))}else{u["$ui5.deleted"]=true}},function(e){if(!e.canceled){g=g.filter(function(e){return!e.persistent});b()}throw e})})};f.prototype.addDeleted=function(e,t,i,n,s){var r={created:s,groupId:n&&n.getGroupId(),predicate:i,index:t},o;e.$deleted=e.$deleted||[];if(t===undefined){e.$deleted.unshift(r)}else{for(o=0;o<e.$deleted.length;o+=1){if(t<e.$deleted[o].index){break}}e.$deleted.splice(o,0,r)}return r};f.prototype.addPendingRequest=function(){var e;if(!this.oPendingRequestsPromise){this.oPendingRequestsPromise=new s(function(t){e=t});this.oPendingRequestsPromise.$count=0;this.oPendingRequestsPromise.$resolve=e}this.oPendingRequestsPromise.$count+=1};f.prototype.addTransientCollection=function(e,i){var n,s=e.split("/"),r=s.pop(),o=this.getValue(s.join("/")),a=t.getPrivateAnnotation(o,"postBody"),u,h=e.indexOf(")",e.indexOf("($uid="))+1,c=this.getValue(e.slice(0,h)),l=t.getPrivateAnnotation(c,"select",{}),d=this;function f(){n.$postBodyCollection=a[r]=u}this.checkSharedRequest();n=o[r]=o[r]||[];n.$count=n.$created=n.length;n.$byPredicate={};u=a[r]||[];if(n.length){f()}else{n.$postBodyCollection=f}l[t.getMetaPath(e.slice(h+1))]=i;t.setPrivateAnnotation(c,"select",l);n.forEach(function(e,i){var s="($uid="+t.uid()+")";e["@$ui5.context.isTransient"]=true;t.setPrivateAnnotation(e,"postBody",u[i]);t.setPrivateAnnotation(e,"transient",t.getPrivateAnnotation(o,"transient"));t.setPrivateAnnotation(e,"transientPredicate",s);t.setPrivateAnnotation(e,"promise",t.addPromise(e));n.$byPredicate[s]=e});this.fetchTypes().then(function(i){d.oRequestor.fetchType(i,d.sMetaPath+"/"+t.getMetaPath(e))});return n};f.prototype.adjustIndexes=function(e,t,i,n,s,r){if(i===undefined){return}if(!e&&this.aReadRequests){this.aReadRequests.forEach(function(e){if(e.iStart>=i){e.iStart+=n;e.iEnd+=n}})}(t.$deleted||[]).forEach(function(e,t){if(i<e.index||s<t||r&&(i===0||!e.created)){e.index+=n}})};f.prototype.calculateKeyPredicate=function(e,i,n){var s,r=i[n];if(r&&r.$Key){s=t.getKeyPredicate(e,n,i);if(s){t.setPrivateAnnotation(e,"predicate",s)}}return s};f.prototype.checkSharedRequest=function(){if(this.bSharedRequest){throw new Error(this+" is read-only")}};f.prototype.create=function(e,i,n,r,o,a,h,c,l){var d=this.getValue(n),f=e.getGroupId(),p,g,P=this;function m(s){var a=o["@$ui5.context.isInactive"],u=d.indexOf(o);if(s&&a){if(a===1){t.resetInactiveEntity(P.mChangeListeners,r,o)}return true}t.cancelNestedCreates(o,"Deep create of "+i.getResult()+" canceled; group: "+e.getGroupId());t.removeByPath(P.mPostRequests,n,o);d.splice(u,1);d.$created-=1;if(!o["@$ui5.context.isInactive"]){if(!n){P.iActiveElements-=1}t.addToCount(P.mChangeListeners,n,d,-1)}delete d.$byPredicate[r];P.adjustIndexes(n,d,u,-1);if(l){l()}e.cancel()}function y(){P.addPendingRequest();t.setPrivateAnnotation(o,"transient",new Promise(function(e){g=e}));c()}function v(e,i){t.setPrivateAnnotation(o,"transient",f);t.addByPath(P.mPostRequests,n,o);return s.all([P.oRequestor.request("POST",e,i,null,p,y,m,undefined,t.buildPath(P.sResourcePath,n,r)),P.fetchTypes()]).then(function(i){var s=i[0],a,u,h;t.deletePrivateAnnotation(o,"postBody");t.deletePrivateAnnotation(o,"transient");i[0]["@$ui5.context.isTransient"]=false;t.removeByPath(P.mPostRequests,n,o);P.visitResponse(s,i[1],t.getMetaPath(t.buildPath(P.sMetaPath,n)),n+r,undefined,true);a=t.getPrivateAnnotation(s,"predicate");if(a){t.setPrivateAnnotation(o,"predicate",a);if(r in d.$byPredicate){d.$byPredicate[a]=o;t.updateTransientPaths(P.mChangeListeners,r,a)}}t.cancelNestedCreates(o,"Deep create of "+e+" succeeded. Do not use this promise.");u=t.buildPath(n,a||r);const c=t.updateNestedCreates(P.mChangeListeners,P.mQueryOptions,u,o,s,t.getPrivateAnnotation(o,"select"));if(!c){h=t.getQueryOptionsForPath(P.mLateQueryOptions||P.mQueryOptions,n).$select}t.updateSelected(P.mChangeListeners,u,o,s,h,undefined,true);t.setPrivateAnnotation(o,"deepCreate",c);t.deletePrivateAnnotation(o,"select");P.removePendingRequest();g(true);return o},function(t){var i;if(t.canceled){throw t}if(g){P.removePendingRequest();g()}if(P.fetchTypes().isRejected()){h(t);throw t}f=f.replace(u,"");f=P.oRequestor.getGroupSubmitMode(f)==="API"?f:"$parked."+f;i=v(e,P.oRequestor.lockGroup(f,P,true,true));h(t);return i})}this.checkSharedRequest();if(!Array.isArray(d)){throw new Error("Create is only supported for collections; '"+n+"' does not reference a collection")}p=t.clone(o);t.setPrivateAnnotation(o,"postBody",p);t.setPrivateAnnotation(o,"transientPredicate",r);o["@$ui5.context.isTransient"]=true;if(f.startsWith("$inactive.")){t.setPrivateAnnotation(o,"initialData",t.publicClone(o,true));o["@$ui5.context.isInactive"]=true}else{if(!n){this.iActiveElements+=1}t.addToCount(this.mChangeListeners,n,d,1)}if(a){d.splice(d.$created,0,o)}else{d.unshift(o)}d.$created+=1;d.$byPredicate=d.$byPredicate||{};d.$byPredicate[r]=o;P.adjustIndexes(n,d,0,1,0,true);if(d.$postBodyCollection){if(typeof d.$postBodyCollection==="function"){d.$postBodyCollection()}t.setPrivateAnnotation(o,"transient",f);if(a){d.$postBodyCollection.push(p)}else{d.$postBodyCollection.unshift(p)}e.unlock();return t.addPromise(o)}return i.then(function(t){t+=P.oRequestor.buildQueryString(P.sMetaPath,P.mQueryOptions,true);return v(t,e)})};f.prototype.drillDown=function(e,i,r,a){var u=s.resolve(e),h,c,d=false,p,g=false,P=this;function m(e,t){t||=e[0]==="("&&e.at(-1)===")";n[t?"info":"error"]("Failed to drill-down into "+i+", invalid segment: "+e,P.toString(),o);return undefined}function y(i,n,s,o){var a,u,l=p.slice(0,s).join("/"),f=t.getMetaPath(l),y;if(Array.isArray(i)){return m(n,n==="0")}if(d){return m(n,true)}if(n.includes("@")){u=n.split("@")[0];f=t.getMetaPath(l.split("@")[0]);if(g||u in i||i[u+"@$ui5.noData"]||t.isSelected(f,P.mQueryOptions)){return m(n,true)}}a=i[t.getAnnotationKey(i,".Permissions",n)];if(a===0||a==="None"){return undefined}return P.oRequestor.getModelInterface().fetchMetadata(P.sMetaPath+"/"+f).then(function(s){var a=false;if(!s){return m(n)}if(s.$Type==="Edm.Stream"&&!u){y=i[n+"@odata.mediaReadLink"]||i[n+"@mediaReadLink"];if(y){return y}if(i[n+"@$ui5.noData"]||t.isSelected(f,P.mQueryOptions)){return t.buildPath(P.oRequestor.getServiceUrl()+P.sResourcePath,l)}}if(!g){if(!h&&!Array.isArray(e)){h=e;c=0}if(h&&!o){a=P.fetchLateProperty(r,h,p.slice(0,c).join("/"),p.slice(c).join("/"))}return typeof a==="boolean"?m(n,a):a}if(s.$kind==="NavigationProperty"){return null}if(!s.$Type.startsWith("Edm.")){return{}}if("$DefaultValue"in s){return s.$Type==="Edm.String"?s.$DefaultValue:t.parseLiteral(s.$DefaultValue,s.$Type,l)}return null})}if(!i){return u}p=i.split("/");return p.reduce(function(e,i,n){return e.then(function e(r,o){var u,p,P;if(r===undefined){return undefined}if(i==="$count"){return Array.isArray(r)?r.$count:m(i)}if(r===null){g=true;return y({},i,n+1)}if(typeof r!=="object"||i==="@$ui5._"||Array.isArray(r)&&(i[0]==="$"||i==="length")){return m(i)}if(t.hasPrivateAnnotation(r,"predicate")){h=r;c=n}P=r;g=g||r["@$ui5.context.isTransient"];p=l.exec(i);if(p){if(p[1]){r=r[p[1]]}if(r){r=r.$byPredicate&&r.$byPredicate[p[2]]}}else{u=f.from$skip(i,r);if(a&&u===i&&(r[i]===undefined||r[i]===null)){r[i]={}}r=r[u]}if(r===undefined&&i[0]!=="#"&&i[0]!=="@"){r=y(P,i,n+1,o);if(r instanceof s&&r.isPending()){return r.then(function(){return e(P,true)})}}if(i.includes("@")){d=true}return r})},u)};f.prototype.fetchLateProperty=function(e,i,n,s){var r=false,o,a,u,h=s.indexOf("@"),c,l,d,f,p=t.getMetaPath(n),g=this.getTypes(),P,m=this;function y(){r=true;m.oRequestor.getModelInterface().fireDataRequested("/"+a)}function v(e,i){var n=t.buildPath(o,i),s=g[n],r;if(!s){s=m.oRequestor.fetchType(g,n).getResult()}if(i){(s.$Key||[]).forEach(function(e){if(typeof e==="object"){e=e[Object.keys(e)[0]]}P.push(t.buildPath(i,e))})}if(e.$expand){r=Object.keys(e.$expand)[0];v(e.$expand[r],t.buildPath(i,r))}}if(!(this.mLateQueryOptions||this.mQueryOptions&&this.mQueryOptions.$select)){return false}if(h>=0){if(s.startsWith("@$ui5.",h)){return true}s=s.slice(0,h)}P=[s];o=t.buildPath(this.sMetaPath,p);d=this.mLateQueryOptions||{$select:this.mQueryOptions.$select,$expand:this.mQueryOptions.$expand};d=t.intersectQueryOptions(t.getQueryOptionsForPath(d,n),[s],this.oRequestor.getModelInterface().fetchMetadata,o);if(!d){return false}v(d);a=t.buildPath(this.sResourcePath,n);f=a+this.oRequestor.buildQueryString(o,d,false,true);l=this.mPropertyRequestByPath[f];if(!l){c=a+this.oRequestor.buildQueryString(o,this.mQueryOptions,true);u=t.getPrivateAnnotation(i,"groupId");l=this.oRequestor.request("GET",c,u?this.oRequestor.lockGroup(u,this):e.getUnlockedCopy(),undefined,undefined,y,undefined,o,undefined,false,d).then(function(e){m.visitResponse(e,g,o,n);return e});this.mPropertyRequestByPath[f]=l}return l.then(function(e){var s=t.getPrivateAnnotation(e,"predicate"),o=t.getPrivateAnnotation(i,"predicate");if(o&&s&&o!==s){throw new Error("GET "+f+": Key predicate changed from "+o+" to "+s)}if(i["@odata.etag"]&&e["@odata.etag"]!==i["@odata.etag"]){throw new Error("GET "+f+": ETag changed")}t.updateSelected(m.mChangeListeners,n,i,e,P);if(r){r=false;m.oRequestor.getModelInterface().fireDataReceived(undefined,"/"+a)}}).catch(function(e){if(r){m.oRequestor.getModelInterface().fireDataReceived(e,"/"+a)}throw e}).finally(function(){delete m.mPropertyRequestByPath[f]})};f.prototype.fetchTypes=function(){var e,t,i=this;function n(s,r){if(r&&r.$expand){Object.keys(r.$expand).forEach(function(o){var a=s;o.split("/").forEach(function(n){a+="/"+n;e.push(i.oRequestor.fetchType(t,a))});n(a,r.$expand[o])})}}if(!this.oTypePromise){e=[];t={};e.push(this.oRequestor.fetchType(t,this.sMetaPath));n(this.sMetaPath,this.mQueryOptions);this.oTypePromise=s.all(e).then(function(){return t})}return this.oTypePromise};f.prototype.getAndRemoveCollection=function(t){var i=t.split("/"),n=i.pop(),s=this.fetchValue(e.$cached,i.join("/")).getResult(),r=s[n];this.checkSharedRequest();if(r){if(!Array.isArray(r)){throw new Error(`${t} must point to a collection`)}if(!r.$transfer){return undefined}delete r.$transfer}delete s[n];return r};f.prototype.getAllElements=function(e){var t;if(e){return this.getValue(e)}t=this.aElements.map(function(e){return e instanceof s?undefined:e});t.$count=this.aElements.$count;return t};f.prototype.getCreatedElements=function(e){var t=this.getValue(e);return t?t.slice(0,t.$created):[]};f.prototype.getDownloadQueryOptions=function(e){return e};f.prototype.getDownloadUrl=function(e,i){var n=this.mQueryOptions;if(e){n=t.getQueryOptionsForPath(n,e);n=t.merge({},i,n)}return this.oRequestor.getServiceUrl()+t.buildPath(this.sResourcePath,e)+this.oRequestor.buildQueryString(t.buildPath(this.sMetaPath,t.getMetaPath(e)),this.getDownloadQueryOptions(n),false,true)};f.prototype.getLateQueryOptions=function(){return this.mLateQueryOptions};f.prototype.getPendingRequestsPromise=function(){return this.oPendingRequestsPromise&&this.oPendingRequestsPromise.getResult()};f.prototype.getQueryOptions=function(){return this.mQueryOptions};f.prototype.getTypes=function(){return this.fetchTypes().getResult()};f.prototype.getValue=function(e){throw new Error("Unsupported operation")};f.prototype.getResourcePath=function(){return this.sResourcePath};f.prototype.hasChangeListeners=function(){return!t.isEmptyObject(this.mChangeListeners)};f.prototype.hasPendingChangesForPath=function(e,i,n){var s=this;return Object.keys(this.mChangeRequests).some(function(n){return t.hasPathPrefix(n,e)&&!(i&&s.mChangeRequests[n].every(function(e){return!e.$isKeepAlive||e.$isKeepAlive()}))})||Object.keys(this.mPostRequests).some(function(i){return n&&!i?false:t.hasPathPrefix(i,e)&&s.mPostRequests[i].some(function(e){return e["@$ui5.context.isInactive"]!==true})})};f.prototype.hasSentRequest=function(){return this.bSentRequest};f.prototype.patch=function(i,n){var s=this;this.checkSharedRequest();return this.fetchValue(e.$cached,i).then(function(e){t.updateExisting(s.mChangeListeners,i,e,n);return e})};f.prototype.refreshSingle=function(i,n,r,o,a,u,h){var c=false,l=this;this.checkSharedRequest();return this.fetchValue(e.$cached,n).then(function(e){var d=u&&n===""&&l.oRequestor.getModelInterface().fetchMetadata(l.sMetaPath+"/@com.sap.vocabularies.Common.v1.Messages/$Path").getResult(),f=t.clone(t.getQueryOptionsForPath(l.mQueryOptions,n)),p;if(r>=0){o=t.getPrivateAnnotation(e[r],"predicate")}if(!o){throw new Error("No key predicate known")}p=t.buildPath(l.sResourcePath,n,o);if(a&&l.mLateQueryOptions){t.aggregateExpandSelect(f,l.mLateQueryOptions)}if(d&&f.$select&&!f.$select.includes(d)){f.$select.push(d);c=true}delete f.$apply;delete f.$count;delete f.$filter;delete f.$orderby;delete f.$search;p+=l.oRequestor.buildQueryString(l.sMetaPath,f,false,l.bSortExpandSelect);l.bSentRequest=true;return s.all([l.oRequestor.request("GET",p,i,undefined,undefined,h),l.fetchTypes()]).then(function(t){var i=t[0];l.replaceElement(e,r,o,i,t[1],n,c);return i})})};f.prototype.refreshSingleWithRemove=function(i,n,r,o,a,u,h){var c=this;this.checkSharedRequest();return s.all([this.fetchValue(e.$cached,n),this.fetchTypes()]).then(function(e){var l=e[0],d,f,p={},g,P,m=t.clone(t.getQueryOptionsForPath(c.mQueryOptions,n)),y,v=t.buildPath(c.sResourcePath,n),$=[],R=e[1];if(r!==undefined){d=l[r];o=t.getPrivateAnnotation(d,"predicate");if(!o){throw new Error("No key predicate known")}}else{d=l.$byPredicate[o]}P=t.getKeyFilter(d,c.sMetaPath,R);f=(m.$filter?"("+m.$filter+") and ":"")+P;delete m.$count;delete m.$orderby;c.bSentRequest=true;if(a){if(c.mLateQueryOptions){t.aggregateExpandSelect(m,c.mLateQueryOptions)}p=Object.assign({},m);p.$filter=f;m.$filter=P;delete m.$search;y=v+c.oRequestor.buildQueryString(c.sMetaPath,m,false,c.bSortExpandSelect);$.push(c.oRequestor.request("GET",y,i,undefined,undefined,u));if(r!==undefined&&(P!==f||p.$search)){delete p.$select;delete p.$expand;p.$count=true;p.$top=0;g=v+c.oRequestor.buildQueryString(c.sMetaPath,p);$.push(c.oRequestor.request("GET",g,i.getUnlockedCopy()))}}else{m.$filter=f;y=v+c.oRequestor.buildQueryString(c.sMetaPath,m,false,c.bSortExpandSelect);$.push(c.oRequestor.request("GET",y,i,undefined,undefined,u))}return s.all($).then(function(e){var t=e[0].value,i=e[1]&&e[1]["@odata.count"]==="0";if(t.length>1){throw new Error("Unexpected server response, more than one entity returned.")}else if(t.length===0){c.removeElement(r,o,l,n);c.oRequestor.getModelInterface().reportStateMessages(c.sResourcePath,{},[n+o]);h(false)}else if(i){c.removeElement(r,o,l,n);c.replaceElement(l,undefined,o,t[0],R,n);h(true)}else{c.replaceElement(l,r,o,t[0],R,n)}})})};f.prototype.registerChangeListener=function(e,i){if(!(this.bSharedRequest&&e)){t.registerChangeListener(this,e,i)}};f.prototype.removeElement=function(e,i,n=this.aElements,s=""){const r=i?n.$byPredicate[i]:n[e];if(!i){i=r&&t.getPrivateAnnotation(r,"predicate")}else if(e!==undefined){e=f.getElementIndex(n,i,e)}const o=r?.["@$ui5.context.isDeleted"];if(!o){delete n.$byPredicate[i]}if(e>=0){n.splice(e,1);t.addToCount(this.mChangeListeners,s,n,-1);const i=r&&t.getPrivateAnnotation(r,"transientPredicate");if(i){n.$created-=1;if(!s){this.iActiveElements-=1}if(!o){delete n.$byPredicate[i]}}else if(!s){this.iLimit-=1}this.adjustIndexes(s,n,e,-1)}return e};f.prototype.removeMessages=function(){if(this.sReportedMessagesPath){this.oRequestor.getModelInterface().reportStateMessages(this.sReportedMessagesPath,{});this.sReportedMessagesPath=undefined}};f.prototype.removePendingRequest=function(){if(this.oPendingRequestsPromise){this.oPendingRequestsPromise.$count-=1;if(!this.oPendingRequestsPromise.$count){this.oPendingRequestsPromise.$resolve();this.oPendingRequestsPromise=null}}};f.prototype.replaceElement=function(e,i,n,s,r,o,a){var u,h;if(i===undefined){u=e.$byPredicate[n];e.$byPredicate[n]=s}else{i=f.getElementIndex(e,n,i);u=e[i];e[i]=e.$byPredicate[n]=s;h=t.getPrivateAnnotation(u,"transientPredicate");if(h){s["@$ui5.context.isTransient"]=false;e.$byPredicate[h]=s;t.setPrivateAnnotation(s,"transientPredicate",h)}}t.restoreUpdatingProperties(u,s);this.visitResponse(s,r,t.getMetaPath(t.buildPath(this.sMetaPath,o)),o+n,undefined,a)};f.prototype.requestCount=function(e){var i,n,s,r=this;if(this.mQueryOptions&&this.mQueryOptions.$count){n=Object.assign({},this.mQueryOptions);delete n.$expand;delete n.$orderby;delete n.$select;i=this.getExclusiveFilter();if(i){n.$filter=n.$filter?"("+n.$filter+") and "+i:i}n.$top=0;s=this.sResourcePath+this.oRequestor.buildQueryString(this.sMetaPath,n);return this.oRequestor.request("GET",s,e.getUnlockedCopy()).catch(function(t){if(t.cause&&t.cause.status===404){return r.oRequestor.request("GET",s,e.getUnlockedCopy())}throw t}).then(function(e){var i=parseInt(e["@odata.count"])+r.iActiveElements;t.setCount(r.mChangeListeners,"",r.aElements,i);r.iLimit=i;return i})}return Promise.resolve(r.iLimit)};f.prototype.resetChangesForPath=function(e){var i=this;this.checkSharedRequest();Object.keys(this.mChangeRequests).reverse().forEach(function(n){var s,r;if(t.hasPathPrefix(n,e)){s=i.mChangeRequests[n];for(r=s.length-1;r>=0;r-=1){i.oRequestor.removeChangeRequest(s[r])}delete i.mChangeRequests[n]}});Object.keys(this.mPostRequests).forEach(function(n){var s=i.mPostRequests[n],r,o,a;if(e.startsWith("($uid=")){s.forEach(function(n){o=t.getPrivateAnnotation(n,"transientPredicate");if(o===e&&n["@$ui5.context.isInactive"]===1){t.resetInactiveEntity(i.mChangeListeners,o,n)}})}else if(d(n,e)){for(a=s.length-1;a>=0;a-=1){r=t.getPrivateAnnotation(s[a],"transient");if(r.startsWith("$inactive.")){t.resetInactiveEntity(i.mChangeListeners,t.getPrivateAnnotation(s[a],"transientPredicate"),s[a])}else{i.oRequestor.removePost(r,s[a])}}}})};f.prototype.restoreElement=function(e,i,n,s=t.getPrivateAnnotation(i,"transientPredicate"),r=this.aElements,o=""){this.adjustIndexes(o,r,e,1,n);if(s){r.$created+=1;if(!o){this.iActiveElements+=1}}else if(!o){this.iLimit+=1}t.addToCount(this.mChangeListeners,o,r,1);r.splice(e,0,i);r.$byPredicate[t.getPrivateAnnotation(i,"predicate")]=i};f.prototype.setActive=function(e){if(e){this.iActiveUsages+=1;this.iInactiveSince=Infinity}else{this.iActiveUsages-=1;if(!this.iActiveUsages){this.iInactiveSince=Date.now();this.mChangeListeners={}}}};f.prototype.setLateQueryOptions=function(e){if(e){this.mLateQueryOptions={$select:e.$select,$expand:e.$expand}}else{this.mLateQueryOptions=null}};f.prototype.setProperty=function(i,n,s,r){var o=this;this.checkSharedRequest();return this.fetchValue(e.$cached,s,null,null,true).then(function(e){t.updateAll(o.mChangeListeners,s,e,t.makeUpdateData(i.split("/"),n,r))})};f.prototype.setQueryOptions=function(e={},t=false){this.checkSharedRequest();if(this.bSentRequest&&!t){throw new Error("Cannot set query options: Cache has already sent a request")}this.mQueryOptions=e;this.sQueryString=this.oRequestor.buildQueryString(this.sMetaPath,e,false,this.bSortExpandSelect)};f.prototype.setResourcePath=function(e){this.checkSharedRequest();this.sResourcePath=e;this.sMetaPath=t.getMetaPath("/"+e);this.oTypePromise=undefined;this.mLateQueryOptions=null;this.mPropertyRequestByPath={}};f.prototype.toString=function(){return this.oRequestor.getServiceUrl()+this.sResourcePath+this.sQueryString};f.prototype.update=function(i,r,a,u,h,c,l,d,f,p){var g,P=r.split("/"),m,y=this;this.checkSharedRequest();try{g=this.fetchValue(e.$cached,c)}catch(e){if(!e.$cached||this.oPromise!==null){throw e}g=this.oPromise=s.resolve({"@odata.etag":"*"})}return g.then(function(e){var g=t.buildPath(c,r),v=i.getGroupId(),$,R,E,q,b,S,A,C=t.makeUpdateData(P,a);function O(){t.removeByPath(y.mChangeRequests,g,R);t.updateExisting(y.mChangeListeners,c,e,$)}function w(e){if(arguments.length===0){b=true;return $}t.updateNonExisting($,e)}function k(i,n){var r={"If-Match":e},o;function a(){o=y.oRequestor.lockGroup(v,y,true);f()}if(d){r.Prefer="return=minimal"}R=y.oRequestor.request("PATCH",h,i,r,C,a,O,undefined,t.buildPath(y.sOriginalResourcePath,c),n,undefined,undefined,w);R.$isKeepAlive=p;t.addByPath(y.mChangeRequests,g,R);return s.all([R,y.fetchTypes()]).then(function(i){var n=i[0];t.removeByPath(y.mChangeRequests,g,R);if(b){return}if(!d){y.visitResponse(n,i[1],t.getMetaPath(t.buildPath(y.sMetaPath,c)),c)}t.updateExisting(y.mChangeListeners,c,e,d?{"@odata.etag":n["@odata.etag"]}:n)},function(i){var n=v;if(!u&&!i.canceled){O();throw i}t.removeByPath(y.mChangeRequests,g,R);if(i.canceled){throw i}o.unlock();o=undefined;u(i);if(b){return y.mEditUrl2PatchPromise[h]}switch(y.oRequestor.getGroupSubmitMode(v)){case"API":break;case"Auto":if(!y.oRequestor.hasChanges(v,e)){n="$parked."+v}break;default:throw i}y.mEditUrl2PatchPromise[h]=k(y.oRequestor.lockGroup(n,y,true,true),true);return y.mEditUrl2PatchPromise[h]}).finally(function(){if(o){o.unlock()}delete y.mEditUrl2PatchPromise[h]})}if(!e){throw new Error("Cannot update '"+r+"': '"+c+"' does not exist")}t.deleteUpdating(r,e);S=t.getPrivateAnnotation(e,"transient");if(S){if(typeof S!=="string"){throw new Error("No 'update' allowed while waiting for server response")}if(S.startsWith("$parked.")||S.startsWith("$inactive.")){q=S;S=S.slice(S.indexOf(".")+1)}if(S!==v){throw new Error("The entity will be created via group '"+S+"'. Cannot patch via group '"+v+"'")}}$=t.makeUpdateData(P,t.drillDown(e,P));E=t.getPrivateAnnotation(e,"postBody");if(E){t.updateAll({},c,E,C)}t.updateAll(y.mChangeListeners,c,e,C);if(l){l=t.buildPath(P.slice(0,-1).join("/"),l);m=l.split("/");l=t.buildPath(c,l);A=y.getValue(l);if(A===undefined){n.debug("Missing value for unit of measure "+l+" when updating "+g,y.toString(),o)}else{t.merge(S?E:C,t.makeUpdateData(m,A))}}if(S){if(q&&!e["@$ui5.context.isInactive"]){t.setPrivateAnnotation(e,"transient",S);y.oRequestor.relocate(q,E,S)}i.unlock();return Promise.resolve()}y.oRequestor.relocateAll("$parked."+v,v,e);h+=y.oRequestor.buildQueryString(y.sMetaPath,y.mQueryOptions,true);return k(i)})};f.prototype.visitResponse=function(e,i,n,s,r,o){var u,c=false,l={},d=this.oRequestor.getServiceUrl()+this.sResourcePath,f=this;function p(e,i,n){c=true;if(e&&e.length){f.checkSharedRequest();l[i]=e;e.forEach(function(e){if(e.longtextUrl){e.longtextUrl=t.makeAbsolute(e.longtextUrl,n)}})}}function g(e,i){return i?t.makeAbsolute(i,e):e}function P(e,i,n,s){var o={},a,h,c,l;for(l=0;l<e.length;l+=1){h=e[l];a=n===""?r+l:l;if(h&&typeof h==="object"){m(h,i,n,s,a);c=t.getPrivateAnnotation(h,"predicate");if(!n){u.push(c||""+a)}if(c){o[c]=h;e.$byPredicate=o}}}}function m(e,n,r,o,c){var l,d,y=i[n],v=y&&y[h]&&y[h].$Path,$;o=g(o,e["@odata.context"]);d=f.calculateKeyPredicate(e,i,n);if(c!==undefined){r=t.buildPath(r,d||c)}else if(d){l=a.exec(r);if(l){r=r.slice(0,-l[0].length)+d}}if(s&&!u){u=[r]}if(v){$=t.drillDown(e,v.split("/"));if($!==undefined){p($,r,o)}}Object.keys(e).forEach(function(i){var s,a=n+"/"+i,u=e[i],h=t.buildPath(r,i);if(i.endsWith("@odata.mediaReadLink")||i.endsWith("@mediaReadLink")){e[i]=t.makeAbsolute(u,o)}if(i===v||i.includes("@")){return}if(Array.isArray(u)){u.$created=0;s=e[i+"@odata.count"];if(s){u.$count=parseInt(s)}else if(!e[i+"@odata.nextLink"]){u.$count=u.length}else{u.$count=undefined}P(u,a,h,g(o,e[i+"@odata.context"]))}else if(u&&typeof u==="object"){m(u,a,h,o)}})}if(r!==undefined){u=[];P(e.value,n||this.sMetaPath,"",g(d,e["@odata.context"]))}else if(e&&typeof e==="object"){m(e,n||this.sMetaPath,s||"",d)}if(c&&!this.bSharedRequest){if(!o){this.sReportedMessagesPath=this.sOriginalResourcePath}this.oRequestor.getModelInterface().reportStateMessages(this.sOriginalResourcePath,l,u)}};function p(e,t,i,n,s,r){f.call(this,e,t,i,n,s,r);this.iActiveElements=0;this.oBackup=null;this.sContext=undefined;this.aElements=[];this.aElements.$byPredicate={};this.aElements.$count=undefined;this.aElements.$created=0;this.aElements.$tail=undefined;this.iLimit=Infinity;this.aReadRequests=[];this.bServerDrivenPaging=false;this.oSyncPromiseAll=undefined}p.prototype=Object.create(f.prototype);p.prototype.addKeptElement=function(e){this.checkSharedRequest();this.aElements.$byPredicate[t.getPrivateAnnotation(e,"predicate")]=e};p.prototype.checkRange=function(e,t,i){var n;if(e!==this.aElements.$tail){i=Math.min(i,this.aElements.length);for(n=t;n<i;n+=1){if(this.aElements[n]!==e){throw new Error("Found data at an index being read from the back end")}}}};p.prototype.doReplaceWith=function(e,i){var n=this.aElements[e];this.checkSharedRequest();if(n&&t.hasPrivateAnnotation(n,"transientPredicate")&&!t.hasPrivateAnnotation(i,"transientPredicate")){t.setPrivateAnnotation(i,"transientPredicate",t.getPrivateAnnotation(i,"predicate"))}this.aElements[e]=i;this.addKeptElement(i)};p.prototype.drop=function(e,i,n){if(n){e+=this.aElements.$created}const s=this.aElements[e];if(s["@$ui5.context.isTransient"]){throw new Error("Must not drop a transient element")}delete this.aElements[e];delete this.aElements.$byPredicate[i];const r=t.getPrivateAnnotation(s,"transientPredicate");if(r){this.aElements.$created-=1;this.iActiveElements-=1;this.iLimit+=1;delete this.aElements.$byPredicate[r]}};p.prototype.fetchValue=function(t,i,n,r,o){var a,u=i.split("/")[0],h,c=this;t.unlock();if(this.aElements.$byPredicate[u]){h=s.resolve()}else if((t===e.$cached||u!=="$count")&&this.aElements[u]!==undefined){h=s.resolve(this.aElements[u])}else{if(!this.oSyncPromiseAll){a=this.aElements.$tail?this.aElements.concat(this.aElements.$tail):this.aElements;this.oSyncPromiseAll=s.all(a)}h=this.oSyncPromiseAll}return h.then(function(){c.registerChangeListener(i,r);return c.drillDown(c.aElements,i,t,o)})};p.prototype.fill=function(e,t,i){var n;if(i>this.aElements.length&&i-t>1024){if(this.aElements.$tail&&e){throw new Error("Cannot fill from "+t+" to "+i+", $tail already in use, # of elements is "+this.aElements.length)}this.aElements.$tail=e;i=this.aElements.length}for(n=t;n<i;n+=1){this.aElements[n]=e}this.oSyncPromiseAll=undefined};p.prototype.getExclusiveFilter=function(){var e,i=[],n,s,r=this;function o(e){var s;n=n||r.getTypes();s=t.getKeyFilter(e,r.sMetaPath,n);if(s){i.push(s)}}for(s=0;s<this.aElements.$created;s+=1){e=this.aElements[s];if(!e["@$ui5.context.isTransient"]){o(e)}}(this.aElements.$deleted||[]).forEach(function(e){o(r.aElements.$byPredicate[e.predicate])});return i.length?"not ("+i.sort().join(" or ")+")":undefined};p.prototype.getQueryString=function(){var e=this.getExclusiveFilter(),i=Object.assign({},this.mQueryOptions),n=i.$filter,s=this.sQueryString;if(e){if(n){i.$filter="("+n+") and "+e;s=this.oRequestor.buildQueryString(this.sMetaPath,i,false,this.bSortExpandSelect)}else{s+=(s?"&":"?")+"$filter="+t.encode(e,false)}}return s};p.prototype.getResourcePathWithQuery=function(e,t){var i=this.aElements.$created,n=this.getQueryString(),s=n?"&":"?",r=t-e,o=this.sResourcePath+n;if(e<i){throw new Error("Must not request created element")}e-=i;if(e>0||r<Infinity){o+=s+"$skip="+e}if(r<Infinity){o+="&$top="+r}return o};p.prototype.getValue=function(t){var i;if(!t){return this.aElements}i=this.fetchValue(e.$cached,t);if(i.isFulfilled()){return i.getResult()}i.caught()};p.prototype.handleCount=function(e,i,n,s,r,o){var a=r["@odata.count"],u=this.aElements.$created,h,c=-1,l=this.aElements.$count,d,f=r.value.length,p;s-=o;f-=o;if(a){h=parseInt(a)-o;if(o===i||n===u&&f===h){this.iLimit=c=h}else{d=this.requestCount(this.oRequestor.getUnlockedAutoCopy(e))}}if(r["@odata.nextLink"]){this.bServerDrivenPaging=true;if(s<this.aElements.length){for(p=n+f;p<s;p+=1){delete this.aElements[p]}}else{this.aElements.length=n+f}}else if(f<s-n){if(c===-1){c=l&&l-this.iActiveElements}c=Math.min(c!==undefined?c:Infinity,n-u+f);this.aElements.length=u+c;this.iLimit=c;if(!a&&c>0&&!this.aElements[c-1]){c=undefined}}if(c!==-1){t.setCount(this.mChangeListeners,"",this.aElements,c!==undefined?c+this.iActiveElements:undefined)}return d};p.prototype.handleResponse=function(e,i,n){var s,r=this.aElements,o=r.$created,a,u=0,h,c=e.value.length,l;this.sContext=e["@odata.context"];this.visitResponse(e,n,undefined,undefined,i);for(l=0;l<c;l+=1){s=e.value[l];h=t.getPrivateAnnotation(s,"predicate");if(h){a=r.$byPredicate[h];if(a){if(!a["@odata.etag"]||s["@odata.etag"]===a["@odata.etag"]){if(o&&r.lastIndexOf(a,o-1)>=0){u+=1;r[i+c-u]=undefined;continue}t.updateNonExisting(a,s);s=a}else if(this.hasPendingChangesForPath(h)){throw new Error("Modified on client and on server: "+this.sResourcePath+h)}}r.$byPredicate[h]=s}r[i+l-u]=s}return u};p.prototype.isDeletingInOtherGroup=function(e){return Object.values(this.aElements.$deleted||{}).some(function(t){return t.groupId!==e})};p.prototype.isMissing=function(e){return this.aElements[e]===undefined&&!(this.$tail&&this.aReadRequests.some(t=>t.iStart<=e&&e<t.iEnd))};p.prototype.keepOnlyGivenElements=function(e){var i,n=-1,s={},r=this;e.forEach(function(e){s[e]=true});i=this.aElements.filter(function(e,i){var o;if(!e){return false}if(t.hasPrivateAnnotation(e,"transient")){n=i;return false}o=t.getPrivateAnnotation(e,"predicate");if(s[o]){n=i;delete s[o];return true}r.drop(i,o);return false});this.aElements.length=n+1;Object.keys(s).forEach(function(e){i.push(r.aElements.$byPredicate[e])});return i};p.prototype.move=function(e,t,i){const n=this.aElements;function s(e,t){while(e<t){const i=n[e];n[e]=n[t];n[t]=i;e+=1;t-=1}}function r(e,t,i){s(e,t-1);s(t,i-1);s(e,i-1)}if(i>0){if(e<t){r(e,e+i,t+i)}else if(e>t){r(t,e,e+i)}}};p.prototype.read=function(e,i,n,o,a,u){var h=0,c,l,d,f=this.oPendingRequestsPromise||this.aElements.$tail,p,g=0,P,m=this;if(e<0){throw new Error("Illegal index "+e+", must be >= 0")}if(i<0){throw new Error("Illegal length "+i+", must be >= 0")}if(f){return f.then(function(){return m.read(e,i,n,o,a,u)})}if(u){e+=this.aElements.$created}for(P=0;P<this.aElements.$created;P+=1){c=this.aElements[P];if(t.getPrivateAnnotation(c,"transient")===o.getGroupId()){g+=1}if(m.oBackup&&!c["@$ui5.context.isTransient"]){h+=1}}p=r._getReadIntervals(this.aElements,e,i,this.bServerDrivenPaging?0:Math.max(n,g,h),this.aElements.$created+this.iLimit);if(g&&(p.length>1||p.length&&p[0].start>this.aElements.$created)){o.unlock();return this.oRequestor.waitForBatchResponseReceived(o.getGroupId()).then(function(){return m.read(e,i,n,m.oRequestor.getUnlockedAutoCopy(o),a)})}p.forEach(function(e){m.requestElements(e.start,e.end,o.getUnlockedCopy(),g,a);a=undefined});o.unlock();d=e+i+n;l=this.aElements.slice(Math.max(0,e-n),d);if(this.aElements.$tail){l.push(this.aElements.$tail)}return s.all(l).then(function(){var t=m.aElements.slice(e,e+i);t.$count=m.aElements.$count;return{"@odata.context":m.sContext,value:t}})};p.prototype.refreshKeptElements=function(e,i,n){var s=this,r=Object.keys(this.aElements.$byPredicate).filter(u).sort(),o;function a(){var e,i=t.clone(s.mQueryOptions);if(s.mLateQueryOptions){t.aggregateExpandSelect(i,s.mLateQueryOptions)}if(n){delete i.$apply}delete i.$count;delete i.$orderby;delete i.$search;e=r.map(function(e){return t.getKeyFilter(s.aElements.$byPredicate[e],s.sMetaPath,o)});i.$filter=e.join(" or ");if(e.length>1){i.$top=e.length}return s.sResourcePath+s.oRequestor.buildQueryString(s.sMetaPath,i,false,true)}function u(e){var i=s.aElements.$byPredicate[e];return t.getPrivateAnnotation(i,"predicate")===e&&Object.keys(i).length>1&&!s.hasPendingChangesForPath(e)}this.checkSharedRequest();if(r.length===0){return undefined}o=this.getTypes();return this.oRequestor.request("GET",a(),e).then(function(e){var n;s.visitResponse(e,o,undefined,undefined,0);n=e.value.$byPredicate||{};r.forEach(function(e){var r,o;if(e in n){t.updateAll(s.mChangeListeners,e,s.aElements.$byPredicate[e],n[e])}else{r=s.aElements.$byPredicate[e];if(t.hasPrivateAnnotation(r,"transientPredicate")){o=s.removeElement(-1,e)}else{delete s.aElements.$byPredicate[e]}i(e,o)}})})};p.prototype.removeKeptElement=function(e){this.checkSharedRequest();delete this.aElements.$byPredicate[e]};p.prototype.requestElements=function(e,t,i,n,r){var o,a={iEnd:t,iStart:e},u=this;this.aReadRequests.push(a);this.bSentRequest=true;o=s.all([this.mQueryOptions.$filter==="false"?Promise.resolve({"@odata.count":"0",value:[]}):this.oRequestor.request("GET",this.getResourcePathWithQuery(e,t),i,undefined,undefined,r),this.fetchTypes()]).then(function(e){var t;if(a.obsolete){const e=new Error("Request is obsolete");e.canceled=true;throw e}u.checkRange(o,a.iStart,a.iEnd);if(u.aElements.$tail===o){u.aElements.$tail=undefined}t=u.handleResponse(e[0],a.iStart,e[1]);return u.handleCount(i,n,a.iStart,a.iEnd,e[0],t)}).catch(function(e){if(!e.canceled){u.checkRange(o,a.iStart,a.iEnd);u.fill(undefined,a.iStart,a.iEnd)}throw e}).finally(function(){u.aReadRequests.splice(u.aReadRequests.indexOf(a),1)});this.fill(o,e,t);return o};p.prototype.requestSideEffects=function(e,i,n,r,o){var a,u,h,c,l,d=this.getTypes(),f=this;this.checkSharedRequest();h=t.intersectQueryOptions(Object.assign({},this.mQueryOptions,this.mLateQueryOptions),i,this.oRequestor.getModelInterface().fetchMetadata,this.sMetaPath,"",o);if(!h){return s.resolve()}if(this.beforeRequestSideEffects){this.beforeRequestSideEffects(h)}if(r){a=[this.aElements.$byPredicate[n[0]]]}else{a=this.keepOnlyGivenElements(n);if(!a.length){return s.resolve()}}h.$filter=a.map(function(e){return t.getKeyFilter(e,f.sMetaPath,d)}).join(" or ");if(a.length>1){h.$top=a.length}t.selectKeyProperties(h,d[this.sMetaPath]);delete h.$count;delete h.$orderby;delete h.$search;u=t.extractMergeableQueryOptions(h);c=this.sResourcePath+this.oRequestor.buildQueryString(this.sMetaPath,h,false,true);return this.oRequestor.request("GET",c,e,undefined,undefined,undefined,undefined,this.sMetaPath,undefined,false,u,this,function(e){if(arguments.length){i=i.concat(e)}else{l=true;return i}}).then(function(e){var n,s,r,o;function u(e){e=e.slice(s.length+1);return!i.some(function(i){return t.getRelativePath(e,i)!==undefined})}if(l){return}if(e.value.length!==a.length){throw new Error("Expected "+a.length+" row(s), but instead saw "+e.value.length)}f.visitResponse(e,d,undefined,"",NaN,true);for(r=0,o=e.value.length;r<o;r+=1){n=e.value[r];s=t.getPrivateAnnotation(n,"predicate");if(f.beforeUpdateSelected){f.beforeUpdateSelected(s,n)}t.updateSelected(f.mChangeListeners,s,f.aElements.$byPredicate[s],n,i,u)}})};p.prototype.reset=function(e,i,n,s,r){var o=this.aElements.$byPredicate,a=this.mChangeListeners,u=0,h,c,l,d=this;if(i){this.checkSharedRequest();this.oBackup={iActiveElements:this.iActiveElements,mChangeListeners:this.mChangeListeners,sContext:this.sContext,aElements:this.aElements.slice(),$byPredicate:o,$count:this.aElements.$count,$created:this.aElements.$created,iLimit:this.iLimit}}if(n){this.setQueryOptions(n,true)}for(l=0;l<this.aElements.$created;l+=1){h=this.aElements[l];c=t.getPrivateAnnotation(h,"transient");if(i?"@$ui5.context.isInactive"in h||c&&c!==i:c){e.push(t.getPrivateAnnotation(h,"predicate")||t.getPrivateAnnotation(h,"transientPredicate"));this.aElements[u]=h;u+=1}else{this.iActiveElements-=1}}Object.keys(o).forEach(function(t){if("@$ui5.context.isDeleted"in o[t]){e.push(t)}});this.mChangeListeners={};this.sContext=undefined;this.aElements.length=this.aElements.$created=u;this.aElements.$byPredicate={};this.aElements.$count=undefined;this.iLimit=Infinity;Object.keys(a).forEach(function(t){if(t==="$count"||e.includes(t.split("/")[0])){d.mChangeListeners[t]=a[t]}});e.forEach(function(e){d.aElements.$byPredicate[e]=o[e]});this.aReadRequests?.forEach(e=>{e.obsolete=true});if(a[""]){this.mChangeListeners[""]=a[""];t.fireChange(this.mChangeListeners,"")}Object.values(this.aElements.$deleted||{}).forEach(function(e){e.index=undefined})};p.prototype.restore=function(e){if(e){this.checkSharedRequest();this.iActiveElements=this.oBackup.iActiveElements;this.mChangeListeners=this.oBackup.mChangeListeners;this.sContext=this.oBackup.sContext;this.aElements.length=this.oBackup.aElements.length;this.oBackup.aElements.forEach(function(e,t){this[t]=e},this.aElements);this.aElements.$byPredicate=this.oBackup.$byPredicate;this.aElements.$count=this.oBackup.$count;this.aElements.$created=this.oBackup.$created;this.iLimit=this.oBackup.iLimit}this.oBackup=null};p.prototype.setEmpty=function(){this.iLimit=this.aElements.$count=0};p.prototype.setInactive=function(e,i){const n=this.getValue(e);t.updateAll(this.mChangeListeners,e,n,{"@$ui5.context.isInactive":i});if(!i){t.deletePrivateAnnotation(n,"initialData");this.iActiveElements+=1;t.addToCount(this.mChangeListeners,"",this.aElements,1)}};p.prototype.setPersistedCollection=function(e){this.aElements=e;this.iActiveElements=e.$created;this.iLimit=e.length};function g(e,t,i){f.call(this,e,t,i);this.oPromise=null}g.prototype=Object.create(f.prototype);g.prototype._delete=function(){throw new Error("Unsupported")};g.prototype.create=function(){throw new Error("Unsupported")};g.prototype.fetchValue=function(e,t,i,n,r){var o=this;if(r){throw new Error("Unsupported argument: bCreateOnDemand")}if(this.oPromise){e.unlock()}else{this.bSentRequest=true;this.oPromise=s.resolve(this.oRequestor.request("GET",this.sResourcePath+this.sQueryString,e,undefined,undefined,i,undefined,this.sMetaPath))}return this.oPromise.then(function(e){o.registerChangeListener("",n);return e&&typeof e==="object"?e.value:e})};g.prototype.update=function(){throw new Error("Unsupported")};function P(e,t,i,n,r,o,a,u,h){f.call(this,e,t,i,n,o,r);this.sMetaPath=u||this.sMetaPath;this.bPost=a;this.bPosting=false;if(h){this.oPromise=s.resolve({})}else{this.oPromise=null}}P.prototype=Object.create(f.prototype);P.prototype.buildOriginalResourcePath=function(e,t,i){if(i){this.calculateKeyPredicate(e,t,this.sMetaPath);this.sOriginalResourcePath=i(e)}};P.prototype.fetchValue=function(e,t,i,n,r,o){var a=this.sResourcePath+this.sQueryString,u=this;this.registerChangeListener(t,n);if(this.oPromise){e.unlock()}else{if(this.bPost){throw new Error("Cannot fetch a value before the POST request")}this.oPromise=s.all([this.oRequestor.request("GET",a,e,undefined,undefined,i,undefined,this.sMetaPath),this.fetchTypes()]).then(function(e){u.buildOriginalResourcePath(e[0],e[1],o);u.visitResponse(e[0],e[1]);return e[0]});this.bSentRequest=true}return this.oPromise.then(function(i){if(i&&i["$ui5.deleted"]){throw new Error("Cannot read a deleted entity")}return u.drillDown(i,t,e,r)})};P.prototype.getValue=function(t){var i;if(this.oPromise&&this.oPromise.isFulfilled()){i=this.drillDown(this.oPromise.getResult(),t,e.$cached);if(i.isFulfilled()){return i.getResult()}i.caught()}};P.prototype.post=function(e,i,n,r,o,a){var u,h=n?{"If-Match":r&&"@odata.etag"in n?"*":n}:{},c="POST",l,d=this;function f(){l=d.oRequestor.lockGroup(e.getGroupId(),d,true)}function p(e){d.bPosting=true;return s.all([d.oRequestor.request(c,d.sResourcePath+d.sQueryString,e,h,i,n&&f),d.fetchTypes()]).then(function(e){d.buildOriginalResourcePath(e[0],e[1],a);d.visitResponse(e[0],e[1]);if(d.mQueryOptions&&d.mQueryOptions.$select){t.updateSelected({},"",e[0],e[0],d.mQueryOptions.$select)}d.bPosting=false;if(l){l.unlock()}return e[0]},function(t){d.bPosting=false;if(l){l.unlock();l=undefined}if(o&&t.strictHandlingFailed){return o(t).then(function(t){var i;if(t){delete h["Prefer"];return p(e.getUnlockedCopy())}i=Error("Action canceled due to strict handling");i.canceled=true;throw i})}throw t})}this.checkSharedRequest();if(!this.bPost){throw new Error("POST request not allowed")}if(this.bPosting){throw new Error("Parallel POST requests not allowed")}if(n){u=e.getGroupId();this.oRequestor.relocateAll("$parked."+u,u,n)}if(i){c=i["X-HTTP-Method"]||c;delete i["X-HTTP-Method"];if(this.oRequestor.isActionBodyOptional()&&t.isEmptyObject(i)){i=undefined}}this.bSentRequest=true;if(o){h["Prefer"]="handling=strict"}this.oPromise=p(e);return this.oPromise};P.prototype.requestSideEffects=function(i,n,r){var o,a,u,h,c=this;this.checkSharedRequest();a=this.oPromise&&t.intersectQueryOptions(Object.assign({},this.mQueryOptions,this.mLateQueryOptions),n,this.oRequestor.getModelInterface().fetchMetadata,this.sMetaPath);if(!a){return s.resolve()}if(this.oPromise.isRejected()){throw new Error(this+": Cannot call requestSideEffects, cache is broken: "+this.oPromise.getResult().message)}o=t.extractMergeableQueryOptions(a);r=(r||this.sResourcePath)+this.oRequestor.buildQueryString(this.sMetaPath,a,false,true);u=s.all([this.oRequestor.request("GET",r,i,undefined,undefined,undefined,undefined,this.sMetaPath,undefined,false,o,this,function(e){if(arguments.length){n=n.concat(e)}else{h=true;return n}}),this.fetchTypes(),this.fetchValue(e.$cached,"")]).then(function(e){return e}).then(function(e){var i=e[0],s=e[2];if(h){return}t.setPrivateAnnotation(i,"predicate",t.getPrivateAnnotation(s,"predicate"));c.visitResponse(i,e[1]);t.updateSelected(c.mChangeListeners,"",s,i,n,function(e){return!n.some(function(i){return t.getRelativePath(e,i)!==undefined})})});return u};P.prototype.resetProperty=function(e){var t=this.oPromise.getResult();if(t){e.split("/").some(function(e){delete t["@odata.etag"];if(typeof t[e]==="object"){t=t[e];return false}delete t[e];return true})}};function m(e,t,i){var n=t.split("/"),s=n[0],r=s+JSON.stringify(i),o=e.$mSingletonCacheByPath;g.call(this,e,t,{});if(!o){o=e.$mSingletonCacheByPath={}}this.oSingleton=o[r];if(!this.oSingleton){this.oSingleton=o[r]=new P(e,s,i,undefined,undefined,undefined,undefined,undefined,true)}this.sRelativePath=t.split(s+"/")[1]}m.prototype=Object.create(g.prototype);m.prototype.fetchValue=function(e,i,n,s,r){var o=this.oSingleton.sResourcePath+"/"+this.sRelativePath,a,u=this.oMetadataPromise||this.oRequestor.getModelInterface().fetchMetadata("/"+t.getMetaPath(o)),h=this;return u.then(function(){if(!h.oMetadataPromise){a=h.oSingleton.getLateQueryOptions()||{};t.aggregateExpandSelect(a,t.wrapChildQueryOptions("/"+h.oSingleton.sResourcePath,h.sRelativePath,{},h.oRequestor.getModelInterface().fetchMetadata));h.oSingleton.setLateQueryOptions(a)}h.oMetadataPromise=u;return h.oSingleton.fetchValue(e,h.sRelativePath,n,s,r)})};m.prototype.reset=function(){this.oSingleton.resetProperty(this.sRelativePath)};f.create=function(e,i,n,s,r,o){var a,u,h,c,l;if(o){h=i+e.buildQueryString(t.getMetaPath("/"+i),n,false,s);l=e.$mSharedCollectionCacheByPath;if(!l){l=e.$mSharedCollectionCacheByPath={}}c=l[h];if(c){c.setActive(true)}else{u=Object.keys(l);a=u.length;if(a>100){u.filter(function(e){return!l[e].iActiveUsages}).sort(function(e,t){return l[e].iInactiveSince-l[t].iInactiveSince}).every(function(e){delete l[e];a-=1;return a>100})}c=l[h]=new p(e,i,n,s,r,o)}return c}return new p(e,i,n,s,r)};f.createProperty=function(e,t,i){if(t.includes("(")||t.endsWith("/$count")){return new g(e,t,i)}return new m(e,t,i)};f.createSingle=function(e,t,i,n,s,r,o,a){return new P(e,t,i,n,s,r,o,a)};f.from$skip=function(e,t){return c.test(e)?(t.$created||0)+Number(e):e};f.getElementIndex=function(e,i,n){var s=e[n];if(!s||t.getPrivateAnnotation(s,"predicate")!==i){n=e.indexOf(e.$byPredicate[i])}return n};return f},false);
//# sourceMappingURL=_Cache.js.map