/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/Log","sap/base/util/each","sap/base/util/extend","sap/base/util/isEmptyObject","sap/ui/core/format/NumberFormat","sap/ui/model/CompositeType","sap/ui/model/FormatException","sap/ui/model/ParseException","sap/ui/model/ValidateException"],function(t,e,r,i,o,s,a,n,u){"use strict";var p=s.extend("sap.ui.model.type.Currency",{constructor:function(t){s.apply(this,arguments);this.sName="Currency";this.bShowMeasure=!t||!("showMeasure"in t)||t.showMeasure;this.bShowNumber=!t||!("showNumber"in t)||t.showNumber;this.bUseRawValues=true}});p.prototype.formatValue=function(t,e){var r=t;if(t==undefined||t==null){return null}if(this.oInputFormat){r=this.oInputFormat.parse(t)}if(!Array.isArray(r)){throw new a("Cannot format currency: "+t+" has the wrong format")}if((r[0]==undefined||r[0]==null)&&this.bShowNumber){return null}switch(this.getPrimitiveType(e)){case"string":return this.oOutputFormat.format(r);default:throw new a("Don't know how to format currency to "+e)}};p.prototype.parseValue=function(t,e){var r;switch(this.getPrimitiveType(e)){case"string":r=this.oOutputFormat.parse(t);if(!Array.isArray(r)||this.bShowNumber&&isNaN(r[0])){throw this.getParseException()}break;default:throw new n("Don't know how to parse Currency from "+e)}if(this.oInputFormat){r=this.oInputFormat.format(r)}return r};p.prototype.validateValue=function(r){if(this.oConstraints){var i=sap.ui.getCore().getLibraryResourceBundle(),o=[],s=[],a=r,n;if(this.oInputFormat){a=this.oInputFormat.parse(r)}n=a[0];e(this.oConstraints,function(e,r){switch(e){case"minimum":if(n<r){o.push("minimum");s.push(i.getText("Currency.Minimum",[r]))}break;case"maximum":if(n>r){o.push("maximum");s.push(i.getText("Currency.Maximum",[r]))}break;default:t.warning("Unknown constraint '"+e+"': Value is not validated.",null,"sap.ui.model.type.Currency")}});if(o.length>0){throw new u(this.combineMessages(s),o)}}};p.prototype.setFormatOptions=function(t){this.oFormatOptions=Object.assign(t.style!=="short"&&t.style!=="long"?{preserveDecimals:true}:{},t);this._createFormats()};p.prototype._handleLocalizationChange=function(){this._createFormats()};p.prototype._createFormats=function(){var t=this.oFormatOptions.source;this.oOutputFormat=o.getCurrencyInstance(this.iScale>=0?r({},{maxFractionDigits:this.iScale},this.oFormatOptions):this.oFormatOptions);if(t){if(i(t)){t={groupingEnabled:false,groupingSeparator:",",decimalSeparator:"."}}this.oInputFormat=o.getCurrencyInstance(t)}};p.prototype.getParseException=function(){var t=sap.ui.getCore().getLibraryResourceBundle(),e;if(!this.bShowNumber){e=t.getText("Currency.InvalidMeasure")}else if(!this.bShowMeasure){e=t.getText("EnterNumber")}else{e=t.getText("Currency.Invalid")}return new n(e)};p.prototype.getPartsIgnoringMessages=function(){if(!this.bShowMeasure){return[1]}else if(!this.bShowNumber){return[0]}return[]};p.prototype.getPartsListeningToTypeChanges=function(){return this.bShowNumber?[0]:[]};p.prototype.processPartTypes=function(t){const e=this.iScale;const r=t[0];if(r?.isA("sap.ui.model.odata.type.Decimal")){this.iScale=r.oConstraints?.scale||0}if(e!==this.iScale){this._createFormats()}};return p});
//# sourceMappingURL=Currency.js.map