/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/strings/capitalize","sap/base/util/isPlainObject","sap/base/Log","sap/m/MessageBox","sap/m/MessageToast","sap/ui/thirdparty/jquery","sap/ui/base/ManagedObject","sap/ui/core/BusyIndicator","sap/ui/core/Lib","sap/ui/dt/DesignTime","sap/ui/dt/DOMUtil","sap/ui/dt/ElementUtil","sap/ui/dt/Overlay","sap/ui/dt/OverlayRegistry","sap/ui/dt/Util","sap/ui/events/KeyCodes","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/apply/api/FlexRuntimeInfoAPI","sap/ui/fl/initial/api/Version","sap/ui/fl/write/api/ContextBasedAdaptationsAPI","sap/ui/fl/write/api/ControlPersonalizationWriteAPI","sap/ui/fl/write/api/FeaturesAPI","sap/ui/fl/write/api/PersistenceWriteAPI","sap/ui/fl/write/api/ReloadInfoAPI","sap/ui/fl/write/api/VersionsAPI","sap/ui/fl/write/api/TranslationAPI","sap/ui/fl/Layer","sap/ui/fl/registry/Settings","sap/ui/fl/Utils","sap/ui/model/json/JSONModel","sap/ui/performance/Measurement","sap/ui/rta/appVariant/Feature","sap/ui/rta/command/BaseCommand","sap/ui/rta/command/LREPSerializer","sap/ui/rta/command/Stack","sap/ui/rta/service/index","sap/ui/rta/toolbar/Fiori","sap/ui/rta/toolbar/FioriLike","sap/ui/rta/toolbar/Personalization","sap/ui/rta/toolbar/Standalone","sap/ui/rta/util/changeVisualization/ChangeVisualization","sap/ui/rta/util/PluginManager","sap/ui/rta/util/PopupManager","sap/ui/rta/util/ReloadManager","sap/ui/rta/util/ServiceEventBus","sap/ui/rta/util/validateFlexEnabled","sap/ui/rta/Utils","sap/ui/Device"],function(e,t,i,n,a,jQuery,o,r,s,l,d,h,c,u,g,p,f,v,m,S,b,y,C,_,A,E,R,P,T,M,I,D,w,O,L,V,N,x,B,U,k,F,G,z,K,j,H,$){"use strict";var W="STARTING";var q="STARTED";var Y="STOPPED";var Z="FAILED";var J="SERVICE_STARTING";var Q="SERVICE_STARTED";var X="SERVICE_FAILED";var ee=o.extend("sap.ui.rta.RuntimeAuthoring",{metadata:{library:"sap.ui.rta",associations:{rootControl:{type:"sap.ui.base.ManagedObject"}},properties:{showToolbars:{type:"boolean",defaultValue:true},triggeredFromDialog:{type:"boolean",defaultValue:false},showWindowUnloadDialog:{type:"boolean",defaultValue:true},commandStack:{type:"any"},flexSettings:{type:"object",defaultValue:{layer:R.CUSTOMER,developerMode:true}},mode:{type:"string",defaultValue:"adaptation"},metadataScope:{type:"string",defaultValue:"default"}},events:{start:{parameters:{editablePluginsCount:{type:"int"}}},stop:{},failed:{parameters:{error:{type:"any"}}},selectionChange:{parameters:{selection:{type:"sap.ui.dt.Overlay[]"}}},modeChanged:{},undoRedoStackModified:{}}},_sAppTitle:null,_dependents:null,_sStatus:Y,_bNavigationModeWarningShown:false,constructor:function(...e){o.apply(this,e);this._dependents={};this._mServices={};this._mUShellServices={};this._pElementModified=Promise.resolve();this.addDependent(new F,"pluginManager");this.addDependent(new G,"popupManager");if(this.getShowToolbars()){this.getPopupManager().attachOpen(ne,this);this.getPopupManager().attachClose(ae,this);this.addDependent(new k,"changeVisualization")}if(window.parent!==window){this.startService("receiver")}this.startService("supportTools");this._loadUShellServicesPromise=T.getUShellServices(["URLParsing","AppLifeCycle","CrossApplicationNavigation"]).then(function(e){this._mUShellServices=e;z.setUShellServices(e)}.bind(this))}});ee.needsRestart=function(e){return z.needsAutomaticStart(e)};ee.enableRestart=function(e,t){z.enableAutomaticStart(e,t)};ee.disableRestart=function(e){z.disableAutomaticStart(e)};ee.willRTAStartAfterReload=function(e){return z.needsAutomaticStart(e||R.CUSTOMER)};ee.prototype.addDependent=function(t,i,n){n=typeof n==="undefined"?true:!!n;if(!(i in this._dependents)){if(i&&n){this[`get${e(i,0)}`]=this.getDependent.bind(this,i)}this._dependents[i||t.getId()]=t}else{throw g.createError("RuntimeAuthoring#addDependent",`Can't add dependency with same key '${i}'`,"sap.ui.rta")}};ee.prototype.getDependent=function(e){return this._dependents[e]};ee.prototype.getDependents=function(){return this._dependents};ee.prototype.removeDependent=function(e){delete this._dependents[e]};ee.prototype.setPlugins=function(e){if(this._sStatus!==Y){throw new Error("Cannot replace plugins: runtime authoring already started")}this.getPluginManager().setPlugins(e)};ee.prototype.getPlugins=function(){return this.getPluginManager&&this.getPluginManager()&&this.getPluginManager().getPlugins()};ee.prototype.getDefaultPlugins=function(){return this.getPluginManager().getDefaultPlugins(this.getFlexSettings())};ee.prototype.setFlexSettings=function(e){var t=new URLSearchParams(window.location.search);var i=t.get("sap-ui-layer");e=Object.assign({},this.getFlexSettings(),e);if(i){e.layer=i.toUpperCase()}if(e.scenario||e.baseId){var n=T.buildLrepRootNamespace(e.baseId,e.scenario,e.projectId);e.rootNamespace=n;e.namespace=`${n}changes/`}H.setRtaStyleClassName(e.layer);this.setProperty("flexSettings",e)};ee.prototype.getLayer=function(){return this.getFlexSettings().layer};ee.prototype.getRootControlInstance=function(){this._oRootControl||=h.getElementInstance(this.getRootControl());return this._oRootControl};ee.prototype._getTextResources=function(){return s.getResourceBundleFor("sap.ui.rta")};ee.prototype.start=function(){var e=ee.needsRestart(this.getLayer());var t;var n;if(this._sStatus===Y){this._sStatus=W;var a=this.getRootControlInstance();if(!a){n=new Error("Root control not found");i.error(n);return Promise.reject(n)}return this._loadUShellServicesPromise.then(Oe.bind(this)).then(Le.bind(this,e)).then(function(){return z.handleReloadOnStart({layer:this.getLayer(),selector:this.getRootControlInstance(),versioningEnabled:this._oVersionsModel.getProperty("/versioningEnabled"),developerMode:this.getFlexSettings().developerMode,adaptationId:this._oContextBasedAdaptationsModel.getProperty("/displayedAdaptation/id")})}.bind(this)).then(function(e){if(e){return Promise.reject("Reload triggered")}var i=C.getResetAndPublishInfoFromSession(this.getRootControlInstance());this.bInitialResetEnabled=!!i.isResetEnabled;this._oSerializer=new O({commandStack:this.getCommandStack(),rootControl:this.getRootControl()});this.getPluginManager().preparePlugins(this.getFlexSettings(),ke.bind(this),this.getCommandStack());var n=this.getPluginManager().getPluginList();t=new Promise(function(e,t){I.start("rta.dt.startup","Measurement of RTA: DesignTime start up");this._oDesignTime=new l({scope:this.getMetadataScope(),plugins:n});se(this.getRootControlInstance(),true);this._oDesignTime.addRootElement(this._oRootControl);c.getOverlayContainer().get(0).classList.add("sapUiRta");if(this.getLayer()===R.USER){c.getOverlayContainer().get(0).classList.add("sapUiRtaPersonalize")}else{document.body.classList.add("sapUiRtaMode")}this._oDesignTime.getSelectionManager().attachChange(function(e){this.fireSelectionChange({selection:e.getParameter("selection")})},this);this._oDesignTime.attachEventOnce("synced",function(){e();I.end("rta.dt.startup","Measurement of RTA: DesignTime start up")},this);this._oDesignTime.attachEventOnce("syncFailed",function(e){t(e.getParameter("error"))})}.bind(this));this._oldUnloadHandler=window.onbeforeunload;window.onbeforeunload=this._onUnload.bind(this);return undefined}.bind(this)).then(function(){if(this.getShowToolbars()){return de(this.getRootControlInstance(),this.getLayer(),this._oSerializer).then(Ve.bind(this))}return undefined}.bind(this)).then(ce.bind(this)).then(function(){c.getOverlayContainer().get(0).style.setProperty("--sap-ui-rta-scrollbar-scrollWidth",`${d.getScrollbarWidth()}px`);c.getOverlayContainer().get(0).style.setProperty("--sap-ui-rta-scrollbar-scrollWidthPlusTwo",`${d.getScrollbarWidth()+2}px`);return t}).then(function(){this.getPopupManager().setRta(this);if(this.getShowToolbars()){return this.getToolbar().show()}return undefined}.bind(this)).then(function(){if($.browser.name==="ff"){jQuery(document).on("contextmenu",le)}}).then(function(){this.fnKeyDown=pe.bind(this);jQuery(document).on("keydown",this.fnKeyDown);this.fnOnPersonalizationChangeCreation=oe.bind(this);b.attachChangeCreation(this.getRootControlInstance(),this.fnOnPersonalizationChangeCreation)}.bind(this)).then(ie).then(function(e){if(e){j(this)}this._sStatus=q;ee.disableRestart(this.getLayer());this.fireStart({editablePluginsCount:this.getPluginManager().getEditableOverlaysCount()})}.bind(this)).catch(function(e){if(e==="Reload triggered"){this.destroy()}else{this._sStatus=Z;this.fireFailed({error:e})}return Promise.reject(e)}.bind(this))}return Promise.reject("RuntimeAuthoring is already started")};function te(){var e=this._oVersionsModel.getProperty("/versioningEnabled");var t=e?"MSG_UNSAVED_DRAFT_CHANGES_ON_CLOSE":"MSG_UNSAVED_CHANGES_ON_CLOSE";var i=e?"BTN_UNSAVED_DRAFT_CHANGES_ON_CLOSE_SAVE":"BTN_UNSAVED_CHANGES_ON_CLOSE_SAVE";return H.showMessageBox("warning",t,{titleKey:"TIT_UNSAVED_CHANGES_ON_CLOSE",actionKeys:[i,"BTN_UNSAVED_CHANGES_ON_CLOSE_DONT_SAVE"],emphasizedActionKey:"BTN_UNSAVED_CHANGES_ON_CLOSE_SAVE",showCancel:true})}ee.prototype.stop=function(e,t){var i;var a;ue.call(this,"setBusy",true);return ge.call(this).then(function(){var t=this.getLayer();if(t!==R.USER&&!e&&this.canSave()){return te.call(this).then(function(e){if(e===n.Action.CANCEL){i=true;return Promise.reject()}if(e===this._getTextResources().getText("BTN_UNSAVED_CHANGES_ON_CLOSE_DONT_SAVE")){return this._oSerializer.clearCommandStack(true)}return undefined}.bind(this))}return undefined}.bind(this)).then(function(){if(t){return{}}return z.checkReloadOnExit({layer:this.getLayer(),selector:this.getRootControlInstance(),isDraftAvailable:this._oVersionsModel.getProperty("/draftAvailable"),versioningEnabled:this._oVersionsModel.getProperty("/versioningEnabled"),activeVersion:this._oVersionsModel.getProperty("/activeVersion"),changesNeedReloadPromise:this._bSavedChangesNeedReload?Promise.resolve(true):this._oSerializer.needsReload()})}.bind(this)).then(function(t){a=t;if(!e){return this._serializeToLrep(false,true)}return undefined}.bind(this)).then(function(){ue.call(this,"hide",e);this.fireStop();if(!t){z.handleUrlParametersOnExit(a)}A.clearInstances()}.bind(this)).catch(function(e){if(!i){return he(e)}return undefined}).then(function(){ue.call(this,"setBusy",false);if(!i){this._sStatus=Y;document.body.classList.remove("sapUiRtaMode")}}.bind(this))};ee.prototype.setCommandStack=function(e){var t=this.getProperty("commandStack");if(t){t.detachModified(ce,this)}if(this._oInternalCommandStack){this._oInternalCommandStack.destroy();delete this._oInternalCommandStack}var i=this.setProperty("commandStack",e);if(e){e.attachModified(ce,this)}if(this.getPluginManager&&this.getPluginManager()){this.getPluginManager().provideCommandStack("settings",e)}return i};ee.prototype.getCommandStack=function(){var e=this.getProperty("commandStack");if(!e){e=new L;this._oInternalCommandStack=e;this.setCommandStack(e)}return e};ee.prototype.setMode=function(e){var t=this.getMode();if(t!==e){var i=this.getPluginManager().getPlugin("tabHandling");var n=this.getPluginManager().getPlugin("selection");if(t==="navigation"||e==="navigation"){this._oDesignTime.setEnabled(e!=="navigation");i[e==="navigation"?"restoreTabIndex":"removeTabIndex"]()}var a=this.getChangeVisualization&&this.getChangeVisualization();if(e==="visualization"||t==="visualization"){g.waitForSynced(this._oDesignTime)().then(function(){return a.triggerModeChange(this.getRootControl(),this.getToolbar())}.bind(this))}if(t==="adaptation"){this.getPluginManager().handleStopCutPaste()}i[e==="adaptation"?"restoreOverlayTabIndex":"removeOverlayTabIndex"]();n.setIsActive(!(e==="visualization"));c.getOverlayContainer().toggleClass("sapUiRtaVisualizationMode",e==="visualization");if(e==="visualization"){document.querySelectorAll(".sapUiDtOverlayMovable").forEach(function(e){e.style.cursor="default"})}else{document.querySelectorAll(".sapUiDtOverlayMovable").forEach(function(e){e.style.cursor="move"})}this._oToolbarControlsModel.setProperty("/modeSwitcher",e);this.setProperty("mode",e);this.fireModeChanged({mode:e})}};ee.prototype.setMetadataScope=function(e){if(this._sStatus!==Y){i.error("sap.ui.rta: Failed to set metadata scope on RTA instance after RTA is started");return}this.setProperty("metadataScope",e)};ee.prototype.destroy=function(...e){var t=Object.keys(this._dependents);t.forEach(function(e){this._dependents[e].destroy(true);this.removeDependent(e)}.bind(this));Object.keys(this._mServices).forEach(function(e){this.stopService(e)},this);if(this._oDesignTime){this._oDesignTime.destroy();this._oDesignTime=null;jQuery(document).off("keydown",this.fnKeyDown);if(this.fnOnPersonalizationChangeCreation){b.detachChangeCreation(this.getRootControlInstance(),this.fnOnPersonalizationChangeCreation)}}if(this.getRootControlInstance()){se(this.getRootControlInstance(),false)}this.setCommandStack(null);if(this._oServiceEventBus){this._oServiceEventBus.destroy()}if($.browser.name==="ff"){jQuery(document).off("contextmenu",le)}window.onbeforeunload=this._oldUnloadHandler;o.prototype.destroy.apply(this,e)};ee.prototype.getSelection=function(){if(this._oDesignTime){return this._oDesignTime.getSelectionManager().get()}return[]};ee.prototype.restore=function(){var e=this.getLayer();var t=e===R.USER?"FORM_PERS_RESET_MESSAGE_PERSONALIZATION":"FORM_PERS_RESET_MESSAGE";var i=e===R.USER?"BTN_RESTORE":"FORM_PERS_RESET_TITLE";this.getPluginManager().handleStopCutPaste();return H.showMessageBox("warning",t,{titleKey:i,actions:[n.Action.OK,n.Action.CANCEL],emphasizedAction:n.Action.OK}).then(function(t){if(t===n.Action.OK){ee.enableRestart(e,this.getRootControlInstance());return Ne.call(this)}return undefined}.bind(this))};ee.prototype.undo=function(){this.getPluginManager().handleStopCutPaste();return this.getCommandStack().undo()};ee.prototype.redo=function(){this.getPluginManager().handleStopCutPaste();return this.getCommandStack().redo()};ee.prototype.canUndo=function(){return this.getCommandStack().canUndo()};ee.prototype.canSave=function(){return this.getCommandStack().canSave()};ee.prototype.canRedo=function(){return this.getCommandStack().canRedo()};ee.prototype.save=function(){return ge.call(this).then(this._serializeToLrep.bind(this))};ee.prototype._serializeToLrep=function(e,t){if(!this._bSavedChangesNeedReload){return this._oSerializer.needsReload().then(function(i){this._bSavedChangesNeedReload=i;return ve.call(this,undefined,e,t)}.bind(this))}return ve.call(this,undefined,e,t)};ee.prototype.condenseAndSaveChanges=function(...e){return this._serializeToLrep(...e)};ee.prototype._onUnload=function(){if(this.canSave()&&this.getShowWindowUnloadDialog()){return this._getTextResources().getText("MSG_UNSAVED_CHANGES")}window.onbeforeunload=this._oldUnloadHandler;return undefined};function ie(){var e=new URLSearchParams(window.location.search).get("sap-ui-rta-skip-flex-validation");return P.getInstance().then(function(t){return!t.isCustomerSystem()&&e!=="true"})}function ne(e){var t=e.getParameters().getSource();if(t.isA("sap.m.Dialog")&&this.getToolbar().type==="fiori"){this.getToolbar().setColor("contrast")}this.getToolbar().bringToFront()}function ae(e){if(e.getParameters().isA("sap.m.Dialog")){this.getToolbar().setColor()}}function oe(){if(this.getMode()==="navigation"&&!this._bNavigationModeWarningShown){re.call(this,"MSG_NAVIGATION_MODE_CHANGES_WARNING",{duration:5e3});this._bNavigationModeWarningShown=true}}function re(e,t){var i=this._getTextResources().getText(e);a.show(i,t||{})}function se(e,t){if(e.isA("sap.ui.core.UIComponent")){e=e.getRootControl()}if(e){e[t?"addStyleClass":"removeStyleClass"]("sapUiRtaRoot")}}function le(){return false}function de(e,t,i){return Promise.all([y.isPublishAvailable(),D.isSaveAsAvailable(e,t,i),y.isContextBasedAdaptationAvailable(t),T.getUShellService("AppLifeCycle").then(function(e){if(e){var t=e.getCurrentApplication();return t?t.homePage:false}return false})]).then(function(t){var i=t[0];var n=t[1];var a=t[2];var o=t[3];var r=T.getAppDescriptor(e);var s=r&&!f.getOvpEntry(r);return{publishAvailable:i,saveAsAvailable:!o&&i&&n,contextBasedAdaptationAvailable:!o&&s&&a}})}function he(e){r.hide();var t=e.userMessage||e.stack||e.message||e.status||e;var a=s.getResourceBundleFor("sap.ui.rta");i.error("Failed to transfer changes",t);var o=`${a.getText("MSG_LREP_TRANSFER_ERROR")}\n\t\t\t${a.getText("MSG_ERROR_REASON",[t])}`;n.error(o,{styleClass:H.getRtaStyleClassName()})}function ce(){var e=!this.getShowToolbars()||!this.getCommandStack().canUndo();H.checkDraftOverwrite(this._oVersionsModel,e).then(()=>{if(this.getShowToolbars()){var e=this.getCommandStack();var t=e.canUndo();var i=e.canRedo();var n=e.canSave();var a=e.getSaved();var o=this._oToolbarControlsModel.getProperty("/translation/visible")&&E.hasTranslationRelevantDirtyChanges({layer:R.CUSTOMER,selector:this.getRootControlInstance()});this._oVersionsModel.setDirtyChanges(C.hasDirtyChanges({selector:this.getRootControlInstance()}));this._oToolbarControlsModel.setProperty("/undo/enabled",t);this._oToolbarControlsModel.setProperty("/redo/enabled",i);this._oToolbarControlsModel.setProperty("/save/enabled",n);this._oToolbarControlsModel.setProperty("/restore/enabled",this.bInitialResetEnabled||n||a);this._oToolbarControlsModel.setProperty("/translation/enabled",this.bPersistedDataTranslatable||o)}this.fireUndoRedoStackModified()}).catch(()=>{this.undo()})}function ue(e,t){if(this.getShowToolbars()&&this.getToolbar&&this.getToolbar()){return this.getToolbar()[e](t)}return undefined}function ge(){return Promise.resolve(this._oDesignTime&&this._oDesignTime.waitForBusyPlugins()).then(function(){return this._pElementModified}.bind(this))}function pe(e){var t=$.os.macintosh;var i=c.getOverlayContainer().get(0).contains(document.activeElement);var n=this.getShowToolbars()&&this.getToolbar().getDomRef().contains(document.activeElement);var a=false;document.querySelectorAll(".sapUiDtContextMenu").forEach(function(e){if(e.contains(document.activeElement)){a=true}});var o=document.body===document.activeElement;var r=d.getParents(document.activeElement,".sapUiRtaEditableField").length>0;if((i||n||a||o)&&!r){var s=t?e.metaKey:e.ctrlKey;if(e.keyCode===p.Z&&e.shiftKey===false&&e.altKey===false&&s===true){this.undo().then(e.stopPropagation.bind(e))}else if((t&&e.keyCode===p.Z&&e.shiftKey===true||!t&&e.keyCode===p.Y&&e.shiftKey===false)&&e.altKey===false&&s===true){this.redo().then(e.stopPropagation.bind(e))}}}function fe(e){var t=e.getParameter("callback")||function(){};var i=this._oVersionsModel.getProperty("/versioningEnabled");return this.save().then(function(){re.call(this,i?"MSG_SAVE_DRAFT_SUCCESS":"MSG_SAVE_SUCCESS",{duration:5e3})}.bind(this)).catch(function(e){return he(e)}).then(t)}function ve(e,t,i){if(this.getShowToolbars()){this.bPersistedDataTranslatable=this._oToolbarControlsModel.getProperty("/translation/enabled")}var n={layer:this.getLayer(),removeOtherLayerChanges:true,condenseAnyLayer:t};if(this._oVersionsModel.getProperty("/versioningEnabled")){var a=e?this._oVersionsModel.getProperty("/displayedVersion"):undefined;a||=i?undefined:m.Number.Draft;n.version=a;n.saveAsDraft=this.getLayer()===R.CUSTOMER}if(this._oContextBasedAdaptationsModel.getProperty("/contextBasedAdaptationsEnabled")){n.adaptationId=i?undefined:this._oContextBasedAdaptationsModel.getProperty("/displayedAdaptation/id")}return this._oSerializer.saveCommands(n).then(function(){if(!i){var e=this.getToolbar();var t=this.getChangeVisualization();t.updateAfterSave(e)}}.bind(this))}function me(e){var t=e.getParameter("versionTitle");if(De.call(this)&&we.call(this)){return H.showMessageBox("warning","MSG_DRAFT_DISCARD_ON_REACTIVATE_DIALOG",{titleKey:"TIT_DRAFT_DISCARD_ON_REACTIVATE_DIALOG",actions:[n.Action.OK,n.Action.CANCEL],emphasizedAction:n.Action.OK}).then(function(e){if(e===n.Action.OK){return Se.call(this,t)}return undefined}.bind(this))}return Se.call(this,t)}function Se(e){var t=this.getLayer();var i=this.getRootControlInstance();var n=this._oVersionsModel.getProperty("/displayedVersion");return ve.call(this,true).then(function(){return A.activate({layer:t,control:i,title:e,displayedVersion:n})}).then(function(){re.call(this,"MSG_DRAFT_ACTIVATION_SUCCESS");this.bInitialResetEnabled=true;this._oToolbarControlsModel.setProperty("/restore/enabled",true);this.getCommandStack().removeAllCommands()}.bind(this)).catch(function(e){H.showMessageBox("error","MSG_DRAFT_ACTIVATION_FAILED",{error:e})})}function be(){return H.showMessageBox("warning","MSG_DRAFT_DISCARD_DIALOG",{actions:[n.Action.OK,n.Action.CANCEL],emphasizedAction:n.Action.OK}).then(function(e){if(e===n.Action.OK){return A.discardDraft({layer:this.getLayer(),control:this.getRootControlInstance(),updateState:true}).then(ye.bind(this))}return undefined}.bind(this))}function ye(){var e=this.getLayer();var t={layer:e,removeDraft:true,selector:this.getRootControlInstance()};ee.enableRestart(e,this.getRootControlInstance());this.getCommandStack().removeAllCommands();z.triggerReload(t);return this.stop(true,true)}function Ce(){if(this.canSave()){_e.call(this,"DAC_DATA_LOSS_DIALOG_DESCRIPTION","DAC_DIALOG_HEADER",true)}else{_e.call(this,"DAC_DIALOG_DESCRIPTION","DAC_DIALOG_HEADER")}}function _e(e,t,i){H.showMessageBox("confirm",e,{titleKey:t}).then(function(e){if(e===n.Action.OK){r.show();if(i){this.getCommandStack().removeAllCommands(true)}Ae.call(this)}}.bind(this))}function Ae(){I.start("onCBADeleteAdaptation","Measurement of deleting a context-based adaptation");S.remove({control:this.getRootControlInstance(),layer:this.getLayer(),adaptationId:this._oContextBasedAdaptationsModel.getProperty("/displayedAdaptation/id")}).then(function(){r.hide();var e=this._oContextBasedAdaptationsModel.deleteAdaptation();Pe.call(this,e);I.end("onCBADeleteAdaptation");if(I.getActive()){i.info(`onCBADeleteAdaptation: ${I.getMeasurement("onCBADeleteAdaptation").time} ms`)}}.bind(this)).catch(function(e){r.hide();i.error(e.stack);var t="MSG_LREP_TRANSFER_ERROR";var n={titleKey:"DAC_DIALOG_HEADER"};n.details=e.userMessage;H.showMessageBox("error",t,n)})}function Ee(e,t,i){if(this.canSave()){H.showMessageBox("warning",e,{titleKey:t,actions:[n.Action.YES,n.Action.NO,n.Action.CANCEL],emphasizedAction:n.Action.YES}).then(function(e){if(e===n.Action.YES){return this._serializeToLrep().then(i)}else if(e===n.Action.NO){this.getCommandStack().removeAllCommands(true);return i()}return Promise.resolve()}.bind(this));return Promise.resolve()}return i()}function Re(e){I.start("onCBASwitchAdaptation","Measurement of switching a context-based adaptation");var t=e.getParameter("callback")||function(){};if(e.getParameter("trigger")==="SaveAs"){this.getCommandStack().removeAllCommands(true)}var n=e.getParameter("adaptationId");this._sSwitchToAdaptationId=n;return Ee.call(this,"MSG_SWITCH_VERSION_DIALOG","BTN_SWITCH_ADAPTATIONS",Pe.bind(this,this._sSwitchToAdaptationId)).then(function(){t();I.end("onCBASwitchAdaptation");if(I.getActive()){i.info(`onCBASwitchAdaptation: ${I.getMeasurement("onCBASwitchAdaptation").time} ms`)}}).catch(function(e){H.showMessageBox("error","MSG_SWITCH_ADAPTATION_FAILED",{error:e});i.error(`sap.ui.rta: ${e.stack||e.message||e}`)})}function Pe(e){var t=this._oVersionsModel.getProperty("/displayedVersion");return Me.call(this,t,e)}function Te(e){var t=e.getParameter("callback")||function(){};var n=e.getParameter("version");var a=this._oVersionsModel.getProperty("/displayedVersion");if(n===a){return}this._sSwitchToVersion=n;Ee.call(this,"MSG_SWITCH_VERSION_DIALOG","TIT_SWITCH_VERSION_DIALOG",Me.bind(this,this._sSwitchToVersion)).then(t).catch(function(e){H.showMessageBox("error","MSG_SWITCH_VERSION_FAILED",{error:e});i.error(`sap.ui.rta: ${e.stack||e.message||e}`)})}function Me(e,t){ee.enableRestart(this.getLayer(),this.getRootControlInstance());return A.loadVersionForApplication({control:this.getRootControlInstance(),layer:this.getLayer(),version:e,adaptationId:t}).then(function(){var t={versionSwitch:true,version:e,selector:this.getRootControlInstance()};z.triggerReload(t)}.bind(this))}function Ie(){this.getPluginManager().handleStopCutPaste();return A.publish({selector:this.getRootControlInstance(),styleClass:H.getRtaStyleClassName(),layer:this.getLayer(),version:this._oVersionsModel.getProperty("/displayedVersion")}).then(function(e){if(e!=="Error"&&e!=="Cancel"){a.show(e)}})}function De(){return A.isOldVersionDisplayed({control:this.getRootControlInstance(),layer:this.getLayer()})}function we(){return A.isDraftAvailable({control:this.getRootControlInstance(),layer:this.getLayer()})}function Oe(){return A.initialize({control:this.getRootControlInstance(),layer:this.getLayer()}).then(function(e){this._oVersionsModel=e}.bind(this))}function Le(e){if(!e){S.clearInstances()}return S.initialize({control:this.getRootControlInstance(),layer:this.getLayer()}).then(function(e){this._oContextBasedAdaptationsModel=e}.bind(this))}function Ve(e){if(!this.getDependent("toolbar")){var t=this.getLayer()===R.USER;var i={rtaInformation:{flexSettings:this.getFlexSettings(),rootControl:this.getRootControlInstance(),commandStack:this.getCommandStack()},textResources:this._getTextResources(),restore:this.restore.bind(this),exit:this.stop.bind(this,false,t)};if(!t){i.publishVersion=Ie.bind(this);i.undo=this.undo.bind(this);i.redo=this.redo.bind(this);i.modeChange=Fe.bind(this);i.activate=me.bind(this);i.discardDraft=be.bind(this);i.switchVersion=Te.bind(this);i.switchAdaptation=Re.bind(this);i.deleteAdaptation=Ce.bind(this);i.openChangeCategorySelectionPopover=this.getChangeVisualization?this.getChangeVisualization().openChangeCategorySelectionPopover.bind(this.getChangeVisualization()):function(){};i.save=fe.bind(this)}var n;if(t){n=new B(i)}else if(H.isOriginalFioriToolbarAccessible()){n=new N(i)}else if(H.getFiori2Renderer()){n=new x(i)}else{n=new U(i)}this.addDependent(n,"toolbar");return Promise.all([n.onFragmentLoaded(),y.isKeyUserTranslationEnabled(this.getLayer())]).then(function(t){var i=t[1];var n=e.saveAsAvailable;var a=n&&D.isOverviewExtended();var o=new URLSearchParams(window.location.search);var r;r=!o.has("fiori-tools-rta-mode")||o.get("fiori-tools-rta-mode")==="false";var s=v.getConfiguredFlexServices().some(function(e){return e.connector!=="LocalStorageConnector"});this.bPersistedDataTranslatable=false;this._oToolbarControlsModel=new M({modeSwitcher:this.getMode(),undo:{enabled:false},redo:{enabled:false},save:{enabled:false},translation:{visible:i,enabled:this.bPersistedDataTranslatable},appVariantMenu:{visible:n,enabled:n,overview:{visible:n&&a,enabled:n&&a},manageApps:{visible:n&&!a,enabled:n&&!a},saveAs:{visible:n,enabled:n}},restore:{visible:!this._oVersionsModel.getProperty("/versioningEnabled"),enabled:this.bInitialResetEnabled},contextBasedAdaptation:{visible:e.contextBasedAdaptationAvailable,enabled:e.contextBasedAdaptationAvailable},actionsMenuButton:{enabled:true},visualizationButton:{visible:r,enabled:r},feedbackButton:{visible:s}});this._oVersionsModel.setProperty("/publishVersionVisible",e.publishAvailable);var l=new Promise(function(e){if(!i){e();return}E.getSourceLanguages({selector:this.getRootControlInstance(),layer:this.getLayer()}).then(function(e){this.bPersistedDataTranslatable=e.length>0;this._oToolbarControlsModel.setProperty("/translation/enabled",this.bPersistedDataTranslatable)}.bind(this)).finally(e)}.bind(this));var d=new Promise(function(e){if(!n){e();return}D.isManifestSupported().then(function(e){if(T.isVariantByStartupParameter(this.getRootControlInstance())){e=false}this._oToolbarControlsModel.setProperty("/appVariantMenu/saveAs/enabled",e);this._oToolbarControlsModel.setProperty("/appVariantMenu/overview/enabled",e);this._oToolbarControlsModel.setProperty("/appVariantMenu/manageApps/enabled",e)}.bind(this)).finally(e)}.bind(this));this.getToolbar().setModel(this._oVersionsModel,"versions");this.getToolbar().setModel(this._oContextBasedAdaptationsModel,"contextBasedAdaptations");this.getToolbar().setModel(this._oToolbarControlsModel,"controls");return Promise.all([l,d])}.bind(this))}return Promise.resolve()}function Ne(){var e=this.getLayer();var t=T.getAppComponentForControl(this.getRootControlInstance());return C.reset({selector:t,layer:e}).then(function(){this.getCommandStack().removeAllCommands(true);_.removeInfoSessionStorage(t);var i={layer:e,ignoreMaxLayerParameter:true,triggerHardReload:true};return z.triggerReload(i)}.bind(this)).catch(function(e){if(e!=="cancel"){H.showMessageBox("error","MSG_RESTORE_FAILED",{error:e})}})}function xe(e,t){function i(n){var a=n.getParameter("elementOverlay");if(a.getElement().getId()===e){this._oDesignTime.detachEvent("elementOverlayCreated",i,this);t(a)}}this._oDesignTime.attachEvent("elementOverlayCreated",i,this)}function Be(e,t){function i(e){var n=e.getSource();if(n.getGeometry()&&n.getGeometry().visible){n.detachEvent("geometryChanged",i);t(n)}}function n(e){if(!e.getGeometry()||!e.getGeometry().visible){e.attachEvent("geometryChanged",i)}else{t(e)}}xe.call(this,e,function(e){if(e.isRendered()){n(e)}else{e.attachEventOnce("afterRendering",function(e){n(e.getSource())})}})}function Ue(e,t,i){var n=function(e){e.setSelected(true);this.getPluginManager().getPlugin("rename").startEdit(e)}.bind(this);Be.call(this,t,function(t){var a=this.getPluginManager().getPlugin("createContainer").getCreatedContainerId(e,t.getElement().getId());var o=u.getOverlay(a);if(o){if(i){this.getPluginManager().getPlugin("rename").createRenameCommand(o,i).then(function(){this.getCommandStack().compositeLastTwoCommands()}.bind(this))}else{n(o)}}else{Be.call(this,a,n)}}.bind(this))}function ke(e){var t=e.getParameter("command");var n=e.getParameter("newControlId");var a=e.getParameter("action");var o=e.getParameter("title");this._pElementModified=this._pElementModified.then(function(){this.getPluginManager().handleStopCutPaste();if(t instanceof w){if(n){xe.call(this,n,function(e){var t=e.getDesignTimeMetadata();var i=t.getData().select;if(typeof i==="function"){i(e.getElement())}});if(a){Ue.call(this,a,n,o)}}return this.getCommandStack().pushAndExecute(t).catch(function(e){if(e?.message?.indexOf?.("The following Change cannot be applied because of a dependency")>-1){H.showMessageBox("error","MSG_DEPENDENCY_ERROR",{error:e})}i.error("sap.ui.rta:",e.message,e.stack)})}return undefined}.bind(this));return this._pElementModified}function Fe(e){this.setMode(e.getParameter("item").getKey())}function Ge(e){if(V.hasOwnProperty(e)){return V[e].replace(/\./g,"/")}return undefined}ee.prototype.startService=function(e){if(this._sStatus!==q){return new Promise(function(e,t){this.attachEventOnce("start",e);this.attachEventOnce("failed",t)}.bind(this)).then(function(){return this.startService(e)}.bind(this),function(){return Promise.reject(g.createError("RuntimeAuthoring#startService",`Can't start the service '${e}' because RTA startup failed`,"sap.ui.rta"))})}var i=Ge(e);var n;if(!i){return Promise.reject(g.createError("RuntimeAuthoring#startService",`Unknown service. Can't find any registered service by name '${e}'`,"sap.ui.rta"))}n=this._mServices[e];if(n){switch(n.status){case Q:{return Promise.resolve(n.exports)}case J:{return n.initPromise}case X:{return n.initPromise}default:{return Promise.reject(g.createError("RuntimeAuthoring#startService",`Unknown service status. Service name = '${e}'`,"sap.ui.rta"))}}}else{this._mServices[e]=n={};n.status=J;n.location=i;n.initPromise=new Promise(function(a,o){sap.ui.require([i],function(i){n.factory=i;this._oServiceEventBus||=new K;g.wrapIntoPromise(i)(this,this._oServiceEventBus.publish.bind(this._oServiceEventBus,e)).then(function(i){if(this.bIsDestroyed){throw g.createError("RuntimeAuthoring#startService",`RuntimeAuthoring instance is destroyed while initializing the service '${e}'`,"sap.ui.rta")}if(!t(i)){throw g.createError("RuntimeAuthoring#startService",`Invalid service format. Service should return simple javascript object after initialization. Service name = '${e}'`,"sap.ui.rta")}n.service=i;n.exports={};if(Array.isArray(i.events)&&i.events.length>0){Object.assign(n.exports,{attachEvent:this._oServiceEventBus.subscribe.bind(this._oServiceEventBus,e),detachEvent:this._oServiceEventBus.unsubscribe.bind(this._oServiceEventBus,e),attachEventOnce:this._oServiceEventBus.subscribeOnce.bind(this._oServiceEventBus,e)})}var o=i.exports||{};Object.assign(n.exports,Object.keys(o).reduce(function(e,t){var i=o[t];e[t]=typeof i==="function"?g.waitForSynced(this._oDesignTime,i):i;return e}.bind(this),{}));n.status=Q;a(Object.freeze(n.exports))}.bind(this)).catch(o)}.bind(this),function(t){n.status=X;o(g.propagateError(t,"RuntimeAuthoring#startService",`Can't load service '${e}' by its name: ${i}`,"sap.ui.rta"))})}.bind(this)).catch(function(t){n.status=X;return Promise.reject(g.propagateError(t,"RuntimeAuthoring#startService",`Error initializing service '${e}'`,"sap.ui.rta"))});return n.initPromise}};ee.prototype.stopService=function(e){var t=this._mServices[e];if(t){if(t.status===Q){if(typeof t.service.destroy==="function"){t.service.destroy()}}delete this._mServices[e]}else{throw g.createError("RuntimeAuthoring#stopService",`Can't destroy service: unable to find service with name '${e}'`,"sap.ui.rta")}};ee.prototype.getService=function(e){return this.startService(e)};return ee});
//# sourceMappingURL=RuntimeAuthoring.js.map