/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Lib","sap/ui/dt/plugin/CutPaste","sap/ui/dt/Util","sap/ui/rta/plugin/Plugin","sap/ui/rta/plugin/RTAElementMover","sap/ui/rta/Utils"],function(t,e,i,n,r,a){"use strict";var o=e.extend("sap.ui.rta.plugin.CutPaste",{metadata:{library:"sap.ui.rta",properties:{commandFactory:{type:"object",multiple:false}},events:{dragStarted:{},elementModified:{command:{type:"sap.ui.rta.command.BaseCommand"}}}}});a.extendWith(o.prototype,n.prototype,function(t,e,i){return i!=="getMetadata"});o.prototype.init=function(...t){e.prototype.init.apply(this,t);this.setElementMover(new r({commandFactory:this.getCommandFactory()}))};o.prototype._isEditable=function(t,e){return this.getElementMover().isEditable(t,e.onRegistration).then(function(e){if(e){return true}return this._isPasteEditable(t)}.bind(this))};o.prototype._isPasteEditable=function(t){var e=this.getElementMover();if(!this.hasStableId(t)){return Promise.resolve(false)}return e.isMoveAvailableOnRelevantContainer(t).then(function(i){if(!i){return false}return a.doIfAllControlsAreAvailable([t],function(){return e.isMoveAvailableForChildren(t)})})};o.prototype.isAvailable=function(t){return t.every(function(t){return t.getMovable()})};o.prototype.registerElementOverlay=function(...t){e.prototype.registerElementOverlay.apply(this,t);n.prototype.registerElementOverlay.apply(this,t)};o.prototype.deregisterElementOverlay=function(...t){e.prototype.deregisterElementOverlay.apply(this,t);n.prototype.removeFromPluginsList.apply(this,t)};o.prototype.paste=function(t){this._executePaste(t);i.waitForSynced(this.getDesignTime())().then(function(){return this.getElementMover().buildMoveCommand()}.bind(this)).then(function(t){this.fireElementModified({command:t});this.stopCutAndPaste()}.bind(this)).catch(function(t){throw i.createError("CutPaste#paste",t,"sap.ui.rta")})};o.prototype.cut=function(...t){const[i]=t;return e.prototype.cut.apply(this,t).then(function(){i.setSelected(false)})};o.prototype.getMenuItems=function(e){var i=[];var n=this.enhanceItemWithResponsibleElement({id:"CTX_PASTE",text:t.getResourceBundleFor("sap.ui.rta").getText("CTX_PASTE"),handler:function(t){return this.paste(t[0])}.bind(this),enabled:function(t){return this.isElementPasteable(t[0])}.bind(this),rank:80,icon:"sap-icon://paste"},e,["move"]);var r=n.responsible||e;if(this.isAvailable(r)){var a=this.enhanceItemWithResponsibleElement({id:"CTX_CUT",text:t.getResourceBundleFor("sap.ui.rta").getText("CTX_CUT"),handler:function(t){return this.cut(t[0])}.bind(this),enabled(t){return t.length===1},rank:70,icon:"sap-icon://scissors"},e,["move"]);i.push(a,n);return i}return this._isPasteEditable(e[0]).then(function(t){if(t){i.push(n)}return i})};return o});
//# sourceMappingURL=CutPaste.js.map