/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/util/restricted/_debounce","sap/ui/dt/Plugin","sap/ui/fl/write/api/ChangesWriteAPI","sap/ui/dt/OverlayRegistry","sap/ui/dt/OverlayUtil","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/rta/util/hasStableId"],function(e,t,i,n,a,r,s){"use strict";function l(e,t,i){var n=i;if(typeof this.getActionName()==="string"){if(this.isResponsibleElementActionAvailable(i)){n=this.getResponsibleElementOverlay(i)}}var a=n.getElement()&&n.getDesignTimeMetadata()&&!n.getDesignTimeMetadata().markedAsNotAdaptable()&&this._isEditable(n,Object.assign({sourceElementOverlay:i},e));if(a&&typeof a.then==="function"){a.then(function(e){this._handleModifyPluginList(i,e)}.bind(this));t.push(a)}else{this._handleModifyPluginList(i,a)}return t}var o=t.extend("sap.ui.rta.plugin.Plugin",{metadata:{abstract:true,library:"sap.ui.rta",properties:{commandFactory:{type:"object",multiple:false}},events:{elementModified:{command:{type:"sap.ui.rta.command.BaseCommand"}}}}});o.prototype._isEditable=function(){};o.prototype.executeWhenVisible=function(e,t){var i=function(n){if(n.getSource().getGeometry()&&n.getSource().getGeometry().visible){e.detachEvent("geometryChanged",i,this);t()}};var n=e.getGeometry();if(e.getElementVisibility()&&(!n||!n.visible)){e.attachEvent("geometryChanged",i,this)}else{t()}};function u(t,i,n,a){var r=i.getId();t[r]||={};t[r][n]||=e(a,16);t[r][n]()}var g=function(e){if(!this._mDebounceFunctions){this._mDebounceFunctions={insertOrRemove:{},addOrSet:{}}}var t=e.getParameters();var i;var n=e.getSource();if(t.type==="propertyChanged"&&t.name==="visible"){i=this._getRelevantOverlays(n);if(t.value===true){this.executeWhenVisible(n,function(){this.evaluateEditable(i,{onRegistration:false})}.bind(this))}else{this.evaluateEditable(i,{onRegistration:false})}}else if(t.type==="afterRendering"){if(this.getDesignTime().getStatus()==="synced"){this.evaluateEditable([n],{onRegistration:false})}else{this.getDesignTime().attachEventOnce("synced",function(){this.evaluateEditable([n],{onRegistration:false})},this)}}else if(t.type==="insertAggregation"||t.type==="removeAggregation"){u(this._mDebounceFunctions.insertOrRemove,n,t.name,function(){i=this._getRelevantOverlays(n,t.name);this.evaluateEditable(i,{onRegistration:false})}.bind(this))}else if(t.type==="addOrSetAggregation"){u(this._mDebounceFunctions.addOrSet,n,t.name,function(){var e=this.getDesignTime();if(!e){return}if(e.getStatus()==="synced"){i=this._getRelevantOverlays(n,t.name);this.evaluateEditable(i,{onRegistration:false})}else{e.attachEventOnce("synced",function(){i=this._getRelevantOverlays(n,t.name);this.evaluateEditable(i,{onRegistration:false})},this)}}.bind(this))}};o.prototype._getRelevantOverlays=function(e,t){var i=e.getRelevantOverlays();if(i.length===0){var n=[];if(!e.getIsPartOfTemplate()){n=a.findAllOverlaysInContainer(e);if(t){var r=e.getAggregationOverlay(t);var s=r?r.getChildren():[];s=s.filter(function(e){return n.indexOf(e)===-1});n=n.concat(s)}}e.setRelevantOverlays(n);return n}return i};o.prototype.evaluateEditable=function(e,t){if(!t.onRegistration&&this.getDesignTime()&&this.getDesignTime().getBusyPlugins().length){return}this.setProcessingStatus(true);var i=e.reduce(l.bind(this,t),[]);if(i.length){Promise.all(i).then(function(){this.setProcessingStatus(false)}.bind(this)).catch(function(){this.setProcessingStatus(false)}.bind(this))}else{this.setProcessingStatus(false)}};o.prototype._handleModifyPluginList=function(e,t){if(t!==undefined&&t!==null){if(typeof t==="boolean"){this._modifyPluginList(e,t)}else{this._modifyPluginList(e,t.asChild,false);this._modifyPluginList(e,t.asSibling,true)}}};o.prototype._modifyPluginList=function(e,t,i){if(t){this.addToPluginsList(e,i)}else{this.removeFromPluginsList(e,i)}};o.prototype._retrievePluginName=function(e){var t=this.getMetadata().getName();if(e!==undefined){t+=e?".asSibling":".asChild"}return t};o.prototype._isEditableByPlugin=function(e,t){var i=this._retrievePluginName(t);var n=e.getEditableByPlugins();return n.indexOf(i)>-1};o.prototype.registerElementOverlay=function(e){this.executeWhenVisible(e,function(){this.evaluateEditable([e],{onRegistration:true});e.attachElementModified(g,this)}.bind(this))};o.prototype.deregisterElementOverlay=function(e){this.removeFromPluginsList(e);this.removeFromPluginsList(e,true);this.removeFromPluginsList(e,false);e.detachElementModified(g,this)};o.prototype.hasStableId=function(e){return s(e)};o.prototype.getVariantManagementReference=function(e){var t;if(e.getVariantManagement){t=e.getVariantManagement()}return t};o.prototype.checkAggregationsOnSelf=function(e,t,i,a){var r=e.getDesignTimeMetadata();var s=e.getElement();var l=r.getActionDataFromAggregations(t,s,undefined,a);var o=l.filter(function(e){if(e&&i){return e.aggregation===i}return true})[0];var u=o?o.changeType:null;var g=o&&o.changeOnRelevantContainer;if(g){s=e.getRelevantContainer();var h=n.getOverlay(s);if(!this.hasStableId(h)){return Promise.resolve(false)}}if(u){return this.hasChangeHandler(u,s)}return Promise.resolve(false)};o.prototype.removeFromPluginsList=function(e,t){var i=this._retrievePluginName(t);e.removeEditableByPlugin(i);if(!e.getEditableByPlugins().length){e.setEditable(false)}};o.prototype.addToPluginsList=function(e,t){var i=this._retrievePluginName(t);var n=e.getEditableByPlugins();if(n.indexOf(i)===-1){e.addEditableByPlugin(i);e.setEditable(true)}};o.prototype.hasChangeHandler=function(e,t,n){return i.getChangeHandler({changeType:e,element:t,modifier:r,layer:this.getCommandFactory().getFlexSettings().layer,controlType:n}).then(function(){return true}).catch(function(){return false})};o.prototype.isAvailable=function(e){return e.every(function(e){return this._isEditableByPlugin(e)},this)};o.prototype._checkRelevantContainerStableID=function(e,t){if(e.changeOnRelevantContainer){var i=t.getRelevantContainer();var a=n.getOverlay(i);if(!this.hasStableId(a)){return false}}return true};o.prototype._checkChangeHandlerAndStableId=function(e){var t=this.getAction(e);if(t&&t.changeType){var i=t.changeOnRelevantContainer?e.getRelevantContainer():e.getElement();return this.hasChangeHandler(t.changeType,i).then(function(i){return i&&this._checkRelevantContainerStableID(t,e)&&this.hasStableId(e)}.bind(this))}return Promise.resolve(false)};return o});
//# sourceMappingURL=Plugin.js.map