/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/ManagedObject","sap/ui/core/Element","sap/ui/core/Fragment","sap/ui/fl/write/api/FieldExtensibility","sap/ui/model/json/JSONModel","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/model/resource/ResourceModel","sap/ui/model/Sorter","sap/ui/rta/Utils"],function(e,t,i,o,s,n,l,r,a,u){"use strict";var d=e.extend("sap.ui.rta.plugin.additionalElements.AddElementsDialog",{metadata:{library:"sap.ui.rta",properties:{customFieldEnabled:{type:"boolean",defaultValue:false},businessContextVisible:{type:"boolean",defaultValue:false},title:{type:"string"}},events:{opened:{},openCustomField:{}}}});var p;d.prototype.init=function(){this._oDialogPromise=i.load({id:this.getId(),name:"sap.ui.rta.plugin.additionalElements.AddElementsDialog",controller:this});this._oDialogModel=new s({elements:[],customFieldEnabled:false,customFieldVisible:false,businessContextVisible:false,customFieldButtonTooltip:"",businessContextTexts:[{text:""}]});this._oDialogPromise.then(function(e){e.setModel(this._oDialogModel);p||=new r({bundleName:"sap.ui.rta.messagebundle"});e.setModel(p,"i18n");e.addStyleClass(u.getRtaStyleClassName());this._oDialogModel.setProperty("/listNoDataText",p.getProperty("MSG_NO_FIELDS").toLowerCase());this._oList=t.getElementById(`${this.getId()}--rta_addElementsDialogList`);this._bDescendingSortOrder=false}.bind(this))};d.prototype.exit=function(...t){this._oDialogPromise.then(function(e){e.destroy()});if(e.prototype.exit){e.prototype.exit.apply(this,t)}};d.prototype.setCustomFieldButtonVisible=function(e){this._oDialogModel.setProperty("/customFieldVisible",e)};d.prototype._submitDialog=function(){return this._oDialogPromise.then(function(e){e.close();this._fnResolveOnDialogConfirm()}.bind(this))};d.prototype._cancelDialog=function(){this._oDialogModel.getObject("/elements").forEach(function(e){e.selected=false});this._oDialogPromise.then(function(e){e.close()});this._fnRejectOnDialogCancel()};d.prototype.setElements=function(e){this._oDialogModel.setProperty("/elements",e)};d.prototype.getElements=function(){return this._oDialogModel.getProperty("/elements")};d.prototype.getSelectedElements=function(){return this._oDialogModel.getObject("/elements").filter(function(e){return e.selected})};d.prototype.open=function(){return new Promise(function(e,t){this._fnResolveOnDialogConfirm=e;this._fnRejectOnDialogCancel=t;this._oDialogPromise.then(function(e){e.attachAfterOpen(function(){this.fireOpened()}.bind(this));e.open()}.bind(this))}.bind(this))};d.prototype._resortList=function(){this._bDescendingSortOrder=!this._bDescendingSortOrder;var e=this._oList.getBinding("items");var t=[];t.push(new a("label",this._bDescendingSortOrder));e.sort(t)};d.prototype._updateModelFilter=function(e){var t=e.getParameter("newValue");var i=this._oList.getBinding("items");if(typeof t==="string"){var o=new n("label",l.Contains,t);var s=new n("originalLabel",l.Contains,t);var r=new n("parentPropertyName",l.Contains,t);var a=new n("duplicateName",l.EQ,true);var u=new n({filters:[r,a],and:true});var d=new n({filters:[o,s,u],and:false});i.filter([d])}else{i.filter([])}};d.prototype._redirectToCustomFieldCreation=function(){this.fireOpenCustomField();this._oDialogPromise.then(function(e){e.close()})};d.prototype.setTitle=function(t){e.prototype.setProperty.call(this,"title",t,true);this._oDialogPromise.then(function(e){e.setTitle(t)})};d.prototype.setCustomFieldEnabled=function(e){this.setProperty("customFieldEnabled",e,true);this._oDialogModel.setProperty("/customFieldEnabled",this.getProperty("customFieldEnabled"))};d.prototype._setBusinessContextVisible=function(e){this.setProperty("businessContextVisible",e,true);this._oDialogModel.setProperty("/businessContextVisible",e)};d.prototype.addExtensionData=function(e){this._removeExtensionDataTexts();var t=this._oDialogModel.getObject("/businessContextTexts");if(e&&e.length>0){e.forEach(function(e){t.push({text:e.description})},this)}else{t.push({text:p.getProperty("MSG_NO_BUSINESS_CONTEXTS")})}this._setBusinessContextVisible(true);return o.getTexts().then(function(e){if(e){this._oDialogModel.setProperty("/customFieldButtonTooltip",e.tooltip);this._oDialogModel.setProperty("/businessContextTexts/0/text",e.headerText)}}.bind(this))};d.prototype._removeExtensionDataTexts=function(){var e=this._oDialogModel.getObject("/businessContextTexts");e.splice(1)};return d});
//# sourceMappingURL=AddElementsDialog.js.map