/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/dt/OverlayRegistry","sap/ui/dt/ElementOverlay","sap/ui/dt/AggregationOverlay","sap/ui/dt/Util","sap/ui/fl/Utils","sap/ui/fl/write/api/ExtensionPointRegistryAPI","sap/base/util/deepEqual","sap/base/util/isEmptyObject","sap/base/util/merge","sap/base/util/restricted/_omit","sap/ui/core/mvc/View","sap/base/Log","sap/ui/base/DesignTime"],function(e,t,n,i,a,r,s,g,o,l,d,u,m){"use strict";function v(e,t){var n=r.getExtensionPointInfoByViewId({viewId:e});return l(n,t)}function c(e){return l(e,["bIsView"])}return function(p,f){var h={};h.mExtensionPointMetadata={palette:{icons:{svg:"sap/ui/core/designtime/Icon.icon.svg"}}};h._aConsideredExtensionPoints=[];h._attachNotConsideredExtensionPoints=function(e,t){var n=a.getViewForControl(e.getElement()).getId();var i=v(n,this._aConsideredExtensionPoints);Object.keys(i).forEach(function(e,a){var r=i[e];var s=this._getExtensionPointData(r);s.id=n;t.elements.splice(a,0,s);this._aConsideredExtensionPoints.push(s.name)}.bind(this))};h._getOutline=function(t,n){var a;if(!n&&i.isInteger(t)){n=t;t=undefined}var r=[];if(!t){r=p._oDesignTime.getRootElements().map(function(t){return e.getOverlay(t)})}else{var s=e.getOverlay(t);if(!s){throw i.createError("services.Outline#get",`Cannot find element with id= ${t}. A valid or empty value for the initial element id should be provided.`,"sap.ui.rta")}r.push(s)}a=r.map(function(e){return this._getChildrenNodes(e,n)},this);this._aConsideredExtensionPoints=[];return a};h._getExtensionPoints=function(e){var t=e.id;var n=e.technicalName;return r.getExtensionPointInfoByParentId({parentId:t}).filter(function(e){return e.aggregationName===n})};h._getExtensionPointData=function(e){return{id:e.targetControl.getId(),name:e.name,technicalName:"sap.ui.extensionpoint",type:"extensionPoint",icon:this.mExtensionPointMetadata.palette.icons.svg,extensionPointInfo:{defaultContent:e.defaultContent.map(function(e){return e.getId()}),createdControls:e.createdControls||[]}}};h._enrichExtensionPointData=function(e,t){var n=m.isDesignModeEnabled();if(!n){return undefined}if(e.type==="aggregation"){var i=this._getExtensionPoints(e).sort(function(e,t){return t.index-e.index});i.forEach(function(t){var n=this._getExtensionPointData(t);e.elements.splice(t.index,0,n);this._aConsideredExtensionPoints.push(n.name)}.bind(this))}else if(e.bIsView){return this._attachNotConsideredExtensionPoints(t,e)}};function y(e,t,n){var i=e.getAggregationName&&e.getAggregationName();if(i){var a=e.getParent().getId();if(n[i]){return Object.assign({templateFor:a},n[i])}return(t&&t.elements||[]).map(function(e){if(e.type==="aggregationBindingTemplate"||e.parentAggregationName===i){return Object.assign({templateFor:a},e)}return e.technicalName===i&&e}).filter(Boolean)[0]}var r=e.getParentElementOverlay().getAggregationBindingTemplateOverlays&&e.getParentElementOverlay().getAggregationBindingTemplateOverlays().reduce(function(e,t){return e.concat(t.getChildren())},[])||[];if(r.includes(e)){return undefined}if(!t){return undefined}var s=e.getParentElementOverlay();if(s.getId()===t.templateFor){return t}var g=e.getParent().getChildren().indexOf(e);return t.elements[g]}h._getChildrenNodes=function(e,t,n,a){var r=i.isInteger(t);var s={};if(e.getShouldBeDestroyed()){return{}}var l=this._getNodeProperties(e,n,a)||{};var d=e.getChildren();var u=e.getAggregationBindingTemplateOverlays&&e.getAggregationBindingTemplateOverlays()||[];if(u.length>0){d=u.reduce(function(e,t){var n=t.getChildren()[0];s[n.getId()]=t.getAggregationName();return[n].concat(e)},d)}if((!r||r&&t>0)&&d.length>0&&!g(l)){t=r?t-1:t;var m={};l.elements=d.map(function(e){var n=y(e,a,m);var i=this._getChildrenNodes(e,t,e.getParent(),n);if(i.type==="aggregationBindingTemplate"){var r=s[e.getId()];m[r]=o({},i)}return i},this).filter(function(e){return!g(e)});this._enrichExtensionPointData(l,e)}return c(l)};function E(e,t,n){var i=e.getParentElementOverlay();return i&&n&&i.getAggregationOverlay(n,"AggregationBindingTemplateOverlays")===t}function O(e,t,n){var i={editable:e.getEditable(),bIsView:e.getElement()instanceof d};if(t.isA("sap.ui.core.Component")){i.component=true}if(typeof e.isVisible()==="boolean"){i.visible=e.isVisible()}var a=e.getParent()&&e.getParentAggregationOverlay();var r=a&&a.getAggregationName()||"";if(E(e,a,r)){i.type="aggregationBindingTemplate";i.icon="sap-icon://attachment-text-file";i.parentAggregationName=r}else{i.type="element"}var s=n.getName(t);if(s&&s.singular){i.name=s&&s.singular}return i}function _(e,t,n){var i=e.getAggregationName();var a={technicalName:e.getAggregationName(),editable:false,type:"aggregation",bIsView:e.getElement()instanceof d};if(t.getAggregation(i)){var r=t.getDesignTimeMetadata().getAggregationDescription(i,n);if(r.singular){a.name=r.singular}}if(t.getAggregationBindingTemplateOverlays().length){a.icon="sap-icon://card"}return a}function b(e,t,n){var i={id:e.getId(),technicalName:e.getMetadata().getName(),editable:false,type:null};if(n){i.templateReference=n.id}var a=P(t);if(a){i.icon=a}var r=t.getLabel(e);if(r&&r!==i.id){i.instanceName=r}return i}function P(e){var t=e.getData();return t.palette&&t.palette.icons&&t.palette.icons.svg||undefined}h._getNodeProperties=function(e,n,i){var a=e.getElement();var r=e.getDesignTimeMetadata();var s=b(a,r,i);if(e instanceof t){return Object.assign(s,O(e,a,r))}return Object.assign(s,_(e,n,a))};h._removeDuplicate=function(e,t){return e.filter(function(e){return!s(t,e,Infinity)})};h._updatesHandler=function(t){var i=t.getParameters();if(this.sStatus==="initial"){this.aUpdates=[]}var a=o({},i);var r=a.id?e.getOverlay(a.id).getElement().getId():undefined;var s=a.targetId?e.getOverlay(a.targetId).getElement().getId():undefined;switch(t.getId()){case"elementOverlayCreated":if(i.elementOverlay.isRoot()){var g=i.elementOverlay.getElement().getId();[a.element]=h._getOutline(g);a.type="new";break}return;case"elementOverlayAdded":[a.element]=h._getOutline(r);a.targetId=s;a.type="new";break;case"elementOverlayMoved":[a.element]=h._getOutline(r,0);a.targetId=s;a.type="move";break;case"elementOverlayDestroyed":var d=a.elementOverlay.getParentAggregationOverlay();if(d instanceof n&&!d._bIsBeingDestroyed||a.elementOverlay.isRoot()){a.element={};a.element.id=a.elementOverlay.getElement()?a.elementOverlay.getElement().getId():a.elementOverlay.getAssociation("element");a.type="destroy";break}return;case"elementOverlayEditableChanged":a.element={id:r,editable:a.editable};a.type="editableChange";break;case"elementPropertyChanged":[a.element]=h._getOutline(r,0);a.type="elementPropertyChange";break;default:u.error("Event type is not 'expected' by handler")}a=l(a,["elementOverlay","editable","target","id","elementId"]);this.aUpdates=h._removeDuplicate(this.aUpdates,a);this.aUpdates.push(a);if(this.sStatus==="initial"){setTimeout(function(){if(Array.isArray(this.aUpdates)&&this.aUpdates.length>0){this.sStatus="initial";f("update",this.aUpdates)}}.bind(h),200)}this.sStatus="processing"};h.destroy=function(){p._oDesignTime.detachEvent("elementOverlayCreated",this._updatesHandler,this);p._oDesignTime.detachEvent("elementOverlayAdded",this._updatesHandler,this);p._oDesignTime.detachEvent("elementOverlayMoved",this._updatesHandler,this);p._oDesignTime.detachEvent("elementOverlayDestroyed",this._updatesHandler,this);p._oDesignTime.detachEvent("elementPropertyChanged",this._updatesHandler,this);p._oDesignTime.detachEvent("elementOverlayEditableChanged",this._updatesHandler,this);delete this.aUpdates;delete this.sStatus};h.aUpdates=[];h.sStatus="initial";p._oDesignTime.attachEvent("elementOverlayCreated",h._updatesHandler,h);p._oDesignTime.attachEvent("elementOverlayAdded",h._updatesHandler,h);p._oDesignTime.attachEvent("elementOverlayMoved",h._updatesHandler,h);p._oDesignTime.attachEvent("elementOverlayDestroyed",h._updatesHandler,h);p._oDesignTime.attachEvent("elementPropertyChanged",h._updatesHandler,h);p._oDesignTime.attachEvent("elementOverlayEditableChanged",h._updatesHandler,h);return{events:["update"],exports:{get:h._getOutline.bind(h)},destroy:h.destroy.bind(h)}}});
//# sourceMappingURL=Outline.js.map