/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/i18n/Localization","sap/base/util/restricted/_isEqual","sap/base/Log","sap/ui/base/ManagedObject","sap/ui/core/Fragment","sap/ui/fl/write/api/ContextBasedAdaptationsAPI","sap/m/ColumnListItem","sap/ui/rta/Utils","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/model/json/JSONModel","sap/ui/core/date/UI5Date","sap/ui/performance/Measurement"],function(t,e,a,o,n,i,r,s,l,d,c,p,g){"use strict";var u={Initial:0,Default:1024,Before(t){return t+1024},Between(t,e){return(t+e)/2},After(t){return t+.5}};var h=o.extend("sap.ui.rta.toolbar.contextBased.ManageAdaptations",{metadata:{properties:{toolbar:{type:"any"}}},constructor:function(...t){o.prototype.constructor.apply(this,t);this.oTextResources=this.getToolbar().getTextResources()}});h.prototype.openManageAdaptationDialog=function(){g.start("onCBAOpenManageAdaptationDialog","Measurement of opening the manage context-based adaptation dialog");if(!this._oManageAdaptationDialogPromise){this._oManageAdaptationDialogPromise=n.load({name:"sap.ui.rta.toolbar.contextBased.ManageAdaptationsDialog",id:`${this.getToolbar().getId()}_fragment--sapUiRta_manageAdaptationDialog`,controller:{formatContextColumnCell:f.bind(this),formatContextColumnTooltip:A.bind(this),formatCreatedChangedOnColumnCell:m.bind(this),onLiveSearch:M.bind(this),moveUp:b.bind(this),moveDown:_.bind(this),onDropSelectedAdaptation:x.bind(this),onSaveReorderedAdaptations:U.bind(this),isAdaptationsSelected:N.bind(this),getIndexOfSelectedAdaptation:k.bind(this),onCancel:V.bind(this)}}).then(function(t){this._oManageAdaptationDialog=t;t.addStyleClass(s.getRtaStyleClassName());this.getToolbar().addDependent(this._oManageAdaptationDialog)}.bind(this))}else{C.call(this);w.call(this,true);B.call(this,false)}return this._oManageAdaptationDialogPromise.then(function(){this._oRtaInformation=this.getToolbar().getRtaInformation();return i.load({control:this._oRtaInformation.rootControl,layer:this._oRtaInformation.flexSettings.layer})}.bind(this)).then(function(t){this.oAdaptationsModel=i.getAdaptationsModel({control:this._oRtaInformation.rootControl,layer:this._oRtaInformation.flexSettings.layer});this.oAdaptationsModel.updateAdaptations(t.adaptations);this.oReferenceAdaptationsData=JSON.parse(JSON.stringify(this.oAdaptationsModel.getProperty("/adaptations")));this._oOriginAdaptationsData=JSON.parse(JSON.stringify(this.oAdaptationsModel.getProperty("/allAdaptations")));this._oControlConfigurationModel=new c({isTableItemSelected:false});this._oManageAdaptationDialog.setModel(this.oAdaptationsModel,"contextBased");this._oManageAdaptationDialog.setModel(this._oControlConfigurationModel,"controlConfiguration");D.call(this).attachSelectionChange(v.bind(this));g.end("onCBAOpenManageAdaptationDialog");g.getActive()&&a.info(`onCBAOpenManageAdaptationDialog: ${g.getMeasurement("onCBAOpenManageAdaptationDialog").time} ms`);return this._oManageAdaptationDialog.open()}.bind(this)).catch(function(t){a.error(t.stack);var e="MSG_LREP_TRANSFER_ERROR";var o={titleKey:"BTN_MANAGE_APP_CTX"};o.details=t.userMessage;s.showMessageBox("error",e,o)})};function f(t){return`${t.length} ${t.length>1?this.oTextResources.getText("TXT_TABLE_CONTEXT_CELL_ROLES"):this.oTextResources.getText("TXT_TABLE_CONTEXT_CELL_ROLE")}`}function A(t){return t.join("\n")}function m(e,a){var o=p.getInstance(a);var n={year:"numeric",month:"short",day:"numeric",hour:"numeric",minute:"numeric"};var i=t.getLanguage();return`${e}\n${o.toLocaleTimeString(i,n)}`}function v(t){if(t.getParameter("selected")===true){this._oControlConfigurationModel.setProperty("/isTableItemSelected",true);C.call(this)}}function C(){var t=R.call(this,"moveUpButton");var e=R.call(this,"moveDownButton");if(L.call(this)){if(N.call(this)){t.setEnabled(k.call(this)>0);e.setEnabled(k.call(this)<this.oAdaptationsModel.getProperty("/count")-1)}else{t.setEnabled(false);e.setEnabled(false)}}else{t.setEnabled(false);e.setEnabled(false)}}function M(t){var e;var a=t.getSource().getValue();var o=D.call(this);var n=O.call(this);var i=E.call(this);if(a&&a.length>0){C.call(this);w.call(this,false);var r=new l("title",d.Contains,a);var s=new l({path:"contexts/role",test(t){return t.some(function(t){return t.includes(a.toUpperCase())})}});var c=new l("createdBy",d.Contains,a);var p=new l("changedBy",d.Contains,a);e=new l([r,s,c,p]);if(i.toUpperCase().includes(a.toUpperCase())){n.setVisible(true)}else{n.setVisible(false)}}else{w.call(this,true);if(this._oControlConfigurationModel.getProperty("/isTableItemSelected")){C.call(this)}n.setVisible(true)}var g=o.getBinding("items");g.filter(e,"Application")}function b(t){T.call(this,"Up");t.getSource().focus()}function _(t){T.call(this,"Down");t.getSource().focus()}function P(t,e){return t.rank-e.rank}function y(t){var e=t.getProperty("/adaptations")||[];e.sort(P);t.setProperty("/adaptations",e);t.refresh(true)}function T(t){var e=D.call(this);var a=e.getSelectedItem(0);var o=a.getBindingContext("contextBased");var n=e.indexOfItem(a)+(t==="Up"?-1:1);var i=e.getItems()[n];var r=i?i.getBindingContext("contextBased"):undefined;if(!r){return}var s=r.getProperty("rank");var l=o.getProperty("rank");this.oAdaptationsModel.setProperty("rank",s,o);this.oAdaptationsModel.setProperty("rank",l,r);y(this.oAdaptationsModel);e.getItems()[n].setSelected(true).focus();B.call(this,S.call(this));C.call(this)}function x(t){var e=t.getParameter("draggedControl");var a=e.getBindingContext("contextBased");if(!a){return}var o=u.Default;var n=t.getParameter("droppedControl");if(n instanceof r){var i=t.getParameter("dropPosition");var s=n.getBindingContext("contextBased");var l=s.getProperty("rank");var d=n.getParent();var c=d.indexOfItem(n);if(s===a){return}var p=c+(i==="After"?1:-1);var g=d.getItems()[p];if(!g||p===-1){o=p===-1?.5:u[i](l)}else{var h=g.getBindingContext("contextBased");o=u.Between(l,h.getProperty("rank"))}}this.oAdaptationsModel.setProperty("rank",o,a);y(this.oAdaptationsModel);var f=Object.assign(this.oAdaptationsModel.getProperty("/allAdaptations"),this.oAdaptationsModel.getProperty("/adaptations"));this.oAdaptationsModel.updateAdaptations(f);B.call(this,S.call(this))}function S(){return!e(this.oAdaptationsModel.getProperty("/adaptations").map(function(t){return t.id}),this.oReferenceAdaptationsData.map(function(t){return t.id}))}function B(t){var e=R.call(this,"manageAdaptations-saveButton");e.setTooltip(t?"":this.oTextResources.getText("TOOLTIP_APP_CTX_DIALOG_SAVE"));e.setEnabled(t)}function D(){return R.call(this,"manageAdaptationsTable")}function R(t){return this.getToolbar().getControl(`manageAdaptationDialog--${t}`)}function O(){return R.call(this,"defaultContext")}function E(){return R.call(this,"defaultApplicationTitle").getProperty("text")}function I(){return R.call(this,"searchField")}function L(){return I.call(this).getValue().length===0}function w(t){D.call(this).getDragDropConfig()[0].setEnabled(t)}function N(){var t=D.call(this);return t.getSelectedContextPaths().length>0}function k(){var t=D.call(this);if(t.getSelectedContextPaths().length>0){var e=t.getSelectedContextPaths()[0].split("/");var a=Number(e[e.length-1]);return a}return-1}function U(){s.checkDraftOverwrite(this.getToolbar().getModel("versions")).then(function(){var t=this.getToolbar().getRtaInformation();var e=this.oAdaptationsModel.getProperty("/adaptations").map(function(t){return t.id});return i.reorder({control:t.rootControl,layer:t.flexSettings.layer,parameters:{priorities:e}})}.bind(this)).then(function(){var t=Object.assign(this.oAdaptationsModel.getProperty("/allAdaptations"),this.oAdaptationsModel.getProperty("/adaptations"));this.oAdaptationsModel.updateAdaptations(t);$.call(this)}.bind(this)).catch(function(t){if(t!=="cancel"){s.showMessageBox("error","MSG_LREP_TRANSFER_ERROR",{titleKey:"BTN_MANAGE_APP_CTX",error:t});a.error(`sap.ui.rta: ${t.stack||t.message||t}`)}})}function V(){this.oAdaptationsModel.updateAdaptations(this._oOriginAdaptationsData);$.call(this)}function $(){this._oControlConfigurationModel.setProperty("/isTableItemSelected",false);I.call(this).setValue("");var t=D.call(this);t.getBinding("items").filter([]);t.removeSelections();O.call(this).setVisible(true);this._oManageAdaptationDialog.close()}return h});
//# sourceMappingURL=ManageAdaptations.js.map