/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/Device","./library","./Column","./utils/TableUtils","./extensions/ExtensionBase","sap/ui/core/Renderer","sap/ui/core/IconPool","sap/ui/core/library","sap/base/Log"],function(e,t,a,i,r,s,n,l,o){"use strict";var d=l.SortOrder;var c=i.Column;var p={Begin:"flex-start",End:"flex-end",Left:undefined,Right:undefined,Center:"center"};var g=i.Hook.Keys.TableRenderer;var b={apiVersion:2};b.render=function(t,a){delete a._iHeaderRowCount;p.Left=a._bRtlMode?"flex-end":"flex-start";p.Right=a._bRtlMode?"flex-start":"flex-end";i.getResourceBundle();t.openStart("div",a);a._getAccRenderExtension().writeAriaAttributesFor(t,a,"ROOT");t.class("sapUiTable");if(e.browser.chrome&&window.devicePixelRatio<1){t.class("sapUiTableZoomout")}if("ontouchstart"in document){t.class("sapUiTableTouch")}t.class("sapUiTableSelMode"+a.getSelectionMode());if(a.getColumnHeaderVisible()){t.class("sapUiTableCHdr")}if(i.hasRowHeader(a)){t.class("sapUiTableRowSelectors")}if(i.hasRowHighlights(a)){t.class("sapUiTableRowHighlights")}try{var r=i._getTableTemplateHelper(true).addTableClass();if(r){t.class(r)}}catch(e){}var s=a._getScrollExtension();if(s.isVerticalScrollbarRequired()&&!s.isVerticalScrollbarExternal()){t.class("sapUiTableVScr")}if(a.getEditable&&a.getEditable()){t.class("sapUiTableEdt")}if(i.hasRowActions(a)){var n=a.getRowActionCount();t.class(n==1?"sapUiTableRActS":"sapUiTableRAct")}else if(i.hasRowNavigationIndicators(a)){t.class("sapUiTableRowNavIndicator")}if(i.isNoDataVisible(a)&&!a._hasPendingRequests()){t.class("sapUiTableEmpty")}if(a.getShowOverlay()){t.class("sapUiTableOverlay")}var l=i.Grouping.getModeCssClass(a);if(l){t.class(l)}t.style("width",a.getWidth());i.Hook.call(a,g.RenderTableStyles,t);if(a._bFirstRendering){t.class("sapUiTableNoOpacity")}t.openEnd();this.renderTabElement(t,"sapUiTableOuterBefore");t.openStart("div",a.getId()+"-before");t.class("sapUiTableBefore");t.openEnd();t.renderControl(a.getAggregation("_messageStrip"));if(a.getTitle()){this.renderHeader(t,a,a.getTitle())}if(a.getToolbar()){this.renderToolbar(t,a,a.getToolbar())}if(a.getExtension()&&a.getExtension().length>0){this.renderExtensions(t,a,a.getExtension())}t.close("div");t.openStart("div",a.getId()+"-sapUiTableCnt");t.class("sapUiTableCnt");t.attr("data-sap-ui-fastnavgroup","true");t.attr("data-sap-ui-pasteregion","true");a._getAccRenderExtension().writeAriaAttributesFor(t,a,"CONTAINER");t.openEnd();t.openStart("div",a.getId()+"-sapUiTableGridCnt");a._getAccRenderExtension().writeAriaAttributesFor(t,a,"CONTENT");t.openEnd();this.renderColRsz(t,a);this.renderColHdr(t,a);this.renderTable(t,a);t.close("div");var o=a.getCreationRow();if(o&&o.getVisible()){t.renderControl(o);this.renderHSbBackground(t,a);this.renderHSb(t,a)}a._getAccRenderExtension().writeHiddenAccTexts(t,a);t.openStart("div",a.getId()+"-overlay");t.class("sapUiTableOverlayArea");t.attr("tabindex","0");a._getAccRenderExtension().writeAriaAttributesFor(t,a,"OVERLAY");t.openEnd();t.close("div");t.close("div");t.openStart("div",a.getId()+"-after");t.openEnd();if(a.getFooter()){this.renderFooter(t,a,a.getFooter())}i.Hook.call(a,g.RenderInTableBottomArea,t);t.close("div");this.renderTabElement(t,"sapUiTableOuterAfter");t.close("div")};b.renderHeader=function(e,t,a){e.openStart("div");e.class("sapUiTableHdr");t._getAccRenderExtension().writeAriaAttributesFor(e,t,"TABLEHEADER");e.openEnd();e.renderControl(a);e.close("div")};b.renderToolbar=function(e,t,a){if(!i.isA(a,"sap.ui.core.Toolbar")){return}e.openStart("div");e.class("sapUiTableTbr");if(typeof a.getStandalone==="function"&&a.getStandalone()){a.setStandalone(false)}if(a.isA("sap.m.Toolbar")){a.setDesign("Transparent",true);a.addStyleClass("sapMTBHeader-CTX");e.class("sapUiTableMTbr")}t._getAccRenderExtension().writeAriaAttributesFor(e,t,"TABLESUBHEADER");e.openEnd();e.renderControl(a);e.close("div")};b.renderExtensions=function(e,t,a){for(var i=0,r=a.length;i<r;i++){this.renderExtension(e,t,a[i])}};b.renderExtension=function(e,t,a){e.openStart("div");e.class("sapUiTableExt");t._getAccRenderExtension().writeAriaAttributesFor(e,t,"TABLESUBHEADER");e.openEnd();e.renderControl(a);e.close("div")};b.renderTable=function(e,t){var a=t.getRows().length>0;this.renderTabElement(e,"sapUiTableCtrlBefore",a?"0":"-1");e.openStart("div",t.getId()+"-tableCCnt");i.Hook.call(t,g.RenderRowContainerStyles,e);e.class("sapUiTableCCnt");e.openEnd();this.renderTableCCnt(e,t);e.close("div");this.renderTabElement(e,"sapUiTableCtrlAfter",a?"0":"-1");this.renderTabElement(e,null,"-1",t.getId()+"-focusDummy");var r=t.getCreationRow();if(!r||!r.getVisible()){this.renderHSbBackground(e,t);this.renderHSb(e,t)}};b.renderTableCCnt=function(e,t){this.renderTableCtrl(e,t);this.renderRowHdr(e,t);this.renderRowActions(e,t);if(!t._getScrollExtension().isVerticalScrollbarExternal()){this.renderVSb(e,t)}e.openStart("div",t.getId()+"-noDataCnt");e.class("sapUiTableCtrlEmpty");e.attr("tabindex","0");t._getAccRenderExtension().writeAriaAttributesFor(e,t,"NODATA");e.openEnd();var a=i.getNoContentMessage(t);if(i.isA(a,"sap.ui.core.Control")){e.renderControl(a)}else{e.openStart("span",t.getId()+"-noDataMsg");e.class("sapUiTableCtrlEmptyMsg");e.openEnd();e.text(a);e.close("span")}e.close("div")};b.renderFooter=function(e,t,a){e.openStart("div");e.class("sapUiTableFtr");t._getAccRenderExtension().writeAriaAttributesFor(e,t,"TABLEFOOTER");e.openEnd();e.renderControl(a);e.close("div")};b.renderColHdr=function(e,t){var a=i.getHeaderRowCount(t);var r=t.getColumns();var s=t.getComputedFixedColumnCount();e.openStart("div");e.class("sapUiTableColHdrCnt");e.openEnd();this.renderColRowHdr(e,t);if(s>0){e.openStart("div");e.class("sapUiTableCHA");e.class("sapUiTableCtrlScrFixed");e.class("sapUiTableNoOpacity");e.openEnd();this.renderTableControlCnt(e,t,true,0,s,true,false,0,a,true);e.close("div")}e.openStart("div",t.getId()+"-sapUiTableColHdrScr");e.class("sapUiTableCHA");e.class("sapUiTableCtrlScr");if(r.length==0){e.class("sapUiTableHasNoColumns")}if(s>0){if(t._bRtlMode){e.style("margin-right","0")}else{e.style("margin-left","0")}}e.openEnd();this.renderTableControlCnt(e,t,false,s,r.length,false,false,0,a,true);e.close("div");e.openStart("div");e.class("sapUiTableVSbHeader");e.openEnd();e.close("div");if(i.hasRowActions(t)){e.openStart("div",t.getId()+"-rowacthdr");t._getAccRenderExtension().writeAriaAttributesFor(e,t,"ROWACTIONHEADER");e.class("sapUiTableCell");e.class("sapUiTableHeaderCell");e.class("sapUiTableRowActionHeaderCell");e.openEnd();e.openStart("span");e.openEnd();e.text(i.getResourceText("TBL_ROW_ACTION_COLUMN_LABEL"));e.close("span");e.close("div")}e.close("div")};b.renderColRowHdr=function(e,a){var r=false;var s=false;var n=a._getSelectionPlugin().getRenderConfig();e.openStart("div",a.getId()+"-selall");e.class("sapUiTableCell");e.class("sapUiTableHeaderCell");e.class("sapUiTableRowSelectionHeaderCell");var l;if(n.headerSelector.visible){var o=n.headerSelector.selected;if(n.headerSelector.type==="toggle"){l=o?"TBL_DESELECT_ALL":"TBL_SELECT_ALL"}else if(n.headerSelector.type==="clear"){l="TBL_DESELECT_ALL";if(!n.headerSelector.enabled){e.class("sapUiTableSelAllDisabled");e.attr("aria-disabled","true")}}if(l){e.attr("title",i.getResourceText(l))}if(!o){e.class("sapUiTableSelAll")}else{s=true}e.class("sapUiTableSelAllVisible");r=true}e.attr("tabindex","-1");var d={enabled:r,checked:s};a._getAccRenderExtension().writeAriaAttributesFor(e,a,"COLUMNROWHEADER",d);e.openEnd();if(n.headerSelector.visible){if(n.headerSelector.type==="clear"&&n.headerSelector.icon){e.renderControl(n.headerSelector.icon)}else{e.openStart("div");e.class("sapUiTableSelectAllCheckBox");e.openEnd();e.close("div")}}if(i.hasRowHeader(a)&&a.getSelectionMode()===t.SelectionMode.None){e.openStart("span",a.getId()+"-rowselecthdr");e.class("sapUiPseudoInvisibleText");e.openEnd();e.text(i.getResourceText("TBL_ROW_SELECTION_COLUMN_LABEL"));e.close("span")}e.close("div")};b.renderCol=function(e,t,a,r,n,l,o,c,g){var b,T=!n,f=a.getIndex(),u=a.getMultiLabels();if(u.length>0){b=u[r]}else if(r==0){b=a.getLabel()}var C=a.getId();if(r===0){e.openStart("td",a)}else{C=C+"_"+r;e.openStart("td",C)}e.attr("data-sap-ui-related",a.getId());e.attr("data-sap-ui-colid",a.getId());e.attr("data-sap-ui-colindex",f);e.attr("tabindex","-1");var h={column:a,headerId:C,index:f};if(n>1){e.attr("colspan",n);h.colspan=true}if(g){var R=a.getFiltered();var v=a.getSortOrder()!==d.None;if(!a.getSorted()){v=false}if(R){e.class("sapUiTableColFiltered")}if(v){e.class("sapUiTableColSorted");if(a.getSortOrder()===d.Descending){e.class("sapUiTableColSortedD")}}}t._getAccRenderExtension().writeAriaAttributesFor(e,t,"COLUMNHEADER",h);e.class("sapUiTableCell");e.class("sapUiTableHeaderCell");e.class("sapUiTableHeaderDataCell");var S=a.getHeaderMenuInstance();if(t.getEnableColumnReordering()||t.hasListeners("columnSelect")||S&&S.getAriaHasPopupType()!=="None"){e.class("sapUiTableHeaderCellActive")}if(!t.getEnableColumnReordering()&&!t.hasListeners("columnSelect")&&!S&&a._menuHasItems()){e.class("sapUiTableHeaderCellActive")}if(l){e.class("sapUiTableCellFirst")}if(o){e.class("sapUiTableCellLastFixed")}if(c){e.class("sapUiTableCellLast")}if(T){e.class("sapUiTableHidden")}if(t.getColumnHeaderHeight()>0){e.style("height",t.getColumnHeaderHeight()+"px")}var E=a.getTooltip_AsString();if(E){e.attr("title",E)}e.openEnd();e.openStart("div",C+"-inner");e.class("sapUiTableCellInner");if(!i.hasRowHeader(t)&&l&&!i.hasRowHighlights(t)&&!i.Grouping.isInTreeMode(t)){e.class("sapUiTableFirstColumnCell")}var A=a.getHAlign();var w=s.getTextAlign(A);if(w){e.style("text-align",w)}e.openEnd();e.openStart("div");e.style("justify-content",p[A]);e.openEnd();if(b){e.renderControl(b)}e.close("div");e.close("div");e.close("td")};b.renderColRsz=function(e,t){e.openStart("div",t.getId()+"-rsz");e.class("sapUiTableColRsz");e.openEnd();e.close("div")};b.renderRowHdr=function(e,t){e.openStart("div",t.getId()+"-sapUiTableRowHdrScr");t._getAccRenderExtension().writeAriaAttributesFor(e,t,"PRESENTATION");e.class("sapUiTableRowHdrScr");e.class("sapUiTableNoOpacity");t._getAccRenderExtension().writeAriaAttributesFor(e,t,"ROWHEADER_COL");e.openEnd();for(var a=0,i=t.getRows().length;a<i;a++){this.renderRowAddon(e,t,t.getRows()[a],a,true)}e.close("div")};b.renderRowActions=function(e,t){if(!i.hasRowActions(t)&&!i.hasRowNavigationIndicators(t)){return}e.openStart("div",t.getId()+"-sapUiTableRowActionScr");t._getAccRenderExtension().writeAriaAttributesFor(e,t,"PRESENTATION");i.hasRowActions(t)?e.class("sapUiTableRowWithAction"):e.class("sapUiTableRowActionScr");e.class("sapUiTableNoOpacity");e.openEnd();for(var a=0,r=t.getRows().length;a<r;a++){this.renderRowAddon(e,t,t.getRows()[a],a,false)}e.close("div")};b.addRowCSSClasses=function(e,t,a){var r=t._getRowCounts();var s=i.getFirstFixedBottomRowIndex(t);if(a===0){e.class("sapUiTableFirstRow")}else if(a===t.getRows().length-1){e.class("sapUiTableLastRow")}if(r.fixedTop>0){if(a==r.fixedTop-1){e.class("sapUiTableRowLastFixedTop")}if(a==r.fixedTop){e.class("sapUiTableRowFirstScrollable")}}if(s>=0&&s===a){e.class("sapUiTableRowFirstFixedBottom")}else if(s>=1&&s-1===a){e.class("sapUiTableRowLastScrollable")}};b.renderRowAddon=function(e,t,a,r,s){var n=t._getSelectionPlugin().isSelected(a);e.openStart("div");e.attr("data-sap-ui-related",a.getId());e.attr("data-sap-ui-rowindex",r);e.class("sapUiTableRow");e.class("sapUiTableContentRow");if(a.isContentHidden()){e.class("sapUiTableRowHidden")}else if(n){e.class("sapUiTableRowSel")}if(r%2!=0&&t.getAlternateRowColors()&&!i.Grouping.isInTreeMode(t)){e.class("sapUiTableRowAlternate")}this.addRowCSSClasses(e,t,r);e.openEnd();e.openStart("div",t.getId()+(s?"-rowsel":"-rowact")+r);e.class("sapUiTableCell");e.class("sapUiTableContentCell");e.class(s?"sapUiTableRowSelectionCell":"sapUiTableRowActionCell");i.Hook.call(t,g.RenderRowStyles,e);e.attr("tabindex","-1");var l={rowSelected:n,rowHidden:a.isEmpty()};t._getAccRenderExtension().writeAriaAttributesFor(e,t,s?"ROWHEADER":"ROWACTION",l);e.openEnd();if(s){this.writeRowHighlightContent(e,t,a,r);this.writeRowSelectorContent(e,t,a)}else{var o=a.getRowAction();if(o){e.renderControl(o)}this.writeRowNavigationContent(e,t,a,r)}e.close("div");e.close("div")};b.renderTableCtrl=function(e,t){if(t.getComputedFixedColumnCount()>0){e.openStart("div",t.getId()+"-sapUiTableCtrlScrFixed");e.class("sapUiTableCtrlScrFixed");e.openEnd();this.renderTableControl(e,t,true);e.close("div")}e.openStart("div",t.getId()+"-sapUiTableCtrlScr");e.class("sapUiTableCtrlScr");if(t.getComputedFixedColumnCount()>0){if(t._bRtlMode){e.style("margin-right","0")}else{e.style("margin-left","0")}}e.openEnd();e.openStart("div",t.getId()+"-tableCtrlCnt");e.class("sapUiTableCtrlCnt");e.openEnd();this.renderTableControl(e,t,false);e.close("div");e.close("div")};b.renderTableControl=function(e,t,a){var i,r;if(a){i=0;r=t.getComputedFixedColumnCount()}else{i=t.getComputedFixedColumnCount();r=t.getColumns().length}var s=t._getRowCounts();var n=t.getRows();if(s.fixedTop>0){this.renderTableControlCnt(e,t,a,i,r,true,false,0,s.fixedTop)}this.renderTableControlCnt(e,t,a,i,r,false,false,s.fixedTop,n.length-s.fixedBottom);if(s.fixedBottom>0&&n.length>0){this.renderTableControlCnt(e,t,a,i,r,false,true,n.length-s.fixedBottom,n.length)}};b.renderTableControlCnt=function(e,t,a,r,s,n,l,o,d,c){var p=c?"-header":"-table";var g=t.getId()+p;var b=[];if(a){g+="-fixed";b.push("sapUiTableCtrlFixed")}else{b.push("sapUiTableCtrlScroll")}if(n){g+="-fixrow";b.push("sapUiTableCtrlRowFixed")}else if(l){g+="-fixrow-bottom";b.push("sapUiTableCtrlRowFixedBottom")}else{b.push("sapUiTableCtrlRowScroll")}e.openStart("table",g);b.forEach(function(t){e.class(t)});t._getAccRenderExtension().writeAriaAttributesFor(e,t,c?"COLUMNHEADER_TABLE":"TABLE");e.class("sapUiTableCtrl");if(c){e.class("sapUiTableCHT")}e.style(a?"width":"min-width",t._getColumnsWidth(r,s)+"px");e.openEnd();e.openStart("thead").openEnd();e.openStart("tr");e.class("sapUiTableCtrlCol");if(o==0){e.class("sapUiTableCtrlFirstCol")}if(c){e.class("sapUiTableCHTHR")}e.openEnd();var T=t.getColumns();var f=new Array(s);var u;var C;var h=!a&&s>r;var R=t._getVisibleColumns();for(u=r;u<s;u++){C=T[u];var v={shouldRender:!!(C&&C.shouldRender())};if(v.shouldRender){var S=C.getWidth();if(i.isVariableWidth(S)){h=false;if(a){C._iFixWidth=C._iFixWidth||160;S=C._iFixWidth+"px"}}else if(a){delete C._iFixWidth}v.width=S}f[u]=v}if(T.length===0){e.openStart("th").openEnd().close("th")}for(u=r;u<s;u++){p=c?"_hdr":"_col";C=T[u];v=f[u];if(v.shouldRender){if(o==0){e.openStart("th",t.getId()+p+u);t._getAccRenderExtension().writeAriaAttributesFor(e,t,"TH",{column:C})}else{e.openStart("th")}e.style("width",v.width);e.attr("data-sap-ui-headcolindex",u);e.attr("data-sap-ui-colid",C.getId());if(C===R[0]){e.class("sapUiTableFirstVisibleColumnTH")}e.openEnd();if(o==0&&i.getHeaderRowCount(t)==0&&!c){if(C.getMultiLabels().length>0){e.renderControl(C.getMultiLabels()[0])}else{e.renderControl(C.getLabel())}}e.close("th")}}if(h){e.openStart("th",c&&t.getId()+"-dummycolhdr");t._getAccRenderExtension().writeAriaAttributesFor(e,t,"PRESENTATION");e.openEnd().close("th")}e.close("tr");e.close("thead");e.openStart("tbody").openEnd();var E=t.getRows();var A;var w;if(c){for(A=o,w=d;A<w;A++){this.renderColumnHeaderRow(e,t,A,a,r,s,h,A===w-1)}}else{var x=t._getAccExtension().getAriaTextsForSelectionMode(true);var U=i.isRowSelectionAllowed(t);var H=t.getDragDropConfig().some(function(e){return e.getMetadata().isInstanceOf("sap.ui.core.dnd.IDragInfo")&&e.getSourceAggregation()==="rows"});var I=this.getLastFixedColumnIndex(t);for(A=o,w=d;A<w;A++){this.renderTableRow(e,t,E[A],A,a,r,s,false,R,I,h,x,U,H)}}e.close("tbody");e.close("table")};b.writeRowSelectorContent=function(e,t,a){t._getAccRenderExtension().writeAccRowSelectorText(e,t,a);if(i.Grouping.isInGroupMode(t)){e.openStart("div");e.class("sapUiTableGroupShield");e.openEnd();e.close("div");e.openStart("div",a.getId()+"-groupHeader");e.class("sapUiTableGroupIcon");e.openEnd();e.close("div");if(i.Grouping.showGroupMenuButton(t)){var r=n.getIconInfo("sap-icon://drop-down-list");e.openStart("div").class("sapUiTableGroupMenuButton").openEnd();e.text(r.content);e.close("div")}}};b.writeRowHighlightContent=function(e,t,a,r){if(!i.hasRowHighlights(t)){return}var s=a.getAggregation("_settings");var n=s._getHighlightCSSClassName();e.openStart("div",a.getId()+"-highlight");e.class("sapUiTableRowHighlight");e.class(n);e.openEnd();t._getAccRenderExtension().writeAccRowHighlightText(e,t,a,r);e.close("div")};b.writeRowNavigationContent=function(e,t,a,r){if(!i.hasRowNavigationIndicators(t)){return}var s=a.getAggregation("_settings");e.openStart("div",a.getId()+"-navIndicator");if(s.getNavigated()){e.class("sapUiTableRowNavigated")}e.openEnd();e.close("div")};b.renderColumnHeaderRow=function(e,t,a,i,r,s,n,l){e.openStart("tr");e.class("sapUiTableRow");e.class("sapUiTableHeaderRow");e.class("sapUiTableColHdrTr");t._getAccRenderExtension().writeAriaAttributesFor(e,t,"COLUMNHEADER_ROW");e.openEnd();var o=this.getColumnsToRender(t,r,s),d=0,p=-1;function g(e,t,i){var r=c.getHeaderSpan(e,a),s;if(d<1){if(r>1){s=e.getIndex();r=i.slice(t+1,t+r).reduce(function(e,t){return t.getIndex()-s<r?e+1:e},1)}e._nSpan=d=r;p=t}else{e._nSpan=0}d--}o.forEach(g);function b(r,s){this.renderCol(e,t,r,a,r._nSpan,s===0,i&&s==p,!i&&s==p,r._nSpan===1&&!r._bIconsRendered);r._bIconsRendered=r._bIconsRendered||r._nSpan===1;delete r._nSpan;if(l){delete r._bIconsRendered}}o.forEach(b.bind(this));if(!i&&n&&o.length>0){e.openStart("td").class("sapUiTableCellDummy");t._getAccRenderExtension().writeAriaAttributesFor(e,t,"PRESENTATION");e.openEnd().close("td")}e.close("tr")};b.renderTableRow=function(e,t,a,r,s,n,l,o,d,c,p,b,T,f){if(!a){return}var u=t._getSelectionPlugin();if(s){e.openStart("tr",a.getId()+"-fixed");e.attr("data-sap-ui-related",a.getId())}else{e.openStart("tr",a)}if(a._bDummyRow){e.style("opacity","0")}e.class("sapUiTableRow");e.class("sapUiTableContentRow");e.class("sapUiTableTr");if(f&&s){e.attr("draggable","true");e.attr("data-sap-ui-draggable","true")}if(a.isContentHidden()){e.class("sapUiTableRowHidden")}else if(u.isSelected(a)){e.class("sapUiTableRowSel")}if(r%2!=0&&t.getAlternateRowColors()&&!i.Grouping.isInTreeMode(t)){e.class("sapUiTableRowAlternate")}this.addRowCSSClasses(e,t,r);e.attr("data-sap-ui-rowindex",r);i.Hook.call(t,g.RenderRowStyles,e);var C=a.getAggregation("_settings");var h={index:r,fixedCol:s,rowNavigated:C?C.getNavigated():false};t._getAccRenderExtension().writeAriaAttributesFor(e,t,"TR",h);e.openEnd();var R=!a.isEmpty()&&u.isSelected(a);var v=a.getCells();for(var S=0,E=v.length;S<E;S++){this.renderTableCell(e,t,a,v[S],S,s,n,l,d,c,R)}if(!s&&p&&v.length>0){e.openStart("td").class("sapUiTableCellDummy");t._getAccRenderExtension().writeAriaAttributesFor(e,t,"PRESENTATION");e.openEnd();e.close("td")}e.close("tr")};b.renderTableCell=function(e,t,r,n,l,o,d,c,p,b,T){var f=a.ofCell(n);var u=f.getIndex();if(f.shouldRender()&&d<=u&&c>u){var C=r.getId()+"-col"+l;e.openStart("td",C);e.attr("tabindex","-1");e.attr("data-sap-ui-colid",f.getId());var h=p.length;var R=h>0&&p[0]===f;var v=h>0&&p[h-1]===f;var S=o&&b===u;var E={index:u,column:f,row:r,fixed:o,rowSelected:T};t._getAccRenderExtension().writeAriaAttributesFor(e,t,"DATACELL",E);var A=s.getTextAlign(f.getHAlign());if(A){e.style("text-align",A)}e.class("sapUiTableCell");e.class("sapUiTableContentCell");e.class("sapUiTableDataCell");if(R){e.class("sapUiTableCellFirst")}if(S){e.class("sapUiTableCellLastFixed")}if(v){e.class("sapUiTableCellLast")}if(R&&i.Grouping.isInTreeMode(t)){e.class("sapUiTableCellFlex")}e.openEnd();e.openStart("div");e.class("sapUiTableCellInner");if(!i.hasRowHeader(t)&&R&&!i.hasRowHighlights(t)&&!i.Grouping.isInTreeMode(t)){e.class("sapUiTableFirstColumnCell")}i.Hook.call(t,g.RenderCellContentStyles,e);e.openEnd();this.renderTableCellControl(e,t,n,R);e.close("div");e.close("td")}};b.renderTableCellControl=function(e,t,a,r){if(r&&i.Grouping.isInTreeMode(t)){var s=a.getParent();e.openStart("span",s.getId()+"-treeicon");e.class("sapUiTableTreeIcon");e.attr("tabindex","-1");t._getAccRenderExtension().writeAriaAttributesFor(e,t,"TREEICON",{row:s});e.openEnd();e.close("span")}e.renderControl(a)};b.renderVSb=function(e,t,a){var i=t._getScrollExtension();var r=t._getRowCounts();a=Object.assign({tabIndex:true},a);e.openStart("div");e.class("sapUiTableVSbContainer");if(!i.isVerticalScrollbarRequired()){e.class("sapUiTableHidden")}e.class(a.cssClass);e.openEnd();e.openStart("div",t.getId()+"-vsb");e.class("sapUiTableVSb");e.style("max-height",i.getVerticalScrollbarHeight()+"px");if(r.fixedTop>0){e.style("top",r.fixedTop*t._getBaseRowHeight()-1+"px")}if(a.tabIndex){e.attr("tabindex","-1")}e.openEnd();e.openStart("div");e.class("sapUiTableVSbContent");e.style("height",i.getVerticalScrollHeight()+"px");e.openEnd();e.close("div");e.close("div");e.close("div")};b.renderVSbExternal=function(e,t){if(r.isEnrichedWith(t,"sap.ui.table.extensions.Synchronization")){this.renderVSb(e,t,{cssClass:"sapUiTableVSbExternal",tabIndex:false})}else{o.error("This method can only be used with synchronization enabled.",t,"TableRenderer.renderVSbExternal")}};b.renderHSb=function(e,t,a){a=Object.assign({id:t.getId()+"-hsb",cssClass:"sapUiTableHSb",tabIndex:true,hidden:true,scrollWidth:0},a);e.openStart("div",a.id);e.class(a.cssClass);if(a.hidden){e.class("sapUiTableHidden")}if(a.tabIndex){e.attr("tabindex","-1")}e.openEnd();e.openStart("div",a.id+"-content");e.class("sapUiTableHSbContent");if(a.scrollWidth>0){e.style("width",a.scrollWidth+"px")}e.openEnd();e.close("div");e.close("div")};b.renderHSbExternal=function(e,t,a,i){if(r.isEnrichedWith(t,"sap.ui.table.extensions.Synchronization")){this.renderHSb(e,t,{id:a,cssClass:"sapUiTableHSbExternal",tabIndex:false,hidden:false,scrollWidth:i})}else{o.error("This method can only be used with synchronization enabled.",t,"TableRenderer.renderVSbExternal")}};b.renderHSbBackground=function(e,t){e.openStart("div",t.getId()+"-hsb-bg");e.class("sapUiTableHSbBg");e.openEnd().close("div")};b.renderTabElement=function(e,t,a,i){e.openStart("div");if(t){e.class(t)}if(i){e.attr("id",i)}e.attr("role","none");e.attr("tabindex",a==null?"0":a);e.openEnd().close("div")};b.getColumnsToRender=function(e,t,a){return e.getColumns().slice(t,a).filter(function(e){return e&&e.shouldRender()})};b.getLastFixedColumnIndex=function(e){var t=e.getComputedFixedColumnCount();var a=e.getColumns();var i,r;for(var s=t-1;s>=0;s--){i=a[s];if(i.shouldRender()){r=s;break}}return r};return b},true);
//# sourceMappingURL=TableRenderer.js.map