//@ui5-bundle sap/ui/table/library-preload.js
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/AnalyticalColumn", ["./Column","./library","sap/ui/core/Element","sap/ui/model/type/Boolean","sap/ui/model/type/DateTime","sap/ui/model/type/Float","sap/ui/model/type/Integer","sap/ui/model/type/Time","./utils/TableUtils","sap/base/Log"],function(e,t,r,i,a,n,o,p,s,u){"use strict";var l=t.GroupEventType;function g(e){return s.isA(e,"sap.ui.table.AnalyticalTable")}var d=e.extend("sap.ui.table.AnalyticalColumn",{metadata:{library:"sap.ui.table",properties:{leadingProperty:{type:"string",group:"Misc",defaultValue:null},summed:{type:"boolean",group:"Misc",defaultValue:false},inResult:{type:"boolean",group:"Misc",defaultValue:false},showIfGrouped:{type:"boolean",group:"Appearance",defaultValue:false},groupHeaderFormatter:{type:"function",group:"Appearance",defaultValue:null},grouped:{type:"boolean",group:"Appearance",defaultValue:false}}}});d._DEFAULT_FILTERTYPES={Time:new p({UTC:true}),DateTime:new a({UTC:true}),Float:new n,Integer:new o,Boolean:new i};d.prototype._setGrouped=function(e){var t=this._getTable();var r=e?l.group:l.ungroup;this.setGrouped(e);t.fireGroup({column:this,groupedColumns:t._aGroupedColumns,type:r})};d.prototype._isAggregatableByMenu=function(){var e=this._getTable(),t=e.getBinding(),r=t&&t.getAnalyticalQueryResult();return e&&r&&r.findMeasureByPropertyName(this.getLeadingProperty())};d.prototype.setGrouped=function(e){var t=this.getParent();if(g(t)){if(e){t._addGroupedColumn(this.getId())}else{t._removeGroupedColumn(this.getId())}}var r=this.setProperty("grouped",e);this._updateColumns();return r};d.prototype.setSummed=function(e){var t=this.setProperty("summed",e,true);this._updateTableAnalyticalInfo();return t};d.prototype.setVisible=function(t){e.prototype.setVisible.call(this,t);this._updateColumns();return this};d.prototype.getLabel=function(){var e=this.getAggregation("label");try{if(!e){if(!this._oBindingLabel){var t=this.getParent();if(g(t)){var r=t.getBinding();if(r){this._oBindingLabel=s._getTableTemplateHelper().createLabel();this.addDependent(this._oBindingLabel);s.Binding.metadataLoaded(t).then(function(){this._oBindingLabel.setText(r.getPropertyLabel(this.getLeadingProperty()))}.bind(this))}}}e=this._oBindingLabel}}catch(e){u.warning(e)}return e};d.prototype.getFilterProperty=function(){var e=this.getProperty("filterProperty");if(!e){var t=this.getParent();if(g(t)){var r=t.getBinding();var i=this.getLeadingProperty();if(r&&r.getFilterablePropertyNames().indexOf(i)>-1){e=i}}}return e};d.prototype.getSortProperty=function(){var e=this.getProperty("sortProperty");if(!e){var t=this.getParent();if(g(t)){var r=t.getBinding();var i=this.getLeadingProperty();if(r&&r.getSortablePropertyNames().indexOf(i)>-1){e=i}}}return e};d.prototype.getFilterType=function(){var e=this.getProperty("filterType");if(!e){var t=this.getParent();if(g(t)){var r=t.getBinding();var i=this.getLeadingProperty(),a=r&&r.getProperty(i);if(a){switch(a.type){case"Edm.Time":e=d._DEFAULT_FILTERTYPES["Time"];break;case"Edm.DateTime":case"Edm.DateTimeOffset":e=d._DEFAULT_FILTERTYPES["DateTime"];break;case"Edm.Single":case"Edm.Double":case"Edm.Decimal":e=d._DEFAULT_FILTERTYPES["Float"];break;case"Edm.SByte":case"Edm.Int16":case"Edm.Int32":case"Edm.Int64":e=d._DEFAULT_FILTERTYPES["Integer"];break;case"Edm.Boolean":e=d._DEFAULT_FILTERTYPES["Boolean"];break}}}}return e};d.prototype._updateColumns=function(e,t){var r=this.getParent();if(g(r)){r._updateColumns(e,t)}};d.prototype._updateTableAnalyticalInfo=function(e){var t=this.getParent();if(t&&g(t)&&!t._bSuspendUpdateAnalyticalInfo){t.updateAnalyticalInfo(e)}};d.prototype._updateTableColumnDetails=function(){var e=this.getParent();if(e&&g(e)&&!e._bSuspendUpdateAnalyticalInfo){e._updateTableColumnDetails()}};d.prototype.shouldRender=function(){if(!this.getVisible()||!this.getTemplate()){return false}return(!this.getGrouped()||this._bLastGroupAndGrouped||this.getShowIfGrouped())&&(!this._bDependendGrouped||this._bLastGroupAndGrouped)};d.prototype.getTooltip_AsString=function(){if(!this.getTooltip()){return this._getDefaultTooltip()}return r.prototype.getTooltip_AsString.apply(this)};d.prototype.getTooltip_Text=function(){var e=r.prototype.getTooltip_Text.apply(this);if(!this.getTooltip()||!e){e=this._getDefaultTooltip()}return e};d.prototype._getDefaultTooltip=function(){var e=this.getParent();if(g(e)&&!e._getHideStandardTooltips()){var t=e.getBinding();if(t&&this.getLeadingProperty()){return t.getPropertyQuickInfo(this.getLeadingProperty())}}return null};d.prototype._menuHasItems=function(){var t=function(){var e=this.getParent();var t=e.getBinding();var r=t&&t.getAnalyticalQueryResult();return e&&r&&r.findMeasureByPropertyName(this.getLeadingProperty())}.bind(this);return e.prototype._menuHasItems.apply(this)||t()};d.prototype.isFilterableByMenu=function(){var e=this.getFilterProperty();if(!e||!this.getShowFilterMenuEntry()){return false}var t=this.getParent();if(g(t)){var r=t.getBinding();if(r){if(r.getFilterablePropertyNames().indexOf(e)>-1&&r.getProperty(e)){return true}}}return false};d.prototype.isGroupableByMenu=function(){var e=this.getParent();if(g(e)){var t=e.getBinding();if(t){var r=t.getAnalyticalQueryResult();if(r&&r.findDimensionByPropertyName(this.getLeadingProperty())&&t.getSortablePropertyNames().indexOf(this.getLeadingProperty())>-1&&t.getFilterablePropertyNames().indexOf(this.getLeadingProperty())>-1){return true}}}return false};d.prototype._isGroupableByMenu=function(){return this.isGroupableByMenu()};d.prototype._setCellContentVisibilitySettings=function(){};d.prototype._applySorters=function(){this._updateTableAnalyticalInfo(true);e.prototype._applySorters.apply(this,arguments)};return d});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/AnalyticalColumnMenu", ["./ColumnMenu","sap/ui/unified/MenuRenderer","./utils/TableUtils","./library","sap/ui/thirdparty/jquery"],function(e,t,o,u,jQuery){"use strict";var n=e.extend("sap.ui.table.AnalyticalColumnMenu",{metadata:{library:"sap.ui.table"},renderer:t});n.prototype._addMenuItems=function(){e.prototype._addMenuItems.apply(this);if(this._getColumn()){this._addSumMenuItem()}};n.prototype._addGroupMenuItem=function(){var e=this._getColumn();var t=this._getTable();if(e.isGroupableByMenu()){this._oGroupIcon=this._createMenuItem("group","TBL_GROUP",e.getGrouped()?"accept":null,function(u){var n=u.getSource();var i=!e.getGrouped();if(i&&!e.getShowIfGrouped()){var a;if(o.isNoDataVisible(t)){a=t.getDomRef("noDataCnt")}else{a=t.getDomRef("rowsel0")}if(a){a.focus()}}e._setGrouped(i);n.setIcon(i?"sap-icon://accept":null)});this.addItem(this._oGroupIcon)}};n.prototype._addSumMenuItem=function(){var e=this._getColumn();if(e._isAggregatableByMenu()){this._oSumItem=this._createMenuItem("total","TBL_TOTAL",e.getSummed()?"accept":null,jQuery.proxy(function(t){var o=t.getSource(),u=e.getSummed();e.setSummed(!u);o.setIcon(!u?"sap-icon://accept":null)},this));this.addItem(this._oSumItem)}};n.prototype.open=function(){e.prototype.open.apply(this,arguments);var t=this._getColumn();this._oSumItem&&this._oSumItem.setIcon(t.getSummed()?"sap-icon://accept":null);this._oGroupIcon&&this._oGroupIcon.setIcon(t.getGrouped()?"sap-icon://accept":null)};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/AnalyticalColumnMenuRenderer", ["sap/ui/table/AnalyticalColumnMenu"],function(e){"use strict";return e.getMetadata().getRenderer()},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/AnalyticalTable", ["./AnalyticalColumn","./Column","./Table","./TreeTable","./TableRenderer","./library","sap/ui/model/analytics/ODataModelAdapter","sap/ui/unified/MenuItem","./utils/TableUtils","./plugins/BindingSelection","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/model/controlhelper/TreeBindingProxy","sap/ui/core/library"],function(e,t,o,n,r,i,a,s,u,p,l,jQuery,d,m){"use strict";var f=i.GroupEventType;var c=i.TreeAutoExpandMode;var h=u.createWeakMapFacade();var g=o.extend("sap.ui.table.AnalyticalTable",{metadata:{library:"sap.ui.table",properties:{sumOnTop:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},numberOfExpandedLevels:{type:"int",group:"Misc",defaultValue:0,deprecated:true},autoExpandMode:{type:"string",group:"Misc",defaultValue:"Bundled",deprecated:true},columnVisibilityMenuSorter:{type:"any",group:"Appearance",defaultValue:null},collapseRecursive:{type:"boolean",defaultValue:true,deprecated:true},dirty:{type:"boolean",group:"Appearance",defaultValue:null,deprecated:true}},events:{group:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.AnalyticalColumn"}}}},designtime:"sap/ui/table/designtime/AnalyticalTable.designtime"},renderer:r});g.prototype._getFixedBottomRowContexts=function(){var e=this.getBinding();return e?[e.getGrandTotalNode()]:[]};g.prototype._getContexts=function(e,t,o){var n=this.getBinding();if(n){return n.getNodes(e,t,o)}else{return[]}};g.prototype._getRowContexts=n.prototype._getRowContexts;g.prototype.init=function(){o.prototype.init.apply(this,arguments);this.addStyleClass("sapUiAnalyticalTable");this.setShowColumnVisibilityMenu(true);this.setEnableColumnFreeze(true);this.setEnableCellFilter(true);this.setProperty("rowCountConstraints",{fixedTop:false,fixedBottom:false});this._aGroupedColumns=[];this._bSuspendUpdateAnalyticalInfo=false;this._mGroupHeaderMenuItems=null;u.Grouping.setToDefaultGroupMode(this);u.Hook.register(this,u.Hook.Keys.Row.UpdateState,y,this);u.Hook.register(this,u.Hook.Keys.Table.OpenMenu,G,this);u.Hook.register(this,u.Hook.Keys.Row.Expand,_,this);u.Hook.register(this,u.Hook.Keys.Row.Collapse,v,this);this._oProxy=new d(this,"rows")};g.prototype.exit=function(){o.prototype.exit.apply(this,arguments);this._cleanupGroupHeaderMenuItems()};g.prototype._adaptLocalization=function(e,t){return o.prototype._adaptLocalization.apply(this,arguments).then(function(){if(t){this._cleanupGroupHeaderMenuItems()}}.bind(this))};g.prototype.setFixedRowCount=function(){l.error("The property fixedRowCount is not supported by control sap.ui.table.AnalyticalTable!");return this};g.prototype.setFixedBottomRowCount=function(){l.error("The property fixedBottomRowCount is managed by control sap.ui.table.AnalyticalTable!");return this};g.prototype.setDirty=function(e){l.error("The property dirty of control sap.ui.table.AnalyticalTable is deprecated. Please use showOverlay instead.");this.setProperty("dirty",e,true);this.setShowOverlay(this.getDirty());return this};g.prototype.setEnableGrouping=function(){l.error("The property enableGrouping is not supported by the sap.ui.table.AnalyticalTable control");return this};g.prototype.setGroupBy=function(){l.warning("The groupBy association is not supported by the sap.ui.table.AnalyticalTable control");return this};g.prototype.getModel=function(e){var t=o.prototype.getModel.apply(this,arguments);var n=this.getBindingInfo("rows");if(t&&n&&n.model==e){a.apply(t)}return t};g.prototype.updateRows=function(e){o.prototype.updateRows.apply(this,arguments);if(e!=="sort"){this._invalidateColumnMenus()}};g.prototype._bindRows=function(e){delete h(this).bPendingRequest;this._applyAnalyticalBindingInfo(e);o.prototype._bindRows.call(this,e)};g.prototype._bindAggregation=function(e,t){if(e==="rows"){this._invalidateColumnMenus();this._setFirstVisibleRowIndex(0,{onlySetProperty:true})}o.prototype._bindAggregation.call(this,e,t);if(e==="rows"){this._updateTotalRow(true);u.Binding.metadataLoaded(this).then(function(){this._updateColumns(true)}.bind(this))}};g.prototype._applyAnalyticalBindingInfo=function(e){e.parameters=e.parameters||{};e.parameters.analyticalInfo=this._getColumnInformation();if(!e.parameters.hasOwnProperty("sumOnTop")){e.parameters.sumOnTop=this.getSumOnTop()}if(!e.parameters.hasOwnProperty("numberOfExpandedLevels")){e.parameters.numberOfExpandedLevels=this.getNumberOfExpandedLevels()}if(e.parameters.numberOfExpandedLevels>this._aGroupedColumns.length){e.parameters.numberOfExpandedLevels=0}if(!e.parameters.hasOwnProperty("autoExpandMode")){var t=this.getAutoExpandMode();if(t!=c.Bundled&&t!=c.Sequential){t=c.Bundled}e.parameters.autoExpandMode=t}};g.prototype._getColumnInformation=function(){var t=[],o=this.getColumns();for(var n=0;n<this._aGroupedColumns.length;n++){var r=sap.ui.getCore().byId(this._aGroupedColumns[n]);if(!r){continue}t.push({name:r.getLeadingProperty(),visible:r.getVisible(),grouped:r.getGrouped(),total:r.getSummed(),inResult:r.getInResult(),formatter:r.getGroupHeaderFormatter()})}for(var n=0;n<o.length;n++){var r=o[n];if(this._aGroupedColumns.indexOf(r.getId())>-1){continue}if(!(r instanceof e)){l.error("You have to use AnalyticalColumns for the Analytical table")}t.push({name:r.getLeadingProperty(),visible:r.getVisible(),grouped:r.getGrouped(),total:r.getSummed(),inResult:r.getInResult(),formatter:r.getGroupHeaderFormatter()})}return t};function y(e){var t=this.getBinding();var o=this.getBindingInfo("rows");var n=e.context;e.context=n.context;if(!e.context){return}if(t.nodeHasChildren(n)){e.type=e.Type.GroupHeader;e.expandable=true}else if(n.nodeState.sum){e.type=e.Type.Summary}e.level=n.level+(e.type===e.Type.Summary?1:0);e.expanded=n.nodeState.expanded;e.contentHidden=e.expanded&&!o.parameters.sumOnTop;e.title=e.type===e.Type.GroupHeader?t.getGroupName(n.context,n.level):""}function _(e){this.expand(e.getIndex())}function v(e){this.collapse(e.getIndex())}g.prototype.onRowsUpdated=function(e){o.prototype.onRowsUpdated.apply(this,arguments);var n=this.getRows();var r=this.getBinding();var i=this._getVisibleColumns()[0];for(var a=0;a<n.length;a++){var s=n[a];var u=s.getCells();var p=u.length;for(var l=0;l<p;l++){var d=t.ofCell(u[l]);var m=r?r.isMeasure(d.getLeadingProperty()):false;var f=jQuery(u[l].$().closest("td"));var c=false;if(s.isSummary()&&m){c=!d.getSummed()}else if(s.isGroupHeader()&&d===i){c=!m}f.toggleClass("sapUiTableCellHidden",c)}}};function G(e,t){var o=e.isOfType(u.CELLTYPE.ANYCONTENTCELL)?this.getRows()[e.rowIndex]:null;if(!o||!o.isGroupHeader()){this._removeGroupHeaderMenuItems(t);return}this._iGroupedLevel=o.getLevel();this._addGroupHeaderMenuItems(t)}g.prototype._addGroupHeaderMenuItems=function(e){var t=this;function o(){var e=t._iGroupedLevel-1;if(t._aGroupedColumns[e]){var o=t.getColumns().filter(function(o){return t._aGroupedColumns[e]===o.getId()})[0];return{column:o,index:e}}else{return undefined}}if(!this._mGroupHeaderMenuItems){this._mGroupHeaderMenuItems={}}if(!this._mGroupHeaderMenuItems["visibility"]){this._mGroupHeaderMenuItems["visibility"]=new s({text:u.getResourceText("TBL_SHOW_COLUMN"),select:function(){var e=o();if(e){var n=e.column,r=n.getShowIfGrouped();n.setShowIfGrouped(!r);t.fireGroup({column:n,groupedColumns:n.getParent()._aGroupedColumns,type:!r?f.showGroupedColumn:f.hideGroupedColumn})}}})}e.addItem(this._mGroupHeaderMenuItems["visibility"]);if(!this._mGroupHeaderMenuItems["ungroup"]){this._mGroupHeaderMenuItems["ungroup"]=new s({text:u.getResourceText("TBL_UNGROUP"),select:function(){var e=o();if(e&&e.column){var n=e.column;n.setGrouped(false);t.fireGroup({column:n,groupedColumns:t._aGroupedColumns,type:f.ungroup})}}})}e.addItem(this._mGroupHeaderMenuItems["ungroup"]);if(!this._mGroupHeaderMenuItems["ungroupall"]){this._mGroupHeaderMenuItems["ungroupall"]=new s({text:u.getResourceText("TBL_UNGROUP_ALL"),select:function(){var e=t.getColumns();t.suspendUpdateAnalyticalInfo();for(var o=0;o<e.length;o++){e[o].setGrouped(false)}t.resumeUpdateAnalyticalInfo();t.fireGroup({column:undefined,groupedColumns:[],type:f.ungroupAll})}})}e.addItem(this._mGroupHeaderMenuItems["ungroupall"]);if(!this._mGroupHeaderMenuItems["moveup"]){this._mGroupHeaderMenuItems["moveup"]=new s({text:u.getResourceText("TBL_MOVE_UP"),select:function(){var e=o();if(e){var n=e.column;var r=t._aGroupedColumns.indexOf(n.getId());if(r>0){t._aGroupedColumns[r]=t._aGroupedColumns.splice(r-1,1,t._aGroupedColumns[r])[0];t.updateAnalyticalInfo();t.fireGroup({column:n,groupedColumns:n.getParent()._aGroupedColumns,type:f.moveUp})}}},icon:"sap-icon://arrow-top"})}e.addItem(this._mGroupHeaderMenuItems["moveup"]);if(!this._mGroupHeaderMenuItems["movedown"]){this._mGroupHeaderMenuItems["movedown"]=new s({text:u.getResourceText("TBL_MOVE_DOWN"),select:function(){var e=o();if(e){var n=e.column;var r=t._aGroupedColumns.indexOf(n.getId());if(r<t._aGroupedColumns.length){t._aGroupedColumns[r]=t._aGroupedColumns.splice(r+1,1,t._aGroupedColumns[r])[0];t.updateAnalyticalInfo();t.fireGroup({column:n,groupedColumns:n.getParent()._aGroupedColumns,type:f.moveDown})}}},icon:"sap-icon://arrow-bottom"})}e.addItem(this._mGroupHeaderMenuItems["movedown"]);if(!this._mGroupHeaderMenuItems["sortasc"]){this._mGroupHeaderMenuItems["sortasc"]=new s({text:u.getResourceText("TBL_SORT_ASC"),select:function(){o()?.column._sort(m.SortOrder.Ascending)},icon:"sap-icon://up"})}e.addItem(this._mGroupHeaderMenuItems["sortasc"]);if(!this._mGroupHeaderMenuItems["sortdesc"]){this._mGroupHeaderMenuItems["sortdesc"]=new s({text:u.getResourceText("TBL_SORT_DESC"),select:function(){o()?.column._sort(m.SortOrder.Descending)},icon:"sap-icon://down"})}e.addItem(this._mGroupHeaderMenuItems["sortdesc"]);if(!this._mGroupHeaderMenuItems["collapse"]){this._mGroupHeaderMenuItems["collapse"]=new s({text:u.getResourceText("TBL_COLLAPSE_LEVEL"),select:function(){t.getBinding().collapseToLevel(t._iGroupedLevel-1);t.setFirstVisibleRow(0);t._getSelectionPlugin().clearSelection()}})}e.addItem(this._mGroupHeaderMenuItems["collapse"]);if(!this._mGroupHeaderMenuItems["collapseall"]){this._mGroupHeaderMenuItems["collapseall"]=new s({text:u.getResourceText("TBL_COLLAPSE_ALL"),select:function(){t.getBinding().collapseToLevel(0);t.setFirstVisibleRow(0);t._getSelectionPlugin().clearSelection()}})}e.addItem(this._mGroupHeaderMenuItems["collapseall"]);if(!this._mGroupHeaderMenuItems["expand"]){this._mGroupHeaderMenuItems["expand"]=new s({text:u.getResourceText("TBL_EXPAND_LEVEL"),select:function(){t.getBinding().expandToLevel(t._iGroupedLevel);t.setFirstVisibleRow(0);t._getSelectionPlugin().clearSelection()}})}e.addItem(this._mGroupHeaderMenuItems["expand"]);if(!this._mGroupHeaderMenuItems["expandall"]){this._mGroupHeaderMenuItems["expandall"]=new s({text:u.getResourceText("TBL_EXPAND_ALL"),select:function(){t.expandAll()}})}e.addItem(this._mGroupHeaderMenuItems["expandall"]);var n=o();if(n){var r=n.column;if(r.getShowIfGrouped()){this._mGroupHeaderMenuItems["visibility"].setText(u.getResourceText("TBL_HIDE_COLUMN"))}else{this._mGroupHeaderMenuItems["visibility"].setText(u.getResourceText("TBL_SHOW_COLUMN"))}this._mGroupHeaderMenuItems["moveup"].setEnabled(n.index>0);this._mGroupHeaderMenuItems["movedown"].setEnabled(n.index<this._aGroupedColumns.length-1)}else{this._mGroupHeaderMenuItems["moveup"].setEnabled(true);this._mGroupHeaderMenuItems["movedown"].setEnabled(true)}};g.prototype._removeGroupHeaderMenuItems=function(e){if(!this._mGroupHeaderMenuItems){return}for(var t in this._mGroupHeaderMenuItems){e.removeItem(this._mGroupHeaderMenuItems[t])}};g.prototype._cleanupGroupHeaderMenuItems=function(){for(var e in this._mGroupHeaderMenuItems){this._mGroupHeaderMenuItems[e].destroy()}this._mGroupHeaderMenuItems=null};g.prototype.getContextByIndex=function(e){return this._oProxy.getContextByIndex(e)};g.prototype.getContextInfoByIndex=function(e){return this._oProxy.getNodeByIndex(e)};g.prototype.suspendUpdateAnalyticalInfo=function(){this._bSuspendUpdateAnalyticalInfo=true};g.prototype.resumeUpdateAnalyticalInfo=function(e,t){this._bSuspendUpdateAnalyticalInfo=false;this._updateColumns(e,t)};g.prototype.addColumn=function(e,t){var n=this._getColumn(e);if(n.getGrouped()){this._addGroupedColumn(n.getId())}o.prototype.addColumn.call(this,n,t);this._updateColumns(t);return this};g.prototype.insertColumn=function(e,t,n){var r=this._getColumn(e);if(r.getGrouped()){this._addGroupedColumn(r.getId())}o.prototype.insertColumn.call(this,r,t,n);this._updateColumns(n);return this};g.prototype.removeColumn=function(e,t){var n=o.prototype.removeColumn.apply(this,arguments);if(!this._bReorderInProcess){this._aGroupedColumns=jQuery.grep(this._aGroupedColumns,function(t){if(e.getId){return t!=e.getId()}else{return t==e}})}this.updateAnalyticalInfo(t);return n};g.prototype.removeAllColumns=function(e){this._aGroupedColumns=[];var t=o.prototype.removeAllColumns.apply(this,arguments);this._updateColumns(e);return t};g.prototype._getColumn=function(t){if(typeof t==="string"){var o=new e({leadingProperty:t,template:t,managed:true});return o}else if(t instanceof e){return t}else{throw new Error("Wrong column type. You need to define a string (property) or pass an AnalyticalColumnObject")}};g.prototype._updateColumns=function(e,t){if(!this._bSuspendUpdateAnalyticalInfo){this._updateTableColumnDetails();this.updateAnalyticalInfo(e,t);if(this.bOutput){this.invalidate()}}};g.prototype.updateAnalyticalInfo=function(e,t){if(this._bSuspendUpdateAnalyticalInfo){return}var o=this.getBinding();if(o){var n=this._getColumnInformation();var r=o.getNumberOfExpandedLevels()||0;if(r>this._aGroupedColumns.length){o.setNumberOfExpandedLevels(0)}o.updateAnalyticalInfo(n,t);this._updateTotalRow(e);if(!e){this._getRowContexts()}}};g.prototype.refreshRows=function(){o.prototype.refreshRows.apply(this,arguments);this._updateTotalRow()};g.prototype._updateTotalRow=function(e){var t=this.getBinding();this.setProperty("rowCountConstraints",{fixedTop:false,fixedBottom:t?t.providesGrandTotal()&&t.hasTotaledMeasures():false},e)};g.prototype._updateTableColumnDetails=function(){if(this._bSuspendUpdateAnalyticalInfo){return}var e=this.getBinding(),t=e&&e.getAnalyticalQueryResult();if(t){var o=this.getColumns(),n=[],r=[],i=[],a={},s,u;for(var p=0;p<o.length;p++){s=o[p];s._isLastGroupableLeft=false;s._bLastGroupAndGrouped=false;s._bDependendGrouped=false;if(!s.getVisible()){continue}var l=s.getLeadingProperty();u=t.findDimensionByPropertyName(l);if(u){var d=u.getName();if(!a[d]){a[d]={dimension:u,columns:[s]}}else{a[d].columns.push(s)}if(s.getGrouped()&&n.indexOf(d)==-1){n.push(d)}if(i.indexOf(d)==-1){i.push(d)}}}r=jQuery.grep(i,function(e){return n.indexOf(n,e)==-1});if(n.length>0){jQuery.each(n,function(e,t){jQuery.each(a[t].columns,function(e,t){if(!t.getGrouped()){t._bDependendGrouped=true}})});if(n.length==i.length){u=t.findDimensionByPropertyName(sap.ui.getCore().byId(this._aGroupedColumns[this._aGroupedColumns.length-1]).getLeadingProperty());var m=a[u.getName()].columns;jQuery.each(m,function(e,t){t._bLastGroupAndGrouped=true})}}if(r.length==1){jQuery.each(a[r[0]].columns,function(e,t){t._isLastGroupableLeft=true})}}};g.prototype._getFirstMeasureColumnIndex=function(){var e=this.getBinding(),t=e&&e.getAnalyticalQueryResult(),o=this._getVisibleColumns();if(!t){return-1}for(var n=0;n<o.length;n++){var r=o[n],i=r.getLeadingProperty();if(t.findMeasureByName(i)||t.findMeasureByPropertyName(i)){return n}}};g.prototype._getTotalRowCount=function(){var e=o.prototype._getTotalRowCount.apply(this,arguments);if(e===1){var t=this.getBinding();var n=t?t.providesGrandTotal()&&t.hasTotaledMeasures():false;if(n){e=0}}return e};g.prototype.getTotalSize=function(){var e=this.getBinding();if(e){return e.getTotalSize()}return 0};g.prototype._onPersoApplied=function(){o.prototype._onPersoApplied.apply(this,arguments);this._aGroupedColumns=[];var e=this.getColumns();for(var t=0,n=e.length;t<n;t++){if(e[t].getGrouped()){this._addGroupedColumn(e[t].getId())}}this._updateColumns()};g.prototype._addGroupedColumn=function(e){if(this._aGroupedColumns.indexOf(e)===-1){this._aGroupedColumns.push(e)}};g.prototype._removeGroupedColumn=function(e){var t=this._aGroupedColumns.indexOf(e);if(t>=0){this._aGroupedColumns.splice(t,1)}};g.prototype.getGroupedColumns=function(){return this._aGroupedColumns};g.prototype.setCollapseRecursive=function(e){this._oProxy.setCollapseRecursive(e);this.setProperty("collapseRecursive",!!e,true);return this};g.prototype.expand=n.prototype.expand;g.prototype.collapse=n.prototype.collapse;g.prototype.expandAll=function(){this._oProxy.expandToLevel(this._aGroupedColumns.length);this.setFirstVisibleRow(0);this._getSelectionPlugin().clearSelection();return this};g.prototype.collapseAll=n.prototype.collapseAll;g.prototype.isExpanded=n.prototype.isExpanded;g.prototype.getAnalyticalInfoOfRow=function(e){var t=this.getBinding();var o=e?e.getRowBindingContext():null;if(!u.isA(e,"sap.ui.table.Row")||e.getParent()!==this||!t||!o){return null}var n=o===t.getGrandTotalContext();var r=null;var i=-1;if(n){r=t.getGrandTotalContextInfo();i=0}else{r=this.getContextInfoByIndex(e.getIndex());if(r){i=r.level}}var a=r&&t.nodeHasChildren&&t.nodeHasChildren(r);var s=!a&&!n&&r&&r.nodeState&&r.nodeState.sum;var p=[];if(s||a){var l=this.getGroupedColumns();if(l.length>0&&i>0&&i<=l.length){for(var d=0;d<i;d++){p.push(l[d])}}}return{grandTotal:n,group:a,groupTotal:s,level:i,context:o,groupedColumns:p}};g.prototype._createLegacySelectionPlugin=function(){return new p};g.prototype._setRowCountConstraints=function(){};g.prototype._onBindingDataRequested=function(e){if(e.getParameter("__simulateAsyncAnalyticalBinding")){return}var t=this.getBinding();if(!t.bUseBatchRequests){h(this).bPendingRequest=true}o.prototype._onBindingDataRequested.apply(this,arguments)};g.prototype._onBindingDataReceived=function(e){if(e.getParameter("__simulateAsyncAnalyticalBinding")){return}var t=this.getBinding();if(!t.bUseBatchRequests){h(this).bPendingRequest=false}o.prototype._onBindingDataReceived.apply(this,arguments)};g.prototype._hasPendingRequests=function(){if(h(this).hasOwnProperty("bPendingRequest")){return h(this).bPendingRequest}else{return o.prototype._hasPendingRequests.apply(this,arguments)}};return g});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/AnalyticalTableRenderer", ["sap/ui/table/AnalyticalTable"],function(e){"use strict";return e.getMetadata().getRenderer()},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/Column", ["./utils/TableUtils","./menus/ColumnHeaderMenuAdapter","sap/ui/core/Core","sap/ui/core/Element","sap/ui/core/library","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/model/FilterType","sap/ui/model/Sorter","sap/ui/model/Type","sap/ui/model/type/String","sap/base/util/ObjectPath","sap/base/util/JSTokenizer","sap/base/Log"],function(e,t,r,i,a,o,n,l,s,u,p,f,d,g){"use strict";var h=a.HorizontalAlign;var y=a.SortOrder;var c=a.ValueState;var m={Standard:"Standard",Creation:"Creation"};var b=e.createWeakMapFacade();var v=new window.WeakMap;var T=i.extend("sap.ui.table.Column",{metadata:{library:"sap.ui.table",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},minWidth:{type:"int",group:"Dimension",defaultValue:0},flexible:{type:"boolean",group:"Behavior",defaultValue:true,deprecated:true},resizable:{type:"boolean",group:"Behavior",defaultValue:true},hAlign:{type:"sap.ui.core.HorizontalAlign",group:"Appearance",defaultValue:h.Begin},sorted:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},sortOrder:{type:"sap.ui.core.SortOrder",group:"Appearance",defaultValue:y.None},sortProperty:{type:"string",group:"Behavior",defaultValue:null},filtered:{type:"boolean",group:"Appearance",defaultValue:false},filterProperty:{type:"string",group:"Behavior",defaultValue:null},filterValue:{type:"string",group:"Behavior",defaultValue:null},filterOperator:{type:"string",group:"Behavior",defaultValue:null},defaultFilterOperator:{type:"string",group:"Behavior",defaultValue:null},filterType:{type:"any",group:"Misc",defaultValue:null},grouped:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},visible:{type:"boolean",group:"Appearance",defaultValue:true},name:{type:"string",group:"Appearance",defaultValue:null},showFilterMenuEntry:{type:"boolean",group:"Appearance",defaultValue:true},showSortMenuEntry:{type:"boolean",group:"Appearance",defaultValue:true},headerSpan:{type:"any",group:"Behavior",defaultValue:1},autoResizable:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"label",aggregations:{label:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},multiLabels:{type:"sap.ui.core.Control",multiple:true,singularName:"multiLabel"},template:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},creationTemplate:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},menu:{type:"sap.ui.unified.Menu",multiple:false}},associations:{headerMenu:{type:"sap.ui.core.IColumnHeaderMenu",multiple:false}},events:{columnMenuOpen:{allowPreventDefault:true,parameters:{menu:{type:"sap.ui.unified.Menu"}}}}}});T._DEFAULT_FILTER_TYPE=new p;T.prototype.init=function(){this.mSkipPropagation={template:true,creationTemplate:true};b(this).oSorter=null;b(this).mCellContentVisibilitySettings=F(this);b(this).bHasDefaultLabel=false;b(this).bHasDefaultTemplate=false;this._initTemplateClonePool()};T.prototype._initTemplateClonePool=function(){this._mTemplateClones=Object.keys(m).reduce(function(e,t){e[t]=[];return e},{})};T.prototype.exit=function(){this._destroyTemplateClones();t.unlink(this)};T.prototype.invalidate=function(t){if(t!==this.getTemplate()&&t!==this.getCreationTemplate()&&!e.isA(t,"sap.ui.table.ColumnMenu")){i.prototype.invalidate.apply(this,arguments)}};T.prototype.setLabel=function(t){var r=t;if(typeof t==="string"){if(b(this).bHasDefaultLabel){this.getLabel().setText(t);return this}r=e._getTableTemplateHelper().createLabel({text:t});b(this).bHasDefaultLabel=true}else if(b(this).bHasDefaultLabel){this.destroyLabel();b(this).bHasDefaultLabel=false}if(r&&r.setIsInColumnHeaderContext){r.setIsInColumnHeaderContext(true)}var i=this.getLabel();if(i&&r!==i&&i.setIsInColumnHeaderContext){i.setIsInColumnHeaderContext(false)}return this.setAggregation("label",r)};T.prototype.setTemplate=function(t){var r=t;var i=this._getTable();var a=this.getTemplate();var o=true;if(typeof t==="string"){if(b(this).bHasDefaulTemplate){this.getTemplate().bindProperty("text",t);o=false}else{r=e._getTableTemplateHelper().createTextView().bindProperty("text",t);b(this).bHasDefaulTemplate=true}}else if(b(this).bHasDefaulTemplate){this.destroyTemplate();b(this).bHasDefaulTemplate=false}if(o){this.setAggregation("template",r,true)}if(this.getVisible()){this.invalidate()}this._destroyTemplateClones("Standard");if(i&&this.getVisible()){if(r){i.invalidateRowsAggregation()}if(!a||!r){var n=i.getCreationRow();if(n){n._update()}}}return this};T.prototype.destroyTemplate=function(){this.destroyAggregation("template");this._destroyTemplateClones("Standard");var e=this._getTable();var t=e?e.getCreationRow():null;if(t){t._update()}return this};T.prototype.setCreationTemplate=function(e){var t=this._getTable();this.setAggregation("creationTemplate",e,true);this._destroyTemplateClones("Creation");if(e&&t&&this.getVisible()){var r=t.getCreationRow();if(r){r._update()}}return this};T.prototype.getCreationTemplate=function(){return this.getAggregation("creationTemplate")};T.prototype.destroyCreationTemplate=function(){this.destroyAggregation("creationTemplate",true);this._destroyTemplateClones("Creation");return this};T.prototype._menuHasItems=function(){var t=this._getTable();var r=(t?t.getEnableColumnFreeze():false)||(t?t.getShowColumnVisibilityMenu():false)||this.isSortableByMenu()||this.isFilterableByMenu()||this.isGroupableByMenu();if(r){return true}return e.Hook.call(t,e.Hook.Keys.Column.MenuItemNotification,this).some(function(e){return e})};T.prototype.isFilterableByMenu=function(){return!!(this.getFilterProperty()&&this.getShowFilterMenuEntry())};T.prototype.isSortableByMenu=function(){return!!(this.getSortProperty()&&this.getShowSortMenuEntry())};T.prototype.isGroupableByMenu=function(){var e=this._getTable();return!!(e&&e.getEnableGrouping&&e.getEnableGrouping()&&this.getSortProperty())};T.prototype._isGroupableByMenu=function(){var e=false;e=this.isGroupableByMenu();return e};T.prototype.setSorted=function(e){if(e&&this.getSortOrder()===y.None&&!this.isBound("sortOrder")){this.setSortOrder(y.Ascending)}return this.setProperty("sorted",e)};T.prototype.setFilterValue=function(e){return this.setProperty("filterValue",e,true)};T.prototype.setFilterOperator=function(e){return this.setProperty("filterOperator",e,true)};T.prototype.setDefaultFilterOperator=function(e){return this.setProperty("defaultFilterOperator",e,true)};T.prototype._openHeaderMenu=function(e){var r=this.getHeaderMenuInstance();this._cellPressed=e;t.activateFor(this).then(function(){if(r){r.openBy(e)}})};T.prototype._isHeaderMenuOpen=function(){var e=this.getHeaderMenuInstance();if(e){return e.isOpen()}};T.prototype._setGrouped=function(e){var t=this._getTable();t.setGroupBy(e?this:null)};T.prototype._isAggregatableByMenu=function(){return false};T.prototype.toggleSort=function(){this.sort(this.getSorted()&&this.getSortOrder()===y.Ascending)};T.prototype.sort=function(e,t){this._sort(e?y.Descending:y.Ascending,t);return this};T.prototype._sort=function(e,t){var r=this._getTable();if(!r||this.getSortProperty()===""){return}var i=r.fireSort({column:this,sortOrder:e,columnAdded:e!==y.None&&t===true});if(!i){return}if(e===y.None){r._removeSortedColumn(this)}else{r.pushSortedColumn(this,t)}this.setSorted(e!==y.None);this.setSortOrder(e);this._updateSorters()};T.prototype._updateSorters=function(){var e=this._getTable();var t=e.getSortedColumns();var r=e.getColumns();var i=this.getSortOrder();for(let e=0,i=r.length;e<i;e++){if(t.indexOf(r[e])<0){r[e].resetProperty("sorted");r[e].resetProperty("sortOrder");delete b(r[e]).oSorter}}if(i!==y.None){b(this).oSorter=new s(this.getSortProperty(),i===y.Descending)}this._applySorters()};T.prototype._applySorters=function(){const e=this._getTable();const t=e.getBinding();if(!t){g.warning("Sorting not performed because no binding present",this);return}const r=e.getSortedColumns();const i=r.map(e=>b(e).oSorter);t.sort(i)};T.prototype._getFilterState=function(){try{this._getFilter();return c.None}catch(e){return c.Error}};T.prototype._getFilter=function(){var e,t=this.getFilterProperty(),r=this.getFilterValue(),i=this.getFilterOperator(),a,l,s=this.getFilterType()||T._DEFAULT_FILTER_TYPE,u=s instanceof p,f;if(r){if(!i){f=r.match(/(.*)\s*\.\.\s*(.*)/);if(r.indexOf("=")==0){i=n.EQ;a=r.substr(1)}else if(r.indexOf("!=")==0){i=n.NE;a=r.substr(2)}else if(r.indexOf("<=")==0){i=n.LE;a=r.substr(2)}else if(r.indexOf("<")==0){i=n.LT;a=r.substr(1)}else if(r.indexOf(">=")==0){i=n.GE;a=r.substr(2)}else if(r.indexOf(">")==0){i=n.GT;a=r.substr(1)}else if(f){if(f[1]&&f[2]){i=n.BT;a=f[1];l=f[2]}else if(f[1]&&!f[2]){i=n.GE;a=f[1]}else{i=n.LE;a=f[2]}}else if(u&&r.indexOf("*")==0&&r.lastIndexOf("*")==r.length-1){i=n.Contains;a=r.substr(1,r.length-2)}else if(u&&r.indexOf("*")==0){i=n.EndsWith;a=r.substr(1)}else if(u&&r.lastIndexOf("*")==r.length-1){i=n.StartsWith;a=r.substr(0,r.length-1)}else{if(this.getDefaultFilterOperator()){i=this.getDefaultFilterOperator()}else if(u){i=n.Contains}else{i=n.EQ}a=r.substr(0)}if(!l){e=new o(t,i,this._parseFilterValue(a))}else{e=new o(t,i,this._parseFilterValue(a),this._parseFilterValue(l))}}else{e=new o(t,i,this._parseFilterValue(r))}}return e};T.prototype.filter=function(t){var r=this._getTable();if(r&&r.isBound("rows")){var i=r.fireFilter({column:this,value:t});if(i){this.setFiltered(!!t);this.setFilterValue(t);var a=[];var o=r.getColumns();for(var n=0,s=o.length;n<s;n++){var u=o[n],p,f;try{p=u._getFilter();f=c.None}catch(e){f=c.Error}if(p){a.push(p)}e.Hook.call(this._getTable(),e.Hook.Keys.Column.SetFilterState,u,f)}r.getBinding().filter(a,l.Control)}}return this};T.prototype._parseFilterValue=function(e){var t=this.getFilterType();if(t){if(typeof t==="function"){e=t(e)}else{e=t.parseValue(e,"string")}}return e};T.prototype.shouldRender=function(){var e=this.getVisible()&&this.getTemplate()!=null;e=e&&!this.getGrouped();return e};T.prototype.setProperty=function(e,t){var r=this._getTable();var a=r&&this.getProperty(e)!=t;var o=a&&e==="visible";var n=a&&(e==="visible"||e==="headerSpan");var l=i.prototype.setProperty.apply(this,arguments);if(o){r.invalidateRowsAggregation();var s=r.getCreationRow();if(s){s._update()}}if(n){r._invalidateComputedFixedColumnCount()}return l};T.prototype.setFilterType=function(e){var t=e;if(typeof e==="string"){try{var r=d.parseJS(e);if(typeof r.type==="string"){var i=sap.ui.require(r.type.replaceAll(".","/"));if(!i){i=f.get(e)}t=i&&new i(r.formatOptions,r.constraints)}}catch(r){var i=sap.ui.require(e.replaceAll(".","/"));if(!i){i=f.get(e)}t=i&&new i}if(!(t instanceof u)){g.error("The filter type is not an instance of sap.ui.model.Type! Ignoring the filter type!");t=undefined}}this.setProperty("filterType",t,true);return this};T.prototype.getIndex=function(){var e=this._getTable();if(e){return e.indexOfColumn(this)}else{return-1}};T.prototype.isDragAllowed=function(t){return e.Column.isColumnMovable(this,true)};T.prototype._getFreeTemplateClone=function(e){var t=this._mTemplateClones[e];var r=null;if(!t){return null}for(var i=0;i<t.length;i++){if(!t[i]||t[i].bIsDestroyed){t.splice(i,1);i--}else if(!r&&!t[i].getParent()){r=t[i]}}return r};T.prototype.getTemplateClone=function(e,t){if(typeof e!=="number"||this.getTemplate()==null){return null}var r=t==null?"Standard":t;var i=this._getFreeTemplateClone(r);if(!i&&m.hasOwnProperty(r)){var a=this["get"+(r==="Standard"?"":r)+"Template"];var o=a.call(this);if(o){i=o.clone();this._mTemplateClones[r].push(i)}}if(i){v.set(i,this);var n=this._getTable();if(n){n._getAccExtension().addColumnHeaderLabel(this,i)}}return i};function C(e){for(var t=0;t<e.length;t++){if(e[t]!=null&&!e[t].bIsDestroyed){e[t].destroy()}}}T.prototype._destroyTemplateClones=function(e){if(e==null){for(var t in m){C(this._mTemplateClones[t])}this._initTemplateClonePool()}else{C(this._mTemplateClones[e]);this._mTemplateClones[e]=[]}};T.prototype._getTable=function(){var t=this.getParent();return e.isA(t,"sap.ui.table.Table")?t:null};T.prototype._setCellContentVisibilitySettings=function(e){_(e);b(this).mCellContentVisibilitySettings=F(this,e)};T.prototype._getCellContentVisibilitySettings=function(){return b(this).mCellContentVisibilitySettings};T.prototype.getHeaderMenuInstance=function(){return r.byId(this.getHeaderMenu())};function _(e){if(e==null){return}S(e,null,false,["standard","groupHeader","summary"]);S(e.standard,"standard",true);S(e.groupHeader,"groupHeader",true,["nonExpandable","expanded","collapsed"]);S(e.summary,"summary",true,["group","total"])}function S(e,t,r,i){if(e!=null&&!(r&&typeof e==="boolean"||i&&typeof e==="object")){throw new Error("Invalid value"+(t?" for '"+t+"'":""))}if(i&&e!=null&&typeof e==="object"){Object.keys(e).forEach(function(r){if(i.includes(r)){if(t!=null){S(e[r],t+"."+r,true)}}else{throw new Error("Unsupported setting '"+(t?t+".":"")+r+"'")}})}}function F(e,t){t=t?t:{};return{standard:V(t.standard),groupHeader:{nonExpandable:V(t.groupHeader,"nonExpandable"),expanded:V(t.groupHeader,"expanded"),collapsed:V(t.groupHeader,"collapsed")},summary:{group:V(t.summary,"group"),total:V(t.summary,"total")}}}function V(e,t){if(typeof e==="boolean"){return e}else if(t&&e){return e[t]!==false}else{return true}}T.ofCell=function(e){return v.get(e)||null};return T});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/ColumnMenu", ["./library","sap/ui/unified/Menu","sap/ui/unified/MenuItem","sap/ui/unified/MenuTextFieldItem","sap/ui/unified/MenuRenderer","./utils/TableUtils","sap/base/assert","sap/ui/thirdparty/jquery"],function(e,t,i,n,o,u,r,jQuery){"use strict";var l=new window.WeakMap;var a=t.extend("sap.ui.table.ColumnMenu",{metadata:{library:"sap.ui.table"},renderer:o});a.prototype.init=function(){if(t.prototype.init){t.prototype.init.apply(this,arguments)}this.addStyleClass("sapUiTableColumnMenu");this._bInvalidated=true;this._iPopupClosedTimeoutId=null};a.prototype.exit=function(){if(t.prototype.exit){t.prototype.exit.apply(this,arguments)}window.clearTimeout(this._iPopupClosedTimeoutId);a._destroyColumnVisibilityMenuItem(this._getTable())};a.prototype.onThemeChanged=function(){if(this.getDomRef()){this._invalidate()}};a.prototype.setParent=function(e){this._invalidate();return t.prototype.setParent.apply(this,arguments)};a.prototype._getColumn=function(){var e=this.getParent();return u.isA(e,"sap.ui.table.Column")?e:null};a.prototype._getTable=function(){var e=this._getColumn();return e?e._getTable():null};a._destroyColumnVisibilityMenuItem=function(e){if(!e||!e._oColumnVisibilityMenuItem){return}e._oColumnVisibilityMenuItem.destroy();e._oColumnVisibilityMenuItem=null};a.prototype._removeColumnVisibilityFromAggregation=function(){var e=this._getTable();if(!e||e._oColumnVisibilityMenuItem){return}this.removeAggregation("items",e._oColumnVisibilityMenuItem,true)};a.prototype._invalidate=function(){this._removeColumnVisibilityFromAggregation();this.destroyItems();this._bInvalidated=true};a.prototype.open=function(){if(!this._bInvalidated&&this._getColumn()){this._addColumnVisibilityMenuItem()}if(this._bInvalidated){this._bInvalidated=false;this._addMenuItems()}u.Hook.call(this._getTable(),u.Hook.Keys.Table.OpenMenu,u.getCellInfo(arguments[4]),this);if(this.getItems().length>0){this._lastFocusedDomRef=arguments[4];t.prototype.open.apply(this,arguments)}};a.prototype._addMenuItems=function(){if(this._getColumn()){this._addSortMenuItem(false);this._addSortMenuItem(true);this._addFilterMenuItem();this._addGroupMenuItem();this._addFreezeMenuItem();this._addColumnVisibilityMenuItem()}};a.prototype._addSortMenuItem=function(e){var t=this._getColumn();if(t.isSortableByMenu()){var i=e?"desc":"asc";var n=e?"sort-descending":"sort-ascending";this.addItem(this._createMenuItem(i,"TBL_SORT_"+i.toUpperCase(),n,function(i){t.sort(e,i.getParameter("ctrlKey")===true)}))}};a.prototype._addFilterMenuItem=function(){var e=this._getColumn();if(e.isFilterableByMenu()){var t=e.getParent();var i=t&&t.getEnableCustomFilter();if(i){this.addItem(this._createMenuItem("filter","TBL_FILTER_ITEM","filter",function(){t.fireCustomFilter({column:e})}))}else{this.addItem(this._createMenuTextFieldItem("filter","TBL_FILTER","filter",e.getFilterValue(),function(){e.filter(this.getValue())}))}}};a.prototype._addGroupMenuItem=function(){var e=this._getColumn();if(e.isGroupableByMenu()){var t=this._getTable();this.addItem(this._createMenuItem("group","TBL_GROUP",null,function(){var i;t.setGroupBy(e);if(u.isNoDataVisible(t)){i=t.getDomRef("noDataCnt")}else{i=t.getDomRef("rowsel0")}if(i){i.focus()}}))}};a.prototype._addFreezeMenuItem=function(){var e=this._getColumn();var t=this._getTable();var i=t&&t.getEnableColumnFreeze();if(i){var n=e.getIndex();var o=n+u.Column.getHeaderSpan(e)==t.getComputedFixedColumnCount();this.addItem(this._createMenuItem("freeze",o?"TBL_UNFREEZE":"TBL_FREEZE",null,function(){var i=t.fireColumnFreeze({column:e});if(i){if(o){t.setFixedColumnCount(0)}else{t.setFixedColumnCount(n+1)}}}))}};a.prototype._addColumnVisibilityMenuItem=function(){var e=this._getTable();if(e&&e.getShowColumnVisibilityMenu()){if(!e._oColumnVisibilityMenuItem||e._oColumnVisibilityMenuItem.bIsDestroyed){e._oColumnVisibilityMenuItem=this._createMenuItem("column-visibilty","TBL_COLUMNS");var i=new t(e._oColumnVisibilityMenuItem.getId()+"-menu");e._oColumnVisibilityMenuItem.setSubmenu(i)}this.addItem(e._oColumnVisibilityMenuItem);this._updateColumnVisibilityMenuItem()}};a.prototype._createColumnVisibilityMenuItem=function(e){var t=this._getTable();var n=u.Column.getHeaderText(e);return new i({text:n,icon:e.getVisible()?"sap-icon://accept":null,ariaLabelledBy:[t.getId()+(e.getVisible()?"-ariahidecolmenu":"-ariashowcolmenu")],select:jQuery.proxy(function(i){var n=!e.getVisible();if(n||u.getVisibleColumnCount(t)>1){var o=true;if(u.isA(t,"sap.ui.table.Table")){o=t.fireColumnVisibility({column:e,newVisible:n})}if(o){if(t.getFocusDomRef().getAttribute("id")===e.getId()){var r=t._getVisibleColumns();r[Math.min(r.indexOf(e)+1,u.getVisibleColumnCount(t)-2)].focus()}e.setVisible(n)}}},this)})};a.prototype._createMenuItem=function(e,t,n,o){return new i(this.getId()+"-"+e,{text:u.getResourceText(t),icon:n?"sap-icon://"+n:null,select:o||function(){}})};a.prototype._createMenuTextFieldItem=function(e,t,i,o,r){r=r||function(){};return new n(this.getId()+"-"+e,{label:u.getResourceText(t),icon:i?"sap-icon://"+i:null,value:o,select:r||function(){}})};a.prototype._setFilterValue=function(e){var t=this.getParent();var i=t?t.getParent():undefined;var n=sap.ui.getCore().byId(this.getId()+"-filter");if(n&&n.setValue&&(i&&!i.getEnableCustomFilter())){n.setValue(e)}return this};a.prototype._setFilterState=function(e){var t=this.getParent();var i=t?t.getParent():undefined;var n=sap.ui.getCore().byId(this.getId()+"-filter");if(n&&n.setValueState&&(i&&!i.getEnableCustomFilter())){n.setValueState(e)}return this};function s(e){var t=e.getColumns();if(e.getColumnVisibilityMenuSorter&&typeof e.getColumnVisibilityMenuSorter==="function"){var i=e.getColumnVisibilityMenuSorter();if(typeof i==="function"){t=t.sort(i)}}return t}function m(e,t){if(t.isA("sap.ui.table.AnalyticalColumn")){var i=e.getAnalyticalQueryResult();var n=i.getEntityType();var o=e.getModel().getProperty("/#"+n.getTypeDescription().name+"/"+t.getLeadingProperty()+"/sap:visible");if(o&&(o.value==="false"||o.value===false)){return true}}return false}a.prototype._updateColumnVisibilityMenuItem=function(){var e=this._getTable();if(!e||!e._oColumnVisibilityMenuItem){return}var t=e._oColumnVisibilityMenuItem.getSubmenu();if(!t){return}var i=s(e);var n=t.getItems();var o=e._getVisibleColumns();var r=e.getBinding();var a=u.isA(r,"sap.ui.model.analytics.AnalyticalBinding");for(var d=0;d<i.length;d++){var p=i[d];if(a){if(m(r,p)){continue}}var f=l.get(p);if(!f||f.bIsDestroyed){var f=this._createColumnVisibilityMenuItem(p);t.insertItem(f,d);l.set(p,f)}else{var g=n.indexOf(f);if(d!==g){t.removeItem(f);t.insertItem(f,d)}}var y=o.indexOf(p)>-1;var c=y?"sap-icon://accept":"";n=t.getItems();n[d].setProperty("icon",c);n[d].setEnabled(!y||o.length>1);n[d].removeAllAriaLabelledBy();n[d].addAriaLabelledBy(e.getId()+(y?"-ariahidecolmenu":"-ariashowcolmenu"))}for(var d=n.length;d>i.length;d--){n[d-1].destroy()}};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/ColumnMenuRenderer", ["sap/ui/table/ColumnMenu"],function(e){"use strict";return e.getMetadata().getRenderer()},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/CreationRow", ["./CreationRowRenderer","./Column","./utils/TableUtils","sap/ui/core/Control","sap/m/library","sap/m/OverflowToolbar","sap/m/ToolbarSpacer","sap/m/Button"],function(e,t,r,l,a,o,i,n){"use strict";var s=l.extend("sap.ui.table.CreationRow",{metadata:{library:"sap.ui.table",properties:{applyEnabled:{type:"boolean",group:"Behavior",defaultValue:true}},aggregations:{cells:{type:"sap.ui.core.Control",multiple:true,singularName:"cell"},toolbar:{type:"sap.ui.core.Toolbar",multiple:false},_defaultToolbar:{type:"sap.ui.core.Toolbar",multiple:false,visibility:"hidden"}},events:{apply:{allowPreventDefault:true}}},renderer:e});s.prototype.setApplyEnabled=function(e){this.setProperty("applyEnabled",e,true);this._updateDefaultToolbar();return this};s.prototype.setVisible=function(e){var t=this.getVisible();var r=this.getTable();this.setProperty("visible",e);if(t!==e&&r){r.invalidate()}return this};s.prototype.setParent=function(e){l.prototype.setParent.apply(this,arguments);this._update();return this};s.prototype.resetFocus=function(){var e=r.getFirstInteractiveElement(this);if(e){e.focus();if(e instanceof window.HTMLInputElement){e.select()}return true}return false};s.prototype.getFocusDomRef=function(){var e=r.getFirstInteractiveElement(this);if(e){return e}return l.prototype.getFocusDomRef.apply(this,arguments)};s.prototype._fireApply=function(){var e=false;if(this.fireApply()){e=this.resetFocus()}return e};function u(e,t){var r=document.activeElement;e.getTable().getDomRef("focusDummy").focus();t.setMarked();window.setTimeout(function(){if(!e._fireApply()){r.focus()}},0)}s.prototype.onsapenter=function(e){if(this.getApplyEnabled()&&!e.isMarked()){u(this,e)}};s.prototype.onsapentermodifiers=function(e){if(this.getApplyEnabled()&&(e.metaKey||e.ctrlKey)){u(this,e)}};function p(e){return new o(e.getId()+"-tb",{content:[new i,new n(e.getId()+"-applyBtn",{text:r.getResourceText("TBL_CREATIONROW_APPLY"),enabled:e.getApplyEnabled(),press:function(){e._fireApply()}})],style:a.ToolbarStyle.Clear,ariaLabelledBy:[e.getId()+"-label"]})}s.prototype._getToolbar=function(){var e=this.getToolbar();if(!e){var t=this.getAggregation("_defaultToolbar");if(!t){t=p(this);this.setAggregation("_defaultToolbar",t,true)}e=t;if(e.data("sap-ui-table-invalid")){this._updateDefaultToolbar()}}return e};s.prototype._updateDefaultToolbar=function(){var e=this.getAggregation("_defaultToolbar");var t;if(this.getToolbar()){if(e){e.data("sap-ui-table-invalid",true)}return}if(!e){return}t=e.getContent()[1];t.setEnabled(this.getApplyEnabled());e.data("sap-ui-table-invalid",null)};s.prototype._getCell=function(e){var r=this.getCells();var l=r.filter(function(r){return t.ofCell(r).getIndex()===e})[0];if(!l){return null}return l};s.prototype._getCellDomRef=function(e){var t=this._getCell(e);var l=t?t.getDomRef():null;var a=r.getCell(this.getTable(),l,true);if(!a){return null}return a};s.prototype._focusCell=function(e){var t=this._getCellDomRef(e);var l=r.getInteractiveElements(t);if(l){l[0].focus();if(l[0]instanceof window.HTMLInputElement){l[0].select()}return true}return false};s.prototype._takeOverKeyboardHandling=function(e){var t=this.getTable();var l=t?t.getDomRef():null;if(!l||!l.contains(document.activeElement)){return false}var a=r.getCell(this.getTable(),document.activeElement);var o=r.getCellInfo(a);var i=false;if(o.columnIndex!=null&&o.columnIndex>=0){i=this._focusCell(o.columnIndex)}else{i=this.resetFocus()}if(i&&e){e.preventDefault()}return i};s.prototype._update=function(){var e=this.getTable();if(!e){this.removeAllCells();return}var t=e.getColumns();this.removeAllCells();for(var r=0,l=t.length;r<l;r++){if(t[r].getVisible()){this.addCell(t[r].getTemplateClone(r,"Creation"))}}};s.prototype.getTable=function(){var e=this.getParent();return r.isA(e,"sap.ui.table.Table")?e:null};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/CreationRowRenderer", ["./TableRenderer","./utils/TableUtils","sap/ui/core/Renderer"],function(e,t,n){"use strict";var a={apiVersion:2};a.render=function(e,t){var n=t.getTable();if(!n){return}e.openStart("div",t);e.attr("data-sap-ui-fastnavgroup","true");n._getAccRenderExtension().writeAriaAttributesFor(e,n,"CREATIONROW",{creationRow:t});e.class("sapUiTableCreationRow");e.openEnd();this.renderBeginSection(e);this.renderMiddleSection(e,t,n);this.renderEndSection(e,n);n._getAccRenderExtension().writeAccCreationRowText(e,n,t);e.close("div")};a.renderBeginSection=function(e){e.openStart("div");e.class("sapUiTableCreationRowBeginSection");e.class("sapUiTableRowHdrScr");e.openEnd();e.close("div")};a.renderMiddleSection=function(e,t,n){e.openStart("div");e.class("sapUiTableCreationRowMiddleSection");e.openEnd();this.renderForm(e,t,n);this.renderToolbar(e,t);e.close("div")};a.renderEndSection=function(e,n){e.openStart("div");e.class("sapUiTableCreationRowEndSection");if(t.hasRowActions(n)){e.class("sapUiTableCell");e.class("sapUiTableRowActionHeaderCell")}else{e.class("sapUiTableVSbBg")}e.openEnd();e.close("div")};a.renderForm=function(e,t,n){if(t.getCells().length===0){return}e.openStart("div");e.class("sapUiTableCreationRowForm");e.openEnd();if(n.getComputedFixedColumnCount()>0){this.renderRowFormTable(e,n,true)}e.openStart("div");e.class("sapUiTableCtrlScr");e.openEnd();this.renderRowFormTable(e,n,false);e.close("div");e.close("div")};a.renderRowFormTable=function(a,i,r){var o=r?0:i.getComputedFixedColumnCount();var l=r?i.getComputedFixedColumnCount():i.getColumns().length;var s=i.getCreationRow();a.openStart("table");i._getAccRenderExtension().writeAriaAttributesFor(a,i,"CREATIONROW_TABLE");a.class("sapUiTableCtrl");a.style(r?"width":"min-width",i._getColumnsWidth(o,l)+"px");a.openEnd();a.openStart("thead").openEnd();a.openStart("tr");a.class("sapUiTableCtrlCol");a.openEnd();var d=i.getColumns();var c=new Array(l);var p;var u;var C=!r&&l>o;var T;for(p=o;p<l;p++){u=d[p];T={shouldRender:!!(u&&u.shouldRender())};if(T.shouldRender){var b=u.getWidth();if(t.isVariableWidth(b)){C=false;if(r){u._iFixWidth=u._iFixWidth||160;b=u._iFixWidth+"px"}}else if(r){delete u._iFixWidth}T.width=b}c[p]=T}for(p=o;p<l;p++){u=d[p];T=c[p];if(T.shouldRender){a.openStart("th");a.style("width",T.width);a.attr("data-sap-ui-headcolindex",p);a.attr("data-sap-ui-colid",u.getId());a.openEnd();a.close("th")}}if(C){a.openStart("th").openEnd().close("th")}a.close("tr");a.close("thead");a.openStart("tbody").openEnd();a.openStart("tr");a.class("sapUiTableTr");a.openEnd();var g=s.getCells();var h=e.getColumnsToRender(i,o,l);for(p=o;p<l;p++){u=d[p];T=c[p];if(T.shouldRender){a.openStart("td");a.attr("data-sap-ui-colid",u.getId());var v=s._getCell(p);var f=h.length;var R=f>0&&h[0]===u;var S=f>0&&h[f-1]===u;var E=e.getLastFixedColumnIndex(i);var w=r&E===p;var x=n.getTextAlign(u.getHAlign(),v&&v.getTextDirection&&v.getTextDirection());a.style("text-align",x);a.class("sapUiTableCell");a.class("sapUiTablePseudoCell");if(R){a.class("sapUiTableCellFirst")}if(w){a.class("sapUiTableCellLastFixed")}if(S){a.class("sapUiTableCellLast")}a.openEnd();if(v){a.openStart("div");a.class("sapUiTableCellInner");a.openEnd();e.renderTableCellControl(a,i,v,R);a.close("div")}a.close("td")}}if(!r&&C&&g.length>0){a.openStart("td").class("sapUiTableCellDummy").openEnd().close("td")}a.close("tr");a.close("tbody");a.close("table")};a.renderToolbar=function(e,t){e.renderControl(t._getToolbar())};return a},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/Row", ["sap/ui/core/Element","./utils/TableUtils","sap/ui/thirdparty/jquery"],function(t,e,jQuery){"use strict";var o=Object.freeze({Standard:"Standard",Summary:"Summary",GroupHeader:"GroupHeader"});function n(){var t=null;var e=o.Standard;var n=false;var i="";var r=false;var a=false;var l=0;Object.defineProperties(this,{context:{get:function(){return t},set:function(e){t=e||null}},Type:{get:function(){return o}},type:{get:function(){return e},set:function(t){if(!(t in o)){throw Error("Is not a valid type for sap.ui.table.Row: "+t)}e=t}},empty:{get:function(){return this.context==null}},contentHidden:{get:function(){return this.empty?true:n},set:function(t){n=t===true}},title:{get:function(){return this.empty?"":i},set:function(t){i=typeof t==="string"?t:""}},expandable:{get:function(){return this.empty?false:a},set:function(t){a=t===true}},expanded:{get:function(){return this.expandable?r:false},set:function(t){r=t===true}},level:{get:function(){return this.empty?0:l},set:function(t){l=typeof t==="number"?Math.max(1,t||1):1}},reset:{value:function(){t=null;e=o.Standard;n=false;i="";a=false;r=false;l=1}}})}var i=new window.WeakMap;function r(t){if(!i.has(t)){i.set(t,Object.seal(new n))}return i.get(t)}var a=t.extend("sap.ui.table.Row",{metadata:{library:"sap.ui.table",defaultAggregation:"cells",aggregations:{cells:{type:"sap.ui.core.Control",multiple:true,singularName:"cell"},_rowAction:{type:"sap.ui.table.RowAction",multiple:false,visibility:"hidden"},_settings:{type:"sap.ui.table.RowSettings",multiple:false,visibility:"hidden"}}}});a.prototype.init=function(){this.initDomRefs()};a.prototype.exit=function(){this.initDomRefs()};a.prototype.getFocusInfo=function(){var e=this.getTable();return e?e.getFocusInfo():t.prototype.getFocusInfo.apply(this,arguments)};a.prototype.applyFocusInfo=function(e){var o=this.getTable();if(o){o.applyFocusInfo(e)}else{t.prototype.applyFocusInfo.apply(this,arguments)}return this};a.prototype._setFocus=function(t){var o=e.getFirstInteractiveElement(this);if(t===true&&o){o.focus()}else{this.getDomRef("col0").focus()}};a.prototype.addStyleClass=function(t){this.getDomRefs(true).row.addClass(t)};a.prototype.removeStyleClass=function(t){this.getDomRefs(true).row.removeClass(t)};a.prototype.initDomRefs=function(){this._mDomRefs={}};a.prototype.getIndex=function(){var t=this.getTable();if(!t){return-1}var e=t.indexOfRow(this);var o=t._getRowCounts();if(o.fixedTop>0&&e<o.fixedTop){return e}if(o.fixedBottom>0&&e>=o.count-o.fixedBottom){var n=t._getTotalRowCount();if(n>=o.count){return n-(o.count-e)}else{return e}}return t._getFirstRenderedRowIndex()+e};a.prototype.getDomRefs=function(t,e){t=t===true;e=e===true;var o=t?"jQuery":"dom";var n=this._mDomRefs;if(!n[o]){var i=this.getTable();var r=function(e){var o=document.getElementById(e);if(o){return t?jQuery(o):o}return null};var a=function(e){if(e){return t?e.parent():e.parentNode}return null};n[o]={};if(i){var l=i.indexOfRow(this);n[o].rowSelector=r(i.getId()+"-rowsel"+l);n[o].rowAction=r(i.getId()+"-rowact"+l)}n[o].rowHeaderPart=a(n[o].rowSelector);n[o].rowFixedPart=r(this.getId()+"-fixed");n[o].rowScrollPart=r(this.getId());n[o].rowActionPart=a(n[o].rowAction);n[o].rowSelectorText=r(this.getId()+"-rowselecttext");if(t){n[o].row=jQuery().add(n[o].rowHeaderPart).add(n[o].rowFixedPart).add(n[o].rowScrollPart).add(n[o].rowActionPart)}else{n[o].row=[n[o].rowHeaderPart,n[o].rowFixedPart,n[o].rowScrollPart,n[o].rowActionPart].filter(Boolean)}}var s=n[o];if(e){return Object.keys(s).map(function(t){return t==="row"?null:s[t]}).filter(Boolean)}return s};a.prototype._updateSelection=function(){var t=this.getTable();var e=t._getSelectionPlugin().isSelected(this);this._setSelected(e);t._getAccExtension().updateSelectionStateOfRow(this)};a.prototype.setRowBindingContext=function(t,o){var n=o.getBindingInfo("rows");var i=n?n.model:undefined;var a=r(this);a.reset();a.context=t;if(a.context){e.Hook.call(o,e.Hook.Keys.Row.UpdateState,a)}this.setBindingContext(a.context,i);this.getDomRefs(true).row.toggleClass("sapUiTableRowHidden",this.isContentHidden());this._updateTableCells(o)};a.prototype.getRowBindingContext=function(){return r(this).context};a.prototype.setBindingContext=function(e,o){return t.prototype.setBindingContext.call(this,e||null,o)};a.prototype._updateTableCells=function(t){var e=this.getCells(),o=this.getIndex(),n=!!t._updateTableCell,i,r,a,l=this.getRowBindingContext();for(var s=0;s<e.length;s++){i=e[s];a=!!i._updateTableCell;r=a||n?i.$().closest("td"):null;if(a){i._updateTableCell(i,l,r,o)}if(n){t._updateTableCell(i,l,r,o)}}};a.prototype.getType=function(){return r(this).type};a.prototype.isGroupHeader=function(){return this.getType()===o.GroupHeader};a.prototype.isSummary=function(){return this.getType()===o.Summary};a.prototype.isGroupSummary=function(){return this.isSummary()&&this.getLevel()>1};a.prototype.isTotalSummary=function(){return this.isSummary()&&this.getLevel()===1};a.prototype.isEmpty=function(){return r(this).empty};a.prototype.isContentHidden=function(){return r(this).contentHidden};a.prototype.getLevel=function(){return r(this).level};a.prototype.getTitle=function(){return r(this).title};a.prototype.isExpandable=function(){return r(this).expandable};a.prototype.isExpanded=function(){return r(this).expanded};a.prototype.destroy=function(){this.removeAllCells();return t.prototype.destroy.apply(this,arguments)};a.prototype.invalidate=function(){return this};a.prototype.getDragGhost=function(){var t=this.getTable();var e=t.getDomRef();var o=this.getDomRefs();var n;var i;var r;var a=t._getSelectionPlugin().getSelectedCount();function l(t){t.removeAttribute("id");t.removeAttribute("data-sap-ui");t.removeAttribute("data-sap-ui-related");var e=t.children.length;for(var o=0;o<e;o++){l(t.children[o])}}function s(t,e){var o=t.cloneNode();var n=t.querySelector("thead").cloneNode(true);var i=t.querySelector("tbody").cloneNode();var r=e.cloneNode(true);i.appendChild(r);o.appendChild(n);o.appendChild(i);return o}n=e.cloneNode();n.classList.add("sapUiTableRowGhost");n.classList.remove("sapUiTableVScr");n.classList.remove("sapUiTableHScr");n.style.width=e.getBoundingClientRect().width+"px";if(o.rowSelector){i=t.getDomRef("sapUiTableRowHdrScr").cloneNode();r=o.rowSelector.cloneNode(true);i.appendChild(r);n.appendChild(i)}if(o.rowFixedPart){i=t.getDomRef("sapUiTableCtrlScrFixed").cloneNode();r=s(t.getDomRef("table-fixed"),o.rowFixedPart);i.appendChild(r);n.appendChild(i)}if(o.rowScrollPart){var p=t.getDomRef("sapUiTableCtrlScr");i=p.cloneNode();r=s(t.getDomRef("table"),o.rowScrollPart);i.appendChild(t.getDomRef("tableCtrlCnt").cloneNode());i.firstChild.appendChild(r);n.appendChild(i)}if(o.rowAction){i=t.getDomRef("sapUiTableRowActionScr").cloneNode();r=o.rowAction.cloneNode(true);i.appendChild(r);n.appendChild(i)}if(a>1){i=document.createElement("div");i.classList.add("sapUiTableRowGhostCount");var u=document.createElement("div");u.textContent=a;i.appendChild(u);n.appendChild(i)}l(n);return n};a.prototype._setSelected=function(t){var o=this.getTable();if(t){this.addStyleClass("sapUiTableRowSel")}else{this.removeStyleClass("sapUiTableRowSel")}if(o){e.dynamicCall(o._getSyncExtension,function(e){e.syncRowSelection(o.indexOfRow(this),t)},this)}};a.prototype._setHovered=function(t){var o=this.getTable();if(t){this.addStyleClass("sapUiTableRowHvr")}else{this.removeStyleClass("sapUiTableRowHvr")}if(o){e.dynamicCall(o._getSyncExtension,function(e){e.syncRowHover(o.indexOfRow(this),t)},this)}};a.prototype.getRowAction=function(){return this.getAggregation("_rowAction")};a.prototype.getTable=function(){var t=this.getParent();return e.isA(t,"sap.ui.table.Table")?t:null};a.prototype.expand=function(){if(this.isExpandable()&&!this.isExpanded()){e.Hook.call(this.getTable(),e.Hook.Keys.Row.Expand,this)}};a.prototype.collapse=function(){if(this.isExpandable()&&this.isExpanded()){e.Hook.call(this.getTable(),e.Hook.Keys.Row.Collapse,this)}};a.prototype.toggleExpandedState=function(){if(this.isExpanded()){this.collapse()}else{this.expand()}};a.prototype.Type=o;return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/RowAction", ["./library","./utils/TableUtils","./RowActionRenderer","sap/ui/core/Control","sap/ui/core/Icon","sap/ui/unified/Menu","sap/ui/core/Popup"],function(e,t,i,s,o,n,a){"use strict";var r=s.extend("sap.ui.table.RowAction",{metadata:{library:"sap.ui.table",properties:{visible:{type:"boolean",group:"Misc",defaultValue:true}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.table.RowActionItem",multiple:true},_icons:{type:"sap.ui.core.Icon",multiple:true,visibility:"hidden"},_menu:{type:"sap.ui.unified.Menu",multiple:false,visibility:"hidden"}},events:{}},renderer:i});r.prototype.init=function(){this._bFixedLayout=true;this._aActions=["",""];this._iLastCloseTime=0;this.addAggregation("_icons",new o(this.getId()+"-icon0",{decorative:false,press:[this._onIconPress,this]}).addStyleClass("sapUiTableActionIcon")).addDelegate({onAfterRendering:function(){var e=this.getAggregation("_icons")[0].getDomRef();if(this._aActions[0]==="menu"){e.setAttribute("aria-haspopup","menu")}else{e.removeAttribute("aria-haspopup")}}},this);this.addAggregation("_icons",new o(this.getId()+"-icon1",{decorative:false,press:[this._onIconPress,this]}).addStyleClass("sapUiTableActionIcon")).addDelegate({onAfterRendering:function(){var e=this.getAggregation("_icons")[1].getDomRef();if(this._aActions[1]==="menu"){e.setAttribute("aria-haspopup","menu")}else{e.removeAttribute("aria-haspopup")}}},this)};r.prototype.onBeforeRendering=function(){var e=this.getRow();var i=e?e.getTable():null;var s=this.getAggregation("_icons");var o=this.getItems();var n=this._getVisibleItems();var a=n.length;var r=this._getSize();var c=i?i.getId()+"-rowacthdr":"";if(this._bFixedLayout&&a===1&&r===2&&o.length>1&&n[0]===o[1]){n[0]._syncIcon(s[1]);this._aActions=["","action_fixed"]}else if(a===0||r===0){this._aActions=["",""]}else if(a===1&&r>0){n[0]._syncIcon(s[0]);this._aActions=["action",""]}else if(a===2&&r===2){n[0]._syncIcon(s[0]);n[1]._syncIcon(s[1]);this._aActions=["action","action"]}else if(a>2&&r===2){n[0]._syncIcon(s[0]);s[1].setSrc("sap-icon://overflow");s[1].setTooltip(t.getResourceText("TBL_ROW_ACTION_MORE"));this._aActions=["action","menu"]}else{s[0].setSrc("sap-icon://overflow");s[0].setTooltip(t.getResourceText("TBL_ROW_ACTION_MORE"));this._aActions=["menu",""]}s.forEach(function(e,t){e.removeAllAriaLabelledBy();e.removeStyleClass("sapUiTableActionHidden");if(c){e.addAriaLabelledBy(c)}if(this._aActions[t]===""){e.addStyleClass("sapUiTableActionHidden")}}.bind(this))};r.prototype.getAccessibilityInfo=function(){var e=this.getRow();var i=this._getVisibleItems().length;var s=this._getSize();var o=this.getVisible()&&i>0&&s>0&&(!e||!e.isContentHidden()&&!e.isGroupHeader()&&!e.isSummary());var n;if(o){n=t.getResourceText(i==1?"TBL_ROW_ACTION_SINGLE_ACTION":"TBL_ROW_ACTION_MULTIPLE_ACTION",[i])}else{n=t.getResourceText("TBL_ROW_ACTION_NO_ACTION")}return{focusable:o,enabled:o,description:n}};r.prototype._getVisibleItems=function(){return this.getItems().filter(function(e){return e.getVisible()})};r.prototype.getRow=function(){var e=this.getParent();return t.isA(e,"sap.ui.table.Row")?e:null};r.prototype._getSize=function(){var e=this.getRow();var t=e?e.getTable():null;return t?t.getRowActionCount():2};r.prototype._onIconPress=function(e){var t=e.getSource();var i=this.indexOfAggregation("_icons",t);var s=this._aActions[i];if(s==="action"){this._getVisibleItems()[i]._firePress()}else if(s==="action_fixed"){this._getVisibleItems()[0]._firePress()}else if(s==="menu"){var o=this.getAggregation("_menu");if(!o){o=new n;this.setAggregation("_menu",o,true);o.getPopup().attachClosed(function(){this._iLastCloseTime=Date.now()},this)}o.removeAllItems();if(Date.now()-this._iLastCloseTime<500){return}var r=this.getItems();for(var c=i;c<r.length;c++){o.addItem(r[c]._getMenuItem())}o.open(null,t,a.Dock.EndTop,a.Dock.EndBottom,t)}};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/RowActionItem", ["./library","./utils/TableUtils","sap/ui/core/Element","sap/ui/unified/MenuItem","sap/ui/core/IconPool"],function(t,e,i,o,n){"use strict";var s=t.RowActionType;var r=i.extend("sap.ui.table.RowActionItem",{metadata:{library:"sap.ui.table",properties:{icon:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},visible:{type:"boolean",group:"Misc",defaultValue:true},text:{type:"string",group:"Misc",defaultValue:""},type:{type:"sap.ui.table.RowActionType",group:"Behavior",defaultValue:s.Custom}},events:{press:{parameters:{item:{type:"sap.ui.table.RowActionItem"},row:{type:"sap.ui.table.Row"}}}}}});r.prototype.init=function(){this._oMenuItem=null};r.prototype.exit=function(){if(this._oMenuItem){this._oMenuItem.destroy();this._oMenuItem=null}};r.prototype.getRowAction=function(){var t=this.getParent();return e.isA(t,"sap.ui.table.RowAction")?t:null};r.prototype._firePress=function(){var t=this.getRowAction();this.firePress({item:this,row:t?t.getRow():null})};r.prototype._getMenuItem=function(){if(!this._oMenuItem){this._oMenuItem=new o({select:[this._firePress,this]})}this._oMenuItem.setIcon(this._getIcon());this._oMenuItem.setVisible(this.getVisible());this._oMenuItem.setText(this._getText(false));return this._oMenuItem};r.prototype._getIcon=function(){var t=this.getIcon();if(t){return t}if(this.getType()===s.Navigation){return n.getIconURI(e.ThemeParameters.navigationIcon)}if(this.getType()===s.Delete){return n.getIconURI(e.ThemeParameters.deleteIcon)}return null};r.prototype._getText=function(t){var i=t?this.getTooltip_AsString()||this.getText():this.getText()||this.getTooltip_AsString();if(i){return i}if(this.getType()===s.Navigation){return e.getResourceText("TBL_ROW_ACTION_NAVIGATE")}if(this.getType()===s.Delete){return e.getResourceText("TBL_ROW_ACTION_DELETE")}return null};r.prototype._syncIcon=function(t){t.setSrc(this._getIcon());t.setTooltip(this._getText(true))};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/RowActionRenderer", [],function(){"use strict";var e={apiVersion:2};e.render=function(e,i){e.openStart("div",i);e.class("sapUiTableAction");if(!i.getRow()){e.style("display","none")}if(!i.getVisible()){e.class("sapUiTableActionHidden")}var t=i.getTooltip_AsString();if(t){e.attr("title",t)}e.openEnd();var n=i.getAggregation("_icons");e.renderControl(n[0]);e.renderControl(n[1]);e.close("div")};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/RowSettings", ["sap/ui/core/Element","./utils/TableUtils","sap/ui/base/DataType","./library","sap/ui/core/library"],function(t,e,i,a,r){"use strict";var s=r.MessageType;var o=r.IndicationColor;var g=t.extend("sap.ui.table.RowSettings",{metadata:{library:"sap.ui.table",properties:{highlight:{type:"string",group:"Appearance",defaultValue:"None"},highlightText:{type:"string",group:"Misc",defaultValue:""},navigated:{type:"boolean",group:"Appearance",defaultValue:false}}}});g.prototype.validateProperty=function(e,a){if(e!="highlight"||a==null){return t.prototype.validateProperty.apply(this,arguments)}if(!i.getType("sap.ui.core.MessageType").isValid(a)&&!i.getType("sap.ui.core.IndicationColor").isValid(a)){throw new Error('"'+a+'" is of type '+typeof a+", expected is a value of the enums sap.ui.core.MessageType or sap.ui.core.IndicationColor"+' for property "'+e+'" of '+this)}return a};g.prototype.setHighlight=function(t){var e;var i;this.setProperty("highlight",t,true);e=this._getRow();if(!e){return this}i=e.getDomRef("highlight");if(!i){return this}for(var a in s){i.classList.remove("sapUiTableRowHighlight"+a)}for(var r in o){i.classList.remove("sapUiTableRowHighlight"+r)}i.classList.add(this._getHighlightCSSClassName());var g=e.getParent();var n=g?g._getAccExtension():null;if(n){n.updateAriaStateOfRowHighlight(this)}return this};g.prototype.setNavigated=function(t){var e;var i;this.setProperty("navigated",t,true);e=this._getRow();if(!e){return this}i=e.getDomRef("navIndicator");if(!i){return this}if(t){i.classList.add("sapUiTableRowNavigated")}else{i.classList.remove("sapUiTableRowNavigated")}var a=e.getParent();var r=a?a._getAccExtension():null;if(r){r._updateAriaStateOfNavigatedRow(this)}return this};g.prototype.setHighlightText=function(t){var e=this._getRow();var i=e?e.getParent():null;var a=i?i._getAccExtension():null;this.setProperty("highlightText",t,true);if(a){a.updateAriaStateOfRowHighlight(this)}return this};g.prototype._getHighlightCSSClassName=function(){var t=this.getHighlight();if(t==null){t=s.None}return"sapUiTableRowHighlight"+t};g.prototype._getHighlightText=function(){var t=this.getHighlight();if(t===s.None){return""}var i=this.getHighlightText();if(t in s&&i===""){i=e.getResourceText("TBL_ROW_STATE_"+t.toUpperCase())}return i};g.prototype._getRow=function(){var t=this.getParent();if(e.isA(t,"sap.ui.table.Row")){return t}else{return null}};return g});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/Table", ["sap/ui/Device","sap/ui/core/Control","sap/ui/core/util/PasteHelper","sap/ui/model/ChangeReason","sap/ui/model/Filter","sap/ui/model/Sorter","sap/ui/model/BindingMode","./Column","./Row","./library","./utils/TableUtils","./extensions/ExtensionBase","./extensions/Accessibility","./extensions/Keyboard","./extensions/Pointer","./extensions/Scrolling","./extensions/DragAndDrop","./TableRenderer","./rowmodes/Type","./rowmodes/Fixed","./rowmodes/Interactive","./rowmodes/Auto","./plugins/SelectionModelSelection","sap/ui/thirdparty/jquery","sap/base/Log","sap/ui/core/Configuration","sap/ui/core/library"],function(e,t,i,o,n,r,s,a,l,u,d,p,h,g,c,f,y,m,w,b,C,v,R,jQuery,_,S,x){"use strict";var T=u.GroupEventType;var A=u.SelectionMode;var I=u.SelectionBehavior;var B=x.SortOrder;var M=d.Hook.Keys.Table;var F=d.createWeakMapFacade();var D=t.extend("sap.ui.table.Table",{metadata:{library:"sap.ui.table",dnd:true,properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"auto"},rowHeight:{type:"int",group:"Appearance",defaultValue:null,deprecated:true},columnHeaderHeight:{type:"int",group:"Appearance",defaultValue:null},columnHeaderVisible:{type:"boolean",group:"Appearance",defaultValue:true},visibleRowCount:{type:"int",group:"Appearance",defaultValue:10,deprecated:true},firstVisibleRow:{type:"int",group:"Appearance",defaultValue:0},selectionMode:{type:"sap.ui.table.SelectionMode",group:"Behavior",defaultValue:A.MultiToggle},selectionBehavior:{type:"sap.ui.table.SelectionBehavior",group:"Behavior",defaultValue:I.RowSelector},selectedIndex:{type:"int",group:"Appearance",defaultValue:-1,deprecated:true},editable:{type:"boolean",group:"Behavior",defaultValue:true,deprecated:true},navigationMode:{type:"sap.ui.table.NavigationMode",group:"Behavior",defaultValue:"Scrollbar",deprecated:true},threshold:{type:"int",group:"Appearance",defaultValue:100},enableColumnReordering:{type:"boolean",group:"Behavior",defaultValue:true},enableGrouping:{type:"boolean",group:"Behavior",defaultValue:false,deprecated:true},showColumnVisibilityMenu:{type:"boolean",group:"Appearance",defaultValue:false},showNoData:{type:"boolean",group:"Appearance",defaultValue:true},visibleRowCountMode:{type:"sap.ui.table.VisibleRowCountMode",group:"Appearance",defaultValue:"Fixed",deprecated:true},minAutoRowCount:{type:"int",group:"Appearance",defaultValue:5,deprecated:true},fixedColumnCount:{type:"int",group:"Appearance",defaultValue:0},fixedRowCount:{type:"int",group:"Appearance",defaultValue:0,deprecated:true},fixedBottomRowCount:{type:"int",group:"Appearance",defaultValue:0,deprecated:true},enableColumnFreeze:{type:"boolean",group:"Behavior",defaultValue:false},enableCellFilter:{type:"boolean",group:"Behavior",defaultValue:false},showOverlay:{type:"boolean",group:"Appearance",defaultValue:false},enableSelectAll:{type:"boolean",group:"Behavior",defaultValue:true},enableCustomFilter:{type:"boolean",group:"Behavior",defaultValue:false},enableBusyIndicator:{type:"boolean",group:"Behavior",defaultValue:false},rowActionCount:{type:"int",group:"Appearance",defaultValue:0},alternateRowColors:{type:"boolean",group:"Appearance",defaultValue:false},rowCountConstraints:{type:"object",visibility:"hidden"}},defaultAggregation:"columns",aggregations:{title:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false,deprecated:true},footer:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},toolbar:{type:"sap.ui.core.Toolbar",multiple:false,deprecated:true},extension:{type:"sap.ui.core.Control",multiple:true,singularName:"extension"},columns:{type:"sap.ui.table.Column",multiple:true,singularName:"column",bindable:"bindable",dnd:{layout:"Horizontal"}},rows:{type:"sap.ui.table.Row",multiple:true,singularName:"row",bindable:"bindable",selector:"#{id}-tableCCnt",dnd:true},rowMode:{type:"sap.ui.table.rowmodes.RowMode",multiple:false,altTypes:["sap.ui.table.rowmodes.Type"]},creationRow:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},noData:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},_noColumnsMessage:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},rowActionTemplate:{type:"sap.ui.table.RowAction",multiple:false},rowSettingsTemplate:{type:"sap.ui.table.RowSettings",multiple:false},contextMenu:{type:"sap.ui.core.IContextMenu",multiple:false},plugins:{type:"sap.ui.table.plugins.SelectionPlugin",multiple:true,singularName:"plugin",deprecated:true},_messageStrip:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_hiddenDependents:{type:"sap.ui.core.Element",multiple:true,visibility:"hidden"}},associations:{groupBy:{type:"sap.ui.table.Column",multiple:false,deprecated:true},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{rowSelectionChange:{parameters:{rowIndex:{type:"int"},rowContext:{type:"sap.ui.model.Context"},rowIndices:{type:"int[]"},selectAll:{type:"boolean"},userInteraction:{type:"boolean"}}},columnSelect:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},columnResize:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},width:{type:"sap.ui.core.CSSSize"}}},columnMove:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},newPos:{type:"int"}}},sort:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},sortOrder:{type:"sap.ui.core.SortOrder"},columnAdded:{type:"boolean"}}},filter:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},value:{type:"string"}}},group:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}},deprecated:true},columnVisibility:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},newVisible:{type:"boolean"}}},cellClick:{allowPreventDefault:true,parameters:{cellControl:{type:"sap.ui.core.Control"},cellDomRef:{type:"Object"},rowIndex:{type:"int"},columnIndex:{type:"int"},columnId:{type:"string"},rowBindingContext:{type:"sap.ui.model.Context"}}},cellContextmenu:{allowPreventDefault:true,parameters:{cellControl:{type:"sap.ui.core.Control"},cellDomRef:{type:"Object"},rowIndex:{type:"int"},columnIndex:{type:"int"},columnId:{type:"string"},rowBindingContext:{type:"sap.ui.model.Context"}},deprecated:true},beforeOpenContextMenu:{allowPreventDefault:true,parameters:{rowIndex:{type:"int"},columnIndex:{type:"int"},contextMenu:{type:"sap.ui.core.IContextMenu"}}},columnFreeze:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},customFilter:{parameters:{column:{type:"sap.ui.table.Column"},value:{type:"string"}}},firstVisibleRowChanged:{parameters:{firstVisibleRow:{type:"int"}}},busyStateChanged:{parameters:{busy:{type:"boolean"}}},paste:{allowPreventDefault:true,parameters:{data:{type:"string[][]"}}},rowsUpdated:{}},designtime:"sap/ui/table/designtime/Table.designtime"},renderer:m});D.prototype.init=function(){this.mSkipPropagation={rowActionTemplate:true,rowSettingsTemplate:true};F(this).iCachedBindingLength=0;F(this).iFirstRenderedRowIndex=0;F(this).iComputedFixedColumnCount=null;this._attachExtensions();this._bRtlMode=S.getRTL();this._bRowsBeingBound=false;this._bContextsAvailable=false;this._aRowClones=[];this._bRowAggregationInvalid=true;this._mTimeouts={};this._mAnimationFrames={};this._setHideStandardTooltips(false);this._aRowHeights=[];this._aSortedColumns=[];this._aTableHeaders=[];this._bAllowColumnHeaderTextSelection=false;F(this).iPendingRequests=0;this._iBindingLength=null;this._bFirstRendering=true;this._nDevicePixelRatio=window.devicePixelRatio;if(sap.ui.getCore().isThemeApplied()){d.readThemeParameters()}this._bInvalid=true};D.prototype.applySettings=function(e,i){if(e){var o=["threshold","firstVisibleRow","rowMode"];var n={};o.push("plugins");for(var r=0;r<o.length;r++){var s=o[r];if(s in e){n[s]=e[s];delete e[s]}}if(Object.keys(n).length>0){t.prototype.applySettings.call(this,n,i)}}this._initLegacySelectionPlugin();U(this);t.prototype.applySettings.call(this,e,i)};D.prototype._attachExtensions=function(){if(this._bExtensionsInitialized){return}p.enrich(this,c);p.enrich(this,f);p.enrich(this,g);p.enrich(this,h);p.enrich(this,y);if(e.os.ios){sap.ui.require(["sap/ui/table/extensions/ScrollingIOS"],function(e){if(!this.bIsDestroyed){p.enrich(this,e)}}.bind(this))}this._bExtensionsInitialized=true};D.prototype.exit=function(){this.invalidateRowsAggregation();this._detachExtensions();this._cleanUpTimers();this._detachEvents();d.Menu.cleanupDefaultContentCellContextMenu(this);K(this);delete this._aTableHeaders};D.prototype._detachExtensions=function(){p.cleanup(this)};D.prototype.onpaste=function(e){if(e.isMarked()||/^(input|textarea)$/i.test(e.target.tagName)||!this.getDomRef("sapUiTableCnt").contains(e.target)){return}var t=i.getPastedDataAs2DArray(e.originalEvent);if(t.length===0||t[0].length===0){return}this.firePaste({data:t})};D.prototype.onThemeChanged=function(){d.readThemeParameters();if(this.getDomRef()){this.invalidate()}};D.prototype.onLocalizationChanged=function(e){var t=e.changes||{};var i=t.hasOwnProperty("rtl");var o=t.hasOwnProperty("language");this._adaptLocalization(i,o).then(function(){this.invalidate()}.bind(this)).catch(function(){})};D.prototype.onlocalizationChanged=D.prototype.onLocalizationChanged;D.prototype._adaptLocalization=function(e,t){if(!e&&!t){return Promise.reject()}var i=Promise.resolve();if(e){this._bRtlMode=S.getRTL()}if(t){i=d.getResourceBundle({async:true,reload:true})}return i.then(function(){if(t){d.Menu.cleanupDefaultContentCellContextMenu(this);this._invalidateColumnMenus()}}.bind(this))};D.prototype._collectRowHeights=function(t){var i=this.getDomRef();if(!i){return[]}var o=this._getBaseRowHeight();var n=t?".sapUiTableColHdrTr":".sapUiTableTr";var r=i.querySelectorAll(".sapUiTableCtrlFixed > tbody > tr"+n);var s=i.querySelectorAll(".sapUiTableCtrlScroll > tbody > tr"+n);var a=t?d.getHeaderRowCount(this):this.getRows().length;var l=[];var u=e.browser.chrome&&window.devicePixelRatio!=1;if(t){if(this.getColumnHeaderHeight()>0){o=this.getColumnHeaderHeight()}else if(this.getRowMode()){o=this._getDefaultRowHeight()}}for(var p=0;p<a;p++){var h=r[p]?r[p].getBoundingClientRect().height:0;var g=s[p]?s[p].getBoundingClientRect().height:0;var c=Math.max(h,g);if(u){var f=o-c;if(f>0&&f<1){l.push(Math.max(c,o-1));continue}}l.push(Math.max(c,o))}if(l.length>0&&!t){d.dynamicCall(this._getSyncExtension,function(e){var t=e.syncRowHeights(l.slice());if(t&&t.length===l.length){l=t.slice()}})}return l};D.prototype._resetRowHeights=function(){var e=this._getBaseRowHeight();var t="";if(e){t=e+"px"}var i=this.getDomRef("tableCCnt");if(i){var o=i.querySelectorAll(".sapUiTableTr");for(var n=0;n<o.length;n++){o[n].style.height=t}}};D.prototype._resetColumnHeaderHeights=function(){var e=this.getDomRef();if(e){var t=e.querySelectorAll(".sapUiTableColHdrTr");for(var i=0;i<t.length;i++){t[i].style.height=null}}};D.prototype._collectTableSizes=function(){var e={tableCtrlScrollWidth:0,tableRowHdrScrWidth:0,tableCtrlScrWidth:0,tableCtrlFixedWidth:0,tableCntHeight:0,tableCntWidth:0};var t=this.getDomRef();if(!t){return e}var i=t.querySelector(".sapUiTableCnt");if(i){e.tableCntHeight=i.clientHeight;e.tableCntWidth=i.clientWidth}var o=t.querySelector(".sapUiTableCtrlScroll:not(.sapUiTableCHT)");if(o){e.tableCtrlScrollWidth=o.getBoundingClientRect().width}var n=t.querySelector(".sapUiTableRowHdrScr");if(n){e.tableRowHdrScrWidth=n.clientWidth}var r=t.querySelector(".sapUiTableCtrlScr:not(.sapUiTableCHA)");if(r){e.tableCtrlScrWidth=r.getBoundingClientRect().width}var s=t.querySelector(".sapUiTableCtrlScrFixed:not(.sapUiTableCHA) > .sapUiTableCtrlFixed");if(s){e.tableCtrlFixedWidth=s.clientWidth}var a=this._getSpanBasedComputedFixedColumnCount();var l=0;if(a){var u=this.getColumns();var p=t.querySelectorAll(".sapUiTableCtrlFirstCol:not(.sapUiTableCHTHR) > th");for(var h=0;h<p.length;h++){var g=parseInt(p[h].getAttribute("data-sap-ui-headcolindex"));if(!isNaN(g)&&g<a){var c=u[g];var f;if(c._iFixWidth!=null){f=c._iFixWidth}else{f=p[h].getBoundingClientRect().width}l+=f}}}if(l>0){var y=this._getScrollExtension();var m=e.tableRowHdrScrWidth;var w=y.getVerticalScrollbar();if(w&&!y.isVerticalScrollbarExternal()){m+=w.offsetWidth}if(d.hasRowActions(this)){var b=this.getDomRef("sapUiTableRowActionScr");if(b){m+=b.offsetWidth}}m+=d.Column.getMinColumnWidth();var C=e.tableCntWidth-m;var v=C>l;var R=!v;if(this._bIgnoreFixedColumnCount!==R){this._bIgnoreFixedColumnCount=R;if(this.getEnableColumnFreeze()){this._invalidateColumnMenus()}this.invalidate()}}return e};D.prototype._updateRowHeights=function(e,t){var i=this.getDomRef();if(!i){return}function o(t,i){var o=e[i];if(o){t.style.height=o+"px"}}var n=t?".sapUiTableColHdrTr":".sapUiTableTr";var r=t?[]:i.querySelectorAll(".sapUiTableRowSelectionCell");var s=t?[]:i.querySelectorAll(".sapUiTableRowActionCell");var a=i.querySelectorAll(".sapUiTableCtrlFixed > tbody > tr"+n);var l=i.querySelectorAll(".sapUiTableCtrlScroll > tbody > tr"+n);Array.prototype.forEach.call(r,o);Array.prototype.forEach.call(s,o);Array.prototype.forEach.call(a,o);Array.prototype.forEach.call(l,o)};D.prototype.onBeforeRendering=function(e){this._bInvalid=true;this._detachEvents();if(e&&e.isMarked("renderRows")){return}this._cleanUpTimers();this._aTableHeaders=[]};D.prototype.onAfterRendering=function(e){var t=e&&e.isMarked("renderRows");this._bInvalid=false;this._attachEvents();this._initRowDomRefs();if(!this._bAllowColumnHeaderTextSelection&&!t){this._disableTextSelection(this.$().find(".sapUiTableCHA"))}this.getDomRef().classList.remove("sapUiTableRActFlexible");if(!t){this._aTableHeaders=this.$().find(".sapUiTableColHdrCnt th")}this._updateTableSizes(d.RowsUpdateReason.Render,true);d.registerResizeHandler(this,"Table",this._onTableResize.bind(this));this._bFirstRendering=false};D.prototype.invalidate=function(){this._bInvalid=true;d.Column.invalidateColumnUtils(this);return t.prototype.invalidate.call(this)};D.prototype._initRowDomRefs=function(){var e=this.getRows();for(var t=0;t<e.length;t++){e[t].initDomRefs()}};D.prototype._updateTableSizes=function(e,t){t=t===true;var i=this.getDomRef();if(this._bInvalid||!i||!sap.ui.getCore().isThemeApplied()||i.offsetWidth===0){return}if(!t){this._resetRowHeights();this._resetColumnHeaderHeights()}this._aRowHeights=this._collectRowHeights(false);var o=this._collectRowHeights(true);function n(e){var t=e.getDomRef();var i=d.Column.getMinColumnWidth();var o=[];var n=e.getColumnHeaderVisible();function r(e,t){if(e<=t){return Math.max(e,t-5,i)+"px"}return-1}function s(s){var a=Math.max(s._minWidth||0,i,s.getMinWidth());var l=s.getWidth();var u;var p;var h;if(d.isVariableWidth(l)&&!d.isFixedColumn(e,s.getIndex())){u=t.querySelectorAll('th[data-sap-ui-colid="'+s.getId()+'"]');p=u[n?0:1];h=p?p.offsetWidth:null;if(h!==null){if(h<=a){return{headers:u,newWidth:r(h,a)}}else if(p&&p.style.width!=l){o.push({col:s,header:p,minWidth:a,headers:u});return{headers:u,newWidth:l}}o.push({col:s,header:p,minWidth:a,headers:u})}}return null}function a(e){if(e){Array.prototype.forEach.call(e.headers,function(t){t.style.width=e.newWidth})}}e._getVisibleColumns().map(s).forEach(a);if(o.length){var l;for(var u=0;u<o.length;u++){l=o[u].header&&o[u].header.offsetWidth;o[u].newWidth=r(l,o[u].minWidth);if(parseInt(o[u].newWidth)>=0){a(o[u])}}}}n(this);var r=this._collectTableSizes();this._updateRowHeights(this._aRowHeights,false);this._updateRowHeights(o,true);d.dynamicCall(this._getSyncExtension,function(e){e.syncLayout({top:this.getDomRef("sapUiTableCnt").offsetTop,headerHeight:this.getDomRef().querySelector(".sapUiTableColHdrCnt").getBoundingClientRect().height,contentHeight:this.getDomRef("tableCCnt").getBoundingClientRect().height})},this);var s=this.$();if(d.hasRowActions(this)||d.hasRowNavigationIndicators(this)){var a=s.hasClass("sapUiTableRActFlexible");var l=this.getDomRef("dummycolhdr");if(l){var u=l.clientWidth>2;if(!a&&u){var p=this.getColumns().reduce(function(e,t){var i=t.getDomRef();if(i&&t.getIndex()>=this.getComputedFixedColumnCount()){e+=i.offsetWidth}return e}.bind(this),0);var h=p+r.tableRowHdrScrWidth+r.tableCtrlFixedWidth;var g={};if(!d.hasRowActions(this)){h=h-d.ThemeParameters.navIndicatorWidth+d.BaseBorderWidth}g[this._bRtlMode?"right":"left"]=h;this.$("sapUiTableRowActionScr").css(g);this.$("rowacthdr").css(g);s.toggleClass("sapUiTableRActFlexible",true)}else if(a&&!u){this.$("sapUiTableRowActionScr").removeAttr("style");this.$("rowacthdr").removeAttr("style");s.toggleClass("sapUiTableRActFlexible",false)}}}s.find(".sapUiTableNoOpacity").addBack().removeClass("sapUiTableNoOpacity");d.Hook.call(this,M.UpdateSizes,e)};D.prototype.setShowOverlay=function(e){this.setProperty("showOverlay",e,true);if(this.getDomRef()){this.$().toggleClass("sapUiTableOverlay",this.getShowOverlay());this._getAccExtension().updateAriaStateForOverlayAndNoData();this._getKeyboardExtension().updateNoDataAndOverlayFocus()}return this};D.prototype._updateFixedBottomRows=function(){var e=this.getDomRef();if(!e||this._getRowCounts().fixedBottom===0){return}var t=d.getFirstFixedBottomRowIndex(this);var i=this.getRows();var o;jQuery(e).find(".sapUiTableRowLastScrollable").removeClass("sapUiTableRowLastScrollable");jQuery(e).find(".sapUiTableRowFirstFixedBottom").removeClass("sapUiTableRowFirstFixedBottom");if(t>=0&&t<i.length){o=i[t].getDomRefs(true);o.row.addClass("sapUiTableRowFirstFixedBottom",true)}if(t>=1&&t<i.length){o=i[t-1].getDomRefs(true);o.row.addClass("sapUiTableRowLastScrollable",true)}};D.prototype.focus=function(e){this._oFocusInfo=e;t.prototype.focus.apply(this,arguments);delete this._oFocusInfo};D.prototype.getFocusInfo=function(){var e=this.$().find(":focus").attr("id");if(e){return{customId:e}}else{return t.prototype.getFocusInfo.apply(this,arguments)}};D.prototype.applyFocusInfo=function(e){delete this._bApplyFocusInfoFailed;if(e&&e.customId){if(document.getElementById(e.customId)){jQuery(document.getElementById(e.customId)).trigger("focus")}else{this._bApplyFocusInfoFailed=true}}else{t.prototype.applyFocusInfo.apply(this,arguments)}return this};D.prototype.setTitle=function(e){var t=e;if(typeof e==="string"||e instanceof String){t=d._getTableTemplateHelper().createTextView({text:e});t.addStyleClass("sapUiTableHdrTitle")}this.setAggregation("title",t);return this};D.prototype.setFooter=function(e){var t=e;if(typeof e==="string"||e instanceof String){t=d._getTableTemplateHelper().createTextView({text:e})}this.setAggregation("footer",t);return this};D.prototype.setSelectionMode=function(e){if(e===A.Multi){e=A.MultiToggle;_.warning("The selection mode 'Multi' is deprecated and must not be used anymore."+" Your setting was defaulted to selection mode 'MultiToggle'",this)}if(this._hasSelectionPlugin()){_.error("If a selection plugin is applied to the table, the selection mode is controlled by the plugin.",this)}else{this.setProperty("selectionMode",e);this._getSelectionPlugin().setSelectionMode(e)}return this};D.prototype.setFirstVisibleRow=function(e){if(e==null){e=0}else if(e<0){_.error("The index of the first visible row must be greater than or equal to 0. The value has been set to 0.",this);e=0}else if(this._bContextsAvailable){var t=this._getMaxFirstVisibleRowIndex();if(t<e){_.warning("The index of the first visible row is too high. The value has been set to "+t+".",this);e=t}}this._setFirstVisibleRowIndex(e);return this};D.prototype._setFirstVisibleRowIndex=function(e,t){t=Object.assign({onScroll:false,suppressScrolling:false,suppressEvent:false,forceEvent:false,suppressRendering:false,onlySetProperty:false},t);if(this._bContextsAvailable){e=Math.min(e,this._getMaxFirstVisibleRowIndex())}e=Math.max(0,e);var i=this.getFirstVisibleRow()!==e;var o=this._getFirstRenderedRowIndex();var n=this._bContextsAvailable?Math.min(e,this._getMaxFirstRenderedRowIndex()):e;var r=this._getScrollExtension();this.setProperty("firstVisibleRow",e,true);if(!t.suppressRendering){F(this).iFirstRenderedRowIndex=n}if(t.onlySetProperty){return false}if((i||t.forceEvent)&&!t.suppressEvent){this.fireFirstVisibleRowChanged({firstVisibleRow:e})}if(!this.getBinding()){r.updateVerticalScrollPosition();return false}var s=false;var a=this.getBinding()!=null&&n!==o;if(a){if(!t.suppressRendering){N(this,t.onScroll?d.RowsUpdateReason.VerticalScroll:d.RowsUpdateReason.FirstVisibleRowChange);s=true}if(!t.onScroll&&!t.suppressScrolling){r.updateVerticalScrollPosition(s)}}else if(!t.onScroll&&!t.suppressScrolling){r.updateVerticalScrollPosition(!this._bContextsAvailable)}return s};D.prototype._setFocus=function(e,t){return new Promise(function(i){if(e===-1){e=this._getTotalRowCount()-1}if(typeof e!=="number"||e<-1){e=0}var o=this.getFirstVisibleRow();var n=this._getRowCounts().count;if(e>o&&e<o+n){this.getRows()[e-o]._setFocus(t);return i()}if(this._setFirstVisibleRowIndex(e)){this.attachEventOnce("rowsUpdated",function(){P(this,e,t);return i()})}else{P(this,e,t);return i()}}.bind(this))};function P(e,t,i){var o=e._getTotalRowCount();var n=e._getFirstRenderedRowIndex();e.getRows()[Math.min(t,o-1)-n]._setFocus(i)}D.getMetadata().getAggregation("rows")._doesNotRequireFactory=true;D.prototype.bindAggregation=function(e,i){if(e==="rows"){this._bindRows(V(Array.prototype.slice.call(arguments,1)));return this}return t.prototype.bindAggregation.apply(this,arguments)};D.prototype.bindRows=function(e){this._bindRows(V(arguments));return this};D.prototype._bindRows=function(e){E(this);this._bRowsBeingBound=true;O(this);$(this);D._addBindingListener(e,"change",function(){this._onBindingChange.apply(this,arguments)}.bind(this));D._addBindingListener(e,"dataRequested",function(){this._onBindingDataRequested.apply(this,arguments)}.bind(this));D._addBindingListener(e,"dataReceived",function(){this._onBindingDataReceived.apply(this,arguments)}.bind(this));d.Hook.call(this,M.BindRows,e);t.prototype.bindAggregation.call(this,"rows",e);this._bRowsBeingBound=false};D.prototype._bindAggregation=function(e,i){if(e==="rows"){E(this);this._bRowsBeingBound=true}t.prototype._bindAggregation.call(this,e,i);if(e==="rows"){d.Grouping.setupExperimentalGrouping(this);var o=this.getBinding();var n=o?o.getModel():null;this._bRowsBeingBound=false;d.Hook.call(this,M.RowsBound,o);if(n&&n.getDefaultBindingMode()===s.OneTime){_.error('The binding mode of the model is set to "OneTime".'+' This binding mode is not supported for the "rows" aggregation!'+" Scrolling can not be performed.",this)}}};D.prototype.unbindAggregation=function(e,i){if(e==="rows"){this._unbindRows();return this}return t.prototype.unbindAggregation.apply(this,arguments)};D.prototype.unbindRows=function(){this._unbindRows();return this};D.prototype._unbindRows=function(){var e=this.getBindingInfo("rows");if(e){d.Hook.call(this,M.UnbindRows,e)}t.prototype.unbindAggregation.call(this,"rows",true);if(this._bRowsBeingBound||this.bIsDestroyed||this._bIsBeingDestroyed){return}this._adjustToTotalRowCount();if(e){d.Hook.call(this,M.RowsUnbound)}E(this);$(this)};function E(e){e._bRowsBeingBound=false;e._bContextsAvailable=false;F(e).iPendingRequests=0;e._iBindingLength=null}function V(e){var t;if(e==null||e[0]==null){t={}}else if(typeof e[0]==="string"){var i=e[0];var o=e[1];var s=e[2];var a=e[3];if(o instanceof r||Array.isArray(s)&&s[0]instanceof n){a=s;s=o;o=undefined}t={path:i,sorter:s,filters:a,template:o}}else{t=e[0]}return t}D._addBindingListener=function(e,t,i,o){if(!e.events){e.events={}}var n=e.events[t];e.events[t]=function(){i.apply(o,arguments);if(n){n.apply(this,arguments)}}};D.prototype._onBindingChange=function(e){};D.prototype.setRowMode=function(e){L(this);this.setAggregation("rowMode",e);U(this);return this};D.prototype.destroyRowMode=function(){this.destroyAggregation("rowMode");if(!F(this).oDefaultRowMode){U(this)}return this};function H(e){var t=e.getRowMode();if(!e.isDestroyStarted()&&!d.isA(t,"sap.ui.table.rowmodes.RowMode")&&!F(e).oDefaultRowMode){U(e)}return d.isA(t,"sap.ui.table.rowmodes.RowMode")?t:F(e).oDefaultRowMode}function U(e){const t=e.getRowMode();const i=d.isA(t,"sap.ui.table.rowmodes.RowMode")?undefined:t||w.Fixed;if(i===undefined||F(e).oDefaultRowMode){return}if(t===null){switch(e.getVisibleRowCountMode()){case w.Fixed:F(e).oDefaultRowMode=new b(true);break;case w.Interactive:F(e).oDefaultRowMode=new C(true);break;case w.Auto:F(e).oDefaultRowMode=new v(true);break;default:throw new Error("Default row mode could not be created")}e.addAggregation("_hiddenDependents",F(e).oDefaultRowMode);return}switch(i){case w.Fixed:F(e).oDefaultRowMode=new b;break;case w.Interactive:F(e).oDefaultRowMode=new C;break;case w.Auto:F(e).oDefaultRowMode=new v;break;default:throw new Error("Default row mode could not be created")}e.addAggregation("_hiddenDependents",F(e).oDefaultRowMode)}function L(e){if(F(e).oDefaultRowMode){F(e).oDefaultRowMode.destroy();delete F(e).oDefaultRowMode}}D.prototype._getRowCounts=function(){var e=H(this).getComputedRowCounts();var t=this._bVariableRowHeightEnabled&&!e.fixedTop&&!e.fixedBottom;e._fullsize=e.count;e._scrollSize=e.scrollable;if(e.count>0&&t){e.count++;e.scrollable++}return e};D.prototype._isNoDataDisabled=function(){return!this.getShowNoData()||(H(this)?.isNoDataDisabled()??false)};D.prototype.setVisibleRowCountMode=function(e){if(this.getRowMode()){_.warning('If the "rowMode" aggregation is set, setting the "visibleRowCountMode" has no effect');return this.setProperty("visibleRowCountMode",e,true)}var t=this.getVisibleRowCountMode();this.setProperty("visibleRowCountMode",e);var i=this.getVisibleRowCountMode();if(i!==t){L(this);U(this)}return this};D.prototype.setVisibleRowCount=function(e){var t=this.getVisibleRowCountMode();if(t=="Auto"){_.error("VisibleRowCount will be ignored since VisibleRowCountMode is set to Auto",this);return this}if(e!=null&&!isFinite(e)){return this}var i=this.getFixedRowCount()+this.getFixedBottomRowCount();if(e<=i&&i>0){_.error("Table: "+this.getId()+" visibleRowCount('"+e+"') must be bigger than number of"+" fixed rows('"+(this.getFixedRowCount()+this.getFixedBottomRowCount())+"')",this);return this}if(this.getRowMode()){_.warning('If the "rowMode" aggregation is set, setting the "visibleRowCount" has no effect');return this.setProperty("visibleRowCount",e,true)}e=this.validateProperty("visibleRowCount",e);this.setProperty("visibleRowCount",e);d.dynamicCall(this._getSyncExtension,function(t){t.syncRowCount(e)});return this};D.prototype.setMinAutoRowCount=function(e){if(parseInt(e)<1){_.error("The minAutoRowCount property must be greater than 0. The value has been set to 1.",this);e=1}if(this.getRowMode()){_.warning('If the "rowMode" aggregation is set, setting the "minAutoRowCount" has no effect');return this.setProperty("minAutoRowCount",e,true)}return this.setProperty("minAutoRowCount",e)};D.prototype.setTooltip=function(e){_.warning("The aggregation tooltip is not supported for sap.ui.table.Table",this);return this.setAggregation("tooltip",e,true)};D.prototype.setNavigationMode=function(){this.setProperty("navigationMode","Scrollbar",true);_.error("The navigationMode property is deprecated and must not be used anymore. Your setting was defaulted to 'Scrollbar'",this);return this};D.prototype._getRowContexts=function(e){var t=this.getBinding();var i=this._getRowCounts();var o=this.getThreshold();e=e==null?i.count:e;if(o!==0){o=Math.max(e-i.fixedTop-i.fixedBottom,o)}e=Math.max(e,H(this).getMinRequestLength(),0);if(!t||e===0){return[]}var n=this._getFirstRenderedRowIndex();var r=[];if(i.fixedTop>0&&n>0){W(r,this._getFixedTopRowContexts(),0);W(r,this._getContexts(n+i.fixedTop,e-i.fixedBottom-i.fixedTop,o),i.fixedTop)}else{W(r,this._getContexts(n,e-i.fixedBottom,o),0)}if(i.fixedBottom>0){W(r,this._getFixedBottomRowContexts(),Math.min(i.fixedTop+i.scrollable,Math.max(this._getTotalRowCount()-i.fixedBottom,0)))}return r};function W(e,t,i){for(var o=0;o<t.length;o++){e[i+o]=t[o]}}D.prototype._getFixedTopRowContexts=function(){var e=this._getRowCounts();return e.fixedTop>0?this._getContexts(0,e.fixedTop,0,true):[]};D.prototype._getFixedBottomRowContexts=function(){var e=this._getRowCounts();var t=G(this,true);if(e.fixedBottom>0&&e.count-e.fixedBottom<t){return this._getContexts(t-e.fixedBottom,e.fixedBottom,0,true)}else{return[]}};D.prototype._getContexts=function(e,t,i,o){var n=this.getBinding();return n?n.getContexts(e,t,i,o):[]};D.prototype._adjustToTotalRowCount=function(){var e=this._getTotalRowCount();if(this._iBindingLength!==e){this._iBindingLength=e;this._updateFixedBottomRows();this._adjustFirstVisibleRowToTotalRowCount();d.Hook.call(this,M.TotalRowCountChanged)}};D.prototype._adjustFirstVisibleRowToTotalRowCount=function(){var e=this.getFirstVisibleRow();var t=this._getMaxFirstVisibleRowIndex();if(t<e&&this._bContextsAvailable){this._setFirstVisibleRowIndex(t,{onlySetProperty:true})}};D.prototype.refreshRows=function(e){this._bContextsAvailable=false;if(e===o.Sort||e===o.Filter){this.setFirstVisibleRow(0)}d.Hook.call(this,M.RefreshRows,e||d.RowsUpdateReason.Unknown)};D.prototype.updateRows=function(e,t){if(this.bIsDestroyed||this._bIsBeingDestroyed){return}if(t.detailedReason==="AddVirtualContext"){z(this);return}else if(t.detailedReason==="RemoveVirtualContext"){O(this);return}this._bContextsAvailable=true;if(e===o.Sort||e===o.Filter){this.setFirstVisibleRow(0)}this._adjustToTotalRowCount();N(this,e)};function z(e){var t=e._getRowContexts()[0];O(e);e._oVirtualRow=e._getRowClone("virtual");e._oVirtualRow.setBindingContext(t,e.getBindingInfo("rows").model);e.addAggregation("_hiddenDependents",e._oVirtualRow)}function O(e){if(e._oVirtualRow){e._oVirtualRow.destroy();delete e._oVirtualRow}}function N(e,t){if(e._bContextsAvailable){d.Hook.call(e,M.UpdateRows,t||d.RowsUpdateReason.Unknown)}}D.prototype.insertRow=function(){_.error('The control manages the rows aggregation. The method "insertRow" cannot be used programmatically!',this);return this};D.prototype.addRow=function(){_.error('The control manages the rows aggregation. The method "addRow" cannot be used programmatically!',this);return this};D.prototype.removeRow=function(){_.error('The control manages the rows aggregation. The method "removeRow" cannot be used programmatically!',this);return null};D.prototype.removeAllRows=function(){_.error('The control manages the rows aggregation. The method "removeAllRows" cannot be used programmatically!',this);return[]};D.prototype.destroyRows=function(){_.error('The control manages the rows aggregation. The method "destroyRows" cannot be used programmatically!',this);return this};D.prototype.setCreationRow=function(e){if(!d.isA(e,"sap.ui.table.CreationRow")){e=null}return this.setAggregation("creationRow",e)};D.prototype.getCreationRow=function(){return this.getAggregation("creationRow")};D.prototype.autoResizeColumn=function(e){this._getPointerExtension().doAutoResizeColumn(e)};D.prototype._attachEvents=function(){var t=this.$();var i=this.getId();if(S.getAnimationMode()!==S.AnimationMode.none){jQuery(document.body).on("webkitTransitionEnd."+i+" transitionend."+i,function(e){if(jQuery(e.target).has(t).length>0){this._updateTableSizes(d.RowsUpdateReason.Animation)}}.bind(this))}e.resize.attachHandler(this._onWindowResize,this);p.attachEvents(this)};D.prototype._detachEvents=function(){var t=this.getId();jQuery(document.body).off("webkitTransitionEnd."+t+" transitionend."+t);d.deregisterResizeHandler(this,"Table");e.resize.detachHandler(this._onWindowResize,this);p.detachEvents(this)};D.prototype._cleanUpTimers=function(){var e;for(e in this._mTimeouts){if(this._mTimeouts[e]){window.clearTimeout(this._mTimeouts[e]);delete this._mTimeouts[e]}}for(e in this._mAnimationFrames){if(this._mAnimationFrames[e]){window.cancelAnimationFrame(this._mAnimationFrames[e]);delete this._mAnimationFrames[e]}}};function q(e){var t=e.getDomRef();if(t){e.getDomRef().classList.toggle("sapUiTableEmpty",d.isNoDataVisible(e));e._getAccExtension().updateAriaStateForOverlayAndNoData();e._getKeyboardExtension().updateNoDataAndOverlayFocus()}}D.prototype.removeColumn=function(e){e=this.removeAggregation("columns",e);if(e===null){return e}if(!this._bReorderInProcess){this._removeSortedColumn(e)}k(this);return e};D.prototype.removeAllColumns=function(){var e=this.removeAllAggregation("columns");this._aSortedColumns=[];k(this);return e};D.prototype.destroyColumns=function(){var e=this.destroyAggregation("columns");this._aSortedColumns=[];k(this);return e};D.prototype.addColumn=function(e){this.addAggregation("columns",e);k(this);return this};D.prototype.insertColumn=function(e,t){this.insertAggregation("columns",e,t);k(this);return this};function k(e){e.invalidateRowsAggregation();e._invalidateComputedFixedColumnCount();var t=e.getCreationRow();if(t){t._update()}}D.prototype._getTotalRowCount=function(){return G(this)};function G(e,t){var i=e.getBinding();var o=e.getBindingInfo("rows");if(!i){return 0}if(o.length!=null){return o.length}if(t===true){return i.getLength()}if(!e._bContextsAvailable){return F(e).iCachedBindingLength}F(e).iCachedBindingLength=i.getLength();return F(e).iCachedBindingLength}D.prototype._getMaxFirstVisibleRowIndex=function(){var e;if(d.isVariableRowHeightEnabled(this)){e=this._getTotalRowCount()-1}else{e=this._getTotalRowCount()-this._getRowCounts().count}return Math.max(0,e)};D.prototype._getMaxFirstRenderedRowIndex=function(){var e=this._getTotalRowCount()-this._getRowCounts().count;return Math.max(0,e)};D.prototype._getFirstRenderedRowIndex=function(){return F(this).iFirstRenderedRowIndex};D.prototype._getVisibleColumns=function(){var e=[];var t=this.getColumns();for(var i=0,o=t.length;i<o;i++){if(t[i].shouldRender()){e.push(t[i])}}return e};D.prototype._getColumnsWidth=function(e,t){var i=this.getColumns();var o=0;if(e!==0&&!e){e=0}if(t!==0&&!t){t=i.length}for(var n=e,r=t;n<r;n++){if(i[n]&&i[n].shouldRender()){var s=d.convertCSSSizeToPixel(i[n].getWidth());if(s==null){s=d.Column.getMinColumnWidth()}o+=s}}return o};D.prototype._onTableResize=function(e){var t=e.oldSize.width;var i=e.size.width;if(this._bInvalid||!this.getDomRef()||t===i){return}this._updateTableSizes(d.RowsUpdateReason.Resize)};D.prototype._onWindowResize=function(){if(this._bInvalid||!this.getDomRef()){return}if(e.browser.chrome&&window.devicePixelRatio!==this._nDevicePixelRatio){this._nDevicePixelRatio=window.devicePixelRatio;this._updateTableSizes(d.RowsUpdateReason.Zoom);this._adjustOutlineOffset()}};D.prototype._adjustOutlineOffset=function(){if(window.devicePixelRatio<1){this.addStyleClass("sapUiTableZoomout")}else{this.removeStyleClass("sapUiTableZoomout")}};D.prototype._disableTextSelection=function(e){jQuery(e||document.body).attr("unselectable","on").css({"-moz-user-select":"none","-webkit-user-select":"none","user-select":"none"}).on("selectstart",function(e){e.preventDefault();return false})};D.prototype._enableTextSelection=function(e){jQuery(e||document.body).attr("unselectable","off").css({"-moz-user-select":"","-webkit-user-select":"","user-select":""}).off("selectstart")};D.prototype._findAndfireCellEvent=function(e,t,i){var o=jQuery(t.target);var n=o.closest(".sapUiTableDataCell");var r=n.attr("id");var s=/.*-row(\d*)-col(\d*)/i.exec(r);var l=false;if(s){var u=s[1];var d=s[2];var p=this.getRows()[u];var h=p&&p.getCells()[d];var g=p&&p.getIndex();var c=a.ofCell(h).getId();var f=p.getRowBindingContext();var y={rowIndex:g,columnIndex:d,columnId:c,cellControl:h,rowBindingContext:f,cellDomRef:n.get(0)};l=!e.call(this,y);if(!l&&typeof i==="function"){y.cellDomRef=n[0];l=i.call(this,y)}}return l};D.prototype.getFocusDomRef=function(){this._getKeyboardExtension().initItemNavigation();if(this.getShowOverlay()){return this.getDomRef("overlay")}if(d.isNoDataVisible(this)){return this.getDomRef("noDataCnt")}var e=this._oFocusInfo&&this._oFocusInfo.targetInfo&&d.isA(this._oFocusInfo.targetInfo,"sap.ui.core.message.Message");if(e&&this.getColumnHeaderVisible()){var i=this._getVisibleColumns()[0];if(i){return i.getDomRef()}}var o=d.getFocusedItemInfo(this);if(o&&o.domRef){return o.domRef}return t.prototype.getFocusDomRef.apply(this,arguments)};D.prototype.pushSortedColumn=function(e,t){if(!t){this._aSortedColumns=[]}if(this._aSortedColumns.indexOf(e)===-1){this._aSortedColumns.push(e)}};D.prototype._removeSortedColumn=function(e){var t=this._aSortedColumns.indexOf(e);if(t>-1){this._aSortedColumns.splice(t,1)}};D.prototype.getSortedColumns=function(){return this._aSortedColumns.slice()};D.prototype.sort=function(e,t,i){if(!e){this._aSortedColumns.forEach(e=>{e.setSorted(false);e.setSortOrder(B.None)});this.getBinding()?.sort();this._aSortedColumns=[]}if(this.getColumns().indexOf(e)>=0){e._sort(t??B.Ascending,i)}};D.prototype.filter=function(e,t){if(this.getColumns().indexOf(e)>=0){if(t==null){t=""}else if(typeof t!=="string"){throw new Error("The filter value is not a string")}e.filter(t)}};D.prototype._updateSelection=function(){var e=this.getSelectionMode();if(e===A.None){return}var t=this._getSelectionPlugin().getRenderConfig();var i;var o;var n=this.$("selall");var r=this.getRows();for(var s=0;s<r.length;s++){var a=r[s];a._updateSelection()}if(!t.headerSelector.visible){return}if(t.headerSelector.type==="toggle"){var l=t.headerSelector.selected;n.toggleClass("sapUiTableSelAll",!l);this._getAccExtension().setSelectAllState(l);i=l?"TBL_DESELECT_ALL":"TBL_SELECT_ALL"}else if(t.headerSelector.type==="clear"){n.toggleClass("sapUiTableSelAllDisabled",!t.headerSelector.enabled);i="TBL_DESELECT_ALL";if(t.headerSelector.enabled){n.removeAttr("aria-disabled")}else{n.attr("aria-disabled","true")}}if(i){o=d.getResourceText(i);n.attr("title",o)}};D.prototype._getHideStandardTooltips=function(){return this._bHideStandardTooltips};D.prototype._setHideStandardTooltips=function(e){this._bHideStandardTooltips=e};D.prototype._onSelectionChanged=function(e){this._updateSelection();if(this._hasSelectionPlugin()){return}var t=this._getSelectionPlugin();var i=e.getParameter("rowIndices");var o=e.getParameter("selectAll");var n=this._iSourceRowIndex!==undefined?this._iSourceRowIndex:t.getSelectedIndex();if(this.getMetadata().hasProperty("selectedIndex")){this.setProperty("selectedIndex",t.getSelectedIndex(),true)}this.fireRowSelectionChange({rowIndex:n,rowContext:this.getContextByIndex(n),rowIndices:i,selectAll:o,userInteraction:this._iSourceRowIndex!==undefined})};D.prototype.getContextByIndex=function(e){var t=this.getBinding();var i=null;if(!t||e<0){return i}if(t.getContextByIndex){i=t.getContextByIndex(e)}else{i=t.getContexts(e,1,0,true)[0]}return i||null};D.prototype.getSelectedIndex=function(){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#getSelectedIndex must not be called if a selection plugin is applied.")}return this._getSelectionPlugin().getSelectedIndex()};D.prototype.setSelectedIndex=function(e){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#setSelectedIndex must not be called if a selection plugin is applied.")}this._getSelectionPlugin().setSelectedIndex(e);return this};D.prototype.clearSelection=function(){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#clearSelection must not be called if a selection plugin is applied.")}this._getSelectionPlugin().clearSelection();return this};D.prototype.selectAll=function(){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#selectAll must not be called if a selection plugin is applied.")}if(d.hasSelectAll(this)){this._getSelectionPlugin().selectAll()}return this};D.prototype.getSelectedIndices=function(){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#getSelectedIndices must not be called if a selection plugin is applied.")}return this._getSelectionPlugin().getSelectedIndices()};D.prototype.addSelectionInterval=function(e,t){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#addSelectionInterval must not be called if a selection plugin is applied.")}this._getSelectionPlugin().addSelectionInterval(e,t);return this};D.prototype.setSelectionInterval=function(e,t){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#setSelectionInterval must not be called if a selection plugin is applied.")}this._getSelectionPlugin().setSelectionInterval(e,t);return this};D.prototype.removeSelectionInterval=function(e,t){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#removeSelectionInterval must not be called if a selection plugin is applied.")}this._getSelectionPlugin().removeSelectionInterval(e,t);return this};D.prototype.isIndexSelected=function(e){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#isIndexSelected must not be called if a selection plugin is applied.")}return this._getSelectionPlugin().isIndexSelected(e)};D.prototype.setGroupBy=function(e){var t=e;var i=sap.ui.getCore().byId(this.getGroupBy());if(typeof t==="string"){t=sap.ui.getCore().byId(t)}var o=false;if(t instanceof a&&t!==i){if(this.getColumns().indexOf(t)===-1){throw new Error("Column has to be part of the columns aggregation!")}var n=this.fireGroup({column:t,groupedColumns:[t.getId()],type:T.group});if(i){i.setGrouped(false);o=true}if(n&&this.getEnableGrouping()){t.setGrouped(true)}}if(!t||o){if(i){i.setGrouped(false)}d.Grouping.resetExperimentalGrouping(this)}this.setAssociation("groupBy",t);d.Grouping.setupExperimentalGrouping(this);return this};D.prototype.getBinding=function(e){return t.prototype.getBinding.call(this,e==null?"rows":e)};D.prototype.setEnableGrouping=function(e){var t=sap.ui.getCore().byId(this.getGroupBy());this.setProperty("enableGrouping",e);if(t){t.setGrouped(e)}if(e){d.Grouping.setupExperimentalGrouping(this)}else{d.Grouping.resetExperimentalGrouping(this)}return this};D.prototype.getComputedFixedColumnCount=function(){if(this._bIgnoreFixedColumnCount){return 0}return this._getSpanBasedComputedFixedColumnCount()};D.prototype._getSpanBasedComputedFixedColumnCount=function(){if(F(this).iComputedFixedColumnCount===null){var e=this.getColumns();var t;var i=this.getFixedColumnCount();for(var o=i-1;o>=0;o--){t=e[o];if(t){i=Math.max(i,t.getIndex()+d.Column.getHeaderSpan(t));break}}F(this).iComputedFixedColumnCount=Math.min(i,e.length)}return F(this).iComputedFixedColumnCount};D.prototype.setFixedColumnCount=function(e){this.setProperty("fixedColumnCount",e);this._invalidateComputedFixedColumnCount();var t=this.getColumns();var i;var o=this.$().find(".sapUiTableCtrlFirstCol > th");for(var n=this._getSpanBasedComputedFixedColumnCount()-1;n>=0;n--){i=t[n];if(i&&d.isVariableWidth(i.getWidth())){i._iFixWidth=o.filter("[data-sap-ui-headcolindex='"+i.getIndex()+"']").width()}}this._collectTableSizes();if(this.getEnableColumnFreeze()){this._invalidateColumnMenus()}return this};D.prototype.setFixedRowCount=function(e){if(!(parseInt(e)>=0)){_.error("Number of fixed rows must be greater or equal 0",this);return this}if(e+this.getFixedBottomRowCount()>=this.getVisibleRowCount()){_.error("Table '"+this.getId()+"' fixed rows('"+(e+this.getFixedBottomRowCount())+"') must be smaller than"+" numberOfVisibleRows('"+this.getVisibleRowCount()+"')",this);return this}if(this.getRowMode()){_.warning('If the "rowMode" aggregation is set, setting the "fixedRowCount" has no effect');return this.setProperty("fixedRowCount",e,true)}return this.setProperty("fixedRowCount",e)};D.prototype.setFixedBottomRowCount=function(e){if(!(parseInt(e)>=0)){_.error("Number of fixed bottom rows must be greater or equal 0",this);return this}if(e+this.getFixedRowCount()>=this.getVisibleRowCount()){_.error("Table '"+this.getId()+"' fixed rows('"+(e+this.getFixedRowCount())+"') must be smaller than"+" numberOfVisibleRows('"+this.getVisibleRowCount()+"')",this);return this}if(this.getRowMode()){_.warning('If the "rowMode" aggregation is set, setting the "iFixedBottomRowCount" has no effect');return this.setProperty("fixedBottomRowCount",e,true)}return this.setProperty("fixedBottomRowCount",e)};D.prototype.setThreshold=function(e){this.setProperty("threshold",e,true);return this};D.prototype._invalidateColumnMenus=function(){d.Hook.call(this,d.Hook.Keys.Table.InvalidateColumnMenus,this)};D.prototype._isTouchEvent=function(e){return!!(e&&e.originalEvent&&e.originalEvent.touches)};D.prototype._getRowClone=function(e){var t=typeof e==="number";var i=t;var o=i?this._aRowClones[e]:null;if(o&&!o.bIsDestroyed){return o}o=new l(this.getId()+"-rows"+"-row"+(t?e:"-"+e));if(i){this._aRowClones[e]=o}var n=this.getColumns();for(var r=0,s=n.length;r<s;r++){if(n[r].getVisible()){var a=n[r].getTemplateClone(r);if(a){o.addCell(a)}}}if(d.hasRowActions(this)){var u=this.getRowActionTemplate().clone();o.setAggregation("_rowAction",u,true)}var p=this.getRowSettingsTemplate();if(p){var h=p.clone();o.setAggregation("_settings",h,true)}return o};D.prototype.invalidateRowsAggregation=function(){this._bRowAggregationInvalid=true};D.prototype._invalidateComputedFixedColumnCount=function(){F(this).iComputedFixedColumnCount=null};D.prototype._getBaseRowHeight=function(){var e=H(this).getBaseRowContentHeight();if(e>0){return e+d.RowHorizontalFrameSize}else{return this._getDefaultRowHeight()}};D.prototype._getDefaultRowHeight=function(){var e=d.getContentDensity(this);return d.DefaultRowHeight[e]};D.prototype._getDefaultRowContentHeight=function(){var e=d.getContentDensity(this);return d.BaseSize[e]};D.prototype.setNoData=function(e){var t=d.getNoContentMessage(this);this.setAggregation("noData",e,true);var i=d.getNoContentMessage(this);if(d.isA(e,"sap.m.IllustratedMessage")){j(this)}else{this.destroyAggregation("_noColumnsMessage",true)}if(typeof t==="string"&&typeof i==="string"){if(t!==i){this.$("noDataMsg").text(i)}}else{this.invalidate()}return this};function j(e){if(e.getAggregation("_noColumnsMessage")||F(e).bIsLoadingNoColumnsMessage){return}F(e).bIsLoadingNoColumnsMessage=true;sap.ui.require(["sap/m/table/Util"],function(t){if(!d.isA(e.getNoData(),"sap.m.IllustratedMessage")){return}var i=t.getNoColumnsIllustratedMessage();i.setEnableVerticalResponsiveness(true);e.setAggregation("_noColumnsMessage",i,d.getVisibleColumnCount(e)>0);delete F(e).bIsLoadingNoColumnsMessage})}D.prototype.exportData=function(e){var t=sap.ui.requireSync("sap/ui/core/util/Export");e=e||{};if(!e.rows){var i=this.getBinding(),o=this.getBindingInfo("rows");var n=i.aFilters.concat(i.aApplicationFilters);e.rows={path:o.path,model:o.model,sorter:i.aSorters,filters:n,parameters:o.parameters}}if(!e.exportType){var r=sap.ui.requireSync("sap/ui/core/util/ExportTypeCSV");e.exportType=new r}var s=e.rows.model;if(!s){var a=e.rows.path;var l=a.indexOf(">");if(l>0){s=a.substr(0,l)}}if(!e.columns){e.columns=[];var u=this.getColumns();for(var d=0,p=u.length;d<p;d++){var h=u[d];if(h.getSortProperty()){e.columns.push({name:h.getLabel().getText(),template:{content:{path:h.getSortProperty(),model:s}}})}}}var g=new t(e);this.addDependent(g);return g};D.prototype._onPersoApplied=function(){var e=this.getColumns();var t=[];for(var i=0,o=e.length;i<o;i++){var n=e[i];if(n.getSorted()&&n.getSortOrder()!==B.None){t.push(new r(n.getSortProperty(),n.getSortOrder()===B.Descending))}}var s=this.getBinding();if(s){if(t.length>0){s.sort(t)}}};D.prototype.setBusy=function(e){var i=this.getBusy();var o=t.prototype.setBusy.call(this,e,"sapUiTableGridCnt");var n=this.getBusy();if(i!==n){this.fireBusyStateChanged({busy:n})}return o};D.prototype.setEnableBusyIndicator=function(e){this.setProperty("enableBusyIndicator",e,true);if(this.getEnableBusyIndicator()){$(this)}else{this.setBusy(false);K(this)}return this};D.prototype._onBindingDataRequested=function(){F(this).iPendingRequests++;$(this)};D.prototype._onBindingDataReceived=function(){F(this).iPendingRequests--;$(this)};D.prototype._hasPendingRequests=function(){return F(this).iPendingRequests>0};function $(e){if(!e.getEnableBusyIndicator()){return}K(e);if(e._hasPendingRequests()){e.setBusy(true)}else{F(e).hideBusyIndicatorTimeoutId=setTimeout(function(){e.setBusy(false);K(e)},10)}}function K(e){clearTimeout(F(e).hideBusyIndicatorTimeoutId);delete F(e).hideBusyIndicatorTimeoutId}D.prototype._setLargeDataScrolling=function(e){this._bLargeDataScrolling=!!e};D.prototype.setRowActionTemplate=function(e){this.setAggregation("rowActionTemplate",e);this.invalidateRowsAggregation();return this};D.prototype.setRowActionCount=function(e){if(typeof e==="number"){e=Math.max(0,Math.min(e,2))}return this.setProperty("rowActionCount",e)};D.prototype.setRowSettingsTemplate=function(e){this.setAggregation("rowSettingsTemplate",e);this.invalidateRowsAggregation();return this};D.prototype._getSelectionPlugin=function(){var e=this._oSelectionPlugin||this._oLegacySelectionPlugin;if(typeof this._getSelectedIndicesCount==="function"&&e.getSelectedCount!==this._getSelectedIndicesCount){e.getSelectedCount=this._getSelectedIndicesCount;["isIndexSelected","setSelectedIndex","getSelectedIndex","getSelectedIndices","setSelectionInterval","addSelectionInterval","removeSelectionInterval","selectAll","clearSelection"].forEach(function(t){e[t]=this[t]}.bind(this))}return e};D.prototype._hasSelectionPlugin=function(){return this._oSelectionPlugin!=null};function Z(e){var t=e.getDependents().filter(e=>e.isA("sap.ui.table.plugins.SelectionPlugin"));t.unshift(...e.getPlugins());return t[0]}D.prototype._initSelectionPlugin=function(){var e=Z(this);if(this.isDestroyed()||this.isDestroyStarted()){return}if(e){this._destroyLegacySelectionPlugin();J(this,this._oSelectionPlugin);Y(this,e);this._oSelectionPlugin=e}else{this._initLegacySelectionPlugin();J(this,this._oSelectionPlugin);delete this._oSelectionPlugin}};D.prototype._initLegacySelectionPlugin=function(){if(this._oLegacySelectionPlugin||Z(this)){return}this._oLegacySelectionPlugin=this._createLegacySelectionPlugin();this.addAggregation("_hiddenDependents",this._oLegacySelectionPlugin);Y(this,this._oLegacySelectionPlugin)};D.prototype._destroyLegacySelectionPlugin=function(){if(this._oLegacySelectionPlugin&&!this._oLegacySelectionPlugin.isDestroyStarted()){this._oLegacySelectionPlugin.destroy();delete this._oLegacySelectionPlugin}};D.prototype._createLegacySelectionPlugin=function(){return new R};function Y(e,t){if(t&&t.getMetadata().hasEvent("selectionChange")){t.attachSelectionChange(e._onSelectionChanged,e)}}function J(e,t){if(t&&t.getMetadata().hasEvent("selectionChange")){t.detachSelectionChange(e._onSelectionChanged,e)}}D.prototype.insertAggregation=function(e,i,o,n){if(e==="_hiddenDependents"){return t.prototype.insertAggregation.call(this,e,i,o,true)}return t.prototype.insertAggregation.apply(this,arguments)};D.prototype.addAggregation=function(e,i,o){if(e==="_hiddenDependents"){return t.prototype.addAggregation.call(this,e,i,true)}return t.prototype.addAggregation.apply(this,arguments)};D.prototype.removeAggregation=function(e,i,o){if(e==="_hiddenDependents"){return t.prototype.removeAggregation.call(this,e,i,true)}return t.prototype.removeAggregation.apply(this,arguments)};D.prototype.removeAllAggregation=function(e,i){if(e==="_hiddenDependents"){return t.prototype.removeAllAggregation.call(this,e,true)}return t.prototype.removeAllAggregation.apply(this,arguments)};D.prototype.destroyAggregation=function(e,i){if(e==="_hiddenDependents"){return t.prototype.destroyAggregation.call(this,e,true)}t.prototype.destroyAggregation.apply(this,arguments);if(e==="rows"){this._aRowClones.forEach(function(e){e.destroy()});this._aRowClones=[]}return this};D.prototype.getCellControl=function(e,t,i){var o=d.getRowColCell(this,e,t,!i);return o.cell};D.prototype._fireRowsUpdated=function(e){var t={reason:e||d.RowsUpdateReason.Unknown};this.onRowsUpdated(t);clearTimeout(this._mTimeouts.fireRowsUpdated);this._mTimeouts.fireRowsUpdated=setTimeout(function(){this.onRowsContentUpdated(t);this.fireEvent("_rowsUpdated",t);this.fireRowsUpdated()}.bind(this),0)};D.prototype.onRowsUpdated=function(e){d.Grouping.updateGroups(this);d.Menu.closeContentCellContextMenu(this);this._getAccExtension()._updateAriaRowIndices();this._updateSelection();q(this);this.getRows().forEach(function(e){e.getCells().forEach(function(t){var i=a.ofCell(t);var o=i._getCellContentVisibilitySettings();var n=e.getDomRefs(true).row.find('td[data-sap-ui-colid="'+i.getId()+'"]');var r=true;if(!n){return}if(e.isGroupHeader()){if(!e.isExpandable()){r=o.groupHeader.nonExpandable}else if(e.isExpanded()){r=o.groupHeader.expanded}else{r=o.groupHeader.collapsed}}else if(e.isTotalSummary()){r=o.summary.total}else if(e.isGroupSummary()){r=o.summary.group}else{r=o.standard}n.toggleClass("sapUiTableCellHidden",!r)})})};D.prototype.onRowsContentUpdated=function(e){if(this.getRows().length>0){this._resetRowHeights();this._aRowHeights=this._collectRowHeights(false);this._updateRowHeights(this._aRowHeights,false);this._getAccExtension().updateAccForCurrentCell(e.reason)}};D.prototype._enableSynchronization=function(){var e=this;return new Promise(function(t,i){sap.ui.require(["sap/ui/table/extensions/Synchronization"],function(i){t(p.enrich(e,i).getInterface())},function(e){i(e)})})};D.prototype._enableLegacyMultiSelection=function(){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#_enableLegacyMultiSelection must not be called"+" if a selection plugin is applied.")}this._legacyMultiSelection=function(e,t){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: The legacy multi selection is not supported if a selection plugin is applied")}var i=!!(t.metaKey||t.ctrlKey);if(!this.isIndexSelected(e)){if(i){this.addSelectionInterval(e,e)}else{this.setSelectedIndex(e)}}else if(i||this.getSelectedIndices().length===1){this.removeSelectionInterval(e,e)}else{this.setSelectedIndex(e)}}.bind(this)};D.prototype._setRowCountConstraints=function(e){this.setProperty("rowCountConstraints",e)};function Q(e,t){const i=e.getAggregation("_hiddenDependents")||[];return t.filter(e=>!i.includes(e))}D.prototype.findAggregatedObjects=function(){return Q(this,t.prototype.findAggregatedObjects.apply(this,arguments))};D.prototype.findElements=function(){return Q(this,t.prototype.findElements.apply(this,arguments))};D.prototype.getPlugin=function(e){if(!e||!e.startsWith("sap.ui.table.plugins.")){throw new Error("This method can only be used to get plugins of the sap.ui.table library")}var t=this.getDependents().find(t=>t.isA(e));if(!t){t=this.getPlugins().find(t=>t.isA(e))}return t};return D});
/*
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/TablePersoController", ["./library","sap/ui/base/ManagedObject","sap/ui/core/syncStyleClass","sap/base/Log","sap/ui/thirdparty/jquery","./utils/TableUtils","sap/ui/core/Configuration"],function(e,t,r,a,jQuery,o,i){"use strict";var s=e.ResetAllMode;var n=t.extend("sap.ui.table.TablePersoController",{constructor:function(e,r){t.apply(this,arguments)},metadata:{deprecated:true,properties:{autoSave:{type:"boolean",defaultValue:true},persoService:{type:"any"},customDataKey:{type:"string",defaultValue:"persoKey"},showResetAll:{type:"boolean",defaultValue:true,since:"1.88"},resetAllMode:{type:"sap.ui.table.ResetAllMode",defaultValue:s.Default,since:"1.88"}},associations:{table:{type:"sap.ui.table.Table",multiple:false}},library:"sap.ui.table"}});n.prototype.init=function(){this._schemaProperty="_persoSchemaVersion";this._schemaVersion="1.0";this._oInitialPersoData=null;this._aTableEvents=["columnResize","columnMove","columnVisibility","sort","filter","group"];this._aColumnProperties=["visible","width","sorted","sortOrder","grouped","summed"];this._bSaveFilters=false;if(this._bSaveFilters){this._aTableEvents.push("filter");this._aColumnProperties.push("filtered");this._aColumnProperties.push("filterValue")}};n.prototype.setResetAllMode=function(e){if(!this._resetAllModeSet){this.setProperty("resetAllMode",e);this._resetAllModeSet=true}else{a.warning("resetAllMode of the TablePersoController can only be set once.")}};n.prototype.exit=function(){var e=this._getTable();if(e){this._manageTableEventHandlers(e,false)}delete this._schemaProperty;delete this._schemaVersion;delete this._oInitialPersoData;if(this._oDialog){this._oDialog.destroy();delete this._oDialog}};n.prototype.setPersoService=function(e){e=this.validateProperty("persoService",e);if(e&&(typeof e.getPersData!=="function"||typeof e.setPersData!=="function"||typeof e.delPersData!=="function")){throw new Error('Value of property "persoService" needs to be null/undefined or an object that has the methods '+'"getPersData", "setPersData" and "delPersData".')}var t=this.getPersoService();this.setProperty("persoService",e,true);var r=this.getPersoService();if(r&&r!==t&&this._getTable()&&(this.getAutoSave()||!t)){this.refresh()}return this};n.prototype.setAutoSave=function(e){var t=this.getAutoSave();this.setProperty("autoSave",e,true);var r=this.getAutoSave();if(r&&!t){this.savePersonalizations()}return this};n.prototype.setTable=function(e){var t=this._getTable();if(t){t._oPersoController=undefined}this.setAssociation("table",e,true);var r=this._getTable();if(r){r._oPersoController=this}if(t){this._manageTableEventHandlers(t,false)}if(r&&r!==t){if(this.getResetAllMode()===s.Default){this._oInitialPersoData=this._getCurrentTablePersoData(true)}this._manageTableEventHandlers(r,true);if(this.getPersoService()&&(this.getAutoSave()||!t)){this.refresh()}}else if(!r){this._oInitialPersoData=null}return this};n.prototype.setCustomDataKey=function(e){var t=this.getCustomDataKey();this.setProperty("customDataKey",e,true);var r=this.getCustomDataKey();if(this.getResetAllMode()===s.Default&&this._getTable()){this._oInitialPersoData=this._getCurrentTablePersoData(true)}if(t!==r&&this.getAutoSave()){this.savePersonalizations()}return this};n.prototype._manageTableEventHandlers=function(e,t){for(var r=0,a=this._aTableEvents.length;r<a;r++){var o=e[t?"attachEvent":"detachEvent"];o.apply(e,[this._aTableEvents[r],this._tableEventHandler,this])}};n.prototype.refresh=function(){var e=this;var t=this.getPersoService();if(t){return t.getPersData().done(function(t){var r=t&&Array.isArray(t.aColumns)?t:e._oInitialPersoData;e._adjustTable(r);if(e.getResetAllMode()===s.ServiceDefault){e._oInitialPersoData=e._getCurrentTablePersoData(true)}}).fail(function(){a.error("Problem reading persisted personalization data.")})}else{a.error("The Personalization Service is not available!");var r=jQuery.Deferred();r.reject();return r.promise()}};n.prototype.savePersonalizations=function(){var e=this.getPersoService();if(e){var t=this._getCurrentTablePersoData();t[this._schemaProperty]=this._schemaVersion;return e.setPersData(t).fail(function(){a.error("Problem persisting personalization data.")})}else{a.error("The Personalization Service is not available!");var r=jQuery.Deferred();r.reject();return r.promise()}};n.prototype._adjustTable=function(e){var t=this._getTable();if(!t||!e||!Array.isArray(e.aColumns)){return}var r={},o=t.getColumns();for(var i=0,s=o.length;i<s;i++){r[this._getColumnPersoKey(o[i])]=o[i]}var n=e.aColumns;for(var i=0,s=n.length;i<s;i++){var l=n[i];var u=r[l.id];if(u){if(t.indexOfColumn(u)!==l.order){t.removeColumn(u);t.insertColumn(u,l.order)}var h=u.getMetadata();for(var p=0,f=this._aColumnProperties.length;p<f;p++){var g=this._aColumnProperties[p];if(l[g]!==undefined){try{if(h.hasProperty(g)&&u.getProperty(g)!=l[g]){u.setProperty(g,l[g])}}catch(e){a.error('sap.ui.table.TablePersoController: failed to apply the value "'+u[g]+'" for the property + "'+g+'".')}}}}}if(typeof t._onPersoApplied==="function"){t._onPersoApplied()}};n.prototype._tableEventHandler=function(e){if(this.getAutoSave()&&!this._iTriggerSaveTimeout){var t=this;this._iTriggerSaveTimeout=setTimeout(function(){t.savePersonalizations();t._iTriggerSaveTimeout=null},0)}};n.prototype._getCurrentTablePersoData=function(e){var t=this._getTable(),r=t.getColumns();var a={aColumns:[]};for(var i=0,s=r.length;i<s;i++){var n=r[i];var l=this._getColumnPersoKey(n);var u={id:l,order:i};var h=n.getMetadata();for(var p=0,f=this._aColumnProperties.length;p<f;p++){var g=this._aColumnProperties[p];if(h.hasProperty(g)){u[g]=n.getProperty(g)}}if(e){u.text=o.Column.getHeaderText(n)||l}a.aColumns.push(u)}return a};n.prototype._getTable=function(){return sap.ui.getCore().byId(this.getTable())};n.prototype._getColumnPersoKey=function(e){return this._getPersoKey(this._getTable())+"-"+this._getPersoKey(e)};n.prototype._getPersoKey=function(e){var t=e.data(this.getCustomDataKey());if(!t){t=e.getId();if(t.indexOf(i.getUIDPrefix())===0){a.warning('Generated IDs should not be used as personalization keys! The stability cannot be ensured! (Control: "'+e.getId()+'")')}}return t};n.prototype.openDialog=function(e){var t=this;function a(){if(t._oDialog){r("sapUiSizeCompact",t._getTable(),t._oDialog._oDialog);t._oDialog.open()}}if(!this._oDialog){sap.ui.getCore().loadLibrary("sap.m",{async:true}).then(function(){sap.ui.require(["sap/m/TablePersoDialog"],function(r){t._oDialog=new r(t._getTable().getId()+"-PersoDialog",{persoService:t.getPersoService(),showSelectAll:true,showResetAll:e&&e.showResetAll||t.getShowResetAll(),hasGrouping:false,contentWidth:e&&e.contentWidth,contentHeight:e&&e.contentHeight||"20rem",initialColumnState:t._oInitialPersoData.aColumns,columnInfoCallback:function(e,r,a){return t._getCurrentTablePersoData(true).aColumns},confirm:function(){t._adjustTable(this.retrievePersonalizations());if(t.getAutoSave()){t.savePersonalizations()}}});t._oDialog._oDialog.addStyleClass("sapUiNoContentPadding");if(t.getResetAllMode()===s.ServiceReset&&t.getPersoService().getResetPersData){t._oDialog.setShowResetAll(false);t.getPersoService().getResetPersData().done(function(e){if(this._bIsBeingDestroyed){return}if(e){t._oDialog.setInitialColumnState(e.aColumns);t._oDialog.setShowResetAll(t.getShowResetAll())}})}a()})})}else{a()}};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/TableRenderer", ["sap/ui/Device","./library","./Column","./utils/TableUtils","./extensions/ExtensionBase","sap/ui/core/Renderer","sap/ui/core/IconPool","sap/ui/core/library","sap/base/Log"],function(e,t,a,i,r,s,n,l,o){"use strict";var d=l.SortOrder;var c=i.Column;var p={Begin:"flex-start",End:"flex-end",Left:undefined,Right:undefined,Center:"center"};var g=i.Hook.Keys.TableRenderer;var b={apiVersion:2};b.render=function(t,a){delete a._iHeaderRowCount;p.Left=a._bRtlMode?"flex-end":"flex-start";p.Right=a._bRtlMode?"flex-start":"flex-end";i.getResourceBundle();t.openStart("div",a);a._getAccRenderExtension().writeAriaAttributesFor(t,a,"ROOT");t.class("sapUiTable");if(e.browser.chrome&&window.devicePixelRatio<1){t.class("sapUiTableZoomout")}if("ontouchstart"in document){t.class("sapUiTableTouch")}t.class("sapUiTableSelMode"+a.getSelectionMode());if(a.getColumnHeaderVisible()){t.class("sapUiTableCHdr")}if(i.hasRowHeader(a)){t.class("sapUiTableRowSelectors")}if(i.hasRowHighlights(a)){t.class("sapUiTableRowHighlights")}try{var r=i._getTableTemplateHelper(true).addTableClass();if(r){t.class(r)}}catch(e){}var s=a._getScrollExtension();if(s.isVerticalScrollbarRequired()&&!s.isVerticalScrollbarExternal()){t.class("sapUiTableVScr")}if(a.getEditable&&a.getEditable()){t.class("sapUiTableEdt")}if(i.hasRowActions(a)){var n=a.getRowActionCount();t.class(n==1?"sapUiTableRActS":"sapUiTableRAct")}else if(i.hasRowNavigationIndicators(a)){t.class("sapUiTableRowNavIndicator")}if(i.isNoDataVisible(a)&&!a._hasPendingRequests()){t.class("sapUiTableEmpty")}if(a.getShowOverlay()){t.class("sapUiTableOverlay")}var l=i.Grouping.getModeCssClass(a);if(l){t.class(l)}t.style("width",a.getWidth());i.Hook.call(a,g.RenderTableStyles,t);if(a._bFirstRendering){t.class("sapUiTableNoOpacity")}t.openEnd();this.renderTabElement(t,"sapUiTableOuterBefore");t.openStart("div",a.getId()+"-before");t.class("sapUiTableBefore");t.openEnd();t.renderControl(a.getAggregation("_messageStrip"));if(a.getTitle()){this.renderHeader(t,a,a.getTitle())}if(a.getToolbar()){this.renderToolbar(t,a,a.getToolbar())}if(a.getExtension()&&a.getExtension().length>0){this.renderExtensions(t,a,a.getExtension())}t.close("div");t.openStart("div",a.getId()+"-sapUiTableCnt");t.class("sapUiTableCnt");t.attr("data-sap-ui-fastnavgroup","true");t.attr("data-sap-ui-pasteregion","true");a._getAccRenderExtension().writeAriaAttributesFor(t,a,"CONTAINER");t.openEnd();t.openStart("div",a.getId()+"-sapUiTableGridCnt");a._getAccRenderExtension().writeAriaAttributesFor(t,a,"CONTENT");t.openEnd();this.renderColRsz(t,a);this.renderColHdr(t,a);this.renderTable(t,a);t.close("div");var o=a.getCreationRow();if(o&&o.getVisible()){t.renderControl(o);this.renderHSbBackground(t,a);this.renderHSb(t,a)}a._getAccRenderExtension().writeHiddenAccTexts(t,a);t.openStart("div",a.getId()+"-overlay");t.class("sapUiTableOverlayArea");t.attr("tabindex","0");a._getAccRenderExtension().writeAriaAttributesFor(t,a,"OVERLAY");t.openEnd();t.close("div");t.close("div");t.openStart("div",a.getId()+"-after");t.openEnd();if(a.getFooter()){this.renderFooter(t,a,a.getFooter())}i.Hook.call(a,g.RenderInTableBottomArea,t);t.close("div");this.renderTabElement(t,"sapUiTableOuterAfter");t.close("div")};b.renderHeader=function(e,t,a){e.openStart("div");e.class("sapUiTableHdr");t._getAccRenderExtension().writeAriaAttributesFor(e,t,"TABLEHEADER");e.openEnd();e.renderControl(a);e.close("div")};b.renderToolbar=function(e,t,a){if(!i.isA(a,"sap.ui.core.Toolbar")){return}e.openStart("div");e.class("sapUiTableTbr");if(typeof a.getStandalone==="function"&&a.getStandalone()){a.setStandalone(false)}if(a.isA("sap.m.Toolbar")){a.setDesign("Transparent",true);a.addStyleClass("sapMTBHeader-CTX");e.class("sapUiTableMTbr")}t._getAccRenderExtension().writeAriaAttributesFor(e,t,"TABLESUBHEADER");e.openEnd();e.renderControl(a);e.close("div")};b.renderExtensions=function(e,t,a){for(var i=0,r=a.length;i<r;i++){this.renderExtension(e,t,a[i])}};b.renderExtension=function(e,t,a){e.openStart("div");e.class("sapUiTableExt");t._getAccRenderExtension().writeAriaAttributesFor(e,t,"TABLESUBHEADER");e.openEnd();e.renderControl(a);e.close("div")};b.renderTable=function(e,t){var a=t.getRows().length>0;this.renderTabElement(e,"sapUiTableCtrlBefore",a?"0":"-1");e.openStart("div",t.getId()+"-tableCCnt");i.Hook.call(t,g.RenderRowContainerStyles,e);e.class("sapUiTableCCnt");e.openEnd();this.renderTableCCnt(e,t);e.close("div");this.renderTabElement(e,"sapUiTableCtrlAfter",a?"0":"-1");this.renderTabElement(e,null,"-1",t.getId()+"-focusDummy");var r=t.getCreationRow();if(!r||!r.getVisible()){this.renderHSbBackground(e,t);this.renderHSb(e,t)}};b.renderTableCCnt=function(e,t){this.renderTableCtrl(e,t);this.renderRowHdr(e,t);this.renderRowActions(e,t);if(!t._getScrollExtension().isVerticalScrollbarExternal()){this.renderVSb(e,t)}e.openStart("div",t.getId()+"-noDataCnt");e.class("sapUiTableCtrlEmpty");e.attr("tabindex","0");t._getAccRenderExtension().writeAriaAttributesFor(e,t,"NODATA");e.openEnd();var a=i.getNoContentMessage(t);if(i.isA(a,"sap.ui.core.Control")){e.renderControl(a)}else{e.openStart("span",t.getId()+"-noDataMsg");e.class("sapUiTableCtrlEmptyMsg");e.openEnd();e.text(a);e.close("span")}e.close("div")};b.renderFooter=function(e,t,a){e.openStart("div");e.class("sapUiTableFtr");t._getAccRenderExtension().writeAriaAttributesFor(e,t,"TABLEFOOTER");e.openEnd();e.renderControl(a);e.close("div")};b.renderColHdr=function(e,t){var a=i.getHeaderRowCount(t);var r=t.getColumns();var s=t.getComputedFixedColumnCount();e.openStart("div");e.class("sapUiTableColHdrCnt");e.openEnd();this.renderColRowHdr(e,t);if(s>0){e.openStart("div");e.class("sapUiTableCHA");e.class("sapUiTableCtrlScrFixed");e.class("sapUiTableNoOpacity");e.openEnd();this.renderTableControlCnt(e,t,true,0,s,true,false,0,a,true);e.close("div")}e.openStart("div",t.getId()+"-sapUiTableColHdrScr");e.class("sapUiTableCHA");e.class("sapUiTableCtrlScr");if(r.length==0){e.class("sapUiTableHasNoColumns")}if(s>0){if(t._bRtlMode){e.style("margin-right","0")}else{e.style("margin-left","0")}}e.openEnd();this.renderTableControlCnt(e,t,false,s,r.length,false,false,0,a,true);e.close("div");e.openStart("div");e.class("sapUiTableVSbHeader");e.openEnd();e.close("div");if(i.hasRowActions(t)){e.openStart("div",t.getId()+"-rowacthdr");t._getAccRenderExtension().writeAriaAttributesFor(e,t,"ROWACTIONHEADER");e.class("sapUiTableCell");e.class("sapUiTableHeaderCell");e.class("sapUiTableRowActionHeaderCell");e.openEnd();e.openStart("span");e.openEnd();e.text(i.getResourceText("TBL_ROW_ACTION_COLUMN_LABEL"));e.close("span");e.close("div")}e.close("div")};b.renderColRowHdr=function(e,a){var r=false;var s=false;var n=a._getSelectionPlugin().getRenderConfig();e.openStart("div",a.getId()+"-selall");e.class("sapUiTableCell");e.class("sapUiTableHeaderCell");e.class("sapUiTableRowSelectionHeaderCell");var l;if(n.headerSelector.visible){var o=n.headerSelector.selected;if(n.headerSelector.type==="toggle"){l=o?"TBL_DESELECT_ALL":"TBL_SELECT_ALL"}else if(n.headerSelector.type==="clear"){l="TBL_DESELECT_ALL";if(!n.headerSelector.enabled){e.class("sapUiTableSelAllDisabled");e.attr("aria-disabled","true")}}if(l){e.attr("title",i.getResourceText(l))}if(!o){e.class("sapUiTableSelAll")}else{s=true}e.class("sapUiTableSelAllVisible");r=true}e.attr("tabindex","-1");var d={enabled:r,checked:s};a._getAccRenderExtension().writeAriaAttributesFor(e,a,"COLUMNROWHEADER",d);e.openEnd();if(n.headerSelector.visible){if(n.headerSelector.type==="clear"&&n.headerSelector.icon){e.renderControl(n.headerSelector.icon)}else{e.openStart("div");e.class("sapUiTableSelectAllCheckBox");e.openEnd();e.close("div")}}if(i.hasRowHeader(a)&&a.getSelectionMode()===t.SelectionMode.None){e.openStart("span",a.getId()+"-rowselecthdr");e.class("sapUiPseudoInvisibleText");e.openEnd();e.text(i.getResourceText("TBL_ROW_SELECTION_COLUMN_LABEL"));e.close("span")}e.close("div")};b.renderCol=function(e,t,a,r,n,l,o,c,g){var b,T=!n,f=a.getIndex(),u=a.getMultiLabels();if(u.length>0){b=u[r]}else if(r==0){b=a.getLabel()}var C=a.getId();if(r===0){e.openStart("td",a)}else{C=C+"_"+r;e.openStart("td",C)}e.attr("data-sap-ui-related",a.getId());e.attr("data-sap-ui-colid",a.getId());e.attr("data-sap-ui-colindex",f);e.attr("tabindex","-1");var h={column:a,headerId:C,index:f};if(n>1){e.attr("colspan",n);h.colspan=true}if(g){var R=a.getFiltered();var v=a.getSortOrder()!==d.None;if(!a.getSorted()){v=false}if(R){e.class("sapUiTableColFiltered")}if(v){e.class("sapUiTableColSorted");if(a.getSortOrder()===d.Descending){e.class("sapUiTableColSortedD")}}}t._getAccRenderExtension().writeAriaAttributesFor(e,t,"COLUMNHEADER",h);e.class("sapUiTableCell");e.class("sapUiTableHeaderCell");e.class("sapUiTableHeaderDataCell");var S=a.getHeaderMenuInstance();if(t.getEnableColumnReordering()||t.hasListeners("columnSelect")||S&&S.getAriaHasPopupType()!=="None"){e.class("sapUiTableHeaderCellActive")}if(!t.getEnableColumnReordering()&&!t.hasListeners("columnSelect")&&!S&&a._menuHasItems()){e.class("sapUiTableHeaderCellActive")}if(l){e.class("sapUiTableCellFirst")}if(o){e.class("sapUiTableCellLastFixed")}if(c){e.class("sapUiTableCellLast")}if(T){e.class("sapUiTableHidden")}if(t.getColumnHeaderHeight()>0){e.style("height",t.getColumnHeaderHeight()+"px")}var E=a.getTooltip_AsString();if(E){e.attr("title",E)}e.openEnd();e.openStart("div",C+"-inner");e.class("sapUiTableCellInner");if(!i.hasRowHeader(t)&&l&&!i.hasRowHighlights(t)&&!i.Grouping.isInTreeMode(t)){e.class("sapUiTableFirstColumnCell")}var A=a.getHAlign();var w=s.getTextAlign(A);if(w){e.style("text-align",w)}e.openEnd();e.openStart("div");e.style("justify-content",p[A]);e.openEnd();if(b){e.renderControl(b)}e.close("div");e.close("div");e.close("td")};b.renderColRsz=function(e,t){e.openStart("div",t.getId()+"-rsz");e.class("sapUiTableColRsz");e.openEnd();e.close("div")};b.renderRowHdr=function(e,t){e.openStart("div",t.getId()+"-sapUiTableRowHdrScr");t._getAccRenderExtension().writeAriaAttributesFor(e,t,"PRESENTATION");e.class("sapUiTableRowHdrScr");e.class("sapUiTableNoOpacity");t._getAccRenderExtension().writeAriaAttributesFor(e,t,"ROWHEADER_COL");e.openEnd();for(var a=0,i=t.getRows().length;a<i;a++){this.renderRowAddon(e,t,t.getRows()[a],a,true)}e.close("div")};b.renderRowActions=function(e,t){if(!i.hasRowActions(t)&&!i.hasRowNavigationIndicators(t)){return}e.openStart("div",t.getId()+"-sapUiTableRowActionScr");t._getAccRenderExtension().writeAriaAttributesFor(e,t,"PRESENTATION");i.hasRowActions(t)?e.class("sapUiTableRowWithAction"):e.class("sapUiTableRowActionScr");e.class("sapUiTableNoOpacity");e.openEnd();for(var a=0,r=t.getRows().length;a<r;a++){this.renderRowAddon(e,t,t.getRows()[a],a,false)}e.close("div")};b.addRowCSSClasses=function(e,t,a){var r=t._getRowCounts();var s=i.getFirstFixedBottomRowIndex(t);if(a===0){e.class("sapUiTableFirstRow")}else if(a===t.getRows().length-1){e.class("sapUiTableLastRow")}if(r.fixedTop>0){if(a==r.fixedTop-1){e.class("sapUiTableRowLastFixedTop")}if(a==r.fixedTop){e.class("sapUiTableRowFirstScrollable")}}if(s>=0&&s===a){e.class("sapUiTableRowFirstFixedBottom")}else if(s>=1&&s-1===a){e.class("sapUiTableRowLastScrollable")}};b.renderRowAddon=function(e,t,a,r,s){var n=t._getSelectionPlugin().isSelected(a);e.openStart("div");e.attr("data-sap-ui-related",a.getId());e.attr("data-sap-ui-rowindex",r);e.class("sapUiTableRow");e.class("sapUiTableContentRow");if(a.isContentHidden()){e.class("sapUiTableRowHidden")}else if(n){e.class("sapUiTableRowSel")}if(r%2!=0&&t.getAlternateRowColors()&&!i.Grouping.isInTreeMode(t)){e.class("sapUiTableRowAlternate")}this.addRowCSSClasses(e,t,r);e.openEnd();e.openStart("div",t.getId()+(s?"-rowsel":"-rowact")+r);e.class("sapUiTableCell");e.class("sapUiTableContentCell");e.class(s?"sapUiTableRowSelectionCell":"sapUiTableRowActionCell");i.Hook.call(t,g.RenderRowStyles,e);e.attr("tabindex","-1");var l={rowSelected:n,rowHidden:a.isEmpty()};t._getAccRenderExtension().writeAriaAttributesFor(e,t,s?"ROWHEADER":"ROWACTION",l);e.openEnd();if(s){this.writeRowHighlightContent(e,t,a,r);this.writeRowSelectorContent(e,t,a)}else{var o=a.getRowAction();if(o){e.renderControl(o)}this.writeRowNavigationContent(e,t,a,r)}e.close("div");e.close("div")};b.renderTableCtrl=function(e,t){if(t.getComputedFixedColumnCount()>0){e.openStart("div",t.getId()+"-sapUiTableCtrlScrFixed");e.class("sapUiTableCtrlScrFixed");e.openEnd();this.renderTableControl(e,t,true);e.close("div")}e.openStart("div",t.getId()+"-sapUiTableCtrlScr");e.class("sapUiTableCtrlScr");if(t.getComputedFixedColumnCount()>0){if(t._bRtlMode){e.style("margin-right","0")}else{e.style("margin-left","0")}}e.openEnd();e.openStart("div",t.getId()+"-tableCtrlCnt");e.class("sapUiTableCtrlCnt");e.openEnd();this.renderTableControl(e,t,false);e.close("div");e.close("div")};b.renderTableControl=function(e,t,a){var i,r;if(a){i=0;r=t.getComputedFixedColumnCount()}else{i=t.getComputedFixedColumnCount();r=t.getColumns().length}var s=t._getRowCounts();var n=t.getRows();if(s.fixedTop>0){this.renderTableControlCnt(e,t,a,i,r,true,false,0,s.fixedTop)}this.renderTableControlCnt(e,t,a,i,r,false,false,s.fixedTop,n.length-s.fixedBottom);if(s.fixedBottom>0&&n.length>0){this.renderTableControlCnt(e,t,a,i,r,false,true,n.length-s.fixedBottom,n.length)}};b.renderTableControlCnt=function(e,t,a,r,s,n,l,o,d,c){var p=c?"-header":"-table";var g=t.getId()+p;var b=[];if(a){g+="-fixed";b.push("sapUiTableCtrlFixed")}else{b.push("sapUiTableCtrlScroll")}if(n){g+="-fixrow";b.push("sapUiTableCtrlRowFixed")}else if(l){g+="-fixrow-bottom";b.push("sapUiTableCtrlRowFixedBottom")}else{b.push("sapUiTableCtrlRowScroll")}e.openStart("table",g);b.forEach(function(t){e.class(t)});t._getAccRenderExtension().writeAriaAttributesFor(e,t,c?"COLUMNHEADER_TABLE":"TABLE");e.class("sapUiTableCtrl");if(c){e.class("sapUiTableCHT")}e.style(a?"width":"min-width",t._getColumnsWidth(r,s)+"px");e.openEnd();e.openStart("thead").openEnd();e.openStart("tr");e.class("sapUiTableCtrlCol");if(o==0){e.class("sapUiTableCtrlFirstCol")}if(c){e.class("sapUiTableCHTHR")}e.openEnd();var T=t.getColumns();var f=new Array(s);var u;var C;var h=!a&&s>r;var R=t._getVisibleColumns();for(u=r;u<s;u++){C=T[u];var v={shouldRender:!!(C&&C.shouldRender())};if(v.shouldRender){var S=C.getWidth();if(i.isVariableWidth(S)){h=false;if(a){C._iFixWidth=C._iFixWidth||160;S=C._iFixWidth+"px"}}else if(a){delete C._iFixWidth}v.width=S}f[u]=v}if(T.length===0){e.openStart("th").openEnd().close("th")}for(u=r;u<s;u++){p=c?"_hdr":"_col";C=T[u];v=f[u];if(v.shouldRender){if(o==0){e.openStart("th",t.getId()+p+u);t._getAccRenderExtension().writeAriaAttributesFor(e,t,"TH",{column:C})}else{e.openStart("th")}e.style("width",v.width);e.attr("data-sap-ui-headcolindex",u);e.attr("data-sap-ui-colid",C.getId());if(C===R[0]){e.class("sapUiTableFirstVisibleColumnTH")}e.openEnd();if(o==0&&i.getHeaderRowCount(t)==0&&!c){if(C.getMultiLabels().length>0){e.renderControl(C.getMultiLabels()[0])}else{e.renderControl(C.getLabel())}}e.close("th")}}if(h){e.openStart("th",c&&t.getId()+"-dummycolhdr");t._getAccRenderExtension().writeAriaAttributesFor(e,t,"PRESENTATION");e.openEnd().close("th")}e.close("tr");e.close("thead");e.openStart("tbody").openEnd();var E=t.getRows();var A;var w;if(c){for(A=o,w=d;A<w;A++){this.renderColumnHeaderRow(e,t,A,a,r,s,h,A===w-1)}}else{var x=t._getAccExtension().getAriaTextsForSelectionMode(true);var U=i.isRowSelectionAllowed(t);var H=t.getDragDropConfig().some(function(e){return e.getMetadata().isInstanceOf("sap.ui.core.dnd.IDragInfo")&&e.getSourceAggregation()==="rows"});var I=this.getLastFixedColumnIndex(t);for(A=o,w=d;A<w;A++){this.renderTableRow(e,t,E[A],A,a,r,s,false,R,I,h,x,U,H)}}e.close("tbody");e.close("table")};b.writeRowSelectorContent=function(e,t,a){t._getAccRenderExtension().writeAccRowSelectorText(e,t,a);if(i.Grouping.isInGroupMode(t)){e.openStart("div");e.class("sapUiTableGroupShield");e.openEnd();e.close("div");e.openStart("div",a.getId()+"-groupHeader");e.class("sapUiTableGroupIcon");e.openEnd();e.close("div");if(i.Grouping.showGroupMenuButton(t)){var r=n.getIconInfo("sap-icon://drop-down-list");e.openStart("div").class("sapUiTableGroupMenuButton").openEnd();e.text(r.content);e.close("div")}}};b.writeRowHighlightContent=function(e,t,a,r){if(!i.hasRowHighlights(t)){return}var s=a.getAggregation("_settings");var n=s._getHighlightCSSClassName();e.openStart("div",a.getId()+"-highlight");e.class("sapUiTableRowHighlight");e.class(n);e.openEnd();t._getAccRenderExtension().writeAccRowHighlightText(e,t,a,r);e.close("div")};b.writeRowNavigationContent=function(e,t,a,r){if(!i.hasRowNavigationIndicators(t)){return}var s=a.getAggregation("_settings");e.openStart("div",a.getId()+"-navIndicator");if(s.getNavigated()){e.class("sapUiTableRowNavigated")}e.openEnd();e.close("div")};b.renderColumnHeaderRow=function(e,t,a,i,r,s,n,l){e.openStart("tr");e.class("sapUiTableRow");e.class("sapUiTableHeaderRow");e.class("sapUiTableColHdrTr");t._getAccRenderExtension().writeAriaAttributesFor(e,t,"COLUMNHEADER_ROW");e.openEnd();var o=this.getColumnsToRender(t,r,s),d=0,p=-1;function g(e,t,i){var r=c.getHeaderSpan(e,a),s;if(d<1){if(r>1){s=e.getIndex();r=i.slice(t+1,t+r).reduce(function(e,t){return t.getIndex()-s<r?e+1:e},1)}e._nSpan=d=r;p=t}else{e._nSpan=0}d--}o.forEach(g);function b(r,s){this.renderCol(e,t,r,a,r._nSpan,s===0,i&&s==p,!i&&s==p,r._nSpan===1&&!r._bIconsRendered);r._bIconsRendered=r._bIconsRendered||r._nSpan===1;delete r._nSpan;if(l){delete r._bIconsRendered}}o.forEach(b.bind(this));if(!i&&n&&o.length>0){e.openStart("td").class("sapUiTableCellDummy");t._getAccRenderExtension().writeAriaAttributesFor(e,t,"PRESENTATION");e.openEnd().close("td")}e.close("tr")};b.renderTableRow=function(e,t,a,r,s,n,l,o,d,c,p,b,T,f){if(!a){return}var u=t._getSelectionPlugin();if(s){e.openStart("tr",a.getId()+"-fixed");e.attr("data-sap-ui-related",a.getId())}else{e.openStart("tr",a)}if(a._bDummyRow){e.style("opacity","0")}e.class("sapUiTableRow");e.class("sapUiTableContentRow");e.class("sapUiTableTr");if(f&&s){e.attr("draggable","true");e.attr("data-sap-ui-draggable","true")}if(a.isContentHidden()){e.class("sapUiTableRowHidden")}else if(u.isSelected(a)){e.class("sapUiTableRowSel")}if(r%2!=0&&t.getAlternateRowColors()&&!i.Grouping.isInTreeMode(t)){e.class("sapUiTableRowAlternate")}this.addRowCSSClasses(e,t,r);e.attr("data-sap-ui-rowindex",r);i.Hook.call(t,g.RenderRowStyles,e);var C=a.getAggregation("_settings");var h={index:r,fixedCol:s,rowNavigated:C?C.getNavigated():false};t._getAccRenderExtension().writeAriaAttributesFor(e,t,"TR",h);e.openEnd();var R=!a.isEmpty()&&u.isSelected(a);var v=a.getCells();for(var S=0,E=v.length;S<E;S++){this.renderTableCell(e,t,a,v[S],S,s,n,l,d,c,R)}if(!s&&p&&v.length>0){e.openStart("td").class("sapUiTableCellDummy");t._getAccRenderExtension().writeAriaAttributesFor(e,t,"PRESENTATION");e.openEnd();e.close("td")}e.close("tr")};b.renderTableCell=function(e,t,r,n,l,o,d,c,p,b,T){var f=a.ofCell(n);var u=f.getIndex();if(f.shouldRender()&&d<=u&&c>u){var C=r.getId()+"-col"+l;e.openStart("td",C);e.attr("tabindex","-1");e.attr("data-sap-ui-colid",f.getId());var h=p.length;var R=h>0&&p[0]===f;var v=h>0&&p[h-1]===f;var S=o&&b===u;var E={index:u,column:f,row:r,fixed:o,rowSelected:T};t._getAccRenderExtension().writeAriaAttributesFor(e,t,"DATACELL",E);var A=s.getTextAlign(f.getHAlign());if(A){e.style("text-align",A)}e.class("sapUiTableCell");e.class("sapUiTableContentCell");e.class("sapUiTableDataCell");if(R){e.class("sapUiTableCellFirst")}if(S){e.class("sapUiTableCellLastFixed")}if(v){e.class("sapUiTableCellLast")}if(R&&i.Grouping.isInTreeMode(t)){e.class("sapUiTableCellFlex")}e.openEnd();e.openStart("div");e.class("sapUiTableCellInner");if(!i.hasRowHeader(t)&&R&&!i.hasRowHighlights(t)&&!i.Grouping.isInTreeMode(t)){e.class("sapUiTableFirstColumnCell")}i.Hook.call(t,g.RenderCellContentStyles,e);e.openEnd();this.renderTableCellControl(e,t,n,R);e.close("div");e.close("td")}};b.renderTableCellControl=function(e,t,a,r){if(r&&i.Grouping.isInTreeMode(t)){var s=a.getParent();e.openStart("span",s.getId()+"-treeicon");e.class("sapUiTableTreeIcon");e.attr("tabindex","-1");t._getAccRenderExtension().writeAriaAttributesFor(e,t,"TREEICON",{row:s});e.openEnd();e.close("span")}e.renderControl(a)};b.renderVSb=function(e,t,a){var i=t._getScrollExtension();var r=t._getRowCounts();a=Object.assign({tabIndex:true},a);e.openStart("div");e.class("sapUiTableVSbContainer");if(!i.isVerticalScrollbarRequired()){e.class("sapUiTableHidden")}e.class(a.cssClass);e.openEnd();e.openStart("div",t.getId()+"-vsb");e.class("sapUiTableVSb");e.style("max-height",i.getVerticalScrollbarHeight()+"px");if(r.fixedTop>0){e.style("top",r.fixedTop*t._getBaseRowHeight()-1+"px")}if(a.tabIndex){e.attr("tabindex","-1")}e.openEnd();e.openStart("div");e.class("sapUiTableVSbContent");e.style("height",i.getVerticalScrollHeight()+"px");e.openEnd();e.close("div");e.close("div");e.close("div")};b.renderVSbExternal=function(e,t){if(r.isEnrichedWith(t,"sap.ui.table.extensions.Synchronization")){this.renderVSb(e,t,{cssClass:"sapUiTableVSbExternal",tabIndex:false})}else{o.error("This method can only be used with synchronization enabled.",t,"TableRenderer.renderVSbExternal")}};b.renderHSb=function(e,t,a){a=Object.assign({id:t.getId()+"-hsb",cssClass:"sapUiTableHSb",tabIndex:true,hidden:true,scrollWidth:0},a);e.openStart("div",a.id);e.class(a.cssClass);if(a.hidden){e.class("sapUiTableHidden")}if(a.tabIndex){e.attr("tabindex","-1")}e.openEnd();e.openStart("div",a.id+"-content");e.class("sapUiTableHSbContent");if(a.scrollWidth>0){e.style("width",a.scrollWidth+"px")}e.openEnd();e.close("div");e.close("div")};b.renderHSbExternal=function(e,t,a,i){if(r.isEnrichedWith(t,"sap.ui.table.extensions.Synchronization")){this.renderHSb(e,t,{id:a,cssClass:"sapUiTableHSbExternal",tabIndex:false,hidden:false,scrollWidth:i})}else{o.error("This method can only be used with synchronization enabled.",t,"TableRenderer.renderVSbExternal")}};b.renderHSbBackground=function(e,t){e.openStart("div",t.getId()+"-hsb-bg");e.class("sapUiTableHSbBg");e.openEnd().close("div")};b.renderTabElement=function(e,t,a,i){e.openStart("div");if(t){e.class(t)}if(i){e.attr("id",i)}e.attr("role","none");e.attr("tabindex",a==null?"0":a);e.openEnd().close("div")};b.getColumnsToRender=function(e,t,a){return e.getColumns().slice(t,a).filter(function(e){return e&&e.shouldRender()})};b.getLastFixedColumnIndex=function(e){var t=e.getComputedFixedColumnCount();var a=e.getColumns();var i,r;for(var s=t-1;s>=0;s--){i=a[s];if(i.shouldRender()){r=s;break}}return r};return b},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/TreeTable", ["./Table","./TableRenderer","sap/ui/model/ClientTreeBindingAdapter","sap/ui/model/TreeBindingCompatibilityAdapter","./library","./utils/TableUtils","./plugins/BindingSelection","sap/base/Log","sap/base/assert","sap/ui/model/controlhelper/TreeBindingProxy"],function(e,t,o,r,i,n,s,a,p,l){"use strict";var u=n.createWeakMapFacade();var d=e.extend("sap.ui.table.TreeTable",{metadata:{library:"sap.ui.table",properties:{expandFirstLevel:{type:"boolean",defaultValue:false,deprecated:true},useGroupMode:{type:"boolean",group:"Appearance",defaultValue:false},groupHeaderProperty:{type:"string",group:"Data",defaultValue:null},collapseRecursive:{type:"boolean",defaultValue:true,deprecated:true},rootLevel:{type:"int",group:"Data",defaultValue:0,deprecated:true}},events:{toggleOpenState:{parameters:{rowIndex:{type:"int"},rowContext:{type:"object"},expanded:{type:"boolean"}}}}},renderer:t});d.prototype.init=function(){e.prototype.init.apply(this,arguments);u(this).bPendingRequest=false;n.Grouping.setToDefaultTreeMode(this);n.Hook.register(this,n.Hook.Keys.Row.UpdateState,y,this);n.Hook.register(this,n.Hook.Keys.Row.Expand,g,this);n.Hook.register(this,n.Hook.Keys.Row.Collapse,h,this);this._oProxy=new l(this,"rows")};d.prototype._bindRows=function(t){u(this).bPendingRequest=false;var o=this.getExpandFirstLevel()?1:0;this._oProxy.applyLegacySettingsToBindingInfo(t,{rootLevel:this.isPropertyInitial("rootLevel")?undefined:this.getRootLevel(),collapseResursive:this.isPropertyInitial("collapseRecursive")?undefined:this.getCollapseRecursive(),numberOfExpandedLevels:this.isPropertyInitial("expandFirstLevel")?undefined:o});return e.prototype._bindRows.call(this,t)};function y(e){var t=e.context["_mProxyInfo"];e.level=t.level;e.expandable=!t.isLeaf;e.expanded=t.isExpanded;if(n.Grouping.isInGroupMode(this)){var o=this.getGroupHeaderProperty();if(o){e.title=e.context.getProperty(o)}if(e.expandable){e.type=e.Type.GroupHeader;e.contentHidden=true}}}function g(e){var t=e.getIndex();this._oProxy.expand(t);var o=this._oProxy.isExpanded(t);if(typeof o==="boolean"){this._onGroupHeaderChanged(t,o)}}function h(e){var t=e.getIndex();this._oProxy.collapse(t);var o=this._oProxy.isExpanded(t);if(typeof o==="boolean"){this._onGroupHeaderChanged(t,o)}}d.prototype.setFixedRowCount=function(e){a.warning('TreeTable: the property "fixedRowCount" is not supported and will be ignored!');return this};d.prototype.isTreeBinding=function(t){t=t||"rows";if(t==="rows"){return this._oProxy.isTreeBinding()}return e.prototype.isTreeBinding.apply(this,arguments)};d.prototype.getBinding=function(t){t=t==null?"rows":t;var i=e.prototype.getBinding.call(this,t);if(i&&t==="rows"&&!i.getLength){if(i.isA("sap.ui.model.odata.ODataTreeBinding")){r(i,this)}else if(i.isA("sap.ui.model.odata.v2.ODataTreeBinding")){i.applyAdapterInterface()}else if(i.isA("sap.ui.model.ClientTreeBinding")){o.apply(i)}else{a.error("Binding not supported by sap.ui.table.TreeTable")}}return i};d.prototype._getContexts=function(e,t,o,r){return this._oProxy.getContexts(e,t,o,r)};d.prototype._getRowContexts=function(e){return c(this,e)};function c(t,o,r){var i=t._getTotalRowCount();var n=e.prototype._getRowContexts.call(t,o);if(r===true){return n}var s=t._getTotalRowCount();var a=t._getFirstRenderedRowIndex();var p=t._getMaxFirstRenderedRowIndex();t._adjustToTotalRowCount();if(p<a&&t._bContextsAvailable){n=c(t,o,true)}else if(i!==s){n=c(t,o,true)}return n}d.prototype._onGroupHeaderChanged=function(e,t){this.fireToggleOpenState({rowIndex:e,rowContext:this.getContextByIndex(e),expanded:t})};d.prototype.expand=function(e){this._oProxy.expand(e);return this};d.prototype.collapse=function(e){this._oProxy.collapse(e);return this};d.prototype.collapseAll=function(){this._oProxy.collapseAll();if(this.getBinding()){this.setFirstVisibleRow(0)}return this};d.prototype.expandToLevel=function(e){this._oProxy.expandToLevel(e);return this};d.prototype.isExpanded=function(e){return this._oProxy.isExpanded(e)};d.prototype.getContextByIndex=function(e){return this._oProxy.getContextByIndex(e)};d.prototype.setRootLevel=function(e){this.setFirstVisibleRow(0);this._oProxy.setRootLevel(e);this.setProperty("rootLevel",e,true);return this};d.prototype.setCollapseRecursive=function(e){this._oProxy.setCollapseRecursive(e);this.setProperty("collapseRecursive",!!e,true);return this};d.prototype.setUseGroupMode=function(e){this.setProperty("useGroupMode",!!e);f(this);return this};d.prototype.setEnableGrouping=function(){a.warning("The property enableGrouping is not supported by the sap.ui.table.TreeTable control");return this};d.prototype.setGroupBy=function(){a.warning("The groupBy association is not supported by the sap.ui.table.TreeTable control");return this};d.prototype.setUseFlatMode=function(e){this._bFlatMode=!!e;f(this);return this};function f(e){if(e.getUseGroupMode()){n.Grouping.setHierarchyMode(e,n.Grouping.HierarchyMode.GroupedTree)}else if(e._bFlatMode){n.Grouping.setToDefaultFlatMode(e)}else if(!e._bFlatMode){n.Grouping.setToDefaultTreeMode(e)}}d.prototype._createLegacySelectionPlugin=function(){return new s};d.prototype._onBindingDataRequested=function(t){u(this).bPendingRequest=true;e.prototype._onBindingDataRequested.apply(this,arguments)};d.prototype._onBindingDataReceived=function(t){u(this).bPendingRequest=false;e.prototype._onBindingDataReceived.apply(this,arguments)};d.prototype._hasPendingRequests=function(){return u(this).bPendingRequest};return d});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/TreeTableRenderer", ["sap/ui/table/TreeTable"],function(e){"use strict";return e.getMetadata().getRenderer()},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/extensions/Accessibility", ["./ExtensionBase","./AccessibilityRender","../utils/TableUtils","../library","sap/ui/thirdparty/jquery","sap/ui/core/Configuration"],function(e,t,a,r,jQuery,i){"use strict";var o=r.SelectionMode;var l=a.CELLTYPE;var n={getAccInfoOfControl:function(e){var t=null;if(e&&typeof e.getAccessibilityInfo==="function"){if(typeof e.getVisible==="function"&&!e.getVisible()){t=n._normalize({})}else{var r=e.getAccessibilityInfo();if(r){var i={};n._flatten(r,i);t=i}}if(t&&!t.description){t.description=a.getResourceText("TBL_CTRL_STATE_EMPTY")}}return t},_normalize:function(e){if(!e){return null}if(e._normalized){return e}e.role=e.role||"";e.type=e.type||"";e.description=e.description||"";e.enabled=e.enabled===true||e.enabled===false?e.enabled:null;e.editable=e.editable===true||e.editable===false?e.editable:null;e.children=e.children||[];e._normalized=true;return e},_flatten:function(e,t,a){a=a?a:0;n._normalize(e);if(a==0){n._normalize(t);t._descriptions=[]}t._descriptions.push(n._getFullDescription(e));e.children.forEach(function(e){if(!e.getAccessibilityInfo||e.getVisible&&!e.getVisible()){return}var r=e.getAccessibilityInfo();if(r){n._flatten(r,t,a+1)}});if(a==0){t.description=t._descriptions.join(" ").trim();t._descriptions=undefined}},_getFullDescription:function(e){var t=e.type+" "+e.description;if(e.enabled===false){t=t+" "+a.getResourceText("TBL_CTRL_STATE_DISABLED")}else if(e.editable===false){t=t+" "+a.getResourceText("TBL_CTRL_STATE_READONLY")}else if(e.required===true){t=t+" "+a.getResourceText("TBL_CTRL_STATE_REQUIRED")}return t.trim()}};var s={getColumnIndexOfFocusedCell:function(e){var t=e.getTable();var r=a.getFocusedItemInfo(t);return r.cellInRow-(a.hasRowHeader(t)?1:0)},getInfoOfFocusedCell:function(e){var t=e.getTable();var r=t._getItemNavigation();var i=t.getDomRef();if(!e.getAccMode()||!i||!r){return null}var o=r.getFocusedDomRef();if(!o||o!==document.activeElement){return null}return a.getCellInfo(o)},getRelevantColumnHeaders:function(e,t){var r=[];if(!e||!t||!e.getColumnHeaderVisible()){return r}var i=a.getHeaderRowCount(e);if(i>0){var o=t.getId();r.push(o);for(var l=1;l<i;l++){r.push(o+"_"+l)}var n=a.Column.getParentSpannedColumns(e,o);if(n&&n.length){for(var s=0;s<n.length;s++){var u=n[s].level;var c=n[s].column.getId();r[u]=u===0?c:c+"_"+u}}}return r},isHiddenCell:function(e,t){var r=a.Grouping.isInGroupHeaderRow(e);var i=a.Grouping.isInSummaryRow(e);var o=!!t&&!!t.hasStyleClass;var l=e.parent().hasClass("sapUiTableRowHidden");var n=e.hasClass("sapUiTableCellHidden");var s=r&&o&&t.hasStyleClass("sapUiAnalyticalTableGroupCellHidden");var u=i&&o&&t.hasStyleClass("sapUiAnalyticalTableSumCellHidden");return l||n||s||u},isTreeColumnCell:function(e,t){return a.Grouping.isInTreeMode(e.getTable())&&t.hasClass("sapUiTableCellFirst")},getColumnTooltip:function(e){if(!e){return null}var t=e.getLabel();function r(e){if(!e){return false}var a=t&&t.getText?t.getText():"";return e==a}var i=e.getTooltip_AsString();if(!r(i)){return i}if(a.isA(t,"sap.ui.core.Control")){i=t.getTooltip_AsString()}if(!r(i)){return i}return null},getGridSize:function(e){var t=a.hasRowHeader(e);var r=a.hasRowActions(e);var i=a.getVisibleColumnCount(e)+(t?1:0)+(r?1:0);var o=a.isNoDataVisible(e)?0:Math.max(e._getTotalRowCount(),e._getRowCounts()._fullsize);return{columnCount:i,rowCount:a.getHeaderRowCount(e)+o}},getRowIndex:function(e){return e.getIndex()+1+a.getHeaderRowCount(e.getTable())},updateRowColCount:function(e){var t=e.getTable(),r=t._getItemNavigation(),i=false,o=false,l=false,n=a.hasRowHeader(t);if(r){var u=s.getColumnIndexOfFocusedCell(e)+1+(n?1:0);var c=t.getRows()[a.getRowIndexOfFocusedCell(t)];var d=c?s.getRowIndex(c):0;var f=s.getGridSize(t);i=e._iLastRowNumber!=d||e._iLastRowNumber==d&&e._iLastColumnNumber==u;o=e._iLastColumnNumber!=u;l=e._iLastRowNumber==null&&e._iLastColumnNumber==null;t.$("rownumberofrows").text(i&&d>0?a.getResourceText("TBL_ROW_ROWCOUNT",[d,f.rowCount]):".");t.$("colnumberofcols").text(o?a.getResourceText("TBL_COL_COLCOUNT",[u,f.columnCount]):".");t.$("ariacount").text(l?a.getResourceText("TBL_DATA_ROWS_COLS",[f.rowCount,f.columnCount]):".");e._iLastRowNumber=d;e._iLastColumnNumber=u}return{rowChange:i,colChange:o,initial:l}},cleanupCellModifications:function(e){if(e._cleanupInfo){e._cleanupInfo.cell.attr(e._cleanupInfo.attr);e._cleanupInfo=null}},storeDefaultsBeforeCellModifications:function(e,t,a,r){e._cleanupInfo={cell:t,attr:{"aria-labelledby":a&&a.length?a.join(" "):null,"aria-describedby":r&&r.length?r.join(" "):null}}},performCellModifications:function(e,t,r,i,l,n,u,c){s.storeDefaultsBeforeCellModifications(e,t,r,i);var d=s.updateRowColCount(e);var f=e.getTable();f.$("cellacc").text(u||".");if(c){c(l,n,d.rowChange,d.colChange,d.initial)}var E="";if(d.initial){E=f.getId()+"-ariacount";if(f.getSelectionMode()!==o.None){E=E+" "+f.getId()+"-ariaselection"}}if(l&&l.length){E=E+" "+l.join(" ")}if(d.initial||d.rowChange){if(a.hasRowNavigationIndicators(f)){var T=a.getCellInfo(t);if(T.type!==a.CELLTYPE.COLUMNHEADER&&T.type!==a.CELLTYPE.COLUMNROWHEADER){var g=f.getRows()[T.rowIndex].getAggregation("_settings");if(g.getNavigated()){E=E+" "+f.getId()+"-rownavigatedtext"}}}}t.attr({"aria-labelledby":E?E:null,"aria-describedby":n&&n.length?n.join(" "):null})},modifyAccOfDATACELL:function(e){var t=this.getTable();var r=t.getId();var i=t._getItemNavigation();var o=e.cell;if(!i){return}var l=a.getRowIndexOfFocusedCell(t),c=s.getColumnIndexOfFocusedCell(this),d=a.getRowColCell(t,l,c,false),f=null,E=d.row,T=E.getId(),g=s.isHiddenCell(o,d.cell),p=s.isTreeColumnCell(this,o),b=s.getAriaAttributesFor(this,u.ELEMENTTYPES.DATACELL,{index:c,column:d.column,fixed:a.isFixedColumn(t,c)})["aria-labelledby"]||[],R=[],C=[r+"-rownumberofrows",r+"-colnumberofcols"],h=E.isGroupHeader(),A=E.isSummary();if(h){C.push(r+"-ariarowgrouplabel")}else if(E.isTotalSummary()){C.push(r+"-ariagrandtotallabel")}else if(E.isGroupSummary()){C.push(r+"-ariagrouptotallabel")}if(a.hasRowHighlights(t)&&!h&&!A){C.push(T+"-highlighttext")}C=C.concat(b);if(!g){f=n.getAccInfoOfControl(d.cell);C.push(f?r+"-cellacc":d.cell.getId());if(a.getInteractiveElements(o)!==null){C.push(r+"-toggleedit")}}var v=f?f.description:".";if(p&&!g){var w=s.getAriaAttributesFor(this,u.ELEMENTTYPES.TREEICON,{row:d.row});if(w&&w["aria-label"]){v=w["aria-label"]+" "+v}}s.performCellModifications(this,o,b,null,C,R,v,function(e,r,i,l){if(h&&i){e.splice(3,0,T+"-groupHeader")}var n=o.find(".sapUiTableTreeIcon").not(".sapUiTableTreeIconLeaf").length==1;if((n||h)&&(i||l)){r.push(t.getId()+(!E.isExpanded()?"-rowexpandtext":"-rowcollapsetext"))}else if(!g&&!h&&!A&&a.isRowSelectionAllowed(t)&&i){e.push(T+"-rowselecttext")}})},modifyAccOfROWHEADER:function(e){var t=this.getTable();var r=t.getId();var i=e.cell;var o=t.getRows()[e.rowIndex];var l=o.getId();var n=s.getAriaAttributesFor(this,u.ELEMENTTYPES.ROWHEADER)["aria-labelledby"]||[];var c=n.concat([r+"-rownumberofrows",r+"-colnumberofcols"]);if(!o.isSummary()&&!o.isGroupHeader()&&!o.isContentHidden()){c.push(l+"-rowselecttext");if(a.hasRowHighlights(t)){c.push(l+"-highlighttext")}}if(o.isGroupHeader()){c.push(r+"-ariarowgrouplabel");c.push(l+"-groupHeader");c.push(r+(o.isExpanded()?"-rowcollapsetext":"-rowexpandtext"))}if(o.isTotalSummary()){c.push(r+"-ariagrandtotallabel")}else if(o.isGroupSummary()){c.push(r+"-ariagrouptotallabel")}s.performCellModifications(this,i,n,null,c,null,null)},modifyAccOfCOLUMNHEADER:function(e){var t=this.getTable();var r=e.cell;var i=sap.ui.getCore().byId(r.attr("data-sap-ui-colid"));var o=a.Column.getHeaderLabel(i);var l=s.getAriaAttributesFor(this,u.ELEMENTTYPES.COLUMNHEADER,{headerId:r.attr("id"),column:i,index:r.attr("data-sap-ui-colindex")});var n=s.getColumnTooltip(i);var c=[t.getId()+"-colnumberofcols"].concat(l["aria-labelledby"]);var d=e.columnSpan;if(o?.getRequired?.()){c.push(t.getId()+"-ariarequired")}if(d>1){c.push(t.getId()+"-ariacolspan");t.$("ariacolspan").text(a.getResourceText("TBL_COL_DESC_SPAN",[""+d]))}if(n){c.push(t.getId()+"-cellacc")}if(d<=1&&i&&i.getFiltered()){c.push(t.getId()+"-ariacolfiltered")}s.performCellModifications(this,r,l["aria-labelledby"],l["aria-describedby"],c,l["aria-describedby"],n)},modifyAccOfCOLUMNROWHEADER:function(e){var t=this.getTable();var a=e.cell;var r=a.hasClass("sapUiTableSelAllVisible");var i=s.getAriaAttributesFor(this,u.ELEMENTTYPES.COLUMNROWHEADER,{enabled:r,checked:r&&!t.$().hasClass("sapUiTableSelAll")});var o=[t.getId()+"-colnumberofcols"].concat(i["aria-labelledby"]);s.performCellModifications(this,a,i["aria-labelledby"],i["aria-describedby"],o,i["aria-describedby"],null)},modifyAccOfROWACTION:function(e){var t=this.getTable();var r=t.getId();var i=e.cell;var o=t.getRows()[e.rowIndex];var l=o.getId();var n=s.isHiddenCell(i);var c=s.getAriaAttributesFor(this,u.ELEMENTTYPES.ROWACTION)["aria-labelledby"]||[];var d=[r+"-rownumberofrows",r+"-colnumberofcols"].concat(c);var f=[];var E=o.isGroupHeader();if(E){d.push(r+"-ariarowgrouplabel");d.push(r+(o.isExpanded()?"-rowcollapsetext":"-rowexpandtext"))}if(o.isTotalSummary()){d.push(r+"-ariagrandtotallabel")}else if(o.isGroupSummary()){d.push(r+"-ariagrouptotallabel")}if(a.hasRowHighlights(t)&&!o.isGroupHeader()&&!o.isSummary()){d.push(l+"-highlighttext")}var T="";if(!n){var g=o.getRowAction();if(g){var p=g.getAccessibilityInfo();if(p){d.push(r+"-cellacc");T=p.description;if(a.getInteractiveElements(i)!==null){f.push(r+"-toggleedit")}}}}s.performCellModifications(this,i,c,[],d,f,T,function(e,t,a){if(E&&a){var i=e.indexOf(r+"-ariarowgrouplabel")+1;e.splice(i,0,l+"-groupHeader")}})},getAriaAttributesFor:function(e,t,r){var i={},l=e.getTable(),n=l.getId();function c(e,t,r,o){var l="";if(r&&o){l="overlay,nodata"}else if(r&&!o){l="overlay"}else if(!r&&o){l="nodata"}var n=false;if(r&&e.getShowOverlay()||o&&a.isNoDataVisible(e)){n=true}if(n){i["aria-hidden"]="true"}if(l){i["data-sap-ui-table-acc-covered"]=l}}switch(t){case u.ELEMENTTYPES.COLUMNROWHEADER:var d=l._getSelectionPlugin().getRenderConfig();if(d.headerSelector.visible){if(d.headerSelector.type==="toggle"){i["role"]=["checkbox"];if(r&&r.enabled){i["aria-checked"]=r.checked?"true":"false"}}else if(d.headerSelector.type==="clear"){i["role"]=["button"];if(!r||!r.enabled){i["aria-disabled"]="true"}}}break;case u.ELEMENTTYPES.ROWHEADER:i["role"]="gridcell";i["aria-colindex"]=1;if(a.hasRowHeader(l)&&l.getSelectionMode()===o.None){i["aria-labelledby"]=[n+"-rowselecthdr"]}break;case u.ELEMENTTYPES.ROWACTION:i["role"]="gridcell";i["aria-colindex"]=a.getVisibleColumnCount(l)+1+(a.hasRowHeader(l)?1:0);i["aria-labelledby"]=[n+"-rowacthdr"];break;case u.ELEMENTTYPES.COLUMNHEADER:var f=r&&r.column;var E=r&&r.colspan;i["role"]="columnheader";i["aria-colindex"]=r.index+1+(a.hasRowHeader(l)?1:0);var T=[];if(r&&r.headerId){var g=s.getRelevantColumnHeaders(l,f);var p=g.indexOf(r.headerId);T=p>0?g.slice(0,p+1):[r.headerId]}for(var b=0;b<T.length;b++){T[b]=T[b]+"-inner"}i["aria-labelledby"]=T;if(r&&r.index<l.getComputedFixedColumnCount()){i["aria-labelledby"].push(n+"-ariafixedcolumn")}if(!E&&f){i["aria-sort"]=f.getSortOrder().toLowerCase();if(!f.getSorted()){delete i["aria-sort"]}}if(!E&&f){var R=f.getHeaderMenuInstance();if(R){var C=R.getAriaHasPopupType();if(C!=="None"){i["aria-haspopup"]=C.toLowerCase()}}if(!R&&f._menuHasItems()){i["aria-haspopup"]="menu"}}break;case u.ELEMENTTYPES.DATACELL:i["role"]="gridcell";i["aria-colindex"]=r.index+1+(a.hasRowHeader(l)?1:0);if(r.column){var T=s.getRelevantColumnHeaders(l,r.column);for(var b=0;b<T.length;b++){T[b]=T[b]+"-inner"}if(r&&r.fixed){T.push(n+"-ariafixedcolumn")}i["aria-labelledby"]=T}break;case u.ELEMENTTYPES.ROOT:break;case u.ELEMENTTYPES.TABLE:i["role"]="presentation";c(l,i,true,true);break;case u.ELEMENTTYPES.CONTAINER:break;case u.ELEMENTTYPES.CONTENT:i["role"]=a.Grouping.isInGroupMode(l)||a.Grouping.isInTreeMode(l)?"treegrid":"grid";i["aria-labelledby"]=[].concat(l.getAriaLabelledBy());if(l.getTitle()){i["aria-labelledby"].push(l.getTitle().getId())}if(l.getSelectionMode()===o.MultiToggle){i["aria-multiselectable"]="true"}var h=l._getRowCounts();var A=a.hasFixedColumns(l);var v=h.fixedTop>0;var w=h.fixedBottom>0;var L=a.hasRowHeader(l);var m=a.hasRowActions(l);var O=s.getGridSize(l);i["aria-owns"]=[n+"-table"];if(A){i["aria-owns"].push(n+"-table-fixed")}if(v){i["aria-owns"].push(n+"-table-fixrow");if(A){i["aria-owns"].push(n+"-table-fixed-fixrow")}}if(w){i["aria-owns"].push(n+"-table-fixrow-bottom");if(A){i["aria-owns"].push(n+"-table-fixed-fixrow-bottom")}}if(L){i["aria-owns"].push(n+"-sapUiTableRowHdrScr")}if(m){i["aria-owns"].push(n+"-sapUiTableRowActionScr")}i["aria-rowcount"]=O.rowCount;i["aria-colcount"]=O.columnCount;if(l.isA("sap.ui.table.AnalyticalTable")){i["aria-roledescription"]=a.getResourceText("TBL_ANALYTICAL_TABLE_ROLE_DESCRIPTION")}break;case u.ELEMENTTYPES.TABLEHEADER:i["role"]="heading";i["aria-level"]="2";c(l,i,true,false);break;case u.ELEMENTTYPES.COLUMNHEADER_TBL:i["role"]="presentation";break;case u.ELEMENTTYPES.COLUMNHEADER_ROW:i["role"]="row";c(l,i,true,false);break;case u.ELEMENTTYPES.CREATIONROW_TBL:i["role"]="presentation";break;case u.ELEMENTTYPES.CREATIONROW:i["role"]="form";i["aria-labelledby"]=r.creationRow.getId()+"-label";c(l,i,true,false);break;case u.ELEMENTTYPES.ROWHEADER_COL:c(l,i,true,true);break;case u.ELEMENTTYPES.TH:i["role"]="presentation";i["scope"]="col";i["aria-hidden"]="true";break;case u.ELEMENTTYPES.TR:i["role"]="row";if(r.rowNavigated){i["aria-current"]=true}if(!r.fixedCol){i["aria-owns"]=[];if(a.hasRowHeader(l)){i["aria-owns"].push(n+"-rowsel"+r.index)}if(a.hasFixedColumns(l)){for(var _=0;_<l.getComputedFixedColumnCount();_++){i["aria-owns"].push(n+"-rows-row"+r.index+"-col"+_)}}if(a.hasRowActions(l)){i["aria-owns"].push(n+"-rowact"+r.index)}}break;case u.ELEMENTTYPES.TREEICON:if(a.Grouping.isInTreeMode(l)){i={"aria-label":"",title:"",role:""};if(l.getBinding()){if(r&&r.row){if(r.row.isExpandable()){var S=a.getResourceText("TBL_COLLAPSE_EXPAND");i["title"]=S;i["aria-expanded"]=""+!!r.row.isExpanded();i["aria-hidden"]="false";i["role"]="button"}else{i["aria-label"]=a.getResourceText("TBL_LEAF");i["aria-hidden"]="true"}}}}break;case u.ELEMENTTYPES.NODATA:var N=a.getNoContentMessage(l);var T=[];i["role"]="gridcell";if(a.isA(N,"sap.ui.core.Control")){if(N.getAccessibilityReferences instanceof Function){var y=N.getAccessibilityReferences();T.push(y.title);T.push(y.description)}else{T.push(N.getId())}}else{T.push(n+"-noDataMsg")}i["aria-labelledby"]=T;c(l,i,true,false);break;case u.ELEMENTTYPES.OVERLAY:i["role"]="region";i["aria-labelledby"]=[].concat(l.getAriaLabelledBy());if(l.getTitle()){i["aria-labelledby"].push(l.getTitle().getId())}i["aria-labelledby"].push(n+"-ariainvalid");break;case u.ELEMENTTYPES.TABLEFOOTER:case u.ELEMENTTYPES.TABLESUBHEADER:c(l,i,true,false);break;case u.ELEMENTTYPES.ROWACTIONHEADER:i["aria-hidden"]="true";break;case"PRESENTATION":i["role"]="presentation";break}return i}};var u=e.extend("sap.ui.table.extensions.Accessibility",{_init:function(r,o,l){this._accMode=i.getAccessibility();this._busyCells=[];a.addDelegate(r,this);e.enrich(r,t);return"AccExtension"},_attachEvents:function(){a.Hook.register(this.getTable(),a.Hook.Keys.Table.TotalRowCountChanged,this._updateAriaRowCount,this)},_detachEvents:function(){a.Hook.deregister(this.getTable(),a.Hook.Keys.Table.TotalRowCountChanged,this._updateAriaRowCount,this)},_debug:function(){this._ExtensionHelper=s;this._ACCInfoHelper=n},destroy:function(){this.getTable().removeEventDelegate(this);this._busyCells=[];e.prototype.destroy.apply(this,arguments)},getAriaAttributesFor:function(e,t){return s.getAriaAttributesFor(this,e,t)},onfocusin:function(e){var t=this.getTable();if(!t||a.getCellInfo(e.target).cell==null){return}if(t._mTimeouts._cleanupACCExtension){clearTimeout(t._mTimeouts._cleanupACCExtension);t._mTimeouts._cleanupACCExtension=null}this.updateAccForCurrentCell("Focus")},onfocusout:function(e){var t=this.getTable();if(!t){return}t._mTimeouts._cleanupACCExtension=setTimeout(function(){var e=this.getTable();if(!e){return}this._iLastRowNumber=null;this._iLastColumnNumber=null;s.cleanupCellModifications(this);e._mTimeouts._cleanupACCExtension=null}.bind(this),100)}});u.ELEMENTTYPES={DATACELL:"DATACELL",COLUMNHEADER:"COLUMNHEADER",ROWHEADER:"ROWHEADER",ROWACTION:"ROWACTION",COLUMNROWHEADER:"COLUMNROWHEADER",ROOT:"ROOT",CONTAINER:"CONTAINER",CONTENT:"CONTENT",TABLE:"TABLE",TABLEHEADER:"TABLEHEADER",TABLEFOOTER:"TABLEFOOTER",TABLESUBHEADER:"TABLESUBHEADER",COLUMNHEADER_TBL:"COLUMNHEADER_TABLE",COLUMNHEADER_ROW:"COLUMNHEADER_ROW",CREATIONROW_TBL:"CREATIONROW_TABLE",CREATIONROW:"CREATIONROW",ROWHEADER_COL:"ROWHEADER_COL",TH:"TH",TR:"TR",TREEICON:"TREEICON",ROWACTIONHEADER:"ROWACTIONHEADER",NODATA:"NODATA",OVERLAY:"OVERLAY"};u.prototype.getAccMode=function(){return this._accMode};u.prototype._updateAriaRowIndices=function(){if(!this._accMode){return}var e=this.getTable();var t=e.getRows();var a,r,i;for(r=0;r<t.length;r++){a=t[r];i=a.getDomRefs(true);i.row.not(i.rowHeaderPart).not(i.rowActionPart).attr("aria-rowindex",s.getRowIndex(a))}};u.prototype._updateAriaRowCount=function(){var e=this.getTable();var t=e.$("sapUiTableGridCnt");if(t){t.attr("aria-rowcount",s.getGridSize(e).rowCount)}};u.prototype.updateAccForCurrentCell=function(e){if(!this._accMode||!this.getTable()._getItemNavigation()){return}if(e==="Focus"||e===a.RowsUpdateReason.Expand||e===a.RowsUpdateReason.Collapse){s.cleanupCellModifications(this)}var t=s.getInfoOfFocusedCell(this);var r;if(!t||!t.isOfType(l.ANY)){return}if(t.isOfType(l.DATACELL)){r=u.ELEMENTTYPES.DATACELL}else if(t.isOfType(l.COLUMNHEADER)){r=u.ELEMENTTYPES.COLUMNHEADER}else if(t.isOfType(l.ROWHEADER)){r=u.ELEMENTTYPES.ROWHEADER}else if(t.isOfType(l.ROWACTION)){r=u.ELEMENTTYPES.ROWACTION}else if(t.isOfType(l.COLUMNROWHEADER)){r=u.ELEMENTTYPES.COLUMNROWHEADER}if(!s["modifyAccOf"+r]){return}if(e!=="Focus"&&e!==a.RowsUpdateReason.Expand&&e!==a.RowsUpdateReason.Collapse){if(t.isOfType(l.ANYCONTENTCELL)){t.cell.attr("role","status");t.cell.attr("role","gridcell")}else{return}}s["modifyAccOf"+r].apply(this,[t])};u.prototype.updateRowTooltips=function(e,t,r){if(!this._accMode){return}var i=this.getTable();var o=!e.isEmpty()&&!e.isGroupHeader()&&!e.isSummary()&&!i._getHideStandardTooltips();if(t.row){if(o&&a.isRowSelectionAllowed(i)&&!t.row.hasClass("sapUiTableRowHidden")){t.row.attr("title",r)}else{t.row.removeAttr("title")}}if(t.rowSelector){if(o&&a.isRowSelectorSelectionAllowed(i)){t.rowSelector.attr("title",r)}else{t.rowSelector.removeAttr("title")}}if(t.rowScrollPart){var l=t.rowScrollPart.add(t.rowFixedPart).add(t.rowActionPart);if(o&&a.isRowSelectionAllowed(i)){l.attr("title",r)}else{l.removeAttr("title")}}};u.prototype.updateSelectionStateOfRow=function(e){if(!this._accMode){return}var t=e.getDomRefs(true);var a="";var r="";if(!e.isEmpty()&&!e.isGroupHeader()&&!e.isSummary()){var i=this.getAriaTextsForSelectionMode(true);var o=this.getTable();var l=o._getSelectionPlugin().isSelected(e);if(t.row){t.row.not(t.rowHeaderPart).not(t.rowActionPart).add(t.row.children(".sapUiTableCell")).attr("aria-selected",l?"true":"false")}if(!l){a=i.keyboard["rowSelect"];r=i.mouse["rowSelect"]}else{a=i.keyboard["rowDeselect"];r=i.mouse["rowDeselect"]}}if(t.rowSelectorText){t.rowSelectorText.text(a)}this.updateRowTooltips(e,t,r)};u.prototype.updateAriaExpandAndLevelState=function(e){if(!this._accMode){return}var t=e.getDomRefs(true);var a=t.row.find(".sapUiTableTreeIcon");if(t.rowHeaderPart){t.rowHeaderPart.attr({"aria-haspopup":e.isGroupHeader()?"menu":null})}t.row.not(t.rowHeaderPart).not(t.rowActionPart).attr({"aria-expanded":e.isExpandable()?e.isExpanded()+"":null,"aria-level":e.getLevel()});if(a){a.attr(s.getAriaAttributesFor(this,u.ELEMENTTYPES.TREEICON,{row:e}))}};u.prototype.updateAriaStateOfRowHighlight=function(e){if(!this._accMode||!e){return}var t=e._getRow();var a=t?t.getDomRef("highlighttext"):null;if(a){a.innerText=e._getHighlightText()}};u.prototype._updateAriaStateOfNavigatedRow=function(e){if(!this._accMode||!e){return}var t=e._getRow();var a=e.getNavigated();t.getDomRefs(true).row.attr("aria-current",a?true:null)};u.prototype.updateAriaStateForOverlayAndNoData=function(){var e=this.getTable();if(!e||!e.getDomRef()||!this._accMode){return}if(e.getShowOverlay()){e.$().find("[data-sap-ui-table-acc-covered*='overlay']").attr("aria-hidden","true")}else{e.$().find("[data-sap-ui-table-acc-covered*='overlay']").removeAttr("aria-hidden");if(a.isNoDataVisible(e)){e.$().find("[data-sap-ui-table-acc-covered*='nodata']").attr("aria-hidden","true")}else{e.$().find("[data-sap-ui-table-acc-covered*='nodata']").removeAttr("aria-hidden")}}};u.prototype.getAriaTextsForSelectionMode=function(e,t){var r=this.getTable();if(!t){t=r.getSelectionMode()}var i=!r._getHideStandardTooltips();var l={mouse:{rowSelect:"",rowDeselect:""},keyboard:{rowSelect:"",rowDeselect:""}};var n=r._getSelectionPlugin().getSelectedCount();if(t===o.Single){l.mouse.rowSelect=i?a.getResourceText("TBL_ROW_SELECT"):"";l.mouse.rowDeselect=i?a.getResourceText("TBL_ROW_DESELECT"):"";l.keyboard.rowSelect=a.getResourceText("TBL_ROW_SELECT_KEY");l.keyboard.rowDeselect=a.getResourceText("TBL_ROW_DESELECT_KEY")}else if(t===o.MultiToggle){l.mouse.rowSelect=i?a.getResourceText("TBL_ROW_SELECT_MULTI_TOGGLE"):"";l.mouse.rowDeselect=i?a.getResourceText("TBL_ROW_DESELECT"):"";l.keyboard.rowSelect=a.getResourceText("TBL_ROW_SELECT_KEY");l.keyboard.rowDeselect=a.getResourceText("TBL_ROW_DESELECT_KEY");if(e===true&&n===0){l.mouse.rowSelect=i?a.getResourceText("TBL_ROW_SELECT"):""}}return l};u.prototype.setSelectAllState=function(e){var t=this.getTable();if(this._accMode&&t){t.$("selall").attr("aria-checked",e?"true":"false")}};u.prototype.addColumnHeaderLabel=function(e,t){var a=this.getTable();if(!this._accMode||!t.getAriaLabelledBy||!a){return}var r=a.getColumnHeaderVisible()?e.getId():null;if(!r){var i=e.getAggregation("label");if(i){r=i.getId()}}var o=t.getAriaLabelledBy();if(r&&o.indexOf(r)<0){t.addAriaLabelledBy(r)}};return u});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/extensions/AccessibilityRender", ["./ExtensionBase","../utils/TableUtils","../library"],function(e,t,r){"use strict";var i=r.SelectionMode;var o=function(e,t,r,i,o){o=o||[];o.push("sapUiInvisibleText");e.openStart("span",t+"-"+r);o.forEach(function(t){e.class(t)});e.attr("aria-hidden","true");e.openEnd();if(i){e.text(i)}else{e.text(".")}e.close("span")};var a=e.extend("sap.ui.table.extensions.AccessibilityRender",{_init:function(e,t,r){return"AccRenderExtension"},writeHiddenAccTexts:function(e,r){if(!r._getAccExtension().getAccMode()){return}var a=r.getId();e.openStart("div");e.class("sapUiTableHiddenTexts");e.style("display","none");e.attr("aria-hidden","true");e.openEnd();o(e,a,"ariacount");o(e,a,"toggleedit",t.getResourceText("TBL_TOGGLE_EDIT_KEY"));o(e,a,"ariarowgrouplabel",t.getResourceText("TBL_ROW_GROUP_LABEL"));o(e,a,"ariagrandtotallabel",t.getResourceText("TBL_GRAND_TOTAL_ROW"));o(e,a,"ariagrouptotallabel",t.getResourceText("TBL_GROUP_TOTAL_ROW"));o(e,a,"rownumberofrows");o(e,a,"colnumberofcols");o(e,a,"cellacc");o(e,a,"ariacolmenu",t.getResourceText("TBL_COL_DESC_MENU"));o(e,a,"ariacolspan");o(e,a,"ariacolfiltered",t.getResourceText("TBL_COL_DESC_FILTERED"));o(e,a,"ariacolsortedasc",t.getResourceText("TBL_COL_DESC_SORTED_ASC"));o(e,a,"ariacolsorteddes",t.getResourceText("TBL_COL_DESC_SORTED_DES"));o(e,a,"ariainvalid",t.getResourceText("TBL_TABLE_INVALID"));o(e,a,"ariashowcolmenu",t.getResourceText("TBL_COL_VISBILITY_MENUITEM_SHOW"));o(e,a,"ariahidecolmenu",t.getResourceText("TBL_COL_VISBILITY_MENUITEM_HIDE"));o(e,a,"rowexpandtext",t.getResourceText("TBL_ROW_EXPAND_KEY"));o(e,a,"rowcollapsetext",t.getResourceText("TBL_ROW_COLLAPSE_KEY"));o(e,a,"ariarequired",t.getResourceText("TBL_COL_REQUIRED"));var c=r.getSelectionMode();if(c!==i.None){o(e,a,"ariaselection",t.getResourceText(c==i.MultiToggle?"TBL_TABLE_SELECTION_MULTI":"TBL_TABLE_SELECTION_SINGLE"))}if(r.getComputedFixedColumnCount()>0){o(e,a,"ariafixedcolumn",t.getResourceText("TBL_FIXED_COLUMN"))}if(t.hasRowNavigationIndicators(r)){o(e,a,"rownavigatedtext",t.getResourceText("TBL_ROW_STATE_NAVIGATED"))}e.close("div")},writeAriaAttributesFor:function(e,t,r,i){var o=t._getAccExtension();if(!o.getAccMode()){return}var a=o.getAriaAttributesFor(r,i);var c,n;for(n in a){c=a[n];if(Array.isArray(c)){c=c.join(" ")}if(c){e.attr(n.toLowerCase(),c)}}},writeAccRowSelectorText:function(e,t,r){if(!t._getAccExtension().getAccMode()){return}var i=t._getSelectionPlugin().isSelected(r);var a=t._getAccExtension().getAriaTextsForSelectionMode(true);var c=a.keyboard[i?"rowDeselect":"rowSelect"];if(!r.isGroupHeader()&&!r.isSummary()){o(e,r.getId(),"rowselecttext",r.isEmpty()?"":c,["sapUiTableAriaRowSel"])}},writeAccRowHighlightText:function(e,t,r,i){if(!t._getAccExtension().getAccMode()){return}var a=r.getAggregation("_settings");var c=a._getHighlightText();o(e,r.getId(),"highlighttext",c)},writeAccCreationRowText:function(e,r,i){if(!r._getAccExtension().getAccMode()){return}o(e,i.getId(),"label",t.getResourceText("TBL_CREATEROW_LABEL"))}});return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/extensions/DragAndDrop", ["./ExtensionBase","../utils/TableUtils","sap/ui/core/library"],function(t,e,o){"use strict";var r="sap.ui.table";var a=o.dnd.DropPosition;var i={getSessionData:function(t,e){return t.getComplexData(r+(e==null?"":"-"+e))},setSessionData:function(t,e,o){t.setComplexData(r+(o==null?"":"-"+o),e)},getInstanceSessionData:function(t,e){return this.getSessionData(t,e.getId())},setInstanceSessionData:function(t,e,o){this.setSessionData(t,o,e.getId())},scrollVertically:e.throttle(function(t,e,o,r){var a=t._getScrollExtension().getVerticalScrollbar();a.scrollTop+=this.calculateScrollDistance(o,r)*(e?1:-1)},50),scrollHorizontally:e.throttle(function(t,e,o,r){var a=t._getScrollExtension().getHorizontalScrollbar();a.scrollLeft+=this.calculateScrollDistance(o,r)*(e?1:-1)},50),calculateScrollDistance:function(t,e){var o=2;var r=50;var a=e/t;return Math.max(o,Math.round(r*a))}};var l={ondragstart:function(t){var e=t.dragSession;if(!e||!e.getDragControl()){return}var o=e.getDragControl();var r={};if(o.isA("sap.ui.table.Row")){if(o.isEmpty()||o.isGroupHeader()||o.isSummary()){t.preventDefault();return}else{r.draggedRowContext=o.getRowBindingContext()}}i.setInstanceSessionData(e,this,r)},ondragenter:function(t){var o=t.dragSession;if(!o||!o.getDropControl()){return}var r=i.getInstanceSessionData(o,this);var l=o.getDragControl();var n=o.getDropControl();if(!r){r={}}if(n.isA("sap.ui.table.Row")){var s=r.draggedRowContext;var g=n.getRowBindingContext();var c=o.getDropInfo().getDropPosition();if(n.isEmpty()&&c===a.On&&e.hasData(this)||s&&s===g||n.isGroupHeader()||n.isSummary()){t.setMarked("NonDroppable")}else{if(!g){var f=this.getRows()[e.getNonEmptyRowCount(this)-1];o.setDropControl(f||this)}if(o.getDropControl()!==this){var u=this.getDomRef().classList.contains("sapUiTableVScr");var h=this.getDomRef("sapUiTableCnt").getBoundingClientRect();o.setIndicatorConfig({width:h.width-(u?16:0),left:h.left+(this._bRtlMode&&u?16:0)})}}}else if(n.isA("sap.ui.table.Column")){var v=e.getCellInfo(e.getCell(this,t.target)).columnIndex;if(l.isA("sap.ui.table.Column")&&!e.Column.isColumnMovableTo(l,v,true)){t.setMarked("NonDroppable");return}var h=this.getDomRef("sapUiTableCnt").getBoundingClientRect();o.setIndicatorConfig({height:h.height-(this._getScrollExtension().isHorizontalScrollbarVisible()?16:0)})}else if(l===n){t.setMarked("NonDroppable")}if(!r.verticalScrollEdge){var d=window.pageYOffset;var p=this.getDomRef("table").getBoundingClientRect();r.verticalScrollEdge={bottom:p.bottom+d,top:p.top+d}}var D=window.pageXOffset;var S=this.getDomRef("sapUiTableCtrlScr").getBoundingClientRect();r.horizontalScrollEdge={left:S.left+D,right:S.right+D};i.setInstanceSessionData(o,this,r)},ondragover:function(t){var e=t.dragSession;if(!e){return}var o=i.getInstanceSessionData(e,this);if(!o){return}var r=50;var a=e.getDropControl();var l=this._getScrollExtension();var n=l.getVerticalScrollbar();var s=l.getHorizontalScrollbar();var g=o.verticalScrollEdge;var c=o.horizontalScrollEdge;if(g&&n&&a!==this){var f=t.pageY;if(f>=g.top-r&&f<=g.top+r){i.scrollVertically(this,false,r*2,g.top+r-f)}else if(f<=g.bottom+r&&f>=g.bottom-r){i.scrollVertically(this,true,r*2,f-g.bottom+r)}}if(c&&s&&a!==this){var u=t.pageX;if(u>=c.left-r&&u<=c.left+r){i.scrollHorizontally(this,false,r*2,c.left+r-u)}else if(u<=c.right+r&&u>=c.right-r){i.scrollHorizontally(this,true,r*2,u-c.right+r)}}},onlongdragover:function(t){var o=t.dragSession;if(!o){return}var r=e.getCell(this,t.target);var a=e.getCellInfo(r).rowIndex;var i=a==null?null:this.getRows()[a];var l=o.getDropControl();if(i&&(l===i||!l)){i.expand()}},ondragend:function(t){i.scrollVertically.cancel();i.scrollHorizontally.cancel()}};var n=t.extend("sap.ui.table.extensions.DragAndDrop",{_init:function(t,o,r){this._oDelegate=l;e.addDelegate(t,this._oDelegate,t);return"DragAndDropExtension"},_debug:function(){this._ExtensionDelegate=l},destroy:function(){var e=this.getTable();if(e){e.removeEventDelegate(this._oDelegate)}i.scrollVertically.cancel();i.scrollHorizontally.cancel();this._oDelegate=null;t.prototype.destroy.apply(this,arguments)}});return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/extensions/ExtensionBase", ["sap/ui/base/Object"],function(t){"use strict";var e=t.extend("sap.ui.table.extensions.ExtensionBase",{_table:null,_type:null,_settings:null,constructor:function(n,s){t.call(this);this._table=n;this._settings=s||{};this._type=e.TABLETYPES.STANDARD;if(n.isA("sap.ui.table.TreeTable")){this._type=e.TABLETYPES.TREE}else if(n.isA("sap.ui.table.AnalyticalTable")){this._type=e.TABLETYPES.ANALYTICAL}var i=this._init(this._table,this._type,this._settings);if(i){var a=this;n["_get"+i]=function(){return a}}},destroy:function(){this._table=null;this._type=null;this.bIsDestroyed=true;t.prototype.destroy.apply(this,arguments)},getInterface:function(){return this}});e.TABLETYPES={TREE:"TREE",ANALYTICAL:"ANALYTICAL",STANDARD:"STANDARD"};e.prototype.getTable=function(){return this._table};e.prototype._init=function(t,e,n){return null};e.prototype._attachEvents=function(){};e.prototype._detachEvents=function(){};e.attachEvents=function(t){if(!t._aExtensions){return}for(var e=0;e<t._aExtensions.length;e++){t._aExtensions[e]._attachEvents()}};e.detachEvents=function(t){if(!t._aExtensions){return}for(var e=0;e<t._aExtensions.length;e++){t._aExtensions[e]._detachEvents()}};e.enrich=function(t,n,s){if(!n||!(n.prototype instanceof e)){return null}var i=new n(t,s);if(!t._aExtensions){t._aExtensions=[]}t._aExtensions.push(i);return i};e.cleanup=function(t){if(!t._bExtensionsInitialized||!t._aExtensions){return}for(var e=0;e<t._aExtensions.length;e++){t._aExtensions[e].destroy()}delete t._aExtensions;delete t._bExtensionsInitialized};e.isEnrichedWith=function(t,e){if(!t||!t._aExtensions){return false}for(var n=0;n<t._aExtensions.length;n++){if(t._aExtensions[n].getMetadata().getName()===e){return true}}return false};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/extensions/Keyboard", ["./ExtensionBase","./KeyboardDelegate","../utils/TableUtils","sap/ui/core/delegate/ItemNavigation","sap/ui/Device","sap/ui/dom/containsOrEquals","sap/ui/thirdparty/jquery"],function(e,t,i,o,a,n,jQuery){"use strict";var s={_forward:function(e,t){var i=e._getItemNavigation();if(i!=null&&!e._getKeyboardExtension().isItemNavigationSuspended()&&!t.isMarked("sapUiTableSkipItemNavigation")){i["on"+t.type](t)}},onfocusin:function(e){s._forward(this,e)},onsapfocusleave:function(e){s._forward(this,e)},onmousedown:function(e){s._forward(this,e)},onsapnext:function(e){s._forward(this,e)},onsapnextmodifiers:function(e){s._forward(this,e)},onsapprevious:function(e){s._forward(this,e)},onsappreviousmodifiers:function(e){s._forward(this,e)},onsappageup:function(e){s._forward(this,e)},onsappagedown:function(e){s._forward(this,e)},onsaphome:function(e){s._forward(this,e)},onsaphomemodifiers:function(e){s._forward(this,e)},onsapend:function(e){s._forward(this,e)},onsapendmodifiers:function(e){s._forward(this,e)},onsapkeyup:function(e){s._forward(this,e)}};var l={onBeforeRendering:function(e){this._oStoredFocusInfo=this.getFocusInfo()},onAfterRendering:function(e){var t=e&&e.isMarked("renderRows");this._getKeyboardExtension().invalidateItemNavigation();if(this._oStoredFocusInfo&&this._oStoredFocusInfo.customId){if(t){this.applyFocusInfo(this._oStoredFocusInfo)}else{r.initItemNavigation(this._getKeyboardExtension(),true)}}delete this._oStoredFocusInfo},onfocusin:function(e){var t=this._getKeyboardExtension();if(!t._bIgnoreFocusIn){r.initItemNavigation(this._getKeyboardExtension())}else{e.setMarked("sapUiTableIgnoreFocusIn")}if(e.target&&e.target.id===this.getId()+"-rsz"){e.preventDefault();e.setMarked("sapUiTableSkipItemNavigation")}}};var r={initItemNavigation:function(e,t){if(r.isItemNavigationInvalid(e)){r._initItemNavigation(e,t)}},_initItemNavigation:function(e,t){var a=e.getTable();if(!a){return}var n=a.$();var s=a.getRows().length;var l=i.getVisibleColumnCount(a);var f=i.hasRowHeader(a);var d=i.hasRowActions(a);var u=i.hasFixedColumns(a);var c;var g=[],p,v,h,m,_;if(u){h=n.find(".sapUiTableCtrlFixed.sapUiTableCtrlRowFixed:not(.sapUiTableCHT)");m=n.find(".sapUiTableCtrlFixed.sapUiTableCtrlRowScroll:not(.sapUiTableCHT)");_=n.find(".sapUiTableCtrlFixed.sapUiTableCtrlRowFixedBottom:not(.sapUiTableCHT)")}var b=n.find(".sapUiTableCtrlScroll.sapUiTableCtrlRowFixed:not(.sapUiTableCHT)");var I=n.find(".sapUiTableCtrlScroll.sapUiTableCtrlRowScroll:not(.sapUiTableCHT)");var C=n.find(".sapUiTableCtrlScroll.sapUiTableCtrlRowFixedBottom:not(.sapUiTableCHT)");if(f){p=n.find(".sapUiTableRowSelectionCell").get();l++}if(d){v=n.find(".sapUiTableRowActionCell").get();l++}for(c=0;c<s;c++){if(f){g.push(p[c])}if(u){g=g.concat(h.find('tr[data-sap-ui-rowindex="'+c+'"]').find("td[tabindex]").get())}g=g.concat(b.find('tr[data-sap-ui-rowindex="'+c+'"]').find("td[tabindex]").get());if(u){g=g.concat(m.find('tr[data-sap-ui-rowindex="'+c+'"]').find("td[tabindex]").get())}g=g.concat(I.find('tr[data-sap-ui-rowindex="'+c+'"]').find("td[tabindex]").get());if(u){g=g.concat(_.find('tr[data-sap-ui-rowindex="'+c+'"]').find("td[tabindex]").get())}g=g.concat(C.find('tr[data-sap-ui-rowindex="'+c+'"]').find("td[tabindex]").get());if(d){g.push(v[c])}}if(a.getColumnHeaderVisible()){var R=[];var T=n.find(".sapUiTableCHT.sapUiTableCtrlFixed>tbody>tr");var F=n.find(".sapUiTableCHT.sapUiTableCtrlScroll>tbody>tr");var w=i.getHeaderRowCount(a);for(c=0;c<w;c++){if(f){R.push(a.getDomRef("selall"))}if(T.length){R=R.concat(jQuery(T.get(c)).find(".sapUiTableHeaderCell").get())}if(F.length){R=R.concat(jQuery(F.get(c)).find(".sapUiTableHeaderCell").get())}if(d){R.push(n.find(".sapUiTableRowActionHeaderCell").children().get(0))}}g=R.concat(g)}if(!e._itemNavigation){e._itemNavigation=new o;e._itemNavigation.setTableMode(true);e._itemNavigation.attachEvent(o.Events.AfterFocus,function(t){var o=i.getFocusedItemInfo(a);o.header=i.getHeaderRowCount(a);o.domRef=null;if(o.row>=o.header){e._oLastFocusedCellInfo=o}},a)}e._itemNavigation.setColumns(l);e._itemNavigation.setRootDomRef(n.find(".sapUiTableCnt").get(0));e._itemNavigation.setItemDomRefs(g);if(!t){e._itemNavigation.setFocusedIndex(r.getInitialItemNavigationIndex(e))}e._itemNavigationInvalidated=false},getInitialItemNavigationIndex:function(e){return i.hasRowHeader(e.getTable())?1:0},isItemNavigationInvalid:function(e){return!e._itemNavigation||e._itemNavigationInvalidated}};var f=e.extend("sap.ui.table.extensions.Keyboard",{_init:function(e,o,a){this._itemNavigation=null;this._itemNavigationInvalidated=false;this._itemNavigationSuspended=false;this._delegate=new t(o);this._actionMode=false;i.addDelegate(e,l,e);i.addDelegate(e,this._delegate,e);i.addDelegate(e,s,e);e._getItemNavigation=function(){return this._itemNavigation}.bind(this);return"KeyboardExtension"},_debug:function(){this._ExtensionHelper=r;this._ItemNavigationDelegate=s;this._ExtensionDelegate=l},destroy:function(){var t=this.getTable();if(t){t.removeEventDelegate(l);t.removeEventDelegate(this._delegate);t.removeEventDelegate(s)}if(this._itemNavigation){this._itemNavigation.destroy();this._itemNavigation=null}if(this._delegate){this._delegate.destroy();this._delegate=null}e.prototype.destroy.apply(this,arguments)}});f.prototype.initItemNavigation=function(){r.initItemNavigation(this)};f.prototype.invalidateItemNavigation=function(){this._itemNavigationInvalidated=true};f.prototype.setActionMode=function(e){if(!this._delegate){return}if(e===true&&!this._actionMode&&this._delegate.enterActionMode){this._actionMode=this._delegate.enterActionMode.apply(this.getTable(),Array.prototype.slice.call(arguments,1))===true}else if(e===false&&this._actionMode&&this._delegate.leaveActionMode){this._actionMode=false;this._delegate.leaveActionMode.apply(this.getTable(),Array.prototype.slice.call(arguments,1))}};f.prototype.isInActionMode=function(){return this._actionMode};f.prototype.updateNoDataAndOverlayFocus=function(){var e=this.getTable();var t=document.activeElement;if(!e||!e.getDomRef()){return}if(e.getShowOverlay()){if(n(e.getDomRef(),t)&&e.$("overlay")[0]!==t){this._oLastFocus={Ref:t,Pos:"overlay"};e.getDomRef("overlay").focus()}}else if(i.isNoDataVisible(e)){if(e.$("noDataCnt")[0]===t){return}if(n(e.getDomRef("tableCCnt"),t)){this._oLastFocus={Ref:t,Pos:"table content"};if(a.browser.safari){e.getDomRef("noDataCnt").getBoundingClientRect()}e.getDomRef("noDataCnt").focus()}else if(e.$("overlay")[0]===t){u(e,this)}else if(e._bApplyFocusInfoFailed){this._oLastFocus={Ref:t,Pos:"table content"};delete e._bApplyFocusInfoFailed;e.getDomRef("noDataCnt").focus()}}else if(this._oLastFocus){if(this._oLastFocus.Pos==="table content"){if(n(e.getDomRef("tableCCnt"),this._oLastFocus.Ref)){d(e,this)}else if(e.getRows()[0]&&e.getRows()[0].getDomRef("col0")){e.getRows()[0].getDomRef("col0").focus();this._oLastFocus=null}}else if(this._oLastFocus.Pos==="overlay"){if(n(e.getDomRef(),this._oLastFocus.Ref)){d(e,this)}else{u(e,this)}}}};function d(e,t){if(!jQuery(t._oLastFocus.Ref).hasClass("sapUiTableCell")){var o=i.getParentCell(e,t._oLastFocus.Ref);if(o&&o[0]&&jQuery(o[0]).hasClass("sapUiTableCell")){o[0].focus()}else{t._oLastFocus.Ref.focus()}}else{t._oLastFocus.Ref.focus()}t._oLastFocus=null}function u(e,t){if(e.getColumnHeaderVisible()){i.focusItem(e,r.getInitialItemNavigationIndex(t));t._oLastFocus=null}else if(i.isNoDataVisible(e)){e.getDomRef("noDataCnt").focus();t._oLastFocus=null}else if(e.getRows()[0]&&e.getRows()[0].getDomRef("col0")){e.getRows()[0].getDomRef("col0").focus();t._oLastFocus=null}}f.prototype.suspendItemNavigation=function(){this._itemNavigationSuspended=true};f.prototype.resumeItemNavigation=function(){this._itemNavigationSuspended=false};f.prototype.isItemNavigationSuspended=function(){return this._itemNavigationSuspended};f.prototype.getLastFocusedCellInfo=function(){var e=i.getHeaderRowCount(this.getTable());if(!this._oLastFocusedCellInfo||this._oLastFocusedCellInfo.header!=e){var t=i.getFocusedItemInfo(this.getTable());var o=r.getInitialItemNavigationIndex(this);return{cellInRow:o,row:e,header:e,cellCount:t.cellCount,columnCount:t.columnCount,cell:t.columnCount*e+o}}return this._oLastFocusedCellInfo};f.prototype.setSilentFocus=function(e){this._bIgnoreFocusIn=true;this.setFocus(e);this._bIgnoreFocusIn=false};f.prototype.setFocus=function(e){if(!e){return}var t=this.getTable();var o=i.getCellInfo(e);if(o.isOfType(i.CELLTYPE.ANY)&&t){var a=jQuery(e);if(a.attr("tabindex")!="0"){var n=t._getItemNavigation();if(n&&n.aItemDomRefs){for(var s=0;s<n.aItemDomRefs.length;s++){if(n.aItemDomRefs[s]){n.aItemDomRefs[s].setAttribute("tabindex","-1")}}}a.attr("tabindex","0")}}if(e instanceof HTMLElement){e.focus()}else{e.trigger("focus")}};return f});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/extensions/KeyboardDelegate", ["../utils/TableUtils","../library","sap/ui/base/Object","sap/ui/Device","sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery","sap/ui/core/Configuration"],function(e,t,i,n,o,jQuery,s){"use strict";var r=e.CELLTYPE;var l=t.SelectionMode;var a={CTRL:1,SHIFT:2,ALT:4};var f=5;var u="1rem";function g(e,t){e.setMarked("sapUiTableSkipItemNavigation",t!==false)}function c(t){if(e.getCellInfo(t.target).isOfType(r.ANY)){t.preventDefault();t.stopPropagation()}}var d=i.extend("sap.ui.table.extensions.KeyboardDelegate",{constructor:function(e){i.call(this)},destroy:function(){i.prototype.destroy.apply(this,arguments)},getInterface:function(){return this}});function v(t,i){if(!I(t,i)){return}var n=e.getCellInfo(e.getCell(t,i.target));if(n.isOfType(r.ANYCOLUMNHEADER)){C(t,n,i)}else if(n.isOfType(r.ANYCONTENTCELL)){h(t,n,i)}}function C(t,i,n){var o=e.getHeaderRowCount(t);if(e.isNoDataVisible(t)){var s=e.getFocusedItemInfo(t);if(s.row-o<=1){g(n)}}else if(i.isOfType(r.COLUMNROWHEADER)&&o>1){g(n);e.focusItem(t,o*(e.getVisibleColumnCount(t)+1),n)}}function h(t,i,n){var o=t._getKeyboardExtension();var s=o.isInActionMode();var r=d._isKeyCombination(n,null,a.CTRL);var l=r||s;var f=e.getParentCell(t,n.target);if(!l&&f){f.trigger("focus");return}g(n);if(e.isLastScrollableRow(t,i.cell)){var u=R(t,n);if(u){n.preventDefault();return}}if(i.rowIndex===t.getRows().length-1||e.isVariableRowHeightEnabled(t)&&i.rowIndex===t.getRows().length-2&&t.getRows()[i.rowIndex+1].getRowBindingContext()===null){if(!s&&f){f.trigger("focus")}else{var c=t.getCreationRow();if(!c||!c._takeOverKeyboardHandling(n)){o.setActionMode(false)}}return}F(t,i.type,i.rowIndex+1,i.columnIndex,l);n.preventDefault()}function p(t,i){var n=e.getCellInfo(e.getCell(t,i.target));if(!n.isOfType(r.ANYCONTENTCELL)||!I(t,i)){return}var o=d._isKeyCombination(i,null,a.CTRL);var s=t._getKeyboardExtension();var l=s.isInActionMode();var f=o||l;var u=e.getParentCell(t,i.target);if(!f&&u){u.trigger("focus");return}g(i);if(e.isFirstScrollableRow(t,n.cell)){var c=y(t,i);if(c){i.preventDefault();return}}if(n.rowIndex===0){g(i,n.isOfType(r.ROWACTION)||f);if(!l&&u){u.trigger("focus")}else{s.setActionMode(false)}return}F(t,n.type,n.rowIndex-1,n.columnIndex,f);i.preventDefault()}function I(e,t){var i=d._isKeyCombination(t,null,a.CTRL);return!t.isMarked()&&(i||!(t.target instanceof window.HTMLInputElement)&&!(t.target instanceof window.HTMLTextAreaElement))}function m(t,i){if(i.isMarked()){return}var n=e.getCellInfo(e.getCell(t,i.target));var o=s.getRTL();if(!n.isOfType(r.COLUMNHEADER)||!o){return}var l=e.getFocusedItemInfo(t);var a=l.cellInRow-(e.hasRowHeader(t)?1:0);var f=e.getVisibleColumnCount(t);if(e.hasRowActions(t)&&a===f-1){g(i)}}function E(e){return new Promise(function(t){e.attachEventOnce("_rowsUpdated",t)})}function T(e){if(e._hasPendingRequests()){return E(e).then(function(){return T(e)})}return Promise.resolve()}function R(e,t,i,n){var o=e._getFirstRenderedRowIndex()===e._getMaxFirstRenderedRowIndex();if(o){return null}return A(e,t,true,i,n)}function y(e,t,i,n){var o=e._getFirstRenderedRowIndex()===0;if(o){return null}return A(e,t,false,i,n)}function A(t,i,n,o,s){var l=e.getCellInfo(e.getCell(t,i.target));var f=t._getKeyboardExtension().isInActionMode();var u=d._isKeyCombination(i,null,a.CTRL);var g=u||f;var c=f&&l.isOfType(r.DATACELL);if(c){t._getKeyboardExtension().setSilentFocus(t.getDomRef("focusDummy"));setTimeout(function(){t._getScrollExtension().scrollVertically(n===true,o)},0)}else{t._getScrollExtension().scrollVertically(n===true,o)}return E(t).then(function(){if(s){s()}else if(g){F(t,l.type,l.rowIndex,l.columnIndex,true)}})}function O(e,t){var i=e._getRowCounts();var n=R(e,t,false,function(){x(e,i.fixedTop+i.scrollable-1)});if(n){return}if(i.fixedBottom>0){x(e,i.fixedTop+i.scrollable)}else{e._getKeyboardExtension().setActionMode(false)}}function x(t,i){var n=t.getRows()[i];var o=n.isGroupHeader()||e.isRowSelectorSelectionAllowed(t);if(o){F(t,r.ROWHEADER,i)}else{var s=d._getFirstInteractiveElement(n);if(s){d._focusElement(t,s[0])}else{F(t,r.DATACELL,i,0,false,true);if(n.getIndex()===t._getTotalRowCount()-1){t._getKeyboardExtension().setActionMode(false)}}}}function _(e,t){var i=e._getRowCounts();var n=y(e,t,false,function(){w(e,i.fixedTop)});if(n){return}if(i.fixedTop>0){w(e,i.fixedTop-1)}else{e._getKeyboardExtension().setActionMode(false)}}function w(t,i){var n=t.getRows()[i];var o=n.isGroupHeader()||e.isRowSelectorSelectionAllowed(t);var s=d._getLastInteractiveElement(n);if(s){d._focusElement(t,s[0])}else if(o){F(t,r.ROWHEADER,i)}else{F(t,r.DATACELL,i,0,false,true);if(n.getIndex()===0){t._getKeyboardExtension().setActionMode(false)}}}function b(t,i){var n=e.getFocusedItemInfo(t);var o=t._getKeyboardExtension().getLastFocusedCellInfo();e.focusItem(t,n.cellInRow+n.columnCount*o.row,i)}function L(t,i){var n=e.getFocusedItemInfo(t);e.focusItem(t,n.cellInRow,i)}function N(e,t){e._getKeyboardExtension().setSilentFocus(e.$().find("."+t))}d._isKeyCombination=function(e,t,i){if(i==null){i=0}var s=typeof t==="string"?String.fromCharCode(e.charCode):e.keyCode;var r=0;r|=(n.os.macintosh?e.metaKey:e.ctrlKey)&&t!==o.CONTROL?a.CTRL:0;r|=e.shiftKey&&t!==o.SHIFT?a.SHIFT:0;r|=e.altKey&&t!==o.ALT?a.ALT:0;var l=t==null||s===t;var f=i===r;return l&&f};function S(t,i){var n=e.getCell(t,i);var o=e.getCellInfo(n);return t.getRows()[o.rowIndex]}function D(t,i){var n=e.getCellInfo(i.target);if(n.isOfType(r.COLUMNROWHEADER)){t._getSelectionPlugin().onHeaderSelectorPress()}else if(d._allowsToggleExpandedState(t,i.target)){S(t,i.target).toggleExpandedState()}else if(n.isOfType(r.ROWHEADER)){l()}else if(n.isOfType(r.DATACELL|r.ROWACTION)){var o=!t.hasListeners("cellClick");if(!t._findAndfireCellEvent(t.fireCellClick,i)){if(e.isRowSelectionAllowed(t)){l();o=false}}if(o){var s=e.getInteractiveElements(i.target);if(s){t._getKeyboardExtension().setActionMode(true)}}}function l(){var n=null;if(t._legacyMultiSelection){n=function(e){t._legacyMultiSelection(e.getIndex(),i)}}e.toggleRowSelection(t,i.target,null,n)}}function M(t,i){var n=t.getParent();var o=n._getVisibleColumns();var s=o.indexOf(t);var r;if(i&&s<o.length-1){r=n.indexOfColumn(o[s+1])+1}else if(!i&&s>0){r=n.indexOfColumn(o[s-1])}if(r!=null){e.Column.moveColumnTo(t,r)}}function K(e,t){var i=e.getColumns().filter(function(e){return e.getVisible()||(e.getGrouped?e.getGrouped():false)});for(var n=0;n<i.length;n++){var o=i[n];if(o===t){return n}}return-1}function H(t,i,n){if(!n){if(t._oRangeSelection.selected){e.toggleRowSelection(t,i,true)}else{e.toggleRowSelection(t,i,false)}}else{e.toggleRowSelection(t,i,false)}}d._focusElement=function(e,t,i){if(!e||!t){return}if(i==null){i=false}if(i){e._getKeyboardExtension().setSilentFocus(t)}else{t.focus()}if(t instanceof window.HTMLInputElement){t.select()}};function F(t,i,n,o,s,l){if(!t||i==null||n==null||n<0||n>=t.getRows().length){return}var a=t.getRows()[n];var f;if(i===r.ROWHEADER){t._getKeyboardExtension().setFocus(t.getDomRef("rowsel"+n));return}else if(i===r.ROWACTION){f=t.getDomRef("rowact"+n)}else if(i===r.DATACELL&&(o!=null&&o>=0)){var u=t.getColumns()[o];var g=K(t,u);if(g>=0){f=a.getDomRef("col"+g)}}if(!f){return}if(s){var c=e.getInteractiveElements(f);if(c){d._focusElement(t,c[0]);return}}if(l){t._getKeyboardExtension()._bStayInActionMode=true}f.focus()}function U(e){return e.classList.contains("sapUiTableTreeIconNodeOpen")||e.classList.contains("sapUiTableTreeIconNodeClosed")}d._allowsToggleExpandedState=function(t,i){return e.Grouping.isInGroupHeaderRow(i)||e.Grouping.isInTreeMode(t)&&i.classList.contains("sapUiTableCellFirst")&&(i.querySelector(".sapUiTableTreeIconNodeOpen")||i.querySelector(".sapUiTableTreeIconNodeClosed"))||U(i)};d._isElementInteractive=function(t){if(!t){return false}return jQuery(t).is(e.INTERACTIVE_ELEMENT_SELECTORS)};d._getFirstInteractiveElement=function(t){var i=e.getFirstInteractiveElement(t,true);if(!i){return null}return jQuery(i)};d._getLastInteractiveElement=function(t){if(!t){return null}var i=t.getParent();var n=t.getCells();var o;var s;if(e.hasRowActions(i)){n.push(t.getRowAction())}for(var r=n.length-1;r>=0;r--){o=e.getParentCell(i,n[r].getDomRef());s=e.getInteractiveElements(o);if(s){return s.last()}}return null};d._getPreviousInteractiveElement=function(t,i){if(!t||!i){return null}var n=jQuery(i);if(!this._isElementInteractive(n)){return null}var o=e.getParentCell(t,i);var s;var l;var a;var f;var u;var g;var c;s=e.getInteractiveElements(o);if(s[0]!==n[0]){return s.eq(s.index(i)-1)}l=e.getCellInfo(o);f=t.getRows()[l.rowIndex].getCells();if(l.isOfType(r.ROWACTION)){c=f.length-1}else{u=t.getColumns()[l.columnIndex];g=K(t,u);c=g-1}for(var d=c;d>=0;d--){a=f[d].getDomRef();o=e.getParentCell(t,a);s=e.getInteractiveElements(o);if(s){return s.last()}}return null};d._getNextInteractiveElement=function(t,i){if(!t||!i){return null}var n=jQuery(i);if(!this._isElementInteractive(n)){return null}var o=e.getParentCell(t,i);var s;var l;var a;var f;var u;var g;var c;s=e.getInteractiveElements(o);if(s.get(-1)!==n[0]){return s.eq(s.index(i)+1)}l=e.getCellInfo(o);if(l.isOfType(r.ROWACTION)){return null}g=t.getRows()[l.rowIndex];f=g.getCells();u=t.getColumns()[l.columnIndex];c=K(t,u);for(var d=c+1;d<f.length;d++){a=f[d].getDomRef();o=e.getParentCell(t,a);s=e.getInteractiveElements(o);if(s){return s.first()}}if(e.hasRowActions(t)){o=e.getParentCell(t,g.getRowAction().getDomRef());s=e.getInteractiveElements(o);if(s.get(-1)!==n[0]){return s.eq(s.index(i)+1)}}return null};function W(t){var i=e.getRowIndexOfFocusedCell(t);var n=t.getRows()[i];var o=n.getIndex();var s=t._getSelectionPlugin();t._oRangeSelection={startIndex:o,selected:s.isSelected(n)}}d.prototype.enterActionMode=function(){var t=this._getKeyboardExtension();var i=document.activeElement;var n=e.getInteractiveElements(i);var o=e.getParentCell(this,i);var s=e.getCellInfo(o);if(s.isOfType(r.ANYCOLUMNHEADER)){return false}if(n){t.suspendItemNavigation();i.tabIndex=-1;d._focusElement(this,n[0],true);return true}else if(o){this._getKeyboardExtension().suspendItemNavigation();return true}return false};d.prototype.leaveActionMode=function(t){t=t==null?true:t;var i=this._getKeyboardExtension();var n=document.activeElement;var o=e.getParentCell(this,n);i.resumeItemNavigation();if(t){if(o){d._focusElement(this,o[0],true)}else{var s=this._getItemNavigation();if(s){var r=s.aItemDomRefs;var l=r.indexOf(n);if(l>-1){s.setFocusedIndex(l)}}i.setSilentFocus(n)}}};d.prototype.onfocusin=function(t){if(t.isMarked("sapUiTableIgnoreFocusIn")){return}var i=jQuery(t.target);if(i.hasClass("sapUiTableOuterBefore")||i.hasClass("sapUiTableOuterAfter")||t.target!=this.getDomRef("overlay")&&this.getShowOverlay()){this.$("overlay").trigger("focus")}else if(i.hasClass("sapUiTableCtrlBefore")){var n=e.isNoDataVisible(this);if(!n||n&&this.getColumnHeaderVisible()){L(this,t)}else{this._getKeyboardExtension().setSilentFocus(this.$("noDataCnt"))}}else if(i.hasClass("sapUiTableCtrlAfter")){if(!e.isNoDataVisible(this)){b(this,t)}}var o=e.getCellInfo(t.target);var s=o.isOfType(r.ROWHEADER)&&e.Grouping.isInGroupHeaderRow(t.target);var l=o.isOfType(r.ROWHEADER)&&!s&&e.isRowSelectorSelectionAllowed(this);var a=o.isOfType(r.DATACELL)&&this._getKeyboardExtension()._bStayInActionMode;var f=e.getCellInfo(e.getParentCell(this,t.target)).isOfType(r.ANYCONTENTCELL);var u=d._isElementInteractive(t.target);var g=this._getKeyboardExtension().isInActionMode();var c=g&&(s||l||a)||u&&f;if(a){this._getKeyboardExtension()._bStayInActionMode=false}this._getKeyboardExtension().setActionMode(c,false)};d.prototype.onkeydown=function(t){if(t.isMarked()){return}var i=this._getKeyboardExtension();var n=e.getCellInfo(t.target);var s=this.getSelectionMode();var f=this._getSelectionPlugin();if(d._isKeyCombination(t,o.F2)){var u=i.isInActionMode();var g=e.getCell(this,t.target);var c=e.getParentCell(this,t.target)!=null;n=e.getCellInfo(g);if(!u&&c){g.trigger("focus")}else if(n.isOfType(r.ANYCOLUMNHEADER)){var v=e.getInteractiveElements(g);if(v){v[0].focus()}}else{i.setActionMode(!u)}return}if(d._isKeyCombination(t,o.F4)&&d._allowsToggleExpandedState(this,t.target)){S(this,t.target).toggleExpandedState();return}if(d._isKeyCombination(t,o.SPACE)&&U(t.target)){t.preventDefault();return}if(this._getKeyboardExtension().isInActionMode()||!n.isOfType(r.ANY)){return}if(d._isKeyCombination(t,o.SPACE)){t.preventDefault()}if(d._isKeyCombination(t,o.SHIFT)&&s===l.MultiToggle&&(n.isOfType(r.ROWHEADER)&&e.isRowSelectorSelectionAllowed(this)||n.isOfType(r.DATACELL|r.ROWACTION))){W(this)}else if(d._isKeyCombination(t,o.A,a.CTRL)){t.preventDefault();if(n.isOfType(r.ANYCONTENTCELL|r.COLUMNROWHEADER)&&s===l.MultiToggle){f.onKeyboardShortcut("toggle",t)}}else if(d._isKeyCombination(t,o.A,a.CTRL+a.SHIFT)){if(n.isOfType(r.ANYCONTENTCELL|r.COLUMNROWHEADER)){f.onKeyboardShortcut("clear",t)}}else if(d._isKeyCombination(t,o.F4)){if(n.isOfType(r.DATACELL)){i.setActionMode(true)}}};d.prototype.onkeypress=function(t){if(t.isMarked()){return}var i=this._getKeyboardExtension();var n=e.getCellInfo(t.target);if(d._isKeyCombination(t,"+")){if(d._allowsToggleExpandedState(this,t.target)){S(this,t.target).expand()}else if(n.isOfType(r.DATACELL|r.ROWACTION)){i.setActionMode(true)}}else if(d._isKeyCombination(t,"-")){if(d._allowsToggleExpandedState(this,t.target)){S(this,t.target).collapse()}else if(n.isOfType(r.DATACELL|r.ROWACTION)){i.setActionMode(true)}}};d.prototype.oncontextmenu=function(t){if(t.isMarked("sapUiTableHandledByPointerExtension")){return}var i=e.getCellInfo(document.activeElement);if(i.isOfType(r.ANY)){t.preventDefault();e.Menu.openContextMenu(this,t)}};d.prototype.onkeyup=function(t){if(t.isMarked()){return}var i=e.getCellInfo(t.target);if(d._isKeyCombination(t,o.SHIFT)){delete this._oRangeSelection}if(i.isOfType(r.COLUMNHEADER)){if(d._isKeyCombination(t,o.SPACE)||d._isKeyCombination(t,o.ENTER)){e.Menu.openContextMenu(this,t)}}else if(d._isKeyCombination(t,o.SPACE)){D(this,t)}else if(d._isKeyCombination(t,o.SPACE,a.SHIFT)){e.toggleRowSelection(this,i.rowIndex);W(this)}else if(this._legacyMultiSelection&&!i.isOfType(r.COLUMNROWHEADER)&&(d._isKeyCombination(t,o.SPACE,a.CTRL)||d._isKeyCombination(t,o.ENTER,a.CTRL))){D(this,t)}};d.prototype.onsaptabnext=function(t){var i=this._getKeyboardExtension();var n=e.getCellInfo(t.target);var o;if(i.isInActionMode()){var s;o=e.getCell(this,t.target);n=e.getCellInfo(o);if(!n.isOfType(r.ANYCONTENTCELL)){return}var l=this.getRows()[n.rowIndex];var a=d._getLastInteractiveElement(l);var f=a===null||a[0]===t.target;if(f){var u=l.getIndex();var g=e.isLastScrollableRow(this,o);var c=this._getTotalRowCount()-1===u;var v=e.isRowSelectorSelectionAllowed(this);t.preventDefault();if(c){i.setActionMode(false)}else if(g){O(this,t)}else{var C=n.rowIndex;if(v){F(this,r.ROWHEADER,C+1)}else{var h=this.getRows().length;var p=false;for(var I=n.rowIndex+1;I<h;I++){C=I;l=this.getRows()[C];s=d._getFirstInteractiveElement(l);p=l.isGroupHeader();if(s||p){break}}if(s){d._focusElement(this,s[0])}else if(p){F(this,r.ROWHEADER,C)}else{O(this,t)}}}}else if(n.isOfType(r.ROWHEADER)){t.preventDefault();s=d._getFirstInteractiveElement(l);d._focusElement(this,s[0])}else{t.preventDefault();s=d._getNextInteractiveElement(this,t.target);d._focusElement(this,s[0])}}else if(n.isOfType(r.ANYCOLUMNHEADER)){if(this.getCreationRow()&&this.getCreationRow().getVisible()&&!e.hasData(this)){N(this,"sapUiTableCtrlAfter")}else if(e.isNoDataVisible(this)){this.$("noDataCnt").trigger("focus");t.preventDefault()}else if(this.getRows().length>0){b(this,t);t.preventDefault()}}else if(n.isOfType(r.ANYCONTENTCELL)){N(this,"sapUiTableCtrlAfter")}else if(t.target===this.getDomRef("overlay")){i.setSilentFocus(this.$().find(".sapUiTableOuterAfter"))}else if(!n.isOfType(r.ANY)){o=e.getParentCell(this,t.target);if(o){t.preventDefault();o.trigger("focus")}}};d.prototype.onsaptabprevious=function(t){var i=this._getKeyboardExtension();var n=e.getCellInfo(t.target);var o;if(i.isInActionMode()){var s;o=e.getCell(this,t.target);n=e.getCellInfo(o);if(!n.isOfType(r.ANYCONTENTCELL)){return}var l=this.getRows()[n.rowIndex];var a=l.getIndex();var f=d._getFirstInteractiveElement(l);var u=f!==null&&f[0]===t.target;var g=e.isRowSelectorSelectionAllowed(this);var c=g||l.isGroupHeader();if(u&&c){t.preventDefault();F(this,r.ROWHEADER,n.rowIndex)}else if(u&&!c||n.isOfType(r.ROWHEADER)||f===null){var v=e.isFirstScrollableRow(this,o);var C=a===0;t.preventDefault();if(C){i.setActionMode(false)}else if(v){_(this,t)}else{var h=n.rowIndex;var p=false;for(var I=n.rowIndex-1;I>=0;I--){h=I;l=this.getRows()[h];s=d._getLastInteractiveElement(l);p=l.isGroupHeader();if(s||c||p){break}}if(s){d._focusElement(this,s[0])}else if(p||c){F(this,r.ROWHEADER,h)}else{_(this,t)}}}else{t.preventDefault();s=d._getPreviousInteractiveElement(this,t.target);d._focusElement(this,s[0])}}else if(n.isOfType(r.ANYCONTENTCELL)||t.target===this.getDomRef("noDataCnt")){if(this.getColumnHeaderVisible()&&!n.isOfType(r.ROWACTION)){L(this,t);t.preventDefault()}else{N(this,"sapUiTableCtrlBefore")}}else if(t.target===this.getDomRef("overlay")){this._getKeyboardExtension().setSilentFocus(this.$().find(".sapUiTableOuterBefore"))}else if(!n.isOfType(r.ANY)){o=e.getParentCell(this,t.target);if(o){t.preventDefault();o.trigger("focus")}}};d.prototype.onsapdown=function(e){c(e);v(this,e)};d.prototype.onsapdownmodifiers=function(t){if(t.isMarked()){g(t);return}c(t);if(d._isKeyCombination(t,null,a.CTRL)){v(this,t);return}var i=this._getKeyboardExtension();if(d._isKeyCombination(t,null,a.ALT)&&d._allowsToggleExpandedState(this,t.target)){g(t);S(this,t.target).expand();return}if(i.isInActionMode()){return}var n=e.getCellInfo(t.target);if(d._isKeyCombination(t,null,a.SHIFT)){if(n.isOfType(r.ANYCONTENTCELL)){if(!this._oRangeSelection){g(t);return}var o=e.getRowIndexOfFocusedCell(this);var s=this.getRows()[o].getIndex();var l=this._oRangeSelection.startIndex>s;var f;if(s===this._getTotalRowCount()-1){return}if(e.isLastScrollableRow(this,t.target)){if(this._oRangeSelection.pScroll){g(t);return}else{f=R(this,t);this._oRangeSelection.pScroll=f}}if(f){g(t);f.then(function(){return T(this)}.bind(this)).then(function(){H(this,o-(l?1:0),l);delete this._oRangeSelection.pScroll}.bind(this))}else{H(this,o+(l?0:1),l)}}else{g(t)}}if(d._isKeyCombination(t,null,a.ALT)){if(n.isOfType(r.DATACELL)){i.setActionMode(true)}g(t)}};d.prototype.onsapup=function(e){c(e);p(this,e)};d.prototype.onsapupmodifiers=function(t){if(t.isMarked()){g(t);return}c(t);if(d._isKeyCombination(t,null,a.CTRL)){p(this,t);return}if(d._isKeyCombination(t,null,a.ALT)&&d._allowsToggleExpandedState(this,t.target)){g(t);S(this,t.target).collapse();return}var i=this._getKeyboardExtension();if(i.isInActionMode()){return}var n=e.getCellInfo(t.target);if(d._isKeyCombination(t,null,a.SHIFT)){if(n.isOfType(r.ANYCONTENTCELL)){if(!this._oRangeSelection){g(t);return}var o=e.getRowIndexOfFocusedCell(this);var s=this.getRows()[o].getIndex();var l=this._oRangeSelection.startIndex<s;var f;if(s===0){g(t);return}if(e.isFirstScrollableRow(this,t.target)){if(this._oRangeSelection.pScroll){g(t);return}else{f=y(this,t);this._oRangeSelection.pScroll=f}}if(f){g(t);f.then(function(){return T(this)}.bind(this)).then(function(){H(this,l?1:0,l);delete this._oRangeSelection.pScroll}.bind(this))}else{H(this,o-(l?0:1),l)}}else{g(t)}}if(d._isKeyCombination(t,null,a.ALT)){if(n.isOfType(r.DATACELL)){i.setActionMode(true)}g(t)}};d.prototype.onsapleft=function(e){c(e);m(this,e)};d.prototype.onsapleftmodifiers=function(t){if(t.isMarked()){g(t);return}c(t);if(this._getKeyboardExtension().isInActionMode()){return}var i=e.getCellInfo(t.target);var n=s.getRTL();if(d._isKeyCombination(t,null,a.SHIFT)){if(i.isOfType(r.DATACELL)){if(!this._oRangeSelection){g(t);return}var o=e.getFocusedItemInfo(this);var l=e.hasRowHeader(this)&&o.cellInRow===1;if(l&&!e.isRowSelectorSelectionAllowed(this)){g(t)}}else if(i.isOfType(r.ROWACTION)){if(!this._oRangeSelection){g(t)}}else if(i.isOfType(r.ROWHEADER)&&n){if(!e.isRowSelectionAllowed(this)){g(t)}}else if(i.isOfType(r.COLUMNROWHEADER)&&n){g(t)}else if(i.isOfType(r.COLUMNHEADER)){var f=-e.convertCSSSizeToPixel(u);var v=0;if(n){f=f*-1}for(var C=i.columnIndex;C<i.columnIndex+i.columnSpan;C++){v+=e.Column.getColumnWidth(this,C)}e.Column.resizeColumn(this,i.columnIndex,v+f,true,i.columnSpan);g(t)}}else if(d._isKeyCombination(t,null,a.CTRL)){if(i.isOfType(r.COLUMNHEADER)){g(t);M(this.getColumns()[i.columnIndex],n)}}else if(d._isKeyCombination(t,null,a.ALT)){g(t)}};d.prototype.onsaprightmodifiers=function(t){if(t.isMarked()){g(t);return}c(t);if(this._getKeyboardExtension().isInActionMode()){return}var i=e.getCellInfo(t.target);var n=s.getRTL();if(d._isKeyCombination(t,null,a.SHIFT)){if(i.isOfType(r.DATACELL)){if(!this._oRangeSelection){g(t)}}else if(i.isOfType(r.ROWHEADER)){if(!e.isRowSelectionAllowed(this)){g(t)}}else if(i.isOfType(r.ROWACTION)&&n){if(!this._oRangeSelection){g(t)}}else if(i.isOfType(r.COLUMNHEADER)){var o=e.convertCSSSizeToPixel(u);var l=0;if(n){o=o*-1}for(var f=i.columnIndex;f<i.columnIndex+i.columnSpan;f++){l+=e.Column.getColumnWidth(this,f)}e.Column.resizeColumn(this,i.columnIndex,l+o,true,i.columnSpan);g(t)}else if(i.isOfType(r.COLUMNROWHEADER)){g(t)}}else if(d._isKeyCombination(t,null,a.CTRL)){if(i.isOfType(r.COLUMNHEADER)){g(t);M(this.getColumns()[i.columnIndex],!n)}}else if(d._isKeyCombination(t,null,a.ALT)){g(t)}};d.prototype.onsaphome=function(t){c(t);if(this._getKeyboardExtension().isInActionMode()){return}if(e.Grouping.isInGroupHeaderRow(t.target)){g(t);return}var i=e.getCellInfo(t.target);if(i.isOfType(r.DATACELL|r.ROWACTION|r.COLUMNHEADER)){var n=e.getFocusedItemInfo(this);var o=n.cell;var s=n.cellInRow;var l=this.getComputedFixedColumnCount();var a=e.hasRowHeader(this);var f=a?1:0;if(e.hasFixedColumns(this)&&s>l+f){g(t);e.focusItem(this,o-s+l+f,null)}else if(a&&s>1){g(t);e.focusItem(this,o-s+f,null)}}};d.prototype.onsapend=function(t){c(t);if(this._getKeyboardExtension().isInActionMode()){return}if(e.Grouping.isInGroupHeaderRow(t.target)){g(t);return}var i=e.getCellInfo(t.target);if(i.isOfType(r.ANY)){var n=e.getFocusedItemInfo(this);var o=n.cell;var s=n.columnCount;var l=this.getComputedFixedColumnCount();var a=n.cellInRow;var f=e.hasRowHeader(this);var u=f?1:0;var d=false;if(i.isOfType(r.COLUMNHEADER)&&e.hasFixedColumns(this)){var v=parseInt(i.cell.attr("colspan")||1);if(v>1&&a+v-u===l){d=true}}if(f&&a===0){g(t);e.focusItem(this,o+1,null)}else if(e.hasFixedColumns(this)&&a<l-1+u&&!d){g(t);e.focusItem(this,o+l-a,null)}else if(e.hasRowActions(this)&&i.isOfType(r.DATACELL)&&a<s-2){g(t);e.focusItem(this,o-a+s-2,null)}}};d.prototype.onsaphomemodifiers=function(t){c(t);if(this._getKeyboardExtension().isInActionMode()){return}if(d._isKeyCombination(t,null,a.CTRL)){var i=e.getCellInfo(t.target);if(i.isOfType(r.ANYCONTENTCELL|r.COLUMNHEADER)){g(t);var n=e.getFocusedItemInfo(this);var o=n.row;if(o>0){var s=n.cell;var l=n.columnCount;var f=e.getHeaderRowCount(this);var u=this._getRowCounts();if(o<f+u.fixedTop){if(i.isOfType(r.ROWACTION)){e.focusItem(this,s-l*(o-f),t)}else{e.focusItem(this,s-l*o,t)}}else if(o>=f+u.fixedTop&&o<f+e.getNonEmptyRowCount(this)-u.fixedBottom){this._getScrollExtension().scrollVerticallyMax(false);if(u.fixedTop>0||i.isOfType(r.ROWACTION)){e.focusItem(this,s-l*(o-f),t)}else{e.focusItem(this,s-l*o,t)}}else{this._getScrollExtension().scrollVerticallyMax(false);e.focusItem(this,s-l*(o-f-u.fixedTop),t)}}}}};d.prototype.onsapendmodifiers=function(t){c(t);if(this._getKeyboardExtension().isInActionMode()){return}if(d._isKeyCombination(t,null,a.CTRL)){var i=e.getCellInfo(t.target);if(i.isOfType(r.ANY)){var n=e.getFocusedItemInfo(this);var o=n.row;var s=e.getHeaderRowCount(this);var l=e.getNonEmptyRowCount(this);var f=this._getRowCounts();g(t);if(f.fixedBottom===0||o<s+l-1||e.isNoDataVisible(this)&&o<s-1){var u=n.cell;var v=n.columnCount;if(e.isNoDataVisible(this)){e.focusItem(this,u+v*(s-o-1),t)}else if(o<s){if(f.fixedTop>0){e.focusItem(this,u+v*(s+f.fixedTop-o-1),t)}else{this._getScrollExtension().scrollVerticallyMax(true);e.focusItem(this,u+v*(s+l-f.fixedBottom-o-1),t)}}else if(o>=s&&o<s+f.fixedTop){this._getScrollExtension().scrollVerticallyMax(true);e.focusItem(this,u+v*(s+l-f.fixedBottom-o-1),t)}else if(o>=s+f.fixedTop&&o<s+l-f.fixedBottom){this._getScrollExtension().scrollVerticallyMax(true);e.focusItem(this,u+v*(s+l-o-1),t)}else{e.focusItem(this,u+v*(s+l-o-1),t)}}}}};d.prototype.onsappageup=function(t){c(t);if(this._getKeyboardExtension().isInActionMode()){return}var i=e.getCellInfo(t.target);if(i.isOfType(r.ANYCONTENTCELL|r.COLUMNHEADER)){var n=e.getFocusedItemInfo(this);var o=n.row;var s=e.getHeaderRowCount(this);var l=this._getRowCounts();if(l.fixedTop===0&&o>=s||l.fixedTop>0&&o>s){g(t);var a=n.cell;var f=n.columnCount;if(o<s+l.fixedTop){e.focusItem(this,a-f*(o-s),t)}else if(o===s+l.fixedTop){var u=e.getNonEmptyRowCount(this)-l.fixedTop-l.fixedBottom;var d=this.getFirstVisibleRow();y(this,t,true);if(d<u){if(l.fixedTop>0||i.isOfType(r.ROWACTION)){e.focusItem(this,a-f*(o-s),t)}else{e.focusItem(this,a-f*s,t)}}}else if(o>s+l.fixedTop&&o<s+e.getNonEmptyRowCount(this)){e.focusItem(this,a-f*(o-s-l.fixedTop),t)}else{e.focusItem(this,a-f*(o-s-e.getNonEmptyRowCount(this)+1),t)}}if(i.isOfType(r.ROWACTION)&&o===s&&l.fixedTop>0){g(t)}}};d.prototype.onsappagedown=function(t){c(t);if(this._getKeyboardExtension().isInActionMode()){return}var i=e.getCellInfo(t.target);if(i.isOfType(r.ANY)){var n=e.getFocusedItemInfo(this);var o=n.row;var s=e.getHeaderRowCount(this);var l=e.getNonEmptyRowCount(this);var a=this._getRowCounts();g(t);if(e.isNoDataVisible(this)&&o<s-1||a.fixedBottom===0||o<s+l-1){var f=n.cell;var u=n.columnCount;if(o<s-1&&!i.isOfType(r.COLUMNROWHEADER)){e.focusItem(this,f+u*(s-o-1),t)}else if(o<s){if(!e.isNoDataVisible(this)){e.focusItem(this,f+u*(s-o),t)}}else if(o>=s&&o<s+l-a.fixedBottom-1){e.focusItem(this,f+u*(s+l-a.fixedBottom-o-1),t)}else if(o===s+l-a.fixedBottom-1){var d=e.getNonEmptyRowCount(this)-a.fixedTop-a.fixedBottom;var v=this._getTotalRowCount()-a.fixedBottom-this.getFirstVisibleRow()-d*2;R(this,t,true);if(v<d&&a.fixedBottom>0){e.focusItem(this,f+u*(s+l-o-1),t)}}else{e.focusItem(this,f+u*(s+l-o-1),t)}}}};d.prototype.onsappageupmodifiers=function(t){c(t);if(this._getKeyboardExtension().isInActionMode()){return}if(d._isKeyCombination(t,null,a.ALT)){var i=e.getCellInfo(t.target);var n=e.getFocusedItemInfo(this);if(i.isOfType(r.DATACELL|r.COLUMNHEADER)){var o=n.cell;var s=n.cellInRow;var l=e.hasRowHeader(this);var u=l?1:0;var v=f;g(t);if(l&&(e.Grouping.isInGroupHeaderRow(t.target)||s===1)){e.focusItem(this,o-s,null)}else if(s-u<v){e.focusItem(this,o-s+u,null)}else{e.focusItem(this,o-v,null)}}else if(i.isOfType(r.ROWACTION)){e.focusItem(this,n.cell-1,null)}}};d.prototype.onsappagedownmodifiers=function(t){c(t);if(this._getKeyboardExtension().isInActionMode()){return}if(d._isKeyCombination(t,null,a.ALT)){var i=e.getCellInfo(t.target);if(i.isOfType(r.DATACELL|r.ROWHEADER|r.ANYCOLUMNHEADER)){var n=e.getFocusedItemInfo(this);var o=n.cellInRow;var s=e.hasRowHeader(this);var l=s?1:0;var u=e.getVisibleColumnCount(this);var v=parseInt(i.cell.attr("colspan")||1);g(t);if(o+v-l<u){var C=n.cell;var h=f;if(s&&o===0){e.focusItem(this,C+1,null)}else if(v>h){e.focusItem(this,C+v,null)}else if(o+v-l+h>u){e.focusItem(this,C+u-o-1+l,null)}else if(!e.Grouping.isInGroupHeaderRow(t.target)){e.focusItem(this,C+h,null)}}else if(i.isOfType(r.DATACELL)&&e.hasRowActions(this)&&o===n.columnCount-2){e.focusItem(this,n.cell+1,null)}}}};d.prototype.onsapenter=function(e){D(this,e)};return d});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/extensions/Pointer", ["./ExtensionBase","../utils/TableUtils","../library","sap/ui/Device","sap/ui/core/Element","sap/ui/core/Popup","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/scrollLeftRTL","sap/ui/dom/jquery/control"],function(e,t,i,o,n,l,s,jQuery){"use strict";var r=i.SelectionMode;var a=i.SelectionBehavior;var u=["sapMBtnBase","sapMInputBase","sapMLnk","sapMSlt","sapMCb","sapMRI","sapMSegBBtn","sapUiIconPointer","sapMBtnIcon","sapMObjStatusActive"];var d={_getEventPosition:function(e,t){var i;function o(i){if(!t._isTouchEvent(i)){return null}var o=["touches","targetTouches","changedTouches"];for(var n=0;n<o.length;n++){var l=o[n];if(e[l]&&e[l][0]){return e[l][0]}if(e.originalEvent[l]&&e.originalEvent[l][0]){return e.originalEvent[l][0]}}return null}i=o(e)||e;return{x:i.pageX,y:i.pageY}},_skipClick:function(e,i,o){if(!o.isOfType(t.CELLTYPE.DATACELL|t.CELLTYPE.ROWACTION)){return false}if(e.isMarked()){return true}var l=n.closestTo(i[0]);if(l){var s=l.$();if(s.length){for(var r=0;r<u.length;r++){if(s.hasClass(u[r])){return typeof l.getEnabled==="function"?l.getEnabled():true}}}}return false},_handleClickSelection:function(e,i,o){t.toggleRowSelection(o,i,null,function(t){var i=o._getSelectionPlugin();if(e.shiftKey){i.setSelected(t,true,{range:true})}else if(o._legacyMultiSelection){o._legacyMultiSelection(t.getIndex(),e)}else{i.setSelected(t,!i.isSelected(t))}})}};var f={initColumnResizing:function(e,t){if(e._bIsColumnResizerMoving){return}e._bIsColumnResizerMoving=true;e._bColumnResizerMoved=false;e._iColumnResizeStart=d._getEventPosition(t,e).x;e.$().toggleClass("sapUiTableResizing",true);var i=jQuery(document);var o=e._isTouchEvent(t);e._$colResize=e.$("rsz");i.on((o?"touchend":"mouseup")+".sapUiTableColumnResize",f.exitColumnResizing.bind(e));i.on((o?"touchmove":"mousemove")+".sapUiTableColumnResize",f.onMouseMoveWhileColumnResizing.bind(e));e._disableTextSelection()},exitColumnResizing:function(e){var i=d._getEventPosition(e,this).x;var o=this._getVisibleColumns()[this._iLastHoveredVisibleColumnIndex];var n=this.$().find('th[data-sap-ui-colid="'+o.getId()+'"]');var l=n[0].offsetWidth;var s=n.width();var r=l-s;var a=i-(n.offset().left+(this._bRtlMode?0:l));var u=Math.round(l+a*(this._bRtlMode?-1:1))-r;var h=Math.max(u,t.Column.getMinColumnWidth());f._resizeColumn(this,this._iLastHoveredVisibleColumnIndex,this._bColumnResizerMoved?h:null)},onMouseMoveWhileColumnResizing:function(e){var t=d._getEventPosition(e,this).x;var i=this.$().find(".sapUiTableCnt").offset().left;var o=Math.floor(t-i);if(!this._bColumnResizerMoved&&Math.abs(t-this._iColumnResizeStart)>=5){this._bColumnResizerMoved=true}this._$colResize.css("left",o+"px");this._$colResize.toggleClass("sapUiTableColRszActive",true);if(this._isTouchEvent(e)){e.stopPropagation();e.preventDefault()}},_cleanupColumResizing:function(e){if(e._$colResize){e._$colResize.toggleClass("sapUiTableColRszActive",false);e._$colResize=null}e._bIsColumnResizerMoving=false;e.$().toggleClass("sapUiTableResizing",false);e._enableTextSelection();var t=jQuery(document);t.off("touchmove.sapUiTableColumnResize");t.off("touchend.sapUiTableColumnResize");t.off("mousemove.sapUiTableColumnResize");t.off("mouseup.sapUiTableColumnResize")},_resizeColumn:function(e,i,o){var n=e._getVisibleColumns();var l;if(i>=0&&i<n.length){l=n[i];if(o!=null){t.Column.resizeColumn(e,e.indexOfColumn(l),o)}}f._cleanupColumResizing(e);l.focus()},doAutoResizeColumn:function(e,t){var i=e._getVisibleColumns(),o;if(t>=0&&t<i.length){o=i[t];if(!o.getAutoResizable()||!o.getResizable()){return}var n=f._calculateAutomaticColumnWidth.apply(e,[o,t]);if(n){f._resizeColumn(e,t,n)}}},_calculateAutomaticColumnWidth:function(e,i){e=e||this.getColumns()[i];var o=this.$();var n=jQuery("<div>").addClass("sapUiTableHiddenSizeDetector sapUiTableHeaderDataCell sapUiTableDataCell");o.append(n);var l=o.find('td[data-sap-ui-colid = "'+e.getId()+'"]:not([colspan])').filter(function(e,t){return t.style.display!="none"}).children().clone();l.removeAttr("id");var s=n.append(l).width()+4;s=Math.min(s,o.find(".sapUiTableCnt").width());s=Math.max(s+4,t.Column.getMinColumnWidth());n.remove();return s},initColumnTracking:function(e){e.$().find(".sapUiTableCtrlScr, .sapUiTableCtrlScrFixed").on("mousemove",function(e){var t=this.getDomRef("sapUiTableCnt");if(!t||this._bIsColumnResizerMoving){return}var i=e.clientX,o=t.getBoundingClientRect(),n=0,l=this._bRtlMode?1e4:-1e4;for(var s=0;s<this._aTableHeaders.length;s++){var r=this._aTableHeaders[s].getBoundingClientRect();if(this._bRtlMode){if(i<r.right-5&&i>=r.left){n=s;l=r.left-o.left;break}}else{if(i>r.left+5&&i<=r.right){n=s;l=r.right-o.left;break}}}var a=this._getVisibleColumns()[n];if(a&&a.getResizable()){this.$("rsz").css("left",l+"px");this._iLastHoveredVisibleColumnIndex=n}}.bind(e))}};var h={initReordering:function(e,i,o){var n=e.getColumns()[i],s=n.$(),r=e.$();e._disableTextSelection();r.addClass("sapUiTableDragDrop");var a=s.clone();a.find("*").addBack(a).removeAttr("id").removeAttr("data-sap-ui").removeAttr("tabindex");a.attr("id",e.getId()+"-roghost").addClass("sapUiTableColReorderGhost").css({left:-1e4,top:-1e4,"z-index":l.getNextZIndex()});a.toggleClass(t.getContentDensity(e),true);a.appendTo(document.body);e._$ReorderGhost=e.getDomRef("roghost");r.find("td[data-sap-ui-colid='"+n.getId()+"']").toggleClass("sapUiTableColReorderFade",true);var u=jQuery("<div id='"+e.getId()+"-roind' class='sapUiTableColReorderIndicator'><div class='sapUiTableColReorderIndicatorArrow'></div><div class='sapUiTableColReorderIndicatorInner'></div></div>");u.appendTo(e.getDomRef("sapUiTableCnt"));e._$ReorderIndicator=e.getDomRef("roind");e._iDnDColIndex=i;var d=jQuery(document),f=e._isTouchEvent(o);d.on((f?"touchend":"mouseup")+".sapUiColumnMove",h.exitReordering.bind(e));d.on((f?"touchmove":"mousemove")+".sapUiColumnMove",h.onMouseMoveWhileReordering.bind(e))},onMouseMoveWhileReordering:function(e){var i=d._getEventPosition(e,this),o=i.x,n=i.y,l=this._iNewColPos;this._iNewColPos=this._iDnDColIndex;e.preventDefault();var s=h.findColumnForPosition(this,o);if(!s||!s.id){this._iNewColPos=l;return}var r=40,a=this.getDomRef("sapUiTableColHdrScr"),u=jQuery(a),f=a.getBoundingClientRect(),c=u.outerWidth(),C=this._bRtlMode?u.scrollLeftRTL():u.scrollLeft();this._bReorderScroll=false;if(o>f.left+c-r&&C+c<a.scrollWidth){this._bReorderScroll=true;h.doScroll(this,!this._bRtlMode);h.adaptReorderMarkerPosition(this,s,false)}else if(o<f.left+r&&C>0){this._bReorderScroll=true;h.doScroll(this,this._bRtlMode);h.adaptReorderMarkerPosition(this,s,false)}jQuery(this._$ReorderGhost).css({left:o+5,top:n+5});if(this._bReorderScroll||!s){return}if(s.before||s.after&&s.index==this._iDnDColIndex){this._iNewColPos=s.index}else if(s.after&&s.index!=this._iDnDColIndex){this._iNewColPos=s.index+1}if(!t.Column.isColumnMovableTo(this.getColumns()[this._iDnDColIndex],this._iNewColPos)){this._iNewColPos=l}else{h.adaptReorderMarkerPosition(this,s,true)}},exitReordering:function(e){var i=this._iDnDColIndex;var o=this._iNewColPos;var n=jQuery(document);n.off("touchmove.sapUiColumnMove");n.off("touchend.sapUiColumnMove");n.off("mousemove.sapUiColumnMove");n.off("mouseup.sapUiColumnMove");this._bReorderScroll=false;this.$().removeClass("sapUiTableDragDrop");delete this._iDnDColIndex;delete this._iNewColPos;jQuery(this._$ReorderGhost).remove();delete this._$ReorderGhost;jQuery(this._$ReorderIndicator).remove();delete this._$ReorderIndicator;this.$().find(".sapUiTableColReorderFade").removeClass("sapUiTableColReorderFade");this._enableTextSelection();t.Column.moveColumnTo(this.getColumns()[i],o)},findColumnForPosition:function(e,t){var i,o,n,l,s,r,a;for(var u=0;u<e._aTableHeaders.length;u++){i=e._aTableHeaders[u];o=jQuery(i);n=i.getBoundingClientRect();l=o.outerWidth();s={left:n.left,center:n.left+l/2,right:n.left+l,width:l,index:parseInt(o.attr("data-sap-ui-headcolindex")),id:o.attr("data-sap-ui-colid")};r=t>=s.left&&t<=s.center;a=t>=s.center&&t<=s.right;if(r||a){s.before=e._bRtlMode?a:r;s.after=e._bRtlMode?r:a;return s}}return null},doScroll:function(e,t){if(e._mTimeouts.horizontalReorderScrollTimerId){window.clearTimeout(e._mTimeouts.horizontalReorderScrollTimerId);e._mTimeouts.horizontalReorderScrollTimerId=null}if(e._bReorderScroll){var i=t?30:-30;if(e._bRtlMode){i=-1*i}e._mTimeouts.horizontalReorderScrollTimerId=setTimeout(h.doScroll.bind(e,e,t),60);var o=e.$("sapUiTableColHdrScr");var n=e._bRtlMode?"scrollLeftRTL":"scrollLeft";o[n](o[n]()+i)}},adaptReorderMarkerPosition:function(e,t,i){if(!t||!e._$ReorderIndicator){return}var o=t.left-e.getDomRef().getBoundingClientRect().left;if(e._bRtlMode&&t.before||!e._bRtlMode&&t.after){o=o+t.width}jQuery(e._$ReorderIndicator).css({left:o+"px"}).toggleClass("sapUiTableColReorderIndicatorActive",i)}};var c={ROWAREAS:[".sapUiTableRowSelectionCell",".sapUiTableRowActionCell",".sapUiTableCtrlFixed > tbody > .sapUiTableTr",".sapUiTableCtrlScroll > tbody > .sapUiTableTr"],initRowHovering:function(e){var t=e.$();c.ROWAREAS.forEach(function(i){c._initRowHoveringForArea(e,t,i)})},_initRowHoveringForArea:function(e,t,i){t.find(i).on("mouseenter",function(){c._onHover(e,t,i,this)}).on("mouseleave",function(){c._onUnhover(e,t,i,this)})},_onHover:function(e,t,i,o){if(e.getSelectionMode()!==r.None&&e.getSelectionBehavior()!==a.RowSelector||e.hasListeners("cellClick")){var n=t.find(i).index(o);var l=e.getRows()[n];if(l){l._setHovered(true)}}},_onUnhover:function(e,t,i,o){var n=t.find(i).index(o);var l=e.getRows()[n];if(l){l._setHovered(false)}}};var C={onmousedown:function(e){var i=this._getPointerExtension();var n=t.getCell(this,e.target);var l=t.getCellInfo(n);var s=jQuery(e.target);var r;var a;var u;this._getKeyboardExtension().initItemNavigation();if(e.button===0){if(e.target===this.getDomRef("rsz")){e.preventDefault();e.stopPropagation();f.initColumnResizing(this,e)}else if(s.hasClass("sapUiTableColResizer")){var h=s.closest(".sapUiTableHeaderCell").attr("data-sap-ui-colindex");this._iLastHoveredVisibleColumnIndex=this._getVisibleColumns().indexOf(this.getColumns()[h]);f.initColumnResizing(this,e)}else if(l.isOfType(t.CELLTYPE.COLUMNHEADER)){r=this.getColumns()[l.columnIndex];a=r.getAggregation("menu");u=a&&a.isOpen();if(!u){i._bShowMenu=true;this._mTimeouts.delayedMenuTimerId=setTimeout(function(){delete i._bShowMenu},200)}if(this.getEnableColumnReordering()&&!(this._isTouchEvent(e)&&s.hasClass("sapUiTableColDropDown"))){this._getPointerExtension().doReorderColumn(l.columnIndex,e)}}if(o.browser.firefox&&(e.metaKey||e.ctrlKey)||s.closest(".sapUiTableHSb",this.getDomRef()).length===1||s.closest(".sapUiTableVSb",this.getDomRef()).length===1){e.preventDefault()}}if(e.button===2){if(d._skipClick(e,s,l)){i._bShowDefaultMenu=true;return}if(l.isOfType(t.CELLTYPE.COLUMNHEADER)){r=this.getColumns()[l.columnIndex];a=r.getAggregation("menu");u=a&&a.isOpen();if(!u){i._bShowMenu=true}else{i._bHideMenu=true}}else if(l.isOfType(t.CELLTYPE.ANYCONTENTCELL)){i._bShowMenu=true}else{i._bShowDefaultMenu=true}}},onmouseup:function(e){clearTimeout(this._mTimeouts.delayedColumnReorderTimerId)},ondblclick:function(e){if(o.system.desktop&&e.target===this.getDomRef("rsz")){e.preventDefault();f.doAutoResizeColumn(this,this._iLastHoveredVisibleColumnIndex)}},ontap:function(e){clearTimeout(this._mTimeouts.delayedColumnReorderTimerId);if(e.isMarked()){return}var i=jQuery(e.target);var o=t.getCell(this,e.target);var n=t.getCellInfo(o);var l=this.getRows()[n.rowIndex];if(!n.isOfType(t.CELLTYPE.ANY)){return}if(n.isOfType(t.CELLTYPE.COLUMNHEADER)){var r=this._getPointerExtension();if(r._bShowMenu){t.Menu.openContextMenu(this,e);delete r._bShowMenu}}else if(n.isOfType(t.CELLTYPE.COLUMNROWHEADER)){this._getSelectionPlugin().onHeaderSelectorPress()}else if(l&&l.isSummary()){e.preventDefault()}else if(i.hasClass("sapUiTableGroupMenuButton")){t.Menu.openContextMenu(this,e)}else if(i.hasClass("sapUiTableGroupIcon")||i.hasClass("sapUiTableTreeIcon")){l.toggleExpandedState()}else{if(d._skipClick(e,i,n)){return}var a=window.getSelection().toString();if(!e.shiftKey&&a.length>0&&a!=="\n"){s.debug("DOM Selection detected -> Click event on table skipped, Target: "+e.target);return}if(!this._findAndfireCellEvent(this.fireCellClick,e)){d._handleClickSelection(e,o,this)}else{e.preventDefault()}}},oncontextmenu:function(e){var i=this._getPointerExtension();if(i._bShowDefaultMenu){e.setMarked("sapUiTableHandledByPointerExtension");delete i._bShowDefaultMenu}else if(i._bShowMenu){var o=t.Menu.openContextMenu(this,e);if(o){e.preventDefault()}e.setMarked("sapUiTableHandledByPointerExtension");delete i._bShowMenu}else if(i._bHideMenu){e.setMarked("sapUiTableHandledByPointerExtension");e.preventDefault();delete i._bHideMenu}}};var v=e.extend("sap.ui.table.extensions.Pointer",{_init:function(i,o,n){this._delegate=C;t.addDelegate(i,this._delegate,i);i._iLastHoveredVisibleColumnIndex=0;i._bIsColumnResizerMoving=false;i._iFirstReorderableIndex=o==e.TABLETYPES.TREE?1:0;return"PointerExtension"},_attachEvents:function(){var e=this.getTable();if(e){f.initColumnTracking(e);c.initRowHovering(e)}},_detachEvents:function(){var e=this.getTable();if(e){var t=e.$();t.find(".sapUiTableCtrlScr, .sapUiTableCtrlScrFixed").off();t.find(".sapUiTableCtrl > tbody > tr").off();t.find(".sapUiTableRowSelectionCell").off()}},_debug:function(){this._ExtensionHelper=d;this._ColumnResizeHelper=f;this._ReorderHelper=h;this._ExtensionDelegate=C;this._RowHoverHandler=c;this._KNOWNCLICKABLECONTROLS=u},doAutoResizeColumn:function(e){var t=this.getTable();if(t){f.doAutoResizeColumn(t,e)}},doReorderColumn:function(e,i){var o=this.getTable();if(o&&t.Column.isColumnMovable(o.getColumns()[e])){o._mTimeouts.delayedColumnReorderTimerId=setTimeout(function(){h.initReordering(this,e,i)}.bind(o),200)}},destroy:function(){var t=this.getTable();if(t){t.removeEventDelegate(this._delegate)}this._delegate=null;e.prototype.destroy.apply(this,arguments)}});return v});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/extensions/Scrolling", ["./ExtensionBase","../utils/TableUtils","../library","sap/ui/Device","sap/ui/performance/trace/Interaction","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/scrollLeftRTL"],function(e,r,t,o,l,i,jQuery){"use strict";var n=t.SharedDomRef;var a=r.Hook.Keys;var s=r.createWeakMapFacade();var c=1e6;var f=2;var d={HORIZONAL:"HORIZONTAL",VERTICAL:"VERTICAL",BOTH:"BOTH"};function u(e,r){i.debug("sap.ui.table.extensions.Scrolling",e,r)}function p(e,r){var t=true;var o=false;var l=[];var i={cancel:function(){if(this.isCancelled()||!this.isRunning()){return}o=true;for(var e=0;e<l.length;e++){l[e]()}u("Process cancelled: "+r.id)},isCancelled:function(){return o},addCancelListener:function(e){l.push(e)},isRunning:function(){return t},getInfo:function(){return r},onPromiseCreated:function(e){}};var n;u("Process started: "+r.id);if(typeof e==="function"){n=new Promise(function(){e.apply(this,Array.prototype.slice.call(arguments).concat(i))})}else{n=Promise.resolve()}Object.assign(n,i);n.then(function(){if(i.isCancelled()){u("Process finished due to cancellation: "+r.id)}else{u("Process finished: "+r.id)}t=false});i.onPromiseCreated(n);return n}function g(){this.iIndex=0;this.nOffset=0;this.sOffsetType=g.OffsetType.Pixel;this.bIsInitial=true}g.OffsetType={Pixel:"Pixel",Percentage:"Percentage",PercentageOfViewport:"PercentageOfViewport"};g.prototype.getIndex=function(){return this.iIndex};g.prototype.getOffset=function(){return this.nOffset};g.prototype.getOffsetType=function(){return this.sOffsetType};g.prototype.isOffsetInPixel=function(){return this.sOffsetType===g.OffsetType.Pixel};g.prototype.isInitial=function(){return this.bIsInitial};g.prototype.setPosition=function(e,r,t){u("ScrollPosition#setPosition(index: "+e+", offset: "+r+", offsetType: "+t+")");if(!g._isPositiveNumber(e)){return}if(!g._isPositiveNumber(r)){this.nOffset=0}this.setIndex(e);this.setOffset(r,t)};g.prototype.setIndex=function(e){u("ScrollPosition#setIndex(index: "+e+")");if(!g._isPositiveNumber(e)){return}this.bIsInitial=false;this.iIndex=e};g.prototype.setOffset=function(e,r){u("ScrollPosition#setOffset(offset: "+e+", offsetType: "+r+")");if(!g._isPositiveNumber(e)){return}this.bIsInitial=false;this.sOffsetType=r in g.OffsetType?r:g.OffsetType.Pixel;if(this.isOffsetInPixel()){this.nOffset=Math.round(e)}else{this.nOffset=Math.min(e,1)}};g.prototype.scrollRows=function(e){var r=this.getIndex()+e;var t=this.getOffset();if(!this.isOffsetInPixel()||r<0){t=0}this.setPosition(Math.max(0,r),t)};g._isPositiveNumber=function(e){return typeof e==="number"&&!isNaN(e)&&e>=0};var S={UpdateFromFirstVisibleRow:{id:"UpdateFromFirstVisibleRow",rank:6},UpdateFromScrollPosition:{id:"UpdateFromScrollPosition",rank:5},RestoreScrollPosition:{id:"RestoreScrollPosition",rank:4},AdjustToTotalRowCount:{id:"AdjustToTotalRowCount",rank:3},OnRowsUpdated:{id:"OnRowsUpdated",rank:3},UpdateFromScrollbar:{id:"UpdateFromScrollbar",rank:2},UpdateFromViewport:{id:"UpdateFromViewport",rank:1},canStart:function(e,r){var t=s(e).pVerticalScrollUpdateProcess;var o=t?t.getInfo():null;if(t&&t.isRunning()&&o.rank>r.rank){u("Cannot start update process "+r.id+" - A higher-ranked update process is currently running ("+o.id+")",e);return false}return true},start:function(e,r,t){if(!S.canStart(e,r)){return}if(s(e).pVerticalScrollUpdateProcess){s(e).pVerticalScrollUpdateProcess.cancel()}s(e).pVerticalScrollUpdateProcess=new p(t,r)}};var v={onScrollbarScroll:function(e){var r=e.target.scrollLeft;var t=e.target._scrollLeft;l.notifyScrollEvent&&l.notifyScrollEvent(e);if(r!==t){var o=v.getScrollAreas(this);e.target._scrollLeft=r;for(var i=0;i<o.length;i++){var n=o[i];if(n!==e.target&&n.scrollLeft!==r){n.scrollLeft=r;n._scrollLeft=r}}s(this).iHorizontalScrollPosition=r}},restoreScrollPosition:function(e){var r=e._getScrollExtension();var t=r.getHorizontalScrollbar();if(t&&s(e).iHorizontalScrollPosition!==null){var o=v.getScrollAreas(e);for(var l=0;l<o.length;l++){var i=o[l];delete i._scrollLeft}if(t.scrollLeft!==s(e).iHorizontalScrollPosition){t.scrollLeft=s(e).iHorizontalScrollPosition}else{var n=jQuery.Event("scroll");n.target=t;v.onScrollbarScroll.call(e,n)}}},updateScrollbar:function(e){var r=e._getScrollExtension();var t=r.getHorizontalScrollbar();if(!t){return}var l=e._collectTableSizes();var i=e.$();var n=l.tableCtrlScrollWidth;if(o.browser.safari){n=Math.max(n,e._getColumnsWidth(e.getComputedFixedColumnCount()))}var a=n>l.tableCtrlScrWidth;if(a){if(!r.isHorizontalScrollbarVisible()){i.addClass("sapUiTableHScr");t.classList.remove("sapUiTableHidden");if(o.browser.safari){var s=i.find(".sapUiTableCtrlScroll, .sapUiTableColHdrScr > .sapUiTableColHdr");s.outerWidth(n)}}var c=l.tableCtrlFixedWidth;if(i.find(".sapUiTableRowHdrScr").length>0){c+=l.tableRowHdrScrWidth}if(e._bRtlMode){t.style.marginRight=c+"px";t.style.marginLeft=""}else{t.style.marginLeft=c+"px";t.style.marginRight=""}var f=e.getDomRef("hsb-content");if(f){f.style.width=n+"px"}}if(!a&&r.isHorizontalScrollbarVisible()){i.removeClass("sapUiTableHScr");t.classList.add("sapUiTableHidden");if(o.browser.safari){i.find(".sapUiTableCtrlScroll, .sapUiTableColHdr").css("width","")}}},onScrollbarMouseDown:function(e){this._getKeyboardExtension().setActionMode(false)},addEventListeners:function(e){var r=e._getScrollExtension();var t=r.getHorizontalScrollbar();var o=v.getScrollAreas(e);if(!r._onHorizontalScrollEventHandler){r._onHorizontalScrollEventHandler=v.onScrollbarScroll.bind(e)}for(var l=0;l<o.length;l++){o[l].addEventListener("scroll",r._onHorizontalScrollEventHandler)}if(t){if(!r._onHorizontalScrollbarMouseDownEventHandler){r._onHorizontalScrollbarMouseDownEventHandler=v.onScrollbarMouseDown.bind(e)}t.addEventListener("mousedown",r._onHorizontalScrollbarMouseDownEventHandler)}},removeEventListeners:function(e){var r=e._getScrollExtension();var t=r.getHorizontalScrollbar();var o=v.getScrollAreas(e);if(r._onHorizontalScrollEventHandler){for(var l=0;l<o.length;l++){o[l].removeEventListener("scroll",r._onHorizontalScrollEventHandler);delete o[l]._scrollLeft}delete r._onHorizontalScrollEventHandler}if(t&&r._onHorizontalScrollbarMouseDownEventHandler){t.removeEventListener("mousedown",r._onHorizontalScrollbarMouseDownEventHandler);delete r._onHorizontalScrollbarMouseDownEventHandler}},getScrollAreas:function(e){var r=e.getDomRef();var t;if(r){t=Array.prototype.slice.call(e.getDomRef().querySelectorAll(".sapUiTableCtrlScr"))}var o=[e._getScrollExtension().getHorizontalScrollbar()].concat(t);return o.filter(function(e){return e!=null})}};var h={performUpdateFromFirstVisibleRow:function(e,t){u("VerticalScrollingHelper.performUpdateFromFirstVisibleRow",e);S.start(e,S.UpdateFromFirstVisibleRow,function(o,l,i){r.Hook.call(e,a.Signal,"StartTableUpdate");i.onPromiseCreated=function(t){t.finally(function(){r.Hook.call(e,a.Signal,"EndTableUpdate")})};if(t===true){var n=function(){u("VerticalScrollingHelper.performUpdateFromFirstVisibleRow (async: rows update)",e);h._performUpdateFromFirstVisibleRow(e,i).then(o);return false};h.addOnRowsUpdatedPreprocessor(e,n);i.addCancelListener(function(){var r=h.removeOnRowsUpdatedPreprocessor(e,n);if(r){o()}})}else{h._performUpdateFromFirstVisibleRow(e,i).then(o)}})},_performUpdateFromFirstVisibleRow:function(e,r){return h.adjustScrollPositionToFirstVisibleRow(e,r).then(function(){return h.fixTemporaryFirstVisibleRow(e,null,r)}).then(function(){return h.fixScrollPosition(e,r)}).then(function(){return Promise.all([h.scrollViewport(e,r),h.scrollScrollbar(e,r)])})},performUpdateFromScrollPosition:function(e){u("VerticalScrollingHelper.performUpdateFromScrollPosition",e);S.start(e,S.UpdateFromScrollPosition,function(t,o,l){r.Hook.call(e,a.Signal,"StartTableUpdate");l.onPromiseCreated=function(t){t.finally(function(){r.Hook.call(e,a.Signal,"EndTableUpdate")})};h.adjustFirstVisibleRowToScrollPosition(e,null,l).then(function(){if(l.isCancelled()){return}var t=s(e).oVerticalScrollPosition;u("VerticalScrollingHelper.performUpdateFromScrollPosition (async: firstVisibleRow update)",e);if(t.getIndex()>e.getFirstVisibleRow()){t.setIndex(e.getFirstVisibleRow());if(r.isVariableRowHeightEnabled(e)){t.setOffset(1,g.OffsetType.Percentage)}else{t.setOffset(0)}}}).then(function(){return h.fixScrollPosition(e,l)}).then(function(){return Promise.all([h.scrollViewport(e,l),h.scrollScrollbar(e,l)])}).then(t)})},performUpdateFromScrollbar:function(e){u("VerticalScrollingHelper.performUpdateFromScrollbar",e);clearTimeout(s(e).mTimeouts.largeDataScrolling);delete s(e).mTimeouts.largeDataScrolling;S.start(e,S.UpdateFromScrollbar,function(t,o,l){r.Hook.call(e,a.Signal,"StartTableUpdate");l.onPromiseCreated=function(t){t.finally(function(){r.Hook.call(e,a.Signal,"EndTableUpdate")})};e._getKeyboardExtension().setActionMode(false);if(e._bLargeDataScrolling){s(e).mTimeouts.largeDataScrolling=setTimeout(function(){delete s(e).mTimeouts.largeDataScrolling;if(e._getScrollExtension().getVerticalScrollbar()!=null){u("VerticalScrollingHelper.performUpdateFromScrollbar (async: large data scrolling)",e);h._performUpdateFromScrollbar(e,l).then(t)}else{u("VerticalScrollingHelper.performUpdateFromScrollbar (async: large data scrolling): No scrollbar",e)}},300);l.addCancelListener(function(){if(s(e).mTimeouts.largeDataScrolling!=null){clearTimeout(s(e).mTimeouts.largeDataScrolling);delete s(e).mTimeouts.largeDataScrolling;t()}})}else{h._performUpdateFromScrollbar(e,l).then(t)}})},_performUpdateFromScrollbar:function(e,r){return h.adjustScrollPositionToScrollbar(e,r).then(function(){return h.adjustFirstVisibleRowToScrollPosition(e,null,r)}).then(function(){return h.fixScrollPosition(e,r)}).then(function(){return h.scrollViewport(e,r)})},performUpdateFromViewport:function(e){u("VerticalScrollingHelper.performUpdateFromViewport",e);S.start(e,S.UpdateFromViewport,function(t,o,l){r.Hook.call(e,a.Signal,"StartTableUpdate");l.onPromiseCreated=function(t){t.finally(function(){r.Hook.call(e,a.Signal,"EndTableUpdate")})};h.adjustScrollPositionToViewport(e,l).then(function(){return h.adjustFirstVisibleRowToScrollPosition(e,true,l)}).then(function(){return h.scrollScrollbar(e,l)}).then(t)})},onScrollbarScroll:function(e){l.notifyScrollEvent&&l.notifyScrollEvent(e);var r=e.target.scrollTop;var t=e.target._scrollTop;var o=r!==t;delete e.target._scrollTop;if(r===0&&!e.target.isConnected){u("VerticalScrollingHelper.onScrollbarScroll: Scrollbar is not connected with the DOM",this)}else if(o){u("VerticalScrollingHelper.onScrollbarScroll: Scroll position changed to "+r+" by interaction",this);h.performUpdateFromScrollbar(this)}else{u("VerticalScrollingHelper.onScrollbarScroll: Scroll position changed to "+r+" by API",this)}},onViewportScroll:function(e){if(!S.canStart(this,S.UpdateFromViewport)){return}var r=e.target.scrollTop;var t=e.target._scrollTop;delete e.target._scrollTop;if(r!==t){u("VerticalScrollingHelper.onViewportScroll: Scroll position changed to "+r+" by interaction",this);h.performUpdateFromViewport(this)}else{u("VerticalScrollingHelper.onViewportScroll: Scroll position changed to "+r+" by API",this)}},adjustFirstVisibleRowToScrollPosition:function(e,r,t){if(t&&t.isCancelled()){return Promise.resolve()}r=r===true;var o=s(e).oVerticalScrollPosition;var l=o.getOffsetType()===g.OffsetType.PercentageOfViewport;var i=o.getIndex();var n=e.getFirstVisibleRow();var a=h.isIndexInBuffer(e,i);var c=a||l;u("VerticalScrollingHelper.adjustFirstVisibleRowToScrollPosition:"+' Set "firstVisibleRow" from '+n+" to "+i,e);var f=e._setFirstVisibleRowIndex(i,{onScroll:true,suppressEvent:c,suppressRendering:r});if(!f){if(c){return h.fixTemporaryFirstVisibleRow(e,true,t)}return Promise.resolve()}return new Promise(function(r){var o=function(o){u("VerticalScrollingHelper.adjustFirstVisibleRowToScrollPosition (async: rows updated):"+" Reason "+o.getParameters().reason,this);if(c){h.fixTemporaryFirstVisibleRow(e,true,t).then(r)}else{r()}return false};h.addOnRowsUpdatedPreprocessor(e,o);if(t){t.addCancelListener(function(){var t=h.removeOnRowsUpdatedPreprocessor(e,o);if(t){r()}})}})},fixTemporaryFirstVisibleRow:function(e,r,t){if(t&&t.isCancelled()){return Promise.resolve()}r=r===true;var o=s(e).oVerticalScrollPosition;var l=o.getOffsetType()===g.OffsetType.PercentageOfViewport;var i=o.getIndex();var n=h.isIndexInBuffer(e,i);var a=n||l;if(!a){u("VerticalScrollingHelper.fixTemporaryFirstVisibleRow: Aborted - The index is already final",e);return Promise.resolve()}var c=i;var f=h.getScrollRangeOfViewport(e);var d=e._getMaxFirstRenderedRowIndex();var p=e._aRowHeights;var S;u("VerticalScrollingHelper.fixTemporaryFirstVisibleRow",e);if(l){var v=f*o.getOffset();if(n){c=d}for(S=0;S<p.length;S++){var b=v-p[S];if(b>=0){v=b;c++}else{break}}}else if(n){var T=Math.max(0,Math.min(p.length-1,i-d));var m=0;for(S=0;S<T;S++){m+=p[S];if(m>f){c=d+S;break}}}if(i!==c||r){u('VerticalScrollingHelper.fixTemporaryFirstVisibleRow: Set "firstVisibleRow" to '+c,e);e._setFirstVisibleRowIndex(c,{onScroll:true,forceEvent:r,suppressRendering:true})}return Promise.resolve()},adjustScrollPositionToFirstVisibleRow:function(e,r){if(r&&r.isCancelled()){return Promise.resolve()}u("VerticalScrollingHelper.adjustScrollPositionToFirstVisibleRow",e);s(e).oVerticalScrollPosition.setPosition(e.getFirstVisibleRow());return Promise.resolve()},adjustScrollPositionToScrollbar:function(e,t){if(t&&t.isCancelled()){return Promise.resolve()}var o=s(e).oVerticalScrollPosition;var l=h.getScrollPositionOfScrollbar(e);var i=h.getScrollRange(e);var n=h.getScrollRangeRowFraction(e);var a=0;var c=0;var f=g.OffsetType.Percentage;var d;u("VerticalScrollingHelper.adjustScrollPositionToScrollbar",e);if(r.isVariableRowHeightEnabled(e)){if(h.isScrollPositionOfScrollbarInBuffer(e)){var p=h.getScrollRangeBuffer(e);var S=i-p;var v=l-S;var b=v/p;a=e._getMaxFirstRenderedRowIndex();if(h.isIndexInBuffer(e,o.getIndex())){var T=h.getScrollRangeOfViewport(e);var m=T*b;var V=e._aRowHeights;for(var w=0;w<V.length;w++){var R=m-V[w];if(R>=0){m=R;a++}else{c=Math.round(m);f=g.OffsetType.Pixel;break}}}else{c=b;f=g.OffsetType.PercentageOfViewport}}else{d=l/n;a=Math.floor(d);c=d-a}}else{var P=i-l;var H=P<1;if(H){a=e._getMaxFirstVisibleRowIndex();c=0;f=g.OffsetType.Pixel}else{d=l/n;a=Math.floor(d);c=d-a}}o.setPosition(a,c,f);return Promise.resolve()},adjustScrollPositionToViewport:function(e,r){if(r&&r.isCancelled()){return Promise.resolve()}var t=s(e).oVerticalScrollPosition;var o=e._aRowHeights;var l=e._getFirstRenderedRowIndex();var i=0;var n=h.getScrollPositionOfViewport(e);u("VerticalScrollingHelper.adjustScrollPositionToViewport",e);for(var a=0;a<o.length;a++){var c=n-o[a];if(c>=0){n=c;l++}else{i=Math.round(n);break}}t.setPosition(l,i);return Promise.resolve()},fixScrollPosition:function(e,t){if(t&&t.isCancelled()){return Promise.resolve()}var o=s(e).oVerticalScrollPosition;var l=e.getDomRef("tableCCnt");var i=h.getScrollRangeOfViewport(e);var n=e._aRowHeights;if(!l||!e.getBinding()){u("VerticalScrollingHelper.fixScrollPosition: Aborted - Viewport or binding not available",e);return Promise.resolve()}u("VerticalScrollingHelper.fixScrollPosition",e);var a=o.getIndex();var c=o.getOffset();var f=0;var d;var p=e._getFirstRenderedRowIndex();switch(o.getOffsetType()){case g.OffsetType.Pixel:case g.OffsetType.Percentage:var S=o.getIndex();var v=0;var b=o.getOffsetType();if(h.isIndexInBuffer(e,S)){var T=0;f=Math.max(0,Math.min(n.length-1,S-p));for(d=0;d<f;d++){T+=n[d];if(T>i){a=p+d;c=i-v;b=g.OffsetType.Pixel;f=d;break}else{v=T}}}if(b===g.OffsetType.Pixel){c=Math.min(c,n[f])}else{c=n[f]*c}v+=c;if(v>i&&r.isVariableRowHeightEnabled(e)){c-=v-i}break;case g.OffsetType.PercentageOfViewport:var m=i*o.getOffset();for(d=0;d<n.length;d++){var V=m-n[d];if(V>=0){m=V;f++}else{a=p+f;c=Math.round(m);break}}break;default:}o.setPosition(a,c);return Promise.resolve()},scrollViewport:function(e,t){if(t&&t.isCancelled()){return Promise.resolve()}if(!r.isVariableRowHeightEnabled(e)){u("VerticalScrollingHelper.scrollViewport: Aborted - Variable row height not enabled",e);return Promise.resolve()}var o=s(e).oVerticalScrollPosition;var l=e.getDomRef("tableCCnt");var i=h.getScrollRangeOfViewport(e);var n=e._aRowHeights;var a=0;if(i===0){u("VerticalScrollingHelper.scrollViewport: Aborted - No overflow in viewport",e);l.scrollTop=a;l._scrollTop=l.scrollTop;return Promise.resolve()}u("VerticalScrollingHelper.scrollViewport",e);switch(o.getOffsetType()){case g.OffsetType.Pixel:var c=o.getIndex();var f=Math.max(0,Math.min(n.length-1,c-e._getFirstRenderedRowIndex()));for(var d=0;d<f;d++){a+=n[d]}a+=o.getOffset();break;default:u("VerticalScrollingHelper.scrollViewport: The viewport can only be scrolled if the offset is in pixel",e);return Promise.resolve()}u("VerticalScrollingHelper.scrollViewport: Scroll from "+l.scrollTop+" to "+a,e);l.scrollTop=a;l._scrollTop=l.scrollTop;return Promise.resolve()},scrollScrollbar:function(e,r){if(r&&r.isCancelled()){return Promise.resolve()}var t=s(e).oVerticalScrollPosition;var o=t.getIndex();var l=h.getScrollRangeBuffer(e);var i=h.getScrollRange(e);var n=i-l;var a=0;var c=0;var f=h.getScrollRangeOfViewport(e);var d=e._aRowHeights;var p;u("VerticalScrollingHelper.scrollScrollbar",e);if(i===0||d.length===0){u("VerticalScrollingHelper.scrollScrollbar: No scrollable content",e);return Promise.resolve()}switch(t.getOffsetType()){case g.OffsetType.Pixel:if(h.isIndexInBuffer(e,o)){var S=0;p=Math.max(0,Math.min(d.length-1,o-e._getMaxFirstRenderedRowIndex()));for(var v=0;v<p;v++){S+=d[v]}S+=Math.min(d[p],t.getOffset());var b=Math.min(S/f,1);var T=l*b;a=n+T}else{var m=h.getScrollRangeRowFraction(e);a=o*m;p=Math.max(0,Math.min(d.length-1,o-e._getFirstRenderedRowIndex()));a+=m*Math.min(t.getOffset()/d[p],1)}break;default:u("VerticalScrollingHelper.scrollViewport: The scrollbar can only be scrolled if the offset is in pixel",e);return Promise.resolve()}if(a>0&&a<.5){c=1}else if(a>=i-.5&&a<i){c=i-1}else{c=Math.round(a)}var V=e._getScrollExtension().getVerticalScrollbar();if(V){u("VerticalScrollingHelper.scrollScrollbar: Scroll from "+V.scrollTop+" to "+c,e);V.scrollTop=c;V._scrollTop=V.scrollTop}else{u("VerticalScrollingHelper.scrollScrollbar: Not scrolled - No scrollbar available",e)}return Promise.resolve()},getScrollRange:function(e){var r=e._getScrollExtension();var t=r.getVerticalScrollHeight()-r.getVerticalScrollbarHeight();return Math.max(0,t)},getScrollRangeBuffer:function(e){if(!r.isVariableRowHeightEnabled(e)){return 0}return f*e._getBaseRowHeight()},getScrollPositionOfScrollbar:function(e){var r=e._getScrollExtension();if(r.isVerticalScrollbarVisible()){return r.getVerticalScrollbar().scrollTop}else{return 0}},getScrollPositionOfViewport:function(e){var r=e?e.getDomRef("tableCCnt"):null;return r?r.scrollTop:0},getScrollRangeRowFraction:function(e){var t=e._getScrollExtension();var o=e._getTotalRowCount()-e._getRowCounts()._fullsize;var l;if(r.isVariableRowHeightEnabled(e)){l=h.getScrollRange(e)-h.getScrollRangeBuffer(e);var i=t.getVerticalScrollHeight()===c;if(!i){l+=e._getBaseRowHeight()}}else{l=h.getScrollRange(e)}return l/Math.max(1,o)},isScrollPositionOfScrollbarInBuffer:function(e){if(!r.isVariableRowHeightEnabled(e)){return false}var t=h.getScrollRange(e);var o=h.getScrollPositionOfScrollbar(e);var l=h.getScrollRangeBuffer(e);return t-o<=l},isIndexInBuffer:function(e,t){if(!r.isVariableRowHeightEnabled(e)){return false}return t>=e._getMaxFirstRenderedRowIndex()},getScrollRangeOfViewport:function(e){if(!e||!e._aRowHeights){return 0}var r=e._aRowHeights;var t=e._getBaseRowHeight()*e._getRowCounts()._fullsize;if(e._getRowCounts()._fullsize>=e._getTotalRowCount()){r=r.slice(0,e._getTotalRowCount())}var o=r.reduce(function(e,r){return e+r},0)-t;if(o>0){o=Math.ceil(o)}return Math.max(0,o)},addOnRowsUpdatedPreprocessor:function(e,r){s(e).aOnRowsUpdatedPreprocessors.push(r)},removeOnRowsUpdatedPreprocessor:function(e,r){if(!r){s(e).aOnRowsUpdatedPreprocessors=[];return false}var t=s(e).aOnRowsUpdatedPreprocessors.indexOf(r);if(t>-1){s(e).aOnRowsUpdatedPreprocessors.splice(t,1);return true}return false},onRowsUpdated:function(e){u("VerticalScrollingHelper.onRowsUpdated: Reason "+e.getParameters().reason,this);h.updateScrollbarVisibility(this);if(s(this).aOnRowsUpdatedPreprocessors.length>0){u("VerticalScrollingHelper.onRowsUpdated (preprocessors)",this);var t=s(this).aOnRowsUpdatedPreprocessors.reduce(function(r,t){var o=t.call(this,e);return!(r&&!o)},true);h.removeOnRowsUpdatedPreprocessor(this);if(!t){u("VerticalScrollingHelper.onRowsUpdated (preprocessors): Default prevented",this);return}}if(!r.isVariableRowHeightEnabled(this)){u("VerticalScrollingHelper.onRowsUpdated: Aborted - Variable row heights not enabled",this);return}var o=this;S.start(this,S.OnRowsUpdated,function(e,t,l){r.Hook.call(o,a.Signal,"StartTableUpdate");l.onPromiseCreated=function(e){e.finally(function(){r.Hook.call(o,a.Signal,"EndTableUpdate")})};h.fixScrollPosition(o,l).then(function(){return Promise.all([h.adjustFirstVisibleRowToScrollPosition(o,true,l),h.scrollViewport(o,l),h.scrollScrollbar(o,l)])}).then(e)})},restoreScrollPosition:function(e,t){u("VerticalScrollingHelper.restoreScrollPosition",e);S.start(e,S.RestoreScrollPosition,function(o,l,i){r.Hook.call(e,a.Signal,"StartTableUpdate");i.onPromiseCreated=function(t){t.then(function(){if(!i.isCancelled()){h._restoreScrollPosition(e)}}).finally(function(){r.Hook.call(e,a.Signal,"EndTableUpdate")})};if(t!==true){o();return}var n=function(){u("VerticalScrollingHelper.restoreScrollPosition (async: rows updated)",e);o();return false};h.addOnRowsUpdatedPreprocessor(e,n);i.addCancelListener(function(){var r=h.removeOnRowsUpdatedPreprocessor(e,n);if(r){o()}})})},_restoreScrollPosition:function(e){var r=s(e).oVerticalScrollPosition;var t=r.isInitial();u("VerticalScrollingHelper.restoreScrollPosition: "+"Scroll position is"+(t?" ":" not ")+"initial",e);if(t){h.performUpdateFromFirstVisibleRow(e)}else{h.performUpdateFromScrollPosition(e)}},onTotalRowCountChanged:function(){h.adjustToTotalRowCount(this)},adjustToTotalRowCount:function(e){var t=e._getScrollExtension();u("VerticalScrollingHelper.adjustToTotalRowCount",e);h.updateScrollbarVisibility(e);v.updateScrollbar(e);t.updateVerticalScrollHeight();S.start(e,S.AdjustToTotalRowCount,function(t,o,l){r.Hook.call(e,a.Signal,"StartTableUpdate");l.onPromiseCreated=function(t){t.then(function(){if(l.isCancelled()||s(e).oVerticalScrollPosition.isInitial()){return}h.performUpdateFromScrollPosition(e)}).finally(function(){r.Hook.call(e,a.Signal,"EndTableUpdate")})};if(s(e).oVerticalScrollPosition.isInitial()){t()}else{var i=function(){u("VerticalScrollingHelper.adjustToTotalRowCount (async: rows updated)",e);t();return false};h.addOnRowsUpdatedPreprocessor(e,i);l.addCancelListener(function(){var r=h.removeOnRowsUpdatedPreprocessor(e,i);if(r){t()}})}})},onUpdateTableSizes:function(e){h.updateScrollbarVisibility(this);v.updateScrollbar(this)},updateScrollbarVisibility:function(e){var r=e._getScrollExtension();var t=r.getVerticalScrollbar();var o=e?e.getDomRef():null;if(!t||!o){return}var l=r.isVerticalScrollbarRequired();o.classList.toggle("sapUiTableVScr",l&&!r.isVerticalScrollbarExternal());t.parentElement.classList.toggle("sapUiTableHidden",!l)},addEventListeners:function(e){var r=e._getScrollExtension();var t=h.getScrollAreas(e);var o=e.getDomRef("tableCCnt");if(!r._onVerticalScrollEventHandler){r._onVerticalScrollEventHandler=h.onScrollbarScroll.bind(e)}for(var l=0;l<t.length;l++){t[l].addEventListener("scroll",r._onVerticalScrollEventHandler)}if(o){if(!r._onViewportScrollEventHandler){r._onViewportScrollEventHandler=h.onViewportScroll.bind(e)}o.addEventListener("scroll",r._onViewportScrollEventHandler)}e.attachRowsUpdated(h.onRowsUpdated)},removeEventListeners:function(e){var r=e._getScrollExtension();var t=h.getScrollAreas(e);var o=e.getDomRef("tableCCnt");if(r._onVerticalScrollEventHandler){for(var l=0;l<t.length;l++){t[l].removeEventListener("scroll",r._onVerticalScrollEventHandler)}delete r._onVerticalScrollEventHandler}if(o&&r._onViewportScrollEventHandler){o.removeEventListener("scroll",r._onViewportScrollEventHandler);delete r._onViewportScrollEventHandler}e.detachRowsUpdated(h.onRowsUpdated)},getScrollAreas:function(e){var r=[e._getScrollExtension().getVerticalScrollbar()];return r.filter(function(e){return e!=null})}};var b={onMouseWheelScrolling:function(e,t){var o=this._getScrollExtension();var l=Math.abs(t.deltaY)>Math.abs(t.deltaX);var i=l?t.deltaY:t.deltaX;var n=l&&t.shiftKey||!l;var a=i>0;var c=false;if(i===0){return}if(n&&(e.scrollDirection===d.HORIZONAL||e.scrollDirection===d.BOTH)){var f=o.getHorizontalScrollbar();if(t.deltaMode!==window.WheelEvent.DOM_DELTA_PIXEL){var u=r.Column.getMinColumnWidth();i=a?u:-u}if(a){c=f.scrollLeft===f.scrollWidth-f.offsetWidth}else{c=f.scrollLeft===0}if(o.isHorizontalScrollbarVisible()&&!c){t.preventDefault();t.stopPropagation();this._getKeyboardExtension().setActionMode(false);f.scrollLeft=f.scrollLeft+i}}else if(!n&&(e.scrollDirection===d.VERTICAL||e.scrollDirection===d.BOTH)){var p=o.getVerticalScrollbar();var g=s(this).oVerticalScrollPosition;if(a){c=p.scrollTop===p.scrollHeight-p.offsetHeight}else{c=p.scrollTop===0}if(!o.isVerticalScrollbarVisible()||c){return}t.preventDefault();t.stopPropagation();if(t.deltaMode===window.WheelEvent.DOM_DELTA_PIXEL){var S=i/this._getDefaultRowHeight();if(S>=0){g.scrollRows(Math.max(1,Math.floor(S)))}else{g.scrollRows(Math.min(-1,Math.ceil(S)))}}else if(t.deltaMode===window.WheelEvent.DOM_DELTA_LINE){g.scrollRows(i)}else if(t.deltaMode===window.WheelEvent.DOM_DELTA_PAGE){g.scrollRows(i*this._getRowCounts()._scrollSize)}this._getKeyboardExtension().setActionMode(false);h.performUpdateFromScrollPosition(this)}},onTouchStart:function(e,r){if(r.type==="touchstart"||r.pointerType==="touch"){var t=this._getScrollExtension();var o=t.getHorizontalScrollbar();var l=t.getVerticalScrollbar();var i=r.touches?r.touches[0]:r;s(this).mTouchSessionData={initialPageX:i.pageX,initialPageY:i.pageY,initialScrollTop:l?l.scrollTop:0,initialScrollLeft:o?o.scrollLeft:0,initialScrolledToEnd:null,touchMoveDirection:null}}},onTouchMoveScrolling:function(e,r){if(r.type!=="touchmove"&&r.pointerType!=="touch"){return}var t=this._getScrollExtension();var o=s(this).mTouchSessionData;if(!o){return}var l=r.touches?r.touches[0]:r;var i=l.pageX-o.initialPageX;var n=l.pageY-o.initialPageY;var a=false;if(!o.touchMoveDirection){if(i===0&&n===0){return}o.touchMoveDirection=Math.abs(i)>Math.abs(n)?"horizontal":"vertical"}switch(o.touchMoveDirection){case"horizontal":var c=t.getHorizontalScrollbar();if(c&&(e.scrollDirection===d.HORIZONAL||e.scrollDirection===d.BOTH)){this._getKeyboardExtension().setActionMode(false);if(o.initialScrolledToEnd==null){if(i<0){o.initialScrolledToEnd=c.scrollLeft===c.scrollWidth-c.offsetWidth}else{o.initialScrolledToEnd=c.scrollLeft===0}}if(!o.initialScrolledToEnd){c.scrollLeft=o.initialScrollLeft-i;a=true}}break;case"vertical":var f=t.getVerticalScrollbar();if(f&&(e.scrollDirection===d.VERTICAL||e.scrollDirection===d.BOTH)){this._getKeyboardExtension().setActionMode(false);if(o.initialScrolledToEnd==null){if(n<0){o.initialScrolledToEnd=f.scrollTop===f.scrollHeight-f.offsetHeight}else{o.initialScrolledToEnd=f.scrollTop===0}}if(!o.initialScrolledToEnd){f.scrollTop=o.initialScrollTop-n;a=true}}break;default:}if(a){r.preventDefault()}},addEventListeners:function(e){var r=e._getScrollExtension();var t=b.getEventListenerTargets(e);r._mMouseWheelEventListener=this.addMouseWheelEventListener(t,e,{scrollDirection:d.BOTH});r._mTouchEventListener=this.addTouchEventListener(t,e,{scrollDirection:d.BOTH})},addMouseWheelEventListener:function(e,r,t){var o=b.onMouseWheelScrolling.bind(r,t);for(var l=0;l<e.length;l++){e[l].addEventListener("wheel",o)}return{wheel:o}},addTouchEventListener:function(e,r,t){var l=b.onTouchStart.bind(r,t);var i=b.onTouchMoveScrolling.bind(r,t);var n={};for(var a=0;a<e.length;a++){if(o.support.pointer&&o.system.desktop){e[a].addEventListener("pointerdown",l);e[a].addEventListener("pointermove",i,o.browser.chrome?{passive:true}:false)}else if(o.support.touch){e[a].addEventListener("touchstart",l);e[a].addEventListener("touchmove",i)}}if(o.support.pointer&&o.system.desktop){n={pointerdown:l,pointermove:i}}else if(o.support.touch){n={touchstart:l,touchmove:i}}return n},removeEventListeners:function(e){var r=e._getScrollExtension();var t=b.getEventListenerTargets(e);function o(e,r){for(var t in r){var o=r[t];if(o){e.removeEventListener(t,o)}}}for(var l=0;l<t.length;l++){o(t[l],r._mMouseWheelEventListener);o(t[l],r._mTouchEventListener)}delete r._mMouseWheelEventListener;delete r._mTouchEventListener},getEventListenerTargets:function(e){var r=[e.getDomRef("tableCCnt")];return r.filter(function(e){return e!=null})}};var T={onBeforeRendering:function(e){this._getScrollExtension()._clearCache()},onAfterRendering:function(e){var r=this._getScrollExtension();var t=e!=null&&e.isMarked("renderRows");if(t){r.updateVerticalScrollbarHeight();r.updateVerticalScrollHeight()}h.restoreScrollPosition(this,this.getBinding()!=null);v.restoreScrollPosition(this)},onfocusin:function(e){var t;var l=r.getCellInfo(e.target);var i=this._getScrollExtension().getHorizontalScrollbar();if(l.isOfType(r.CELLTYPE.DATACELL)){t=this.getDomRef("sapUiTableCtrlScr")}else if(l.isOfType(r.CELLTYPE.COLUMNHEADER)){t=this.getDomRef("sapUiTableColHdrScr")}if(t&&i&&l.columnIndex>=this.getComputedFixedColumnCount()){var n=jQuery(i);var s=l.cell[0];var c=this._bRtlMode?n.scrollLeftRTL():i.scrollLeft;var f=t.clientWidth;var d=s.offsetLeft;var u=d+s.offsetWidth;var p=d-c;var g=u-f-c;var S;if(p<0&&g<0){S=c+p}else if(g>0&&p>0){S=c+g}if(S!=null){if(this._bRtlMode){n.scrollLeftRTL(S)}else{i.scrollLeft=S}}}var v=r.getParentCell(this,e.target);if(v){var h=this;var b=function(){var e=v.find(".sapUiTableCellInner");if(e.length>0){if(h._bRtlMode){e.scrollLeftRTL(e[0].scrollWidth-e[0].clientWidth)}else{e[0].scrollLeft=0}e[0].scrollTop=0}r.Hook.call(h,a.Signal,"EndFocusHandling");r.Hook.call(h,a.Signal,"EndTableUpdate")};r.Hook.call(this,a.Signal,"StartTableUpdate");r.Hook.call(this,a.Signal,"StartFocusHandling");Promise.resolve().then(function(){if(o.browser.safari){window.setTimeout(b,0)}else{b()}})}}};var m=e.extend("sap.ui.table.extensions.Scrolling",{_init:function(e,t,o){var l=s(e);l.oHorizontalScrollbar=null;l.iHorizontalScrollPosition=null;l.oVerticalScrollbar=null;l.oVerticalScrollPosition=new g(e);l.pVerticalScrollUpdateProcess=null;l.oExternalVerticalScrollbar=null;l.bIsVerticalScrollbarExternal=false;l.mTimeouts={};l.mAnimationFrames={};l.mTouchSessionData=null;l.aOnRowsUpdatedPreprocessors=[];r.addDelegate(e,T,e);return"ScrollExtension"},_attachEvents:function(){var e=this.getTable();v.addEventListeners(e);h.addEventListeners(e);b.addEventListeners(e);r.Hook.register(e,r.Hook.Keys.Table.TotalRowCountChanged,h.onTotalRowCountChanged,e);r.Hook.register(e,r.Hook.Keys.Table.UpdateSizes,h.onUpdateTableSizes,e)},_detachEvents:function(){var e=this.getTable();v.removeEventListeners(e);h.removeEventListeners(e);b.removeEventListeners(e);r.Hook.deregister(e,r.Hook.Keys.Table.TotalRowCountChanged,h.onTotalRowCountChanged,e);r.Hook.deregister(e,r.Hook.Keys.Table.UpdateSizes,h.onUpdateTableSizes,e)},destroy:function(){var t=this.getTable();this._clearCache();if(t){r.removeDelegate(t,T);if(s(t).pVerticalScrollUpdateProcess){s(t).pVerticalScrollUpdateProcess.cancel();s(t).pVerticalScrollUpdateProcess=null}}e.prototype.destroy.apply(this,arguments)}});m.prototype.scrollVertically=function(e,r){var t=this.getTable();if(!t){return}var o=t._getRowCounts();var l=t._getFirstRenderedRowIndex();var i=r===true?o.scrollable:1;if(e===true){s(t).oVerticalScrollPosition.setPosition(l+i,1,g.OffsetType.PercentageOfViewport)}else{s(t).oVerticalScrollPosition.setPosition(Math.max(0,l-i))}h.performUpdateFromScrollPosition(t)};m.prototype.scrollVerticallyMax=function(e){var r=this.getTable();if(!r){return}if(e===true){s(r).oVerticalScrollPosition.setPosition(r._getMaxFirstRenderedRowIndex(),1,g.OffsetType.PercentageOfViewport)}else{s(r).oVerticalScrollPosition.setPosition(0)}h.performUpdateFromScrollPosition(r)};m.prototype.getHorizontalScrollbar=function(){var e=this.getTable();if(!e){return null}if(!e._bInvalid&&!s(e).oHorizontalScrollbar){s(e).oHorizontalScrollbar=e.getDomRef(n.HorizontalScrollBar)}return s(e).oHorizontalScrollbar};m.prototype.getVerticalScrollbar=function(){var e=this.getTable();var r=this.isVerticalScrollbarExternal();if(!e){return null}if(!e._bInvalid&&!s(e).oVerticalScrollbar){s(e).oVerticalScrollbar=e.getDomRef(n.VerticalScrollBar);if(!s(e).oVerticalScrollbar&&r){s(e).oVerticalScrollbar=s(e).oExternalVerticalScrollbar}}var t=s(e).oVerticalScrollbar;if(t&&!r&&!t.isConnected){return null}return t};m.prototype.isHorizontalScrollbarVisible=function(){var e=this.getHorizontalScrollbar();return e!=null&&!e.classList.contains("sapUiTableHidden")};m.prototype.isVerticalScrollbarVisible=function(){var e=this.getVerticalScrollbar();return e!=null&&!e.parentElement.classList.contains("sapUiTableHidden")};m.prototype.isVerticalScrollbarExternal=function(){var e=this.getTable();return e?s(e).bIsVerticalScrollbarExternal:false};m.prototype.markVerticalScrollbarAsExternal=function(e){var r=this.getTable();if(r&&e){s(r).bIsVerticalScrollbarExternal=true;s(r).oExternalVerticalScrollbar=e}};m.prototype.updateVerticalScrollbarHeight=function(){var e=this.getTable();var r=this.getVerticalScrollbar();if(!e||!r){return}r.style.maxHeight=this.getVerticalScrollbarHeight()+"px";r._scrollTop=r.scrollTop};m.prototype.getVerticalScrollbarHeight=function(){var e=this.getTable();if(!e){return 0}return e._getRowCounts()._scrollSize*e._getBaseRowHeight()};m.prototype.updateVerticalScrollPosition=function(e){var r=this.getTable();if(!r){return}e=e===true;if(e||r.getBinding()){h.performUpdateFromFirstVisibleRow(r,e)}else{h.adjustScrollPositionToFirstVisibleRow(r)}};m.prototype.restoreVerticalScrollPosition=function(){h.restoreScrollPosition(this.getTable())};m.prototype.updateVerticalScrollHeight=function(){var e=this.getVerticalScrollbar();var r=e?e.firstChild:null;if(!r){return}r.style.height=this.getVerticalScrollHeight()+"px";e._scrollTop=e.scrollTop};m.prototype.getVerticalScrollHeight=function(e){var t=this.getTable();if(!t){return 0}var o=t._getTotalRowCount();var l=t._getRowCounts();var i=Math.max(o,l.count);var n=t._getBaseRowHeight();var a;if(r.isVariableRowHeightEnabled(t)){a=n*(i-1)+h.getScrollRangeBuffer(t)}else{a=n*i}if(e===true){return a}else{return Math.min(c,a)}};m.prototype.isVerticalScrollbarRequired=function(){var e=this.getTable();if(!e){return false}return r.isVariableRowHeightEnabled(e)&&h.getScrollRangeOfViewport(e)>0||e._getTotalRowCount()>e._getRowCounts()._fullsize};m.prototype.registerForMouseWheel=function(r,t){var o=this.getTable();if(e.isEnrichedWith(o,"sap.ui.table.extensions.Synchronization")){return b.addMouseWheelEventListener(r,o,t)}else{i.error("This method can only be used with synchronization enabled.",o,"sap.ui.table.extensions.Scrolling#registerForMouseWheel");return null}};m.prototype.registerForTouch=function(r,t){var o=this.getTable();if(e.isEnrichedWith(o,"sap.ui.table.extensions.Synchronization")){return b.addTouchEventListener(r,o,t)}else{i.error("This method can only be used with synchronization enabled.",o,"sap.ui.table.extensions.Scrolling#registerForTouch");return null}};m.prototype._clearCache=function(){var e=this.getTable();if(!e){return}s(e).oVerticalScrollbar=null;s(e).oHorizontalScrollbar=null};m.ScrollDirection=d;return m});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/extensions/ScrollingIOS", ["./ExtensionBase","../utils/TableUtils"],function(t,e){"use strict";var r={onAfterRendering:function(){this.attachScrollbar()}};var o=t.extend("sap.ui.table.extensions.ScrollingIOS",{_init:function(t){e.addDelegate(t,r,this);this.attachScrollbar();return"ScrollIOSExtension"},destroy:function(){var o=this.getTable();e.removeDelegate(o,r);clearTimeout(this._iUpdateDefaultScrollbarPositionTimeoutId);t.prototype.destroy.apply(this,arguments)},_attachEvents:function(){var t=this.getTable();e.Hook.register(t,e.Hook.Keys.Table.TotalRowCountChanged,this.onTotalRowCountChanged,this);e.Hook.register(t,e.Hook.Keys.Table.UpdateSizes,this.onUpdateTableSizes,this)},_detachEvents:function(){var t=this.getTable();var r=t._getScrollExtension().getVerticalScrollbar();if(r){r.removeEventListener("scroll",this._onVerticalScrollEventHandler)}delete this._onVerticalScrollEventHandler;var o=this.getVerticalScrollbar();if(o){o.removeEventListener("pointerdown",this._onPointerDownEventHandler)}delete this._onPointerDownEventHandler;var a=this.getVerticalScrollbarThumb();if(a){a.removeEventListener("touchmove",this._onTouchMoveEventHandler)}delete this._onTouchMoveEventHandler;e.Hook.deregister(t,e.Hook.Keys.Table.TotalRowCountChanged,this.onTotalRowCountChanged,this);e.Hook.deregister(t,e.Hook.Keys.Table.UpdateSizes,this.onUpdateTableSizes,this)}});o.prototype.onUpdateTableSizes=function(){this.updateVerticalScrollbarThumbHeight();this.updateVerticalScrollbarThumbPosition()};o.prototype.onTotalRowCountChanged=function(){this.updateVerticalScrollbarThumbHeight()};o.prototype.attachScrollbar=function(){var t=this.getTable();var e=t._getScrollExtension().getVerticalScrollbar();var r=this.getVerticalScrollbar();var o=this.getVerticalScrollbarThumb();if(!e||!e.isConnected){return}if(!r){r=document.createElement("div");r.setAttribute("id",t.getId()+"-vsb-ios");r.classList.add("sapUiTableVSbIOS");o=document.createElement("div");o.classList.add("sapUiTableVSbIOSThumb");r.append(o);e.after(r)}if(!this._onPointerDownEventHandler){this._onPointerDownEventHandler=this.onPointerDown.bind(this);r.addEventListener("pointerdown",this._onPointerDownEventHandler);this._onTouchMoveEventHandler=this.onTouchMove.bind(this);o.addEventListener("touchmove",this._onTouchMoveEventHandler);this._onVerticalScrollEventHandler=this.updateVerticalScrollbarThumbPosition.bind(this);e.addEventListener("scroll",this._onVerticalScrollEventHandler)}this.updateVerticalScrollbar()};o.prototype.getVerticalScrollbar=function(){var t=this.getTable();return t?t.getDomRef("vsb-ios"):null};o.prototype.getVerticalScrollbarThumb=function(){var t=this.getVerticalScrollbar();return t?t.firstElementChild:null};o.prototype.updateVerticalScrollbar=function(){var t=this.getTable();var e=this.getVerticalScrollbar();e.style.height=t._getScrollExtension().getVerticalScrollbarHeight()+"px";e.style.top=Math.max(0,t._getRowCounts().fixedTop*t._getBaseRowHeight()-1)+"px";this.updateVerticalScrollbarThumbPosition();this.updateVerticalScrollbarThumbHeight()};o.prototype.updateVerticalScrollbarThumbPosition=function(){var t=this.getVerticalScrollbarThumb();if(t){t.style.top=this.getCalculateThumbOffset()+"px"}};o.prototype.updateVerticalScrollbarThumbHeight=function(){var t=this.getTable();var e=t._getScrollExtension();var r=this.getVerticalScrollbarThumb();if(r){if(e.isVerticalScrollbarRequired()){r.style.height=this.getCalculateThumbHeight()+"px"}else{r.style.height="0"}}};o.prototype.getCalculateThumbHeight=function(){var t=this.getTable();var e=t._getScrollExtension();var r=e.getVerticalScrollbarHeight();var o=e.getVerticalScrollHeight();return Math.round(Math.pow(r,2)/o)};o.prototype.getCalculateThumbOffset=function(){var t=this.getTable();var e=t._getScrollExtension();var r=e.getVerticalScrollbarHeight();var o=e.getVerticalScrollHeight();var a=e.getVerticalScrollbar();var i=a?e.getVerticalScrollbar().scrollTop:0;return Math.round(i*r/o)};o.prototype.onTouchMove=function(t){var e=this.getTable();var r=e._getScrollExtension();var o=this.getVerticalScrollbarThumb();var a=o.getBoundingClientRect().y;var i=this.getCalculateThumbHeight();var l=o.offsetTop+t.touches[0].pageY-a-i/2;var n=Math.min(r.getVerticalScrollbarHeight()-i,Math.max(0,l));t.preventDefault();t.stopPropagation();o.style.top=n+"px";clearTimeout(this._iUpdateDefaultScrollbarPositionTimeoutId);this._iUpdateDefaultScrollbarPositionTimeoutId=setTimeout(function(){this.updateDefaultScrollbarPosition(n,i);delete this._iUpdateDefaultScrollbarPositionTimeoutId}.bind(this),30)};o.prototype.onPointerDown=function(t){var e=this.getTable();var r=e._getScrollExtension();var o=this.getVerticalScrollbarThumb();var a=o.getBoundingClientRect().y;var i=this.getCalculateThumbHeight();var l=o.offsetTop+t.clientY-a-i/2;var n=Math.min(r.getVerticalScrollbarHeight()-i,Math.max(0,l));t.preventDefault();t.stopPropagation();o.style.top=n+"px";this.updateDefaultScrollbarPosition(n,i)};o.prototype.updateDefaultScrollbarPosition=function(t,e){var r=this.getTable();if(!r){return}var o=r._getScrollExtension();var a=o.getVerticalScrollbarHeight();if(t+e>=a){o.scrollVerticallyMax(true)}else{var i=t*o.getVerticalScrollHeight()/a;var l=o.getVerticalScrollbar();l.scrollTop=i}};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/extensions/Synchronization", ["./ExtensionBase","../utils/TableUtils","../library","sap/base/Log"],function(e,t,r,n){"use strict";var o={setRowSelection:function(e,r){var n=this.getTable();var o=n.getRows()[e];if(o&&r!=null){t.toggleRowSelection(n,o,r)}},setRowHover:function(e,t){var r=this.getTable();var n=r.getRows()[e];if(n&&t!=null){n._setHovered(t)}},addVerticalScrollingListener:function(e){var t=this.getTable();var r=t._getSyncExtension();var n=t._getScrollExtension();var l={scrollDirection:n.constructor.ScrollDirection.VERTICAL};o.removeVerticalScrollingListener.call(this);if(!e){return}if(e.wheelAreas){r._mMouseWheelEventListener=n.registerForMouseWheel(e.wheelAreas,l);r._mMouseWheelEventListener.areas=e.wheelAreas}if(e.touchAreas){r._mTouchEventListener=n.registerForTouch(e.touchAreas,l);r._mTouchEventListener.areas=e.touchAreas}},removeVerticalScrollingListener:function(){var e=this.getTable();var t=e._getSyncExtension();function r(e,t){for(var r in t){var n=t[r];if(n){for(var o=0;o<e.length;o++){e[o].removeEventListener(r,n)}}}}if(t._mMouseWheelEventListener){r(t._mMouseWheelEventListener.areas,t._mMouseWheelEventListener);delete t._mMouseWheelEventListener}if(t._mTouchEventListener){r(t._mTouchEventListener.areas,t._mTouchEventListener);delete t._mTouchEventListener}},placeVerticalScrollbarAt:function(e){var t=this.getTable();var n=t._getScrollExtension();if(!e){throw new Error("The HTMLElement in which the vertical scrollbar should be placed must be specified.")}if(!n.isVerticalScrollbarExternal()){var o=sap.ui.getCore().createRenderManager();t.getRenderer().renderVSbExternal(o,t);o.flush(e);var l=t.getId()+"-"+r.SharedDomRef.VerticalScrollBar;var i=e.querySelector('[id="'+l+'"]');n.markVerticalScrollbarAsExternal(i);t.invalidate()}else{e.appendChild(n.getVerticalScrollbar().parentElement);n.restoreVerticalScrollPosition()}},renderHorizontalScrollbar:function(e,t,r){var n=this.getTable();if(t==null){throw new Error("The id must be specified.")}n.getRenderer().renderHSbExternal(e,n,t,r)}};var l={onBeforeRendering:function(e){var t=this._getSyncExtension();var r=e&&e.isMarked("renderRows");var n=this.getDomRef("tableCCnt");if(!r&&n&&t._onTableContainerScrollEventHandler){n.removeEventListener("scroll",t._onTableContainerScrollEventHandler);delete t._onTableContainerScrollEventHandler}},onAfterRendering:function(e){var t=this._getScrollExtension();var r=e&&e.isMarked("renderRows");var n=this.getDomRef("tableCCnt");if(t.isVerticalScrollbarExternal()&&!r){t.updateVerticalScrollbarHeight();t.updateVerticalScrollHeight()}if(!r){var o=this._getSyncExtension();o.syncInnerVerticalScrollPosition(n.scrollTop);if(!o._onTableContainerScrollEventHandler){o._onTableContainerScrollEventHandler=function(e){o.syncInnerVerticalScrollPosition(e.target.scrollTop)}}n.addEventListener("scroll",o._onTableContainerScrollEventHandler)}}};var i=e.extend("sap.ui.table.extensions.Synchronization",{_init:function(e,r,n){this._delegate=l;this._oPublicInterface={syncRowSelection:o.setRowSelection.bind(this),syncRowHover:o.setRowHover.bind(this),registerVerticalScrolling:o.addVerticalScrollingListener.bind(this),deregisterVerticalScrolling:o.removeVerticalScrollingListener.bind(this),placeVerticalScrollbarAt:o.placeVerticalScrollbarAt.bind(this),renderHorizontalScrollbar:o.renderHorizontalScrollbar.bind(this)};t.addDelegate(e,this._delegate,e);return"SyncExtension"},destroy:function(){var t=this.getTable();if(t){t.removeEventDelegate(this._delegate)}o.removeVerticalScrollingListener.call(this);this._delegate=null;this._oPublicInterface=null;e.prototype.destroy.apply(this,arguments)}});i.prototype.syncRowCount=function(e){this.callInterfaceHook("rowCount",arguments)};i.prototype.syncRowSelection=function(e,t){this.callInterfaceHook("rowSelection",arguments)};i.prototype.syncRowHover=function(e,t){this.callInterfaceHook("rowHover",arguments)};i.prototype.syncRowHeights=function(e){return this.callInterfaceHook("rowHeights",arguments)};i.prototype.syncInnerVerticalScrollPosition=function(e){this.callInterfaceHook("innerVerticalScrollPosition",arguments)};i.prototype.syncLayout=function(e){this.callInterfaceHook("layout",arguments)};i.prototype.callInterfaceHook=function(e,r){var o={};o[e]=Array.prototype.slice.call(r);n.debug("sap.ui.table.extensions.Synchronization","Sync "+e+"("+o[e]+")",this.getTable());return t.dynamicCall(this._oPublicInterface,o)};i.prototype.getInterface=function(){return this._oPublicInterface};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/library", ["sap/ui/core/Core","sap/ui/model/TreeAutoExpandMode","sap/ui/table/rowmodes/Type","sap/ui/core/library","sap/ui/unified/library"],function(e,o,i){"use strict";var a=sap.ui.getCore().initLibrary({name:"sap.ui.table",version:"1.120.22",dependencies:["sap.ui.core","sap.ui.unified"],designtime:"sap/ui/table/designtime/library.designtime",types:["sap.ui.table.NavigationMode","sap.ui.table.RowActionType","sap.ui.table.SelectionBehavior","sap.ui.table.SelectionMode","sap.ui.table.SortOrder","sap.ui.table.VisibleRowCountMode","sap.ui.table.TreeAutoExpandMode","sap.ui.table.plugins.SelectionMode"],interfaces:[],controls:["sap.ui.table.AnalyticalColumnMenu","sap.ui.table.AnalyticalTable","sap.ui.table.ColumnMenu","sap.ui.table.CreationRow","sap.ui.table.Table","sap.ui.table.TreeTable","sap.ui.table.RowAction"],elements:["sap.ui.table.AnalyticalColumn","sap.ui.table.Column","sap.ui.table.Row","sap.ui.table.RowActionItem","sap.ui.table.RowSettings","sap.ui.table.rowmodes.RowMode","sap.ui.table.rowmodes.Fixed","sap.ui.table.rowmodes.Interactive","sap.ui.table.rowmodes.Auto","sap.ui.table.plugins.SelectionPlugin","sap.ui.table.plugins.MultiSelectionPlugin","sap.ui.table.plugins.ODataV4Selection"],extensions:{flChangeHandlers:{},"sap.ui.support":{publicRules:true}}});a.NavigationMode={Scrollbar:"Scrollbar",Paginator:"Paginator"};a.RowActionType={Custom:"Custom",Navigation:"Navigation",Delete:"Delete"};a.SelectionBehavior={Row:"Row",RowSelector:"RowSelector",RowOnly:"RowOnly"};a.SelectionMode={MultiToggle:"MultiToggle",Multi:"Multi",Single:"Single",None:"None"};a.SortOrder={Ascending:"Ascending",Descending:"Descending"};a.VisibleRowCountMode={Fixed:"Fixed",Interactive:"Interactive",Auto:"Auto"};a.SharedDomRef={HorizontalScrollBar:"hsb",VerticalScrollBar:"vsb"};a.GroupEventType={group:"group",ungroup:"ungroup",ungroupAll:"ungroupAll",moveUp:"moveUp",moveDown:"moveDown",showGroupedColumn:"showGroupedColumn",hideGroupedColumn:"hideGroupedColumn"};a.ResetAllMode={Default:"Default",ServiceDefault:"ServiceDefault",ServiceReset:"ServiceReset"};a.ColumnHeader=a.Column;a.TreeAutoExpandMode=o;if(!a.plugins){a.plugins={}}a.plugins.SelectionMode={Single:"Single",MultiToggle:"MultiToggle"};a.rowmodes=a.rowmodes||{};a.rowmodes.Type=i;if(!a.TableHelper){a.TableHelper={addTableClass:function(){return""},createLabel:function(e){throw new Error("no Label control available!")},createTextView:function(e){throw new Error("no TextView control available!")},bFinal:false}}return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/menus/ColumnHeaderMenuAdapter", ["../utils/TableUtils","sap/ui/base/Object","sap/ui/base/EventProvider","sap/ui/base/ManagedObjectObserver"],function(e,t,n,r){"use strict";var o=new window.Map;var i={default:"LegacyColumnMenuAdapter","sap.m.table.columnmenu.Menu":"MobileColumnHeaderMenuAdapter","sap.ui.table.test.Menu":"test/TestAdapter"};var u=t.extend("sap.ui.table.menus.ColumnHeaderMenuAdapter",{constructor:function(){t.apply(this,arguments);this._mInjectionTarget=null;this._oColumnHeaderMenuObserver=new r(function(e){this.onAfterMenuDestroyed(e.object)}.bind(this))}});u.activateFor=function(t){var n=t.getHeaderMenuInstance();var r=a(n);var i;if(!r||!t._getTable()){return Promise.resolve()}o.forEach(function(e,n){if(n!==r){c(t,n)}});if(!o.has(r)){i={adapter:s(r).then(function(n){i=o.get(r);i.adapter=new n;i.adapter._injectMenuItems(i.activeFor.getHeaderMenuInstance(),i.activeFor);if(r==="LegacyColumnMenuAdapter"){e.Hook.register(t._getTable(),e.Hook.Keys.Table.InvalidateColumnMenus,i.adapter._invalidateAllMenus,i.adapter)}}),columns:[t],activeFor:t};o.set(r,i)}else{i=o.get(r);i.activeFor=t;if(!i.columns.includes(t)){i.columns.push(t)}}if(i.adapter instanceof Promise){return i.adapter}i.adapter._injectMenuItems(n,t);return Promise.resolve()};u.unlink=function(e){c(e)};u.prototype._injectMenuItems=function(e,t){this._removeMenuItems();this._oColumnHeaderMenuObserver.observe(e,{destroy:true});this.injectMenuItems(e,t);this._mInjectionTarget={column:t,menu:e}};u.prototype._removeMenuItems=function(){if(!this._mInjectionTarget){return}this.removeMenuItems(this._mInjectionTarget.menu);this._mInjectionTarget=null};u.prototype.injectMenuItems=function(e,t){};u.prototype.removeMenuItems=function(e){};u.prototype.onAfterMenuDestroyed=function(e){};u.prototype.destroy=function(){t.prototype.destroy.apply(this,arguments);this._removeMenuItems();this._oColumnHeaderMenuObserver.disconnect();delete this._oColumnHeaderMenuObserver};function s(e){return new Promise(function(t,n){sap.ui.require(["sap/ui/table/menus/"+e],function(e){t(e)},function(e){n(e)})})}function a(t){for(var n in i){if(e.isA(t,n)){return i[n]}}return i.default}function c(e,t){var n;if(t){n=o.get(t)}else{o.forEach(function(r,o){if(r.columns.includes(e)){n=r;t=o}})}if(!n){return}if(n.adapter instanceof Promise){n.adapter.then(function(){c(e,t)})}else{if(n.columns.includes(e)){n.columns.splice(n.columns.indexOf(e),1)}if(n.columns.length===0){n.adapter.destroy();o.delete(t)}}}return u});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/menus/LegacyColumnMenuAdapter", ["./ColumnHeaderMenuAdapter","sap/ui/table/ColumnMenu","sap/ui/table/AnalyticalColumnMenu","sap/ui/table/utils/TableUtils","sap/ui/core/Popup","sap/ui/Device","sap/ui/base/ManagedObjectObserver"],function(e,t,n,a,r,l,u){"use strict";var i=["sortProperty","filterProperty","showSortMenuEntry","showFilterMenuEntry"];var o=["filterValue"];var s=["enableCustomFilter","enableGrouping","enableColumnFreeze","showColumnVisibilityMenu"];var p=e.extend("sap.ui.table.menus.LegacyColumnMenuAdapter",{constructor:function(){e.apply(this,arguments);this._oLegacyMenuObserver=new u(function(e){if(e.old!==e.current){if(i.indexOf(e.name)>-1){this._invalidateMenu(e.object)}else if(o.indexOf(e.name)>-1){this._setFilterValue(e.object,e.current)}else if(s.indexOf(e.name)>-1){this._invalidateAllMenus()}}}.bind(this))}});p.prototype.injectMenuItems=function(e,t){var n=t._getTable();var a=t.getDomRef();var r=a.querySelector(".sapUiTableColDropDown")!==null;if(!l.system.desktop&&!r){return this._applyColumnHeaderCellMenu(t)}this._removeColumnHeaderCellMenu(n);var u=n.fireColumnSelect({column:t});if(u){this._openColumnContextMenu(t)}};p.prototype._invalidateMenu=function(e){var t=e.getMenu();if(a.isA(t,"sap.ui.table.ColumnMenu")){t._invalidate()}};p.prototype._invalidateAllMenus=function(e){var t=e.getColumns();for(var n=0,a=t.length;n<a;n++){this._invalidateMenu(t[n])}};p.prototype._setFilterValue=function(e,t){var n=e.getMenu();if(a.isA(n,"sap.ui.table.ColumnMenu")){n._setFilterValue(t)}};p.prototype._setFilterState=function(e,t){var n=e.getMenu();if(a.isA(n,"sap.ui.table.ColumnMenu")){n._setFilterState(t)}};p.prototype._applyColumnHeaderCellMenu=function(e){var t=e._getTable();var n=e.getDomRef();var a=n.getAttribute("colspan");var r=n.querySelector(".sapUiTableCellInner");var l=n.querySelector(".sapUiTableCellTouchMenu")!==null;if(a&&a!=="1"||l||!e.getResizable()&&!e._menuHasItems()){return false}var u=document.createElement("div");this._removeColumnHeaderCellMenu(t);r.style.display="none";if(e._menuHasItems()){var i;i=document.createElement("div");i.classList.add("sapUiTableColDropDown");i.textContent="";u.appendChild(i)}if(e.getResizable()){var o;o=document.createElement("div");o.classList.add("sapUiTableColResizer");o.textContent="";u.appendChild(o)}u.classList.add("sapUiTableCellTouchMenu");n.appendChild(u);var s=function(){this._removeColumnHeaderCellMenu(t);n.removeEventListener("focusout",s)}.bind(this);n.addEventListener("focusout",s);return true};p.prototype._removeColumnHeaderCellMenu=function(e){var t=e&&e.$().find(".sapUiTableCHT .sapUiTableCellTouchMenu");if(t.length){t.parent().find(".sapUiTableCellInner").show();t.remove()}};p.prototype._openColumnContextMenu=function(e){var t=e._getTable();var n=e._cellPressed;var a=t.getColumns();for(var r=0;r<a.length;r++){if(a[r]!==e){this._closeColumnContextMenu(a[r])}}var l=n.getAttribute("colspan");if(l&&l!=="1"){return false}return this._openMenu(e,n)};p.prototype._openMenu=function(e,t){var n=this._getMenu(e);if(!e._menuHasItems()){return false}var a=e.fireColumnMenuOpen({menu:n});if(a){var l=r.Dock;n.open(null,t,l.BeginTop,l.BeginBottom,t);return true}else{return true}};p.prototype._closeColumnContextMenu=function(e){var t=e.getMenu();if(t){t.close()}};p.prototype._getMenu=function(e){var t=e.getMenu();if(!t){t=this._createMenu(e);e.setAggregation("menu",t,true);var n=i.concat(o).concat(s);this._oLegacyMenuObserver.observe(e,{properties:n});a.Hook.register(e._getTable(),a.Hook.Keys.Column.SetFilterState,this._setFilterState,this)}return t};p.prototype._createMenu=function(e){var a=e.isA("sap.ui.table.AnalyticalColumn")?n:t;return new a(e.getId()+"-menu",{ariaLabelledBy:e})};return p});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/menus/MobileColumnHeaderMenuAdapter", ["./ColumnHeaderMenuAdapter","../utils/TableUtils","../library","sap/m/library","sap/m/table/columnmenu/QuickAction","sap/m/table/columnmenu/QuickActionContainer","sap/m/table/columnmenu/QuickSort","sap/m/table/columnmenu/QuickSortItem","sap/m/table/columnmenu/QuickGroup","sap/m/table/columnmenu/QuickGroupItem","sap/m/table/columnmenu/QuickTotal","sap/m/table/columnmenu/QuickTotalItem","sap/m/table/columnmenu/Item","sap/m/table/columnmenu/ItemContainer","sap/m/table/columnmenu/ActionItem","sap/m/Button","sap/m/Input","sap/ui/core/library","sap/ui/core/Core","sap/ui/Device"],function(e,t,i,o,r,u,s,n,a,c,l,_,p,m,h,k,Q,f,d,C){"use strict";var g=e.extend("sap.ui.table.menus.MobileColumnHeaderMenuAdapter",{});g.prototype.injectMenuItems=function(e,t){this._oColumn=t;this._oMenu=e;this._prepareQuickActions(t);e.addAggregation("_quickActions",this._oQuickActionContainer);this._prepareItems(t);e.addAggregation("_items",this._oItemContainer)};g.prototype.removeMenuItems=function(e){delete this._oColumn;e.removeAggregation("_quickActions",this._oQuickActionContainer);e.removeAggregation("_items",this._oItemContainer)};g.prototype.onAfterMenuDestroyed=function(e){if(e!==this._oMenu){return}delete this._oQuickActionContainer;delete this._oQuickSort;delete this._oQuickFreeze;delete this._oQuickFilter;delete this._oQuickGroup;delete this._oQuickTotal;delete this._oItemContainer;delete this._oCustomFilterItem};g.prototype.destroy=function(){e.prototype.destroy.apply(this,arguments);this._destroyQuickActions();this._destroyItems();delete this._oColumn};g.prototype._prepareQuickActions=function(e){var t=e._getTable();this._prepareQuickSort(e);if(!t.getEnableCustomFilter()){this._prepareQuickFilter(e)}this._prepareQuickGroup(e);this._prepareQuickTotal(e);this._prepareQuickFreeze(e);this._prepareQuickResize(e);if(!this._oQuickActionContainer){this._oQuickActionContainer=new u}this._oQuickActionContainer.addQuickAction(this._oQuickSort);this._oQuickActionContainer.addQuickAction(this._oQuickFilter);this._oQuickActionContainer.addQuickAction(this._oQuickGroup);this._oQuickActionContainer.addQuickAction(this._oQuickTotal);this._oQuickActionContainer.addQuickAction(this._oQuickFreeze);this._oQuickActionContainer.addQuickAction(this._oQuickResize)};g.prototype._prepareItems=function(e){var t=e._getTable();if(t.getEnableCustomFilter()){this._prepareCustomFilterItem(e)}if(!this._oItemContainer){this._oItemContainer=new m}this._oItemContainer.addItem(this._oCustomFilterItem)};g.prototype._destroyQuickActions=function(){if(this._oQuickActionContainer){this._oQuickActionContainer.destroy()}delete this._oQuickActionContainer;delete this._oQuickSort;delete this._oQuickFilter;delete this._oQuickGroup;delete this._oQuickTotal;delete this._oQuickFreeze};g.prototype._destroyItems=function(){if(this._oItemContainer){this._oItemContainer.destroy()}delete this._oItemContainer;delete this._oCustomFilterItem};g.prototype._prepareQuickSort=function(e){if(e.isSortableByMenu()){if(!this._oQuickSort){this._oQuickSort=this._createQuickSort()}this._updateQuickSort(e);this._oQuickSort.setVisible(true)}else if(this._oQuickSort){this._oQuickSort.setVisible(false)}};g.prototype._createQuickSort=function(){return new s({items:new n,change:[function(e){var t=e.getParameter("item").getSortOrder();this._oColumn._sort(t,false)},this]})};g.prototype._updateQuickSort=function(e){var i=this._oQuickSort.getItems()[0];i.setLabel(t.Column.getHeaderText(e));i.setSortOrder(e.getSortOrder())};g.prototype._prepareQuickFilter=function(e){if(e.getShowFilterMenuEntry()&&e.isFilterableByMenu()){if(!this._oQuickFilter){this._oQuickFilter=this._createQuickFilter();this._oQuickFilter._bHideLabelColon=true}this._updateQuickFilter(e);this._oQuickFilter.setVisible(true)}else if(this._oQuickFilter){this._oQuickFilter.setVisible(false)}};g.prototype._createQuickFilter=function(){return new r({content:new Q({submit:[function(e){this._oColumn.setFilterValue(e.getSource().getValue());var t=this._oColumn._getFilterState();if(t===f.ValueState.None){this._oColumn.filter(e.getSource().getValue());this._oMenu.close()}e.getSource().setValueState(t)},this]}),category:o.table.columnmenu.Category.Filter})};g.prototype._updateQuickFilter=function(e){var i=d.getLibraryResourceBundle("sap.m");var o=this._oQuickFilter.getContent()[0];this._oQuickFilter.setLabel(i.getText("table.COLUMNMENU_QUICK_FILTER",[t.Column.getHeaderText(e)]));o.setValue(e.getFilterValue());o.setValueState(e._getFilterState())};g.prototype._prepareQuickGroup=function(e){if(e._isGroupableByMenu()){if(!this._oQuickGroup){this._oQuickGroup=this._createQuickGroup()}this._updateQuickGroup(e);this._oQuickGroup.setVisible(true)}else if(this._oQuickGroup){this._oQuickGroup.setVisible(false)}};g.prototype._createQuickGroup=function(){return new a({items:new c,change:[function(e){var i=e.getParameter("item").getGrouped();var o=this._oColumn;var r=o._getTable();this._oMenu.attachEventOnce("afterClose",function(){if(i&&(!o.getShowIfGrouped||!o.getShowIfGrouped())){var e;if(t.isNoDataVisible(r)){e=r.getDomRef("noDataCnt")}else{e=r.getDomRef("rowsel0")}if(e){e.focus()}}o._setGrouped(i)})},this]})};g.prototype._updateQuickGroup=function(e){var i=this._oQuickGroup.getItems()[0];i.setLabel(t.Column.getHeaderText(e));i.setGrouped(e.getGrouped())};g.prototype._prepareQuickTotal=function(e){if(e._isAggregatableByMenu()){if(!this._oQuickTotal){this._oQuickTotal=this._createQuickTotal()}this._updateQuickTotal(e);this._oQuickTotal.setVisible(true)}else if(this._oQuickTotal){this._oQuickTotal.setVisible(false)}};g.prototype._createQuickTotal=function(){return new l({items:new _,change:[function(e){this._oColumn.setSummed(e.getParameter("item").getTotaled())},this]})};g.prototype._updateQuickTotal=function(e){var i=this._oQuickTotal.getItems()[0];i.setLabel(t.Column.getHeaderText(e));i.setTotaled(e.getSummed())};g.prototype._prepareQuickFreeze=function(e){if(e._getTable().getEnableColumnFreeze()){if(!this._oQuickFreeze){this._oQuickFreeze=this._createQuickFreeze()}this._updateQuickFreeze(e);this._oQuickFreeze.setVisible(true)}else if(this._oQuickFreeze){this._oQuickFreeze.setVisible(false)}};g.prototype._createQuickFreeze=function(){return new r({content:new k({press:[function(e){var i=this._oColumn._getTable();var o=i.fireColumnFreeze({column:this._oColumn});if(o){var r=e.getSource().getText()===t.getResourceText("TBL_UNFREEZE");if(r){i.setFixedColumnCount(0)}else{i.setFixedColumnCount(this._oColumn.getIndex()+1)}}this._oMenu.close()},this]})})};g.prototype._updateQuickFreeze=function(e){var i=e.getIndex()+t.Column.getHeaderSpan(e)===e._getTable().getComputedFixedColumnCount();var o=i?"TBL_UNFREEZE":"TBL_FREEZE";this._oQuickFreeze.getContent()[0].setText(t.getResourceText(o))};g.prototype._prepareQuickResize=function(e){if(!C.system.desktop&&e.getResizable()){if(!this._oQuickResize){this._oQuickResize=this._createQuickResize(e)}this._oQuickResize.setVisible(true)}else if(this._oQuickResize){this._oQuickResize.setVisible(false)}};g.prototype._createQuickResize=function(e){var t=d.getLibraryResourceBundle("sap.m");return new r({content:new k({text:t.getText("table.COLUMNMENU_RESIZE"),press:[function(t){this._startColumnResize(e);this._oMenu.close()},this]})})};g.prototype._startColumnResize=function(e){var t=e._getTable();t.$().toggleClass("sapUiTableResizing",true);t._$colResize=t.$("rsz");t._$colResize.toggleClass("sapUiTableColRszActive",true)};g.prototype._removeHeaderCellColumnResizer=function(e){var t=e&&e.$().find(".sapUiTableCHT .sapUiTableCellTouchMenu");if(t.length){t.parent().find(".sapUiTableCellInner").show();t.remove()}};g.prototype._prepareCustomFilterItem=function(e){if(e.getShowFilterMenuEntry()){if(!this._oCustomFilterItem){this._oCustomFilterItem=this._createCustomFilterItem()}this._oCustomFilterItem.setVisible(true)}else if(this._oCustomFilterItem){this._oCustomFilterItem.setVisible(false)}};g.prototype._createCustomFilterItem=function(){return new h({label:t.getResourceText("TBL_FILTER_ITEM"),icon:"sap-icon://filter",press:[function(e){this._oColumn._getTable().fireCustomFilter({column:this._oColumn})},this]})};return g});
/*
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/plugins/BindingSelection", ["./SelectionPlugin","../utils/TableUtils","../library"],function(e,t,n){"use strict";var i=n.SelectionMode;var l=e.extend("sap.ui.table.plugins.BindingSelection",{metadata:{library:"sap.ui.table",properties:{selectionMode:{type:"sap.ui.table.SelectionMode",group:"Behavior",defaultValue:i.MultiToggle}},events:{selectionChange:{parameters:{indices:{type:"int[]"},selectAll:{type:"boolean"}}}}}});l.prototype.onDeactivate=function(t){e.prototype.onDeactivate.apply(this,arguments);a(this,this.getTableBinding())};l.prototype.setSelected=function(e,t,n){if(!this.isIndexSelectable(e.getIndex())){return}if(n&&n.range){var i=this.getSelectedIndex();if(i>=0){this.addSelectionInterval(i,e.getIndex())}}else if(t){this.addSelectionInterval(e.getIndex(),e.getIndex())}else{this.removeSelectionInterval(e.getIndex(),e.getIndex())}};l.prototype.isSelected=function(e){return this.isIndexSelected(e.getIndex())};l.prototype.getRenderConfig=function(){return{headerSelector:{type:"toggle",visible:t.hasSelectAll(this.getTable()),selected:this.getSelectableCount()>0&&this.getSelectableCount()===this.getSelectedCount()}}};function o(e){var t=e.getTable(),n;if(e.getSelectableCount()>e.getSelectedCount()){t._iSourceRowIndex=0;e.selectAll();n=true}else{t._iSourceRowIndex=-1;e.clearSelection();n=false}t._iSourceRowIndex=undefined;return n}l.prototype.onHeaderSelectorPress=function(){if(this.getRenderConfig().headerSelector.visible){o(this)}};l.prototype.onKeyboardShortcut=function(e,t){if(e==="toggle"&&o(this)===false){t?.setMarked("sapUiTableClearAll")}else if(e==="clear"){this.clearSelection();t?.setMarked("sapUiTableClearAll")}};l.prototype.addSelectionInterval=function(e,t){if(this.getSelectionMode()===i.None){return}var n=this.getTableBinding();if(n&&n.addSelectionInterval){if(this.getSelectionMode()===i.Single){e=t;this.setSelectionInterval(e,t)}else{n.addSelectionInterval(e,t)}}};l.prototype.clearSelection=function(){var e=this.getTableBinding();if(e&&e.clearSelection){e.clearSelection()}};l.prototype.getSelectedIndex=function(){var e=this.getTableBinding();if(e&&e.getSelectedIndex){return e.getSelectedIndex()}else{return-1}};l.prototype.getSelectedIndices=function(){var e=this.getTableBinding();if(this.getSelectionMode()===i.Single){var t=this.getSelectedIndex();if(t===-1){return[]}return[t]}if(e&&e.getSelectedIndices){return e.getSelectedIndices()}else{return[]}};l.prototype.getSelectableCount=function(){var e=this.getTableBinding();if(!e){return 0}else if(e.isA("sap.ui.model.analytics.AnalyticalBinding")){var t=e.getGrandTotalContextInfo();return t?t.totalNumberOfLeafs:0}else{return e.getLength()}};l.prototype.getSelectedCount=function(){var e=this.getTableBinding();if(e&&e.getSelectedNodesCount){return e.getSelectedNodesCount()}else{return 0}};l.prototype.isIndexSelectable=function(e){var t=this.getTableBinding();if(t&&t.isIndexSelectable){return t.isIndexSelectable(e)}else{return false}};l.prototype.isIndexSelected=function(e){var t=this.getTableBinding();if(this.getSelectionMode()===i.Single){if(e<0){return false}return e===this.getSelectedIndex()}if(t&&t.isIndexSelected){return t.isIndexSelected(e)}else{return false}};l.prototype.removeSelectionInterval=function(e,t){var n=this.getTableBinding();if(n&&n.removeSelectionInterval){n.removeSelectionInterval(e,t)}};l.prototype.selectAll=function(){if(this.getSelectionMode()===i.None){return}var e=this.getTableBinding();if(e&&e.selectAll){e.selectAll()}};l.prototype.setSelectedIndex=function(e){if(this.getSelectionMode()===i.None){return}if(e===-1){this.clearSelection()}else{var t=this.getTableBinding();if(t&&t.setSelectedIndex){t.setSelectedIndex(e)}}};l.prototype.setSelectionInterval=function(e,t){if(this.getSelectionMode()===i.None){return}var n=this.getTableBinding();if(n&&n.setSelectionInterval){if(this.getSelectionMode()===i.Single){e=t}n.setSelectionInterval(e,t)}};l.prototype.setSelectionMode=function(e){var t=this.getSelectionMode();this.setProperty("selectionMode",e);if(this.getSelectionMode()!==t){this.clearSelection()}return this};l.prototype._getHighestSelectableIndex=function(){var e=this.getTableBinding();if(!e){return-1}else if(e.isA("sap.ui.model.analytics.AnalyticalBinding")){var t=e.providesGrandTotal()&&e.hasTotaledMeasures();return e.getLength()-(t?2:1)}else{return e.getLength()-1}};l.prototype.onTableRowsBound=function(t){e.prototype.onTableRowsBound.apply(this,arguments);r(this,t)};function r(e,t){if(t){t.attachChange(e._onBindingChange,e);if(t.attachSelectionChanged){t.attachSelectionChanged(e._onSelectionChange,e)}}}function a(e,t){if(t){t.detachChange(e._onBindingChange,e);if(t.detachSelectionChanged){t.detachSelectionChanged(e._onSelectionChange,e)}}}l.prototype._onBindingChange=function(e){var t=typeof e==="object"?e.getParameter("reason"):e;if(t==="sort"||t==="filter"){this.clearSelection()}};l.prototype._onSelectionChange=function(e){var t=e.getParameter("rowIndices");var n=e.getParameter("selectAll");this.fireSelectionChange({rowIndices:t,selectAll:n})};return l});
/*
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/plugins/MultiSelectionPlugin", ["./SelectionPlugin","./PluginBase","../library","../utils/TableUtils","sap/ui/core/Icon","sap/ui/core/IconPool","sap/base/Log"],function(e,t,i,n,o,l,r){"use strict";var s=i.SelectionMode;var a=e.extend("sap.ui.table.plugins.MultiSelectionPlugin",{metadata:{library:"sap.ui.table",properties:{limit:{type:"int",group:"Behavior",defaultValue:200},enableNotification:{type:"boolean",group:"Behavior",defaultValue:false},showHeaderSelector:{type:"boolean",group:"Appearance",defaultValue:true},selectionMode:{type:"sap.ui.table.SelectionMode",group:"Behavior",defaultValue:s.MultiToggle}},events:{selectionChange:{parameters:{indices:{type:"int[]"},limitReached:{type:"boolean"},customPayload:{type:"object"}}}}}});a.findOn=t.findOn;a.prototype.init=function(){e.prototype.init.apply(this,arguments);var t=new o({src:l.getIconURI(n.ThemeParameters.clearSelectionIcon),useIconTooltip:false});t.addStyleClass("sapUiTableSelectClear");this._bLimitReached=false;this._bLimitDisabled=this.getLimit()===0;this.oInnerSelectionPlugin=null;this.oDeselectAllIcon=t};a.prototype.exit=function(){e.prototype.exit.apply(this,arguments);if(this.oDeselectAllIcon){this.oDeselectAllIcon.destroy();this.oDeselectAllIcon=null}};a.prototype.onActivate=function(t){e.prototype.onActivate.apply(this,arguments);this.oInnerSelectionPlugin=t._createLegacySelectionPlugin();this.oInnerSelectionPlugin.attachSelectionChange(this._onSelectionChange,this);t.addAggregation("_hiddenDependents",this.oInnerSelectionPlugin);t.setProperty("selectionMode",this.getSelectionMode())};a.prototype.onDeactivate=function(t){e.prototype.onDeactivate.apply(this,arguments);t.setProperty("selectionMode",s.None);if(this.oInnerSelectionPlugin){this.oInnerSelectionPlugin.destroy();this.oInnerSelectionPlugin=null}};a.prototype.setSelected=function(e,t,i){if(!this.isIndexSelectable(e.getIndex())){return}if(i&&i.range){var n=this.getSelectedIndex();if(n>=0){this.addSelectionInterval(n,e.getIndex())}}else if(t){this.addSelectionInterval(e.getIndex(),e.getIndex())}else{this.removeSelectionInterval(e.getIndex(),e.getIndex())}};a.prototype.isSelected=function(e){return this.isIndexSelected(e.getIndex())};a.prototype.getRenderConfig=function(){if(!this.isActive()){return e.prototype.getRenderConfig.apply(this,arguments)}return{headerSelector:{type:this._bLimitDisabled?"toggle":"clear",icon:this.oDeselectAllIcon,visible:this.getSelectionMode()===s.MultiToggle&&this.getShowHeaderSelector(),enabled:this._bLimitDisabled||this.getSelectedCount()>0,selected:this.getSelectableCount()>0&&this.getSelectableCount()===this.getSelectedCount()}}};a.prototype.onHeaderSelectorPress=function(){var e=this.getRenderConfig();if(!e.headerSelector.visible||!e.headerSelector.enabled){return}if(e.headerSelector.type==="toggle"){c(this)}else if(e.headerSelector.type==="clear"){this.clearSelection()}};a.prototype.onKeyboardShortcut=function(e,t){if(e==="toggle"){if(this._bLimitDisabled&&c(this)===false){t?.setMarked("sapUiTableClearAll")}}else if(e==="clear"){this.clearSelection();t?.setMarked("sapUiTableClearAll")}};function c(e){if(e.getSelectableCount()>e.getSelectedCount()){e.selectAll();return true}else{e.clearSelection();return false}}a.prototype.setSelectionMode=function(e){var t=this.getParent();if(t){t.setProperty("selectionMode",e,true)}if(this.oInnerSelectionPlugin){this.oInnerSelectionPlugin.setSelectionMode(e)}this.setProperty("selectionMode",e);return this};a.prototype.setLimit=function(e){if(typeof e==="number"&&e<0){r.warning("The limit must be greater than or equal to 0",this);return this}this.setProperty("limit",e,!!this.getLimit()===!!e);this._bLimitDisabled=e===0;return this};a.prototype.setEnableNotification=function(e){this.setProperty("enableNotification",e,true);return this};a.prototype.isLimitReached=function(){return this._bLimitReached};a.prototype.setLimitReached=function(e){this._bLimitReached=e};a.prototype.selectAll=function(e){if(!this._bLimitDisabled){return Promise.reject(new Error("Not possible if the limit is enabled"))}var t=this.getSelectableCount();if(t===0){return Promise.reject(new Error("Nothing to select"))}return this.addSelectionInterval(0,this._getHighestSelectableIndex(),e)};function u(e,t,i,o){var l=e._getHighestSelectableIndex();if(t<0&&i<0||t>l&&i>l){return Promise.reject(new Error("Out of range"))}t=Math.min(Math.max(0,t),l);i=Math.min(Math.max(0,i),l);var r=e.getLimit();var s=i<t;var a=s?i:t;var c;if(o&&e.isIndexSelected(t)){if(s){t--}else if(t!==i){t++;a++}}c=Math.abs(i-t)+1;if(!e._bLimitDisabled){e.setLimitReached(c>r);if(e.isLimitReached()){if(s){i=t-r+1;a=i-1}else{i=t+r-1}c=r+1}}return n.loadContexts(e.getTableBinding(),a,c).then(function(){return{indexFrom:t,indexTo:i}})}a.prototype.setSelectionInterval=function(e,t,i){var o=this.getTable();var l=this.getSelectionMode();if(l===s.None){return Promise.reject(new Error("SelectionMode is '"+s.None+"'"))}if(l===s.Single){e=t}return u(this,e,t,false).then(function(e){this._oCustomEventPayloadTmp=i;this.oInnerSelectionPlugin.setSelectionInterval(e.indexFrom,e.indexTo);delete this._oCustomEventPayloadTmp;if(!this.isLimitReached()){return Promise.resolve()}return n.scrollTableToIndex(o,e.indexTo,e.indexFrom>e.indexTo).then(function(){if(!this.getEnableNotification()){return Promise.resolve()}return n.showNotificationPopoverAtIndex(o,e.indexTo,this.getLimit())}.bind(this))}.bind(this))};a.prototype.setSelectedIndex=function(e,t){return this.setSelectionInterval(e,e,t)};a.prototype.addSelectionInterval=function(e,t,i){var o=this.getTable();var l=this.getSelectionMode();if(l===s.None){return Promise.reject(new Error("SelectionMode is '"+s.None+"'"))}if(l===s.Single){return this.setSelectionInterval(t,t)}if(l===s.MultiToggle){return u(this,e,t,true).then(function(e){this._oCustomEventPayloadTmp=i;this.oInnerSelectionPlugin.addSelectionInterval(e.indexFrom,e.indexTo);delete this._oCustomEventPayloadTmp;if(!this.isLimitReached()){return Promise.resolve()}return n.scrollTableToIndex(o,e.indexTo,e.indexFrom>e.indexTo).then(function(){if(!this.getEnableNotification()){return Promise.resolve()}return n.showNotificationPopoverAtIndex(o,e.indexTo,this.getLimit())}.bind(this))}.bind(this))}};a.prototype.clearSelection=function(e){if(this.oInnerSelectionPlugin){this.setLimitReached(false);this._oCustomEventPayloadTmp=e;this.oInnerSelectionPlugin.clearSelection();delete this._oCustomEventPayloadTmp}};a.prototype.getSelectedIndex=function(){if(this.oInnerSelectionPlugin){return this.oInnerSelectionPlugin.getSelectedIndex()}return-1};a.prototype.getSelectedIndices=function(){if(this.oInnerSelectionPlugin){return this.oInnerSelectionPlugin.getSelectedIndices()}return[]};a.prototype.getSelectableCount=function(){if(this.oInnerSelectionPlugin){return this.oInnerSelectionPlugin.getSelectableCount()}return 0};a.prototype.getSelectedCount=function(){if(this.oInnerSelectionPlugin){return this.oInnerSelectionPlugin.getSelectedCount()}return 0};a.prototype.isIndexSelectable=function(e){if(this.oInnerSelectionPlugin){return this.oInnerSelectionPlugin.isIndexSelectable(e)}return false};a.prototype.isIndexSelected=function(e){if(this.oInnerSelectionPlugin){return this.oInnerSelectionPlugin.isIndexSelected(e)}return false};a.prototype.removeSelectionInterval=function(e,t,i){if(this.oInnerSelectionPlugin){this.setLimitReached(false);this._oCustomEventPayloadTmp=i;this.oInnerSelectionPlugin.removeSelectionInterval(e,t);delete this._oCustomEventPayloadTmp}};a.prototype._onSelectionChange=function(e){var t=e.getParameter("rowIndices");this.fireSelectionChange({rowIndices:t,limitReached:this.isLimitReached(),customPayload:typeof this._oCustomEventPayloadTmp==="object"?this._oCustomEventPayloadTmp:null,_internalTrigger:e.getParameter("_internalTrigger")})};a.prototype._getHighestSelectableIndex=function(){if(this.oInnerSelectionPlugin){return this.oInnerSelectionPlugin._getHighestSelectableIndex()}return 0};a.prototype.onThemeChanged=function(){this.oDeselectAllIcon.setSrc(l.getIconURI(n.ThemeParameters.clearSelectionIcon))};return a});
/*
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/plugins/ODataV4Selection", ["./SelectionPlugin","../library","../utils/TableUtils","sap/ui/core/Icon","sap/ui/core/IconPool"],function(e,t,i,n,o){"use strict";var l=t.plugins.SelectionMode;var r=t.SelectionMode;var a=e.extend("sap.ui.table.plugins.ODataV4Selection",{metadata:{library:"sap.ui.table",properties:{selectionMode:{type:"sap.ui.table.plugins.SelectionMode",group:"Behavior",defaultValue:l.MultiToggle},limit:{type:"int",group:"Behavior",defaultValue:200},enableNotification:{type:"boolean",group:"Behavior",defaultValue:false},hideHeaderSelector:{type:"boolean",group:"Appearance",defaultValue:false}},events:{selectionChange:{}}}});a.prototype.init=function(){e.prototype.init.apply(this,arguments);var t=new n({src:o.getIconURI(i.ThemeParameters.clearSelectionIcon),useIconTooltip:false});t.addStyleClass("sapUiTableSelectClear");this._bLimitReached=false;this.oDeselectAllIcon=t;this._oRangeSelectionStartContext=null};a.prototype.exit=function(){e.prototype.exit.apply(this,arguments);if(this.oDeselectAllIcon){this.oDeselectAllIcon.destroy();this.oDeselectAllIcon=null}};a.prototype.onActivate=function(t){e.prototype.onActivate.apply(this,arguments);t.setProperty("selectionMode",this.getSelectionMode())};a.prototype.onDeactivate=function(t){e.prototype.onDeactivate.apply(this,arguments);t.setProperty("selectionMode",r.None);this.clearSelection()};a.prototype.setSelected=function(e,t,i){var n=e.getRowBindingContext();if(!n||!g(n)){return}if(i&&i.range){s(this,e);return}if(this.isSelected(e)===t){return}if(this.getSelectionMode()===l.Single){this._bSuppressSelectionChangeEvent=true;this.clearSelection()}n.setSelected(t);this._oRangeSelectionStartContext=t&&this.getSelectionMode()===l.MultiToggle?n:null;this.fireSelectionChange()};a.prototype.setSelectedContexts=function(e){this.clearSelection();var t=this.getSelectionMode()===l.Single?e.slice(0,1):e;t.forEach(function(e){e.setSelected(true)});this.fireSelectionChange()};function s(e,t){if(!e._oRangeSelectionStartContext){return}var i=e._oRangeSelectionStartContext.getIndex();var n=t.getRowBindingContext();var o=n?n.getIndex():-1;if(i!==o){i+=o>i?1:-1}d(e,i,o)}a.prototype.isSelected=function(e){var t=e.getRowBindingContext();return t?t.isSelected():false};a.prototype.getSelectedCount=function(){return this.getSelectedContexts().length};a.prototype.getRenderConfig=function(){if(!this.isActive()){return e.prototype.getRenderConfig.apply(this,arguments)}return{headerSelector:{type:this._isLimitDisabled()?"toggle":"clear",icon:this.oDeselectAllIcon,visible:this.getSelectionMode()===l.MultiToggle&&!this.getHideHeaderSelector(),enabled:this._isLimitDisabled()||this.getSelectedCount()>0,selected:u(this)}}};function c(e){if(u(e)){e.clearSelection();return false}else if(e._isLimitDisabled()){var t=e.getTableBinding();if(t&&t.getLength()){d(e,0,t.getLength()-1);return true}}return undefined}function u(e){var t=e.getTableBinding();if(!t||!t.isLengthFinal()){return false}var i=t.getAllCurrentContexts().filter(function(e){return g(e)}).length;var n=e.getSelectedContexts().filter(function(e){return g(e)}).length;return i>0&&i===n}a.prototype.onHeaderSelectorPress=function(){var e=this.getRenderConfig();if(!e.headerSelector.visible||!e.headerSelector.enabled){return}if(e.headerSelector.type==="toggle"){c(this)}else if(e.headerSelector.type==="clear"){this.clearSelection()}};a.prototype.onKeyboardShortcut=function(e,t){if(e==="toggle"){if(this._isLimitDisabled()&&c(this)===false){t?.setMarked("sapUiTableClearAll")}}else if(e==="clear"){this.clearSelection();t?.setMarked("sapUiTableClearAll")}};a.prototype.setSelectionMode=function(e){var t=this.getTable();this.setProperty("selectionMode",e,true);this._oRangeSelectionStartContext=null;this.clearSelection();if(t){t.setProperty("selectionMode",this.getSelectionMode())}return this};a.prototype.onTableRowsBound=function(e){if(!e.getModel().isA("sap.ui.model.odata.v4.ODataModel")){this.deactivate()}};a.prototype._isLimitDisabled=function(){return this.getLimit()===0};a.prototype.isLimitReached=function(){return this._bLimitReached};function d(e,t,n){var o=e.getTable();var l=e.getLimit();var r=n<t;var a=r?n:t;var s=Math.abs(n-t)+1;if(!e._isLimitDisabled()){e._bLimitReached=s>l;if(e._bLimitReached){if(r){n=t-l+1;a=n}else{n=t+l-1}s=l+1}}var c=false;i.loadContexts(e.getTableBinding(),a,s).then(function(t){t.forEach(function(t){if(!g(t)||t.isSelected()){return}if(r&&t.getIndex()>=n||t.getIndex()<=n){t.setSelected(true);c=true}if(t.getIndex()===n){e._oRangeSelectionStartContext=t}});if(e.isLimitReached()){i.scrollTableToIndex(o,n,r).then(function(){if(e.getEnableNotification()){i.showNotificationPopoverAtIndex(o,n,e.getLimit())}})}if(c){e.fireSelectionChange()}})}function g(e){var t="hierarchyQualifier"in(e.getBinding().getAggregation()||{});return t||e.getProperty("@$ui5.node.isExpanded")===undefined&&!e.getProperty("@$ui5.node.isTotal")}a.prototype.clearSelection=function(){var e=false;this.getSelectedContexts().forEach(function(t){if(!e&&t.isSelected()){e=true}t.setSelected(false)});if(e&&!this._bSuppressSelectionChangeEvent){this.fireSelectionChange()}this._bSuppressSelectionChangeEvent=false};a.prototype.getSelectedContexts=function(){var e=this.getTableBinding();return e?e.getAllCurrentContexts().filter(function(e){return e.isSelected()}):[]};a.prototype.onThemeChanged=function(){this.oDeselectAllIcon.setSrc(o.getIconURI(i.ThemeParameters.clearSelectionIcon))};return a});
/*
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/plugins/PluginBase", ["../utils/TableUtils","sap/ui/core/Element"],function(t,e){"use strict";var i=t.Hook.Keys;var n={};var o=t.createWeakMapFacade();var a=e.extend("sap.ui.table.plugins.PluginBase",{metadata:{abstract:true,library:"sap.ui.table"}});a.getPlugin=function(t,e=a){if(!t){return}if(typeof e==="function"&&e.getMetadata){e=e.getMetadata().getName()}const i=function(t){return t.isA(e)&&t.isA(["sap.m.plugins.PluginBase","sap.ui.table.plugins.PluginBase"])};return t.getDependents().find(i)||t.findElements(false,i)[0]};a.findOn=function(t){return a.getPlugin(t,this)};a.prototype.init=function(){e.prototype.init.apply(this,arguments);o(this).bIsActive=false};a.prototype.exit=function(){e.prototype.exit.apply(this,arguments);this.deactivate()};a.prototype.onActivate=function(t){};a.prototype.onDeactivate=function(t){};a.prototype.isActive=function(){return o(this).bIsActive};a.prototype.isApplicable=function(e){return t.isA(e,"sap.ui.table.Table")};a.prototype.setParent=function(t){this.deactivate();e.prototype.setParent.apply(this,arguments);if(t){if(!this.isApplicable(this.getTable())){throw new Error(this+" is not applicable to "+t)}this.activate()}return this};a.prototype.onTableBindRows=function(){};n[i.Table.BindRows]=function(t){this.onTableBindRows(t)};a.prototype.onTableRowsBound=function(t){};n[i.Table.RowsBound]=function(t){this.onTableRowsBound(t)};a.prototype.onTableUnbindRows=function(){};n[i.Table.UnbindRows]=function(){this.onTableUnbindRows()};a.prototype.getTable=function(){var e=this.getParent();return t.isA(e,"sap.ui.table.Table")?e:null};a.prototype.getTableBinding=function(){var t=this.getTable();var e=t?t.getBinding():null;return e?e:null};a.prototype.setRowCountConstraints=function(t){var e=this.getTable();if(e){e._setRowCountConstraints(t)}};a.prototype.activate=function(){var e=this.getTable();if(!e||this.isActive()){return}t.Hook.install(e,n,this);this.onActivate(e);var i=this.getTableBinding();if(i){this.onTableRowsBound(i)}o(this).bIsActive=true};a.prototype.deactivate=function(){var e=this.getTable();if(!this.isActive()){return}t.Hook.uninstall(e,n,this);this.onDeactivate(e);o(this).bIsActive=false};return a});
/*
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/plugins/SelectionModelSelection", ["sap/ui/model/SelectionModel","./SelectionPlugin","../utils/TableUtils","../library"],function(e,t,o,i){"use strict";var n=i.SelectionMode;var l=t.extend("sap.ui.table.plugins.SelectionModelSelection",{metadata:{library:"sap.ui.table",properties:{selectionMode:{type:"sap.ui.table.SelectionMode",group:"Behavior",defaultValue:n.MultiToggle}},events:{selectionChange:{parameters:{indices:{type:"int[]"},selectAll:{type:"boolean"}}}}}});l.prototype.init=function(){t.prototype.init.apply(this,arguments);this.oSelectionModel=new e(c(this.getSelectionMode()))};l.prototype.exit=function(){t.prototype.exit.apply(this,arguments);if(this.oSelectionModel){this.oSelectionModel.destroy();this.oSelectionModel=null}};l.prototype.onActivate=function(e){t.prototype.onActivate.apply(this,arguments);this.oSelectionModel.attachSelectionChanged(s,this);o.Hook.register(e,o.Hook.Keys.Table.TotalRowCountChanged,S,this);this._iTotalRowCount=e._getTotalRowCount()};l.prototype.onDeactivate=function(e){t.prototype.onDeactivate.apply(this,arguments);this.oSelectionModel.detachSelectionChanged(s,this);this.oSelectionModel.clearSelection();d(this,this.getTableBinding());o.Hook.deregister(e,o.Hook.Keys.Table.TotalRowCountChanged,S,this)};l.prototype.setSelected=function(e,t,o){if(!this.isIndexSelectable(e.getIndex())){return}if(o&&o.range){var i=this.getSelectedIndex();if(i>=0){this.addSelectionInterval(i,e.getIndex())}}else if(t){this.addSelectionInterval(e.getIndex(),e.getIndex())}else{this.removeSelectionInterval(e.getIndex(),e.getIndex())}};l.prototype.isSelected=function(e){return this.isIndexSelected(e.getIndex())};l.prototype.getRenderConfig=function(){return{headerSelector:{type:"toggle",visible:o.hasSelectAll(this.getTable()),selected:this.getSelectableCount()>0&&this.getSelectableCount()===this.getSelectedCount()}}};function r(e){var t=e.getTable(),o;if(e.getSelectableCount()>e.getSelectedCount()){t._iSourceRowIndex=0;e.selectAll();o=true}else{t._iSourceRowIndex=-1;e.clearSelection();o=false}t._iSourceRowIndex=undefined;return o}l.prototype.onHeaderSelectorPress=function(){if(this.getRenderConfig().headerSelector.visible){r(this)}};l.prototype.onKeyboardShortcut=function(e,t){if(e==="toggle"&&r(this)===false){t?.setMarked("sapUiTableClearAll")}else if(e==="clear"){this.clearSelection();t?.setMarked("sapUiTableClearAll")}};l.prototype.addSelectionInterval=function(e,t){if(!this.oSelectionModel||this.getSelectionMode()===n.None){return}this.oSelectionModel.addSelectionInterval(e,t)};l.prototype.clearSelection=function(){if(this.oSelectionModel){this.oSelectionModel.clearSelection()}};l.prototype.getSelectedIndex=function(){if(this.oSelectionModel){return this.oSelectionModel.getLeadSelectedIndex()}return-1};l.prototype.getSelectedIndices=function(){if(this.oSelectionModel){return this.oSelectionModel.getSelectedIndices()}return[]};l.prototype.getSelectableCount=function(){var e=this.getTableBinding();return e?e.getLength():0};l.prototype.getSelectedCount=function(){return this.getSelectedIndices().length};l.prototype.isIndexSelectable=function(e){return e>=0&&e<=this._getHighestSelectableIndex()};l.prototype.isIndexSelected=function(e){return this.getSelectedIndices().indexOf(e)!==-1};l.prototype.removeSelectionInterval=function(e,t){if(this.oSelectionModel){this.oSelectionModel.removeSelectionInterval(e,t)}};l.prototype.selectAll=function(){if(!this.oSelectionModel||this.getSelectionMode()!==n.MultiToggle){return}this.oSelectionModel.selectAll(this._getHighestSelectableIndex())};l.prototype.setSelectedIndex=function(e){if(this.getSelectionMode()===n.None){return}if(e===-1){this.clearSelection()}else{this.setSelectionInterval(e,e)}};l.prototype.setSelectionInterval=function(e,t){if(!this.oSelectionModel||this.getSelectionMode()===n.None){return}this.oSelectionModel.setSelectionInterval(e,t)};l.prototype.setSelectionMode=function(e){var t=this.getSelectionMode();this.setProperty("selectionMode",e);if(this.getSelectionMode()!==t){this.clearSelection()}if(this.oSelectionModel){this.oSelectionModel.setSelectionMode(c(this.getSelectionMode()))}return this};function c(t){return t===n.MultiToggle?e.MULTI_SELECTION:e.SINGLE_SELECTION}l.prototype._getHighestSelectableIndex=function(){var e=this.getTableBinding();return e?e.getLength()-1:-1};l.prototype.onTableRowsBound=function(e){t.prototype.onTableRowsBound.apply(this,arguments);a(this,e)};l.prototype.onTableUnbindRows=function(){t.prototype.onTableUnbindRows.apply(this,arguments);this._bSuppressSelectionChangeEvent=true;this.clearSelection();delete this._bSuppressSelectionChangeEvent};function s(e){var t=e.getParameter("rowIndices");var o=e.getParameter("selectAll");if(!this._bSuppressSelectionChangeEvent){this.fireSelectionChange({rowIndices:t,selectAll:o,_internalTrigger:this._bInternalTrigger})}}function a(e,t){if(t){t.attachChange(h,e)}}function d(e,t){if(t){t.detachChange(h,e)}}function h(e){var t=typeof e==="object"?e.getParameter("reason"):e;if(t==="sort"||t==="filter"){this.clearSelection()}}function S(){var e=this.getTable()._getTotalRowCount();if(this._iTotalRowCount>0&&this._iTotalRowCount!==e){this._bInternalTrigger=true;this.clearSelection();delete this._bInternalTrigger}this._iTotalRowCount=e}return l});
/*
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/plugins/SelectionPlugin", ["sap/ui/core/Element","./PluginBase"],function(e,t){"use strict";var n=t.extend("sap.ui.table.plugins.SelectionPlugin",{metadata:{abstract:true,library:"sap.ui.table",properties:{enabled:{type:"boolean",defaultValue:true}},events:{selectionChange:{parameters:{}}}}});n.findOn=t.findOn;n.prototype.setParent=function(e){var n=this.getTable();t.prototype.setParent.apply(this,arguments);(e||n)._initSelectionPlugin()};n.prototype.exit=function(){t.prototype.exit.apply(this,arguments);this.getTable()?._initSelectionPlugin()};n.prototype.setEnabled=function(e){this.setProperty("enabled",e,true);if(this.getEnabled()){this.activate()}else{this.deactivate()}return this};n.prototype.getRenderConfig=function(){return{headerSelector:{type:"none"}}};n.prototype.onHeaderSelectorPress=function(){};n.prototype.onKeyboardShortcut=function(e,t){};n.prototype.setSelected=function(e,t,n){throw new Error(this+" does not implement #setSelected")};n.prototype.isSelected=function(e){throw new Error(this+" does not implement #isSelected")};n.prototype.getSelectedCount=function(){throw new Error(this+" does not implement #getSelectedCount")};return n});
/*
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/plugins/V4Aggregation", ["./PluginBase","../utils/TableUtils","sap/base/util/deepClone"],function(t,e,o){"use strict";function i(t,o){var i="TBL_ROW_GROUP_TITLE";var r=[o.property.label,t.getProperty(o.property.path,true)];if(o.textProperty){i="TBL_ROW_GROUP_TITLE_FULL";r.push(t.getProperty(o.textProperty.path,true))}return e.getResourceText(i,r)}var r=t.extend("sap.ui.table.plugins.V4Aggregation",{metadata:{library:"sap.ui.table",properties:{totalSummaryOnTop:{type:"string",defaultValue:"Off"},totalSummaryOnBottom:{type:"string",defaultValue:"Fixed"},groupSummary:{type:"string",defaultValue:"Bottom"},groupHeaderFormatter:{type:"function"}}}});r.prototype.isApplicable=function(e){return t.prototype.isApplicable.apply(this,arguments)&&e.getMetadata().getName()==="sap.ui.table.Table"};r.prototype.activate=function(){var e=this.getTableBinding();if(e&&!e.isA("sap.ui.model.odata.v4.ODataListBinding")){return}t.prototype.activate.apply(this,arguments)};r.prototype.onActivate=function(t){this.setRowCountConstraints({fixedTop:false,fixedBottom:false});e.Grouping.setToDefaultGroupMode(t);e.Hook.register(t,e.Hook.Keys.Row.UpdateState,this.updateRowState,this);e.Hook.register(t,e.Hook.Keys.Row.Expand,g,this);e.Hook.register(t,e.Hook.Keys.Row.Collapse,u,this)};r.prototype.onDeactivate=function(t){this._mGroup=undefined;this._mAggregate=undefined;this._aGroupLevels=undefined;this._mColumnState=undefined;this.setRowCountConstraints();a(this);e.Grouping.setToDefaultFlatMode(t);e.Hook.deregister(t,e.Hook.Keys.Row.UpdateState,this.updateRowState,this);e.Hook.deregister(this,e.Hook.Keys.Row.Expand,g,this);e.Hook.deregister(this,e.Hook.Keys.Row.Collapse,u,this);var o=t.getBinding();if(o){o.setAggregation()}};function a(t){var e=t.getTable();if(e){e.getColumns().forEach(function(t){t._setCellContentVisibilitySettings()})}}function n(t){var e=t.getTable();var o=t.getGroupSummary();if(!e||!t._mColumnState){return}e.getColumns().forEach(function(e){var i=t._mColumnState[e.getId()];if(i){e._setCellContentVisibilitySettings({groupHeader:{expanded:!!i.subtotals&&(o==="Top"||o==="TopAndBottom"),collapsed:!!i.subtotals&&(o==="Bottom"||o==="TopAndBottom")},summary:{group:!!i.subtotals,total:!!i.grandTotal}})}else{e._setCellContentVisibilitySettings()}})}r.prototype.onTableRowsBound=function(t){if(!t.getModel().isA("sap.ui.model.odata.v4.ODataModel")){this.deactivate()}};r.prototype.onTableBindRows=function(t){t.parameters=t.parameters||{};t.parameters.$$aggregation=this.getAggregationInfo()};r.prototype.updateRowState=function(t){var e=t.context.getProperty("@$ui5.node.level");var o=t.context.getProperty("@$ui5.node.isTotal");var r=t.context.getProperty("@$ui5.node.isExpanded")===undefined;var a=e===0&&o;var n=e>0&&!r;var s=!n&&o;t.level=e;t.expandable=n;t.expanded=t.context.getProperty("@$ui5.node.isExpanded")===true;if(a||s){t.type=t.Type.Summary;t.level++}else if(n){t.type=t.Type.GroupHeader}if(n){var g=this._aGroupLevels[e-1];var u=this.getGroupHeaderFormatter();var p=u?u(t.context,g.property.name):undefined;if(p===undefined){t.title=i(t.context,g)}else if(typeof p!=="string"){throw new Error("The group header title must be a string or undefined")}else{t.title=p}}};r.prototype.setPropertyInfos=function(t){this._aPropertyInfos=t};r.prototype.getPropertyInfos=function(){return this._aPropertyInfos||[]};r.prototype.findPropertyInfo=function(t){return this.getPropertyInfos().find(function(e){return e.name===t})};r.prototype.setAggregationInfo=function(t){t=Object.assign({columnState:{}},t);if(!Array.isArray(t.visible)){this._mGroup=undefined;this._mAggregate=undefined;this._aGroupLevels=undefined;this._sSearch=undefined}else{var e=[];var o=[];var i;this._mGroup=this.getPropertyInfos().reduce(function(t,e){if(e.key){t[e.path]={};i=s(this,e);if(i){t[e.path].additionally=i;o.concat(i)}}return t}.bind(this),{});this._mAggregate={};var r=t.visible.concat();if(t.groupLevels){t.groupLevels.forEach(function(t){if(r.indexOf(t)<0){r.push(t)}})}r.forEach(function(r){var a=this.findPropertyInfo(r);if(!a){return}if(a.groupable){this._mGroup[a.path]={};i=s(this,a);if(i){this._mGroup[a.path].additionally=i;o=o.concat(i)}}if(a.aggregatable){this._mAggregate[a.path]={};if(t.grandTotal&&t.grandTotal.indexOf(r)>=0){this._mAggregate[a.path].grandTotal=true}if(t.subtotals&&t.subtotals.indexOf(r)>=0){this._mAggregate[a.path].subtotals=true}if(a.unit){var n=this.findPropertyInfo(a.unit);if(n){this._mAggregate[a.path].unit=n.path;e.push(n.path)}}if(a.aggregationDetails&&a.aggregationDetails.customAggregate&&a.aggregationDetails.customAggregate.contextDefiningProperties){a.aggregationDetails.customAggregate.contextDefiningProperties.forEach(function(t){var e=this.findPropertyInfo(t);if(e){this._mGroup[e.path]={};i=s(this,a);if(i){this._mGroup[e.path].additionally=i;o=o.concat(i)}}}.bind(this))}}}.bind(this));this._aGroupLevels=[];if(t.groupLevels){t.groupLevels.forEach(function(t){var e=this.findPropertyInfo(t);if(e){this._aGroupLevels.push({property:e,textProperty:this.findPropertyInfo(e.text)})}}.bind(this))}Object.keys(this._mGroup).forEach(function(t){if(this._mAggregate.hasOwnProperty(t)){if(this._mAggregate[t].grandTotal||this._mAggregate[t].subtotals){delete this._mGroup[t];return}else{delete this._mAggregate[t]}}if(this._mGroup[t].additionally){this._mGroup[t].additionally=this._mGroup[t].additionally.filter(function(t){return e.indexOf(t)===-1})}if(o.indexOf(t)>-1){delete this._mGroup[t]}}.bind(this));this._sSearch=t.search}this._mColumnState=t.columnState;n(this);this.updateAggregation()};r.prototype.getAggregationInfo=function(){if(!Object.keys(this._mGroup||{}).length&&!Object.keys(this._mAggregate||{}).length){return}var t={aggregate:o(this._mAggregate),group:o(this._mGroup),groupLevels:this._aGroupLevels?this._aGroupLevels.map(function(t){return t.property.path}):undefined,search:this._sSearch};if(t.aggregate){p(this,t);l(this,t)}return t};function s(t,e){if(e.text){var o=t.findPropertyInfo(e.text);if(o){return[o.path]}}return null}function g(t){var e=t.getRowBindingContext();if(e){e.expand()}}function u(t){var e=t.getRowBindingContext();if(e){e.collapse()}}r.prototype.setTotalSummaryOnTop=function(t){this.setProperty("totalSummaryOnTop",t,true);this.updateAggregation()};r.prototype.setTotalSummaryOnBottom=function(t){this.setProperty("totalSummaryOnBottom",t,true);this.updateAggregation()};r.prototype.setGroupSummary=function(t){this.setProperty("groupSummary",t,true);n(this);this.updateAggregation()};r.prototype.updateAggregation=function(){var t=this.getTableBinding();if(t){t.setAggregation(this.getAggregationInfo())}};function p(t,e){var o=t.getTotalSummaryOnTop();var i=t.getTotalSummaryOnBottom();var r=o==="On"||o==="Fixed";var a=i==="On"||i==="Fixed";var n=Object.keys(e.aggregate).some(function(t){return e.aggregate[t].grandTotal});if(r&&a){e.grandTotalAtBottomOnly=false}else if(a){e.grandTotalAtBottomOnly=true}else if(r){e.grandTotalAtBottomOnly=undefined}else{Object.keys(e.aggregate).forEach(function(t){delete e.aggregate[t].grandTotal})}t.setRowCountConstraints({fixedTop:o==="Fixed"&&n,fixedBottom:i==="Fixed"&&n})}function l(t,e){var o=t.getGroupSummary();if(o==="Top"){e.subtotalsAtBottomOnly=undefined}else if(o==="Bottom"){e.subtotalsAtBottomOnly=true}else if(o==="TopAndBottom"){e.subtotalsAtBottomOnly=false}else{Object.keys(e.aggregate).forEach(function(t){delete e.aggregate[t].subtotals})}}return r});
/*
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/rowmodes/Auto", ["../utils/TableUtils","./RowMode","sap/ui/Device","sap/ui/thirdparty/jquery"],function(t,e,o,jQuery){"use strict";var i=t.createWeakMapFacade();var a=e.extend("sap.ui.table.rowmodes.Auto",{metadata:{library:"sap.ui.table",properties:{minRowCount:{type:"int",defaultValue:5,group:"Appearance"},maxRowCount:{type:"int",defaultValue:-1,group:"Appearance"},fixedTopRowCount:{type:"int",defaultValue:0,group:"Appearance"},fixedBottomRowCount:{type:"int",defaultValue:0,group:"Appearance"},rowContentHeight:{type:"int",defaultValue:0,group:"Appearance"},hideEmptyRows:{type:"boolean",defaultValue:false,group:"Appearance",visibility:"hidden"}}},constructor:function(t){Object.defineProperty(this,"bLegacy",{value:typeof t==="boolean"?t:false});e.apply(this,arguments)}});var s={};function n(t){var e=t.getTable();var i=e?e.getDomRef("tableCCnt"):null;if(i&&o.browser.chrome&&window.devicePixelRatio!==1){var a=document.createElement("table");var s=a.insertRow();var n=t.getRowContentHeight();var r;a.classList.add("sapUiTableCtrl");s.classList.add("sapUiTableTr");if(n>0){s.style.height=t.getBaseRowHeightOfTable()+"px"}i.appendChild(a);r=s.getBoundingClientRect().height;i.removeChild(a);return r}else{return t.getBaseRowHeightOfTable()}}a.prototype.init=function(){e.prototype.init.apply(this,arguments);i(this).iPendingStartTableUpdateSignals=0;i(this).bRowCountAutoAdjustmentActive=false;i(this).iLastAvailableSpace=0;i(this).rowCount=-1;i(this).bTableIsFlexItem=false;i(this).adjustRowCountToAvailableSpaceAsync=t.throttleFrameWise(this.adjustRowCountToAvailableSpace.bind(this))};a.prototype.attachEvents=function(){e.prototype.attachEvents.apply(this,arguments);t.addDelegate(this.getTable(),s,this)};a.prototype.detachEvents=function(){e.prototype.detachEvents.apply(this,arguments);t.removeDelegate(this.getTable(),s)};a.prototype.cancelAsyncOperations=function(){e.prototype.cancelAsyncOperations.apply(this,arguments);this.stopAutoRowMode()};a.prototype.registerHooks=function(){e.prototype.registerHooks.apply(this,arguments);t.Hook.register(this.getTable(),t.Hook.Keys.Table.RefreshRows,this._onTableRefreshRows,this);t.Hook.register(this.getTable(),t.Hook.Keys.Table.UpdateSizes,this._onUpdateTableSizes,this)};a.prototype.deregisterHooks=function(){e.prototype.deregisterHooks.apply(this,arguments);t.Hook.deregister(this.getTable(),t.Hook.Keys.Table.RefreshRows,this._onTableRefreshRows,this);t.Hook.deregister(this.getTable(),t.Hook.Keys.Table.UpdateSizes,this._onUpdateTableSizes,this)};a.prototype.getFixedTopRowCount=function(){if(this.bLegacy){var t=this.getTable();return t?t.getFixedRowCount():0}return this.getProperty("fixedTopRowCount")};a.prototype.getFixedBottomRowCount=function(){if(this.bLegacy){var t=this.getTable();return t?t.getFixedBottomRowCount():0}return this.getProperty("fixedBottomRowCount")};a.prototype.getMinRowCount=function(){if(this.bLegacy){var t=this.getTable();return t?t.getMinAutoRowCount():0}return this.getProperty("minRowCount")};a.prototype.getRowContentHeight=function(){if(this.bLegacy){var t=this.getTable();return t?t.getRowHeight():0}return this.getProperty("rowContentHeight")};a.prototype.setHideEmptyRows=function(t){this.setProperty("hideEmptyRows",t);if(t){this.disableNoData()}else{this.enableNoData()}return this};a.prototype.getHideEmptyRows=function(){return this.getProperty("hideEmptyRows")};a.prototype._getMinRowCount=function(){var t=this.getMinRowCount();var e=this.getMaxRowCount();if(e>=0){return Math.min(t,e)}else{return t}};a.prototype.getMinRequestLength=function(){var e=this.getTable();var i=this.getConfiguredRowCount();if(u(this)||e&&!e._bContextsAvailable){var a=Math.ceil(o.resize.height/t.DefaultRowHeight.sapUiSizeCondensed);i=Math.max(i,a)}return i};a.prototype.updateTable=function(){if(this.getHideEmptyRows()&&this.getComputedRowCounts().count===0){var t=this.getConfiguredRowCount();if(t>0){this.getRowContexts(t)}}return e.prototype.updateTable.apply(this,arguments)};a.prototype.getComputedRowCounts=function(){if(u(this)){return{count:0,scrollable:0,fixedTop:0,fixedBottom:0}}var t=this.getConfiguredRowCount();var e=this.getFixedTopRowCount();var o=this.getFixedBottomRowCount();if(this.getHideEmptyRows()){t=Math.min(t,this.getTotalRowCountOfTable())}return this.computeStandardizedRowCounts(t,e,o)};a.prototype.getTableStyles=function(){var t="0px";if(u(this)){t="auto"}else{var e=this.getConfiguredRowCount();if(e===0||e===this._getMinRowCount()){t="auto"}}return{height:t}};a.prototype.getTableBottomPlaceholderStyles=function(){if(!this.getHideEmptyRows()){return undefined}var t;if(u(this)){t=this._getMinRowCount()}else{t=this.getConfiguredRowCount()-this.getComputedRowCounts().count}return{height:t*this.getBaseRowHeightOfTable()+"px"}};a.prototype.getRowContainerStyles=function(){return{height:this.getComputedRowCounts().count*Math.max(this.getBaseRowHeightOfTable(),n(this))+"px"}};a.prototype.renderRowStyles=function(t){var e=this.getRowContentHeight();if(e>0){t.style("height",this.getBaseRowHeightOfTable()+"px")}};a.prototype.renderCellContentStyles=function(t){var e=this.getRowContentHeight();if(this.bLegacy){if(e>0){t.style("max-height",e+"px")}return}if(e<=0){e=this.getDefaultRowContentHeightOfTable()}if(e>0){t.style("max-height",e+"px")}};a.prototype.getBaseRowContentHeight=function(){return Math.max(0,this.getRowContentHeight())};a.prototype._onTableRefreshRows=function(){var t=this.getConfiguredRowCount();if(t>0){if(!u(this)){this.initTableRowsAfterDataRequested(t)}this.getRowContexts(t)}};a.prototype.getConfiguredRowCount=function(){var t=Math.max(0,this.getMinRowCount(),i(this).rowCount);var e=this.getMaxRowCount();if(e>=0){t=Math.min(t,e)}return t};a.prototype.startAutoRowMode=function(){i(this).adjustRowCountToAvailableSpaceAsync(t.RowsUpdateReason.Render,true)};a.prototype.stopAutoRowMode=function(){this.deregisterResizeHandler();i(this).adjustRowCountToAvailableSpaceAsync.cancel();i(this).bRowCountAutoAdjustmentActive=false;l(this)};a.prototype.registerResizeHandler=function(e){var o=this.getTable();if(o){t.registerResizeHandler(o,"AutoRowMode",this.onResize.bind(this),null,e===true);t.registerResizeHandler(o,"AutoRowMode-BeforeTable",this.onResize.bind(this),"before");t.registerResizeHandler(o,"AutoRowMode-AfterTable",this.onResize.bind(this),"after")}};a.prototype.deregisterResizeHandler=function(){var e=this.getTable();if(e){t.deregisterResizeHandler(e,["AutoRowMode, AutoRowMode-BeforeTable, AutoRowMode-AfterTable"])}};a.prototype.onResize=function(e){var o=e.oldSize.height;var a=e.size.height;if(o!==a){r(this);i(this).adjustRowCountToAvailableSpaceAsync(t.RowsUpdateReason.Resize)}};a.prototype._onUpdateTableSizes=function(e){if(e===t.RowsUpdateReason.Resize||e===t.RowsUpdateReason.Render){return}if(i(this).bRowCountAutoAdjustmentActive){r(this);i(this).adjustRowCountToAvailableSpaceAsync(e)}};a.prototype.adjustRowCountToAvailableSpace=function(e,o){o=o===true;var a=this.getTable();var s=a?a.getDomRef():null;if(!a||a._bInvalid||!s||!sap.ui.getCore().isThemeApplied()){l(this);return}i(this).bTableIsFlexItem=window.getComputedStyle(s.parentNode).display==="flex";if(s.scrollHeight===0){if(o){this.registerResizeHandler(!i(this).bTableIsFlexItem);i(this).bRowCountAutoAdjustmentActive=true}l(this);return}var r=this.determineAvailableSpace();var u=this.getConfiguredRowCount();var h=Math.floor(r/n(this));var p=this.getComputedRowCounts().count;var g;i(this).rowCount=h;g=this.getComputedRowCounts().count;if(this.bLegacy){a.setProperty("visibleRowCount",g,true)}if(p!==g){this.updateTable(e)}else{if(u!==h||e===t.RowsUpdateReason.Zoom){this.applyTableStyles();this.applyRowContainerStyles();this.applyTableBottomPlaceholderStyles()}if(!this._bFiredRowsUpdatedAfterRendering&&a.getRows().length>0){this.fireRowsUpdated(e)}}if(o){this.registerResizeHandler(!i(this).bTableIsFlexItem);i(this).bRowCountAutoAdjustmentActive=true}l(this)};a.prototype.determineAvailableSpace=function(){var t=this.getTable();var e=t?t.getDomRef():null;var a=t?t.getDomRef("tableCCnt"):null;var s=t?t.getDomRef("placeholder-bottom"):null;if(!e||!a||!e.parentNode){return 0}var n=0;var r=a.clientHeight;var l=s?s.clientHeight:0;if(i(this).bTableIsFlexItem){var u=e.childNodes;for(var h=0;h<u.length;h++){n+=u[h].offsetHeight}n-=r-l}else{n=e.scrollHeight-r-l}var p=t._getScrollExtension();if(!p.isHorizontalScrollbarVisible()){var g={};g[o.browser.BROWSER.CHROME]=16;g[o.browser.BROWSER.FIREFOX]=16;g[o.browser.BROWSER.SAFARI]=16;g[o.browser.BROWSER.ANDROID]=8;n+=g[o.browser.name]}var d=i(this).bTableIsFlexItem?e:e.parentNode;var R=Math.max(0,Math.floor(jQuery(d).height()-n));var f=Math.abs(R-i(this).iLastAvailableSpace);if(f>=5){i(this).iLastAvailableSpace=R}return i(this).iLastAvailableSpace};s.onBeforeRendering=function(t){var e=t&&t.isMarked("renderRows");if(!e){this.stopAutoRowMode()}};s.onAfterRendering=function(t){var e=t&&t.isMarked("renderRows");if(!e){this.startAutoRowMode()}};function r(e){i(e).iPendingStartTableUpdateSignals++;t.Hook.call(e.getTable(),t.Hook.Keys.Signal,"StartTableUpdate")}function l(e){for(var o=0;o<i(e).iPendingStartTableUpdateSignals;o++){t.Hook.call(e.getTable(),t.Hook.Keys.Signal,"EndTableUpdate")}i(e).iPendingStartTableUpdateSignals=0}function u(t){return i(t).rowCount===-1}return a});
/*
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/rowmodes/Fixed", ["./RowMode","../utils/TableUtils"],function(t,e){"use strict";var o=t.extend("sap.ui.table.rowmodes.Fixed",{metadata:{library:"sap.ui.table",properties:{rowCount:{type:"int",defaultValue:10,group:"Appearance"},fixedTopRowCount:{type:"int",defaultValue:0,group:"Appearance"},fixedBottomRowCount:{type:"int",defaultValue:0,group:"Appearance"},rowContentHeight:{type:"int",defaultValue:0,group:"Appearance"},hideEmptyRows:{type:"boolean",defaultValue:false,group:"Appearance",visibility:"hidden"}}},constructor:function(e){Object.defineProperty(this,"bLegacy",{value:typeof e==="boolean"?e:false});t.apply(this,arguments)}});var i={};o.prototype.attachEvents=function(){t.prototype.attachEvents.apply(this,arguments);e.addDelegate(this.getTable(),i,this)};o.prototype.detachEvents=function(){t.prototype.detachEvents.apply(this,arguments);e.removeDelegate(this.getTable(),i)};o.prototype.registerHooks=function(){t.prototype.registerHooks.apply(this,arguments);e.Hook.register(this.getTable(),e.Hook.Keys.Table.RefreshRows,this._onTableRefreshRows,this)};o.prototype.deregisterHooks=function(){t.prototype.deregisterHooks.apply(this,arguments);e.Hook.deregister(this.getTable(),e.Hook.Keys.Table.RefreshRows,this._onTableRefreshRows,this)};o.prototype.getRowCount=function(){if(this.bLegacy){var t=this.getTable();return t?t.getVisibleRowCount():0}return this.getProperty("rowCount")};o.prototype.getFixedTopRowCount=function(){if(this.bLegacy){var t=this.getTable();return t?t.getFixedRowCount():0}return this.getProperty("fixedTopRowCount")};o.prototype.getFixedBottomRowCount=function(){if(this.bLegacy){var t=this.getTable();return t?t.getFixedBottomRowCount():0}return this.getProperty("fixedBottomRowCount")};o.prototype.getRowContentHeight=function(){if(this.bLegacy){var t=this.getTable();return t?t.getRowHeight():0}return this.getProperty("rowContentHeight")};o.prototype.setHideEmptyRows=function(t){this.setProperty("hideEmptyRows",t);if(t){this.disableNoData()}else{this.enableNoData()}return this};o.prototype.getHideEmptyRows=function(){return this.getProperty("hideEmptyRows")};o.prototype.getMinRequestLength=function(){return Math.max(0,this.getRowCount())};o.prototype.updateTable=function(){if(this.getHideEmptyRows()&&this.getComputedRowCounts().count===0){var e=this.getRowCount();if(e>0){this.getRowContexts(e)}}return t.prototype.updateTable.apply(this,arguments)};o.prototype.getComputedRowCounts=function(){var t=this.getRowCount();var e=this.getFixedTopRowCount();var o=this.getFixedBottomRowCount();if(this.getHideEmptyRows()){t=Math.min(t,this.getTotalRowCountOfTable())}return this.computeStandardizedRowCounts(t,e,o)};o.prototype.getTableStyles=function(){return{height:"auto"}};o.prototype.getTableBottomPlaceholderStyles=function(){if(!this.getHideEmptyRows()){return undefined}var t=Math.max(0,this.getRowCount()-this.getComputedRowCounts().count);return{height:t*this.getBaseRowHeightOfTable()+"px"}};o.prototype.getRowContainerStyles=function(){var t=this.getComputedRowCounts().count*this.getBaseRowHeightOfTable()+"px";if(this.bLegacy&&!e.isVariableRowHeightEnabled(this.getTable())){return{minHeight:t}}return{height:t}};o.prototype.renderRowStyles=function(t){var e=this.getRowContentHeight();if(e>0){t.style("height",this.getBaseRowHeightOfTable()+"px")}};o.prototype.renderCellContentStyles=function(t){var e=this.getRowContentHeight();if(this.bLegacy){return}if(e<=0){e=this.getDefaultRowContentHeightOfTable()}if(e>0){t.style("max-height",e+"px")}};o.prototype.getBaseRowContentHeight=function(){return Math.max(0,this.getRowContentHeight())};o.prototype._onTableRefreshRows=function(){var t=this.getRowCount();if(t>0){if(e.isVariableRowHeightEnabled(this.getTable())){t++}this.initTableRowsAfterDataRequested(t);this.getRowContexts(t)}};i.onAfterRendering=function(t){var o=this.getTable();var i=t&&t.isMarked("renderRows");if(!i&&o.getRows().length>0){this.fireRowsUpdated(e.RowsUpdateReason.Render)}};return o});
/*
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/rowmodes/Interactive", ["./RowMode","../utils/TableUtils","sap/ui/thirdparty/jquery"],function(t,e,jQuery){"use strict";var o=t.extend("sap.ui.table.rowmodes.Interactive",{metadata:{library:"sap.ui.table",final:true,properties:{rowCount:{type:"int",defaultValue:10,group:"Appearance"},minRowCount:{type:"int",defaultValue:5,group:"Appearance"},fixedTopRowCount:{type:"int",defaultValue:0,group:"Appearance"},fixedBottomRowCount:{type:"int",defaultValue:0,group:"Appearance"},rowContentHeight:{type:"int",defaultValue:0,group:"Appearance"}}},constructor:function(e){Object.defineProperty(this,"bLegacy",{value:typeof e==="boolean"?e:false});t.apply(this,arguments)}});var i={};var n={};o.prototype.attachEvents=function(){t.prototype.attachEvents.apply(this,arguments);e.addDelegate(this.getTable(),i,this)};o.prototype.detachEvents=function(){t.prototype.detachEvents.apply(this,arguments);e.removeDelegate(this.getTable(),i)};o.prototype.registerHooks=function(){t.prototype.registerHooks.apply(this,arguments);e.Hook.register(this.getTable(),e.Hook.Keys.Table.RefreshRows,this._onTableRefreshRows,this)};o.prototype.deregisterHooks=function(){t.prototype.deregisterHooks.apply(this,arguments);e.Hook.deregister(this.getTable(),e.Hook.Keys.Table.RefreshRows,this._onTableRefreshRows,this)};o.prototype.getRowCount=function(){if(this.bLegacy){var t=this.getTable();return t?t.getVisibleRowCount():0}return this.getProperty("rowCount")};o.prototype.getFixedTopRowCount=function(){if(this.bLegacy){var t=this.getTable();return t?t.getFixedRowCount():0}return this.getProperty("fixedTopRowCount")};o.prototype.getFixedBottomRowCount=function(){if(this.bLegacy){var t=this.getTable();return t?t.getFixedBottomRowCount():0}return this.getProperty("fixedBottomRowCount")};o.prototype.getMinRowCount=function(){if(this.bLegacy){var t=this.getTable();return t?t.getMinAutoRowCount():0}return this.getProperty("minRowCount")};o.prototype.getRowContentHeight=function(){if(this.bLegacy){var t=this.getTable();return t?t.getRowHeight():0}return this.getProperty("rowContentHeight")};o.prototype.getMinRequestLength=function(){return this.getConfiguredRowCount()};o.prototype.getComputedRowCounts=function(){var t=this.getConfiguredRowCount();var e=this.getFixedTopRowCount();var o=this.getFixedBottomRowCount();return this.computeStandardizedRowCounts(t,e,o)};o.prototype.getTableStyles=function(){return{height:"auto"}};o.prototype.getRowContainerStyles=function(){var t=this.getComputedRowCounts().count*this.getBaseRowHeightOfTable()+"px";if(this.bLegacy&&!e.isVariableRowHeightEnabled(this.getTable())){return{minHeight:t}}return{height:t}};o.prototype.renderRowStyles=function(t){var e=this.getRowContentHeight();if(e>0){t.style("height",this.getBaseRowHeightOfTable()+"px")}};o.prototype.renderCellContentStyles=function(t){var e=this.getRowContentHeight();if(this.bLegacy){return}if(e<=0){e=this.getDefaultRowContentHeightOfTable()}if(e>0){t.style("max-height",e+"px")}};o.prototype.renderInTableBottomArea=function(t){t.openStart("div",this.getTable().getId()+"-sb");t.attr("tabindex","-1");t.class("sapUiTableHeightResizer");t.style("height","5px");t.openEnd();t.close("div")};o.prototype.getBaseRowContentHeight=function(){return Math.max(0,this.getRowContentHeight())};o.prototype._onTableRefreshRows=function(){var t=this.getConfiguredRowCount();if(t>0){this.initTableRowsAfterDataRequested(t);this.getRowContexts(t)}};o.prototype.getConfiguredRowCount=function(){return Math.max(0,this.getMinRowCount(),this.getRowCount())};i.onBeforeRendering=function(t){if(this.bLegacy){this.getTable().setVisibleRowCount(this.getComputedRowCounts().count)}};i.onAfterRendering=function(t){var o=this.getTable();var i=t&&t.isMarked("renderRows");if(!i&&o.getRows().length>0){this.fireRowsUpdated(e.RowsUpdateReason.Render)}};i.onmousedown=function(t){var e=this.getTable();if(t.button===0&&t.target===e.getDomRef("sb")){n.initInteractiveResizing(e,this,t)}};n.initInteractiveResizing=function(t,e,o){var i=jQuery(document.body);var r=t.$("sb");var a=jQuery(document);var s=r.offset();var u=r.height();var p=r.width();var g=t._isTouchEvent(o);var h=document.createElement("div");h.style.width=p+"px";h.style.height=u+"px";h.style.left=s.left+"px";h.style.top=s.top+"px";h.className="sapUiTableInteractiveResizerGhost";h.id=t.getId()+"-ghost";i.append(h);var l=document.createElement("div");l.style.top="0px";l.style.bottom="0px";l.style.left="0px";l.style.right="0px";l.style.position="absolute";l.id=t.getId()+"-rzoverlay";r.append(l);a.on((g?"touchend":"mouseup")+".sapUiTableInteractiveResize",n.exitInteractiveResizing.bind(t,e));a.on((g?"touchmove":"mousemove")+".sapUiTableInteractiveResize",n.onMouseMoveWhileInteractiveResizing.bind(t));t._disableTextSelection()};n.exitInteractiveResizing=function(t,e){var o=jQuery(document);var i=this.$();var r=this.$("ghost");var a=n.getEventPosition(this,e).y;var s=a-i.find(".sapUiTableCCnt").offset().top-r.height()-i.find(".sapUiTableFtr").height();var u=Math.floor(s/t.getBaseRowHeightOfTable());var p=Math.max(1,u,t.getMinRowCount());if(t.bLegacy){p=Math.max(p,t.getFixedTopRowCount()+t.getFixedBottomRowCount()+1);this.setVisibleRowCount(p)}t.setRowCount(p);r.remove();this.$("rzoverlay").remove();o.off("touchend.sapUiTableInteractiveResize");o.off("touchmove.sapUiTableInteractiveResize");o.off("mouseup.sapUiTableInteractiveResize");o.off("mousemove.sapUiTableInteractiveResize");this._enableTextSelection()};n.onMouseMoveWhileInteractiveResizing=function(t){var e=n.getEventPosition(this,t).y;var o=this.$().offset().top;if(e>o){this.$("ghost").css("top",e+"px")}};n.getEventPosition=function(t,e){var o;function i(o){if(!t._isTouchEvent(o)){return null}var i=["touches","targetTouches","changedTouches"];for(var n=0;n<i.length;n++){var r=i[n];if(e[r]&&e[r][0]){return e[r][0]}if(e.originalEvent[r]&&e.originalEvent[r][0]){return e.originalEvent[r][0]}}return null}o=i(e)||e;return{x:o.pageX,y:o.pageY}};return o});
/*
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/rowmodes/RowMode", ["../utils/TableUtils","sap/ui/core/Element","sap/ui/thirdparty/jquery","sap/ui/Device"],function(e,t,jQuery,o){"use strict";var r=e.createWeakMapFacade();var a=t.extend("sap.ui.table.rowmodes.RowMode",{metadata:{library:"sap.ui.table",abstract:true}});var n={};a.prototype.init=function(){this._bFiredRowsUpdatedAfterRendering=false;r(this).bListeningForFirstRowsUpdatedAfterRendering=false;r(this).bNoDataDisabled=false;r(this).updateTableAsync=e.throttle(this.updateTable.bind(this),50,{asyncLeading:true})};a.prototype.exit=function(){this.detachEvents();this.cancelAsyncOperations();this.deregisterHooks()};a.prototype.setParent=function(){this.detachEvents();this.cancelAsyncOperations();this.deregisterHooks();t.prototype.setParent.apply(this,arguments);this.attachEvents();this.registerHooks()};a.prototype.attachEvents=function(){e.addDelegate(this.getTable(),n,this)};a.prototype.detachEvents=function(){e.removeDelegate(this.getTable(),n)};a.prototype.cancelAsyncOperations=function(){var e=this.getTable();if(e){clearTimeout(e._mTimeouts.refreshRowsCreateRows)}r(this).updateTableAsync.cancel()};a.prototype.registerHooks=function(){var t=this.getTable();var o=e.Hook.Keys;e.Hook.register(t,o.Table.RowsUnbound,this._onTableRowsUnbound,this);e.Hook.register(t,o.Table.UpdateRows,this._onTableUpdateRows,this);e.Hook.register(t,o.TableRenderer.RenderTableStyles,this.applyTableStyles,this);e.Hook.register(t,o.TableRenderer.RenderInTableBottomArea,this.renderInTableBottomArea,this);e.Hook.register(t,o.TableRenderer.RenderRowContainerStyles,this.applyRowContainerStyles,this);e.Hook.register(t,o.TableRenderer.RenderRowStyles,this.renderRowStyles,this);e.Hook.register(t,o.TableRenderer.RenderCellContentStyles,this.renderCellContentStyles,this)};a.prototype.deregisterHooks=function(){var t=this.getTable();var o=e.Hook.Keys;e.Hook.deregister(t,o.Table.RowsUnbound,this._onTableRowsUnbound,this);e.Hook.deregister(t,o.Table.UpdateRows,this._onTableUpdateRows,this);e.Hook.deregister(t,o.TableRenderer.RenderTableStyles,this.applyTableStyles,this);e.Hook.deregister(t,o.TableRenderer.RenderInTableBottomArea,this.renderInTableBottomArea,this);e.Hook.deregister(t,o.TableRenderer.RenderRowContainerStyles,this.applyRowContainerStyles,this);e.Hook.deregister(t,o.TableRenderer.RenderRowStyles,this.renderRowStyles,this);e.Hook.deregister(t,o.TableRenderer.RenderCellContentStyles,this.renderCellContentStyles,this)};a.prototype.getMinRequestLength=function(){h(this,"getMinRequestLength")};a.prototype.getComputedRowCounts=function(){h(this,"getComputedRowCounts")};a.prototype.getTableStyles=function(){h(this,"getTableStyles")};a.prototype.getTableBottomPlaceholderStyles=function(){return undefined};a.prototype.getRowContainerStyles=function(){h(this,"getRowContainerStyles")};a.prototype.getTable=function(){var t=this.getParent();return e.isA(t,"sap.ui.table.Table")?t:null};a.prototype.updateTable=function(e){var t=this.getTable();if(!t){return}r(this).updateTableAsync.cancel();t._adjustFirstVisibleRowToTotalRowCount();var o=this.updateTableRows();if(t._bInvalid){return}this.applyTableStyles();this.applyRowContainerStyles();this.applyTableBottomPlaceholderStyles();if(o||t.getRows().some(function(e){return e.getDomRef()==null})){this.renderTableRows()}if(o||t.getRows().length>0){this.fireRowsUpdated(e)}};a.prototype.getBaseRowContentHeight=function(){return 0};a.prototype.getBaseRowHeightOfTable=function(){var e=this.getTable();return e?e._getBaseRowHeight():0};a.prototype.getDefaultRowContentHeightOfTable=function(){var e=this.getTable();return e?e._getDefaultRowContentHeight():0};a.prototype.getTotalRowCountOfTable=function(){var e=this.getTable();return e?e._getTotalRowCount():0};a.prototype._onTableRowsUnbound=function(){clearTimeout(this.getTable()._mTimeouts.refreshRowsCreateRows);this.updateTable(e.RowsUpdateReason.Unbind)};a.prototype._onTableUpdateRows=function(e){var t=this.getTable();clearTimeout(t._mTimeouts.refreshRowsCreateRows);r(this).updateTableAsync(e)};a.prototype.applyTableStyles=function(e){var t=this.getTableStyles();if(e){e.style("height",t.height);e.style("min-height",t.minHeight);e.style("max-height",t.maxHeight);return}var o=this.getTable();var r=o?o.getDomRef():null;if(r){r.style.height=t.height;r.style.minHeight=t.minHeight;r.style.maxHeight=t.maxHeight}};a.prototype.applyTableBottomPlaceholderStyles=function(e){var t=this.getTableBottomPlaceholderStyles();if(e){e.style("height",t.height);return}var o=this.getTable();var r=o?o.getDomRef("placeholder-bottom"):null;if(r){r.style.height=t.height}};a.prototype.applyRowContainerStyles=function(e){var t=this.getRowContainerStyles();if(e){e.style("height",t.height);e.style("min-height",t.minHeight);e.style("max-height",t.maxHeight);return}var o=this.getTable();var r=o?o.getDomRef("tableCCnt"):null;if(r){r.style.height=t.height;r.style.minHeight=t.minHeight;r.style.maxHeight=t.maxHeight}};a.prototype.computeStandardizedRowCounts=function(e,t,o){var r=this.getRowCountConstraints();if(r.fixedTop===true){t=1}else if(r.fixedTop===false){t=0}if(r.fixedBottom===true){o=1}else if(r.fixedBottom===false){o=0}e=Math.max(0,e);t=Math.max(0,t);o=Math.max(0,o);if(t+o>=e){o=Math.max(o>0?1:0,o-Math.max(0,t+o-(e-1)));t=Math.max(t>0?1:0,t-Math.max(0,t+o-(e-1)))}if(t+o>=e){o=0}if(t+o>=e){t=0}return{count:e,scrollable:e-t-o,fixedTop:t,fixedBottom:o}};a.prototype.getRowCountConstraints=function(){var e=this.getTable();return e?e.getProperty("rowCountConstraints")||{}:{}};a.prototype.renderRowStyles=function(e){};a.prototype.renderCellContentStyles=function(e){};a.prototype.renderInTableBottomArea=function(e){var t=this.getTableBottomPlaceholderStyles();if(t===undefined){return}e.openStart("div",this.getTable().getId()+"-placeholder-bottom");e.class("sapUiTablePlaceholder");this.applyTableBottomPlaceholderStyles(e);e.openEnd();e.close("div")};a.prototype.initTableRowsAfterDataRequested=function(e){var t=this.getTable();var o=t.getBinding();clearTimeout(t._mTimeouts.refreshRowsCreateRows);if(!o||e<=0||t.getRows().length>0){return}o.attachEventOnce("dataRequested",function(){clearTimeout(t._mTimeouts.refreshRowsCreateRows);t._mTimeouts.refreshRowsCreateRows=setTimeout(function(){if(t.getRows().length>0){return}var o=s(t,e),r;for(var a=0;a<o.length;a++){r=o[a];r.setRowBindingContext(null,t);t.addAggregation("rows",r,true)}t._bRowAggregationInvalid=false},0)})};a.prototype.updateTableRows=function(){var t=this.getTable();var o=t.getRows();var r=this.getComputedRowCounts().count;var a=false;if(e.isNoDataVisible(t)&&!t.getBinding()){r=0}else if(e.isVariableRowHeightEnabled(t)&&r>0){r++}var n=t.getDomRef("tableCCnt");var s=window.getSelection();if(n&&s.containsNode(n,true)){s.empty()}if(t._bRowAggregationInvalid){a=o.length>0;t.destroyAggregation("rows",t._bInvalid?"KeepDom":true);o=[]}if(r===o.length){l(this,o);return a}e.dynamicCall(t._getSyncExtension,function(e){e.syncRowCount(r)});i(this,r);a=true;t._bRowAggregationInvalid=false;return a};a.prototype.renderTableRows=function(){var e=this.getTable();var t=e?e.getDomRef("tableCCnt"):null;if(!t){return}var r=jQuery.Event("BeforeRendering");r.setMarked("renderRows");r.srcControl=e;e._handleEvent(r);var a=sap.ui.getCore().createRenderManager();var n=e.getRenderer();n.renderTableCCnt(a,e);a.flush(t,false,false);a.destroy();var i=jQuery.Event("AfterRendering");i.setMarked("renderRows");i.srcControl=e;e._handleEvent(i);var s=e.getRows().length>0;var l=e.getDomRef();l.querySelector(".sapUiTableCtrlBefore").setAttribute("tabindex",s?"0":"-1");l.querySelector(".sapUiTableCtrlAfter").setAttribute("tabindex",s?"0":"-1");if(o.browser.safari){var h=document.getElementById(e.getId()+"-header");var d=document.getElementById(e.getId()+"-table");d.style.width=h.style.width}};a.prototype.getRowContexts=function(e){var t=this.getTable();return t?t._getRowContexts(e):[]};a.prototype.fireRowsUpdated=function(t){var o=this.getTable();if(!o||!o._bContextsAvailable){return}if(!this._bFiredRowsUpdatedAfterRendering){t=e.RowsUpdateReason.Render;if(!r(this).bListeningForFirstRowsUpdatedAfterRendering){r(this).bListeningForFirstRowsUpdatedAfterRendering=true;o.attachEvent("_rowsUpdated",function(){this._bFiredRowsUpdatedAfterRendering=true;r(this).bListeningForFirstRowsUpdatedAfterRendering=false}.bind(this))}}o._fireRowsUpdated(t)};a.prototype.disableNoData=function(){if(this.isNoDataDisabled()){return}r(this).bNoDataDisabled=true;var e=this.getTable();if(e){e.invalidate()}};a.prototype.enableNoData=function(){if(!this.isNoDataDisabled()){return}r(this).bNoDataDisabled=false;var e=this.getTable();if(e){e.invalidate()}};a.prototype.isNoDataDisabled=function(){return r(this).bNoDataDisabled};function i(e,t){var o=e.getTable();var r=o.getRows();if(r.length<t){var a=s(o,t-r.length);r=r.concat(a);l(e,r);a.forEach(function(e){o.addAggregation("rows",e,true)})}else{for(var n=r.length-1;n>=t;n--){o.removeAggregation("rows",n,true)}r.splice(t);l(e,r)}}function s(e,t){var o=[];var r=e.getRows().length;for(var a=0;a<t;a++){o.push(e._getRowClone(r+a))}return o}function l(e,t){var o=e.getTable();if(!o||t.length===0){return}var r=e.getRowContexts(t.length);for(var a=0;a<t.length;a++){t[a].setRowBindingContext(r[a],o)}}function h(e,t){throw new Error(e+": sap.ui.table.rowmodes.RowMode subclass does not implement #"+t)}n.onBeforeRendering=function(t){var o=t&&t.isMarked("renderRows");if(!o){this._bFiredRowsUpdatedAfterRendering=false;this.updateTable(e.RowsUpdateReason.Render)}};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/rowmodes/Type", function(){"use strict";var e={Fixed:"Fixed",Auto:"Auto",Interactive:"Interactive"};return e},true);
/*
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/rowmodes/Variable", ["../library","./RowMode"],function(t,e){"use strict";var o=e.extend("sap.ui.table.rowmodes.Variable",{metadata:{library:"sap.ui.table",properties:{tableHeight:{type:"sap.ui.core.CSSSize",defaultValue:"100%",group:"Dimension"}}}});o.prototype.getComputedRowCounts=function(){var t=this.getTotalRowCountOfTable();var e=this.getHideEmptyRows()?Math.min(this.getRowCount(),t):this.getRowCount();return{count:e,fixedTopCount:this.getFixedTopRowCount(),fixedBottomCount:this.getFixedBottomRowCount()}};o.prototype.getTableHeight=function(){return{height:this.getTableHeight()}};o.prototype.getRowContainerHeight=function(){return{height:this.getComputedRowCounts().count*this.getBaseRowHeightOfTable()}};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/utils/TableUtils", ["./_GroupingUtils","./_ColumnUtils","./_MenuUtils","./_BindingUtils","./_HookUtils","../library","sap/ui/base/Object","sap/ui/core/ResizeHandler","sap/ui/core/library","sap/ui/core/theming/Parameters","sap/ui/core/Icon","sap/ui/core/Lib","sap/ui/model/ChangeReason","sap/ui/thirdparty/jquery","sap/base/util/restricted/_throttle","sap/base/Log"],function(e,t,n,i,a,o,r,l,s,u,d,c,f,jQuery,g,p){"use strict";var C=o.SelectionBehavior;var v=o.SelectionMode;var m=s.MessageType;var R;var _=null;var h={DATACELL:1<<1,COLUMNHEADER:1<<2,ROWHEADER:1<<3,ROWACTION:1<<4,COLUMNROWHEADER:1<<5,PSEUDO:1<<6};h.ANYCONTENTCELL=h.ROWHEADER|h.DATACELL|h.ROWACTION;h.ANYCOLUMNHEADER=h.COLUMNHEADER|h.COLUMNROWHEADER;h.ANYROWHEADER=h.ROWHEADER|h.COLUMNROWHEADER;h.ANY=h.ANYCONTENTCELL|h.ANYCOLUMNHEADER;var w={sapUiSizeCozy:48,sapUiSizeCompact:32,sapUiSizeCondensed:24,undefined:32};var b=1;var I=1;var S={sapUiSizeCozy:w.sapUiSizeCozy+I,sapUiSizeCompact:w.sapUiSizeCompact+I,sapUiSizeCondensed:w.sapUiSizeCondensed+I,undefined:w.undefined+I};var T={navigationIcon:"navigation-right-arrow",deleteIcon:"sys-cancel",clearSelectionIcon:"clear-all",navIndicatorWidth:3};var E={Render:"Render",VerticalScroll:"VerticalScroll",FirstVisibleRowChange:"FirstVisibleRowChange",Unbind:"Unbind",Animation:"Animation",Resize:"Resize",Zoom:"Zoom",Unknown:"Unknown"};for(var y in f){E[y]=f[y]}var x=":sapTabbable, .sapUiTableTreeIcon:not(.sapUiTableTreeIconLeaf)";var U={Grouping:e,Column:t,Menu:n,Binding:i,Hook:a,CELLTYPE:h,BaseSize:w,BaseBorderWidth:b,RowHorizontalFrameSize:I,DefaultRowHeight:S,RowsUpdateReason:E,INTERACTIVE_ELEMENT_SELECTORS:x,ThemeParameters:T,hasRowHeader:function(t){return t.getSelectionMode()!==v.None&&t.getSelectionBehavior()!==C.RowOnly||e.isInGroupMode(t)},hasSelectAll:function(e){var t=e?e.getSelectionMode():v.None;return t===v.MultiToggle&&e.getEnableSelectAll()},hasRowHighlights:function(e){if(!e){return false}var t=e.getRowSettingsTemplate();if(!t){return false}var n=t.getHighlight();return t.isBound("highlight")||n!=null&&n!==m.None},hasRowNavigationIndicators:function(e){if(!e){return false}var t=e.getRowSettingsTemplate();if(!t){return false}var n=t.getNavigated();return t.isBound("navigated")||n},hasRowActions:function(e){var t=e?e.getRowActionTemplate():null;return t!=null&&(t.isBound("visible")||t.getVisible())&&e.getRowActionCount()>0},isRowSelectionAllowed:function(e){return e.getSelectionMode()!==v.None&&(e.getSelectionBehavior()===C.Row||e.getSelectionBehavior()===C.RowOnly)},isRowSelectorSelectionAllowed:function(e){return e.getSelectionMode()!==v.None&&U.hasRowHeader(e)},isNoDataVisible:function(e){return!e._isNoDataDisabled()&&!U.hasData(e)||U.getVisibleColumnCount(e)===0},hasData:function(e){return e._getTotalRowCount()>0},isBusyIndicatorVisible:function(e){if(!e||!e.getDomRef()){return false}return e.getDomRef().querySelector('[id="'+e.getId()+'-sapUiTableGridCnt"] > .sapUiLocalBusyIndicator')!=null},isA:function(e,t){return r.isObjectA(e,t)},toggleRowSelection:function(e,t,n,i){var a;if(U.isA(t,"sap.ui.table.Row")){a=t}else if(typeof t==="number"){a=e.getRows()[t]}else{var o=jQuery(t);var r=U.getCellInfo(o[0]);var l=U.isRowSelectionAllowed(e);if(!U.Grouping.isInGroupHeaderRow(o[0])&&(r.isOfType(U.CELLTYPE.DATACELL|U.CELLTYPE.ROWACTION)&&l||r.isOfType(U.CELLTYPE.ROWHEADER)&&U.isRowSelectorSelectionAllowed(e))){a=e.getRows()[r.rowIndex]}}if(!a||a.isEmpty()){return}e._iSourceRowIndex=a.getIndex();if(i){i(a)}else{var s=e._getSelectionPlugin();s.setSelected(a,typeof n==="boolean"?n:!s.isSelected(a))}delete e._iSourceRowIndex},getNoContentMessage:function(e){if(U.getVisibleColumnCount(e)>0){return e.getNoData()||U.getResourceText("TBL_NO_DATA")}else{return e.getAggregation("_noColumnsMessage")||U.getResourceText("TBL_NO_COLUMNS")}},getVisibleColumnCount:function(e){return e._getVisibleColumns().length},getHeaderRowCount:function(e){if(e._iHeaderRowCount===undefined){if(!e.getColumnHeaderVisible()){e._iHeaderRowCount=0}else{var t=1;var n=e.getColumns();for(var i=0;i<n.length;i++){if(n[i].shouldRender()){t=Math.max(t,n[i].getMultiLabels().length)}}e._iHeaderRowCount=t}}return e._iHeaderRowCount},isVariableRowHeightEnabled:function(e){var t=e._getRowCounts();return e&&e._bVariableRowHeightEnabled&&!t.fixedTop&&!t.fixedBottom},getNonEmptyRowCount:function(e){return Math.min(e._getRowCounts().count,e._getTotalRowCount())},getFocusedItemInfo:function(e){var t=e._getItemNavigation();if(!t){return null}return{cell:t.getFocusedIndex(),columnCount:t.iColumns,cellInRow:t.getFocusedIndex()%t.iColumns,row:Math.floor(t.getFocusedIndex()/t.iColumns),cellCount:t.getItemDomRefs().length,domRef:t.getFocusedDomRef()}},getRowIndexOfFocusedCell:function(e){var t=U.getFocusedItemInfo(e);return t.row-U.getHeaderRowCount(e)},isFixedColumn:function(e,t){return t<e.getComputedFixedColumnCount()},hasFixedColumns:function(e){return e.getComputedFixedColumnCount()>0},focusItem:function(e,t,n){var i=e._getItemNavigation();if(i){i.focusItem(t,n)}},scrollTableToIndex:function(e,t,n){if(!e){return Promise.resolve()}var i=e.getFirstVisibleRow();var a=e._getRowCounts();var o=i+a.scrollable-1;var r=false;if(t<i||t>o){var l=n?t-a.fixedTop-1:t-a.scrollable-a.fixedTop+2;r=e._setFirstVisibleRowIndex(Math.max(0,l))}return new Promise(function(t){if(r){e.attachEventOnce("rowsUpdated",t)}else{t()}})},showNotificationPopoverAtIndex:function(e,t,n){var i=e._oNotificationPopover;var a=e.getRows()[t-e._getFirstRenderedRowIndex()];var o=U.getResourceText("TBL_SELECT_LIMIT_TITLE");var r=U.getResourceText("TBL_SELECT_LIMIT",[n]);return new Promise(function(t){sap.ui.require(["sap/m/Popover","sap/m/Bar","sap/m/Title","sap/m/Text","sap/m/HBox","sap/ui/core/library","sap/m/library"],function(n,l,s,u,c,f,g){if(!i){i=new n(e.getId()+"-notificationPopover",{customHeader:[new l({contentMiddle:[new c({items:[new d({src:"sap-icon://message-warning",color:f.IconColor.Critical}).addStyleClass("sapUiTinyMarginEnd"),new s({text:o,level:f.TitleLevel.H2})],renderType:g.FlexRendertype.Bare,justifyContent:g.FlexJustifyContent.Center,alignItems:g.FlexAlignItems.Center})]})],content:new u({text:r})});i.addStyleClass("sapUiContentPadding");e._oNotificationPopover=i;e.addAggregation("_hiddenDependents",e._oNotificationPopover)}else{i.getContent()[0].setText(r)}e.detachFirstVisibleRowChanged(this.onFirstVisibleRowChange,this);e.attachFirstVisibleRowChanged(this.onFirstVisibleRowChange,this);var p=a.getDomRefs().rowSelector;if(p){i.attachEventOnce("afterOpen",t);i.openBy(p)}else{t()}}.bind(this))}.bind(this))},onFirstVisibleRowChange:function(e){var t=e.getSource();if(!t._oNotificationPopover){return}if(t){t.detachFirstVisibleRowChanged(this.onFirstVisibleRowChange,this)}t._oNotificationPopover.close()},loadContexts:function(e,t,n){var i=e.getContexts(t,n,0,true);var a=i.length===Math.min(n,e.getLength())&&!i.includes(undefined);if(a){return Promise.resolve(i)}return new Promise(function(i){e.attachEventOnce("dataReceived",function(){i(this.loadContexts(e,t,n))}.bind(this))}.bind(this))},getCellInfo:function(e){var t;var n=jQuery(e);var i;var a;var o;var r;var l;t={type:0,cell:null,rowIndex:null,columnIndex:null,columnSpan:null};if(n.hasClass("sapUiTableDataCell")){i=n.attr("data-sap-ui-colid");a=sap.ui.getCore().byId(i);t.type=U.CELLTYPE.DATACELL;t.rowIndex=parseInt(n.parent().attr("data-sap-ui-rowindex"));t.columnIndex=a.getIndex();t.columnSpan=1}else if(n.hasClass("sapUiTableHeaderDataCell")){o=/_([\d]+)/;i=n.attr("id");r=o.exec(i);l=r&&r[1]!=null?parseInt(r[1]):0;t.type=U.CELLTYPE.COLUMNHEADER;t.rowIndex=l;t.columnIndex=parseInt(n.attr("data-sap-ui-colindex"));t.columnSpan=parseInt(n.attr("colspan")||1)}else if(n.hasClass("sapUiTableRowSelectionCell")){t.type=U.CELLTYPE.ROWHEADER;t.rowIndex=parseInt(n.parent().attr("data-sap-ui-rowindex"));t.columnIndex=-1;t.columnSpan=1}else if(n.hasClass("sapUiTableRowActionCell")){t.type=U.CELLTYPE.ROWACTION;t.rowIndex=parseInt(n.parent().attr("data-sap-ui-rowindex"));t.columnIndex=-2;t.columnSpan=1}else if(n.hasClass("sapUiTableRowSelectionHeaderCell")){t.type=U.CELLTYPE.COLUMNROWHEADER;t.columnIndex=-1;t.columnSpan=1}else if(n.hasClass("sapUiTablePseudoCell")){i=n.attr("data-sap-ui-colid");a=sap.ui.getCore().byId(i);t.type=U.CELLTYPE.PSEUDO;t.rowIndex=-1;t.columnIndex=a?a.getIndex():-1;t.columnSpan=1}if(t.type!==0){t.cell=n}t.isOfType=function(e){if(e==null){return false}return(this.type&e)>0};return t},getRowColCell:function(e,t,n,i){var a=e.getRows()[t]||null;var o=i?e.getColumns():e._getVisibleColumns();var r=o[n]||null;var l;var s=null;if(a&&r){if(!l){var u=r.getMetadata();while(u.getName()!=="sap.ui.table.Column"){u=u.getParent()}l=u.getClass()}s=a.getCells().find(function(e){return r===l.ofCell(e)})||null}return{row:a,column:r,cell:s}},getCell:function(e,t,n){n=n===true;if(!e||!t){return null}var i=jQuery(t);var a=e.getDomRef();var o=".sapUiTableCell";if(!n){o+=":not(.sapUiTablePseudoCell)"}var r=i.closest(o,a);if(r.length>0){return r}return null},getParentCell:function(e,t,n){n=n===true;var i=jQuery(t);var a=U.getCell(e,t,n);if(!a||a[0]===i[0]){return null}else{return a}},registerResizeHandler:function(e,t,n,i,a){i=i==null?"":i;a=a===true;if(!e||typeof t!=="string"||typeof n!=="function"){return undefined}var o=e.getDomRef(i);U.deregisterResizeHandler(e,t);if(!e._mResizeHandlerIds){e._mResizeHandlerIds={}}if(a&&o){o=o.parentNode}if(o){e._mResizeHandlerIds[t]=l.register(o,n)}return e._mResizeHandlerIds[t]},deregisterResizeHandler:function(e,t){var n=[];if(!e._mResizeHandlerIds){return}if(typeof t==="string"){n.push(t)}else if(t===undefined){for(var i in e._mResizeHandlerIds){if(typeof i=="string"&&e._mResizeHandlerIds.hasOwnProperty(i)){n.push(i)}}}else if(Array.isArray(t)){n=t}for(var a=0;a<n.length;a++){var o=n[a];if(e._mResizeHandlerIds[o]){l.deregister(e._mResizeHandlerIds[o]);e._mResizeHandlerIds[o]=undefined}}},isFirstScrollableRow:function(e,t){if(isNaN(t)){var n=jQuery(t);t=parseInt(n.add(n.parent()).filter("[data-sap-ui-rowindex]").attr("data-sap-ui-rowindex"))}return t==e._getRowCounts().fixedTop},isLastScrollableRow:function(e,t){if(isNaN(t)){var n=jQuery(t);t=parseInt(n.add(n.parent()).filter("[data-sap-ui-rowindex]").attr("data-sap-ui-rowindex"))}var i=e._getRowCounts();return t==i.count-i.fixedBottom-1},getContentDensity:function(e){var t;var n=["sapUiSizeCondensed","sapUiSizeCompact","sapUiSizeCozy"];var i=function(e,t){if(!t[e]){return}for(var i=0;i<n.length;i++){if(t[e](n[i])){return n[i]}}};var a=e.$();if(a.length>0){t=i("hasClass",a)}else{t=i("hasStyleClass",e)}if(t){return t}var o=null;var r=e.getParent();if(r){do{t=i("hasStyleClass",r);if(t){return t}if(r.getDomRef){o=r.getDomRef()}else if(r.getRootNode){o=r.getRootNode()}if(!o&&r.getParent){r=r.getParent()}else{r=null}}while(r&&!o)}a=jQuery(o||document.body);t=i("hasClass",a.closest("."+n.join(",.")));return t},isVariableWidth:function(e){return!e||e=="auto"||e.toString().match(/%$/)},getFirstFixedBottomRowIndex:function(e){var t=e._getRowCounts();if(!e.getBinding()||t.fixedBottom===0){return-1}var n=-1;var i=e.getFirstVisibleRow();var a=e._getTotalRowCount();if(a>=t.count){n=t.count-t.fixedBottom}else{var o=a-t.fixedBottom-i;if(o>=0&&i+o<a){n=o}}return n},getResourceBundle:function(e){e=jQuery.extend({async:false,reload:false},e);if(R&&e.reload!==true){if(e.async===true){return Promise.resolve(R)}else{return R}}var t=c.getResourceBundleFor("sap.ui.table");R=t;if(e.async===true){t=Promise.resolve(R)}return t},getResourceText:function(e,t){return R?R.getText(e,t):""},dynamicCall:function(e,t,n){var i=typeof e==="function"?e():e;if(!i||!t){return undefined}n=n||i;if(typeof t==="function"){t.call(n,i);return undefined}else{var a;var o=[];for(var r in t){if(typeof i[r]==="function"){a=t[r];o.push(i[r].apply(n,a))}else{o.push(undefined)}}if(o.length===1){return o[0]}else{return o}}},throttle:function(e,t,n){n=Object.assign({leading:true,asyncLeading:false,trailing:true},n);var i;var a=false;var o={};var r;var l;if(n.leading&&n.asyncLeading){r=function(){if(a){var t=Promise.resolve().then(function(){if(!t.canceled){e.apply(o.context,o.args)}i=null});t.cancel=function(){t.canceled=true};i=t}else{e.apply(this,arguments)}}}else{r=e}var s=g(r,t,{leading:n.leading,trailing:n.trailing});if(n.leading&&n.asyncLeading){var u=s.cancel;s.cancel=function(){if(i){i.cancel()}u()};l=Object.assign(function(){o={context:this,args:arguments};a=true;s.apply(this,arguments);a=false},s)}else{l=s}return l},throttleFrameWise:function(e){var t=null;var n=function(){n.cancel();t=window.requestAnimationFrame(function(t){e.apply(this,t)}.bind(this,arguments))};n.cancel=function(){window.cancelAnimationFrame(t);t=null};return n},getInteractiveElements:function(e){if(!e){return null}var t=jQuery(e);var n=U.getCellInfo(t);if(n.isOfType(h.ANY|h.PSEUDO)){var i=t.find(x);if(i.length>0){return i}}return null},getFirstInteractiveElement:function(e,t){if(!e){return null}var n=e.getTable();var i=e.getCells();if(t===true&&U.hasRowActions(n)){i.push(e.getRowAction())}for(var a=0;a<i.length;a++){var o=i[a].getDomRef();var r=U.getCell(n,o,true);var l=U.getInteractiveElements(r);if(l){return l[0]}}return null},convertCSSSizeToPixel:function(e,t){var n;if(typeof e!=="string"){return null}if(e.endsWith("px")){n=parseFloat(e)}else if(e.endsWith("em")||e.endsWith("rem")){n=parseFloat(e)*U.getBaseFontSize()}else{return null}if(t){return n+"px"}else{return n}},getBaseFontSize:function(){if(_==null){var e=document.documentElement;if(e){_=parseInt(window.getComputedStyle(e).fontSize)}}return _==null?16:_},readThemeParameters:function(){var e=u.get({name:["_sap_ui_table_BaseSize","_sap_ui_table_BaseSizeCozy","_sap_ui_table_BaseSizeCompact","_sap_ui_table_BaseSizeCondensed","_sap_ui_table_BaseBorderWidth","_sap_ui_table_NavigationIcon","_sap_ui_table_DeleteIcon","_sap_ui_table_ClearSelectionIcon","_sap_ui_table_NavIndicatorWidth"]});function t(t){return U.convertCSSSizeToPixel(e[t])}w.undefined=t("_sap_ui_table_BaseSize");w.sapUiSizeCozy=t("_sap_ui_table_BaseSizeCozy");w.sapUiSizeCompact=t("_sap_ui_table_BaseSizeCompact");w.sapUiSizeCondensed=t("_sap_ui_table_BaseSizeCondensed");b=t("_sap_ui_table_BaseBorderWidth");I=b;S.undefined=w.undefined+I;S.sapUiSizeCozy=w.sapUiSizeCozy+I;S.sapUiSizeCompact=w.sapUiSizeCompact+I;S.sapUiSizeCondensed=w.sapUiSizeCondensed+I;T.navigationIcon=e["_sap_ui_table_NavigationIcon"];T.deleteIcon=e["_sap_ui_table_DeleteIcon"];T.clearSelectionIcon=e["_sap_ui_table_ClearSelectionIcon"];T.navIndicatorWidth=t("_sap_ui_table_NavIndicatorWidth")},addDelegate:function(e,t,n){if(e&&t){e.addDelegate(t,false,n?n:t,false)}},removeDelegate:function(e,t){if(e&&t){e.removeDelegate(t)}},createWeakMapFacade:function(){var e=new window.WeakMap;return function(t){if(!t||!(typeof t==="object")){return null}if(!e.has(t)){e.set(t,{})}return e.get(t)}},_getTableTemplateHelper:function(e){var t="An automatic control and template generation for the sap.ui.table.Table is not supported "+"anymore for the aggragations footer and title and the aggregations label and template of "+"the sap.ui.table.Columns. Use concrete controls for those aggregations instead of altType string.";if(o.TableHelper){if(!e){p.warning(t)}return o.TableHelper}throw new Error(t)}};e.TableUtils=U;t.TableUtils=U;n.TableUtils=U;i.TableUtils=U;a.TableUtils=U;return U},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/utils/_BindingUtils", [],function(){"use strict";var a={TableUtils:null,metadataLoaded:function(a){var t=a.getBinding();var e=t?t.getModel():null;var d=null;var n=null;var i=new Promise(function(a,t){d=a;n=t});if(!e){n();return i}if(e.metadataLoaded){e.metadataLoaded().then(function(){d()})}else if(e.attachMetadataLoaded){if(e.oMetadata&&e.oMetadata.isLoaded()){d()}else{e.attachMetadataLoaded(function(){d()})}}return i}};return a},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/utils/_ColumnUtils", ["sap/ui/Device","../library","sap/base/Log"],function(e,n,r){"use strict";var t={TableUtils:null,initColumnUtils:function(e){if(!e._oColumnInfo){t.updateColumnInfo(e,t.collectColumnInfo(e))}},invalidateColumnUtils:function(e){e._oColumnInfo=null},updateColumnInfo:function(e,n){e._oColumnInfo=n},collectColumnInfo:function(e){return{columnCount:e.getColumns().length,visibleColumnCount:t.TableUtils.getVisibleColumnCount(e),columnMap:t.getColumnMap(e)}},getColumnMap:function(e){var n;var r;var a={};var l={};var u=e.getColumns();var o=t.TableUtils.getHeaderRowCount(e);var i={};for(var f=0;f<u.length;f++){r=u[f];a={};a.id=r.getId();a.column=r;a.levelInfo=[];a.parents=[];for(var s=0;s<o;s++){a.levelInfo[s]={};a.levelInfo[s].spannedColumns=[];var d=t.getHeaderSpan(r,s);for(n=1;n<d;n++){var v=u[f+n];if(v){var g=v.getId();a.levelInfo[s].spannedColumns.push(u[f+n]);if(!i[g]){i[g]=[]}i[g].push({column:r,level:s})}}}l[a.id]=a}var m=Object.keys(i);for(n=0;n<m.length;n++){var C=m[n];l[C].parents=i[C]}return l},getColumnMapItem:function(e,n){t.initColumnUtils(e);var a=e._oColumnInfo.columnMap[n];if(!a){r.error("Column with ID '"+n+"' not found",e)}else{return a}},getParentSpannedColumns:function(e,n,r){var a=t.getColumnMapItem(e,n);if(!a){return undefined}var l=[];for(var u=0;u<a.parents.length;u++){var o=a.parents[u];if(r===undefined||o.level===r){l.push(o)}}return l},getChildrenSpannedColumns:function(e,n,r){var a=t.getColumnMapItem(e,n);if(!a){return undefined}var l=[];var u;if(r===undefined){u=a.levelInfo.length}else{u=r+1}for(var o=r||0;o<u;o++){var i=a.levelInfo[o];for(var f=0;f<i.spannedColumns.length;f++){l.push({column:i.spannedColumns[f],level:o})}}return l},getHeaderSpan:function(e,n){var r=e.getHeaderSpan();var t;if(!r){return 1}if(!Array.isArray(r)){r=(r+"").split(",")}function a(e){var n=parseInt(e);return isNaN(n)?1:n}if(isNaN(n)){t=Math.max.apply(null,r.map(a))}else{t=a(r[n])}return Math.max(t,1)},getMaxHeaderSpan:function(e){return t.getHeaderSpan(e)},hasHeaderSpan:function(e){return t.getHeaderSpan(e)>1},getColumnBoundaries:function(e,n){var r=t.getColumnMapItem(e,n);if(!r){return undefined}var a={};if(n){a[n]=r.column}var l=function(n,r){var a;var u;var o=[];r=r||[];for(u=0;u<r.length;u++){a=n[r[u]];o=o.concat(t.getParentSpannedColumns(e,a.getId()));o=o.concat(t.getChildrenSpannedColumns(e,a.getId()))}r=[];for(u=0;u<o.length;u++){a=o[u].column;var i=a.getId();if(!n[i]){r.push(i);n[i]=a}}if(r.length>0){return l(n,r)}else{return n}};a=l(a,[n]);var u=e.indexOfColumn(r.column);var o={startColumn:r.column,startIndex:u,endColumn:r.column,endIndex:-1};var i=e.getColumns();var f=Object.getOwnPropertyNames(a);for(var s=0;s<f.length;s++){var d=a[f[s]];u=e.indexOfColumn(d);var v=t.getMaxHeaderSpan(d);if(u<o.startIndex){o.startIndex=u;o.startColumn=d}var g=u+v-1;if(g>o.endIndex){o.endIndex=g;o.endColumn=i[g]}}return o},isColumnMovable:function(e,n){var r=e.getParent();if(!r||!r.getEnableColumnReordering()&&!n){return false}var a=r.indexOfColumn(e);if(a<r.getComputedFixedColumnCount()||a<r._iFirstReorderableIndex){return false}if(t.hasHeaderSpan(e)||t.getParentSpannedColumns(r,e.getId()).length!=0){return false}return true},normalizeColumnMoveTargetIndex:function(e,n){var r=e.getParent(),t=r.indexOfColumn(e),a=r.getColumns();if(n>t){n--}if(n<0){n=0}else if(n>a.length){n=a.length}return n},isColumnMovableTo:function(e,n,r){var a=e.getParent();if(!a||n===undefined||!t.isColumnMovable(e,r)){return false}n=t.normalizeColumnMoveTargetIndex(e,n);if(n<a.getComputedFixedColumnCount()||n<a._iFirstReorderableIndex){return false}var l=a.indexOfColumn(e),u=a.getColumns();if(n>l){var o=u[n>=u.length?u.length-1:n];var i=t.getColumnBoundaries(a,o.getId());if(t.hasHeaderSpan(o)||i.endIndex>n){return false}}else{var f=u[n];if(t.getParentSpannedColumns(a,f.getId()).length!=0){return false}}return true},moveColumnTo:function(e,n){if(!t.isColumnMovableTo(e,n)){return false}var r=e.getParent(),a=r.indexOfColumn(e);if(n===a){return false}n=t.normalizeColumnMoveTargetIndex(e,n);var l=r.fireColumnMove({column:e,newPos:n});if(!l){return false}r._bReorderInProcess=true;r.removeColumn(e,true);r.insertColumn(e,n);r._bReorderInProcess=false;return true},getMinColumnWidth:function(){return e.system.desktop?48:88},resizeColumn:function(e,n,r,a,l){if(!e||n==null||n<0||r==null||r<=0){return false}if(l==null||l<=0){l=1}if(a==null){a=true}var u=e.getColumns();if(n>=u.length||!u[n].getVisible()){return false}var o=[];for(var i=n;i<u.length;i++){var f=u[i];if(f.getVisible()){o.push(f);if(o.length===l){break}}}var s=[];for(var i=0;i<o.length;i++){var d=o[i];if(d.getResizable()){s.push(d)}}if(s.length===0){return false}var v=0;for(var i=0;i<o.length;i++){var d=o[i];v+=t.getColumnWidth(e,d.getIndex())}var g=r-v;var m=Math.round(g/s.length);var C=false;var h=e.getDomRef();if(!t.TableUtils.isFixedColumn(e,n)){e._getVisibleColumns().forEach(function(e){var n=e.getWidth(),r;if(h&&s.indexOf(e)<0&&t.TableUtils.isVariableWidth(n)){r=h.querySelector('th[data-sap-ui-colid="'+e.getId()+'"]');if(r){e._minWidth=Math.max(r.offsetWidth,t.getMinColumnWidth())}}})}for(var i=0;i<s.length;i++){var c=s[i];var p=t.getColumnWidth(e,c.getIndex());var I=p+m;var b=t.getMinColumnWidth();if(I<b){I=b}var x=I-p;if(Math.abs(x)<Math.abs(m)){var M=s.length-(i+1);g-=x;m=Math.round(g/M)}if(x!==0){var S=true;var T=I+"px";if(a){S=e.fireColumnResize({column:c,width:T})}if(S){c.setWidth(T);C=true}}}return C},getColumnWidth:function(e,n){if(!e||n==null||n<0){return null}var r=e.getColumns();if(n>=r.length){return null}var a=r[n];var l=a.getWidth();if(l===""||l==="auto"||l.match(/%$/)){if(a.getVisible()){var u=a.getDomRef();return u?u.offsetWidth:0}else{return 0}}else{return t.TableUtils.convertCSSSizeToPixel(l)}},getHeaderText:function(e){if(!e){return null}function n(e){return e&&e.getText&&e.getText()||""}var r=e.getName();if(!r){var a=e.getMultiLabels();for(var l=a.length-1;l>=0;l--){var u=n(a[l]);if(t.getHeaderSpan(e,l)===1&&u){r=u;break}}}if(!r){r=n(e.getLabel())}return r},getHeaderLabel:function(e){if(!e){return null}var n;var r=e.getMultiLabels();for(var a=r.length-1;a>=0;a--){if(t.getHeaderSpan(e,a)===1){n=r[a];break}}if(!n){n=e.getLabel()}return n}};return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/utils/_GroupingUtils", ["sap/ui/model/Sorter","sap/ui/Device","sap/ui/thirdparty/jquery"],function(e,r,jQuery){"use strict";var a=new window.WeakMap;var t={TableUtils:null,HierarchyMode:{Flat:"Flat",Group:"Group",Tree:"Tree",GroupedTree:"GroupedTree"},setHierarchyMode:function(e,r){if(!t.TableUtils.isA(e,"sap.ui.table.Table")||!(r in t.HierarchyMode)){return}var o=t.getHierarchyMode(e);if(o!==r){a.set(e,r);e.invalidate()}},getHierarchyMode:function(e){return t.TableUtils.isA(e,"sap.ui.table.Table")?a.get(e)||t.HierarchyMode.Flat:null},setToDefaultFlatMode:function(e){t.setHierarchyMode(e,t.HierarchyMode.Flat)},setToDefaultGroupMode:function(e){t.setHierarchyMode(e,t.HierarchyMode.Group)},setToDefaultTreeMode:function(e){t.setHierarchyMode(e,t.HierarchyMode.Tree)},isInFlatMode:function(e){return t.getHierarchyMode(e)===t.HierarchyMode.Flat},isInGroupMode:function(e){var r=t.getHierarchyMode(e);return r===t.HierarchyMode.Group||r===t.HierarchyMode.GroupedTree},isInTreeMode:function(e){return t.getHierarchyMode(e)===t.HierarchyMode.Tree},getModeCssClass:function(e){switch(t.getHierarchyMode(e)){case t.HierarchyMode.Group:case t.HierarchyMode.GroupedTree:return"sapUiTableGroupMode";case t.HierarchyMode.Tree:return"sapUiTableTreeMode";default:return null}},showGroupMenuButton:function(e){return!r.system.desktop&&t.TableUtils.isA(e,"sap.ui.table.AnalyticalTable")},isInGroupHeaderRow:function(e){var r=t.TableUtils.getCellInfo(e);if(r.isOfType(t.TableUtils.CELLTYPE.ANYCONTENTCELL)){return r.cell.parent().hasClass("sapUiTableGroupHeaderRow")}return false},isInSummaryRow:function(e){var r=t.TableUtils.getCellInfo(e);if(r.isOfType(t.TableUtils.CELLTYPE.ANYCONTENTCELL)){return r.cell.parent().hasClass("sapUiTableSummaryRow")}return false},calcGroupIndent:function(e){var r=t.getHierarchyMode(e.getTable())===t.HierarchyMode.GroupedTree;var a=!r&&!e.isGroupHeader()&&!e.isTotalSummary();var o=e.getLevel()-(a?1:0);var n=0;for(var i=1;i<o;i++){if(i===1){n=24}else if(i===2){n+=12}else{n+=8}}return n},calcTreeIndent:function(e){return(e.getLevel()-1)*17},setGroupIndent:function(e,r){var a=e.getDomRefs(true);var t=a.row;var o=a.rowHeaderPart;var n=e.getTable()._bRtlMode;var i=t.find("td.sapUiTableCellFirst > .sapUiTableCellInner");var l=o.find(".sapUiTableGroupShield");if(r<=0){o.css(n?"right":"left","");l.css("width","").css(n?"margin-right":"margin-left","");i.css(n?"padding-right":"padding-left","");t.css("--CalculatedGroupIndent","0")}else{o.css(n?"right":"left",r+"px");l.css("width",r+"px").css(n?"margin-right":"margin-left",-1*r+"px");i.css(n?"padding-right":"padding-left",r+8+"px");t.css("--CalculatedGroupIndent",r+"px")}},setTreeIndent:function(e,r){var a=e.getDomRefs(true);var t=a.row;var o=e.getTable()._bRtlMode;var n=t.find(".sapUiTableTreeIcon");n.css(o?"margin-right":"margin-left",r>0?r+"px":"")},updateTableRowForGrouping:function(e){var r=e.getTable();var a=e.getDomRefs(true);var o=a.row;var n=e.isExpanded();var i=e.isExpandable();o.toggleClass("sapUiTableSummaryRow",e.isSummary());if(t.isInGroupMode(r)){var l=e.getTitle();var s=t.calcGroupIndent(e);e.$("groupHeader").toggleClass("sapUiTableGroupIconOpen",i&&n).toggleClass("sapUiTableGroupIconClosed",i&&!n).attr("title",!r._getHideStandardTooltips()&&l?l:null).text(l);t.setGroupIndent(e,s);o.toggleClass("sapUiTableRowIndented",s>0).toggleClass("sapUiTableGroupHeaderRow",e.isGroupHeader());if(t.showGroupMenuButton(r)){var p=r.$();var u=p.hasClass("sapUiTableVScr")?p.find(".sapUiTableVSb").width():0;var d=a.rowHeaderPart.find(".sapUiTableGroupMenuButton");var g=p.width()-d.width()-u-5-s;d.css(r._bRtlMode?"right":"left",g+"px")}}if(t.isInTreeMode(r)){var c=o.find(".sapUiTableTreeIcon");if(!i&&document.activeElement===c[0]){t.TableUtils.getParentCell(r,c[0]).trigger("focus")}c.toggleClass("sapUiTableTreeIconLeaf",!i).toggleClass("sapUiTableTreeIconNodeOpen",i&&n).toggleClass("sapUiTableTreeIconNodeClosed",i&&!n);t.setTreeIndent(e,t.calcTreeIndent(e))}if(!t.isInFlatMode(r)){r._getAccExtension().updateAriaExpandAndLevelState(e)}},cleanupTableRowForGrouping:function(e){var r=e.getTable();var a=e.getDomRefs(true);if(t.isInGroupMode(r)){a.row.removeClass("sapUiTableGroupHeaderRow sapUiTableSummaryRow sapUiTableRowIndented");e.$("groupHeader").removeClass("sapUiTableGroupIconOpen","sapUiTableGroupIconClosed").attr("title","").text("");t.setGroupIndent(e,0)}if(t.isInTreeMode(r)){a.row.find(".sapUiTableTreeIcon").removeClass("sapUiTableTreeIconLeaf").removeClass("sapUiTableTreeIconNodeOpen").removeClass("sapUiTableTreeIconNodeClosed");t.setTreeIndent(e,0)}r._getAccExtension().updateAriaExpandAndLevelState(e)},updateGroups:function(e){if(e.getBinding()){e.getRows().forEach(function(e){t.updateTableRowForGrouping(e)})}else{e.getRows().forEach(function(e){t.cleanupTableRowForGrouping(e)})}},setupExperimentalGrouping:function(r){if(!r.getEnableGrouping()){return}var a=r.getBinding();var o=sap.ui.getCore().byId(r.getGroupBy());var n=o&&o.getGrouped()&&t.TableUtils.isA(a,"sap.ui.model.ClientListBinding");if(!n||a._modified){return}a._modified=true;t.setToDefaultGroupMode(r);var i=o.getSortProperty();a.sort(new e(i));var l=r._getTotalRowCount(),s=a.getContexts(0,l);var p;var u=0;for(var d=l-1;d>=0;d--){var g=s[d].getProperty(i);if(!p){p=g}if(p!==g){var c=s[d+1].getModel().getContext("/sap.ui.table.GroupInfo"+d);c.__groupInfo={oContext:s[d+1],name:p,count:u,groupHeader:true,expanded:true};s.splice(d+1,0,c);p=g;u=0}u++}var c=s[0].getModel().getContext("/sap.ui.table.GroupInfo");c.__groupInfo={oContext:s[0],name:p,count:u,groupHeader:true,expanded:true};s.splice(0,0,c);jQuery.extend(a,{getLength:function(){return s.length},getContexts:function(e,r){return s.slice(e,e+r)}});function f(e){var r=s[e];return(r&&r.__groupInfo&&r.__groupInfo.groupHeader)===true}r._experimentalGroupingRowState=function(e){var r=e.context;if((r&&r.__groupInfo&&r.__groupInfo.groupHeader)===true){e.type=e.Type.GroupHeader}e.title=r&&r.__groupInfo&&r.__groupInfo.name+" - "+r.__groupInfo.count;e.expandable=e.type===e.Type.GroupHeader;e.expanded=e.expandable&&r.__groupInfo&&r.__groupInfo.expanded;e.level=e.expandable?1:2;e.contentHidden=e.expandable};r._experimentalGroupingExpand=function(e){var r=e.getIndex();if(f(r)&&!s[r].__groupInfo.expanded){for(var t=0;t<s[r].__childs.length;t++){s.splice(r+1+t,0,s[r].__childs[t])}delete s[r].__childs;s[r].__groupInfo.expanded=true;a._fireChange()}};r._experimentalGroupingCollapse=function(e){var r=e.getIndex();if(f(r)&&s[r].__groupInfo.expanded){s[r].__childs=s.splice(r+1,s[r].__groupInfo.count);s[r].__groupInfo.expanded=false;a._fireChange()}};var T=t.TableUtils.Hook;T.register(r,T.Keys.Row.UpdateState,r._experimentalGroupingRowState);T.register(r,T.Keys.Row.Expand,r._experimentalGroupingExpand);T.register(r,T.Keys.Row.Collapse,r._experimentalGroupingCollapse);r._mTimeouts.groupingFireBindingChange=r._mTimeouts.groupingFireBindingChange||window.setTimeout(function(){a._fireChange()},0)},resetExperimentalGrouping:function(e){var r=e.getBinding();var a=t.TableUtils.Hook;if(r&&r._modified){t.setToDefaultFlatMode(e);e.bindRows(e.getBindingInfo("rows"))}a.deregister(e,a.Keys.Row.UpdateState,e._experimentalGroupingRowState);a.deregister(e,a.Keys.Row.Expand,e._experimentalGroupingExpand);a.deregister(e,a.Keys.Row.Collapse,e._experimentalGroupingCollapse);delete e._experimentalGroupingRowState;delete e._experimentalGroupingExpand;delete e._experimentalGroupingCollapse}};return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/utils/_HookUtils", ["sap/ui/base/DataType","sap/ui/model/ChangeReason"],function(e,t){"use strict";var n=new window.WeakMap;var r={};var a={};var u={};var s=["function"];var l={};var i={Table:{BindRows:{arguments:[{type:"object"}]},RowsBound:{arguments:[{type:"class:sap.ui.model.Binding"}]},UnbindRows:{arguments:[{type:"object"}]},RowsUnbound:{arguments:[]},RefreshRows:{arguments:[{type:b}]},UpdateRows:{arguments:[{type:b}]},UpdateSizes:{arguments:[{type:b}]},OpenMenu:{arguments:[{type:h},{type:"class:sap.ui.unified.Menu"}]},TotalRowCountChanged:{arguments:[]},InvalidateColumnMenus:{arguments:[{type:"class:sap.ui.table.Table"}]}},TableRenderer:{RenderTableStyles:{arguments:[{type:"object"}]},RenderInTableBottomArea:{arguments:[{type:"object"}]},RenderRowContainerStyles:{arguments:[{type:"object"}]},RenderRowStyles:{arguments:[{type:"object"}]},RenderCellContentStyles:{arguments:[{type:"object"}]}},Row:{UpdateState:{arguments:[{type:v}]},Expand:{arguments:[{type:"class:sap.ui.table.Row"}]},Collapse:{arguments:[{type:"class:sap.ui.table.Row"}]}},Column:{MenuItemNotification:{arguments:[{type:"class:sap.ui.table.Column"}],returnValue:"boolean"},SetFilterState:{arguments:[{type:"class:sap.ui.table.Column"},{type:"string"}]}},Signal:{arguments:[{type:"string"}]}};l.TableUtils=null;l.Keys=a;l.call=function(e,t){var a=n.get(e);if(!p(e)||!f(t)){return undefined}var u=y(t);if(a==null){if(u.returnValue){return[]}return undefined}var s=c(Array.prototype.slice.call(arguments,2));var i=d(u,s);if(!i){throw new Error("Hook with key "+t+" was not called. Invalid arguments passed\n"+e)}var o=a.map(function(e){if(e.key===r){var n={};var a=e.handlerContext==null?e.target:e.handlerContext;n[t]=s;return l.TableUtils.dynamicCall(e.target,n,a)}else if(e.key===t){return e.handler.apply(e.handlerContext,s)}});o=g(u,o);return o};l.install=function(e,t,a){if(!t||!p(e)){return}var u=n.get(e);if(u==null){u=[]}var s=u.some(function(e){return e.key===r&&e.target===t&&e.handlerContext===a});if(s){return}u.push({key:r,target:t,handlerContext:a});n.set(e,u)};l.uninstall=function(e,t,a){var u=n.get(e);if(u==null||!t){return}for(var s=0;s<u.length;s++){var l=u[s];if(l.key===r&&l.target===t&&l.handlerContext===a){u.splice(s,1);break}}if(u.length===0){n.delete(e)}else{n.set(e,u)}};l.register=function(e,t,r,a){if(typeof r!=="function"||!p(e)||!f(t)){return}var u=n.get(e);if(u==null){u=[]}u.push({key:t,handler:r,handlerContext:a});n.set(e,u)};l.deregister=function(e,t,r,a){var u=n.get(e);if(u==null){return}for(var s=0;s<u.length;s++){var l=u[s];if(l.key===t&&l.handler===r&&l.handlerContext===a){u.splice(s,1);break}}if(u.length===0){n.delete(e)}else{n.set(e,u)}};function o(e,t,n){Object.keys(t).forEach(function(r){var a=n?n+"."+r:r;if("arguments"in t[r]){s.forEach(function(e){if(t[r].arguments.indexOf(e)>-1||t[r].returnValue===e){throw new Error("Forbidden type found in metadata of hook "+n+": "+e)}});e[r]=a;u[a]=t[r]}else{e[r]={};o(e[r],t[r],a)}});return e}o(a,i);function f(e){return e in u}function p(e){return l.TableUtils.isA(e,"sap.ui.table.Table")&&!e.bIsDestroyed&&!e._bIsBeingDestroyed}function y(e){return u[e]}function c(e){while(e.length>0){var t=e.pop();if(t!=null){e.push(t);break}}e.map(function(e){if(e===null){return undefined}else{return e}});return e}function d(t,n){return t.arguments.length>=n.length&&n.every(function(n,r){var a=t.arguments[r];if(typeof a.type==="function"){return a.type(n)}if(a.type.startsWith("class:")){return l.TableUtils.isA(n,a.type.substring(6))}return a.optional===true&&n==null||e.getType(a.type).isValid(n)})}function g(t,n){if(!t.returnValue){return undefined}var r=t.returnValue;return n.filter(function(t){if(t==null){return false}else if(typeof r==="function"){return r(t)}else if(r==="Promise"){return t instanceof Promise}else if(r.startsWith("class:")){return l.TableUtils.isA(t,r.substring(6))}else{return e.getType(r).isValid(t)}})}function m(e){return typeof e==="string"&&Object.values(t).includes(e)}function b(e){return e in l.TableUtils.RowsUpdateReason||m(e)}function h(e){return e?typeof e.isOfType==="function":false}function v(e){return e!=null&&e.hasOwnProperty("context")&&e.hasOwnProperty("Type")&&e.hasOwnProperty("type")&&e.type in e.Type}return l},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/utils/_MenuUtils", ["sap/ui/Device","sap/ui/unified/Menu","sap/ui/unified/MenuItem","sap/ui/core/Popup"],function(e,t,n,l){"use strict";function o(e,t){var n=t.getRowBindingContext();var l=e.getFilterProperty();var o=n.getProperty(l);if(o!=null&&typeof o!=="string"){o=o.toString()}if(this.getEnableCustomFilter()){this.fireCustomFilter({column:e,value:o})}else{this.filter(e,o)}}var u={TableUtils:null,openContextMenu:function(e,t){var n=u.TableUtils.getCell(e,t.target);var l=n?n[0]:null;var o=u.TableUtils.getCellInfo(l);var r=o.columnIndex;var C=o.rowIndex;var i=true;if(o.isOfType(u.TableUtils.CELLTYPE.COLUMNHEADER)){e.getColumns()[r]._openHeaderMenu(l);return true}else if(o.isOfType(u.TableUtils.CELLTYPE.ANYCONTENTCELL)){var a=u.TableUtils.getRowColCell(e,C,r,r>=0);var s=a.row;var f;var x=e.getBindingInfo("rows");if(x){f=s.getBindingContext(x.model)}if(r>=0){i=e.fireCellContextmenu({rowIndex:s.getIndex(),columnIndex:r,columnId:a.column.getId(),cellControl:a.cell,rowBindingContext:f,cellDomRef:l})}if(!i){return true}var c=e.getContextMenu();if(c&&x){c.setBindingContext(f,x.model)}i=e.fireBeforeOpenContextMenu({rowIndex:s.getIndex(),columnIndex:a.column?r:null,contextMenu:c});if(i){return u._openContentCellContextMenu(e,l,t)}else{return true}}return false},_openContentCellContextMenu:function(e,t,n){var l=u.TableUtils.getCellInfo(t);if(l.rowIndex>=u.TableUtils.getNonEmptyRowCount(e)){return false}if(u.hasCustomContextMenu(e)){return u._openCustomContentCellContextMenu(e,t,n)}else{return u._openDefaultContentCellContextMenu(e,t,n)}},_openCustomContentCellContextMenu:function(e,t,n){var l=u.TableUtils.getCellInfo(t);var o=e.getRows()[l.rowIndex];if(o.isGroupHeader()||o.isSummary()){return false}e.getContextMenu().openAsContextMenu(n,t);return true},_openDefaultContentCellContextMenu:function(e,l,r){var C=u.TableUtils.getCellInfo(l);var i=C.rowIndex;var a=e.getRows()[i];var s=C.columnIndex;var f=e.getColumns();var x=f[s];if(!e._oCellContextMenu){e._oCellContextMenu=new t(e.getId()+"-cellcontextmenu")}var c=e._oCellContextMenu.getId()+"-cellfilter";var M=sap.ui.getCore().byId(c);if(e.getEnableCellFilter()&&x&&x.isFilterableByMenu()&&!a.isGroupHeader()){if(!M){M=new n({id:c,text:u.TableUtils.getResourceText("TBL_FILTER")});M._onSelect=o.bind(e,x,a);M.attachSelect(M._onSelect)}else{M.detachSelect(M._onSelect);M._onSelect=o.bind(e,x,a);M.attachSelect(M._onSelect)}e._oCellContextMenu.insertItem(M,0)}else{e._oCellContextMenu.removeItem(M)}u.TableUtils.Hook.call(e,u.TableUtils.Hook.Keys.Table.OpenMenu,C,e._oCellContextMenu);if(e._oCellContextMenu.getItems().length===0){return false}e._oCellContextMenu.openAsContextMenu(r,l);return true},closeContentCellContextMenu:function(e){u._closeCustomContentCellContextMenu(e);u._closeDefaultContentCellContextMenu(e)},_closeCustomContentCellContextMenu:function(e){e.getContextMenu()?.close?.()},_closeDefaultContentCellContextMenu:function(e){e._oCellContextMenu?.close()},cleanupDefaultContentCellContextMenu:function(e){if(!e||!e._oCellContextMenu){return}var t=e._oCellContextMenu.getId()+"-cellfilter";var n=sap.ui.getCore().byId(t);e._oCellContextMenu.removeAllItems();e._oCellContextMenu.destroy();e._oCellContextMenu=null;if(n){n.destroy()}},hasCustomContextMenu:function(e){return e!=null&&e.getContextMenu()!=null}};return u},true);
sap.ui.require.preload({
	"sap/ui/table/manifest.json":'{"_version":"1.21.0","sap.app":{"id":"sap.ui.table","type":"library","embeds":[],"applicationVersion":{"version":"1.120.22"},"title":"Table-like controls, mainly for desktop scenarios.","description":"Table-like controls, mainly for desktop scenarios.","ach":"CA-UI5-TBL","resources":"resources.json","offline":true},"sap.ui":{"technology":"UI5","supportedThemes":["base","sap_hcb"]},"sap.ui5":{"dependencies":{"minUI5Version":"1.120","libs":{"sap.ui.core":{"minVersion":"1.120.22"},"sap.ui.unified":{"minVersion":"1.120.22"}}},"library":{"i18n":{"bundleUrl":"messagebundle.properties","supportedLocales":["","ar","bg","ca","cnr","cs","cy","da","de","el","en","en-GB","en-US-sappsd","en-US-saprigi","en-US-saptrc","es","es-MX","et","fi","fr","fr-CA","hi","hr","hu","id","it","iw","ja","kk","ko","lt","lv","mk","ms","nl","no","pl","pt","pt-PT","ro","ru","sh","sk","sl","sr","sv","th","tr","uk","vi","zh-CN","zh-TW"]},"content":{"controls":["sap.ui.table.AnalyticalColumnMenu","sap.ui.table.AnalyticalTable","sap.ui.table.ColumnMenu","sap.ui.table.CreationRow","sap.ui.table.Table","sap.ui.table.TreeTable","sap.ui.table.RowAction"],"elements":["sap.ui.table.AnalyticalColumn","sap.ui.table.Column","sap.ui.table.Row","sap.ui.table.RowActionItem","sap.ui.table.RowSettings","sap.ui.table.rowmodes.RowMode","sap.ui.table.rowmodes.Fixed","sap.ui.table.rowmodes.Interactive","sap.ui.table.rowmodes.Auto","sap.ui.table.plugins.SelectionPlugin","sap.ui.table.plugins.MultiSelectionPlugin","sap.ui.table.plugins.ODataV4Selection"],"types":["sap.ui.table.NavigationMode","sap.ui.table.RowActionType","sap.ui.table.SelectionBehavior","sap.ui.table.SelectionMode","sap.ui.table.SortOrder","sap.ui.table.VisibleRowCountMode","sap.ui.table.TreeAutoExpandMode","sap.ui.table.plugins.SelectionMode"],"interfaces":[]}}}}'
});
//# sourceMappingURL=library-preload.js.map
