/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","sap/ui/thirdparty/URI","sap/ui/base/Object","sap/base/util/restricted/_debounce","sap/ui/testrecorder/CommunicationBus","sap/ui/testrecorder/CommunicationChannels","sap/ui/testrecorder/Constants"],function(jQuery,e,t,i,o,s,n){"use strict";var r=null;var a=false;var d=t.extend("sap.ui.testrecorder.UIContextInjector",{constructor:function(){if(!r){t.apply(this,arguments);this._sIdentifier=f()}else{return r}}});d.prototype.injectFrame=function(e,t){window.communicationWindows=window.communicationWindows||{};this._generateTestRecorderUrl();this.fnOnClose=t;this._isInIframe=e.indexOf("window")===-1;this._onResizeHandleMouseover=c.bind(this);this._onResizeHandleMousedown=u.bind(this);this._onResizeHandleMouseleave=l.bind(this);this._onDocumentMouseup=h.bind(this);this._onDocumentMousemove=m.bind(this);if(this._isInIframe){this.dockFrameBottom()}else{this._openWindow()}o.subscribe(s.MINIMIZE_IFRAME,this.minimizeFrame.bind(this));o.subscribe(s.SHOW_IFRAME,this.unminimizeFrame.bind(this));o.subscribe(s.CLOSE_IFRAME,this.close.bind(this));o.subscribe(s.OPEN_NEW_WINDOW,this.openNewWindow.bind(this));o.subscribe(s.DOCK_IFRAME_BOTTOM,this.dockFrameBottom.bind(this));o.subscribe(s.DOCK_IFRAME_RIGHT,this.dockFrameRight.bind(this));o.subscribe(s.DOCK_IFRAME_LEFT,this.dockFrameLeft.bind(this))};d.prototype.minimizeFrame=function(){this._iframe.style.width=n.FRAME.MINIMIZED.width;this._iframe.style.height=n.FRAME.MINIMIZED.height;Object.values(this._resizeHandles).forEach(function(e){e.style.display="none"})};d.prototype.unminimizeFrame=function(){switch(this._sRememberedDockSide){case n.DOCK.RIGHT:this.dockFrameRight();break;case n.DOCK.LEFT:this.dockFrameLeft();break;case n.DOCK.BOTTOM:default:this.dockFrameBottom();break}};d.prototype.dockFrameBottom=function(){this._dockFrame(n.DOCK.BOTTOM)};d.prototype.dockFrameRight=function(){this._dockFrame(n.DOCK.RIGHT)};d.prototype.dockFrameLeft=function(){this._dockFrame(n.DOCK.LEFT)};d.prototype._dockFrame=function(e){if(!this._iframe){this._dockStarted=true;this.close();this._openFrame()}this._sRememberedDockSide=e;for(var t in n.FRAME[e]){this._iframe.style[t]=n.FRAME[e][t]}Object.values(this._resizeHandles).forEach(function(e){e.style.display="none"});this._resizeHandles[e].style.display="block";for(var i in n.RESIZE_HANDLE[e]){this._resizeHandles[e].style[i]=n.RESIZE_HANDLE[e][i]}};d.prototype.openNewWindow=function(){this._dockStarted=true;this.close();this._openWindow()};d.prototype._openWindow=function(){window.communicationWindows.testRecorder=window.open(this._sUrl,"sapUiTestRecorder","width=1024,height=700,status=no,toolbar=no,menubar=no,resizable=yes,location=no,directories=no,scrollbars=yes");window.communicationWindows.testRecorder.document.title="Test Recorder";p();this._isInIframe=false;this._dockStarted=false;this._closeTriggered=false;setTimeout(function(){var e=function(){window.communicationWindows.testRecorder.removeEventListener("beforeunload",e);if(!this._dockStarted&&!this._closeTriggered){this.close()}}.bind(this);if(window.communicationWindows.testRecorder.closed){if(!this._dockStarted&&!this._closeTriggered){this.close()}}else{window.communicationWindows.testRecorder.addEventListener("beforeunload",e)}}.bind(this),1e3)};d.prototype._openFrame=function(){var e=document.createElement("IFRAME");var t=document.createElement("DIV");var i=this._createResizeHandle(jQuery.extend(n.RESIZE_HANDLE.BOTTOM,{cursor:"n-resize",resize:function(e,t){e.style.top=t.y+"px";this._iframe.style.height="calc(100% - "+t.y+"px)"}.bind(this)}));var o=this._createResizeHandle(jQuery.extend(n.RESIZE_HANDLE.RIGHT,{cursor:"e-resize",resize:function(e,t){e.style.left=t.x+"px";this._iframe.style.left=t.x+"px";this._iframe.style.width="calc(100% - "+t.x+"px)"}.bind(this)}));var s=this._createResizeHandle(jQuery.extend(n.RESIZE_HANDLE.LEFT,{cursor:"w-resize",resize:function(e,t){e.style.left=t.x+"px";this._iframe.style.width=t.x+"px"}.bind(this)}));t.id=n.RESIZE_OVERLAY_ID;t.style.position="absolute";t.style.width="100%";t.style.height="100%";t.style.top="0";t.style.left="0";t.style["z-index"]=n.RESIZE_OVERLAY_ZINDEX;t.style.display="none";e.id=n.IFRAME_ID;e.src=this._sUrl;e.style.position="absolute";e.style.border="none";e.style.borderRadius="1px";e.style["z-index"]=n.IFRAME_ZINDEX;e.style.boxShadow="1px -10px 42px -4px #888";document.body.appendChild(i);document.body.appendChild(o);document.body.appendChild(s);document.body.appendChild(t);document.body.appendChild(e);window.communicationWindows.testRecorder=e.contentWindow;p();this._iframe=e;this._resizeOverlay=t;this._resizeHandles={BOTTOM:i,RIGHT:o,LEFT:s};this._dockStarted=false;this._isInIframe=true;this._closeTriggered=false};d.prototype.close=function(){if(this._closeTriggered){return}this._closeTriggered=true;if(this._isInIframe){var e=this._iframe&&this._iframe.contentWindow;if(e){this._iframe.src="about:blank";e.close();if(typeof CollectGarbage=="function"){CollectGarbage()}this._iframe.remove();this._resizeOverlay.remove();Object.values(this._resizeHandles).forEach(function(e){e.remove()});this._iframe=null;this._resizeOverlay=null;this._resizeHandles={}}}else if(window.communicationWindows.testRecorder){window.communicationWindows.testRecorder.close()}if(!this._dockStarted){window.communicationWindows={};this.fnOnClose()}};d.prototype.getCommunicationInfo=function(){return{origin:this._sOrigin,identifier:this._sIdentifier,url:this._sUrl}};d.prototype._generateTestRecorderUrl=function(){var t=(new e).search(true);var i=["sap-language"];var o=["sap-ui-testRecorder"];var s=Object.keys(t).map(function(e){if(o.indexOf(e)===-1&&e.startsWith("sap-ui-")||i.indexOf(e)>-1){return"&"+e+"="+t[e]}}).join("");this._sUrl=sap.ui.require.toUrl("sap/ui/testrecorder/ui/overlay.html")+"?sap-ui-testrecorder-origin="+window.location.protocol+"//"+window.location.host+"&"+"sap-ui-testrecorder-frame-identifier="+this._sIdentifier+s;var n=new e(this._sUrl);this._sOrigin=(n.protocol()||window.location.protocol.replace(":",""))+"://"+(n.host()||window.location.host)};d.prototype._createResizeHandle=function(e){var t=document.createElement("DIV");t.id=e.id;t.style.position="absolute";t.style.width=e.width;t.style.height=e.height;t.style.left=e.left;t.style.top=e.top;t.style["z-index"]=n.RESIZE_HANDLE_ZINDEX;t.style.cursor=e.cursor;t.style.display="none";t.onmouseover=this._onResizeHandleMouseover(t);t.onmousedown=this._onResizeHandleMousedown(t,e.resize);t.onmouseleave=this._onResizeHandleMouseleave(t);return t};function c(e){return function(){e.style.background="#0854a0"}}function u(e,t){return function(i){i.preventDefault();a=true;this._resizeOverlay.style.display="block";document.onmouseup=this._onDocumentMouseup;document.onmousemove=this._onDocumentMousemove(e,t)}.bind(this)}function l(e){return function(){if(!a){e.style.background="transparent"}}}function h(){a=false;this._resizeOverlay.style.display="none";document.onmouseup=null;document.onmousemove=null}function m(e,t){return i(function(i){i.preventDefault();var o=150;t(e,{x:Math.max(Math.min(i.clientX,window.innerWidth-o),o),y:Math.max(Math.min(i.clientY,window.innerHeight-o),o)})},50)}function f(){return""+Date.now()}function p(){var e=window.document.getElementById("sap-ui-bootstrap");if(e&&e.dataset.sapUiLanguage){_(function(t){t.dataset.sapUiLanguage=e.dataset.sapUiLanguage})}if(e&&e.dataset.sapUiConfig){e.dataset.sapUiConfig.split(",").forEach(function(e){if(e.startsWith("language:")){_(function(t){t.dataset.sapUiConfig=t.dataset.sapUiConfig?t.dataset.sapUiConfig+","+e:e})}})}if(window["sap-ui-config"]?.language){window.communicationWindows.testRecorder["sap-ui-config"]=window.communicationWindows.testRecorder["sap-ui-config"]||{};window.communicationWindows.testRecorder["sap-ui-config"].language=window["sap-ui-config"].language}}function _(e){var t=window.communicationWindows.testRecorder.document.getElementById("sap-ui-bootstrap");if(t){e(t)}else{setTimeout(function(){_(e)},10)}}r=new d;return r},true);
//# sourceMappingURL=UIContextInjector.js.map