/*!
 * jQuery UI Sortable 1.10.4
 * http://jqueryui.com
 *
 * Copyright 2014 jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 *
 * http://api.jqueryui.com/sortable/
 *
 * Depends:
 *	jquery.ui.core.js
 *	jquery.ui.mouse.js
 *	jquery.ui.widget.js
 */
(function(t,e){function i(t,e,i){return t>e&&t<e+i}function s(t){return/left|right/.test(t.css("float"))||/inline|table-cell/.test(t.css("display"))}t.widget("ui.sortable",t.ui.mouse,{version:"1.10.4",widgetEventPrefix:"sort",ready:false,options:{appendTo:"parent",axis:false,connectWith:false,containment:false,cursor:"auto",cursorAt:false,dropOnEmpty:true,forcePlaceholderSize:false,forceHelperSize:false,grid:false,handle:false,helper:"original",items:"> *",opacity:false,placeholder:false,revert:false,scroll:true,scrollSensitivity:20,scrollSpeed:20,scope:"default",tolerance:"intersect",zIndex:1e3,activate:null,beforeStop:null,change:null,deactivate:null,out:null,over:null,receive:null,remove:null,sort:null,start:null,stop:null,update:null},_create:function(){var t=this.options;this.containerCache={};this.element.addClass("ui-sortable");this.refresh();this.floating=this.items.length?t.axis==="x"||s(this.items[0].item):false;this.offset=this.element.offset();this._mouseInit();this.ready=true},_destroy:function(){this.element.removeClass("ui-sortable ui-sortable-disabled");this._mouseDestroy();for(var t=this.items.length-1;t>=0;t--){this.items[t].item.removeData(this.widgetName+"-item")}return this},_setOption:function(e,i){if(e==="disabled"){this.options[e]=i;this.widget().toggleClass("ui-sortable-disabled",!!i)}else{t.Widget.prototype._setOption.apply(this,arguments)}},_mouseCapture:function(e,i){var s=null,o=false,r=this;if(this.reverting){return false}if(this.options.disabled||this.options.type==="static"){return false}this._refreshItems(e);t(e.target).parents().each(function(){if(t.data(this,r.widgetName+"-item")===r){s=t(this);return false}});if(t.data(e.target,r.widgetName+"-item")===r){s=t(e.target)}if(!s){return false}if(this.options.handle&&!i){t(this.options.handle,s).find("*").addBack().each(function(){if(this===e.target){o=true}});if(!o){return false}}this.currentItem=s;this._removeCurrentsFromItems();return true},_mouseStart:function(e,i,s){var o,r,n=this.options;this.currentContainer=this;this.refreshPositions();this.helper=this._createHelper(e);this._cacheHelperProportions();this._cacheMargins();this.scrollParent=this.helper.scrollParent();this.offset=this.currentItem.offset();this.offset={top:this.offset.top-this.margins.top,left:this.offset.left-this.margins.left};t.extend(this.offset,{click:{left:e.pageX-this.offset.left,top:e.pageY-this.offset.top},parent:this._getParentOffset(),relative:this._getRelativeOffset()});this.helper.css("position","absolute");this.cssPosition=this.helper.css("position");this.originalPosition=this._generatePosition(e);this.originalPageX=e.pageX;this.originalPageY=e.pageY;n.cursorAt&&this._adjustOffsetFromHelper(n.cursorAt);this.domPosition={prev:this.currentItem.prev()[0],parent:this.currentItem.parent()[0]};if(this.helper[0]!==this.currentItem[0]){this.currentItem.hide()}this._createPlaceholder();if(n.containment){this._setContainment()}if(n.cursor&&n.cursor!=="auto"){r=this.document.find("body");this.storedCursor=r.css("cursor");r.css("cursor",n.cursor);this.storedStylesheet=t("<style>*{ cursor: "+n.cursor+" !important; }</style>").appendTo(r)}if(n.opacity){if(this.helper.css("opacity")){this._storedOpacity=this.helper.css("opacity")}this.helper.css("opacity",n.opacity)}if(n.zIndex){if(this.helper.css("zIndex")){this._storedZIndex=this.helper.css("zIndex")}this.helper.css("zIndex",n.zIndex)}if(this.scrollParent[0]!==document&&this.scrollParent[0].tagName!=="HTML"){this.overflowOffset=this.scrollParent.offset()}this._trigger("start",e,this._uiHash());if(!this._preserveHelperProportions){this._cacheHelperProportions()}if(!s){for(o=this.containers.length-1;o>=0;o--){this.containers[o]._trigger("activate",e,this._uiHash(this))}}if(t.ui.ddmanager){t.ui.ddmanager.current=this}if(t.ui.ddmanager&&!n.dropBehaviour){t.ui.ddmanager.prepareOffsets(this,e)}this.dragging=true;this.helper.addClass("ui-sortable-helper");this._mouseDrag(e);return true},_mouseDrag:function(e){var i,s,o,r,n=this.options,h=false;this.position=this._generatePosition(e);this.positionAbs=this._convertPositionTo("absolute");if(!this.lastPositionAbs){this.lastPositionAbs=this.positionAbs}if(this.options.scroll){if(this.scrollParent[0]!==document&&this.scrollParent[0].tagName!=="HTML"){if(this.overflowOffset.top+this.scrollParent[0].offsetHeight-e.pageY<n.scrollSensitivity){this.scrollParent[0].scrollTop=h=this.scrollParent[0].scrollTop+n.scrollSpeed}else if(e.pageY-this.overflowOffset.top<n.scrollSensitivity){this.scrollParent[0].scrollTop=h=this.scrollParent[0].scrollTop-n.scrollSpeed}if(this.overflowOffset.left+this.scrollParent[0].offsetWidth-e.pageX<n.scrollSensitivity){this.scrollParent[0].scrollLeft=h=this.scrollParent[0].scrollLeft+n.scrollSpeed}else if(e.pageX-this.overflowOffset.left<n.scrollSensitivity){this.scrollParent[0].scrollLeft=h=this.scrollParent[0].scrollLeft-n.scrollSpeed}}else{if(e.pageY-t(document).scrollTop()<n.scrollSensitivity){h=t(document).scrollTop(t(document).scrollTop()-n.scrollSpeed)}else if(t(window).height()-(e.pageY-t(document).scrollTop())<n.scrollSensitivity){h=t(document).scrollTop(t(document).scrollTop()+n.scrollSpeed)}if(e.pageX-t(document).scrollLeft()<n.scrollSensitivity){h=t(document).scrollLeft(t(document).scrollLeft()-n.scrollSpeed)}else if(t(window).width()-(e.pageX-t(document).scrollLeft())<n.scrollSensitivity){h=t(document).scrollLeft(t(document).scrollLeft()+n.scrollSpeed)}}if(h!==false&&t.ui.ddmanager&&!n.dropBehaviour){t.ui.ddmanager.prepareOffsets(this,e)}}this.positionAbs=this._convertPositionTo("absolute");if(!this.options.axis||this.options.axis!=="y"){this.helper[0].style.left=this.position.left+"px"}if(!this.options.axis||this.options.axis!=="x"){this.helper[0].style.top=this.position.top+"px"}for(i=this.items.length-1;i>=0;i--){s=this.items[i];o=s.item[0];r=this._intersectsWithPointer(s);if(!r){continue}if(s.instance!==this.currentContainer){continue}if(o!==this.currentItem[0]&&this.placeholder[r===1?"next":"prev"]()[0]!==o&&!t.contains(this.placeholder[0],o)&&(this.options.type==="semi-dynamic"?!t.contains(this.element[0],o):true)){this.direction=r===1?"down":"up";if(this.options.tolerance==="pointer"||this._intersectsWithSides(s)){this._rearrange(e,s)}else{break}this._trigger("change",e,this._uiHash());break}}this._contactContainers(e);if(t.ui.ddmanager){t.ui.ddmanager.drag(this,e)}this._trigger("sort",e,this._uiHash());this.lastPositionAbs=this.positionAbs;return false},_mouseStop:function(e,i){if(!e){return}if(t.ui.ddmanager&&!this.options.dropBehaviour){t.ui.ddmanager.drop(this,e)}if(this.options.revert){var s=this,o=this.placeholder.offset(),r=this.options.axis,n={};if(!r||r==="x"){n.left=o.left-this.offset.parent.left-this.margins.left+(this.offsetParent[0]===document.body?0:this.offsetParent[0].scrollLeft)}if(!r||r==="y"){n.top=o.top-this.offset.parent.top-this.margins.top+(this.offsetParent[0]===document.body?0:this.offsetParent[0].scrollTop)}this.reverting=true;t(this.helper).animate(n,parseInt(this.options.revert,10)||500,function(){s._clear(e)})}else{this._clear(e,i)}return false},cancel:function(){if(this.dragging){this._mouseUp({target:null});if(this.options.helper==="original"){this.currentItem.css(this._storedCSS).removeClass("ui-sortable-helper")}else{this.currentItem.show()}for(var e=this.containers.length-1;e>=0;e--){this.containers[e]._trigger("deactivate",null,this._uiHash(this));if(this.containers[e].containerCache.over){this.containers[e]._trigger("out",null,this._uiHash(this));this.containers[e].containerCache.over=0}}}if(this.placeholder){if(this.placeholder[0].parentNode){this.placeholder[0].parentNode.removeChild(this.placeholder[0])}if(this.options.helper!=="original"&&this.helper&&this.helper[0].parentNode){this.helper.remove()}t.extend(this,{helper:null,dragging:false,reverting:false,_noFinalSort:null});if(this.domPosition.prev){t(this.domPosition.prev).after(this.currentItem)}else{t(this.domPosition.parent).prepend(this.currentItem)}}return this},serialize:function(e){var i=this._getItemsAsjQuery(e&&e.connected),s=[];e=e||{};t(i).each(function(){var i=(t(e.item||this).attr(e.attribute||"id")||"").match(e.expression||/(.+)[\-=_](.+)/);if(i){s.push((e.key||i[1]+"[]")+"="+(e.key&&e.expression?i[1]:i[2]))}});if(!s.length&&e.key){s.push(e.key+"=")}return s.join("&")},toArray:function(e){var i=this._getItemsAsjQuery(e&&e.connected),s=[];e=e||{};i.each(function(){s.push(t(e.item||this).attr(e.attribute||"id")||"")});return s},_intersectsWith:function(t){var e=this.positionAbs.left,i=e+this.helperProportions.width,s=this.positionAbs.top,o=s+this.helperProportions.height,r=t.left,n=r+t.width,h=t.top,l=h+t.height,a=this.offset.click.top,c=this.offset.click.left,f=this.options.axis==="x"||s+a>h&&s+a<l,p=this.options.axis==="y"||e+c>r&&e+c<n,u=f&&p;if(this.options.tolerance==="pointer"||this.options.forcePointerForContainers||this.options.tolerance!=="pointer"&&this.helperProportions[this.floating?"width":"height"]>t[this.floating?"width":"height"]){return u}else{return r<e+this.helperProportions.width/2&&i-this.helperProportions.width/2<n&&h<s+this.helperProportions.height/2&&o-this.helperProportions.height/2<l}},_intersectsWithPointer:function(t){var e=this.options.axis==="x"||i(this.positionAbs.top+this.offset.click.top,t.top,t.height),s=this.options.axis==="y"||i(this.positionAbs.left+this.offset.click.left,t.left,t.width),o=e&&s,r=this._getDragVerticalDirection(),n=this._getDragHorizontalDirection();if(!o){return false}return this.floating?n&&n==="right"||r==="down"?2:1:r&&(r==="down"?2:1)},_intersectsWithSides:function(t){var e=i(this.positionAbs.top+this.offset.click.top,t.top+t.height/2,t.height),s=i(this.positionAbs.left+this.offset.click.left,t.left+t.width/2,t.width),o=this._getDragVerticalDirection(),r=this._getDragHorizontalDirection();if(this.floating&&r){return r==="right"&&s||r==="left"&&!s}else{return o&&(o==="down"&&e||o==="up"&&!e)}},_getDragVerticalDirection:function(){var t=this.positionAbs.top-this.lastPositionAbs.top;return t!==0&&(t>0?"down":"up")},_getDragHorizontalDirection:function(){var t=this.positionAbs.left-this.lastPositionAbs.left;return t!==0&&(t>0?"right":"left")},refresh:function(t){this._refreshItems(t);this.refreshPositions();return this},_connectWith:function(){var t=this.options;return t.connectWith.constructor===String?[t.connectWith]:t.connectWith},_getItemsAsjQuery:function(e){var i,s,o,r,n=[],h=[],l=this._connectWith();if(l&&e){for(i=l.length-1;i>=0;i--){o=t(l[i]);for(s=o.length-1;s>=0;s--){r=t.data(o[s],this.widgetFullName);if(r&&r!==this&&!r.options.disabled){h.push([typeof r.options.items==="function"?r.options.items.call(r.element):t(r.options.items,r.element).not(".ui-sortable-helper").not(".ui-sortable-placeholder"),r])}}}}h.push([typeof this.options.items==="function"?this.options.items.call(this.element,null,{options:this.options,item:this.currentItem}):t(this.options.items,this.element).not(".ui-sortable-helper").not(".ui-sortable-placeholder"),this]);function a(){n.push(this)}for(i=h.length-1;i>=0;i--){h[i][0].each(a)}return t(n)},_removeCurrentsFromItems:function(){var e=this.currentItem.find(":data("+this.widgetName+"-item)");this.items=t.grep(this.items,function(t){for(var i=0;i<e.length;i++){if(e[i]===t.item[0]){return false}}return true})},_refreshItems:function(e){this.items=[];this.containers=[this];var i,s,o,r,n,h,l,a,c=this.items,f=[[typeof this.options.items==="function"?this.options.items.call(this.element[0],e,{item:this.currentItem}):t(this.options.items,this.element),this]],p=this._connectWith();if(p&&this.ready){for(i=p.length-1;i>=0;i--){o=t(p[i]);for(s=o.length-1;s>=0;s--){r=t.data(o[s],this.widgetFullName);if(r&&r!==this&&!r.options.disabled){f.push([typeof r.options.items==="function"?r.options.items.call(r.element[0],e,{item:this.currentItem}):t(r.options.items,r.element),r]);this.containers.push(r)}}}}for(i=f.length-1;i>=0;i--){n=f[i][1];h=f[i][0];for(s=0,a=h.length;s<a;s++){l=t(h[s]);l.data(this.widgetName+"-item",n);c.push({item:l,instance:n,width:0,height:0,left:0,top:0})}}},refreshPositions:function(e){if(this.offsetParent&&this.helper){this.offset.parent=this._getParentOffset()}var i,s,o,r;for(i=this.items.length-1;i>=0;i--){s=this.items[i];if(s.instance!==this.currentContainer&&this.currentContainer&&s.item[0]!==this.currentItem[0]){continue}o=this.options.toleranceElement?t(this.options.toleranceElement,s.item):s.item;if(!e){s.width=o.outerWidth();s.height=o.outerHeight()}r=o.offset();s.left=r.left;s.top=r.top}if(this.options.custom&&this.options.custom.refreshContainers){this.options.custom.refreshContainers.call(this)}else{for(i=this.containers.length-1;i>=0;i--){r=this.containers[i].element.offset();this.containers[i].containerCache.left=r.left;this.containers[i].containerCache.top=r.top;this.containers[i].containerCache.width=this.containers[i].element.outerWidth();this.containers[i].containerCache.height=this.containers[i].element.outerHeight()}}return this},_createPlaceholder:function(e){e=e||this;var i,s=e.options;if(!s.placeholder||s.placeholder.constructor===String){i=s.placeholder;s.placeholder={element:function(){var s=e.currentItem[0].nodeName.toLowerCase(),o=t("<"+s+">",e.document[0]).addClass(i||e.currentItem[0].className+" ui-sortable-placeholder").removeClass("ui-sortable-helper");if(s==="tr"){e.currentItem.children().each(function(){t("<td>&#160;</td>",e.document[0]).attr("colspan",t(this).attr("colspan")||1).appendTo(o)})}else if(s==="img"){o.attr("src",e.currentItem.attr("src"))}if(!i){o.css("visibility","hidden")}return o},update:function(t,o){if(i&&!s.forcePlaceholderSize){return}if(!o.height()){o.height(e.currentItem.innerHeight()-parseInt(e.currentItem.css("paddingTop")||0,10)-parseInt(e.currentItem.css("paddingBottom")||0,10))}if(!o.width()){o.width(e.currentItem.innerWidth()-parseInt(e.currentItem.css("paddingLeft")||0,10)-parseInt(e.currentItem.css("paddingRight")||0,10))}}}}e.placeholder=t(s.placeholder.element.call(e.element,e.currentItem));e.currentItem.after(e.placeholder);s.placeholder.update(e,e.placeholder)},_contactContainers:function(e){var o,r,n,h,l,a,c,f,p,u,d=null,m=null;for(o=this.containers.length-1;o>=0;o--){if(t.contains(this.currentItem[0],this.containers[o].element[0])){continue}if(this._intersectsWith(this.containers[o].containerCache)){if(d&&t.contains(this.containers[o].element[0],d.element[0])){continue}d=this.containers[o];m=o}else{if(this.containers[o].containerCache.over){this.containers[o]._trigger("out",e,this._uiHash(this));this.containers[o].containerCache.over=0}}}if(!d){return}if(this.containers.length===1){if(!this.containers[m].containerCache.over){this.containers[m]._trigger("over",e,this._uiHash(this));this.containers[m].containerCache.over=1}}else{n=1e4;h=null;u=d.floating||s(this.currentItem);l=u?"left":"top";a=u?"width":"height";c=this.positionAbs[l]+this.offset.click[l];for(r=this.items.length-1;r>=0;r--){if(!t.contains(this.containers[m].element[0],this.items[r].item[0])){continue}if(this.items[r].item[0]===this.currentItem[0]){continue}if(u&&!i(this.positionAbs.top+this.offset.click.top,this.items[r].top,this.items[r].height)){continue}f=this.items[r].item.offset()[l];p=false;if(Math.abs(f-c)>Math.abs(f+this.items[r][a]-c)){p=true;f+=this.items[r][a]}if(Math.abs(f-c)<n){n=Math.abs(f-c);h=this.items[r];this.direction=p?"up":"down"}}if(!h&&!this.options.dropOnEmpty){return}if(this.currentContainer===this.containers[m]){return}h?this._rearrange(e,h,null,true):this._rearrange(e,null,this.containers[m].element,true);this._trigger("change",e,this._uiHash());this.containers[m]._trigger("change",e,this._uiHash(this));this.currentContainer=this.containers[m];this.options.placeholder.update(this.currentContainer,this.placeholder);this.containers[m]._trigger("over",e,this._uiHash(this));this.containers[m].containerCache.over=1}},_createHelper:function(e){var i=this.options,s=typeof i.helper==="function"?t(i.helper.apply(this.element[0],[e,this.currentItem])):i.helper==="clone"?this.currentItem.clone():this.currentItem;if(!s.parents("body").length){t(i.appendTo!=="parent"?i.appendTo:this.currentItem[0].parentNode)[0].appendChild(s[0])}if(s[0]===this.currentItem[0]){this._storedCSS={width:this.currentItem[0].style.width,height:this.currentItem[0].style.height,position:this.currentItem.css("position"),top:this.currentItem.css("top"),left:this.currentItem.css("left")}}if(!s[0].style.width||i.forceHelperSize){s.width(this.currentItem.width())}if(!s[0].style.height||i.forceHelperSize){s.height(this.currentItem.height())}return s},_adjustOffsetFromHelper:function(e){if(typeof e==="string"){e=e.split(" ")}if(t.isArray(e)){e={left:+e[0],top:+e[1]||0}}if("left"in e){this.offset.click.left=e.left+this.margins.left}if("right"in e){this.offset.click.left=this.helperProportions.width-e.right+this.margins.left}if("top"in e){this.offset.click.top=e.top+this.margins.top}if("bottom"in e){this.offset.click.top=this.helperProportions.height-e.bottom+this.margins.top}},_getParentOffset:function(){this.offsetParent=this.helper.offsetParent();var e=this.offsetParent.offset();if(this.cssPosition==="absolute"&&this.scrollParent[0]!==document&&t.contains(this.scrollParent[0],this.offsetParent[0])){e.left+=this.scrollParent.scrollLeft();e.top+=this.scrollParent.scrollTop()}if(this.offsetParent[0]===document.body||this.offsetParent[0].tagName&&this.offsetParent[0].tagName.toLowerCase()==="html"&&t.ui.ie){e={top:0,left:0}}return{top:e.top+(parseInt(this.offsetParent.css("borderTopWidth"),10)||0),left:e.left+(parseInt(this.offsetParent.css("borderLeftWidth"),10)||0)}},_getRelativeOffset:function(){if(this.cssPosition==="relative"){var t=this.currentItem.position();return{top:t.top-(parseInt(this.helper.css("top"),10)||0)+this.scrollParent.scrollTop(),left:t.left-(parseInt(this.helper.css("left"),10)||0)+this.scrollParent.scrollLeft()}}else{return{top:0,left:0}}},_cacheMargins:function(){this.margins={left:parseInt(this.currentItem.css("marginLeft"),10)||0,top:parseInt(this.currentItem.css("marginTop"),10)||0}},_cacheHelperProportions:function(){this.helperProportions={width:this.helper.outerWidth(),height:this.helper.outerHeight()}},_setContainment:function(){var e,i,s,o=this.options;if(o.containment==="parent"){o.containment=this.helper[0].parentNode}if(o.containment==="document"||o.containment==="window"){this.containment=[0-this.offset.relative.left-this.offset.parent.left,0-this.offset.relative.top-this.offset.parent.top,t(o.containment==="document"?document:window).width()-this.helperProportions.width-this.margins.left,(t(o.containment==="document"?document:window).height()||document.body.parentNode.scrollHeight)-this.helperProportions.height-this.margins.top]}if(!/^(document|window|parent)$/.test(o.containment)){e=t(o.containment)[0];i=t(o.containment).offset();s=t(e).css("overflow")!=="hidden";this.containment=[i.left+(parseInt(t(e).css("borderLeftWidth"),10)||0)+(parseInt(t(e).css("paddingLeft"),10)||0)-this.margins.left,i.top+(parseInt(t(e).css("borderTopWidth"),10)||0)+(parseInt(t(e).css("paddingTop"),10)||0)-this.margins.top,i.left+(s?Math.max(e.scrollWidth,e.offsetWidth):e.offsetWidth)-(parseInt(t(e).css("borderLeftWidth"),10)||0)-(parseInt(t(e).css("paddingRight"),10)||0)-this.helperProportions.width-this.margins.left,i.top+(s?Math.max(e.scrollHeight,e.offsetHeight):e.offsetHeight)-(parseInt(t(e).css("borderTopWidth"),10)||0)-(parseInt(t(e).css("paddingBottom"),10)||0)-this.helperProportions.height-this.margins.top]}},_convertPositionTo:function(e,i){if(!i){i=this.position}var s=e==="absolute"?1:-1,o=this.cssPosition==="absolute"&&!(this.scrollParent[0]!==document&&t.contains(this.scrollParent[0],this.offsetParent[0]))?this.offsetParent:this.scrollParent,r=/(html|body)/i.test(o[0].tagName);return{top:i.top+this.offset.relative.top*s+this.offset.parent.top*s-(this.cssPosition==="fixed"?-this.scrollParent.scrollTop():r?0:o.scrollTop())*s,left:i.left+this.offset.relative.left*s+this.offset.parent.left*s-(this.cssPosition==="fixed"?-this.scrollParent.scrollLeft():r?0:o.scrollLeft())*s}},_generatePosition:function(e){var i,s,o=this.options,r=e.pageX,n=e.pageY,h=this.cssPosition==="absolute"&&!(this.scrollParent[0]!==document&&t.contains(this.scrollParent[0],this.offsetParent[0]))?this.offsetParent:this.scrollParent,l=/(html|body)/i.test(h[0].tagName);if(this.cssPosition==="relative"&&!(this.scrollParent[0]!==document&&this.scrollParent[0]!==this.offsetParent[0])){this.offset.relative=this._getRelativeOffset()}if(this.originalPosition){if(this.containment){if(e.pageX-this.offset.click.left<this.containment[0]){r=this.containment[0]+this.offset.click.left}if(e.pageY-this.offset.click.top<this.containment[1]){n=this.containment[1]+this.offset.click.top}if(e.pageX-this.offset.click.left>this.containment[2]){r=this.containment[2]+this.offset.click.left}if(e.pageY-this.offset.click.top>this.containment[3]){n=this.containment[3]+this.offset.click.top}}if(o.grid){i=this.originalPageY+Math.round((n-this.originalPageY)/o.grid[1])*o.grid[1];n=this.containment?i-this.offset.click.top>=this.containment[1]&&i-this.offset.click.top<=this.containment[3]?i:i-this.offset.click.top>=this.containment[1]?i-o.grid[1]:i+o.grid[1]:i;s=this.originalPageX+Math.round((r-this.originalPageX)/o.grid[0])*o.grid[0];r=this.containment?s-this.offset.click.left>=this.containment[0]&&s-this.offset.click.left<=this.containment[2]?s:s-this.offset.click.left>=this.containment[0]?s-o.grid[0]:s+o.grid[0]:s}}return{top:n-this.offset.click.top-this.offset.relative.top-this.offset.parent.top+(this.cssPosition==="fixed"?-this.scrollParent.scrollTop():l?0:h.scrollTop()),left:r-this.offset.click.left-this.offset.relative.left-this.offset.parent.left+(this.cssPosition==="fixed"?-this.scrollParent.scrollLeft():l?0:h.scrollLeft())}},_rearrange:function(t,e,i,s){i?i[0].appendChild(this.placeholder[0]):e.item[0].parentNode.insertBefore(this.placeholder[0],this.direction==="down"?e.item[0]:e.item[0].nextSibling);this.counter=this.counter?++this.counter:1;var o=this.counter;this._delay(function(){if(o===this.counter){this.refreshPositions(!s)}})},_clear:function(t,e){this.reverting=false;var i,s=[];if(!this._noFinalSort&&this.currentItem.parent().length){this.placeholder.before(this.currentItem)}this._noFinalSort=null;if(this.helper[0]===this.currentItem[0]){for(i in this._storedCSS){if(this._storedCSS[i]==="auto"||this._storedCSS[i]==="static"){this._storedCSS[i]=""}}this.currentItem.css(this._storedCSS).removeClass("ui-sortable-helper")}else{this.currentItem.show()}if(this.fromOutside&&!e){s.push(function(t){this._trigger("receive",t,this._uiHash(this.fromOutside))})}if((this.fromOutside||this.domPosition.prev!==this.currentItem.prev().not(".ui-sortable-helper")[0]||this.domPosition.parent!==this.currentItem.parent()[0])&&!e){s.push(function(t){this._trigger("update",t,this._uiHash())})}if(this!==this.currentContainer){if(!e){s.push(function(t){this._trigger("remove",t,this._uiHash())});s.push(function(t){return function(e){t._trigger("receive",e,this._uiHash(this))}}.call(this,this.currentContainer));s.push(function(t){return function(e){t._trigger("update",e,this._uiHash(this))}}.call(this,this.currentContainer))}}function o(t,e,i){return function(s){i._trigger(t,s,e._uiHash(e))}}for(i=this.containers.length-1;i>=0;i--){if(!e){s.push(o("deactivate",this,this.containers[i]))}if(this.containers[i].containerCache.over){s.push(o("out",this,this.containers[i]));this.containers[i].containerCache.over=0}}if(this.storedCursor){this.document.find("body").css("cursor",this.storedCursor);this.storedStylesheet.remove()}if(this._storedOpacity){this.helper.css("opacity",this._storedOpacity)}if(this._storedZIndex){this.helper.css("zIndex",this._storedZIndex==="auto"?"":this._storedZIndex)}this.dragging=false;if(this.cancelHelperRemoval){if(!e){this._trigger("beforeStop",t,this._uiHash());for(i=0;i<s.length;i++){s[i].call(this,t)}this._trigger("stop",t,this._uiHash())}this.fromOutside=false;return false}if(!e){this._trigger("beforeStop",t,this._uiHash())}this.placeholder[0].parentNode.removeChild(this.placeholder[0]);if(this.helper[0]!==this.currentItem[0]){this.helper.remove()}this.helper=null;if(!e){for(i=0;i<s.length;i++){s[i].call(this,t)}this._trigger("stop",t,this._uiHash())}this.fromOutside=false;return true},_trigger:function(){if(t.Widget.prototype._trigger.apply(this,arguments)===false){this.cancel()}},_uiHash:function(e){var i=e||this;return{helper:i.helper,placeholder:i.placeholder||t([]),position:i.position,originalPosition:i.originalPosition,offset:i.positionAbs,item:i.currentItem,sender:e?e.element:null}}})})(jQuery);
//# sourceMappingURL=jquery-ui-sortable.js.map