/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Control","sap/ui/Device","sap/ui/core/LocaleData","sap/ui/core/delegate/ItemNavigation","sap/ui/unified/library","sap/ui/core/Locale","./MonthPickerRenderer","sap/ui/thirdparty/jquery","sap/ui/events/KeyCodes","sap/ui/unified/DateRange","sap/ui/unified/calendar/CalendarUtils","sap/ui/unified/calendar/CalendarDate","sap/ui/core/Configuration","sap/ui/core/date/UI5Date"],function(t,e,a,i,s,o,n,jQuery,r,h,l,g,c,f){"use strict";var d=12,u=2,p={OneYearBackward:-1,OneYearForward:1};var _=t.extend("sap.ui.unified.calendar.MonthPicker",{metadata:{library:"sap.ui.unified",properties:{month:{type:"int",group:"Data",defaultValue:0},months:{type:"int",group:"Appearance",defaultValue:12},intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},columns:{type:"int",group:"Appearance",defaultValue:3},primaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance"},secondaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance"},_firstMonth:{type:"int",group:"Data",visibility:"hidden",defaultValue:0},_focusedMonth:{type:"int",group:"Data",visibility:"hidden"}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{select:{},pageChange:{}}},renderer:n});_.prototype.init=function(){this._iMinMonth=0;this._iMaxMonth=11};_.prototype.onAfterRendering=function(){var t,e=this.getMonth(),a=this.getMonths(),i=this.getProperty("_firstMonth"),s=this.getProperty("_focusedMonth"),o=this._oItemNavigation?this._oItemNavigation.getFocusedIndex():0;m.call(this);D.call(this);if(this.getColumns()>0){t=s%a;var n=parseInt(d/a),r=n*a;if(s>=r){t=12-r+1+t}}else if(e<i||e>i+a-1){t=o}else{t=e-i}this._oItemNavigation.focusItem(t)};_.prototype.setMonth=function(t){var e=Math.floor(t/this.getMonths())*this.getMonths();if(e+this.getMonths()>12){e=12-this.getMonths()}this.setProperty("month",t);this.setProperty("_focusedMonth",t);this.setProperty("_firstMonth",e);t=this.getProperty("month");if(t<0||t>11){throw new Error("Property month must be between 0 and 11; "+this)}if(this.getIntervalSelection()){this._oItemNavigation&&this._oItemNavigation.focusItem(t);return this}if(this.getDomRef()){if(this.getMonths()<12){var a=this.getStartMonth();if(t>=a&&t<=a+this.getMonths()-1){this._selectMonth(t,true);this._oItemNavigation.focusItem(t-a)}else{S.call(this,t)}}else{this._selectMonth(t,true);this._oItemNavigation.focusItem(t)}}return this};_.prototype.getSelectedDates=function(){if(this._oSelectedDatesControlOrigin){return this._oSelectedDatesControlOrigin.getSelectedDates()}return this.getAggregation("selectedDates")};_.prototype._getPrimaryCalendarType=function(){return this.getProperty("primaryCalendarType")||c.getCalendarType()};_.prototype._getSelectedDates=function(){var t=this.getSelectedDates(),e;if(t){return t}else if(!this._aMPSelectedDates||!this._aMPSelectedDates.length){this._aMPSelectedDates=[new h];e=g.fromLocalJSDate(f.getInstance(),this._getPrimaryCalendarType());e.setMonth(this.getMonth(),1);this._iYear&&e.setYear(this._iYear);this._aMPSelectedDates[0].setStartDate(e.toLocalJSDate());return this._aMPSelectedDates}else{return this._aMPSelectedDates}};_.prototype.exit=function(){if(this._aMPSelectedDates&&this._aMPSelectedDates.length){this._aMPSelectedDates.forEach(function(t){t.destroy()});this._aMPSelectedDates=undefined}};_.prototype.getFocusDomRef=function(){return this.getDomRef()&&this._oItemNavigation.getItemDomRefs()[this._oItemNavigation.getFocusedIndex()]};_.prototype._setSelectedDatesControlOrigin=function(t){this._oSelectedDatesControlOrigin=t};_.prototype._setYear=function(t){this._iYear=t};_.prototype._setDate=function(t){this._oDate=t};_.prototype._getLocale=function(){var t=this._oSelectedDatesControlOrigin;if(t&&t._getLocale){return t._getLocale()}else if(!this._sLocale){this._sLocale=c.getFormatSettings().getFormatLocale().toString()}return this._sLocale};_.prototype._getLocaleData=function(){var t=this._oSelectedDatesControlOrigin;if(t&&t._getLocaleData){return t._getLocaleData()}else if(!this._oLocaleData){var e=this._getLocale();var i=new o(e);this._oLocaleData=a.getInstance(i)}return this._oLocaleData};_.prototype.onsapspace=function(t){t.preventDefault()};_.prototype.onsapselect=function(t){var e=this._oItemNavigation.getFocusedIndex();var a=e+this.getStartMonth();if(a>=this._iMinMonth&&a<=this._iMaxMonth){this._selectMonth(a);this.fireSelect()}};_.prototype.onmousedown=function(t){this._oMousedownPosition={clientX:t.clientX,clientY:t.clientY}};_.prototype.onmouseup=function(t){var a=t.target,i=this._getSelectedDates()[0],s,o,n;if(this._bMousedownChange){this._bMousedownChange=false;if(this.getIntervalSelection()&&a.classList.contains("sapUiCalItem")&&i){s=g.fromLocalJSDate(i.getStartDate(),this._getPrimaryCalendarType());o=i.getEndDate();n=this._extractMonth(a);if(n!==s.getMonth()&&!o&&n>=this._iMinMonth&&n<=this._iMaxMonth){this._selectMonth(n);this._oItemNavigation.focusItem(n)}}this.fireSelect()}else if(e.support.touch&&this._isValueInThreshold(this._oMousedownPosition.clientX,t.clientX,10)&&this._isValueInThreshold(this._oMousedownPosition.clientY,t.clientY,10)){n=this._oItemNavigation.getFocusedIndex()+this.getStartMonth();if(n>=this._iMinMonth&&n<=this._iMaxMonth){this._selectMonth(n);this.fireSelect()}}};_.prototype.onmouseover=function(t){var e=t.target,a=this._getSelectedDates()[0],i,s;if(!a){return}if(a.getStartDate()){i=g.fromLocalJSDate(a.getStartDate(),this._getPrimaryCalendarType());i.setDate(1)}if(e.classList.contains("sapUiCalItem")){s=g.fromLocalJSDate(f.getInstance(),this._getPrimaryCalendarType());s.setMonth(this._extractMonth(e),1);this._iYear&&s.setYear(this._iYear);if(this._isSelectionInProgress()){this._markInterval(i,s)}}};_.prototype.onThemeChanged=function(){if(this._bNoThemeChange){return}if(!this.getDomRef()){return}var t=this._oItemNavigation.getItemDomRefs(),e=this._getLocaleData(),a=e.getMonthsStandAlone("wide",this._getPrimaryCalendarType()),i,s;this._bNamesLengthChecked=undefined;this._bLongMonth=false;for(i=0;i<t.length;i++){s=jQuery(t[i]);s.text(a[i])}D.call(this)};_.prototype.nextPage=function(){var t=this.getStartMonth(),e=this._oItemNavigation.getFocusedIndex(),a=e+t,i=this.getMonths();a=a+i;if(a>d-1){a=d-1}S.call(this,a);var s=Math.floor(this.getStartMonth()+this.getMonths())%d;if(s+this.getMonths()>12){s=12-this.getMonths()}this.setProperty("_firstMonth",s);return this};_.prototype.previousPage=function(){var t=this.getStartMonth(),e=this._oItemNavigation.getFocusedIndex(),a=e+t,i=this.getMonths();a=a-i;if(a<0){a=0}S.call(this,a);var s=Math.floor(this.getStartMonth()-this.getMonths())%d;if(s<0){s=0}this.setProperty("_firstMonth",s);return this};_.prototype.setMinMax=function(t,e){var a,i,s,o;if(t==this._iMinMonth&&e==this._iMaxMonth){return this}t=parseInt(t);if(isNaN(t)||t<0||t>11){t=0}e=parseInt(e);if(isNaN(e)||e<0||e>11){e=11}if(t<=e){this._iMinMonth=t;this._iMaxMonth=e}else{this._iMaxMonth=t;this._iMinMonth=e}if(this.getDomRef()){a=this._oItemNavigation.getItemDomRefs();for(o=0;o<a.length;o++){i=jQuery(a[o]);s=this._extractMonth(a[o]);if(s<this._iMinMonth||s>this._iMaxMonth){i.addClass("sapUiCalItemDsbl");i.attr("aria-disabled",true)}else{i.removeClass("sapUiCalItemDsbl");i.removeAttr("aria-disabled")}}}return this};_.prototype.getStartMonth=function(){return this.getProperty("_firstMonth")};_.prototype._isValueInThreshold=function(t,e,a){var i=t-a,s=t+a;return e>=i&&e<=s};_.prototype._getSecondaryCalendarType=function(){var t=this.getSecondaryCalendarType();if(t===this._getPrimaryCalendarType()){return undefined}return t};_.prototype._getDisplayedSecondaryDates=function(t){var e=this.getSecondaryCalendarType(),a=new g(this._oDate?this._oDate:g.fromLocalJSDate(f.getInstance()),this._getPrimaryCalendarType()),i,s;a.setMonth(t);a.setDate(1);i=new g(a,e);a.setDate(l._daysInMonth(a));s=new g(a,e);return{start:i,end:s}};function m(){var t=this.getDomRef(),e=this.$().find(".sapUiCalItem"),a=this.getColumns();if(!this._oItemNavigation){this._oItemNavigation=new i;this._oItemNavigation.attachEvent(i.Events.AfterFocus,this._handleAfterFocus,this);this._oItemNavigation.attachEvent(i.Events.FocusAgain,M,this);this._oItemNavigation.attachEvent(i.Events.BorderReached,y,this);this.addDelegate(this._oItemNavigation);this._oItemNavigation.setHomeEndColumnMode(true,true);this._oItemNavigation.setDisabledModifiers({sapnext:["alt","meta"],sapprevious:["alt","meta"],saphome:["alt","meta"],sapend:["meta"]})}this._oItemNavigation.setRootDomRef(t);this._oItemNavigation.setItemDomRefs(e);this._oItemNavigation.setCycling(false);this._oItemNavigation.setColumns(a,true);var s=this.getMonth()-this.getStartMonth();this._oItemNavigation.setFocusedIndex(s);this._oItemNavigation.setPageSize(e.length)}_.prototype._handleAfterFocus=function(t){var e=t.getParameter("index"),a=t.getParameter("event"),i=this._oItemNavigation.aItemDomRefs[e],s=this._getSelectedDates()[0],o,n;if(!a){return}if(a.type==="mousedown"){this._handleMousedown(a,e)}else if(a.type==="sapnext"||a.type==="sapprevious"){if(!s){return}if(s.getStartDate()){o=g.fromLocalJSDate(s.getStartDate(),this._getPrimaryCalendarType());o.setDate(1)}n=g.fromLocalJSDate(f.getInstance(),this._getPrimaryCalendarType());n.setMonth(this._extractMonth(i),1);this._iYear&&n.setYear(this._iYear);if(this._isSelectionInProgress()){this._markInterval(o,n)}}};function M(t){this._handleAfterFocus(t)}_.prototype._isSelectionInProgress=function(){var t=this._getSelectedDates()[0];if(!t){return false}return this.getIntervalSelection()&&t.getStartDate()&&!t.getEndDate()};_.prototype._extractMonth=function(t){var e=this.getId().length+u;return parseInt(t.id.slice(e))};_.prototype._markInterval=function(t,e){var a=this._oItemNavigation.getItemDomRefs(),i=g.fromLocalJSDate(f.getInstance(),this._getPrimaryCalendarType()),s;if(t.isAfter(e)){e=[t,t=e][0]}if(this._bMousedownChange){if(e.getMonth()>this._iMinMonth&&e.getMonth()<this._iMaxMonth){jQuery(a[e.getMonth()]).addClass("sapUiCalItemSel")}if(t.getMonth()>this._iMinMonth&&t.getMonth()<this._iMaxMonth){jQuery(a[t.getMonth()]).addClass("sapUiCalItemSel")}}for(s=0;s<a.length;++s){i.setMonth(this._extractMonth(a[s]),1);this._iYear&&i.setYear(this._iYear);if(l._isBetween(i,t,e)&&i.getMonth()>this._iMinMonth&&i.getMonth()<this._iMaxMonth){jQuery(a[s]).addClass("sapUiCalItemSelBetween")}else{jQuery(a[s]).removeClass("sapUiCalItemSelBetween")}if(this._bMousedownChange&&!i.isSame(t)&&!i.isSame(e)){jQuery(a[s]).removeClass("sapUiCalItemSel")}}};_.prototype._handleMousedown=function(t,a){if(t.button||e.support.touch&&!e.system.combi){return}var i=a+this.getStartMonth();if(i>=this._iMinMonth&&i<=this._iMaxMonth){this._selectMonth(i);this._bMousedownChange=true}t.preventDefault();t.setMark("cancelAutoClose")};function y(t){var e=t.getParameter("event"),a=this._oItemNavigation.getFocusedIndex()+this.getStartMonth(),i=this.getMonths(),s=this.getColumns(),o=this._getSelectedDates()[0],n,h=g.fromLocalJSDate(f.getInstance(),this._getPrimaryCalendarType()),l=s===0&&i<d;this._iYear&&h.setYear(this._iYear);if(o&&o.getStartDate()){n=g.fromLocalJSDate(o.getStartDate(),this._getPrimaryCalendarType());n.setDate(1)}if(e.type){switch(e.type){case"sapnext":case"sapnextmodifiers":if(l){this._oneRowChangePage(a,true)}else if(e.keyCode===r.ARROW_DOWN&&s<=i){if(a<d-i){S.call(this,a+s,false,p.OneYearForward)}else if(i===d){this.firePageChange({offset:p.OneYearForward});this._oItemNavigation.focusItem(a%s);h.setMonth(a%s,1);this.setProperty("_focusedMonth",a%s);this._isSelectionInProgress()&&this._markInterval(n,h)}else{if(s===0){s=i}S.call(this,a%s,true,p.OneYearForward)}}else{if(a<d-i){S.call(this,a+1,false,p.OneYearForward)}else if(i===d){this.firePageChange({offset:p.OneYearForward});this._oItemNavigation.focusItem(0);h.setMonth(0,1);this._isSelectionInProgress()&&this._markInterval(n,h)}else{S.call(this,0,true,p.OneYearForward)}}break;case"sapprevious":case"sappreviousmodifiers":if(l){this._oneRowChangePage(a)}else if(e.keyCode===r.ARROW_UP&&s<=i){if(a>=i){S.call(this,a-s,false,p.OneYearBackward)}else if(i===d){this.firePageChange({offset:p.OneYearBackward});this._oItemNavigation.focusItem(i-s+a);h.setMonth(i-s+a,1);this.setProperty("_focusedMonth",i-s+a);this._isSelectionInProgress()&&this._markInterval(n,h)}else{S.call(this,d-s+a,true,p.OneYearBackward)}}else{if(a>=i){S.call(this,a-1,false,p.OneYearBackward)}else if(i===d){this.firePageChange({offset:p.OneYearBackward});this._oItemNavigation.focusItem(i-1);h.setMonth(i-1,1);this._isSelectionInProgress()&&this._markInterval(n,h)}else{S.call(this,d-1,true,p.OneYearBackward)}}break;case"sappagedown":if(a<d-i){S.call(this,a+i,false,p.OneYearForward)}else if(i===d){this.firePageChange({offset:p.OneYearForward})}else{S.call(this,a,true,p.OneYearForward)}break;case"sappageup":if(a>i){S.call(this,a-i,false,p.OneYearBackward)}else if(i===d){this.firePageChange({offset:p.OneYearBackward})}else{S.call(this,a,true,p.OneYearBackward)}break;default:break}}}_.prototype._oneRowChangePage=function(t,e){var a=this.getProperty("_firstMonth"),i=this.getMonths(),s=e?a+i<d:a>0,o=e?1:-1;if(s){e&&this.nextPage()||this.previousPage();this.firePageChange({offset:0});this.setMonth(t+o)}};_.prototype._selectMonth=function(t,e){var a=this._getSelectedDates()[0],i=this.getAggregation("selectedDates"),s,o;this.setProperty("_focusedMonth",t);if(!a){return}!e&&this.setProperty("month",t);o=g.fromLocalJSDate(f.getInstance(),this._getPrimaryCalendarType());o.setMonth(t,1);this._iYear&&o.setYear(this._iYear);if(!this._oSelectedDatesControlOrigin){if(!i||!i.length){this.addAggregation("selectedDates",a,true)}!this.getIntervalSelection()&&a.setStartDate(o.toLocalJSDate())}if(this.getIntervalSelection()&&!e){if(!a.getStartDate()){a.setStartDate(o.toLocalJSDate())}else if(!a.getEndDate()){s=g.fromLocalJSDate(a.getStartDate(),this._getPrimaryCalendarType());if(o.isBefore(s)){a.setEndDate(s.toLocalJSDate());a.setStartDate(o.toLocalJSDate())}else{a.setEndDate(o.toLocalJSDate())}}else{a.setStartDate(o.toLocalJSDate());a.setEndDate(undefined)}}};function D(){if(!this._bNamesLengthChecked){var t=0,e=this._oItemNavigation.getItemDomRefs(),a=false,i=this.getMonths(),s=Math.ceil(d/i),o=i-1;for(var n=0;n<s;n++){if(i<d){S.call(this,o);o=o+i;if(o>d-1){o=d-1}}for(t=0;t<e.length;t++){var r=e[t];if(Math.abs(r.clientWidth-r.scrollWidth)>1){a=true;break}}if(a){break}}if(i<d){o=this.getMonth();S.call(this,o)}if(a){this._bLongMonth=false;var h=this._getLocaleData(),l=this._getPrimaryCalendarType(),g=h.getMonthsStandAlone("abbreviated",l),c=h.getMonthsStandAlone("wide",l);for(t=0;t<e.length;t++){var f=jQuery(e[t]);f.text(g[t]);f.attr("aria-label",c[t])}}else{this._bLongMonth=true}this._bNamesLengthChecked=true}}function S(t,e,a){var i=this._getSelectedDates()[0],s,o;this.setProperty("_focusedMonth",t);if(i&&i.getStartDate()){s=g.fromLocalJSDate(i.getStartDate(),this._getPrimaryCalendarType());s.setDate(1)}if(i&&i.getEndDate()){o=g.fromLocalJSDate(i.getEndDate(),this._getPrimaryCalendarType());o.setDate(1)}else{o=g.fromLocalJSDate(f.getInstance(),this._getPrimaryCalendarType());this._iYear&&o.setYear(this._iYear);o.setMonth(t,1)}this._isSelectionInProgress()&&this._markInterval(s,o);if(e){this.firePageChange({offset:a})}}_.prototype._fnShouldApplySelection=function(t){var e=this._getSelectedDates()[0],a,i;if(!e){return false}a=e.getStartDate();i=e.getEndDate();if(a){a=g.fromLocalJSDate(a,this._getPrimaryCalendarType());a.setDate(1)}if(this.getIntervalSelection()&&a&&i){i=g.fromLocalJSDate(i,this._getPrimaryCalendarType());i.setDate(1);if(t.isSame(a)||t.isSame(i)){return true}}else if(a&&t.isSame(a)){return true}return false};_.prototype._fnShouldApplySelectionBetween=function(t){var e=this._getSelectedDates()[0],a,i;if(!e){return false}a=e.getStartDate();i=e.getEndDate();if(this.getIntervalSelection()&&a&&i){a=g.fromLocalJSDate(a,this._getPrimaryCalendarType());a.setDate(1);i=g.fromLocalJSDate(i,this._getPrimaryCalendarType());i.setDate(1);if(l._isBetween(t,a,i)){return true}}return false};return _});
//# sourceMappingURL=MonthPicker.js.map