/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/unified/calendar/CalendarUtils","sap/ui/unified/calendar/CalendarDate","sap/ui/unified/CalendarLegend","sap/ui/unified/CalendarLegendRenderer","sap/ui/core/library","sap/ui/unified/library","sap/base/Log","sap/ui/core/InvisibleText","sap/ui/core/date/UI5Date","sap/ui/core/Configuration"],function(e,a,t,i,n,r,s,l,d,o){"use strict";var c=r.CalendarDayType;var p=n.CalendarType;var y={apiVersion:2};y.render=function(e,a){var t=this.getStartDate(a),i=a.getTooltip_AsString(),n=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified"),r=a.getId(),s={value:"",append:true},d="",o=a.getWidth();e.openStart("div",a);this.getClass(e,a).forEach(function(a){e.class(a)});if(a._getSecondaryCalendarType()){e.class("sapUiCalMonthSecType")}this.addWrapperAdditionalStyles(e,a);if(i){e.attr("title",i)}if(a._getShowHeader()){s.value=s.value+" "+r+"-Head"}if(a._bCalendar){d+=" "+l.getStaticId("sap.ui.unified","CALENDAR_MONTH_PICKER_OPEN_HINT")+" "+l.getStaticId("sap.ui.unified","CALENDAR_YEAR_PICKER_OPEN_HINT")}if(o){e.style("width",o)}e.accessibilityState(a,{role:"grid",roledescription:n.getText("CALENDAR_DIALOG"),multiselectable:!a.getSingleSelection()||a.getIntervalSelection(),labelledby:s,describedby:d});e.openEnd();if(a.getIntervalSelection()){e.openStart("span",r+"-Start");e.style("display","none");e.openEnd();e.text(n.getText("CALENDAR_START_DATE"));e.close("span");e.openStart("span",r+"-End");e.style("display","none");e.openEnd();e.text(n.getText("CALENDAR_END_DATE"));e.close("span")}this.renderMonth(e,a,t);e.close("div")};y.addWrapperAdditionalStyles=function(){};y.getStartDate=function(e){return e._getDate()};y.getClass=function(e,a){var t=["sapUiCalMonthView"],i=a.getPrimaryCalendarType(),n=a.getShowWeekNumbers();if(i===p.Islamic||!n){t.push("sapUiCalNoWeekNum")}return t};y.renderMonth=function(e,a,t){this.renderHeader(e,a,t);this.renderDays(e,a,t)};y.renderHeader=function(e,a,t){var i=a._getLocaleData();var n=a._getFirstDayOfWeek();this.renderHeaderLine(e,a,i,t);e.openStart("div");e.accessibilityState(null,{role:"row"});e.style("overflow","hidden");e.openEnd();this.renderDayNames(e,a,i,n,7,true,undefined);e.close("div")};y.renderHeaderLine=function(a,t,i,n){e._checkCalendarDate(n);if(t._getShowHeader()){var r=t.getId();var s=t.getPrimaryCalendarType();var l=i.getMonthsStandAlone("wide",s);a.openStart("div",r+"-Head");a.class("sapUiCalHeadText");a.openEnd();a.text(l[n.getMonth()]);a.close("div")}};y.renderDayNames=function(e,a,t,i,n,r,s){var l=a._getFirstDayOfWeek();var d=a.getId();var o="";var c=a.getPrimaryCalendarType();var y=[];if(a._bLongWeekDays||!a._bNamesLengthChecked){y=t.getDaysStandAlone("abbreviated",c)}else{y=t.getDaysStandAlone("narrow",c)}var g=t.getDaysStandAlone("wide",c);if(a.getShowWeekNumbers()&&c!==p.Islamic){this.renderDummyCell(e,"sapUiCalWH",true,"columnheader")}for(var f=0;f<n;f++){if(r){o=d+"-WH"+(f+l)%7}else{o=d+"-WH"+f}e.openStart("div",o);e.class("sapUiCalWH");if(f===0){e.class("sapUiCalFirstWDay")}if(s){e.style("width",s)}e.accessibilityState(null,{role:"columnheader",label:g[(f+i)%7]});e.openEnd();e.text(y[(f+i)%7]);e.close("div")}};y.renderDays=function(a,t,i){var n,r,s,l,d,o,c;e._checkCalendarDate(i);if(!i){i=t._getFocusedDate()}o=i.toUTCJSDate().getTime();if(!o&&o!==0){throw new Error("Date is invalid "+t)}l=this.getDayHelper(t,i);r=t._getVisibleDays(i,true);c=t.getShowWeekNumbers();n=t.getPrimaryCalendarType()!==p.Islamic&&c;s=r.length;for(d=0;d<s;d++){if(d%7===0){a.openStart("div");a.attr("role","row");a.openEnd();if(n){this._renderWeekNumber(a,r[d],l,t)}}this.renderDay(a,t,r[d],l,true,n,-1);if(d%7===6||d===s-1){a.close("div")}}if(s===28){this.renderDummyCell(a,"sapUiCalItem",false,"")}};y.renderDummyCell=function(e,a,t,i){e.openStart("div");e.class(a);e.class("sapUiCalDummy");e.style("visibility",t?"visible":"hidden");e.attr("role",i);e.attr("aria-label",sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified").getText("CALENDAR_WEEK"));e.openEnd();e.close("div")};y.getDayHelper=function(e,i){var n,r,l=e._getLocaleData(),o={sLocale:e._getLocale(),oLocaleData:l,iMonth:i.getMonth(),iYear:i.getYear(),iFirstDayOfWeek:e._getFirstDayOfWeek(),iWeekendStart:l.getWeekendStart(),iWeekendEnd:l.getWeekendEnd(),aNonWorkingDays:e._getNonWorkingDays(),sToday:l.getRelativeDay(0),oToday:a.fromLocalJSDate(d.getInstance(),e.getPrimaryCalendarType()),sId:e.getId(),oFormatLong:e._getFormatLong(),sPrimaryCalendarType:e.getPrimaryCalendarType(),sSecondaryCalendarType:e._getSecondaryCalendarType(),oLegend:undefined};r=e.getLegend();if(r&&typeof r==="string"){n=sap.ui.getCore().byId(r);if(n){if(!(n instanceof t)){throw new Error(n+" is not an sap.ui.unified.CalendarLegend. "+e)}o.oLegend=n}else{s.warning("CalendarLegend "+r+" does not exist!",e)}}return o};y.renderDay=function(t,n,r,s,l,d,o,p,y){e._checkCalendarDate(r);var g=new a(r,s.sSecondaryCalendarType),f={role:n._getAriaRole(),selected:false,label:"",describedby:""},u=r._bBeforeFirstYear,D="",C=s.oLegend;var S=n._oFormatYyyymmdd.format(r.toUTCJSDate(),true);var b=r.getDay();var m=n._checkDateSelected(r);var h=n._getDateTypes(r);var v=s&&s.oLegend?s.oLegend._getSpecialDateTypeFilter():"";var E=n._checkDateEnabled(r);var _=0;var W=n._isSpecialDateMarkerEnabled(r);const k=n._oUnifiedRB.getText("LEGEND_NON_WORKING_DAY");const I=[];if(u){E=false}t.openStart("div",s.sId+"-"+S);t.class("sapUiCalItem");t.class("sapUiCalWDay"+b);if(p){t.style("width",p)}if(b===s.iFirstDayOfWeek){t.class("sapUiCalFirstWDay")}if(l&&s.iMonth!==r.getMonth()){t.class("sapUiCalItemOtherMonth");f["disabled"]=true}if(r.isSame(s.oToday)){t.class("sapUiCalItemNow");I.push(n._oUnifiedRB.getText("LEGEND_TODAY"))}if(m>0){t.class("sapUiCalItemSel");f["selected"]=true}else{f["selected"]=false}if(m===2){t.class("sapUiCalItemSelStart");f["describedby"]=f["describedby"]+" "+s.sId+"-Start"}else if(m===3){t.class("sapUiCalItemSelEnd");f["describedby"]=f["describedby"]+" "+s.sId+"-End"}else if(m===4){t.class("sapUiCalItemSelBetween")}else if(m===5){t.class("sapUiCalItemSelStart");t.class("sapUiCalItemSelEnd");f["describedby"]=f["describedby"]+" "+s.sId+"-Start";f["describedby"]=f["describedby"]+" "+s.sId+"-End"}if(this.renderWeekNumbers&&n._oDate){f["describedby"]=f["describedby"]+" "+n.getId()+"-week-"+n._calculateWeekNumber(r)+"-text"}if(W){h.forEach(function(e){if(e.type!==c.None){if(e.type===c.NonWorking){I.push(k);t.class("sapUiCalItemWeekEnd");return}if(v===""||v===c.None||v===e.type){t.class("sapUiCalItem"+e.type);D=e.type;if(e.tooltip){I.push(e.tooltip)}}}})}if(s.aNonWorkingDays){s.aNonWorkingDays.forEach(function(e){if(r.getDay()===e){I.push(k)}})}else if(r.getDay()===s.iWeekendStart||r.getDay()===s.iWeekendEnd){I.push(k)}if(I.length){const e=I.filter((e,a)=>I.indexOf(e)===a);t.attr("title",e.join(" "))}if((n.getParent()&&n.getParent().getMetadata().getName()==="sap.ui.unified.CalendarOneMonthInterval"||n.getMetadata().getName()==="sap.ui.unified.calendar.OneMonthDatesRow")&&n.getStartDate()&&s.iMonth!==r.getMonth()){t.class("sapUiCalItemOtherMonth")}if(!E){t.class("sapUiCalItemDsbl");f["disabled"]=true}if(s.aNonWorkingDays){for(_=0;_<s.aNonWorkingDays.length;_++){if(b===s.aNonWorkingDays[_]){t.class("sapUiCalItemWeekEnd");break}}}else if(b>=s.iWeekendStart&&b<=s.iWeekendEnd||s.iWeekendEnd<s.iWeekendStart&&(b>=s.iWeekendStart||b<=s.iWeekendEnd)){t.class("sapUiCalItemWeekEnd")}t.attr("tabindex","-1");t.attr("data-sap-day",S);if(y){f["label"]=f["label"]+s.aWeekDaysWide[b]+" "}f["label"]=f["label"]+s.oFormatLong.format(r.toUTCJSDate(),true);if(D!==""){i.addCalendarTypeAccInfo(f,D,C)}if(s.sSecondaryCalendarType){f["label"]=f["label"]+" "+n._oFormatSecondaryLong.format(g.toUTCJSDate(),true)}t.accessibilityState(null,f);t.openEnd();if(h[0]&&W){t.openStart("div");t.class("sapUiCalSpecialDate");if(h[0].color&&(v===""||v===c.None)){t.style("background-color",h[0].color)}t.openEnd();t.close("div")}t.openStart("span");t.class("sapUiCalItemText");if(h[0]&&h[0].color){t.class("sapUiCalItemTextCustomColor")}t.openEnd();if(!u){t.text(r.getDate())}t.close("span");if(y){t.openStart("span");t.class("sapUiCalDayName");t.openEnd();t.text(s.aWeekDays[b]);t.close("span")}if(s.sSecondaryCalendarType){t.openStart("span");t.class("sapUiCalItemSecText");t.openEnd();t.text(g.getDate());t.close("span")}t.close("div")};y._renderWeekNumber=function(e,a,t,i){var n=i._calculateWeekNumber(a);var r=t.sId+"-WNum-"+n;e.openStart("div",r);e.class("sapUiCalWeekNum");e.accessibilityState(null,{role:"rowheader",labelledby:l.getStaticId("sap.ui.unified","CALENDAR_WEEK")+" "+r});e.openEnd();e.text(n);e.close("div")};return y},true);
//# sourceMappingURL=MonthRenderer.js.map