sap.ui.define(["exports", "sap/ui/webc/common/thirdparty/base/renderer/LitRenderer"], function (_exports, _LitRenderer) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;
  /* eslint no-unused-vars: 0 */

  function block0(context, tags, suffix) {
    return suffix ? (0, _LitRenderer.html)`<${(0, _LitRenderer.scopeTag)("ui5-dialog", tags, suffix)} aria-label="${(0, _LitRenderer.ifDefined)(this._dialogTitle)}" @ui5-after-open=${(0, _LitRenderer.ifDefined)(this._focusRecentlyUsedControl)} @ui5-before-close=${(0, _LitRenderer.ifDefined)(this._restoreConfirmedOnEscape)} ?stretch=${this._isPhone}><div slot="header" class="ui5-vsd-header"><div class="ui5-vsd-header-container"><div class="ui5-vsd-header-start">${this.showBackButton ? block1.call(this, context, tags, suffix) : undefined}<${(0, _LitRenderer.scopeTag)("ui5-title", tags, suffix)} class="ui5-vsd-title" id="${(0, _LitRenderer.ifDefined)(this._id)}-label">${(0, _LitRenderer.ifDefined)(this._title)}</${(0, _LitRenderer.scopeTag)("ui5-title", tags, suffix)}></div><div class="ui5-vsd-header-end"><${(0, _LitRenderer.scopeTag)("ui5-button", tags, suffix)} design="Transparent" @click="${this._resetSettings}" ?disabled=${this._disableResetButton}>${(0, _LitRenderer.ifDefined)(this._resetButtonLabel)}</${(0, _LitRenderer.scopeTag)("ui5-button", tags, suffix)}></div></div>${!this.showBackButton ? block2.call(this, context, tags, suffix) : undefined}</div><div class="ui5-vsd-content" ?expand-content="${this.expandContent}">${this.shouldBuildSort ? block4.call(this, context, tags, suffix) : undefined}${this.shouldBuildFilter ? block8.call(this, context, tags, suffix) : undefined}</div><div slot="footer" class="ui5-vsd-footer"><${(0, _LitRenderer.scopeTag)("ui5-button", tags, suffix)} design="Emphasized" @click="${this._confirmSettings}">${(0, _LitRenderer.ifDefined)(this._okButtonLabel)}</${(0, _LitRenderer.scopeTag)("ui5-button", tags, suffix)}><${(0, _LitRenderer.scopeTag)("ui5-button", tags, suffix)} design="Transparent" @click="${this._cancelSettings}">${(0, _LitRenderer.ifDefined)(this._cancelButtonLabel)}</${(0, _LitRenderer.scopeTag)("ui5-button", tags, suffix)}></div></${(0, _LitRenderer.scopeTag)("ui5-dialog", tags, suffix)}>` : (0, _LitRenderer.html)`<ui5-dialog aria-label="${(0, _LitRenderer.ifDefined)(this._dialogTitle)}" @ui5-after-open=${(0, _LitRenderer.ifDefined)(this._focusRecentlyUsedControl)} @ui5-before-close=${(0, _LitRenderer.ifDefined)(this._restoreConfirmedOnEscape)} ?stretch=${this._isPhone}><div slot="header" class="ui5-vsd-header"><div class="ui5-vsd-header-container"><div class="ui5-vsd-header-start">${this.showBackButton ? block1.call(this, context, tags, suffix) : undefined}<ui5-title class="ui5-vsd-title" id="${(0, _LitRenderer.ifDefined)(this._id)}-label">${(0, _LitRenderer.ifDefined)(this._title)}</ui5-title></div><div class="ui5-vsd-header-end"><ui5-button design="Transparent" @click="${this._resetSettings}" ?disabled=${this._disableResetButton}>${(0, _LitRenderer.ifDefined)(this._resetButtonLabel)}</ui5-button></div></div>${!this.showBackButton ? block2.call(this, context, tags, suffix) : undefined}</div><div class="ui5-vsd-content" ?expand-content="${this.expandContent}">${this.shouldBuildSort ? block4.call(this, context, tags, suffix) : undefined}${this.shouldBuildFilter ? block8.call(this, context, tags, suffix) : undefined}</div><div slot="footer" class="ui5-vsd-footer"><ui5-button design="Emphasized" @click="${this._confirmSettings}">${(0, _LitRenderer.ifDefined)(this._okButtonLabel)}</ui5-button><ui5-button design="Transparent" @click="${this._cancelSettings}">${(0, _LitRenderer.ifDefined)(this._cancelButtonLabel)}</ui5-button></div></ui5-dialog>`;
  }
  function block1(context, tags, suffix) {
    return suffix ? (0, _LitRenderer.html)`<${(0, _LitRenderer.scopeTag)("ui5-button", tags, suffix)} design="Transparent" icon="nav-back" class="ui5-vsd-back-button" @click="${this._navigateToFilters}"></${(0, _LitRenderer.scopeTag)("ui5-button", tags, suffix)}>` : (0, _LitRenderer.html)`<ui5-button design="Transparent" icon="nav-back" class="ui5-vsd-back-button" @click="${this._navigateToFilters}"></ui5-button>`;
  }
  function block2(context, tags, suffix) {
    return (0, _LitRenderer.html)`${this.hasPagination ? block3.call(this, context, tags, suffix) : undefined}`;
  }
  function block3(context, tags, suffix) {
    return suffix ? (0, _LitRenderer.html)`<div class="ui5-vsd-sub-header-container"><div class="ui5-vsd-sub-header"><${(0, _LitRenderer.scopeTag)("ui5-segmented-button", tags, suffix)} @ui5-selection-change="${(0, _LitRenderer.ifDefined)(this._handleModeChange)}"><${(0, _LitRenderer.scopeTag)("ui5-segmented-button-item", tags, suffix)} ?pressed="${this.isModeSort}" icon="sort" mode="Sort"></${(0, _LitRenderer.scopeTag)("ui5-segmented-button-item", tags, suffix)}><${(0, _LitRenderer.scopeTag)("ui5-segmented-button-item", tags, suffix)} ?pressed="${this.isModeFilter}" icon="filter" mode="Filter"></${(0, _LitRenderer.scopeTag)("ui5-segmented-button-item", tags, suffix)}></${(0, _LitRenderer.scopeTag)("ui5-segmented-button", tags, suffix)}></div></div>` : (0, _LitRenderer.html)`<div class="ui5-vsd-sub-header-container"><div class="ui5-vsd-sub-header"><ui5-segmented-button @ui5-selection-change="${(0, _LitRenderer.ifDefined)(this._handleModeChange)}"><ui5-segmented-button-item ?pressed="${this.isModeSort}" icon="sort" mode="Sort"></ui5-segmented-button-item><ui5-segmented-button-item ?pressed="${this.isModeFilter}" icon="filter" mode="Filter"></ui5-segmented-button-item></ui5-segmented-button></div></div>`;
  }
  function block4(context, tags, suffix) {
    return (0, _LitRenderer.html)`${this.isModeSort ? block5.call(this, context, tags, suffix) : undefined}`;
  }
  function block5(context, tags, suffix) {
    return suffix ? (0, _LitRenderer.html)`<div class="ui5-vsd-sort"><${(0, _LitRenderer.scopeTag)("ui5-list", tags, suffix)} mode="SingleSelectBegin" @ui5-item-click="${(0, _LitRenderer.ifDefined)(this._onSortOrderChange)}" sort-order accessible-name-ref="${(0, _LitRenderer.ifDefined)(this._id)}-label"><${(0, _LitRenderer.scopeTag)("ui5-li-groupheader", tags, suffix)}>${(0, _LitRenderer.ifDefined)(this._sortOrderLabel)}</${(0, _LitRenderer.scopeTag)("ui5-li-groupheader", tags, suffix)}>${(0, _LitRenderer.repeat)(this._currentSettings.sortOrder, (item, index) => item._id || index, (item, index) => block6.call(this, context, tags, suffix, item, index))}</${(0, _LitRenderer.scopeTag)("ui5-list", tags, suffix)}><${(0, _LitRenderer.scopeTag)("ui5-list", tags, suffix)} mode="SingleSelectBegin" @ui5-item-click=${(0, _LitRenderer.ifDefined)(this._onSortByChange)} sort-by><${(0, _LitRenderer.scopeTag)("ui5-li-groupheader", tags, suffix)}>${(0, _LitRenderer.ifDefined)(this._sortByLabel)}</${(0, _LitRenderer.scopeTag)("ui5-li-groupheader", tags, suffix)}>${(0, _LitRenderer.repeat)(this._currentSettings.sortBy, (item, index) => item._id || index, (item, index) => block7.call(this, context, tags, suffix, item, index))}</${(0, _LitRenderer.scopeTag)("ui5-list", tags, suffix)}></div>` : (0, _LitRenderer.html)`<div class="ui5-vsd-sort"><ui5-list mode="SingleSelectBegin" @ui5-item-click="${(0, _LitRenderer.ifDefined)(this._onSortOrderChange)}" sort-order accessible-name-ref="${(0, _LitRenderer.ifDefined)(this._id)}-label"><ui5-li-groupheader>${(0, _LitRenderer.ifDefined)(this._sortOrderLabel)}</ui5-li-groupheader>${(0, _LitRenderer.repeat)(this._currentSettings.sortOrder, (item, index) => item._id || index, (item, index) => block6.call(this, context, tags, suffix, item, index))}</ui5-list><ui5-list mode="SingleSelectBegin" @ui5-item-click=${(0, _LitRenderer.ifDefined)(this._onSortByChange)} sort-by><ui5-li-groupheader>${(0, _LitRenderer.ifDefined)(this._sortByLabel)}</ui5-li-groupheader>${(0, _LitRenderer.repeat)(this._currentSettings.sortBy, (item, index) => item._id || index, (item, index) => block7.call(this, context, tags, suffix, item, index))}</ui5-list></div>`;
  }
  function block6(context, tags, suffix, item, index) {
    return suffix ? (0, _LitRenderer.html)`<${(0, _LitRenderer.scopeTag)("ui5-li", tags, suffix)} ?selected="${item.selected}">${(0, _LitRenderer.ifDefined)(item.text)}</${(0, _LitRenderer.scopeTag)("ui5-li", tags, suffix)}>` : (0, _LitRenderer.html)`<ui5-li ?selected="${item.selected}">${(0, _LitRenderer.ifDefined)(item.text)}</ui5-li>`;
  }
  function block7(context, tags, suffix, item, index) {
    return suffix ? (0, _LitRenderer.html)`<${(0, _LitRenderer.scopeTag)("ui5-li", tags, suffix)} data-ui5-external-action-item-index="${index}" ?selected="${item.selected}">${(0, _LitRenderer.ifDefined)(item.text)}</${(0, _LitRenderer.scopeTag)("ui5-li", tags, suffix)}>` : (0, _LitRenderer.html)`<ui5-li data-ui5-external-action-item-index="${index}" ?selected="${item.selected}">${(0, _LitRenderer.ifDefined)(item.text)}</ui5-li>`;
  }
  function block8(context, tags, suffix) {
    return (0, _LitRenderer.html)`${this.isModeFilter ? block9.call(this, context, tags, suffix) : undefined}`;
  }
  function block9(context, tags, suffix) {
    return (0, _LitRenderer.html)`${this._filterStepTwo ? block10.call(this, context, tags, suffix) : block14.call(this, context, tags, suffix)}`;
  }
  function block10(context, tags, suffix) {
    return suffix ? (0, _LitRenderer.html)`<${(0, _LitRenderer.scopeTag)("ui5-list", tags, suffix)} accessible-name-ref="${(0, _LitRenderer.ifDefined)(this._id)}-label" mode="MultiSelect" @ui5-item-click="${(0, _LitRenderer.ifDefined)(this._handleFilterValueItemClick)}">${(0, _LitRenderer.repeat)(this._currentSettings.filters, (item, index) => item._id || index, (item, index) => block11.call(this, context, tags, suffix, item, index))}</${(0, _LitRenderer.scopeTag)("ui5-list", tags, suffix)}>` : (0, _LitRenderer.html)`<ui5-list accessible-name-ref="${(0, _LitRenderer.ifDefined)(this._id)}-label" mode="MultiSelect" @ui5-item-click="${(0, _LitRenderer.ifDefined)(this._handleFilterValueItemClick)}">${(0, _LitRenderer.repeat)(this._currentSettings.filters, (item, index) => item._id || index, (item, index) => block11.call(this, context, tags, suffix, item, index))}</ui5-list>`;
  }
  function block11(context, tags, suffix, item, index) {
    return (0, _LitRenderer.html)`${item.selected ? block12.call(this, context, tags, suffix, item, index) : undefined}`;
  }
  function block12(context, tags, suffix, item, index) {
    return (0, _LitRenderer.html)`${(0, _LitRenderer.repeat)(item.filterOptions, (item, index) => item._id || index, (item, index) => block13.call(this, context, tags, suffix, item, index))}`;
  }
  function block13(context, tags, suffix, item, index) {
    return suffix ? (0, _LitRenderer.html)`<${(0, _LitRenderer.scopeTag)("ui5-li", tags, suffix)} ?selected=${item.selected}>${(0, _LitRenderer.ifDefined)(item.text)}</${(0, _LitRenderer.scopeTag)("ui5-li", tags, suffix)}>` : (0, _LitRenderer.html)`<ui5-li ?selected=${item.selected}>${(0, _LitRenderer.ifDefined)(item.text)}</ui5-li>`;
  }
  function block14(context, tags, suffix) {
    return suffix ? (0, _LitRenderer.html)`<${(0, _LitRenderer.scopeTag)("ui5-list", tags, suffix)} @ui5-item-click="${(0, _LitRenderer.ifDefined)(this._changeCurrentFilter)}" accessible-name-ref="${(0, _LitRenderer.ifDefined)(this._id)}-label"><${(0, _LitRenderer.scopeTag)("ui5-li-groupheader", tags, suffix)}>${(0, _LitRenderer.ifDefined)(this._filterByLabel)}</${(0, _LitRenderer.scopeTag)("ui5-li-groupheader", tags, suffix)}>${(0, _LitRenderer.repeat)(this.filterItems, (item, index) => item._id || index, (item, index) => block15.call(this, context, tags, suffix, item, index))}</${(0, _LitRenderer.scopeTag)("ui5-list", tags, suffix)}>` : (0, _LitRenderer.html)`<ui5-list @ui5-item-click="${(0, _LitRenderer.ifDefined)(this._changeCurrentFilter)}" accessible-name-ref="${(0, _LitRenderer.ifDefined)(this._id)}-label"><ui5-li-groupheader>${(0, _LitRenderer.ifDefined)(this._filterByLabel)}</ui5-li-groupheader>${(0, _LitRenderer.repeat)(this.filterItems, (item, index) => item._id || index, (item, index) => block15.call(this, context, tags, suffix, item, index))}</ui5-list>`;
  }
  function block15(context, tags, suffix, item, index) {
    return suffix ? (0, _LitRenderer.html)`<${(0, _LitRenderer.scopeTag)("ui5-li", tags, suffix)} class="ui5-vsd-filterItemList" ?selected=${item.selected} additional-text=${(0, _LitRenderer.ifDefined)(item.additionalText)}>${(0, _LitRenderer.ifDefined)(item.text)}</${(0, _LitRenderer.scopeTag)("ui5-li", tags, suffix)}>` : (0, _LitRenderer.html)`<ui5-li class="ui5-vsd-filterItemList" ?selected=${item.selected} additional-text=${(0, _LitRenderer.ifDefined)(item.additionalText)}>${(0, _LitRenderer.ifDefined)(item.text)}</ui5-li>`;
  }
  var _default = block0;
  _exports.default = _default;
});