sap.ui.define(["exports","sap/ui/webc/common/thirdparty/base/UI5Element","sap/ui/webc/common/thirdparty/base/decorators/customElement","sap/ui/webc/common/thirdparty/base/decorators/property","sap/ui/webc/common/thirdparty/base/decorators/event","sap/ui/webc/common/thirdparty/base/types/Integer","sap/ui/webc/common/thirdparty/base/renderer/LitRenderer","sap/ui/webc/common/thirdparty/base/Device","sap/ui/webc/common/thirdparty/base/i18nBundle","sap/ui/webc/common/thirdparty/base/locale/getLocale","sap/ui/webc/common/thirdparty/localization/DateFormat","sap/ui/webc/common/thirdparty/localization/getCachedLocaleDataInstance","sap/ui/webc/common/thirdparty/localization/features/calendar/Gregorian","sap/ui/webc/common/thirdparty/base/types/CalendarType","sap/ui/webc/common/thirdparty/base/asset-registries/LocaleData","sap/ui/webc/common/thirdparty/base/Keys","sap/ui/webc/common/thirdparty/icons/time-entry-request","./generated/templates/TimeSelectionTemplate.lit","./WheelSlider","./timepicker-utils/TimeSlider","./generated/i18n/i18n-defaults","./generated/themes/TimeSelection.css"],function(e,t,r,i,s,a,o,n,u,d,l,h,c,g,p,f,m,_,y,S,v,b){"use strict";Object.defineProperty(e,"__esModule",{value:true});e.default=void 0;t=H(t);r=H(r);i=H(i);s=H(s);a=H(a);o=H(o);d=H(d);l=H(l);h=H(h);g=H(g);_=H(_);y=H(y);b=H(b);function H(e){return e&&e.__esModule?e:{default:e}}var C=void 0&&(void 0).__decorate||function(e,t,r,i){var s=arguments.length,a=s<3?t:i===null?i=Object.getOwnPropertyDescriptor(t,r):i,o;if(typeof Reflect==="object"&&typeof Reflect.decorate==="function")a=Reflect.decorate(e,t,r,i);else for(var n=e.length-1;n>=0;n--)if(o=e[n])a=(s<3?o(a):s>3?o(t,r,a):o(t,r))||a;return s>3&&a&&Object.defineProperty(t,r,a),a};var w;let T=w=class e extends t.default{static async onDefine(){[w.i18nBundle]=await Promise.all([(0,u.getI18nBundle)("@ui5/webcomponents"),(0,p.fetchCldr)((0,d.default)().getLanguage(),(0,d.default)().getRegion(),(0,d.default)().getScript())])}constructor(){super()}get _hoursConfiguration(){const e=this.getFormat().aFormatArray;const t=e.find(e=>e.type.startsWith("hour"));return(0,S.getHoursConfigByFormat)(t?t.type:"hour0_23")}get _neededSliders(){const e=this.getFormat().aFormatArray;return(0,S.getTimeControlsByFormat)(e,this._hoursConfiguration)}get _hasHoursSlider(){return this._neededSliders[0]&&!this.hideHours}get _hasMinutesSlider(){return this._neededSliders[1]&&!this.hideMinutes}get _hasSecondsSlider(){return this._neededSliders[2]&&!this.hideSeconds}get _hasPeriodsSlider(){return this._neededSliders[3]}get secondsArray(){return(0,S.getSeconds)(this.maxSeconds?this.maxSeconds+1:undefined,this.secondsStep)}get minutesArray(){return(0,S.getMinutes)(this.maxMinutes?this.maxMinutes+1:undefined,this.minutesStep)}get hoursArray(){return(0,S.getHours)(this._hoursConfiguration,this.maxHours?this.maxHours+1:undefined)}get periodsArray(){const e=this.getFormat().aDayPeriodsAbbrev;return e.map(e=>e.toUpperCase())}get _hoursSliderFocused(){return this._currentSlider==="hours"}get _minutesSliderFocused(){return this._currentSlider==="minutes"}get _secondsSliderFocused(){return this._currentSlider==="seconds"}get _periodSliderFocused(){return this._currentSlider==="periods"}get _hours(){let e;const t=this.validDateValue;if(this._hoursConfiguration.isTwelveHoursFormat&&t.getHours()>this._hoursConfiguration.maxHour){e=t.getHours()-12}else if(this._hoursConfiguration.isTwelveHoursFormat&&t.getHours()<this._hoursConfiguration.minHour){e=t.getHours()+12}else{e=t.getHours()}if(e.toString().length===1){e=`0${e}`}return e.toString()}get _minutes(){const e=this.validDateValue.getMinutes().toString();return e.length===1?`0${e}`:e}get _seconds(){const e=this.validDateValue.getSeconds().toString();return e.length===1?`0${e}`:e}get _period(){if(!this._hoursConfiguration.isTwelveHoursFormat){return undefined}let e;const t=this.validDateValue;if(this._hoursConfiguration.minHour===1){e=t.getHours()>=this._hoursConfiguration.maxHour?this.periodsArray[1]:this.periodsArray[0]}else{e=t.getHours()>this._hoursConfiguration.maxHour||t.getHours()===this._hoursConfiguration.minHour?this.periodsArray[1]:this.periodsArray[0]}return e}setValue(e){const t=this.formatValue(e);if(this.isValid(t)){this.value=this.normalizeValue(t);this.fireEvent("change",{value:this.value,valid:true})}}onHoursChange(e){let t=parseInt(e.detail.value);const r=this._hoursConfiguration.isTwelveHoursFormat;if(r){if(this._period===this.periodsArray[0]){t=t===12?0:t}if(this._period===this.periodsArray[1]){t=t===12?t:t+12}}const i=this.validDateValue;i.setHours(t);this.setValue(i)}onMinutesChange(e){const t=parseInt(e.detail.value);const r=this.validDateValue;r.setMinutes(t);this.setValue(r)}onSecondsChange(e){const t=parseInt(e.detail.value);const r=this.validDateValue;r.setSeconds(t);this.setValue(r)}onPeriodChange(e){const t=e.detail.value;const r=this.validDateValue;if(t===this.periodsArray[0]&&r.getHours()>=12){r.setHours(r.getHours()-12)}if(t===this.periodsArray[1]&&r.getHours()<12){r.setHours(r.getHours()+12)}this.setValue(r)}isValid(e){return e===""||this.getFormat().parse(e)}normalizeValue(e){if(e===""){return e}return this.getFormat().format(this.getFormat().parse(e))}get _formatPattern(){const e=this.formatPattern;const t=!!e.match(/H/i);const r=!e||!t;const i=(0,h.default)((0,d.default)());return r?i.getCombinedDateTimePattern("medium","medium",undefined):e}get _isPattern(){return this._formatPattern!=="medium"&&this._formatPattern!=="short"&&this._formatPattern!=="long"}selectSlider(e){const t=e.target;this._setCurrentSlider(t.closest("[ui5-wheelslider]").getAttribute("data-sap-slider"))}_setCurrentSlider(e){if(this._currentSlider===e){return}this._currentSlider=e;this.fireEvent("slider-change",{slider:e})}get _currentSliderDOM(){return this.shadowRoot.querySelector(`[data-sap-slider="${this._currentSlider}"]`)}get _activeSliders(){return[this._hasHoursSlider?"hours":"",this._hasMinutesSlider?"minutes":"",this._hasSecondsSlider?"seconds":"",this._hasPeriodsSlider?"periods":""].filter(e=>!!e)}_onfocusin(e){if(!this._currentSlider){this._setCurrentSlider(this._activeSliders[0])}if(e.target===e.currentTarget){this._currentSliderDOM.focus()}}_onfocusout(e){if(!this.shadowRoot.contains(e.relatedTarget)){this._setCurrentSlider("")}}_onkeydown(e){if(!((0,f.isLeft)(e)||(0,f.isRight)(e))){return}e.preventDefault();const t=this._activeSliders;const r=e.target;const i=r.closest("[ui5-wheelslider]").getAttribute("data-sap-slider");let s=t.indexOf(i);if((0,f.isLeft)(e)){s=s===0?t.length-1:s-1}else if((0,f.isRight)(e)){s=s===t.length-1?0:s+1}this._setCurrentSlider(t[s]);this._currentSliderDOM.focus()}_handleWheel(e){e.preventDefault()}getFormat(){let e;if(this._isPattern){e=l.default.getDateInstance({calendarType:this._calendarType,pattern:this._formatPattern})}else{e=l.default.getDateInstance({calendarType:this._calendarType,style:this._formatPattern})}return e}formatValue(e){return this.getFormat().format(e)}get dateValue(){return this.value?this.getFormat().parse(this.value):new Date}get validDateValue(){return this.value!==undefined&&this.isValid(this.value)?this.dateValue:new Date}get hoursSliderTitle(){return w.i18nBundle.getText(v.TIMEPICKER_HOURS_LABEL)}get minutesSliderTitle(){return w.i18nBundle.getText(v.TIMEPICKER_MINUTES_LABEL)}get secondsSliderTitle(){return w.i18nBundle.getText(v.TIMEPICKER_SECONDS_LABEL)}get periodSliderTitle(){return"AM/PM"}get classes(){return{root:{"ui5-time-selection-root":true,"ui5-phone":(0,n.isPhone)()}}}};C([(0,i.default)({defaultValue:undefined})],T.prototype,"value",void 0);C([(0,i.default)()],T.prototype,"formatPattern",void 0);C([(0,i.default)({type:Boolean})],T.prototype,"hideHours",void 0);C([(0,i.default)({type:Boolean})],T.prototype,"hideMinutes",void 0);C([(0,i.default)({type:Boolean})],T.prototype,"hideSeconds",void 0);C([(0,i.default)({validator:a.default})],T.prototype,"maxHours",void 0);C([(0,i.default)({validator:a.default})],T.prototype,"maxMinutes",void 0);C([(0,i.default)({validator:a.default})],T.prototype,"maxSeconds",void 0);C([(0,i.default)({validator:a.default,defaultValue:1})],T.prototype,"secondsStep",void 0);C([(0,i.default)({validator:a.default,defaultValue:1})],T.prototype,"minutesStep",void 0);C([(0,i.default)({defaultValue:"hours"})],T.prototype,"_currentSlider",void 0);C([(0,i.default)({type:g.default})],T.prototype,"_calendarType",void 0);T=w=C([(0,r.default)({tag:"ui5-time-selection",languageAware:true,renderer:o.default,styles:b.default,template:_.default,dependencies:[y.default]}),(0,s.default)("change",{detail:{value:{type:String},valid:{type:Boolean}}}),(0,s.default)("sliderChange",{detail:{slider:{type:String}}})],T);T.define();var D=T;e.default=D});
//# sourceMappingURL=TimeSelection.js.map