/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","sap/ui/core/Control","sap/ui/core/CustomData","sap/ui/core/mvc/View","sap/ui/base/ManagedObjectObserver","./BlockBaseMetadata","./BlockBaseRenderer","sap/ui/model/Context","sap/ui/layout/form/ColumnLayout","./library","sap/ui/core/Component","sap/ui/layout/library","sap/base/Log","sap/uxap/ModelMapping"],function(jQuery,e,t,o,i,n,a,s,r,p,u,l,d,g){"use strict";var c=l.form.SimpleFormLayout;var h=p.BlockBaseFormAdjustment;var f=e.extend("sap.uxap.BlockBase",{metadata:{designtime:"sap/uxap/designtime/BlockBase.designtime",library:"sap.uxap",properties:{mode:{type:"string",group:"Appearance"},visible:{type:"boolean",group:"Appearance",defaultValue:true},columnLayout:{type:"sap.uxap.BlockBaseColumnLayout",group:"Behavior",defaultValue:"auto"},formAdjustment:{type:"sap.uxap.BlockBaseFormAdjustment",group:"Behavior",defaultValue:h.BlockColumns},showSubSectionMore:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"mappings",aggregations:{mappings:{type:"sap.uxap.ModelMapping",multiple:true,singularName:"mapping"},_views:{type:"sap.ui.core.Control",multiple:true,singularName:"view",visibility:"hidden"}},associations:{selectedView:{type:"sap.ui.core.Control",multiple:false}},events:{viewInit:{parameters:{view:{type:"sap.ui.core.mvc.View"}}}},views:{}},renderer:a},n);f.prototype.init=function(){if(!this.getMetadata().hasViews()){this.getMetadata().setView("defaultXML",{viewName:this.getMetadata().getName(),type:"XML"})}this._oMappingApplied={};this._bLazyLoading=false;this._bConnected=false;this._oUpdatedModels={};this._oParentObjectPageSubSection=null;this._oPromisedViews={};this._oViewDestroyObserver=new i(this._onViewDestroy.bind(this))};f.prototype.onBeforeRendering=function(){var e;this._applyMapping();if(!this.getMode()||this.getMode()===""){if(this.getMetadata().getView("defaultXML")){this.setMode("defaultXML")}else{d.error("BlockBase ::: there is no mode defined for rendering "+this.getMetadata().getName()+". You can either set a default mode on the block metadata or set the mode property before rendering the block.")}}this._applyFormAdjustment();e=this._getObjectPageLayout();this._bLazyLoading=e&&(e.getEnableLazyLoading()||e.getUseIconTabBar())};f.prototype.onAfterRendering=function(){var e=this._getObjectPageLayout();if(e){e._requestAdjustLayout()}};f.prototype.setParent=function(t,o,i){e.prototype.setParent.call(this,t,o,i);if(t&&t.isA("sap.uxap.ObjectPageSubSection")){this._bLazyLoading=true;this._oParentObjectPageSubSection=t}};f.prototype.setModel=function(t,o){this._applyMapping(o);return e.prototype.setModel.call(this,t,o)};f.prototype._applyMapping=function(){if(this._shouldLazyLoad()){d.debug("BlockBase ::: Ignoring the _applyMapping as the block is not connected")}else{this.getMappings().forEach(function(t,o){var i,n,a=t.getInternalModelName(),r=t.getExternalPath(),p=t.getExternalModelName(),u;if(r){if(a==""||r==""){throw new Error("BlockBase :: incorrect mapping, one of the modelMapping property is empty")}i=this.getModel(p);if(!i){return}u=i.resolve(r,this.getBindingContext(p));n=this.getBindingContext(a);if(!this._isMappingApplied(a)||this.getModel(a)!==this.getModel(p)||n&&n.getPath()!==u){d.info("BlockBase :: mapping external model "+p+" to "+a);this._oMappingApplied[a]=true;e.prototype.setModel.call(this,i,a);this.setBindingContext(new s(i,u),a)}}},this)}};f.prototype._isMappingApplied=function(e){return this.getModel(e)&&this._oMappingApplied[e]};f.prototype.propagateProperties=function(t){if(this._shouldLazyLoad()&&!this._oUpdatedModels.hasOwnProperty(t)){this._oUpdatedModels[t]=true}else{this._applyMapping(t)}return e.prototype.propagateProperties.call(this,t)};f.prototype.getSupportedModes=function(){var e=jQuery.extend({},this.getMetadata().getViews());for(var t in e){e[t]=t}return e};f.prototype.setMode=function(e){e=this._validateMode(e);if(this.getMode()!==e){this.setProperty("mode",e,false);if(!this._shouldLazyLoad()){this._selectView(e)}}return this};f.prototype.setColumnLayout=function(e){if(this._oParentObjectPageSubSection){this._oParentObjectPageSubSection.invalidate()}return this.setProperty("columnLayout",e)};f.prototype.clone=function(){var t=-1,o=this.getAssociation("selectedView"),i=this.getAggregation("_views")||[];if(o){i.forEach(function(e,i){if(e.getId()===o){t=i}return t<0})}var n=e.prototype.clone.call(this);if(t>=0){n.setAssociation("selectedView",n.getAggregation("_views")[t])}return n};f.prototype._validateMode=function(e){this.validateProperty("mode",e);if(!this.getMetadata().getView(e)){var t=this.getMetadata()._sClassName||this.getId();if(this.getMetadata().getView("defaultXML")){d.warning("BlockBase :: no view defined for block "+t+" for mode "+e+", loading defaultXML instead");e="defaultXML"}else{throw new Error("BlockBase :: no view defined for block "+t+" for mode "+e)}}return e};f.prototype._getSelectedViewContent=function(){var e=null,t,o;t=this.getAssociation("selectedView");o=this.getAggregation("_views");if(o){for(var i=0;!e&&i<o.length;i++){if(o[i].getId()===t){e=o[i]}}}return e};f.prototype.createView=function(e,t){if(!this._oPromisedViews[e.id]){this._oPromisedViews[e.id]=new Promise(function(i,n){var a=u.getOwnerComponentFor(this),s=function(){var t=function(){return o.create(e)};if(a){return a.runAsOwner(t)}else{return t()}};s().then(function(e){this._afterViewInstantiated(e,t);i(e)}.bind(this))}.bind(this))}return this._oPromisedViews[e.id]};f.prototype._afterViewInstantiated=function(e,o){if(this._bIsBeingDestroyed){return}var i=e.getController();if(e){if(i){i.oParentBlock=this}e.addCustomData(new t({key:"layoutMode",value:o}));this.addAggregation("_views",e);this._oViewDestroyObserver.observe(e,{destroy:true});this.fireEvent("viewInit",{view:e})}else{throw new Error("BlockBase :: no view defined in metadata.views for mode "+o)}};f.prototype._notifyForLoadingInMode=function(e,t,o){if(e&&typeof e.onParentBlockModeChange==="function"){e.onParentBlockModeChange(o)}else{d.info("BlockBase ::: could not notify "+t.sViewName+" of loading in mode "+o+": missing controller onParentBlockModeChange method")}};f.prototype._selectView=function(e){var t,o=this.getId()+"-"+e,i,n;n=function(t){if(t&&this.getAssociation("selectedView")!==o){this.setAssociation("selectedView",t);this._notifyForLoadingInMode(t.getController(),t,e)}}.bind(this);t=this._findView(e);if(t){n(t);return}i=this.getMetadata().getView(e);i.id=o;this.createView(i,e).then(function(e){n(e)})};f.prototype._findView=function(e){var t=this.getAggregation("_views")||[],o,i;i=t.filter(function(t){return t.data("layoutMode")===e});if(i.length){return i[0]}o=this.getMetadata().getView(e);i=t.filter(function(e){return o.viewName===e.getViewName()});if(i.length){return i[0]}};f.FORM_ADUSTMENT_OFFSET=16;f._FORM_ADJUSTMENT_CONST={labelSpan:{L:12},emptySpan:{L:0},columns:{XL:1,L:1,M:1}};f._PARENT_GRID_SIZE=12;f.prototype._computeFormAdjustmentFields=function(e,t){if(e&&t){return e===h.BlockColumns?jQuery.extend({},f._FORM_ADJUSTMENT_CONST,{columns:t}):f._FORM_ADJUSTMENT_CONST}};f.prototype._applyFormAdjustment=function(){var e=this.getFormAdjustment(),t=this._getSelectedViewContent(),o=this._oParentObjectPageSubSection,i;if(e!==h.None&&t&&o){i=this._computeFormAdjustmentFields(e,o._oLayoutConfig);t.getContent().forEach(function(e){this._adjustForm(e,i)}.bind(this))}};f.prototype._adjustForm=function(e,t){var o,i;if(e.getMetadata().getName()==="sap.ui.layout.form.SimpleForm"){e.setLayout(c.ColumnLayout);i=e.getAggregation("form").getLayout();i._iBreakPointTablet-=f.FORM_ADUSTMENT_OFFSET;i._iBreakPointDesktop-=f.FORM_ADUSTMENT_OFFSET;i._iBreakPointLargeDesktop-=f.FORM_ADUSTMENT_OFFSET;e.setLabelSpanL(t.labelSpan.L);e.setEmptySpanL(t.emptySpan.L);this._applyFormAdjustmentFields(t,e);e.setWidth("100%")}else if(e.getMetadata().getName()==="sap.ui.layout.form.Form"){i=e.getLayout();if(i&&i.getMetadata().getName()==="sap.ui.layout.form.ColumnLayout"){o=i}else{o=new r;e.setLayout(o)}o._iBreakPointTablet-=f.FORM_ADUSTMENT_OFFSET;o._iBreakPointDesktop-=f.FORM_ADUSTMENT_OFFSET;o._iBreakPointLargeDesktop-=f.FORM_ADUSTMENT_OFFSET;o.setLabelCellsLarge(t.labelSpan.L);o.setEmptyCellsLarge(t.emptySpan.L);this._applyFormAdjustmentFields(t,o);e.setWidth("100%")}};f.prototype._applyFormAdjustmentFields=function(e,t){t.setColumnsXL(e.columns.XL);t.setColumnsL(e.columns.L);t.setColumnsM(e.columns.M)};f.prototype._getObjectPageLayout=function(){return p.Utilities.getClosestOPL(this)};f.prototype.setVisible=function(e,t){var o=this._getObjectPageLayout();if(e===this.getVisible()){return this}this.setProperty("visible",e,t);o&&o._requestAdjustLayoutAndUxRules();return this};f.prototype.setShowSubSectionMore=function(e,t){if(e!=this.getShowSubSectionMore()){this.setProperty("showSubSectionMore",e,true);if(this._oParentObjectPageSubSection){this._oParentObjectPageSubSection.refreshSeeMoreVisibility()}}return this};f.prototype.connectToModels=function(){if(!this._bConnected){d.debug("BlockBase :: Connecting block to the UI5 model tree");this._bConnected=true;if(this._bLazyLoading){var e=this.getMode();e&&this._selectView(e);this.updateBindings(true,null)}this.invalidate()}};f.prototype._allowPropagationToLoadedViews=function(e){if(!this._bConnected){return}this.mSkipPropagation._views=!e};f.prototype.updateBindingContext=function(t,o,i,n){if(!this._shouldLazyLoad()){return e.prototype.updateBindingContext.call(this,t,o,i,n)}else{d.debug("BlockBase ::: Ignoring the updateBindingContext as the block is not visible for now in the ObjectPageLayout")}};f.prototype.updateBindings=function(t,o){if(!this._shouldLazyLoad()){return e.prototype.updateBindings.call(this,t,o)}else{d.debug("BlockBase ::: Ignoring the updateBindingContext as the block is not visible for now in the ObjectPageLayout")}};f.prototype.exit=function(){if(this._oViewDestroyObserver){this._oViewDestroyObserver.disconnect()}};f.prototype._shouldLazyLoad=function(){return!!this._oParentObjectPageSubSection&&this._bLazyLoading&&!this._bConnected};f.prototype._onViewDestroy=function(e){delete this._oPromisedViews[e.object.getId()]};return f});
//# sourceMappingURL=BlockBase.js.map