//@ui5-bundle sap/uxap/library-preload.js
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/AnchorBar", ["sap/ui/thirdparty/jquery","sap/m/Button","sap/m/MenuButton","sap/m/library","sap/m/Toolbar","sap/ui/core/IconPool","sap/ui/core/Item","sap/ui/core/ResizeHandler","sap/ui/core/delegate/ScrollEnablement","sap/ui/layout/HorizontalLayout","sap/ui/Device","sap/ui/core/CustomData","sap/ui/core/Control","./HierarchicalSelect","./library","sap/uxap/AnchorBarRenderer","sap/base/Log","sap/ui/core/Configuration","sap/ui/dom/jquery/scrollLeftRTL"],function(jQuery,t,e,o,i,r,s,n,a,l,c,h,u,f,p,d,_,g){"use strict";var S=o.SelectType;var y=2;var A=i.extend("sap.uxap.AnchorBar",{metadata:{library:"sap.uxap",properties:{showPopover:{type:"boolean",defaultValue:true},upperCase:{type:"boolean",defaultValue:false},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance"}},associations:{selectedButton:{type:"sap.m.Button",multiple:false}},aggregations:{_select:{type:"sap.uxap.HierarchicalSelect",multiple:false,visibility:"hidden"},_scrollArrowLeft:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_scrollArrowRight:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}}},renderer:d});A.ButtonDelegate={onAfterRendering:function(){var t=this.isA("sap.m.MenuButton")?this._getButtonControl():this,e=this.hasStyleClass("sapUxAPAnchorBarButtonSelected");if(this.data("bHasSubMenu")){t.$().attr("aria-haspopup","menu");t.$().find(".sapMBtn").attr("role","none").removeAttr("aria-haspopup")}t.$().attr("aria-controls",this.data("sectionId")).attr("aria-selected",e)}};A.prototype.init=function(){if(i.prototype.init){i.prototype.init.call(this)}this.addStyleClass("sapUxAPAnchorBar");this._oPressHandlers={};this._oSectionInfo={};this._oScroller=null;this._sSelectedKey=null;this._bRtl=g.getRTL();this._bHasButtonsBar=c.system.tablet||c.system.desktop;this.oLibraryResourceBundleOP=sap.ui.getCore().getLibraryResourceBundle("sap.uxap");this._oSelect=this._getHierarchicalSelect();if(this._bHasButtonsBar){this._oScroller=new a(this,this.getId()+"-scroll",{horizontal:true,vertical:false,nonTouchScrolling:true});this._iREMSize=0;this._iTolerance=0;this._iOffset=0;this._sResizeListenerId=undefined}this.setDesign("Transparent")};A.SCROLL_STEP=250;A.SCROLL_DURATION=500;A.DOM_CALC_DELAY=200;A.prototype.setSelectedButton=function(t){var e=this.getSelectedButton(),o,i=this._oSelect.getItems(),r=i.length>0;if(typeof t==="string"){t=sap.ui.getCore().byId(t)}if(t){if(t.getId()===e){return this}var s=t.data("sectionId");this._sSelectedKey=s;if(s&&r){this._oSelect.setSelectedKey(s)}if(this._bHasButtonsBar&&t.data("secondLevel")!==true){o=sap.ui.getCore().byId(e);this._toggleSelectionStyleClass(o,false);this._toggleSelectionStyleClass(t,true);if(s){this.scrollToSection(s,A.SCROLL_DURATION)}this._setAnchorButtonsTabFocusValues(t)}this.setAssociation("selectedButton",t,true)}return this};A.prototype.setShowPopover=function(t,e){if(this.getShowPopover()===t){return this}return this.setProperty("showPopover",t,true)};A.prototype.getSelectedSection=function(){var e=this.getSelectedButton();if(e&&typeof e==="string"){e=sap.ui.getCore().byId(e)}if(e&&e instanceof t&&e.data("sectionId")){return sap.ui.getCore().byId(e.data("sectionId"))}return null};A.prototype.onBeforeRendering=function(){if(this._bHasButtonsBar){this._iREMSize=parseInt(jQuery("body").css("font-size"));this._iTolerance=this._iREMSize*1;this._iOffset=this._iREMSize*3}if(i.prototype.onBeforeRendering){i.prototype.onBeforeRendering.call(this)}var t=this.getContent()||[],e=this.getUpperCase();this._oSelect.setUpperCase(e);this.toggleStyleClass("sapUxAPAnchorBarUpperCase",e);if(t.length>0&&this._sSelectedKey){this._oSelect.setSelectedKey(this._sSelectedKey)}};A.prototype.addContent=function(t,e){var o=t.data("secondLevel")===true||t.data("secondLevel")==="true";t.addStyleClass("sapUxAPAnchorBarButton");t.removeAllAriaDescribedBy();this._createSelectItem(t,o);if(o){t.destroy()}else{t.addEventDelegate(A.ButtonDelegate,t);this.addAggregation("content",t,e)}return this};A.prototype._removeButtonsDelegate=function(){var t=this.getContent();t.forEach(function(t){t.removeEventDelegate(A.ButtonDelegate)})};A.prototype._createSelectItem=function(t,e){var o=t.getBindingInfo("text"),i=t.getText().trim()!=""||o;if(i&&(!e||t.data("bTitleVisible")===true)){var r=new s({key:t.data("sectionId"),text:t.getText(),customData:[new h({key:"secondLevel",value:t.data("secondLevel")})]});if(o){r.bindProperty("text",Object.assign({},o))}this._oSelect.addItem(r)}};A.prototype._decorateSubMenuButtons=function(t){var e=t.getSource().getContent();e.forEach(function(t){t.$().attr("aria-controls",t.data("sectionId"))})};A.prototype._toggleSelectionStyleClass=function(t,o){if(t&&t.toggleStyleClass){t.toggleStyleClass("sapUxAPAnchorBarButtonSelected",o);if(t instanceof e){t._getButtonControl().$().attr("aria-selected",o)}else{t.$().attr("aria-selected",o)}}};A.prototype.onButtonPress=function(t){this.fireEvent("_anchorPress",{sectionBaseId:t.getSource().data("sectionId")})};A.prototype._onSelectChange=function(t){var e=t.getParameter("selectedItem"),o,i;if(!e){_.warning("AnchorBar :: no selected hierarchicalSelect item");return}o=sap.ui.getCore().byId(e.getKey());if(o){this.fireEvent("_anchorPress",{sectionBaseId:o.getId()});i=o.getDomRef();if(i){setTimeout(function(){i.focus()},0)}}else{_.error("AnchorBar :: cannot find corresponding section",e.getKey())}};A.prototype._getHierarchicalSelect=function(){if(!this.getAggregation("_select")){this.setAggregation("_select",new f({width:"100%",icon:"sap-icon://slim-arrow-down",tooltip:this.oLibraryResourceBundleOP.getText("ANCHOR_BAR_OVERFLOW"),change:jQuery.proxy(this._onSelectChange,this)}))}return this.getAggregation("_select")};A.prototype._createScrollArrow=function(e){var o,i,s,n,a,c=this,h=this.oLibraryResourceBundleOP.getText("TOOLTIP_OP_SCROLL_LEFT_ARROW"),u=this.oLibraryResourceBundleOP.getText("TOOLTIP_OP_SCROLL_RIGHT_ARROW");if(e){o=this.getId()+"-arrowScrollLeft";i="slim-arrow-left";s="anchorBarArrowLeft";n=this._bRtl?u:h}else{o=this.getId()+"-arrowScrollRight";i="slim-arrow-right";s="anchorBarArrowRight";n=this._bRtl?h:u}a=new t(o,{icon:r.getIconURI(i),type:"Transparent",press:function(t){t.preventDefault();c._handleScrollButtonTap(e)},tooltip:n});a.addEventDelegate({onAfterRendering:function(){if(g.getTheme()!="sap_hcb"){this.$().attr("tabindex",-1)}},onThemeChanged:function(){if(g.getTheme()=="sap_hcb"){this.$().removeAttr("tabindex")}else{this.$().attr("tabindex",-1)}}},a);return new l({content:[a]}).addStyleClass("anchorBarArrow").addStyleClass(s)};A.prototype._getScrollArrowLeft=function(){var t=this.getAggregation("_scrollArrowLeft");if(t){return t}else{t=this._createScrollArrow(true);this.setAggregation("_scrollArrowLeft",t);return t}};A.prototype._getScrollArrowRight=function(){var t=this.getAggregation("_scrollArrowRight");if(t){return t}else{t=this._createScrollArrow(false);this.setAggregation("_scrollArrowRight",t);return t}};A.prototype._applyHierarchicalSelectMode=function(){if(this._sHierarchicalSelectMode===d._AnchorBarHierarchicalSelectMode.Icon){this.$().find(".sapUxAPAnchorBarScrollContainer").show();this._oSelect.setWidth("auto");this._oSelect.setAutoAdjustWidth(true);this._oSelect.setType(S.IconOnly);this._computeBarSectionsInfo()}else{this.$().find(".sapUxAPAnchorBarScrollContainer").hide();this._oSelect.setWidth("100%");this._oSelect.setAutoAdjustWidth(false);this._oSelect.setType(S.Default)}this.$().toggleClass("sapUxAPAnchorBarOverflow",this._sHierarchicalSelectMode===d._AnchorBarHierarchicalSelectMode.Icon)};A.prototype._adjustSize=function(t){var e=c.media.getCurrentRange(c.media.RANGESETS.SAP_STANDARD,this._getWidth(this)),o=t&&t.size&&t.size.width!==t.oldSize.width,i=p.Utilities.isPhoneScenario(e)?d._AnchorBarHierarchicalSelectMode.Text:d._AnchorBarHierarchicalSelectMode.Icon;if(i!==this._sHierarchicalSelectMode){this._sHierarchicalSelectMode=i;this._applyHierarchicalSelectMode()}if(this._sHierarchicalSelectMode===d._AnchorBarHierarchicalSelectMode.Icon){if(this._iMaxPosition<0){return}var r=this.$(),s=r.find(".sapUxAPAnchorBarScrollContainer"),n,a,l,h,u=function t(){var e=n;n=a;a=e};if(o){this.scrollToSection(this._sSelectedKey)}l=s.width();h=this._bRtl?s.scrollLeftRTL():s.scrollLeft();n=h>=this._iTolerance;a=h+l<this._iMaxPosition-this._iTolerance;if(this._bRtl){u()}_.debug("AnchorBar :: scrolled at "+h,"scrollBegin ["+(n?"true":"false")+"] scrollEnd ["+(a?"true":"false")+"]");r.toggleClass("sapUxAPAnchorBarScrollLeft",n);r.toggleClass("sapUxAPAnchorBarScrollRight",a)}};A.prototype._handleScrollButtonTap=function(t){var e=!this._bRtl&&t||this._bRtl&&!t?-1:1;this._oScroller.scrollTo(this._iMaxPosition*e,0,A.SCROLL_DURATION*3)};A.prototype.scrollToSection=function(t,e){if(this._bHasButtonsBar){var o=c.media.getCurrentRange(c.media.RANGESETS.SAP_STANDARD,this._getWidth(this)),e=e||A.SCROLL_DURATION,i;if(!p.Utilities.isPhoneScenario(o)&&this._oSectionInfo[t]){if(this._bRtl&&c.browser.firefox){i=this._oSectionInfo[t].scrollLeft+this._iOffset}else{i=this._oSectionInfo[t].scrollLeft-this._iOffset;if(i<0){i=0}}_.debug("AnchorBar :: scrolling to section "+t+" of "+i);if(this._sCurrentScrollId!=t){this._sCurrentScrollId=t;if(this._iCurrentScrollTimeout){clearTimeout(this._iCurrentScrollTimeout);this.$("scroll").parent().stop(true,false)}this._iCurrentScrollTimeout=setTimeout(function(){this._sCurrentScrollId=undefined;this._iCurrentScrollTimeout=undefined}.bind(this),e);this._oScroller.scrollTo(i,0,e)}}else{_.debug("AnchorBar :: no need to scroll to "+t)}}};A.prototype.scrollToCurrentlySelectedSection=function(){var t=this.getSelectedButton(),e=sap.ui.getCore().byId(t),o;if(e){o=e.data("sectionId");this.scrollToSection(o,0)}};A.prototype.getScrollDelegate=function(){return this._oScroller};A.PAGEUP_AND_PAGEDOWN_JUMP_SIZE=5;A.prototype.onsapright=function(t){t.preventDefault();var e,o=this.getContent(),i;o.forEach(function(o,i){if(t.target.id.indexOf(o.getId())>-1){e=i+1;return}});if(e&&o[e]){i=o[e];i.focus()}else if(o[o.length-1]){i=o[o.length-1];i.focus()}this._forceScrollIfNeeded(i)};A.prototype.onsapleft=function(t){t.preventDefault();var e,o=this.getContent(),i;o.forEach(function(o,i){if(t.target.id.indexOf(o.getId())>-1){e=i-1;return}});if(e&&o[e]){i=o[e];i.focus()}else if(o[0]){i=o[0];i.focus()}this._forceScrollIfNeeded(i,true)};A.prototype._forceScrollIfNeeded=function(t,e){var o=t.getDomRef(),i=o.parentElement,r=i.offsetLeft,s=i.offsetWidth,n=o&&o.offsetWidth,a=o&&o.offsetLeft,l=this._oScroller.getScrollLeft(),c,h,u;if(!i||!n){return}if(!this._bRtl){h=a+n;u=s-(r+h-l);if(!e&&u<0&&s-h<0){this._scrollAnchorBar(e,u)}u=a-this._iOffset-r-y;if(e&&l>u){this._scrollAnchorBar(e,u)}}else{if(e){c=l+s-this._iOffset;h=a-r;if(h+n>c){u=h+n-c+y;this._scrollAnchorBar(e,u)}}else{if(a-r-this._iOffset-y<l){u=n-a+y;this._scrollAnchorBar(e,u)}}}};A.prototype._scrollAnchorBar=function(t,e){var o=!this._bRtl&&t||this._bRtl&&!t?-1:1,i=this._oScroller.getScrollLeft(),r=e;if(o===1){r=this._bRtl?i+e:i+Math.abs(e)}if(this._bRtl&&o===-1){r=e*o}this._oScroller.scrollTo(r,0,A.SCROLL_DURATION*3)};A.prototype.onsapdown=function(t){t.preventDefault()};A.prototype.onsapup=function(t){t.preventDefault()};A.prototype.onsaphome=function(t){t.preventDefault();var e=this.getContent();e[0].focus()};A.prototype.onsapend=function(t){t.preventDefault();var e=this.getContent();e[e.length-1].focus()};A.prototype.onsappageup=function(t){this._handlePageUp(t)};A.prototype.onsappagedown=function(t){this._handlePageDown(t)};A.prototype._handlePageUp=function(t){t.preventDefault();var e;var o=this.getContent();o.forEach(function(o,i){if(t.target.id.indexOf(o.getId())>-1){e=i-(A.PAGEUP_AND_PAGEDOWN_JUMP_SIZE+1);return}});if(e&&o[e]){o[e].focus()}else if(o[0]){o[0].focus()}};A.prototype._handlePageDown=function(t){t.preventDefault();var e;var o=this.getContent();o.forEach(function(o,i){if(t.target.id.indexOf(o.getId())>-1){e=i+A.PAGEUP_AND_PAGEDOWN_JUMP_SIZE+1;return}});if(e&&o[e]){o[e].focus()}else if(o[o.length-1]){o[o.length-1].focus()}};A.prototype._setAnchorButtonsTabFocusValues=function(t){var e=this.getContent()||[],o,i="0",r="-1",s="tabIndex";e.forEach(function(e){o=e.getAggregation("_button")?e.getAggregation("_button").$():e.$();if(e===t){o.attr(s,i)}else{o.attr(s,r)}})};A.prototype.onAfterRendering=function(){var t;if(i.prototype.onAfterRendering){i.prototype.onAfterRendering.call(this)}t=sap.ui.getCore().byId(this.getSelectedButton());this._setAnchorButtonsTabFocusValues(t);this._iMaxPosition=-1;this._sResizeListenerId=n.register(this,jQuery.proxy(this._adjustSize,this));this.$().find(".sapUxAPAnchorBarScrollContainer").on("scroll",jQuery.proxy(this._onScroll,this));if(t){this.setSelectedButton(t)}if(this._bHasButtonsBar){this._iComputeContentSizeTimeout=setTimeout(function(){if(this._sHierarchicalSelectMode===d._AnchorBarHierarchicalSelectMode.Icon){this._computeBarSectionsInfo()}this._adjustSize();this._iComputeContentSizeTimeout=null}.bind(this),A.DOM_CALC_DELAY)}};A.prototype.onThemeChanged=function(){if(this._sHierarchicalSelectMode===d._AnchorBarHierarchicalSelectMode.Icon){this._computeBarSectionsInfo()}};A.prototype._onScroll=function(){if(!this._iCurrentSizeCheckTimeout){this._iCurrentSizeCheckTimeout=setTimeout(function(){this._iCurrentSizeCheckTimeout=undefined;this._adjustSize()}.bind(this),A.SCROLL_DURATION)}};A.prototype._computeBarSectionsInfo=function(){this._iMaxPosition=0;var t=this.getContent()||[];t.forEach(this._computeNextSectionInfo,this);if(this._bRtl&&(c.browser.webkit||c.browser.firefox)){t.forEach(this._adjustNextSectionInfo,this);this._oScroller&&this._oScroller.scrollTo(this._iMaxPosition,0,0)}};A.prototype._computeNextSectionInfo=function(t){var e=t.$().outerWidth(true);this._oSectionInfo[t.data("sectionId")]={scrollLeft:this._iMaxPosition,width:e};this._iMaxPosition+=e};A.prototype._adjustNextSectionInfo=function(t){var e=this._oSectionInfo[t.data("sectionId")];if(c.browser.firefox){e.scrollLeft=-e.scrollLeft}else{e.scrollLeft=this._iMaxPosition-e.scrollLeft-e.width}};A.prototype._resetControl=function(){this._removeButtonsDelegate();this.destroyAggregation("content");this._oSelect.destroyAggregation("items",true);return this};A.prototype._getAccessibilityRole=function(){return"none"};A.prototype.enhanceAccessibilityState=function(t,e){var o=this.getContent(),i=o.indexOf(t);if(i!==-1){e.role="option";e.setsize=o.length;e.posinset=i+1}};A.prototype.exit=function(){if(this._sResizeListenerId){n.deregister(this._sResizeListenerId);this._sResizeListenerId=null}if(this._oScroller){this._oScroller.destroy();this._oScroller=null}if(this.oLibraryResourceBundleOP){this.oLibraryResourceBundleOP=null}if(this._iComputeContentSizeTimeout){clearTimeout(this._iComputeContentSizeTimeout);this._iComputeContentSizeTimeout=null}this._removeButtonsDelegate()};A.prototype._getWidth=function(t){var e=t.getDomRef();return!(t instanceof u)?0:e&&e.offsetWidth||0};A.prototype.setVisible=function(t){this.getParent()&&this.getParent().toggleStyleClass("sapUxAPObjectPageLayoutNoAnchorBar",!t);return this.setProperty("visible",t)};return A});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/AnchorBarRenderer", ["sap/m/ToolbarRenderer","sap/ui/core/Renderer","sap/m/BarInPageEnabler","./library"],function(e,r,t,a){"use strict";var o=r.extend(e);o.apiVersion=2;var n=o._AnchorBarHierarchicalSelectMode={Icon:"icon",Text:"text"};o.renderBarContent=function(e,r){if(r._bHasButtonsBar){e.renderControl(r._getScrollArrowLeft());e.openStart("div",r.getId()+"-scrollContainer");e.class("sapUxAPAnchorBarScrollContainer").openEnd();e.openStart("div",r.getId()+"-scroll").attr("role","listbox").attr("aria-describedby",r.getId()+"-desc").attr("aria-label",sap.ui.getCore().getLibraryResourceBundle("sap.uxap").getText("ANCHOR_BAR_ARIA_LABEL")).openEnd();o.renderBarItems(e,r);e.close("div");e.openStart("span",r.getId()+"-desc").class("sapUiPseudoInvisibleText").openEnd();e.text(sap.ui.getCore().getLibraryResourceBundle("sap.uxap").getText("ANCHOR_BAR_ARIA_LABEL_DESC"));e.close("span");e.close("div");e.renderControl(r._getScrollArrowRight())}t.addChildClassTo(r._oSelect,r);e.renderControl(r._oSelect)};o.renderBarItems=function(e,r){var a=r.getSelectedButton();r.getContent().forEach(function(o){t.addChildClassTo(o,r);if(o.getId()===a){o.addStyleClass("sapUxAPAnchorBarButtonSelected")}e.renderControl(o)})};o.decorateRootElement=function(r,t){e.decorateRootElement.apply(this,arguments);if(t._sHierarchicalSelectMode===n.Icon){r.class("sapUxAPAnchorBarOverflow")}if(t.getBackgroundDesign()){r.class("sapUxAPAnchorBar"+t.getBackgroundDesign())}};return o},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/BlockBase", ["sap/ui/thirdparty/jquery","sap/ui/core/Control","sap/ui/core/CustomData","sap/ui/core/mvc/View","sap/ui/base/ManagedObjectObserver","./BlockBaseMetadata","./BlockBaseRenderer","sap/ui/model/Context","sap/ui/layout/form/ColumnLayout","./library","sap/ui/core/Component","sap/ui/layout/library","sap/base/Log","sap/uxap/ModelMapping"],function(jQuery,e,t,o,i,n,a,s,r,p,u,l,d,g){"use strict";var c=l.form.SimpleFormLayout;var h=p.BlockBaseFormAdjustment;var f=e.extend("sap.uxap.BlockBase",{metadata:{designtime:"sap/uxap/designtime/BlockBase.designtime",library:"sap.uxap",properties:{mode:{type:"string",group:"Appearance"},visible:{type:"boolean",group:"Appearance",defaultValue:true},columnLayout:{type:"sap.uxap.BlockBaseColumnLayout",group:"Behavior",defaultValue:"auto"},formAdjustment:{type:"sap.uxap.BlockBaseFormAdjustment",group:"Behavior",defaultValue:h.BlockColumns},showSubSectionMore:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"mappings",aggregations:{mappings:{type:"sap.uxap.ModelMapping",multiple:true,singularName:"mapping"},_views:{type:"sap.ui.core.Control",multiple:true,singularName:"view",visibility:"hidden"}},associations:{selectedView:{type:"sap.ui.core.Control",multiple:false}},events:{viewInit:{parameters:{view:{type:"sap.ui.core.mvc.View"}}}},views:{}},renderer:a},n);f.prototype.init=function(){if(!this.getMetadata().hasViews()){this.getMetadata().setView("defaultXML",{viewName:this.getMetadata().getName(),type:"XML"})}this._oMappingApplied={};this._bLazyLoading=false;this._bConnected=false;this._oUpdatedModels={};this._oParentObjectPageSubSection=null;this._oPromisedViews={};this._oViewDestroyObserver=new i(this._onViewDestroy.bind(this))};f.prototype.onBeforeRendering=function(){var e;this._applyMapping();if(!this.getMode()||this.getMode()===""){if(this.getMetadata().getView("defaultXML")){this.setMode("defaultXML")}else{d.error("BlockBase ::: there is no mode defined for rendering "+this.getMetadata().getName()+". You can either set a default mode on the block metadata or set the mode property before rendering the block.")}}this._applyFormAdjustment();e=this._getObjectPageLayout();this._bLazyLoading=e&&(e.getEnableLazyLoading()||e.getUseIconTabBar())};f.prototype.onAfterRendering=function(){var e=this._getObjectPageLayout();if(e){e._requestAdjustLayout()}};f.prototype.setParent=function(t,o,i){e.prototype.setParent.call(this,t,o,i);if(t&&t.isA("sap.uxap.ObjectPageSubSection")){this._bLazyLoading=true;this._oParentObjectPageSubSection=t}};f.prototype.setModel=function(t,o){this._applyMapping(o);return e.prototype.setModel.call(this,t,o)};f.prototype._applyMapping=function(){if(this._shouldLazyLoad()){d.debug("BlockBase ::: Ignoring the _applyMapping as the block is not connected")}else{this.getMappings().forEach(function(t,o){var i,n,a=t.getInternalModelName(),r=t.getExternalPath(),p=t.getExternalModelName(),u;if(r){if(a==""||r==""){throw new Error("BlockBase :: incorrect mapping, one of the modelMapping property is empty")}i=this.getModel(p);if(!i){return}u=i.resolve(r,this.getBindingContext(p));n=this.getBindingContext(a);if(!this._isMappingApplied(a)||this.getModel(a)!==this.getModel(p)||n&&n.getPath()!==u){d.info("BlockBase :: mapping external model "+p+" to "+a);this._oMappingApplied[a]=true;e.prototype.setModel.call(this,i,a);this.setBindingContext(new s(i,u),a)}}},this)}};f.prototype._isMappingApplied=function(e){return this.getModel(e)&&this._oMappingApplied[e]};f.prototype.propagateProperties=function(t){if(this._shouldLazyLoad()&&!this._oUpdatedModels.hasOwnProperty(t)){this._oUpdatedModels[t]=true}else{this._applyMapping(t)}return e.prototype.propagateProperties.call(this,t)};f.prototype.getSupportedModes=function(){var e=jQuery.extend({},this.getMetadata().getViews());for(var t in e){e[t]=t}return e};f.prototype.setMode=function(e){e=this._validateMode(e);if(this.getMode()!==e){this.setProperty("mode",e,false);if(!this._shouldLazyLoad()){this._selectView(e)}}return this};f.prototype.setColumnLayout=function(e){if(this._oParentObjectPageSubSection){this._oParentObjectPageSubSection.invalidate()}return this.setProperty("columnLayout",e)};f.prototype.clone=function(){var t=-1,o=this.getAssociation("selectedView"),i=this.getAggregation("_views")||[];if(o){i.forEach(function(e,i){if(e.getId()===o){t=i}return t<0})}var n=e.prototype.clone.call(this);if(t>=0){n.setAssociation("selectedView",n.getAggregation("_views")[t])}return n};f.prototype._validateMode=function(e){this.validateProperty("mode",e);if(!this.getMetadata().getView(e)){var t=this.getMetadata()._sClassName||this.getId();if(this.getMetadata().getView("defaultXML")){d.warning("BlockBase :: no view defined for block "+t+" for mode "+e+", loading defaultXML instead");e="defaultXML"}else{throw new Error("BlockBase :: no view defined for block "+t+" for mode "+e)}}return e};f.prototype._getSelectedViewContent=function(){var e=null,t,o;t=this.getAssociation("selectedView");o=this.getAggregation("_views");if(o){for(var i=0;!e&&i<o.length;i++){if(o[i].getId()===t){e=o[i]}}}return e};f.prototype.createView=function(e,t){if(!this._oPromisedViews[e.id]){this._oPromisedViews[e.id]=new Promise(function(i,n){var a=u.getOwnerComponentFor(this),s=function(){var t=function(){return o.create(e)};if(a){return a.runAsOwner(t)}else{return t()}};s().then(function(e){this._afterViewInstantiated(e,t);i(e)}.bind(this))}.bind(this))}return this._oPromisedViews[e.id]};f.prototype._afterViewInstantiated=function(e,o){if(this._bIsBeingDestroyed){return}var i=e.getController();if(e){if(i){i.oParentBlock=this}e.addCustomData(new t({key:"layoutMode",value:o}));this.addAggregation("_views",e);this._oViewDestroyObserver.observe(e,{destroy:true});this.fireEvent("viewInit",{view:e})}else{throw new Error("BlockBase :: no view defined in metadata.views for mode "+o)}};f.prototype._notifyForLoadingInMode=function(e,t,o){if(e&&typeof e.onParentBlockModeChange==="function"){e.onParentBlockModeChange(o)}else{d.info("BlockBase ::: could not notify "+t.sViewName+" of loading in mode "+o+": missing controller onParentBlockModeChange method")}};f.prototype._selectView=function(e){var t,o=this.getId()+"-"+e,i,n;n=function(t){if(t&&this.getAssociation("selectedView")!==o){this.setAssociation("selectedView",t);this._notifyForLoadingInMode(t.getController(),t,e)}}.bind(this);t=this._findView(e);if(t){n(t);return}i=this.getMetadata().getView(e);i.id=o;this.createView(i,e).then(function(e){n(e)})};f.prototype._findView=function(e){var t=this.getAggregation("_views")||[],o,i;i=t.filter(function(t){return t.data("layoutMode")===e});if(i.length){return i[0]}o=this.getMetadata().getView(e);i=t.filter(function(e){return o.viewName===e.getViewName()});if(i.length){return i[0]}};f.FORM_ADUSTMENT_OFFSET=16;f._FORM_ADJUSTMENT_CONST={labelSpan:{L:12},emptySpan:{L:0},columns:{XL:1,L:1,M:1}};f._PARENT_GRID_SIZE=12;f.prototype._computeFormAdjustmentFields=function(e,t){if(e&&t){return e===h.BlockColumns?jQuery.extend({},f._FORM_ADJUSTMENT_CONST,{columns:t}):f._FORM_ADJUSTMENT_CONST}};f.prototype._applyFormAdjustment=function(){var e=this.getFormAdjustment(),t=this._getSelectedViewContent(),o=this._oParentObjectPageSubSection,i;if(e!==h.None&&t&&o){i=this._computeFormAdjustmentFields(e,o._oLayoutConfig);t.getContent().forEach(function(e){this._adjustForm(e,i)}.bind(this))}};f.prototype._adjustForm=function(e,t){var o,i;if(e.getMetadata().getName()==="sap.ui.layout.form.SimpleForm"){e.setLayout(c.ColumnLayout);i=e.getAggregation("form").getLayout();i._iBreakPointTablet-=f.FORM_ADUSTMENT_OFFSET;i._iBreakPointDesktop-=f.FORM_ADUSTMENT_OFFSET;i._iBreakPointLargeDesktop-=f.FORM_ADUSTMENT_OFFSET;e.setLabelSpanL(t.labelSpan.L);e.setEmptySpanL(t.emptySpan.L);this._applyFormAdjustmentFields(t,e);e.setWidth("100%")}else if(e.getMetadata().getName()==="sap.ui.layout.form.Form"){i=e.getLayout();if(i&&i.getMetadata().getName()==="sap.ui.layout.form.ColumnLayout"){o=i}else{o=new r;e.setLayout(o)}o._iBreakPointTablet-=f.FORM_ADUSTMENT_OFFSET;o._iBreakPointDesktop-=f.FORM_ADUSTMENT_OFFSET;o._iBreakPointLargeDesktop-=f.FORM_ADUSTMENT_OFFSET;o.setLabelCellsLarge(t.labelSpan.L);o.setEmptyCellsLarge(t.emptySpan.L);this._applyFormAdjustmentFields(t,o);e.setWidth("100%")}};f.prototype._applyFormAdjustmentFields=function(e,t){t.setColumnsXL(e.columns.XL);t.setColumnsL(e.columns.L);t.setColumnsM(e.columns.M)};f.prototype._getObjectPageLayout=function(){return p.Utilities.getClosestOPL(this)};f.prototype.setVisible=function(e,t){var o=this._getObjectPageLayout();if(e===this.getVisible()){return this}this.setProperty("visible",e,t);o&&o._requestAdjustLayoutAndUxRules();return this};f.prototype.setShowSubSectionMore=function(e,t){if(e!=this.getShowSubSectionMore()){this.setProperty("showSubSectionMore",e,true);if(this._oParentObjectPageSubSection){this._oParentObjectPageSubSection.refreshSeeMoreVisibility()}}return this};f.prototype.connectToModels=function(){if(!this._bConnected){d.debug("BlockBase :: Connecting block to the UI5 model tree");this._bConnected=true;if(this._bLazyLoading){var e=this.getMode();e&&this._selectView(e);this.updateBindings(true,null)}this.invalidate()}};f.prototype._allowPropagationToLoadedViews=function(e){if(!this._bConnected){return}this.mSkipPropagation._views=!e};f.prototype.updateBindingContext=function(t,o,i,n){if(!this._shouldLazyLoad()){return e.prototype.updateBindingContext.call(this,t,o,i,n)}else{d.debug("BlockBase ::: Ignoring the updateBindingContext as the block is not visible for now in the ObjectPageLayout")}};f.prototype.updateBindings=function(t,o){if(!this._shouldLazyLoad()){return e.prototype.updateBindings.call(this,t,o)}else{d.debug("BlockBase ::: Ignoring the updateBindingContext as the block is not visible for now in the ObjectPageLayout")}};f.prototype.exit=function(){if(this._oViewDestroyObserver){this._oViewDestroyObserver.disconnect()}};f.prototype._shouldLazyLoad=function(){return!!this._oParentObjectPageSubSection&&this._bLazyLoading&&!this._bConnected};f.prototype._onViewDestroy=function(e){delete this._oPromisedViews[e.object.getId()]};return f});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/BlockBaseMetadata", ["sap/ui/core/ElementMetadata","sap/base/Log","sap/base/util/isEmptyObject"],function(e,t,r){"use strict";var n=function(t,r){e.apply(this,arguments);this._mViews=r.metadata.views||{}};n.prototype=Object.create(e.prototype);n.prototype.constructor=n;n.prototype.applySettings=function(t){var r=t.hasOwnProperty("renderer")?t.renderer||"":undefined;e.prototype.applySettings.call(this,t);if(r==null){this._sRendererName=null}};n.prototype.getRendererName=function(){if(!this._sBlockRenderer){this._sBlockRenderer=this._resolveRendererName();t.debug("BlockBaseMetadata :: "+this.getName()+" is renderer with "+this._sBlockRenderer)}return this._sBlockRenderer};n.prototype._resolveRendererName=function(){var t=e.prototype.getRendererName.call(this);if(t==null){var r=this.getParent();if(r){t=n.prototype._resolveRendererName.apply(r)}else{throw new Error("BlockBaseMetadata :: no renderer found for "+this.getName())}}return t};n.prototype.getView=function(e){return this._mViews[e]};n.prototype.getViews=function(){return this._mViews};n.prototype.setView=function(e,t){this._mViews[e]=t;return this};n.prototype.hasViews=function(){return!r(this._mViews)};return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/BlockBaseRenderer", function(){"use strict";var e={apiVersion:2};e.render=function(e,t){if(!t.getVisible()){return}e.openStart("div",t);if(t._getSelectedViewContent()){e.class("sapUxAPBlockBase").class("sapUxAPBlockBase"+t.getMode())}else{var n=t.getMetadata().getName().split(".").pop();e.class(n+t.getMode())}e.openEnd();if(t._getSelectedViewContent()){e.renderControl(t._getSelectedViewContent())}e.close("div")};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/BreadCrumbs", ["sap/m/Link","sap/m/Select","sap/ui/core/Control","sap/ui/core/ResizeHandler","sap/ui/core/delegate/ItemNavigation","sap/ui/core/Item","sap/ui/core/Icon","sap/ui/Device","./library","sap/ui/core/InvisibleText","sap/ui/util/openWindow","./BreadCrumbsRenderer","sap/ui/thirdparty/jquery"],function(e,t,i,s,r,o,n,a,l,u,h,g,jQuery){"use strict";var c=i.extend("sap.uxap.BreadCrumbs",{metadata:{library:"sap.uxap",properties:{showCurrentLocation:{type:"boolean",group:"Behavior",defaultValue:true}},defaultAggregation:"links",aggregations:{links:{type:"sap.m.Link",multiple:true,singularName:"link"},currentLocation:{type:"sap.m.Text",multiple:false},_tubeIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_overflowSelect:{type:"sap.m.Select",multiple:false,visibility:"hidden"}}},renderer:g});c.PAGEUP_AND_PAGEDOWN_JUMP_SIZE=5;c.prototype.init=function(){this._iREMSize=parseInt(jQuery("body").css("font-size"));this._iContainerMaxHeight=this._iREMSize*2};c.prototype.onBeforeRendering=function(){this._bOnPhone=a.system.phone;this._resetControl()};c.prototype.onAfterRendering=function(){this._handleInitialModeSelection()};c.prototype._handleInitialModeSelection=function(){if(this._bOnPhone){this._setSelectVisible(true);return this}this._configureKeyboardHandling();if(!this._iContainerHeight){this._iContainerHeight=this.$().outerHeight()}if(this._iContainerHeight>this._iContainerMaxHeight){this._toggleOverflowMode(true);return this}this._sResizeListenerId=s.register(this,this._handleScreenResize.bind(this));return this};c.prototype._toggleOverflowMode=function(e){if(this._sResizeListenerId){s.deregister(this._sResizeListenerId)}this._setSelectVisible(e);this._setBreadcrumbsVisible(!e);this._sResizeListenerId=s.register(this,this._handleScreenResize.bind(this));return this};c.prototype._getTubeIcon=function(){if(!this.getAggregation("_tubeIcon")){this.setAggregation("_tubeIcon",new n({src:"sap-icon://slim-arrow-right",color:"#bfbfbf",size:"1rem",useIconTooltip:false}).addStyleClass("sapUxAPTubeIcon"))}return this.getAggregation("_tubeIcon")};c.prototype._getOverflowSelect=function(){var e,i;if(!this.getAggregation("_overflowSelect")){i=this.getLinks().reverse()||[];i.unshift(this.getCurrentLocation());e=new t({items:i.map(this._createSelectItem),autoAdjustWidth:true});e.attachChange(this._overflowSelectChangeHandler);this.setAggregation("_overflowSelect",e)}return this.getAggregation("_overflowSelect")};c.prototype._createSelectItem=function(e){return new o({key:e.getId(),text:e.getText()})};c.prototype._overflowSelectChangeHandler=function(t){var i=t.getParameter("selectedItem").getKey(),s=sap.ui.getCore().byId(i),r,o;if(s instanceof e){r=s.getHref();s.firePress();if(r){o=s.getTarget();if(o){h(r,o)}else{window.location.href=r}}}return this};c.prototype._handleScreenResize=function(e){var t=this._shouldOverflow(),i=this._getUsingOverflowSelect();if(t&&!i){this._toggleOverflowMode(true)}else if(!t&&i){this._toggleOverflowMode(false)}return this};c.prototype._shouldOverflow=function(){var e=this._getBreadcrumbsAsJQueryObject(),t,i=this._getUsingOverflowSelect();if(i){this._setBreadcrumbsVisible(true)}e.addClass("sapUxAPInvisible");t=e.outerHeight()>this._iContainerMaxHeight;e.removeClass("sapUxAPInvisible");if(i){this._setBreadcrumbsVisible(false)}return t};c.prototype._getBreadcrumbsAsJQueryObject=function(){if(!this._$breadcrumbs){this._$breadcurmbs=this.$("breadcrumbs")}return this._$breadcurmbs};c.prototype._getOverflowSelectAsJQueryObject=function(){if(!this._$select){this._$select=this.$("select")}return this._$select};c.prototype._setBreadcrumbsVisible=function(e){var t=this.$(),i=this._getBreadcrumbsAsJQueryObject(),s="sapUxAPFullWidth",r="sapUiHidden";if(e){i.removeClass(r);t.removeClass(s)}else{i.addClass(r);t.addClass(s)}return t};c.prototype._setSelectVisible=function(e){var t=this._getOverflowSelectAsJQueryObject(),i="sapUiHidden";if(e){t.removeClass(i)}else{t.addClass(i)}return this};c.prototype._resetControl=function(){this._iContainerHeight=null;this._$select=null;this._$breadcrumbs=null;this.setAggregation("_overflowSelect",null,true);if(this._sResizeListenerId){s.deregister(this._sResizeListenerId)}return this};c.prototype._getAriaLabelledBy=function(){if(!this._oAriaLabelledBy){c.prototype._oAriaLabelledBy=new u({text:sap.ui.getCore().getLibraryResourceBundle("sap.uxap").getText("BREADCRUMB_TRAIL_LABEL")}).toStatic()}return this._oAriaLabelledBy};c.prototype._getItemNavigation=function(){if(!this._ItemNavigation){this._ItemNavigation=new r}return this._ItemNavigation};c.prototype._getItemsToNavigate=function(){var e=this.getLinks(),t=this.getCurrentLocation(),i=this.getShowCurrentLocation();if(i&&t){e.push(t)}return e};c.prototype._configureKeyboardHandling=function(){var e=this._getItemNavigation(),t=this._getBreadcrumbsAsJQueryObject()[0],i=-1,s=this._getItemsToNavigate(),r=[];s.forEach(function(e){e.$().attr("tabindex","-1");r.push(e.getDomRef())});this.addDelegate(e);e.setCycling(false);e.setRootDomRef(t);e.setItemDomRefs(r);e.setSelectedIndex(i);this._getBreadcrumbsAsJQueryObject().attr("tabindex","-1");s[0].$().attr("tabindex","0");return this};c.prototype.onsappageup=function(e){this._handlePageKeys(e,false)};c.prototype.onsappagedown=function(e){this._handlePageKeys(e,true)};c.prototype._handlePageKeys=function(e,t){var i,s=this._getItemsToNavigate(),r=0,o=t?s.length-1:0;e.preventDefault();s.some(function(t,i){if(t.getId()===e.target.id){r=i;return true}});if(t){i=r+c.PAGEUP_AND_PAGEDOWN_JUMP_SIZE}else{i=r-c.PAGEUP_AND_PAGEDOWN_JUMP_SIZE}if(i&&s[i]){s[i].focus()}else if(s[o]){s[o].focus()}};c.prototype._getUsingOverflowSelect=function(){return!this._getOverflowSelectAsJQueryObject().hasClass("sapUiHidden")};c.prototype.exit=function(){if(this._ItemNavigation){this.removeDelegate(this._ItemNavigation);this._ItemNavigation.destroy();this._ItemNavigation=null}this._resetControl()};return c});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/BreadCrumbsRenderer", function(){"use strict";var e={apiVersion:2};e.render=function(e,r){e.openStart("div",r).class("sapUxAPBreadCrumbs").attr("role","navigation").attr("aria-labelledby",r._getAriaLabelledBy().getId()).openEnd();this._renderOverflowSelect(e,r);if(!r._bOnPhone){this._renderBreadcrumbTrail(e,r)}e.close("div")};e._renderBreadcrumbTrail=function(e,r){var n=r.getLinks(),t=r.getCurrentLocation(),o=r._getTubeIcon(),a=r.getShowCurrentLocation();e.openStart("ul",r.getId()+"-breadcrumbs").openEnd();n.forEach(function(r){e.openStart("li").openEnd();e.renderControl(r);e.renderControl(o);e.close("li")});if(a){e.openStart("li").openEnd();e.renderControl(t);e.close("li")}e.close("ul")};e._renderOverflowSelect=function(e,r){var n=r._getTubeIcon();e.openStart("div",r.getId()+"-select");e.class("sapUiHidden");e.openEnd();e.openStart("span").class("sapUxAPBreadCrumbsDots").openEnd().text("...").close("span");e.renderControl(n);e.renderControl(r._getOverflowSelect());e.close("div")};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/HierarchicalSelect", ["sap/m/Select","sap/ui/Device","sap/ui/thirdparty/jqueryui/jquery-ui-position","./HierarchicalSelectRenderer"],function(e,t,jQuery,r){"use strict";var i=e.extend("sap.uxap.HierarchicalSelect",{metadata:{library:"sap.uxap",properties:{upperCase:{type:"boolean",group:"Appearance",defaultValue:false}}},renderer:r});i.POPOVER_MIN_WIDTH_REM=11;i.prototype.onAfterRendering=function(){e.prototype.onAfterRendering.apply(this,arguments)};i.prototype.onAfterRenderingPicker=function(){e.prototype.onAfterRenderingPicker.call(this);this._applyHierarchyLevelClasses()};i.prototype.onAfterRenderingList=function(){e.prototype.onAfterRenderingList.call(this);this._applyHierarchyLevelClasses()};i.prototype._applyHierarchyLevelClasses=function(){var e=this.getItems()||[];e.forEach(function(e){var t=e.data("secondLevel")===true?"sapUxAPHierarchicalSelectSecondLevel":"sapUxAPHierarchicalSelectFirstLevel";e.$().addClass(t)},this)};i.prototype.setUpperCase=function(e,t){this.setProperty("upperCase",e,t);this.toggleStyleClass("sapUxAPHierarchicalSelectUpperCase",e);var r=this.getAggregation("picker");if(r){r.toggleStyleClass("sapMSltPickerFirstLevelUpperCase",e);if(!t){r.invalidate()}}return this};i.prototype.onsapenter=e.prototype.ontap;["onsapup","onsappageup","onsappagedown","onsaphome","onsapend"].forEach(function(t){i.prototype[t]=function(r){e.prototype[t].call(this,r);r.stopPropagation()}});i.prototype._createDialog=function(){var t=e.prototype._createDialog.call(this),r=t.getCustomHeader();if(r){r.addStyleClass("sapUxAPHierarchicalSelect")}return t};i.prototype._decoratePopover=function(r){e.prototype._decoratePopover.call(this,r);r._adaptPositionParams=function(){this._marginTop=0;this._marginLeft=0;this._marginRight=0;this._marginBottom=0;this._arrowOffset=0;this._offsets=["0 0","0 0","0 0","0 0"];this._myPositions=["end bottom","end center","end top","begin center"];this._atPositions=["end top","end center","end bottom","begin center"]};if(t.system.tablet||t.system.desktop){var i=jQuery.position.scrollbarWidth();if(i>0){r.setOffsetX(i)}}};i.prototype._onAfterRenderingPopover=function(){var e=this.getPicker(),t=e.getDomRef("cont"),r=t.style.minWidth;if(r.endsWith("rem")){r=r.substring(0,r.length-3);var o=parseFloat(r);if(o<i.POPOVER_MIN_WIDTH_REM&&t){t.style.minWidth=i.POPOVER_MIN_WIDTH_REM+"rem"}}};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/HierarchicalSelectRenderer", ["sap/m/SelectRenderer","sap/ui/core/Renderer"],function(e,r){"use strict";var a=r.extend(e);a.apiVersion=2;a.addClass=function(e){e.class("sapUxAPHierarchicalSelect")};return a},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/LazyLoading", ["sap/ui/thirdparty/jquery","sap/ui/Device","sap/ui/base/Object","./ObjectPageSubSection","./library","sap/base/Log","sap/base/util/isEmptyObject"],function(jQuery,e,i,t,o,s,r){"use strict";var n=i.extend("sap.uxap._helpers.LazyLoading",{constructor:function(e){this._oObjectPageLayout=e;this._$html=jQuery("html");this._iPreviousScrollTop=0;this._iScrollProgress=0;this._iPreviousScrollTimestamp=0;this._sLazyLoadingTimer=null;this._bSuppressed=false;this._oPrevSubSectionsInView={};this.setLazyLoadingParameters()},getInterface:function(){return this}});n.prototype.setLazyLoadingParameters=function(){this.LAZY_LOADING_DELAY=200;if(this._isPhone()){this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD={FirstRendering:1,ScrollToSection:1}}else if(this._isTablet()){this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD={FirstRendering:2,ScrollToSection:1}}else if(this._isTabletSize()){this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD={FirstRendering:2,ScrollToSection:2}}else{this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD={FirstRendering:3,ScrollToSection:3}}this.LAZY_LOADING_FAST_SCROLLING_THRESHOLD=5};n.prototype.suppress=function(){this._bSuppressed=true};n.prototype.resume=function(){this._bSuppressed=false};n.prototype._triggerVisibleSubSectionsEvents=function(){this._oPrevSubSectionsInView={};this._oObjectPageLayout._requestAdjustLayout(true);this.doLazyLoading()};n.prototype.lazyLoadDuringScroll=function(e,i,t,o){var r,n,a=false;if(this._bSuppressed){return}if(e){if(this._sLazyLoadingTimer){clearTimeout(this._sLazyLoadingTimer)}this._sLazyLoadingTimer=null;this.doLazyLoading();return}this._iScrollProgress=i-this._iPreviousScrollTop;r=Math.round(Math.abs(this._iScrollProgress)/o*100);if(r>=this.LAZY_LOADING_FAST_SCROLLING_THRESHOLD){a=true}this._iPreviousScrollTop=i;this._iPreviousScrollTimestamp=t||0;n=i===0?0:this.LAZY_LOADING_DELAY;if(a&&this._sLazyLoadingTimer){s.debug("ObjectPageLayout :: lazyLoading","delayed by "+n+" ms because of fast scroll");clearTimeout(this._sLazyLoadingTimer);this._sLazyLoadingTimer=null}if(!this._sLazyLoadingTimer){this._sLazyLoadingTimer=setTimeout(this.doLazyLoading.bind(this),n)}};n.prototype.doLazyLoading=function(){var e=this._oObjectPageLayout._getHeightRelatedParameters(),i=this._oObjectPageLayout.getUseIconTabBar(),t=sap.ui.getCore().byId(this._oObjectPageLayout.getSelectedSection()),o=this._oObjectPageLayout._oSectionInfo,r,n,a,u=this._iPreviousScrollTop>=e.iHeaderContentHeight,c={},_={},h,l,L;if(this._bSuppressed){return}a=e.iScreenHeight-(u?e.iAnchorBarHeight:0)-(u?e.iHeaderTitleHeightStickied:0);r=e.iScrollTop;h=Date.now()-this._iPreviousScrollTimestamp;l=h<this.LAZY_LOADING_DELAY/2&&Math.abs(this._iScrollProgress)>5;if(l){if(this._iScrollProgress>=0){L=Math.round(Math.min(this._iScrollProgress*20,a/2))}else{L=-1*Math.round(Math.min(Math.abs(this._iScrollProgress)*20,a/2))}r+=L;s.debug("ObjectPageLayout :: lazyLoading","Visible page shifted from : "+L)}n=r+a;r+=16;jQuery.each(o,jQuery.proxy(function(e,o){if(!o.isSection&&o.sectionReference.getParent()&&o.sectionReference.getParent().getVisible()){if(i&&t&&t.indexOfSubSection(o.sectionReference)<0){return}if(o.positionTop<=n&&r<o.positionBottom-1){_[e]=e;if(!o.loaded){c[e]=e}}}},this));jQuery.each(c,jQuery.proxy(function(e,i){s.debug("ObjectPageLayout :: lazyLoading","connecting "+i);sap.ui.getCore().byId(i).connectToModels();o[i].loaded=true},this));jQuery.each(_,jQuery.proxy(function(e,i){if(!this._oPrevSubSectionsInView[e]){s.debug("ObjectPageLayout :: lazyLoading","subSectionEnteredViewPort "+i);this._oObjectPageLayout.fireEvent("subSectionEnteredViewPort",{subSection:sap.ui.getCore().byId(i)})}},this));this._oPrevSubSectionsInView=_;if(l){this._sLazyLoadingTimer=setTimeout(this.doLazyLoading.bind(this),this.LAZY_LOADING_DELAY)}else{this._sLazyLoadingTimer=null}};n.prototype.getSubsectionsToPreload=function(e,i){var o,s;if(i){o=this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD.ScrollToSection;s=false}else{o=this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD.FirstRendering;s=true}var r=[];e.some(function(e){if(!s&&i){s=e.getId()==i}if(s&&e instanceof t){if(e.getVisible()&&e._getInternalVisible()){r.push(e);o--}}return o<=0});return r};n.prototype.destroy=function(){if(this._sLazyLoadingTimer){clearTimeout(this._sLazyLoadingTimer)}};n.prototype._isPhone=function(){return o.Utilities.isPhoneScenario(this._oObjectPageLayout._getCurrentMediaContainerRange())};n.prototype._isTablet=function(){return e.system.tablet};n.prototype._isTabletSize=function(){return o.Utilities.isTabletScenario(this._oObjectPageLayout._getCurrentMediaContainerRange())};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/ModelMapping", ["sap/ui/core/Element","./library"],function(e,a){"use strict";var t=e.extend("sap.uxap.ModelMapping",{metadata:{library:"sap.uxap",properties:{externalModelName:{type:"string",group:"Misc",defaultValue:null},internalModelName:{type:"string",group:"Misc",defaultValue:"Model"},externalPath:{type:"string",group:"Misc",defaultValue:null}}}});return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/ObjectImageHelper", ["sap/ui/base/ManagedObject","sap/ui/core/IconPool","sap/m/Avatar","sap/m/Image"],function(e,a,t,c){"use strict";var n=function(){};n.createObjectImage=function(a){var t,r=a.getObjectImageURI();if(r.indexOf("sap-icon://")===0){t=n.instantiateAvatar(r);t.addStyleClass("sapUxAPObjectPageHeaderObjectImageIcon")}else{t=new c({densityAware:a.getObjectImageDensityAware(),alt:e.escapeSettingsValue(a.getObjectImageAlt()),decorative:false,mode:"Background",backgroundSize:"cover",backgroundPosition:"center"});t.addStyleClass("sapUxAPObjectPageHeaderObjectImage");t.setSrc(r)}if(a.getObjectImageAlt()){t.setTooltip(a.getObjectImageAlt())}return t};n.instantiateAvatar=function(e){return new t({displaySize:"L",fallbackIcon:e})};n.createPlaceholder=function(){return n.instantiateAvatar(a.getIconURI("picture"))};n.updateAvatarInstance=function(e,a,t){e.setDisplayShape(a);e.setBackgroundColor(t)};n._renderImageAndPlaceholder=function(e,a){var t=a.oHeader,c=a.oObjectImage,r=a.oPlaceholder,s=a.bIsObjectIconAlwaysVisible,o=a.bAddSubContainer,l=a.sBaseClass,d=t.getObjectImageShape(),i=t.getObjectImageBackgroundColor(),g=t.getShowPlaceholder()&&!t.getObjectImageURI(),b=c.isA("sap.m.Avatar");if(t.getShowPlaceholder()){n.updateAvatarInstance(r,d,i)}if(t.getObjectImageURI()||t.getShowPlaceholder()){e.openStart("span").class(l).class("sapUxAPObjectPageHeaderObjectImage-"+d);if(s){e.class("sapUxAPObjectPageHeaderObjectImageForce")}e.openEnd();if(o){e.openStart("span").class("sapUxAPObjectPageHeaderObjectImageContainerSub").openEnd()}if(b){n.updateAvatarInstance(c,d,i);e.openStart("div").class("sapUxAPObjectPageHeaderObjectImage").class("sapUxAPObjectPageHeaderPlaceholder").openEnd()}if(t.getObjectImageURI()){e.renderControl(c)}n._renderPlaceholder(e,r,g);if(b){e.close("div")}if(o){e.close("span")}e.close("span")}};n._renderPlaceholder=function(e,a,t){e.openStart("div").class("sapUxAPObjectPageHeaderPlaceholder").class("sapUxAPObjectPageHeaderObjectImage");if(!t){e.class("sapUxAPHidePlaceholder")}e.openEnd();e.renderControl(a);e.close("div")};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/ObjectPageAccessibleLandmarkInfo", ["sap/ui/core/Element","./library"],function(e,a){"use strict";var l=e.extend("sap.uxap.ObjectPageAccessibleLandmarkInfo",{metadata:{library:"sap.uxap",properties:{rootRole:{type:"sap.ui.core.AccessibleLandmarkRole",defaultValue:"Main"},rootLabel:{type:"string",defaultValue:null},contentRole:{type:"sap.ui.core.AccessibleLandmarkRole",defaultValue:"None"},contentLabel:{type:"string",defaultValue:null},navigationRole:{type:"sap.ui.core.AccessibleLandmarkRole",defaultValue:"Navigation"},navigationLabel:{type:"string",defaultValue:null},headerRole:{type:"sap.ui.core.AccessibleLandmarkRole",defaultValue:"Banner"},headerLabel:{type:"string",defaultValue:null},footerRole:{type:"sap.ui.core.AccessibleLandmarkRole",defaultValue:"Region"},footerLabel:{type:"string",defaultValue:null}}}});return l});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/ObjectPageDynamicHeaderContent", ["./library","./ObjectPageDynamicHeaderContentRenderer","sap/f/DynamicPageHeader"],function(e,t,n){"use strict";var r=n.extend("sap.uxap.ObjectPageDynamicHeaderContent",{metadata:{interfaces:["sap.uxap.IHeaderContent"],library:"sap.uxap"},renderer:t});r.createInstance=function(e,t,n,a,i){return new r({content:e,visible:t,pinnable:a,id:i})};r.prototype.supportsPinUnpin=function(){return true};r.prototype.supportsChildPageDesign=function(){return false};r.prototype.supportsAlwaysExpanded=function(){return false};r.prototype.setContentDesign=function(e){};r.prototype.setVisible=function(e){this.getParent()&&this.getParent().toggleStyleClass("sapUxAPObjectPageLayoutNoHeaderContent",!e);return this.setProperty("visible",e)};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/ObjectPageDynamicHeaderContentRenderer", ["sap/ui/core/Renderer","sap/f/DynamicPageHeaderRenderer"],function(e,r){"use strict";var n=e.extend(r);n.apiVersion=2;return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/ObjectPageDynamicHeaderTitle", ["./library","sap/uxap/ObjectPageDynamicHeaderContent","./ObjectPageDynamicHeaderTitleRenderer","sap/base/Log","sap/f/DynamicPageTitle"],function(e,t,a,r,n){"use strict";var p=n.extend("sap.uxap.ObjectPageDynamicHeaderTitle",{metadata:{interfaces:["sap.uxap.IHeaderTitle"],library:"sap.uxap"},renderer:a});p.prototype.isDynamic=function(){return true};p.prototype.getCompatibleHeaderContentClass=function(){return t};p.prototype.supportsToggleHeaderOnTitleClick=function(){return true};p.prototype.supportsTitleInHeaderContent=function(){return false};p.prototype.supportsAdaptLayoutForDomElement=function(){return false};p.prototype.supportsBackgroundDesign=function(){return true};p.KNOWN_HEADING_CONTROL_CLASS_NAMES=["sap.m.Title","sap.m.Text","sap.m.FormattedText","sap.m.Label"];p.prototype.getTitleText=function(){var e=this.getHeading(),t=e&&e.getMetadata().getName();if(p.KNOWN_HEADING_CONTROL_CLASS_NAMES.indexOf(t)>-1){return e.getText()}};p.prototype.getHeaderDesign=function(){return e.ObjectPageHeaderDesign.Light};p.prototype.snap=function(e){this._toggleState(false,e);this._updateARIAState(false)};p.prototype.unSnap=function(e){this._toggleState(true,e);this._updateARIAState(true)};p.prototype._adaptObjectPageHeaderIndentifierLine=function(e,t){};return p});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/ObjectPageDynamicHeaderTitleRenderer", ["sap/ui/core/Renderer","sap/f/DynamicPageTitleRenderer"],function(e,r){"use strict";var i=e.extend(r);i.apiVersion=2;return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/ObjectPageHeader", ["sap/ui/thirdparty/jquery","sap/ui/core/Control","sap/ui/core/IconPool","sap/ui/core/CustomData","sap/ui/Device","sap/m/Breadcrumbs","./ObjectPageHeaderActionButton","sap/ui/core/ResizeHandler","sap/m/Button","sap/m/ActionSheet","./ObjectImageHelper","./ObjectPageHeaderContent","./library","sap/m/library","./ObjectPageHeaderRenderer"],function(jQuery,t,e,i,o,n,a,r,s,l,c,u,p,h,g){"use strict";var d=p.Importance;var f=h.ButtonType;var _=h.PlacementType;var y=p.ObjectPageHeaderDesign;var b=h.AvatarShape;var I=h.AvatarColor;function A(t){return typeof t==="function"}var m=t.extend("sap.uxap.ObjectPageHeader",{metadata:{library:"sap.uxap",interfaces:["sap.uxap.IHeaderTitle"],properties:{objectImageURI:{type:"string",defaultValue:null},objectImageAlt:{type:"string",defaultValue:""},objectImageDensityAware:{type:"boolean",defaultValue:false},objectTitle:{type:"string",defaultValue:null},objectSubtitle:{type:"string",defaultValue:null},objectImageShape:{type:"sap.m.AvatarShape",group:"Appearance",defaultValue:b.Square},objectImageBackgroundColor:{type:"sap.m.AvatarColor",group:"Appearance",defaultValue:I.Accent6},isObjectIconAlwaysVisible:{type:"boolean",defaultValue:false},isObjectTitleAlwaysVisible:{type:"boolean",defaultValue:true},isObjectSubtitleAlwaysVisible:{type:"boolean",defaultValue:true},isActionAreaAlwaysVisible:{type:"boolean",defaultValue:true},headerDesign:{type:"sap.uxap.ObjectPageHeaderDesign",defaultValue:y.Light,deprecated:true},showTitleSelector:{type:"boolean",group:"Misc",defaultValue:false},markFavorite:{type:"boolean",group:"Misc",defaultValue:false},markFlagged:{type:"boolean",group:"Misc",defaultValue:false},showMarkers:{type:"boolean",group:"Misc",defaultValue:false},markLocked:{type:"boolean",group:"Misc",defaultValue:false},showPlaceholder:{type:"boolean",group:"Misc",defaultValue:false},markChanges:{type:"boolean",group:"Misc",defaultValue:false}},defaultAggregation:"actions",aggregations:{_breadCrumbs:{type:"sap.m.Breadcrumbs",multiple:false,visibility:"hidden"},breadcrumbs:{type:"sap.m.Breadcrumbs",multiple:false,singularName:"breadcrumb"},breadCrumbsLinks:{type:"sap.m.Link",multiple:true,singularName:"breadCrumbLink",deprecated:true},_overflowButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_expandButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_objectImage:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_placeholder:{type:"sap.m.Avatar",multiple:false,visibility:"hidden"},_lockIconCont:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_lockIcon:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_titleArrowIconCont:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_titleArrowIcon:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_favIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_flagIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_overflowActionSheet:{type:"sap.m.ActionSheet",multiple:false,visibility:"hidden"},_changesIconCont:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_changesIcon:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_sideContentBtn:{type:"sap.m.Button",multiple:false,visibility:"hidden"},navigationBar:{type:"sap.m.Bar",multiple:false},actions:{type:"sap.ui.core.Control",multiple:true,singularName:"action"},sideContentButton:{type:"sap.m.Button",multiple:false},titleSelectorTooltip:{type:"sap.ui.core.TooltipBase",altTypes:["string"],multiple:false}},events:{titleSelectorPress:{parameters:{domRef:{type:"string"}}},markLockedPress:{parameters:{domRef:{type:"string"}}},markChangesPress:{parameters:{domRef:{type:"string"}}}},designtime:"sap/uxap/designtime/ObjectPageHeader.designtime"},renderer:g});m.prototype._iAvailablePercentageForActions=.3;m.prototype.init=function(){this._bFirstRendering=true;if(!this.oLibraryResourceBundle){this.oLibraryResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.m")}if(!this.oLibraryResourceBundleOP){this.oLibraryResourceBundleOP=sap.ui.getCore().getLibraryResourceBundle("sap.uxap")}this._oOverflowActionSheet=this._lazyLoadInternalAggregation("_overflowActionSheet",true);this._oOverflowButton=this._lazyLoadInternalAggregation("_overflowButton",true).attachPress(this._handleOverflowButtonPress,this);this._oExpandButton=this._lazyLoadInternalAggregation("_expandButton",true);this._oActionSheetButtonMap={};this._oFlagIcon=this._lazyLoadInternalAggregation("_flagIcon",true);this._oFavIcon=this._lazyLoadInternalAggregation("_favIcon",true);this._oTitleArrowIcon=this._lazyLoadInternalAggregation("_titleArrowIcon",true).attachPress(this._handleArrowPress,this);this._oTitleArrowIconCont=this._lazyLoadInternalAggregation("_titleArrowIconCont",true).attachPress(this._handleArrowPress,this);this._oLockIcon=this._lazyLoadInternalAggregation("_lockIcon",true).attachPress(this._handleLockPress,this);this._oLockIconCont=this._lazyLoadInternalAggregation("_lockIconCont",true).attachPress(this._handleLockPress,this);this._oChangesIcon=this._lazyLoadInternalAggregation("_changesIcon",true).attachPress(this._handleChangesPress,this);this._oChangesIconCont=this._lazyLoadInternalAggregation("_changesIconCont",true).attachPress(this._handleChangesPress,this)};m.getMetadata().forwardAggregation("breadCrumbsLinks",{getter:function(){return this._lazyLoadInternalAggregation("_breadCrumbs")},aggregation:"links"});m.prototype._handleOverflowButtonPress=function(t){this._oOverflowActionSheet.openBy(this._oOverflowButton)};m.prototype._handleArrowPress=function(t){this.fireTitleSelectorPress({domRef:t.getSource().getDomRef()})};m.prototype._handleLockPress=function(t){this.fireMarkLockedPress({domRef:t.getSource().getDomRef()})};m.prototype._handleChangesPress=function(t){this.fireMarkChangesPress({domRef:t.getSource().getDomRef()})};m._internalAggregationFactory={_objectImage:c.createObjectImage,_placeholder:c.createPlaceholder,_overflowActionSheet:function(){return new l({placement:_.Bottom})},_lockIconCont:function(t){return this._getButton(t,"sap-icon://private","lock-cont",t.oLibraryResourceBundleOP.getText("TOOLTIP_OP_LOCK_MARK_VALUE"))},_breadCrumbs:function(t){return new n({links:t.getAggregation("breadCrumbLinks")})},_lockIcon:function(t){return this._getButton(t,"sap-icon://private","lock",t.oLibraryResourceBundleOP.getText("TOOLTIP_OP_LOCK_MARK_VALUE"))},_titleArrowIconCont:function(t){return this._getButton(t,"sap-icon://slim-arrow-down","titleArrow-cont",t.oLibraryResourceBundleOP.getText("OP_SELECT_ARROW_TOOLTIP"))},_titleArrowIcon:function(t){return this._getButton(t,"sap-icon://slim-arrow-down","titleArrow",t.oLibraryResourceBundleOP.getText("OP_SELECT_ARROW_TOOLTIP"))},_favIcon:function(t){return this._getIcon(t,"favorite",t.oLibraryResourceBundleOP.getText("TOOLTIP_OP_FAVORITE_MARK_VALUE"))},_flagIcon:function(t){return this._getIcon(t,"flag",t.oLibraryResourceBundleOP.getText("TOOLTIP_OP_FLAG_MARK_VALUE"))},_overflowButton:function(t){return this._getButton(t,"sap-icon://overflow","overflow",t.oLibraryResourceBundleOP.getText("TOOLTIP_OP_OVERFLOW_BTN"))},_expandButton:function(t){return this._getButton(t,"sap-icon://slim-arrow-down","expand",t.oLibraryResourceBundleOP.getText("TOOLTIP_OP_EXPAND_HEADER_BTN"))},_changesIconCont:function(t){return this._getButton(t,"sap-icon://user-edit","changes-cont",t.oLibraryResourceBundleOP.getText("TOOLTIP_OP_CHANGES_MARK_VALUE"))},_changesIcon:function(t){return this._getButton(t,"sap-icon://user-edit","changes",t.oLibraryResourceBundleOP.getText("TOOLTIP_OP_CHANGES_MARK_VALUE"))},_getIcon:function(t,i,o){return e.createControlByURI({id:this._getParentAugmentedId(t,i),tooltip:o,src:e.getIconURI(i),visible:false})},_getButton:function(t,e,i,o){return new s({id:this._getParentAugmentedId(t,i),tooltip:o,icon:e,type:f.Transparent})},_getParentAugmentedId:function(t,e){return t.getId()+"-"+e}};m.prototype._lazyLoadInternalAggregation=function(t,e){if(!this.getAggregation(t)){this.setAggregation(t,m._internalAggregationFactory[t](this),e)}return this.getAggregation(t)};m.prototype._applyActionProperty=function(t,e){var i=e[0];if(this.getProperty(t)!==i){e.unshift(t);this.setProperty.apply(this,e);if(!this._bFirstRendering){this._notifyParentOfChanges()}}return this};m.prototype._applyObjectImageProperty=function(t,e){var i=e[0];if(this.getProperty(t)!==i){e.unshift(t);this.setProperty.apply(this,e);this._destroyObjectImage();if(!this._bFirstRendering){this._notifyParentOfChanges(true)}}return this};m.prototype._setAggregationTooltip=function(t,e){var i=this.getAggregation(t);if(i){i.setTooltip(e)}return this};m.prototype._setTitleSelectorTooltip=function(t){if(t===null||t===undefined){t=this.oLibraryResourceBundleOP.getText("OP_SELECT_ARROW_TOOLTIP")}this._setAggregationTooltip("_titleArrowIcon",t);this._setAggregationTooltip("_titleArrowIconCont",t);return this};m.prototype.setHeaderDesign=function(t){this.setProperty("headerDesign",t);if(this.getParent()){this.getParent().invalidate()}return this};m.prototype.setObjectTitle=function(t){var e=this.getParent(),i=this.getProperty("objectTitle"),o=i!==t;this._applyActionProperty("objectTitle",Array.prototype.slice.call(arguments));e&&A(e._updateAriaLabels)&&e._updateAriaLabels();if(o&&this.mEventRegistry["_titleChange"]){this.fireEvent("_titleChange",{id:this.getId(),name:"objectTitle",oldValue:i,newValue:t})}return this};var P=["objectSubtitle","showTitleSelector","markLocked","markFavorite","markFlagged","showMarkers","showPlaceholder","markChanges"],v=["objectImageURI","objectImageAlt","objectImageDensityAware","objectImageShape","objectImageBackgroundColor"];var O=function(t){var e="set"+t.charAt(0).toUpperCase()+t.slice(1);m.prototype[e]=function(){var e=Array.prototype.slice.call(arguments);this._applyActionProperty.call(this,t,e);return this}};var T=function(t){var e="set"+t.charAt(0).toUpperCase()+t.slice(1);m.prototype[e]=function(){var e=Array.prototype.slice.call(arguments);this._applyObjectImageProperty.call(this,t,e);return this}};var B=function(t,e,i){var o="set"+t.charAt(0).toUpperCase()+t.slice(1);e[o]=function(){var e=Array.prototype.slice.call(arguments);e.unshift(t);i.setProperty.apply(i,e);return this.setProperty.apply(this,e)}};P.forEach(O);v.forEach(T);m.prototype._destroyObjectImage=function(){var t="_objectImage",e=this.getAggregation(t);if(e){e.destroy();this.setAggregation(t,null)}};m.prototype.onBeforeRendering=function(){var t=this.getSideContentButton(),e=this;if(t&&!t.getTooltip()){t.setTooltip(this.oLibraryResourceBundleOP.getText("TOOLTIP_OP_SHOW_SIDE_CONTENT"))}var i=this.getActions()||[];this._oOverflowActionSheet.removeAllButtons();this._resetActionSheetMap();if(i.length>1||this._hasOneButtonShowText(i)){i.forEach(function(t){if(t instanceof s&&!(t instanceof a)){t._bInternalVisible=t.getVisible();t._getInternalVisible=function(){return this._bInternalVisible};t._setInternalVisible=function(t,e){this.$().toggle(t);if(t!=this._bInternalVisible){this._bInternalVisible=t;if(e){this.invalidate()}}};t.setVisible=function(i){t._setInternalVisible(i,true);s.prototype.setVisible.call(this,i);e._adaptLayout()};t.onAfterRendering=function(){if(!this._getInternalVisible()){this.$().hide()}e._resizeIdentifierLineContainer(e.$())}}if(t instanceof s&&t.getVisible()){var i=this._createActionSheetButton(t);this._oActionSheetButtonMap[t.getId()]=i;this._oOverflowActionSheet.addButton(i);B("text",t,i);B("icon",t,i);B("enabled",t,i);B("type",t,i)}},this)}this._oTitleArrowIcon.setVisible(this.getShowTitleSelector());this._oFavIcon.setVisible(this.getMarkFavorite());this._oFlagIcon.setVisible(this.getMarkFlagged());this._attachDetachActionButtonsHandler(false);if(this._iResizeId){r.deregister(this._iResizeId);this._iResizeId=null}this._bFirstRendering=false};m.prototype._resetActionSheetMap=function(){Object.keys(this._oActionSheetButtonMap).forEach(function(t){this._oActionSheetButtonMap[t].destroy()}.bind(this));this._oActionSheetButtonMap={}};m.prototype._createActionSheetButton=function(t){return new s({press:jQuery.proxy(this._onSeeMoreContentSelect,this),enabled:t.getEnabled(),text:t.getText(),icon:t.getIcon(),type:t.getType(),tooltip:t.getTooltip(),customData:new i({key:"originalId",value:t.getId()})})};m.prototype._handleImageNotFoundError=function(){var t=this._lazyLoadInternalAggregation("_objectImage"),e=this.getParent(),i=e?e.$():this.$();if(this.getShowPlaceholder()){i.find(".sapMImg.sapUxAPObjectPageHeaderObjectImage").hide();i.find(".sapUxAPObjectPageHeaderPlaceholder").removeClass("sapUxAPHidePlaceholder")}else{t.addStyleClass("sapMNoImg")}};m.prototype._clearImageNotFoundHandler=function(){this._lazyLoadInternalAggregation("_objectImage").$().off("error")};m.prototype.onAfterRendering=function(){var t=this._lazyLoadInternalAggregation("_objectImage").$();if(this._adaptLayoutTimeout){clearTimeout(this._adaptLayoutTimeout)}this._adaptLayout();this._clearImageNotFoundHandler();t.on("error",this._handleImageNotFoundError.bind(this));if(!this.getObjectImageURI()){this._handleImageNotFoundError()}if(!this._iResizeId){this._iResizeId=r.register(this,this._onHeaderResize.bind(this))}this._attachDetachActionButtonsHandler(true)};m.prototype._onHeaderResize=function(t){this._adaptLayout();if(this.getParent()&&typeof this.getParent()._onUpdateHeaderTitleSize==="function"){this.getParent()._onUpdateHeaderTitleSize(t)}};m.prototype._attachDetachActionButtonsHandler=function(t){var e=this.getActions()||[];if(e.length<1){return}e.forEach(function(e){if(e instanceof s){var i=this._oActionSheetButtonMap[e.getId()];if(t){e.attachEvent("_change",this._adaptLayoutDelayed,this);if(i){i.attachEvent("_change",this._adaptOverflow,this)}}else{e.detachEvent("_change",this._adaptLayoutDelayed,this);if(i){i.detachEvent("_change",this._adaptOverflow,this)}}}},this)};m.prototype._onSeeMoreContentSelect=function(t){var e=t.getSource(),i=sap.ui.getCore().byId(e.data("originalId"));if(i.firePress){i.firePress({overflowButtonId:this._oOverflowButton.getId(),bInOverflow:true})}this._oOverflowActionSheet.close()};m._actionImportanceMap={Low:3,Medium:2,High:1};m._sortActionsByImportance=function(t,e){var i=t instanceof a?t.getImportance():d.High,o=e instanceof a?e.getImportance():d.High,n=m._actionImportanceMap[i]-m._actionImportanceMap[o];if(n===0){return t.position-e.position}return n};m.prototype._hasOneButtonShowText=function(t){var e=false;if(t.length!==1){return e}if(t[0]instanceof a){e=!t[0].getHideText()&&t[0].getText()!=""}else if(t[0]instanceof s){e=t[0].getText()!=""}return e};m.prototype._adaptLayout=function(t){var e=this.$("identifierLine"),i=e.width(),n=this._getActionsWidth(),r=n/i,l=this._iAvailablePercentageForActions*i,c=this._oOverflowButton.$();if(i===0){return}if(r>this._iAvailablePercentageForActions){this._adaptActions(l)}else if(t&&t.getSource()instanceof a){t.getSource()._setInternalVisible(true)}if(o.system.phone){this.getActions().forEach(function(t){if(t instanceof s){t.$().css("visibility","visible")}})}var u=this.$("actions");var p=u.find(".sapMBtn").not(".sapUxAPObjectPageHeaderExpandButton");if(p.filter(":visible").length===p.length){c.hide()}this._adaptObjectPageHeaderIndentifierLine(this.$())};m.prototype._adaptLayoutDelayed=function(){if(this._adaptLayoutTimeout){clearTimeout(this._adaptLayoutTimeout)}this._adaptLayoutTimeout=setTimeout(function(){this._adaptLayoutTimeout=null;this._adaptLayout()}.bind(this),0)};m.prototype._adaptObjectPageHeaderIndentifierLine=function(t){var e=this._findById(t,"identifierLine"),i=e.find(".sapUxAPObjectPageHeaderIdentifierTitle");this._adaptObjectPageHeaderTitle(i);this._resizeIdentifierLineContainer(t)};m.prototype._resizeIdentifierLineContainer=function(t){var e=this._findById(t,"identifierLineContainer"),i=this._findById(t,"actions"),o=this._findById(t,"identifierLine"),n=o.width(),a=t?t.find(".sapUxAPObjectPageHeaderObjectImageContainer"):this.$().find(".sapUxAPObjectPageHeaderObjectImageContainer"),r=i.width()+a.width();e.width((.95-r/n)*100+"%")};m.prototype._adaptObjectPageHeaderTitle=function(t){var e=t.width(),i=t.find(".sapUxAPObjectPageHeaderTitleText"),o=i.length,n;for(var a=0;a<o;a++){n=jQuery(i.get(a));n.toggleClass("sapUxAPObjectPageHeaderTitleTextRestrictedWidth",false);if(n.width()>e){n.toggleClass("sapUxAPObjectPageHeaderTitleTextRestrictedWidth",true)}}};m.prototype._adaptActions=function(t){var e=p.Utilities.isPhoneScenario(this._getCurrentMediaContainerRange())||o.system.phone,i=this._oOverflowButton.$(),n=i.show().width(),a=this.getActions(),r=a.length,s;for(var l=0;l<r;l++){a[l].position=l}a.sort(m._sortActionsByImportance);a.forEach(function(o){s=this._oActionSheetButtonMap[o.getId()];if(s){n+=o.$().width();if(t>n&&!e){this._setActionButtonVisibility(o,true);i.hide()}else{this._setActionButtonVisibility(o,false);i.show()}}},this)};m.prototype._adaptOverflow=function(){var t=this._oOverflowActionSheet.getButtons();var e=t.some(function(t){return t.getVisible()});this._oOverflowButton.$().toggle(e)};m.prototype._setActionButtonVisibility=function(t,e){var i=this._oActionSheetButtonMap[t.getId()];if(i){if(t.getVisible()){t._setInternalVisible(e);i.setVisible(!e)}else{i.setVisible(false)}}};m.prototype._getActionsWidth=function(){var t=0;this.getActions().forEach(function(e){if(e instanceof s){e.$().show();if(o.system.phone){e.$().css("visibility","hidden")}t+=e.$().outerWidth(true)}});return t};m.prototype._findById=function(t,e){var i;if(!e||!t){return null}e=this.getId()+"-"+e;i="#"+e.replace(/(:|\.)/g,"\\$1");return t.find(i)};m.prototype._getBreadcrumbsAggregation=function(){var t=this.getBreadcrumbs(),e=this._lazyLoadInternalAggregation("_breadCrumbs",true);return t||(e&&e.getLinks().length?e:null)};m.prototype._notifyParentOfChanges=function(t){var e=this.getParent();if(e&&typeof e._headerTitleChangeHandler==="function"){e._headerTitleChangeHandler(t)}};m.prototype.setTitleSelectorTooltip=function(t){this._setTitleSelectorTooltip(t);this.setAggregation("titleSelectorTooltip",t,true);return this};m.prototype.destroyTitleSelectorTooltip=function(){this._setTitleSelectorTooltip(null);this.destroyAggregation("titleSelectorTooltip",true);return this};m.prototype.exit=function(){this._clearImageNotFoundHandler();if(this._iResizeId){r.deregister(this._iResizeId);this._iResizeId=null}this._resetActionSheetMap()};m.prototype.setNavigationBar=function(t){this.setAggregation("navigationBar",t);if(t&&this.mEventRegistry["_adaptableContentChange"]){this.fireEvent("_adaptableContentChange",{parent:this,adaptableContent:t})}return this};m.prototype._getAdaptableContent=function(){return this.getNavigationBar()};m.prototype.isDynamic=function(){return false};m.prototype.getCompatibleHeaderContentClass=function(){return u};m.prototype.supportsToggleHeaderOnTitleClick=function(){return false};m.prototype.supportsTitleInHeaderContent=function(){return true};m.prototype.supportsAdaptLayoutForDomElement=function(){return true};m.prototype.supportsBackgroundDesign=function(){return false};m.prototype.getTitleText=function(){return this.getObjectTitle()};m.prototype.snap=function(){this._adaptLayout()};m.prototype.unSnap=function(){this._adaptLayout()};m.prototype._toggleExpandButton=function(t){};m.prototype._setShowExpandButton=function(t){};m.prototype._focusExpandButton=function(){};m.prototype._toggleFocusableState=function(t){};return m});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/ObjectPageHeaderActionButton", ["sap/m/Button","./library","./ObjectPageHeaderActionButtonRenderer"],function(e,t,n){"use strict";var i=e.extend("sap.uxap.ObjectPageHeaderActionButton",{metadata:{interfaces:["sap.m.IOverflowToolbarContent"],library:"sap.uxap",properties:{hideText:{type:"boolean",defaultValue:true},hideIcon:{type:"boolean",defaultValue:false},importance:{type:"sap.uxap.Importance",group:"Behavior",defaultValue:t.Importance.High}},designtime:"sap/uxap/designtime/ObjectPageHeaderActionButton.designtime"},renderer:n});i.prototype.init=function(){e.prototype.init.call(this);this._bInternalVisible=this.getVisible();this._bInternalHiddenText=this.getHideText()};i.prototype.onAfterRendering=function(){if(!this._getInternalVisible()){this.$().hide()}};i.prototype._getText=function(){if(this._bInternalHiddenText&&this.getHideText()){return""}return this.getText()};i.prototype.setHideText=function(e,t){this.setProperty("hideText",e,t);this._bInternalHiddenText=e;return this};i.prototype.setHideIcon=function(e,t){this.toggleStyleClass("sapUxAPObjectPageHeaderActionButtonHideIcon",e);return this.setProperty("hideIcon",e,t)};i.prototype._setInternalVisible=function(e,t){this.$().toggle(e);if(e!=this._bInternalVisible){this._bInternalVisible=e;if(t){this.invalidate()}}};i.prototype.setVisible=function(t){var n=e.prototype.setVisible.apply(this,arguments);this.getParent()&&this.getParent().invalidate();return n};i.prototype._getInternalVisible=function(){return this._bInternalVisible};i.prototype.getOverflowToolbarConfig=function(){var e={canOverflow:true,propsUnrelatedToSize:["importance"],getCustomImportance:function(){return this.getImportance()}.bind(this)};e.onBeforeEnterOverflow=function(e){e._bInternalHiddenText=false;e.toggleStyleClass("sapUxAPObjectPageHeaderActionButtonHideIcon",false,true)};e.onAfterExitOverflow=function(e){e._bInternalHiddenText=e.getHideText();e.toggleStyleClass("sapUxAPObjectPageHeaderActionButtonHideIcon",e.getHideIcon(),true)};return e};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/ObjectPageHeaderActionButtonRenderer", ["sap/m/ButtonRenderer","sap/ui/core/Renderer"],function(e,r){"use strict";var n=r.extend(e);n.apiVersion=2;return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/ObjectPageHeaderContent", ["sap/ui/core/Control","./library","sap/m/Button","./ObjectImageHelper","./ObjectPageHeaderContentRenderer"],function(e,t,a,r,n){"use strict";var o=t.ObjectPageHeaderDesign;var i=e.extend("sap.uxap.ObjectPageHeaderContent",{metadata:{library:"sap.uxap",interfaces:["sap.uxap.IHeaderContent"],properties:{contentDesign:{type:"sap.uxap.ObjectPageHeaderDesign",group:"Misc",defaultValue:o.Light,deprecated:true}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},_editHeaderButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_objectImage:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_placeholder:{type:"sap.m.Avatar",multiple:false,visibility:"hidden"}}},renderer:n});i.prototype.onBeforeRendering=function(){var e=this.getParent(),a=this.getAggregation("_editHeaderButton");if(a){return}if(e&&e instanceof t.ObjectPageLayout&&e.getShowEditHeaderButton()){a=this._getInternalBtnAggregation("_editHeaderButton","EDIT_HEADER","-editHeaderBtn","Transparent");a.attachPress(this._handleEditHeaderButtonPress,this)}};i.prototype.exit=function(){var e=this.getAggregation("_editHeaderButton");if(e){e.detachPress(this._handleEditHeaderButtonPress,this)}};i.prototype._handleEditHeaderButtonPress=function(e){this.getParent().fireEditHeaderButtonPress()};i.prototype._getInternalBtnAggregation=function(e,t,r,n){if(!this.getAggregation(e)){var o=new a({text:sap.ui.getCore().getLibraryResourceBundle("sap.uxap").getText(t),type:n,id:this.getId()+r});this.setAggregation(e,o)}return this.getAggregation(e)};i.prototype._getObjectImage=function(){if(!this.getAggregation("_objectImage")){var e=this.getParent(),t=e&&e.getHeaderTitle&&e.getHeaderTitle(),a=t&&r.createObjectImage(t);if(a){this.setAggregation("_objectImage",a,true)}}return this.getAggregation("_objectImage")};i.prototype._destroyObjectImage=function(e){var t=this.getAggregation("_objectImage");if(t){t.destroy();this.getAggregation("_objectImage",null,e)}};i.prototype._getPlaceholder=function(){if(!this.getAggregation("_placeholder")){var e=this.getParent(),t=e&&e.getHeaderTitle&&e.getHeaderTitle(),a=t.getShowPlaceholder();var n=a&&r.createPlaceholder();if(n){this.setAggregation("_placeholder",n,true)}}return this.getAggregation("_placeholder")};i.prototype._getLayoutDataForControl=function(e){var a=e.getLayoutData();if(!a){return}else if(a instanceof t.ObjectPageHeaderLayoutData){return a}else if(a.getMetadata().getName()=="sap.ui.core.VariantLayoutData"){var r=a.getMultipleLayoutData();for(var n=0;n<r.length;n++){var o=r[n];if(o instanceof t.ObjectPageHeaderLayoutData){return o}}}};i.prototype.setVisible=function(e){this.getParent()&&this.getParent().toggleStyleClass("sapUxAPObjectPageLayoutNoHeaderContent",!e);return this.setProperty("visible",e)};i.createInstance=function(e,t,a,r,n){return new i({content:e,visible:t,id:n})};i.prototype.supportsPinUnpin=function(){return false};i.prototype.supportsChildPageDesign=function(){return true};i.prototype.supportsAlwaysExpanded=function(){return true};i.prototype._toggleCollapseButton=function(e){};i.prototype._setShowCollapseButton=function(e){};i.prototype._focusCollapseButton=function(){};i.prototype._focusPinButton=function(){};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/ObjectPageHeaderContentRenderer", ["./ObjectPageHeaderRenderer","./ObjectImageHelper"],function(e,t){"use strict";var a={apiVersion:2};a.render=function(e,t){var a=t.getParent(),n=a&&a.isA("sap.uxap.ObjectPageLayout"),s=a&&n?a.getHeaderTitle():undefined,r=a&&n?a.isA("sap.uxap.ObjectPageLayout")&&a.getShowTitleInHeaderContent():false,o=n&&a.getShowEditHeaderButton()&&t.getContent()&&t.getContent().length>0;if(o){e.openStart("div",t).class("sapUxAPObjectPageHeaderContentFlexBox").class("sapUxAPObjectPageHeaderContentDesign-"+t.getContentDesign());if(s){e.class("sapUxAPObjectPageContentObjectImage-"+s.getObjectImageShape())}e.openEnd()}e.openStart("div",o?undefined:t);if(o){e.class("sapUxAPObjectPageHeaderContentCellLeft")}else{e.class("sapUxAPObjectPageHeaderContentDesign-"+t.getContentDesign());if(s){e.class("sapUxAPObjectPageContentObjectImage-"+s.getObjectImageShape())}}e.class("sapContrastPlus").class("ui-helper-clearfix").class("sapUxAPObjectPageHeaderContent");if(!t.getVisible()){e.class("sapUxAPObjectPageHeaderContentHidden")}e.openEnd();if(n&&a.getIsChildPage()){e.openStart("div").class("sapUxAPObjectChildPage").openEnd().close("div")}if(r){this._renderTitleImage(e,t,s);if(t.getContent().length==0){e.openStart("span").class("sapUxAPObjectPageHeaderContentItem").openEnd();this._renderTitle(e,s);e.close("span")}}t.getContent().forEach(function(a,n){this._renderHeaderContentItem(a,n,e,r,s,t)},this);e.close("div");if(o){this._renderEditButton(e,t);e.close("div")}};a._renderHeaderContentItem=function(e,t,a,n,s,r){var o=false,i=false,d=r._getLayoutDataForControl(e),l=t===0;if(d){o=d.getShowSeparatorBefore();i=d.getShowSeparatorAfter();a.openStart("span").class("sapUxAPObjectPageHeaderWidthContainer").class("sapUxAPObjectPageHeaderContentItem").style("width",d.getWidth());if(i||o){a.class("sapUxAPObjectPageHeaderSeparatorContainer")}if(!d.getVisibleL()){a.class("sapUxAPObjectPageHeaderLayoutHiddenL")}if(!d.getVisibleM()){a.class("sapUxAPObjectPageHeaderLayoutHiddenM")}if(!d.getVisibleS()){a.class("sapUxAPObjectPageHeaderLayoutHiddenS")}a.openEnd();if(o){a.openStart("span").class("sapUxAPObjectPageHeaderSeparatorBefore").openEnd().close("span")}if(l&&n){this._renderTitle(a,s)}}else{if(l&&n){a.openStart("span").class("sapUxAPObjectPageHeaderContentItem").openEnd();this._renderTitle(a,s)}else{e.addStyleClass("sapUxAPObjectPageHeaderContentItem")}}a.renderControl(e);if(i){a.openStart("span").class("sapUxAPObjectPageHeaderSeparatorAfter").openEnd().close("span")}if(d||l&&n){a.close("span")}};a._renderTitleImage=function(e,a,n){t._renderImageAndPlaceholder(e,{oHeader:n,oObjectImage:a._getObjectImage(),oPlaceholder:a._getPlaceholder(),bIsObjectIconAlwaysVisible:false,bAddSubContainer:false,sBaseClass:"sapUxAPObjectPageHeaderContentImageContainer"})};a._renderTitle=function(t,a){e._renderObjectPageTitle(t,a,true)};a._renderEditButton=function(e,t){e.openStart("div").class("sapUxAPObjectPageHeaderContentCellRight").openEnd();e.renderControl(t.getAggregation("_editHeaderButton"));e.close("div")};return a},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/ObjectPageHeaderLayoutData", ["sap/ui/core/LayoutData","./library"],function(e,a){"use strict";var t=e.extend("sap.uxap.ObjectPageHeaderLayoutData",{metadata:{library:"sap.uxap",properties:{visibleS:{type:"boolean",group:"Misc",defaultValue:true},visibleM:{type:"boolean",group:"Misc",defaultValue:true},visibleL:{type:"boolean",group:"Misc",defaultValue:true},showSeparatorBefore:{type:"boolean",group:"Misc",defaultValue:false},showSeparatorAfter:{type:"boolean",group:"Misc",defaultValue:false},width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:"auto"}}}});
/*!
	 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
	 */return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/ObjectPageHeaderRenderer", ["./ObjectImageHelper","sap/ui/Device"],function(e,t){"use strict";var a={apiVersion:2};a.render=function(a,r){var n=r.getNavigationBar(),s=r.getIsObjectIconAlwaysVisible()||r.getIsObjectTitleAlwaysVisible()||r.getIsObjectSubtitleAlwaysVisible()||r.getIsActionAreaAlwaysVisible(),o=r.getParent(),i=r.getAggregation("_expandButton"),l=r._lazyLoadInternalAggregation("_objectImage",true),c,d=t.system.desktop,g=o&&o.isA("sap.uxap.ObjectPageLayout")&&(o.getHeaderContent()&&o.getHeaderContent().length>0&&o.getShowHeaderContent()||o.getShowHeaderContent()&&o.getShowTitleInHeaderContent());a.openStart("div",r).class("sapUxAPObjectPageHeader");a.class("sapUxAPObjectPageHeaderDesign-"+r.getHeaderDesign());a.openEnd();if(n){a.openStart("div").class("sapUxAPObjectPageHeaderNavigation").openEnd();a.renderControl(n);a.close("div")}a.openStart("div",r.getId()+"-identifierLine").class("sapUxAPObjectPageHeaderIdentifier");if(s){a.class("sapUxAPObjectPageHeaderIdentifierForce")}a.openEnd();if(o&&o.isA("sap.uxap.ObjectPageLayout")&&o.getIsChildPage()){a.openStart("div").class("sapUxAPObjectChildPage").openEnd().close("div")}if(r.getShowPlaceholder()){c=r._lazyLoadInternalAggregation("_placeholder",true)}e._renderImageAndPlaceholder(a,{oHeader:r,oObjectImage:l,oPlaceholder:c,bIsObjectIconAlwaysVisible:r.getIsObjectIconAlwaysVisible(),bAddSubContainer:true,sBaseClass:"sapUxAPObjectPageHeaderObjectImageContainer"});a.openStart("span",r.getId()+"-identifierLineContainer").class("sapUxAPObjectPageHeaderIdentifierContainer").openEnd();this._renderObjectPageTitle(a,r);a.close("span");a.openStart("span",r.getId()+"-actions").class("sapUxAPObjectPageHeaderIdentifierActions");if(r.getIsActionAreaAlwaysVisible()){a.class("sapUxAPObjectPageHeaderIdentifierActionsForce")}a.openEnd();if(d&&g){i.addStyleClass("sapUxAPObjectPageHeaderExpandButton");a.renderControl(i)}var p=r.getActions();for(var b=0;b<p.length;b++){var A=p[b];a.renderControl(A)}var P=r.getAggregation("_overflowButton");a.renderControl(P);this._renderSideContentBtn(a,r);a.close("span");a.close("div");a.close("div")};a._renderObjectPageTitle=function(e,t,a){var r=t.getObjectTitle(),n=t.getShowMarkers()&&(t.getMarkFavorite()||t.getMarkFlagged()),s=t._getBreadcrumbsAggregation(),o=t.getTooltip_Text(),i=a?"-content":"";if(!a&&s){e.renderControl(s)}e.openStart("h2",t.getId()+"-title"+i).class("sapUxAPObjectPageHeaderIdentifierTitle");if(t.getIsObjectTitleAlwaysVisible()){e.class("sapUxAPObjectPageHeaderIdentifierTitleForce")}if(a){e.class("sapUxAPObjectPageHeaderIdentifierTitleInContent")}if(t.getShowTitleSelector()){e.class("sapUxAPObjectPageHeaderTitleFollowArrow")}e.openEnd();e.openStart("span",t.getId()+"-innerTitle"+i).class("sapUxAPObjectPageHeaderTitleText").class("sapUxAPObjectPageHeaderTitleTextWrappable");if(o){e.attr("title",o)}e.openEnd();if(n||t.getShowTitleSelector()||t.getMarkLocked()||t.getMarkChanges()){var l=r.substr(r.lastIndexOf(" ")+1);var c=r.substr(0,r.lastIndexOf(" ")+1);if(l.length===1){l=r;c=""}e.text(c);e.close("span");e.openStart("span").class("sapUxAPObjectPageHeaderNowrapMarkers");if(t.getMarkLocked()||t.getMarkChanges()){e.class("sapUxAPObjectPageHeaderMarks")}e.openEnd();e.openStart("span").class("sapUxAPObjectPageHeaderTitleText").openEnd().text(l).close("span");this._renderMarkers(e,t);if(t.getMarkLocked()){this._renderLock(e,t,a)}else if(t.getMarkChanges()){this._renderMarkChanges(e,t,a)}this._renderSelectTitleArrow(e,t,a);e.close("span")}else{e.text(r);e.close("span")}e.close("h2");if(t.getObjectSubtitle()){e.openStart("div",t.getId()+"-subtitle"+i).class("sapUxAPObjectPageHeaderIdentifierDescription");if(t.getIsObjectSubtitleAlwaysVisible()){e.class("sapUxAPObjectPageHeaderIdentifierDescriptionForce")}if(a){e.class("sapUxAPObjectPageHeaderIdentifierSubTitleInContent")}e.openEnd();e.text(t.getObjectSubtitle());e.close("div")}};a._renderSelectTitleArrow=function(e,t,a){if(t.getShowTitleSelector()){e.openStart("span").class("sapUxAPObjectPageHeaderTitleArrow").openEnd();if(a){e.renderControl(t._oTitleArrowIconCont)}else{e.renderControl(t._oTitleArrowIcon)}e.close("span")}};a._renderSideContentBtn=function(e,t){var a=t.getSideContentButton();if(a){e.openStart("span");e.class("sapUxAPObjectPageHeaderSideContentBtn");e.openEnd();e.openStart("span").class("sapUxAPObjectPageHeaderSeparator").openEnd().close("span");e.renderControl(a);e.close("span")}};a._renderMarkChanges=function(e,t,a){e.openStart("span").class("sapUxAPObjectPageHeaderChangesBtn").class("sapUiSizeCompact").openEnd();if(a){e.renderControl(t._oChangesIconCont)}else{e.renderControl(t._oChangesIcon)}e.close("span")};a._renderLock=function(e,t,a){e.openStart("span").class("sapUxAPObjectPageHeaderLockBtn").class("sapUiSizeCompact").openEnd();if(a){e.renderControl(t._oLockIconCont)}else{e.renderControl(t._oLockIcon)}e.close("span")};a._renderMarkers=function(e,t){var a=[];if(t.getShowMarkers()){a.push(t._oFavIcon);a.push(t._oFlagIcon);this._renderMarkersAria(e,t);e.openStart("span",t.getId()+"-markers").class("sapMObjStatusMarker").attr("aria-describedby",t.getId()+"-markers-aria").openEnd();for(var r=0;r<a.length;r++){e.renderControl(a[r])}e.close("span")}};a._renderMarkersAria=function(e,t){var a="";if(t.getMarkFlagged()){a+=t.oLibraryResourceBundle.getText("ARIA_FLAG_MARK_VALUE")+" "}if(t.getMarkFavorite()){a+=t.oLibraryResourceBundle.getText("ARIA_FAVORITE_MARK_VALUE")+" "}if(a!==""){e.openStart("div",t.getId()+"-markers-aria").attr("aria-hidden","false").class("sapUiHidden").openEnd().text(a).close("div")}};return a},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/ObjectPageLayout", ["sap/ui/thirdparty/jquery","sap/ui/base/ManagedObjectObserver","sap/ui/core/ResizeHandler","sap/ui/core/Configuration","sap/ui/core/Control","sap/ui/core/InvisibleText","sap/ui/Device","sap/ui/base/ManagedObject","sap/ui/core/delegate/ScrollEnablement","./ObjectPageSectionBase","./ObjectPageSection","./ObjectPageSubSection","./ObjectPageHeaderContent","./LazyLoading","./ObjectPageLayoutABHelper","./ThrottledTaskHelper","sap/ui/core/library","./library","./ObjectPageLayoutRenderer","sap/base/Log","sap/base/util/array/diff","sap/ui/dom/getScrollbarSize","sap/base/assert","sap/base/util/isEmptyObject","sap/base/util/merge","sap/ui/events/KeyCodes","sap/ui/dom/getFirstEditableInput","sap/ui/dom/units/Rem","sap/ui/base/Object"],function(jQuery,e,t,i,o,n,r,s,a,l,h,c,d,g,u,_,p,f,S,b,y,T,H,A,C,I,P,v,B){"use strict";var O=p.TitleLevel;var L=p.AccessibleLandmarkRole;var E=f.ObjectPageSubSectionLayout;var m=["toggleAnchorBar","_moveHeader"];var R=o.extend("sap.uxap.ObjectPageLayout",{metadata:{library:"sap.uxap",properties:{showAnchorBar:{type:"boolean",defaultValue:true},showAnchorBarPopover:{type:"boolean",defaultValue:true},upperCaseAnchorBar:{type:"boolean",defaultValue:true},backgroundDesignAnchorBar:{type:"sap.m.BackgroundDesign",group:"Appearance"},height:{type:"sap.ui.core.CSSSize",defaultValue:"100%"},enableLazyLoading:{type:"boolean",defaultValue:false},subSectionLayout:{type:"sap.uxap.ObjectPageSubSectionLayout",defaultValue:E.TitleOnTop},sectionTitleLevel:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:O.Auto},useIconTabBar:{type:"boolean",group:"Misc",defaultValue:false},showHeaderContent:{type:"boolean",group:"Misc",defaultValue:true},useTwoColumnsForLargeScreen:{type:"boolean",group:"Appearance",defaultValue:false},showTitleInHeaderContent:{type:"boolean",group:"Appearance",defaultValue:false},showOnlyHighImportance:{type:"boolean",group:"Behavior",defaultValue:false},isChildPage:{type:"boolean",group:"Appearance",defaultValue:false},alwaysShowContentHeader:{type:"boolean",group:"Behavior",defaultValue:false},headerContentPinnable:{type:"boolean",group:"Behavior",defaultValue:true},headerContentPinned:{type:"boolean",group:"Behavior",defaultValue:false},toggleHeaderOnTitleClick:{type:"boolean",group:"Behavior",defaultValue:true},preserveHeaderStateOnScroll:{type:"boolean",group:"Behavior",defaultValue:false},showEditHeaderButton:{type:"boolean",group:"Behavior",defaultValue:false},flexEnabled:{type:"boolean",group:"Misc",defaultValue:false},showFooter:{type:"boolean",group:"Behavior",defaultValue:false}},associations:{selectedSection:{type:"sap.uxap.ObjectPageSection",multiple:false}},defaultAggregation:"sections",aggregations:{sections:{type:"sap.uxap.ObjectPageSection",multiple:true,singularName:"section"},headerTitle:{type:"sap.uxap.IHeaderTitle",multiple:false},headerContent:{type:"sap.ui.core.Control",multiple:true,singularName:"headerContent"},footer:{type:"sap.m.IBar",multiple:false},landmarkInfo:{type:"sap.uxap.ObjectPageAccessibleLandmarkInfo",multiple:false},_anchorBar:{type:"sap.uxap.AnchorBar",multiple:false,visibility:"hidden"},_iconTabBar:{type:"sap.m.IconTabBar",multiple:false,visibility:"hidden"},_headerContent:{type:"sap.uxap.IHeaderContent",multiple:false,visibility:"hidden"}},events:{headerContentPinnedStateChange:{parameters:{pinned:{type:"boolean"}}},toggleAnchorBar:{parameters:{fixed:{type:"boolean"}}},sectionChange:{parameters:{section:{type:"sap.uxap.ObjectPageSection"},subSection:{type:"sap.uxap.ObjectPageSubSection"}}},editHeaderButtonPress:{},beforeNavigate:{allowPreventDefault:true,parameters:{section:{type:"sap.uxap.ObjectPageSection"},subSection:{type:"sap.uxap.ObjectPageSubSection"}}},navigate:{parameters:{section:{type:"sap.uxap.ObjectPageSection"},subSection:{type:"sap.uxap.ObjectPageSubSection"}}},subSectionVisibilityChange:{parameters:{visibleSubSections:{type:"object"}}}},dnd:{draggable:false,droppable:true},designtime:"sap/uxap/designtime/ObjectPageLayout.designtime"},renderer:S});R.HEADER_CALC_DELAY=350;R.DOM_CALC_DELAY=200;R.MAX_SNAP_POSITION_OFFSET=20;R.HEADER_MAX_ALLOWED_NON_SROLLABLE_PERCENTAGE=.6;R.TITLE_LEVEL_AS_ARRAY=Object.keys(O);R.EVENTS={TITLE_PRESS:"_titlePress",TITLE_MOUSE_OVER:"_titleMouseOver",TITLE_MOUSE_OUT:"_titleMouseOut",PIN_UNPIN_PRESS:"_pinUnpinPress",VISUAL_INDICATOR_MOUSE_OVER:"_visualIndicatorMouseOver",VISUAL_INDICATOR_MOUSE_OUT:"_visualIndicatorMouseOut",HEADER_VISUAL_INDICATOR_PRESS:"_headerVisualIndicatorPress",TITLE_VISUAL_INDICATOR_PRESS:"_titleVisualIndicatorPress"};R.BREAK_POINTS={DESKTOP:1439,TABLET:1024,PHONE:600};R.MEDIA={PHONE:"sapUxAPObjectPageLayout-Std-Phone",TABLET:"sapUxAPObjectPageLayout-Std-Tablet",DESKTOP:"sapUxAPObjectPageLayout-Std-Desktop",DESKTOP_XL:"sapUxAPObjectPageLayout-Std-Desktop-XL"};R.DYNAMIC_HEADERS_MEDIA={PHONE:"sapFDynamicPage-Std-Phone",TABLET:"sapFDynamicPage-Std-Tablet",DESKTOP:"sapFDynamicPage-Std-Desktop",DESKTOP_XL:"sapFDynamicPage-Std-Desktop-XL"};R.DIV="div";R.HEADER="header";R.FOOTER="section";R.HEADER_CONTENT_PADDING_BOTTOM=v.toPx("1rem");R.SHOW_FOOTER_CLASS_NAME="sapUxAPObjectPageFloatingFooterShow";R.HIDE_FOOTER_CLASS_NAME="sapUxAPObjectPageFloatingFooterHide";R.NO_NAVIGATION_CLASS_NAME="sapUxAPObjectPageNoNavigation";R.ARIA={LABEL_TOOLBAR_FOOTER_ACTIONS:"ARIA_LABEL_TOOLBAR_FOOTER_ACTIONS"};R.prototype._getFirstEditableInput=function(e){var t=this.getDomRef(e);return P(t)};R.prototype._focusFirstEditableInput=function(e){this._getFirstEditableInput(e).focus()};R._getNextTitleLevelEntry=function(e){var t=R.TITLE_LEVEL_AS_ARRAY.indexOf(e),i=t!==-1,o=i&&t!==R.TITLE_LEVEL_AS_ARRAY.length-1;if(!i){return O.Auto}return R.TITLE_LEVEL_AS_ARRAY[o?t+1:t]};R._getLibraryResourceBundle=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.uxap")};R.prototype.init=function(){this.oCore=sap.ui.getCore();this._bFirstRendering=true;this._bDomReady=false;this._bPinned=false;this._bStickyAnchorBar=false;this._bHeaderInTitleArea=false;this._bHeaderExpanded=true;this._bHeaderBiggerThanAllowedHeight=false;this._bDelayDOMBasedCalculations=true;this._iStoredScrollTop=0;this._oStoredScrolledSubSectionInfo={};this._bAllContentFitsContainer=false;this._bIsFooterAanimationGoing=false;this._bInternalAnchorBarVisible=true;this._oVisibleSubSections=0;this._$footerWrapper=[];this._$opWrapper=[];this._$anchorBar=[];this._$titleArea=[];this._$stickyAnchorBar=[];this._$headerContent=[];this._$stickyHeaderContent=[];this._bMobileScenario=false;this._oSectionInfo={};this._aSectionBases=[];this._sScrolledSectionId="";this._iScrollToSectionDuration=600;this._$spacer=[];this.iHeaderContentHeight=0;this.iStickyHeaderContentHeight=0;this.iHeaderTitleHeight=0;this.iHeaderTitleHeightStickied=0;this.iAnchorBarHeight=0;this.iFooterHeight=0;this.iTotalHeaderSize=0;this._iHeaderContentPaddingBottom=0;this._oScrollContainerLastState={};this._iREMSize=parseInt(jQuery("body").css("font-size"));this._iOffset=parseInt(.25*this._iREMSize);this._iResizeId=null;this._iAfterRenderingDomReadyTimeout=null;this._oABHelper=new u(this);this._initializeScroller();this._attachSnapListeners()};R.prototype.onBeforeRendering=function(){var e,t;this._deregisterScreenSizeListener();this._deregisterTitleSizeListener();if(this._oLazyLoading){this._oLazyLoading.destroy()}this._oLazyLoading=new g(this);this._deregisterCustomEvents();if(!this.getVisible()){return}if(!this.getSelectedSection()){this._bHeaderExpanded=true}this._bMobileScenario=f.Utilities.isPhoneScenario(this._getCurrentMediaContainerRange());this._bTabletScenario=f.Utilities.isTabletScenario(this._getCurrentMediaContainerRange());if(this._checkAlwaysShowContentHeader()){this._bHeaderExpanded=true}this._bHeaderInTitleArea=this._shouldPreserveHeaderInTitleArea();this._createHeaderContent();this._getHeaderContent().setContentDesign(this._getHeaderDesign());this._oABHelper._getAnchorBar().setProperty("upperCase",this.getUpperCaseAnchorBar(),true);this._storeScrollLocation();this._applyUxRules();if(!A(this._oSectionInfo)&&this._bFirstRendering){this._preloadSectionsOnBeforeFirstRendering();this._bFirstRendering=false}this._bStickyAnchorBar=this._shouldPreserveHeaderInTitleArea();this._handleExpandButtonPressEventLifeCycle(false);this._attachTitlePressHandler();e=this._getHeaderContent();if(e&&e.supportsPinUnpin()){t=this.getHeaderContentPinnable()&&!this.getPreserveHeaderStateOnScroll();this._getHeaderContent().setPinnable(t);if(t){this._attachPinPressHandler()}}this._attachVisualIndicatorsPressHandlers(this._handleDynamicTitlePress,this);if(r.system.desktop){this._attachVisualIndicatorMouseOverHandlers(this._addHoverClass,this._removeHoverClass,this);this._attachTitleMouseOverHandlers(this._addHoverClass,this._removeHoverClass,this)}if(this.getFooter()&&this._bIsFooterAanimationGoing){this._onToggleFooterAnimationEnd(this.getFooter())}this._$titleArea=[];this._setFooterAriaLabelledBy()};R.prototype._setFooterAriaLabelledBy=function(){var e=this.getFooter();if(e&&!e.getAriaLabelledBy().length){this._oInvisibleText=new n({id:e.getId()+"-FooterActions-InvisibleText",text:R._getLibraryResourceBundle().getText(R.ARIA.LABEL_TOOLBAR_FOOTER_ACTIONS)}).toStatic();e.addAriaLabelledBy(this._oInvisibleText)}};R.prototype._destroyInvisibleText=function(){if(this._oInvisibleText){this._oInvisibleText.destroy();this._oInvisibleText=null}};R.prototype.setBackgroundDesignAnchorBar=function(e){var t=this.getBackgroundDesignAnchorBar();if(t===e){return this}this.setProperty("backgroundDesignAnchorBar",e);this._oABHelper._getAnchorBar().setBackgroundDesign(e);return this};R.prototype.setToggleHeaderOnTitleClick=function(e){var t=this.getHeaderTitle(),i=this.setProperty("toggleHeaderOnTitleClick",e,true);if(!t||!t.supportsToggleHeaderOnTitleClick()){b.warning("Setting toggleHeaderOnTitleClick will not take effect as it is not supported in the ObjectPageHeader, read the API Doc for more information",this);return i}e=this.getProperty("toggleHeaderOnTitleClick");this._updateToggleHeaderVisualIndicators();this._updateTitleVisualState();return i};R.prototype._attachTitlePressHandler=function(){var e=this.getHeaderTitle();if(D(e)&&!this._bAlreadyAttachedTitlePressHandler){e.attachEvent(R.EVENTS.TITLE_PRESS,this._handleDynamicTitlePress,this);this._bAlreadyAttachedTitlePressHandler=true}};R.prototype._attachSnapListeners=function(){m.forEach(function(e){this.attachEvent(e,function(){this.fireEvent("_snapChange")})},this)};R.prototype._toggleHeaderVisibility=function(e){var t=this._getHeaderContent();if(D(t)){t.$().toggleClass("sapUxAPObjectPageHeaderContentHidden",!e)}};R.prototype._snapHeader=function(e,t){var i,o=this._getHeaderContent();if(o&&o.supportsPinUnpin()&&this._bPinned){this._unPin(t);o.getAggregation("_pinButton").setPressed(false);e=true}this._toggleHeaderTitle(false,true);this._toggleHeaderVisibility(e);this._moveAnchorBarToTitleArea();if(e){this._moveHeaderToContentArea();this._bHeaderExpanded=false;this._updateToggleHeaderVisualIndicators();this._adjustHeaderHeights();this._requestAdjustLayout(true);i=this._$opWrapper.scrollTop()<=this._getSnapPosition()+1;if(i){this._scrollTo(this._getSnapPosition()+1)}return}this._bHeaderExpanded=false;this._updateToggleHeaderVisualIndicators();this._adjustHeaderHeights();this._requestAdjustLayout()};R.prototype._expandHeader=function(e){this._toggleHeaderTitle(true,true);this._toggleHeaderVisibility(true);if(e){this._moveAnchorBarToTitleArea();this._moveHeaderToTitleArea();this._bHeaderExpanded=true;this._updateToggleHeaderVisualIndicators();this._adjustHeaderHeights();this._requestAdjustLayout();return}this._moveAnchorBarToContentArea();this._moveHeaderToContentArea();this._scrollTo(0,0);this._bHeaderExpanded=true;this._adjustHeaderHeights();this._updateToggleHeaderVisualIndicators();if(this._isHeaderPinnable()){this._getHeaderContent()._getPinButton().setVisible(!this._headerBiggerThanAllowedToBeExpandedInTitleArea())}};R.prototype._handleDynamicTitlePress=function(){if(!this.getToggleHeaderOnTitleClick()||!this._hasVisibleDynamicTitleAndHeader()){return}var e=!this._bHeaderExpanded,t,i,o;if(e){t=this._$opWrapper.scrollTop()<=this._getSnapPosition()+1;i=!this._headerBiggerThanAllowedToBeExpandedInTitleArea()&&(this._shouldPreserveHeaderInTitleArea()||!t);this._expandHeader(i);if(!i){this._scrollTo(0,0)}}else{o=!this._shouldPreserveHeaderInTitleArea()&&(!this._bAllContentFitsContainer||this._headerBiggerThanAllowedToBeExpandedInTitleArea());this._snapHeader(o,true)}this.getHeaderTitle()._getFocusSpan().trigger("focus")};R.prototype._attachPinPressHandler=function(){var e=this._getHeaderContent();if(D(e)&&!this._bAlreadyAttachedPinPressHandler){e.attachEvent(R.EVENTS.PIN_UNPIN_PRESS,this._onPinUnpinButtonPress,this);this._bAlreadyAttachedPinPressHandler=true}};R.prototype._handleExpandButtonPressEventLifeCycle=function(e){var t=this.getHeaderTitle(),i=this._hasDynamicTitle(),o;if(t&&!i){o=t.getAggregation("_expandButton");if(o){o[e?"attachPress":"detachPress"](this._handleExpandButtonPress,this)}}};R.prototype._adjustSelectedSectionByUXRules=function(){var e=this.oCore.byId(this.getSelectedSection()),t=e&&this._sectionCanBeRenderedByUXRules(e);if(!t){if(this._oFirstVisibleSection){e=this._oFirstVisibleSection;this.setAssociation("selectedSection",e.getId(),true)}else{this.setAssociation("selectedSection",null,true);return}}};R.prototype._sectionCanBeRenderedByUXRules=function(e){if(!(e instanceof l)){return false}var t=e.getBindingInfo("subSections");if(!t&&(!e.getVisible()||!e._getInternalVisible())){return false}var i=this._aSectionBases.map(function(e){return e.getId()});return i.indexOf(e.getId())>-1};R.prototype._getSectionsToRender=function(){this._adjustSelectedSectionByUXRules();var e=this.oCore.byId(this.getSelectedSection());if(this.getUseIconTabBar()&&e){return[e]}else{return this.getSections()}};R.prototype._preloadSectionsOnBeforeFirstRendering=function(){var e=this._getSectionsToPreloadOnBeforeFirstRendering();this._connectModelsForSections(e);if(this.getEnableLazyLoading()){e.forEach(function(e){this.fireEvent("subSectionPreload",{subSection:e})},this)}};R.prototype._getSectionsToPreloadOnBeforeFirstRendering=function(){var e,t,i;if(!this.getEnableLazyLoading()){return this._getSectionsToRender()}if(this.getUseIconTabBar()){return this._oLazyLoading.getSubsectionsToPreload(this._grepCurrentTabSectionBases())}this._adjustSelectedSectionByUXRules();t=this.oCore.byId(this.getSelectedSection());if(!t||t===this._oFirstVisibleSection){return this._oLazyLoading.getSubsectionsToPreload(this._aSectionBases)}i=this.indexOfSection(t);var o=function(e){var t=e.isA("sap.uxap.ObjectPageSection")?e:e.getParent();return this.indexOfSection(t)>=i}.bind(this);e=this._aSectionBases.filter(o);return this._oLazyLoading.getSubsectionsToPreload(e)};R.prototype._grepCurrentTabSectionBases=function(){var e=[],t,i,o,n;this._adjustSelectedSectionByUXRules();t=this.oCore.byId(this.getSelectedSection());if(t){i=t.getId();this._aSectionBases.forEach(function(t){o=t.getParent();n=o&&o.getId();if(t.getId()===i||n===i){e.push(t)}})}return e};R.prototype.onAfterRendering=function(){var e=this._getHeaderContent(),i=this._getWidth(this);this._bInvalidatedAndNotRerendered=false;this._ensureCorrectParentHeight();this._cacheDomElements();this._iResizeId=t.register(this,this._onUpdateScreenSize.bind(this));this._iTitleResizeId=t.register(this._$titleArea.get(0),this._adjustTitlePositioning.bind(this));if(this._hasDynamicTitle()){this.addStyleClass("sapUxAPObjectPageHasDynamicTitle")}if(i>0){this._updateMedia(i,R.MEDIA)}this._$opWrapper.on("scroll.OPL",this._onScroll.bind(this));if(this._bDomReady&&this.$().parents(":hidden").length===0){this._onAfterRenderingDomReady()}else{if(this._iAfterRenderingDomReadyTimeout){clearTimeout(this._iAfterRenderingDomReadyTimeout)}this._iAfterRenderingDomReadyTimeout=setTimeout(this._onAfterRenderingDomReady.bind(this),this._getDOMCalculationDelay());this._adjustTitlePositioning()}if(e&&e.supportsPinUnpin()){this._updatePinButtonState()}this._handleExpandButtonPressEventLifeCycle(true)};R.prototype._onAfterRenderingDomReady=function(){var e,t,i,o=this._getWidth(this);if(this._bIsBeingDestroyed){return}this._adjustSelectedSectionByUXRules();e=this.getSelectedSection();t=this.oCore.byId(e);this._iAfterRenderingDomReadyTimeout=null;this._bDomReady=true;this._adjustHeaderHeights();this._initAnchorBarScroll();if(e){if(this.getUseIconTabBar()){this._setSelectedSectionId(e);this._setCurrentTabSection(t);this._bAllContentFitsContainer=this._hasSingleVisibleFullscreenSubSection(t);this._checkSubSectionVisibilityChange()}else{this.scrollToSection(e,0)}}this._toggleScrolling(this._shouldAllowScrolling());this._registerOnContentResize();this.getHeaderTitle()&&this._shiftHeaderTitle();this.getFooter()&&this._shiftFooter();this._setSectionsFocusValues();if(this.getPreserveHeaderStateOnScroll()){this._overridePreserveHeaderStateOnScroll()}if(!this._bHeaderExpanded){i=!this._shouldPreserveHeaderInTitleArea()&&!this._bAllContentFitsContainer;this._snapHeader(i)}this._restoreScrollPosition();this.oCore.getEventBus().publish("sap.ui","ControlForPersonalizationRendered",this);this._updateMedia(o,R.MEDIA);if(this._hasDynamicTitle()){this._updateMedia(o,R.DYNAMIC_HEADERS_MEDIA)}this._updateToggleHeaderVisualIndicators();this._updateTitleVisualState();this.fireEvent("onAfterRenderingDOMReady")};R.prototype._toggleScrolling=function(e){if(this._$opWrapper.length){this._$opWrapper.get(0).style.overflowY=e?"auto":"hidden"}};R.prototype._shouldAllowScrolling=function(){return!this._bAllContentFitsContainer||!this._getFirstVisibleSubSection()?._hasRestrictedHeight()};R.prototype._shiftFooter=function(){var e=this.$("footerWrapper"),t=this._calculateShiftOffset();e.css(t.sStyleAttribute,t.iMarginalsOffset+"px")};R.prototype._calculateShiftOffset=function(){var e=0,t=this.oCore.getConfiguration().getRTL()?"left":"right",i=this._hasVerticalScrollBar(),o=this._iOffset,n;if(r.system.desktop){n=T().width;e=n;if(!i){e=0;o+=n}}return{sStyleAttribute:t,iActionsOffset:o,iMarginalsOffset:e}};R.prototype._getDOMCalculationDelay=function(){return this._bDelayDOMBasedCalculations?R.HEADER_CALC_DELAY:0};R.prototype.exit=function(){if(this._oScroller){this._oScroller.destroy();this._oScroller=null}if(this._oLazyLoading){this._oLazyLoading.destroy();this._oLazyLoading=null}this._destroyInvisibleText();this._deregisterScreenSizeListener();this._deregisterTitleSizeListener();if(this._iContentResizeId){t.deregister(this._iContentResizeId)}if(this._iAfterRenderingDomReadyTimeout){clearTimeout(this._iAfterRenderingDomReadyTimeout)}if(this._oObserver){this._oObserver.disconnect();this._oObserver=null}this._deregisterCustomEvents();this._oFirstVisibleSection=null;this._oFirstVisibleSubSection=null};R.prototype.setShowOnlyHighImportance=function(e){var t=this.getShowOnlyHighImportance();if(t!==e){this.setProperty("showOnlyHighImportance",e,true);this.getSections().forEach(function(e){e._updateImportance()})}return this};R.prototype.setIsHeaderContentAlwaysExpanded=function(e){var t=this.getAlwaysShowContentHeader();var i=r.system.phone||r.system.tablet;if(t!==e){this.setProperty("alwaysShowContentHeader",e,i)}return this};R.prototype.setShowEditHeaderButton=function(e){var t=this.getShowEditHeaderButton(),i=this.getAggregation("_headerContent");if(t!==e){this.setProperty("showEditHeaderButton",e,true);i&&i.invalidate()}return this};R.prototype._initializeScroller=function(){if(this._oScroller){return}this._oScroller=new a(this,this.getId()+"-scroll",{horizontal:false,vertical:true});this._oScroller.setOnAfterScrollToElement(this._onAfterScrollToElement.bind(this))};R.prototype._onAfterScrollToElement=function(){var e=this._$opWrapper.scrollTop(),t=this._bStickyAnchorBar;this._onScroll({target:{scrollTop:e}});if(this._bStickyAnchorBar&&!t&&this._$opWrapper.scrollTop()===e){this._$opWrapper.scrollTop(e-this.iAnchorBarHeight)}};R.prototype.setSelectedSection=function(e){var t,i;if(e instanceof l){e=e.getId()}else if(e!=null&&typeof e!=="string"){H(false,"setSelectedSection(): sId must be a string, an instance of sap.uxap.ObjectPageSection or null");return this}if(e===this.getSelectedSection()){return this}if(e===null){this.setAssociation("selectedSection",null,true);this._expandHeader(this._bHeaderInTitleArea);this._selectFirstVisibleSection();return this}this.scrollToSection(e);t=h._getClosestSection(e);i=t instanceof h?t.getId():t;this.setDirectScrollingToSection(i);return this.setAssociation("selectedSection",i,true)};R.prototype._selectFirstVisibleSection=function(){if(this.getUseIconTabBar()&&this._oFirstVisibleSection){this._adjustSelectedSectionByUXRules();this._setCurrentTabSection(this._oFirstVisibleSection);this._bAllContentFitsContainer=this._hasSingleVisibleFullscreenSubSection(this._oFirstVisibleSection);this._preloadSectionsOnBeforeScroll(this._oFirstVisibleSection);this._updateSelectionOnScroll(0);this._checkSubSectionVisibilityChange()}else if(this.$().is(":visible")){this._scrollTo(0,0);if(!this._bInvalidatedAndNotRerendered){this._sScrolledSectionId=null;this._updateSelectionOnScroll(0)}}};R.prototype._ensureCorrectParentHeight=function(){if(this._bCorrectParentHeightIsSet){return}if(this.getParent().getHeight&&["","auto"].indexOf(this.getParent().getHeight())!==-1){this.$().parent().css("height","100%")}this._bCorrectParentHeightIsSet=true};R.prototype._cacheDomElements=function(){this._$footerWrapper=this.$("footerWrapper");this._$titleArea=this.$("headerTitle");this._$anchorBar=this.$("anchorBar");this._$stickyAnchorBar=this.$("stickyAnchorBar");this._$opWrapper=this.$("opwrapper");this._$spacer=this.$("spacer");this._$headerContent=this.$("headerContent");this._$stickyHeaderContent=this.$("stickyHeaderContent");this._$contentContainer=this.$("scroll");this._$sectionsContainer=this.$("sectionsContainer");this._oScroller._$Container=this._$opWrapper;this._bDomElementsCached=true};R.prototype._handleExpandButtonPress=function(e){this._expandHeader(true)};R.prototype._toggleHeaderTitle=function(e,t){var i=this.getHeaderTitle(),o=this._oABHelper._getAnchorBar();if(this._$titleArea.length){this._$titleArea.toggleClass("sapUxAPObjectPageHeaderStickied",!e);this._$titleArea.toggleClass("sapUxAPObjectPageHeaderSnappedTitleOnMobile",this._hasDynamicTitleWithSnappedTitleOnMobile()&&!e)}if(e){i&&i.unSnap(t)}else{i&&i.snap(t)}o.scrollToCurrentlySelectedSection()};R.prototype._moveHeaderToTitleArea=function(){this._$headerContent.children().appendTo(this._$stickyHeaderContent);this._bHeaderInTitleArea=true;this.fireEvent("_moveHeader",{fixed:true});this._bSupressModifyOnScrollOnce=true};R.prototype._moveHeaderToContentArea=function(){if(this._bHeaderInTitleArea){this._$headerContent.append(this._$stickyHeaderContent.children());this._$stickyHeaderContent.children().remove();this._bHeaderInTitleArea=false;this.fireEvent("_moveHeader",{fixed:false})}};R.prototype._updateNavigation=function(){if(this.getShowAnchorBar()){this._oABHelper._buildAnchorBar()}};R.prototype._applyUxRules=function(e){var t,i,o,n,r,s,a,l,h,d,g,u,_={};t=this.getSections()||[];n=0;s=this.getShowAnchorBar();a=this.getUseIconTabBar();l=null;this._cleanMemory();t.forEach(function(t){if(!t.getVisible()){return true}this._registerSectionBaseInfo(t);i=t.getSubSections()||[];o=0;h=null;i.forEach(function(t){if(!t.getVisible()){return true}this._registerSectionBaseInfo(t);r=t.getVisibleBlocksCount();if(r===0){t._setInternalVisible(false,e);b.info("ObjectPageLayout :: noVisibleBlock UX rule matched","subSection "+t.getTitle()+" forced to hidden")}else{t._setInternalVisible(true,e);_[t.getId()]=true;o++;if(!h){h=t}if(this._shouldApplySectionTitleLevel(t)){t._setInternalTitleLevel(this._determineSectionBaseInternalTitleLevel(t,!l),e)}}},this);if(o>1){i.forEach(function(e){e._setBorrowedTitleDomId("")})}if(o==0){t._setInternalVisible(false,e);b.info("ObjectPageLayout :: noVisibleSubSection UX rule matched","section "+t.getTitle()+" forced to hidden")}else{t._setInternalVisible(true,e);_[t.getId()]=true;if(!l){l=t;u=o}if(this.getSubSectionLayout()===E.TitleOnTop&&o===1&&h.getTitle().trim()!==""){b.info("ObjectPageLayout :: TitleOnTop.sectionGetSingleSubSectionTitle UX rule matched","section "+t.getTitle()+" is taking its single subsection title "+h.getTitle());t._setInternalTitle(h.getTitle(),e);_[h.getId()]=false;h._setBorrowedTitleDomId(t.getId()+"-title")}else{t._setInternalTitle("",e)}if(o===1&&!h.getTitle().trim()){h._setBorrowedTitleDomId(t.getId()+"-title")}if(this._shouldApplySectionTitleLevel(t)){t._setInternalTitleLevel(this._determineSectionBaseInternalTitleLevel(t),e)}n++}if(a){_[t.getId()]=false}},this);if(n<=1){s=false;b.info("ObjectPageLayout :: notEnoughVisibleSection UX rule matched","anchorBar forced to hidden");if(a&&l){_[l.getId()]=true}}else if(l&&s){d=true;_[l.getId()]=false;b.info("ObjectPageLayout :: firstSectionTitleHidden UX rule matched","section "+l.getTitle()+" title forced to hidden")}this.toggleStyleClass(R.NO_NAVIGATION_CLASS_NAME,n<=1);Object.keys(_).forEach(function(t){this.oCore.byId(t)._setInternalTitleVisible(_[t],e)}.bind(this));if(s){this._oABHelper._buildAnchorBar()}this._setInternalAnchorBarVisible(s,e);this._oFirstVisibleSection=l;this._oFirstVisibleSubSection=this._getFirstVisibleSubSection(l);this._bAllContentFitsContainer=n===1&&o===1&&this._oFirstVisibleSubSection.hasStyleClass(c.FIT_CONTAINER_CLASS);if(d&&u===1){g=this.getAggregation("_anchorBar").getContent();if(g.length){this._oFirstVisibleSubSection._setBorrowedTitleDomId(g[0].getId()+"-content")}}this._checkSubSectionVisibilityChange()};R.prototype._checkSubSectionVisibilityChange=function(){var e=this.getUseIconTabBar(),t=e&&sap.ui.getCore().byId(this.getSelectedSection()),i=t?[t]:this._getVisibleSections(),o={},n;i.forEach(function(e){e.getSubSections().forEach(function(e){n=e.getVisible()&&e._getInternalVisible();if(n){o[e.getId()]=e}})});if(y(Object.keys(this._oVisibleSubSections),Object.keys(o)).length){this._oVisibleSubSections=o;this.fireEvent("subSectionVisibilityChange",{visibleSubSections:o})}};R.prototype.setUseIconTabBar=function(e){var t=this.getUseIconTabBar();if(e!=t){this._applyUxRules()}this.setProperty("useIconTabBar",e);this.toggleStyleClass("sapUxAPObjectPageLayoutIconTabBar",e);return this};R.prototype._setCurrentTabSection=function(e,t){if(!e){return}var i;if(B.isObjectA(e,"sap.uxap.ObjectPageSubSection")){i=e;e=e.getParent()}else{i=this._getFirstVisibleSubSection(e)}if(this._oCurrentTabSection!==e){this._renderSection(e);this._oCurrentTabSection=e}this._oCurrentTabSubSection=i};R.prototype._renderSection=function(e){var t=this.$().find(".sapUxAPObjectPageContainer"),i;if(e&&t.length){i=this.oCore.createRenderManager();this.getSections().forEach(function(t){if(t.getId()===e.getId()){i.renderControl(e)}else{i.cleanupControlWithoutRendering(t)}});i.flush(t[0]);i.destroy()}};R.prototype.setShowAnchorBarPopover=function(e,t){var i=this.getProperty("showAnchorBarPopover"),e=this.validateProperty("showAnchorBarPopover",e),o=this.getSelectedSection();if(e===i){return this}this._oABHelper._getAnchorBar().setShowPopover(e);this._oABHelper._buildAnchorBar();this._setSelectedSectionId(o);return this.setProperty("showAnchorBarPopover",e,true)};R.prototype._getInternalAnchorBarVisible=function(){return this._bInternalAnchorBarVisible};R.prototype._setInternalAnchorBarVisible=function(e,t){if(e!=this._bInternalAnchorBarVisible){this._bInternalAnchorBarVisible=e;if(t===true){this.invalidate()}}};R.prototype.setUpperCaseAnchorBar=function(e){this._oABHelper._getAnchorBar().setProperty("upperCase",e);return this.setProperty("upperCaseAnchorBar",e,true)};R.prototype._requestAdjustLayout=function(e){if(!this._oLayoutTask){this._oLayoutTask=new _(this._updateScreenHeightSectionBasesAndSpacer,R.DOM_CALC_DELAY,this)}if(!e){b.debug("ObjectPageLayout :: _requestAdjustLayout","delayed by "+R.DOM_CALC_DELAY+" ms because of dom modifications")}return this._oLayoutTask.reSchedule(e,{}).catch(function(e){})};R.prototype._requestAdjustLayoutAndUxRules=function(e){this._setSectionInfoIsDirty(true);if(!this._oUxRulesTask){this._oUxRulesTask=new _(this._adjustLayoutAndUxRules,R.DOM_CALC_DELAY,this)}if(!e){b.debug("ObjectPageLayout :: _requestAdjustLayoutAndUxRules","delayed by "+R.DOM_CALC_DELAY+" ms because of dom modifications")}return this._oUxRulesTask.reSchedule(e,{}).catch(function(e){})};R.prototype._adjustLayoutAndUxRules=function(){var e,t,i;b.debug("ObjectPageLayout :: _requestAdjustLayout","refreshing ux rules");this._applyUxRules(true);this._adjustSelectedSectionByUXRules();e=this.getSelectedSection();t=this.oCore.byId(e);if(t){this._setSelectedSectionId(e);if(this.getUseIconTabBar()){this._setCurrentTabSection(t);this._bAllContentFitsContainer=this._hasSingleVisibleFullscreenSubSection(t)}this._requestAdjustLayout(true);if(this.getEnableLazyLoading()&&this._oLazyLoading){this._oLazyLoading.doLazyLoading()}if(!this._isClosestScrolledSection(e)||this._hasOngoingScrollToSection()){i=e;if(t.indexOfSubSection(this.oCore.byId(this.getOngoingScrollToSectionBaseId()))>-1){i=this.getOngoingScrollToSectionBaseId()}this.scrollToSection(i,null,0,false,true)}}};R.prototype._isClosestScrolledSection=function(e){var t=this._$opWrapper.length>0?this._$opWrapper.scrollTop():0,i=this.iScreenHeight,o=this._getClosestScrolledSectionBaseId(t,i),n=this.oCore.byId(o),r=h._getClosestSection(n);return r&&e===r.getId()};R.prototype._hasOngoingScrollToSection=function(e){return this._oScroller._$Container&&this._oScroller._$Container.is(":animated")&&this.getOngoingScrollToSectionBaseId()};R.prototype._setSelectedSectionId=function(e){var t=this.getAggregation("_anchorBar"),i=e&&this._oSectionInfo[e];if(!i){return}if(t&&i.buttonId){t.setSelectedButton(i.buttonId);this.setAssociation("selectedSection",e,true)}};R.prototype.isFirstRendering=function(){return this._bFirstRendering};R.prototype._cleanMemory=function(){var e=this.getAggregation("_anchorBar");if(e){e._resetControl()}this._oSectionInfo={};this._aSectionBases=[]};R.prototype._registerSectionBaseInfo=function(e){this._oSectionInfo[e.getId()]={$dom:[],positionTop:0,buttonId:"",isSection:e instanceof h,sectionReference:e};this._aSectionBases.push(e)};R.prototype._triggerVisibleSubSectionsEvents=function(){this._bDelayDOMBasedCalculations=false;if(this.getEnableLazyLoading()&&this._oLazyLoading){this._oLazyLoading._triggerVisibleSubSectionsEvents()}};R.prototype.scrollToSection=function(e,t,o,n,r){var s=this.oCore.byId(e),a,l,d=i.getAnimationMode()!==i.AnimationMode.none,g,u,_,p;if(!this.getDomRef()){b.warning("scrollToSection can only be used after the ObjectPage is rendered",this);return}if(!s){b.warning("scrollToSection aborted: unknown section",e,this);return}if(!this._oSectionInfo[e]||!s._getInternalVisible()){b.warning("scrollToSection aborted: section is hidden by UX rules",e,this);return}if(this.bIsDestroyed){b.debug("ObjectPageLayout :: scrollToSection","scrolling canceled as page is being destroyed");return}if(this.getUseIconTabBar()){var f=h._getClosestSection(s);var S=this._bAllContentFitsContainer,y;this._bAllContentFitsContainer=this._hasSingleVisibleFullscreenSubSection(f);y=this._bAllContentFitsContainer!==S;if(y&&!this._bHeaderExpanded){this._snapHeader(!this._bAllContentFitsContainer);this._bSupressModifyOnScrollOnce=true}if(this._oCurrentTabSection){this._oCurrentTabSection._allowPropagationToLoadedViews(false)}f._allowPropagationToLoadedViews(true);this._setCurrentTabSection(s);this.getAggregation("_anchorBar").setSelectedButton(this._oSectionInfo[f.getId()].buttonId);this.setAssociation("selectedSection",f.getId(),true);this._checkSubSectionVisibilityChange()}l=s instanceof c?s:this._getFirstVisibleSubSection(s);if(this._bHeaderInTitleArea&&!this._shouldPreserveHeaderInTitleArea()&&!this._bAllContentFitsContainer){this._moveHeaderToContentArea();this._toggleHeaderTitle(false);this._bHeaderExpanded=false;this._updateToggleHeaderVisualIndicators()}o=o||0;s._expandSection();this._requestAdjustLayout(true);t=this._computeScrollDuration(t,s);g=d&&t>0;var T=this._computeScrollPosition(s);if(this._sCurrentScrollId!=e||r){this._sCurrentScrollId=e;if(this._iCurrentScrollTimeout){clearTimeout(this._iCurrentScrollTimeout);if(this._$contentContainer){this._$contentContainer.parent().stop(true,false)}}if(this._bDomElementsCached){this._iCurrentScrollTimeout=setTimeout(function(){this._sCurrentScrollId=undefined;this._iCurrentScrollTimeout=undefined}.bind(this),t)}this._preloadSectionsOnBeforeScroll(s);T+=o;if(!this._bStickyAnchorBar&&this._shouldSnapHeaderOnScroll(T)){a=this._getSnapPosition();this._scrollTo(a,0);if(a===0){this._toggleHeader(true)}}u=g&&this.getEnableLazyLoading()&&this._oLazyLoading;_=function(e,t,i){t&&this.setOngoingScrollToSectionBaseId(e);i&&this._oLazyLoading.suppress()}.bind(this,e,g,u);p=function(e){if(e===this.getOngoingScrollToSectionBaseId()){this.setOngoingScrollToSectionBaseId(null);this._resumeLazyLoading()}}.bind(this,e);this._scrollTo(T,t,_,p);if(n){this.fireNavigate({section:h._getClosestSection(s),subSection:l})}}};R.prototype.onAnchorBarTabPress=function(e){var t=sap.ui.getCore().byId(e.getParameter("sectionBaseId")),i=t instanceof f.ObjectPageSubSection,o,n;if(!t){return}o=i?t.getParent():t;n=i?t:this._getFirstVisibleSubSection(t);var r=this.fireBeforeNavigate({section:o,subSection:n});if(!r){return}this.setDirectScrollingToSection(o.getId());this.scrollToSection(t.getId(),null,0,true);o.setAssociation("selectedSubSection",n,true);this.setAssociation("selectedSection",o,true)};R.prototype._hasSingleVisibleFullscreenSubSection=function(e){var t=e.getSubSections().filter(function(e){return e.getVisible()&&e._getInternalVisible()&&e.getBlocks().length>0});return t.length===1&&t[0].hasStyleClass(c.FIT_CONTAINER_CLASS)};R.prototype._computeScrollDuration=function(e,t){var i=parseInt(e);i=i>=0?i:this._iScrollToSectionDuration;if(this.getUseIconTabBar()&&(t instanceof h||this._isFirstVisibleSectionBase(t))&&this._bStickyAnchorBar){i=0}return i};R.prototype._computeScrollPosition=function(e){var t=this._oSectionInfo[e.getId()].positionTop,i=!this._bStickyAnchorBar;if(i&&this._isFirstVisibleSectionBase(e)){t=0}return t};R.prototype._preloadSectionsOnBeforeScroll=function(e){var t=e.getId(),i;if(!this.getEnableLazyLoading()&&this.getUseIconTabBar()){i=e instanceof h?e:e.getParent();this._connectModelsForSections([i])}if(this.getEnableLazyLoading()){var o=this.getUseIconTabBar()?this._grepCurrentTabSectionBases():this._aSectionBases;i=this._oLazyLoading.getSubsectionsToPreload(o,t);if(r.system.desktop){setTimeout(function(){this._connectModelsForSections(i);this._fireSubSectionEnteredViewPortEvent(i)}.bind(this),50)}else{this._connectModelsForSections(i);this._fireSubSectionEnteredViewPortEvent(i)}}};R.prototype._fireSubSectionEnteredViewPortEvent=function(e){e.forEach(function(e){this.fireEvent("subSectionEnteredViewPort",{subSection:e})},this)};R.prototype.getScrollingSectionId=function(){return this._sScrolledSectionId};R.prototype.setDirectScrollingToSection=function(e){this.sDirectSectionId=e};R.prototype.getDirectScrollingToSection=function(){return this.sDirectSectionId};R.prototype.setOngoingScrollToSectionBaseId=function(e){this.sOngoingScrollToSectionBaseId=e};R.prototype.getOngoingScrollToSectionBaseId=function(){return this.sOngoingScrollToSectionBaseId};R.prototype.clearDirectScrollingToSection=function(){this.sDirectSectionId=null};R.prototype._scrollTo=function(e,t,i,o){if(this._oScroller&&this._bDomReady&&!this._bSuppressScroll){b.debug("ObjectPageLayout :: scrolling to "+e);if(t===0&&this._shouldSnapHeaderOnScroll(e)){this._toggleHeader(true)}i&&i();this._oScroller.scrollTo(0,e,t,o)}return this};R.prototype._resumeLazyLoading=function(){if(this._oLazyLoading){this._oLazyLoading.resume();this._oLazyLoading.lazyLoadDuringScroll(true)}};R.prototype._scrollBelowCollapseVisualIndicator=function(){var e=this._getHeaderContent(),t,i,o,n;if(!D(e)||!D(this._$opWrapper)){return}t=e._getCollapseButton().getDomRef();i=t.getBoundingClientRect().height;o=this._$opWrapper[0].getBoundingClientRect().height;n=t.offsetTop+i-o;this._scrollTo(n)};R.prototype._updateMedia=function(e,t){if(!e){return}var i=function(e){Object.keys(t).forEach(function(i){var o=t[i],n=e===o;this.toggleStyleClass(o,n)},this)}.bind(this),o=R.BREAK_POINTS;if(e<=o.PHONE){i(t.PHONE)}else if(e<=o.TABLET){i(t.TABLET)}else if(e<=o.DESKTOP){i(t.DESKTOP)}else{i(t.DESKTOP_XL)}};R.prototype._updateScreenHeightSectionBasesAndSpacer=function(){var e,t,i,o,n,r,s=this._bHeaderInTitleArea||!this._bHeaderExpanded,a,l,d,g=this.getDomRef(),u=this.getUseIconTabBar(),_=this.oCore.byId(this.getSelectedSection());if(!g||!this._bDomReady){return false}b.debug("ObjectPageLayout :: _updateScreenHeightSectionBasesAndSpacer","re-evaluating dom positions");this.iScreenHeight=this._getDOMRefHeight(g);if(this.iScreenHeight===0){return}if(u&&_){this._bAllContentFitsContainer=this._hasSingleVisibleFullscreenSubSection(_)}this.iFooterHeight=this._getFooterHeight();var p=-1;this._aSectionBases.forEach(function(e){var i=this._oSectionInfo[e.getId()],r=e.$(),s=false,g;if(!i||!r.length){return}if(!i.isSection){p++}i.$dom=r;var _=f.Utilities.getChildPosition(r,this._$contentContainer).top;i.positionTop=Math.ceil(_);if(!i.isSection&&(g=e.getParent())){s=e._getTitleDomId()===g.getId()+"-title";if(s){var S=g.$().position().top;i.positionTop=Math.ceil(S)}}if(!this._bStickyAnchorBar&&!this._bHeaderInTitleArea){i.positionTop-=this.iAnchorBarHeight}i.sectionReference.toggleStyleClass("sapUxAPObjectPageSubSectionPromoted",s);if(this._bMobileScenario){var b=e.getParent();if(b instanceof h&&b._getIsHidden()){return}if(n){this._oSectionInfo[n].positionBottom=i.positionTop}n=e.getId();t=e}else{if(i.isSection){if(n){this._oSectionInfo[n].positionBottom=i.positionTop;if(o){this._oSectionInfo[o].positionBottom=i.positionTop}}n=e.getId();o=null}else{if(o){this._oSectionInfo[o].positionBottom=i.positionTop}o=e.getId();t=e}}if(!i.isSection){l=u||e.getParent()===this._oFirstVisibleSection;a=l&&p===0;d=e.hasStyleClass(c.FIT_CONTAINER_CLASS);e._setHeight(this._computeSubSectionHeight(a,d,e))}},this);if(t){e=this._computeLastVisibleHeight(t);if(this._bMobileScenario&&n){this._oSectionInfo[n].positionBottom=this._oSectionInfo[n].positionTop+e}else{if(o){this._oSectionInfo[o].positionBottom=this._oSectionInfo[o].positionTop+e}if(n&&o){this._oSectionInfo[n].positionBottom=this._oSectionInfo[o].positionTop+e}}r=this._bStickyAnchorBar||p>0||this._checkContentBottomRequiresSnap(t);if(this._bAllContentFitsContainer){r=false}if(r&&!this._shouldPreserveHeaderInTitleArea()){s=true}i=this._computeSpacerHeight(t,e,r,s);this._$spacer.height(i+"px");b.debug("ObjectPageLayout :: bottom spacer is now "+i+"px");C(this._oScrollContainerLastState,{iScrollableContentLength:Math.round(this._getScrollableContentLength()),iSpacerHeight:i})}this._adjustTitlePositioning();this._setSectionInfoIsDirty(false);this._updateSelectionOnScroll(this._$opWrapper.scrollTop());this._toggleScrolling(this._shouldAllowScrolling());return true};R.prototype._computeSubSectionHeight=function(e,t,i){var o,n,r,s,a,l;if(!t){return""}var h=this._bAllContentFitsContainer?this._bHeaderExpanded:e;o=this._getSectionsContainerHeight(h);if(this._bAllContentFitsContainer){n=this._$sectionsContainer[0].getBoundingClientRect();r=i.getDomRef().getBoundingClientRect();s=r.top-n.top;a=this.iFooterHeight+this._iREMSize;l=s+a;o-=l}return o+"px"};R.prototype._computeScrollableContentSize=function(e){var t=0;if(this._$contentContainer&&this._$contentContainer.length){t=this._$contentContainer[0].scrollHeight}if(!this._bStickyAnchorBar&&e){t-=this.iAnchorBarHeight}if(this._bStickyAnchorBar&&!e){t+=this.iAnchorBarHeight}return t};R.prototype._computeLastVisibleHeight=function(e){var t=this._bStickyAnchorBar||this._bHeaderInTitleArea;var i=this._getSectionPositionTop(e,t);return Math.floor(this._$spacer.position().top)-i};R.prototype._getStickyAreaHeight=function(e){if(e){return this.iHeaderTitleHeightStickied+this.iAnchorBarHeight}return this.iHeaderTitleHeight};R.prototype._getScrollableViewportHeight=function(e){return this.getDomRef().getBoundingClientRect().height-this._getStickyAreaHeight(e)};R.prototype._getSectionsContainerHeight=function(e){var t=!e,i=this._getScrollableViewportHeight(t);if(!t&&!this._bHeaderInTitleArea){i-=this.iHeaderContentHeight+this.iAnchorBarHeight}return i};R.prototype._getSectionPositionTop=function(e,t){var i=this._oSectionInfo[e.getId()].positionTop;if(!this._bStickyAnchorBar&&!this._bHeaderInTitleArea){i+=this.iAnchorBarHeight}return i};R.prototype._getSectionPositionBottom=function(e,t){var i=this._oSectionInfo[e.getId()].positionBottom;if(!t){i+=this.iAnchorBarHeight}return i};R.prototype._determineSectionBaseInternalTitleLevel=function(e,t){var i=this.getSectionTitleLevel(),o=e instanceof h;if(i===O.Auto){if(o||t&&!o){return O.H3}return O.H4}return o?i:R._getNextTitleLevelEntry(i)};R.prototype._shouldApplySectionTitleLevel=function(e){return e.getTitleLevel()===O.Auto};R.prototype._checkContentBottomRequiresSnap=function(e){var t=false;return this._getSectionPositionBottom(e,t)>this._getScrollableViewportHeight(t)+this._getSnapPosition()};R.prototype._computeSpacerHeight=function(e,t,i,o){var n,r;if(Object.keys(this._oVisibleSubSections).length===1&&this._bHeaderExpanded){n=0}else{r=this._getScrollableViewportHeight(o);if(i){r=Math.ceil(r);t=Math.floor(t)}else{t=this._$spacer.position().top}if(t<r){n=r-t}else{n=0}}if(this.iFooterHeight>n){n+=this.iFooterHeight}return n};R.prototype._isFirstVisibleSectionBase=function(e){var t,i,o,n=this.getSelectedSection(),r=this.getUseIconTabBar();if(!e||!e.getParent()){return}t=e.getId();if(r&&t===n){return true}if(r&&e.getParent().getId()===n){i=sap.ui.getCore().byId(n);o=this._getFirstVisibleSubSection(i);return o&&o.getId()===t}if(this._oFirstVisibleSection&&this._oFirstVisibleSubSection){return t===this._oFirstVisibleSection.getId()||t===this._oFirstVisibleSubSection.getId()}return false};R.prototype._getFirstVisibleSubSection=function(e){if(!e){e=this.getUseIconTabBar()?this._oCurrentTabSection:this._oFirstVisibleSection;if(!e){return}}var t;this._aSectionBases.every(function(i){if(i.getParent()&&i.getParent().getId()===e.getId()){t=i;return false}return true});return t};R.prototype._initAnchorBarScroll=function(){var e=this.oCore.byId(this.getSelectedSection()),t;this._requestAdjustLayout(true);t=e?this._computeScrollPosition(e):0;this._sScrolledSectionId="";this._sCurrentScrollId="";this._onScroll({target:{scrollTop:t}},true)};R.prototype._setAsCurrentSection=function(e){var t,i,o,n;if(this._sScrolledSectionId===e){return}b.debug("ObjectPageLayout :: current section is "+e);this._sScrolledSectionId=e;t=this.getAggregation("_anchorBar");n=t&&this._getInternalAnchorBarVisible();i=this.oCore.byId(e);o=i&&i instanceof c&&(i.getTitle().trim()===""||!i._getInternalTitleVisible()||i.getParent()._getIsHidden());if(o){e=i.getParent().getId();b.debug("ObjectPageLayout :: current section is a subSection with an empty or hidden title, selecting parent "+e)}if(i&&this._oSectionInfo[e]){n&&t.setSelectedButton(this._oSectionInfo[e].buttonId);this.setAssociation("selectedSection",h._getClosestSection(e).getId(),true);this._setSectionsFocusValues(e)}};R.prototype._registerOnContentResize=function(){var e=this._$contentContainer.length&&this._$contentContainer[0];if(!e){return}if(this._iContentResizeId){t.deregister(this._iContentResizeId)}this._iContentResizeId=t.register(e,this._onUpdateContentSize.bind(this))};R.prototype._onUpdateContentSize=function(e){var t=e.size;this.iContentHeight=t.height;if(t.height===0||t.width===0){b.info("ObjectPageLayout :: not triggering calculations if height or width is 0");return}if(this.getPreserveHeaderStateOnScroll()){this._overridePreserveHeaderStateOnScroll()}this._adjustHeaderHeights();this._requestAdjustLayout(true)};R.prototype.triggerPendingLayoutUpdates=function(){if(this._hasPendingLayoutUpdate()){this._requestAdjustLayout(true)}};R.prototype._hasPendingLayoutUpdate=function(){return this._oLayoutTask&&this._oLayoutTask.isPending()||this._$contentContainer.length&&this._$contentContainer.get(0).offsetHeight!==this.iContentHeight};R.prototype._adjustTitlePositioning=function(e){if(!this._$titleArea.length||!this._$opWrapper.length){return}var t=this._$opWrapper.get(0),i=this._$titleArea.get(0),o=i.getBoundingClientRect().height,n=i.getBoundingClientRect().width,r=T().width,s;t.style.paddingTop=o+"px";t.style.scrollPaddingTop=o+"px";if(this._oScroller){this._oScroller.setScrollPaddingTop(o)}s="polygon(0px "+o+"px, "+Math.floor(n)+"px "+o+"px, "+Math.floor(n)+"px 0, 100% 0, 100% 100%, 0 100%)";if(this.oCore.getConfiguration().getRTL()){s="polygon(0px 0px, "+r+"px 0px, "+r+"px "+o+"px, 100% "+o+"px, 100% 100%, 0 100%)"}t.style.clipPath=s;this.getHeaderTitle()&&this._shiftHeaderTitle()};R.prototype._onUpdateScreenSize=function(e){var t=this.getHeaderTitle(),i=this._getHeaderContent(),o=e.size.width,n=e.size.height,r=e.oldSize.height,s=n!==r,a,l=i&&i.supportsAlwaysExpanded()&&this.getAlwaysShowContentHeader();if(e.size.height===0||e.size.width===0){b.info("ObjectPageLayout :: not triggering calculations if height or width is 0");return}this._bMobileScenario=f.Utilities.isPhoneScenario(this._getCurrentMediaContainerRange());this._bTabletScenario=f.Utilities.isTabletScenario(this._getCurrentMediaContainerRange());if(!this._bDomReady){b.info("ObjectPageLayout :: cannot _onUpdateScreenSize before dom is ready");return}this._oLazyLoading.setLazyLoadingParameters();setTimeout(function(){if(l&&this._bHeaderInTitleArea!=this._checkAlwaysShowContentHeader()){this.invalidate()}if(this._bHeaderInTitleArea&&this._headerBiggerThanAllowedToBeExpandedInTitleArea()){if(this._isHeaderPinnable()){this._updatePinButtonState()}this._expandHeader(false);this._scrollTo(0,0)}else if(this._isHeaderPinnable()&&!this._headerBiggerThanAllowedToBeExpandedInTitleArea()){this._updatePinButtonState()}if(t&&t.isDynamic()){t._onResize(o);this._updateMedia(o,R.DYNAMIC_HEADERS_MEDIA)}this._updateMedia(o,R.MEDIA);this._adjustHeaderHeights();this._requestAdjustLayout(true);if(this.getFooter()&&this.getShowFooter()){this._shiftFooter()}a=this.getSelectedSection();if(r===0&&s&&!this._isClosestScrolledSection(a)){a!==null?this.scrollToSection(a,0):this._selectFirstVisibleSection()}this._scrollTo(this._$opWrapper.scrollTop(),0);if(r===0&&s&&this.getEnableLazyLoading()&&this._oLazyLoading&&!this._bDelayDOMBasedCalculations){this._oLazyLoading.doLazyLoading()}}.bind(this),this._getDOMCalculationDelay())};R.prototype._onUpdateHeaderTitleSize=function(e){if(e.size.height===0||e.size.width===0){b.info("ObjectPageLayout :: not triggering calculations if height or width is 0");return}if(!this._bDomReady){b.info("ObjectPageLayout :: cannot _onUpdateTitleSize before dom is ready");return}this._adjustHeaderHeights();this._requestAdjustLayout()};R.prototype._applyContextualSettings=function(e){var t=e.contextualWidth;if(this._hasDynamicTitle()){this._updateMedia(t,R.DYNAMIC_HEADERS_MEDIA)}this._updateMedia(t,R.MEDIA);return s.prototype._applyContextualSettings.call(this,e)};R.prototype._shouldSnapHeaderOnScroll=function(e){return e>0&&e>=this._getSnapPosition()&&!this._shouldPreserveHeaderInTitleArea()};R.prototype._getScrollableContentLength=function(){return this._$contentContainer.length?this._getDOMRefHeight(this._$contentContainer[0]):0};R.prototype._isContentScrolledToBottom=function(){return this._oScrollContainerLastState.iScrollableContentLength<=this._oScrollContainerLastState.iScrollTop+this._oScrollContainerLastState.iScrollableViewportHeight};R.prototype._isContentLengthDecreased=function(e){if(e){return e.iScrollableContentLength>this._oScrollContainerLastState.iScrollableContentLength&&e.iSpacerHeight===this._oScrollContainerLastState.iSpacerHeight}};R.prototype._canReachScrollTop=function(e,t){var i;t=t||0;i=this._oScrollContainerLastState.iScrollableContentLength+t+this._$contentContainer.get(0).offsetTop-this._oScrollContainerLastState.iScrollableViewportHeight;return i>=e};R.prototype._deregisterCustomEvents=function(){if(this._$opWrapper.length){this._$opWrapper.off(".OPL")}};R.prototype._deregisterScreenSizeListener=function(){if(this._iResizeId){t.deregister(this._iResizeId);this._iResizeId=null}};R.prototype._deregisterTitleSizeListener=function(){if(this._iTitleResizeId){t.deregister(this._iTitleResizeId);this._iTitleResizeId=null}};R.prototype._onScroll=function(e,t){var i=Math.max(Math.ceil(e.target.scrollTop),0),o=this._$opWrapper.length&&this._$opWrapper[0],n=this._$spacer.length&&this._$spacer[0],r=this._$spacer.height(),s,a=this.getHeaderTitle(),l=this._shouldSnapHeaderOnScroll(i),h=this._shouldPreserveHeaderInTitleArea(),c=false,d=this._oScrollContainerLastState;this._oScrollContainerLastState={iScrollTop:i,iScrollableContentLength:Math.round(this._getScrollableContentLength()),iScrollableViewportHeight:o.offsetHeight,iSpacerHeight:r};if(this._bSupressModifyOnScrollOnce){this._bSupressModifyOnScrollOnce=false;if(!t){return}}if(!o||!n){return}s=this.iScreenHeight;if(s===0){return}if(this._getSectionInfoIsDirty()){return}if(d&&this._isContentScrolledToBottom()&&this._isContentLengthDecreased(d)){var g=d.iScrollableContentLength-this._oScrollContainerLastState.iScrollableContentLength;if(!this._canReachScrollTop(d.iScrollTop)&&this._canReachScrollTop(d.iScrollTop,g)){var u=d.iScrollTop+this._oScrollContainerLastState.iScrollableViewportHeight,_=this._oScrollContainerLastState.iScrollableContentLength,p=u-_,f;if(p>0){f=r+p;this._$spacer.height(f+"px");this._scrollTo(d.iScrollTop);return}}}if(l&&!h){s-=this.iAnchorBarHeight+this.iHeaderTitleHeightStickied}if(this._bHeaderInTitleArea&&!h){this._moveHeaderToContentArea();this._toggleHeaderTitle(false);this._bHeaderExpanded=false;this._updateToggleHeaderVisualIndicators();this._requestAdjustLayout()}if(!h&&(a&&this.getShowHeaderContent()||this.getShowAnchorBar())){this._toggleHeader(l,!!(e&&e.type==="scroll"))}if(!h){this._adjustHeaderTitleBackgroundPosition(i)}b.debug("ObjectPageLayout :: lazy loading : Scrolling at "+i,"----------------------------------------");this._updateSelectionOnScroll(i);if(this.getEnableLazyLoading()){this._oLazyLoading.lazyLoadDuringScroll(t,i,e.timeStamp,s)}if(a&&a.supportsTitleInHeaderContent()&&this.getShowHeaderContent()&&this.getShowTitleInHeaderContent()&&a.getShowTitleSelector()){if(i===0){this.$("scroll").css("z-index","1000");c=false}else if(!c){c=true;this.$("scroll").css("z-index","0")}}};R.prototype._updateSelectionOnScroll=function(e){var t=this.iScreenHeight,i,o,n,r;if(t===0){return}i=this._getClosestScrolledSectionBaseId(e,t);o=h._getClosestSection(i);n=o?o.getId():null;r=this._getClosestScrolledSectionBaseId(e,t,true);if(i){var s=this.getDirectScrollingToSection(),a=this.oCore.byId(s);if(i!==this._sScrolledSectionId){b.debug("ObjectPageLayout :: closest id "+i,"----------------------------------------");var s=this.getDirectScrollingToSection();if(s&&s!==n&&(a&&a.getDomRef()&&!this.isFirstRendering())){return}this.clearDirectScrollingToSection();this._setAsCurrentSection(i)}else if(n===this.getDirectScrollingToSection()){this.clearDirectScrollingToSection()}if(r!==this._sScrolledSubSectionId){var l=h._getClosestSection(i),c=this.oCore.byId(r);this._sScrolledSubSectionId=r;this.fireEvent("_sectionChange",{section:l,subSection:c});this.fireEvent("sectionChange",{section:l,subSection:c})}}};R.prototype._getSnapPosition=function(){var e=this.iHeaderContentHeight,t=this._getTitleHeightDelta();e-=Math.max(t,this._iHeaderContentPaddingBottom);return e};R.prototype._getTitleHeightDelta=function(){var e=this.iHeaderTitleHeightStickied-this.iHeaderTitleHeight;e=Math.max(e,0);e=Math.min(e,R.MAX_SNAP_POSITION_OFFSET);return e};R.prototype._getClosestScrolledSectionBaseId=function(e,t,i){i=!!i;e=Math.ceil(e);var o=e+t,n,r=i||this._bMobileScenario;jQuery.each(this._oSectionInfo,function(t,s){var a,l,c,d,g,u=this.getSelectedSection();a=s.sectionReference;l=a.getParent();c=l instanceof h&&l._getIsHidden();if(this.getUseIconTabBar()&&u){g=this.oCore.byId(u);if(!g){return}if(s.isSection&&s.sectionReference!=g){return true}if(!s.isSection&&g.indexOfSubSection(s.sectionReference)<0){return true}}if(s.isSection||r&&!c){if(!n&&s.sectionReference._getInternalVisible()===true){d=this._getFirstVisibleSubSection(s.sectionReference);if(s.isSection&&i&&d){n=d.getId()}else{n=t}}if(s.isSection&&i){return true}if(s.positionTop<=o&&e<=s.positionBottom){if(s.positionTop<=e+1&&s.positionBottom>e){n=t}}}}.bind(this));return this.oCore.byId(n)?n:null};R.prototype._toggleHeader=function(e,t){var i;if(e===this._bStickyAnchorBar){return}i=this.getHeaderTitle();if(!this._shouldPreserveHeaderInTitleArea()&&!this._bHeaderInTitleArea){this._toggleHeaderTitle(!e,t)}if(!this._bStickyAnchorBar&&e){this._restoreFocusAfter(this._moveAnchorBarToTitleArea);i&&i.snap();this._bHeaderExpanded=false;this._adjustHeaderHeights();this._updateToggleHeaderVisualIndicators()}else if(this._bStickyAnchorBar&&!e){this._restoreFocusAfter(this._moveAnchorBarToContentArea);i&&i.unSnap();this._bHeaderExpanded=true;this._adjustHeaderHeights();this._updateToggleHeaderVisualIndicators();if(this._isHeaderPinnable()){this._getHeaderContent()._getPinButton().setVisible(!this._headerBiggerThanAllowedToBeExpandedInTitleArea())}}};R.prototype._restoreFocusAfter=function(e){var t=this.oCore.byId(this.oCore.getCurrentFocusedControlId());e.call(this);if(r.system.phone!==true){if(!this.oCore.byId(this.oCore.getCurrentFocusedControlId())){t&&t.$().trigger("focus")}}return this};R.prototype._moveAnchorBarToTitleArea=function(){this._$anchorBar.children().appendTo(this._$stickyAnchorBar);this._toggleHeaderStyleRules(true);if(this.iHeaderTitleHeight!=this.iHeaderTitleHeightStickied){this._adjustHeaderBackgroundSize()}return this};R.prototype._moveAnchorBarToContentArea=function(){if(!this._shouldPreserveHeaderInTitleArea()){var e=this._$opWrapper.scrollTop();this._$anchorBar.css("height","auto").append(this._$stickyAnchorBar.children());this._$opWrapper.scrollTop(e);this._toggleHeaderStyleRules(false)}return this};R.prototype._toggleHeaderStyleRules=function(e){e=!!e;var t=e?"hidden":"inherit";this._bStickyAnchorBar=e;this._$headerContent.css("overflow",t);this._$headerContent.toggleClass("sapContrastPlus",!e);this._$headerContent.toggleClass("sapUxAPObjectPageHeaderDetailsHidden",e);this._$anchorBar.css("visibility",t);if(D(this._$stickyAnchorBar)){this._$stickyAnchorBar.attr("aria-hidden",!e)}this.fireToggleAnchorBar({fixed:e});if(!e&&!this.iAnchorBarHeight){this._requestAdjustLayout()}};R.prototype.getScrollDelegate=function(){return this._oScroller};R.prototype.setHeaderTitle=function(t,i){if(t&&typeof t.addEventDelegate==="function"){t.addEventDelegate({onAfterRendering:this._onAfterHeaderTitleRendering.bind(this)})}this.setAggregation("headerTitle",t,i);this._oObserver&&this._oObserver.disconnect();this._oObserver=new e(this._onModifyHeaderTitle.bind(this));this._oObserver.observe(t,{aggregations:["headerTitle"],properties:["backgroundDesign"]});if(t){this._createHeaderContent()}if(this._hasDynamicTitle()){this._iHeaderContentPaddingBottom=R.HEADER_CONTENT_PADDING_BOTTOM}return this};R.prototype._onAfterHeaderTitleRendering=function(){var e=this.getHeaderTitle(),t=e&&e.$(),i;if(!e||!t.length){return}i=t.height();if(i!==this._iCachedHeaderTitleHeight){this._adjustHeaderHeights();this._iCachedHeaderTitleHeight=i}};R.prototype._onModifyHeaderTitle=function(e){var t=this.getAggregation("_headerContent");t&&e.current&&t.setBackgroundDesign(e.current)};R.prototype.invalidate=function(e){this._bInvalidatedAndNotRerendered=true;if(this.getUseIconTabBar()&&e&&e instanceof h&&!e.isActive()&&this._oSectionInfo[e.getId()]){return}if(this._iAfterRenderingDomReadyTimeout){clearTimeout(this._iAfterRenderingDomReadyTimeout);this._iAfterRenderingDomReadyTimeout=null}o.prototype.invalidate.apply(this,arguments)};R.prototype._createHeaderContent=function(){var e=this.getHeaderTitle(),t=this.getAggregation("_headerContent"),i,o;var n=e?e.getCompatibleHeaderContentClass():d;if(!(t instanceof n)){i=this.getAggregation("_headerContent");if(i){i.destroy()}o=n.createInstance(this.getAggregation("headerContent"),this.getShowHeaderContent(),"",this.getHeaderContentPinnable(),this.getId()+"-OPHeaderContent");o.getContent().forEach(this._replaceHeaderContentParent,this);this.setAggregation("_headerContent",o,true)}};R.prototype._adjustHeaderBackgroundSize=function(){var e=this.getHeaderTitle();if(e&&e.getHeaderDesign()=="Dark"){if(!this._shouldPreserveHeaderInTitleArea()){this.iTotalHeaderSize=this.iHeaderTitleHeight+this.iHeaderContentHeight;this._$headerContent.css("background-size","100% "+this.iTotalHeaderSize+"px")}else{this.iTotalHeaderSize=this.iHeaderTitleHeight-this._$stickyAnchorBar.height();this._$stickyHeaderContent.css("background-size","100% "+this.iTotalHeaderSize+"px")}e.$().css("background-size","100% "+this.iTotalHeaderSize+"px");this._adjustHeaderTitleBackgroundPosition(0)}};R.prototype._adjustHeaderTitleBackgroundPosition=function(e){var t=this.getHeaderTitle();if(t&&t.getHeaderDesign()=="Dark"){if(this._bStickyAnchorBar){t.$().css("background-position","0px "+(this.iTotalHeaderSize-this.iHeaderTitleHeightStickied)*-1+"px")}else{if(this._shouldPreserveHeaderInTitleArea()){t.$().css("background-position","0px 0px")}else{t.$().css("background-position","0px "+(this.iHeaderTitleHeight+this.iHeaderContentHeight-this.iTotalHeaderSize-e)+"px")}}}};R.prototype._adjustHeaderHeights=function(){var e=this.getHeaderTitle(),t=true;if(e&&!e.supportsAdaptLayoutForDomElement()){t=false}if(this._$titleArea.length>0){this.iHeaderContentHeight=this._$headerContent.length?Math.round(this._getDOMRefHeight(this._$headerContent[0])):0;this.iStickyHeaderContentHeight=this._$stickyHeaderContent.height();this.iAnchorBarHeight=this._bStickyAnchorBar?this._$stickyAnchorBar.outerHeight():this._$anchorBar.outerHeight();if(!this._bHeaderExpanded){this.iHeaderTitleHeightStickied=this._$titleArea.height()-this.iAnchorBarHeight;this.iHeaderTitleHeight=this._obtainExpandedTitleHeight(t)}else{this.iHeaderTitleHeight=this._$titleArea.is(":visible")?this._$titleArea.height():0;this.iHeaderTitleHeightStickied=this._obtainSnappedTitleHeight(t)}this._adjustHeaderBackgroundSize();this._adjustTitlePositioning();b.info("ObjectPageLayout :: adjustHeaderHeight","headerTitleHeight: "+this.iHeaderTitleHeight+" - headerTitleStickiedHeight: "+this.iHeaderTitleHeightStickied+" - headerContentHeight: "+this.iHeaderContentHeight)}else{b.debug("ObjectPageLayout :: adjustHeaderHeight","skipped as the objectPageLayout is being rendered")}};R.prototype._appendTitleCloneToDOM=function(e){var t=this.getHeaderTitle().$(),i=t.clone();i.css({left:"-10000px",top:"-10000px",width:t.width()+"px",position:"absolute"});i.toggleClass("sapUxAPObjectPageHeaderStickied",e);i.appendTo(this._$titleArea.parent());if(e){this.getHeaderTitle()&&this.getHeaderTitle()._adaptObjectPageHeaderIndentifierLine(i)}return i};R.prototype._obtainSnappedTitleHeight=function(e){var t=this.getHeaderTitle(),i,o;if(!t){return 0}if(e){i=this._appendTitleCloneToDOM(true);o=i.height();i.remove()}else if(t.snap){o=this._obtainTitleHeightViaStateChange(true)}return o};R.prototype._obtainExpandedTitleHeight=function(e){var t=this.getHeaderTitle(),i,o;if(!t){return 0}if(e){i=this._appendTitleCloneToDOM(false);o=i.is(":visible")?i.height():0;i.remove()}else if(t.unSnap){o=this._obtainTitleHeightViaStateChange(false)}return o};R.prototype._obtainTitleHeightViaStateChange=function(e){var t=this.getHeaderTitle(),i,o=this._$sectionsContainer.height(),n,r=e?t.snap:t.unSnap,s=e?t.unSnap:t.snap;r.call(t,false);i=t.$().outerHeight();s.call(t,false);n=this._$sectionsContainer.height();this._adjustSpacerHeightUponUnsnapping(o,n);return i};R.prototype._adjustSpacerHeightUponUnsnapping=function(e,t){var i;if(e!=t){i=this._$spacer.height()-(t-e);this._$spacer.height(i)}};R.prototype._getHeaderDesign=function(){var e=this.getHeaderTitle(),t=f.ObjectPageHeaderDesign.Light;if(e!=null){t=e.getHeaderDesign()}return t};R.prototype._getVisibleSections=function(){return this.getSections().filter(function(e){return e.getVisible()&&e._getInternalVisible()})};R.prototype._setSectionsFocusValues=function(e){var t=this._getVisibleSections()||[],i,o="0",n="-1",r="tabindex",s,a=t[0];t.forEach(function(t){i=t.$();if(e===t.getId()){i.attr(r,o);s=t;t._setSubSectionsFocusValues()}else{i.attr(r,n);t._disableSubSectionsFocus()}});if(!s&&t.length>0){a.$().attr(r,o);a._setSubSectionsFocusValues();s=a}return s};R.prototype.setShowHeaderContent=function(e){var t=this.getShowHeaderContent(),i;if(t!==e){if(t&&this._bHeaderInTitleArea&&!this._shouldPreserveHeaderInTitleArea()){this._moveHeaderToContentArea();this._toggleHeaderTitle(false)}this.setProperty("showHeaderContent",e,true);this._updateTitleVisualState();i=this._getHeaderContent();this.$().toggleClass("sapUxAPObjectPageLayoutNoHeaderContent",!e||!i);if(i){i.setProperty("visible",e)}}return this};R.prototype._headerTitleChangeHandler=function(e){var t;if(!this.getShowTitleInHeaderContent()){return}if(e){this._getHeaderContent()._destroyObjectImage(true)}t=this.oCore.createRenderManager();this.getRenderer()._rerenderHeaderContentArea(t,this);this._getHeaderContent().invalidate();t.destroy()};R.prototype._replaceHeaderContentParent=function(e){if(e.getParent().isA(["sap.uxap.ObjectPageHeaderContent","sap.uxap.ObjectPageDynamicHeaderContent"])){if(e.isA(["sap.uxap.ObjectPageHeaderContent","sap.uxap.ObjectPageDynamicHeaderContent"])){return}if(e._sOriginalParentAggregationName){return}e._sOriginalParentAggregationName=e.sParentAggregationName;e.sParentAggregationName="headerContent";e.getParent=function(){return this}.bind(this);e.destroy=function(){this._restoreParent(e);e.getMetadata().getClass().prototype.destroy.apply(e,arguments)}.bind(this)}};R.prototype._restoreParent=function(e){if(e&&e._sOriginalParentAggregationName){e.sParentAggregationName=e._sOriginalParentAggregationName;e.getParent=e.getMetadata().getClass().prototype.getParent;e.destroy=e.getMetadata().getClass().prototype.destroy;e._sOriginalParentAggregationName=null}};R.prototype.getHeaderContent=function(){if(!this._getHeaderContent()){return this.getAggregation("headerContent",[])}return this._getHeaderContent().getAggregation("content",[])};R.prototype.insertHeaderContent=function(e,t,i){if(!this._getHeaderContent()){return this.insertAggregation("headerContent",e,t,i)}this._getHeaderContent().insertAggregation("content",e,t,i);this._replaceHeaderContentParent(e);return this};R.prototype.addHeaderContent=function(e,t){if(!this._getHeaderContent()){return this.addAggregation("headerContent",e,t)}this._getHeaderContent().addAggregation("content",e,t);this._replaceHeaderContentParent(e);return this};R.prototype.removeAllHeaderContent=function(e){var t;if(!this._getHeaderContent()){return this.removeAllAggregation("headerContent",e)}t=this._getHeaderContent().removeAllAggregation("content",e);t.forEach(function(e){this._restoreParent(e)},this);return t};R.prototype.removeHeaderContent=function(e,t){if(!this._getHeaderContent()){return this.removeAggregation("headerContent",e,t)}this._getHeaderContent().removeAggregation("content",e,t);this._restoreParent(e);return this};R.prototype.destroyHeaderContent=function(e){if(!this._getHeaderContent()){return this.destroyAggregation("headerContent",e)}return this._getHeaderContent().destroyAggregation("content",e)};R.prototype.indexOfHeaderContent=function(e){if(!this._getHeaderContent()){return this.indexOfAggregation("headerContent",e)}return this._getHeaderContent().indexOfAggregation("content",e)};R.prototype._getHeaderContent=function(){return this.getAggregation("_headerContent")};R.prototype._getHeaderContentDomRef=function(){var e=this._getHeaderContent();if(!e||!this.getShowHeaderContent()){return null}if(this._bStickyAnchorBar&&!this._bHeaderInTitleArea){return this.$().find(".sapUxAPObjectPageHeaderTitle .sapUxAPObjectPageHeaderDetails").get(0)}return e.getDomRef()};R.prototype._connectModelsForSections=function(e){e=e||[];e.forEach(function(e){e.connectToModels()})};R.prototype._getHeightRelatedParameters=function(){return{iHeaderContentHeight:this.iHeaderContentHeight,iScreenHeight:this.iScreenHeight,iAnchorBarHeight:this.iAnchorBarHeight,iHeaderTitleHeightStickied:this.iHeaderTitleHeightStickied,iStickyHeaderContentHeight:this.iStickyHeaderContentHeight,iScrollTop:this._$opWrapper.scrollTop()}};R.prototype._hasVerticalScrollBar=function(){var e=this._$opWrapper.length&&this._$opWrapper.get(0);return e&&e.scrollHeight>e.offsetHeight};R.prototype._shiftHeaderTitle=function(){var e=this._calculateShiftOffset(),t=e.sStyleAttribute,i=e.iMarginalsOffset;this.$().find(".sapUxAPObjectPageHeaderTitle").css(t,i+"px")};R.prototype._isFirstSection=function(e){var t=this._getVisibleSections();if(e===t[0]){return true}return false};R.prototype._isValidStoredSubSectionInfo=function(){var e=this.getSelectedSection(),t=this.oCore.byId(e),i;if(!t||!this._oStoredScrolledSubSectionInfo){return false}i=this.oCore.byId(this._oStoredScrolledSubSectionInfo.sSubSectionId);return i&&this._sectionCanBeRenderedByUXRules(i)&&t.indexOfSubSection(i)>=0};R.prototype._restoreScrollPosition=function(){var e=this._isValidStoredSubSectionInfo(),t;if(e){t=this._computeScrollPosition(this.oCore.byId(this._oStoredScrolledSubSectionInfo.sSubSectionId))+this._oStoredScrolledSubSectionInfo.iOffset;this._scrollTo(t,0)}else{this.scrollToSection(this.getSelectedSection(),0)}};R.prototype._storeScrollLocation=function(){if(!this.getDomRef()||!this._bDomReady||!this._oScroller){return}this.triggerPendingLayoutUpdates();var e=this._$opWrapper.scrollTop(),t=this._getClosestScrolledSectionBaseId(this._oScroller.getScrollTop(),this.iScreenHeight,true),i;if(t){i=e-this._computeScrollPosition(this.oCore.byId(t))}this._iStoredScrollTop=e;this._oStoredScrolledSubSectionInfo={sSubSectionId:t,iOffset:i};this._oCurrentTabSection=null};R.prototype.onkeyup=function(e){var t,i;if(e.which===I.TAB){t=this.oCore.getCurrentFocusedControlId();i=t&&this.oCore.byId(t);if(i&&this._isFirstSection(i)){this._scrollTo(0,0)}}};R.prototype.setShowFooter=function(e){var t=this.setProperty("showFooter",e,true);this._toggleFooter(e);this.$().toggleClass("sapUxAPObjectPageLayoutFooterVisible",e);return t};R.prototype.destroyFooter=function(){this._destroyInvisibleText();return this.destroyAggregation("footer")};R.prototype._toggleFooter=function(e){var t,o=this.getFooter(),n=this.oCore.getConfiguration().getAnimationMode();if(!D(o)||!D(this._$footerWrapper)){return}t=n!==i.AnimationMode.none&&n!==i.AnimationMode.minimal;if(t){this._toggleFooterAnimation(e,o)}else{this._$footerWrapper.toggleClass("sapUiHidden",!e)}this._requestAdjustLayout()};R.prototype._toggleFooterAnimation=function(e,t){this._$footerWrapper.on("webkitAnimationEnd animationend",this._onToggleFooterAnimationEnd.bind(this,t));this._bIsFooterAanimationGoing=true;if(e){this._$footerWrapper.removeClass("sapUiHidden")}t.toggleStyleClass(R.SHOW_FOOTER_CLASS_NAME,e);t.toggleStyleClass(R.HIDE_FOOTER_CLASS_NAME,!e)};R.prototype._onToggleFooterAnimationEnd=function(e){this._$footerWrapper.off("webkitAnimationEnd animationend");if(e.hasStyleClass(R.HIDE_FOOTER_CLASS_NAME)){this._$footerWrapper.addClass("sapUiHidden");e.removeStyleClass(R.HIDE_FOOTER_CLASS_NAME)}else{e.removeStyleClass(R.SHOW_FOOTER_CLASS_NAME)}this._bIsFooterAanimationGoing=false};R.prototype.clone=function(){var e,t,i;Object.keys(this.mAggregations).forEach(this._cloneProxiedAggregations,this);e=o.prototype.clone.apply(this,arguments);t=this._getHeaderContent();i=e._getHeaderContent();if(i){i.destroy()}if(t){e.setAggregation("_headerContent",t.clone(),true)}return e};R.prototype._cloneProxiedAggregations=function(e){var t=this.mAggregations[e];if(Array.isArray(t)&&t.length===0){t=this["get"+e.charAt(0).toUpperCase()+e.slice(1)]()}this.mAggregations[e]=t};R.prototype._shouldPreserveHeaderInTitleArea=function(){return this._bPinned||this._preserveHeaderStateOnScroll()||this._checkAlwaysShowContentHeader()};R.prototype._checkAlwaysShowContentHeader=function(){return!this._hasDynamicTitle()&&!this._bMobileScenario&&!this._bTabletScenario&&this.getShowHeaderContent()&&this.getAlwaysShowContentHeader()};R.prototype._headerBiggerThanAllowedToBeFixed=function(){var e=this._getOwnHeight();return this._getEntireHeaderHeight()>R.HEADER_MAX_ALLOWED_NON_SROLLABLE_PERCENTAGE*e};R.prototype._headerBiggerThanAllowedToBeExpandedInTitleArea=function(){return this._getEntireHeaderHeight()>=this._getOwnHeight()};R.prototype._getOwnHeight=function(){return this._getHeight(this)};R.prototype._getHeight=function(e){return!(e instanceof o)?0:e.$().outerHeight()||0};R.prototype._getEntireHeaderHeight=function(){var e=0,t=0,i=this.getHeaderTitle(),o=this._getHeaderContent();if(D(i)){e=i.$().outerHeight()}if(D(o)){t=o.$().outerHeight()}return e+t};R.prototype._onPinUnpinButtonPress=function(){if(this._bPinned){this._unPin(true)}else{this._pin(true);this._restorePinButtonFocus()}};R.prototype._restorePinButtonFocus=function(){var e=this._getHeaderContent();if(D(e)&&e.supportsPinUnpin()){e._focusPinButton()}};R.prototype._pin=function(e){if(this._bPinned){return}this._bPinned=true;if(e){this.setProperty("headerContentPinned",true,true);this.fireEvent("headerContentPinnedStateChange",{pinned:true})}this._toggleHeaderTitle(true);this._moveAnchorBarToTitleArea();this._moveHeaderToTitleArea();this._adjustHeaderHeights();this._requestAdjustLayout();this._updateToggleHeaderVisualIndicators();this.addStyleClass("sapUxAPObjectPageLayoutHeaderPinned")};R.prototype._unPin=function(e){if(!this._bPinned){return}this._bPinned=false;if(e){this.setProperty("headerContentPinned",false,true);this.fireEvent("headerContentPinnedStateChange",{pinned:false})}this._updateToggleHeaderVisualIndicators();this.removeStyleClass("sapUxAPObjectPageLayoutHeaderPinned")};R.prototype._isHeaderPinnable=function(){var e=this._getHeaderContent();return e&&e.supportsPinUnpin()&&e.getPinnable()};R.prototype._shouldPinUnpinHeader=function(){return this._bHeaderExpanded&&!this.getPreserveHeaderStateOnScroll()&&!this._headerBiggerThanAllowedToBeExpandedInTitleArea()};R.prototype._updatePinButtonState=function(){var e=this._isHeaderPinnable(),t=e&&this.getHeaderContentPinned()&&this._shouldPinUnpinHeader(),i=this._getHeaderContent();i._togglePinButton(t);this.$().toggleClass("sapUxAPObjectPageLayoutHeaderPinnable",e);i._getPinButton().setVisible(!this._headerBiggerThanAllowedToBeExpandedInTitleArea());if(t){this._pin()}else{this._unPin()}};R.prototype._preserveHeaderStateOnScroll=function(){return this._hasDynamicTitle()&&this.getPreserveHeaderStateOnScroll()&&!this._bHeaderBiggerThanAllowedHeight};R.prototype._overridePreserveHeaderStateOnScroll=function(){var e=this._bHeaderBiggerThanAllowedHeight,t;this._bHeaderBiggerThanAllowedHeight=this._headerBiggerThanAllowedToBeFixed();t=e!==this._bHeaderBiggerThanAllowedHeight;if(!this._bHeaderBiggerThanAllowedHeight||!t){return}if(this._bHeaderExpanded){this._moveAnchorBarToContentArea();this._moveHeaderToContentArea(true)}else{this._snapHeader(true)}this._adjustHeaderHeights();this._requestAdjustLayout()};R.prototype._hasDynamicTitle=function(){var e=this.getHeaderTitle();return e&&e.isDynamic()};R.prototype._attachVisualIndicatorsPressHandlers=function(e,t){var i=this.getHeaderTitle(),o=this._getHeaderContent();if(D(i)&&!this._bAlreadyAttachedTitleIndicatorPressHandler){i.attachEvent(R.EVENTS.TITLE_VISUAL_INDICATOR_PRESS,function(){e.call(t);if(this._headerBiggerThanAllowedToBeExpandedInTitleArea()){this._scrollBelowCollapseVisualIndicator()}this._focusCollapseVisualIndicator()},this);this._bAlreadyAttachedTitleIndicatorPressHandler=true}if(D(o)&&!this._bAlreadyAttachedHeaderIndicatorPressHandler){o.attachEvent(R.EVENTS.HEADER_VISUAL_INDICATOR_PRESS,function(){e.call(t);this._focusExpandVisualIndicator()},this);this._bAlreadyAttachedHeaderIndicatorPressHandler=true}};R.prototype._hasVisibleDynamicTitleAndHeader=function(){var e=this.getHeaderTitle(),t=this.getHeaderContent();return this._hasVisibleDynamicTitle(e)&&this._hasVisibleHeaderContent(t)};R.prototype._hasVisibleDynamicTitle=function(e){return D(e)&&e.isDynamic()&&e.getVisible()};R.prototype._hasVisibleHeaderContent=function(e){return D(e)&&e.length>0&&this.getShowHeaderContent()};R.prototype._hasDynamicTitleWithSnappedTitleOnMobile=function(){var e=this.getHeaderTitle();return D(e)&&e.isDynamic()&&!!e.getSnappedTitleOnMobile()&&r.system.phone};R.prototype._updateToggleHeaderVisualIndicators=function(){var e,t,i,o=this._hasVisibleDynamicTitleAndHeader();if(!this.getToggleHeaderOnTitleClick()||!o){t=false;i=false}else{e=this._bHeaderExpanded;t=e;i=!e&&!this._hasDynamicTitleWithSnappedTitleOnMobile()}this._toggleCollapseVisualIndicator(t);this._toggleExpandVisualIndicator(i)};R.prototype._updateTitleVisualState=function(){var e=this.getHeaderTitle(),t=this._hasVisibleDynamicTitleAndHeader()&&this.getToggleHeaderOnTitleClick()&&!this._hasDynamicTitleWithSnappedTitleOnMobile();this.$().toggleClass("sapUxAPObjectPageLayoutTitleClickEnabled",t);if(D(e)){e._toggleFocusableState(t)}};R.prototype._focusCollapseVisualIndicator=function(){var e=this._getHeaderContent();if(D(e)){e._focusCollapseButton()}};R.prototype._focusExpandVisualIndicator=function(){var e=this.getHeaderTitle();if(D(e)){e._focusExpandButton()}};R.prototype._toggleExpandVisualIndicator=function(e){var t=this.getHeaderTitle();if(D(t)){t._toggleExpandButton(e)}};R.prototype._toggleCollapseVisualIndicator=function(e){var t=this._getHeaderContent();if(D(t)){t._toggleCollapseButton(e)}};R.prototype._attachVisualIndicatorMouseOverHandlers=function(e,t,i){var o=this._getHeaderContent();if(D(o)&&!this._bAlreadyAttachedVisualIndicatorMouseOverOutHandler){o.attachEvent(R.EVENTS.VISUAL_INDICATOR_MOUSE_OVER,e,i);o.attachEvent(R.EVENTS.VISUAL_INDICATOR_MOUSE_OUT,t,i);this._bAlreadyAttachedVisualIndicatorMouseOverOutHandler=true}};R.prototype._attachTitleMouseOverHandlers=function(e,t,i){var o=this.getHeaderTitle();if(D(o)&&!this._bAlreadyAttachedTitleMouseOverOutHandler){o.attachEvent(R.EVENTS.TITLE_MOUSE_OVER,e,i);o.attachEvent(R.EVENTS.TITLE_MOUSE_OUT,t,i);this._bAlreadyAttachedTitleMouseOverOutHandler=true}};R.prototype._suppressScroll=function(){this._bSuppressScroll=true};R.prototype._resumeScroll=function(){this._bSuppressScroll=false;if(this._iStoredScrollTop){this._scrollTo(this._iStoredScrollTop,0)}else{this._onScroll({target:{scrollTop:this._$opWrapper.scrollTop()}})}};R.prototype._addHoverClass=function(){var e=this.$();if(e){e.addClass("sapUxAPObjectPageLayoutTitleForceHovered")}};R.prototype._removeHoverClass=function(){var e=this.$();if(e){e.removeClass("sapUxAPObjectPageLayoutTitleForceHovered")}};R.prototype._getHeight=function(e){return!(e instanceof o)?0:e.$().outerHeight()||0};R.prototype._getWidth=function(e){var t=e.getDomRef();return!(e instanceof o)?0:t&&t.offsetWidth||0};R.prototype._getSectionInfoIsDirty=function(){return this.bSectionInfoIsDirty};R.prototype._setSectionInfoIsDirty=function(e){this.bSectionInfoIsDirty=e};R.prototype._getAriaLabelText=function(e,t){var i=this.getHeaderTitle(),o=i?i.getTitleText():null,n;if(i&&o&&e!=="ROOT"){n=o;if(t){n+=" "+R._getLibraryResourceBundle().getText(e+"_ARIA_LABEL_WITH_TITLE")}}else{n=R._getLibraryResourceBundle().getText(e+"_ARIA_LABEL_WITHOUT_TITLE")}return n};R.prototype._getFooterHeight=function(){if(this.getFooter()&&this.getShowFooter()){var e=this.$("footerWrapper").get(0),t=this._getDOMRefHeight(e),i=e?parseFloat(getComputedStyle(e).marginBottom):0;return t+i}return 0};R.prototype._getDOMRefHeight=function(e){return e&&e.parentElement?e.getBoundingClientRect().height:0};R.prototype._updateAriaLabels=function(){var e=this.getLandmarkInfo(),t=this._getAriaLabelText("ROOT",true),i=this._getAriaLabelText("HEADER",true),o=this._getAriaLabelText("NAVIGATION",false),n=this._getAriaLabelText("NAVTOOLBAR",true),r=e&&e.getHeaderLabel(),s=e&&e.getRootLabel(),a=e&&e.getNavigationLabel();if(!s){this.$().attr("aria-label",t)}if(!r){this.$("headerTitle").attr("aria-label",i)}if(!a){this.$("anchorBar").attr("aria-label",o);this.$("stickyAnchorBar").attr("aria-label",o)}this.$("anchBar").attr("aria-label",n)};R.prototype._formatLandmarkInfo=function(e,t){if(e){var i=e["get"+t+"Role"]()||"",o=e["get"+t+"Label"]()||"";if(i===L.None){i=""}return{role:i.toLowerCase(),label:o}}return{}};R.prototype._getHeaderTag=function(e){if(e&&e.getHeaderRole()!==L.None){return R.DIV}return R.HEADER};R.prototype._getFooterTag=function(e){if(e&&e.getFooterRole()!==L.None){return R.DIV}return R.FOOTER};function D(e){if(arguments.length===1){return Array.isArray(e)?e.length>0:!!e}return Array.prototype.slice.call(arguments).every(function(e){return D(e)})}return R});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/ObjectPageLayoutABHelper", ["sap/ui/thirdparty/jquery","sap/ui/base/Object","sap/ui/core/Core","sap/ui/core/CustomData","sap/ui/base/ManagedObjectObserver","./AnchorBar","sap/m/Button","sap/m/MenuButton","sap/m/Menu","sap/m/MenuItem","sap/ui/core/IconPool","sap/ui/core/InvisibleText"],function(jQuery,t,e,n,o,a,i,r,s,u,c,g){"use strict";var h=t.extend("sap.uxap._helpers.AB",{constructor:function(t){this._oObjectPageLayout=t;this._oObserver=new o(this._proxyStateChanges.bind(this));this._aMenusWithAttachPressHandler=[]},getInterface:function(){return this}});h._focusSection=function(t,e){var n=t.getDomRef();if(n){n.focus(e)}};h.prototype.getObjectPageLayout=function(){return this._oObjectPageLayout};h.prototype._proxyStateChanges=function(t){var e=t.object,n=this._findExistingClone(e),o=t.name,a=t.current,i="set"+l(o);if(n){n[i].call(n,a)}};h.prototype._findExistingClone=function(t){var e,n=t.getId()+"-__clone",o=this._getAnchorBar(),a=o.getContent();a.some(function(t){if(t.getId().indexOf(n)===0){e=t;return true}});return e};h.prototype._getAnchorBar=function(){var t=this.getObjectPageLayout(),e=t.getAggregation("_anchorBar");if(!e){e=new a({id:t.getId()+"-anchBar",showPopover:t.getShowAnchorBarPopover(),backgroundDesign:t.getBackgroundDesignAnchorBar()});e.attachEvent("_anchorPress",t.onAnchorBarTabPress,t);this.getObjectPageLayout().setAggregation("_anchorBar",e,true)}return e};h.prototype._setCustomData=function(t,e,o,a){o._oSectionInfo[e.getId()].buttonId=t.getId();t.addCustomData(new n({key:"sectionId",value:e.getId()}));t.addCustomData(new n({key:"bTitleVisible",value:e._getInternalTitleVisible()}));if(!a){t.addCustomData(new n({key:"secondLevel",value:true}))}};h.prototype._buildAnchorBar=function(){var t=this.getObjectPageLayout(),e=t.getSections()||[],o=this._getAnchorBar(),a=jQuery.proxy(o.onButtonPress,o),i,c,h,l,f=g.getStaticId("sap.m","SPLIT_BUTTON_DESCRIPTION");if(o&&this.getObjectPageLayout().getShowAnchorBar()){o._resetControl();this._oObserver.disconnect();e.forEach(function(e){if(!e.getVisible()||!e._getInternalVisible()){return}var g,d=e.getSubSections()||[];g=this._buildAnchorBarButton(e,true);if(g){o.addContent(g);if(g instanceof r){var _=new s({});g.enhanceAccessibilityState=function(t,e){var n=o.getContent(),a=n.indexOf(t.getParent());if(a!==-1){e.role="option";e.setsize=n.length;e.posinset=a+1;e.labelledby=e.labelledby.split(" ").filter(function(t){return t!==f}).join(" ")}};_._setCustomEnhanceAccStateFunction(function(t,e){e.controls=t.data("sectionId")});g.setMenu(_)}d.forEach(function(e){if(!e.getVisible()||!e._getInternalVisible()){return}var s=this._buildAnchorBarButton(e,false),f=o.getId()+"-"+e.getId()+"-anchor";if(s){o.addContent(s)}if(g instanceof r){l=e.getCustomAnchorBarButton();if(l){i=l.getText();c=l.getIcon()}else{i=e._getInternalTitle()||e.getTitle();c=""}h=new u(f,{text:i,icon:c});h.addCustomData(new n({key:"sectionId",value:e.getId()}));h.attachPress(a);this._setCustomData(h,e,t,false);g.getMenu().addItem(h)}},this)}},this)}};h.prototype._moveFocusOnSection=function(t){var e=t.data(),n=sap.ui.getCore().byId(e.sectionId),o={preventScroll:true},a;if(n){if(n.isActive()){h._focusSection(n,o)}else{a={onAfterRendering:function(){n.removeEventDelegate(a);h._focusSection(n,o)}};n.addEventDelegate(a)}}};h.prototype._instantiateAnchorBarButton=function(t,e,n){var o,a;if(t){o=r;a={type:"Transparent",buttonMode:"Split",useDefaultActionOnly:true,ariaDescribedBy:e}}else{o=i;a={ariaDescribedBy:e}}if(n){a.id=n}return new o(a)};h.prototype._buildAnchorBarButton=function(t,e){var o=null,a=this.getObjectPageLayout(),i,r=this._getAnchorBar(),s,u,c,g,h=t.getAggregation("subSections"),l=jQuery.proxy(r.onButtonPress,r);if(t.getVisible()&&t._getInternalVisible()){i=t.getCustomAnchorBarButton();if(!i){s=r.getId()+"-"+t.getId()+"-anchor";if(e){if(h&&h.length>1){g=h.filter(function(t){return t.getVisible()&&t._getInternalVisible()}).length}}c=e&&g>1&&r.getShowPopover();if(c){o=this._instantiateAnchorBarButton(true,t,s);o.attachDefaultAction(l);o._getButtonControl().attachPress(function(){this.getParent().focus()});o._getButtonControl().attachArrowPress(function(){var t=o._getButtonControl();if(this._aMenusWithAttachPressHandler[t.getId()]){return}o.getMenu().attachItemSelected(function(t){this._moveFocusOnSection(t.getParameter("item"))},this);this._aMenusWithAttachPressHandler[t.getId()]=true},this);o.addCustomData(new n({key:"bHasSubMenu",value:true}))}else if(e){o=this._instantiateAnchorBarButton(false,t,s);o.attachPress(function(t){this._moveFocusOnSection(t.getSource())},this);o.attachPress(l)}else{u=r.getId()+"-"+t.getId()+"-sub-anchor";o=this._instantiateAnchorBarButton(false,t,u)}var f=t._getInternalTitle()!=""?t._getInternalTitle():t.getTitle();o.setText(f)}else{o=i.clone();o.attachPress(function(t){this._moveFocusOnSection(t.getSource())},this);o.attachPress(l);this._oObserver.observe(i,{properties:true})}this._setCustomData(o,t,a,e)}return o};function l(t){return t.substring(0,1).toUpperCase()+t.substring(1)}return h});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/ObjectPageLayoutRenderer", [],function(){"use strict";var e={apiVersion:2};e.render=function(e,t){var a,r=t.getHeaderTitle(),n=null,o=sap.ui.getCore().getLibraryResourceBundle("sap.uxap"),i=t.getHeaderContent()&&t.getHeaderContent().length>0&&t.getShowHeaderContent(),s=t.getShowTitleInHeaderContent()&&t.getShowHeaderContent(),l=i||s,c=t.getUseIconTabBar(),d=t.getToggleHeaderOnTitleClick()&&t.getHeaderTitle()&&t.getHeaderTitle().supportsToggleHeaderOnTitleClick(),g=t._getAriaLabelText("ROOT",true),p=t._getAriaLabelText("HEADER",true),f=t.getBackgroundDesignAnchorBar(),u=t.getLandmarkInfo(),C=t._getHeaderTag(u),P=t._getFooterTag(u),A=u&&u.getHeaderRole(),h=u&&u.getHeaderLabel(),b=u&&u.getRootRole(),I=u&&u.getRootLabel(),O=u&&u.getNavigationRole(),T=t.getShowFooter();if(t.getShowAnchorBar()&&t._getInternalAnchorBarVisible()){n=t.getAggregation("_anchorBar")}e.openStart("div",t);if(!b){e.attr("role","main")}e.attr("aria-roledescription",o.getText("ROOT_ROLE_DESCRIPTION"));if(!I){e.attr("aria-label",g)}e.class("sapUxAPObjectPageLayout");if(T){e.class("sapUxAPObjectPageLayoutFooterVisible")}if(d){e.class("sapUxAPObjectPageLayoutTitleClickEnabled")}if(!l){e.class("sapUxAPObjectPageLayoutNoHeaderContent")}if(!n||!n.getVisible()){e.class("sapUxAPObjectPageLayoutNoAnchorBar")}e.style("height",t.getHeight());e.accessibilityState(t,t._formatLandmarkInfo(u,"Root"));e.openEnd();e.openStart(C,t.getId()+"-headerTitle");if(!A){e.attr("role","banner")}e.attr("aria-roledescription",o.getText("HEADER_ROLE_DESCRIPTION"));if(!h){e.attr("aria-label",p)}e.attr("data-sap-ui-customfastnavgroup",true).class("sapUxAPObjectPageHeaderTitle").class("sapContrastPlus").accessibilityState(t,t._formatLandmarkInfo(u,"Header")).openEnd();if(r){e.renderControl(r)}this._renderHeaderContentDOM(e,t,t._bHeaderInTitleArea,"-stickyHeaderContent");e.openStart("div",t.getId()+"-stickyAnchorBar");e.attr("data-sap-ui-customfastnavgroup",true);if(!O){e.attr("role","navigation")}e.attr("aria-roledescription",o.getText("NAVIGATION_ROLE_DESCRIPTION"));if(!t._bHeaderInTitleArea){e.attr("aria-hidden","true")}e.class("sapUxAPObjectPageStickyAnchorBar").class("sapUxAPObjectPageNavigation").class("ui-helper-clearfix");if(f){e.class("sapUxAPObjectPageNavigation"+f)}e.accessibilityState(t,t._formatLandmarkInfo(u,"Navigation"));e.openEnd();this._renderAnchorBar(e,t,n,t._bHeaderInTitleArea);e.close("div");e.close(C);e.openStart("div",t.getId()+"-opwrapper").class("sapUxAPObjectPageWrapper");if(r&&(!r.supportsTitleInHeaderContent()||!(t.getShowTitleInHeaderContent()&&r.getShowTitleSelector()))){e.class("sapUxAPObjectPageWrapperTransform")}e.openEnd();e.openStart("div",t.getId()+"-scroll").class("sapUxAPObjectPageScroll").openEnd();this._renderHeaderContentDOM(e,t,!t._bHeaderInTitleArea,"-headerContent",true);e.openStart("section",t.getId()+"-anchorBar");e.attr("data-sap-ui-customfastnavgroup",true);if(!O){e.attr("role","navigation")}e.attr("aria-roledescription",o.getText("NAVIGATION_ROLE_DESCRIPTION"));e.class("sapUxAPObjectPageNavigation").class("ui-helper-clearfix").class("sapContrastPlus");if(f){e.class("sapUxAPObjectPageNavigation"+f)}e.accessibilityState(t,t._formatLandmarkInfo(u,"Navigation"));e.openEnd();this._renderAnchorBar(e,t,n,!t._bHeaderInTitleArea);e.close("section");e.openStart("section",t.getId()+"-sectionsContainer");e.class("sapUxAPObjectPageContainer");e.class("ui-helper-clearfix");if(!n){e.class("sapUxAPObjectPageContainerNoBar")}e.accessibilityState(t,t._formatLandmarkInfo(u,"Content"));e.openEnd();a=t._getSectionsToRender();if(Array.isArray(a)){a.forEach(function(a){e.renderControl(a);if(c){t._oCurrentTabSection=a}})}e.close("section");this.renderFooterContent(e,t);e.openStart("div",t.getId()+"-spacer").openEnd().close("div");e.close("div");e.close("div");this._renderFooterContentInternal(e,t,P,u,o);e.close("div")};e._renderAnchorBar=function(e,t,a,r){var n=t.getAggregation("sections"),o;if(r){o=t._getHeaderContent();if(t.getIsChildPage()&&o&&o.supportsChildPageDesign()){e.openStart("div",t.getId()+"-childPageBar");if(Array.isArray(n)&&n.length>1){e.class("sapUxAPObjectChildPage")}e.openEnd();e.close("div")}if(a){e.renderControl(a)}}};e._renderHeaderContentDOM=function(e,t,a,r,n){e.openStart("header",t.getId()+r).class("ui-helper-clearfix").class("sapUxAPObjectPageHeaderDetails");e.class("sapUxAPObjectPageHeaderDetailsDesign-"+t._getHeaderDesign());if(n){e.class("sapContrastPlus")}e.attr("data-sap-ui-customfastnavgroup",true).openEnd();if(a){this.renderHeaderContent(e,t)}e.close("header")};e.renderHeaderContent=function(e,t){e.renderControl(t._getHeaderContent())};e.renderFooterContent=function(e,t){};e._renderFooterContentInternal=function(e,t,a,r,n){var o=t.getFooter(),i=r&&r.getFooterRole();if(!o){return}e.openStart(a,t.getId()+"-footerWrapper");e.class("sapUxAPObjectPageFooter").class("sapMFooter-CTX").class("sapContrast").class("sapContrastPlus");if(!t.getShowFooter()){e.class("sapUiHidden")}if(!i){e.attr("role","region")}e.attr("aria-roledescription",n.getText("FOOTER_ROLE_DESCRIPTION"));e.accessibilityState(t,t._formatLandmarkInfo(r,"Footer"));e.openEnd();o.addStyleClass("sapUxAPObjectPageFloatingFooter");e.renderControl(o);e.close(a)};e._rerenderHeaderContentArea=function(e,t){var a=t._bHeaderInTitleArea?"stickyHeaderContent":"headerContent",r;this.renderHeaderContent(e,t);r=t.$(a)[0];if(r){e.flush(r)}};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/ObjectPageLazyLoader", ["./library","sap/ui/core/Element","sap/ui/core/StashedControlSupport","sap/base/assert","sap/ui/base/Object"],function(e,t,a,n,r){"use strict";var s=t.extend("sap.uxap.ObjectPageLazyLoader",{metadata:{library:"sap.uxap",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}},defaultAggregation:"content"}});a.mixInto(s);s.prototype.setParent=function(e){if(!(e===null||r.isObjectA(e,"sap.uxap.ObjectPageSubSection"))){n(false,"setParent(): oParent must be an instance of sap.uxap.ObjectPageSubSection or null")}return t.prototype.setParent.apply(this,arguments)};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/ObjectPageSection", ["./ObjectPageSectionBase","sap/ui/Device","sap/m/Button","sap/ui/core/ResizeHandler","sap/ui/core/StashedControlSupport","sap/ui/base/ManagedObjectObserver","./ObjectPageSubSection","./library","sap/m/library","./ObjectPageSectionRenderer"],function(t,e,i,o,n,s,r,a,u,l){"use strict";var p=u.ButtonType;var d=t.extend("sap.uxap.ObjectPageSection",{metadata:{library:"sap.uxap",properties:{showTitle:{type:"boolean",group:"Appearance",defaultValue:true},titleUppercase:{type:"boolean",group:"Appearance",defaultValue:true},wrapTitle:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"subSections",aggregations:{subSections:{type:"sap.uxap.ObjectPageSubSection",multiple:true,singularName:"subSection",forwarding:{getter:"_getGrid",aggregation:"content"}},heading:{type:"sap.ui.core.Control",multiple:false},_showHideAllButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_showHideButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"}},associations:{selectedSubSection:{type:"sap.uxap.ObjectPageSubSection",multiple:false}},designtime:"sap/uxap/designtime/ObjectPageSection.designtime"},renderer:l});d.MEDIA_RANGE=e.media.RANGESETS.SAP_STANDARD;d._getClosestSection=function(t){var e=typeof t==="string"&&sap.ui.getCore().byId(t)||t;return e instanceof r?e.getParent():e};d._getLibraryResourceBundle=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.uxap")};d.prototype.getSectionText=function(t){return d._getLibraryResourceBundle().getText("SECTION_CONTROL_NAME")};d.prototype._expandSection=function(){t.prototype._expandSection.call(this)._updateShowHideAllButton(!this._thereAreHiddenSubSections())};d.prototype.init=function(){t.prototype.init.call(this);this._sContainerSelector=".sapUxAPObjectPageSectionContainer";this._onResizeRef=this._onResize.bind(this);this._oGridContentObserver=new s(this._onGridContentChange.bind(this))};d.prototype.exit=function(){this._detachMediaContainerWidthChange(this._updateImportance,this);if(this._iResizeHandlerId){o.deregister(this._iResizeHandlerId);this._iResizeHandlerId=null}if(t.prototype.exit){t.prototype.exit.call(this)}};d.prototype._onResize=function(){this._updateMultilineContent()};d.prototype._getImportanceLevelToHide=function(t){var e=this._getObjectPageLayout(),i=t||this._getCurrentMediaContainerRange(),o=e&&e.getShowOnlyHighImportance();return this._determineTheLowestLevelOfImportanceToShow(i.name,o)};d.prototype._updateImportance=function(t){var e=this._getObjectPageLayout(),i=this._getImportanceLevelToHide(t),o=this.bOutput&&this.getDomRef("header");this.getSubSections().forEach(function(t){t._applyImportanceRules(i)});this._applyImportanceRules(i);this._updateShowHideAllButton(false);o&&o.classList.toggle("sapUxAPObjectPageSectionHeaderHidden",!this._isTitleVisible());o&&o.setAttribute("aria-hidden",!this._isTitleAriaVisible());if(e&&this.getDomRef()){e._requestAdjustLayout()}};d.prototype._updateMultilineContent=function(){var t=this.getSubSections(),e=t.find(function(t){return t.getVisible()});if(e&&e.getDomRef()){var i=e._getTitleDomId(),o,n,s,r,a;if(!i){return}a=document.getElementById(e._getTitleDomId());o=a?a.offsetWidth:0;n=this.$().find(".sapUxAPObjectPageSubSectionHeaderActions").width();s=this.$("header").width();r=o+n>s;e._toggleMultiLineSectionContent(r)}};d.prototype._determineTheLowestLevelOfImportanceToShow=function(t,e){if(e||t==="Phone"){return a.Importance.High}if(t==="Tablet"){return a.Importance.Medium}return a.Importance.Low};d.prototype.connectToModels=function(){this.getSubSections().forEach(function(t){t.connectToModels()})};d.prototype._allowPropagationToLoadedViews=function(t){this.getSubSections().forEach(function(e){e._allowPropagationToLoadedViews(t)})};d.prototype.onBeforeRendering=function(){t.prototype.onBeforeRendering.call(this);this._detachMediaContainerWidthChange(this._updateImportance,this);this._updateImportance();this._applyLayout()};d.prototype.onAfterRendering=function(){this._updateMultilineContent();this._attachMediaContainerWidthChange(this._updateImportance,this);this._iResizeHandlerId=o.register(this,this._onResizeRef)};d.prototype._applyLayout=function(){var t={M:2,L:3,XL:4},e=this.getSubSections();this._resetLayoutData(e);this._assignLayoutData(e,t);return this};d.prototype._getMinRequiredColspanForChild=function(t){return t?t._getMinRequiredColspan():0};d.prototype._allowAutoextendColspanForChild=function(t){return true};d.prototype._onGridContentChange=function(t){var e;if(t.type==="aggregation"&&["content","subSections"].indexOf(t.name)>-1){this.invalidate();e=t.mutation;if(e==="add"||e==="insert"){this._oGridContentObserver.observe(t.child,{properties:["visible"]})}else if(t.mutation==="remove"){this._oGridContentObserver.unobserve(t.child)}}if(t.type==="property"&&t.name==="visible"){this.invalidate()}};d.prototype._isTitleVisible=function(){return this.getShowTitle()&&this._getInternalTitleVisible()||this._getInternalTitleForceVisible()};d.prototype._isTitleAriaVisible=function(){return this.getShowTitle()||this._getInternalTitleForceVisible()};d.prototype._getInternalTitleForceVisible=function(){return this._getShouldDisplayExpandCollapseButton()||this._getShouldDisplayShowHideAllButton()};d.prototype._setSubSectionsFocusValues=function(){var t=this._getVisibleSubSections()||[],e=this.getSelectedSubSection(),i;if(t.length===0){return this}if(t.length===1){t[0]._setToFocusable(false);return this}t.forEach(function(t){if(e===t.getId()){t._setToFocusable(true);i=true}else{t._setToFocusable(false)}});if(!i){t[0]._setToFocusable(true)}return this};d.prototype._disableSubSectionsFocus=function(){var t=this.getSubSections()||[];t.forEach(function(t){t._setToFocusable(false)});return this};d.prototype._thereAreHiddenSubSections=function(){return this.getSubSections().some(function(t){return t._getIsHidden()})};d.prototype._updateShowHideSubSections=function(t){this.getSubSections().forEach(function(e){if(t&&e._shouldBeHidden()){e._updateShowHideState(true)}else if(!t){e._updateShowHideState(false)}})};d.prototype._getShouldDisplayShowHideAllButton=function(){return this.getSubSections().some(function(t){return t._shouldBeHidden()})};d.prototype._getShouldDisplayExpandCollapseButton=function(){return this._getIsHidden()};d.prototype._showHideContentAllContent=function(){var t=this._thereAreHiddenSubSections();if(this._getIsHidden()&&t){this._updateShowHideState(false)}this._updateShowHideSubSections(!t);this._updateShowHideAllButton(t)};d.prototype._updateShowHideState=function(e){if(this._getIsHidden()===e){return this}this._updateShowHideButton(e);this._getShowHideAllButton().setVisible(this._getShouldDisplayShowHideAllButton());return t.prototype._updateShowHideState.call(this,e)};d.prototype._updateShowHideAllButton=function(t){this._getShowHideAllButton().setVisible(this._getShouldDisplayShowHideAllButton()).setText(this._getShowHideAllButtonText(t))};d.prototype._getVisibleSubSections=function(){return this.getSubSections().filter(function(t){return t.getVisible()&&t._getInternalVisible()})};d.prototype._getShowHideAllButton=function(){if(!this.getAggregation("_showHideAllButton")){this.setAggregation("_showHideAllButton",new i({visible:this._getShouldDisplayShowHideAllButton(),text:this._getShowHideAllButtonText(!this._thereAreHiddenSubSections()),press:this._showHideContentAllContent.bind(this),type:p.Transparent}).addStyleClass("sapUxAPSectionShowHideButton"),true)}return this.getAggregation("_showHideAllButton")};d.prototype._getShowHideButtonText=function(t){return d._getLibraryResourceBundle().getText(t?"HIDE":"SHOW")};d.prototype._getShowHideAllButtonText=function(t){return d._getLibraryResourceBundle().getText(t?"HIDE_ALL":"SHOW_ALL")};d.prototype._updateShowHideButton=function(t){this._getShowHideButton().setVisible(this._shouldBeHidden()).setText(this._getShowHideButtonText(!t))};d.prototype._getShowHideButton=function(){if(!this.getAggregation("_showHideButton")){this.setAggregation("_showHideButton",new i({visible:this._shouldBeHidden(),text:this._getShowHideButtonText(!this._getIsHidden()),press:this._showHideContent.bind(this),type:p.Transparent}).addStyleClass("sapUxAPSectionShowHideButton"),true)}return this.getAggregation("_showHideButton")};n.mixInto(d);return d});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/ObjectPageSectionBase", ["sap/ui/core/InvisibleText","sap/ui/thirdparty/jquery","sap/ui/core/Control","sap/ui/core/library","./library","sap/base/Log","sap/ui/events/KeyCodes","sap/ui/core/Configuration","sap/ui/layout/Grid","sap/ui/layout/GridData","sap/ui/dom/jquery/Focusable"],function(t,jQuery,e,i,n,o,a,r,s,l){"use strict";var u=i.TitleLevel;var g=e.extend("sap.uxap.ObjectPageSectionBase",{metadata:{abstract:true,library:"sap.uxap",properties:{title:{type:"string",group:"Appearance",defaultValue:null},titleLevel:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:u.Auto},visible:{type:"boolean",group:"Appearance",defaultValue:true},importance:{type:"sap.uxap.Importance",group:"Behavior",defaultValue:n.Importance.High}},aggregations:{ariaLabelledBy:{type:"sap.ui.core.InvisibleText",multiple:false,visibility:"hidden"},customAnchorBarButton:{type:"sap.m.Button",multiple:false},_grid:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}}},renderer:null});g.prototype.init=function(){this._bInternalVisible=true;this._bInternalTitleVisible=true;this._sInternalTitle="";this._sInternalTitleLevel=u.Auto;this._isHidden=false;this._oGridContentObserver=null;this._bRtl=r.getRTL()};g.prototype.onAfterRendering=function(){if(this._getObjectPageLayout()){this._getObjectPageLayout()._requestAdjustLayout().catch(function(){o.debug("ObjectPageSectionBase :: cannot adjustLayout",this)});this._getObjectPageLayout()._setSectionsFocusValues()}};g.prototype.onBeforeRendering=function(){var t="ariaLabelledBy";if(!this.getAggregation(t)){this.setAggregation(t,this._getAriaLabelledBy(),true)}else{this.updateInvisibleTextLabelValue()}};g.prototype.exit=function(){if(this._oInvisibleText){this._oInvisibleText.destroy();this._oInvisibleText=null}};g.prototype._getGrid=function(){if(!this.getAggregation("_grid")&&!this._bIsBeingDestroyed){this.setAggregation("_grid",new s({id:this.getId()+"-innerGrid",defaultSpan:"XL12 L12 M12 S12",hSpacing:1,vSpacing:1,width:"100%",containerQuery:true}),true);if(this._oGridContentObserver){this._oGridContentObserver.observe(this.getAggregation("_grid"),{aggregations:["content","subSections"]})}}return this.getAggregation("_grid")};g.prototype._resetLayoutData=function(t){t.forEach(function(t){if(t.getLayoutData()){t.destroyLayoutData()}},this)};g.prototype._assignLayoutData=function(t,e){var i=12,n=[],o=[],a,r,s,u;a={iRemaining:e.M,iColumnConfig:e.M};r={iRemaining:e.L,iColumnConfig:e.L};s={iRemaining:e.XL,iColumnConfig:e.XL};u=[s,r,a];t.forEach(function(t){if(t.getVisible&&t.getVisible()){n.push(t)}else{o.push(t)}});n.forEach(function(t,e){u.forEach(function(i){i.iCalculatedSize=this._getEffectiveColspanForGridItem(t,i.iRemaining,n,e,i.iColumnConfig)},this);t.setLayoutData(new l({spanS:i,spanM:a.iCalculatedSize*(i/a.iColumnConfig),spanL:r.iCalculatedSize*(i/r.iColumnConfig),spanXL:s.iCalculatedSize*(i/s.iColumnConfig),linebreakM:e>0&&a.iRemaining===a.iColumnConfig,linebreakL:e>0&&r.iRemaining===r.iColumnConfig,linebreakXL:e>0&&s.iRemaining===s.iColumnConfig}));if(t.isA("sap.uxap.ObjectPageSubSection")){t._oLayoutConfig={M:a.iCalculatedSize,L:r.iCalculatedSize,XL:s.iCalculatedSize}}u.forEach(function(t){t.iRemaining-=t.iCalculatedSize;if(t.iRemaining<1){t.iRemaining=t.iColumnConfig}})},this);o.forEach(function(t){t.setLayoutData(new l({visibleS:false,visibleM:false,visibleL:false,visibleXL:false}))});return n};g.prototype._getEffectiveColspanForGridItem=function(t,e,i,n,o){var a,r=o,s,l=this._getMinRequiredColspanForChild(t);if(!this._allowAutoextendColspanForChild(t)){return Math.min(o,l)}for(s=1;s<=r;s++){a=this._getMinRequiredColspanForChild(i[n+s]);if(a<=e-l){e-=a}else{break}}return e};g.prototype._getMinRequiredColspanForChild=function(t){};g.prototype._allowAutoextendColspanForChild=function(t){};g.prototype.setCustomAnchorBarButton=function(t){var e=this.setAggregation("customAnchorBarButton",t,true);if(this._getObjectPageLayout()){this._getObjectPageLayout()._updateNavigation()}return e};g.prototype.getSectionText=function(){return""};g.prototype.updateInvisibleTextLabelValue=function(){var t=this.getAggregation("ariaLabelledBy"),e=this._getAriaLabelledByText();if(t){sap.ui.getCore().byId(t.getId()).setText(e)}return this};g.prototype._getAriaLabelledBy=function(){var t=this._getAriaLabelledByText();return this._getInvisibleText().setText(t)};g.prototype._getAriaLabelledByText=function(){var t=this._getShouldLabelTitle()&&this._getTitle();return t||this.getSectionText()};g.prototype._getInvisibleText=function(){if(!this._oInvisibleText){this._oInvisibleText=new t;this._oInvisibleText.toStatic()}return this._oInvisibleText};g.prototype._getShouldLabelTitle=function(){return this.getShowTitle?this.getShowTitle():true};g.prototype._setInternalVisible=function(t,e){if(t!=this._bInternalVisible){this._bInternalVisible=t;if(e){this.invalidate()}}};g.prototype._getInternalVisible=function(){return this._bInternalVisible};g.prototype._setInternalTitleVisible=function(t,e){if(t!=this._bInternalTitleVisible){this._bInternalTitleVisible=t;if(e){this.invalidate()}}};g.prototype._getInternalTitleVisible=function(){return this._bInternalTitleVisible};g.prototype._setInternalTitle=function(t,e){if(t!=this._sInternalTitle){this._sInternalTitle=t;if(e){this.invalidate()}}};g.prototype._getTitle=function(){return this._getInternalTitle()||this.getTitle()};g.prototype._getInternalTitle=function(){return this._sInternalTitle};g.prototype._getARIALevel=function(){var t=this._getTitleLevel();if(t===u.Auto){t=u.H2}return t.slice(-1)};g.prototype._getTitleLevel=function(){var t=this.getTitleLevel();return t===u.Auto?this._getInternalTitleLevel():t};g.prototype._setInternalTitleLevel=function(t,e){if(t!==this._sInternalTitleLevel){this._sInternalTitleLevel=t;if(e){this.invalidate()}}};g.prototype._getInternalTitleLevel=function(){return this._sInternalTitleLevel};g.prototype._getObjectPageLayout=function(){return n.Utilities.getClosestOPL(this)};g.prototype._notifyObjectPageLayout=function(){if(this._getObjectPageLayout()&&this._getObjectPageLayout().$().length){this._getObjectPageLayout()._requestAdjustLayoutAndUxRules()}};["addAggregation","insertAggregation","removeAllAggregation","removeAggregation","destroyAggregation"].forEach(function(t){g.prototype[t]=function(i,n,o,a){if(["addAggregation","removeAggregation"].indexOf(t)>-1){a=o}if(["removeAllAggregation","destroyAggregation"].indexOf(t)>-1){a=n}var r=e.prototype[t].apply(this,arguments);if(a!==true){this._notifyObjectPageLayout()}return r}});g.prototype.setVisible=function(t,e){if(this.getVisible()===t){return this}if(!this._getObjectPageLayout()){return this.setProperty("visible",t,e)}this.setProperty("visible",t,true);this._notifyObjectPageLayout();this.invalidate();return this};g.prototype.setTitle=function(t,e){this.setProperty("title",t,e);this._notifyObjectPageLayout();this.updateInvisibleTextLabelValue();return this};g.prototype._shouldBeHidden=function(){return g._importanceMap[this.getImportance()]>g._importanceMap[this._sCurrentLowestImportanceLevelToShow]};g._importanceMap={Low:3,Medium:2,High:1};g.prototype._updateShowHideState=function(t){var e=this._getObjectPageLayout();this._isHidden=t;this.$().children(this._sContainerSelector).toggle(!t);if(e){e._requestAdjustLayout()}return this};g.prototype._getIsHidden=function(){return this._isHidden};g.prototype._expandSection=function(){return this._updateShowHideState(false)};g.prototype._showHideContent=function(){return this._updateShowHideState(!this._getIsHidden())};g.prototype._applyImportanceRules=function(t){this._sCurrentLowestImportanceLevelToShow=t;if(this.getDomRef()){this._updateShowHideState(this._shouldBeHidden())}else{this._isHidden=this._shouldBeHidden()}};g.PAGEUP_AND_PAGEDOWN_JUMP_SIZE=5;g.prototype.onkeydown=function(t){if(t.keyCode===a.SPACE&&t.srcControl.isA("sap.uxap.ObjectPageSection")){t.preventDefault()}if(t.keyCode===a.F7){var e=this.getSubSections(),i=e[0],n;if(e.length===1){n=i._oLastFocusedControlF7;if(n){n.$().trigger("focus")}else{i.$().firstFocusableDomRef().focus()}}else{if(i.getActions().length){i.getActions()[0].$().trigger("focus")}}}};g.prototype.onsapdown=function(t){var e=t.currentTarget,i=e.nextSibling;if(e.classList.contains("sapUxAPObjectPageSubSection")){var n=e.parentElement;if(n.nextElementSibling){i=n.nextElementSibling.querySelector(".sapUxAPObjectPageSubSection")}}this._handleFocusing(t,i)};g.prototype._handleFocusing=function(t,e){var i;if(this._targetIsCorrect(t)&&e){i=jQuery(t.currentTarget).parent().children();t.preventDefault();e.focus();if(i.length>1){this._scrollParent(jQuery(e).attr("id"))}}};g.prototype._targetIsCorrect=function(t){return t.srcControl===this};g.prototype.onsapright=function(t){var e=this._bRtl?"onsapup":"onsapdown";this[e](t)};g.prototype.onsapup=function(t){var e=t.currentTarget,i=e.previousSibling;if(e.classList.contains("sapUxAPObjectPageSubSection")){var n=e.parentElement;if(n.previousElementSibling){i=n.previousElementSibling.querySelector(".sapUxAPObjectPageSubSection")}}this._handleFocusing(t,i)};g.prototype.onsapleft=function(t){var e=this._bRtl?"onsapdown":"onsapup";this[e](t)};g.prototype.onsaphome=function(t){var e=t.currentTarget,i=e.parentElement.firstChild;if(e.classList.contains("sapUxAPObjectPageSubSection")){i=e.closest(".sapUxAPObjectPageSection").querySelector(".sapUxAPObjectPageSubSection")}this._handleFocusing(t,i)};g.prototype.onsapend=function(t){var e=t.currentTarget,i=e.parentElement.lastChild,n;if(e.classList.contains("sapUxAPObjectPageSubSection")){n=e.closest(".sapUxAPObjectPageSection").querySelectorAll(".sapUxAPObjectPageSubSection");i=n[n.length-1]}this._handleFocusing(t,i)};g.prototype.onsappageup=function(t){if(!this._targetIsCorrect(t)){return}t.preventDefault();var e,i=t.currentTarget;var n=jQuery(i).parent().children();var o;if(i.classList.contains("sapUxAPObjectPageSubSection")){n=jQuery(i.closest(".sapUxAPObjectPageSection")).find(".sapUxAPObjectPageSubSection")}n.each(function(i,n){if(jQuery(n).attr("id")===t.currentTarget.id){e=i-(g.PAGEUP_AND_PAGEDOWN_JUMP_SIZE+1);return}});if(e&&n[e]){n[e].focus();o=jQuery(n[e]).attr("id")}else if(n[0]){n[0].focus();o=jQuery(n[0]).attr("id")}if(n.length>1){this._scrollParent(o)}};g.prototype.onsappagedown=function(t){if(!this._targetIsCorrect(t)){return}t.preventDefault();var e,i=t.currentTarget;var n=jQuery(i).parent().children();var o;if(i.classList.contains("sapUxAPObjectPageSubSection")){n=jQuery(i.closest(".sapUxAPObjectPageSection")).find(".sapUxAPObjectPageSubSection")}n.each(function(i,n){if(jQuery(n).attr("id")===t.currentTarget.id){e=i+g.PAGEUP_AND_PAGEDOWN_JUMP_SIZE+1;return}});if(e&&n[e]){n[e].focus();o=jQuery(n[e]).attr("id")}else if(n[n.length-1]){n[n.length-1].focus();o=jQuery(n[n.length-1]).attr("id")}if(n.length>1){this._scrollParent(o)}};g.prototype._scrollParent=function(t){if(this._getObjectPageLayout()){this._getObjectPageLayout().scrollToSection(t,0,10)}};return g});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/ObjectPageSectionRenderer", ["sap/ui/core/Configuration"],function(e){"use strict";var t={apiVersion:2};t.render=function(t,i){var a,n,r,s=e.getAccessibility(),o=i.getAggregation("ariaLabelledBy"),l=i.getHeading(),c=i.getWrapTitle();if(!i.getVisible()||!i._getInternalVisible()){return}a=i._getTitle();n=i._isTitleVisible();r=!i._isTitleAriaVisible();t.openStart("section",i).class("sapUxAPObjectPageSection");if(!n){t.class("sapUxAPObjectPageSectionNoTitle")}if(c){t.class("sapUxAPObjectPageSectionWrapTitle")}t.attr("role","region");if(s&&o){t.attr("aria-labelledby",o.getId())}t.attr("data-sap-ui-customfastnavgroup",true);t.openEnd();if(l){t.openStart("div").class("sapUxAPObjectPageSectionHeading").openEnd();t.renderControl(l);t.close("div")}t.openStart("div",i.getId()+"-header").attr("role","heading").attr("aria-level",i._getARIALevel()).class("sapUxAPObjectPageSectionHeader").class(n?"":"sapUxAPObjectPageSectionHeaderHidden");if(r){t.attr("aria-hidden","true")}t.openEnd();t.openStart("div",i.getId()+"-title").class("sapUxAPObjectPageSectionTitle");if(i.getTitleUppercase()){t.class("sapUxAPObjectPageSectionTitleUppercase")}t.openEnd();t.text(a);t.close("div");if(n){t.renderControl(i._getShowHideAllButton());t.renderControl(i._getShowHideButton())}t.close("div");t.openStart("div").class("sapUxAPObjectPageSectionContainer");if(i._isHidden){t.style("display","none")}t.openEnd();t.renderControl(i._getGrid());t.close("div");t.close("section")};return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/ObjectPageSubSection", ["sap/ui/thirdparty/jquery","sap/ui/core/Core","sap/ui/core/ResizeHandler","./ObjectPageSectionBase","./ObjectPageLazyLoader","./BlockBase","sap/m/Button","sap/ui/core/StashedControlSupport","sap/ui/base/ManagedObjectObserver","sap/m/TitlePropagationSupport","./library","sap/m/library","./ObjectPageSubSectionRenderer","sap/base/Log","sap/ui/base/DataType","sap/ui/events/KeyCodes","sap/ui/dom/jquery/Focusable"],function(jQuery,t,e,o,i,r,s,n,a,g,u,h,l,p,c,f){"use strict";var d=h.ButtonType;var y=u.ObjectPageSubSectionMode;var _=u.ObjectPageSubSectionLayout;var S=o.extend("sap.uxap.ObjectPageSubSection",{metadata:{library:"sap.uxap",properties:{showTitle:{type:"boolean",group:"Appearance",defaultValue:true},_columnSpan:{type:"string",group:"Appearance",defaultValue:"all",visibility:"hidden"},mode:{type:"sap.uxap.ObjectPageSubSectionMode",group:"Appearance",defaultValue:y.Collapsed},titleUppercase:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"blocks",aggregations:{blocks:{type:"sap.ui.core.Control",multiple:true,singularName:"block"},moreBlocks:{type:"sap.ui.core.Control",multiple:true,singularName:"moreBlock"},actions:{type:"sap.ui.core.Control",multiple:true,singularName:"action"}},designtime:"sap/uxap/designtime/ObjectPageSubSection.designtime"},renderer:l});g.call(S.prototype,"blocks",function(){return this._getTitleDomId()});S.FIT_CONTAINER_CLASS="sapUxAPObjectPageSubSectionFitContainer";S.COLUMN_SPAN={all:"all",auto:"auto"};S._getLibraryResourceBundle=function(){return t.getLibraryResourceBundle("sap.uxap")};S.prototype.init=function(){o.prototype.init.call(this);this._aStashedControls=[];this._bRenderedFirstTime=false;this._aAggregationProxy={blocks:[],moreBlocks:[]};this._$spacer=[];this._sContainerSelector=".sapUxAPBlockContainer";this._sMoreContainerSelector=".sapUxAPSubSectionSeeMoreContainer";this._oObserver=new a(S.prototype._observeChanges.bind(this));this._oObserver.observe(this,{aggregations:["actions"]});this._oBlocksObserver=new a(this._onBlocksChange.bind(this));this._switchSubSectionMode(this.getMode());this._initTitlePropagationSupport();this._sBorrowedTitleDomId=false;this._height=""};S.prototype.getParent=function(){var t=o.prototype.getParent.apply(this,arguments);if(t&&t.isA("sap.ui.layout.Grid")){t=t.getParent()}return t};S.prototype.setParent=function(){var t=o.prototype.setParent.apply(this,arguments),e=this.getParent();if(e&&e.isA("sap.uxap.ObjectPageSection")&&this.sParentAggregationName!=="subSections"){this.sParentAggregationName="subSections"}return t};S.prototype._getColumnSpan=function(){return this.getProperty("_columnSpan")};S.prototype._setColumnSpan=function(t){var e=this.getProperty("_columnSpan"),o;if(e===t){return}this.setProperty("_columnSpan",t);o=this.getParent();o&&o.invalidate();return this};S.prototype._getHeight=function(){return this._height};S.prototype._setHeight=function(t){var e,o;if(this._height===t){return}e=c.getType("sap.ui.core.CSSSize");if(!e.isValid(t)){throw new Error('"'+t+'" is of type '+typeof t+", expected "+e.getName()+' for property "_height" of '+this)}this._height=t;o=this.getDomRef();if(o){o.style.height=this._height;this._adaptDomHeight()}};S.prototype._toggleContentResizeListener=function(t){if(t&&!this._iResizeId){this._iResizeId=e.register(this._getContentWrapper(),this._adaptDomHeight.bind(this))}if(!t&&this._iResizeId){e.deregister(this._iResizeId);this._iResizeId=null}};S.prototype._getContentWrapper=function(){return this.getAggregation("_grid")};S.prototype.getSectionText=function(t){return S._getLibraryResourceBundle().getText("SUBSECTION_CONTROL_NAME")};S.prototype._getShouldLabelTitle=function(){if(this._getUseTitleOnTheLeft()){return this.getShowTitle()}if(this._sBorrowedTitleDomId){return false}return this.getShowTitle()};S.prototype._getTitleDomId=function(){if(this._sBorrowedTitleDomId){return this._sBorrowedTitleDomId}if(!this.getTitle().trim()){return false}if(this._getInternalTitleVisible()){return this.getId()+"-headerTitle"}return false};S.prototype._setBorrowedTitleDomId=function(t){this._sBorrowedTitleDomId=t};S.prototype._toggleMultiLineSectionContent=function(t){this.toggleStyleClass("sapUxAPObjectPageSectionMultilineContent",t);this._bMultiLine=t};S.prototype._expandSection=function(){o.prototype._expandSection.call(this);var t=this.getParent();t&&typeof t._expandSection==="function"&&t._expandSection();return this};S.prototype._hasVisibleActions=function(){var t=this.getActions()||[];if(t.length===0){return false}return t.filter(function(t){return t.getVisible()}).length>0};S.prototype._observeChanges=function(t){var e=t.object,o=t.name,i=t.mutation,r=t.child,s;if(e===this){if(o==="actions"){if(i==="insert"){this._observeAction(r)}else if(i==="remove"){this._unobserveAction(r)}}}else if(o==="visible"){s=this._getInternalTitleVisible()&&this.getTitle().trim()!=="";if(!s){this.$("header").toggleClass("sapUiHidden",!this._hasVisibleActions())}}};S.prototype._onBlocksChange=function(){var t=this._getObjectPageLayout();if(!this._bRenderedFirstTime){return}this._applyLayout(t)};S.prototype._observeAction=function(t){this._oObserver.observe(t,{properties:["visible"]})};S.prototype._unobserveAction=function(t){this._oObserver.unobserve(t,{properties:["visible"]})};["addStyleClass","toggleStyleClass","removeStyleClass"].forEach(function(t){S.prototype[t]=function(e,i){if(e===S.FIT_CONTAINER_CLASS){this._notifyObjectPageLayout()}return o.prototype[t].apply(this,arguments)}});S.prototype._unStashControls=function(){var e;this._aStashedControls.forEach(function(o){o.control.unstash();e=t.byId(o.control.getId());this.addAggregation(o.aggregationName,e,true)}.bind(this));this._aStashedControls=[]};S.prototype.connectToModels=function(){var t=this.getBlocks()||[],e=this.getMoreBlocks()||[],o=this.getMode();this._unStashControls();t.forEach(function(t){if(t instanceof r){if(!t.getMode()){t.setMode(o)}t.connectToModels()}});if(e.length>0&&o===y.Expanded){e.forEach(function(t){if(t instanceof r){if(!t.getMode()){t.setMode(o)}t.connectToModels()}})}};S.prototype._allowPropagationToLoadedViews=function(t){var e=this.getBlocks()||[],o=this.getMoreBlocks()||[];e.forEach(function(e){if(e instanceof r){e._allowPropagationToLoadedViews(t)}});o.forEach(function(e){if(e instanceof r){e._allowPropagationToLoadedViews(t)}})};S.prototype.clone=function(){Object.keys(this._aAggregationProxy).forEach(function(t){var e=this.mAggregations[t];if(!e||e.length===0){this.mAggregations[t]=this._aAggregationProxy[t]}},this);return o.prototype.clone.apply(this,arguments)};S.prototype._cleanProxiedAggregations=function(){var t=this._aAggregationProxy;Object.keys(t).forEach(function(e){t[e].forEach(function(t){t.destroy()})})};S.prototype._unobserveBlocks=function(){var t=this.getBlocks().concat(this.getMoreBlocks());t.forEach(function(t){t&&this._oBlocksObserver.unobserve(t,{properties:["visible"]})},this)};S.prototype.exit=function(){if(this._oSeeMoreButton){this._oSeeMoreButton.destroy();this._oSeeMoreButton=null}if(this._oSeeLessButton){this._oSeeLessButton.destroy();this._oSeeLessButton=null}this._unobserveBlocks();this._oCurrentlyVisibleSeeMoreLessButton=null;this._cleanProxiedAggregations();if(o.prototype.exit){o.prototype.exit.call(this)}};S.prototype.onAfterRendering=function(){var t=this._getObjectPageLayout(),e=this.getParent();if(o.prototype.onAfterRendering){o.prototype.onAfterRendering.call(this)}if(!t){return}if(this.hasStyleClass(S.FIT_CONTAINER_CLASS)){this._toggleContentResizeListener(true)}this._$spacer=t.$("spacer");if(this._bShouldFocusSeeMoreLessButton&&document.activeElement===document.body){this._oCurrentlyVisibleSeeMoreLessButton.focus()}this._bShouldFocusSeeMoreLessButton=false;if(e&&e.hasStyleClass("sapUiTableOnObjectPageAdjustmentsForSection")){this.getAggregation("_grid").setProperty("hSpacing",0)}};S.prototype.onBeforeRendering=function(){var t=this._getObjectPageLayout();if(!t){return}if(o.prototype.onBeforeRendering){o.prototype.onBeforeRendering.call(this)}this._toggleContentResizeListener(false);this._setAggregationProxy();this._getGrid().removeAllContent();this._applyLayout(t);this.refreshSeeMoreVisibility();this.toggleStyleClass("sapUxAPObjectPageSubSectionStashed",this._aStashedControls.length?true:false)};S.prototype._adaptDomHeight=function(){var t=this.getDomRef(),e=this._height,o=this.hasStyleClass(S.FIT_CONTAINER_CLASS);if(!t){return}if(o&&e){var i=t.scrollHeight,r=Math.ceil(parseFloat(e));t.style.height=i>r?"":e;this._height=t.style.height}};S.prototype._hasRestrictedHeight=function(){var t=this.getDomRef();if(!t){return}return parseInt(t.style.height)>0};S.prototype._applyLayout=function(t){var e,o=this._getGrid(),i=o.getAggregation("content"),r=this.getMode(),s=t.getSubSectionLayout(),n=this._calculateLayoutConfiguration(s,t),a=this.getBlocks(),g=a.concat(this.getMoreBlocks());this._oLayoutConfig=n;this._resetLayoutData(g);if(r===y.Expanded){e=g}else{e=a}this._assignLayoutData(e,n);try{e.forEach(function(t){this._setBlockMode(t,r);if(!i||i&&i.indexOf(t)<0){o.addAggregation("content",t,true)}},this)}catch(t){p.error("ObjectPageSubSection :: error while building layout "+s+": "+t)}return this};S.prototype._calculateLayoutConfiguration=function(t,e){var o={M:2,L:3,XL:4},i=o.L,r=o.XL,s=t===_.TitleOnLeft,n=e.getUseTwoColumnsForLargeScreen();if(s){i-=1;r-=1}if(n){i-=1}o.L=i;o.XL=r;return o};S.prototype.refreshSeeMoreVisibility=function(){var t=this._getSeeMoreButton(),e=this._getSeeLessButton();this._bBlockHasMore=!!this.getMoreBlocks().length;if(!this._bBlockHasMore){this._bBlockHasMore=this.getBlocks().some(function(t){if(t instanceof r&&t.getVisible()&&t.getShowSubSectionMore()){return true}})}this.toggleStyleClass("sapUxAPObjectPageSubSectionWithSeeMore",this._bBlockHasMore);t.toggleStyleClass("sapUxAPSubSectionSeeMoreButtonVisible",this._bBlockHasMore);e.toggleStyleClass("sapUxAPSubSectionSeeMoreButtonVisible",this._bBlockHasMore);return this._bBlockHasMore};S.prototype.setMode=function(t){if(this.getMode()!==t){this._switchSubSectionMode(t);if(this._bRenderedFirstTime){this.invalidate()}}return this};S.prototype.onkeydown=function(e){if(e.keyCode===f.SPACE&&e.srcControl.isA("sap.uxap.ObjectPageSubSection")){e.preventDefault()}if(e.keyCode===f.F7){e.stopPropagation();var o=t.byId(e.target.id);if(o instanceof S){this._handleSubSectionF7()}else{this._handleInteractiveElF7();this._oLastFocusedControlF7=o}}};S.prototype._handleInteractiveElF7=function(){if(this.getParent().getSubSections().length>1){this.$().trigger("focus")}else{this.getParent().$().trigger("focus")}};S.prototype._handleSubSectionF7=function(t){if(this._oLastFocusedControlF7){this._oLastFocusedControlF7.$().trigger("focus")}else{this.$().firstFocusableDomRef().focus()}};S.prototype._getMinRequiredColspan=function(){var t=this._getColumnSpan(),e,o,i;if(t===S.COLUMN_SPAN.auto){e=this.getBlocks().concat(this.getMoreBlocks());o=e.filter(function(t){return t.getVisible&&t.getVisible()});return o.reduce(function(t,e){return t+this._getMinRequiredColspanForChild(e)}.bind(this),0)}i=parseInt(t);if(i>0&&i<=4){return i}return 4};S.prototype._getMinRequiredColspanForChild=function(t){var e=1;if(!t){e=0}else if(t instanceof r&&t.getColumnLayout()!="auto"){e=parseInt(t.getColumnLayout())}return e};S.prototype._allowAutoextendColspanForChild=function(t){return this._hasAutoLayout(t)};S.prototype._hasAutoLayout=function(t){return!(t instanceof r)||t.getColumnLayout()=="auto"};S.prototype._setAggregationProxy=function(){var t;if(this._bRenderedFirstTime){return}jQuery.each(this._aAggregationProxy,jQuery.proxy(function(e,o){t=this.removeAllAggregation(e,true);t.forEach(this._onAddBlock,this);this._setAggregation(e,t,true)},this));this._bRenderedFirstTime=true};S.prototype.hasProxy=function(t){return this._bRenderedFirstTime&&this._aAggregationProxy.hasOwnProperty(t)};S.prototype._getAggregation=function(t){return this._aAggregationProxy[t]};S.prototype._setAggregation=function(t,e,o){this._aAggregationProxy[t]=e;if(o!==true){this._notifyObjectPageLayout();this.invalidate()}return this._aAggregationProxy[t]};S.prototype.addAggregation=function(t,e,s){var n;if(e instanceof i){if(e.isStashed()){this._aStashedControls.push({aggregationName:t,control:e})}else{e.getContent().forEach(function(e){this.addAggregation(t,e,true)},this);e.removeAllContent();e.destroy();this.invalidate()}}else if(this.hasProxy(t)){n=this._getAggregation(t);n.push(e);this._onAddBlock(e);this._setAggregation(t,n,s);if(e instanceof r||e instanceof i){e.setParent(this,"blocks")}}else{o.prototype.addAggregation.apply(this,arguments)}return this};S.prototype.insertBlock=function(t,e){p.warning("ObjectPageSubSection :: usage of insertBlock is not supported - addBlock is performed instead.");return this.addAggregation("blocks",t)};S.prototype._onAddBlock=function(t){t&&this._oBlocksObserver.observe(t,{properties:["visible"]})};S.prototype._onRemoveBlock=function(t){t&&this._oBlocksObserver.unobserve(t,{properties:["visible"]})};S.prototype.insertMoreBlock=function(t,e){p.warning("ObjectPageSubSection :: usage of insertMoreBlock is not supported - addMoreBlock is performed instead.");return this.addAggregation("moreBlocks",t)};S.prototype.removeAllAggregation=function(t,e){var i;if(this.hasProxy(t)){i=this._getAggregation(t);this._unobserveBlocks();this._setAggregation(t,[],e);return i.slice()}return o.prototype.removeAllAggregation.apply(this,arguments)};S.prototype.removeAggregation=function(t,e){var i=false,r;if(this.hasProxy(t)&&typeof e==="object"){r=this._getAggregation(t);r.forEach(function(o,s){if(o.getId()===e.getId()){r.splice(s,1);this._onRemoveBlock(e);this._setAggregation(t,r);i=true}return!i},this);return i?e:null}return o.prototype.removeAggregation.apply(this,arguments)};S.prototype.indexOfAggregation=function(t,e){var i=-1;if(this.hasProxy(t)){this._getAggregation(t).some(function(t,o){if(t.getId()===e.getId()){i=o;return true}},this);return i}return o.prototype.indexOfAggregation.apply(this,arguments)};S.prototype.getAggregation=function(t){if(this.hasProxy(t)){return this._getAggregation(t)}return o.prototype.getAggregation.apply(this,arguments)};S.prototype.destroyAggregation=function(t){if(this.hasProxy(t)){this._getAggregation(t).forEach(function(t){t.destroy()});this._setAggregation(t,[]);return this}return o.prototype.destroyAggregation.apply(this,arguments)};S.prototype.destroy=function(){this._aStashedControls.forEach(function(t){t.control.destroy()});o.prototype.destroy.apply(this,arguments)};S.prototype._getSeeMoreButton=function(){if(!this._oSeeMoreButton){this._oSeeMoreButton=new s(this.getId()+"--seeMore",{type:d.Transparent,iconFirst:false,text:S._getLibraryResourceBundle().getText("SHOW_MORE")}).addStyleClass("sapUxAPSubSectionSeeMoreButton").attachPress(this._seeMoreLessControlPressHandler,this)}return this._oSeeMoreButton};S.prototype._getSeeLessButton=function(){if(!this._oSeeLessButton){this._oSeeLessButton=new s(this.getId()+"--seeLess",{type:d.Transparent,iconFirst:false,text:S._getLibraryResourceBundle().getText("SHOW_LESS")}).addStyleClass("sapUxAPSubSectionSeeMoreButton").attachPress(this._seeMoreLessControlPressHandler,this)}return this._oSeeLessButton};S.prototype._seeMoreLessControlPressHandler=function(t){var e=this.getMode(),o,i=this.getMoreBlocks()||[];if(e===y.Expanded){o=y.Collapsed}else{o=y.Expanded;i.forEach(function(t){if(t instanceof r){t.setMode(e);t.connectToModels()}},this)}this._switchSubSectionMode(o);this._bShouldFocusSeeMoreLessButton=true};S.prototype._switchSubSectionMode=function(t){t=this.validateProperty("mode",t);if(t===y.Collapsed){this.setProperty("mode",y.Collapsed);this._oCurrentlyVisibleSeeMoreLessButton=this._getSeeMoreButton().setVisible(true);this._getSeeLessButton().setVisible(false)}else{this.setProperty("mode",y.Expanded);this._getSeeMoreButton().setVisible(false);this._oCurrentlyVisibleSeeMoreLessButton=this._getSeeLessButton().setVisible(true)}};S.prototype._setBlockMode=function(t,e){if(t instanceof r){t.setMode(e)}else{p.debug("ObjectPageSubSection :: cannot propagate mode "+e+" to "+t.getMetadata().getName())}};S.prototype._setToFocusable=function(t){var e="0",o="-1",i="tabindex";if(t){this.$().attr(i,e)}else{this.$().attr(i,o)}return this};S.prototype._getUseTitleOnTheLeft=function(){var t=this._getObjectPageLayout();return t&&t.getSubSectionLayout()===_.TitleOnLeft};S.prototype._updateShowHideState=function(t){if(this._getIsHidden()===t){return this}this.$().children(this._sMoreContainerSelector).toggle(!t);return o.prototype._updateShowHideState.call(this,t)};S.prototype.getVisibleBlocksCount=function(){var t=this._aStashedControls.length;(this.getBlocks()||[]).forEach(function(e){if(e.getVisible&&!e.getVisible()){return true}t++});(this.getMoreBlocks()||[]).forEach(function(e){if(e.getVisible&&!e.getVisible()){return true}t++});return t};return S});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/ObjectPageSubSectionRenderer", ["sap/ui/core/Configuration"],function(e){"use strict";var t={apiVersion:2};t.render=function(t,i){var a,n,s,r,o,l,c,d=e.getAccessibility(),g=i.getAggregation("ariaLabelledBy");if(!i.getVisible()||!i._getInternalVisible()){return}a=i.getActions()||[];o=a.length>0;s=i.getShowTitle();n=i._getInternalTitleVisible()&&i.getTitle().trim()!==""&&s;r=n||o;c=i._hasVisibleActions();t.openStart("div",i).attr("role","region").style("height",i._getHeight());if(i._bBlockHasMore){t.class("sapUxAPObjectPageSubSectionWithSeeMore")}if(i._bMultiLine){t.class("sapUxAPObjectPageSectionMultilineContent")}t.class("sapUxAPObjectPageSubSection").class("ui-helper-clearfix");if(d&&g){t.attr("aria-labelledby",g.getId())}t.openEnd();if(r){t.openStart("div",i.getId()+"-header").class("sapUxAPObjectPageSubSectionHeader");if(!n&&!c){t.class("sapUiHidden")}l=i._getUseTitleOnTheLeft();if(l){t.class("titleOnLeftLayout")}t.openEnd();t.openStart("div",i.getId()+"-headerTitle");if(n){t.attr("role","heading").attr("aria-level",i._getARIALevel())}t.class("sapUxAPObjectPageSubSectionHeaderTitle");if(i.getTitleUppercase()){t.class("sapUxAPObjectPageSubSectionHeaderTitleUppercase")}t.attr("data-sap-ui-customfastnavgroup",true).openEnd();if(n){t.text(i.getTitle())}t.close("div");if(o){t.openStart("div").class("sapUxAPObjectPageSubSectionHeaderActions").attr("data-sap-ui-customfastnavgroup",true).openEnd();a.forEach(t.renderControl,t);t.close("div")}t.close("div")}t.openStart("div").class("ui-helper-clearfix").class("sapUxAPBlockContainer");if(i._isHidden){t.style("display","none")}t.openEnd();t.renderControl(i._getGrid());t.close("div");t.openStart("div").class("sapUxAPSubSectionSeeMoreContainer");if(i._isHidden){t.style("display","none")}t.openEnd();t.renderControl(i._getSeeMoreButton());t.renderControl(i._getSeeLessButton());t.close("div");t.close("div")};return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/ThrottledTaskHelper", ["sap/ui/thirdparty/jquery","sap/ui/base/Object"],function(jQuery,i){"use strict";var t=i.extend("sap.uxap.ThrottledTask",{constructor:function(i,t,s){this._fnTask=i;this._iDelay=t;this._oContext=s;this._oPromise=null;this._fnResolvePromise=null;this._fnRejectPromise=null;this._iTimer=null;this._oTaskOptions=null},reSchedule:function(i,t){var s=this._getPromise();if(this._iTimer){clearTimeout(this._iTimer);this._iTimer=null}this._oTaskOptions=this._mergeOptions(this._oTaskOptions||{},t);if(i){var e=this._fnTask.call(this._oContext,this._oTaskOptions);this._completePromise(e);return s}this._iTimer=setTimeout(function(){if(this._oPromise){var i=this._fnTask.call(this._oContext,this._oTaskOptions);this._completePromise(i)}}.bind(this),this._iDelay);return s},isPending:function(){return this._iTimer!=null},_getPromise:function(){if(!this._oPromise){this._oPromise=new Promise(function(i,t){this._fnResolvePromise=i;this._fnRejectPromise=t}.bind(this))}return this._oPromise},_completePromise:function(i){var t=i?this._fnResolvePromise:this._fnRejectPromise;t();this._oPromise=null;this._fnResolvePromise=null;this._fnRejectPromise=null;this._oTaskOptions=null},_mergeOptions:function(i,t){var s=jQuery.extend({},i,t);jQuery.each(s,function(e){s[e]=i[e]||t[e]});return s}});return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/changeHandler/AddIFrameObjectPageLayout", ["sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/changeHandler/AddIFrame","sap/ui/fl/changeHandler/common/getTargetAggregationIndex","sap/ui/fl/changeHandler/common/createIFrame"],function(e,t,n,r){"use strict";var a=Object.assign({},t);a.applyChange=function(e,a,o){var i=o.modifier;var g=e.getContent();var c=g.targetAggregation;if(c!=="sections"){return Promise.resolve().then(t.applyChange.bind(t,e,a,o))}var s=o.view;var u=o.appComponent;var l=g.selector;var f=sap.ui.getCore().getLibraryResourceBundle("sap.uxap").getText("SECTION_TITLE_FOR_IFRAME");var d;var p;return Promise.resolve().then(i.createControl.bind(i,"sap.uxap.ObjectPageSection",u,s,l,{title:f},false)).then(function(e){d=e;var t=Object.create(l);t.id+="-subSection";return i.createControl("sap.uxap.ObjectPageSubSection",u,s,t,{title:f},false)}).then(function(e){p=e;return i.insertAggregation(d,"subSections",p,0,s)}).then(function(){var t=Object.create(l);t.id+="-iframe";var n={sourceControlId:i.getId(p),selectorControlId:i.getId(d),propertyName:"title"};return r(e,o,t,n)}).then(function(e){return i.insertAggregation(p,"blocks",e,0,s)}).then(n.bind(null,e,a,o)).then(function(e){return i.insertAggregation(a,"sections",d,e,s)}).then(function(){e.setRevertData([i.getId(d)])})};a.getCondenserInfo=function(e){var n=Object.assign({},t.getCondenserInfo(e));var r=e.getContent();var a=r.targetAggregation;if(a==="sections"){n.updateControl=Object.assign({},n.affectedControl);n.updateControl.id=n.affectedControl.id+"-iframe"}return n};a.getChangeVisualizationInfo=function(t,n){var r=t.getContent().selector;var a=e.bySelector(r,n);var o=a.getParent().getAggregation("_anchorBar");var i=[r];var g=[r];o.getAggregation("content").forEach(function(e){e.getAggregation("customData").some(function(t){if(t.getKey()==="sectionId"&&a.getId()===t.getProperty("value")){g.push(e.getId())}})});return{affectedControls:i,displayControls:g}};return a},true);
/*!
	* OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
	*/
sap.ui.predefine("sap/uxap/changeHandler/MoveObjectPageSection", ["sap/base/util/merge","sap/ui/core/Core","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/changeHandler/MoveControls"],function(e,t,r,n){"use strict";var o=Object.assign({},n);o.applyChange=function(e,t,r){var o=r.modifier.targets==="jsControlTree";if(o){t._suppressScroll()}var a=n.applyChange.call(this,e,t,r);if(o){t.attachEventOnce("onAfterRenderingDOMReady",function(){t._resumeScroll(false)})}return a};o.revertChange=function(e,t,r){var o=r.modifier.targets==="jsControlTree";if(o){t._suppressScroll()}var a=n.revertChange.call(this,e,t,r);if(o){t.attachEventOnce("onAfterRenderingDOMReady",function(){t._resumeScroll(false)})}return a};o.completeChangeContent=function(e,r,o){var a=t.byId(r.source.id),i=t.byId(r.target.id);var s=Promise.resolve();if(a.isA("sap.uxap.AnchorBar")&&i.isA("sap.uxap.AnchorBar")){s=s.then(this._mapAnchorsToSections.bind(this,r,o))}return s.then(function(){return n.completeChangeContent.apply(this,arguments[0])}.bind(this,arguments))};o._mapAnchorsToSections=function(r,n){return Promise.resolve().then(function(){var o,a;var i=n.modifier;var s=i.bySelector(r.selector,n.appComponent,n.view);var c=s._getVisibleSections();function g(e){var r=t.byId(e),n=r.data("sectionId");return t.byId(n)}var u=[];r.movedElements.forEach(function(e){var t=c[e.targetIndex];var r=Promise.resolve().then(function(){return i.findIndexInParentAggregation(t)}).then(function(t){e.targetIndex=t;o=g(e.id);if(!o||!o.getParent()){throw new Error("Cannot map anchor to section")}a={id:o.getParent().getId(),aggregation:o.sParentAggregationName};e.id=o.getId()});u.push(r)});return Promise.all(u).then(function(){e(r.source,a);e(r.target,a)})})};o.getChangeVisualizationInfo=function(e,t){var n=e.getContent();var o=e.getRevertData()[0];var a=n.movedElements[0].selector;var i=r.bySelector(a,t);var s=i.getParent().getAggregation("_anchorBar");var c=[a];var g=[a];s.getAggregation("content").forEach(function(e){e.getAggregation("customData").some(function(t){if(t.getKey()==="sectionId"&&i.getId()===t.getProperty("value")){g.push(e.getId())}})});return{affectedControls:c,displayControls:g,dependentControls:[n.source.selector],descriptionPayload:{sourceContainer:o.sourceParent,targetContainer:n.target.selector}}};return o},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/changeHandler/RenameObjectPageSection", ["sap/base/Log","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/changeHandler/BaseRename"],function(e,t,r){"use strict";var n={propertyName:"title",changePropertyName:"newText",translationTextType:"XGRP"};var o=r.createRenameChangeHandler(n);o._getControlForRename=function(e,t){var r,n;return Promise.resolve().then(function(){return t.getAggregation(e,"subSections")}).then(function(n){r=n;if(r.length!==1){return[]}return Promise.all([t.getPropertyBindingOrProperty(r[0],"title"),t.getProperty(t.getParent(e),"subSectionLayout")])}).then(function(t){n=t[0];if(r&&r.length===1&&n&&typeof n==="object"||typeof n==="string"&&n.trim()!==""&&t[1]==="TitleOnTop"){return r[0]}return e})};o.applyChange=function(e,t,r){var a=r.modifier;var i=n.propertyName;var g=e.getText(n.changePropertyName);if(g&&typeof g==="string"){return o._getControlForRename(t,a).then(function(t){if(g.trim()===""){throw new Error("Change cannot be applied as ObjectPageSubSection's title cannot be empty")}return a.getPropertyBindingOrProperty(t,i).then(function(r){e.setRevertData(r);a.setPropertyBindingOrProperty(t,i,g);return true})})}};o.revertChange=function(t,r,a){var i=t.getRevertData(),g=a.modifier,u=n.propertyName;return o._getControlForRename(r,g).then(function(r){if(i||i===""){g.setPropertyBindingOrProperty(r,u,i);t.resetRevertData();return true}else{e.error("Change doesn't contain sufficient information to be reverted. Most Likely the Change didn't go through applyChange.")}})};o.getChangeVisualizationInfo=function(e,r){var o=e.getTexts()&&e.getTexts()[n.changePropertyName];var a=e.getSelector();var i=t.bySelector(a,r);var g=i.getParent().getAggregation("_anchorBar");var u=[i.getId()];var c=[i.getId()];g.getAggregation("content").forEach(function(e){e.getAggregation("customData").some(function(t){if(t.getKey()==="sectionId"&&i.getId()===t.getProperty("value")){c.push(e.getId())}})});return{descriptionPayload:{originalLabel:e.getRevertData(),newLabel:o&&o.value},affectedControls:u,displayControls:c}};return o},true);
/*!
	* OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
	*/
sap.ui.predefine("sap/uxap/changeHandler/UnstashObjectPageSection", ["sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/changeHandler/UnstashControl"],function(e,t){"use strict";var r=Object.assign({},t);r.getChangeVisualizationInfo=function(t,r){var n=t.getSelector();var o=e.bySelector(n,r);var a=o.getParent().getAggregation("_anchorBar");var i=[n];var g=[n];a.getAggregation("content").forEach(function(e){e.getAggregation("customData").some(function(t){if(t.getKey()==="sectionId"&&o.getId()===t.getProperty("value")){g.push(e.getId())}})});return{affectedControls:i,displayControls:g}};return r},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/component/Component", ["sap/uxap/library","sap/ui/core/UIComponent","sap/ui/core/library","sap/base/Log","sap/ui/core/mvc/View","sap/ui/core/Component"],function(o,t,e,i,n){"use strict";var a=e.mvc.ViewType;var s=o.ObjectPageConfigurationMode;var r=t.extend("sap.uxap.component.Component",{metadata:{interfaces:["sap.ui.core.IAsyncContentCreation"]},init:function(){this._oModel=null;this._oViewConfig={viewData:{component:this}};switch(this.oComponentData.mode){case s.JsonURL:this._oModel=new t(this.oComponentData.jsonConfigurationURL);this._oViewConfig.viewName="sap.uxap.component.ObjectPageLayoutUXDrivenFactory";this._oViewConfig.type=a.XML;break;case s.JsonModel:this._oViewConfig.viewName="sap.uxap.component.ObjectPageLayoutUXDrivenFactory";this._oViewConfig.type=a.XML;break;default:i.error("UxAPComponent :: missing bootstrap information. Expecting one of the following: JsonURL, JsonModel and FacetsAnnotation")}t.prototype.init.call(this)},createContent:function(){var o;var t=n.create(this._oViewConfig);t.then(function(t){this._oView=t;if(this._oModel){o=this._oView.getController();if(o&&o.connectToComponent){o.connectToComponent(this._oModel)}this._oView.setModel(this._oModel,"objectPageLayoutMetadata")}}.bind(this));return t},propagateProperties:function(o){if(this.oComponentData.mode===s.JsonModel){var e=this._oView.getController();if(e&&e.connectToComponent){e.connectToComponent(this.getModel("objectPageLayoutMetadata"))}}return t.prototype.propagateProperties.apply(this,arguments)},destroy:function(){if(this._oView){this._oView.destroy();this._oView=null}if(this._oModel){this._oModel.destroy();this._oModel=null}if(t.prototype.destroy){t.prototype.destroy.call(this)}}});return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/component/ObjectPageComponentContainer", ["sap/ui/core/ComponentContainer","sap/base/Log","sap/ui/core/Component"],function(e,n,o){"use strict";var t=e.extend("sap.uxap.component.ObjectPageComponentContainer",{metadata:{library:"sap.uxap",properties:{jsonConfigurationURL:{type:"string",group:"Behavior"},mode:{type:"sap.uxap.ObjectPageConfigurationMode",group:"Behavior"}}},init:function(){this.setPropagateModel(true);this.setName("sap.uxap.component")},onBeforeRendering:function(){if(e.prototype.onBeforeRendering){e.prototype.onBeforeRendering.call(this)}},_createComponent:function(){var e;if(!this._oComponent){e=o.create({name:this.getName(),url:this.getUrl(),componentData:{jsonConfigurationURL:this.getJsonConfigurationURL(),mode:this.getMode()}});e.then(function(e){this._oComponent=e}.bind(this));return e}else{return this._oComponent}},getObjectPageLayoutInstance:function(){var e=null;if(this._oComponent&&this._oComponent._oView){e=this._oComponent._oView.byId("ObjectPageLayout")}else{n.error("ObjectPageComponentContainer :: cannot find children ObjectPageLayout, has it been rendered already?")}return e},renderer:"sap.ui.core.ComponentContainerRenderer"});return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/component/ObjectPageLayoutUXDrivenFactory.controller", ["sap/ui/model/BindingMode","sap/ui/model/Context","sap/ui/base/ManagedObject","sap/ui/core/mvc/Controller","sap/base/Log","sap/base/util/each","sap/base/util/isEmptyObject"],function(e,t,r,a,o,n,i){"use strict";return a.extend("sap.uxap.component.ObjectPageLayoutUXDrivenFactory",{connectToComponent:function(r){var a=i(r.getData());r.setDefaultBindingMode(e.OneWay);var n=function(){if(a){r.detachRequestCompleted(n)}var e=new t(r,"/headerTitle"),i=this.getView().byId("ObjectPageLayout");if(e.getProperty("")){try{this._oHeader=this.controlFactory(i.getId(),e);i.setHeaderTitle(this._oHeader)}catch(e){o.error("ObjectPageLayoutFactory :: error in header creation from config: "+e)}}}.bind(this);if(a){r.attachRequestCompleted(n)}else{n()}},controlFactory:function(e,t){var a=t.getProperty(""),i,c,s;try{c=sap.ui.requireSync(a.Type.replace(/\./g,"/"));s=c.getMetadata();n(s._mAllEvents,function(e,t){if(typeof a[e]=="string"){a[e]=this.convertEventHandler(a[e])}}.bind(this));i=r.create(a);n(s._mAllProperties,function(e,r){if(a[e]){i.bindProperty(e,"objectPageLayoutMetadata>"+t.getPath()+"/"+e)}})}catch(e){o.error("ObjectPageLayoutFactory :: error in control creation from config: "+e)}return i},convertEventHandler:function(e){var t=window,r=e.split(".");try{n(r,function(e,r){t=t[r]})}catch(r){o.error("ObjectPageLayoutFactory :: undefined event handler: "+e+". Did you forget to require its static class?");t=undefined}return t}})});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/flexibility/ObjectPageDynamicHeaderTitle.flexibility", ["sap/m/changeHandler/CombineButtons","sap/m/changeHandler/SplitMenuButton","sap/f/changeHandler/MoveDynamicPageTitleActions"],function(e,n,a){"use strict";return{hideControl:"default",unhideControl:"default",combineButtons:{changeHandler:e,layers:{CUSTOMER:false}},splitMenuButton:{changeHandler:n,layers:{CUSTOMER:false}},moveActions:{changeHandler:a},moveControls:"default"}},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/flexibility/ObjectPageHeader.flexibility", ["sap/m/changeHandler/CombineButtons","sap/m/changeHandler/SplitMenuButton"],function(e,n){"use strict";return{combineButtons:{changeHandler:e,layers:{CUSTOMER:false}},moveControls:"default",splitMenuButton:{changeHandler:n,layers:{CUSTOMER:false}}}},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/flexibility/ObjectPageHeaderActionButton.flexibility", ["sap/ui/fl/changeHandler/BaseRename"],function(e){"use strict";return{hideControl:"default",rename:e.createRenameChangeHandler({propertyName:"text",translationTextType:"XBUT"}),unhideControl:"default"}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/flexibility/ObjectPageLayout.flexibility", ["sap/uxap/changeHandler/MoveObjectPageSection","sap/uxap/changeHandler/AddIFrameObjectPageLayout"],function(e,a){"use strict";return{moveControls:{changeHandler:e,layers:{USER:true}},addIFrame:{changeHandler:a}}},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/flexibility/ObjectPageSection.flexibility", ["sap/uxap/changeHandler/RenameObjectPageSection","sap/uxap/changeHandler/UnstashObjectPageSection"],function(e,a){"use strict";return{rename:e,moveControls:"default",hideControl:{changeHandler:"default",layers:{USER:true}},unhideControl:{changeHandler:"default",layers:{USER:true}},stashControl:{changeHandler:"default",layers:{USER:true}},unstashControl:{changeHandler:a,layers:{USER:true}}}},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/flexibility/ObjectPageSubSection.flexibility", ["sap/m/changeHandler/CombineButtons","sap/m/changeHandler/SplitMenuButton","sap/ui/fl/changeHandler/BaseRename"],function(e,n,a){"use strict";return{hideControl:"default",unhideControl:"default",rename:a.createRenameChangeHandler({propertyName:"title",translationTextType:"XGRP"}),combineButtons:{changeHandler:e,layers:{CUSTOMER:false}},moveControls:"default",splitMenuButton:{changeHandler:n,layers:{CUSTOMER:false}}}},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/library", ["sap/ui/core/Core","sap/ui/base/DataType","sap/ui/Device","sap/ui/thirdparty/jquery","sap/ui/base/Object","sap/ui/core/library","sap/f/library","sap/m/library","sap/ui/layout/library"],function(e,a,t,jQuery,i){"use strict";var s=sap.ui.getCore().initLibrary({name:"sap.uxap",dependencies:["sap.ui.core","sap.f","sap.m","sap.ui.layout"],designtime:"sap/uxap/designtime/library.designtime",types:["sap.uxap.BlockBaseColumnLayout","sap.uxap.BlockBaseFormAdjustment","sap.uxap.Importance","sap.uxap.ObjectPageConfigurationMode","sap.uxap.ObjectPageHeaderDesign","sap.uxap.ObjectPageHeaderPictureShape","sap.uxap.ObjectPageSubSectionLayout","sap.uxap.ObjectPageSubSectionMode"],interfaces:["sap.uxap.IHeaderTitle","sap.uxap.IHeaderContent"],controls:["sap.uxap.AnchorBar","sap.uxap.BlockBase","sap.uxap.BreadCrumbs","sap.uxap.HierarchicalSelect","sap.uxap.ObjectPageHeader","sap.uxap.ObjectPageDynamicHeaderTitle","sap.uxap.ObjectPageDynamicHeaderContent","sap.uxap.ObjectPageHeaderActionButton","sap.uxap.ObjectPageHeaderContent","sap.uxap.ObjectPageLayout","sap.uxap.ObjectPageSection","sap.uxap.ObjectPageSectionBase","sap.uxap.ObjectPageSubSection"],elements:["sap.uxap.ModelMapping","sap.uxap.ObjectPageAccessibleLandmarkInfo","sap.uxap.ObjectPageHeaderLayoutData","sap.uxap.ObjectPageLazyLoader"],version:"1.120.22",extensions:{flChangeHandlers:{"sap.uxap.ObjectPageHeader":"sap/uxap/flexibility/ObjectPageHeader","sap.uxap.ObjectPageLayout":"sap/uxap/flexibility/ObjectPageLayout","sap.uxap.ObjectPageSection":"sap/uxap/flexibility/ObjectPageSection","sap.uxap.ObjectPageSubSection":"sap/uxap/flexibility/ObjectPageSubSection","sap.uxap.ObjectPageDynamicHeaderTitle":"sap/uxap/flexibility/ObjectPageDynamicHeaderTitle","sap.uxap.ObjectPageHeaderActionButton":"sap/uxap/flexibility/ObjectPageHeaderActionButton","sap.ui.core._StashedControl":{unstashControl:{changeHandler:"default",layers:{USER:true}},stashControl:{changeHandler:"default",layers:{USER:true}}}},"sap.ui.support":{publicRules:true}}});s.BlockBaseColumnLayout=a.createType("sap.uxap.BlockBaseColumnLayout",{isValid:function(e){return/^(auto|[1-4]{1})$/.test(e)}},a.getType("string"));s.BlockBaseFormAdjustment={BlockColumns:"BlockColumns",OneColumn:"OneColumn",None:"None"};s.ObjectPageConfigurationMode={JsonURL:"JsonURL",JsonModel:"JsonModel"};s.ObjectPageHeaderDesign={Light:"Light",Dark:"Dark"};s.ObjectPageHeaderPictureShape={Circle:"Circle",Square:"Square"};s.ObjectPageSubSectionLayout={TitleOnTop:"TitleOnTop",TitleOnLeft:"TitleOnLeft"};s.ObjectPageSubSectionMode={Collapsed:"Collapsed",Expanded:"Expanded"};s.Importance={Low:"Low",Medium:"Medium",High:"High"};s.Utilities={getClosestOPL:function(e){while(e&&!i.isObjectA(e,"sap.uxap.ObjectPageLayout")){e=e.getParent()}return e},isPhoneScenario:function(e){if(t.system.phone){return true}return s.Utilities._isCurrentMediaSize("Phone",e)},isTabletScenario:function(e){return s.Utilities._isCurrentMediaSize("Tablet",e)},_isCurrentMediaSize:function(e,a){return a&&a.name===e},getChildPosition:function(e,a){var t=e instanceof jQuery?e:jQuery(e),i=a instanceof jQuery?a:jQuery(a),s=jQuery(document.documentElement),n=t.position(),p=t.offsetParent(),u;while(!p.is(i)&&!p.is(s)){u=p.position();n.top+=u.top;n.left+=u.left;p=p.offsetParent()}return n}};return s});
sap.ui.require.preload({
	"sap/uxap/component/ObjectPageLayoutUXDrivenFactory.view.xml":'<mvc:View xmlns:mvc="sap.ui.core.mvc"\n\t\t  xmlns="sap.uxap"\n\t\t  height="100%"\n\t\t  controllerName="sap.uxap.component.ObjectPageLayoutUXDrivenFactory"\n><ObjectPageLayout id="ObjectPageLayout"\n\t\t\t\t\t  subSectionLayout="{objectPageLayoutMetadata>/subSectionLayout}"\n\t\t\t\t\t  showAnchorBar="{objectPageLayoutMetadata>/showAnchorBar}"\n\t\t\t\t\t  height="{objectPageLayoutMetadata>/height}"\n\t\t\t\t\t  enableLazyLoading="{objectPageLayoutMetadata>/enableLazyLoading}"\n\t\t\t\t\t  sections="{path: \'objectPageLayoutMetadata>/sections\', templateShareable: false}"\n\t\t\t\t\t  headerContent="{path:\'objectPageLayoutMetadata>/headerContent\', factory:\'.controlFactory\'}"\n\t\t\t\t\t  showAnchorBarPopover="{objectPageLayoutMetadata>/showAnchorBarPopover}"\n\t\t\t\t\t  upperCaseAnchorBar="{objectPageLayoutMetadata>/upperCaseAnchorBar}"\n\t\t\t\t\t  useIconTabBar="{objectPageLayoutMetadata>/useIconTabBar}"\n\t\t\t\t\t  showHeaderContent="{objectPageLayoutMetadata>/showHeaderContent}"\n\t\t\t\t\t  useTwoColumnsForLargeScreen="{objectPageLayoutMetadata>/useTwoColumnsForLargeScreen}"\n\t\t\t\t\t  showTitleInHeaderContent="{objectPageLayoutMetadata>/showTitleInHeaderContent}"\n\t\t\t\t\t  showOnlyHighImportance="{objectPageLayoutMetadata>/showOnlyHighImportance}"\n\t\t\t\t\t  isChildPage="{objectPageLayoutMetadata>/isChildPage}"\n\t\t\t\t\t  alwaysShowContentHeader="{objectPageLayoutMetadata>/alwaysShowContentHeader}"\n\t\t\t\t\t  showEditHeaderButton="{objectPageLayoutMetadata>/showEditHeaderButton}"\n\t><sections><ObjectPageSection id="ObjectPageSection"\n\t\t\t\t\t\t\t   title="{objectPageLayoutMetadata>title}"\n\t\t\t\t\t\t\t   importance="{objectPageLayoutMetadata>importance}"\n\t\t\t\t\t\t\t   showTitle="{objectPageLayoutMetadata>showTitle}"\n\t\t\t\t\t\t\t   subSections="{path: \'objectPageLayoutMetadata>subSections\', templateShareable: false}"\n\t\t\t\t\t\t\t   visible="{objectPageLayoutMetadata>visible}"><subSections><ObjectPageSubSection id="ObjectPageSubSection"\n\t\t\t\t\t\t\t\t\t\t  title="{objectPageLayoutMetadata>title}"\n\t\t\t\t\t\t\t\t\t\t  visible="{objectPageLayoutMetadata>visible}"\n\t\t\t\t\t\t\t\t\t\t  mode="{objectPageLayoutMetadata>mode}"\n\t\t\t\t\t\t\t\t\t\t  importance="{objectPageLayoutMetadata>importance}"\n\t\t\t\t\t\t\t\t\t\t  actions="{path:\'objectPageLayoutMetadata>actions\', factory:\'.controlFactory\'}"\n\t\t\t\t\t\t\t\t\t\t  blocks="{path:\'objectPageLayoutMetadata>blocks\', factory:\'.controlFactory\'}"\n\t\t\t\t\t\t\t\t\t\t  moreBlocks="{path:\'objectPageLayoutMetadata>moreBlocks\', factory:\'.controlFactory\'}"></ObjectPageSubSection></subSections></ObjectPageSection></sections></ObjectPageLayout></mvc:View>\n',
	"sap/uxap/manifest.json":'{"_version":"1.21.0","sap.app":{"id":"sap.uxap","type":"library","embeds":[],"applicationVersion":{"version":"1.120.22"},"title":"SAP UxAP","description":"SAP UxAP","ach":"CA-UI5-CTR","resources":"resources.json","offline":true},"sap.ui":{"technology":"UI5","supportedThemes":["base","sap_hcb"]},"sap.ui5":{"dependencies":{"minUI5Version":"1.120","libs":{"sap.ui.core":{"minVersion":"1.120.22"},"sap.m":{"minVersion":"1.120.22"},"sap.ui.layout":{"minVersion":"1.120.22"},"sap.f":{"minVersion":"1.120.22","lazy":true}}},"library":{"i18n":{"bundleUrl":"messagebundle.properties","supportedLocales":["","ar","bg","ca","cnr","cs","cy","da","de","el","en","en-GB","en-US-sappsd","en-US-saprigi","en-US-saptrc","es","es-MX","et","fi","fr","fr-CA","hi","hr","hu","id","it","iw","ja","kk","ko","lt","lv","mk","ms","nl","no","pl","pt","pt-PT","ro","ru","sh","sk","sl","sr","sv","th","tr","uk","vi","zh-CN","zh-TW"]},"content":{"controls":["sap.uxap.AnchorBar","sap.uxap.BlockBase","sap.uxap.BreadCrumbs","sap.uxap.HierarchicalSelect","sap.uxap.ObjectPageHeader","sap.uxap.ObjectPageDynamicHeaderTitle","sap.uxap.ObjectPageDynamicHeaderContent","sap.uxap.ObjectPageHeaderActionButton","sap.uxap.ObjectPageHeaderContent","sap.uxap.ObjectPageLayout","sap.uxap.ObjectPageSection","sap.uxap.ObjectPageSectionBase","sap.uxap.ObjectPageSubSection"],"elements":["sap.uxap.ModelMapping","sap.uxap.ObjectPageAccessibleLandmarkInfo","sap.uxap.ObjectPageHeaderLayoutData","sap.uxap.ObjectPageLazyLoader"],"types":["sap.uxap.BlockBaseColumnLayout","sap.uxap.BlockBaseFormAdjustment","sap.uxap.Importance","sap.uxap.ObjectPageConfigurationMode","sap.uxap.ObjectPageHeaderDesign","sap.uxap.ObjectPageHeaderPictureShape","sap.uxap.ObjectPageSubSectionLayout","sap.uxap.ObjectPageSubSectionMode"],"interfaces":["sap.uxap.IHeaderTitle","sap.uxap.IHeaderContent"]}}}}'
});
//# sourceMappingURL=library-preload.js.map
