//@ui5-bundle Calendar-preload.js
/*!
* OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.predefine("sap/base/i18n/Formatting", ["sap/base/assert","sap/base/config","sap/base/Eventing","sap/base/Log","sap/base/i18n/Localization","sap/base/i18n/LanguageTag","sap/base/i18n/date/CalendarType","sap/base/i18n/date/CalendarWeekNumbering","sap/base/util/deepEqual","sap/base/util/extend","sap/base/util/isEmptyObject"],(e,t,a,r,n,s,i,o,u,m,l)=>{"use strict";const d=new a;const g=t.getWritableInstance();const p={};let c;let y;const f={"":{pattern:null},1:{pattern:"dd.MM.yyyy"},2:{pattern:"MM/dd/yyyy"},3:{pattern:"MM-dd-yyyy"},4:{pattern:"yyyy.MM.dd"},5:{pattern:"yyyy/MM/dd"},6:{pattern:"yyyy-MM-dd"},7:{pattern:"Gyy.MM.dd"},8:{pattern:"Gyy/MM/dd"},9:{pattern:"Gyy-MM-dd"},A:{pattern:"yyyy/MM/dd"},B:{pattern:"yyyy/MM/dd"},C:{pattern:"yyyy/MM/dd"}};const b={"":{short:null,medium:null,dayPeriods:null},0:{short:"HH:mm",medium:"HH:mm:ss",dayPeriods:null},1:{short:"hh:mm a",medium:"hh:mm:ss a",dayPeriods:["AM","PM"]},2:{short:"hh:mm a",medium:"hh:mm:ss a",dayPeriods:["am","pm"]},3:{short:"KK:mm a",medium:"KK:mm:ss a",dayPeriods:["AM","PM"]},4:{short:"KK:mm a",medium:"KK:mm:ss a",dayPeriods:["am","pm"]}};const C={"":{groupingSeparator:null,decimalSeparator:null}," ":{groupingSeparator:".",decimalSeparator:","},X:{groupingSeparator:",",decimalSeparator:"."},Y:{groupingSeparator:" ",decimalSeparator:","}};function A(e,t){if(!e){throw new TypeError(t)}}function P(e,a){t._.invalidate();const r=p[e];if(a!=null){p[e]=a}else{delete p[e]}if((r!=null||a!=null)&&!u(r,a)){const t=!c;c??={};c[e]=a;if(t){S()}}}function h(e){let t;if(e&&typeof e==="string"){try{t=new s(e)}catch(e){}}else if(e instanceof s){t=e}return t}const T={attachChange(e){d.attachEvent("change",e)},detachChange(e){d.detachEvent("change",e)},getLanguageTag(){function e(){let e=new s(n.getLanguage());if(!l(p)||T.getCalendarWeekNumbering()!==o.Default){let t=e.toString();if(t.indexOf("-x-")<0){t+="-x-sapufmt"}else if(t.indexOf("-sapufmt")<=t.indexOf("-x-")){t+="-sapufmt"}e=new s(t)}return e}return g.get({name:"sapUiFormatLocale",type:function(e){return new s(e)},defaultValue:e,external:true})},setLanguageTag(e){const t=h(e);A(e==null||t,"vLanguageTag must be a BCP47 language tag or Java Locale id or null");const a=T.getLanguageTag();g.set("sapUiFormatLocale",t?.toString());const r=T.getLanguageTag();if(a.toString()!==r.toString()){const e=!c;c??={};c.languageTag=r.toString();if(e){S()}}},_set:P,getCustomUnits(){return p["units"]?.["short"]},setCustomUnits(e){let t=null;if(e){t={short:e}}P("units",t)},addCustomUnits(e){const t=T.getCustomUnits();if(t){e=m({},t,e)}T.setCustomUnits(e)},setUnitMappings(e){P("unitMappings",e)},addUnitMappings(e){const t=T.getUnitMappings();if(t){e=m({},t,e)}T.setUnitMappings(e)},getUnitMappings(){return p["unitMappings"]},getDatePattern(t){e(t=="short"||t=="medium"||t=="long"||t=="full","sStyle must be short, medium, long or full");return p["dateFormats-"+t]},setDatePattern(e,t){A(e=="short"||e=="medium"||e=="long"||e=="full","sStyle must be short, medium, long or full");P("dateFormats-"+e,t)},getTimePattern(t){e(t=="short"||t=="medium"||t=="long"||t=="full","sStyle must be short, medium, long or full");return p["timeFormats-"+t]},setTimePattern(e,t){A(e=="short"||e=="medium"||e=="long"||e=="full","sStyle must be short, medium, long or full");P("timeFormats-"+e,t)},getNumberSymbol(t){e(["group","decimal","plusSign","minusSign"].includes(t),"sType must be decimal, group, plusSign or minusSign");return p["symbols-latn-"+t]},setNumberSymbol(e,t){A(["group","decimal","plusSign","minusSign"].includes(e),"sType must be decimal, group, plusSign or minusSign");P("symbols-latn-"+e,t)},getCustomCurrencies(){return p["currency"]},setCustomCurrencies(e){A(typeof e==="object"||e==null,"mCurrencyDigits must be an object");Object.keys(e||{}).forEach(function(t){A(typeof t==="string");A(typeof e[t]==="object")});P("currency",e)},addCustomCurrencies(e){const t=T.getCustomCurrencies();if(t){e=m({},t,e)}T.setCustomCurrencies(e)},_setDayPeriods(t,a){e(t=="narrow"||t=="abbreviated"||t=="wide","sWidth must be narrow, abbreviated or wide");P("dayPeriods-format-"+t,a)},getABAPDateFormat(){const e=g.get({name:"sapUiABAPDateFormat",type:t.Type.String,defaultValue:g.get({name:"sapUiLegacyDateFormat",type:t.Type.String,external:true}),external:true});return e?e.toUpperCase():undefined},setABAPDateFormat(e){e=e?String(e).toUpperCase():"";A(f.hasOwnProperty(e),"sFormatId must be one of ['1','2','3','4','5','6','7','8','9','A','B','C'] or empty");const t=!c;const a=T.getABAPDateFormat();if(a!==e){c??={};g.set("sapUiABAPDateFormat",e);c.ABAPDateFormat=e;T.setDatePattern("short",f[e].pattern);T.setDatePattern("medium",f[e].pattern);if(t){S()}}},getABAPTimeFormat(){const e=g.get({name:"sapUiABAPTimeFormat",type:t.Type.String,defaultValue:g.get({name:"sapUiLegacyTimeFormat",type:t.Type.String,external:true}),external:true});return e?e.toUpperCase():undefined},setABAPTimeFormat(e){e=e||"";A(b.hasOwnProperty(e),"sFormatId must be one of ['0','1','2','3','4'] or empty");const t=!c;const a=T.getABAPTimeFormat();if(a!==e){c??={};g.set("sapUiABAPTimeFormat",e);c.ABAPTimeFormat=e;T.setTimePattern("short",b[e]["short"]);T.setTimePattern("medium",b[e]["medium"]);T._setDayPeriods("abbreviated",b[e].dayPeriods);if(t){S()}}},getABAPNumberFormat(){const e=g.get({name:"sapUiABAPNumberFormat",type:t.Type.String,defaultValue:g.get({name:"sapUiLegacyNumberFormat",type:t.Type.String,external:true}),external:true});return e?e.toUpperCase():undefined},setABAPNumberFormat(e){e=e?e.toUpperCase():"";A(C.hasOwnProperty(e),"sFormatId must be one of [' ','X','Y'] or empty");const t=!c;const a=T.getABAPNumberFormat();if(a!==e){c??={};g.set("sapUiABAPNumberFormat",e);c.ABAPNumberFormat=e;T.setNumberSymbol("group",C[e].groupingSeparator);T.setNumberSymbol("decimal",C[e].decimalSeparator);if(t){S()}}},setCustomIslamicCalendarData(e){A(Array.isArray(e),"aCustomCalendarData must be an Array");const t=!c;c??={};y=c.customIslamicCalendarData=e.slice();if(t){S()}},getCustomIslamicCalendarData(){return y?.slice()??undefined},setTrailingCurrencyCode(e){A(typeof e==="boolean","bTrailingCurrencyCode must be a boolean");g.set("sapUiTrailingCurrencyCode",e)},getTrailingCurrencyCode(){return g.get({name:"sapUiTrailingCurrencyCode",type:t.Type.Boolean,defaultValue:true,external:true})},getCustomLocaleData(){return p},getCalendarWeekNumbering(){let e=o.Default;try{e=g.get({name:"sapUiCalendarWeekNumbering",type:o,defaultValue:o.Default,external:true})}catch(e){}return e},setCalendarWeekNumbering(e){t._.checkEnum(o,e,"calendarWeekNumbering");const a=g.get({name:"sapUiCalendarWeekNumbering",type:o,defaultValue:o.Default,external:true});if(a!==e){const t=!c;c??={};g.set("sapUiCalendarWeekNumbering",e);c.calendarWeekNumbering=e;if(t){S()}}},getCalendarType(){let e,a=g.get({name:"sapUiCalendarType",type:t.Type.String,external:true});a??=null;if(a){for(e in i){if(e.toLowerCase()===a.toLowerCase()){return e}}r.warning("Parameter 'calendarType' is set to "+a+" which isn't a valid value and therefore ignored. The calendar type is determined from format setting and current locale")}const s=T.getABAPDateFormat();switch(s){case"1":case"2":case"3":case"4":case"5":case"6":return i.Gregorian;case"7":case"8":case"9":return i.Japanese;case"A":case"B":return i.Islamic;case"C":return i.Persian;default:return n.getPreferredCalendarType()}},setCalendarType(e){const t=T.getCalendarType();g.set("sapUiCalendarType",e);const a=T.getCalendarType();if(t!==a){const e=!c;c??={};c.calendarType=a;if(e){S()}}}};function S(){d.fireEvent("change",c);c=undefined}function F(){const e=T.getABAPDateFormat();if(e!==undefined){T.setABAPDateFormat(e)}const t=T.getABAPNumberFormat();if(t!==undefined){T.setABAPNumberFormat(t)}const a=T.getABAPTimeFormat();if(a!==undefined){T.setABAPTimeFormat(a)}}F();return T});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/i18n/date/CalendarWeekNumbering", [],function(){"use strict";var e={Default:"Default",ISO_8601:"ISO_8601",MiddleEastern:"MiddleEastern",WesternTraditional:"WesternTraditional"};Object.defineProperty(e,"getWeekConfigurationValues",{value:function(t){switch(t){case e.ISO_8601:return{firstDayOfWeek:1,minimalDaysInFirstWeek:4};case e.MiddleEastern:return{firstDayOfWeek:6,minimalDaysInFirstWeek:1};case e.WesternTraditional:return{firstDayOfWeek:0,minimalDaysInFirstWeek:1};default:return undefined}}});return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/strings/camelize", [],function(){"use strict";var r=/-(.)/gi;var e=function(e){return e.replace(r,function(r,e){return e.toUpperCase()})};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/ObjectPath", [],function(){"use strict";var r={};var e=window;function t(r){return Array.isArray(r)?r.slice():r.split(".")}r.create=function(r,n){var a=n||e;var o=t(r);for(var i=0;i<o.length;i++){var u=o[i];if(a[u]===null||a[u]!==undefined&&(typeof a[u]!=="object"&&typeof a[u]!=="function")){throw new Error("Could not set object-path for '"+o.join(".")+"', path segment '"+u+"' already exists.")}a[u]=a[u]||{};a=a[u]}return a};r.get=function(r,n){var a=n||e;var o=t(r);var i=o.pop();for(var u=0;u<o.length&&a;u++){a=a[o[u]]}return a?a[i]:undefined};r.set=function(n,a,o){o=o||e;var i=t(n);var u=i.pop();var f=r.create(i,o);f[u]=a};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/Version", [],function(){"use strict";var t=/^[0-9]+(?:\.([0-9]+)(?:\.([0-9]+))?)?(.*)$/;function n(r,i,e,o){if(r instanceof n){return r}if(!(this instanceof n)){return new n(r,i,e,o)}var u;if(typeof r==="string"){u=t.exec(r)}else if(Array.isArray(r)){u=r}else{u=arguments}u=u||[];function f(t){t=parseInt(t);return isNaN(t)?0:t}r=f(u[0]);i=f(u[1]);e=f(u[2]);o=String(u[3]||"");this.toString=function(){return r+"."+i+"."+e+o};this.getMajor=function(){return r};this.getMinor=function(){return i};this.getPatch=function(){return e};this.getSuffix=function(){return o};this.compareTo=function(){var t=n.apply(window,arguments);return r-t.getMajor()||i-t.getMinor()||e-t.getPatch()||(o<t.getSuffix()?-1:o===t.getSuffix()?0:1)}}n.prototype.inRange=function(t,n){return this.compareTo(t)>=0&&this.compareTo(n)<0};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/array/uniqueSort", ["sap/base/assert"],function(r){"use strict";var a=function(a){r(Array.isArray(a),"uniqueSort: input parameter must be an Array");var e=a.length;if(e>1){a.sort();var i=0;for(var t=1;t<e;t++){if(a.indexOf(a[t])===t){a[++i]=a[t]}}if(++i<e){a.splice(i,e-i)}}return a};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/deepEqual", ["sap/base/Log"],function(e){"use strict";var r=function(t,n,f,a,u){if(typeof f=="boolean"){a=f;f=undefined}if(!u){u=0}if(!f){f=10}if(u>f){e.warning("deepEqual comparison exceeded maximum recursion depth of "+f+". Treating values as unequal");return false}if(t===n||Number.isNaN(t)&&Number.isNaN(n)){return true}if(Array.isArray(t)&&Array.isArray(n)){if(!a&&t.length!==n.length){return false}if(t.length>n.length){return false}for(var i=0;i<t.length;i++){if(!r(t[i],n[i],f,a,u+1)){return false}}return true}if(typeof t=="object"&&typeof n=="object"){if(!t||!n){return false}if(t.constructor!==n.constructor){return false}if(!a&&Object.keys(t).length!==Object.keys(n).length){return false}if(t instanceof Node){return t.isEqualNode(n)}if(t instanceof Date){return t.valueOf()===n.valueOf()}for(var i in t){if(!r(t[i],n[i],f,a,u+1)){return false}}return true}return false};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/isEmptyObject", [],function(){"use strict";var r=function r(n){for(var e in n){return false}return true};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/resolveReference", ["sap/base/util/ObjectPath"],function(t){"use strict";var n=Object.create(null);function e(e,i,o){var r,f;if(i&&e[0]in i){f=e.length>1?t.get(e.slice(0,-1),i):i;r=f&&f[e[e.length-1]];if(typeof r==="function"&&o.bindContext){r=r.bind(o.rootContext||f)}return r}return n}var i=function(i,o,r){o=o||{};r=r||{};r.bindContext=r.bindContext!==false;r.bindDotContext=r.bindDotContext!==false;var f=i.split("."),u=f.shift()||".",d=u===".",b=n;f.unshift(u);if(r.preferDotContext&&!d){b=e(f,o["."],{bindContext:r.bindContext&&r.bindDotContext,rootContext:o["."]})}if(b===n){b=e(f,o,{bindContext:r.bindContext&&(d?r.bindDotContext:f.length>1),rootContext:d?o["."]:undefined})}if(!d){if(b===n&&r.useProbingRequire){b=sap.ui.require(i.replace(/\./g,"/"));if(b===undefined){b=n}}if(b===n){b=t.get(i)}}return b===n?undefined:b};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/base/DataType", ["sap/base/util/ObjectPath","sap/base/assert","sap/base/Log","sap/base/util/isPlainObject","sap/base/util/resolveReference"],function(e,t,n,r,a){"use strict";var i=function(){throw new Error};i.prototype.getName=function(){return undefined};i.prototype.getBaseType=function(){return undefined};i.prototype.getPrimitiveType=function(){var e=this;while(e.getBaseType()){e=e.getBaseType()}return e};i.prototype.getComponentType=function(){return undefined};i.prototype.getDefaultValue=function(){return undefined};i.prototype.isArrayType=function(){return false};i.prototype.isEnumType=function(){return false};i.prototype.getEnumValues=function(){return undefined};i.prototype.parseValue=function(e){return e};i.prototype.isValid=undefined;i.prototype.setNormalizer=function(e){t(typeof e==="function","DataType.setNormalizer: fnNormalizer must be a function");this._fnNormalizer=typeof e==="function"?e:undefined};i.prototype.normalize=function(e){return this._fnNormalizer?this._fnNormalizer(e):e};function u(e,t,n){t=t||{};var r=n||i.prototype;var a=Object.create(r);a.getName=function(){return e};if(t.hasOwnProperty("defaultValue")){var u=t.defaultValue;a.getDefaultValue=function(){return u}}if(t.isValid){var o=t.isValid;a.isValid=r.isValid?function(e){if(!r.isValid(e)){return false}return o(e)}:o}if(t.parseValue){a.parseValue=t.parseValue}a.getBaseType=function(){return n};return a}var o={any:u("any",{defaultValue:null,isValid:function(e){return true}}),boolean:u("boolean",{defaultValue:false,isValid:function(e){return typeof e==="boolean"},parseValue:function(e){return e=="true"}}),int:u("int",{defaultValue:0,isValid:function(e){return typeof e==="number"&&(isNaN(e)||Math.floor(e)==e)},parseValue:function(e){return parseInt(e)}}),float:u("float",{defaultValue:0,isValid:function(e){return typeof e==="number"},parseValue:function(e){return parseFloat(e)}}),string:u("string",{defaultValue:"",isValid:function(e){return typeof e==="string"||e instanceof String},parseValue:function(e){return e}}),object:u("object",{defaultValue:null,isValid:function(e){return typeof e==="object"||typeof e==="function"},parseValue:function(e){return e?JSON.parse(e):null}}),function:u("function",{defaultValue:null,isValid:function(e){return e==null||typeof e==="function"},parseValue:function(e,t){if(e===""){return undefined}if(!/^\.?[A-Z_\$][A-Z0-9_\$]*(\.[A-Z_\$][A-Z0-9_\$]*)*$/i.test(e)){throw new Error("Function references must consist of dot separated "+"simple identifiers (A-Z, 0-9, _ or $) only, but was '"+e+"'")}var n,r=t&&t.context,i=t&&t.locals;n=a(e,Object.assign({".":r},i));if(n&&this.isValid(n)){return n}throw new TypeError("The string '"+e+"' couldn't be resolved to a function")}})};var s=u("array",{defaultValue:[]});function f(e){t(e instanceof i,"DataType.<createArrayType>: componentType must be a DataType");var n=Object.create(i.prototype);n.getName=function(){return e.getName()+"[]"};n.getComponentType=function(){return e};n.isValid=function(t){if(t===null){return true}if(Array.isArray(t)){for(var n=0;n<t.length;n++){if(!e.isValid(t[n])){return false}}return true}return false};n.parseValue=function(t){var n=t.split(",");for(var r=0;r<n.length;r++){n[r]=e.parseValue(n[r])}return n};n.isArrayType=function(){return true};n.getBaseType=function(){return s};return n}const p=Object.create(null);function l(e,t){var n={},r;for(var a in t){var u=t[a];if(!r){r=u}if(typeof u!=="string"){throw new Error("Value "+u+" for enum type "+e+" is not a string")}if(!n.hasOwnProperty(u)||a==u){n[u]=a}}var s=Object.create(i.prototype);s.getName=function(){return e};s.isValid=function(e){return typeof e==="string"&&n.hasOwnProperty(e)};s.parseValue=function(e){return t[e]};s.getDefaultValue=function(){return r};s.getBaseType=function(){return o.string};s.isEnumType=function(){return true};s.getEnumValues=function(){return t};return s}i.getType=function(a){t(a&&typeof a==="string","sTypeName must be a non-empty string");var u=o[a];if(!(u instanceof i)){if(a.indexOf("[]",a.length-2)>0){var s=a.slice(0,-2),y=this.getType(s);u=y&&f(y);if(u){o[a]=u}}else if(a!=="array"){u=p[a];if(u==null){u=e.get(a);if(u!=null){n.error(`The type '${a}' was accessed via globals. Defining enums via globals is deprecated. Please require the module 'sap/ui/base/DataType' and call the static 'DataType.registerEnum' API.`)}}if(u instanceof i){o[a]=u}else if(r(u)){u=o[a]=l(a,u);delete p[a]}else if(u){n.warning("[FUTURE FATAL] '"+a+"' is not a valid data type. Falling back to type 'any'.");u=o.any}else{n.error("[FUTURE FATAL] data type '"+a+"' could not be found.");u=undefined}}}return u};i.createType=function(e,r,a){t(typeof e==="string"&&e,"DataType.createType: type name must be a non-empty string");t(a==null||a instanceof i||typeof a==="string"&&a,"DataType.createType: base type must be empty or a DataType or a non-empty string");if(/[\[\]]/.test(e)){n.error("[FUTURE FATAL] DataType.createType: array types ('something[]') must not be created with createType, "+"they're created on-the-fly by DataType.getType")}if(typeof a==="string"){a=i.getType(a)}a=a||o.any;if(a.isArrayType()||a.isEnumType()){n.error("[FUTURE FATAL] DataType.createType: base type must not be an array- or enum-type")}if(e==="array"||o[e]instanceof i){if(e==="array"||o[e].getBaseType()==null){throw new Error("DataType.createType: primitive or hidden type "+e+" can't be re-defined")}n.warning("[FUTURE FATAL] DataTypes.createType: type "+e+" is redefined. "+"This is an unsupported usage of DataType and might cause issues.")}var s=o[e]=u(e,r,a);return s};var y=new Set;i.registerInterfaceTypes=function(t){t.forEach(function(t){y.add(t);e.set(t,t)})};i.registerEnum=function(e,t){p[e]=t};i._isEnumCandidate=function(e){return!Object.keys(e).some(t=>{const n=typeof e[t];return n==="object"||n==="function"})};i.isInterfaceType=function(e){return y.has(e)};return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/base/DesignTime", ["sap/base/config"],e=>{"use strict";const t={isDesignModeEnabled(){return e.get({name:"sapUiXxDesignMode",type:e.Type.Boolean,external:true,freeze:true})},isControllerCodeDeactivationSuppressed(){return e.get({name:"sapUiXxSuppressDeactivationOfControllerCode",type:e.Type.Boolean,external:true,freeze:true})},isControllerCodeDeactivated(){return t.isDesignModeEnabled()&&!t.isControllerCodeDeactivationSuppressed()}};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/base/Metadata", ["sap/base/util/ObjectPath","sap/base/assert","sap/base/Log","sap/base/util/array/uniqueSort"],function(t,e,a,s){"use strict";function r(t){return typeof t==="function"}var n=function(a,s){e(typeof a==="string"&&a,"Metadata: sClassName must be a non-empty string");e(typeof s==="object","Metadata: oClassInfo must be empty or an object");if(!s||typeof s.metadata!=="object"){s={metadata:s||{},constructor:t.get(a)};s.metadata.__version=1}s.metadata.__version=s.metadata.__version||2;if(!r(s.constructor)){throw Error("constructor for class "+a+" must have been declared before creating metadata for it")}this._sClassName=a;this._oClass=s.constructor;this.extend(s)};n.prototype.extend=function(t){this.applySettings(t);this.afterApplySettings()};n.prototype.applySettings=function(s){var o=this,i=s.metadata,p;if(i.baseType){var c;if(r(i.baseType)){c=i.baseType;if(!r(c.getMetadata)){throw new TypeError("baseType must be a UI5 class with a static getMetadata function")}}else{c=t.get(i.baseType);if(!r(c)){a.fatal("base class '"+i.baseType+"' does not exist")}}if(c.getMetadata){this._oParent=c.getMetadata();e(c===c.getMetadata().getClass(),"Metadata: oParentClass must match the class in the parent metadata")}else{this._oParent=new n(i.baseType,{})}}else{this._oParent=undefined}this._bAbstract=!!i["abstract"];this._bFinal=!!i["final"];this._sStereotype=i.stereotype||(this._oParent?this._oParent._sStereotype:"object");this._bDeprecated=!!i["deprecated"];this._aInterfaces=i.interfaces||[];this._aPublicMethods=i.publicMethods||[];this._bInterfacesUnique=false;p=this._oClass.prototype;for(var u in s){if(u!=="metadata"&&u!=="constructor"){p[u]=s[u];if(!u.match(/^_|^on|^init$|^exit$/)){o._aPublicMethods.push(u)}}}};n.prototype.afterApplySettings=function(){if(this._oParent){this._aAllPublicMethods=this._oParent._aAllPublicMethods.concat(this._aPublicMethods);this._bInterfacesUnique=false}else{this._aAllPublicMethods=this._aPublicMethods}};n.prototype.getStereotype=function(){return this._sStereotype};n.prototype.getName=function(){return this._sClassName};n.prototype.getClass=function(){return this._oClass};n.prototype.getParent=function(){return this._oParent};n.prototype._dedupInterfaces=function(){if(!this._bInterfacesUnique){s(this._aInterfaces);s(this._aPublicMethods);s(this._aAllPublicMethods);this._bInterfacesUnique=true}};n.prototype.getPublicMethods=function(){this._dedupInterfaces();return this._aPublicMethods};n.prototype.getAllPublicMethods=function(){this._dedupInterfaces();return this._aAllPublicMethods};n.prototype.getInterfaces=function(){this._dedupInterfaces();return this._aInterfaces};n.prototype.isInstanceOf=function(t){if(this._oParent){if(this._oParent.isInstanceOf(t)){return true}}var e=this._aInterfaces;for(var a=0,s=e.length;a<s;a++){if(e[a]===t){return true}}return false};Object.defineProperty(n.prototype,"_mImplementedTypes",{get:function(){if(this===n.prototype){throw new Error("sap.ui.base.Metadata: The '_mImplementedTypes' property must not be accessed on the prototype")}var t=Object.create(this._oParent?this._oParent._mImplementedTypes:null);t[this._sClassName]=true;var e=this._aInterfaces,a=e.length;while(a-- >0){if(!t[e[a]]){t[e[a]]=true}}Object.defineProperty(this,"_mImplementedTypes",{value:Object.freeze(t),writable:false,configurable:false});return t},configurable:true});n.prototype.isA=function(t){var e=this._mImplementedTypes;if(Array.isArray(t)){for(var a=0;a<t.length;a++){if(t[a]in e){return true}}return false}return t in e};n.prototype.isAbstract=function(){return this._bAbstract};n.prototype.isFinal=function(){return this._bFinal};n.prototype.isDeprecated=function(){return this._bDeprecated};n.prototype.addPublicMethods=function(t){var e=t instanceof Array?t:arguments;Array.prototype.push.apply(this._aPublicMethods,e);Array.prototype.push.apply(this._aAllPublicMethods,e);this._bInterfacesUnique=false};n.createClass=function(s,o,i,p){if(typeof s==="string"){p=i;i=o;o=s;s=null}e(!s||r(s));e(typeof o==="string"&&!!o);e(!i||typeof i==="object");e(!p||r(p));p=p||n;if(r(p.preprocessClassInfo)){i=p.preprocessClassInfo(i)}i=i||{};i.metadata=i.metadata||{};if(!i.hasOwnProperty("constructor")){i.constructor=undefined}var c=i.constructor;e(!c||r(c));if(s){if(!c){if(i.metadata.deprecated){c=function(){a.warning("Usage of deprecated class: "+o);s.apply(this,arguments)}}else{c=function(){s.apply(this,arguments)}}}c.prototype=Object.create(s.prototype);c.prototype.constructor=c;i.metadata.baseType=s}else{c=c||function(){};delete i.metadata.baseType}i.constructor=c;t.set(o,c);var u=new p(o,i);c.getMetadata=c.prototype.getMetadata=function(){return u};if(!c.getMetadata().isFinal()){c.extend=function(t,e,a){return n.createClass(c,t,e,a||p)}}return c};return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/base/Object", ["./Metadata","sap/base/Log"],function(t,e){"use strict";var n=t.createClass("sap.ui.base.Object",{constructor:function(){if(!(this instanceof n)){throw Error('Cannot instantiate object: "new" is missing!')}}});n.prototype.destroy=function(){};n.prototype.getInterface=function(){var t=new n._Interface(this,this.getMetadata().getAllPublicMethods());this.getInterface=function(){return t};return t};n.defineClass=function(n,r,a){var i=new(a||t)(n,r);var s=i.getClass();s.getMetadata=s.prototype.getMetadata=function(){return i};if(!i.isFinal()){s.extend=function(e,n,r){return t.createClass(s,e,n,r||a)}}e.debug("defined class '"+n+"'"+(i.getParent()?" as subclass of "+i.getParent().getName():""));return i};n.prototype.isA=function(t){return this.getMetadata().isA(t)};n.isA=function(t,e){return t instanceof n&&t.isA(e)};n.isObjectA=function(t,e){return t instanceof n&&t.isA(e)};n._Interface=function(t,e,r){if(!t){return t}function a(t,e){return function(){var a=t[e].apply(t,arguments);if(r){return this}else{return a instanceof n?a.getInterface():a}}}if(!e){return{}}var i;for(var s=0,o=e.length;s<o;s++){i=e[s];if(!t[i]||typeof t[i]==="function"){this[i]=a(t,i)}}};return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/AnimationMode", [],function(){"use strict";var i={full:"full",basic:"basic",minimal:"minimal",none:"none"};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/CalendarType", ["sap/ui/base/DataType","sap/base/i18n/date/CalendarType"],function(e,a){"use strict";e.registerEnum("sap.ui.core.CalendarType",a);return a},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/Configuration", ["sap/base/assert","sap/base/config","sap/base/Event","sap/base/Log","sap/base/i18n/Formatting","sap/base/i18n/Localization","sap/base/util/Version","sap/ui/base/DesignTime","sap/ui/base/Object","sap/ui/core/AnimationMode","sap/ui/core/ControlBehavior","sap/ui/core/getCompatibilityVersion","sap/ui/core/Locale","sap/ui/core/Supportability","sap/ui/core/Theming","sap/ui/security/Security"],function(e,t,n,a,i,r,o,s,u,g,l,c,p,m,f,d){"use strict";var y=new o("1.120.31");var C;var b;var h;function A(){h=h||{__count:0};h.__count++;return h}function T(){if(h&&--h.__count===0){var e=h;delete h.__count;h=undefined;b?.fireLocalizationChanged(e)}}var S=u.extend("sap.ui.core.Configuration",{constructor:function(){u.call(this);a.error("Configuration is designed as a singleton and should not be created manually! "+"Please require 'sap/ui/core/Configuration' instead and use the module export directly without using 'new'.");return S}});Object.assign(S,{getVersion:function(){return y},getCompatibilityVersion:c,getTheme:f.getTheme,setTheme:function(e){f.setTheme(e);return this},getLanguage:r.getLanguage,setLanguage:function(){r.setLanguage.apply(r,arguments);return S},getLanguageTag:function(){return r.getLanguageTag().toString()},getSAPLogonLanguage:r.getSAPLogonLanguage,getTimezone:r.getTimezone,setTimezone:function(){r.setTimezone.apply(r,arguments);return S},getCalendarType:i.getCalendarType,getCalendarWeekNumbering:i.getCalendarWeekNumbering,getRTL:r.getRTL,setRTL:function(){r.setRTL.apply(r,arguments);return S},getLocale:function(){var e=r.getLanguageTag();return p._getCoreLocale(e)},setCalendarType:function(e){i.setCalendarType.apply(i,arguments);return this},setCalendarWeekNumbering:function(e){i.setCalendarWeekNumbering.apply(i,arguments);return this},getFormatLocale:function(){return i.getLanguageTag().toString()},setFormatLocale:function(e){i.setLanguageTag.apply(i,arguments);return this},getLanguagesDeliveredWithCore:r.getLanguagesDeliveredWithCore,getSupportedLanguages:r.getSupportedLanguages,getAccessibility:l.isAccessibilityEnabled,getAutoAriaBodyRole:function(){return t.get({name:"sapUiAutoAriaBodyRole",type:t.Type.Boolean})},getAnimation:function(){var e=S.getAnimationMode();return e!==S.AnimationMode.minimal&&e!==S.AnimationMode.none},getAnimationMode:l.getAnimationMode,setAnimationMode:l.setAnimationMode,getFiori2Adaptation:function(){var e=t.get({name:"sapUiXxFiori2Adaptation",type:t.Type.StringArray,external:true}),n;if(e.length===0||e.length===1&&e[0]==="false"){n=false}else if(e.length===1&&e[0]==="true"){n=true}return n===undefined?e:n},getDebug:m.isDebugModeEnabled,getInspect:m.isControlInspectorEnabled,getOriginInfo:m.collectOriginInfo,getNoDuplicateIds:function(){return t.get({name:"sapUiNoDuplicateIds",type:t.Type.Boolean,defaultValue:true,external:true})},getUIDPrefix:function(){var e=sap.ui.require("sap/ui/base/ManagedObjectMetadata");return e.getUIDPrefix()},getDesignMode:s.isDesignModeEnabled,getSuppressDeactivationOfControllerCode:s.isControllerCodeDeactivationSuppressed,getControllerCodeDeactivated:s.isControllerCodeDeactivated,getApplication:function(){return t.get({name:"sapUiApplication",type:t.Type.String,external:true})},getRootComponent:function(){return t.get({name:"sapUiRootComponent",type:t.Type.String})},getAppCacheBuster:function(){return t.get({name:"sapUiAppCacheBuster",type:t.Type.StringArray,external:true,freeze:true})},getAppCacheBusterMode:function(){return t.get({name:"sapUiXxAppCacheBusterMode",type:t.Type.String,defaultValue:"sync",external:true,freeze:true})},getDisableCustomizing:function(){return t.get({name:"sapUiXxDisableCustomizing",type:t.Type.Boolean})},getManifestFirst:function(){return t.get({name:"sapUiManifestFirst",type:t.Type.Boolean,external:true})},getFlexibilityServices:function(){var e=sap.ui.require("sap/ui/fl/initial/_internal/FlexConfiguration");var n;if(e){n=e.getFlexibilityServices()}else{const e=[{url:"/sap/bc/lrep",connector:"LrepConnector"}];n=t.get({name:"sapUiFlexibilityServices",type:t=>{if(t&&typeof t==="string"){if(t[0]==="/"){e[0].url=t;t=e}else{t=JSON.parse(t)}}return t||[]},defaultValue:e,external:true})}return n},getFormatSettings:function(){return C},getFrameOptions:d.getFrameOptions,getWhitelistService:d.getAllowlistService,getAllowlistService:d.getAllowlistService,getFileShareSupport:function(){return t.get({name:"sapUiFileShareSupport",type:t.Type.String,defaultValue:undefined})},getStatistics:S.getStatisticsEnabled,getStatisticsEnabled:m.isStatisticsEnabled,getNoNativeScroll:function(){return false},getActiveTerminologies:r.getActiveTerminologies,getSecurityTokenHandlers:d.getSecurityTokenHandlers,setSecurityTokenHandlers:d.setSecurityTokenHandlers,applySettings:function(t){function n(e,t){var i,r;for(i in t){r="set"+i.slice(0,1).toUpperCase()+i.slice(1);if(i==="formatSettings"&&C){n(C,t[i])}else if(typeof e[r]==="function"){e[r](t[i])}else{a.warning("Configuration.applySettings: unknown setting '"+i+"' ignored")}}}e(typeof t==="object","mSettings must be an object");A();n(S,t);T();return this},setCore:function(e){b=e}});S.AnimationMode=g;function L(e,t){if(!e){throw new Error(t)}}var D=u.extend("sap.ui.core.Configuration.FormatSettings",{constructor:function(){u.call(this);this.mSettings={}},getFormatLocale:function(){var e=i.getLanguageTag();return p._getCoreLocale(e)},_set:i._set,getCustomUnits:i.getCustomUnits,setCustomUnits:function(){i.setCustomUnits.apply(i,arguments);return this},addCustomUnits:function(){i.addCustomUnits.apply(i,arguments);return this},setUnitMappings:function(){i.setUnitMappings.apply(i,arguments);return this},addUnitMappings:function(){i.addUnitMappings.apply(i,arguments);return this},getUnitMappings:i.getUnitMappings,getDatePattern:i.getDatePattern,setDatePattern:function(){i.setDatePattern.apply(i,arguments);return this},getTimePattern:i.getTimePattern,setTimePattern:function(){i.setTimePattern.apply(i,arguments);return this},getNumberSymbol:i.getNumberSymbol,setNumberSymbol:function(){i.setNumberSymbol.apply(i,arguments);return this},getCustomCurrencies:i.getCustomCurrencies,setCustomCurrencies:function(){i.setCustomCurrencies.apply(i,arguments);return this},addCustomCurrencies:function(){i.addCustomCurrencies.apply(i,arguments);return this},setFirstDayOfWeek:function(e){L(typeof e=="number"&&e>=0&&e<=6,"iValue must be an integer value between 0 and 6");i._set("weekData-firstDay",e);return this},_setDayPeriods:i._setDayPeriods,getLegacyDateFormat:i.getABAPDateFormat,setLegacyDateFormat:function(){i.setABAPDateFormat.apply(i,arguments);return this},getLegacyTimeFormat:i.getABAPTimeFormat,setLegacyTimeFormat:function(){i.setABAPTimeFormat.apply(i,arguments);return this},getLegacyNumberFormat:i.getABAPNumberFormat,setLegacyNumberFormat:function(){i.setABAPNumberFormat.apply(i,arguments);return this},setLegacyDateCalendarCustomizing:function(){i.setCustomIslamicCalendarData.apply(i,arguments);return this},getLegacyDateCalendarCustomizing:i.getCustomIslamicCalendarData,setTrailingCurrencyCode:function(){i.setTrailingCurrencyCode.apply(i,arguments);return this},getTrailingCurrencyCode:i.getTrailingCurrencyCode,getCustomLocaleData:i.getCustomLocaleData});C=new D(this);r.attachChange(function(e){if(!h&&b){b.fireLocalizationChanged(n.getParameters(e))}else if(h){Object.assign(h,n.getParameters(e))}});i.attachChange(function(e){const t=n.getParameters(e);Object.keys(e).forEach(e=>{if(["ABAPDateFormat","ABAPTimeFormat","ABAPNumberFormat"].includes(e)){t[e.replace("ABAP","legacy")]=t[e];delete t[e]}else if(e==="customIslamicCalendarData"){t["legacyDateCalendarCustomizing"]=t[e];delete t[e]}});if(!h&&b){b.fireLocalizationChanged(t)}else if(h){Object.assign(h,t)}});return S});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/ControlBehavior", ["sap/base/config","sap/base/Eventing","sap/ui/core/AnimationMode"],(e,n,t)=>{"use strict";const a=e.getWritableInstance();const i=new n;const o={attachChange:e=>{i.attachEvent("change",e)},detachChange:e=>{i.detachEvent("change",e)},isAccessibilityEnabled:()=>a.get({name:"sapUiAccessibility",type:e.Type.Boolean,defaultValue:true,external:true}),getAnimationMode:()=>{let n=a.get({name:"sapUiAnimationMode",type:t,defaultValue:undefined,external:true});const i=a.get({name:"sapUiAnimation",type:e.Type.Boolean,defaultValue:true,external:true});if(n===undefined){if(i){n=t.full}else{n=t.minimal}}e._.checkEnum(t,n,"animationMode");return n},setAnimationMode:n=>{e._.checkEnum(t,n,"animationMode");const i=a.get({name:"sapUiAnimationMode",type:t,defaultValue:undefined,external:true});a.set("sapUiAnimationMode",n);if(i!=n){s({animationMode:n})}}};function s(e){i.fireEvent("change",e)}return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/Locale", ["sap/base/assert","sap/ui/base/Object","sap/base/i18n/Localization","sap/base/i18n/LanguageTag"],function(t,n,e,a){"use strict";var i=Object.create(null);var s=n.extend("sap.ui.core.Locale",{constructor:function(t){n.apply(this);if(t instanceof a){this.oLanguageTag=t;this.sLocaleId=this.oLanguageTag.toString()}else{this.oLanguageTag=new a(t);this.sLocaleId=t}Object.assign(this,this.oLanguageTag);this.sLanguage=this.language},getLanguage:function(){return this.language},getScript:function(){return this.script},getRegion:function(){return this.region},getVariant:function(){return this.variant},getVariantSubtags:function(){return this.variantSubtags},getExtension:function(){return this.extension},getExtensionSubtags:function(){return this.extensionSubtags},getPrivateUse:function(){return this.privateUse},getPrivateUseSubtags:function(){return this.privateUseSubtags},hasPrivateUseSubtag:function(n){t(n&&n.match(/^[0-9A-Z]{1,8}$/i),"subtag must be a valid BCP47 private use tag");return this.privateUseSubtags.indexOf(n)>=0},toString:function(){return this.oLanguageTag.toString()},getSAPLogonLanguage:function(){return e._getSAPLogonLanguage(this)}});s._getCoreLocale=function(t){if(t instanceof a){t=i[t.toString()]||new s(t);i[t.toString()]=t}return t};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/LocaleData", ["./CalendarType","./Locale","sap/base/assert","sap/base/i18n/LanguageTag","sap/base/i18n/Localization","sap/base/util/extend","sap/base/util/LoaderExtensions","sap/ui/base/Object","sap/ui/core/Configuration","sap/ui/core/date/CalendarWeekNumbering"],function(e,t,r,n,i,a,o,s,u,l){"use strict";var c=/c/i,f=/e/i,g={"acceleration-meter-per-second-squared":"acceleration-meter-per-square-second","concentr-milligram-per-deciliter":"concentr-milligram-ofglucose-per-deciliter","concentr-part-per-million":"concentr-permillion","consumption-liter-per-100kilometers":"consumption-liter-per-100-kilometer","mass-metric-ton":"mass-tonne","pressure-millimeter-of-mercury":"pressure-millimeter-ofhg","pressure-pound-per-square-inch":"pressure-pound-force-per-square-inch","pressure-inch-hg":"pressure-inch-ofhg","torque-pound-foot":"torque-pound-force-foot"},m=/^([+-]?)((\d+)(?:\.(\d+))?)[eE]([+-]?\d+)$/,h=/0+$/;const d=/(.*)?\{[0|1]}(.*)?\{[0|1]}(.*)?/;const p=["narrow","abbreviated","wide"];var _=s.extend("sap.ui.core.LocaleData",{constructor:function(e){s.apply(this);this.oLocale=t._getCoreLocale(e);var r=T(this.oLocale);this.mData=r.mData;this.sCLDRLocaleId=r.sCLDRLocaleId},_get:function(){return this._getDeep(this.mData,arguments)},_getMerged:function(){return this._get.apply(this,arguments)},_getMonthsWithAlternatives:function(e,t){return this._get(P(t),"months","format",e)},_getMonthsStandAloneWithAlternatives:function(e,t){return this._get(P(t),"months","stand-alone",e)},_getDeep:function(e,t){var r=e;for(var n=0;n<t.length;n++){r=r[t[n]];if(r===undefined){break}}return r},getOrientation:function(){return this._get("orientation")},getCurrentLanguageName:function(){return this.getLanguageName(this.oLocale.toString())},getLanguageName:function(e){const t=new n(e);let r=i.getModernLanguage(t.language);let a=t.script;if(r==="sr"&&a==="Latn"){r="sh";a=null}const o=t.region;const s=this._get("languages");const u=s[r];if(!a&&!o||!u){return u}const l=s[r+"_"+o]||s[r+"_"+a];if(l){return l}if(a){const e=this._get("scripts")[a];if(e){return u+" ("+e+")"}}if(o){const e=this._get("territories")[o];if(e){return u+" ("+e+")"}}return u},getLanguages:function(){const e=this._get("languages");["ar_001","de_AT","de_CH","en_AU","en_CA","en_GB","en_US","es_419","es_ES","es_MX","fa_AF","fr_CA","fr_CH","nds_NL","nl_BE","pt_BR","pt_PT","ro_MD","sw_CD","zh_Hans","zh_Hant"].forEach(t=>{if(!e[t]){e[t]=this.getLanguageName(t)}});return e},getScripts:function(){return this._get("scripts")},getTerritories:function(){return this._get("territories")},getMonths:function(e,t){r(p.includes(e),"sWidth must be narrow, abbreviated or wide");return this._get(P(t),"months","format",e).map(e=>Array.isArray(e)?e[0]:e)},getMonthsStandAlone:function(e,t){r(p.includes(e),"sWidth must be narrow, abbreviated or wide");return this._get(P(t),"months","stand-alone",e).map(e=>Array.isArray(e)?e[0]:e)},getDays:function(e,t){r(e=="narrow"||e=="abbreviated"||e=="wide"||e=="short","sWidth must be narrow, abbreviate, wide or short");return this._get(P(t),"days","format",e)},getDaysStandAlone:function(e,t){r(e=="narrow"||e=="abbreviated"||e=="wide"||e=="short","sWidth must be narrow, abbreviated, wide or short");return this._get(P(t),"days","stand-alone",e)},getQuarters:function(e,t){r(e=="narrow"||e=="abbreviated"||e=="wide","sWidth must be narrow, abbreviated or wide");return this._get(P(t),"quarters","format",e)},getQuartersStandAlone:function(e,t){r(e=="narrow"||e=="abbreviated"||e=="wide","sWidth must be narrow, abbreviated or wide");return this._get(P(t),"quarters","stand-alone",e)},getDayPeriods:function(e,t){r(e=="narrow"||e=="abbreviated"||e=="wide","sWidth must be narrow, abbreviated or wide");return this._get(P(t),"dayPeriods","format",e)},getDayPeriodsStandAlone:function(e,t){r(e=="narrow"||e=="abbreviated"||e=="wide","sWidth must be narrow, abbreviated or wide");return this._get(P(t),"dayPeriods","stand-alone",e)},getDatePattern:function(e,t){r(e=="short"||e=="medium"||e=="long"||e=="full","sStyle must be short, medium, long or full");return this._get(P(t),"dateFormats",e)},getFlexibleDayPeriods:function(e,t){return this._get(P(t),"flexibleDayPeriods","format",e)},getFlexibleDayPeriodsStandAlone:function(e,t){return this._get(P(t),"flexibleDayPeriods","stand-alone",e)},getFlexibleDayPeriodOfTime:function(e,t){var r,n,i;r=(e*60+t)%1440;n=this._get("dayPeriodRules");function a(e){var t=e.split(":"),r=t[0],n=t[1];return parseInt(r)*60+parseInt(n)}i=Object.keys(n).find(function(e){var t=n[e];return t["_at"]&&a(t["_at"])===r});if(i){return i}return Object.keys(n).find(function(e){var t,i,o,s=n[e];if(s["_at"]){return false}o=a(s["_from"]);t=a(s["_before"]);if(o>t){i=[{start:o,end:1440},{start:0,end:t}]}else{i=[{start:o,end:t}]}return i.some(function(e){return e.start<=r&&e.end>r})})},getTimePattern:function(e,t){r(e=="short"||e=="medium"||e=="long"||e=="full","sStyle must be short, medium, long or full");return this._get(P(t),"timeFormats",e)},getDateTimePattern:function(e,t){r(e=="short"||e=="medium"||e=="long"||e=="full","sStyle must be short, medium, long or full");return this._get(P(t),"dateTimeFormats",e)},getCombinedDateTimePattern:function(e,t,n){r(e=="short"||e=="medium"||e=="long"||e=="full","sStyle must be short, medium, long or full");r(t=="short"||t=="medium"||t=="long"||t=="full","sStyle must be short, medium, long or full");var i=this.getDateTimePattern(e,n),a=this.getDatePattern(e,n),o=this.getTimePattern(t,n);return i.replace("{0}",o).replace("{1}",a)},getCombinedDateTimeWithTimezonePattern:function(e,t,r){return this.applyTimezonePattern(this.getCombinedDateTimePattern(e,t,r))},applyTimezonePattern:function(e){var t=[e];var r=[{group:"Timezone",length:2,field:"zone",symbol:"V"}];this._appendItems(t,r);return t[0]},getTimezoneTranslations:function(){var e=this.oLocale.toString();var t=_._mTimezoneTranslations[e];if(!t){_._mTimezoneTranslations[e]=t=k(this._get("timezoneNames"))}return Object.assign({},t)},getCustomDateTimePattern:function(e,t){var r=this._get(P(t),"dateTimeFormats","availableFormats");return this._getFormatPattern(e,r,t)},getIntervalPattern:function(e,t){var r=this._get(P(t),"dateTimeFormats","intervalFormats"),n,i,a,o,s;if(e){n=e.split("-");i=n[0];a=n[1];o=r[i];if(o){s=o[a];if(s){return s}}}return r.intervalFormatFallback},getCombinedIntervalPattern:function(e,t){const r=this._get(P(t),"dateTimeFormats","intervalFormats");const[,n,i,a]=d.exec(r.intervalFormatFallback);return _._escapeIfNeeded(n)+e+_._escapeIfNeeded(i)+e+_._escapeIfNeeded(a)},getCustomIntervalPattern:function(e,t,r){var n=this._get(P(r),"dateTimeFormats","intervalFormats");return this._getFormatPattern(e,n,r,t)},_getFormatPattern:function(e,t,r,n){var i,a,o;if(!n){i=t[e]}else if(typeof n==="string"){if(n=="j"||n=="J"){n=this.getPreferredHourSymbol()}o=t[e];i=o&&o[n]}if(i){if(typeof i==="object"){a=Object.keys(i).map(function(e){return i[e]})}else{return i}}if(!a){a=this._createFormatPattern(e,t,r,n)}if(a&&a.length===1){return a[0]}return a},_createFormatPattern:function(e,t,r,n){var i=this._parseSkeletonFormat(e),a,o=this._findBestMatch(i,e,t),s,u,l,c,f,g,m,h,d=/^([GyYqQMLwWEecdD]+)([hHkKjJmszZvVOXx]+)$/,p,_;if(n){if(typeof n==="string"){h=v[n]?v[n].group:"";if(h){p=y[h].index>i[i.length-1].index}m=n}else{p=true;if(i[0].symbol==="y"&&o&&o.pattern.G){l=v["G"];c=y[l.group];i.splice(0,0,{symbol:"G",group:l.group,match:l.match,index:c.index,field:c.field,length:1})}for(_=i.length-1;_>=0;_--){s=i[_];if(n[s.group]){p=false;break}}for(_=0;_<i.length;_++){s=i[_];if(n[s.group]){m=s.symbol;break}}if((m=="h"||m=="K")&&n.DayPeriod){m="a"}}if(p){return[this.getCustomDateTimePattern(e,r)]}if(o&&o.missingTokens.length===0){f=o.pattern[m];if(f&&o.distance>0){f=this._expandFields(f,o.patternTokens,i)}}if(!f){u=this._get(P(r),"dateTimeFormats","availableFormats");if(d.test(e)&&"ahHkKjJms".indexOf(m)>=0){f=this._getMixedFormatPattern(e,u,r,n)}else{g=this._getFormatPattern(e,u,r);f=this.getCombinedIntervalPattern(g,r)}}a=[f]}else if(!o){f=e;a=[f]}else{if(typeof o.pattern==="string"){a=[o.pattern]}else if(typeof o.pattern==="object"){a=[];for(var b in o.pattern){f=o.pattern[b];a.push(f)}}if(o.distance>0){if(o.missingTokens.length>0){if(d.test(e)){a=[this._getMixedFormatPattern(e,t,r)]}else{a=this._expandFields(a,o.patternTokens,i);a=this._appendItems(a,o.missingTokens,r)}}else{a=this._expandFields(a,o.patternTokens,i)}}}if(e.indexOf("J")>=0){a.forEach(function(e,t){a[t]=e.replace(/ ?[abB](?=([^']*'[^']*')*[^']*)$/g,"")})}return a},_parseSkeletonFormat:function(e){var t=[],r={index:-1},n,i,a;for(var o=0;o<e.length;o++){n=e.charAt(o);if(n=="j"||n=="J"){n=this.getPreferredHourSymbol()}if(n==r.symbol){r.length++;continue}i=v[n];a=y[i.group];if(i.group=="Other"||a.diffOnly){throw new Error("Symbol '"+n+"' is not allowed in skeleton format '"+e+"'")}if(a.index<=r.index){throw new Error("Symbol '"+n+"' at wrong position or duplicate in skeleton format '"+e+"'")}r={symbol:n,group:i.group,match:i.match,index:a.index,field:a.field,length:1};t.push(r)}return t},_findBestMatch:function(e,t,r){var n,i,a,o,s,u,l,c,f,g,m={distance:1e4,firstDiffPos:-1};for(var h in r){if(h==="intervalFormatFallback"||h.indexOf("B")>-1){continue}n=this._parseSkeletonFormat(h);u=0;i=[];l=true;if(e.length<n.length){continue}s=0;c=e.length;for(var d=0;d<e.length;d++){a=e[d];o=n[s];if(c===e.length){c=d}if(o){f=v[a.symbol];g=v[o.symbol];if(a.symbol===o.symbol){if(a.length===o.length){if(c===d){c=e.length}}else{if(a.length<f.numericCeiling?o.length<g.numericCeiling:o.length>=g.numericCeiling){u+=Math.abs(a.length-o.length)}else{u+=5}}s++;continue}else{if(a.match==o.match){u+=Math.abs(a.length-o.length)+10;s++;continue}}}i.push(a);u+=50-d}if(s<n.length){l=false}if(l&&(u<m.distance||u===m.distance&&c>m.firstDiffPos)){m.distance=u;m.firstDiffPos=c;m.missingTokens=i;m.pattern=r[h];m.patternTokens=n}}if(m.pattern){return m}},_expandFields:function(e,t,r){var n=typeof e==="string";var i;if(n){i=[e]}else{i=e}var a=i.map(function(e){var n={},i={},a="",o=false,s=0,u,l,c,f,g,m,h,d;r.forEach(function(e){n[e.group]=e});t.forEach(function(e){i[e.group]=e});while(s<e.length){d=e.charAt(s);if(o){a+=d;if(d=="'"){o=false}}else{h=v[d];if(h&&n[h.group]&&i[h.group]){g=n[h.group];m=i[h.group];u=g.length;c=m.length;l=1;while(e.charAt(s+1)==d){s++;l++}if(u===c||(u<h.numericCeiling?l>=h.numericCeiling:l<h.numericCeiling)){f=l}else{f=Math.max(l,u)}for(var p=0;p<f;p++){a+=d}}else{a+=d;if(d=="'"){o=true}}}s++}return a});return n?a[0]:a},_appendItems:function(e,t,r){var n=this._get(P(r),"dateTimeFormats","appendItems");e.forEach(function(r,i){var a,o,s;t.forEach(function(t){o=n[t.group];a="'"+this.getDisplayName(t.field)+"'";s="";for(var u=0;u<t.length;u++){s+=t.symbol}e[i]=o.replace(/\{0\}/,r).replace(/\{1\}/,s).replace(/\{2\}/,a)}.bind(this))}.bind(this));return e},_getMixedFormatPattern:function(e,t,r,n){var i=/^([GyYqQMLwWEecdD]+)([hHkKjJmszZvVOXx]+)$/,a=/MMMM|LLLL/,o=/MMM|LLL/,s=/E|e|c/,u,l,c,f,g,m,h,d;u=i.exec(e);l=u[1];c=u[2];g=this._getFormatPattern(l,t,r);if(n){m=this.getCustomIntervalPattern(c,n,r)}else{m=this._getFormatPattern(c,t,r)}if(a.test(l)){f=s.test(l)?"full":"long"}else if(o.test(l)){f="medium"}else{f="short"}h=this.getDateTimePattern(f,r);d=h.replace(/\{1\}/,g).replace(/\{0\}/,m);return d},getNumberSymbol:function(e){r(e=="decimal"||e=="group"||e=="plusSign"||e=="minusSign"||e=="percentSign","sType must be decimal, group, plusSign, minusSign or percentSign");return this._get("symbols-latn-"+e)},getLenientNumberSymbols:function(e){r(e=="plusSign"||e=="minusSign","sType must be plusSign or minusSign");return this._get("lenient-scope-number")[e]},getDecimalPattern:function(){return this._get("decimalFormat").standard},getCurrencyPattern:function(e){return this._get("currencyFormat")[e]||this._get("currencyFormat").standard},getCurrencySpacing:function(e){return this._get("currencyFormat","currencySpacing",e==="after"?"afterCurrency":"beforeCurrency")},getPercentPattern:function(){return this._get("percentFormat").standard},getMiscPattern:function(e){r(e=="approximately"||e=="atLeast"||e=="atMost"||e=="range","sName must be approximately, atLeast, atMost or range");return this._get("miscPattern")[e]},getMinimalDaysInFirstWeek:function(){return this._get("weekData-minDays")},getFirstDayOfWeek:function(){return this._get("weekData-firstDay")},getWeekendStart:function(){return this._get("weekData-weekendStart")},getWeekendEnd:function(){return this._get("weekData-weekendEnd")},getCustomCurrencyCodes:function(){var e=this._get("currency")||{},t={};Object.keys(e).forEach(function(e){t[e]=e});return t},getCurrencyDigits:function(e){var t=this._get("currency");if(t){if(t[e]&&t[e].hasOwnProperty("digits")){return t[e].digits}else if(t["DEFAULT"]&&t["DEFAULT"].hasOwnProperty("digits")){return t["DEFAULT"].digits}}var r=this._get("currencyDigits",e);if(r==null){r=this._get("currencyDigits","DEFAULT");if(r==null){r=2}}return r},getCurrencySymbol:function(e){var t=this.getCurrencySymbols();return t&&t[e]||e},getCurrencyCodeBySymbol:function(e){var t=this._get("currencySymbols"),r;for(r in t){if(t[r]===e){return r}}return e},getCurrencySymbols:function(){var e=this._get("currency"),t={},r;for(var n in e){r=e[n].isoCode;if(e[n].symbol){t[n]=e[n].symbol}else if(r){t[n]=this._get("currencySymbols")[r]}}return Object.assign({},this._get("currencySymbols"),t)},getUnitDisplayName:function(e){var t=this.getUnitFormat(e);return t&&t["displayName"]||""},getRelativePatterns:function(e,t){if(t===undefined){t="wide"}r(t==="wide"||t==="short"||t==="narrow","sStyle is only allowed to be set with 'wide', 'short' or 'narrow'");var n=[],i=this.getPluralCategories(),a,o,s,u;if(!e){e=["year","month","week","day","hour","minute","second"]}e.forEach(function(e){a=this._get("dateFields",e+"-"+t);for(var r in a){if(r.indexOf("relative-type-")===0){s=parseInt(r.substr(14));n.push({scale:e,value:s,pattern:a[r]})}else if(r.indexOf("relativeTime-type-")==0){o=a[r];u=r.substr(18)==="past"?-1:1;i.forEach(function(t){var r=o["relativeTimePattern-count-"+t];if(r){n.push({scale:e,sign:u,pattern:r})}})}}}.bind(this));return n},getRelativePattern:function(e,t,n,i){var a,o,s,u;if(typeof n==="string"){i=n;n=undefined}if(n===undefined){n=t>0}if(i===undefined){i="wide"}r(i==="wide"||i==="short"||i==="narrow","sStyle is only allowed to be set with 'wide', 'short' or 'narrow'");s=e+"-"+i;if(t===0||t===-2||t===2){a=this._get("dateFields",s,"relative-type-"+t)}if(!a){o=this._get("dateFields",s,"relativeTime-type-"+(n?"future":"past"));u=this.getPluralCategory(Math.abs(t).toString());a=o["relativeTimePattern-count-"+u]}return a},getRelativeSecond:function(e,t){return this.getRelativePattern("second",e,t)},getRelativeMinute:function(e,t){if(e==0){return null}return this.getRelativePattern("minute",e,t)},getRelativeHour:function(e,t){if(e==0){return null}return this.getRelativePattern("hour",e,t)},getRelativeDay:function(e,t){return this.getRelativePattern("day",e,t)},getRelativeWeek:function(e,t){return this.getRelativePattern("week",e,t)},getRelativeMonth:function(e,t){return this.getRelativePattern("month",e,t)},getDisplayName:function(e,t){r(e=="second"||e=="minute"||e=="hour"||e=="zone"||e=="day"||e=="weekday"||e=="week"||e=="month"||e=="quarter"||e=="year"||e=="era","sType must be second, minute, hour, zone, day, weekday, week, month, quarter, year, era");if(t===undefined){t="wide"}r(t==="wide"||t==="short"||t==="narrow","sStyle is only allowed to be set with 'wide', 'short' or 'narrow'");var n=["era","weekday","zone"],i=n.indexOf(e)===-1?e+"-"+t:e;return this._get("dateFields",i,"displayName")},getRelativeYear:function(e,t){return this.getRelativePattern("year",e,t)},getDecimalFormat:function(e,t,r){var n;var i;switch(e){case"long":i=this._get("decimalFormat-long");break;default:i=this._get("decimalFormat-short");break}if(i){var a=t+"-"+r;n=i[a];if(!n){a=t+"-other";n=i[a]}}return n},getCurrencyFormat:function(e,t,r){var n;var i=this._get("currencyFormat-"+e);if(!i){if(e==="sap-short"){throw new Error('Failed to get CLDR data for property "currencyFormat-sap-short"')}i=this._get("currencyFormat-short")}if(i){var a=t+"-"+r;n=i[a];if(!n){a=t+"-other";n=i[a]}}return n},getListFormat:function(e,t){var r=this._get("listPattern-"+(e||"standard")+"-"+(t||"wide"));if(r){return r}return{}},getResolvedUnitFormat:function(e){e=this.getUnitFromMapping(e)||e;return this.getUnitFormat(e)},getUnitFormat:function(e){var t=this._get("units","short",e);if(!t&&g[e]){t=this._get("units","short",g[e])}return t},getUnitFormats:function(){return this._getMerged("units","short")},getUnitFromMapping:function(e){return this._get("unitMappings",e)},getEras:function(e,t){r(e=="wide"||e=="abbreviated"||e=="narrow","sWidth must be wide, abbreviate or narrow");var n=this._get(P(t),"era-"+e),i=[];for(var a in n){i[parseInt(a)]=n[a]}return i},getEraDates:function(e){var t=this._get("eras-"+e.toLowerCase()),r=[];for(var n in t){r[parseInt(n)]=t[n]}return r},getCalendarWeek:function(e,t){r(e=="wide"||e=="narrow","sStyle must be wide or narrow");var n=sap.ui.getCore().getLibraryResourceBundle("sap.ui.core",this.oLocale.toString()),i="date.week.calendarweek."+e;return n.getText(i,t?[t]:undefined)},firstDayStartsFirstWeek:function(){return this.oLocale.getLanguage()==="en"&&this.oLocale.getRegion()==="US"},getPreferredCalendarType:function(){var t,r,n,i=this._get("calendarPreference")||[];for(n=0;n<i.length;n++){t=i[n].split("-")[0];for(r in e){if(t===r.toLowerCase()){return r}}}return e.Gregorian},getPreferredHourSymbol:function(){return this._get("timeData","_preferred")},getPluralCategories:function(){var e=this._get("plurals"),t=Object.keys(e);t.push("other");return t},getPluralCategory:function(e){var t=typeof e==="number"?e.toString():e,r=this._get("plurals");if(!this._pluralTest){this._pluralTest={}}for(var n in r){var i=this._pluralTest[n];if(!i){i=this._parsePluralRule(r[n]);this._pluralTest[n]=i}if(i(t).bMatch){return n}}return"other"},_parsePluralRule:function(e){var t="or",r="and",n="%",i="=",a="!=",o="n",s="i",u="f",l="t",g="v",m="w",d="c",p="e",y="..",v=",";var b=0,w;w=e.split(" ");function C(e){if(w[b]===e){b++;return true}return false}function D(){var e=w[b];b++;return e}function k(){var e,r;e=P();if(C(t)){r=k();return function(t){return e(t)||r(t)}}return e}function P(){var e,t;e=T();if(C(r)){t=P();return function(r){return e(r)&&t(r)}}return e}function T(){var e,t,r;e=F();if(C(i)){r=true}else if(C(a)){r=false}else{throw new Error("Expected '=' or '!='")}t=L();if(r){return function(r){return t(r).indexOf(e(r))>=0}}else{return function(r){return t(r).indexOf(e(r))===-1}}}function F(){var e;e=S();if(C(n)){var t=parseInt(D());return function(r){return e(r)%t}}return e}function S(){if(C(o)){return function(e){return e.n}}else if(C(s)){return function(e){return e.i}}else if(C(u)){return function(e){return e.f}}else if(C(l)){return function(e){return e.t}}else if(C(g)){return function(e){return e.v}}else if(C(m)){return function(e){return e.w}}else if(C(d)){return function(e){return e.c}}else if(C(p)){return function(e){return e.c}}else{throw new Error("Unknown operand: "+D())}}function L(){var e=[],t=D(),r=t.split(v),n,i,a;r.forEach(function(t){n=t.split(y);if(n.length===1){e.push(parseInt(t))}else{i=parseInt(n[0]);a=parseInt(n[1]);for(var r=i;r<=a;r++){e.push(r)}}});return function(t){return e}}var x=k();if(b!=w.length){throw new Error("Not completely parsed")}return function(e){var t,r,n,i,a,o,s;e=e.replace(c,"e");n=e.search(f);r=n<0?0:parseInt(e.slice(n+1));e=_.convertToDecimal(e);t=e.indexOf(".");if(t===-1){o=e;i="";a=""}else{o=e.slice(0,t);i=e.slice(t+1);a=i.replace(h,"")}s={n:parseFloat(e),i:parseInt(o),v:i.length,w:a.length,f:i===""?0:parseInt(i),t:a===""?0:parseInt(a),c:r};return{bMatch:x(s),oOperands:s}}}});_.convertToDecimal=function(e){var t,r,n,i,a,o,s=String(e);if(!s.includes("e")&&!s.includes("E")){return s}o=s.match(m);i=o[1]==="-";s=o[2].replace(".","");t=o[3]?o[3].length:0;n=o[4]?o[4].length:0;r=parseInt(o[5]);a=t+r;if(r>0){s=r<n?s.slice(0,a)+"."+s.slice(a):s=s.padEnd(a,"0")}else{s=-r<t?s=s.slice(0,a)+"."+s.slice(a):s="0."+s.padStart(n-r,"0")}if(i){s="-"+s}return s};var y={Era:{field:"era",index:0},Year:{field:"year",index:1},Quarter:{field:"quarter",index:2},Month:{field:"month",index:3},Week:{field:"week",index:4},"Day-Of-Week":{field:"weekday",index:5},Day:{field:"day",index:6},DayPeriod:{field:"hour",index:7,diffOnly:true},Hour:{field:"hour",index:8},Minute:{field:"minute",index:9},Second:{field:"second",index:10},Timezone:{field:"zone",index:11}};var v={G:{group:"Era",match:"Era",numericCeiling:1},y:{group:"Year",match:"Year",numericCeiling:100},Y:{group:"Year",match:"Year",numericCeiling:100},Q:{group:"Quarter",match:"Quarter",numericCeiling:3},q:{group:"Quarter",match:"Quarter",numericCeiling:3},M:{group:"Month",match:"Month",numericCeiling:3},L:{group:"Month",match:"Month",numericCeiling:3},w:{group:"Week",match:"Week",numericCeiling:100},W:{group:"Week",match:"Week",numericCeiling:100},d:{group:"Day",match:"Day",numericCeiling:100},D:{group:"Day",match:"Day",numericCeiling:100},E:{group:"Day-Of-Week",match:"Day-Of-Week",numericCeiling:1},e:{group:"Day-Of-Week",match:"Day-Of-Week",numericCeiling:3},c:{group:"Day-Of-Week",match:"Day-Of-Week",numericCeiling:2},h:{group:"Hour",match:"Hour12",numericCeiling:100},H:{group:"Hour",match:"Hour24",numericCeiling:100},k:{group:"Hour",match:"Hour24",numericCeiling:100},K:{group:"Hour",match:"Hour12",numericCeiling:100},m:{group:"Minute",match:"Minute",numericCeiling:100},s:{group:"Second",match:"Second",numericCeiling:100},z:{group:"Timezone",match:"Timezone",numericCeiling:1},Z:{group:"Timezone",match:"Timezone",numericCeiling:1},O:{group:"Timezone",match:"Timezone",numericCeiling:1},v:{group:"Timezone",match:"Timezone",numericCeiling:1},V:{group:"Timezone",match:"Timezone",numericCeiling:1},X:{group:"Timezone",match:"Timezone",numericCeiling:1},x:{group:"Timezone",match:"Timezone",numericCeiling:1},S:{group:"Other",numericCeiling:100},u:{group:"Other",numericCeiling:100},U:{group:"Other",numericCeiling:1},r:{group:"Other",numericCeiling:100},F:{group:"Other",numericCeiling:100},g:{group:"Other",numericCeiling:100},a:{group:"DayPeriod",numericCeiling:1},b:{group:"Other",numericCeiling:1},B:{group:"Other",numericCeiling:1},A:{group:"Other",numericCeiling:100}};function b(e){var t=/\$([-a-z0-9A-Z._]+)(?::([^$]*))?\$/.exec(e);return t&&t[2]?t[2].split(/,/):null}var w=b("$cldr-locales:ar,ar_EG,ar_SA,bg,ca,cnr,cy,cs,da,de,de_AT,de_CH,el,el_CY,en,en_AU,en_GB,en_HK,en_IE,en_IN,en_NZ,en_PG,en_SG,en_ZA,es,es_AR,es_BO,es_CL,es_CO,es_MX,es_PE,es_UY,es_VE,et,fa,fi,fr,fr_BE,fr_CA,fr_CH,fr_LU,he,hi,hr,hu,id,it,it_CH,ja,kk,ko,lt,lv,mk,ms,nb,nl,nl_BE,pl,pt,pt_PT,ro,ru,ru_UA,sk,sl,sr,sr_Latn,sv,th,tr,uk,vi,zh_CN,zh_HK,zh_SG,zh_TW$");var C=function(){var e=w,t={},r;if(e){for(r=0;r<e.length;r++){t[e[r]]=true}}return t}();var D={};function k(e,t,r,n){n=n?n.slice():[];r=r||{};t=t||"";Object.keys(e).forEach(function(i){var a=e[i];if(typeof a==="object"){var o=n.slice();var s=a["_parent"];if(s){o.push(s)}k(a,t+i+"/",r,o)}else if(typeof a==="string"&&i!=="_parent"){var u=n.length?n.join(", ")+", ":"";r[t+i]=u+a}});return r}function P(e){if(!e){e=u.getCalendarType()}return"ca-"+e.toLowerCase()}function T(e){var t=e.getLanguage()||"",r=e.getScript()||"",n=e.getRegion()||"",a;function s(e,t){var r,n,i;if(!t){return}for(r in t){if(t.hasOwnProperty(r)){n=e[r];i=t[r];if(n===undefined){e[r]=i}else if(n===null){delete e[r]}else if(typeof n==="object"&&typeof i==="object"&&!Array.isArray(n)){s(n,i)}}}}function u(e){if(!D[e]&&(!C||C[e]===true)){var t=D[e]=o.loadResource("sap/ui/core/cldr/"+e+".json",{dataType:"json",failOnError:false});if(t&&t.__fallbackLocale){s(t,u(t.__fallbackLocale));delete t.__fallbackLocale}}return D[e]}t=t&&i.getModernLanguage(t)||t;if(t==="no"){t="nb"}if(t==="zh"&&!n){if(r==="Hans"){n="CN"}else if(r==="Hant"){n="TW"}}if(t==="sh"||t==="sr"&&r==="Latn"){t="sr_Latn"}var l=t+"_"+n;var c=l;if(t&&n){a=u(l)}if(!a&&t){a=u(t);c=t}if(!a){a=u("en");c="en"}D[l]=a;c=c.replace(/_/g,"-");return{mData:a,sCLDRLocaleId:c}}var F=_.extend("sap.ui.core.CustomLocaleData",{constructor:function(e){_.apply(this,arguments);this.mCustomData=u.getFormatSettings().getCustomLocaleData()},_get:function(){var e=Array.prototype.slice.call(arguments),t,r;if(e[0].indexOf("ca-")==0){t=e[0];if(t==P()){e=e.slice(1)}}r=e.join("-");var n=this.mCustomData[r];if(n==null){n=this._getDeep(this.mCustomData,arguments);if(n==null){n=this._getDeep(this.mData,arguments)}}return n},_getMerged:function(){var e=this._getDeep(this.mData,arguments);var t=this._getDeep(this.mCustomData,arguments);return a({},e,t)},getFirstDayOfWeek:function(){var e=u.getCalendarWeekNumbering();if(e===l.Default){return _.prototype.getFirstDayOfWeek.call(this)}return l.getWeekConfigurationValues(e).firstDayOfWeek},getMinimalDaysInFirstWeek:function(){var e=u.getCalendarWeekNumbering();if(e===l.Default){return _.prototype.getMinimalDaysInFirstWeek.call(this)}return l.getWeekConfigurationValues(e).minimalDaysInFirstWeek}});_.getInstance=function(e){e=t._getCoreLocale(e);return e.hasPrivateUseSubtag("sapufmt")?new F(e):new _(e)};_._cldrLocales=w;_._mTimezoneTranslations={};const S=new RegExp("["+Object.keys(v).join("")+"]");const L=/^(\s)?(.*?)(\s)?$/;_._escapeIfNeeded=function(e){if(e===undefined){return""}if(S.test(e)){return e.replace(L,"$1'$2'$3")}return e};return _});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/Supportability", ["sap/base/config"],e=>{"use strict";const t={isDebugModeEnabled(){let t=window["sap-ui-debug"]===true||e.get({name:"sapUiDebug",type:e.Type.Boolean,external:true});try{t=t||/^(?:true|x|X)$/.test(window.localStorage.getItem("sap-ui-debug"))}catch(e){}return t},isControlInspectorEnabled(){return e.get({name:"sapUiInspect",type:e.Type.Boolean,external:true})},isStatisticsEnabled(){var t=e.get({name:"sapUiStatistics",type:e.Type.Boolean,defaultValue:e.get({name:"sapStatistics",type:e.Type.Boolean,external:true}),external:true});try{t=t||window.localStorage.getItem("sap-ui-statistics")=="X"}catch(e){}return t},getSupportSettings(){return e.get({name:"sapUiSupport",type:e.Type.StringArray,defaultValue:null,external:true})},getTestRecorderSettings(){return e.get({name:"sapUiTestRecorder",type:e.Type.StringArray,defaultValue:null,external:true})},collectOriginInfo(){return e.get({name:"sapUiOriginInfo",type:e.Type.Boolean,external:true})}};return t});
/*!
 * copyright
 */
sap.ui.predefine("sap/ui/core/Theming", ["sap/base/assert","sap/base/config","sap/base/Event","sap/base/Eventing","sap/base/Log","sap/base/i18n/Localization","sap/base/util/deepEqual","sap/ui/core/theming/ThemeHelper"],function(e,t,n,a,i,o,s,h){"use strict";const l=t.getWritableInstance();const c=new a;let r;let g;const m={getTheme:()=>{let e=l.get({name:"sapTheme",type:l.Type.String,defaultValue:l.get({name:"sapUiTheme",type:l.Type.String,external:true}),external:true});if(e===""){const t=h.getDefaultThemeInfo();e=`${t.DEFAULT_THEME}${t.DARK_MODE?"_dark":""}`}const t=e.indexOf("@");if(t>=0){const n=T(e.slice(t+1));e=t>0?e.slice(0,t):e;if(n!==m.getThemeRoot(e)){m.setThemeRoot(e,n)}}e=h.validateAndFallbackTheme(e,m.getThemeRoot(e));return e},setTheme:e=>{if(e){if(e.indexOf("@")!==-1){throw new TypeError("Providing a theme root as part of the theme parameter is not allowed.")}const t=!r;r??={};const n=m.getTheme();l.set("sapTheme",e);const a=m.getTheme();const i=n!==a;if(i){r.theme={new:a,old:n}}else{r=undefined}if(t){p(r)}if(!g&&i){f({theme:a})}}},getThemeRoot:(e,t)=>{const n=l.get({name:"sapUiThemeRoots",type:l.Type.MergedObject});let a;e??=m.getTheme();if(n[e]&&typeof n[e]==="string"){a=n[e]}else if(n[e]&&typeof n[e]==="object"){a=n[e][t]||n[e][""]}return a},setThemeRoot:(t,n,a,i)=>{e(typeof t==="string","sThemeName must be a string");e(typeof n==="string","sThemeBaseUrl must be a string");const o=!r;r??={};const h={name:"sapUiThemeRoots",type:l.Type.MergedObject};const c=l.get(Object.assign(h,{defaultValue:{}}));const g=l.get(Object.assign(h,{defaultValue:{}}));if(typeof a==="boolean"){i=a;a=undefined}g[t]??={};if(typeof g[t]==="string"){g[t]={"":g[t]};c[t]={"":c[t]}}if(a){for(let e=0;e<a.length;e++){const i=a[e];g[t][i]=n}}else{g[t][""]=n}if(!s(c,g)){l.set("sapUiThemeRoots",g);if(a){r.themeRoots={new:Object.assign({},g[t]),old:Object.assign({},c[t])}}else{r.themeRoots={new:n,old:c[t]?.[""]}}r.themeRoots.forceUpdate=i&&t===m.getTheme()}else{r=undefined}if(o){p()}},attachAppliedOnce:e=>{const t="applied";if(g){if(g.themeLoaded){e.call(null,new n(t,{theme:m.getTheme()}))}else{c.attachEventOnce(t,e)}}else{e.call(null,new n(t,{theme:m.getTheme()}))}},attachApplied:e=>{const t="applied";c.attachEvent(t,e);if(g){if(g.themeLoaded){e.call(null,new n(t,{theme:m.getTheme()}))}}else{e.call(null,new n(t,{theme:m.getTheme()}))}},detachApplied:e=>{c.detachEvent("applied",e)},attachChange:e=>{c.attachEvent("change",e)},detachChange:e=>{c.detachEvent("change",e)},attachThemeScopingChanged:e=>{c.attachEvent("themeScopingChanged",e)},detachThemeScopingChanged:e=>{c.detachEvent("themeScopingChanged",e)},fireThemeScopingChanged:e=>{c.fireEvent("themeScopingChanged",e)},notifyContentDensityChanged:()=>{f({theme:m.getTheme()})},registerThemeManager:e=>{g=e;g._attachThemeApplied(function(e){f(n.getParameters(e))});o.attachChange(function(e){var t=e.rtl;if(t!==undefined){g._updateThemeUrls(m.getTheme())}})}};function p(){if(r){c.fireEvent("change",r);r=undefined}}function f(e){c.fireEvent("applied",e)}function d(e,t){const n=l.get({name:"sapAllowedThemeOrigins",type:l.Type.String});return!!n?.split(",").some(n=>{try{n=t&&!n.startsWith("//")?"//"+n:n;return n==="*"||e===new URL(n.trim(),globalThis.location.href).origin}catch(e){i.error("[FUTURE FATAL] sapAllowedThemeOrigin provides invalid theme origin: "+n);return false}})}function T(e){const t=e.startsWith("//");let n,a;try{n=new URL(e,globalThis.location.href);n.search="";if(n.origin&&d(n.origin,t)){a=n.toString()}else{n=new URL(n.pathname,globalThis.location.href);a=n.toString()}if(t){a=a.replace(n.protocol,"")}a+=(a.endsWith("/")?"":"/")+"UI5/"}catch(e){}return a}return m});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/date/Buddhist", ["./UniversalDate","../CalendarType","./_Calendars"],function(t,e,r){"use strict";var n=t.extend("sap.ui.core.date.Buddhist",{constructor:function(){var t=arguments;if(t.length>1){t=u(t)}this.oDate=this.createDate(Date,t);this.sCalendarType=e.Buddhist}});n.UTC=function(){var t=u(arguments);return Date.UTC.apply(Date,t)};n.now=function(){return Date.now()};function a(r){var n=t.getEraStartDate(e.Buddhist,0).year,a=r.year-n+1;if(r.year<1941&&r.month<3){a-=1}if(r.year===null){a=undefined}return{year:a,month:r.month,day:r.day}}function i(r){var n=t.getEraStartDate(e.Buddhist,0).year,a=r.year+n-1;if(a<1941&&r.month<3){a+=1}if(r.year===null){a=undefined}return{year:a,month:r.month,day:r.day}}function u(t){var e,r;e={year:t[0],month:t[1],day:t[2]!==undefined?t[2]:1};r=i(e);t[0]=r.year;return t}n.prototype._getBuddhist=function(){var t={year:this.oDate.getFullYear(),month:this.oDate.getMonth(),day:this.oDate.getDate()};return a(t)};n.prototype._setBuddhist=function(t){var e=i(t);return this.oDate.setFullYear(e.year,e.month,e.day)};n.prototype._getUTCBuddhist=function(){var t={year:this.oDate.getUTCFullYear(),month:this.oDate.getUTCMonth(),day:this.oDate.getUTCDate()};return a(t)};n.prototype._setUTCBuddhist=function(t){var e=i(t);return this.oDate.setUTCFullYear(e.year,e.month,e.day)};n.prototype.getYear=function(){return this._getBuddhist().year};n.prototype.getFullYear=function(){return this._getBuddhist().year};n.prototype.getUTCFullYear=function(){return this._getUTCBuddhist().year};n.prototype.setYear=function(t){var e=this._getBuddhist();e.year=t;return this._setBuddhist(e)};n.prototype.setFullYear=function(t,e,r){var n=this._getBuddhist();n.year=t;if(e!==undefined){n.month=e}if(r!==undefined){n.day=r}return this._setBuddhist(n)};n.prototype.setUTCFullYear=function(t,e,r){var n=this._getUTCBuddhist();n.year=t;if(e!==undefined){n.month=e}if(r!==undefined){n.day=r}return this._setUTCBuddhist(n)};r.set(e.Buddhist,n);return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/date/CalendarUtils", ["sap/ui/core/date/CalendarWeekNumbering","sap/ui/core/Configuration","sap/ui/core/LocaleData"],function(e,t,a){"use strict";var i={getWeekConfigurationValues:function(n,r){var u,o;if(!n){return i.getWeekConfigurationValues(t.getCalendarWeekNumbering(),r)}o=e.getWeekConfigurationValues(n);if(o){return o}if(n===e.Default){r=r||t.getFormatSettings().getFormatLocale();u=a.getInstance(r);return{firstDayOfWeek:u.getFirstDayOfWeek(),minimalDaysInFirstWeek:u.getMinimalDaysInFirstWeek()}}return undefined}};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/date/CalendarWeekNumbering", ["sap/ui/base/DataType","sap/base/i18n/date/CalendarWeekNumbering"],function(e,a){"use strict";e.registerEnum("sap.ui.core.date.CalendarWeekNumbering",a);return a},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/date/Gregorian", ["./UniversalDate","../CalendarType","./_Calendars"],function(e,t,a){"use strict";var n=e.extend("sap.ui.core.date.Gregorian",{constructor:function(){this.oDate=this.createDate(Date,arguments);this.sCalendarType=t.Gregorian}});n.UTC=function(){return Date.UTC.apply(Date,arguments)};n.now=function(){return Date.now()};a.set(t.Gregorian,n);return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/date/Islamic", ["./UniversalDate","../CalendarType","sap/base/Log","sap/base/i18n/Formatting","./_Calendars"],function(t,e,a,r,o){"use strict";var n=t.extend("sap.ui.core.date.Islamic",{constructor:function(){var t=arguments;if(t.length>1){t=p(t)}this.oDate=this.createDate(Date,t);this.sCalendarType=e.Islamic}});n.UTC=function(){var t=p(arguments);return Date.UTC.apply(Date,t)};n.now=function(){return Date.now()};var i=1400,s=1721425.5,h=1948439.5,l=-425215872e5,f=864e5;var u=null;var c=["A","B"];function y(t){var e=t.year,a=t.month,r=t.day,o,n,i,l,f,u,c;u=0;if(a+1>2){u=v(e)?-1:-2}c=s-1+365*(e-1)+Math.floor((e-1)/4)+-Math.floor((e-1)/100)+Math.floor((e-1)/400)+Math.floor((367*(a+1)-362)/12+u+r);c=Math.floor(c)+.5;f=c-h;l=Math.floor(f/29.530588853);if(l<0){o=Math.floor(l/12)+1;n=l%12;if(n<0){n+=12}i=f-I(o,n)+1}else{l++;while(M(l)>f){l--}o=Math.floor(l/12)+1;n=l%12;i=f-M(12*(o-1)+n)+1}return{day:i,month:n,year:o}}function m(t){var e=t.year,a=t.month,r=t.day,o=e<1?I(e,a):M(12*(e-1)+a),n=r+o+h-1,i=Math.floor(n-.5)+.5,l=i-s,f=Math.floor(l/146097),u=C(l,146097),c=Math.floor(u/36524),y=C(u,36524),m=Math.floor(y/1461),p=C(y,1461),d=Math.floor(p/365),g=f*400+c*100+m*4+d,T,D,_,U,F,Y,w,b;if(!(c==4||d==4)){g++}_=s+365*(g-1)+Math.floor((g-1)/4)-Math.floor((g-1)/100)+Math.floor((g-1)/400);U=i-_;F=s-1+365*(g-1)+Math.floor((g-1)/4)-Math.floor((g-1)/100)+Math.floor((g-1)/400)+Math.floor(739/12+(v(g)?-1:-2)+1);w=0;if(i<F){w=0}else{w=v(g)?1:2}T=Math.floor(((U+w)*12+373)/367);Y=s-1+365*(g-1)+Math.floor((g-1)/4)-Math.floor((g-1)/100)+Math.floor((g-1)/400);b=0;if(T>2){b=v(g)?-1:-2}Y+=Math.floor((367*T-362)/12+b+1);D=i-Y+1;return{day:D,month:T-1,year:g}}function p(t){var e=Array.prototype.slice.call(t),a,r;a={year:t[0],month:t[1],day:t[2]!==undefined?t[2]:1};r=m(a);e[0]=r.year;e[1]=r.month;e[2]=r.day;return e}function d(){var t,e;u={};t=r.getABAPDateFormat();t=T(t)?t:"A";e=r.getCustomIslamicCalendarData();e=e||[];if(!e.length){a.warning("No calendar customizations.");return}e.forEach(function(e){if(e.dateFormat===t){var a=g(e.gregDate);var r=new Date(Date.UTC(a.year,a.month-1,a.day));var o=r.getTime();var n=(o-l)/f;a=g(e.islamicMonthStart);var i=(a.year-1)*12+a.month-1;u[i]=n}});a.info("Working with date format: ["+t+"] and customization: "+JSON.stringify(e))}function g(t){return{year:parseInt(t.substr(0,4)),month:parseInt(t.substr(4,2)),day:parseInt(t.substr(6,2))}}function M(t){if(!u){d()}var e=u[t];if(!e){var a=Math.floor(t/12)+1;var r=t%12;e=I(a,r)}return e}function I(t,e){return Math.ceil(29.5*e)+(t-1)*354+Math.floor((3+11*t)/30)}function C(t,e){return t-e*Math.floor(t/e)}function v(t){return!(t%400)||!(t%4)&&!!(t%100)}function T(t){return c.indexOf(t)!==-1}n.prototype._getIslamic=function(){return y({day:this.oDate.getDate(),month:this.oDate.getMonth(),year:this.oDate.getFullYear()})};n.prototype._setIslamic=function(t){var e=m(t);return this.oDate.setFullYear(e.year,e.month,e.day)};n.prototype._getUTCIslamic=function(){return y({day:this.oDate.getUTCDate(),month:this.oDate.getUTCMonth(),year:this.oDate.getUTCFullYear()})};n.prototype._setUTCIslamic=function(t){var e=m(t);return this.oDate.setUTCFullYear(e.year,e.month,e.day)};n.prototype.getDate=function(t){return this._getIslamic().day};n.prototype.getMonth=function(){return this._getIslamic().month};n.prototype.getYear=function(){return this._getIslamic().year-i};n.prototype.getFullYear=function(){return this._getIslamic().year};n.prototype.setDate=function(t){var e=this._getIslamic();e.day=t;return this._setIslamic(e)};n.prototype.setMonth=function(t,e){var a=this._getIslamic();a.month=t;if(e!==undefined){a.day=e}return this._setIslamic(a)};n.prototype.setYear=function(t){var e=this._getIslamic();e.year=t+i;return this._setIslamic(e)};n.prototype.setFullYear=function(t,e,a){var r=this._getIslamic();r.year=t;if(e!==undefined){r.month=e}if(a!==undefined){r.day=a}return this._setIslamic(r)};n.prototype.getUTCDate=function(t){return this._getUTCIslamic().day};n.prototype.getUTCMonth=function(){return this._getUTCIslamic().month};n.prototype.getUTCFullYear=function(){return this._getUTCIslamic().year};n.prototype.setUTCDate=function(t){var e=this._getUTCIslamic();e.day=t;return this._setUTCIslamic(e)};n.prototype.setUTCMonth=function(t,e){var a=this._getUTCIslamic();a.month=t;if(e!==undefined){a.day=e}return this._setUTCIslamic(a)};n.prototype.setUTCFullYear=function(t,e,a){var r=this._getUTCIslamic();r.year=t;if(e!==undefined){r.month=e}if(a!==undefined){r.day=a}return this._setUTCIslamic(r)};o.set(e.Islamic,n);return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/date/Japanese", ["./UniversalDate","../CalendarType","./_Calendars"],function(e,t,a){"use strict";var n=e.extend("sap.ui.core.date.Japanese",{constructor:function(){var e=arguments;if(e.length>1){e=i(e)}this.oDate=this.createDate(Date,e);this.sCalendarType=t.Japanese}});n.UTC=function(){var e=i(arguments);return Date.UTC.apply(Date,e)};n.now=function(){return Date.now()};function r(a){var n=e.getEraByDate(t.Japanese,a.year,a.month,a.day),r=e.getEraStartDate(t.Japanese,n).year;return{era:n,year:a.year-r+1,month:a.month,day:a.day}}function o(a){var n=e.getEraStartDate(t.Japanese,a.era).year;return{year:n+a.year-1,month:a.month,day:a.day}}function i(a){var n,r,i,s=a[0];if(typeof s=="number"){if(s>=100){return a}else{i=e.getCurrentEra(t.Japanese);s=[i,s]}}else if(!Array.isArray(s)){s=[]}n={era:s[0],year:s[1],month:a[1],day:a[2]!==undefined?a[2]:1};r=o(n);a[0]=r.year;return a}n.prototype._getJapanese=function(){var e={year:this.oDate.getFullYear(),month:this.oDate.getMonth(),day:this.oDate.getDate()};return r(e)};n.prototype._setJapanese=function(e){var t=o(e);return this.oDate.setFullYear(t.year,t.month,t.day)};n.prototype._getUTCJapanese=function(){var e={year:this.oDate.getUTCFullYear(),month:this.oDate.getUTCMonth(),day:this.oDate.getUTCDate()};return r(e)};n.prototype._setUTCJapanese=function(e){var t=o(e);return this.oDate.setUTCFullYear(t.year,t.month,t.day)};n.prototype.getYear=function(){return this._getJapanese().year};n.prototype.getFullYear=function(){return this._getJapanese().year};n.prototype.getEra=function(){return this._getJapanese().era};n.prototype.getUTCFullYear=function(){return this._getUTCJapanese().year};n.prototype.getUTCEra=function(){return this._getUTCJapanese().era};n.prototype.setYear=function(e){var t=this._getJapanese();t.year=e;return this._setJapanese(t)};n.prototype.setFullYear=function(e,t,a){var n=this._getJapanese();n.year=e;if(t!==undefined){n.month=t}if(a!==undefined){n.day=a}return this._setJapanese(n)};n.prototype.setEra=function(a,n,o,i){var s=e.getEraStartDate(t.Japanese,a),u=r(s);if(n!==undefined){u.year=n}if(o!==undefined){u.month=o}if(i!==undefined){u.day=i}return this._setJapanese(u)};n.prototype.setUTCFullYear=function(e,t,a){var n=this._getUTCJapanese();n.year=e;if(t!==undefined){n.month=t}if(a!==undefined){n.day=a}return this._setUTCJapanese(n)};n.prototype.setUTCEra=function(a,n,o,i){var s=e.getEraStartDate(t.Japanese,a),u=r(s);if(n!==undefined){u.year=n}if(o!==undefined){u.month=o}if(i!==undefined){u.day=i}return this._setUTCJapanese(u)};n.prototype.getWeek=function(t,a){return e.getWeekByDate(this.sCalendarType,this.oDate.getFullYear(),this.getMonth(),this.getDate(),t,a)};n.prototype.getUTCWeek=function(t,a){return e.getWeekByDate(this.sCalendarType,this.oDate.getUTCFullYear(),this.getUTCMonth(),this.getUTCDate(),t,a)};a.set(t.Japanese,n);return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/date/Persian", ["./UniversalDate","../CalendarType","./_Calendars"],function(t,e,r){"use strict";var n=t.extend("sap.ui.core.date.Persian",{constructor:function(){var t=arguments;if(t.length>1){t=s(t)}this.oDate=this.createDate(Date,t);this.sCalendarType=e.Persian}});n.UTC=function(){var t=s(arguments);return Date.UTC.apply(Date,t)};n.now=function(){return Date.now()};var a=1300;function i(t){var e=f(t.year,t.month+1,t.day);return h(e)}function o(t){var e=y(t.year,t.month+1,t.day);return p(e)}function s(t){var e=Array.prototype.slice.call(t),r,n;if(typeof t[0]!=="number"||typeof t[1]!=="number"||t[2]!==undefined&&typeof t[2]!="number"){e[0]=NaN;e[1]=NaN;e[2]=NaN;return e}r={year:t[0],month:t[1],day:t[2]!==undefined?t[2]:1};n=o(r);e[0]=n.year;e[1]=n.month;e[2]=n.day;return e}function u(t){var e=[-61,9,38,199,426,686,756,818,1111,1181,1210,1635,2060,2097,2192,2262,2324,2394,2456,3178],r=e.length,n=t+621,a=-14,i=e[0],o,s,u,y,h,f,p;for(p=1;p<r;p+=1){o=e[p];s=o-i;if(t<o){break}a=a+c(s,33)*8+c(d(s,33),4);i=o}f=t-i;a=a+c(f,33)*8+c(d(f,33)+3,4);if(d(s,33)===4&&s-f===4){a+=1}y=c(n,4)-c((c(n,100)+1)*3,4)-150;h=20+a-y;if(s-f<6){f=f-s+c(s+4,33)*33}u=d(d(f+1,33)-1,4);if(u===-1){u=4}return{leap:u,gy:n,march:h}}function y(t,e,r){while(e<1){e+=12;t--}while(e>12){e-=12;t++}var n=u(t);return f(n.gy,3,n.march)+(e-1)*31-c(e,7)*(e-7)+r-1}function h(t){var e=p(t).year,r=e-621,n=u(r),a=f(e,3,n.march),i,o,s;s=t-a;if(s>=0){if(s<=185){o=1+c(s,31);i=d(s,31)+1;return{year:r,month:o-1,day:i}}else{s-=186}}else{r-=1;s+=179;if(n.leap===1){s+=1}}o=7+c(s,30);i=d(s,30)+1;return{year:r,month:o-1,day:i}}function f(t,e,r){var n=c((t+c(e-8,6)+100100)*1461,4)+c(153*d(e+9,12)+2,5)+r-34840408;n=n-c(c(t+100100+c(e-8,6),100)*3,4)+752;return n}function p(t){var e,r,n,a,i;e=4*t+139361631;e=e+c(c(4*t+183187720,146097)*3,4)*4-3908;r=c(d(e,1461),4)*5+308;n=c(d(r,153),5)+1;a=d(c(r,153),12)+1;i=c(e,1461)-100100+c(8-a,6);return{year:i,month:a-1,day:n}}function c(t,e){return~~(t/e)}function d(t,e){return t-~~(t/e)*e}n.prototype._getPersian=function(){return i({day:this.oDate.getDate(),month:this.oDate.getMonth(),year:this.oDate.getFullYear()})};n.prototype._setPersian=function(t){var e=o(t);return this.oDate.setFullYear(e.year,e.month,e.day)};n.prototype._getUTCPersian=function(){return i({day:this.oDate.getUTCDate(),month:this.oDate.getUTCMonth(),year:this.oDate.getUTCFullYear()})};n.prototype._setUTCPersian=function(t){var e=o(t);return this.oDate.setUTCFullYear(e.year,e.month,e.day)};n.prototype.getDate=function(t){return this._getPersian().day};n.prototype.getMonth=function(){return this._getPersian().month};n.prototype.getYear=function(){return this._getPersian().year-a};n.prototype.getFullYear=function(){return this._getPersian().year};n.prototype.setDate=function(t){var e=this._getPersian();e.day=t;return this._setPersian(e)};n.prototype.setMonth=function(t,e){var r=this._getPersian();r.month=t;if(e!==undefined){r.day=e}return this._setPersian(r)};n.prototype.setYear=function(t){var e=this._getPersian();e.year=t+a;return this._setPersian(e)};n.prototype.setFullYear=function(t,e,r){var n=this._getPersian();n.year=t;if(e!==undefined){n.month=e}if(r!==undefined){n.day=r}return this._setPersian(n)};n.prototype.getUTCDate=function(t){return this._getUTCPersian().day};n.prototype.getUTCMonth=function(){return this._getUTCPersian().month};n.prototype.getUTCFullYear=function(){return this._getUTCPersian().year};n.prototype.setUTCDate=function(t){var e=this._getUTCPersian();e.day=t;return this._setUTCPersian(e)};n.prototype.setUTCMonth=function(t,e){var r=this._getUTCPersian();r.month=t;if(e!==undefined){r.day=e}return this._setUTCPersian(r)};n.prototype.setUTCFullYear=function(t,e,r){var n=this._getUTCPersian();n.year=t;if(e!==undefined){n.month=e}if(r!==undefined){n.day=r}return this._setUTCPersian(n)};r.set(e.Persian,n);return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/date/UI5Date", ["sap/ui/core/Configuration","sap/ui/core/format/TimezoneUtil"],function(t,e){"use strict";var n=["year","month","day","hour","minute","second","fractionalSecond"],o=/Z|GMT|:.*[\+|\-]|^([\+|\-]\d{2})?\d{4}(-\d{2}){0,2}$/,r=["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],i=["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],a={Sun:0,Mon:1,Tue:2,Wed:3,Thu:4,Fri:5,Sat:6};function s(t,e){return(t<0?"-":"")+Math.abs(t).toString().padStart(e,"0")}function u(t,e){var r=u._createDateInstance(t);Object.defineProperties(this,{sTimezoneID:{value:e},oDate:{value:r,writable:true},oDateParts:{value:undefined,writable:true}});if(isNaN(r)){return}if(t.length>1||t.length===1&&typeof t[0]==="string"&&!o.test(t[0])){this._setParts(n,[r.getFullYear(),r.getMonth(),r.getDate(),r.getHours(),r.getMinutes(),r.getSeconds(),r.getMilliseconds()])}}u.prototype=Object.create(Date.prototype,{constructor:{value:Date}});u.prototype[Symbol.toStringTag]="Date";u.prototype._getPart=function(t){var n;if(isNaN(this.oDate)){return NaN}this.oDateParts=this.oDateParts||e._getParts(this.oDate,this.sTimezoneID);if(t==="weekday"){return a[this.oDateParts.weekday]}n=parseInt(this.oDateParts[t]);if(t==="month"){n-=1}else if(t==="year"){if(this.oDateParts.era==="B"){n=1-n}}return n};u.prototype._setParts=function(t,n){var o,r,i,a,s,u,c={},h=Math.min(t.length,n.length);if(h===0){return this.setTime(NaN)}for(o=0;o<h;o+=1){u=parseInt(+n[o]);s=t[o];if(isNaN(u)){return this.setTime(NaN)}if(s==="month"){u+=1}else if(s==="year"){if(u<=0){u=1-u;c.era="B"}else{c.era="A"}}c[s]=u.toString()}if(this.oDateParts){r=this.oDateParts}else if(isNaN(this.oDate)){r={day:"1",fractionalSecond:"0",hour:"0",minute:"0",month:"1",second:"0"}}else{r=e._getParts(this.oDate,this.sTimezoneID)}c=Object.assign({},r,c);i=e._getDateFromParts(c);if(isNaN(i)){return this.setTime(NaN)}a=i.getTime()+e.calculateOffset(i,this.sTimezoneID)*1e3;return this.setTime(a)};u.prototype.clone=function(){return u.getInstance(this)};u.prototype.getDate=function(){return this._getPart("day")};u.prototype.getDay=function(){return this._getPart("weekday")};u.prototype.getFullYear=function(){return this._getPart("year")};u.prototype.getHours=function(){return this._getPart("hour")};u.prototype.getMilliseconds=function(){return this._getPart("fractionalSecond")};u.prototype.getMinutes=function(){return this._getPart("minute")};u.prototype.getMonth=function(){return this._getPart("month")};u.prototype.getSeconds=function(){return this._getPart("second")};u.prototype.getTimezoneOffset=function(){return e.calculateOffset(this.oDate,this.sTimezoneID)/60};u.prototype.getYear=function(){return this._getPart("year")-1900};u.prototype.setDate=function(t){return this._setParts(["day"],arguments)};u.prototype.setFullYear=function(t,e,n){return this._setParts(["year","month","day"],arguments)};u.prototype.setHours=function(t,e,n,o){return this._setParts(["hour","minute","second","fractionalSecond"],arguments)};u.prototype.setMilliseconds=function(t){return this._setParts(["fractionalSecond"],arguments)};u.prototype.setMinutes=function(t,e,n){return this._setParts(["minute","second","fractionalSecond"],arguments)};u.prototype.setMonth=function(t,e){return this._setParts(["month","day"],arguments)};u.prototype.setSeconds=function(t,e){return this._setParts(["second","fractionalSecond"],arguments)};u.prototype.setTime=function(t){this.oDateParts=undefined;return this.oDate.setTime(t)};u.prototype.setYear=function(t){var e=parseInt(t);e=e<0||e>99?e:e+1900;return this._setParts(["year"],[e])};u.prototype.toDateString=function(){if(isNaN(this.oDate)){return this.oDate.toDateString()}return r[this.getDay()]+" "+i[this.getMonth()]+" "+s(this.getDate(),2)+" "+s(this.getFullYear(),4)};u.prototype.toString=function(){if(isNaN(this.oDate)){return this.oDate.toString()}return this.toDateString()+" "+this.toTimeString()};u.prototype.toTimeString=function(){var t,e,n,o;if(isNaN(this.oDate)){return this.oDate.toTimeString()}o=this.getTimezoneOffset();n=o>0?"-":"+";t=Math.floor(Math.abs(o)/60);e=Math.abs(o)%60;return s(this.getHours(),2)+":"+s(this.getMinutes(),2)+":"+s(this.getSeconds(),2)+" GMT"+n+s(t,2)+s(e,2)};["getTime","getUTCDate","getUTCDay","getUTCFullYear","getUTCHours","getUTCMilliseconds","getUTCMinutes","getUTCMonth","getUTCSeconds","toGMTString","toISOString","toJSON","toUTCString","valueOf"].forEach(function(t){u.prototype[t]=function(){return this.oDate[t].apply(this.oDate,arguments)}});["toLocaleDateString","toLocaleString","toLocaleTimeString"].forEach(function(e){u.prototype[e]=function(n,o){return this.oDate[e](n||t.getLanguageTag(),Object.assign({timeZone:this.sTimezoneID},o))}});["setUTCDate","setUTCFullYear","setUTCHours","setUTCMilliseconds","setUTCMinutes","setUTCMonth","setUTCSeconds"].forEach(function(t){u.prototype[t]=function(){this.oDateParts=undefined;return this.oDate[t].apply(this.oDate,arguments)}});u._createDateInstance=function(t){if(t[0]instanceof Date){t[0]=t[0].valueOf()}return new(Function.prototype.bind.apply(Date,[].concat.apply([null],t)))};u.getInstance=function(){var n=t.getTimezone();if(n!==e.getLocalTimezone()){return new u(arguments,n)}return u._createDateInstance(arguments)};u.checkDate=function(n){if(isNaN(n.getTime())){throw new Error("The given Date is not valid")}if(!(n instanceof u)&&t.getTimezone()!==e.getLocalTimezone()){throw new Error("Configured time zone requires the parameter 'oDate' to be an instance of"+" sap.ui.core.date.UI5Date")}};return u});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/date/UniversalDate", ["sap/ui/base/Object","sap/ui/core/Configuration","sap/ui/core/LocaleData","./_Calendars","./CalendarUtils","./CalendarWeekNumbering","./UI5Date"],function(e,t,r,a,n,o,i){"use strict";var s=e.extend("sap.ui.core.date.UniversalDate",{constructor:function(){var e=s.getClass();return this.createDate(e,arguments)}});s.UTC=function(){var e=s.getClass();return e.UTC.apply(e,arguments)};s.now=function(){return Date.now()};s.prototype.createDate=function(e,t){if(e===Date){return i.getInstance.apply(null,t)}switch(t.length){case 0:return new e;case 1:return new e(t[0]instanceof Date?t[0].getTime():t[0]);case 2:return new e(t[0],t[1]);case 3:return new e(t[0],t[1],t[2]);case 4:return new e(t[0],t[1],t[2],t[3]);case 5:return new e(t[0],t[1],t[2],t[3],t[4]);case 6:return new e(t[0],t[1],t[2],t[3],t[4],t[5]);case 7:return new e(t[0],t[1],t[2],t[3],t[4],t[5],t[6])}};s.getInstance=function(e,r){var a,n;if(e instanceof s){e=e.getJSDate()}if(e&&isNaN(e.getTime())){throw new Error("The given date object is invalid")}if(!r){r=t.getCalendarType()}a=s.getClass(r);n=Object.create(a.prototype);n.oDate=e?i.getInstance(e):i.getInstance();n.sCalendarType=r;return n};s.getClass=function(e){if(!e){e=t.getCalendarType()}return a.get(e)};["getDate","getMonth","getFullYear","getYear","getDay","getHours","getMinutes","getSeconds","getMilliseconds","getUTCDate","getUTCMonth","getUTCFullYear","getUTCDay","getUTCHours","getUTCMinutes","getUTCSeconds","getUTCMilliseconds","getTime","valueOf","getTimezoneOffset","toString","toDateString","setDate","setFullYear","setYear","setMonth","setHours","setMinutes","setSeconds","setMilliseconds","setUTCDate","setUTCFullYear","setUTCMonth","setUTCHours","setUTCMinutes","setUTCSeconds","setUTCMilliseconds"].forEach(function(e){s.prototype[e]=function(){return this.oDate[e].apply(this.oDate,arguments)}});s.prototype.getJSDate=function(){return this.oDate};s.prototype.getCalendarType=function(){return this.sCalendarType};s.prototype.getEra=function(){return s.getEraByDate(this.sCalendarType,this.oDate.getFullYear(),this.oDate.getMonth(),this.oDate.getDate())};s.prototype.setEra=function(e){};s.prototype.getUTCEra=function(){return s.getEraByDate(this.sCalendarType,this.oDate.getUTCFullYear(),this.oDate.getUTCMonth(),this.oDate.getUTCDate())};s.prototype.setUTCEra=function(e){};s.prototype.getWeek=function(e,t){return s.getWeekByDate(this.sCalendarType,this.getFullYear(),this.getMonth(),this.getDate(),e,t)};s.prototype.setWeek=function(e,t,r){var a=s.getFirstDateOfWeek(this.sCalendarType,e.year||this.getFullYear(),e.week,t,r);this.setFullYear(a.year,a.month,a.day)};s.prototype.getUTCWeek=function(e,t){return s.getWeekByDate(this.sCalendarType,this.getUTCFullYear(),this.getUTCMonth(),this.getUTCDate(),e,t)};s.prototype.setUTCWeek=function(e,t,r){var a=s.getFirstDateOfWeek(this.sCalendarType,e.year||this.getFullYear(),e.week,t,r);this.setUTCFullYear(a.year,a.month,a.day)};s.prototype.getQuarter=function(){return Math.floor(this.getMonth()/3)};s.prototype.getUTCQuarter=function(){return Math.floor(this.getUTCMonth()/3)};s.prototype.getDayPeriod=function(){if(this.getHours()<12){return 0}else{return 1}};s.prototype.getUTCDayPeriod=function(){if(this.getUTCHours()<12){return 0}else{return 1}};s.prototype.getTimezoneShort=function(){if(this.oDate.getTimezoneShort){return this.oDate.getTimezoneShort()}};s.prototype.getTimezoneLong=function(){if(this.oDate.getTimezoneLong){return this.oDate.getTimezoneLong()}};var u=7*24*60*60*1e3;s.getWeekByDate=function(e,r,a,n,o,i){i=i||t.getCalendarWeekNumbering();f(i);o=o||t.getFormatSettings().getFormatLocale();var s=this.getClass(e);var u=c(s,r,o,i);var l=new s(s.UTC(r,a,n));var y,h,C,T,D;var d=g(i,o);if(d){y=p(u,l)}else{h=r-1;C=r+1;T=c(s,h,o,i);D=c(s,C,o,i);if(l>=D){r=C;y=0}else if(l<u){r=h;y=p(T,l)}else{y=p(u,l)}}return{year:r,week:y}};s.getFirstDateOfWeek=function(e,r,a,n,o){o=o||t.getCalendarWeekNumbering();f(o);n=n||t.getFormatSettings().getFormatLocale();var i=this.getClass(e);var s=c(i,r,n,o);var l=new i(s.valueOf()+a*u);var p=g(o,n);if(p&&a===0&&s.getUTCFullYear()<r){return{year:r,month:0,day:1}}return{year:l.getUTCFullYear(),month:l.getUTCMonth(),day:l.getUTCDate()}};function g(e,t){var a=r.getInstance(t);return(e===o.Default||e===o.WesternTraditional)&&a.firstDayStartsFirstWeek()}function f(e){if(typeof e==="object"){if(typeof e.firstDayOfWeek!=="number"||typeof e.minimalDaysInFirstWeek!=="number"){throw new TypeError("Week config requires firstDayOfWeek and minimalDaysInFirstWeek to be set")}}else if(!Object.values(o).includes(e)){throw new TypeError("Illegal format option calendarWeekNumbering: '"+e+"'")}}function l(e,t){if(typeof e==="object"&&typeof e.firstDayOfWeek==="number"&&typeof e.minimalDaysInFirstWeek==="number"){return e}return n.getWeekConfigurationValues(e,t)}function c(e,r,a,n){a=a||t.getFormatSettings().getFormatLocale();var o=l(n,a);var i=o.minimalDaysInFirstWeek;var s=o.firstDayOfWeek;var u=new e(e.UTC(r,0,1));var g=7;if(isNaN(u.getTime())){throw new Error("Could not determine the first day of the week, because the date "+"object is invalid")}while(u.getUTCDay()!==s){u.setUTCDate(u.getUTCDate()-1);g--}if(g<i){u.setUTCDate(u.getUTCDate()+7)}return u}function p(e,t){return Math.floor((t.valueOf()-e.valueOf())/u)}var y={};s.getEraByDate=function(e,t,r,a){var n=h(e),o=new Date(0).setUTCFullYear(t,r,a),i;for(var s=n.length-1;s>=0;s--){i=n[s];if(!i){continue}if(i._start&&o>=i._startInfo.timestamp){return s}if(i._end&&o<i._endInfo.timestamp){return s}}};s.getCurrentEra=function(e){var t=i.getInstance();return this.getEraByDate(e,t.getFullYear(),t.getMonth(),t.getDate())};s.getEraStartDate=function(e,t){var r=h(e),a=r[t]||r[0];if(a._start){return a._startInfo}};function h(e){var a=t.getFormatSettings().getFormatLocale(),n=r.getInstance(a),o=y[e];if(!o){var o=n.getEraDates(e);if(!o[0]){o[0]={_start:"1-1-1"}}for(var i=0;i<o.length;i++){var s=o[i];if(!s){continue}if(s._start){s._startInfo=C(s._start)}if(s._end){s._endInfo=C(s._end)}}y[e]=o}return o}function C(e){var t=e.split("-"),r,a,n;if(t[0]==""){r=-parseInt(t[1]);a=parseInt(t[2])-1;n=parseInt(t[3])}else{r=parseInt(t[0]);a=parseInt(t[1])-1;n=parseInt(t[2])}return{timestamp:new Date(0).setUTCFullYear(r,a,n),year:r,month:a,day:n}}return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/date/UniversalDateUtils", ["sap/ui/core/date/UniversalDate","sap/ui/core/Locale","sap/ui/core/LocaleData","sap/base/assert","sap/ui/core/Configuration"],function(e,t,r,a,n){"use strict";function u(t){a(t instanceof e,"method accepts only instances of UniversalDate");return t.createDate(t.constructor,[t.getJSDate()])}var s={};s.getRange=function(e,t,r,a){if(a===undefined){a=true}if(isNaN(e)){throw new TypeError("duration is NaN, but is "+e)}e=Math.trunc(e);var n=s.resetStartTime(r==undefined?null:r),i;if(a){switch(t){case"MINUTE":case"HOUR":n=s.createNewUniversalDate();break;case"DAY":break;case"WEEK":n=s.getWeekStartDate(n);break;case"MONTH":n=s.getMonthStartDate(n);break;case"QUARTER":n=s.getQuarterStartDate(n);break;case"YEAR":n=s.getYearStartDate(n);break;default:throw new TypeError("invalid unit "+t)}}switch(t){case"MINUTE":i=u(n);i.setMinutes(n.getMinutes()+e);break;case"HOUR":i=u(n);i.setHours(n.getHours()+e);break;case"DAY":if(e>0){n.setDate(n.getDate()+1)}i=u(n);e=e==0?1:e;i.setDate(n.getDate()+e);break;case"WEEK":if(e>0){n.setDate(n.getDate()+7)}i=u(n);e=e==0?1:e;i.setDate(n.getDate()+e*7);break;case"MONTH":if(e>0){n.setMonth(n.getMonth()+1)}i=u(n);e=e==0?1:e;i.setMonth(n.getMonth()+e);break;case"QUARTER":if(e>0){n.setMonth(n.getMonth()+3)}i=u(n);e=e==0?1:e;i.setMonth(n.getMonth()+e*3);break;case"YEAR":if(e>0){n.setFullYear(n.getFullYear()+1)}i=u(n);e=e==0?1:e;i.setFullYear(n.getFullYear()+e);break;default:throw new TypeError("invalid unit "+t)}if(i.getTime()<n.getTime()){i=[n,n=i][0]}if(t==="HOUR"||t==="MINUTE"){return[n,i]}i.setDate(i.getDate()-1);return[s.resetStartTime(n),s.resetEndTime(i)]};s.getWeekStartDate=function(e,a){var i=a?new t(a):n.getFormatSettings().getFormatLocale(),g=r.getInstance(i),o=g.getFirstDayOfWeek();e=e?u(e):u(s.createNewUniversalDate());e.setDate(e.getDate()-e.getDay()+o);return s.resetStartTime(e)};s.getWeekLastDate=function(e,t){var r=s.getWeekStartDate(e,t);r.setDate(r.getDate()+6);return s.resetStartTime(r)};s.getMonthStartDate=function(e){e=e?u(e):u(s.createNewUniversalDate());e.setDate(1);return s.resetStartTime(e)};s.getMonthEndDate=function(e){var t=s.getMonthStartDate(e);t.setMonth(t.getMonth()+1);t.setDate(0);return s.resetStartTime(t)};s.getQuarterStartDate=function(e){e=e?u(e):u(s.createNewUniversalDate());e.setMonth(3*Math.floor(e.getMonth()/3));e.setDate(1);return s.resetStartTime(e)};s.getQuarterEndDate=function(e){var t=s.getQuarterStartDate(e);t.setMonth(t.getMonth()+3);t.setDate(0);return s.resetStartTime(t)};s.getYearStartDate=function(e){e=e?u(e):u(s.createNewUniversalDate());e.setMonth(0);e.setDate(1);return s.resetStartTime(e)};s.getYearEndDate=function(e){e=e?u(e):u(s.createNewUniversalDate());e.setFullYear(e.getFullYear()+1);e.setMonth(0);e.setDate(0);return s.resetStartTime(e)};s.resetStartTime=function(e){e=e?u(e):u(s.createNewUniversalDate());e.setHours(0,0,0,0);return e};s.resetEndTime=function(e){e=e?u(e):u(s.createNewUniversalDate());e.setHours(23,59,59,999);return e};s.createNewUniversalDate=function(){return new e};s._getDateFromWeekStartByDayOffset=function(t,r){var a=n.getCalendarType(),u=n.getFormatSettings().getFormatLocale(),i=s.createNewUniversalDate(),g=i.getWeek(u,t),o=e.getFirstDateOfWeek(a,g.year,g.week,u,t);if(r===undefined){r=0}return new e(o.year,o.month,o.day+r,0,0,0)};s.ranges={lastDays:function(e){return s.getRange(-e,"DAY")},lastMinutes:function(e){return s.getRange(-e,"MINUTE")},lastHours:function(e){return s.getRange(-e,"HOUR")},yesterday:function(){return s.getRange(-1,"DAY")},today:function(){return s.getRange(0,"DAY")},tomorrow:function(){return s.getRange(1,"DAY")},nextMinutes:function(e){return s.getRange(e,"MINUTE")},nextHours:function(e){return s.getRange(e,"HOUR")},nextDays:function(e){return s.getRange(e,"DAY")},lastWeeks:function(e,t){var r;if(t){r=s._getDateFromWeekStartByDayOffset(t);return s.getRange(-e,"WEEK",r,false)}return s.getRange(-e,"WEEK")},lastWeek:function(e){var t;if(e){t=s._getDateFromWeekStartByDayOffset(e);return s.getRange(-1,"WEEK",t,false)}return s.getRange(-1,"WEEK")},currentWeek:function(e){var t;if(e){t=s._getDateFromWeekStartByDayOffset(e);return s.getRange(0,"WEEK",t,false)}return s.getRange(0,"WEEK")},firstDayOfWeek:function(e){var t;if(e){t=s._getDateFromWeekStartByDayOffset(e);return[s.resetStartTime(t),s.resetEndTime(t)]}var r=s.getWeekStartDate();return[r,s.resetEndTime(r)]},lastDayOfWeek:function(e){var t,r;if(e){r=6;t=s._getDateFromWeekStartByDayOffset(e,r);return[t,s.resetEndTime(t)]}var a=s.getWeekLastDate();return[a,s.resetEndTime(a)]},nextWeek:function(e){var t;if(e){t=s._getDateFromWeekStartByDayOffset(e);return s.getRange(1,"WEEK",t,false)}return s.getRange(1,"WEEK")},nextWeeks:function(e,t){var r;if(t){r=s._getDateFromWeekStartByDayOffset(t);return s.getRange(e,"WEEK",r,false)}return s.getRange(e,"WEEK")},lastMonths:function(e){return s.getRange(-e,"MONTH")},lastMonth:function(){return s.getRange(-1,"MONTH")},currentMonth:function(){return s.getRange(0,"MONTH")},firstDayOfMonth:function(){var e=s.getMonthStartDate();return[e,s.resetEndTime(e)]},lastDayOfMonth:function(){var e=s.getMonthEndDate();return[e,s.resetEndTime(e)]},nextMonth:function(){return s.getRange(1,"MONTH")},nextMonths:function(e){return s.getRange(e,"MONTH")},lastQuarters:function(e){return s.getRange(-e,"QUARTER")},lastQuarter:function(){return s.getRange(-1,"QUARTER")},firstDayOfQuarter:function(){var e=s.getQuarterStartDate();return[e,s.resetEndTime(e)]},lastDayOfQuarter:function(){var e=s.getQuarterEndDate();return[e,s.resetEndTime(e)]},currentQuarter:function(){return s.getRange(0,"QUARTER")},nextQuarter:function(){return s.getRange(1,"QUARTER")},nextQuarters:function(e){return s.getRange(e,"QUARTER")},quarter:function(e){if(e<=2){return s.getRange(e-1,"QUARTER",s.getYearStartDate())}else{var t=s.getRange(e-2,"QUARTER",s.getYearStartDate());var r=t[1];r.setMilliseconds(1e3);return s.getRange(0,"QUARTER",r)}},lastYears:function(e){return s.getRange(-e,"YEAR")},lastYear:function(){return s.getRange(-1,"YEAR")},firstDayOfYear:function(){var e=s.getYearStartDate();return[e,s.resetEndTime(e)]},lastDayOfYear:function(){var e=s.getYearEndDate();return[e,s.resetEndTime(e)]},currentYear:function(){return s.getRange(0,"YEAR")},nextYear:function(){return s.getRange(1,"YEAR")},nextYears:function(e){return s.getRange(e,"YEAR")},yearToDate:function(){var e=s.createNewUniversalDate();return[s.getYearStartDate(e),s.resetEndTime(e)]},dateToYear:function(){var e=s.createNewUniversalDate();return[s.resetStartTime(e),s.resetEndTime(s.getYearEndDate(e))]}};return s});
/*
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/date/_Calendars", [],function(){"use strict";var e=new Map;var r={get:function(r){if(!e.has(r)){sap.ui.requireSync("sap/ui/core/date/"+r)}if(e.has(r)){return e.get(r)}throw new TypeError("Load required calendar 'sap/ui/core/date/"+r+"' in advance")},set:function(r,a){e.set(r,a)}};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/format/TimezoneUtil", ["sap/base/i18n/date/TimezoneUtils"],function(e){"use strict";return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/getCompatibilityVersion", ["sap/base/config","sap/base/util/Version","sap/base/strings/camelize"],(e,t,s)=>{"use strict";const a=t("1.14");const n="1.120.31";var i={"xx-test":"1.15",flexBoxPolyfill:"1.14",sapMeTabContainer:"1.14",sapMeProgessIndicator:"1.14",sapMGrowingList:"1.14",sapMListAsTable:"1.14",sapMDialogWithPadding:"1.14",sapCoreBindingSyntax:"1.24"};const o=o=>{const r="sapUiCompatVersion";const p=e.get({name:r,type:e.Type.String});function g(o){var g=!o?p||a.toString():e.get({name:s(r+"-"+o.toLowerCase()),type:e.Type.String})||p||i[o]||a.toString();g=t(g.toLowerCase()==="edge"?n:g);return t(g.getMajor(),g.getMinor())}return i.hasOwnProperty(o)?g(o):g()};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/theming/ThemeHelper", ["sap/base/Log"],function(e){"use strict";var r={};const t="sap_horizon";const a=window.matchMedia("(prefers-color-scheme: dark)").matches;const n=/^([a-zA-Z0-9_]*)(_(hcb|hcw|dark))$/g;const s=["sap_horizon","sap_horizon_dark","sap_horizon_hcb","sap_horizon_hcw","sap_fiori_3","sap_fiori_3_dark","sap_fiori_3_hcb","sap_fiori_3_hcw","sap_belize","sap_belize_plus","sap_belize_hcb","sap_belize_hcw","sap_bluecrystal","sap_hcb"];const i={};var l={};l.reset=function(){r={}};l.getMetadata=function(t){if(!t){return null}var a=t.replace("sap-ui-theme-","").replace(/\./g,"-");if(r[a]){return r[a]}var n=document.createElement("span");n.classList.add("sapThemeMetaData-UI5-"+a);document.documentElement.appendChild(n);var s=window.getComputedStyle(n).getPropertyValue("background-image");document.documentElement.removeChild(n);var i=/\(["']?data:text\/plain;utf-8,(.*?)['"]?\)/i.exec(s);if(!i||i.length<2){return null}var l=i[1];if(l.charAt(0)!=="{"&&l.charAt(l.length-1)!=="}"){try{l=decodeURI(l)}catch(e){}}l=l.replace(/\\"/g,'"');var c=l.replace(/%20/g," ");var o;try{o=JSON.parse(c);r[a]=o}catch(r){e.error("[FUTURE FATAL] Could not parse theme metadata for library "+a+".")}return o};l.checkAndRemoveStyle=function(r){var t=r.prefix||"",a=r.id;var n=function(r,t){var a=document.getElementById(r);try{var n=false,s=false,i=false,c=false;n=!a;s=!!(a&&(a.getAttribute("data-sap-ui-ready")==="true"||a.getAttribute("data-sap-ui-ready")==="false"));i=!!(a&&a.sheet&&a.sheet.href===a.href&&l.hasSheetCssRules(a.sheet));c=!!(a&&a.innerHTML&&a.innerHTML.length>0);var o=n||i||c||s;if(t){e.debug("ThemeHelper: "+r+": "+o+" (noLinkElement: "+n+", sheet: "+i+", innerHtml: "+c+", linkElementFinishedLoading: "+s+")")}return o}catch(a){if(t){e.error("[FUTURE FATAL] ThemeHelper: "+r+": Error during check styles '"+r+"'",a)}}return false};var s=n(t+a,true);if(s){var i=document.querySelectorAll("link[data-sap-ui-foucmarker='"+t+a+"']");if(i.length>0){for(var c=0,o=i.length;c<o;c++){i[c].remove()}e.debug("ThemeManager: Old stylesheets removed for library: "+a)}}return s};l.safeAccessSheetCssRules=function(e){try{return e.cssRules}catch(e){return null}};l.hasSheetCssRules=function(e){var r=l.safeAccessSheetCssRules(e);return!!r&&r.length>0};l.validateAndFallbackTheme=function(r,a){if(a==null&&i[r]){return i[r]}let l=r;if(a==null&&r.startsWith("sap_")&&s.indexOf(r)==-1){const a=n.exec(r)||[];const s=a[2];if(s){l=`${t}${s}`}else{l=t}i[r]=l;e.warning(`The configured theme '${r}' is not yet or no longer supported in this version. The valid fallback theme is '${l}'.`,"Theming")}return l};l.getDefaultThemeInfo=function(){return{DEFAULT_THEME:t,DARK_MODE:a}};return l});
/*!
 * copyright
 */
sap.ui.predefine("sap/ui/security/Security", ["sap/base/config"],function(e){"use strict";const t=e.getWritableInstance();const i=()=>{let e=true;let i=t.get({name:"sapUiAllowlistService",type:t.Type.String,defaultValue:t.get({name:"sapUiWhitelistService",type:t.Type.String,defaultValue:undefined})});if(!i){i=t.get({name:"sapAllowlistService",type:t.Type.String,defaultValue:t.get({name:"sapWhitelistService",type:t.Type.String})});e=false}return{allowlistService:i,globalProvider:e}};const r={getAllowlistService:()=>i().allowlistService,getFrameOptions(){var e=t.get({name:"sapUiFrameOptions",type:t.Type.String,defaultValue:"default"});if(e==="default"){const t=i();e=t.allowlistService&&!t.globalProvider?"trusted":"allow"}return e},getSecurityTokenHandlers(){return t.get({name:"sapUiSecurityTokenHandlers",type:t.Type.FunctionArray})},setSecurityTokenHandlers(e){e.forEach(function(e){if(typeof e!=="function"){throw new Error("Not a function: "+e)}});t.set("sapUiSecurityTokenHandlers",e.slice())}};return r});
//# sourceMappingURL=Calendar-preload.js.map
