/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./GridContainerRenderer","./GridContainerSettings","./GridContainerUtils","./GridNavigationMatrix","./delegate/GridContainerItemNavigation","./library","./dnd/GridKeyboardDragAndDrop","sap/base/strings/capitalize","sap/ui/core/delegate/ItemNavigation","sap/ui/base/ManagedObjectObserver","sap/ui/core/Control","sap/ui/core/Core","sap/ui/core/Element","sap/ui/core/ResizeHandler","sap/ui/core/InvisibleMessage","sap/ui/Device","sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery"],function(e,t,i,r,s,n,o,a,u,l,p,h,g,d,c,f,m,jQuery){"use strict";var y={"sap.f.Card":function(e){return e.getCardHeader()||e.getCardContent()},"sap.ui.integration.widgets.Card":function(e){return e.getCardHeader()||e.getCardContent()},"sap.m.GenericTile":function(){return true}};function _(e){var t=e.getLayoutData();return t?t.getColumns():1}function v(e){var t=e.getLayoutData();return t?t.getActualRows():1}function I(e){var t=e.getLayoutData();return t?t.hasAutoHeight():true}var C=p.extend("sap.f.GridContainer",{metadata:{library:"sap.f",interfaces:["sap.f.dnd.IGridDroppable"],properties:{width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:""},minHeight:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"2rem"},containerQuery:{type:"boolean",group:"Behavior",defaultValue:false},snapToRow:{type:"boolean",group:"Appearance",defaultValue:false},allowDenseFill:{type:"boolean",group:"Appearance",defaultValue:false},inlineBlockLayout:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.core.Control",multiple:true,singularName:"item",dnd:true},layout:{type:"sap.f.GridContainerSettings",multiple:false},layoutXS:{type:"sap.f.GridContainerSettings",multiple:false},layoutS:{type:"sap.f.GridContainerSettings",multiple:false},layoutM:{type:"sap.f.GridContainerSettings",multiple:false},layoutL:{type:"sap.f.GridContainerSettings",multiple:false},layoutXL:{type:"sap.f.GridContainerSettings",multiple:false},_defaultLayout:{type:"sap.f.GridContainerSettings",multiple:false,visibility:"hidden"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{layoutChange:{parameters:{layout:{type:"string"}}},columnsChange:{parameters:{columns:{type:"int"}}},borderReached:{parameters:{event:{type:"jQuery.Event"},direction:{type:"sap.f.NavigationDirection"},row:{type:"int"},column:{type:"int"}}}},dnd:{draggable:false,droppable:true}},renderer:e});C.prototype.bUseExtendedChangeDetection=true;C.prototype.getActiveLayoutSettings=function(){var e=this.getAggregation(this._sActiveLayout);if(!e&&this._sActiveLayout==="layoutXS"){e=this.getAggregation("layoutS")}if(!e){e=this.getAggregation("layout")||this.getAggregation("_defaultLayout")}return e};C.prototype._onBeforeItemRendering=function(){var e=this.getParent();if(e._resizeListeners[this.getId()]){d.deregister(e._resizeListeners[this.getId()]);delete e._resizeListeners[this.getId()]}e._reflectItemVisibilityToWrapper(this)};C.prototype._onAfterItemRendering=function(){var e=this.getParent();e._checkOwnVisualFocus(this);e._resizeListeners[this.getId()]=d.register(this,e._resizeItemHandler);e._setItemNavigationItems();e._applyItemAutoRows(this)};C.prototype._onItemWrapperFocusIn=function(e){var t=this._oItemNavigation.getFocusedDomRef(),i,r;if(!t||!t.firstChild){return}i=g.closestTo(t.firstChild);if(!i||!i.getAriaRoleDescription){return}r=i.getAriaRoleDescription();if(r){c.getInstance().announce(r)}};C.prototype._reflectItemVisibilityToWrapper=function(e){var t=i.getItemWrapper(e),r;if(!t){return}r=jQuery(t);if(e.getVisible()&&r.hasClass("sapFGridContainerInvisiblePlaceholder")){r.removeClass("sapFGridContainerInvisiblePlaceholder")}else if(!e.getVisible()&&!r.hasClass("sapFGridContainerInvisiblePlaceholder")){r.addClass("sapFGridContainerInvisiblePlaceholder")}};C.prototype._onItemChange=function(e){if(e.name!=="items"||!e.child){return}if(e.mutation==="insert"){e.child.addEventDelegate(this._itemDelegate,e.child)}else if(e.mutation==="remove"){e.child.removeEventDelegate(this._itemDelegate,e.child)}};C.prototype._deregisterResizeListeners=function(){var e,t;for(e in this._resizeListeners){t=this._resizeListeners[e];d.deregister(t)}delete this._resizeListeners;f.resize.detachHandler(this._resizeDeviceHandler)};C.prototype._setItemNavigationItems=function(){if(!this._isRenderingFinished){return}var e=this,t=[];if(!e._oItemNavigation){e._oItemNavigation=(new s).setCycling(false).setDisabledModifiers({sapnext:["alt","meta","ctrl"],sapprevious:["alt","meta","ctrl"]}).setTableMode(true,true).setFocusedIndex(0).attachEvent(u.Events.AfterFocus,this._onItemWrapperFocusIn.bind(this));e.addDelegate(this._oItemNavigation)}e.$().children().map(function(e,i){if(i.getAttribute("class").indexOf("sapFGridContainerItemWrapper")>-1){t.push(i)}});e._oItemNavigation.setRootDomRef(e.getDomRef());e._oItemNavigation.setItemDomRefs(t)};C.prototype._detectActiveLayout=function(){var e=this.getContainerQuery()&&this.getDomRef()?this._getComputedWidth():f.resize.width,t=f.media.getCurrentRange("GridContainerRangeSet",e),i="layout"+t.name,r=this.getActiveLayoutSettings(),s=false;if(!e){return false}if(this._sActiveLayout!==i){this.addStyleClass("sapFGridContainer"+a(i));if(this._sActiveLayout){this.removeStyleClass("sapFGridContainer"+a(this._sActiveLayout))}this._sActiveLayout=i;s=r!==this.getActiveLayoutSettings();this.fireLayoutChange({layout:this._sActiveLayout})}return s};C.prototype._detectColumnsChange=function(){var e=this.getActiveLayoutSettings(),t=this.$().innerWidth(),i;if(!e){return}i=e.getComputedColumnsCount(t);if(this._iColumns!==i){this.fireColumnsChange({columns:i});this._iColumns=i}};C.prototype._getActiveGridStyles=function(){var e=this.getActiveLayoutSettings(),t=e.getColumns()||"auto-fill",i=e.getColumnSize(),r=e.getMinColumnSize(),s=e.getMaxColumnSize(),n={"grid-gap":e.getGap()};if(r&&s){n["grid-template-columns"]="repeat("+t+", minmax("+r+", "+s+"))"}else{n["grid-template-columns"]="repeat("+t+", "+i+")"}if(this.getInlineBlockLayout()){n["grid-auto-rows"]="min-content"}else{n["grid-auto-rows"]=e.getRowSize()}return n};C.prototype.init=function(){this._oRb=h.getLibraryResourceBundle("sap.f");this.setAggregation("_defaultLayout",new t);this._initRangeSet();this._resizeListeners={};this._oItemNavigation=null;this._itemDelegate={onBeforeRendering:this._onBeforeItemRendering,onAfterRendering:this._onAfterItemRendering};this._itemsObserver=new l(this._onItemChange.bind(this));this._itemsObserver.observe(this,{aggregations:["items"]});this._resizeHandler=this._resize.bind(this);this._resizeDeviceHandler=this._resizeDevice.bind(this);f.resize.attachHandler(this._resizeDeviceHandler);this._resizeItemHandler=this._resizeItem.bind(this)};C.prototype.insertItem=function(e,t){this.insertAggregation("items",e,t,true);if(!this.getDomRef()||!e.getVisible()){this.invalidate();return this}var r=h.createRenderManager(),s=this._createItemWrapper(e),n=this._getItemAt(t+1),o=this.getDomRef();if(n){o.insertBefore(s,i.getItemWrapper(n))}else{o.insertBefore(s,o.lastChild)}r.render(e,s);r.destroy();return this};C.prototype.removeItem=function(e){var t=this.removeAggregation("items",e,true),i=this.getDomRef(),r=t.getDomRef();if(!i||!r){this.invalidate();return t}i.removeChild(r.parentElement);return t};C.prototype.onBeforeRendering=function(){this._detectActiveLayout();var e=this._resizeListeners[this.getId()];if(e){d.deregister(e)}c.getInstance();this._isRenderingFinished=false;this._lastGridWidth=null;this._lastViewportWidth=null};C.prototype.onAfterRendering=function(){this._resizeListeners[this.getId()]=d.register(this.getDomRef(),this._resizeHandler);this._isRenderingFinished=true;this._setItemNavigationItems();this._applyLayout(true);if(this.getItems().length===1&&this._forceFocus){this.focusItem(0);this._forceFocus=false}};C.prototype.exit=function(){this._deregisterResizeListeners();if(this._itemsObserver){this._itemsObserver.disconnect();delete this._itemsObserver}if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;this._oItemNavigation=null}this._forceFocus=null;if(this._checkColumnsTimeout){clearTimeout(this._checkColumnsTimeout);this._checkColumnsTimeout=null}};C.prototype._initRangeSet=function(){if(!f.media.hasRangeSet("GridContainerRangeSet")){f.media.initRangeSet("GridContainerRangeSet",[375,600,1024,1440],"px",["XS","S","M","L","XL"])}};C.prototype._resize=function(){if(!this._isWidthChanged()){return}var e=this._detectActiveLayout();this._applyLayout(e)};C.prototype._resizeDevice=function(){if(!this.getContainerQuery()){this._resize()}};C.prototype._isWidthChanged=function(){var e=this._getComputedWidth(),t=f.resize.width;if(this._lastGridWidth===e&&this._lastViewportWidth===t){return false}this._lastGridWidth=e;this._lastViewportWidth=t;return true};C.prototype._getComputedWidth=function(){if(!this.getDomRef()){return null}return this.getDomRef().getBoundingClientRect().width};C.prototype._resizeItem=function(e){this._applyItemAutoRows(e.control)};C.prototype._applyLayout=function(e){if(!this._isRenderingFinished){return}if(e){this.$().css(this._getActiveGridStyles());this.getItems().forEach(this._applyItemAutoRows.bind(this))}this._checkColumns()};C.prototype._checkColumns=function(){if(this._checkColumnsTimeout){clearTimeout(this._checkColumnsTimeout);this._checkColumnsTimeout=null}this._checkColumnsTimeout=setTimeout(function(){this._detectColumnsChange();this._enforceMaxColumns()}.bind(this),0)};C.prototype._applyItemAutoRows=function(e){if(!this._isRenderingFinished){return}if(this.getInlineBlockLayout()){return}if(I(e)){var t=e.$(),i=this.getActiveLayoutSettings(),r=e.getDomRef()?e.getDomRef().getBoundingClientRect().height:0,s=i.calculateRowsForItem(Math.round(r));if(!s){return}t.parent().css({"grid-row":"span "+Math.max(s,v(e))})}};C.prototype._enforceMaxColumns=function(){var e=this.getActiveLayoutSettings(),t;if(!e){return}t=e.getComputedColumnsCount(this.$().innerWidth());if(!t){return}this.getItems().forEach(function(e){e.$().parent().css("grid-column","span "+Math.min(_(e),t))})};C.prototype._getItemAt=function(e){var t=this.getItems(),i;if(e<0){e=0}if(t.length&&t[e]){i=t[e]}return i};C.prototype._createItemWrapper=function(t){var i=e.getStylesForItemWrapper(t,this),r=i.styles,s=i.classes,n=document.createElement("div");n.setAttribute("id",e.generateWrapperId(t,this));n.setAttribute("tabindex","0");r.forEach(function(e,t){n.style.setProperty(t,e)});s.forEach(function(e){n.classList.add(e)});return n};C.prototype.onItemNavigationBorderReached=function(e){this.fireEvent("borderReached",e)};["onkeypress","onkeyup","onkeydown","onsapenter","onsapselect","onsapspace"].forEach(function(e){C.prototype[e]=function(t){if(!this._isItemWrapper(t.target)){return}if(e==="onsapspace"){t.preventDefault()}var i=g.closestTo(t.target.firstChild);if(i){var r=i.getFocusDomRef(),s=g.closestTo(r);if(s&&s[e]){s[e].call(s,t)}}}});C.prototype._checkOwnVisualFocus=function(e){var t=e.getMetadata().getName(),r;if(y[t]&&y[t](e)){r=e.getFocusDomRef();if(r.getAttribute("tabindex")==="0"){r.setAttribute("tabindex",-1);r.tabIndex=-1}i.getItemWrapper(e).classList.add("sapFGridContainerItemWrapperNoVisualFocus")}};C.prototype._moveItem=function(e){if(!e.ctrlKey){return}if(!this._isItemWrapper(e.target)){return}var t=g.closestTo(e.target.firstElementChild),r=this.getItems().length,s=this.indexOfItem(t),n=-1,a,u=[];switch(e.keyCode){case m.ARROW_RIGHT:n=h.getConfiguration().getRTL()?s-1:s+1;if(n>=0&&n<r){a=i.createConfig(this,this.getItems()[n]);a.dropPosition="After";u=[a]}break;case m.ARROW_LEFT:n=h.getConfiguration().getRTL()?s+1:s-1;if(n>=0&&n<r){a=i.createConfig(this,this.getItems()[n]);a.dropPosition="Before";u=[a]}break;case m.ARROW_UP:u=i.findDropTargetsAbove(this,t);u.forEach(function(e){e.dropPosition="Before"});break;case m.ARROW_DOWN:u=i.findDropTargetsBelow(this,t);u.forEach(function(e){e.dropPosition=this.indexOfItem(e.item)!==-1?"After":"Before"}.bind(this));break;default:break}e.stopPropagation();o.fireDnD(t,u,e);this._setItemNavigationItems()};C.prototype.onsapincreasemodifiers=C.prototype._moveItem;C.prototype.onsapdecreasemodifiers=C.prototype._moveItem;C.prototype.focusItem=function(e){var t,i=this._oItemNavigation;this._forceFocus=true;this._setItemNavigationItems();t=i.getItemDomRefs();if(t[e]){i.focusItem(e)}};C.prototype.focusItemByDirection=function(e,t,i){this._oItemNavigation.focusItemByDirection(this,e,t,i)};C.prototype.getNavigationMatrix=function(){if(!h.isThemeApplied()){return null}var e=this.getItems().reduce(function(e,t){if(t.getVisible()){e.push(i.getItemWrapper(t))}return e},[]);return r.create(this.getDomRef(),e)};C.prototype._isItemWrapper=function(e){return e.classList.contains("sapFGridContainerItemWrapper")};return C});
//# sourceMappingURL=GridContainer.js.map