/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Control","./shellBar/Factory","./shellBar/AdditionalContentSupport","./shellBar/ResponsiveHandler","./shellBar/Accessibility","sap/m/BarInPageEnabler","sap/m/BadgeCustomData","sap/m/Button","sap/ui/Device","sap/m/library","./ShellBarRenderer"],function(t,e,o,i,a,s,r,n,l,h,p){"use strict";var d=h.AvatarSize;var u=t.extend("sap.f.ShellBar",{metadata:{library:"sap.f",interfaces:["sap.f.IShellBar","sap.m.IBar","sap.tnt.IToolHeader"],properties:{title:{type:"string",group:"Appearance",defaultValue:""},secondTitle:{type:"string",group:"Appearance",defaultValue:""},homeIcon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:""},homeIconTooltip:{type:"string",group:"Appearance",defaultValue:""},showMenuButton:{type:"boolean",group:"Appearance",defaultValue:false},showNavButton:{type:"boolean",group:"Appearance",defaultValue:false},showCopilot:{type:"boolean",group:"Appearance",defaultValue:false},showSearch:{type:"boolean",group:"Appearance",defaultValue:false},showNotifications:{type:"boolean",group:"Appearance",defaultValue:false},showProductSwitcher:{type:"boolean",group:"Appearance",defaultValue:false},notificationsNumber:{type:"string",group:"Appearance",defaultValue:""}},aggregations:{menu:{type:"sap.m.Menu",multiple:false,forwarding:{getter:"_getMenu",aggregation:"menu"}},searchManager:{type:"sap.f.SearchManager",multiple:false},profile:{type:"sap.m.Avatar",multiple:false},additionalContent:{type:"sap.f.IShellBar",multiple:true,singularName:"additionalContent"},_overflowToolbar:{type:"sap.m.OverflowToolbar",multiple:false,visibility:"hidden"},_additionalBox:{type:"sap.m.HBox",multiple:false,visibility:"hidden"}},events:{homeIconPressed:{parameters:{icon:{type:"sap.m.Image"}}},menuButtonPressed:{parameters:{button:{type:"sap.m.Button"}}},navButtonPressed:{parameters:{button:{type:"sap.m.Button"}}},copilotPressed:{parameters:{image:{type:"sap.m.Image"},button:{type:"sap.m.Button"}}},searchButtonPressed:{parameters:{button:{type:"sap.m.Button"}}},notificationsPressed:{parameters:{button:{type:"sap.m.Button"}}},productSwitcherPressed:{parameters:{button:{type:"sap.m.Button"}}},avatarPressed:{parameters:{avatar:{type:"sap.m.Avatar"}}}}},renderer:p});o.apply(u.prototype);var _="ShellBarRangeSet";l.media.initRangeSet(_,[600,1024,1440,1920],"px",["Phone","Tablet","Desktop","LargeDesktop","ExtraLargeDesktop"],true);u.prototype.init=function(){this._oFactory=new e(this);this._bOTBUpdateNeeded=true;this._bLeftBoxUpdateNeeded=true;this._bRightBoxUpdateNeeded=true;this._oOverflowToolbar=this._oFactory.getOverflowToolbar();this._oAdditionalBox=this._oFactory.getAdditionalBox();this._aControls=[];this._aAdditionalContent=[];this.setAggregation("_overflowToolbar",this._oOverflowToolbar);this.setAggregation("_additionalBox",this._oAdditionalBox);this._oToolbarSpacer=this._oFactory.getToolbarSpacer();this._oResponsiveHandler=new i(this);this._oAcc=new a(this);this._sRangeSet=_};u.prototype.onBeforeRendering=function(){this._assignControls()};u.prototype.onAfterRendering=function(){if(!this.sCurrentRange){this._assignSearch();this.invalidate()}};u.prototype.exit=function(){this._aLeftControls=[];this._aRightControls=[];this._aControls=[];this._oResponsiveHandler.exit();this._oFactory.destroy();this._oAcc.exit()};u.prototype.setHomeIcon=function(t){if(t){if(!this._oHomeIcon){this._oHomeIcon=this._oFactory.getHomeIcon()}this._oHomeIcon.setSrc(t)}else{this._oHomeIcon=null}this._bLeftBoxUpdateNeeded=true;return this.setProperty("homeIcon",t)};u.prototype.setProfile=function(t){this.validateAggregation("profile",t,false);if(t){t.setDisplaySize(d.XS);t.setTooltip(this._oAcc.getEntityTooltip("PROFILE"));t.attachPress(function(){this.fireEvent("avatarPressed",{avatar:t})},this);t.addStyleClass("sapFShellBarProfile")}return this.setAggregation("profile",t)};u.prototype.setHomeIconTooltip=function(t){var e=this._oAcc.getEntityTooltip("LOGO");if(!this._oHomeIcon){this._oHomeIcon=this._oFactory.getHomeIcon()}if(t){this._oHomeIcon.setTooltip(t)}else{this._oHomeIcon.setTooltip(e)}return this.setProperty("homeIconTooltip",t,true)};u.prototype.setTitle=function(t){this._sTitle=t;if(!t){this._oPrimaryTitle=null;this._oMegaMenu=null}else{if(!this._oMegaMenu){this._oMegaMenu=this._oFactory.getMegaMenu()}this._oMegaMenu.setText(t);if(!this._oPrimaryTitle){this._oPrimaryTitle=this._oFactory.getPrimaryTitle()}this._oPrimaryTitle.setText(t)}this._bLeftBoxUpdateNeeded=true;return this.setProperty("title",t)};u.prototype.setSecondTitle=function(t){if(t){if(!this._oSecondTitle){this._oSecondTitle=this._oFactory.getSecondTitle()}this._oSecondTitle.setText(t)}else{this._oSecondTitle=null}this._bLeftBoxUpdateNeeded=true;return this.setProperty("secondTitle",t)};u.prototype.setShowCopilot=function(t){if(t){if(!this._oCopilot){this._oCopilot=this._oFactory.getCopilot()}}else{this._oCopilot=null}this._bOTBUpdateNeeded=true;this._bLeftBoxUpdateNeeded=true;this._bRightBoxUpdateNeeded=true;return this.setProperty("showCopilot",t)};u.prototype.setShowSearch=function(t){if(t){if(!this._oSearch){this._oSearch=this._oFactory.getSearch()}}else{this._oSearch=null}this._bOTBUpdateNeeded=true;return this.setProperty("showSearch",t)};u.prototype.setSearchManager=function(t){this.setAggregation("searchManager",t);if(t){if(!this._oManagedSearch){this._oManagedSearch=this._oFactory.getManagedSearch();this.addStyleClass("sapFShellBarWithSearch",true)}}else{this._oManagedSearch=null;this.addStyleClass("sapFShellBarWithSearch",false)}this._bOTBUpdateNeeded=true;return this};u.prototype.setShowNotifications=function(t){var e=this,o;if(t){if(!this._oNotifications){o=this.getParent();this._oNotifications=this._oFactory.getNotifications();this._oNotifications._onBeforeEnterOverflow=function(){var t=o&&o._getOverflowButton().getBadgeCustomData();this._bInOverflow=true;t&&t.setVisible(this.getBadgeCustomData().getVisible())};this._oNotifications._onAfterExitOverflow=function(){var t=o&&o._getOverflowButton().getBadgeCustomData();this._bInOverflow=false;t&&t.setVisible(false)};this._oNotifications.onBadgeUpdate=function(t,o){n.prototype.onBadgeUpdate.apply(this,arguments);if(!this._bInOverflow){e._oAcc.updateNotificationsNumber(t)}else{e._oAcc.updateNotificationsNumber("")}}}}else{this._oNotifications=null}this._bOTBUpdateNeeded=true;return this.setProperty("showNotifications",t)};u.prototype.setShowProductSwitcher=function(t){if(t){if(!this._oProductSwitcher){this._oProductSwitcher=this._oFactory.getProductSwitcher()}}else{this._oProductSwitcher=null}this._bRightBoxUpdateNeeded=true;return this.setProperty("showProductSwitcher",t)};u.prototype.setShowNavButton=function(t){if(t){if(!this._oNavButton){this._oNavButton=this._oFactory.getNavButton()}}else{this._oNavButton=null}this._bLeftBoxUpdateNeeded=true;return this.setProperty("showNavButton",t)};u.prototype.setShowMenuButton=function(t){if(t){if(!this._oMenuButton){this._oMenuButton=this._oFactory.getMenuButton()}}else{this._oMenuButton=null}this._bLeftBoxUpdateNeeded=true;return this.setProperty("showMenuButton",t)};u.prototype.setNotificationsNumber=function(t){if(this.getShowNotifications()){this._updateNotificationsIndicators(t)}return this.setProperty("notificationsNumber",t,true)};u.prototype._addDataToControl=function(t){t.addStyleClass("sapFShellBarItem");if(this._aControls.indexOf(t)===-1){this._aControls.push(t)}return t};u.prototype._assignControls=function(){if(!this._bOTBUpdateNeeded&&!this._bLeftBoxUpdateNeeded&&!this._bRightBoxUpdateNeeded){return}if(this._bLeftBoxUpdateNeeded){this._aLeftControls=[];if(this._oNavButton){this.addControlToCollection(this._oNavButton,this._aLeftControls)}if(this._oMenuButton){this.addControlToCollection(this._oMenuButton,this._aLeftControls)}if(this._oHomeIcon){this.addControlToCollection(this._oHomeIcon,this._aLeftControls)}this._assignControlsToAdditionalBox();this._aLeftControls.push(this._oAdditionalBox)}if(this._oCopilot){this._addDataToControl(this._oCopilot)}if(this._bRightBoxUpdateNeeded||this._bOTBUpdateNeeded){this._aRightControls=[];if(this._bOTBUpdateNeeded){this._assignControlsToOverflowToolbar()}this._aRightControls.push(this._oOverflowToolbar)}this._bLeftBoxUpdateNeeded=false;this._bRightBoxUpdateNeeded=false;this._bOTBUpdateNeeded=false};u.prototype._assignControlsToAdditionalBox=function(){this._oAdditionalBox.removeAllItems();this._oTitleControl=null;if(this.getShowMenuButton()){if(this._oPrimaryTitle){this.addControlToCollection(this._oPrimaryTitle,this._oAdditionalBox);this._oTitleControl=this._oPrimaryTitle}}else if(this._oMegaMenu){if(this._oMegaMenu.getMenu()&&this._oMegaMenu.getMenu().getItems().length){this.addControlToCollection(this._oMegaMenu,this._oAdditionalBox);this._oTitleControl=this._oMegaMenu}else if(this._oPrimaryTitle){this.addControlToCollection(this._oPrimaryTitle,this._oAdditionalBox);this._oTitleControl=this._oPrimaryTitle}}if(this._oSecondTitle){this.addControlToCollection(this._oSecondTitle,this._oAdditionalBox)}return this._oAdditionalBox};u.prototype._assignControlsToOverflowToolbar=function(){var t,e=this._getCurrentMediaRange();this.sCurrentRange=e;if(!this._oOverflowToolbar){return}this._oOverflowToolbar.removeAllContent();this.addControlToCollection(this._oToolbarSpacer,this._oOverflowToolbar);this._assignSearch();if(this._oSearch){this.addControlToCollection(this._oSearch,this._oOverflowToolbar)}if(this._oCopilot){this.addControlToCollection(this._oCopilot,this._oOverflowToolbar)}if(this._oNotifications){this.addControlToCollection(this._oNotifications,this._oOverflowToolbar)}t=this.getAdditionalContent();if(t){t.forEach(function(t){this.addControlToCollection(t,this._oOverflowToolbar)},this)}this._bOTBUpdateNeeded=false;return this._oOverflowToolbar};u.prototype._assignSearch=function(){var t=this._getCurrentMediaRange();this.sCurrentRange=t;if(this._oManagedSearch&&this.sCurrentRange!=="ExtraLargeDesktop"){this.addControlToCollection(this._oManagedSearch,this._oOverflowToolbar);this._oManagedSearch._switchOpenStateOnSearch()}else if(this._oManagedSearch&&this.sCurrentRange==="ExtraLargeDesktop"){this._oManagedSearch.setIsOpen(true);this.removeControlFromCollection(this._oManagedSearch,this._oOverflowToolbar)}};u.prototype._getCurrentMediaRange=function(){return this.$().length&&l.media.getCurrentRange(this._sRangeSet,this.$().outerWidth()).name};u.prototype.addControlToCollection=function(t,e){var o;if(Array.isArray(e)){o="push"}else{o=e===this._oAdditionalBox?"addItem":"addContent"}this._addDataToControl(t);e[o](t)};u.prototype.removeControlFromCollection=function(t,e){var o;if(!Array.isArray(e)){o=e===this._oAdditionalBox?"removeItem":"removeContent"}e[o](t)};u.prototype._updateNotificationsIndicators=function(t){var e;if(!this.getShowNotifications()){return}e=this._oOverflowToolbar._getOverflowButton();this._addOrUpdateBadges(e,t);if(!this._oNotifications._bInOverflow){this._oOverflowToolbar._getOverflowButton().getBadgeCustomData().setVisible(false)}this._addOrUpdateBadges(this._oNotifications,t)};u.prototype._addOrUpdateBadges=function(t,e){if(t.getBadgeCustomData()){t.getBadgeCustomData().setValue(e)}else{t.addCustomData(new r({value:e,animation:"Update"}))}};u.prototype._getMenu=function(){if(!this._oMegaMenu){this._oMegaMenu=this._oFactory.getMegaMenu()}return this._oMegaMenu};u.prototype.onThemeChanged=function(){this._oResponsiveHandler._handleResize()};u.prototype._getOverflowToolbar=function(){return this._oOverflowToolbar};u.prototype.getContext=s.prototype.getContext;u.prototype.isContextSensitive=s.prototype.isContextSensitive;u.prototype.setHTMLTag=s.prototype.setHTMLTag;u.prototype.getHTMLTag=s.prototype.getHTMLTag;u.prototype.applyTagAndContextClassFor=s.prototype.applyTagAndContextClassFor;u.prototype._applyContextClassFor=s.prototype._applyContextClassFor;u.prototype._applyTag=s.prototype._applyTag;u.prototype._getContextOptions=s.prototype._getContextOptions;u.prototype._setRootAccessibilityRole=s.prototype._setRootAccessibilityRole;u.prototype._getRootAccessibilityRole=s.prototype._getRootAccessibilityRole;u.prototype._setRootAriaLevel=s.prototype._setRootAriaLevel;u.prototype._getRootAriaLevel=s.prototype._getRootAriaLevel;return u});
//# sourceMappingURL=ShellBar.js.map