/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Element","sap/ui/core/delegate/ItemNavigation","sap/ui/events/KeyCodes","sap/base/Log","sap/f/library","sap/f/GridNavigationMatrix"],function(o,t,e,i,n,s){"use strict";const r=n.NavigationDirection;const c=10;var u=t.extend("sap.f.delegate.GridItemNavigation");u.prototype.onfocusin=function(o){t.prototype.onfocusin.call(this,o);if(o.target===this.oDomRef){this.resetFocusPosition()}};u.prototype.onsapfocusleave=function(o){t.prototype.onsapfocusleave.call(this,o);if(o.target===this.oDomRef){this.resetFocusPosition()}};u.prototype.onsapnext=function(o){this._moveFocus(o)};u.prototype.onsapprevious=function(o){this._moveFocus(o)};u.prototype.onsappageup=function(o){this._moveFocus(o)};u.prototype.onsappagedown=function(o){this._moveFocus(o)};u.prototype.resetFocusPosition=function(){this._mCurrentPosition=null};u.prototype.setFocusPosition=function(o){this._mCurrentPosition=o;i.info("Grid matrix position: ("+this._mCurrentPosition.row+", "+this._mCurrentPosition.column+")")};u.prototype.ontap=function(){this.resetFocusPosition()};u.prototype._moveFocus=function(o){const t=o.target;if(this.getItemDomRefs().indexOf(t)===-1){return}o.preventDefault();const i=this._getGridInstance().getNavigationMatrix();if(!i){return}const n=this._findPositionInMatrix(i,t);if(!this._mCurrentPosition){this.setFocusPosition({...n})}switch(o.keyCode){case e.ARROW_DOWN:this._moveFocusDown(n,i,t,o);break;case e.ARROW_RIGHT:this._moveFocusRight(n,i,t,o);break;case e.ARROW_UP:this._moveFocusUp(n,i,t,o);break;case e.ARROW_LEFT:this._moveFocusLeft(n,i,t,o);break;case e.PAGE_DOWN:this._moveFocusDown(n,i,t,o,c);break;case e.PAGE_UP:this._moveFocusUp(n,i,t,o,c);break;default:break}};u.prototype._moveFocusDown=function(o,t,e,i,n=1){const r={row:o.row,column:this._mCurrentPosition.column};const c={...r};let u=t[c.row][c.column];while(r.row<t.length-1&&(u===e||r.row-o.row<n)){r.row+=1;if(t[r.row][r.column]!==s.EMPTY_CELL){u=t[r.row][r.column];c.row=r.row}}if(u===e){this._onBorderReached(i);return}this.setFocusPosition(c);this.focusItem(this.getItemDomRefs().indexOf(u),i)};u.prototype._moveFocusRight=function(o,t,e,i){o.row=this._mCurrentPosition.row;let n=t[o.row][o.column];while(o.column<t[o.row].length-1&&n===e){o.column+=1;if(t[o.row][o.column]!==s.EMPTY_CELL){n=t[o.row][o.column]}}if(n===e){this._onBorderReached(i);return}this.setFocusPosition(o);this.focusItem(this.getItemDomRefs().indexOf(n),i)};u.prototype._moveFocusUp=function(o,t,e,i,n=1){const r={row:o.row,column:this._mCurrentPosition.column};const c={...r};let u=t[c.row][c.column];while(r.row>0&&(u===e||o.row-r.row<n)){r.row-=1;if(t[r.row][r.column]!==s.EMPTY_CELL){u=t[r.row][r.column];c.row=r.row}}if(u===e){this._onBorderReached(i);return}while(c.row>0&&t[c.row-1][c.column]===u){c.row-=1}this.setFocusPosition(c);this.focusItem(this.getItemDomRefs().indexOf(u),i)};u.prototype._moveFocusLeft=function(o,t,e,i){o.row=this._mCurrentPosition.row;let n=t[o.row][o.column];while(o.column>0&&n===e){o.column-=1;if(t[o.row][o.column]!==s.EMPTY_CELL){n=t[o.row][o.column]}}if(n===e){this._onBorderReached(i);return}while(o.column>0&&t[o.row][o.column-1]===n){o.column-=1}this.setFocusPosition(o);this.focusItem(this.getItemDomRefs().indexOf(n),i)};u.prototype._findPositionInMatrix=function(o,t){let e=null;o.some(function(o,i){const n=o.indexOf(t);if(n!==-1){e={};e.row=i;e.column=n;return true}return false});return e};u.prototype._onBorderReached=function(o){let t;switch(o.keyCode){case e.ARROW_RIGHT:t=r.Right;break;case e.ARROW_LEFT:t=r.Left;break;case e.ARROW_DOWN:case e.PAGE_DOWN:t=r.Down;break;case e.ARROW_UP:case e.PAGE_UP:t=r.Up;break}this._getGridInstance().onItemNavigationBorderReached({event:o,row:this._mCurrentPosition.row,column:this._mCurrentPosition.column,direction:t})};u.prototype.focusItemByDirection=function(o,t,e,i){const n=o.getNavigationMatrix();let s,c,u,a;switch(t){case r.Right:u=e;a=-1;c=n[e];if(c){do{s=c[++a]}while(!s)}break;case r.Left:u=e;a=n[0].length;c=n[e];if(c){do{s=c[--a]}while(!s)}if(s){while(a>0&&n[e][a-1]===s){a--}}break;case r.Down:u=-1;a=i;while(!s&&n[++u]&&n[u][i]!==undefined){s=n[u][i]}break;case r.Up:u=n.length;a=i;while(!s&&n[--u]&&n[u][i]!==undefined){s=n[u][i]}if(s){while(u>0&&n[u-1][i]===s){u--}}break;default:break}if(!s){return}this.setFocusPosition({column:a,row:u});s.focus()};u.prototype._getGridInstance=function(){return o.closestTo(this.oDomRef)};return u});
//# sourceMappingURL=GridItemNavigation.js.map