/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Control","sap/ui/core/IconPool","./AvatarRenderer","sap/ui/events/KeyCodes","sap/base/Log","sap/ui/core/Icon","./library","sap/ui/core/library","sap/ui/core/InvisibleText","sap/m/imageUtils/getCacheBustedUrl"],function(e,t,a,i,s,o,r,n,l,p){"use strict";var u=r.AvatarType;var h=r.AvatarImageFitType;var c=r.AvatarColor;var g=r.AvatarSize;var d=r.AvatarShape;var f=n.aria.HasPopup;var I=n.ValueState;var _=Object.keys(c).filter(function(e){return e.indexOf("Accent")!==-1});var y=e.extend("sap.m.Avatar",{metadata:{library:"sap.m",properties:{src:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},initials:{type:"string",group:"Data",defaultValue:null},displayShape:{type:"sap.m.AvatarShape",group:"Appearance",defaultValue:d.Circle},displaySize:{type:"sap.m.AvatarSize",group:"Appearance",defaultValue:g.S},customDisplaySize:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"3rem"},customFontSize:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"1.125rem"},imageFitType:{type:"sap.m.AvatarImageFitType",group:"Appearance",defaultValue:h.Cover},fallbackIcon:{type:"string",group:"Data",defaultValue:null},backgroundColor:{type:"sap.m.AvatarColor",group:"Appearance",defaultValue:c.Accent6},showBorder:{type:"boolean",group:"Appearance",defaultValue:false},badgeIcon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:""},badgeTooltip:{type:"string",group:"Data",defaultValue:null},decorative:{type:"boolean",group:"Accessibility",defaultValue:false},ariaHasPopup:{type:"sap.ui.core.aria.HasPopup",group:"Accessibility",defaultValue:f.None},badgeValueState:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:I.None},enabled:{type:"boolean",group:"Behavior",defaultValue:true},active:{type:"boolean",group:"Behavior",defaultValue:false}},aggregations:{detailBox:{type:"sap.m.LightBox",multiple:false,bindable:"bindable"},_badge:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_icon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{press:{}},dnd:{draggable:true,droppable:false},designtime:"sap/m/designtime/Avatar.designtime"},renderer:a});y.DEFAULT_CIRCLE_PLACEHOLDER="sap-icon://person-placeholder";y.DEFAULT_SQUARE_PLACEHOLDER="sap-icon://product";y.AVATAR_BADGE_TOOLTIP={"sap-icon://zoom-in":sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("AVATAR_TOOLTIP_ZOOMIN"),"sap-icon://camera":sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("AVATAR_TOOLTIP_CAMERA"),"sap-icon://edit":sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("AVATAR_TOOLTIP_EDIT")};y.prototype.init=function(){this._sActualType=null;this._bIsDefaultIcon=true;this._sImageFallbackType=null;this._sPickedRandomColor=null;this._badgeRef=null};y.prototype.onBeforeRendering=function(){if(this._getImageCustomData()&&!this._iCacheBustingValue){this._setNewCacheBustingValue()}};y.prototype.onAfterRendering=function(){this._checkInitialsHolderWidth()};y.prototype.onThemeChanged=function(){this._checkInitialsHolderWidth()};y.prototype.exit=function(){if(this._fnLightBoxOpen){this._fnLightBoxOpen=null}if(this._badgeRef){this._badgeRef.destroy()}if(this._oInvisibleText){this._oInvisibleText.destroy();this._oInvisibleText=null}this._sPickedRandomColor=null};y.prototype.setDetailBox=function(e){var t=this.getDetailBox();if(e){if(e===t){return this}if(t){this.detachPress(this._fnLightBoxOpen,t)}this._fnLightBoxOpen=e.open;this.attachPress(this._fnLightBoxOpen,e)}else if(this._fnLightBoxOpen){this.detachPress(this._fnLightBoxOpen,t);this._fnLightBoxOpen=null}return this.setAggregation("detailBox",e)};y.prototype.setBadgeValueState=function(e){Object.keys(I).forEach(function(t){this.toggleStyleClass("sapFAvatar"+t,t===e)}.bind(this));this.setProperty("badgeValueState",e,true);return this};y.prototype.clone=function(){var t=e.prototype.clone.apply(this,arguments),a=t.getDetailBox();if(a){t.detachPress(this._fnLightBoxOpen,this.getDetailBox());t._fnLightBoxOpen=a.open;t.attachPress(t._fnLightBoxOpen,a)}return t};y.prototype.attachPress=function(){Array.prototype.unshift.apply(arguments,["press"]);e.prototype.attachEvent.apply(this,arguments);if(this.hasListeners("press")){this.$().attr("tabindex","0");this.$().attr("role","button")}return this};y.prototype.detachPress=function(){Array.prototype.unshift.apply(arguments,["press"]);e.prototype.detachEvent.apply(this,arguments);if(!this.hasListeners("press")){this.$().removeAttr("tabindex");this.$().attr("role","img")}return this};y.prototype.ontap=function(){this._handlePress()};y.prototype.onkeydown=function(e){if(e.which===i.SHIFT||e.which===i.ESCAPE){this._bShouldInterupt=this._bSpacePressed}if(e.which===i.SPACE){this._bSpacePressed=true;e.preventDefault()}if(e.which===i.ENTER){this._handlePress()}};y.prototype.onkeyup=function(e){if(e.which===i.SPACE){if(!this._bShouldInterupt){this._handlePress()}this._bShouldInterupt=false;this._bSpacePressed=false;e.stopPropagation()}};y.prototype._handlePress=function(){if(!this.getEnabled()){return}this.firePress({})};y.prototype._areInitialsValid=function(e){var t=/^[a-zA-Z\xc0-\xd6\xd8-\xdc\xe0-\xf6\xf8-\xfc]{1,3}$/;if(!t.test(e)){s.warning("Initials should consist of only 1,2 or 3 latin letters",this);this._sActualType=u.Icon;this._bIsDefaultIcon=true;return false}return true};y.prototype._validateSrc=function(e){if(t.isIconURI(e)){this._sActualType=u.Icon;this._bIsDefaultIcon=t.getIconInfo(e)?false:true}else{this._bIsDefaultIcon=true;this._sActualType=u.Image;this.preloadedImage=new window.Image;this.preloadedImage.src=e;this.preloadedImage.onload=this._onImageLoad.bind(this);this.preloadedImage.onerror=this._onImageError.bind(this)}return this};y.prototype._getDisplayIcon=function(e){return t.isIconURI(e)&&t.getIconInfo(e)?t.createControlByURI({src:e}):null};y.prototype._getActualDisplayType=function(){var e=this._getAvatarSrc(),t=this.getInitials();if(e){this._validateSrc(e)}else if(t&&this._areInitialsValid(t)){this._sActualType=u.Initials}else{s.warning("No src and initials were provided",this);this._sActualType=u.Icon;this._bIsDefaultIcon=true}return this._sActualType};y.prototype._getImageFallbackType=function(){var e=this.getInitials();this._sImageFallbackType=e&&this._areInitialsValid(e)?u.Initials:u.Icon;return this._sImageFallbackType};y.prototype._getDefaultIconPath=function(e){var a=null,i=this.getFallbackIcon();if(i&&t.isIconURI(i)){a=i}else if(e===d.Circle){a=y.DEFAULT_CIRCLE_PLACEHOLDER}else if(e===d.Square){a=y.DEFAULT_SQUARE_PLACEHOLDER}return a};y.prototype._getIcon=function(){var e=this.getSrc(),a=this.getAggregation("_icon"),i=this.getDisplayShape();if(this._bIsDefaultIcon){e=this._getDefaultIconPath(i)}if(!a){a=t.createControlByURI({alt:"Image placeholder",src:e});this.setAggregation("_icon",a)}else if(a.getSrc()!==e){a.setSrc(e)}return a};y.prototype._getDefaultTooltip=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("AVATAR_TOOLTIP")};y.prototype._getBadgeIconSource=function(){var e;if(this.getDetailBox()){e="sap-icon://zoom-in"}else if(this.getBadgeIcon()!==""){if(this._getDisplayIcon(this.getBadgeIcon())){e=this.getBadgeIcon()}else{s.warning("No valid Icon URI source for badge affordance was provided")}}return e};y.prototype._getBadgeTooltip=function(){var e=this._getDefaultTooltip(),t=this.getBadgeIcon();if(this.getBadgeTooltip()){e=this.getBadgeTooltip()}else if(t&&y.AVATAR_BADGE_TOOLTIP[this.getBadgeIcon()]){e=y.AVATAR_BADGE_TOOLTIP[t]}return e};y.prototype._getBadge=function(){var e=this._getBadgeIconSource(),t=this._getBadgeTooltip();if(!e){return}if(!this._badgeRef){this.setAggregation("_badge",new o({src:e,tooltip:t}))}this._badgeRef=this.getAggregation("_badge");return this._badgeRef};y.prototype._onImageLoad=function(){delete this.preloadedImage};y.prototype._onImageError=function(){var e=this._getImageFallbackType();this.$().removeClass("sapFAvatarImage").addClass("sapFAvatar"+e);delete this.preloadedImage};y.prototype._getActualBackgroundColor=function(){var e=this.getBackgroundColor();if(e===c.Random){if(this._sPickedRandomColor){return this._sPickedRandomColor}e=this._sPickedRandomColor=c[_[_.length*Math.random()<<0]]}else{this._sPickedRandomColor=null}return e};y.prototype._checkInitialsHolderWidth=function(){var e=this.$(),t=this.getInitials().length;this.$oInitialsHolder=e.children(".sapFAvatarInitialsHolder");if(this.$oInitialsHolder.length!==0&&t===3){var a=e[0].offsetWidth,i=this.$oInitialsHolder[0].offsetWidth;if(i>a){this._wideInitialsIcon()}}};y.prototype._wideInitialsIcon=function(){var e=this.$(),t=e.children(".sapFAvatarHiddenIcon");t.removeClass("sapFAvatarHiddenIcon");this.$oInitialsHolder.css("display","none");e.removeClass("sapFAvatarInitials");e.addClass("sapFAvatarIcon")};y.prototype._getInvisibleText=function(){if(!this._oInvisibleText&&this.sInitials){this._oInvisibleText=new l({id:this.getId()+"-InvisibleText"});this._oInvisibleText.setText(this.sInitials).toStatic()}return this._oInvisibleText};y.prototype._getAriaLabelledBy=function(){var e=this.getAriaLabelledBy(),t;this.sInitials=this.getInitials();if(this.sInitials&&e.length>0){t=this._getInvisibleText().getId();e.push(t)}return e};y.prototype._getImageCustomData=function(e){var t=this.getCustomData().filter(function(e){return e.isA("sap.m.ImageCustomData")});return t.length?t[0]:undefined};y.prototype._setNewCacheBustingValue=function(){if(this._getImageCustomData()){this._iCacheBustingValue=Date.now()}};y.prototype._getAvatarSrc=function(){var e=this._getImageCustomData(),t=this.getSrc();if(e&&t){var a={sUrl:t,sParamName:e.getParamName(),sParamValue:this._iCacheBustingValue};return p(a)}return t};y.prototype.refreshAvatarCacheBusting=function(){this._setNewCacheBustingValue();this.invalidate()};return y});
//# sourceMappingURL=Avatar.js.map