/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./BarInPageEnabler","./library","sap/ui/core/Control","sap/ui/core/ResizeHandler","sap/ui/Device","./BarRenderer","sap/ui/thirdparty/jquery","sap/ui/core/Configuration"],function(t,e,i,r,o,s,jQuery,a){"use strict";var n=e.BarDesign;var l=e.TitleAlignment;var p=2;var h=i.extend("sap.m.Bar",{metadata:{interfaces:["sap.m.IBar"],library:"sap.m",properties:{enableFlexBox:{type:"boolean",group:"Misc",defaultValue:false,deprecated:true},translucent:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},design:{type:"sap.m.BarDesign",group:"Appearance",defaultValue:n.Auto},titleAlignment:{type:"sap.m.TitleAlignment",group:"Misc",defaultValue:l.None}},aggregations:{contentLeft:{type:"sap.ui.core.Control",multiple:true,singularName:"contentLeft"},contentMiddle:{type:"sap.ui.core.Control",multiple:true,singularName:"contentMiddle"},contentRight:{type:"sap.ui.core.Control",multiple:true,singularName:"contentRight"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},designtime:"sap/m/designtime/Bar.designtime",dnd:{draggable:false,droppable:true}},renderer:s});h.prototype.onBeforeRendering=function(){var t=this.getTitleAlignment(),e;this._removeAllListeners();for(e in l){if(e!==t){this.removeStyleClass("sapMBarTitleAlign"+e)}else{this.addStyleClass("sapMBarTitleAlign"+e)}}};h.prototype.onAfterRendering=function(){this._handleResize()};h.prototype.init=function(){this.data("sap-ui-fastnavgroup","true",true);this._sPrevTitleAlignmentClass=""};h.prototype.exit=function(){this._removeAllListeners();if(this._oflexBox){this._oflexBox.destroy();this._oflexBox=null}this._$MidBarPlaceHolder=null;this._$RightBar=null;this._$LeftBar=null};h._aResizeHandlers=["_sResizeListenerId","_sResizeListenerIdMid","_sResizeListenerIdRight","_sResizeListenerIdLeft"];h.prototype._removeAllListeners=function(){var t=this;h._aResizeHandlers.forEach(function(e){t._removeListenerFailsave(e)})};h.prototype._removeListenerFailsave=function(t){if(this[t]){r.deregister(this[t]);this[t]=null}};h.prototype._handleResize=function(){this._removeAllListeners();var t=!!this.getContentLeft().length,e=!!this.getContentMiddle().length,i=!!this.getContentRight().length;if(!e){e=this._oflexBox&&!!this._oflexBox.getItems().length}if(!this.getVisible()){return}if(!t&&!e&&!i){return}this._$LeftBar=this.$("BarLeft");this._$RightBar=this.$("BarRight");this._$MidBarPlaceHolder=this.$("BarPH");this._sResizeListenerId=r.register(this.getDomRef(),jQuery.proxy(this._handleResize,this));if(this.getEnableFlexBox()){this._updatePosition(t,e,i);return}if(t){this._sResizeListenerIdLeft=r.register(this._$LeftBar[0],jQuery.proxy(this._handleResize,this))}else{this._$LeftBar.addClass("sapMBarEmpty")}if(e){this._sResizeListenerIdMid=r.register(this._$MidBarPlaceHolder[0],jQuery.proxy(this._handleResize,this))}else{this._$MidBarPlaceHolder.addClass("sapMBarEmpty")}if(i){this._sResizeListenerIdRight=r.register(this._$RightBar[0],jQuery.proxy(this._handleResize,this))}else{this._$RightBar.addClass("sapMBarEmpty")}this._updatePosition(t,e,i)};h.prototype._updatePosition=function(t,e,i){if(!t&&e&&!i){return}if(t&&!e&&!i){return}if(!t&&!e&&i){return}var r=this.$().outerWidth(true);this._$RightBar.css({width:""});this._$LeftBar.css({width:""});this._$MidBarPlaceHolder.css({position:"",width:"",visibility:"hidden"});var o=this._$RightBar.outerWidth(true);if(o>r){if(t){this._$LeftBar.css({width:"0px"})}if(e){this._$MidBarPlaceHolder.css({width:"0px"})}this._$RightBar.css({width:r+"px"});return}var s=this._getBarContainerWidth(this._$LeftBar);if(r<s+o){s=r-o;this._$LeftBar.css({width:s+"px"});this._$MidBarPlaceHolder.css({width:"0px"});return}this._$MidBarPlaceHolder.css(this._getMidBarCss(o,r,s))};h.prototype._getMidBarCss=function(t,e,i){var r=this._$MidBarPlaceHolder.outerWidth(true),o=a.getRTL(),s={visibility:""};if(this.getEnableFlexBox()){var n=o?"right":"left";r=e-i-t-parseInt(this._$MidBarPlaceHolder.css("margin-left"))-parseInt(this._$MidBarPlaceHolder.css("margin-right"));s.position="absolute";s.width=r+"px";s[n]=i;return s}var p=e-i-t,h=e/2-r/2,d=i>h,g=e/2+r/2,u=e-t<g,f=this.getTitleAlignment();if(f!==l.None&&f!==l.Center||p>0&&(d||u)){s.position="absolute";s.width=p+"px";s.left=o?t:i}return s};h.prototype._getBarContainerWidth=function(t){var e,i=0,r=t.children(),s=0;if(o.browser.webkit||o.browser.firefox){for(e=0;e<r.length;e++){s+=jQuery(r[e]).outerWidth(true)}i=t.outerWidth(true)}else{var a;for(e=0;e<r.length;e++){a=window.getComputedStyle(r[e]);if(a.width=="auto"){s+=jQuery(r[e]).width()+1}else{s+=parseFloat(a.width)}s+=parseFloat(a.marginLeft);s+=parseFloat(a.marginRight);s+=parseFloat(a.paddingLeft);s+=parseFloat(a.paddingRight)}var n=window.getComputedStyle(t[0]);i+=parseFloat(n.width);i+=parseFloat(n.marginLeft);i+=parseFloat(n.marginRight);i+=parseFloat(n.paddingLeft);i+=parseFloat(n.paddingRight)}if(i<s){i=s}return i};var d=t.extend("sap.m.BarInAnyContentEnabler",{});d.mContexts={dialogFooter:{contextClass:"sapMFooter-CTX",tag:"Footer"}};d.prototype.getContext=function(){var e=t.prototype.getContext.call();for(var i in d.mContexts){e[i]=d.mContexts[i]}return e};h.prototype.getContext=d.prototype.getContext;h.prototype.isContextSensitive=d.prototype.isContextSensitive;h.prototype.setHTMLTag=d.prototype.setHTMLTag;h.prototype.getHTMLTag=d.prototype.getHTMLTag;h.prototype.applyTagAndContextClassFor=d.prototype.applyTagAndContextClassFor;h.prototype._applyContextClassFor=d.prototype._applyContextClassFor;h.prototype._applyTag=d.prototype._applyTag;h.prototype._getContextOptions=d.prototype._getContextOptions;h.prototype._setRootAccessibilityRole=d.prototype._setRootAccessibilityRole;h.prototype._getRootAccessibilityRole=d.prototype._getRootAccessibilityRole;h.prototype._getAccessibilityRole=function(){var t=this._getRootAccessibilityRole(),e=t;if(this._getBarInteractiveControlsCount()<p&&t==="toolbar"){e=""}return e};h.prototype._setRootAriaLevel=d.prototype._setRootAriaLevel;h.prototype._getRootAriaLevel=d.prototype._getRootAriaLevel;h.prototype._getBarInteractiveControlsCount=function(){var t=0;t+=this.getContentLeft().filter(this._isInteractiveControl).length;t+=this.getContentRight().filter(this._isInteractiveControl).length;t+=this.getContentMiddle().filter(this._isInteractiveControl).length;return t};h.prototype._isInteractiveControl=function(t){return t.getVisible()&&t.isA("sap.m.IToolbarInteractiveControl")&&typeof t._getToolbarInteractive==="function"&&t._getToolbarInteractive()};return h});
//# sourceMappingURL=Bar.js.map