/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./Input","./ComboBoxTextField","./ComboBoxBaseRenderer","./SuggestionsPopover","sap/ui/base/ManagedObjectObserver","sap/ui/core/SeparatorItem","sap/ui/core/InvisibleText","sap/ui/base/ManagedObject","sap/base/Log","./library","sap/ui/Device","sap/ui/dom/containsOrEquals","sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery","sap/m/inputUtils/forwardItemProperties","sap/m/inputUtils/highlightDOMElements","sap/m/inputUtils/highlightItemsWithContains","sap/m/inputUtils/ListHelpers","sap/ui/core/IconPool","sap/ui/core/Core"],function(t,e,i,s,o,n,r,a,u,p,l,h,c,jQuery,g,d,f,y,I,m){"use strict";var b=p.PlacementType;var S=["value","enabled","name","placeholder","editable","textAlign","textDirection","valueState","valueStateText"];var v=e.extend("sap.m.ComboBoxBase",{metadata:{library:"sap.m",abstract:true,defaultAggregation:"items",properties:{showSecondaryValues:{type:"boolean",group:"Misc",defaultValue:false},open:{type:"boolean",defaultValue:false},showClearIcon:{type:"boolean",defaultValue:false},effectiveShowClearIcon:{type:"boolean",defaultValue:false,visibility:"hidden"}},aggregations:{items:{type:"sap.ui.core.Item",multiple:true,singularName:"item",bindable:"bindable"},picker:{type:"sap.ui.core.PopupInterface",multiple:false,visibility:"hidden"}},events:{loadItems:{}},dnd:{draggable:false,droppable:true}},renderer:i});v.prototype.oncompositionend=function(t){e.prototype.oncompositionend.apply(this,arguments);if(!l.browser.firefox){this.handleInputValidation(t,this.isComposingCharacter())}};v.prototype.shouldShowClearIcon=function(){return this.getProperty("effectiveShowClearIcon")&&!!this.getValue()&&this.getEditable()&&this.getEnabled()};v.prototype.updateItems=function(t){this.bItemsUpdated=false;var e=this.getItems().length;var i;this.destroyItems();this.updateAggregation("items");this.bItemsUpdated=true;if(this.hasLoadItemsEventListeners()){if(this.isOpen()){y.fillList(this.getItems(),this._getList(),this._mapItemToListItem.bind(this));this.setRecreateItems(false)}this.onItemsLoaded()}i=this._getList();if(i&&e===this.getItems().length){i.setBusy(false);i.setShowNoData(!this.getItems().length);this.bInitialBusyIndicatorState=false}};v.prototype.setFilterFunction=function(t){if(t===null||t===undefined){this.fnFilter=null;return this}if(typeof t!=="function"){u.warning("Passed filter is not a function and the default implementation will be used")}else{this.fnFilter=t}return this};v.prototype.highlightList=function(t){var e=[];e=this._getList().$().find(".sapMSLIInfo [id$=-infoText], .sapMSLITitleOnly [id$=-titleText]");if(this.useHighlightItemsWithContains()){f(e,t)}else{d(e,t)}};v.prototype.useHighlightItemsWithContains=function(){return false};v.prototype._decoratePopupInput=function(t){if(t){this.setTextFieldHandler(t);t.setShowClearIcon(this.getShowClearIcon())}return t};v.prototype.setTextFieldHandler=function(t){var e=this,i=t._handleEvent;t._handleEvent=function(t){i.apply(this,arguments);if(/keydown|keyup|sapdown|sapup|saphome|sapend|sappagedown|sappageup|input/.test(t.type)){e._handleEvent(t)}}};v.prototype.refreshItems=function(){this.bItemsUpdated=false;this.refreshAggregation("items")};v.prototype.loadItems=function(t,e){var i=typeof t==="function";if(this.hasLoadItemsEventListeners()&&this.getItems().length===0){this._bOnItemsLoadedScheduled=false;if(i){e=jQuery.extend({action:t,busyIndicator:true,busyIndicatorDelay:300},e);this.aMessageQueue.push(e);if(this.iLoadItemsEventInitialProcessingTimeoutID===-1&&e.busyIndicator){this.iLoadItemsEventInitialProcessingTimeoutID=setTimeout(function t(){this.setInternalBusyIndicatorDelay(0);this.setInternalBusyIndicator(true)}.bind(this),e.busyIndicatorDelay)}}if(!this.bProcessingLoadItemsEvent){this.bProcessingLoadItemsEvent=true;this.fireLoadItems()}}else if(i){t.call(this)}};v.prototype.onItemsLoaded=function(){this.bProcessingLoadItemsEvent=false;clearTimeout(this.iLoadItemsEventInitialProcessingTimeoutID);if(this.bInitialBusyIndicatorState!==this.getBusy()){this.setInternalBusyIndicator(this.bInitialBusyIndicatorState)}if(this.iInitialBusyIndicatorDelay!==this.getBusyIndicatorDelay()){this.setInternalBusyIndicatorDelay(this.iInitialBusyIndicatorDelay)}for(var t=0,e,i,s;t<this.aMessageQueue.length;t++){e=this.aMessageQueue.shift();t--;s=t+1===this.aMessageQueue.length;i=s?null:this.aMessageQueue[t+1];if(typeof e.action==="function"){if(e.name==="input"&&!s&&i.name==="input"){continue}e.action.call(this)}}};v.prototype.hasLoadItemsEventListeners=function(){return this.hasListeners("loadItems")};v.prototype._scheduleOnItemsLoadedOnce=function(){if(!this._bOnItemsLoadedScheduled&&!this.isBound("items")&&this.hasLoadItemsEventListeners()&&this.bProcessingLoadItemsEvent){this._bOnItemsLoadedScheduled=true;setTimeout(this.onItemsLoaded.bind(this),0)}};v.prototype.getPickerInvisibleTextId=function(){return r.getStaticId("sap.m","COMBOBOX_AVAILABLE_OPTIONS")};v.prototype._getGroupHeaderInvisibleText=function(){if(!this._oGroupHeaderInvisibleText){this._oGroupHeaderInvisibleText=new r;this._oGroupHeaderInvisibleText.toStatic()}return this._oGroupHeaderInvisibleText};v.prototype._isListInSuggestMode=function(){return this._getList().getItems().some(function(t){return!t.getVisible()&&y.getItemByListItem(this.getItems(),t).getEnabled()},this)};v.prototype.getSelectable=function(t){return t._bSelectable};v.prototype._setItemsShownWithFilter=function(t){this._bItemsShownWithFilter=t};v.prototype._getItemsShownWithFilter=function(){return this._bItemsShownWithFilter};v.prototype._getClearIcon=function(){if(this._oClearIcon){return this._oClearIcon}this._oClearIcon=this.addEndIcon({src:I.getIconURI("decline"),noTabStop:true,visible:false,alt:this._oRb.getText("INPUT_CLEAR_ICON_ALT"),useIconTooltip:false,decorative:false,press:this.handleClearIconPress.bind(this)},0);this._oClearIcon.addStyleClass("sapMComboBoxBaseClearIcon");return this._oClearIcon};v.prototype.handleClearIconPress=function(t){};v.prototype.onkeyup=function(t){if(!this.getEnabled()||!this.getEditable()){return}this.getShowClearIcon()&&this.setProperty("effectiveShowClearIcon",!!this.getValue())};v.prototype.onkeydown=function(t){e.prototype.onkeydown.apply(this,arguments);var i=this._getSuggestionsPopover();if(this.areHotKeysPressed(t)&&i&&i.isOpen()){i.setValueStateActiveState(true);i._handleValueStateLinkNav(this,t);i.updateFocus(this,null)}};v.prototype.setValue=function(t){e.prototype.setValue.apply(this,arguments);this.setProperty("effectiveShowClearIcon",!!t);return this};v.prototype.init=function(){e.prototype.init.apply(this,arguments);this._oRb=m.getLibraryResourceBundle("sap.m");this.setPickerType(l.system.phone?"Dialog":"Dropdown");this._setItemsShownWithFilter(false);this.bItemsUpdated=false;this.bOpenedByKeyboardOrButton=false;this._bShouldClosePicker=false;this.bProcessingLoadItemsEvent=false;this.iLoadItemsEventInitialProcessingTimeoutID=-1;this.aMessageQueue=[];this.bInitialBusyIndicatorState=this.getBusy();this.iInitialBusyIndicatorDelay=this.getBusyIndicatorDelay();this._bOnItemsLoadedScheduled=false;this._bDoTypeAhead=true;this.getArrowIcon().addEventDelegate({onmousedown:function(t){this._bShouldClosePicker=this.isOpen()}},this);this.getArrowIcon().attachPress(this._handlePopupOpenAndItemsLoad.bind(this,true,this));this.fnFilter=null;var t=new o(function(t){var e=t.mutation;var i=t.child;var s={remove:"detachEvent",insert:"attachEvent"};var o={remove:"handleItemRemoval",insert:"handleItemInsertion"};if(!i[s[e]]||!this[o[e]]){return}i[s[e]]("_change",this.onItemChange,this);this.setRecreateItems(true);this[o[e]](i)}.bind(this));t.observe(this,{aggregations:["items"]})};v.prototype.handleItemRemoval=function(t){};v.prototype.handleItemInsertion=function(t){};v.prototype.setRecreateItems=function(t){this._bRecreateItems=t};v.prototype.getRecreateItems=function(){return this._bRecreateItems};v.prototype.onBeforeRendering=function(){var t=this.isOpen(),i=t?this._getSuggestionsPopover()._getValueStateHeader().getText():null,s=t?this._getSuggestionsPopover()._getValueStateHeader().getValueState():null;e.prototype.onBeforeRendering.apply(this,arguments);if(t&&(this.getValueStateText()&&i!==this.getValueStateText()||this.getValueState()!==s||this.getFormattedValueStateText())){this._updateSuggestionsPopoverValueState(true)}};v.prototype.onAfterRendering=function(){e.prototype.onAfterRendering.apply(this,arguments);const t=this.getPicker();if(t&&t.getDomRef()){if(t.getAriaDescribedBy().length>0&&t.isOpen()){t.getDomRef().setAttribute("aria-describedby",this.getValueStateLinksShortcutsId())}else{t.getDomRef().removeAttribute("aria-describedby")}}};v.prototype._handlePopupOpenAndItemsLoad=function(t,e){var i;if(!this.getEnabled()||!this.getEditable()){return}if(t&&this._getItemsShownWithFilter()){this._bShouldClosePicker=false;this.toggleIconPressedStyle(true);this.bOpenedByKeyboardOrButton=false;this.clearFilter();this._setItemsShownWithFilter(false);return}if(this._bShouldClosePicker){this._bShouldClosePicker=false;this.close();return}this.loadItems();this.bOpenedByKeyboardOrButton=t;if(this.isPlatformTablet()){this.syncPickerContent();i=this.getPicker();i.setInitialFocus(i)}if(e){i=this.getPicker();i&&i.setInitialFocus(e)}this.open()};v.prototype.exit=function(){e.prototype.exit.apply(this,arguments);this._oRb=null;if(this._getGroupHeaderInvisibleText()){this._getGroupHeaderInvisibleText().destroy();this._oGroupHeaderInvisibleText=null}if(this._oSuggestionPopover){this._oSuggestionPopover.destroy();this._oSuggestionPopover=null}clearTimeout(this.iLoadItemsEventInitialProcessingTimeoutID);this.aMessageQueue=null;this.fnFilter=null};v.prototype.onsapshow=function(t){if(!this.getEnabled()||!this.getEditable()){return}t.setMarked();if(t.keyCode===c.F4){this.onF4(t)}if(this._getItemsShownWithFilter()){this.loadItems(this._handlePopupOpenAndItemsLoad.bind(this,true));return}if(this.isOpen()){this.close();return}this.selectText(0,this.getValue().length);this.loadItems();this.bOpenedByKeyboardOrButton=true;this.open()};v.prototype.onF4=function(t){t.preventDefault()};v.prototype.onsapescape=function(t){if(this.getEnabled()&&this.getEditable()&&this.isOpen()){t.setMarked();t.preventDefault();this.close()}else{e.prototype.onsapescape.apply(this,arguments)}};v.prototype.onsaphide=v.prototype.onsapshow;v.prototype.onsapfocusleave=function(t){if(!t.relatedControlId){e.prototype.onsapfocusleave.apply(this,arguments);return}var i=sap.ui.getCore().byId(t.relatedControlId);if(i===this){return}var s=this.getPicker(),o=i&&i.getFocusDomRef();if(s&&h(s.getFocusDomRef(),o)){return}e.prototype.onsapfocusleave.apply(this,arguments)};v.prototype.getPopupAnchorDomRef=function(){return this.getDomRef()};v.prototype.addContent=function(t){};v.prototype.getList=function(){u.warning("[Warning]:","You are attempting to use deprecated method 'getList()', please refer to SAP note 2746748.",this);return this._getList()};v.prototype._getList=function(){var t=this._oSuggestionPopover&&this._oSuggestionPopover.getItemsContainer();if(this.bIsDestroyed||!t){return null}return t};v.prototype.setPickerType=function(t){this._sPickerType=t};v.prototype.getPickerType=function(){return this._sPickerType};v.prototype._updateSuggestionsPopoverValueState=function(t){var e=this._getSuggestionsPopover();if(!e){return}var i=this.getValueState(),s=this.getValueState()!==e._getValueStateHeader().getValueState(),o=this.getFormattedValueStateText(),n=this.getValueStateText(),r=o!==null||s;if(e.isOpen()&&!r){this.setFormattedValueStateText(e._getValueStateHeader().getFormattedText())}e.updateValueState(i,o||n,this.getShowValueStateMessage(),t)};v.prototype.shouldValueStateMessageBeOpened=function(){var t=e.prototype.shouldValueStateMessageBeOpened.apply(this,arguments);return t&&!this.isOpen()};v.prototype.onPropertyChange=function(t,e){var i=t.getParameter("newValue"),s=t.getParameter("name"),o="set"+s.charAt(0).toUpperCase()+s.slice(1),n=e&&e.srcControl||this.getPickerTextField();if(this.getInputForwardableProperties().indexOf(s)>-1&&n&&typeof n[o]==="function"){n[o](i)}};v.prototype.getInputForwardableProperties=function(){return S};v.prototype.isPickerDialog=function(){return this.getPickerType()==="Dialog"};v.prototype.isPlatformTablet=function(){var t=!l.system.combi,e=l.system.tablet&&t;return e};v.prototype.getDropdownSettings=function(){return{showArrow:false,placement:b.VerticalPreferredBottom,offsetX:0,offsetY:0,bounce:false,ariaLabelledBy:this.getPickerInvisibleTextId()||undefined}};v.prototype._configureList=function(){};v.prototype.createPicker=function(t){var e=this.getAggregation("picker");if(e){return e}this._oSuggestionPopover=this._createSuggestionsPopover();e=this._oSuggestionPopover.getPopover();this.setAggregation("picker",e,true);this.configPicker(e);return e};v.prototype.configPicker=function(t){};v.prototype._hasShowSelectedButton=function(){return false};v.prototype._createSuggestionsPopover=function(){var e=new s(this);e.decorateParent(this);e.createSuggestionPopup(this,{showSelectedButton:this._hasShowSelectedButton()},t);this._decoratePopupInput(e.getInput());e.initContent(this.getId());this.forwardEventHandlersToSuggPopover(e);this._configureList(e.getItemsContainer());return e};v.prototype.forwardEventHandlersToSuggPopover=function(t){t.setOkPressHandler(this._handleOkPress.bind(this));t.setCancelPressHandler(this._handleCancelPress.bind(this));t.setInputLabels(this.getLabels.bind(this))};v.prototype._handleOkPress=function(){var t=this,e=t.getPickerTextField();t.updateDomValue(e.getValue());t.onChange();t.close()};v.prototype._handleCancelPress=function(){this.close();this.revertSelection()};v.prototype.setSelectable=function(t,e){if(this.indexOfItem(t)<0){return}t._bSelectable=e;var i=y.getListItem(t);if(i){i.setVisible(e)}};v.prototype.onBeforeOpen=function(){this.closeValueStateMessage();this._updateSuggestionsPopoverValueState();if(!this._getItemsShownWithFilter()){this.toggleIconPressedStyle(true)}};v.prototype.onBeforeClose=function(){this.bOpenedByKeyboardOrButton=false;this._setItemsShownWithFilter(false);this._updateSuggestionsPopoverValueState()};v.prototype.getPicker=function(){var t=this.getAggregation("picker");if(t&&!t.bIsDestroyed&&!this.bIsDestroyed){return t}return null};v.prototype._getSuggestionsPopover=function(){return this._oSuggestionPopover};v.prototype.getValueStateLinks=function(){var t=this.getPicker()&&this.getPicker().getCustomHeader()&&typeof this.getPicker().getCustomHeader().getFormattedText==="function",e=t&&this.getPicker().getCustomHeader().getFormattedText(),i=e&&e.getControls();return i||[]};v.prototype.getPickerTextField=function(){var t=this._getSuggestionsPopover();return t?t.getInput():null};v.prototype.getPickerTitle=function(){var t=this.getPicker(),e=t&&t.getCustomHeader();if(this.isPickerDialog()&&e){return e.getContentMiddle()[0]}return null};v.prototype.revertSelection=function(){};v.prototype.hasContent=function(){return this.getItems().length>0};v.prototype.syncPickerContent=function(){};v.prototype.open=function(){var t=this.getPicker();if(t){t.open()}return this};v.prototype.getVisibleItems=function(){return y.getVisibleItems(this.getItems())};v.prototype.isItemSelected=function(){};v.prototype.getKeys=function(t){t=t||this.getItems();for(var e=0,i=[];e<t.length;e++){i[e]=t[e].getKey()}return i};v.prototype.findItem=function(t,e){var i="get"+t.charAt(0).toUpperCase()+t.slice(1);for(var s=0,o=this.getItems();s<o.length;s++){if(o[s][i]()===e){return o[s]}}return null};v.prototype.getItemByText=function(t){return this.findItem("text",t)};v.prototype.clearFilter=function(){this.getItems().forEach(function(t){var e=y.getListItem(t);if(e){e.setVisible(t.getEnabled()&&this.getSelectable(t))}},this)};v.prototype.onItemChange=function(t,e){g({item:t.getSource(),propName:t.getParameter("name"),propValue:t.getParameter("newValue")},e)};v.prototype.clearSelection=function(){};v.prototype.setInternalBusyIndicator=function(t){this.bInitialBusyIndicatorState=this.getBusy();return this.setBusy.apply(this,arguments)};v.prototype.setInternalBusyIndicatorDelay=function(t){this.iInitialBusyIndicatorDelay=this.getBusyIndicatorDelay();return this.setBusyIndicatorDelay.apply(this,arguments)};v.prototype.getItemAt=function(t){return this.getItems()[+t]||null};v.prototype.getFirstItem=function(){return this.getItems()[0]||null};v.prototype.getLastItem=function(){var t=this.getItems();return t[t.length-1]||null};v.prototype.getEnabledItems=function(t){return y.getEnabledItems(t||this.getItems())};v.prototype.getItemByKey=function(t){return this.findItem("key",t)};v.prototype.addItemGroup=function(t,e,i){e=e||new n({text:a.escapeSettingsValue(t.text)||a.escapeSettingsValue(t.key)});this.addAggregation("items",e,i);if(this._getList()&&e.isA("sap.ui.core.SeparatorItem")){this._getList().addItem(this._mapItemToListItem(e))}return e};v.prototype.isOpen=function(){var t=this.getPicker();return!!(t&&t.isOpen())};v.prototype.close=function(){var t=this.getPicker();if(t){t.close()}return this};v.prototype.intersectItems=function(t,e){return t.filter(function(t){return e.map(function(t){return t.getId()}).indexOf(t.getId())!==-1})};v.prototype.showItems=function(t){var e=this.fnFilter,i=function(){if(!this.getItems().length){return}this.detachLoadItems(i);this.setFilterFunction(t||function(){return true});this.applyShowItemsFilters();this._handlePopupOpenAndItemsLoad(false,this);this.setFilterFunction(e)}.bind(this);if(!this.getEnabled()||!this.getEditable()){return}this._setItemsShownWithFilter(true);this.attachLoadItems(i);this.loadItems(i)};v.prototype._getFormattedValueStateText=function(){if(this.isOpen()){return this._getSuggestionsPopover()._getValueStateHeader().getFormattedText()}else{return e.prototype.getFormattedValueStateText.call(this)}};v.prototype.applyShowItemsFilters=function(){};v.prototype.getValueStateLinksForAcc=function(){const t=this._getFormattedValueStateText();if(!t){return[]}return t.getControls()};return v});
//# sourceMappingURL=ComboBoxBase.js.map