/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","sap/ui/core/Control","./library","./DatePicker","./DateTimePicker","./TimePicker","sap/ui/model/type/Date","sap/ui/model/type/Time","sap/ui/model/type/DateTime","sap/ui/model/odata/type/ODataType","sap/ui/core/library","sap/ui/Device","./DateTimeInputRenderer","sap/ui/core/Configuration","sap/ui/core/date/UI5Date"],function(jQuery,e,t,a,r,i,s,o,l,u,n,p,c,h,y){"use strict";var g=t.DateTimeInputType;var d=n.TextDirection;var m=n.TextAlign;var f=n.ValueState;var v=e.extend("sap.m.DateTimeInput",{metadata:{interfaces:["sap.m.IToolbarInteractiveControl"],library:"sap.m",deprecated:true,designtime:"sap/m/designtime/DateTimeInput.designtime",properties:{value:{type:"string",group:"Data",defaultValue:null,bindable:"bindable"},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"},enabled:{type:"boolean",group:"Behavior",defaultValue:true},editable:{type:"boolean",group:"Behavior",defaultValue:true},valueState:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:f.None},valueStateText:{type:"string",group:"Misc",defaultValue:null},showValueStateMessage:{type:"boolean",group:"Misc",defaultValue:true},name:{type:"string",group:"Misc",defaultValue:null},placeholder:{type:"string",group:"Misc",defaultValue:null},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:m.Initial},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:d.Inherit},type:{type:"sap.m.DateTimeInputType",group:"Data",defaultValue:g.Date},displayFormat:{type:"string",group:"Appearance",defaultValue:null},valueFormat:{type:"string",group:"Data",defaultValue:null},dateValue:{type:"object",group:"Data",defaultValue:null}},aggregations:{_picker:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{change:{parameters:{value:{type:"string"},dateValue:{type:"object"},valid:{type:"boolean"}}}}},renderer:c});!function(e,a,r){var i=t.getLocaleData();jQuery.extend(e,{_types:{Date:{valueFormat:i.getDatePattern("short"),displayFormat:i.getDatePattern("medium")},Time:{valueFormat:i.getTimePattern("short"),displayFormat:i.getTimePattern("short")},DateTime:{valueFormat:i.getDateTimePattern("short"),displayFormat:i.getDateTimePattern("short")}}});["Time","Date"].forEach(function(t,a){["valueFormat","displayFormat"].forEach(function(r){var i=e._types;i.DateTime[r]=i.DateTime[r].replace("{"+a+"}",i[t][r])})})}(v.prototype,jQuery,p);v.prototype.init=function(){this.setType(g.Date)};v.prototype.onBeforeRendering=function(){V.call(this)};v.prototype.getFocusDomRef=function(){var e=T.call(this);return e.getFocusDomRef()};v.prototype.getIdForLabel=function(){var e=T.call(this);return e.getIdForLabel()};function D(e){var t;switch(e){case g.DateTime:t=new r(this.getId()+"-Picker");break;case g.Time:t=new i(this.getId()+"-Picker",{localeId:h.getFormatSettings().getFormatLocale().toString()});break;default:t=new a(this.getId()+"-Picker");break}t.setDisplayFormat(this.getDisplayFormat()||this._types[e].displayFormat);t.setValueFormat(this.getValueFormat()||this._types[e].valueFormat);if(this.getDateValue()){t.setDateValue(this.getDateValue())}t.setEnabled(this.getEnabled());t.setEditable(this.getEditable());t.setValueState(this.getValueState());t.setValueStateText(this.getValueStateText());t.setShowValueStateMessage(this.getShowValueStateMessage());t.setName(this.getName());t.setPlaceholder(this.getPlaceholder());t.setTextAlign(this.getTextAlign());t.setTextDirection(this.getTextDirection());t.setWidth("100%");t.attachChange(b,this);var s=this.getAriaLabelledBy();for(var o=0;o<s.length;o++){t.addAriaLabelledBy(s[o])}return t}v.prototype.setType=function(e){if(e==this.getType()&&T.call(this)){return this}this.destroyAggregation("_picker");var t=D.call(this,e);this.setAggregation("_picker",t);this.setProperty("type",e);return this};v.prototype.setWidth=function(e){this.setProperty("width",e);if(this.getDomRef()){e=this.getWidth();this.$().css("width",e)}return this};v.prototype.setValue=function(e){V.call(this);e=this.validateProperty("value",e);if(e.toLowerCase()=="now"){return this.setDateValue(y.getInstance())}if(e===this.getValue()){return this}this.setProperty("value",e,true);var t=T.call(this);t.setValue(e);var a=t.getDateValue();this.setProperty("dateValue",a,true);return this};v.prototype.setDateValue=function(e){if(!this._isValidDate(e)){throw new Error("Date must be a JavaScript date object; "+this)}V.call(this);this.setProperty("dateValue",e,true);var t=T.call(this);t.setDateValue(e);var a=t.getValue();this.setProperty("value",a,true);return this};v.prototype.setDisplayFormat=function(e){this.setProperty("displayFormat",e,true);var t=T.call(this);t.setDisplayFormat(e||this._types[this.getType()].displayFormat);return this};v.prototype.setValueFormat=function(e){this.setProperty("valueFormat",e,true);var t=T.call(this);t.setValueFormat(e||this._types[this.getType()].ValueFormat);return this};v.prototype.setEnabled=function(e){this.setProperty("enabled",e,true);var t=T.call(this);t.setEnabled(e);return this};v.prototype.setEditable=function(e){this.setProperty("editable",e,true);var t=T.call(this);t.setEditable(e);return this};v.prototype.setValueState=function(e){this.setProperty("valueState",e,true);var t=T.call(this);t.setValueState(e);return this};v.prototype.setValueStateText=function(e){this.setProperty("valueStateText",e,true);var t=T.call(this);t.setValueStateText(e);return this};v.prototype.setShowValueStateMessage=function(e){this.setProperty("showValueStateMessage",e,true);var t=T.call(this);t.setShowValueStateMessage(e);return this};v.prototype.setName=function(e){this.setProperty("name",e,true);var t=T.call(this);t.setName(e);return this};v.prototype.setPlaceholder=function(e){this.setProperty("placeholder",e,true);var t=T.call(this);t.setPlaceholder(e);return this};v.prototype.setTextAlign=function(e){this.setProperty("textAlign",e,true);var t=T.call(this);t.setTextAlign(e);return this};v.prototype.setTextDirection=function(e){this.setProperty("textDirection",e,true);var t=T.call(this);t.setTextDirection(e);return this};v.prototype.addAriaLabelledBy=function(e){this.addAssociation("ariaLabelledBy",e,true);var t=T.call(this);t.addAriaLabelledBy(e);return this};v.prototype.removeAriaLabelledBy=function(e){this.removeAssociation("ariaLabelledBy",e,true);var t=T.call(this);t.removeAriaLabelledBy(e);return this};v.prototype.removeAllAriaLabelledBy=function(){this.removeAssociation("ariaLabelledBy",true);var e=T.call(this);e.removeAllAriaLabelledBy();return this};v.prototype.getAccessibilityInfo=function(){var e=T.call(this);return e&&e.getAccessibilityInfo?e.getAccessibilityInfo():null};v.prototype._getPickerByTypeAndPattern=function(e,t,a){var r=/[DdYyMLWwGQUur]/,i=/[HhKkmsa]/,s=i.test(a),o=r.test(a),l=s&&!o,u=o&&!s,n=o&&s,p,c;switch(e){case g.Time:case g.Date:case g.DateTime:if(l&&t.getMetadata().getName()!=="sap.m.TimePicker"){p=g.Time}else if(u&&t.getMetadata().getName()!=="sap.m.DatePicker"){p=g.Date}else if(n&&t.getMetadata().getName()!=="sap.m.DateTimePicker"){p=g.DateTime}break;default:{throw"Invalid type: "+e+". Expected is one of the sap.m.DateTimeInputType"}}if(p){this.destroyAggregation("_picker");c=D.call(this,p);this.setAggregation("_picker",c)}return c||t};v.prototype._getBoundValueTypePattern=function(){var e=this.getBinding("value"),t=e&&e.getType()&&e.getType();if(t instanceof s||t instanceof o||t instanceof l){return t.getOutputPattern()}if(t instanceof u&&t.oFormat){return t.oFormat.oFormatOptions.pattern}return undefined};v.prototype._getToolbarInteractive=function(){return true};function T(){return this.getAggregation("_picker")}v.prototype._isValidDate=function(e){return!e||Object.prototype.toString.call(e)==="[object Date]"};function V(){if(this._getBoundValueTypePattern()){var e=this._getBoundValueTypePattern();var t=T.call(this);t=this._getPickerByTypeAndPattern(this.getType(),t,e);if(t.getValueFormat()!=e){t.setValueFormat(e)}if(t.getDisplayFormat()!=e){t.setDisplayFormat(e)}}}function b(e){var t=e.getParameter("value");var a;var r=e.getParameter("valid");this.setProperty("value",t,true);if(r){a=e.oSource.getDateValue();this.setProperty("dateValue",a,true)}this.fireChange({value:t,newValue:t,valid:r,dateValue:a,newDateValue:a})}return v});
//# sourceMappingURL=DateTimeInput.js.map