/*!
* OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.define(["./library","sap/ui/core/Core","sap/ui/core/Control","sap/ui/core/library","sap/ui/core/InvisibleText","sap/ui/Device","sap/ui/base/ManagedObject","sap/m/Link","sap/m/Text","sap/m/Button","sap/m/ResponsivePopover","sap/m/HyphenationSupport","./ExpandableTextRenderer"],function(e,t,r,i,a,n,o,p,s,l,d,g,u){"use strict";var h=t.getLibraryResourceBundle("sap.m");var c=h.getText("EXPANDABLE_TEXT_SHOW_MORE");var y=h.getText("EXPANDABLE_TEXT_SHOW_LESS");var x=h.getText("MSGBOX_CLOSE");var f=i.TextAlign;var T=i.TextDirection;var _=i.aria.HasPopup;var v=e.WrappingType;var A=e.PlacementType;var b=e.ExpandableTextOverflowMode;var m=e.EmptyIndicatorMode;var L=e.LinkAccessibleRole;function E(e){return e.replace(/ {2,}/g," ").replace(/\t{2,}/g," ")}var P=r.extend("sap.m.ExpandableText",{metadata:{interfaces:["sap.ui.core.IFormContent","sap.m.IHyphenation"],library:"sap.m",properties:{text:{type:"string",defaultValue:"",bindable:"bindable"},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:T.Inherit},wrappingType:{type:"sap.m.WrappingType",group:"Appearance",defaultValue:v.Normal},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:f.Begin},renderWhitespace:{type:"boolean",group:"Appearance",defaultValue:false},overflowMode:{type:"sap.m.ExpandableTextOverflowMode",group:"Appearance",defaultValue:b.InPlace},maxCharacters:{type:"int",group:"Appearance",defaultValue:100},expanded:{type:"boolean",group:"Appearance",defaultValue:false,visibility:"hidden"},emptyIndicatorMode:{type:"sap.m.EmptyIndicatorMode",group:"Appearance",defaultValue:m.Off}},aggregations:{_showMoreLink:{type:"sap.m.Link",multiple:false,visibility:"hidden"},_ariaLabelledBy:{type:"sap.ui.core.InvisibleText",multiple:false,visibility:"hidden"}},designtime:"sap/m/designtime/ExpandableText.designtime"},renderer:u});P.prototype.init=function(){this.setAggregation("_ariaLabelledBy",new a)};P.prototype.onBeforeRendering=function(){this._updateAriaLabelledByText()};P.prototype._onAfterLinkRendering=function(){var e;if(!this._isExpandable()||this.getOverflowMode()===b.Popover){return}e=this._getShowMoreLink().getDomRef();e.setAttribute("aria-expanded",this.getProperty("expanded"));e.setAttribute("aria-controls",this.getId()+"-string")};P.prototype.getText=function(e){var t=this.getProperty("text");if(e){return t.replace(/\r\n|\n\r|\r/g,"\n")}return t};P.prototype.getTextDomRef=function(){if(!this.getVisible()){return null}return this.getDomRef("string")};P.prototype._isExpandable=function(){var e=this.getText();if(!this.getRenderWhitespace()){e=E(e)}return e.length>this._getMaxCharacters()+c.length};P.prototype._getMaxCharacters=function(){return Math.max(0,this.getMaxCharacters())};P.prototype._getDisplayedText=function(){var e=this.getText(true);if(this.getProperty("expanded")||!this._isExpandable()){return e}if(!this.getRenderWhitespace()){e=E(e)}return e.substring(0,this._getMaxCharacters())};P.prototype._getShowMoreLink=function(){var e=this.getAggregation("_showMoreLink");if(!e){e=new p(this.getId()+"-showMoreLink",{accessibleRole:L.Button,text:this.getProperty("expanded")?y:c,ariaLabelledBy:this.getAggregation("_ariaLabelledBy"),press:function(t){var r,i,a;if(this.getOverflowMode()===b.InPlace){i=!this.getProperty("expanded");e.setText(i?y:c);this.setProperty("expanded",i)}else{r=new s({text:o.escapeSettingsValue(this.getText()),textDirection:this.getTextDirection(),wrappingType:this.getWrappingType(),textAlign:this.getTextAlign(),renderWhitespace:this.getRenderWhitespace()}).addStyleClass("sapUiSmallMargin").addStyleClass("sapMExTextPopover");a=this._oPopover;if(a&&a.isOpen()){a.close();return}if(!a){a=this._oPopover=new d({showHeader:false,placement:A.HorizontalPreferredRight,beforeClose:this._onPopoverBeforeClose.bind(this)});if(n.system.phone){a.setEndButton(new l({text:x,press:function(){a.close()}}))}this.addDependent(a)}e.setText(y);e.rerender();a.removeAllAriaLabelledBy();a.destroyContent();a.addAriaLabelledBy(r);a.addContent(r);a.openBy(t.getSource());this._updateAriaLabelledByText(true)}}.bind(this)});e.addEventDelegate({onAfterRendering:this._onAfterLinkRendering},this);this.setAggregation("_showMoreLink",e,true)}e.setAriaHasPopup(this.getOverflowMode()===b.InPlace?_.None:_.Dialog);return e};P.prototype._onPopoverBeforeClose=function(){this._getShowMoreLink().setText(c);this._updateAriaLabelledByText()};P.prototype._updateAriaLabelledByText=function(e){var t="";e=e||this.getProperty("expanded");if(this.getOverflowMode()===b.Popover){t=h.getText(e?"EXPANDABLE_TEXT_SHOW_LESS_POPOVER_ARIA_LABEL":"EXPANDABLE_TEXT_SHOW_MORE_POPOVER_ARIA_LABEL")}this.getAggregation("_ariaLabelledBy").setText(t)};P.prototype.exit=function(){if(this._oPopover){this._oPopover.destroy();this._oPopover=null}};P.prototype.getAccessibilityInfo=function(){return{description:this.getText()}};P.prototype.getTextsToBeHyphenated=function(){return{main:this._getDisplayedText(true)}};P.prototype.getDomRefsForHyphenatedTexts=function(){return{main:this.getTextDomRef()}};g.mixInto(P.prototype);return P});
//# sourceMappingURL=ExpandableText.js.map