/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./InputBase","sap/ui/core/Element","sap/ui/core/Item","sap/ui/core/Core","sap/ui/core/LabelEnablement","sap/ui/core/AccessKeysEnablement","./ColumnListItem","./GroupHeaderListItem","sap/ui/core/SeparatorItem","./Table","./library","sap/ui/core/IconPool","sap/ui/Device","./SuggestionsPopover","./Toolbar","./ToolbarSpacer","./Button","sap/ui/core/ResizeHandler","sap/ui/dom/containsOrEquals","sap/base/assert","sap/base/util/deepEqual","sap/m/inputUtils/wordStartsWithValue","sap/m/inputUtils/inputsDefaultFilter","sap/m/inputUtils/highlightDOMElements","sap/m/inputUtils/typeAhead","sap/ui/events/KeyCodes","sap/m/inputUtils/filterItems","sap/m/inputUtils/ListHelpers","sap/m/inputUtils/calculateSelectionStart","sap/m/inputUtils/selectionRange","./InputRenderer","sap/ui/base/ManagedObject","sap/ui/base/ManagedObjectObserver","sap/ui/core/Lib","sap/ui/dom/jquery/selectText"],function(e,t,s,i,o,n,r,u,a,g,l,p,h,c,f,d,S,_,y,m,v,I,b,T,P,V,w,R,A,C,D,F,L,M){"use strict";var O=l.ListType;var H=l.InputTextFormatMode;var x=l.InputType;var E=l.ListMode;var B=l.ListSeparators;var U=e.extend("sap.m.Input",{metadata:{interfaces:["sap.ui.core.IAccessKeySupport","sap.m.IToolbarInteractiveControl"],library:"sap.m",properties:{type:{type:"sap.m.InputType",group:"Data",defaultValue:x.Text},maxLength:{type:"int",group:"Behavior",defaultValue:0},dateFormat:{type:"string",group:"Misc",defaultValue:"YYYY-MM-dd",deprecated:true},showValueHelp:{type:"boolean",group:"Behavior",defaultValue:false},valueHelpIconSrc:{type:"sap.ui.core.URI",group:"Behavior",defaultValue:"sap-icon://value-help"},showSuggestion:{type:"boolean",group:"Behavior",defaultValue:false},valueHelpOnly:{type:"boolean",group:"Behavior",defaultValue:false},filterSuggests:{type:"boolean",group:"Behavior",defaultValue:true},maxSuggestionWidth:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null},startSuggestion:{type:"int",group:"Behavior",defaultValue:1},showTableSuggestionValueHelp:{type:"boolean",group:"Behavior",defaultValue:true},description:{type:"string",group:"Misc",defaultValue:null},fieldWidth:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"50%"},valueLiveUpdate:{type:"boolean",group:"Behavior",defaultValue:false},selectedKey:{type:"string",group:"Data",defaultValue:""},textFormatMode:{type:"sap.m.InputTextFormatMode",group:"Misc",defaultValue:H.Value},textFormatter:{type:"function",group:"Misc",defaultValue:null},suggestionRowValidator:{type:"function",group:"Misc",defaultValue:null},enableSuggestionsHighlighting:{type:"boolean",group:"Behavior",defaultValue:true},enableTableAutoPopinMode:{type:"boolean",group:"Behavior",defaultValue:false},autocomplete:{type:"boolean",group:"Behavior",defaultValue:true},showClearIcon:{type:"boolean",defaultValue:false},effectiveShowClearIcon:{type:"boolean",defaultValue:false,visibility:"hidden"},separateSuggestions:{type:"boolean",defaultValue:true,visibility:"hidden"},highlightAccKeysRef:{type:"boolean",defaultValue:false,visibility:"hidden"},accesskey:{type:"string",defaultValue:"",visibility:"hidden"}},defaultAggregation:"suggestionItems",aggregations:{suggestionItems:{type:"sap.ui.core.Item",multiple:true,singularName:"suggestionItem"},suggestionColumns:{type:"sap.m.Column",multiple:true,singularName:"suggestionColumn",bindable:"bindable",forwarding:{getter:"_getSuggestionsTable",aggregation:"columns"}},suggestionRows:{type:"sap.m.ITableItem",multiple:true,singularName:"suggestionRow",bindable:"bindable",forwarding:{getter:"_getSuggestionsTable",aggregation:"items"}},_suggestionPopup:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_valueHelpIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}},associations:{selectedItem:{type:"sap.ui.core.Item",multiple:false},selectedRow:{type:"sap.m.ColumnListItem",multiple:false}},events:{liveChange:{parameters:{value:{type:"string"},escPressed:{type:"boolean"},previousValue:{type:"string"}}},valueHelpRequest:{parameters:{fromSuggestions:{type:"boolean"}}},suggest:{parameters:{suggestValue:{type:"string"},suggestionColumns:{type:"sap.m.ListBase"}}},suggestionItemSelected:{parameters:{selectedItem:{type:"sap.ui.core.Item"},selectedRow:{type:"sap.m.ColumnListItem"}}},submit:{parameters:{value:{type:"string"}}}},designtime:"sap/m/designtime/Input.designtime"},renderer:D});p.insertFontFaceStyle();U._DEFAULTFILTER_TABULAR=function(e,t){var s=t.getCells(),i=0;for(;i<s.length;i++){if(s[i].getText){if(I(s[i].getText(),e)){return true}}}return false};U._DEFAULTRESULT_TABULAR=function(e){if(!e||e.isA("sap.m.GroupHeaderListItem")){return""}var t=e.getCells(),s=0;for(;s<t.length;s++){if(t[s].getText){return t[s].getText()}}return""};U.prototype.init=function(){e.prototype.init.call(this);this._iSetCount=0;this._sProposedItemText=null;this._oRb=M.getResourceBundleFor("sap.m");if(this.getId().indexOf("popup-input")===-1){this._createSuggestionsPopover()}this._setTypedInValue("");this._bDoTypeAhead=false;this._bClearButtonPressed=false;this._bAfterOpenFinisihed=false;n.registerControl(this)};var K=function(e){var t=o.getReferencingLabels(this);t.forEach(function(t){i.byId(t).setProperty("highlightAccKeysRef",e)},this)};U.prototype.getAccessKeysFocusTarget=function(){return this.getFocusDomRef()};U.prototype.onAccKeysHighlightStart=function(){K.call(this,true)};U.prototype.onAccKeysHighlightEnd=function(){K.call(this,false)};U.prototype.exit=function(){e.prototype.exit.call(this);this._deregisterEvents();this.cancelPendingSuggest();if(this._iRefreshListTimeout){clearTimeout(this._iRefreshListTimeout);this._iRefreshListTimeout=null}this._destroySuggestionsTable();if(this._getSuggestionsPopover()){this._oSuggestionPopup=null;this._oSuggPopover.destroy();this._oSuggPopover=null}this.$().off("click")};U.prototype.onBeforeRendering=function(){var t=this.getSelectedKey(),s=this.getShowValueHelp()&&this.getEnabled()&&this.getEditable(),i=this.getProperty("effectiveShowClearIcon")&&this.getEnabled()&&this.getEditable(),o=this._oValueHelpIcon,n=this._getSuggestionsPopover(),r=n&&this._isSuggestionsPopoverOpen(),u=n&&n.getInput(),a=r?n._getValueStateHeader().getText():null,g=r?n._getValueStateHeader().getValueState():"";e.prototype.onBeforeRendering.call(this);if(this.getShowClearIcon()){this._getClearIcon().setProperty("visible",i)}else if(this._oClearButton){this._getClearIcon().setProperty("visible",false)}this._deregisterEvents();if(t&&!this.getSelectedItem()&&this.getSuggestionItemByKey(t)){this.setSelectedKey(t)}if(this.getShowSuggestion()){if(this.getShowTableSuggestionValueHelp()){this._addShowMoreButton()}else{this._removeShowMoreButton()}if(u){u.setType(this.getType())}}if(s){o=this._getValueHelpIcon();o.setVisible(true)}else if(o){o.setVisible(false)}if(!this.getWidth()){this.setWidth("100%")}if(this._hasTabularSuggestions()){this._getSuggestionsTable().setAutoPopinMode(this.getEnableTableAutoPopinMode());this._getSuggestionsTable().setContextualWidth(this.getEnableTableAutoPopinMode()?"Auto":"Inherit")}if(r&&(this.getValueStateText()&&a!==this.getValueStateText()||this.getValueState()!==g||this.getFormattedValueStateText())){this._updateSuggestionsPopoverValueState(true)}};U.prototype.onAfterRendering=function(){e.prototype.onAfterRendering.call(this);if(this.getType()===x.Password){const e=this.getDomRef("inner");const t=e.value;e.removeAttribute("value");e.value=t}const t=this._getSuggestionsPopover();if(t&&t.getPopover()&&t.getPopover().getDomRef()){const e=t.getPopover();if(e.getAriaDescribedBy().length>0&&e.isOpen()){e.getDomRef().setAttribute("aria-describedby",this.getValueStateLinksShortcutsId())}else{e.getDomRef().removeAttribute("aria-describedby")}}};U.prototype._getDisplayText=function(e){var t=this.getTextFormatter();if(t){return t(e)}var s=e.getText(),i=e.getKey(),o=this.getTextFormatMode();switch(o){case H.Key:return i;case H.ValueKey:return s+" ("+i+")";case H.KeyValue:return"("+i+") "+s;default:return s}};U.prototype._onValueUpdated=function(e){if(this._bSelectingItem||e===this._sSelectedValue){return}var t=this.getSelectedKey(),s,i=this._getSuggestionsPopover(),o=i&&i.getItemsContainer();if(!this._hasTabularSuggestions()&&t===""){return}if(this._hasTabularSuggestions()){s=this._getSuggestionsTable()&&!!this._getSuggestionsTable().getSelectedItem()}else{s=o&&!!o.getSelectedItem()}if(s){return}this.setProperty("selectedKey","",true);this.setAssociation("selectedRow",null,true);this.setAssociation("selectedItem",null,true)};U.prototype.setSelectionItem=function(e,t){this._bSelectingItem=true;if(!e){this.setAssociation("selectedItem",null,true);this.setValue("");return}var s=this._iSetCount,i;this.setAssociation("selectedItem",e,true);this.setProperty("selectedKey",e.getKey(),true);if(t){this.fireSuggestionItemSelected({selectedItem:e})}if(s!==this._iSetCount){i=this.getValue()}else{i=this._getDisplayText(e)}this._sSelectedValue=i;this.setSelectionUpdatedFromList(false);this.updateInputField(i);if(this.bIsDestroyed){return}if(!(this.isMobileDevice()&&this.isA("sap.m.MultiInput"))){this._closeSuggestionPopup()}this._bSelectingItem=false;this._resetTypeAhead()};U.prototype.addSuggestionRowGroup=function(e,t,s){t=t||new u({title:F.escapeSettingsValue(e.text)||F.escapeSettingsValue(e.key)});this._createSuggestionPopupContent(true);this.addAggregation("suggestionRows",t,s);return t};U.prototype.addSuggestionItemGroup=function(e,t,s){t=t||new a({text:F.escapeSettingsValue(e.text)||F.escapeSettingsValue(e.key)});this._createSuggestionPopupContent(false);this.addAggregation("suggestionItems",t,s);return t};U.prototype.setSelectedItem=function(e){if(typeof e==="string"){e=t.registry.get(e)}if(e!==null&&!(e instanceof s)){return this}this.setSelectionItem(e);return this};U.prototype.setSelectedKey=function(e){e=this.validateProperty("selectedKey",e);this.setProperty("selectedKey",e,true);if(this._hasTabularSuggestions()){return this}if(!e){this.setSelectionItem();return this}var t=this.getSuggestionItemByKey(e);this.setSelectionItem(t);return this};U.prototype.getSuggestionItemByKey=function(e){var t=this.getSuggestionItems()||[],s,i;for(i=0;i<t.length;i++){s=t[i];if(s.getKey()===e){return s}}};U.prototype.getValueStateLinksForAcc=function(){const e=this._getFormattedValueStateText();if(!e){return[]}return e.getControls()};U.prototype._getFormattedValueStateText=function(){var t=this._isSuggestionsPopoverOpen(),s=t?this._getSuggestionsPopover()._getValueStateHeader().getFormattedText():null;if(t&&s){return s}else{return e.prototype.getFormattedValueStateText.call(this)}};U.prototype.setSelectionRow=function(e,t){if(!e){this.setAssociation("selectedRow",null,true);return}this._bSelectingItem=true;var i,o=this.getSuggestionRowValidator();if(o){i=o(e);if(!(i instanceof s)){i=null}}var n=this._iSetCount,r="",u;this.setAssociation("selectedRow",e,true);if(i){r=i.getKey()}this.setProperty("selectedKey",r,true);if(t){this.fireSuggestionItemSelected({selectedRow:e})}if(n!==this._iSetCount){u=this.getValue()}else{if(i){u=this._getDisplayText(i)}else{u=this._getRowResultFunction()(e)}}this._sSelectedValue=u;this.setSelectionUpdatedFromList(false);this.updateInputField(u);if(this.bIsDestroyed){return}if(!(this.isMobileDevice()&&this.isA("sap.m.MultiInput")&&this._isMultiLineMode)){this._closeSuggestionPopup()}this._bSelectingItem=false;this._resetTypeAhead()};U.prototype.setSelectedRow=function(e){if(typeof e==="string"){e=t.registry.get(e)}if(e!==null&&!(e instanceof r)){return this}this.setSelectionRow(e);return this};U.prototype._getValueHelpIcon=function(){var e=this,t=this.getValueHelpIconSrc();if(!this._oValueHelpIcon){this._oValueHelpIcon=this.addEndIcon({id:this.getId()+"-vhi",src:t,useIconTooltip:false,alt:this._oRb.getText("INPUT_VALUEHELP_BUTTON"),decorative:false,noTabStop:true,press:function(t){if(e.getValueHelpOnly()){return}var s=this.getParent(),i;if(h.support.touch){i=s.$("inner");i.attr("readonly","readonly");s.focus();i.removeAttr("readonly")}else{s.focus()}e.bValueHelpRequested=true;e._fireValueHelpRequest(false)}})}else if(this._oValueHelpIcon.getSrc()!==t){this._oValueHelpIcon.setSrc(t)}return this._oValueHelpIcon};U.prototype._getClearIcon=function(){var e=this;if(this._oClearButton){return this._oClearButton}this._oClearButton=this.addEndIcon({src:p.getIconURI("decline"),noTabStop:true,visible:false,alt:this._oRb.getText("INPUT_CLEAR_ICON_ALT"),useIconTooltip:false,decorative:false,press:function(){if(e.getValue()!==""){e.setValue("");e.fireChange({value:""});e.fireLiveChange({value:""});e._bClearButtonPressed=true;setTimeout(function(){if(h.system.desktop){e.focus();e._closeSuggestionPopup()}},0)}}},0);return this._oClearButton};U.prototype._fireValueHelpRequest=function(e){var t="";if(this.getShowSuggestion()&&!this.isMobileDevice()){t=this._getTypedInValue()||""}else{t=this.getDOMValue()}this.fireValueHelpRequest({fromSuggestions:e,_userInputValue:t})};U.prototype._fireValueHelpRequestForValueHelpOnly=function(){if(this.getEnabled()&&this.getEditable()&&this.getShowValueHelp()&&this.getValueHelpOnly()){if(h.system.phone){this.focus()}this._fireValueHelpRequest(false)}};U.prototype.ontap=function(t){e.prototype.ontap.call(this,t);if(this.isValueHelpOnlyOpener(t.target)){this._fireValueHelpRequestForValueHelpOnly()}if(this.shouldSuggetionsPopoverOpenOnMobile(t)){this._openSuggestionsPopover()}this._bClearButtonPressed=false};U.prototype.shouldSuggetionsPopoverOpenOnMobile=function(e){return this.isMobileDevice()&&this.getEditable()&&this.getEnabled()&&this.getShowSuggestion()&&!this._bClearButtonPressed&&e.target.id!==this.getId()+"-vhi"};U.prototype.setFilterFunction=function(e){if(e===null||e===undefined){this._fnFilter=b;return this}m(typeof e==="function","Input.setFilterFunction: first argument fnFilter must be a function on "+this);this._fnFilter=e;return this};U.prototype._getFilterFunction=function(e){if(typeof this._fnFilter==="function"&&!e){return this._fnFilter}return!this._hasTabularSuggestions()?b:U._DEFAULTFILTER_TABULAR};U.prototype.setRowResultFunction=function(e){var t;if(e===null||e===undefined){this._fnRowResultFilter=U._DEFAULTRESULT_TABULAR;return this}m(typeof e==="function","Input.setRowResultFunction: first argument fnFilter must be a function on "+this);this._fnRowResultFilter=e;t=this.getSelectedRow();if(t){this.setSelectedRow(t)}return this};U.prototype._getRowResultFunction=function(e){if(typeof this._fnRowResultFilter==="function"&&!e){return this._fnRowResultFilter}return U._DEFAULTRESULT_TABULAR};U.prototype.closeSuggestions=function(){this._closeSuggestionPopup()};U.prototype._doSelect=function(e,t){var s=this._$input[0];if(s){var i=this._$input;s.focus();i.selectText(e?e:0,t?t:i.val().length)}return this};U.prototype._isIncrementalType=function(){var e=this.getType();if(e==="Number"||e==="Date"||e==="Datetime"||e==="Month"||e==="Time"||e==="Week"){return true}return false};U.prototype.onsapescape=function(t){if(this._isSuggestionsPopoverOpen()){t.originalEvent._sapui_handledByControl=true;this._revertPopupSelection();if(this._getTypedInValue()!==this.getValue()){this.setValue(this._getTypedInValue())}return}if(this.getValueLiveUpdate()){this.setProperty("value",this.getLastValue(),true)}if(e.prototype.onsapescape){e.prototype.onsapescape.apply(this,arguments)}};U.prototype.onsapenter=function(t){const s=this._isSuggestionsPopoverOpen();const i=!this.hasStyleClass("sapMFocus")&&s;const o=this._hasTabularSuggestions()?this.getSuggestionRows():this.getSuggestionItems();const n=this._getSuggestionsPopover();const r=n?.getItemsContainer()?.getSelectedItem();const u=r?.getTitle?.()||r?.getCells?.()[0]?.getText?.()||"";const a=!!this._iSuggestDelay&&!u.toLowerCase().includes(this._getTypedInValue().toLowerCase());let g=this.getEnabled()&&this.getEditable();let l;this.cancelPendingSuggest();i&&this.setSelectionUpdatedFromList(true);if(this.getShowSuggestion()&&this._bDoTypeAhead&&s&&!this.isComposingCharacter()&&!a){if(this._hasTabularSuggestions()){r&&this.setSelectionRow(r,true)}else{r&&this.setSelectionItem(R.getItemByListItem(o,r),true)}}if(s&&!this.isComposingCharacter()){this._closeSuggestionPopup();l=this.getDOMValue()?this.getDOMValue().length:null;this.selectText(l,l)}!i&&e.prototype.onsapenter.apply(this,arguments);g=g&&!(this.getShowValueHelp()&&this.getValueHelpOnly());if(g){this.fireSubmit({value:this.getValue()})}if(!this.isMobileDevice()){this._resetTypeAhead()}};U.prototype.onsapfocusleave=function(s){var i=this._getSuggestionsPopover(),o=i&&i.getPopover(),n=o&&o.isA("sap.m.Popover"),r=s.relatedControlId&&t.registry.get(s.relatedControlId),u=r&&r.getFocusDomRef(),a=o&&u&&y(o.getDomRef(),u);if(n){if(a&&!i.getValueStateActiveState()){this._bPopupHasFocus=true;if(h.system.desktop&&v(o.getFocusDomRef(),u)||r.isA("sap.m.GroupHeaderListItem")){this.focus()}}else{if(this.getDOMValue()===this._sSelectedSuggViaKeyboard){this._sSelectedSuggViaKeyboard=null}}}if(!a){e.prototype.onsapfocusleave.apply(this,arguments)}this.bValueHelpRequested=false;if(!this._getProposedItemText()||this.isMobileDevice()){return}if(this.getShowSuggestion()&&this._bAfterOpenFinisihed){this.setSelectionUpdatedFromList(true)}else{var g=this.getSuggestionItems().filter(function(e){return e.getText()===this._getProposedItemText()}.bind(this))[0];if(g){this.setSelectionItem(g,true);this.selectText(0,0)}}};U.prototype.onmousedown=function(e){if(this._isSuggestionsPopoverOpen()){e.stopPropagation()}};["onsapup","onsapdown","onsappageup","onsappagedown","onsaphome","onsapend"].forEach(function(e){U.prototype[e]=function(t){if((e==="onsapup"||e==="onsapdown")&&this.isComposingCharacter()){return}if(this.getShowSuggestion()){this._getSuggestionsPopover().handleListNavigation(this,t);if(this._isIncrementalType()){t.setMarked()}this.setSelectionUpdatedFromList(true)}}});U.prototype.setSelectionUpdatedFromList=function(e){this._bSelectionUpdatedFromList=e};U.prototype.getSelectionUpdatedFromList=function(){return this._bSelectionUpdatedFromList};U.prototype.updateSelectionFromList=function(e){if(this._hasTabularSuggestions()&&this.getSelectedRow()!==e){this.setSelectionRow(e,true)}else{var t=R.getItemByListItem(this.getSuggestionItems(),e);t&&this.getSelectedItem()!==t.getId()&&this.setSelectionItem(t,true)}this.setSelectionUpdatedFromList(false)};U.prototype._deregisterEvents=function(){this._deregisterPopupResize();if(this.isMobileDevice()&&this._getSuggestionsPopover()&&this._getSuggestionsPopover().getPopover()){this.$().off("click")}};U.prototype.updateSuggestionItems=function(){this._bSuspendInvalidate=true;this.updateAggregation("suggestionItems");this._synchronizeSuggestions();this._bSuspendInvalidate=false;return this};U.prototype.invalidate=function(){if(!this._bSuspendInvalidate){e.prototype.invalidate.apply(this,arguments)}};U.prototype.cancelPendingSuggest=function(){if(this._iSuggestDelay){clearTimeout(this._iSuggestDelay);this._iSuggestDelay=null}};U.prototype._triggerSuggest=function(e){var t=this._getSuggestionsPopover().getItemsContainer();this.cancelPendingSuggest();this._bShouldRefreshListItems=true;if(!e){e=""}if(e.length>=this.getStartSuggestion()){this._iSuggestDelay=setTimeout(function(){if(this._sPrevSuggValue!==e){this._bBindingUpdated=false;this.fireSuggest({suggestValue:e});if(!this._bBindingUpdated){this._refreshItemsDelayed()}this._sPrevSuggValue=e}}.bind(this),300)}else if(this.isMobileDevice()){if(t instanceof g){t.addStyleClass("sapMInputSuggestionTableHidden")}else if(t&&t.destroyItems){t.destroyItems()}}else if(this._isSuggestionsPopoverOpen()){setTimeout(function(){var e=this.getDOMValue()||"";if(e.length<this.getStartSuggestion()){this._closeSuggestionPopup()}}.bind(this),0)}};U.prototype._shouldTriggerSuggest=function(){return!this._bPopupHasFocus&&!this.getStartSuggestion()&&!this.getValue()&&this.getShowSuggestion()};U.prototype.onchange=function(e){if(this.getShowValueHelp()||this.getShowSuggestion()||this.getProperty("effectiveShowClearIcon")){return}this.onChange(e)};U.prototype.oninput=function(t){e.prototype.oninput.call(this,t);if(t.isMarked("invalid")){return}var s=this.getDOMValue(),i,o,n;if(this.getValueLiveUpdate()){this.setProperty("value",s,true)}this.fireLiveChange({value:s,newValue:s});this.addStyleClass("sapMFocus");if(this.getShowSuggestion()&&!this.isMobileDevice()){i=this._getSuggestionsPopover();o=i.getItemsContainer();this._triggerSuggest(s);if(o&&!i.getValueStateActiveState()){n=o&&o.getSelectedItem();o.removeStyleClass("sapMListFocus");n&&n.removeStyleClass("sapMLIBFocused")}else if(i.getValueStateActiveState()&&document.activeElement.tagName!=="A"){i._getValueStateHeader().removeStyleClass("sapMPseudoFocus")}}this._handleTypeAhead(this)};U.prototype.onkeydown=function(e){this._bBackspaceOrDelete=e.which===V.BACKSPACE||e.which===V.DELETE;this._bDoTypeAhead=!h.os.android&&this.getAutocomplete()&&!this._bBackspaceOrDelete;if(this.areHotKeysPressed(e)&&this._isSuggestionsPopoverOpen()){var t=this._getSuggestionsPopover();t.setValueStateActiveState(true);t._handleValueStateLinkNav(this,e);t.updateFocus(this,null)}};U.prototype.onkeyup=function(e){var t=this.getValue();var s=this.getLastValue();var i=e.which===V.ARROW_DOWN||e.which===V.ARROW_UP;var o,n,r;if(!this._bDoTypeAhead&&!t){this.getShowSuggestion()&&this.setSelectedKey(null);s!==t&&this.setLastValue(s)}else if(!this._bDoTypeAhead&&!i&&t){o=this.getShowSuggestion()&&this._getSuggestionsPopover();n=o&&o.getItemsContainer();r=n&&n.getSelectedItem();this._setProposedItemText(null);if(r){r.setSelected(false)}}this.getShowClearIcon()&&this.setProperty("effectiveShowClearIcon",!!t)};U.prototype.getValue=function(){return this.getDomRef("inner")&&this._$input?this.getDOMValue():this.getProperty("value")};U.prototype._refreshItemsDelayed=function(){clearTimeout(this._iRefreshListTimeout);this._iRefreshListTimeout=setTimeout(this._refreshListItems.bind(this),0)};U.prototype._clearSuggestionPopupItems=function(){var e=this._getSuggestionsPopover().getItemsContainer();if(!e){return}if(e instanceof g){e.removeSelections(true)}else{e.destroyItems()}};U.prototype._hideSuggestionPopup=function(){var e=this._getSuggestionsPopover(),t=e.getPopover(),s=e.getItemsContainer();if(!this.isMobileDevice()){if(this._isSuggestionsPopoverOpen()){this._sCloseTimer=setTimeout(function(){this.cancelPendingSuggest();if(this._getTypedInValue()){this.setDOMValue(this._getTypedInValue())}t.close()}.bind(this),0)}}else if(this._hasTabularSuggestions()&&s){s.addStyleClass("sapMInputSuggestionTableHidden")}this.$("SuggDescr").text("");this.$("inner").removeAttr("aria-activedescendant")};U.prototype._openSuggestionPopup=function(e){if(!this.isMobileDevice()){if(this._sCloseTimer){clearTimeout(this._sCloseTimer);this._sCloseTimer=null}if(!this._isSuggestionsPopoverOpen()&&!this._sOpenTimer&&e!==false&&this.getShowSuggestion()){this._sOpenTimer=setTimeout(function(){this._sOpenTimer=null;this._getSuggestionsPopover()&&this._openSuggestionsPopover()}.bind(this),0)}}};U.prototype._applySuggestionAcc=function(e){var t="",s=this._oRb;setTimeout(function(){if(!this.getSuggestionItems().length&&!this._hasTabularSuggestions()){return this.$("SuggDescr").text("")}if(e===1){t=s.getText("INPUT_SUGGESTIONS_ONE_HIT")}else if(e>1){t=s.getText("INPUT_SUGGESTIONS_MORE_HITS",[e])}else{t=s.getText("INPUT_SUGGESTIONS_NO_HIT")}this.$("SuggDescr").text(t)}.bind(this),0)};U.prototype._refreshListItems=function(){var e=this.getShowSuggestion(),t=this._bDoTypeAhead?this._getTypedInValue():this.getDOMValue()||"",s,i;if(!e||!this._bShouldRefreshListItems||!this.getDomRef()||!this.isMobileDevice()&&!this.$().hasClass("sapMInputFocused")){return null}this._clearSuggestionPopupItems();if(t.length<this.getStartSuggestion()){this._hideSuggestionPopup();return false}s=this._getFilteredSuggestionItems(t);i=s.items.length;var o=i>0;o=o&&!this.getValueHelpOnly();if(o){this._openSuggestionPopup(this.getValue().length>=this.getStartSuggestion())}else{this._hideSuggestionPopup()}this._applySuggestionAcc(i)};U.prototype.addSuggestionItem=function(e){this.addAggregation("suggestionItems",e,true);this._synchronizeSuggestions();this._createSuggestionPopupContent();return this};U.prototype.updateSuggestionRows=function(){this._bSuspendInvalidate=true;this.updateAggregation("suggestionRows");this._synchronizeSuggestions();this._bSuspendInvalidate=false;return this};U.prototype.insertSuggestionItem=function(e,t){this.insertAggregation("suggestionItems",t,e,true);this._synchronizeSuggestions();this._createSuggestionPopupContent();return this};U.prototype.removeSuggestionItem=function(e){var t=this.removeAggregation("suggestionItems",e,true);this._synchronizeSuggestions();return t};U.prototype.removeAllSuggestionItems=function(){var e=this.removeAllAggregation("suggestionItems",true);this._synchronizeSuggestions();return e};U.prototype.destroySuggestionItems=function(){this.destroyAggregation("suggestionItems",true);this._synchronizeSuggestions();return this};U.prototype.bindAggregation=function(){if(arguments[0]==="suggestionRows"||arguments[0]==="suggestionColumns"||arguments[0]==="suggestionItems"){this._createSuggestionPopupContent(arguments[0]==="suggestionRows"||arguments[0]==="suggestionColumns");this._bBindingUpdated=true}return e.prototype.bindAggregation.apply(this,arguments)};U.prototype._closeSuggestionPopup=function(){this._bShouldRefreshListItems=false;this.cancelPendingSuggest();this._isSuggestionsPopoverOpen()&&this._getSuggestionsPopover().getPopover().close();if(!this.isMobileDevice()&&this.$().hasClass("sapMInputFocused")){this.openValueStateMessage()}this.$("SuggDescr").text("");this.$("inner").removeAttr("aria-activedescendant");this._sPrevSuggValue=null};U.prototype._synchronizeSuggestions=function(){var e=this._getSuggestionsPopover(),t=e&&e.getInput(),s=t&&t.getFocusDomRef();if(document.activeElement===this.getFocusDomRef()||document.activeElement===s){this._bShouldRefreshListItems=true;this._refreshItemsDelayed()}if(!this.getDomRef()||this._isSuggestionsPopoverOpen()){return}this._synchronizeSelection()};U.prototype._synchronizeSelection=function(){var e=this.getSelectedKey();if(!e){return}if(this.getValue()&&!this.getSelectedItem()&&!this.getSelectedRow()){return}this.setSelectedKey(e)};U.prototype.onfocusin=function(t){e.prototype.onfocusin.apply(this,arguments);this.addStyleClass("sapMInputFocused");if(!this.isMobileDevice()&&this._isSuggestionsPopoverOpen()){this.closeValueStateMessage()}if(this._shouldTriggerSuggest()){this._triggerSuggest(this.getValue())}this._bPopupHasFocus=undefined;this._sPrevSuggValue=null};U.prototype.oncompositionend=function(t){e.prototype.oncompositionend.apply(this,arguments);if(!h.browser.firefox){this._handleTypeAhead(this)}};U.prototype._getEffectiveTypeAhead=function(){var e=this._getSuggestionsPopover();var t=e&&e.getInput();if(!this.isMobileDevice()||this._bDoTypeAhead!==null){return this._bDoTypeAhead&&document.activeElement===this.getFocusDomRef()}return t._bDoTypeAhead&&(!!t&&document.activeElement===t.getFocusDomRef())};U.prototype._handleTypeAhead=function(e){var t=this.getValue();var s=e.getFocusDomRef();var i={value:"",selectedItem:null};var o;var n=e._getSuggestionsPopover()&&e._getSuggestionsPopover().getItemsContainer();var r=this._getEffectiveTypeAhead();if(s.selectionStart!==s.selectionEnd){this._setTypedInValue(s.value.substring(0,s.selectionStart))}else{this._setTypedInValue(s.value)}if((e&&e.getValue().toLowerCase())===(this._getProposedItemText()&&this._getProposedItemText().toLowerCase())){return}e._setProposedItemText(null);if(!r){return}var u=e._hasTabularSuggestions(),a=u?e.getSuggestionRows():e.getSuggestionItems(),g=function(t){if(!t){return""}return u?e._getRowResultFunction()(t):t.getText()};if(this.isMobileDevice()&&n&&!a.length){o={onBeforeRendering:function(){if(n.getItems().length){this._handleTypeAhead(e)}},onAfterRendering:function(){if(n.getItems().length){n.removeDelegate(o)}}};n.addDelegate(o,this);return}var l=P(t,this,a,function(e){return this._formatTypedAheadValue(g(e))}.bind(this));i.value=g(l[0]);i.selectedItem=l[0];e._setProposedItemText(i.value);this._mTypeAheadInfo=i;return i};U.prototype._resetTypeAhead=function(e){e=e||this;e._setProposedItemText(null);this._setTypedInValue("")};U.prototype.onsapright=function(){var e=this.getValue(),t=this.getFocusDomRef();if(!this.getAutocomplete()){return}if(this._getTypedInValue()!==e){this._setTypedInValue(t.value.substring(0,t.selectionStart));this.fireLiveChange({value:e,newValue:e})}};U.prototype._formatTypedAheadValue=function(e){var t=this._getTypedInValue();if(e.toLowerCase().indexOf(t.toLowerCase())===0){return t.concat(e.substring(t.length,e.length))}else{return e}};U.prototype.onsapshow=function(e){if(!this.getEnabled()||!this.getEditable()||!this.getShowValueHelp()){return}this.bValueHelpRequested=true;this._fireValueHelpRequest(false);e.preventDefault();e.stopPropagation()};U.prototype.onsaphide=U.prototype.onsapshow;U.prototype.onsapselect=function(e){this._fireValueHelpRequestForValueHelpOnly()};U.prototype.onfocusout=function(t){e.prototype.onfocusout.apply(this,arguments);this.removeStyleClass("sapMInputFocused");this.$("SuggDescr").text("")};U.prototype._hasTabularSuggestions=function(){return!!(this.getAggregation("suggestionColumns")&&this.getAggregation("suggestionColumns").length)};U.prototype._getSuggestionsTable=function(){if(this._bIsBeingDestroyed){return null}if(!this._oSuggestionsTable){this._oSuggestionsTable=this._createSuggestionsTable()}return this._oSuggestionsTable};U.prototype._destroySuggestionsTable=function(){if(this._oSuggestionsTable){this._oSuggestionsTable.destroy();this._oSuggestionsTable=null}};U.prototype._createSuggestionsTable=function(){var e;var t=new g(this.getId()+"-popup-table",{mode:E.SingleSelectMaster,showNoData:false,showSeparators:this.getProperty("separateSuggestions")?B.Inner:B.None,width:"100%",enableBusyIndicator:false,rememberSelections:false,itemPress:function(e){if(h.system.desktop){this.focus()}var t=e.getParameter("listItem");this.setSelectionRow(t,true)}.bind(this),sticky:[l.Sticky.ColumnHeaders]});t.addEventDelegate({onAfterRendering:function(){var e;if(!this.getEnableSuggestionsHighlighting()){return}e=t.$().find("tbody .sapMText, tbody .sapMLabel");T(e,this._getTypedInValue())}},this);if(this.isMobileDevice()){t.addStyleClass("sapMInputSuggestionTableHidden")}t.updateItems=function(){g.prototype.updateItems.apply(this,arguments);this._refreshItemsDelayed();return this};e=new L(function(e){var t=e.mutation;var s=e.child;var i=e.name==="items";switch(t){case"insert":if(i){s.setType(O.Active);this._createSuggestionPopupContent(true);this._synchronizeSuggestions()}break;case"remove":if(i){this._synchronizeSuggestions()}break;default:break}}.bind(this));e.observe(t,{aggregations:["items","columns"]});return t};U.prototype.clone=function(){var t=e.prototype.clone.apply(this,arguments);t.setRowResultFunction(this._fnRowResultFilter);t.setValue(this.getValue());return t};U.prototype.setValue=function(t){this._iSetCount++;e.prototype.setValue.call(this,t);this._onValueUpdated(t);this._setTypedInValue("");this.setProperty("effectiveShowClearIcon",!!t);return this};U.prototype.setDOMValue=function(e){this._$input.val(e)};U.prototype.getDOMValue=function(){return this._$input.val()};U.prototype._getInputValue=function(){var t=e.prototype._getInputValue.apply(this,arguments);return t};U.prototype.updateInputField=function(e){if(this._isSuggestionsPopoverOpen()&&this.isMobileDevice()){this._getSuggestionsPopover().getInput().setValue(e)._doSelect()}else{e=this._getInputValue(e);this.setDOMValue(e);this.onChange(null,null,e)}};U.prototype.getAccessibilityInfo=function(){var t=e.prototype.getAccessibilityInfo.apply(this,arguments);t.description=((t.description||"")+" "+this.getDescription()).trim();return t};U.prototype.preventChangeOnFocusLeave=function(e){return this.bFocusoutDueRendering||this.bValueHelpRequested};U.prototype._getShowMoreButton=function(){return this._getSuggestionsPopover().getShowMoreButton()};U.prototype._getShowMoreButtonPress=function(){var e,t=this._getTypedInValue();if(this.getShowTableSuggestionValueHelp()){if(t){e=t;this.updateDomValue(e);this._resetTypeAhead();this._setTypedInValue(e)}this._fireValueHelpRequest(true);this._closeSuggestionPopup()}};U.prototype._addShowMoreButton=function(){var e=this._getSuggestionsPopover();var t=e&&e.getPopover();if(!t||!this._hasTabularSuggestions()||this._getShowMoreButton()){return}var s=new S({text:this._oRb.getText("INPUT_SUGGESTIONS_SHOW_ALL"),press:this._getShowMoreButtonPress.bind(this)});if(t.isA("sap.m.Dialog")){e.setShowMoreButton(s)}else{e.setShowMoreButton(new f({content:[new d,s]}))}};U.prototype._removeShowMoreButton=function(){var e=this._getSuggestionsPopover();var t=e&&e.getPopover();if(t&&this._hasTabularSuggestions()&&this._getShowMoreButton()){e.removeShowMoreButton()}};U.prototype._hasShowSelectedButton=function(){return false};U.prototype._createSuggestionPopupContent=function(e){var t=this._getSuggestionsPopover();var s=t.getItemsContainer();if(s&&(s.isA("sap.m.Table")&&!e||s.isA("sap.m.List")&&e)){s.destroy();s=null;this._destroySuggestionsTable()}if(this._bIsBeingDestroyed||!t||s){return}t.initContent(this.getId(),e?this._getSuggestionsTable():null);if(!this._hasTabularSuggestions()&&!e){this._decorateSuggestionsPopoverList(t.getItemsContainer())}else{this._decorateSuggestionsPopoverTable()}};U.prototype._decorateSuggestionsPopoverList=function(e){if(!e||!e.isA("sap.m.List")){return}e.addEventDelegate({onAfterRendering:function(){var t,s;if(!this.getEnableSuggestionsHighlighting()){return}t=e.$().find(".sapMSLIInfo [id$=-infoText], .sapMSLITitleOnly [id$=-titleText]");s=this._bDoTypeAhead?this._getTypedInValue():this.getValue();s=(s||"").toLowerCase();T(t,s)}},this);e.attachItemPress(function(e){if(h.system.desktop){this.focus()}var t=e.getParameter("listItem");if(!t.isA("sap.m.GroupHeaderListItem")){this.setSelectionItem(R.getItemByListItem(this.getSuggestionItems(),t),true)}},this)};U.prototype._decorateSuggestionsPopoverTable=function(){if(this.getShowTableSuggestionValueHelp()){this._addShowMoreButton()}};U.prototype._decoratePopupInput=function(e){if(!e){return}e.setValueLiveUpdate(true);e.setValueState(this.getValueState());e.setShowValueHelp(this.getShowValueHelp());e.attachValueHelpRequest(function(){this.fireValueHelpRequest({fromSuggestions:true});this._getSuggestionsPopover().iPopupListSelectedIndex=-1;this._closeSuggestionPopup()}.bind(this));e.attachLiveChange(function(e){var t=e.getParameter("newValue");this.setDOMValue(this._getInputValue(this._getSuggestionsPopover().getInput().getValue()));this._triggerSuggest(t);this.fireLiveChange({value:t,newValue:t})}.bind(this));e._handleTypeAhead=function(){U.prototype._handleTypeAhead.call(e,this)}.bind(this);e._resetTypeAhead=function(){U.prototype._resetTypeAhead.call(e,this)}.bind(this);e.addEventDelegate({onsapenter:function(){this.setValue(this._getProposedItemText())}},this);return e};U.prototype.forwardEventHandlersToSuggPopover=function(e){e.setOkPressHandler(this._closeSuggestionPopup.bind(this));e.setCancelPressHandler(this._revertPopupSelection.bind(this))};U.prototype._revertPopupSelection=function(){var e=this._getSuggestionsPopover(),t=e&&e.getInput();this._setProposedItemText(null);this.setSelectionUpdatedFromList(false);if(this.isMobileDevice()){t&&t.setDOMValue(this.getLastValue())}this._closeSuggestionPopup()};U.prototype._getSuggestionsPopover=function(){return this._oSuggPopover};U.prototype._createSuggestionsPopover=function(){var e=this._oSuggPopover=new c(this);e.decorateParent(this);e.setInputLabels(this.getLabels.bind(this));this._createSuggestionsPopoverPopup();this.forwardEventHandlersToSuggPopover(e);e.attachEvent(c.M_EVENTS.SELECTION_CHANGE,function(e){var t=e.getParameter("newItem"),s=this.calculateNewValue(t),i=t&&t.isA("sap.m.GroupHeaderListItem"),o=this.getFocusDomRef(),n=o&&o.value.substring(0,o.selectionStart),r=e.getParameter("previousItem"),u=r&&r.isA("sap.m.GroupHeaderListItem"),a=A(C(o,u),s,n,u);if(!t||i){this.setDOMValue(n)}else{this.setDOMValue(s);a=a===0&&s.indexOf(n)===0?n.length:a;this._doSelect(a)}this._sSelectedSuggViaKeyboard=s},this);if(this.getShowTableSuggestionValueHelp()){this._addShowMoreButton()}return this._oSuggPopover};U.prototype.calculateNewValue=function(e){if(!e||e&&e.isA("sap.m.GroupHeaderListItem")){return""}if(e.isA("sap.m.ColumnListItem")){return this._getInputValue(this._getRowResultFunction()(e))}if(e.isA("sap.m.StandardListItem")){return this._getInputValue(e.getTitle())}};U.prototype._createSuggestionsPopoverPopup=function(){var e=this._getSuggestionsPopover();var t;e.createSuggestionPopup(this,{showSelectedButton:this._hasShowSelectedButton()},U);this._decoratePopupInput(e.getInput());t=e.getPopover();t.attachBeforeOpen(function(){this.closeValueStateMessage();this._updateSuggestionsPopoverValueState()},this);t.attachBeforeClose(function(){this._updateSuggestionsPopoverValueState()},this);t.attachAfterOpen(function(){var e;var t=this.getShowSuggestion()&&this._getSuggestionsPopover();var s=t&&t.getItemsContainer();var i;e=this._handleTypeAhead(this);if(!(this._getProposedItemText()&&s&&!s.getSelectedItem()&&e&&e.selectedItem)){return}i=this._hasTabularSuggestions()?e.selectedItem:R.getListItem(e.selectedItem);i.setSelected(true);this.setSelectionUpdatedFromList(true)},this);if(this.isMobileDevice()){t.attachBeforeClose(function(){this.setDOMValue(this._getInputValue(e.getInput().getValue()));this.onChange()},this).attachAfterClose(function(){var t=e.getItemsContainer();if(!t){return}var s=t&&t.getSelectedItem();if(this._getProposedItemText()&&s){this.setSelectionUpdatedFromList(true)}if(this.getSelectionUpdatedFromList()){this.updateSelectionFromList(s)}if(g&&!(t instanceof g)){t.destroyItems()}else{t.removeSelections(true)}},this).attachAfterOpen(function(){this._triggerSuggest(this.getValue());this._refreshListItems()},this).attachBeforeOpen(function(){var t=e.getInput();["placeholder","maxLength","value","showClearIcon","effectiveShowClearIcon"].forEach(function(e){t.setProperty(e,this.getProperty(e))},this)},this)}else{t.attachAfterClose(function(){const t=e.getItemsContainer();const s=this._getSuggestionsPopover();const i=s?.getItemsContainer()?.getSelectedItem();const o=this.getDomRef();const n=i?.getTitle?.()||i?.getCells?.()[0]?.getText?.()||"";const r=!!this._iSuggestDelay&&!n.toLowerCase().includes(this.getValue().toLowerCase());if(r){return}if(this.getSelectionUpdatedFromList()){this.updateSelectionFromList(i)}if(!t){return}this._bAfterOpenFinisihed=false;if(t instanceof g){i?.removeStyleClass("sapMLIBFocused");t.removeSelections(true)}else{t.destroyItems()}this._deregisterPopupResize();if(o&&o.contains(document.activeElement)){this.addStyleClass("sapMFocus")}s.getPopover().getDomRef().removeAttribute("aria-describedby")},this).attachBeforeOpen(function(){e._sPopoverContentWidth=this.getMaxSuggestionWidth();e.resizePopup(this);this._registerPopupResize();this._bAfterOpenFinisihed=false},this);t.addEventDelegate({onAfterRendering:function(){var t=this.getDomRef().getBoundingClientRect().width;var s=getComputedStyle(this.getDomRef()).getPropertyValue("--sPopoverMaxWidth");this._bAfterOpenFinisihed=true;if(this.getMaxSuggestionWidth()){return}if(t<=parseInt(s)&&!h.system.phone){e.getPopover().addStyleClass("sapMSuggestionPopoverDefaultWidth")}else{e.getPopover().getDomRef().style.setProperty("max-width",t+"px");e.getPopover().addStyleClass("sapMSuggestionPopoverInputWidth")}e.getPopover().getDomRef().style.setProperty("min-width",t+"px")}},this)}this.setAggregation("_suggestionPopup",t);this._oSuggestionPopup=t};U.prototype._registerPopupResize=function(){var e=this._getSuggestionsPopover();this._sPopupResizeHandler=_.register(this,e.resizePopup.bind(e,this))};U.prototype._deregisterPopupResize=function(){if(this._sPopupResizeHandler){this._sPopupResizeHandler=_.deregister(this._sPopupResizeHandler)}};U.prototype.showItems=function(e){var t,s,i=this._getFilterFunction(),o=!this.getEnabled()||!this.getEditable();o=o||this.getValueHelpOnly();if(o){return}this.setFilterFunction(e||function(){return true});this._clearSuggestionPopupItems();t=this._getFilteredSuggestionItems(this.getDOMValue());s=t.items.length;if(s>0){this._openSuggestionPopup()}else{this._hideSuggestionPopup()}this._applySuggestionAcc(s);this.setFilterFunction(i)};U.prototype.shouldValueStateMessageBeOpened=function(){var t=e.prototype.shouldValueStateMessageBeOpened.apply(this,arguments);if(!t||this._isSuggestionsPopoverOpen()){return false}return true};U.prototype._isSuggestionsPopoverOpen=function(){return this._getSuggestionsPopover()&&this._getSuggestionsPopover().isOpen()};U.prototype.isMobileDevice=function(){return h.system.phone};U.prototype._openSuggestionsPopover=function(){this.closeValueStateMessage();this._updateSuggestionsPopoverValueState();this._getSuggestionsPopover().getPopover().open()};U.prototype._updateSuggestionsPopoverValueState=function(e){var t=this._getSuggestionsPopover();if(!t){return}var s=this.getValueState(),i=this.getValueState()!==t._getValueStateHeader().getValueState(),o=this.getFormattedValueStateText(),n=this.getValueStateText();if(this._isSuggestionsPopoverOpen()&&!o&&!i){this.setFormattedValueStateText(t._getValueStateHeader().getFormattedText())}t.updateValueState(s,o||n,this.getShowValueStateMessage(),e);if(this.isMobileDevice()){t.getInput().setValueState(s)}};U.prototype.setShowValueHelp=function(e){var t=this._getSuggestionsPopover()&&this._getSuggestionsPopover().getInput();this.setProperty("showValueHelp",e);if(t){t.setShowValueHelp(e)}return this};U.prototype.isValueHelpOnlyOpener=function(e){return true};U.prototype._getFilteredSuggestionItems=function(e){var t,s=this._getSuggestionsPopover(),i=s.getItemsContainer(),o=s&&s.getInput(),n=false;if(this.isMobileDevice()){n=!o._getProposedItemText()&&!o._mTypeAheadInfo||o._mTypeAheadInfo&&!o._mTypeAheadInfo.value}else{n=this._getProposedItemText()&&!this._mTypeAheadInfo||this._mTypeAheadInfo&&!this._mTypeAheadInfo.value}if(n){this._handleTypeAhead(this)}if(this._hasTabularSuggestions()){if(this.isMobileDevice()&&i){i.removeStyleClass("sapMInputSuggestionTableHidden")}t=this.filterTabularItems(this.getSuggestionRows(),e)}else{t=w(this,this.getSuggestionItems(),e,this.getFilterSuggests(),true,this._getFilterFunction());this._mapItems(t)}return t};U.prototype.filterTabularItems=function(e,t){var s,i=this.getFilterSuggests(),o=[],n=[],r=false,u=this._getFilterFunction();e.forEach(function(e){if(e.isA("sap.m.GroupHeaderListItem")){n.push({header:e,visible:false})}else{s=!i||u(t,e);e.setVisible(s);s&&o.push(e);if(!r&&s&&this._getProposedItemText()===this._getRowResultFunction()(e)){e.setSelected(true);r=true}if(n.length&&s){n[n.length-1].visible=true}}},this);n.forEach(function(e){e.header.setVisible(e.visible)});this._getSuggestionsTable().invalidate();return{items:o,groups:n}};U.prototype._mapItems=function(e){var t=this.getSuggestionItems(),s=e.items,i=e.groups,o=i.map(function(e){return e.header}),n=false,r=this._getSuggestionsPopover().getItemsContainer(),u,a;t.filter(function(e){return s.indexOf(e)>-1||o.indexOf(e)>-1}).map(function(e){u=R.createListItemFromCoreItem(e,true);r.addItem(u);if(!n&&this._getProposedItemText()===e.getText()){u.setSelected(true);n=true}return e},this).filter(function(e){return o.indexOf(e)>-1}).forEach(function(e){a=o.indexOf(e);if(a>-1){u=R.getListItem(e);u&&u.setVisible(i[a].visible)}})};U.prototype._setTypedInValue=function(e){this._sTypedInValue=e;return this};U.prototype._getTypedInValue=function(){return this._sTypedInValue};U.prototype._setSeparateSuggestions=function(e){var t=this._getSuggestionsTable();this.setProperty("separateSuggestions",e);if(t){t.setShowSeparators(e?B.Inner:B.None)}return this};U.prototype._setProposedItemText=function(e){this._sProposedItemText=e;return this};U.prototype._getProposedItemText=function(){return this._sProposedItemText};U.prototype._getToolbarInteractive=function(){return true};return U});
//# sourceMappingURL=Input.js.map