/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/ControlBehavior","./library","sap/ui/Device","sap/ui/core/InvisibleText","sap/ui/core/InvisibleRenderer","sap/ui/core/Configuration","sap/ui/core/Lib"],function(e,t,n,i,r,s,a){"use strict";var o=t.ListType;var d=t.ListMode;var l={apiVersion:2};l.renderInvisible=function(e,t){r.render(e,t,t.TagName)};l.renderHighlight=function(e,t){var n=t.getHighlight();if(n=="None"){return}e.openStart("div");e.class("sapMLIBHighlight");e.class("sapMLIBHighlight"+n);e.openEnd();e.close("div")};l.isModeMatched=function(e,t){var n=(sap.ui.require("sap/m/ListBaseRenderer")||{}).ModeOrder||{};return n[e]==t};l.renderMode=function(e,t,n){var i=t.getMode();if(!this.isModeMatched(i,n)){return}var r=t.getModeControl(true);if(r){this.renderModeContent(e,t,r)}};l.renderModeContent=function(e,t,n){this.decorateMode(n,t);e.renderControl(n)};l.decorateMode=function(t,n){t.removeStyleClass("sapMLIBSelectAnimation sapMLIBUnselectAnimation");if(e.getAnimationMode()===s.AnimationMode.none||!n.getListProperty("modeAnimationOn")){return}var i=n.getMode(),r=n.getListProperty("lastMode");if(!r||r==i){return}if(i==d.None){t.addStyleClass("sapMLIBUnselectAnimation")}else{t.addStyleClass("sapMLIBSelectAnimation")}};l.renderCounter=function(e,t){var n=t.getCounter();if(n){this.renderCounterContent(e,t,n)}};l.renderCounterContent=function(e,t,n){e.openStart("div",t.getId()+"-counter");e.attr("aria-label",a.getResourceBundleFor("sap.m").getText("LIST_ITEM_COUNTER",[n]));e.class("sapMLIBCounter");e.openEnd();e.text(n);e.close("div")};l.renderType=function(e,t){var n=t.getTypeControl(true);if(n){e.renderControl(n)}};l.openItemTag=function(e,t){e.openStart(t.TagName,t)};l.closeItemTag=function(e,t){e.close(t.TagName)};l.renderTabIndex=function(e,t){e.attr("tabindex","-1")};l.renderTooltip=function(e,t){var n=t.getTooltip_AsString();if(n){e.attr("title",n)}};l.addFocusableClasses=function(e,t){if(n.system.desktop){e.class("sapMLIBFocusable");this.addLegacyOutlineClass(e,t)}};l.addLegacyOutlineClass=function(e,t){};l.getAriaAnnouncement=function(e,t){return i.getStaticId("sap.m",t||"LIST_ITEM_"+e.toUpperCase())};l.getAriaRole=function(e){if(e.isGroupHeader()){return"listitem"}var t=e.getList();return t&&t.getAriaRole()=="listbox"?"option":"listitem"};l.getAriaLabelledBy=function(e){if(!e.getContentAnnouncement&&e.getAriaLabelledBy().length){return e.getId()}};l.getAriaDescribedBy=function(e){if(e.getContentAnnouncement){return""}var t=[],n=e.getType();if(e.getListProperty("showUnread")&&e.getUnread()){t.push(this.getAriaAnnouncement("unread"))}if(e.getMode()==d.Delete){t.push(this.getAriaAnnouncement("delete"))}if(n==o.Navigation){t.push(this.getAriaAnnouncement("navigation"))}else{if(n==o.Detail||n==o.DetailAndActive){t.push(this.getAriaAnnouncement("detail"))}if(n==o.Active||n==o.DetailAndActive){t.push(this.getAriaAnnouncement("active"))}}return t.join(" ")};l.getAccessbilityPosition=function(e){var t=e.getList();return t&&t.getAccessbilityPosition&&t.getAccessbilityPosition(e)};l.getAccessibilityState=function(e){var t=this.getAriaLabelledBy(e),n=this.getAriaDescribedBy(e),i=this.getAriaRole(e),r=true,s={role:i};if(t){s.labelledby={value:t.trim(),append:true}}if(n){s.describedby={value:n.trim(),append:true}}if(e.getNavigated()){s.current=true}if(i==="listitem"){s.selected=null;if(e.isGroupHeader()){r=false;s.role="group";s.roledescription=a.getResourceBundleFor("sap.m").getText("LIST_ITEM_GROUP_HEADER");var o=e.getGroupedItems();if(o&&o.length){s.owns=o.join(" ")}}}else if(e.isSelectable()){s.selected=e.getSelected()}if(r){var d=this.getAccessbilityPosition(e);Object.assign(s,d)}return s};l.renderLIContent=function(e,t){};l.renderLIAttributes=function(e,t){};l.renderContentFormer=function(e,t){this.renderHighlight(e,t);this.renderMode(e,t,-1)};l.renderContentLatter=function(e,t){this.renderCounter(e,t);this.renderType(e,t);this.renderMode(e,t,1);this.renderNavigated(e,t)};l.renderLIContentWrapper=function(e,t){e.openStart("div",t.getId()+"-content").class("sapMLIBContent").openEnd();this.renderLIContent(e,t);e.close("div")};l.renderNavigated=function(e,t){if(!t.getNavigated()){return}e.openStart("div");e.class("sapMLIBNavigated");e.openEnd();e.close("div")};l.render=function(t,n){if(!n.getVisible()){this.renderInvisible(t,n);return false}this.openItemTag(t,n);t.class("sapMLIB");t.class("sapMLIB-CTX");t.class("sapMLIBShowSeparator");t.class("sapMLIBType"+n.getType());if(n.isActionable(true)){t.class("sapMLIBActionable");t.class("sapMLIBHoverable")}if(n.getSelected()){t.class("sapMLIBSelected")}if(n.getListProperty("showUnread")&&n.getUnread()){t.class("sapMLIBUnread")}this.addFocusableClasses(t,n);this.renderTooltip(t,n);this.renderTabIndex(t,n);if(e.isAccessibilityEnabled()){t.accessibilityState(n,this.getAccessibilityState(n))}this.renderLIAttributes(t,n);t.openEnd();this.renderContentFormer(t,n);this.renderLIContentWrapper(t,n);this.renderContentLatter(t,n);this.closeItemTag(t,n)};return l},true);
//# sourceMappingURL=ListItemBaseRenderer.js.map