/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/ui/core/Control","./Button","./Dialog","./NavContainer","./List","./Page","./MenuListItem","sap/ui/unified/Menu","sap/ui/unified/MenuItem","sap/ui/Device","sap/ui/core/EnabledPropagator","sap/ui/thirdparty/jquery","sap/ui/core/Popup","sap/ui/base/ManagedObject","sap/ui/core/Element"],function(t,e,i,n,s,o,a,r,g,l,u,p,jQuery,h,m,d){"use strict";var _=h.Dock;var I=t.ListType;var f=t.ListMode;var c=e.extend("sap.m.Menu",{metadata:{interfaces:["sap.ui.core.IContextMenu"],library:"sap.m",properties:{title:{type:"string",group:"Misc",defaultValue:null}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.MenuItem",multiple:true,singularName:"item",bindable:"bindable"},_dialog:{type:"sap.m.Dialog",multiple:false,visibility:"hidden"},_menu:{type:"sap.ui.unified.Menu",multiple:false,visibility:"hidden"}},events:{itemSelected:{parameters:{item:{type:"sap.m.MenuItem"}}},closed:{}}},renderer:null});p.call(c.prototype);c.UNIFIED_MENU_ITEMS_ID_SUFFIX="-unifiedmenu";c.UNFIFIED_MENU_ITEMS_PROPS=l.getMetadata().getAllProperties();c.LIST_ITEMS_ID_SUFFIX="-menuinnerlist";c.MENU_LIST_ITEMS_PROPS=r.getMetadata().getAllProperties();c.prototype.init=function(){if(u.system.phone){this._initDialog()}this._bIsInitialized=false;this.attachEvent("propertyChanged",this._onPropertyChanged,this);this.attachEvent("aggregationChanged",this._onAggregationChanged,this)};c.prototype.exit=function(){if(this._navContainerId){this._navContainerId=null}if(this._bIsInitialized){this._bIsInitialized=null}if(this._getMenu()&&this._getMenu().getPopup()){this._getMenu().getPopup().detachClosed(this._menuClosed,this)}};c.prototype.invalidate=function(){};c.prototype.setTitle=function(t){var e=this._getNavContainer();this.setProperty("title",t,true);if(e&&e.getPages().length){e.getPages()[0].setTitle(t)}return this};c.prototype.openBy=function(t,e,i,n,s){if(u.system.phone){this._openDialog()}else{if(!this._bIsInitialized){this._initAllMenuItems();this._bIsInitialized=true}if(!i){i=_.BeginTop}if(!n){n=_.BeginBottom}if(!s){s="0 -2"}this._getMenu().open(e,t,i,n,t,s)}};c.prototype.close=function(){if(u.system.phone){this._getDialog()&&this._getDialog().close()}else{this._getVisualParent()&&this._getVisualParent().close()}};c.prototype.isOpen=function(){if(u.system.phone){return this._getDialog()&&this._getDialog().isOpen()}else{return this._getVisualParent()&&this._getVisualParent().isOpen()}};c.prototype._initDialog=function(){var t=new n({showHeader:false,stretch:true,content:this._initNavContainer(),buttons:[this._initCloseButton()]});t.addStyleClass("sapMRespMenuDialog");t.addStyleClass("sapUiNoContentPadding");this.setAggregation("_dialog",t,true);t.attachAfterClose(this._menuClosed,this)};c.prototype._getDialog=function(){return this.getAggregation("_dialog")};c.prototype._openDialog=function(){if(!this._bIsInitialized){this._initAllPages();this._bIsInitialized=true}this._getNavContainer().to(this._getNavContainer().getPages()[0]);this._getDialog().open()};c.prototype._initAllMenuItems=function(){this._initMenuForItems(this.getItems())};c.prototype._setCustomEnhanceAccStateFunction=function(t){this._fnEnhanceUnifiedMenuAccState=t};c.prototype._initMenuForItems=function(t,e){var i=new g;i._setCustomEnhanceAccStateFunction(this._fnEnhanceUnifiedMenuAccState);i.isCozy=this._isMenuCozy.bind(this,i);this.addStyleClass("sapMMenu");i.aCustomStyleClasses=this.aCustomStyleClasses;i.mCustomStyleClassMap=this.mCustomStyleClassMap;t.forEach(function(t){this._addVisualMenuItemFromItem(t,i)}.bind(this));if(e){e.setSubmenu(i)}else{i.getPopup().attachClosed(this._menuClosed,this);this.setAggregation("_menu",i,true)}i.attachItemSelect(this._handleMenuItemSelect,this)};c.prototype._menuClosed=function(){this.fireClosed()};c.prototype._getMenu=function(){return this.getAggregation("_menu")};c.prototype._initCloseButton=function(){var t=sap.ui.getCore().getLibraryResourceBundle("sap.m");return new i({text:t.getText("MENU_CLOSE"),press:y.bind(this)})};function y(){this._getDialog().close()}c.prototype._initNavContainer=function(){var t=new s;this._navContainerId=t.getId();return t};c.prototype._getNavContainer=function(){return sap.ui.getCore().byId(this._navContainerId)};c.prototype._initAllPages=function(){this._initPageForParent(this)};c.prototype._initPageForParent=function(t){var e=t.getItems(),i=t instanceof c,n=i?t.getTitle():t.getText(),s=new o({mode:f.None}),r=new a({title:n,showNavButton:!i,content:s});if(!i){this._setBackButtonTooltipForPageWithParent(t,r)}r.attachNavButtonPress(function(){this._getNavContainer().back()},this);this._getNavContainer().addPage(r);e.forEach(function(t){this._addListItemFromItem(t,r)},this);this._updateListInset(s);s.attachEvent("itemPress",this._handleListItemPress,this);return r};c.prototype._handleListItemPress=function(t){var e=t.getParameter("listItem"),i=sap.ui.getCore().byId(e.getMenuItem()),n=i._getVisualChild();if(n){this._getNavContainer().to(n)}else{this._getDialog().close();this.fireItemSelected({item:i})}i.firePress()};c.prototype._setBackButtonTooltipForPageWithParent=function(t,e){var i=t.getParent(),n=sap.ui.getCore().getLibraryResourceBundle("sap.m"),s;s=i instanceof c?i.getTitle():i.getText();s=n.getText("MENU_PAGE_BACK_BUTTON")+" "+s;e.setNavButtonTooltip(s)};c.prototype._createMenuListItemFromItem=function(t){var e=this._generateListItemId(t.getId()),i=d.registry.get(e);if(i){return i}i=new r({id:e,type:t.getEnabled()?I.Active:I.Inactive,icon:t.getIcon(),title:this._handleSettingsValue(t.getText()),startsSection:t.getStartsSection(),menuItem:t,tooltip:this._handleSettingsValue(t.getTooltip()),visible:t.getVisible(),enabled:t.getEnabled()});t.aDelegates.forEach(function(t){i.addEventDelegate(t.oDelegate,t.vThis)});return i};c.prototype._createVisualMenuItemFromItem=function(t){var e=this._generateUnifiedMenuItemId(t.getId()),i=d.registry.get(e),n=t.getCustomData(),s;if(i){return i}i=new l({id:e,icon:t.getIcon(),text:this._handleSettingsValue(t.getText()),startsSection:t.getStartsSection(),tooltip:this._handleSettingsValue(t.getTooltip()),visible:t.getVisible(),enabled:t.getEnabled()});for(s=0;s<n.length;s++){t._addCustomData(i,n[s])}t.aDelegates.forEach(function(t){i.addEventDelegate(t.oDelegate,t.vThis)});return i};c.prototype._addVisualMenuItemFromItem=function(t,e,i){var n=this._createVisualMenuItemFromItem(t);t._setVisualParent(e);t._setVisualControl(n);if(t.getItems().length!==0){this._initMenuForItems(t.getItems(),n);t._setVisualChild(t.getItems()[0]._getVisualParent())}if(i===undefined){e.addItem(n)}else{e.insertItem(n,i)}};c.prototype._addListItemFromItem=function(t,e,i){var n=this._createMenuListItemFromItem(t),s=e.getContent()[0];t._setVisualParent(e);t._setVisualControl(n);if(t.getItems().length!==0){this._initPageForParent(t);t._setVisualChild(t.getItems()[0]._getVisualParent())}if(i===undefined){s.addItem(n)}else{s.insertItem(n,i)}s.invalidate()};c.prototype._connectVisualItem=function(t,e,i){if(!e||sap.ui.getCore().byId(t._getVisualControl())){return}if(u.system.phone){this._addListItemFromItem(t,e,i);var n=e.getContent()[0];this._updateListInset(n)}else{this._addVisualMenuItemFromItem(t,e,i)}};c.prototype._updateListInset=function(t){var e=false,i="sapMListIcons",n=t.getItems();for(var s=0;s<n.length;s++){if(n[s].getIcon()){e=true;break}}if(e){t.addStyleClass(i)}else{t.removeStyleClass(i)}};c.prototype._handleMenuItemSelect=function(t){var e=t.getParameter("item"),i;if(!e){return}i=this._findMenuItemByUnfdMenuItem(e);if(i&&!i.getItems().length){this.fireItemSelected({item:i})}if(i){i.firePress()}};c.prototype._generateListItemId=function(t){return t+c.LIST_ITEMS_ID_SUFFIX};c.prototype._generateUnifiedMenuItemId=function(t){return t+c.UNIFIED_MENU_ITEMS_ID_SUFFIX};c.prototype._findMenuItemByUnfdMenuItem=function(t){var e=[],i=t,n,s,o;do{e.push(i.getId());i=i.getParent().getParent()}while(i instanceof l);n=this.getItems();do{s=e.pop();for(o=0;o<n.length;o++){if(n[o]._getVisualControl()===s){if(e.length===0){return n[o]}else{n=n[o].getItems();break}}}}while(e.length);return null};c.prototype._isMenuCozy=function(t){if(!t.bCozySupported){return false}if(t.hasStyleClass("sapUiSizeCozy")){return true}if(C(t.oOpenerRef)){return true}return false};function C(t){if(!t){return false}t=t.$?t.$():jQuery(t);var e=t.closest(".sapUiSizeCompact,.sapUiSizeCondensed,.sapUiSizeCozy");return!e.hasClass("sapUiSizeCompact")&&!e.hasClass("sapUiSizeCondensed")||e.hasClass("sapUiSizeCozy")}c.prototype.addAggregation=function(t,i,n){e.prototype.addAggregation.apply(this,arguments);if(t==="items"){this._connectVisualItem(i,this._getVisualParent())}return this};c.prototype.insertAggregation=function(t,i,n,s){e.prototype.insertAggregation.apply(this,arguments);if(t==="items"){this._connectVisualItem(i,this._getVisualParent(),n)}return this};c.prototype.removeAggregation=function(t,i,n){var s=e.prototype.removeAggregation.apply(this,arguments);if(t==="items"){this._removeVisualItem(s)}return s};c.prototype.removeAllAggregation=function(t,i){var n=e.prototype.removeAllAggregation.apply(this,arguments);if(t==="items"){for(var s=0;s<n.length;s++){this._removeVisualItem(n[s])}}return n};c.prototype._removeVisualItem=function(t,e){var i=sap.ui.getCore().byId(t._getVisualControl()),n;if(i){n=i.getParent();n.removeItem(i);if(u.system.phone){this._removeSubPageForItem(t);if(n.getItems().length===0){if(e){e._setVisualChild(null);sap.ui.getCore().byId(e._getVisualControl()).rerender()}}if(n){n.invalidate()}}}};c.prototype.destroyAggregation=function(t,i){if(t==="items"){for(var n=0;n<this.getItems().length;n++){this._removeVisualItem(this.getItems()[n])}}return e.prototype.destroyAggregation.apply(this,arguments)};c.prototype._removeSubPageForItem=function(t,e){var i;if(!e){for(var n=0;n<t.getItems().length;n++){this._removeSubPageForItem(t.getItems()[n])}}if(t._getVisualChild()){i=sap.ui.getCore().byId(t._getVisualChild());if(this._getNavContainer()&&i){this._getNavContainer().removePage(i)}!!i&&i.destroy()}};c.prototype._getVisualParent=function(){var t=this._getNavContainer(),e=this._getMenu();if(t&&t.getPages().length){return t.getPages()[0]}else{return e}};c.prototype._onPropertyChanged=function(t){t.cancelBubble();var e=t.getParameter("propertyKey"),i=t.getParameter("propertyValue"),n=u.system.phone?c.MENU_LIST_ITEMS_PROPS:c.UNFIFIED_MENU_ITEMS_PROPS,s=u.system.phone?this._generateListItemId:this._generateUnifiedMenuItemId,o,a;if(u.system.phone&&e==="text"){e="title"}if(!n[e]){return}o=s(t.getSource().getId());a=d.registry.get(o);if(a){a.setProperty(e,i);if(u.system.phone&&this._getDialog().isOpen()){this._getDialog().close()}}};c.prototype._onAggregationChanged=function(t){t.cancelBubble();var e=t.getParameter("aggregationName");switch(e){case"items":this._onItemsAggregationChanged(t);break;case"tooltip":this._onTooltipAggregationChanged(t);break;default:}};c.prototype._onTooltipAggregationChanged=function(t){var e=t.getSource()._getVisualControl(),i=t.getParameter("methodName"),n=t.getParameter("methodParams"),s;if(!e){return}s=sap.ui.getCore().byId(e);if(i==="set"){s.setTooltip(n.item)}if(i==="destroy"){s.destroyTooltip()}};c.prototype._onItemsAggregationChanged=function(t){var e=t.getSource(),i=t.getParameter("methodName"),n=t.getParameter("methodParams"),s;if(i==="add"||i==="insert"){if(i==="insert"){s=n.index}this._addOrInsertItem(e,n.item,s)}if(i==="remove"){this._removeVisualItem(n.item,e)}if(i==="removeall"){for(var o=0;o<n.items.length;o++){this._removeVisualItem(n.items[o],e)}}if(i==="destroy"){this._destroyItem(e)}};c.prototype._addOrInsertItem=function(t,e,i){var n;if(t._getVisualChild()){this._connectVisualItem(e,sap.ui.getCore().byId(t._getVisualChild()),i)}else{if(u.system.phone){this._initPageForParent(t);t._setVisualChild(t.getItems()[0]._getVisualParent());n=sap.ui.getCore().byId(t._getVisualControl());n&&n.invalidate()}else{this._initMenuForItems(t.getItems(),sap.ui.getCore().byId(t._getVisualControl()));t._setVisualChild(t.getItems()[0]._getVisualParent())}}};c.prototype._destroyItem=function(t){var e=sap.ui.getCore().byId(t._getVisualControl());if(e&&e.setMenuItem){e.setMenuItem(null)}this._removeSubPageForItem(t,true);t._setVisualChild(null);if(e&&e.setMenuItem){e.invalidate();e.setMenuItem(t)}};c.prototype.getDomRefId=function(){if(u.system.phone){return this._getDialog().getId()}else{return this._getMenu().getId()}};c.prototype.openAsContextMenu=function(t,e){if(u.system.phone){this._openDialog()}else{if(!this._bIsInitialized){this._initAllMenuItems();this._bIsInitialized=true}this._getMenu().openAsContextMenu(t,e)}};["addStyleClass","removeStyleClass","toggleStyleClass"].forEach(function(t){c.prototype[t]=function(i,n){var s=this._getDialog();e.prototype[t].apply(this,arguments);if(s){s[t].apply(s,arguments)}return this}});c.prototype._handleSettingsValue=function(t){if(typeof t!=="string"){return t}try{m.bindingParser(t);return t}catch{return m.escapeSettingsValue(t)}};return c});
//# sourceMappingURL=Menu.js.map