/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/ui/core/Control","./Button","./SplitButton","sap/ui/Device","sap/ui/core/EnabledPropagator","sap/ui/core/library","sap/ui/core/Popup","sap/ui/core/LabelEnablement","./MenuButtonRenderer","sap/ui/events/KeyCodes"],function(t,e,o,i,n,r,s,a,u,p,l){"use strict";var h=t.MenuButtonMode;var c=s.TextDirection;var g=t.ButtonType;var f=a.Dock;var d=["buttonMode","useDefaultActionOnly","width","menuPosition"];var y=e.extend("sap.m.MenuButton",{metadata:{interfaces:["sap.m.IToolbarInteractiveControl"],library:"sap.m",properties:{text:{type:"string",group:"Misc",defaultValue:null},type:{type:"sap.m.ButtonType",group:"Appearance",defaultValue:g.Default},width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null},enabled:{type:"boolean",group:"Behavior",defaultValue:true},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},activeIcon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconDensityAware:{type:"boolean",group:"Misc",defaultValue:true},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:c.Inherit},buttonMode:{type:"sap.m.MenuButtonMode",group:"Misc",defaultValue:h.Regular},menuPosition:{type:"sap.ui.core.Popup.Dock",group:"Misc",defaultValue:f.BeginBottom},useDefaultActionOnly:{type:"boolean",group:"Behavior",defaultValue:false}},aggregations:{menu:{type:"sap.m.Menu",multiple:false,singularName:"menu"},_button:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{defaultAction:{},beforeMenuOpen:{}},defaultAggregation:"menu",designtime:"sap/m/designtime/MenuButton.designtime",dnd:{draggable:true,droppable:false}},renderer:p});r.call(y.prototype);y.prototype.init=function(){this._initButtonControl()};y.prototype.exit=function(){if(this._sDefaultText){this._sDefaultText=null}if(this._sDefaultIcon){this._sDefaultIcon=null}if(this._lastActionItemId){this._lastActionItemId=null}if(this.getMenu()){this.getMenu().detachClosed(this._menuClosed,this)}};y.prototype.onBeforeRendering=function(){if(!this._sDefaultText){this._sDefaultText=this.getText()}if(!this._sDefaultIcon){this._sDefaultIcon=this.getIcon()}this._updateButtonControl();this._attachMenuEvents()};y.prototype._getTextBtnContentDomRef=function(){return this._getButtonControl()._getTextButton().getDomRef("content")};y.prototype.onAfterRendering=function(){if(this._activeButton){this._activeButton.$().attr("aria-expanded","false");this._activeButton=null}};y.prototype.setButtonMode=function(t){var o=this.getTooltip(),i,n;e.prototype.setProperty.call(this,"buttonMode",t,true);this._getButtonControl().destroy();this._initButtonControl();i=this._getButtonControl();n=i.getMetadata().getAllProperties();for(var r in this.mProperties){if(this.mProperties.hasOwnProperty(r)&&d.indexOf(r)<0&&n.hasOwnProperty(r)){i.setProperty(r,this.mProperties[r],true)}}if(o){i.setTooltip(o)}if(!this._isSplitButton()&&this._sDefaultText){this.setText(this._sDefaultText)}else if(!this.getUseDefaultActionOnly()&&this._getLastSelectedItem()){this.setText(sap.ui.getCore().byId(this._getLastSelectedItem()).getText())}if(!this._isSplitButton()&&this._sDefaultIcon){this.setIcon(this._sDefaultIcon)}else if(!this.getUseDefaultActionOnly()&&this._getLastSelectedItem()){this.setIcon(sap.ui.getCore().byId(this._getLastSelectedItem()).getIcon())}this.invalidate();return this};y.prototype._initButton=function(){var t=new o(this.getId()+"-internalBtn",{width:"100%",ariaHasPopup:s.aria.HasPopup.Menu});t.attachPress(this._handleButtonPress,this);t.onkeydown=this.handleKeydown;return t};y.prototype._initSplitButton=function(){var t=new i(this.getId()+"-internalSplitBtn",{width:"100%"});t.attachPress(this._handleActionPress,this);t.attachArrowPress(this._handleButtonPress,this);t._getArrowButton().onkeydown=this.handleKeydown;return t};y.prototype._initButtonControl=function(){var t;if(this._isSplitButton()){t=this._initSplitButton()}else{t=this._initButton()}this.setAggregation("_button",t,true)};y.prototype._updateButtonControl=function(){this._getButtonControl().setText(this.getText())};y.prototype._getButtonControl=function(){return this.getAggregation("_button")};y.prototype._handleButtonPress=function(t){var e=this.getMenu(),o={zero:"0 0",plus2_right:"0 +2",minus2_right:"0 -2",plus2_left:"+2 0",minus2_left:"-2 0"};this.fireBeforeMenuOpen();if(!e){return}if(this._bPopupOpen&&!t.getParameter("keyboard")){this.getMenu().close();this._bPopupOpen=false;return}if(!e.getTitle()){e.setTitle(this.getText())}var i=[this,t.getParameter("keyboard")];switch(this.getMenuPosition()){case f.BeginTop:i.push(f.BeginBottom,f.BeginTop,o.plus2_right);break;case f.BeginCenter:i.push(f.BeginCenter,f.BeginCenter,o.zero);break;case f.LeftTop:i.push(f.RightBottom,f.LeftBottom,o.plus2_left);break;case f.LeftCenter:i.push(f.RightCenter,f.LeftCenter,o.plus2_left);break;case f.LeftBottom:i.push(f.RightTop,f.LeftTop,o.plus2_left);break;case f.CenterTop:i.push(f.CenterBottom,f.CenterTop,o.plus2_left);break;case f.CenterCenter:i.push(f.CenterCenter,f.CenterCenter,o.zero);break;case f.CenterBottom:i.push(f.CenterTop,f.CenterBottom,o.minus2_right);break;case f.RightTop:i.push(f.LeftBottom,f.RightBottom,o.minus2_left);break;case f.RightCenter:i.push(f.LeftCenter,f.RightCenter,o.minus2_left);break;case f.RightBottom:i.push(f.LeftTop,f.RightTop,o.minus2_left);break;case f.EndTop:i.push(f.EndBottom,f.EndTop,o.plus2_right);break;case f.EndCenter:i.push(f.EndCenter,f.EndCenter,o.zero);break;case f.EndBottom:i.push(f.EndTop,f.EndBottom,o.minus2_right);break;case f.BeginBottom:default:i.push(f.BeginTop,f.BeginBottom,o.minus2_right);break}e.openBy.apply(e,i);if(this.getMenu()){this._bPopupOpen=true}this._writeAriaAttributes();if(this._isSplitButton()&&!n.system.phone){this._getButtonControl().setArrowState(true)}};y.prototype._handleActionPress=function(){var t=this._getLastSelectedItem(),e;if(!this.getUseDefaultActionOnly()&&t){e=sap.ui.getCore().byId(t);this.getMenu().fireItemSelected({item:e})}else{this.fireDefaultAction()}};y.prototype._menuClosed=function(){var t=this._getButtonControl(),e=t,o=this.getMenu(),i=o&&o._getMenu&&o._getMenu();if(this._isSplitButton()){t.setArrowState(false);e=t._getArrowButton()}if(i&&i._bLeavingMenu){this._bPopupOpen=false}e.$().removeAttr("aria-controls");e.$().attr("aria-expanded","false")};y.prototype._menuItemSelected=function(t){var e=t.getParameter("item");this.fireEvent("_menuItemSelected",{item:e});this._bPopupOpen=false;if(!this._isSplitButton()||this.getUseDefaultActionOnly()||!e){return}this._lastActionItemId=e.getId();!!this._sDefaultText&&this.setText(e.getText());!!this._sDefaultIcon&&this.setIcon(e.getIcon())};y.prototype._getLastSelectedItem=function(){return this._lastActionItemId};y.prototype._attachMenuEvents=function(){if(this.getMenu()){this.getMenu().attachClosed(this._menuClosed,this);this.getMenu().attachItemSelected(this._menuItemSelected,this)}};y.prototype._isSplitButton=function(){return this.getButtonMode()===h.Split};y.prototype.setProperty=function(t,o,i){function n(t){var e=[g.Up,g.Back,g.Unstyled];return e.indexOf(t)!==-1}if(t==="type"&&n(o)){return this}if(t==="text"){this._sDefaultText=o}switch(t){case"activeIcon":case"iconDensityAware":case"textDirection":case"visible":case"enabled":this._getButtonControl().setProperty(t,o);break}return e.prototype.setProperty.apply(this,arguments)};y.prototype.setTooltip=function(t){this._getButtonControl().setTooltip(t);return e.prototype.setTooltip.apply(this,arguments)};y.prototype.setText=function(t){e.prototype.setProperty.call(this,"text",t);this._getButtonControl().setText(t);return this};y.prototype.setType=function(t){e.prototype.setProperty.call(this,"type",t);this._getButtonControl().setType(t);return this};y.prototype.setIcon=function(t){e.prototype.setProperty.call(this,"icon",t);this._getButtonControl().setIcon(t);return this};y.prototype.addAriaLabelledBy=function(t){this.getAggregation("_button").addAssociation("ariaLabelledBy",t);return e.prototype.addAssociation.call(this,"ariaLabelledBy",t)};y.prototype.addAriaDescribedBy=function(t){this.getAggregation("_button").addAssociation("ariaDescribedBy",t);return e.prototype.addAssociation.call(this,"ariaDescribedBy",t)};y.prototype.removeAriaLabelledBy=function(t){this.getAggregation("_button").removeAssociation("ariaLabelledBy",t);return e.prototype.removeAssociation.call(this,"ariaLabelledBy",t)};y.prototype.removeAriaDescribedBy=function(t){this.getAggregation("_button").removeAssociation("ariaDescribedBy",t);return e.prototype.removeAssociation.call(this,"ariaDescribedBy",t)};y.prototype.removeAllAriaLabelledBy=function(t){this.getAggregation("_button").removeAllAssociation("ariaLabelledBy");return e.prototype.removeAllAssociation.call(this,"ariaLabelledBy")};y.prototype.removeAllAriaDescribedBy=function(){this.getAggregation("_button").removeAllAssociation("ariaDescribedBy");return e.prototype.removeAllAssociation.call(this,"ariaDescribedBy")};y.prototype.getFocusDomRef=function(){return this._getButtonControl().getDomRef()};y.prototype.onsapescape=function(t){var e=this.getMenu(),o=e&&e._getMenu&&e._getMenu();if(o&&this._bPopupOpen){o._bLeavingMenu=true;o.close();this._menuClosed();t.preventDefault()}};y.prototype.onsapup=function(t){this.openMenuByKeyboard();t.stopPropagation()};y.prototype.onsapdown=function(t){this.openMenuByKeyboard();t.stopPropagation()};y.prototype.onsapupmodifiers=function(t){this.openMenuByKeyboard();t.stopPropagation()};y.prototype.onsapdownmodifiers=function(t){this.openMenuByKeyboard();t.stopPropagation()};y.prototype.onsapshow=function(t){this.openMenuByKeyboard();!!t&&t.preventDefault()};y.prototype.ontouchstart=function(){this._bPopupOpen=this.getMenu()&&this.getMenu()._getMenu()&&this.getMenu()._getMenu().getPopup().isOpen()};y.prototype.handleKeydown=function(t){if((t.keyCode===l.ENTER||t.keyCode===l.TAB)&&this._bPopupOpen){this.getMenu().close();this._bPopupOpen=false}o.prototype.onkeydown.call(this,t)};y.prototype.openMenuByKeyboard=function(){if(!this._isSplitButton()){this._handleButtonPress(Object.create(null,{getParameter:{value:function(){return true}}}))}};y.prototype._writeAriaAttributes=function(){var t=this._getButtonControl(),e=this._isSplitButton()?t._getArrowButton():t,o=this.getMenu();if(o){e.$().attr("aria-controls",o.getDomRefId());e.$().attr("aria-expanded","true")}};y.prototype._getToolbarInteractive=function(){return true};y.prototype.getIdForLabel=function(){return this.getId()+"-internalBtn"};y.prototype._ensureBackwardsReference=function(){var t=this._getButtonControl(),e=t.getAriaLabelledBy(),o=u.getReferencingLabels(this);o.forEach(function(o){if(e&&e.indexOf(o)===-1){t.addAriaLabelledBy(o)}});return this};return y});
//# sourceMappingURL=MenuButton.js.map