/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/ui/core/Item","sap/ui/base/ManagedObjectObserver"],function(t,e,a){"use strict";var o=e.extend("sap.m.MenuItem",{metadata:{library:"sap.m",properties:{icon:{type:"string",group:"Appearance",defaultValue:null},visible:{type:"boolean",group:"Appearance",defaultValue:true},startsSection:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.MenuItem",multiple:true,singularName:"item",bindable:"bindable"}},events:{press:{},propertyChanged:{parameters:{propertyKey:{type:"string"},propertyValue:{type:"any"}}},aggregationChanged:{parameters:{aggregationName:{type:"string"},methodName:{type:"string"},methodParams:{type:"object"}}}}}});o.UNIFIED_MENU_ITEMS_ID_SUFFIX="-unifiedmenu";o.prototype.exit=function(){if(this._sVisualChild){this._sVisualChild=null}if(this._sVisualParent){this._sVisualParent=null}if(this._sVisualControl){this._sVisualControl=null}};o.prototype.setProperty=function(t,a){e.prototype.setProperty.apply(this,arguments);this.fireEvent("propertyChanged",{propertyKey:t,propertyValue:a},false,true)};o.prototype.setAggregation=function(t,a,o){e.prototype.setAggregation.apply(this,arguments);this.fireEvent("aggregationChanged",{aggregationName:t,methodName:"set",methodParams:{item:a}},false,true);return this};o.prototype.addAggregation=function(t,a,o){var r=this._getVisualControl(),s;e.prototype.addAggregation.apply(this,arguments);if(t==="customData"&&r){s=sap.ui.getCore().byId(r);this._addCustomData(s,a)}this.fireEvent("aggregationChanged",{aggregationName:t,methodName:"add",methodParams:{item:a}},false,true);return this};o.prototype.insertAggregation=function(t,a,r,s){var i=this._getVisualControl(),n;e.prototype.insertAggregation.apply(this,arguments);if(t==="customData"&&i){n=sap.ui.getCore().byId(i);n.insertCustomData(a.clone(o.UNIFIED_MENU_ITEMS_ID_SUFFIX),r);this._observeCustomDataChanges(a)}this.fireEvent("aggregationChanged",{aggregationName:t,methodName:"insert",methodParams:{item:a,index:r}},false,true);return this};o.prototype.removeAggregation=function(t,a,o){var r=e.prototype.removeAggregation.apply(this,arguments);if(t==="customData"){if(this.getCustomData().length===1){this._disconnectAndDestroyCustomDataObserver()}else if(a&&this._oCustomDataObserver){this._oCustomDataObserver.unobserve(a,{properties:["value"]})}}this.fireEvent("aggregationChanged",{aggregationName:t,methodName:"remove",methodParams:{item:r}},false,true);return r};o.prototype.removeAllAggregation=function(t,a){var o=e.prototype.removeAllAggregation.apply(this,arguments);if(t==="customData"){this._disconnectAndDestroyCustomDataObserver()}this.fireEvent("aggregationChanged",{aggregationName:t,methodName:"removeall",methodParams:{items:o}},false,true);return o};o.prototype.destroyAggregation=function(t,a){if(t==="customData"){this._disconnectAndDestroyCustomDataObserver()}this.fireEvent("aggregationChanged",{aggregationName:t,methodName:"destroy"},false,true);return e.prototype.destroyAggregation.apply(this,arguments)};o.prototype.destroy=function(){var t=sap.ui.getCore().byId(this._getVisualControl());if(t){t.destroy()}return e.prototype.destroy.apply(this,arguments)};o.prototype.addEventDelegate=function(t,a){e.prototype.addEventDelegate.apply(this,arguments);if(this._getVisualControl()){var o=sap.ui.getCore().byId(this._getVisualControl());o.addEventDelegate(t,a)}return this};o.prototype.removeEventDelegate=function(t){e.prototype.removeEventDelegate.apply(this,arguments);if(this._getVisualControl()){var a=sap.ui.getCore().byId(this._getVisualControl());a.removeEventDelegate(t)}return this};o.prototype._addCustomData=function(t,e){t.addCustomData(e.clone(o.UNIFIED_MENU_ITEMS_ID_SUFFIX,undefined,{bCloneChildren:false,bCloneBindings:true}));this._observeCustomDataChanges(e)};o.prototype._observeCustomDataChanges=function(t){this._getCustomDataObserver().observe(t,{properties:["value"]})};o.prototype._customDataObserverCallbackFunction=function(t){sap.ui.getCore().byId(t.object.getId()+"-"+o.UNIFIED_MENU_ITEMS_ID_SUFFIX).setValue(t.current)};o.prototype._getCustomDataObserver=function(){if(!this._oCustomDataObserver){this._oCustomDataObserver=new a(this._customDataObserverCallbackFunction)}return this._oCustomDataObserver};o.prototype._disconnectAndDestroyCustomDataObserver=function(){if(this._oCustomDataObserver){this._oCustomDataObserver.disconnect();this._oCustomDataObserver.destroy();this._oCustomDataObserver=null}};o.prototype._setVisualChild=function(t){this._setInternalRef(t,"_sVisualChild")};o.prototype._setVisualParent=function(t){this._setInternalRef(t,"_sVisualParent")};o.prototype._setVisualControl=function(t){this._setInternalRef(t,"_sVisualControl")};o.prototype._setInternalRef=function(t,e){if(!t||typeof t==="string"){this[e]=t}else if(t.getId){this[e]=t.getId()}};o.prototype._getVisualChild=function(){return this._sVisualChild};o.prototype._getVisualParent=function(){return this._sVisualParent};o.prototype._getVisualControl=function(){return this._sVisualControl};return o});
//# sourceMappingURL=MenuItem.js.map