/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./InstanceManager","sap/ui/core/Popup","sap/ui/core/library","sap/ui/core/Control","sap/ui/core/Element","sap/ui/core/UIArea","sap/ui/Device","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/core/Configuration"],function(e,t,o,i,n,s,a,r,jQuery,l){"use strict";var u=o.Dock;var f=o.CSSSize;var d={};var c="0 -64",p="sapMMessageToast",m="sapUiSelectable",v="sapContrast",_="sapContrastPlus";d._mSettings={duration:3e3,width:"15em",my:"center bottom",at:"center bottom",of:document.defaultView,offset:"0 0",collision:"fit fit",onClose:null,animationTimingFunction:"ease",animationDuration:1e3,autoClose:true,closeOnBrowserNavigation:true};d._aPopups=[];d._iOpenedPopups=0;d._bBoundedEvents=false;d._mOptions={};d._sMessage="";d._validateSettings=function(e){d._isFiniteInteger(e.duration);d._validateWidth(e.width);d._validateDockPosition(e.my);d._validateDockPosition(e.at);d._validateOf(e.of);d._validateOffset(e.offset);d._validateCollision(e.collision);d._validateOnClose(e.onClose);d._validateAutoClose(e.autoClose);d._validateAnimationTimingFunction(e.animationTimingFunction);d._isFiniteInteger(e.animationDuration)};d._isFiniteInteger=function(e){if(typeof e!=="number"||!isFinite(e)||!(Math.floor(e)===e)||e<=0){r.error('"iNumber" needs to be a finite positive nonzero integer on '+d+"._isFiniteInteger")}};d._validateWidth=function(e){if(!f.isValid(e)){r.error(e+" is not of type "+'"sap.ui.core.CSSSize" for property "width" on '+d+"._validateWidth")}};d._validateDockPosition=function(e){if(!u.isValid(e)){r.error('"'+e+'"'+" is not of type "+'"sap.ui.core.Popup.Dock" on '+d+"._validateDockPosition")}};d._validateOf=function(e){if(!(e instanceof jQuery)&&!(e&&e.nodeType===1)&&!(e instanceof i)&&e!==window){r.error('"of" needs to be an instance of sap.ui.core.Control or an Element or a jQuery object or the window on '+d+"._validateOf")}};d._validateOffset=function(e){if(typeof e!=="string"){r.error(e+" is of type "+typeof e+', expected "string" for property "offset" on '+d+"._validateOffset")}};d._validateCollision=function(e){var t=/^(fit|flip|none|flipfit|flipflip|flip flip|flip fit|fitflip|fitfit|fit fit|fit flip)$/i;if(!t.test(e)){r.error('"collision" needs to be a single value “fit”, “flip”, or “none”, or a pair for horizontal and vertical e.g. "fit flip”, "fit none", "flipfit" on '+d+"._validateOffset")}};d._validateOnClose=function(e){if(typeof e!=="function"&&e!==null){r.error('"onClose" should be a function or null on '+d+"._validateOnClose")}};d._validateAutoClose=function(e){if(typeof e!=="boolean"){r.error('"autoClose" should be a boolean on '+d+"._validateAutoClose")}};d._validateAnimationTimingFunction=function(e){var t=/^(ease|linear|ease-in|ease-out|ease-in-out)$/i;if(!t.test(e)){r.error('"animationTimingFunction" should be a string, expected values: '+"ease, linear, ease-in, ease-out, ease-in-out on "+d+"._validateAnimationTimingFunction")}};function y(e){for(var t=["my","at","of","offset"],o=0;o<t.length;o++){if(e[t[o]]!==undefined){return false}}return true}function g(e){var t=document.createElement("div");t.className=p+" "+m+" "+v+" "+_;if(l.getAccessibility()){t.setAttribute("role","alert")}t.style.width=e.width;t.appendChild(document.createTextNode(e.message));return t}function h(e){if(e){if(y(e)){e.offset=c}if(e.of&&e.of.nodeType===9){e.of=document.defaultView}}else{e={offset:c}}return e}d._handleResizeEvent=function(){if(a.system.phone||a.system.tablet){d._resetPosition(d._aPopups)}setTimeout(d["_applyPositions"].bind(d,d._aPopups),0)};d._handleMouseDownEvent=function(e){var t=e.target.hasAttribute("class")&&e.target.getAttribute("class").indexOf(p)!==-1;if(t||e.isMarked("delayedMouseEvent")){return}d._aPopups.forEach(function(e){e&&e.__bAutoClose&&e.close()})};d._resetPosition=function(e){for(var t=0,o;t<e.length;t++){o=e[t]&&e[t].getContent();if(o){o.style.visibility="hidden";o.style.left=0}}};d._applyPositions=function(e){for(var t=0,o,i;t<e.length;t++){o=e[t];if(o){i=o._oPosition;if(a.system.phone||a.system.tablet){setTimeout(d["_applyPosition"].bind(d,o,i),0)}else{o.setPosition(i.my,i.at,i.of,i.offset)}}}};d._applyPosition=function(e,t){t=t||e._oPosition;var o=e.getContent();e.setPosition(t.my,t.at,t.of,t.offset);o.style.visibility="visible"};d._setCloseAnimation=function(e,t,o,i){var n="opacity "+i.animationTimingFunction+" "+i.animationDuration+"ms",s="webkitTransitionEnd."+p+" transitionend."+p,a=l.getAnimationMode(),r=a!==l.AnimationMode.none&&a!==l.AnimationMode.minimal;if(r&&i.animationDuration>0){e[0].style.webkitTransition=n;e[0].style.transition=n;e[0].style.opacity=0;e.on(s,function t(){e.off(s);o()})}else{o()}};d._fnKeyDown=function(e){var t;var o=this._aPopups[0];var i=e.shiftKey;var n=a.os.macintosh?e.metaKey:e.ctrlKey;if(o&&o.isOpen()&&i&&n&&e.code==="KeyM"){e.preventDefault();t=document.querySelector(".sapMMessageToastHiddenFocusable");o.getContent().classList.add("sapMFocus");t.focus();clearTimeout(this._iCloseTimeoutId)}};function b(e){var t=e.shiftKey;var o=a.os.macintosh?e.metaKey:e.ctrlKey;var i=this._aPopups[0];if(e.code==="Escape"||t&&o&&e.code==="KeyM"){e.preventDefault();setTimeout(function(){this._mSettings.opener&&this._mSettings.opener.focus()}.bind(this),0);i.close()}}d.show=function(o,i){var s=n.closestTo(document.activeElement);var r=s&&s.getUIArea&&s.getUIArea();var l;var u=d,f=jQuery.extend({},d._mSettings,{message:o}),c=new t,m,v,_="mousedown."+p+" touchstart."+p,y;d._mSettings.opener=s;if(!this._oRootNode||this._oRootNode&&r&&r.getRootNode()!==this._oRootNode){this._oRootNode=r?r.getRootNode():document.documentElement}i=h(i);jQuery.extend(f,i);d._validateSettings(f);v=g(f);m=d._aPopups.push(c)-1;c.setContent(v);c.setPosition(f.my,f.at,f.of,f.offset,f.collision);c.setAnimations(function e(t,o,i){i()},function e(t,o,i){u._setCloseAnimation(t,o,i,f)});c.setShadow(false);c.__bAutoClose=f.autoClose;if(f.closeOnBrowserNavigation){e.addPopoverInstance(c)}if(!d._bBoundedEvents){jQuery(window).on("resize."+p,d._handleResizeEvent.bind(d));jQuery(document).on(_,d._handleMouseDownEvent.bind(d));d._bBoundedEvents=true}l=document.createElement("span");l.setAttribute("tabIndex",0);l.setAttribute("class","sapMMessageToastHiddenFocusable");c.getContent().prepend(l);if(this._oRootNode){this._oRootNode.removeEventListener("keydown",u._fnKeyDown.bind(u));this._oRootNode.addEventListener("keydown",u._fnKeyDown.bind(u));l.addEventListener("keydown",b.bind(this))}c.open();d._iOpenedPopups++;function C(){e.removePopoverInstance(u._aPopups[m]);jQuery(u._aPopups[m].getContent()).remove();u._aPopups[m].detachClosed(C);u._aPopups[m].destroy();u._aPopups[m]=null;u._iOpenedPopups--;if(u._iOpenedPopups===0){u._aPopups=[];jQuery(window).off("resize."+p);jQuery(document).off(_);u._bBoundedEvents=false}if(typeof f.onClose==="function"){f.onClose.call(u)}}c.attachClosed(C);this._iCloseTimeoutId=setTimeout(c["close"].bind(c),f.duration);function P(){clearTimeout(u._iCloseTimeoutId);u._iCloseTimeoutId=null;function e(){y=setTimeout(c["close"].bind(c),f.duration);c.getContent().removeEventListener("mouseleave",e)}c.getContent().addEventListener("mouseleave",e);clearTimeout(y);y=null}c.getContent().addEventListener("touchstart",P);c.getContent().addEventListener("mouseover",P);if(a.system.desktop){c.getContent().addEventListener("mouseleave",function(){if(document.activeElement!==c.getContent()){this._iCloseTimeoutId=setTimeout(c["close"].bind(c),f.duration)}})}};d.toString=function(){return"sap.m.MessageToast"};return d},true);
//# sourceMappingURL=MessageToast.js.map