/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","sap/ui/core/Control","sap/ui/core/CustomData","sap/ui/core/IconPool","sap/ui/core/HTML","sap/ui/core/Icon","sap/ui/core/ResizeHandler","./Button","./Toolbar","./ToolbarSpacer","./List","./MessageListItem","./library","./Text","./SegmentedButton","./Page","./NavContainer","./Link","./MessageItem","./GroupHeaderListItem","sap/ui/core/InvisibleText","sap/ui/core/library","sap/ui/base/ManagedObject","./MessageViewRenderer","sap/ui/events/KeyCodes","sap/base/Log","sap/base/security/URLListValidator","sap/ui/thirdparty/caja-html-sanitizer"],function(jQuery,e,t,i,s,a,n,o,r,l,g,u,p,c,d,h,f,_,m,y,v,I,L,T,M,C,B){"use strict";var P=I.ValueState;var S=I.MessageType;var w=p.ListType;var D=e.extend("sap.m.MessageView",{metadata:{library:"sap.m",properties:{asyncDescriptionHandler:{type:"function",group:"Behavior",defaultValue:null},asyncURLHandler:{type:"function",group:"Behavior",defaultValue:null},groupItems:{type:"boolean",group:"Behavior",defaultValue:false},showDetailsPageHeader:{type:"boolean",group:"Behavior",defaultValue:true}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.MessageItem",multiple:true,singularName:"item"},headerButton:{type:"sap.m.Button",multiple:false},_navContainer:{type:"sap.m.NavContainer",multiple:false,visibility:"hidden"}},events:{afterOpen:{parameters:{openBy:{type:"sap.ui.core.Control"}},deprecated:true},itemSelect:{parameters:{item:{type:"sap.m.MessageItem"},messageTypeFilter:{type:"sap.ui.core.MessageType"}}},listSelect:{parameters:{messageTypeFilter:{type:"sap.ui.core.MessageType"}}},longtextLoaded:{},urlValidated:{},activeTitlePress:{parameters:{item:{type:"sap.m.MessageItem"}}}}},renderer:T});var H="sapMMsgView";var E={back:i.getIconURI("nav-back"),close:i.getIconURI("decline"),information:i.getIconURI("information"),warning:i.getIconURI("alert"),error:i.getIconURI("error"),success:i.getIconURI("sys-enter-2")};var A=["all","error","warning","success","information"];var k=["asyncDescriptionHandler","asyncURLHandler"];var b={asyncDescriptionHandler:function(e){var t=e.item.getLongtextUrl();if(t){jQuery.ajax({type:"GET",url:t,success:function(t){e.item.setDescription(t);e.promise.resolve()},error:function(){var i="A request has failed for long text data. URL: "+t;C.error(i);e.promise.reject(i)}})}}};D.setDefaultHandlers=function(e){k.forEach(function(t){if(e.hasOwnProperty(t)){b[t]=e[t]}})};D.prototype.init=function(){var e=this;this._bHasHeaderButton=false;this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._createNavigationPages();this._createLists();k.forEach(function(t){if(b.hasOwnProperty(t)){e.setProperty(t,b[t])}})};D.prototype._handleResize=function(e){this._setItemType(e)};D.prototype._afterNavigate=function(){setTimeout(this["_restoreFocus"].bind(this),0);setTimeout(this["_restoreItemsType"].bind(this),0)};D.prototype._restoreFocus=function(){if(this._isListPage()&&this.getItems().length){this._oLists[this._sCurrentList||"all"].focus()}else if(this._oBackButton){this._oBackButton.focus()}};D.prototype._restoreItemsType=function(){if(this._isListPage()&&this.getItems().length>1){var e=this;this._oLists[this._sCurrentList||"all"].getItems().forEach(function(t){if(t.isA("sap.m.MessageListItem")){e._setItemType(t)}})}};D.prototype._setItemType=function(e){const t=e.getTitleRef();if(!t){return}if(t.offsetWidth<t.scrollWidth){e.setType(w.Navigation);if(this.getItems().length===1){this._fnHandleForwardNavigation(e,"show")}return}if(t.offsetWidth>0){e.setType(this._getItemType(e._oMessageItem))}};D.prototype.onBeforeRendering=function(){var e,t,i=this.getItems();this._clearLists();this._detailsPage.setShowHeader(this.getShowDetailsPageHeader());if(this.getGroupItems()){e=this._groupItems(i);this._fillGroupedLists(e)}else{this._fillLists(i)}var s=this.getHeaderButton();if(s){this._bHasHeaderButton=true;this._oListHeader.insertContent(s,2)}this._clearSegmentedButton();this._fillSegmentedButton();this._fnFilterList(this._getCurrentMessageTypeFilter()||"all");t=this._oLists.all.getItems().filter(function(e){return e.isA("sap.m.MessageListItem")});if(t.length===1&&t[0].getType()===w.Navigation){this._fnHandleForwardNavigation(t[0],"show");this._navContainer._pageStack[this._navContainer._pageStack.length-1].transition="slide"}else if(t.length===0){this._navContainer.backToTop()}this._makeAutomaticBinding()};D.prototype._fillGroupedLists=function(e){var t=Object.keys(e),i=t.indexOf(""),s;if(i!==-1){s=e[""];this._fillLists(s);delete e[""];t.splice(i,1)}t.forEach(function(t){this._fillListsWithGroups(t,e[t])},this)};D.prototype._fillListsWithGroups=function(e,t){var i=new y({title:e});this._oLists["all"].addAggregation("items",i,true);["error","warning","success","information"].forEach(function(e){if(this._hasGroupItemsOfType(t,e)){this._oLists[e].addAggregation("items",i.clone(),true)}},this);this._fillLists(t)};D.prototype._hasGroupItemsOfType=function(e,t){return e.some(function(e){return e.getType().toLowerCase()===t})};D.prototype.exit=function(){if(this._oLists){this._destroyLists()}if(this._oMessageItemTemplate){this._oMessageItemTemplate.destroy()}this._oResourceBundle=null;this._oListHeader=null;this._oDetailsHeader=null;this._oSegmentedButton=null;this._oBackButton=null;this._navContainer=null;this._listPage=null;this._detailsPage=null;this._sCurrentList=null};D.prototype._makeAutomaticBinding=function(){var e=this.getItems();if(!this.getBindingInfo("items")&&!e.length){this._bindToMessageModel()}};D.prototype._bindToMessageModel=function(){var e=this;this.setModel(sap.ui.getCore().getMessageManager().getMessageModel(),"message");this._oMessageItemTemplate=new m({type:"{message>type}",title:"{message>message}",description:"{message>description}",longtextUrl:"{message>longtextUrl}"});this.bindAggregation("items",{path:"message>/",template:e._oMessageItemTemplate})};D.prototype._groupItems=function(e){var t={},i;e.forEach(function(e){i=e.getGroupName();t[i]=t[i]||[];t[i].push(e)});return t};D.prototype._onkeypress=function(e){if(e.shiftKey&&e.keyCode==M.ENTER){this.navigateBack()}};D.prototype._getListHeader=function(){return this._oListHeader||this._createListHeader()};D.prototype._getDetailsHeader=function(){return this._oDetailsHeader||this._createDetailsHeader()};D.prototype._createListHeader=function(){var e=this._oResourceBundle.getText("MESSAGEPOPOVER_CLOSE");var t=this.getId()+"-CloseBtnDescr";var i=new s(t,{content:'<span id="'+t+'" class="sapMMsgViewHiddenContainer">'+e+"</span>"});var a=this._oResourceBundle.getText("MESSAGEPOPOVER_ARIA_HEADING"),n=this.getId()+"-HeadingDescr",o=v.getStaticId("sap.m","MESSAGEVIEW_SEGMENTED_BTN_DESCRIPTION"),g=new s(n,{content:'<span id="'+n+'" class="sapMMsgViewHiddenContainer" role="heading">'+a+"</span>"});this._oSegmentedButton=new d(this.getId()+"-segmented",{ariaLabelledBy:o}).addStyleClass("sapMSegmentedButtonNoAutoWidth");this._oListHeader=new r({content:[this._oSegmentedButton,new l,i,g]});return this._oListHeader};D.prototype._createDetailsHeader=function(){var e=this._oResourceBundle.getText("MESSAGEPOPOVER_CLOSE");var t=this.getId()+"-CloseBtnDetDescr";var i=new s(t,{content:'<span id="'+t+'" class="sapMMsgViewHiddenContainer">'+e+"</span>"});var a=this._oResourceBundle.getText("MESSAGEPOPOVER_ARIA_BACK_BUTTON_TOOLTIP");var n=this._oResourceBundle.getText("MESSAGEPOPOVER_ARIA_BACK_BUTTON");var g=this.getId()+"-BackBtnDetDescr";var u=new s(g,{content:'<span id="'+g+'" class="sapMMsgViewHiddenContainer">'+n+"</span>"});this._oBackButton=new o({icon:E["back"],press:this.navigateBack.bind(this),ariaLabelledBy:u,tooltip:a}).addStyleClass(H+"BackBtn");this._oDetailsHeader=new r({content:[this._oBackButton,new l,i,u]});return this._oDetailsHeader};D.prototype._createNavigationPages=function(){this._listPage=new h(this.getId()+"listPage",{customHeader:this._getListHeader()});this._detailsPage=new h(this.getId()+"-detailsPage",{customHeader:this._getDetailsHeader()}).addStyleClass("sapMMsgViewDetailsPage");this._detailsPage.addEventDelegate({onclick:function(e){var t=e.target;if(t.nodeName.toUpperCase()==="A"&&(t.className.indexOf("sapMMsgViewItemDisabledLink")!==-1||t.className.indexOf("sapMMsgViewItemPendingLink")!==-1)){e.preventDefault()}}});this._navContainer=new f(this.getId()+"-navContainer",{initialPage:this.getId()+"listPage",pages:[this._listPage,this._detailsPage],afterNavigate:this._afterNavigate.bind(this)});this.setAggregation("_navContainer",this._navContainer);return this};D.prototype._createLists=function(){this._oLists={};A.forEach(function(e){this._oLists[e]=new g({itemPress:this._fnHandleItemPress.bind(this),visible:false});this._listPage.addAggregation("content",this._oLists[e],true)},this);return this};D.prototype._clearLists=function(){A.forEach(function(e){if(this._oLists[e]){this._oLists[e].destroyAggregation("items",true)}},this);return this};D.prototype._destroyLists=function(){A.forEach(function(e){this._oLists[e]=null},this);this._oLists=null};D.prototype._fillLists=function(e){e.forEach(function(e){var t=this._mapItemToListItem(e),i=this._mapItemToListItem(e);this._oLists["all"].addAggregation("items",t,true);this._oLists[e.getType().toLowerCase()].addAggregation("items",i,true)},this)};D.prototype._mapItemToListItem=function(e){if(!e){return null}var t=e.getType(),i=this,s=this._getItemType(e),a=new u({title:L.escapeSettingsValue(e.getTitle()),description:L.escapeSettingsValue(e.getSubtitle()),counter:e.getCounter(),icon:this._mapIcon(t),infoState:this._mapInfoState(t),info:"",type:s,messageType:e.getType(),activeTitle:e.getActiveTitle(),activeTitlePress:function(){i.fireActiveTitlePress({item:e})}}).addStyleClass(H+"Item").addStyleClass(H+"Item"+t).toggleStyleClass(H+"ItemActive",e.getActiveTitle());if(s!==w.Navigation){a.addEventDelegate({onAfterRendering:function(){this._setItemType(a);if(!a._sResizeHandlerId){this._sResizeHandlerId=n.register(a,this._handleResize.bind(this,a))}}},this)}a._oMessageItem=e;return a};D.prototype._mapInfoState=function(e){if(!e){return null}switch(e){case S.Warning:return P.Warning;case S.Error:return P.Error;case S.Success:return P.Success;case S.Information:case S.None:return P.None;default:C.warning("The provided MessageType is not mapped to a specific ValueState",e);return null}};D.prototype._mapIcon=function(e){if(!e){return null}return E[e.toLowerCase()]};D.prototype._getItemType=function(e){return e.getDescription()||e.getMarkupDescription()||e.getLongtextUrl()?w.Navigation:w.Inactive};D.prototype._clearSegmentedButton=function(){if(this._oSegmentedButton){this._oSegmentedButton.destroyAggregation("buttons",true)}return this};D.prototype._fillSegmentedButton=function(){var e=this;var t=function(t){return function(){e._fnFilterList(t)}};A.forEach(function(e){var i=this._oLists[e],s=e=="all"?"MESSAGEPOPOVER_ALL":"MESSAGEVIEW_BUTTON_TOOLTIP_"+e.toUpperCase(),a=i.getItems().filter(function(e){return e instanceof u}).length,n;if(a>0){n=new o(this.getId()+"-"+e,{text:e=="all"?this._oResourceBundle.getText(s):a,tooltip:e==="all"?"":this._oResourceBundle.getText(s),icon:E[e],press:t(e)}).addStyleClass(H+"Btn"+e.charAt(0).toUpperCase()+e.slice(1));this._oSegmentedButton.addButton(n,true)}},this);var i=this._oSegmentedButton.getButtons().length>2;this._oSegmentedButton.setVisible(i);if(!i){this._oSegmentedButton.setSelectedButton(this._oSegmentedButton.getButtons()[0]);this._fnFilterList("all")}var s=i||this._bHasHeaderButton;this._listPage.setShowHeader(s);return this};D.prototype._setIcon=function(e,t){this._previousIconTypeClass=H+"DescIcon"+e.getType();this._oMessageIcon=new a({src:t.getIcon()}).addStyleClass(H+"DescIcon").addStyleClass(this._previousIconTypeClass);this._detailsPage.addContent(this._oMessageIcon)};D.prototype._setTitle=function(e,t){var i=e.getActiveTitle(),s,a=this,n=L.escapeSettingsValue(e.getTitle()),o=this.getId()+"MessageTitleText";if(i){s=new _(o,{text:n,ariaDescribedBy:t.getId()+"-link",press:function(){a.fireActiveTitlePress({item:e})}})}else{s=new c(o,{text:n})}s.addStyleClass("sapMMsgViewTitleText");this._detailsPage.addAggregation("content",s)};D.prototype._setDescription=function(e){var t=e.getLink();var i=e.getDescription();if(e.getMarkupDescription()){var a=this._getTagPolicy();i=html.sanitizeWithPolicy(i,a)}this._oLastSelectedItem=e;if(e.getMarkupDescription()){this._oMessageDescriptionText=new s(this.getId()+"MarkupDescription",{content:"<div class='sapMMsgViewDescriptionText'>"+L.escapeSettingsValue(i)+"</div>"})}else{this._oMessageDescriptionText=new c(this.getId()+"MessageDescriptionText",{text:L.escapeSettingsValue(i)}).addStyleClass("sapMMsgViewDescriptionText")}this._detailsPage.addContent(this._oMessageDescriptionText);if(t){var n=this._createLinkCopy(t);this._detailsPage.addContent(n);n.addStyleClass("sapMMsgViewDescriptionLink")}};D.prototype._createLinkCopy=function(e){var i,s=e.clone("","",{cloneChildren:false,cloneBindings:false}),a=e.getCustomData()||[];i=Object.keys(e.getMetadata().getProperties());i.forEach(function(t){s.setProperty(t,e.getProperty(t))});s.destroyCustomData();a.forEach(function(e){var i=new t({key:e.getKey(),value:e.getValue()});s.addCustomData(i)});return s};D.prototype._iNextValidationTaskId=0;D.prototype._validateURL=function(e){if(B.validate(e)){return e}C.warning("You have entered invalid URL");return""};D.prototype._queueValidation=function(e){var t=this.getAsyncURLHandler();var i=++this._iNextValidationTaskId;var s={};var a=new Promise(function(a,n){s.resolve=a;s.reject=n;var o={url:e,id:i,promise:s};t(o)});a.id=i;return a};D.prototype._getTagPolicy=function(){var e=this,t;var i=html.makeTagPolicy(this._validateURL());return function s(a,n){var o,r=false;if(a.toUpperCase()==="A"){for(t=0;t<n.length;){if(n[t]==="href"){r=true;o=n[t+1];n.splice(0,2);continue}t+=2}}n=i(a,n);if(r&&typeof e.getAsyncURLHandler()==="function"){n=n||[];var l="sapMMsgViewItemDisabledLink sapMMsgViewItemPendingLink sapMLnk";var g=n.indexOf("class");if(g>-1){n[g+1]+=l}else{n.unshift(l);n.unshift("class")}var u=n.indexOf("id");if(u>-1){n.splice(u+1,1);n.splice(u,1)}var p=e._queueValidation(o);n.push("href");n.push(o);n.push("target");n.push("_blank");n.push("id");n.push("sap-ui-"+e.getId()+"-link-under-validation-"+p.id);p.then(function(t){var i=jQuery(document.getElementById("sap-ui-"+e.getId()+"-link-under-validation-"+t.id));if(t.allowed){C.info("Allow link "+o)}else{C.info("Disallow link "+o)}i.removeClass("sapMMsgViewItemPendingLink");i.toggleClass("sapMMsgViewItemDisabledLink",!t.allowed);e.fireUrlValidated()}).catch(function(){C.warning("Async URL validation could not be performed.")})}return n}};D.prototype._fnHandleForwardNavigation=function(e,t){var i=e._oMessageItem,s=this.getAsyncDescriptionHandler();this._previousIconTypeClass=this._previousIconTypeClass||"";this.fireItemSelect({item:i,messageTypeFilter:this._getCurrentMessageTypeFilter()});this._clearDetailsPage.call(this);if(typeof s==="function"&&i.getLongtextUrl()){i.setMarkupDescription(true);var a={};var n=new Promise(function(e,t){a.resolve=e;a.reject=t});var o=function(){this._clearDetailsPage.call(this);this._detailsPage.setBusy(false);this._navigateToDetails.call(this,i,e,t,true)}.bind(this);n.then(o).catch(function(){C.warning("Async description loading could not be performed.");o()});this._navContainer.to(this._detailsPage);this._detailsPage.setBusy(true);s({promise:a,item:i})}else{this._navigateToDetails.call(this,i,e,t,false)}this._listPage.$().attr("aria-hidden","true")};D.prototype._fnHandleItemPress=function(e){this._fnHandleForwardNavigation(e.getParameter("listItem"),"slide")};D.prototype._navigateToDetails=function(e,t,i,s){this._setTitle(e,t);this._setDescription(e);this._setIcon(e,t);this._detailsPage.invalidate();this.fireLongtextLoaded();if(!s){this._navContainer.to(this._detailsPage,i)}};D.prototype._clearDetailsPage=function(){this._detailsPage.getContent().forEach(function(e){e.destroy()},this)};D.prototype.navigateBack=function(){this._listPage.$().removeAttr("aria-hidden");this._navContainer.back()};D.prototype._fnFilterList=function(e){A.forEach(function(t){if(t!=e&&this._oLists[t].getVisible()){this._oLists[t].setVisible(false)}},this);this._sCurrentList=e;this._oLists[e].setVisible(true);this.fireListSelect({messageTypeFilter:this._getCurrentMessageTypeFilter()})};D.prototype._getCurrentMessageTypeFilter=function(){return this._sCurrentList=="all"?"":this._sCurrentList};D.prototype._isListPage=function(){return this._navContainer.getCurrentPage()==this._listPage};return D});
//# sourceMappingURL=MessageView.js.map