/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/ui/core/Configuration","sap/ui/core/Control","sap/ui/core/Core","sap/ui/core/RenderManager","./NavContainerRenderer","sap/ui/thirdparty/jquery","sap/base/Log","sap/ui/dom/jquery/Focusable"],function(e,t,i,a,n,s,jQuery,o){"use strict";var r=i.extend("sap.m.NavContainer",{metadata:{interfaces:["sap.ui.core.IPlaceholderSupport"],library:"sap.m",properties:{autoFocus:{type:"boolean",group:"Behavior",defaultValue:true},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"},visible:{type:"boolean",group:"Appearance",defaultValue:true},defaultTransitionName:{type:"string",group:"Appearance",defaultValue:"slide"}},defaultAggregation:"pages",aggregations:{pages:{type:"sap.ui.core.Control",multiple:true,singularName:"page"}},associations:{initialPage:{type:"sap.ui.core.Control",multiple:false}},events:{navigate:{allowPreventDefault:true,parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},afterNavigate:{parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},navigationFinished:{parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}}}},renderer:s});var l={onAfterRendering:function(){if(this._placeholder){this._placeholder.show(this)}}};var d=function(e){var i=t.getAnimationMode(),a=i!==t.AnimationMode.none&&i!==t.AnimationMode.minimal;return a?e:0},p=function(e){return!!(e&&e.getParent())},g=function(e,t){if(p(e)){e.$().css({"-webkit-animation-direction":t,"animation-direction":t})}};r.TransitionDirection={BACK:"back",TO:"to"};r.prototype.init=function(){this._pageStack=[];this._aQueue=[];this._mVisitedPages={};this._mFocusObject={};this._iTransitionsCompleted=0;this._bNeverRendered=true;this._bNavigating=false;this._bRenderingInProgress=false};r.prototype.exit=function(){this._mFocusObject=null;this._placeholder=undefined};r.prototype.onBeforeRendering=function(){var e=this.getCurrentPage();if(this._bNeverRendered&&e){var t=e.getId();if(!this._mVisitedPages[t]){this._mVisitedPages[t]=true;var i={from:null,fromId:null,to:e,toId:t,firstTime:true,isTo:false,isBack:false,isBackToPage:false,isBackToTop:false,direction:"initial"};var a=jQuery.Event("BeforeFirstShow",i);a.srcControl=this;a.data=this._oToDataBeforeRendering||{};a.backData={};e._handleEvent(a);a=jQuery.Event("BeforeShow",i);a.srcControl=this;a.data=this._oToDataBeforeRendering||{};a.backData={};e._handleEvent(a)}}};r.prototype.onAfterRendering=function(){var e=this.getCurrentPage(),t,i,a,n;if(this._bNeverRendered&&e){this._bNeverRendered=false;delete this._bNeverRendered;a=e.getId();if(!this._isInsideAPopup()&&this.getAutoFocus()){t=r._applyAutoFocusTo(a);if(t){this._mFocusObject[a]=t}}i={from:null,fromId:null,to:e,toId:a,firstTime:true,isTo:false,isBack:false,isBackToTop:false,isBackToPage:false,direction:"initial"};n=jQuery.Event("AfterShow",i);n.srcControl=this;n.data=this._oToDataBeforeRendering||{};n.backData={};e._handleEvent(n)}};r.prototype._getActualInitialPage=function(){var e=this.getInitialPage();if(e){var t=sap.ui.getCore().byId(e);if(t){return t}else{o.error("NavContainer: control with ID '"+e+"' was set as 'initialPage' but was not found as a DIRECT child of this NavContainer (number of current children: "+this.getPages().length+").")}}var i=this.getPages();return i.length>0?i[0]:null};r.prototype.getPage=function(e){var t=this.getPages();for(var i=0;i<t.length;i++){if(t[i]&&t[i].getId()==e){return t[i]}}return null};r.prototype._ensurePageStackInitialized=function(e){if(this._pageStack.length===0){var t=this._getActualInitialPage();if(t){this._pageStack.push({id:t.getId(),isInitial:true,data:e||{}})}}return this._pageStack};r.prototype.getCurrentPage=function(){var e=this._ensurePageStackInitialized();if(e.length>=1){return this.getPage(e[e.length-1].id)}else{o.warning(this+": page stack is empty but should have been initialized - application failed to provide a page to display");return undefined}};r.prototype.getPreviousPage=function(){var e=this._ensurePageStackInitialized();if(e.length>1){return this.getPage(e[e.length-2].id)}else if(e.length==1){return undefined}else{o.warning(this+": page stack is empty but should have been initialized - application failed to provide a page to display")}};r.prototype.currentPageIsTopPage=function(){var e=this._ensurePageStackInitialized();return e.length===1};r.prototype.insertPreviousPage=function(e,t,i){var a=this._ensurePageStackInitialized();if(this._pageStack.length>0){var n=a.length-1;var s={id:e,transition:t,data:i};if(n===0){s.isInitial=true;delete a[a.length-1].isInitial}a.splice(n,0,s)}else{o.warning(this+": insertPreviousPage called with empty page stack; ignoring")}return this};r._applyAutoFocusTo=function(e){var t=jQuery(document.getElementById(e)).firstFocusableDomRef();if(t){t.focus()}return t};r.prototype._applyAutoFocus=function(e){var t=e.toId,i,a=e.isBack||e.isBackToPage||e.isBackToTop;if(!e.bFocusInsideFromPage){return}if(a){i=this._mFocusObject!=null?this._mFocusObject[t]:null;if(i){i.focus()}else{r._applyAutoFocusTo(t)}}else if(e.isTo){r._applyAutoFocusTo(t)}};r.prototype._afterNavigation=function(e,t,i){var a=jQuery.Event("AfterShow",e);a.data=t||{};a.backData=i||{};a.srcControl=this;e.to._handleEvent(a);a=jQuery.Event("AfterHide",e);a.srcControl=this;e.from._handleEvent(a);if(this.getAutoFocus()){this._applyAutoFocus(e)}this.enhancePagesAccessibility();this.fireNavigationFinished(e);this.fireAfterNavigate(e);this._dequeueNavigation()};r.prototype._afterTransitionCallback=function(e,t,i){this._iTransitionsCompleted++;this._bNavigating=false;this._afterNavigation(e,t,i);o.info(this+": _afterTransitionCallback called, to: "+e.toId);if(e.to.hasStyleClass("sapMNavItemHidden")){o.warning(this.toString()+": target page '"+e.toId+"' still has CSS class 'sapMNavItemHidden' after transition. This should not be the case, please check the preceding log statements.");e.to.removeStyleClass("sapMNavItemHidden")}};r.prototype.enhancePagesAccessibility=function(){var e=this.getCurrentPage();this.getPages().forEach(function(t){var i=t?.getFocusDomRef();if(e===t){i?.removeAttribute("aria-hidden")}else{i?.setAttribute("aria-hidden",true)}})};r.prototype._dequeueNavigation=function(){var e=this._aQueue.shift();if(typeof e==="function"){e()}};r.prototype._isInPageStack=function(e){return this._pageStack.some(function(t){return t.id===e})};r.prototype._safeBackToPage=function(e,t,i,a){var n;if(!this.getPage(e)){return this}n=this.getCurrentPage();if(n&&n.getId()===e){return this}if(this._isInPageStack(e)){return this.backToPage(e,i,a)}else{i=i||{};i.safeBackToPage=true;return this.to(e,t,i,a)}};r.prototype._isFocusInControl=function(e){return jQuery(document.activeElement).closest(e.$()).length>0};r.prototype.to=function(t,a,s,l,p){if(t instanceof i){t=t.getId()}if(typeof a!=="string"){l=s;s=a}a=a||this.getDefaultTransitionName();l=l||{};s=s||{};var g={id:t,transition:a,data:s};this._ensurePageStackInitialized(s);if(this._bNavigating){o.info(this.toString()+": Cannot navigate to page "+t+" because another navigation is already in progress. - navigation will be executed after the previous one");this._aQueue.push(jQuery.proxy(function(){this.to(t,a,s,l,true)},this));return this}if(this._bNeverRendered){this._oToDataBeforeRendering=s}var u=this.getCurrentPage();if(u&&u.getId()===t){o.warning(this.toString()+": Cannot navigate to page "+t+" because this is the current page.");if(p){this._dequeueNavigation()}if(this._pageStack.length===1){this._pageStack[0].transition=g.transition}return this}var h=this.getPage(t);if(h){if(!u){o.warning("Navigation triggered to page with ID '"+t+"', but the current page is not known/aggregated by "+this);return this}var f={from:u,fromId:u.getId(),to:h,toId:t,firstTime:!this._mVisitedPages[t],isTo:true,isBack:false,isBackToTop:false,isBackToPage:false,direction:"to",bFocusInsideFromPage:this._isFocusInControl(u)};if(f.bFocusInsideFromPage){this._mFocusObject[u.getId()]=document.activeElement}var c=this.fireNavigate(f);if(c){e.closeKeyboard();var v=jQuery.Event("BeforeHide",f);v.srcControl=this;u._handleEvent(v);if(!this._mVisitedPages[t]){v=jQuery.Event("BeforeFirstShow",f);v.srcControl=this;v.data=s||{};v.backData={};h._handleEvent(v)}v=jQuery.Event("BeforeShow",f);v.srcControl=this;v.data=s||{};v.backData={};h._handleEvent(v);this._pageStack.push(g);o.info(this.toString()+": navigating to page '"+t+"': "+h.toString());this._mVisitedPages[t]=true;if(!this.getDomRef()){o.info("'Hidden' 'to' navigation in not-rendered NavContainer "+this.toString());this.fireNavigationFinished(f);if(this._bRenderingInProgress){setTimeout(this.invalidate.bind(this),0)}return this}var m;if(!(m=h.getDomRef())||m.parentNode!=this.getDomRef()||n.isPreservedContent(m)){h.addStyleClass("sapMNavItemRendering");o.debug("Rendering 'to' page '"+h.toString()+"' for 'to' navigation");var y=sap.ui.getCore().createRenderManager();y.render(h,this.getDomRef());y.destroy();h.addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemRendering")}var C=r.transitions[a]||r.transitions["slide"];var b=this._iTransitionsCompleted;var I=this;window.setTimeout(function(){if(I&&I._iTransitionsCompleted<b+1){o.warning("Transition '"+a+"' 'to' was triggered five seconds ago, but has not yet invoked the end-of-transition callback.")}},d(5e3));this._bNavigating=true;var S=s.safeBackToPage||l.safeBackToPage?"back":"to";this._cacheTransitionInfo(a,S);C[S].call(this,u,h,jQuery.proxy(function(){this._afterTransitionCallback(f,s)},this),l)}else{o.info("Navigation to page with ID '"+t+"' has been aborted by the application")}}else{o.warning("Navigation triggered to page with ID '"+t+"', but this page is not known/aggregated by "+this)}return this};r.prototype.back=function(e,t){this._backTo("back",e,t);return this};r.prototype.backToPage=function(e,t,i){this._backTo("backToPage",t,i,e);return this};r.prototype.backToTop=function(e,t){this._backTo("backToTop",e,t);return this};r.prototype._backTo=function(t,a,s,l){if(this._bNavigating){o.warning(this.toString()+": Cannot navigate back because another navigation is already in progress. - navigation will be executed after the previous one");this._aQueue.push(jQuery.proxy(function(){this._backTo(t,a,s,l)},this));return this}if(this._pageStack.length<=1){if(this._pageStack.length===1&&!this._pageStack[0].isInitial){throw new Error("Initial page not found on the stack. How did this happen?")}this._aQueue=[];return this}else{if(l instanceof i){l=l.getId()}var p=this._pageStack[this._pageStack.length-1];var g=p.transition;var u=this.getPage(p.id);var h;var f;if(t==="backToTop"){h=this._getActualInitialPage();f=null}else if(t==="backToPage"){var c=this._findClosestPreviousPageInfo(l);if(!c){o.error(this.toString()+": Cannot navigate backToPage('"+l+"') because target page was not found among the previous pages.");return this}h=sap.ui.getCore().byId(c.id);if(!h){o.error(this.toString()+": Cannot navigate backToPage('"+l+"') because target page does not exist anymore.");return this}f=c.data}else{h=this.getPreviousPage();f=this._pageStack[this._pageStack.length-2].data}if(!h){o.error("NavContainer back navigation: target page is not defined or not aggregated by this NavContainer. Aborting navigation.");return}var v=h.getId();a=a||{};s=s||{};var m={from:u,fromId:u.getId(),to:h,toId:v,firstTime:!this._mVisitedPages[v],isTo:false,isBack:t==="back",isBackToPage:t==="backToPage",isBackToTop:t==="backToTop",direction:t,bFocusInsideFromPage:this._isFocusInControl(u)};var y=this.fireNavigate(m);if(y){e.closeKeyboard();var C=jQuery.Event("BeforeHide",m);C.srcControl=this;u._handleEvent(C);if(!this._mVisitedPages[v]){C=jQuery.Event("BeforeFirstShow",m);C.srcControl=this;C.backData=a||{};C.data={};h._handleEvent(C)}C=jQuery.Event("BeforeShow",m);C.srcControl=this;C.backData=a||{};C.data=f||{};h._handleEvent(C);this._pageStack.pop();o.info(this.toString()+": navigating back to page "+h.toString());this._mVisitedPages[v]=true;if(t==="backToTop"){this._pageStack=[];o.info(this.toString()+": navigating back to top");this.getCurrentPage()}else if(t==="backToPage"){var b=[],I;while(this._pageStack[this._pageStack.length-1].id!==l){I=this._pageStack.pop();b.push(I.id)}o.info(this.toString()+": navigating back to specific page "+h.toString()+" across the pages: "+b.join(", "))}if(!this.getDomRef()){o.info("'Hidden' back navigation in not-rendered NavContainer "+this.toString());this._afterNavigation(m,f,a);return this}var S=r.transitions[g]||r.transitions["slide"];var _=this._iTransitionsCompleted;var T=this;window.setTimeout(function(){if(T&&T._iTransitionsCompleted<_+1){o.warning("Transition '"+g+"' 'back' was triggered five seconds ago, but has not yet invoked the end-of-transition callback.")}},d(5e3));this._bNavigating=true;var k;if(!(k=h.getDomRef())||k.parentNode!=this.getDomRef()||n.isPreservedContent(k)){h.addStyleClass("sapMNavItemRendering");o.debug("Rendering 'to' page '"+h.toString()+"' for back navigation");var N=sap.ui.getCore().createRenderManager();var P=this.$().children().index(u.getDomRef());N.renderControl(h);N.flush(this.getDomRef(),false,P);N.destroy();h.addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemRendering")}if(u.getId()===h.getId()){o.info("Transition is skipped when navigating back to the same page instance"+h.toString());this._afterTransitionCallback(m,f,a);return this}this._cacheTransitionInfo(g,r.TransitionDirection.BACK);S.back.call(this,u,h,jQuery.proxy(function(){this._afterTransitionCallback(m,f,a)},this),s)}}return this};r.prototype._findClosestPreviousPageInfo=function(e){for(var t=this._pageStack.length-2;t>=0;t--){var i=this._pageStack[t];if(i.id===e){return i}}return null};r.prototype._cacheTransitionInfo=function(e,t){this._sTransitionName=e;this._sTransitionDirection=t};r.prototype._fadeTransition=function(e,t,i){this.oFromPage=e;this.oToPage=t;this.fCallback=i;this._fadeOutAnimation()};r.prototype._fadeOutAnimation=function(){var e=this,t=this.oFromPage,i=this.oToPage;i.addStyleClass("sapMNavItemTransparent");if(this._sTransitionName==="slide"){if(this._sTransitionDirection===r.TransitionDirection.TO){i.addStyleClass("sapMNavItemSlideLeft");t.addStyleClass("sapMNavItemSlideRight")}else{i.addStyleClass("sapMNavItemSlideRight");t.addStyleClass("sapMNavItemSlideLeft")}}i.removeStyleClass("sapMNavItemHidden");t.addStyleClass("sapMNavItemOpaque");window.setTimeout(function(){t.$().on("webkitTransitionEnd transitionend",e._fadeOutAnimationEnd.bind(e));e.bTransition1EndPending=true;t.addStyleClass("sapMNavItemFading").removeStyleClass("sapMNavItemOpaque").addStyleClass("sapMNavItemTransparent");window.setTimeout(function(){if(e.bTransition1EndPending){e._fadeOutAnimationEnd()}},d(150))},d(10))};r.prototype._fadeOutAnimationEnd=function(e){var t=this.oFromPage;if(e&&e.originalEvent&&e.originalEvent.propertyName!=="opacity"){return}this.bTransition1EndPending=false;jQuery(t.$()).off("webkitTransitionEnd transitionend");t.removeStyleClass("sapMNavItemSlideLeft").removeStyleClass("sapMNavItemSlideRight");this._fadeInAnimation()};r.prototype._fadeInAnimation=function(){var e=this,t=this.oToPage;window.setTimeout(function(){t.$().on("webkitTransitionEnd transitionend",e._fadeInAnimationEnd.bind(e));e.bTransition2EndPending=true;t.addStyleClass("sapMNavItemFading").removeStyleClass("sapMNavItemTransparent").addStyleClass("sapMNavItemOpaque");window.setTimeout(function(){if(e.bTransition2EndPending){e._fadeInAnimationEnd()}},d(150))},d(10))};r.prototype._fadeInAnimationEnd=function(e){var t=this.oToPage,i=this.oFromPage;if(e&&e.originalEvent&&e.originalEvent.propertyName!=="opacity"){return}this.bTransition2EndPending=false;if(p(i)){i.addStyleClass("sapMNavItemHidden");i.removeStyleClass("sapMNavItemFading").removeStyleClass("sapMNavItemTransparent")}jQuery(t.$()).off("webkitTransitionEnd transitionend");if(p(t)){t.removeStyleClass("sapMNavItemFading").removeStyleClass("sapMNavItemOpaque").removeStyleClass("sapMNavItemSlideLeft").removeStyleClass("sapMNavItemSlideRight")}this.fCallback()};r.prototype._baseSlideAnimation=function(e,t,i){var a=false,n=true,s=this._sTransitionDirection===r.TransitionDirection.BACK,o=s?"reverse":"normal",l=s?"sapMNavItemSlideCenterToLeft":"sapMNavItemSlideRightToCenter",u=!s?"sapMNavItemSlideCenterToLeft":"sapMNavItemSlideRightToCenter",h=function(){jQuery(this).off("webkitAnimationEnd animationend");if(!a){a=true;return a}n=false;g(t,"");g(e,"");if(p(t)){t.removeStyleClass(l)}if(p(e)){e.removeStyleClass(u).addStyleClass("sapMNavItemHidden")}i()};e.$().on("webkitAnimationEnd animationend",h);t.$().on("webkitAnimationEnd animationend",h);g(t,o);g(e,o);e.addStyleClass(u);t.addStyleClass(l).removeStyleClass("sapMNavItemHidden");window.setTimeout(function(){if(n){a=true;h.apply(e.$().add(t.$()))}},d(400))};r.transitions=r.transitions||{};r.transitions["show"]={to:function(e,t,i){t.removeStyleClass("sapMNavItemHidden");e&&e.addStyleClass("sapMNavItemHidden");i()},back:function(e,t,i){t.removeStyleClass("sapMNavItemHidden");e&&e.addStyleClass("sapMNavItemHidden");i()}};r.transitions["baseSlide"]={to:r.prototype._baseSlideAnimation,back:r.prototype._baseSlideAnimation};r.transitions["slide"]={to:r.prototype._fadeTransition,back:r.prototype._fadeTransition};r.transitions["fade"]={to:r.prototype._fadeTransition,back:r.prototype._fadeTransition};r.transitions["flip"]={to:function(e,t,i){var a=this;window.setTimeout(function(){a.$().addClass("sapMNavFlip");t.addStyleClass("sapMNavItemFlipNext");t.removeStyleClass("sapMNavItemHidden");window.setTimeout(function(){var n=false;var s=true;var o=null;o=function(){jQuery(this).off("webkitTransitionEnd transitionend");if(!n){n=true}else{s=false;if(p(t)){t.removeStyleClass("sapMNavItemFlipping")}if(p(e)){e.removeStyleClass("sapMNavItemFlipping").addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemFlipPrevious")}a.$().removeClass("sapMNavFlip");i()}};e.$().on("webkitTransitionEnd transitionend",o);t.$().on("webkitTransitionEnd transitionend",o);t.addStyleClass("sapMNavItemFlipping").removeStyleClass("sapMNavItemFlipNext");e.addStyleClass("sapMNavItemFlipping").addStyleClass("sapMNavItemFlipPrevious");window.setTimeout(function(){if(s){n=true;o.apply(e.$().add(t.$()))}},d(600))},d(60))},0)},back:function(e,t,i){var a=this;a.$().addClass("sapMNavFlip");t.addStyleClass("sapMNavItemFlipPrevious");t.removeStyleClass("sapMNavItemHidden");window.setTimeout(function(){var n=false;var s=true;var o=null;o=function(){jQuery(this).off("webkitTransitionEnd transitionend");if(!n){n=true}else{s=false;if(p(t)){t.removeStyleClass("sapMNavItemFlipping")}if(p(e)){e.removeStyleClass("sapMNavItemFlipping").addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemFlipNext")}a.$().removeClass("sapMNavFlip");i()}};e.$().on("webkitTransitionEnd transitionend",o);t.$().on("webkitTransitionEnd transitionend",o);t.addStyleClass("sapMNavItemFlipping").removeStyleClass("sapMNavItemFlipPrevious");e.addStyleClass("sapMNavItemFlipping").addStyleClass("sapMNavItemFlipNext");window.setTimeout(function(){if(s){n=true;o.apply(e.$().add(t.$()))}},d(600))},d(60))}};r.transitions["door"]={to:function(e,t,i){var a=this;window.setTimeout(function(){a.$().addClass("sapMNavDoor");t.addStyleClass("sapMNavItemDoorInNext");t.removeStyleClass("sapMNavItemHidden");window.setTimeout(function(){var n=false;var s=true;var o=null;o=function(){jQuery(this).off("webkitAnimationEnd animationend");if(!n){n=true}else{s=false;if(p(t)){t.removeStyleClass("sapMNavItemDooring").removeStyleClass("sapMNavItemDoorInNext")}if(p(e)){e.removeStyleClass("sapMNavItemDooring").addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemDoorInPrevious")}a.$().removeClass("sapMNavDoor");i()}};e.$().on("webkitAnimationEnd animationend",o);t.$().on("webkitAnimationEnd animationend",o);t.addStyleClass("sapMNavItemDooring");e.addStyleClass("sapMNavItemDooring").addStyleClass("sapMNavItemDoorInPrevious");window.setTimeout(function(){if(s){n=true;o.apply(e.$().add(t.$()))}},d(1e3))},d(60))},0)},back:function(e,t,i){var a=this;a.$().addClass("sapMNavDoor");t.addStyleClass("sapMNavItemDoorOutNext");t.removeStyleClass("sapMNavItemHidden");window.setTimeout(function(){var n=false;var s=true;var o=null;o=function(){jQuery(this).off("webkitAnimationEnd animationend");if(!n){n=true}else{s=false;if(p(t)){t.removeStyleClass("sapMNavItemDooring").removeStyleClass("sapMNavItemDoorOutNext")}if(p(e)){e.removeStyleClass("sapMNavItemDooring").addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemDoorOutPrevious")}a.$().removeClass("sapMNavDoor");i()}};e.$().on("webkitAnimationEnd animationend",o);t.$().on("webkitAnimationEnd animationend",o);t.addStyleClass("sapMNavItemDooring");e.addStyleClass("sapMNavItemDooring").addStyleClass("sapMNavItemDoorOutPrevious");window.setTimeout(function(){if(s){n=true;o.apply(e.$().add(t.$()))}},d(1e3))},d(60))}};r.prototype.addCustomTransition=function(e,t,i){if(r.transitions[e]){o.warning("Transition with name "+e+" already exists in "+this+". It is now being replaced by custom transition.")}r.transitions[e]={to:t,back:i};return this};r.addCustomTransition=r.prototype.addCustomTransition;r.prototype.invalidate=function(e){if(e==this){}else if(e instanceof i){var t=false,a=this.getPages(),n=a.length;for(var s=0;s<n;s++){if(a[s]===e){t=true;break}}if((!t||e===this.getCurrentPage())&&!this._isInsideAPopup()){i.prototype.invalidate.call(this,e)}}else{i.prototype.invalidate.call(this,e)}};r.prototype._isInsideAPopup=function(){var e;e=function(t){if(!t){return false}if(t.getMetadata().isInstanceOf("sap.ui.core.PopupInterface")){return true}return e(t.getParent())};return e(this)};r.prototype.removePage=function(e){var t;if(typeof e=="number"){t=this.getPages()[e]}else if(typeof e=="string"){t=sap.ui.getCore().byId(e)}else{t=e}t=this.removeAggregation("pages",t,t!==this.getCurrentPage());this._onPageRemoved(t);return t};r.prototype._onPageRemoved=function(e){if(!e){return}e.$().remove();e.removeStyleClass("sapMNavItemHidden");e.removeStyleClass("sapMNavItem");var t=this._ensurePageStackInitialized();this._pageStack=t.filter(function(t){return e.getId()!==t.id})};r.prototype.removeAllPages=function(){var e=this.removeAllAggregation("pages");for(var t=0;t<e.length;t++){this._onPageRemoved(e[t])}return e};r.prototype.addPage=function(e){var t=this.getPages(),i=this.invalidate.bind(this);if(t.indexOf(e)>-1){return this}this.addAggregation("pages",e,true);e.addStyleClass("sapMNavItem");var a=t.length;if(a===0&&this.getPages().length===1){this._fireAdaptableContentChange(e);if(this.getDomRef()){this._ensurePageStackInitialized();i=this.rerender.bind(this);i()}}return this};r.prototype.insertPage=function(e,t){var i=this.getPages().length,a=this.invalidate.bind(this);this.insertAggregation("pages",e,t,true);e.addStyleClass("sapMNavItem");if(i===0&&this.getPages().length===1){this._fireAdaptableContentChange(e);if(this.getDomRef()){this._ensurePageStackInitialized();a=this.rerender.bind(this);a()}}return this};r.prototype.showPlaceholder=function(e){var t,i=sap.ui.require("sap/ui/core/Placeholder");if(!i||!i.isEnabled()){return}if(this._placeholder){this.hidePlaceholder()}if(e&&e.placeholder){this._placeholder=e.placeholder;t=this._placeholder._load()}else{t=Promise.resolve()}if(this.getDomRef()&&this._placeholder){this._placeholder.show(this)}this.addEventDelegate(l,this);return t};r.prototype.hidePlaceholder=function(){if(this._placeholder){this._placeholder.hide();this.removeEventDelegate(l)}};r.prototype.needPlaceholder=function(e,t){return!t||this.getCurrentPage()!==t};r.prototype._getAdaptableContent=function(){return this.getCurrentPage()};r.prototype._fireAdaptableContentChange=function(e){if(e&&this.mEventRegistry["_adaptableContentChange"]){this.fireEvent("_adaptableContentChange",{parent:this,adaptableContent:e})}};return r});
//# sourceMappingURL=NavContainer.js.map