/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/ui/core/Core","./NotificationListBase","sap/ui/core/InvisibleText","sap/ui/core/library","sap/m/Link","sap/m/Avatar","sap/ui/events/KeyCodes","./NotificationListItemRenderer"],function(t,e,i,o,r,a,s,n,p){"use strict";var u=e.getLibraryResourceBundle("sap.m"),h=u.getText("NOTIFICATION_LIST_ITEM_SHOW_MORE"),l=u.getText("NOTIFICATION_LIST_ITEM_SHOW_LESS"),I=u.getText("NOTIFICATION_LIST_ITEM_READ"),T=u.getText("NOTIFICATION_LIST_ITEM_UNREAD");var g=44;var _=t.AvatarSize;var c=t.AvatarColor;var f=t.LinkAccessibleRole;var v=r.Priority;var A=i.extend("sap.m.NotificationListItem",{metadata:{library:"sap.m",properties:{description:{type:"string",group:"Appearance",defaultValue:""},authorInitials:{type:"string",group:"Data",defaultValue:null},truncate:{type:"boolean",group:"Appearance",defaultValue:true},hideShowMoreButton:{type:"boolean",group:"Appearance",defaultValue:false},authorAvatarColor:{type:"sap.m.AvatarColor",group:"Appearance",defaultValue:c.Accent6}},aggregations:{processingMessage:{type:"sap.m.MessageStrip",multiple:false},_showMoreButton:{type:"sap.m.Link",multiple:false,visibility:"hidden"}}},renderer:p});A.prototype.init=function(){this.setType("Active");this._footerIvisibleText=new o({id:this.getId()+"-invisibleFooterText"})};A.prototype._getAuthorAvatar=function(){if(this.getAuthorInitials()||this.getAuthorPicture()){if(!this._avatar){this._avatar=new s({displaySize:_.XS})}this._avatar.setInitials(this.getAuthorInitials());this._avatar.setSrc(this.getAuthorPicture());this._avatar.setBackgroundColor(this.getAuthorAvatarColor());return this._avatar}};A.prototype.onAfterRendering=function(){i.prototype.onAfterRendering.call(this);if(this.getHideShowMoreButton()){return}this._updateShowMoreButtonVisibility()};A.prototype.exit=function(){i.prototype.exit.apply(this,arguments);if(this._footerIvisibleText){this._footerIvisibleText.destroy();this._footerIvisibleText=null}if(this._avatar){this._avatar.destroy();this._avatar=null}};A.prototype._onResize=function(){i.prototype._onResize.apply(this,arguments);this._updateShowMoreButtonVisibility()};A.prototype._updateShowMoreButtonVisibility=function(){var t=this.$(),e=t.find(".sapMNLITitleText")[0],i=t.find(".sapMNLIDescription")[0],o;if(t.length>0){o=e.scrollHeight>g||i.scrollHeight>g}this._getShowMoreButton().setVisible(o)};A.prototype._getShowMoreButton=function(){var t=this.getAggregation("_showMoreButton");if(!t){t=new a(this.getId()+"-showMoreButton",{accessibleRole:f.Button,text:this.getTruncate()?h:l,press:function(){var t=!this.getTruncate();this._getShowMoreButton().setText(t?h:l);this.setProperty("truncate",t,true);this.$().find(".sapMNLITitleText, .sapMNLIDescription").toggleClass("sapMNLIItemTextLineClamp",t)}.bind(this)});this.setAggregation("_showMoreButton",t,true)}return t};A.prototype._getFooterInvisibleText=function(){var t=this.getUnread()?T:I,e=this.getAuthorName(),i=this.getDatetime(),o=this.getPriority(),r=[t];if(e){e=u.getText("NOTIFICATION_LIST_ITEM_CREATED_BY");r.push(e);r.push(this.getAuthorName())}if(i){r.push(u.getText("NOTIFICATION_LIST_ITEM_DATETIME",[i]))}if(o!==v.None){r.push(u.getText("NOTIFICATION_LIST_ITEM_PRIORITY",[o]))}return this._footerIvisibleText.setText(r.join(" "))};return A});
//# sourceMappingURL=NotificationListItem.js.map