/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/ui/core/Control","sap/ui/core/library","sap/ui/core/LabelEnablement","sap/ui/events/KeyCodes","./ObjectNumberRenderer"],function(e,t,i,r,a,s){"use strict";var n=i.TextAlign;var p=i.TextDirection;var u=i.ValueState;var o=e.EmptyIndicatorMode;var l=t.extend("sap.m.ObjectNumber",{metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.m",designtime:"sap/m/designtime/ObjectNumber.designtime",properties:{number:{type:"string",group:"Misc",defaultValue:null},numberUnit:{type:"string",group:"Misc",defaultValue:null,deprecated:true},emphasized:{type:"boolean",group:"Appearance",defaultValue:true},state:{type:"sap.ui.core.ValueState",group:"Misc",defaultValue:u.None},unit:{type:"string",group:"Misc",defaultValue:null},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:p.Inherit},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:n.Begin},active:{type:"boolean",group:"Misc",defaultValue:false},inverted:{type:"boolean",group:"Misc",defaultValue:false},emptyIndicatorMode:{type:"sap.m.EmptyIndicatorMode",group:"Appearance",defaultValue:o.Off}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"}},events:{press:{}},dnd:{draggable:true,droppable:false}},renderer:s});l.prototype._getStateText=function(){var e=this.getState(),t=sap.ui.getCore().getLibraryResourceBundle("sap.m");return t.getText("OBJECTNUMBER_ARIA_VALUE_STATE_"+e.toUpperCase(),[],true)};l.prototype.getAccessibilityInfo=function(){var e="";if(this.getState()!==u.None){e=this._getStateText()}return{description:(this.getNumber()+" "+this.getUnit()+" "+e).trim()}};l.prototype.ontap=function(e){if(this._isClickable(e)){this.firePress()}};l.prototype.ontouchstart=function(e){if(this._isClickable(e)){e.setMarked()}};l.prototype._activeState=function(){this.addStyleClass("sapMObjectNumberPressed")};l.prototype._inactiveState=function(){this.removeStyleClass("sapMObjectNumberPressed")};l.prototype.onkeydown=function(e){if(e.which===a.SPACE||e.which===a.ENTER){e.setMarked();this._activeState();if(e.which===a.ENTER){this.firePress()}else{e.preventDefault();this._bPressedSpace=true}}else if(this._bPressedSpace){if(e.which===a.SHIFT||e.which===a.ESCAPE){this._bPressedEscapeOrShift=true;this._inactiveState()}else{e.preventDefault()}}};l.prototype.onkeyup=function(e){if(e.which===a.ENTER){e.setMarked();this._inactiveState()}else if(e.which===a.SPACE){if(!this._bPressedEscapeOrShift){e.setMarked();this.firePress();this._inactiveState()}else{this._bPressedEscapeOrShift=false}this._bPressedSpace=false}else if(e.which===a.ESCAPE){this._bPressedSpace=false}};l.prototype._isActive=function(){return this.getActive()&&(this.getNumber().trim()||this.getUnit().trim())};l.prototype._isClickable=function(e){var t=e.target.id;return this._isActive()&&(t===this.getId()+"-link"||t===this.getId()+"-number"||t===this.getId()+"-unit")};l.prototype._hasExternalLabelling=function(){return this.getAriaLabelledBy().length>0||r.getReferencingLabels(this).length>0};l.prototype._generateSelfLabellingIds=function(){var e=this.getId(),t="";if(this.getNumber()){t+=e+"-number "}if(this.getUnit()){t+=e+"-unit "}if(this.getEmphasized()){t+=e+"-emphasized "}if(this.getState()!==u.None){t+=e+"-state"}return t.trim()};return l});
//# sourceMappingURL=ObjectNumber.js.map