/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/ui/core/Control","sap/ui/core/ValueStateSupport","sap/ui/core/IndicationColorSupport","sap/ui/core/library","sap/ui/base/DataType","./ObjectStatusRenderer","sap/m/ImageHelper","sap/ui/core/LabelEnablement"],function(t,e,i,o,r,a,n,s,l){"use strict";var p=r.TextDirection;var u=r.ValueState;var c=t.EmptyIndicatorMode;var g=e.extend("sap.m.ObjectStatus",{metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.m",designtime:"sap/m/designtime/ObjectStatus.designtime",properties:{title:{type:"string",group:"Misc",defaultValue:null},text:{type:"string",group:"Misc",defaultValue:null},active:{type:"boolean",group:"Misc",defaultValue:false},state:{type:"string",group:"Misc",defaultValue:u.None},inverted:{type:"boolean",group:"Misc",defaultValue:false},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconDensityAware:{type:"boolean",group:"Appearance",defaultValue:true},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:p.Inherit},emptyIndicatorMode:{type:"sap.m.EmptyIndicatorMode",group:"Appearance",defaultValue:c.Off},stateAnnouncementText:{type:"string",group:"Misc"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{press:{}},dnd:{draggable:true,droppable:false}},renderer:n});g.prototype._getStateText=function(t){if(t!==u.None&&this.isPropertyInitial("stateAnnouncementText")){return i.getAdditionalText(t)?i.getAdditionalText(t):o.getAdditionalText(t)}return!this.isPropertyInitial("stateAnnouncementText")?this.getStateAnnouncementText():""};g.prototype.exit=function(){if(this._oImageControl){this._oImageControl.destroy();this._oImageControl=null}};g.prototype._getImageControl=function(){var t=this.getId()+"-icon",e=!this.getText()&&!this.getTitle(),i={src:this.getIcon(),densityAware:this.getIconDensityAware(),useIconTooltip:false,decorative:!this.getActive()};if(e){i.alt=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("OBJECT_STATUS_ICON")}this._oImageControl=s.getImageControl(t,this._oImageControl,this,i);return this._oImageControl};g.prototype.setState=function(t){if(t==null){t=u.None}else if(!a.getType("sap.ui.core.ValueState").isValid(t)&&!a.getType("sap.ui.core.IndicationColor").isValid(t)){throw new Error('"'+t+'" is not a value of the enums sap.ui.core.ValueState or sap.ui.core.IndicationColor for property "state" of '+this)}return this.setProperty("state",t)};g.prototype.ontap=function(t){if(this._isClickable(t)){this.firePress()}};g.prototype.onsapenter=function(t){if(this._isActive()){this.firePress();t.setMarked()}};g.prototype.onsapspace=function(t){this.onsapenter(t)};g.prototype._isActive=function(){return this.getActive()&&(this.getText().trim()||this.getIcon().trim())};g.prototype._isEmpty=function(){return!(this.getText().trim()||this.getIcon().trim()||this.getTitle().trim())};g.prototype.ontouchstart=function(t){if(this._isClickable(t)){t.setMarked()}};g.prototype.getAccessibilityInfo=function(){var t=this.isPropertyInitial("stateAnnouncementText")?i.getAdditionalText(this.getState()):this.getStateAnnouncementText(),e;if(this.getState()!=u.None){t=t!==null?t:o.getAdditionalText(this.getState())}e=((this.getTitle()||"")+" "+(this.getText()||"")+" "+(t!==null?t:"")+" "+(this.getTooltip()||"")).trim();e=this._isActive()?e+(e?" "+sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("OBJECT_STATUS_ACTIVE"):""):e;return{description:e}};g.prototype._hasExternalLabelling=function(){return this.getAriaLabelledBy().length>0||l.getReferencingLabels(this).length>0};g.prototype._generateSelfLabellingIds=function(){var t=this.getId(),e="";if(this.getTitle()){e+=t+"-title "}if(this.getText()){e+=t+"-text "}if(this.getIcon()){e+=t+"-statusIcon "}return e.trim()};g.prototype._isClickable=function(t){var e=t.target.id;return this._isActive()&&(e===this.getId()+"-link"||e===this.getId()+"-text"||e===this.getId()+"-statusIcon"||e===this.getId()+"-icon")};return g});
//# sourceMappingURL=ObjectStatus.js.map