/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/ui/core/library","sap/ui/core/Control","sap/ui/core/IconPool","sap/ui/Device","sap/ui/core/InvisibleText","sap/ui/core/ResizeHandler","sap/ui/core/Item","sap/ui/core/ListItem","sap/ui/model/odata/type/Boolean","sap/ui/model/type/String","sap/ui/model/odata/type/String","sap/ui/model/type/Date","sap/ui/model/type/Time","sap/ui/model/odata/type/DateTime","sap/ui/model/type/Float","sap/ui/layout/library","sap/ui/layout/Grid","sap/ui/layout/GridData","sap/ui/layout/HorizontalLayout","./Button","./OverflowToolbar","./OverflowToolbarLayoutData","./ToolbarSpacer","./Text","./SearchField","./CheckBox","./ComboBox","./Select","./Label","./Input","./DatePicker","./TimePicker","./DateTimePicker","sap/base/Log","sap/ui/thirdparty/jquery","./P13nOperationsHelper","sap/m/P13nConditionPanelRenderer"],function(e,t,i,o,n,a,s,r,l,d,p,u,h,g,_,f,y,c,m,C,v,S,T,b,I,F,x,V,D,L,M,O,P,k,A,jQuery,w,E){"use strict";var N=t.ValueState;var R=e.ButtonType;var G=e.ToolbarDesign;var K=t.TextAlign;var B=e.OverflowToolbarPriority;var H=e.P13nConditionOperation;var U=i.extend("sap.m.P13nConditionPanel",{metadata:{library:"sap.m",properties:{maxConditions:{type:"string",group:"Misc",defaultValue:"-1"},exclude:{type:"boolean",group:"Misc",defaultValue:false},containerQuery:{type:"boolean",group:"Misc",defaultValue:false},autoAddNewRow:{type:"boolean",group:"Misc",defaultValue:false},disableFirstRemoveIcon:{type:"boolean",group:"Misc",defaultValue:false},alwaysShowAddIcon:{type:"boolean",group:"Misc",defaultValue:true},usePrevConditionSetting:{type:"boolean",group:"Misc",defaultValue:true},autoReduceKeyFieldItems:{type:"boolean",group:"Misc",defaultValue:false},layoutMode:{type:"string",group:"Misc",defaultValue:null},showLabel:{type:"boolean",group:"Misc",defaultValue:false},displayFormat:{type:"string",group:"Misc",defaultValue:null},validationExecutor:{type:"object",group:"Misc",defaultValue:null}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",visibility:"hidden"}},events:{dataChange:{}}},renderer:E.renderer});U.prototype.setConditions=function(e){if(!e){A.error("sap.m.P13nConditionPanel : aCondition is not defined")}if(this._bIgnoreSetConditions){return}this._oConditionsMap={};this._aConditionKeys=[];this._iConditions=0;for(var t=0;t<e.length;t++){this._addCondition2Map(e[t])}this._clearConditions();this._fillConditions()};U.prototype.removeAllConditions=function(){this._oConditionsMap={};this._aConditionKeys=[];this._iConditions=0;this._clearConditions();this._fillConditions()};U.prototype.addCondition=function(e){if(this._bIgnoreSetConditions){return}e.index=this._iConditions;this._addCondition2Map(e);this._addCondition(e)};U.prototype.insertCondition=function(e,t){if(this._bIgnoreSetConditions){return}if(t!==undefined){e.index=t}this._addCondition2Map(e);this._addCondition(e)};U.prototype.removeCondition=function(e){this._clearConditions();if(typeof e=="string"){this._removeConditionFromMap(e)}if(typeof e=="object"){this._removeConditionFromMap(e.key)}this._fillConditions()};U.prototype._addCondition2Map=function(e){if(!e.key){e.key="condition_"+this._iConditions;if(this.getExclude()){e.key="x"+e.key}}this._iConditions++;this._oConditionsMap[e.key]=e;this._aConditionKeys.push(e.key)};U.prototype._removeConditionFromMap=function(e){this._iConditions--;delete this._oConditionsMap[e];var t=this._aConditionKeys.indexOf(e);if(t>=0){this._aConditionKeys.splice(t,1)}};U.prototype.getConditions=function(){var e;var t=[];if(this._oConditionsMap){for(var i in this._oConditionsMap){e=this._oConditionsMap[i];var o=e.value;if(!o){o=this._getFormatedConditionText(e.operation,e.value1,e.value2,e.exclude,e.keyField,e.showIfGrouped)}if(!e._oGrid||e._oGrid.select.getSelected()){t.push({key:i,text:o,exclude:e.exclude,operation:e.operation,keyField:e.keyField,value1:e.value1,value2:this._hasSecondValue(e.operation)?e.value2:null,showIfGrouped:e.showIfGrouped})}}}return t};U.prototype.setOperations=function(e,t){t=t||"default";this._oTypeOperations[t]=e;this._updateAllOperations()};U.prototype.setValues=function(e,t){t=t||"default";this._oTypeValues[t]=e};U.prototype.addOperation=function(e,t){t=t||"default";this._oTypeOperations[t].push(e);this._updateAllOperations()};U.prototype.removeAllOperations=function(e){e=e||"default";this._oTypeOperations[e]=[];this._updateAllOperations()};U.prototype.getOperations=function(e){e=e||"default";return this._oTypeOperations[e]};U.prototype.setKeyFields=function(e){this._aKeyFields=e;this._aKeyFields.forEach(function(e){U._createKeyFieldTypeInstance(e)},this);this._updateKeyFieldItems(this._oConditionsGrid,true);this._updateAllConditionsEnableStates();this._createAndUpdateAllKeyFields();this._updateAllOperations()};U.prototype.addKeyField=function(e){this._aKeyFields.push(e);U._createKeyFieldTypeInstance(e);this._updateKeyFieldItems(this._oConditionsGrid,true,true);this._updateAllConditionsEnableStates();this._createAndUpdateAllKeyFields();this._updateAllOperations()};U._createKeyFieldTypeInstance=function(e){var t;if(!e.typeInstance){switch(e.type){case"boolean":e.typeInstance=new d;break;case"numc":if(!(e.formatSettings&&e.formatSettings.isDigitSequence)){A.error("sap.m.P13nConditionPanel","NUMC type support requires isDigitSequence==true!");e.formatSettings=Object.assign({},e.formatSettings,{isDigitSequence:true})}t=e.formatSettings;if(e.maxLength){t=Object.assign({},t,{maxLength:e.maxLength})}if(!t.maxLength){A.error("sap.m.P13nConditionPanel","NUMC type suppport requires maxLength!")}e.typeInstance=new u({},t);break;case"date":e.typeInstance=new h(Object.assign({},e.formatSettings,{strictParsing:true}),{});break;case"time":e.typeInstance=new g(Object.assign({},e.formatSettings,{strictParsing:true}),{});break;case"datetime":e.typeInstance=new _(Object.assign({},e.formatSettings,{strictParsing:true}),{displayFormat:"Date"});var i=e.typeInstance;if(!i.oFormat){i.formatValue(new Date,"string")}if(i.oFormat){i.oFormat.oFormatOptions.UTC=false}break;case"numeric":if(e.precision||e.scale){t={};if(e.precision){t["maxIntegerDigits"]=parseInt(e.precision)}if(e.scale){t["maxFractionDigits"]=parseInt(e.scale)}}e.typeInstance=new f(t);break;default:var o=e.formatSettings;if(e.maxLength){o=Object.assign({},o,{maxLength:e.maxLength})}e.typeInstance=new p({},o);break}}};U.prototype.removeAllKeyFields=function(){this._aKeyFields=[];this._updateKeyFieldItems(this._oConditionsGrid,true)};U.prototype.getKeyFields=function(){return this._aKeyFields};U.prototype.setAlwaysShowAddIcon=function(e){this.setProperty("alwaysShowAddIcon",e);if(this._oConditionsGrid){this._oConditionsGrid.toggleStyleClass("conditionRootGrid",this.getLayoutMode()!=="Desktop")}return this};U.prototype.setLayoutMode=function(e){this.setProperty("layoutMode",e);if(this._oConditionsGrid){this._oConditionsGrid.toggleStyleClass("conditionRootGrid",e!=="Desktop")}this._updateConditionFieldSpans(e);this._clearConditions();this._fillConditions();return this};U.prototype.setContainerQuery=function(e){this._unregisterResizeHandler();this.setProperty("containerQuery",e);this._registerResizeHandler();this._clearConditions();this._fillConditions();return this};U.prototype._updateConditionFieldSpans=function(e){if(this._aConditionsFields){var t=e==="Desktop";if(t){this._aConditionsFields[2].SpanFilter="L3 M3 S3";this._aConditionsFields[4].SpanFilter="L2 M2 S2";this._aConditionsFields[5].SpanFilter="L3 M3 S3";this._aConditionsFields[6].SpanFilter="L2 M2 S2";this._aConditionsFields[7].SpanFilter="L1 M1 S1"}var i=e==="Tablet";if(i){this._aConditionsFields[2].SpanFilter="L5 M5 S5";this._aConditionsFields[4].SpanFilter="L5 M5 S5";this._aConditionsFields[5].SpanFilter="L10 M10 S10";this._aConditionsFields[6].SpanFilter="L10 M10 S10";this._aConditionsFields[7].SpanFilter="L1 M1 S1"}}};U.prototype.init=function(){this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._sFromLabelText=this._oRb.getText("CONDITIONPANEL_LABELFROM");this._sToLabelText=this._oRb.getText("CONDITIONPANEL_LABELTO");this._sValueLabelText=this._oRb.getText("CONDITIONPANEL_LABELVALUE");this._sShowIfGroupedLabelText=this._oRb.getText("CONDITIONPANEL_LABELGROUPING");this._sValidationDialogFieldMessage=this._oRb.getText("CONDITIONPANEL_FIELDMESSAGE");this._oOperationsHelper=new w;this._oTypeOperations={default:[]};this._oTypeValues={default:[]};this._aKeyFields=[];this._oConditionsMap={};this._aConditionKeys=[];this._iConditions=0;this._sLayoutMode="Desktop";this._sConditionType="Filter";this._sAddRemoveIconTooltip="FILTER";this._iBreakPointTablet=n.media._predefinedRangeSets[n.media.RANGESETS.SAP_STANDARD].points[0];this._iBreakPointDesktop=n.media._predefinedRangeSets[n.media.RANGESETS.SAP_STANDARD].points[1];this._oConditionsGrid=new c({width:"100%",defaultSpan:"L12 M12 S12",hSpacing:0,vSpacing:0}).toggleStyleClass("conditionRootGrid",this.getLayoutMode()!=="Desktop");this._oConditionsGrid.addStyleClass("sapUiRespGridOverflowHidden");this._iFirstConditionIndex=0;this._iConditionPageSize=10;this._oInvisibleTextField=new a({text:this._oRb.getText("CONDITIONPANEL_FIELD_LABEL")});this._oInvisibleTextOperatorInputValue=new a({text:this._oRb.getText("CONDITIONPANEL_FIELD_VALUE_ARIA_LABEL")});this._oInvisibleTextOperator=new a({text:this._oRb.getText("CONDITIONPANEL_OPERATOR_ARIA_LABEL")});this._oInvisibleTextOperatorAddButton=new a({text:this._oRb.getText("CONDITIONPANEL_ADD_SCREENREADER_DESCRIPTION")});this.addAggregation("content",this._oInvisibleTextField);this.addAggregation("content",this._oInvisibleTextOperatorInputValue);this.addAggregation("content",this._oInvisibleTextOperator);this.addAggregation("content",this._oInvisibleTextOperatorAddButton);this.addAggregation("content",this._oConditionsGrid);this._registerResizeHandler();this._aConditionsFields=this._createConditionsFields();this._oButtonGroupSpan={SpanFilter:"L2 M2 S2",SpanSort:n.system.phone?"L2 M2 S4":"L2 M2 S3",SpanGroup:"L2 M2 S3"};this._updateConditionFieldSpans(this.getLayoutMode());this._fillConditions()};U.prototype._createPaginatorToolbar=function(){this._bPaginatorButtonsVisible=false;var e=this;this._oPrevButton=new v({icon:o.getIconURI("navigation-left-arrow"),tooltip:this._oRb.getText("WIZARD_FINISH"),visible:true,press:function(t){e._iFirstConditionIndex=Math.max(0,e._iFirstConditionIndex-e._iConditionPageSize);e._clearConditions();e._fillConditions()},layoutData:new T({priority:B.NeverOverflow})});this._oNextButton=new v({icon:o.getIconURI("navigation-right-arrow"),tooltip:this._oRb.getText("WIZARD_NEXT"),visible:true,press:function(t){e._iFirstConditionIndex+=e._iConditionPageSize;e._clearConditions();e._fillConditions()},layoutData:new T({priority:B.NeverOverflow})});this._oRemoveAllButton=new v({text:this._oRb.getText("CONDITIONPANEL_REMOVE_ALL"),visible:true,press:function(){e._aConditionKeys.forEach(function(e){this.fireDataChange({key:e,index:0,operation:"remove",newData:null})},e);this._iFirstConditionIndex=0;e.removeAllConditions()},layoutData:new T({priority:B.Low})});this._oAddButton=new v({icon:o.getIconURI("add"),visible:true,press:function(t){var i=e._createConditionRow(e._oConditionsGrid,undefined,null,0);e._changeField(i);setTimeout(function(){i.keyField.focus()});e._updatePaginatorToolbar()},layoutData:new T({priority:B.Low}),ariaDescribedBy:this._oInvisibleTextOperatorAddButton});this._oHeaderText=new I({wrapping:false,layoutData:new T({priority:B.NeverOverflow})});this._oPageText=new I({wrapping:false,textAlign:K.Center,layoutData:new T({priority:B.NeverOverflow})});this._oFilterField=new F({width:"12rem",layoutData:new T({priority:B.High})});this._oPaginatorToolbar=new S({height:"3rem",design:G.Transparent,content:[this._oHeaderText,new b,this._oFilterField,this._oPrevButton,this._oPageText,this._oNextButton,this._oRemoveAllButton,this._oAddButton]})};U.prototype._updatePaginatorToolbar=function(){if(this._sConditionType!=="Filter"||this.getMaxConditions()!=="-1"){return}var e=this._aConditionKeys.length;var t=1+Math.floor(Math.max(0,e-1)/this._iConditionPageSize);var i=1+Math.floor(this._iFirstConditionIndex/this._iConditionPageSize);var o=this.getParent();if(!this._oPaginatorToolbar){if(e>this._iConditionPageSize){this._createPaginatorToolbar();this.insertAggregation("content",this._oPaginatorToolbar,0);this._onGridResize()}else{if(o&&o.setHeaderText){if(this._sOrgHeaderText==undefined){this._sOrgHeaderText=o.getHeaderText()}o.setHeaderText(this._sOrgHeaderText+(e>0?" ("+e+")":""))}return}}this._oPrevButton.setEnabled(this._iFirstConditionIndex>0);this._oNextButton.setEnabled(this._iFirstConditionIndex+this._iConditionPageSize<e);if(o&&o.setHeaderToolbar){if(!o.getHeaderToolbar()){this.removeAggregation("content",this._oPaginatorToolbar);o.setHeaderToolbar(this._oPaginatorToolbar);o.attachExpand(function(e){this._setToolbarElementVisibility(e.getSource().getExpanded()&&this._bPaginatorButtonsVisible)}.bind(this))}}if(o&&o.setHeaderText){if(this._sOrgHeaderText==undefined){this._sOrgHeaderText=o.getHeaderText()}var n=this._sOrgHeaderText+(e>0?" ("+e+")":"");o.setHeaderText(n);this._oHeaderText.setText(n)}else{this._oHeaderText.setText(e+" Conditions")}this._oPageText.setText(i+"/"+t);this._bPaginatorButtonsVisible=this._bPaginatorButtonsVisible||t>1;this._setToolbarElementVisibility(this._bPaginatorButtonsVisible);if(i>t){this._iFirstConditionIndex-=Math.max(0,this._iConditionPageSize);this._clearConditions();this._fillConditions()}var a=0;this._oConditionsGrid.getContent().forEach(function(e){if(e.select.getSelected()){a++}},this);if(t==i&&e-this._iFirstConditionIndex>a){this._clearConditions();this._fillConditions()}};U.prototype._setToolbarElementVisibility=function(e){this._oPrevButton.setVisible(e);this._oNextButton.setVisible(e);this._oPageText.setVisible(e);this._oFilterField.setVisible(false);this._oAddButton.setVisible(e);this._oRemoveAllButton.setVisible(e)};U.prototype.exit=function(){this._clearConditions();this._unregisterResizeHandler();this._aConditionsFields=null;this._aKeys=null;this._aKeyFields=null;this._oTypeOperations=null;this._oRb=null;this._sFromLabelText=null;this._sToLabelText=null;this._sValueLabelText=null;this._sValidationDialogFieldMessage=null;this._oConditionsMap=null;this._aConditionKeys=[]};U.prototype._clearConditions=function(){var e=this._oConditionsGrid.getContent();e.forEach(function(e){for(var t in this._aConditionsFields){var i=this._aConditionsFields[t];if(e[i["ID"]]&&e.getContent().indexOf(e[i["ID"]])===-1){e[i["ID"]].destroy()}}},this);this._oConditionsGrid.destroyContent()};U.prototype._fillConditions=function(){var e,t;var i=0,o=this._getMaxConditionsAsNumber(),n=this._aConditionKeys.length;if(this._oConditionsMap){var a=this._sConditionType!=="Filter"||this.getMaxConditions()!=="-1"?9999:this._iConditionPageSize;n=Math.min(n,Math.min(o,this._iFirstConditionIndex+a));for(i=this._iFirstConditionIndex;i<n;i++){t=this._aConditionKeys[i];e=this._oConditionsMap[t];this._createConditionRow(this._oConditionsGrid,e,t)}}this._updatePaginatorToolbar();if((this.getAutoAddNewRow()||this._oConditionsGrid.getContent().length===0)&&this._oConditionsGrid.getContent().length<o){this._createConditionRow(this._oConditionsGrid)}};U.prototype._addCondition=function(e){var t=0;var i=this._getMaxConditionsAsNumber();if(this._oConditionsMap){for(var o in this._oConditionsMap){if(t<i&&e===this._oConditionsMap[o]){this._createConditionRow(this._oConditionsGrid,e,o,t)}t++}}this._updatePaginatorToolbar()};U.prototype._getMaxConditionsAsNumber=function(){return this.getMaxConditions()==="-1"?9999:parseInt(this.getMaxConditions())};U.prototype.onAfterRendering=function(){if(this.getLayoutMode()){this._sLayoutMode=this.getLayoutMode();return}};U.prototype._handleMediaChange=function(e){this._sLayoutMode=e.name;this._updateLayout(e)};U.prototype._unregisterResizeHandler=function(){if(this._sContainerResizeListener){s.deregister(this._sContainerResizeListener);this._sContainerResizeListener=null}n.media.detachHandler(this._handleMediaChange,this,n.media.RANGESETS.SAP_STANDARD)};U.prototype._registerResizeHandler=function(){if(this.getContainerQuery()){this._sContainerResizeListener=s.register(this._oConditionsGrid,this._onGridResize.bind(this));this._onGridResize()}else{n.media.attachHandler(this._handleMediaChange,this,n.media.RANGESETS.SAP_STANDARD)}};U.prototype._getKeyFromConditionGrid=function(e){var t=e.data("_key");if(!t){t=this._createConditionKey()}return t};U.prototype._createConditionKey=function(){var e=0;var t;do{t="condition_"+e;if(this.getExclude()){t="x"+t}e++}while(this._oConditionsMap[t]);return t};U.prototype._createConditionRow=function(e,t,i,o,n){var a,s=this;if(o===undefined){o=e.getContent().length}var r=new c({width:"100%",defaultSpan:"L12 M12 S12",hSpacing:1,vSpacing:0,containerQuery:this.getContainerQuery()}).data("_key",i);r.addStyleClass("sapUiRespGridOverflowHidden");for(var l in this._aConditionsFields){var d;var p=this._aConditionsFields[l];switch(p["Control"]){case"CheckBox":d=new x({enabled:false,layoutData:new m({span:p["Span"+this._sConditionType]})});this._setLayoutVisible(d,false);if(p["ID"]==="showIfGrouped"){d.setEnabled(true);d.setText(p["Label"]);d.attachSelect(function(){s._changeField(r)});d.setSelected(t?t.showIfGrouped:true)}else{if(t){d.setSelected(true);d.setEnabled(true)}}break;case"ComboBox":if(p["ID"]==="keyField"){d=new V({width:"100%",ariaLabelledBy:this._oInvisibleTextField});var u=d.setSelectedKey.bind(d);d.setSelectedKey=function(e){u(e);var t=s.getValidationExecutor();if(t){t()}};var h=d.setSelectedItem.bind(d);d.setSelectedItem=function(e){h(e);var t=s.getValidationExecutor();if(t){t()}};d.setLayoutData(new m({span:p["Span"+this._sConditionType]}));this._fillKeyFieldListItems(d,this._aKeyFields);if(d.attachSelectionChange){d.attachSelectionChange(function(t){var i=s.getValidationExecutor();if(i){i()}s._handleSelectionChangeOnKeyField(e,r)})}if(d.attachChange){d.attachChange(function(t){r.keyField.close();s._handleChangeOnKeyField(e,r)})}if(d.setSelectedItem){if(t){d.setSelectedKey(t.keyField);this._aKeyFields.forEach(function(e,i){var o=e.key;if(o===undefined){o=e}if(t.keyField===o){d.setSelectedItem(d.getItems()[i])}},this)}else{if(this.getUsePrevConditionSetting()&&!this.getAutoReduceKeyFieldItems()){if(o>0&&!i&&n){a=e.getContent()[o-1];if(a.keyField.getSelectedKey()){d.setSelectedKey(a.keyField.getSelectedKey())}else{if(!d.getSelectedItem()&&d.getItems().length>0){d.setSelectedItem(d.getItems()[0])}}}else{this._aKeyFields.some(function(e,t){if(e.isDefault){d.setSelectedItem(d.getItems()[t]);return true}if(!d.getSelectedItem()&&e.type!=="boolean"){d.setSelectedItem(d.getItems()[t])}},this);if(!d.getSelectedItem()&&d.getItems().length>0){d.setSelectedItem(d.getItems()[0])}}}else{this._aKeyFields.forEach(function(e,t){if(e.isDefault){d.setSelectedItem(d.getItems()[t])}},this)}}}}if(p["ID"]==="operation"){d=new D({width:"100%",ariaLabelledBy:this._oInvisibleTextOperator,layoutData:new m({span:p["Span"+this._sConditionType]})});d.attachChange(function(){s._handleChangeOnOperationField(e,r)});r[p["ID"]]=d;this._updateOperationItems(e,r);if(t){var g=this._getCurrentKeyFieldItem(r.keyField),_=this._getRelevantOperations(g),f=this.getCurrentOparation(t);_.some(function(e){if(f===e){d.setSelectedKey(e);return true}},this)}else{if(this.getUsePrevConditionSetting()){if(o>0&&i===null){var a=e.getContent()[o-1];d.setSelectedKey(a.operation.getSelectedKey())}}}}if(d.getSelectedItem&&d.getSelectedItem()&&d.getMetadata()._sUIDToken!=="box"){d.setTooltip(d.getSelectedItem().getTooltip()||d.getSelectedItem().getText())}break;case"TextField":var y=this._getCurrentKeyFieldItem(r.keyField);d=this._createValueField(y,p,r);d.oTargetGrid=e;if(t&&t[p["ID"]]!==undefined){var C=t[p["ID"]];if(d instanceof D){if(typeof C==="string"){C=r.oType.parseValue(C,"string")}if(typeof C==="boolean"){d.setSelectedIndex(C?2:1)}}else if(C!==null&&r.oType){if(typeof C==="string"&&r.oType.getName()==="sap.ui.comp.odata.type.StringDate"){d.setValue(C)}else{if(typeof C==="string"&&["String","sap.ui.model.odata.type.String","sap.ui.model.odata.type.Decimal"].indexOf(r.oType.getName())==-1){try{C=r.oType.parseValue(C,"string");d.setValue(r.oType.formatValue(C,"string"))}catch(e){A.error("sap.m.P13nConditionPanel","Value '"+C+"' does not have the expected type format for "+r.oType.getName()+".parseValue()")}}else{d.setValue(r.oType.formatValue(C,"string"))}}}else{d.setValue(C)}}break;case"Label":d=new L({text:p["Text"]+":",visible:this.getShowLabel(),layoutData:new m({span:p["Span"+this._sConditionType]})}).addStyleClass("conditionLabel");d.oTargetGrid=e;break}r[p["ID"]]=d;r.addContent(d)}this._addButtons(r,e);e.insertContent(r,o);this._updateOperationItems(e,r);this._changeOperationValueFields(e,r);this._updateAllConditionsEnableStates();this._updateConditionButtons(e);if(this.getAutoReduceKeyFieldItems()){this._updateKeyFieldItems(e,false)}if(this._sLayoutMode){this._updateLayout({name:this._sLayoutMode})}if(t){var v=this._getFormatedConditionText(t.operation,t.value1,t.value2,t.exclude,t.keyField,t.showIfGrouped);t._oGrid=r;t.value=v;this._oConditionsMap[i]=t}var S=r.operation.getSelectedKey();if(S==="BT"&&r.value1.setMinDate&&r.value2.setMaxDate){var T=r.value1.getDateValue();var b=r.value2.getDateValue();this._updateMinMaxDate(r,T,b)}else{this._updateMinMaxDate(r,null,null)}return r};U.prototype._handleRemoveCondition=function(e,t){var i=e.getContent().indexOf(t);this._removeCondition(e,t);if(this.getAutoReduceKeyFieldItems()){this._updateKeyFieldItems(e,false)}if(i>=0){i=Math.min(i,e.getContent().length-1);var t=e.getContent()[i];setTimeout(function(){t.remove.focus()})}this._updatePaginatorToolbar()};U.prototype._handleAddCondition=function(e,t,i){var o=e.getContent().indexOf(t);var n=this._createConditionRow(e,undefined,null,o+1,i);this._changeField(n);setTimeout(function(){if(n.keyField.getVisible()){n.keyField.focus();return}if(n.operation.getVisible()){n.operation.focus()}});this._updatePaginatorToolbar()};U.prototype._getCurrentKeyFieldItem=function(e){if(e.getSelectedKey&&e.getSelectedKey()){var t=e.getSelectedKey();var i=this._aKeyFields;for(var o in i){var n=i[o];if(n.key===t){return n}}}return null};U.prototype._createValueField=function(e,t,i){var o;var n;var a=this;var s={value:t["Value"],width:"100%",placeholder:t["Label"],change:function(e){a._validateAndFormatFieldValue(e);a._changeField(i,e)},layoutData:new m({span:t["Span"+this._sConditionType]})};if(e&&e.typeInstance){var l=e.typeInstance;n=this._findConfig(l,"ctrl");if(n==="DateTimePicker"&&l.getMetadata().getName()==="sap.ui.model.odata.type.DateTime"){if(!(l.oConstraints&&l.oConstraints.isDateOnly)){A.error("sap.m.P13nConditionPanel","sap.ui.model.odata.type.DateTime without displayFormat = Date is not supported!");l.oConstraints=Object.assign({},l.oConstraints,{isDateOnly:true})}n="DatePicker"}i.oType=l;if(n=="select"){var d=[];var p=e.values||this._oTypeValues[n]||["",l.formatValue(false,"string"),l.formatValue(true,"string")];p.forEach(function(e,t){d.push(new r({key:t.toString(),text:e.toString()}))});s={width:"100%",items:d,change:function(){a._changeField(i);a._makeFieldValid(o,true)},layoutData:new m({span:t["Span"+this._sConditionType]})};o=new D(s)}else if(n=="TimePicker"){if(l.oFormatOptions&&l.oFormatOptions.style){s.displayFormat=l.oFormatOptions.style}o=new P(s)}else if(n=="DateTimePicker"){if(l.oFormatOptions&&l.oFormatOptions.style){s.displayFormat=l.oFormatOptions.style}o=new k(s)}else if(n==="DatePicker"){if(l.oFormatOptions){s.displayFormat=l.oFormatOptions.style||l.oFormatOptions.pattern;if(l.isA("sap.ui.comp.odata.type.StringDate")){s.valueFormat="yyyyMMdd"}}o=new O(s)}else{o=new M(s);if(this._fSuggestCallback){e=this._getCurrentKeyFieldItem(i.keyField);if(e&&e.key){var u=this._fSuggestCallback(o,e.key);if(u){o._oSuggestProvider=u}}}}}else{i.oType=null;o=new M(s)}if(n!=="boolean"&&n!=="enum"&&o){o.onpaste=function(e){var t;if(window.clipboardData){t=window.clipboardData.getData("Text")}else{t=e.originalEvent.clipboardData.getData("text/plain")}var i=e.srcControl.getParent();var o=t.split(/\r\n|\r|\n/g);if(o&&o[o.length-1].trim()===""){o.pop()}var n=i.operation;var s=n.getSelectedKey();if(o&&o.length>1&&s!=="BT"){setTimeout(function(){var e=o?o.length:0;var t=a._getCurrentKeyFieldItem(i.keyField);var n=i.operation;for(var s=0;s<e;s++){if(a._aConditionKeys.length>=a._getMaxConditionsAsNumber()){break}var r=o[s].trim();if(r){var l;if(t.typeInstance){try{l=t.typeInstance.parseValue(r,"string");t.typeInstance.validateValue(l)}catch(e){A.error("sap.m.P13nConditionPanel.onPaste","not able to parse value "+r+" with type "+t.typeInstance.getName());r="";l=null}if(!l){continue}}var d={oOperation:n.getSelectedKey(),oKeyField:t.key,oPastedValue:l},p=a._getConditions(d);a._addCondition2Map(p);a.fireDataChange({key:p.key,index:p.index,operation:"add",newData:p})}}a._clearConditions();a._fillConditions()},0)}}}if(e&&e.maxLength&&o.setMaxLength){var h=-1;if(typeof e.maxLength==="string"){h=parseInt(e.maxLength)}if(typeof e.maxLength==="number"){h=e.maxLength}if(h>0&&(!o.getShowSuggestion||!o.getShowSuggestion())){o.setMaxLength(h)}}return o};U.prototype._getConditions=function(e){return{index:this._iConditions,key:this._createConditionKey(),exclude:this.getExclude(),operation:e.oOperation,keyField:e.oKeyField,value1:e.oPastedValue,value2:null}};U.prototype._fillOperationListItems=function(e,t,i){var o,n;if(i==="_STRING_"){i=""}if(i==="_TIME_"||i==="_DATETIME_"){i="_DATE_"}if(i==="_BOOLEAN_"||i==="_NUMC_"){i=""}e.destroyItems();t.forEach(function(t){n="CONDITIONPANEL_OPTION"+i+t;if(i&&this._oRb.hasText(n)){o=this._oRb.getText(n)}else{o=this._oRb.getText("CONDITIONPANEL_OPTION"+t)}e.addItem(new l({key:t,text:o,tooltip:o}))}.bind(this))};U.prototype._fillKeyFieldListItems=function(e,t){e.destroyItems();for(var i in t){var o=t[i];e.addItem(new l({key:o.key,text:o.text,tooltip:o.tooltip?o.tooltip:o.text}))}e.setEditable(e.getItems().length>1)};U.prototype._handleChangeOnOperationField=function(e,t){this._changeOperationValueFields(e,t);this._changeField(t)};U.prototype._handleSelectionChangeOnKeyField=function(e,t){if(this._sConditionType==="Filter"){this._updateOperationItems(e,t);this._createAndUpdateValueFields(e,t);this._changeOperationValueFields(e,t)}this._changeField(t)};U.prototype._handleChangeOnKeyField=function(e,t){if(this.getAutoReduceKeyFieldItems()){this._updateKeyFieldItems(e,false,false,t.keyField)}};U.prototype._createAndUpdateAllKeyFields=function(){var e=this._oConditionsGrid.getContent();e.forEach(function(e){this._createAndUpdateValueFields(this._oConditionsGrid,e);this._changeOperationValueFields(this._oConditionsGrid,e)},this)};U.prototype._createAndUpdateValueFields=function(e,t){var i=this._getCurrentKeyFieldItem(t.keyField);var o=function(e,t,o){var n=t.getValue?t.getValue():"";var a=e.indexOfContent(t);e.removeContent(t);if(t._oSuggestProvider){t._oSuggestProvider.destroy();t._oSuggestProvider=null}t.destroy();var s=this._aConditionsFields[o];t=this._createValueField(i,s,e);e[s["ID"]]=t;e.insertContent(t,a===-1?e.indexOfContent(e.operation)+1:a);var r,l;if(e.oType&&n){try{r=e.oType.parseValue(n,"string");e.oType.validateValue(r);l=e.oType.formatValue(r,"string");if(l&&l.toUpperCase&&this.getDisplayFormat()==="UpperCase"){l=l.toUpperCase()}t.setValue(l)}catch(e){var d=e.message;this._makeFieldValid(t,false,d);t.setValue(n)}}};o.bind(this)(t,t.value1,5);o.bind(this)(t,t.value2,6)};U.prototype._updateAllOperations=function(){var e=this._oConditionsGrid.getContent();e.forEach(function(e){this._updateOperationItems(this._oConditionsGrid,e);this._changeOperationValueFields(this._oConditionsGrid,e)},this)};U.prototype._updateOperationItems=function(e,t){var i=this._getCurrentKeyFieldItem(t.keyField);var o=i&&i.type||"";var n=t.operation;var a=n.getSelectedItem();var s=this._getRelevantOperations(i);this._fillOperationListItems(n,s,o?"_"+o.toUpperCase()+"_":"");if(a&&n.getItemByKey(a.getKey())){n.setSelectedKey(a.getKey())}else{n.setSelectedItem(n.getItems()[0])}this._sConditionType="Filter";if(s[0]===H.Ascending||s[0]===H.Descending){this._sConditionType="Sort"}if(s[0]===H.GroupAscending||s[0]===H.GroupDescending){this._sConditionType="Group"}this._adjustValue1Span(t)};U.prototype._updateKeyFieldItems=function(e,t,i,o){var n=e.getContent().length;var a;var s={};if(!t){for(a=0;a<n;a++){var r=e.getContent()[a].keyField;var d=r.getSelectedKey();if(d!=null&&d!==""){s[d]=true}}}for(a=0;a<n;a++){var r=e.getContent()[a].keyField;var p=e.getContent()[a].select;var u=r.getSelectedKey();var h=0;var g=this._aKeyFields;if(r!==o){if(i){h=g.length-1}else{r.destroyItems()}for(h;h<g.length;h++){var _=g[h];if(_.key==null||_.key===""||!s[_.key]||_.key===u){r.addItem(new l({key:_.key,text:_.text,tooltip:_.tooltip?_.tooltip:_.text}))}}r.setEditable(r.getItems().length>1)}if(u){r.setSelectedKey(u)}else if(r.getItems().length>0){r.setSelectedItem(r.getItems()[0])}if(!p.getSelected()){this._aKeyFields.some(function(e,t){if(e.isDefault){r.setSelectedItem(r.getItems()[t]);return true}if(!r.getSelectedItem()){if(e.type!=="boolean"){r.setSelectedItem(r.getItems()[t])}}},this)}if(r.getSelectedItem()){r.setTooltip(r.getSelectedItem().getTooltip()||r.getSelectedItem().getText())}}};U.prototype._changeOperationValueFields=function(e,t){var i=t.operation;var o=i.getSelectedKey();var n=t.value1;var a=t.value2;var s=t.showIfGrouped;var r,l,d;if(!o){return}if(this._hasSecondValue(o)){if(n.setPlaceholder&&n.getPlaceholder()!==this._sFromLabelText){n.setPlaceholder(this._sFromLabelText)}if(!n.getVisible()){n.setVisible(true);t.insertContent(n,t.getContent().length-1)}if(a.setPlaceholder&&a.getPlaceholder()!==this._sToLabelText){a.setPlaceholder(this._sToLabelText)}if(!a.getVisible()){a.setVisible(true);t.insertContent(a,t.getContent().length-this._getSecondValueNegativeIndex())}r=t.getContent();l=r.indexOf(n);d=r.indexOf(a);if(l>d){t.mAggregations.content[l]=a;t.mAggregations.content[d]=n}}else{if(o===H.GroupAscending||o===H.GroupDescending){if(n.getVisible()){n.setVisible(false);t.removeContent(n)}if(a.getVisible()){a.setVisible(false);t.removeContent(a)}if(i.getVisible()){i.setVisible(false);t.removeContent(i)}s.setVisible(this._getMaxConditionsAsNumber()!=1);this._setLayoutVisible(s,this._getMaxConditionsAsNumber()!=1)}else{if(this._hasNoValues(o)){if(n.getVisible()){n.setVisible(false);t.removeContent(n)}if(a.getVisible()){a.setVisible(false);t.removeContent(a)}t.removeContent(s)}else{if(n.setPlaceholder&&n.getPlaceholder()!==this._sValueLabelText){n.setPlaceholder(this._sValueLabelText)}if(!n.getVisible()){n.setVisible(true);t.insertContent(n,t.getContent().length-1)}if(a.getVisible()){a.setVisible(false);t.removeContent(a)}}}}this._adjustValue1Span(t)};U.prototype._adjustValue1Span=function(e){if(this._sConditionType==="Filter"&&e.value1&&e.operation){var t=e.operation;var i=this._aConditionsFields[5]["Span"+this._sConditionType];if(t.getSelectedKey()!=="BT"){i="L5 M10 S10"}var o=e.value1.getLayoutData();if(o.getSpan()!==i){o.setSpan(i)}}};U.prototype._getIndexOfCondition=function(e){var t=-1;e.getParent().getContent().some(function(i){if(i.select.getSelected()){t++}return i===e},this);return t+this._iFirstConditionIndex};U.prototype._makeFieldValid=function(e,t,i){if(t){e.setValueState(N.None);e.setValueStateText("")}else{e.setValueState(N.Warning);e.setValueStateText(i?i:this._sValidationDialogFieldMessage)}};U.prototype._validateAndFormatFieldValue=function(e){var t=e.oSource;var i=t.getParent();var o;if(t.getDateValue&&e){o=e.getParameter("value");var n=e.getParameter("valid");this._makeFieldValid(t,n);return}else{o=t.getValue&&t.getValue()}if(!i){return}if(this.getDisplayFormat()==="UpperCase"&&o){o=o.toUpperCase();t.setValue(o)}if(i.oType&&o){try{var a=i.oType.parseValue(o,"string");i.oType.validateValue(a);this._makeFieldValid(t,true);o=i.oType.formatValue(a,"string");t.setValue(o)}catch(e){var s=e.message;this._makeFieldValid(t,false,s)}}else{this._makeFieldValid(t,true)}};U.prototype._updateMinMaxDate=function(e,t,i){if(e.value1.setMinDate&&e.value2.setMaxDate){if(e.value1&&e.value1.setMaxDate){e.value1.setMaxDate(i instanceof Date?i:null)}if(e.value2&&e.value2.setMinDate){e.value2.setMinDate(t instanceof Date?t:null)}}};U.prototype._changeField=function(e,t){var i=e.keyField.getSelectedKey();if(e.keyField.getSelectedItem()){e.keyField.setTooltip(e.keyField.getSelectedItem().getTooltip()||e.keyField.getSelectedItem().getText())}else{e.keyField.setTooltip(null)}var o=e.operation.getSelectedKey();if(e.operation.getSelectedItem()){e.operation.setTooltip(e.operation.getSelectedItem().getTooltip()||e.operation.getSelectedItem().getText())}else{e.operation.setTooltip(null)}var n=function(e,i){var o;var n;if(e.getDateValue&&!e.isA("sap.m.TimePicker")&&i.getName()!=="sap.ui.comp.odata.type.StringDate"){n=e.getDateValue();if(i&&n){if(t&&t.getParameter("valid")||e.isValidValue()){o=i.formatValue(n,"string")}else{o=""}}}else{o=this._getValueTextFromField(e);n=o;if(i&&i.getName()==="sap.ui.comp.odata.type.StringDate"){o=i.formatValue(n,"string")}else if(i&&o){try{n=i.parseValue(o,"string");i.validateValue(n)}catch(e){A.error("sap.m.P13nConditionPanel","not able to parse value "+o+" with type "+i.getName());o=""}}}return[n,o]}.bind(this);var a=n(e.value1,e.oType);var s=a[0],r=a[1];a=n(e.value2,e.oType);var l=a[0],d=a[1];if(this._hasSecondValue(o)){this._updateMinMaxDate(e,s,l)}else{this._updateMinMaxDate(e,null,null)}var p=this._getCurrentKeyFieldItem(e.keyField);if(p&&p.type==="numc"){if([H.Contains,H.EndsWith].indexOf(o)!=-1){s=e.oType.formatValue(s,"string")}}var u=e.showIfGrouped.getSelected();var h=this.getExclude();var g=e.select;var _="";var f;if(i===""||i==null){i=null;f=this._getKeyFromConditionGrid(e);this._removeConditionFromMap(f);this._enableCondition(e,false);var y=this._getIndexOfCondition(e);if(g.getSelected()){g.setSelected(false);g.setEnabled(false);this._bIgnoreSetConditions=true;this.fireDataChange({key:f,index:y,operation:"remove",newData:null});this._bIgnoreSetConditions=false}return}this._enableCondition(e,true);_=this._getFormatedConditionText(o,r,d,h,i,u);var c={value:_,exclude:h,operation:o,keyField:i,value1:s,value2:this._hasSecondValue(o)?l:null,showIfGrouped:u};f=this._getKeyFromConditionGrid(e);if(_!==""){g.setSelected(true);g.setEnabled(true);var o="update";if(!this._oConditionsMap[f]){o="add"}this._oConditionsMap[f]=c;if(o==="add"){this._aConditionKeys.splice(this._getIndexOfCondition(e),0,f)}e.data("_key",f);this.fireDataChange({key:f,index:this._getIndexOfCondition(e),operation:o,newData:c})}else if(this._oConditionsMap[f]!==undefined){this._removeConditionFromMap(f);e.data("_key",null);var y=this._getIndexOfCondition(e);if(g.getSelected()){g.setSelected(false);g.setEnabled(false);this._bIgnoreSetConditions=true;this.fireDataChange({key:f,index:y,operation:"remove",newData:null});this._bIgnoreSetConditions=false}}this._updatePaginatorToolbar()};U.prototype._getValueTextFromField=function(e){if(e instanceof D){return e.getSelectedItem()?e.getSelectedItem().getText():""}return e.getValue()};U.prototype._updateAllConditionsEnableStates=function(){var e=this._oConditionsGrid.getContent();e.forEach(function(e){var t=this._getCurrentKeyFieldItem(e.keyField);var i=t&&t.key!==undefined?t.key:t;var o=i!==""&&i!==null;this._enableCondition(e,o)},this)};U.prototype._enableCondition=function(e,t){e.operation.setEnabled(t);e.value1.setEnabled(t);e.value2.setEnabled(t);e.showIfGrouped.setEnabled(t)};U.prototype._removeCondition=function(e,t){var i=this._getKeyFromConditionGrid(t);var o=-1;if(t.select.getSelected()){o=this._getIndexOfCondition(t)}this._removeConditionFromMap(i);t.destroy();if(e.getContent().length<1){this._createConditionRow(e)}else{this._updateConditionButtons(e)}if(o>=0){this.fireDataChange({key:i,index:o,operation:"remove",newData:null})}};U.prototype._updateConditionButtons=function(e){var t=this._getMaxConditionsAsNumber();var i=e.getContent().length;for(var o=0;o<i;o++){var n=e.getContent()[o].add;if(this.getAlwaysShowAddIcon()&&i<t||o===i-1&&o<t-1){n.removeStyleClass("displayNone")}else{n.addStyleClass("displayNone")}var a=e.getContent()[o].remove;if(t===1||o===0&&i===1&&this.getDisableFirstRemoveIcon()){a.addStyleClass("displayNone")}else{a.removeStyleClass("displayNone")}}};U.prototype.validateConditions=function(){var e=this;var t=function(t){var i=true;for(var o=0;o<t.length;o++){var n=t[o];var a=e._checkCondition(n,o===t.length-1);i=i&&a}return i};return t(this._oConditionsGrid.getContent())};U.prototype.removeValidationErrors=function(){this._oConditionsGrid.getContent().forEach(function(e){var t=e.value1;var i=e.value2;t.setValueState(N.None);t.setValueStateText("");i.setValueState(N.None);i.setValueStateText("")},this)};U.prototype.removeInvalidConditions=function(){var e=[];this._oConditionsGrid.getContent().forEach(function(t){if(t.value1.getValueState()!==N.None||t.value2.getValueState()!==N.None){e.push(t)}},this);e.forEach(function(e){this._removeCondition(this._oConditionsGrid,e);if(this.getAutoReduceKeyFieldItems()){this._updateKeyFieldItems(this._oConditionsGrid,false)}},this)};U.prototype._checkCondition=function(e,t){var i=true;var o=e.value1;var n=e.value2;var a=o&&(o.getVisible()&&!this._getValueTextFromField(o));var s=o&&o.getVisible()&&o.getValueState?o.getValueState():N.None;var r=n&&(n.getVisible()&&!this._getValueTextFromField(n));var l=n&&n.getVisible()&&n.getValueState?n.getValueState():N.None;var d=e.operation.getSelectedKey();if(this._hasSecondValue(d)){if(!a?r:!r){if(a){o.setValueState(N.Warning);o.setValueStateText(this._sValidationDialogFieldMessage)}if(r){n.setValueState(N.Warning);n.setValueStateText(this._sValidationDialogFieldMessage)}i=false}else if(s!==N.None||l!==N.None){i=false}else{o.setValueState(N.None);o.setValueStateText("");n.setValueState(N.None);n.setValueStateText("")}}if(o.getVisible()&&o.getValueState&&o.getValueState()!==N.None||n.getVisible()&&n.getValueState&&n.getValueState()!==N.None){i=false}return i};U.prototype._getFormatedConditionText=function(e,t,i,o,n,a){var s=U.getFormatedConditionText(e,t,i,o);if(!s){switch(e){case H.Initial:s="=''";break;case H.NotEmpty:s="!''";break;case H.Ascending:s="ascending";break;case H.GroupAscending:s="ascending";s+=" showIfGrouped:"+a;break;case H.Descending:s="descending";break;case H.GroupDescending:s="descending";s+=" showIfGrouped:"+a;break;case H.Total:s="total";break;case H.Average:s="average";break;case H.Minimum:s="minimum";break;case H.Maximum:s="maximum";break}if(o&&s!==""){s="!("+s+")"}}if(this._aKeyFields&&this._aKeyFields.length>1){var r=null;for(var l=0;l<this._aKeyFields.length;l++){var d=this._aKeyFields[l];if(typeof d!=="string"){if(d.key===n&&d.text){r=d.text}}}if(r&&s!==""){s=r+": "+s}}return s};U._oConditionMap={EQ:"=$0",GT:">$0",GE:">=$0",LT:"<$0",LE:"<=$0",Contains:"*$0*",StartsWith:"$0*",EndsWith:"*$0",BT:"$0...$1",Empty:"<$r>"};(function(){var e=sap.ui.getCore().getLibraryResourceBundle("sap.m");U._oConditionMap[H.Empty]=U._oConditionMap[H.Empty].replace("$r",e.getText("CONDITIONPANEL_OPTIONEmpty"))})();U._templateReplace=function(e,t){return e.replace(/\$\d/g,function(e){return t[parseInt(e.substr(1))]})};U.getFormatedConditionText=function(e,t,i,o){var n="";switch(e){case H.Empty:n=U._templateReplace(U._oConditionMap[e],[]);break;case H.EQ:case H.GT:case H.GE:case H.LT:case H.LE:case H.Contains:case H.StartsWith:case H.EndsWith:if(t!==""&&t!==undefined&&t!==null){n=U._templateReplace(U._oConditionMap[e],[t])}break;case H.BT:if(t!==""&&t!==undefined&&t!==null){if(i!==""&&i!==undefined&&i!==null){n=U._templateReplace(U._oConditionMap[e],[t,i])}}break;default:break}if(o&&n!==""){n="!("+n+")"}return n};U.prototype._updateLayout=function(e){if(!this._oConditionsGrid){return}var t=this._oConditionsGrid.getContent();var i=this._aConditionsFields.length;var o=i;if(e.name==="Tablet"){o=5}if(e.name==="Phone"){o=3}if(this._sConditionType==="Filter"){for(var n=0;n<t.length;n++){var a=t[n];a.ButtonContainer.removeStyleClass("floatRight");a.removeContent(a.ButtonContainer);a.insertContent(a.ButtonContainer,o);if(!this.getAlwaysShowAddIcon()){if(o!==i){a.ButtonContainer.removeContent(a.add);a.addContent(a.add)}else{a.removeContent(a.add);a.ButtonContainer.addContent(a.add)}}}}};U.prototype._onGridResize=function(){var e;if(this._oPaginatorToolbar&&this._oConditionsGrid&&this._oConditionsGrid.getContent().length>0){var t=this._oConditionsGrid.getContent()[0];if(t.remove&&t.remove.$().position()){e=0;if(this._oPaginatorToolbar.getParent()&&this._oPaginatorToolbar.getParent().getExpandable&&this._oPaginatorToolbar.getParent().getExpandable()){e=48-4}var i=t.remove.$().position().left-e+t.remove.$().width();this._oPaginatorToolbar.setWidth(i+"px")}}var o=this._oConditionsGrid.getDomRef();if(!o){return}if(!jQuery(o).is(":visible")){return}e=o.clientWidth;var n={};if(e<=this._iBreakPointTablet){n.name="Phone"}else if(e>this._iBreakPointTablet&&e<=this._iBreakPointDesktop){n.name="Tablet"}else{n.name="Desktop"}if(n.name==="Phone"&&this._sLayoutMode!==n.name){this._updateLayout(n);this._sLayoutMode=n.name}if(n.name==="Tablet"&&this._sLayoutMode!==n.name){this._updateLayout(n);this._sLayoutMode=n.name}if(n.name==="Desktop"&&this._sLayoutMode!==n.name){this._updateLayout(n);this._sLayoutMode=n.name}};U.prototype._findConfig=function(e,t){if(typeof e==="object"){e=e.getMetadata().getName()}var i;while(e&&!(i=this._getConfig(e,t))){e=this._getParentType(e)}return i};U.prototype._getConfig=function(e,t){var i=this._mOpsForType[e];if(i){return i[t]}};U.prototype._getParentType=function(e){return this._mTypes[e]};U.prototype._getRelevantOperations=function(e){var t,i=e&&e.type&&this.getOperations(e.type);if(e&&e.operations){t=e.operations}else if(Array.isArray(i)&&i.length>0){t=i}else{t=this.getOperations("default")}return t};U.prototype._addButtons=function(e,t){var i=this;var n=new C({layoutData:new m({span:this.getLayoutMode()==="Desktop"?"L2 M2 S2":this._oButtonGroupSpan["Span"+this._sConditionType]})}).addStyleClass("floatRight");e.addContent(n);e["ButtonContainer"]=n;var a=new v({type:R.Transparent,icon:o.getIconURI("decline"),tooltip:this._oRb.getText("CONDITIONPANEL_REMOVE"+(this._sAddRemoveIconTooltipKey?"_"+this._sAddRemoveIconTooltipKey:"")+"_TOOLTIP"),press:function(){i._handleRemoveCondition(this.oTargetGrid,e)},layoutData:new m({span:this.getLayoutMode()==="Desktop"?"L1 M1 S1":"L1 M2 S2"})});a.oTargetGrid=t;n.addContent(a);e["remove"]=a;var s=new v({type:R.Transparent,icon:o.getIconURI("add"),tooltip:this._oRb.getText("CONDITIONPANEL_ADD"+(this._sAddRemoveIconTooltipKey?"_"+this._sAddRemoveIconTooltipKey:"")+"_TOOLTIP"),press:function(){i._handleAddCondition(this.oTargetGrid,e,true)},layoutData:new m({span:this.getLayoutMode()==="Desktop"?"L1 M1 S1":"L1 M10 S10"})});s.oTargetGrid=t;s.addStyleClass("conditionAddBtnFloatRight");n.addContent(s);e["add"]=s};U.prototype.getCurrentOparation=function(e){return e.operation};U.prototype.setSuggestCallback=function(e){this._fSuggestCallback=e};U.prototype._hasSecondValue=function(e){return e===H.BT};U.prototype._getSecondValueNegativeIndex=function(){return 1};U.prototype._createConditionsFields=function(){return[{ID:"select",Label:"",SpanFilter:"L1 M1 S1",SpanSort:"L1 M1 S1",SpanGroup:"L1 M1 S1",Control:"CheckBox",Value:""},{ID:"keyFieldLabel",Text:"Sort By",SpanFilter:"L1 M1 S1",SpanSort:"L1 M1 S1",SpanGroup:"L1 M1 S1",Control:"Label"},{ID:"keyField",Label:"",SpanFilter:"L3 M5 S10",SpanSort:"L5 M5 S12",SpanGroup:"L4 M4 S12",Control:"ComboBox"},{ID:"operationLabel",Text:"Sort Order",SpanFilter:"L1 M1 S1",SpanSort:"L1 M1 S1",SpanGroup:"L1 M1 S1",Control:"Label"},{ID:"operation",Label:"",SpanFilter:"L2 M5 S10",SpanSort:n.system.phone?"L5 M5 S8":"L5 M5 S9",SpanGroup:"L2 M5 S10",Control:"ComboBox"},{ID:"value1",Label:this._sFromLabelText,SpanFilter:"L3 M10 S10",SpanSort:"L3 M10 S10",SpanGroup:"L3 M10 S10",Control:"TextField",Value:""},{ID:"value2",Label:this._sToLabelText,SpanFilter:"L2 M10 S10",SpanSort:"L2 M10 S10",SpanGroup:"L2 M10 S10",Control:"TextField",Value:""},{ID:"showIfGrouped",Label:this._sShowIfGroupedLabelText,SpanFilter:"L1 M10 S10",SpanSort:"L1 M10 S10",SpanGroup:"L3 M4 S9",Control:"CheckBox",Value:"false"}]};U.prototype._hasNoValues=function(e){return e===H.Empty||e===H.Initial||e===H.Ascending||e===H.Descending||e===H.Total||e===H.Average||e===H.Minimum||e===H.Maximum};U.prototype._setLayoutVisible=function(e,t){var i;if(e.getLayoutData===undefined){return}i=e.getLayoutData&&e.getLayoutData();if(i&&(i.getMetadata&&i.getMetadata().getName()==="sap.ui.layout.GridData")){i.setVisibleXL(t);i.setVisibleL(t);i.setVisibleM(t);i.setVisibleS(t)}else{e.setLayoutData(new m({visibleXL:t,visibleL:t,visibleM:t,visibleS:t}))}e.setVisible(t)};U.prototype._mTypes={base:undefined,string:"base",numeric:"base",date:"base",time:"base",boolean:"base",int:"numeric",float:"numeric","sap.ui.model.type.Boolean":"boolean","sap.ui.model.type.Date":"date","sap.ui.model.type.FileSize":"string","sap.ui.model.type.Float":"float","sap.ui.model.type.Integer":"int","sap.ui.model.type.String":"string","sap.ui.model.type.Time":"time","sap.ui.comp.odata.type.StringDate":"date","sap.ui.model.odata.type.Boolean":"boolean","sap.ui.model.odata.type.Byte":"int","sap.ui.model.odata.type.Date":"date","sap.ui.model.odata.type.DateTime":"datetime","sap.ui.model.odata.type.DateTimeOffset":"datetime","sap.ui.model.odata.type.Decimal":"float","sap.ui.model.odata.type.Double":"float","sap.ui.model.odata.type.Single":"float","sap.ui.model.odata.type.Guid":"string","sap.ui.model.odata.type.Int16":"int","sap.ui.model.odata.type.Int32":"int","sap.ui.model.odata.type.Int64":"int","sap.ui.model.odata.type.Raw":"string","sap.ui.model.odata.type.SByte":"int","sap.ui.model.odata.type.String":"string","sap.ui.model.odata.type.Time":"time","sap.ui.model.odata.type.TimeOfDay":"time","Edm.Boolean":"sap.ui.model.odata.type.Boolean","Edm.Byte":"sap.ui.model.odata.type.Byte","Edm.Date":"sap.ui.model.odata.type.Date","Edm.DateTime":"sap.ui.model.odata.type.DateTime","Edm.DateTimeOffset":"sap.ui.model.odata.type.DateTimeOffset","Edm.Decimal":"sap.ui.model.odata.type.Decimal","Edm.Double":"sap.ui.model.odata.type.Double","Edm.Single":"sap.ui.model.odata.type.Single","Edm.Guid":"sap.ui.model.odata.type.Guid","Edm.Int16":"sap.ui.model.odata.type.Int16","Edm.Int32":"sap.ui.model.odata.type.Int32","Edm.Int64":"sap.ui.model.odata.type.Int64","Edm.SByte":"sap.ui.model.odata.type.SByte","Edm.String":"sap.ui.model.odata.type.String","Edm.Time":"sap.ui.model.odata.type.Time","Edm.TimeOfDay":"sap.ui.model.odata.type.TimeOfDay"};U.prototype._mOpsForType={base:{ctrl:"input"},string:{ctrl:"input"},date:{ctrl:"DatePicker"},datetime:{ctrl:"DateTimePicker"},numeric:{ctrl:"input"},time:{ctrl:"TimePicker"},boolean:{ctrl:"select"}};return U});
//# sourceMappingURL=P13nConditionPanel.js.map