/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/m/delegate/DateNavigation","sap/ui/core/Control","sap/ui/base/ManagedObjectObserver","sap/ui/unified/library","sap/ui/unified/calendar/CalendarUtils","sap/ui/unified/calendar/CalendarDate","sap/ui/unified/calendar/DatesRow","sap/ui/unified/calendar/OneMonthDatesRow","sap/ui/unified/calendar/MonthsRow","sap/ui/unified/calendar/TimesRow","sap/ui/unified/DateRange","sap/ui/unified/DateTypeRange","sap/ui/unified/CalendarAppointment","sap/ui/unified/CalendarRow","sap/ui/unified/CalendarRowRenderer","sap/ui/Device","sap/ui/core/Core","sap/ui/core/Element","sap/ui/core/Renderer","sap/ui/core/ResizeHandler","sap/ui/core/InvisibleText","sap/ui/core/dnd/DragInfo","sap/ui/core/dnd/DropInfo","sap/ui/core/dnd/DragDropInfo","sap/ui/core/format/DateFormat","sap/ui/core/Configuration","sap/ui/core/date/CalendarWeekNumbering","sap/ui/core/date/CalendarUtils","sap/ui/core/Locale","sap/ui/core/date/UI5Date","sap/ui/events/KeyCodes","sap/m/Avatar","sap/m/Toolbar","sap/m/Table","sap/m/Column","sap/m/ColumnListItem","sap/m/ColumnListItemRenderer","sap/m/SegmentedButtonItem","sap/m/StandardListItem","sap/m/PlanningCalendarHeader","sap/m/PlanningCalendarRenderer","sap/m/PlanningCalendarView","sap/m/CheckBox","sap/m/library","sap/base/util/deepEqual","sap/base/Log","sap/m/List","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/control"],function(e,t,a,i,n,r,s,o,l,g,h,p,d,c,u,f,_,y,m,v,D,w,C,S,T,R,A,I,M,b,P,k,H,O,V,N,E,L,U,x,W,z,B,K,F,j,J,jQuery){"use strict";var Y=K.Sticky;var G=i.CalendarDayType;var $=K.ListMode;var q=K.ToolbarDesign;var X=K.PlanningCalendarBuiltInView;var Q=K.ScreenSize;var Z=i.CalendarAppointmentVisualization;var ee=i.GroupAppointmentsMode;var te=i.CalendarIntervalType;var ae=i.CalendarAppointmentHeight;var ie=i.CalendarAppointmentRoundWidth;var ne=K.AvatarShape;var re="DragDropConfig";var se="ResizeConfig";var oe="CreateConfig";var le="-CLI";var ge=t.extend("sap.m.PlanningCalendar",{metadata:{library:"sap.m",properties:{startDate:{type:"object",group:"Data"},viewKey:{type:"string",group:"Appearance",defaultValue:te.Hour},singleSelection:{type:"boolean",group:"Misc",defaultValue:true},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},showIntervalHeaders:{type:"boolean",group:"Appearance",defaultValue:true},showEmptyIntervalHeaders:{type:"boolean",group:"Appearance",defaultValue:true},showRowHeaders:{type:"boolean",group:"Appearance",defaultValue:true},noDataText:{type:"string",group:"Misc",defaultValue:null},groupAppointmentsMode:{type:"sap.ui.unified.GroupAppointmentsMode",group:"Appearance",defaultValue:ee.Collapsed},appointmentsReducedHeight:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},appointmentHeight:{type:"sap.ui.unified.CalendarAppointmentHeight",group:"Appearance",defaultValue:ae.Regular},appointmentRoundWidth:{type:"sap.ui.unified.CalendarAppointmentRoundWidth",group:"Appearance",defaultValue:ie.None},appointmentsVisualization:{type:"sap.ui.unified.CalendarAppointmentVisualization",group:"Appearance",defaultValue:Z.Standard},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null},showDayNamesLine:{type:"boolean",group:"Appearance",defaultValue:false},showWeekNumbers:{type:"boolean",group:"Appearance",defaultValue:false},builtInViews:{type:"string[]",group:"Appearance",defaultValue:[]},stickyHeader:{type:"boolean",group:"Appearance",defaultValue:false},firstDayOfWeek:{type:"int",group:"Appearance",defaultValue:-1},calendarWeekNumbering:{type:"sap.ui.core.date.CalendarWeekNumbering",group:"Appearance",defaultValue:null},primaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance"},secondaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance"},multipleAppointmentsSelection:{type:"boolean",group:"Data",defaultValue:false},iconShape:{type:"sap.m.AvatarShape",group:"Appearance",defaultValue:ne.Circle}},aggregations:{rows:{type:"sap.m.PlanningCalendarRow",multiple:true,singularName:"row"},views:{type:"sap.m.PlanningCalendarView",multiple:true,singularName:"view"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},toolbarContent:{type:"sap.ui.core.Control",multiple:true,singularName:"toolbarContent",forwarding:{getter:"_getHeader",aggregation:"actions"}},table:{type:"sap.m.Table",multiple:false,visibility:"hidden"},header:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{appointmentSelect:{parameters:{appointment:{type:"sap.ui.unified.CalendarAppointment"},appointments:{type:"sap.ui.unified.CalendarAppointment[]"},multiSelect:{type:"boolean"},domRefId:{type:"string"}}},intervalSelect:{parameters:{startDate:{type:"object"},endDate:{type:"object"},subInterval:{type:"boolean"},row:{type:"sap.m.PlanningCalendarRow"}}},rowSelectionChange:{parameters:{rows:{type:"sap.m.PlanningCalendarRow[]"}}},startDateChange:{},viewChange:{},rowHeaderClick:{parameters:{headerId:{type:"string"},row:{type:"sap.m.PlanningCalendarRow"}}},rowHeaderPress:{parameters:{headerId:{type:"string"},row:{type:"sap.m.PlanningCalendarRow"}}}},designtime:"sap/m/designtime/PlanningCalendar.designtime"},constructor:function(e,a){t.prototype.constructor.apply(this,arguments);if(typeof e!=="string"){a=e}if(a&&typeof a.customAppointmentsSorterCallback==="function"){this._fnCustomSortedAppointments=a.customAppointmentsSorterCallback}},renderer:W});var he=["_oTimesRow","_oDatesRow","_oMonthsRow","_oWeeksRow","_oOneMonthsRow"],pe={};pe[te.Day]={sInstanceName:"_oDatesRow",sIdSuffix:"-DatesRow",oClass:s};pe[te.Week]={sInstanceName:"_oWeeksRow",sIdSuffix:"-WeeksRow",oClass:s};pe[te.OneMonth]={sInstanceName:"_oOneMonthsRow",sIdSuffix:"-OneMonthsRow",oClass:o};var de=Q.Desktop;var ce=[X.Hour,X.Day,X.Month,X.Week,X.OneMonth];var ue={PHONE:"600",TABLET:"1024"};var fe={MONTH:"month",MONTH_PICKER:"monthPicker",YEAR_PICKER:"yearPicker",YEAR_RANGE_PICKER:"yearRangePicker"};var _e={onAfterRendering:function(){this.setProperty("_currentPicker",fe.MONTH);this.removeDelegate(_e)}};var ye={onAfterRendering:function(){this.setProperty("_currentPicker",fe.MONTH_PICKER);this.removeDelegate(ye)}};var me={onAfterRendering:function(){this.setProperty("_currentPicker",fe.YEAR_PICKER);this.removeDelegate(me)}};var ve=["sap.ui.unified.calendar.TimesRow","sap.ui.unified.calendar.DatesRow","sap.ui.unified.calendar.MonthsRow","sap.ui.unified.calendar.OneMonthDatesRow"];var De=t.extend("sap.m._PlanningCalendarInternalHeader",{metadata:{aggregations:{toolbar:{type:"sap.m.Toolbar",multiple:false},allCheckBox:{type:"sap.m.CheckBox",multiple:false}}},renderer:{apiVersion:2,render:function(e,t){e.openStart("div",t);e.class("sapMPlanCalHead");e.openEnd();var a=t.getToolbar();if(a){e.renderControl(a)}var i=t.getAllCheckBox();if(i){e.renderControl(i)}e.close("div")}}});ge.prototype.init=function(){this._dateNav=new e;this._iBreakPointTablet=f.media._predefinedRangeSets[f.media.RANGESETS.SAP_STANDARD_EXTENDED].points[0];this._iBreakPointDesktop=f.media._predefinedRangeSets[f.media.RANGESETS.SAP_STANDARD_EXTENDED].points[1];this._iBreakPointLargeDesktop=f.media._predefinedRangeSets[f.media.RANGESETS.SAP_STANDARD_EXTENDED].points[2];if(f.system.phone||jQuery("html").hasClass("sapUiMedia-Std-Phone")){this._iSize=0;this._iSizeScreen=0}else if((f.system.tablet||jQuery("html").hasClass("sapUiMedia-Std-Tablet"))&&!(f.system.desktop||jQuery("html").hasClass("sapUiMedia-Std-Desktop"))){this._iSize=1;this._iSizeScreen=1}else{this._iSize=2;this._iSizeScreen=2}this.addStyleClass("sapMSize"+this._iSize);this.setAggregation("header",this._createHeader());this._attachHeaderEvents();this._oRB=_.getLibraryResourceBundle("sap.m");var t=this.getId();this._oIntervalTypeSelect=this._getHeader()._getOrCreateViewSwitch();this._oIntervalTypeSelect.attachEvent("selectionChange",we,this);this._oTodayButton=this._getHeader()._getTodayButton();this._oCalendarHeader=new De(t+"-CalHead",{});this._oCalendarHeader.isRelative=this.isRelative.bind(this);this._oCalendarHeader._getRelativeInfo=this._getRelativeInfo.bind(this);this._oInfoToolbar=new H(t+"-InfoToolbar",{height:"auto",design:q.Transparent,content:[this._oCalendarHeader,this._oTimesRow],ariaLabelledBy:D.getStaticId("sap.m","PC_INTERVAL_TOOLBAR")});var a=new O(t+"-Table",{sticky:[],infoToolbar:this._oInfoToolbar,mode:$.SingleSelectMaster,columns:[new V({styleClass:"sapMPlanCalRowHead"}),new V({width:"80%",styleClass:"sapMPlanCalAppRow",minScreenWidth:de,demandPopin:true})],ariaLabelledBy:t+"-Descr"});a.attachEvent("selectionChange",Le,this);a.addDelegate({onBeforeRendering:function(){if(this._rowHeaderPressEventMouse){this._rowHeaderPressEventMouse.off()}if(this._rowHeaderPressEventKeyboard){this._rowHeaderPressEventKeyboard.off()}},onAfterRendering:function(){this._rowHeaderPressEventMouse=a.$().find(".sapMPlanCalRowHead > div.sapMLIB").on("click",function(e){var t=y.closestTo(e.currentTarget),a=Oe(t.getParent()),i=t.getId();this.fireRowHeaderClick({headerId:i,row:a});this.fireRowHeaderPress({headerId:i,row:a})}.bind(this));this._rowHeaderPressEventKeyboard=a.$().find(".sapMPlanCalRowHead").on("keydown",function(e){if(e.which===P.SPACE||e.which===P.ENTER){var t=y.closestTo(e.currentTarget),a=Oe(t),i=t.getAggregation("cells")[0].getId();this.fireRowHeaderPress({headerId:i,row:a})}}.bind(this));this._adjustColumnHeadersTopOffset()}},false,this);a.getStickyFocusOffset=Je.bind(this);this.setAggregation("table",a,true);this.setStartDate(b.getInstance());this._resizeProxy=Re.bind(this);this._fnCustomSortedAppointments=undefined;this.iWidth=0};ge.prototype.exit=function(){if(this._sResizeListener){v.deregister(this._sResizeListener);this._sResizeListener=undefined}f.orientation.detachHandler(this._updateStickyHeader,this);if(this._sUpdateCurrentTime){clearTimeout(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined}var e=this.getAggregation("table");e.removeAllItems();he.forEach(function(e){if(this[e]){this[e]._oPlanningCalendar=undefined;this[e].destroy();this[e]=undefined}},this);if(this._oViews){for(var t in this._oViews){this._oViews[t].destroy()}}if(this._oSelectAllCheckBox){this._oSelectAllCheckBox.destroy()}if(this._rowHeaderPressEventMouse){this._rowHeaderPressEventMouse.off();this._rowHeaderPressEventMouse=null}if(this._rowHeaderPressEventKeyboard){this._rowHeaderPressEventKeyboard.off();this._rowHeaderPressEventKeyboard=null}};ge.prototype.onBeforeRendering=function(){this._bBeforeRendering=true;this._updateHeader();this._adjustViewKey();We.call(this);if(this._sUpdateCurrentTime){clearTimeout(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined}this._updatePickerSelection();this._updateHeaderButtons();f.orientation.detachHandler(this._updateStickyHeader,this);this._bBeforeRendering=undefined;this._toggleStickyClasses()};ge.prototype._updateHeader=function(){this._getHeader().setProperty("_primaryCalendarType",this._getPrimaryCalendarType());if(this._getSecondaryCalendarType()){this.setShowDayNamesLine(true);this._getHeader().setProperty("_secondaryCalendarType",this.getSecondaryCalendarType())}return this};ge.prototype.attachEvent=function(e,a,i,n){t.prototype.attachEvent.call(this,e,a,i,n);if(this.hasListeners("intervalSelect")){he.forEach(function(e){if(this[e]){this[e]._setAriaRole("button")}},this)}return this};ge.prototype.setIconShape=function(e){this.setProperty("iconShape",e);this.getRows().forEach(function(t){var a=Ne(t);if(a.getAvatar){a.getAvatar().setDisplayShape(e)}});return this};ge.prototype.detachEvent=function(e,a,i){t.prototype.detachEvent.call(this,e,a,i);if(!this.hasListeners("intervalSelect")){he.forEach(function(e){if(this[e]){this[e]._setAriaRole("gridcell")}},this)}return this};ge.prototype._createHeader=function(){var e=new x(this.getId()+"-Header",{calendarWeekNumbering:this.getCalendarWeekNumbering()});e._getRelativeInfo=this._getRelativeInfo.bind(this);e.getAggregation("_actionsToolbar").addAriaLabelledBy(D.getStaticId("sap.m","PC_FUNCTIONS_TOOLBAR"));e.getAggregation("_navigationToolbar").addAriaLabelledBy(D.getStaticId("sap.m","PC_INTERVAL_SELECTION_TOOLBAR"));return e};ge.prototype._attachHeaderEvents=function(){var e=this._getHeader();e.attachEvent("pressPrevious",this._handlePressArrow,this);e.attachEvent("pressToday",this._handleTodayPress,this);e.attachEvent("pressNext",this._handlePressArrow,this);e.attachEvent("dateSelect",this._handleDateSelect,this);return this};ge.prototype._handlePressArrow=function(e){this._applyArrowsLogic(e.getId()==="pressPrevious")};ge.prototype._applyArrowsLogic=function(e){if(e){this._dateNav.previous(this._getPrimaryCalendarType())}else{this._dateNav.next(this._getPrimaryCalendarType())}var t=this._getRowInstanceByViewKey(this.getViewKey());this.setStartDate(this._dateNav.getStart());t.displayDate(this._dateNav.getCurrent());this._updatePickerSelection();this.fireStartDateChange()};ge.prototype._formatPickerText=function(){var e=this._getFirstAndLastRangeDate(),t=n._createLocalDate(e.oStartDate,true),a=n._createLocalDate(e.oEndDate,true),i=this.getViewKey(),r=te[i]?te[i]:this._getView(i).getIntervalType(),s=_.getConfiguration().getRTL(),o,l,g,h,p,d,c,u;if(this._getSecondaryCalendarType()){p=T.getDateInstance({format:"yMMMMd",calendarType:this.getSecondaryCalendarType()})}switch(r){case te.Hour:o=T.getDateInstance({format:"yMMMMd",calendarType:this._getPrimaryCalendarType()});g=o.format(t);if(t.getDate()!==a.getDate()){h=o.format(a)}if(this._getSecondaryCalendarType()){d=p.format(t);if(t.getDate()!==a.getDate()){c=p.format(a)}}break;case te.Day:case te.Week:var f=this._getRelativeInfo().intervalLabelFormatter;if(this.isRelative()){var y=this.calcIntervalOffset(this.getStartDate());var m=this.calcIntervalOffset(this.getEndDate())-this.calcIntervalOffset(this.getStartDate());g=f?f(y):y;var v=this._getRelativeInfo().iIntervalSize===1?y+m:y+m-1;h=f?f(v):y+m}else{o=T.getDateInstance({format:"yMMMMd",calendarType:this._getPrimaryCalendarType()});g=o.format(t);h=o.format(a);if(this._getSecondaryCalendarType()){d=p.format(t);c=p.format(a)}}break;case te.OneMonth:case"OneMonth":o=T.getDateInstance({format:"yMMMM",calendarType:this._getPrimaryCalendarType()});g=o.format(t);if(this._getSecondaryCalendarType()){p=T.getDateInstance({format:"yMMMM",calendarType:this.getSecondaryCalendarType()});d=p.format(t)}break;case te.Month:o=T.getDateInstance({format:"y",calendarType:this._getPrimaryCalendarType()});g=o.format(t);if(this._getSecondaryCalendarType()){p=T.getDateInstance({format:"y",calendarType:this.getSecondaryCalendarType()});d=p.format(t)}if(t.getFullYear()!==a.getFullYear()){h=o.format(a);if(this._getSecondaryCalendarType()){c=p.format(a)}}if(g===h){h=undefined}break;default:throw new Error("Unknown IntervalType: "+i+"; "+this)}if(!s){l=g;u=d;if(h){l+=" - "+h}if(this._getSecondaryCalendarType()&&c){u+=" - "+c}}else{if(h){l=h+" - "+g}else{l=g}if(this._getSecondaryCalendarType()&&c){u=d+" - "+c}else if(this._getSecondaryCalendarType()){u=d}}return{primaryType:l,secondaryType:u}};ge.prototype._getPrimaryCalendarType=function(){return this.getProperty("primaryCalendarType")||R.getCalendarType()};ge.prototype._getFirstAndLastRangeDate=function(){var e=n._createUniversalUTCDate(this.getStartDate(),this._getPrimaryCalendarType(),true),t=n._createUniversalUTCDate(this._dateNav.getEnd(),this._getPrimaryCalendarType(),true);return{oStartDate:e,oEndDate:t}};ge.prototype._getHeader=function(){return this.getAggregation("header")};ge.prototype._toggleStickyClasses=function(){this.toggleStyleClass("sapMPCSticky",this.getStickyHeader());return this};ge.prototype._adjustColumnHeadersTopOffset=function(){var e=this.getStickyHeader(),t=this.getDomRef().querySelector(".sapMListInfoTBarContainer"),a;switch(e){case true:a=this._getHeader().$().outerHeight()+"px";break;default:a="auto";break}t.style.top=a;return this};ge.prototype.getEndDate=function(){return this._dateNav.getEnd(this._getPrimaryCalendarType())};ge.prototype.getVisibleIntervalsCount=function(){var e=this.getViewKey();if((e===te.OneMonth||e==="OneMonth")&&this._iSize<2){var t=n.getFirstDateOfWeek(n._createUniversalUTCDate(this.getStartDate(),this._getPrimaryCalendarType(),false)),a=n.getFirstDateOfWeek(n._createUniversalUTCDate(this._dateNav.getEnd(),this._getPrimaryCalendarType(),false)),i=b.getInstance(a.getTime());i.setDate(i.getDate()+6);return(i.getTime()-t.getTime())/864e5+1}else{return this._getIntervals(this._getView(this.getViewKey()))}};ge.prototype._setAriaRole=function(e){if(this.hasListeners("intervalSelect")){e._setAriaRole("button")}else{e._setAriaRole("gridcell")}};ge.prototype._updateTodayButtonState=function(){if(!this._oTodayButton){return}if(this.isRelative()){this._oTodayButton.setEnabled(false);return}this._oTodayButton.setEnabled(!this._dateMatchesVisibleRange(b.getInstance(),this.getViewKey()))};ge.prototype._dateMatchesVisibleRange=function(e,t){var a=this._getView(t,!this._bBeforeRendering);if(!a){return false}var i=a.getIntervalType(),s=pe[i],o=s?this[s.sInstanceName]:null,l=false;if(o&&t==="One Month"){return n._isSameMonthAndYear(r.fromLocalJSDate(this.getStartDate()),r.fromLocalJSDate(e))}else if(o&&t==="Week"){var g=o.getDays(),h=r.fromLocalJSDate(e),p=r.fromLocalJSDate(this.getStartDate()),d=r.fromLocalJSDate(this.getStartDate());d.setDate(d.getDate()+g);return h.isSameOrAfter(p)&&h.isBefore(d)}return l};ge.prototype.onAfterRendering=function(e){e.size={width:this.getDomRef().offsetWidth};Re.call(this,e,true);if(!this._sResizeListener){this._sResizeListener=v.register(this,this._resizeProxy)}if(f.system.phone&&this.getStickyHeader()){f.orientation.attachHandler(this._updateStickyHeader,this)}this._updateCurrentTimeVisualization(false);if(this.getHeight()){var t=this.getDomRef().querySelector("table");if(this.getHeight().indexOf("%")>-1){t.style.height=this.getHeight();return}var a=this.$().height()-this._oInfoToolbar.$().height()+"px";t.style.height=a}this._adjustColumnHeadersTopOffset();this._updateHeaderButtons()};ge.prototype.onThemeChanged=function(){if(this.getDomRef()){this._adjustColumnHeadersTopOffset()}};ge.prototype.addToolbarContent=function(e){if(e&&e.isA("sap.m.Title")){this._observeHeaderTitleText(e);this._getHeader().setTitle(e.getText());e.setVisible(false)}this.addAggregation("toolbarContent",e);return this};ge.prototype.insertToolbarContent=function(e,t){if(e&&e.isA("sap.m.Title")){this._observeHeaderTitleText(e);this._getHeader().setTitle(e.getText());e.setVisible(false)}this.insertAggregation("toolbarContent",e,t);return this};ge.prototype.removeToolbarContent=function(e){var t;if(e&&e.isA("sap.m.Title")){this._getHeader().setTitle("");this._disconnectAndDestroyHeaderObserver()}else{t=this.removeAggregation("toolbarContent",e)}return t};ge.prototype.removeAllToolbarContent=function(){var e=this.removeAllAggregation("toolbarContent");this._getHeader().setTitle("");this._disconnectAndDestroyHeaderObserver();return e};ge.prototype.destroyToolbarContent=function(){var e=this.destroyAggregation("toolbarContent");this._getHeader().setTitle("");this._disconnectAndDestroyHeaderObserver();return e};ge.prototype._getHeaderObserver=function(){if(!this._oHeaderObserver){this._oHeaderObserver=new a(this._handleTitleTextChange.bind(this))}return this._oHeaderObserver};ge.prototype._observeHeaderTitleText=function(e){this._getHeaderObserver().observe(e,{properties:["text"]})};ge.prototype._handleTitleTextChange=function(e){this._getHeader().setTitle(e.current)};ge.prototype._disconnectAndDestroyHeaderObserver=function(){if(this._oHeaderObserver){this._oHeaderObserver.disconnect();this._oHeaderObserver.destroy();this._oHeaderObserver=null}};ge.prototype.setStartDate=function(e){var t;if(!e){t=b.getInstance()}else{n._checkJSDateObject(e);t=b.getInstance(e.getTime())}t=this._shiftStartDate(t);if(F(t,this.getStartDate())){this._updateTodayButtonState();return this}var a=t.getFullYear();n._checkYearInValidRange(a);var i=this.getMinDate();if(i&&i.getTime()>t.getTime()){j.warning("StartDate < minDate -> StartDate set to minDate",this);t=b.getInstance(i.getTime())}else{var r=this.getMaxDate();if(r&&r.getTime()<t.getTime()){j.warning("StartDate > maxDate -> StartDate set to minDate",this);if(i){t=b.getInstance(i.getTime())}else{t=b.getInstance(1,0,1);t.setFullYear(1)}}}this.setProperty("startDate",t,true);this._dateNav.setStart(t);this._dateNav.setCurrent(t);this._getHeader().setStartDate(t);he.forEach(function(e){if(this[e]){this[e].setStartDate(b.getInstance(t.getTime()))}},this);if((this.getViewKey()===X.OneMonth||this.getViewKey()==="OneMonth")&&this._oOneMonthsRow.getMode()<2&&this._oOneMonthsRow.getSelectedDates().length){this._setRowsStartDate(this._oOneMonthsRow.getSelectedDates()[0].getStartDate())}else{this._setRowsStartDate(b.getInstance(t.getTime()))}if(this.getViewKey()===X.Week||this.getViewKey()===X.OneMonth||this.getViewKey()==="OneMonth"){this._updateTodayButtonState()}if(this.getDomRef()){this._updateCurrentTimeVisualization(false);this._updatePickerSelection()}this._updateHeaderButtons();return this};ge.prototype.setPrimaryCalendarType=function(e){this.setProperty("primaryCalendarType",e);if(this._getHeader()){this._getHeader().setProperty("_primaryCalendarType",e)}if(this._oTimesRow){this._oTimesRow.setProperty("primaryCalendarType",e)}if(this._oDatesRow){this._oDatesRow.setPrimaryCalendarType(e)}if(this._oMonthsRow){this._oMonthsRow.setProperty("primaryCalendarType",e)}if(this._oWeeksRow){this._oWeeksRow.setPrimaryCalendarType(e)}if(this._oOneMonthsRow){this._oOneMonthsRow.setPrimaryCalendarType(e)}return this};ge.prototype._getSecondaryCalendarType=function(){var e=this.getSecondaryCalendarType();if(e===this._getPrimaryCalendarType()){return undefined}return e};ge.prototype.setSecondaryCalendarType=function(e){this.setProperty("secondaryCalendarType",e);if(this._getHeader()){this._getHeader().setProperty("_secondaryCalendarType",e)}if(this._oTimesRow){this._oTimesRow.setProperty("secondaryCalendarType",e)}if(this._oDatesRow){this._oDatesRow.setSecondaryCalendarType(e)}if(this._oMonthsRow){this._oMonthsRow.setSecondaryCalendarType(e)}if(this._oWeeksRow){this._oWeeksRow.setSecondaryCalendarType(e)}if(this._oOneMonthsRow){this._oOneMonthsRow.setSecondaryCalendarType(e)}return this};ge.prototype.setMinDate=function(e){if(F(e,this.getMinDate())){return this}var t=this.getMaxDate(),a=this._getHeader();if(e){n._checkJSDateObject(e);var i=e.getFullYear();n._checkYearInValidRange(i);this.setProperty("minDate",e,true);this._bNoStartDateChange=true;a.getAggregation("_calendarPicker").setMinDate(b.getInstance(e.getTime()));a.getAggregation("_monthPicker").setMinDate(b.getInstance(e.getTime()));a.getAggregation("_yearPicker").setMinDate(b.getInstance(e.getTime()));if(t&&t.getTime()<e.getTime()){j.warning("minDate > maxDate -> maxDate set to end of the month",this);t=b.getInstance(e.getTime());t.setMonth(t.getMonth()+1,0);t.setHours(23);t.setMinutes(59);t.setSeconds(59);t.setMilliseconds(0);this.setMaxDate(t)}this._bNoStartDateChange=undefined;var r=this.getStartDate();if(r&&r.getTime()<e.getTime()){j.warning("StartDate < minDate -> StartDate set to minDate",this);r=b.getInstance(e.getTime());this.setStartDate(r);a.updatePickerText(this._formatPickerText())}}else{this.setProperty("minDate",undefined,true);a.getAggregation("_calendarPicker").setMinDate();a.getAggregation("_monthPicker").setMinDate();a.getAggregation("_yearPicker").setMinDate()}var s=b.getInstance();if(e&&s.getTime()<e.getTime()){this._oTodayButton.setVisible(false)}else if(!t||s.getTime()<t.getTime()){this._oTodayButton.setVisible(true)}return this};ge.prototype.setMaxDate=function(e){if(F(e,this.getMaxDate())){return this}var t=this.getMinDate(),a=this._getHeader();if(e){n._checkJSDateObject(e);var i=e.getFullYear();n._checkYearInValidRange(i);this.setProperty("maxDate",e,true);this._bNoStartDateChange=true;a.getAggregation("_calendarPicker").setMaxDate(b.getInstance(e.getTime()));a.getAggregation("_monthPicker").setMaxDate(b.getInstance(e.getTime()));a.getAggregation("_yearPicker").setMaxDate(b.getInstance(e.getTime()));if(t&&t.getTime()>e.getTime()){j.warning("maxDate < minDate -> maxDate set to begin of the month",this);t=b.getInstance(e.getTime());t.setDate(1);t.setHours(0);t.setMinutes(0);t.setSeconds(0);t.setMilliseconds(0);this.setMinDate(t)}this._bNoStartDateChange=undefined;var r=this.getStartDate();if(r&&r.getTime()>e.getTime()){j.warning("StartDate > maxDate -> StartDate set to minDate",this);if(t){r=b.getInstance(t.getTime())}else{r=b.getInstance(1,0,1);r.setFullYear(1)}this.setStartDate(r);a.updatePickerText(this._formatPickerText())}}else{this.setProperty("maxDate",undefined,true);a.getAggregation("_calendarPicker").setMaxDate();a.getAggregation("_monthPicker").setMaxDate();a.getAggregation("_yearPicker").setMaxDate()}var s=b.getInstance();if(e&&s.getTime()>e.getTime()){this._oTodayButton.setVisible(false)}else if(!t||s.getTime()>t.getTime()){this._oTodayButton.setVisible(true)}return this};ge.prototype.setCalendarWeekNumbering=function(e){var t=this._getHeader(),a=t._oPopup&&t._oPopup.getContent()[0],i;this.setProperty("calendarWeekNumbering",e);this._updateWeekConfiguration();t.setCalendarWeekNumbering(e);a&&a.setCalendarWeekNumbering(e);for(i in pe){this[pe[i].sInstanceName]&&this[pe[i].sInstanceName].setCalendarWeekNumbering(e)}this.setStartDate(this.getStartDate());return this};ge.prototype.removeIntervalInstanceFromInfoToolbar=function(){var e=this._oInfoToolbar.getContent();e.forEach(function(e){if(e.isA(ve)){this._oInfoToolbar.removeContent(e)}}.bind(this))};ge.prototype.isRelative=function(){var e=this._getView(this.getViewKey(),true);if(!e){return false}return e.getRelative()};ge.prototype.setViewKey=function(e){var t,a,i,n=this.getViewKey(),s=this._getHeader(),o;this.setProperty("viewKey",e,true);this._oIntervalTypeSelect.setSelectedKey(e);this.removeIntervalInstanceFromInfoToolbar();var h=this.getStartDate();var p=this.getMinDate();var d=this.getMaxDate();var c=this._getView(e,!this._bBeforeRendering);var u;var f=this._getSecondaryCalendarType();if(!c){this._bCheckView=true;this.invalidate()}else{var _=c.getIntervalType();var y=c.getIntervalSize();var m=this._getIntervals(c);this._bCheckView=false;this._dateNav.setUnit(_);this._dateNav.setStep(m*y);this._dateNav.setCurrent(undefined);switch(_){case te.Hour:if(!this._oTimesRow){this._oTimesRow=new g(this.getId()+"-TimesRow",{startDate:b.getInstance(h.getTime()),items:m,legend:this.getLegend()});this._setAriaRole(this._oTimesRow);this._oTimesRow._setLegendControlOrigin(this);this._oTimesRow.attachEvent("focus",this._handleFocus,this);this._oTimesRow.attachEvent("select",this._handleCalendarSelect,this);this._oTimesRow._oPlanningCalendar=this;this._oTimesRow._getSpecialDates=function(){return this._oPlanningCalendar._getSpecialDates()};this._oTimesRow.getSpecialDates=function(){return this._oPlanningCalendar.getSpecialDates()}}else if(this._oTimesRow.getItems()!==m){this._oTimesRow.setItems(m);this._dateNav.setStep(m*y)}this._insertInterval(this._oTimesRow);u=s.getAggregation("_calendarPicker")?s.getAggregation("_calendarPicker"):s._oPopup.getContent()[0];u.addDelegate(_e,u);s.setAssociation("currentPicker",u);break;case te.Day:case te.Week:case te.OneMonth:case"OneMonth":i=pe[_];t=this[i.sInstanceName];if(!t){t=new i.oClass(this.getId()+i.sIdSuffix,{startDate:b.getInstance(h.getTime()),days:m,showDayNamesLine:this.getShowDayNamesLine(),legend:this.getLegend(),showWeekNumbers:this.getShowWeekNumbers(),calendarWeekNumbering:this.getCalendarWeekNumbering()});t.isRelative=this.isRelative.bind(this);t._getRelativeInfo=this._getRelativeInfo.bind(this);this._setAriaRole(t);t.attachEvent("select",this._handleCalendarSelect,this);t.attachEvent("focus",this._handleFocus,this);if(e===X.OneMonth||e==="OneMonth"){t._setRowsStartDate=this._setRowsStartDate.bind(this)}t._oPlanningCalendar=this;t._getSpecialDates=function(){return this._oPlanningCalendar._getSpecialDates()};t.getSpecialDates=function(){return this._oPlanningCalendar.getSpecialDates()}}else if(t.getDays()!==m){t.setDays(m);this._dateNav.setStep(m*y)}this._insertInterval(t);this[i.sInstanceName]=t;if(_===te.OneMonth||_==="OneMonth"){u=s.getAggregation("_monthPicker")?s.getAggregation("_monthPicker"):s._oPopup.getContent()[0];s.setAssociation("currentPicker",u);u.addDelegate(ye,u)}else if(this.isRelative()){var v=s.getAggregation("_indexPicker");u=v?v:s._oPopup.getContent()[0];if(v){var c=this._getView(e);var D=Math.round(this.calcIntervalOffset(h));v.setFormatter(this._getRelativeInfo().intervalLabelFormatter);v.setPeriodSize(t.getDays());v.setSelectedIndex(D)}else{var c=this._getView(e);u.setFormatter(c.getIntervalLabelFormatter());u.setPeriodSize(t.getDays());var D=Math.round(this.calcIntervalOffset(h));u.setSelectedIndex(D)}s.setAssociation("currentPicker",u)}else{u=s.getAggregation("_calendarPicker")?s.getAggregation("_calendarPicker"):s._oPopup.getContent()[0];s.setAssociation("currentPicker",u);u.addDelegate(_e,u)}break;case te.Month:if(!this._oMonthsRow){this._oMonthsRow=new l(this.getId()+"-MonthsRow",{startDate:b.getInstance(h.getTime()),months:m,legend:this.getLegend()});this._oMonthsRow.setProperty("primaryCalendarType",this._getPrimaryCalendarType());if(f){this._oMonthsRow.setProperty("secondaryCalendarType",f)}this._setAriaRole(this._oMonthsRow);this._oMonthsRow._setLegendControlOrigin(this);this._oMonthsRow.attachEvent("focus",this._handleFocus,this);this._oMonthsRow.attachEvent("select",this._handleCalendarSelect,this);this._oMonthsRow._oPlanningCalendar=this;this._oMonthsRow._getSpecialDates=function(){return this._oPlanningCalendar._getSpecialDates()};this._oMonthsRow.getSpecialDates=function(){return this._oPlanningCalendar.getSpecialDates()}}else if(this._oMonthsRow.setMonths()!==m){this._oMonthsRow.setMonths(m);this._dateNav.setStep(m*y)}this._insertInterval(this._oMonthsRow);u=s.getAggregation("_yearPicker")?s.getAggregation("_yearPicker"):s._oPopup.getContent()[0];s.setAssociation("currentPicker",u);u.addDelegate(me,u);break;default:throw new Error("Unknown IntervalType: "+_+"; "+this)}var w=this.getAggregation("table").getInfoToolbar().getContent()[1];if(w.getMetadata().hasProperty("_primaryCalendarType")){w.setProperty("_primaryCalendarType",this._getPrimaryCalendarType())}else if(w.getMetadata().hasProperty("primaryCalendarType")){w.setPrimaryCalendarType(this._getPrimaryCalendarType())}if(f&&w.getMetadata().hasProperty("_secondaryCalendarType")){w.setProperty("_secondaryCalendarType",f)}else if(f&&w.getMetadata().hasProperty("secondaryCalendarType")){w.setSecondaryCalendarType(f)}if(this._oOneMonthsRow){this._oOneMonthsRow.setPrimaryCalendarType(this._getPrimaryCalendarType())}if(w.setFirstDayOfWeek){w.setFirstDayOfWeek(this.getFirstDayOfWeek())}var C=this.getRows();for(var S=0;S<C.length;S++){var T=C[S];var R=Ee(T);R.setIntervalType(_);R.setIntervals(m);R.setIntervalSize(y);R.setShowSubIntervals(c.getShowSubIntervals())}if(this.getDomRef()){this._updateCurrentTimeVisualization(false);Se.call(this,this.getShowWeekNumbers(),this._viewAllowsWeekNumbers(e));Te.call(this,this.getShowDayNamesLine(),!!t)}this._updatePickerSelection()}if(e===X.Week||e===X.OneMonth||e===X.Month||e==="OneMonth"){a=this.getStartDate();this.setStartDate(b.getInstance(a.getTime()));if(a.getTime()!==this.getStartDate().getTime()){this.fireStartDateChange()}}if(this._oOneMonthsRow&&(e===X.OneMonth||e==="OneMonth")){this._oOneMonthsRow.setMode(this._iSize);this._oOldStartDate=b.getInstance(this.getStartDate().getTime());this._adjustSelectedDate(r.fromLocalJSDate(a,this._getPrimaryCalendarType()));if(this._iSize<2){this._setRowsStartDate(a)}}else if(this._oOneMonthsRow&&(n===X.OneMonth||n==="OneMonth")&&this._oOneMonthsRow.getSelectedDates().length){o=this._oOneMonthsRow.getSelectedDates()[0].getStartDate();if(o){o.setHours(this._oOldStartDate.getHours());o.setMinutes(this._oOldStartDate.getMinutes());o.setSeconds(this._oOldStartDate.getSeconds());o.setMilliseconds(this._oOldStartDate.getMilliseconds());this.setStartDate(o)}}if(p){s.getAggregation("_calendarPicker")&&s.getAggregation("_calendarPicker").setMinDate(b.getInstance(p.getTime()));s.getAggregation("_yearPicker")&&s.getAggregation("_yearPicker").setMinDate(b.getInstance(p.getTime()));s.getAggregation("_monthPicker")&&s.getAggregation("_monthPicker").setMinDate(b.getInstance(p.getTime()))}if(d){s.getAggregation("_calendarPicker")&&s.getAggregation("_calendarPicker").setMaxDate(b.getInstance(d.getTime()));s.getAggregation("_yearPicker")&&s.getAggregation("_yearPicker").setMaxDate(b.getInstance(d.getTime()));s.getAggregation("_monthPicker")&&s.getAggregation("_monthPicker").setMaxDate(b.getInstance(d.getTime()))}this._updateTodayButtonState();return this};ge.prototype.setFirstDayOfWeek=function(e){if(e<-1||e>6){j.error(""+e+" is not a valid value to the property firstDayOfWeek. Valid values are from -1 to 6.");return}var t=this._getHeader().getAssociation("currentPicker"),a=_.byId(t),i=this.getViewKey(),r=this._dateNav,s=r.getStart(),o=this.getStartDate().getDay(),l=i===X.OneMonth&&this._iSize<2,g=e,h,p,d;a.setFirstDayOfWeek(e);if(i===X.Week||l){h=this.getAggregation("table").getInfoToolbar().getContent()[1];if(e===-1){p=n.getFirstDateOfWeek(n._createUniversalUTCDate(s,undefined,true));d=n._createLocalDate(p,true);g=d.getDay()}h.setFirstDayOfWeek(e);if(!l){s.setDate(s.getDate()-o+g);h.setStartDate(s)}this.getRows().forEach(function(e){this._updateRowTimeline(e)}.bind(this))}this.setProperty("firstDayOfWeek",e);this._updateWeekConfiguration();return this};ge.prototype._updateWeekConfiguration=function(){var e=R.getFormatSettings().getFormatLocale().toString(),t=this.getCalendarWeekNumbering(),a=this.getFirstDayOfWeek(),i=I.getWeekConfigurationValues(t,new M(e));if(a>-1){i.firstDayOfWeek=a}this._dateNav.setWeekConfiguration(i)};ge.prototype._handleFocus=function(e){var t=e.getParameter("date"),a=e.getParameter("restoreOldDate");if(a){return}this.shiftToDate(t,e.getParameter("otherMonth"));this._addMonthFocusDelegate(this._getRowInstanceByViewKey(this.getViewKey()))};ge.prototype.shiftToDate=function(e,t){var a=this._getRowInstanceByViewKey(this.getViewKey()),i,n;this._dateNav.toDate(e,this._getPrimaryCalendarType());i=this._dateNav.getStart();n=this._dateNav.getCurrent();if(this._dateNav.getCurrent()>this._dateNav.getEnd()){i=b.getInstance(this._dateNav.getStart());i.setDate(i.getDate()+1)}if(this.getMaxDate()&&this.getMaxDate()<e||this.getMinDate()&&this.getMinDate()>e){return}if(t){this.fireStartDateChange()}if(a&&!(a.getMode&&a.getMode()<2&&!t)){this.setStartDate(i);a.setStartDate(i);a.setDate(n);this._addMonthFocusDelegate(a)}};ge.prototype._addMonthFocusDelegate=function(e){var t={onAfterRendering:function(){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex());this.removeDelegate(t)}};e.addDelegate(t,e)};ge.prototype._shiftStartDate=function(e){if(this.getViewKey()===X.Week){var t=R.getFormatSettings().getFormatLocale().toString(),a=I.getWeekConfigurationValues(this.getCalendarWeekNumbering(),new M(t)),i,s;if(this.getFirstDayOfWeek()>-1){a.firstDayOfWeek=this.getFirstDayOfWeek()}i=n.getFirstDateOfWeek(n._createUniversalUTCDate(e,undefined,true),a);s=n._createLocalDate(i,true);if(this.getFirstDayOfWeek()>-1){s.setDate(s.getDate()-s.getDay()+this.getFirstDayOfWeek())}if(s.getTime()>e.getTime()){s.setDate(s.getDate()-7)}e.setTime(s.getTime())}if(this.getViewKey()===X.OneMonth||this.getViewKey()===X.Month||this.getViewKey()==="OneMonth"){var o=n._getFirstDateOfMonth(r.fromLocalJSDate(e,this._getPrimaryCalendarType()));var l=o.toLocalJSDate();l.setHours(e.getHours(),e.getMinutes(),e.getSeconds());e.setTime(l.getTime())}return e};ge.prototype._updatePickerSelection=function(){var e=this._getFirstAndLastRangeDate(),t=this._getHeader().getAssociation("currentPicker"),a=_.byId(t),i;i=new h({startDate:n._createLocalDate(e.oStartDate,true),endDate:n._createLocalDate(e.oEndDate,true)});if(this.isRelative()){a.setStartIndex(this.calcIntervalOffset(e.oStartDate))}else{a.destroySelectedDates();a.addSelectedDate(i)}this._getHeader().updatePickerText(this._formatPickerText());this._updateTodayButtonState()};ge.prototype._adjustSelectedDate=function(e){var t=e.toLocalJSDate();if(this._oOneMonthsRow.getMode&&this._oOneMonthsRow.getMode()<2){this._oOneMonthsRow.removeAllSelectedDates();this._oOneMonthsRow.addSelectedDate(new h({startDate:t}));this._oOneMonthsRow.selectDate(t)}};ge.prototype._insertInterval=function(e){if(this._iSizeScreen>1){this._oInfoToolbar.addContent(e)}else{this._oInfoToolbar.insertContent(e,1)}};ge.prototype._viewAllowsWeekNumbers=function(e){var t=this._getView(e).getIntervalType(),a=pe[t];return!!a&&!!a.oClass.prototype.setShowWeekNumbers};ge.prototype._viewAllowsDayNamesLine=function(e){var t=this._getView(e).getIntervalType(),a=pe[t];return!!a&&!!a.oClass.prototype.setShowDayNamesLine};ge.prototype._getRowInstanceByViewKey=function(e){var t=this._getView(e).getIntervalType(),a=pe[t],i;if(a){i=this[a.sInstanceName]}if(t===te.Month){i=this._oMonthsRow}if(t===te.Hour){i=this._oTimesRow}return i};ge.prototype.setShowWeekNumbers=function(e){this.setProperty("showWeekNumbers",e,true);this._getViews().forEach(function(t){var a=t.getKey(),i=this._viewAllowsWeekNumbers(a),n=this._getRowInstanceByViewKey(a);if(n&&i){n.setShowWeekNumbers(e)}if(this.getDomRef()&&this.getViewKey()===a){Se.call(this,e,i)}},this);return this};ge.prototype.setShowIntervalHeaders=function(e){this.setProperty("showIntervalHeaders",e,true);var t=this.getRows();for(var a=0;a<t.length;a++){var i=t[a];Ee(i).setShowIntervalHeaders(e)}return this};ge.prototype.setShowEmptyIntervalHeaders=function(e){this.setProperty("showEmptyIntervalHeaders",e,true);var t=this.getRows();for(var a=0;a<t.length;a++){var i=t[a];Ee(i).setShowEmptyIntervalHeaders(e)}return this};ge.prototype.setGroupAppointmentsMode=function(e){this.setProperty("groupAppointmentsMode",e,true);var t=this.getRows();for(var a=0;a<t.length;a++){var i=t[a];Ee(i).setGroupAppointmentsMode(e)}return this};ge.prototype.setAppointmentsReducedHeight=function(e){this.setProperty("appointmentsReducedHeight",e,true);var t=this.getRows();for(var a=0;a<t.length;a++){var i=t[a];Ee(i).setAppointmentsReducedHeight(e)}return this};ge.prototype.setAppointmentHeight=function(e){var t=this.getRows(),a;this.setProperty("appointmentHeight",e);for(a=0;a<t.length;a++){var i=t[a];Ee(i).setAppointmentHeight(e)}return this};ge.prototype.setAppointmentRoundWidth=function(e){var t=this.getRows(),a;this.setProperty("appointmentRoundWidth",e);for(a=0;a<t.length;a++){var i=t[a];Ee(i).setAppointmentRoundWidth(e)}return this};ge.prototype.setAppointmentsVisualization=function(e){this.setProperty("appointmentsVisualization",e,true);var t=this.getRows();for(var a=0;a<t.length;a++){var i=t[a];Ee(i).setAppointmentsVisualization(e)}return this};ge.prototype.setShowRowHeaders=function(e){if(this.getShowRowHeaders()===e){return this}this.setProperty("showRowHeaders",e,true);var t=this.getAggregation("table"),a,i;t.getColumns()[0].setVisible(e);this._toggleAppointmentsColumnPopinState(e);this.$().toggleClass("sapMPlanCalNoHead",!e);Fe.call(this);this._setSelectionMode.call(this);t.getItems().forEach(function(t){a=t.getCells()[0];i=t.getCells()[1];if(e){i.addAriaLabelledBy(a.getId())}else{i.removeAriaLabelledBy(a.getId())}});return this};ge.prototype.setShowDayNamesLine=function(e){var t,a,i,n=!!this.getDomRef(),r=this.getViewKey();for(t in pe){a=pe[t].sInstanceName;if(this[a]){i=this[a];i.setShowDayNamesLine(e);if(n&&t===r){Te.call(this,e,true)}}}return this.setProperty("showDayNamesLine",e,false)};ge.prototype.setStickyHeader=function(e){if(this.getStickyHeader()===e){return this}this.setProperty("stickyHeader",e,true);if(f.system.phone){if(e){f.orientation.attachHandler(this._updateStickyHeader,this)}else{f.orientation.detachHandler(this._updateStickyHeader,this)}}this._updateStickyHeader();return this};ge.prototype._updateStickyHeader=function(){var e=[],t=this.getStickyHeader(),a=(this.getViewKey()===X.OneMonth||this.getViewKey()==="OneMonth")&&this._iSize<2,i=t&&!f.system.phone&&!a,n=t&&!(f.system.phone&&f.orientation.landscape)&&!a;if(i){e.push(Y.HeaderToolbar)}if(this._oInfoToolbar&&n){e.push(Y.InfoToolbar)}this.getAggregation("table").setSticky(e)};ge.prototype._adjustViewKey=function(){if(!this._oTimesRow&&!this._oDatesRow&&!this._oMonthsRow&&!this._oWeeksRow&&!this._oOneMonthsRow||this._bCheckView){this.setViewKey(this.getViewKey());this._bCheckView=undefined}};ge.prototype.addView=function(e){this.addAggregation("views",e);if(e.getKey()===this.getViewKey()){this._adjustViewKey()}return this};ge.prototype.insertView=function(e,t){this.insertAggregation("views",e,t);if(e.getKey()===this.getViewKey()){this._adjustViewKey()}return this};ge.prototype.addRow=function(e){this.addAggregation("rows",e);this.getAggregation("table").addItem(this._createPlanningCalendarListItem(e));return this};ge.prototype.insertRow=function(e,t){this.insertAggregation("rows",e,t);this.getAggregation("table").insertItem(this._createPlanningCalendarListItem(e),t,true);return this};ge.prototype.removeRow=function(e){var t=this.removeAggregation("rows",e,true),a=this.getAggregation("table");a.removeItem(Ve(t),true);this._handleRowRemoval(t);Ke.call(this);this._setSelectionMode.call(this);return t};ge.prototype.removeAllRows=function(){var e=this.removeAllAggregation("rows",true),t=this.getAggregation("table");t.removeAllItems(true);e.forEach(this._handleRowRemoval,this);Ke.call(this);this._setSelectionMode.call(this);return e};ge.prototype.destroyRows=function(){var e;var t=this.getAggregation("table");t.destroyItems(true);e=this.destroyAggregation("rows");Ke.call(this);this._setSelectionMode.call(this);return e};ge.prototype.setSingleSelection=function(e){this.setProperty("singleSelection",e,true);Fe.call(this);this._setSelectionMode.call(this);if(e){this.selectAllRows(false)}else{Ke.call(this)}this.$().toggleClass("sapMPlanCalMultiSel",!e);return this};ge.prototype.setNoDataText=function(e){this.setProperty("noDataText",e,true);var t=this.getAggregation("table");t.setNoDataText(e);return this};ge.prototype.setLegend=function(e){this.setAssociation("legend",e,true);var t=this.getRows(),i=this.getLegend()&&_.byId(this.getLegend()),n;for(var r=0;r<t.length;r++){var s=t[r];Ee(s).setLegend(e)}he.forEach(function(t){if(this[t]){this[t].setLegend(e)}},this);if(i){n=new a(function(e){this.invalidate()}.bind(this));n.observe(i,{destroy:true})}return this};ge.prototype.addAriaLabelledBy=function(e){this.addAssociation("ariaLabelledBy",e,true);var t=this.getAggregation("table");t.addAriaLabelledBy(e);return this};ge.prototype.removeAriaLabelledBy=function(e){this.removeAssociation("ariaLabelledBy",e,true);var t=this.getAggregation("table");t.removeAriaLabelledBy(e);return this};ge.prototype.removeAllAriaLabelledBy=function(){this.removeAllAssociation("ariaLabelledBy",true);var e=this.getAggregation("table");e.removeAllAriaLabelledBy();e.addAriaLabelledBy(this.getId()+"-Descr");return this};ge.prototype.invalidate=function(e){var a=e&&e instanceof h;if(!this._bIsBeingDestroyed&&(this._bDateRangeChanged||a)){if(this.getDomRef()){var i=this.getViewKey();var n=this._getView(i);var r=n.getIntervalType();switch(r){case te.Hour:if(this._oTimesRow){this._oTimesRow.invalidate(arguments)}break;case te.Day:if(this._oDatesRow){this._oDatesRow.invalidate(arguments)}break;case te.Month:if(this._oMonthsRow){this._oMonthsRow.invalidate(arguments)}break;case te.OneMonth:case"OneMonth":if(this._oOneMonthsRow){this._oOneMonthsRow.invalidate(arguments)}break;case te.Week:if(this._oWeeksRow){this._oWeeksRow.invalidate(arguments)}break;default:throw new Error("Unknown IntervalType: "+r+"; "+this)}}this._bDateRangeChanged=undefined}else{if(e instanceof z){this._bCheckView=true}t.prototype.invalidate.apply(this,arguments)}};ge.prototype.addSpecialDate=function(e){this._bDateRangeChanged=true;return t.prototype.addAggregation.call(this,"specialDates",e)};ge.prototype.insertSpecialDate=function(e,a){this._bDateRangeChanged=true;return t.prototype.insertAggregation.call(this,"specialDates",e,a)};ge.prototype.removeSpecialDate=function(e){this._bDateRangeChanged=true;return t.prototype.removeAggregation.call(this,"specialDates",e)};ge.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;return this.removeAllAggregation("specialDates")};ge.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;return this.destroyAggregation("specialDates")};ge.prototype.removeAllViews=function(){this._bCheckView=true;var e=this.removeAllAggregation("views"),t=this.getBuiltInViews();if(t.length){this.setViewKey(t[0])}else{this.setViewKey(ce[0])}return e};ge.prototype.destroyViews=function(){this._bCheckView=true;var e=this.destroyAggregation("views"),t=this.getBuiltInViews();if(t.length){this.setViewKey(t[0])}else{this.setViewKey(ce[0])}return e};ge.prototype.getSelectedRows=function(){return this.getRows().filter(function(e){return e.getSelected()})};ge.prototype.selectAllRows=function(e){var t=this.getRows();if(!(e&&this.getSingleSelection())){for(var a=0;a<t.length;a++){var i=t[a];i.setSelected(e)}if(this._oSelectAllCheckBox){this._oSelectAllCheckBox.setSelected(e)}}return this};ge.prototype.onsaphomemodifiers=function(e){if((e.metaKey||e.ctrlKey)&&!e.altKey&&!e.shiftKey){var t=this.getRows();var a=t[0];var i=new jQuery.Event("saphome");i._bPlanningCalendar=true;Ee(a).onsaphome(i);e.preventDefault();e.stopPropagation()}};ge.prototype.onsapendmodifiers=function(e){if((e.metaKey||e.ctrlKey)&&!e.altKey&&!e.shiftKey){var t=this.getRows();var a=t[t.length-1];var i=new jQuery.Event("sapend");i._bPlanningCalendar=true;Ee(a).onsapend(i);e.preventDefault();e.stopPropagation()}};ge.prototype.setBuiltInViews=function(e){this.setProperty("builtInViews",e);this.setViewKey(this._getViews()[0].getKey());return this};ge.prototype.removeView=function(e){var t=this.removeAggregation("views",e);if(!this.getViews().length){this.setViewKey(this._getViews()[0].getKey())}return t};ge.prototype._getIntervals=function(e){var t=0;switch(this._iSize){case 0:t=e.getIntervalsS();break;case 1:t=e.getIntervalsM();break;default:t=e.getIntervalsL();break}return t};ge.prototype._getView=function(e,t){var a=this._getViews();var i;for(var n=0;n<a.length;n++){i=a[n];if(i.getKey()!=e){i=undefined}else{break}}if(!i&&!t){throw new Error("PlanningCalendarView with key "+e+" not assigned "+this)}return i};ge.prototype._changeStartDate=function(e){if(this._bNoStartDateChange){return}this.setStartDate(b.getInstance(e.getTime()));this._updatePickerSelection();this.fireStartDateChange()};ge.prototype._updateCurrentTimeVisualization=function(e){if(this._sUpdateCurrentTime){clearTimeout(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined}if(e){var t=this.getRows();for(var a=0;a<t.length;a++){var i=t[a];Ee(i).updateCurrentTimeVisualization()}}var n=b.getInstance();var r=this.getStartDate();var s=this.getViewKey();var o=this._getView(s);var l=o.getIntervalType();var g=this._getIntervals(o);var h=0;var p=0;var d=0;switch(l){case te.Hour:h=6e4;p=r.getTime()-36e5;d=r.getTime()+g*36e5;break;case te.Day:case te.Week:case te.OneMonth:case"OneMonth":h=18e5;p=r.getTime()-36e5;d=r.getTime()+g*864e5;break;default:h=-1;break}if(n.getTime()<=d&&n.getTime()>=p&&h>0){this._sUpdateCurrentTime=setTimeout(this["_updateCurrentTimeVisualization"].bind(this,true),h)}};function we(e){this.setViewKey(e.getParameter("item").getKey());this.fireViewChange()}ge.prototype._handleTodayPress=function(e){var t=b.getInstance(),a,i=this.getViewKey(),s={onAfterRendering:function(){this._focusDate(r.fromLocalJSDate(b.getInstance(),this._getPrimaryCalendarType()));this.removeDelegate(s)}};if(i===X.OneMonth||i==="OneMonth"){a=n._getFirstDateOfMonth(r.fromLocalJSDate(t,this._getPrimaryCalendarType()));this._adjustSelectedDate(r.fromLocalJSDate(t,this._getPrimaryCalendarType()));t=a.toLocalJSDate()}if(i===X.Week){a=this.getStartDate();t.setHours(a.getHours());t.setMinutes(a.getMinutes());t.setSeconds(a.getSeconds())}this.setStartDate(t);this._dateNav.setCurrent(t);if(i===X.Week){this._oWeeksRow.addDelegate(s,this._oWeeksRow)}else if(i===X.OneMonth||i==="OneMonth"){this._oOneMonthsRow.addDelegate(s,this._oOneMonthsRow)}this._updatePickerSelection();this.fireStartDateChange()};ge.prototype._handleStartDateChange=function(e){var t=e.oSource.getStartDate();if(this._getView(this.getViewKey()).getIntervalType()!==te.Hour){var a=this.getStartDate();t.setHours(a.getHours());t.setMinutes(a.getMinutes());t.setSeconds(a.getSeconds())}this._changeStartDate(t)};ge.prototype._handleDateSelect=function(e){var t,a=this.getStartDate();if(this.isRelative()){t=b.getInstance(this.getMinDate().getTime());t.setDate(t.getDate()+e.getSource()._oIndexPicker.getSelectedIndex()*this._getView(this.getViewKey()).getIntervalSize())}else{t=e.getSource().getStartDate()}if(this._getView(this.getViewKey()).getIntervalType()===te.Hour){t.setHours(a.getHours());t.setMinutes(a.getMinutes());t.setSeconds(a.getSeconds())}if(a.getTime()!==t.getTime()){this._changeStartDate(t);this._dateNav.setCurrent(t);var i=this.getViewKey(),n=this._getView(i),r=n.getIntervalType(),s;if(r==="Hour"){r="Time"}else if(r==="Day"){r="Date"}else if(r==="One Month"){r="OneMonth"}s="_o"+r+"sRow";if(this[s]){this[s].displayDate(t)}}};ge.prototype._handleCalendarSelect=function(e){var t=e.getSource().getSelectedDates();if(!t.length){return}var a=b.getInstance(t[0].getStartDate());var i=r.fromLocalJSDate(a,this._getPrimaryCalendarType());var s=n._createUniversalUTCDate(a,this._getPrimaryCalendarType(),true);var o=this.getViewKey();var l=this._getView(o);var g=l.getIntervalType();if(g!==te.OneMonth&&g!=="OneMonth"||this._iSize>1){t[0].setStartDate()}switch(g){case te.Hour:s.setUTCHours(s.getUTCHours()+1);break;case te.Day:case te.Week:s.setUTCDate(s.getUTCDate()+1);break;case te.OneMonth:case"OneMonth":if(this._iSize<2){var h=b.getInstance(i.toLocalJSDate().getTime());if(n.monthsDiffer(this.getStartDate(),i.toLocalJSDate())){this.setStartDate(i.toLocalJSDate());this._getHeader().updatePickerText(this._formatPickerText())}this._setRowsStartDate(h);this._oOneMonthsRow._focusDate(r.fromLocalJSDate(h,this._getPrimaryCalendarType()),true)}else if(n._isNextMonth(i.toLocalJSDate(),this.getStartDate())){this.shiftToDate(i.toLocalJSDate());this._addMonthFocusDelegate(this._getRowInstanceByViewKey(this.getViewKey()));s.setUTCDate(s.getUTCDate()+1);s.setUTCMilliseconds(s.getUTCMilliseconds()-1);s=n._createLocalDate(s,true);return this.fireIntervalSelect({startDate:a,endDate:s,subInterval:false,row:undefined})}s.setUTCDate(s.getUTCDate()+1);break;case te.Month:s.setUTCMonth(s.getUTCMonth()+1);break;default:throw new Error("Unknown IntervalType: "+g+"; "+this)}s.setUTCMilliseconds(s.getUTCMilliseconds()-1);s=n._createLocalDate(s,true);this._formatPickerText();this.fireIntervalSelect({startDate:a,endDate:s,subInterval:false,row:undefined})};function Ce(e){var t=e.getParameter("startDate");var a=this.getViewKey();var i=this._getView(a);var r=i.getIntervalType();if((r===te.OneMonth||r==="OneMonth")&&n._isNextMonth(t,this.getStartDate())){this.shiftToDate(t);this._addMonthFocusDelegate(this._getRowInstanceByViewKey(this.getViewKey()));return}var s=e.getParameter("endDate");var o=e.getParameter("subInterval");var l=Oe(e.oSource.getParent());this._formatPickerText();this.fireIntervalSelect({startDate:t,endDate:s,subInterval:o,row:l})}ge.prototype._applyContextualSettings=function(e){return t.prototype._applyContextualSettings.call(this,e)};function Se(e,t){this.$().toggleClass("sapMPlanCalWithWeekNumbers",e&&t)}function Te(e,t){this.$().toggleClass("sapMPlanCalWithDayNamesLine",e&&t)}function Re(e,t){if(e.size.width<=0){return}if(Math.abs(this.iWidth-e.size.width)<15){return}this.iWidth=e.size.width;this._applyContextualSettings({contextualWidth:this.iWidth});var a=this.getRows();var i;var n=0;var s;var o=this._iSize;Ue.call(this,e.size.width);if(o!=this._iSize){xe.call(this,this._iSize);var l=this.getViewKey();var g=this._getView(l);var h=g.getIntervalType();var p=g.getIntervalSize();var d=this._getIntervals(g);for(n=0;n<a.length;n++){i=a[n];var c=Ee(i);if(d!=c.getIntervals()){c.setIntervals(d)}else{c.handleResize()}}switch(h){case te.Hour:if(this._oTimesRow&&this._oTimesRow.getItems()!=d){this._oTimesRow.setItems(d);this._dateNav.setStep(d*p)}break;case te.Day:if(this._oDatesRow&&this._oDatesRow.getDays()!=d){this._oDatesRow.setDays(d);this._dateNav.setStep(d*p)}break;case te.Month:if(this._oMonthsRow&&this._oMonthsRow.getMonths()!=d){this._oMonthsRow.setMonths(d);this._dateNav.setStep(d*p)}break;case te.Week:if(this._oWeeksRow&&this._oWeeksRow.getDays()!=d){this._oWeeksRow.setDays(d);this._dateNav.setStep(d*p)}break;case te.OneMonth:case"OneMonth":if(this._oOneMonthsRow&&this._oOneMonthsRow.getDays()!=d){this._oOneMonthsRow.setDays(d);this._dateNav.setStep(d*p);if(this._iSize>1){this._setRowsStartDate(b.getInstance(this.getStartDate().getTime()))}}break;default:throw new Error("Unknown IntervalType: "+h+"; "+this)}Fe.call(this);this._updatePickerSelection()}else if(!t){for(n=0;n<a.length;n++){i=a[n];Ee(i).handleResize()}}if(this._oOneMonthsRow&&(this.getViewKey()===te.OneMonth||this.getViewKey()==="OneMonth")){s=this._getSelectedDates().length&&this._getSelectedDates()[0].getStartDate()?this._getSelectedDates()[0].getStartDate():this.getStartDate();this._oOneMonthsRow.setMode(this._iSize);this._adjustSelectedDate(r.fromLocalJSDate(s,this._getPrimaryCalendarType()))}if(this.getStickyHeader()){this._adjustColumnHeadersTopOffset();this._updateStickyHeader()}}function Ae(e){var t=e.getParameter("appointment"),a=e.getParameter("multiSelect")||this.getMultipleAppointmentsSelection(),i=e.getParameter("appointments"),n=e.getParameter("domRefId"),r,s,o,l,g,h,p;if(!a){s=this.getRows();for(h=0;h<s.length;h++){o=s[h];if(e.oSource!=Ee(o)){l=o.getAppointments();for(p=0;p<l.length;p++){g=l[p];g.setSelected(false)}}}}r={appointment:t,appointments:i,multiSelect:a,domRefId:n};this.fireAppointmentSelect(r)}ge.prototype._setRowsStartDate=function(e){var t=this.getRows(),a,i;for(i=0;i<t.length;i++){a=t[i];Ee(a).setStartDate(e)}};ge.prototype._toggleAppointmentsColumnPopinState=function(e){var t=this.getAggregation("table"),a=t.getColumns()[1];a.setDemandPopin(e);a.setMinScreenWidth(e?de:"")};ge.prototype._getViews=function(){var e=this.getViews(),t=this.getBuiltInViews(),a,i=[],n=X,r=te;if(!this._oViews){this._oViews={}}if(t.length){i=t}else{i=e.length?[]:ce}a=i.map(function(e){switch(e){case n.Hour:if(!this._oViews[n.Hour]){this._oViews[n.Hour]=new z(this.getId()+"-HourView",{key:n.Hour,intervalType:r.Hour,description:this._oRB&&this._oRB.getText("PLANNINGCALENDAR_HOURS"),intervalsS:6,intervalsM:6,intervalsL:12})}return this._oViews[n.Hour];case n.Day:if(!this._oViews[n.Day]){this._oViews[n.Day]=new z(this.getId()+"-DayView",{key:n.Day,intervalType:r.Day,description:this._oRB&&this._oRB.getText("PLANNINGCALENDAR_DAYS"),intervalsS:7,intervalsM:7,intervalsL:14})}return this._oViews[n.Day];case n.Month:if(!this._oViews[n.Month]){this._oViews[n.Month]=new z(this.getId()+"-MonthView",{key:n.Month,intervalType:r.Month,description:this._oRB&&this._oRB.getText("PLANNINGCALENDAR_MONTHS"),intervalsS:3,intervalsM:6,intervalsL:12})}return this._oViews[n.Month];case n.Week:if(!this._oViews[n.Week]){this._oViews[n.Week]=new z(this.getId()+"-WeekView",{key:n.Week,intervalType:r.Week,description:this._oRB&&this._oRB.getText("PLANNINGCALENDAR_WEEK"),intervalsS:7,intervalsM:7,intervalsL:7})}return this._oViews[n.Week];case n.OneMonth:case"OneMonth":if(!this._oViews[n.OneMonth]){this._oViews[n.OneMonth]=new z(this.getId()+"-OneMonthView",{key:n.OneMonth,intervalType:r.OneMonth,description:this._oRB&&this._oRB.getText("PLANNINGCALENDAR_ONE_MONTH"),intervalsS:1,intervalsM:1,intervalsL:31})}return this._oViews[n.OneMonth];default:j.error("Cannot get PlanningCalendar views. Invalid view key "+e);break}},this);for(var s in this._oViews){if(i.indexOf(s)<0){this._oViews[s].destroy();delete this._oViews[s]}}if(e.length){a=a.concat(e)}return a};ge.prototype.getSelectedAppointments=function(){var e=[];this.getRows().filter(function(t){e.push.apply(e,Ee(t).aSelectedAppointments)});return e};ge.prototype.setCustomAppointmentsSorterCallback=function(e){if(typeof e==="function"||e===null||e===undefined){this.getRows().forEach(function(t){Ee(t)._setCustomAppointmentsSorterCallback(e)});this._fnCustomSortedAppointments=e}else{j.warning("Your custom sort function won't be used, but the old one will be preserved.",this)}return this};ge.prototype.setWidth=function(e){var t=this.getStartDate();this.getRows().forEach(function(e){Ee(e).setStartDate(t)});return this.setProperty("width",e)};ge.prototype.setMultipleAppointmentsSelection=function(e){this.getRows().forEach(function(t){Ee(t).setMultipleAppointmentsSelection(e)});return this.setProperty("multipleAppointmentsSelection",e)};ge.prototype.getCustomAppointmentsSorterCallback=function(){return this._fnCustomSortedAppointments};ge.prototype._onRowDeselectAppointment=function(){var e=this.getRows();for(var t=0;t<e.length;t++){var a=Ee(e[t]).aSelectedAppointments;for(var i=0;i<a.length;i++){var n=_.byId(a[i]);if(n){n.setProperty("selected",false,true);n.$().removeClass("sapUiCalendarAppSel")}}Ee(e[t]).aSelectedAppointments=[]}};ge.prototype._updateRowTimeline=function(e){var t=Ee(e),a,i,n,r,s,o=(this.getViewKey()===X.OneMonth||this.getViewKey()==="OneMonth")&&this._iSize<2,l=this.getStartDate();t.setNonWorkingDays(e.getNonWorkingDays());t.setNonWorkingHours(e.getNonWorkingHours());if(o&&this._oOneMonthsRow&&this._oOneMonthsRow.getSelectedDates().length){l=this._oOneMonthsRow.getSelectedDates()[0].getStartDate()}t.setStartDate(l);t.setShowIntervalHeaders(this.getShowIntervalHeaders());t.setShowEmptyIntervalHeaders(this.getShowEmptyIntervalHeaders());t.setGroupAppointmentsMode(this.getGroupAppointmentsMode());t.setAppointmentsReducedHeight(this.getAppointmentsReducedHeight());t.setAppointmentRoundWidth(this.getAppointmentRoundWidth());t.setLegend(this.getLegend());t.setAppointmentsVisualization(this.getAppointmentsVisualization());t.setAppointmentHeight(this.getAppointmentHeight());t.detachEvent("select",Ae,this).attachEvent("select",Ae,this);t.detachEvent("startDateChange",this._handleStartDateChange,this).attachEvent("startDateChange",this._handleStartDateChange,this);t.detachEvent("leaveRow",Be,this).attachEvent("leaveRow",Be,this);t.detachEvent("intervalSelect",Ce,this).attachEvent("intervalSelect",Ce,this);Ke.call(this);if(je.call(this)){a=this.getViewKey();i=this._getView(a);n=i.getIntervalType();s=i.getIntervalSize();r=this._getIntervals(i);t.setIntervalType(n);t.setIntervals(r);t.setIntervalSize(s);t.setShowSubIntervals(i.getShowSubIntervals())}this._setSelectionMode.call(this);if(this._fnCustomSortedAppointments){t._setCustomAppointmentsSorterCallback(this._fnCustomSortedAppointments)}};ge.prototype._observeRowChanges=function(e){var t=Ve(e),i=Ne(e),n=Ee(e);var r={destroy:function(){t.destroy()},change:{title:function(e){i.setProperty(e.name,e.current)},icon:function(e){if(i.setIcon){i.setIcon(e.current)}else{i.setProperty(e.name,e.current)}i.getAvatar()&&i.getAvatar().setSrc(e.current).setVisible(!!e.current)},text:function(e){n.toggleStyleClass("sapMPlanCalRowLarge",!!e.current);i.setProperty("description",e.current)},enableAppointmentsDragAndDrop:function(t){this._enableAppointmentsDragAndDrop(e)}.bind(this),enableAppointmentsResize:function(t){this._enableAppointmentsResize(e)}.bind(this),enableAppointmentsCreate:function(t){this._enableAppointmentsCreate(e)}.bind(this),nonWorkingDays:function(e){n.setProperty(e.name,e.current)},nonWorkingHours:function(e){n.setProperty(e.name,e.current)},selected:function(e){Ke.call(this);t.setProperty(e.name,e.current)}.bind(this),tooltip:function(e){if(e.mutation==="insert"){i.setTooltip(e.child)}else if(e.mutation==="remove"){i.setTooltip()}},intervalHeaders:function(e){n.invalidate()},appointments:function(e){n.invalidate()}}};new a(function(e){if(e.type==="destroy"){r.destroy()}else if(r.change[e.name]){r.change[e.name](e)}}).observe(e,{properties:["icon","text","title","nonWorkingDays","nonWorkingHours","selected","enableAppointmentsDragAndDrop","enableAppointmentsResize","enableAppointmentsCreate"],aggregations:["tooltip","appointments","intervalHeaders","headerContent"],destroy:true});e.invalidate=function(e){if(!e||!(e instanceof d)){y.prototype.invalidate.apply(this,arguments)}else if(t){n.invalidate(e)}};e.applyFocusInfo=function(e){n.applyFocusInfo(e);return this}};ge.prototype._createPlanningCalendarListItem=function(e){var t,a,i,n=e.getIcon();if(e.getHeaderContent().length||e.getBindingInfo("headerContent")){a=e._getPlanningCalendarCustomRowHeader()}else{a=new Ie(e.getId()+"-Head",{avatar:new k({src:n,displayShape:this.getIconShape(),visible:!!n}),icon:n,description:e.getText(),title:e.getTitle(),tooltip:e.getTooltip(),iconDensityAware:false,iconInset:false})}i=new be(e.getId()+"-CalRow",{checkResize:false,updateCurrentTime:false});if(this.getShowRowHeaders()){i.addAriaLabelledBy(a.getId())}i._getRelativeInfo=this._getRelativeInfo.bind(this);i.getAppointments=function(){return e.getAppointments()};i.getIntervalHeaders=function(){return e.getIntervalHeaders()};i.setAssociation("row",e.getId());t=a.isA("sap.m.CustomListItem")?new ke(e.getId()+le,{cells:[new J({items:[a]}),i]}):new ke(e.getId()+le,{cells:[a,i]});this._updateRowTimeline(e);this._observeRowChanges(e);this._enableAppointmentsDragAndDrop(e);this._enableAppointmentsResize(e);this._enableAppointmentsCreate(e);return t};ge.prototype._handleRowRemoval=function(e){var t=Ee(e);t.detachEvent("select",Ae,this);t.detachEvent("startDateChange",this._handleStartDateChange,this);t.detachEvent("leaveRow",Be,this);t.detachEvent("intervalSelect",Ce,this);if(this._fnCustomSortedAppointments){t._fnCustomSortedAppointments=undefined}Ve(e).destroy()};var Ie=U.extend("sap.m._PlanningCalendarRowHeader",{renderer:{apiVersion:2,renderTabIndex:function(e,t){},getAriaRole:function(e,t){}},TagName:"div"});Ie.prototype.isSelectable=function(){return false};var Me=m.extend(u);Me.apiVersion=2;Me.getLegendItems=function(e){var t=[],a,i=e.getLegend();if(i){a=_.byId(i);if(a){t=a.getAppointmentItems?a.getAppointmentItems():a.getItems()}else{j.error("PlanningCalendarLegend with id '"+i+"' does not exist!",e)}}return t};Me.renderBeforeAppointments=function(e,t){var a=Oe(t.getParent()),i;if(!a.getEnableAppointmentsDragAndDrop()&&!a.getEnableAppointmentsResize()&&!a.getEnableAppointmentsCreate()||t._isOneMonthsRowOnSmallSizes()){return}i=t.getAggregation("_intervalPlaceholders");e.openStart("div");e.class("sapUiCalendarRowAppsOverlay");e.openEnd();if(i){for(var n=0;n<i.length;n++){var r=i[n];r.setWidth(100/i.length+"%");e.renderControl(r)}}e.close("div")};Me.renderResizeHandle=function(e,t,a){if(!Oe(t.getParent()).getEnableAppointmentsResize()||t._isOneMonthsRowOnSmallSizes()||a._aAppointments&&a._aAppointments.length>0){return}e.openStart("span");e.class("sapUiCalendarAppResizeHandle");e.openEnd();e.close("span")};Me.writeCustomAttributes=function(e,t){if(Oe(t.getParent()).getEnableAppointmentsCreate()){e.attr("draggable","true")}};Me.renderInterval=function(e,t,a,i,n,r,s,o,l,g,h,p,d){var c=t.getIntervalType(),f;if(t._getRelativeInfo().bIsRelative){var _=[];return u.renderInterval(e,t,a,i,n,_,s,o,l,g,h,p,d,f)}if(c===te.Day||c===te.Week||c===te.OneMonth||c==="OneMonth"){var y=Oe(t.getParent()),m=y.getParent(),v=function(e){return e.getType()===G.NonWorking},D=y._getSpecialDates().filter(v),w=m._getSpecialDates().filter(v),C=t.getStartDate(),S,T,R,A;if(w&&D){S=w.concat(D)}else if(D){S=D}if(S&&S.length){var I=function(e){return e===T.getDay()};T=b.getInstance(C.getTime());T.setHours(0,0,0);T.setDate(C.getDate()+a);for(var M=0;M<S.length;M++){if(S[M].getStartDate()){R=b.getInstance(S[M].getStartDate().getTime())}if(S[M].getEndDate()){A=b.getInstance(S[M].getEndDate().getTime())}else{A=b.getInstance(S[M].getStartDate().getTime());A.setHours(23,59,59)}if(T.getTime()>=R.getTime()&&T.getTime()<=A.getTime()){var P=r.some(I);if(!P){f="sapUiCalendarRowAppsNoWork"}}}}}u.renderInterval(e,t,a,i,n,r,s,o,l,g,h,p,d,f)};var be=c.extend("sap.m._PlanningCalendarRowTimeline",{metadata:{aggregations:{intervalHeaders:{type:"sap.ui.unified.CalendarAppointment",multiple:true},_intervalPlaceholders:{type:"sap.m._PlanningCalendarIntervalPlaceholder",multiple:true,visibility:"hidden",dnd:{droppable:true}}},associations:{row:{type:"sap.m.PlanningCalendarRow",multiple:false}},dnd:true},renderer:Me});be.prototype._updatePlaceholders=function(){var e=this.getProperty("intervals");if(this.getIntervalType()===te.Hour){e*=2}this.removeAllAggregation("_intervalPlaceholders");for(var t=0;t<e;t++){this.addAggregation("_intervalPlaceholders",new Pe)}};be.prototype._getRelativeInfo=function(){};be.prototype.onBeforeRendering=function(){c.prototype.onBeforeRendering.call(this);this._updatePlaceholders()};be.prototype.onmousedown=function(e){var t=e.target.classList;this._isResizeHandleMouseDownTarget=t.contains("sapUiCalendarAppResizeHandle");this._isRowAppsIntervalMouseDownTarget=t.contains("sapUiCalendarRowAppsInt")};be.prototype._isResizingPerformed=function(){return this._isResizeHandleMouseDownTarget};be.prototype._isDraggingPerformed=function(){return!this._isResizeHandleMouseDownTarget&&!this._isRowAppsIntervalMouseDownTarget};be.prototype._isCreatingPerformed=function(){return this._isRowAppsIntervalMouseDownTarget};var Pe=t.extend("sap.m._PlanningCalendarIntervalPlaceholder",{metadata:{properties:{width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null}}},renderer:function(e,t){e.openStart("div",t);e.style("width",t.getWidth());e.class("sapUiCalendarRowAppsPlaceholder");e.openEnd();e.close("div")}});var ke=N.extend("sap.m.internal.PlanningCalendarRowListItem",{metadata:{library:"sap.m"},renderer:E});ke.prototype.getHeader=function(){return this.getCells()[0]};ke.prototype.getTimeline=function(){return this.getCells()[1]};ke.prototype.getCustomData=function(){return Oe(this).getCustomData()};ge.prototype._getSelectedDates=function(){var e=this.getViewKey(),t=this._getView(e),a=t.getIntervalType(),i=pe[a];return this[i.sInstanceName].getSelectedDates()};ge.prototype._enableAppointmentsDragAndDrop=function(e){var t=Ee(e),a;if(e.getEnableAppointmentsDragAndDrop()){a=e.getDragDropConfig().some(function(e){return e.getGroupName()===re});if(!a){this._addDragDropInfo(e,Ee(e))}}else{e.getDragDropConfig().forEach(function(t){if(t.getGroupName()===re){e.removeDragDropConfig(t);t.destroy()}});t.getDragDropConfig().forEach(function(e){if(e.getGroupName()===re){t.removeDragDropConfig(e);e.destroy()}})}};ge.prototype._enableAppointmentsResize=function(e){var t=e.getEnableAppointmentsResize(),a=this._getConfigFromDragDropConfigAggregation(e.getAggregation("dragDropConfig"),se),i;if(t&&!a){i=this._createResizeConfig(e);e.addAggregation("dragDropConfig",i,true)}if(!t&&a){e.removeAggregation("dragDropConfig",a,true);a.destroy()}};ge.prototype._enableAppointmentsCreate=function(e){var t=e.getEnableAppointmentsCreate(),a=Ee(e),i=this._getConfigFromDragDropConfigAggregation(a.getAggregation("dragDropConfig"),oe),n;if(t&&!i){n=this._createAppointmentsCreateConfig(e);a.addAggregation("dragDropConfig",n,true)}if(!t&&i){a.removeAggregation("dragDropConfig",i,true);i.destroy()}};ge.prototype._addDragDropInfo=function(e,t){e.addDragDropConfig(new w({groupName:re,sourceAggregation:"appointments",dragStart:function(e){var a=function(){var e=jQuery(".sapUiCalendarRowAppsOverlay");setTimeout(function(){e.addClass("sapUiCalendarRowAppsOverlayDragging")},0);jQuery(document).one("dragend",function(){e.removeClass("sapUiCalendarRowAppsOverlayDragging")})};if(t._isOneMonthsRowOnSmallSizes()||!t._isDraggingPerformed()){e.preventDefault();return}a()}}));t.addDragDropConfig(new C({groupName:re,targetAggregation:"_intervalPlaceholders",dragEnter:function(a){var i=a.getParameter("dragSession"),n=i.getDragControl(),r=t.getIntervalType(),s=t.getStartDate(),o=t.indexOfAggregation("_intervalPlaceholders",i.getDropControl()),l=t.getId(),g,h=function(){var e=jQuery(i.getIndicator()),t=i.getDropControl().getDomRef().getBoundingClientRect(),a=_.byId(l).getDomRef().getBoundingClientRect(),n=i.getDragControl().$().outerWidth(),r=_.getConfiguration().getRTL(),s=r?Math.ceil(t.right)-a.left:a.right-Math.ceil(t.left);e.css("min-width",n<s?n:s).css(r?"border-left-width":"border-right-width",n>s?"0":"").css("margin-left",r?-(e.outerWidth()-parseFloat(e.context.style.width)):"")};if(e.hasListeners("appointmentDragEnter")){if(r===te.Hour){g=this._calcNewHoursAppPos(s,n.getStartDate(),n.getEndDate(),o)}else if(r===te.Day||r===te.Week||(r===te.OneMonth||r==="OneMonth")&&!t._isOneMonthsRowOnSmallSizes()){g=this._calcNewDaysAppPos(s,n.getStartDate(),n.getEndDate(),o)}else if(r===te.Month){g=this._calcNewMonthsAppPos(s,n.getStartDate(),n.getEndDate(),o)}var p=e.fireAppointmentDragEnter({appointment:n,startDate:g.startDate,endDate:g.endDate,calendarRow:Oe(t.getParent())});if(!p){a.preventDefault();return}}else if(Ee(n.getParent())!==t){a.preventDefault();return}if(t.getIntervalType()!==te.Hour){return}if(!i.getIndicator()){setTimeout(h,0)}else{h()}}.bind(this),drop:function(a){var i=a.getParameter("dragSession"),n=i.getDragControl(),r=t.getIntervalType(),s=t.getStartDate(),o=t.indexOfAggregation("_intervalPlaceholders",i.getDropControl()),l,g=a.getParameter("browserEvent"),h=g.metaKey||g.ctrlKey;if(r===te.Hour){l=this._calcNewHoursAppPos(s,n.getStartDate(),n.getEndDate(),o)}else if(r===te.Day||r===te.Week||(r===te.OneMonth||r==="OneMonth")&&!t._isOneMonthsRowOnSmallSizes()){l=this._calcNewDaysAppPos(s,n.getStartDate(),n.getEndDate(),o)}else if(r===te.Month){l=this._calcNewMonthsAppPos(s,n.getStartDate(),n.getEndDate(),o)}t.$().find(".sapUiCalendarRowAppsOverlay").removeClass("sapUiCalendarRowAppsOverlayDragging");if(n.getStartDate().getTime()===l.startDate.getTime()&&n.getParent()===Oe(t.getParent())){return}e.fireAppointmentDrop({appointment:n,startDate:l.startDate,endDate:l.endDate,calendarRow:Oe(t.getParent()),copy:h})}.bind(this)}))};ge.prototype._calcNewHoursAppPos=function(e,t,a,i){var r=n._createUniversalUTCDate(e,null,true),s=n._createUniversalUTCDate(t,null,true),o=n._createUniversalUTCDate(a,null,true),l=b.getInstance(r.setUTCMinutes(0,0,0)+i*30*60*1e3);return{startDate:n._createLocalDate(l,true),endDate:n._createLocalDate(b.getInstance(l.getTime()+o.getTime()-s.getTime()),true)}};ge.prototype._calcNewDaysAppPos=function(e,t,a,i){var r=n._createUniversalUTCDate(e,null,true),s=n._createUniversalUTCDate(t,null,true),o=n._createUniversalUTCDate(a,null,true),l=o.getTime()-s.getTime();s.setUTCFullYear(r.getUTCFullYear(),r.getUTCMonth(),r.getUTCDate()+i);o=b.getInstance(s.getTime()+l);return{startDate:n._createLocalDate(s,true),endDate:n._createLocalDate(o,true)}};ge.prototype._calcNewMonthsAppPos=function(e,t,a,i){var r=n._createUniversalUTCDate(e,null,true),s=n._createUniversalUTCDate(t,null,true),o=n._createUniversalUTCDate(a,null,true),l=o.getTime()-s.getTime();s.setUTCFullYear(r.getUTCFullYear(),r.getUTCMonth()+i);o=b.getInstance(s.getTime()+l);return{startDate:n._createLocalDate(s,true),endDate:n._createLocalDate(o,true)}};ge.prototype._createResizeConfig=function(e){var t=Ee(e),a=new S({sourceAggregation:"appointments",targetAggregation:"_intervalPlaceholders",targetElement:Ee(e),dragStart:function(a){if(!e.getEnableAppointmentsResize()||t._isOneMonthsRowOnSmallSizes()||!t._isResizingPerformed()){a.preventDefault();return}var i=a.getParameter("dragSession"),n=t.$().find(".sapUiCalendarRowAppsOverlay"),r=jQuery(i.getIndicator()),s=i.getDragControl().$();r.addClass("sapUiDnDIndicatorHide");setTimeout(function(){n.addClass("sapUiCalendarRowAppsOverlayDragging")},0);jQuery(document).one("dragend",function(){n.removeClass("sapUiCalendarRowAppsOverlayDragging");r.removeClass("sapUiDnDIndicatorHide");s.css({width:"auto","min-width":"auto","z-index":"auto",opacity:1})});a.getParameter("browserEvent").dataTransfer.setDragImage(He(),0,0)},dragEnter:function(e){var t=e.getParameter("dragSession"),a=this.getTargetElement(),i=function(){var e=jQuery(t.getIndicator());e.addClass("sapUiDnDIndicatorHide")},n=t.getDropControl().getDomRef().getBoundingClientRect(),r=_.byId(a).getDomRef().getBoundingClientRect(),s={width:n.left+n.width-(t.getDragControl().$().position().left+r.left),"z-index":1,opacity:.8},o=s.width;if(n.width>0){while(o<=0){o+=n.width}while(o>n.width){o-=n.width}}s["min-width"]=o;t.getDragControl().$().css(s);if(!t.getIndicator()){setTimeout(i,0)}else{i()}},drop:function(t){var a=Ee(e),i=t.getParameter("dragSession"),n=i.getDragControl(),r=a.getIntervalType(),s=a.getStartDate(),o=a.indexOfAggregation("_intervalPlaceholders",i.getDropControl()),l;if(r===te.Hour){l=this._calcResizeNewHoursAppPos(s,n.getStartDate(),n.getEndDate(),o)}else if(r===te.Day||r===te.Week||(r===te.OneMonth||r==="OneMonth")&&!a._isOneMonthsRowOnSmallSizes()){l=this._calcResizeNewDaysAppPos(s,n.getStartDate(),n.getEndDate(),o)}else if(r===te.Month){l=this._calcResizeNewMonthsAppPos(s,n.getStartDate(),n.getEndDate(),o)}a.$().find(".sapUiCalendarRowAppsOverlay").removeClass("sapUiCalendarRowAppsOverlayDragging");jQuery(i.getIndicator()).removeClass("sapUiDnDIndicatorHide");n.$().css({width:"auto","min-width":"auto","z-index":"auto",opacity:1});if(n.getEndDate().getTime()===l.endDate.getTime()){return}e.fireAppointmentResize({appointment:n,startDate:l.startDate,endDate:l.endDate,calendarRow:e})}.bind(this)});a.setProperty("groupName",se);return a};ge.prototype._calcResizeNewHoursAppPos=function(e,t,a,i){var r=n._createUniversalUTCDate(b.getInstance(e.getTime()),null,true),s=30*60*1e3,o=n._createUniversalUTCDate(t,null,true),l=b.getInstance(r.setUTCMinutes(0,0,0)+(i+1)*s);if(l.getTime()<=o.getTime()){l=b.getInstance(o.getTime()+s)}return{startDate:n._createLocalDate(o,true),endDate:n._createLocalDate(l,true)}};ge.prototype._calcResizeNewDaysAppPos=function(e,t,a,i){var r=n._createUniversalUTCDate(e,null,true),s=n._createUniversalUTCDate(t,null,true),o=b.getInstance(r.setUTCDate(r.getUTCDate()+i+1)),l={};l.startDate=n._createLocalDate(s);l.startDateTime=n._createLocalDate(s,true);l.endDate=n._createLocalDate(o);if(l.endDate<=l.startDate){l.endDate=n._createLocalDate(b.getInstance(o.setUTCDate(s.getUTCDate()+1)))}return{startDate:l.startDateTime,endDate:l.endDate}};ge.prototype._calcResizeNewMonthsAppPos=function(e,t,a,i){var r=n._createUniversalUTCDate(e,null,true),s=n._createUniversalUTCDate(t,null,true),o=b.getInstance(r.setUTCMonth(r.getUTCMonth()+i+1,1));if(n._monthsBetween(s,o,true)<0){o=b.getInstance(o.setUTCFullYear(s.getUTCFullYear(),s.getUTCMonth()+1,1))}return{startDate:n._createLocalDate(s,true),endDate:n._createLocalDate(o)}};ge.prototype._calcCreateNewAppHours=function(e,t,a){var i=n._createUniversalUTCDate(e,null,true),r=30*60*1e3,s=t<=a?t:a,o=t<=a?a+1:t,l=b.getInstance(i.setUTCMinutes(0,0,0)),g=b.getInstance(l.getTime()+s*r),h=b.getInstance(l.getTime()+o*r);return{startDate:n._createLocalDate(g,true),endDate:n._createLocalDate(h,true)}};ge.prototype._calcCreateNewAppDays=function(e,t,a){var i=n._createUniversalUTCDate(e,null,true),r=t<=a?t:a,s=t<=a?a+1:t,o=b.getInstance(i.getTime()),l=b.getInstance(i.getTime());return{startDate:n._createLocalDate(b.getInstance(o.setUTCDate(o.getUTCDate()+r))),endDate:n._createLocalDate(b.getInstance(l.setUTCDate(l.getUTCDate()+s)))}};ge.prototype._calcCreateNewAppMonths=function(e,t,a){var i=n._createUniversalUTCDate(e,null,true),r=t<=a?t:a,s=t<=a?a+1:t,o=b.getInstance(i.getTime()),l=b.getInstance(i.getTime());return{startDate:n._createLocalDate(b.getInstance(o.setUTCMonth(o.getUTCMonth()+r,1))),endDate:n._createLocalDate(b.getInstance(l.setUTCMonth(l.getUTCMonth()+s,1)))}};ge.prototype._getConfigFromDragDropConfigAggregation=function(e,t){var a=e,i=a&&a.length;for(var n=0;n<i;n++){if(a[n].getGroupName()===t){return a[n]}}return null};ge.prototype._createAppointmentsCreateConfig=function(e){var t=Ee(e),a=new S({targetAggregation:"_intervalPlaceholders",dragStart:function(a){if(!e.getEnableAppointmentsCreate()||t._isOneMonthsRowOnSmallSizes()||!t._isCreatingPerformed()){a.preventDefault();return}var i=a.getParameter("dragSession"),n=t.$().find(".sapUiCalendarRowAppsOverlay"),r=jQuery(i.getIndicator());setTimeout(function(){n.addClass("sapUiCalendarRowAppsOverlayDragging")},0);jQuery(document).one("dragend",function(){n.removeClass("sapUiCalendarRowAppsOverlayDragging");r.html("");r.removeClass("sapUiCalendarApp sapUiCalendarAppType01 sapUiAppCreate")});a.getParameter("browserEvent").dataTransfer.setDragImage(He(),0,0)},dragEnter:function(e){var a=e.getParameter("dragSession"),i=a.getDropControl().getDomRef().getBoundingClientRect(),n=function(){var e=jQuery(a.getIndicator());e.addClass("sapUiCalendarApp sapUiCalendarAppType01 sapUiAppCreate")};var r=a.getData("text")?parseFloat(a.getData("text").split("|")[0]):0;if(r){if(r<=i.left){a.setIndicatorConfig({left:r,width:Math.max(i.left+i.width-r,i.width)})}else{a.setIndicatorConfig({left:i.left,width:r-i.left})}}else{a.setData("text",i.left+"|"+t.indexOfAggregation("_intervalPlaceholders",a.getDropControl()))}if(!a.getIndicator()){setTimeout(n,0)}else{n()}},drop:function(a){var i=a.getParameter("dragSession"),n=jQuery(i.getIndicator()),r=t.getIntervalType(),s=Ee(e).getStartDate(),o=parseInt(i.getData("text").split("|")[1]),l=t.indexOfAggregation("_intervalPlaceholders",i.getDropControl()),g;if(r===te.Hour){g=this._calcCreateNewAppHours(s,o,l)}else if(r===te.Day||r===te.Week||(r===te.OneMonth||r==="OneMonth")&&!t._isOneMonthsRowOnSmallSizes()){g=this._calcCreateNewAppDays(s,o,l)}else if(r===te.Month){g=this._calcCreateNewAppMonths(s,o,l)}e.fireAppointmentCreate({startDate:g.startDate,endDate:g.endDate,calendarRow:e});n.html("");n.removeClass("sapUiCalendarApp sapUiCalendarAppType01 sapUiAppCreate")}.bind(this)});a.setProperty("groupName",oe);return a};ge.prototype._updateHeaderButtons=function(){var e=this.getViewKey(),t=this._getView(e,true),a=t&&t.getIntervalType(),i=b.getInstance(this._dateNav.getStart().getTime()),n=b.getInstance(this._dateNav.getEnd().getTime()),r=this.getMinDate()?b.getInstance(this.getMinDate().getTime()):undefined,s=this.getMaxDate()?b.getInstance(this.getMaxDate().getTime()):undefined;if(a!=="Hour"){r&&r.setHours(0,0,0,0);s&&s.setHours(23,59,59,999);i.setHours(0,0,0,0);n.setHours(23,59,59,999)}this._getHeader()._oPrevBtn.setEnabled(!r||i.getTime()>r.getTime());this._getHeader()._oNextBtn.setEnabled(!s||n.getTime()<s.getTime())};ge.prototype._getSpecialDates=function(){var e=this.getSpecialDates();for(var t=0;t<e.length;t++){var a=e[t].getSecondaryType()===i.CalendarDayType.NonWorking&&e[t].getType()!==i.CalendarDayType.NonWorking;if(a){var n=new p;n.setType(i.CalendarDayType.NonWorking);n.setStartDate(e[t].getStartDate());if(e[t].getEndDate()){n.setEndDate(e[t].getEndDate())}e.push(n)}}return e};function He(){var e=jQuery("<span></span>").addClass("sapUiCalAppResizeGhost");e.appendTo(document.body);setTimeout(function(){e.remove()},0);return e.get(0)}function Oe(e){var t=e.getId();return _.byId(t.substring(0,t.indexOf(le)))}function Ve(e){return _.byId(e.getId()+le)}function Ne(e){var t=Ve(e);return t?t.getHeader():null}function Ee(e){var t=Ve(e);return t?t.getTimeline():null}function Le(e){var t=[];var a=this.getRows();for(var i=0;i<a.length;i++){var n=a[i];var r=Ve(n);var s=r.getSelected();if(n.getSelected()!=s){n.setProperty("selected",s,true);t.push(n)}}if(!this.getSingleSelection()){Ke.call(this)}if(t.length>0){this.fireRowSelectionChange({rows:t})}}function Ue(e){if(e<this._iBreakPointTablet){this._iSize=0}else if(e<this._iBreakPointDesktop){this._iSize=1}else{this._iSize=2}if(e<ue.PHONE){this._iSizeScreen=0}else if(e<ue.TABLET){this._iSizeScreen=1}else{this._iSizeScreen=2}}function xe(e){var t="sapMSize"+e,a,i;for(a=0;a<3;a++){i="sapMSize"+a;if(i===t){this.addStyleClass(i)}else{this.removeStyleClass(i)}}}function We(){var e=this._getViews();this._oIntervalTypeSelect.destroyItems();var t;var a;for(t=0;t<e.length;t++){var i=e[t];a=new L(this.getId()+"-"+t,{key:i.getKey(),text:i.getDescription(),tooltip:i.getTooltip()});this._oIntervalTypeSelect.addItem(a)}if(this._oIntervalTypeSelect.getItems().length>4){this._getHeader()._convertViewSwitchToSelect()}else{this._getHeader()._convertViewSwitchToSegmentedButton()}this._oIntervalTypeSelect.setVisible(!(e.length===1))}function ze(e){var t=e.getParameter("selected");var a=this.getRows();if(t){a=this.getRows().filter(function(e){return!e.getSelected()})}this.selectAllRows(t);this.fireRowSelectionChange({rows:a})}function Be(e){var t=e.oSource;var a=e.getParameter("type");var i=this.getRows();var n;var r;var s;var o;var l=0;var g=0;var h;for(l=0;l<i.length;l++){n=i[l];if(Ee(n)==t){g=l;break}}switch(a){case"sapup":s=t.getFocusedAppointment();o=s.getStartDate();if(g>0){g--}r=i[g];Ee(r).focusNearestAppointment(o);break;case"sapdown":s=t.getFocusedAppointment();o=s.getStartDate();if(g<i.length-1){g++}r=i[g];Ee(r).focusNearestAppointment(o);break;case"saphome":if(g>0){r=i[0];h=new jQuery.Event(a);h._bPlanningCalendar=true;Ee(r).onsaphome(h)}break;case"sapend":if(g<i.length-1){r=i[i.length-1];h=new jQuery.Event(a);h._bPlanningCalendar=true;Ee(r).onsapend(h)}break;default:break}}function Ke(){if(this._oSelectAllCheckBox){var e=this.getRows();var t=this.getSelectedRows();if(e.length==t.length&&t.length>0){this._oSelectAllCheckBox.setSelected(true)}else{this._oSelectAllCheckBox.setSelected(false)}}}function Fe(){if(this.getSingleSelection()){if(this._oCalendarHeader.getAllCheckBox()){this._oCalendarHeader.setAllCheckBox()}else if(this._oInfoToolbar.getContent().length>2){this._oInfoToolbar.removeContent(this._oSelectAllCheckBox)}}else{if(!this._oSelectAllCheckBox){this._oSelectAllCheckBox=new B(this.getId()+"-All",{text:this._oRB.getText("COLUMNSPANEL_SELECT_ALL")});this._oSelectAllCheckBox.attachEvent("select",ze,this)}if(this._iSizeScreen<2||!this.getShowRowHeaders()){var e=this._oInfoToolbar.indexOfContent(this._oSelectAllCheckBox);if(this._iSizeScreen<2){if(e<this._oInfoToolbar.getContent().length-1){this._oInfoToolbar.addContent(this._oSelectAllCheckBox)}}else if(e<0||e>1){if(e>1){this._oInfoToolbar.removeContent(this._oSelectAllCheckBox)}this._oInfoToolbar.insertContent(this._oSelectAllCheckBox,1)}}else{this._oCalendarHeader.setAllCheckBox(this._oSelectAllCheckBox)}}}ge.prototype._setSelectionMode=function(){var e=this.getAggregation("table");var t=e.getMode();var a;if(this.getSingleSelection()){if(!this.getShowRowHeaders()&&this.getRows().length==1){a=$.None}else{a=$.SingleSelectMaster}}else{a=$.MultiSelect}if(t!=a){e.setMode(a)}};ge.prototype.calcIntervalOffset=function(e){var t=Date.UTC(e.getFullYear(),e.getMonth(),e.getDate());var a=this.getMinDate()||e;var i=Date.UTC(a.getFullYear(),a.getMonth(),a.getDate());return Math.round((t-i)/1e3/60/60/24/this._getView(this.getViewKey()).getIntervalSize())};ge.prototype._getDateFromIndex=function(e){var t=b.getInstance(this.getMinDate());t.setDate(t.getDate()+e*this._getView(this.getViewKey()).getIntervalSize());return t};ge.prototype._getRelativeInfo=function(){var e={},t=this._getView(this.getViewKey(),true);e.iIntervalSize=t.getIntervalSize();e.bIsRelative=t.getRelative();e.oMinDate=this.getMinDate();e._getDateFromIndex=this._getDateFromIndex.bind(this);e.intervalLabelFormatter=t.getIntervalLabelFormatter()?t.getIntervalLabelFormatter():function(e){return e};e._getIndexFromDate=this.calcIntervalOffset.bind(this);return e};function je(){return this._oTimesRow||this._oDatesRow||this._oMonthsRow||this._oWeeksRow||this._oOneMonthsRow}function Je(){if(!this._getHeader()){return 0}var e=this._getHeader().getDomRef(),t=0,a;if(e){a=e.getBoundingClientRect();t=parseInt(a.height)}return t}return ge});
//# sourceMappingURL=PlanningCalendar.js.map