/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Renderer","./SliderRenderer","sap/ui/core/InvisibleText","sap/ui/core/Configuration"],function(e,t,a,i){"use strict";var n=e.extend(t);n.apiVersion=2;n.renderHandles=function(e,t,a){this.renderHandle(e,t,{id:t.getId()+"-handle1",position:"start",forwardedLabels:a,pressed:t.getProperty("startHandlePressed")});this.renderHandle(e,t,{id:t.getId()+"-handle2",position:"end",forwardedLabels:a,pressed:t.getProperty("endHandlePressed")});e.renderControl(t._mHandleTooltip.start.label);e.renderControl(t._mHandleTooltip.end.label);e.renderControl(t.getAggregation("_handlesLabels")[2])};n.renderHandle=function(e,n,r){var s,o=n.getRange(),d=n.getEnabled(),l=i.getRTL();e.openStart("span",r&&r.id);if(r&&r.position!==undefined){s=o[r.position==="start"?0:1];e.attr("data-range-val",r.position);e.attr("aria-labelledby",(r.forwardedLabels+" "+n._mHandleTooltip[r.position].label.getId()).trim());if(n.getInputsAsTooltips()){e.attr("aria-describedby",a.getStaticId("sap.m","SLIDER_INPUT_TOOLTIP"));d&&e.attr("aria-keyshortcuts","F2")}}if(n.getShowHandleTooltip()&&!n.getShowAdvancedTooltip()){this.writeHandleTooltip(e,n)}e.class(t.CSS_CLASS+"Handle");e.attr("data-ui5-handle-position",r.position);if(r.pressed){e.class(t.CSS_CLASS+"HandlePressed")}if(r&&r.id!==undefined&&r.id===n.getId()+"-handle1"){e.style(l?"right":"left",o[0])}if(r&&r.id!==undefined&&r.id===n.getId()+"-handle2"){e.style(l?"right":"left",o[1])}this.writeAccessibilityState(e,n,s);if(d){e.attr("tabindex","0")}e.openEnd().close("span")};n.writeAccessibilityState=function(e,t,a){var i=t._isElementsFormatterNotNumerical(a),n=t._formatValueByCustomElement(a),r;if(t._getUsedScale()&&!i){r=n}else{r=t.toFixed(a)}e.accessibilityState(t,{role:"slider",orientation:"horizontal",valuemin:t.toFixed(t.getMin()),valuemax:t.toFixed(t.getMax()),valuenow:r});if(i){e.accessibilityState(t,{valuetext:n})}};n.renderStartLabel=function(e,a){e.openStart("div").class(t.CSS_CLASS+"RangeLabel").openEnd().text(a.getMin()).close("div")};n.renderEndLabel=function(e,a){e.openStart("div").class(t.CSS_CLASS+"RangeLabel").style("width",a._getMaxTooltipWidth()+"px").openEnd().text(a.getMax()).close("div")};n.renderLabels=function(e,a){if(!a.getEnableTickmarks()){e.openStart("div").class(t.CSS_CLASS+"Labels").openEnd();this.renderStartLabel(e,a);this.renderEndLabel(e,a);e.close("div")}};n.renderProgressIndicator=function(e,t,a){var i=t.getRange();var n=t.getProperty("progressBarSize");i[0]=t.toFixed(i[0],t._iDecimalPrecision);i[1]=t.toFixed(i[1],t._iDecimalPrecision);var r=Math.abs(i[1]-i[0]);e.openStart("div",t.getId()+"-progress");if(t.getEnabled()){e.attr("tabindex","0")}this.addProgressIndicatorClass(e,t);e.style("width",t._sProgressValue);if(n){e.style("left",n.left);e.style("right",n.right)}e.accessibilityState(t,{role:"slider",orientation:"horizontal",valuemin:t.toFixed(t.getMin()),valuemax:t.toFixed(t.getMax()),valuenow:r,valuetext:t._oResourceBundle.getText("RANGE_SLIDER_RANGE_ANNOUNCEMENT",i.map(t._formatValueByCustomElement,t)),labelledby:(a+" "+t.getAggregation("_handlesLabels")[2].getId()).trim()}).openEnd().close("div")};n.addClass=function(e,a){t.addClass(e,a);e.class("sapMRangeSlider")};n.applyTickmarkStyles=function(e,t,a,i){const n=(e,t,a,i)=>Math.floor((e-t)/i);const r=t.getMin();const s=t.getMax();const o=t.getStep();const d=t.getValue();const l=t.getValue2();const c=n(d,r,s,o);const g=n(l,r,s,o);const u=(e,t,a)=>e>=Math.min(t,a)&&e<=Math.max(t,a);e.attr("data-ui5-active-tickmark",u(a,c,g))};n.shouldRenderFirstActiveTickmark=function(e){return e.getValue()===e.getMin()};n.shouldRenderLastActiveTickmark=function(e){return e.getValue2()===e.getMax()};return n},true);
//# sourceMappingURL=RangeSliderRenderer.js.map