/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./Dialog","./Popover","./library","sap/ui/core/Control","sap/ui/core/IconPool","sap/ui/core/StaticArea","sap/ui/Device","./ResponsivePopoverRenderer","./Toolbar","./ToolbarSpacer","./Button"],function(t,e,o,n,r,i,s,a,l,p,u){"use strict";var g=o.DialogType;var h=o.PlacementType;var f=o.TitleAlignment;var c=n.extend("sap.m.ResponsivePopover",{metadata:{library:"sap.m",properties:{placement:{type:"sap.m.PlacementType",group:"Misc",defaultValue:h.Right},showHeader:{type:"boolean",group:"Misc",defaultValue:true},title:{type:"string",group:"Misc",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},modal:{type:"boolean",group:"Misc",defaultValue:null},offsetX:{type:"int",group:"Misc",defaultValue:null},offsetY:{type:"int",group:"Misc",defaultValue:null},showArrow:{type:"boolean",group:"Appearance",defaultValue:true},contentWidth:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null},contentHeight:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null},horizontalScrolling:{type:"boolean",group:"Misc",defaultValue:true},verticalScrolling:{type:"boolean",group:"Misc",defaultValue:true},showCloseButton:{type:"boolean",group:"Misc",defaultValue:true},resizable:{type:"boolean",group:"Dimension",defaultValue:false},titleAlignment:{type:"sap.m.TitleAlignment",group:"Misc",defaultValue:f.Auto}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},customHeader:{type:"sap.m.IBar",multiple:false},subHeader:{type:"sap.m.IBar",multiple:false},beginButton:{type:"sap.m.Button",multiple:false},endButton:{type:"sap.m.Button",multiple:false},_popup:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},associations:{initialFocus:{type:"sap.ui.core.Control",multiple:false},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"}},events:{beforeOpen:{parameters:{openBy:{type:"sap.ui.core.Control"}}},afterOpen:{parameters:{openBy:{type:"sap.ui.core.Control"}}},beforeClose:{parameters:{openBy:{type:"sap.ui.core.Control"},origin:{type:"sap.m.Button"}}},afterClose:{parameters:{openBy:{type:"sap.ui.core.Control"},origin:{type:"sap.m.Button"}}}}},renderer:a});c.prototype.init=function(){var o=this;this._bAppendedToUIArea=false;var r={resizable:o.getResizable(),titleAlignment:o.getTitleAlignment(),beforeOpen:function(t){o.fireBeforeOpen({openBy:t.getParameter("openBy")})},afterOpen:function(t){o.fireAfterOpen({openBy:t.getParameter("openBy")})},beforeClose:function(t){o.fireBeforeClose({openBy:t.getParameter("openBy"),origin:t.getParameter("origin")})},afterClose:function(t){o.fireAfterClose({openBy:t.getParameter("openBy"),origin:t.getParameter("origin")})}};if(s.system.phone){this._aNotSupportedProperties=["placement","modal","offsetX","offsetY","showCloseButton"];r.stretch=true;r.type=g.Standard;r.titleAlignment=this.getTitleAlignment();this._oControl=new t(this.getId()+"-dialog",r)}else{this._aNotSupportedProperties=["icon","showCloseButton"];this._oControl=new e(this.getId()+"-popover",r)}this.setAggregation("_popup",this._oControl);this._oControl.addStyleClass("sapMResponsivePopover");this._oDelegate={onBeforeRendering:function(){var t=this.getShowCloseButton(),e=this._oControl._getAnyHeader(),o,n,r;if(!t||!s.system.phone){this._removeCloseButton(e);return}if(!this._bContentChanged){return}this._bContentChanged=false;if(e){this._insertCloseButton(e)}else{o=this._getSingleNavContent();if(!o){return}n=o.getCurrentPage();r=this._getRealPage(n);if(r&&(e=r._getAnyHeader())){this._insertCloseButton(e)}o.attachEvent("navigate",this._fnOnNavigate,this)}if(this._oControl&&this._oControl.setTitleAlignment){this._oControl.setTitleAlignment(this.getTitleAlignment())}}};this._oPageDelegate={onAfterShow:function(){var t=o._getRealPage(this),e;if(t&&(e=t._getAnyHeader())){o._insertCloseButton(e)}}};this._fnOnNavigate=function(t){var e=t.getParameter("to");if(e){e.addEventDelegate(this._oPageDelegate,e)}};this._oControl.addEventDelegate(this._oDelegate,this);this._oControl._removeChild=function(t,e,r){var i,s;if(e==="content"&&(t&&t.isA("sap.m.NavContainer"))){i=t.getPages();for(s=0;s<i.length;s++){i[s].removeEventDelegate(o._oPageDelegate)}t.detachEvent("navigate",o._fnOnNavigate,o)}n.prototype._removeChild.apply(this,arguments)}};c.prototype.openBy=function(t){if(!this._bAppendedToUIArea&&!this.getParent()){var e=i.getUIArea();e.addContent(this,true);this._bAppendedToUIArea=true}if(s.system.phone){return this._oControl.open()}else{return this._oControl.openBy(t)}};c.prototype.exit=function(){if(this._oCloseButton){this._oCloseButton.destroy();this._oCloseButton=null}if(this._oControl){this._oControl.removeEventDelegate(this._oDelegate);this._oControl.destroy();this._oControl=null}};c.prototype._getCloseButton=function(){if(!this._oCloseButton){var t=this;this._oCloseButton=new u(this.getId()+"-closeButton",{icon:r.getIconURI("decline"),press:function(){t._oControl._oCloseTrigger=this;t.close()}})}return this._oCloseButton};c.prototype.addContent=function(t){this._bContentChanged=true;this.addAggregation("content",t);return this};c.prototype.clone=function(){var t=n.prototype.clone.apply(this,arguments),e=this.getAggregation("_popup").getContent();for(var o=0;o<e.length;o++){t.addContent(e[o].clone())}return t};c.prototype._getSingleNavContent=function(){var t=this.getContent();while(t.length===1&&t[0]&&t[0].isA("sap.ui.core.mvc.View")){t=t[0].getContent()}if(t.length===1&&t[0]&&t[0].isA("sap.m.NavContainer")){return t[0]}else{return null}};c.prototype._getRealPage=function(t){var e=t,o;while(e){if(e.isA("sap.m.Page")){return e}if(e.isA("sap.ui.core.mvc.View")){o=e.getContent();if(o.length===1){e=o[0];continue}}e=null}return e};c.prototype._insertCloseButton=function(t){var e=this._getCloseButton(),o;if(t&&t.addContentRight){o=t.getAggregation("contentRight",[]).length;t.insertAggregation("contentRight",e,o)}};c.prototype._removeCloseButton=function(t){var e=this._getCloseButton();if(t){t.removeAggregation("contentRight",e)}};c.prototype._firstLetterUpperCase=function(t){return t.charAt(0).toUpperCase()+t.slice(1)};c.prototype._lastIndexOfUpperCaseLetter=function(t){var e,o;for(e=t.length-1;e>=0;e--){o=t.charAt(e);if(o===o.toUpperCase()){return e}}return-1};c.prototype.setProperty=function(t,e,o){n.prototype.setProperty.call(this,t,e,true);var r="set"+this._firstLetterUpperCase(t);if(this._aNotSupportedProperties.indexOf(t)===-1&&r in this._oControl){this._oControl[r](e)}return this};c.prototype.setModel=function(t,e){this._oControl.setModel(t,e);return n.prototype.setModel.call(this,t,e)};c.prototype._createButtonFooter=function(){if(this._oFooter){return this._oFooter}this._oFooter=new l(this.getId()+"-footer",{content:[new p]});return this._oFooter};c.prototype._getButtonFooter=function(){return s.system.phone?this._oControl._getToolbar():this._oControl.getFooter()};c.prototype._getPopup=function(){return this._oControl.oPopup};c.prototype._setButton=function(t,o){if(this._oControl instanceof e){var n="get"+this._firstLetterUpperCase(t)+"Button",r=this[n](),i=this._createButtonFooter(),s="_o"+this._firstLetterUpperCase(t)+"Button",a=t.toLowerCase()==="begin"?"getEndButton":"getBeginButton",l;if(t.toLowerCase()==="begin"){l=0}else{l=this.getBeginButton()?1:0}if(r){i.removeContent(r)}if(o){if(!i.getParent()){this._oControl.setFooter(i)}i.insertContent(o,l+1)}else{var p=this[a]();if(!p){i.destroy();this._oFooter=null}}this[s]=o;return this}else{var u=t.toLowerCase()+"Button";return this.setAggregation(u,o)}};c.prototype._getButton=function(t){if(this._oControl instanceof e){var o="_o"+this._firstLetterUpperCase(t)+"Button";return this[o]}else{var n="get"+this._firstLetterUpperCase(t)+"Button";return this._oControl[n]()}};c.prototype.setBeginButton=function(t){this._oControl.setBeginButton(t);return this._setButton("begin",t)};c.prototype.setEndButton=function(t){this._oControl.setEndButton(t);return this._setButton("end",t)};c.prototype.setShowCloseButton=function(t){var e=this._oControl._getAnyHeader();if(t){this._insertCloseButton(e)}else{this._removeCloseButton(e)}this.setProperty("showCloseButton",t,true);return this};c.prototype.getBeginButton=function(){return this._getButton("begin")};c.prototype.getEndButton=function(){return this._getButton("end")};["bindAggregation","validateAggregation","setAggregation","getAggregation","indexOfAggregation","insertAggregation","addAggregation","removeAggregation","removeAllAggregation","destroyAggregation","setAssociation","getAssociation","addAssociation","removeAssociation","removeAllAssociation, addDependent, removeDependent, removeAllDependents, destroyDependents, getDependents, indexOfDependent"].forEach(function(t){c.prototype[t]=function(){var e=this._lastIndexOfUpperCaseLetter(t),o,r;if(typeof arguments[0]==="string"){if(e!==-1){o=t.substring(0,e)+this._firstLetterUpperCase(arguments[0]);o=o==="addDependents"?"addDependent":o;if(this._oControl&&this._oControl[o]){r=this._oControl[o].apply(this._oControl,Array.prototype.slice.call(arguments,1));return r===this._oControl?this:r}else{return n.prototype[t].apply(this,arguments)}}}r=this._oControl[t].apply(this._oControl,arguments);return r===this._oControl?this:r}});["invalidate","close","isOpen","addStyleClass","removeStyleClass","toggleStyleClass","hasStyleClass","getDomRef","setBusy","getBusy","setBusyIndicatorDelay","getBusyIndicatorDelay","addEventDelegate","removeEventDelegate","_setAriaModal","_setAriaRoleApplication"].forEach(function(t){c.prototype[t]=function(){if(this._oControl&&this._oControl[t]){if(t==="invalidate"&&arguments[0]===this._oControl){return n.prototype.invalidate.apply(this,arguments)}var e=this._oControl[t].apply(this._oControl,arguments);return e===this._oControl?this:e}}});c.prototype._applyContextualSettings=function(){n.prototype._applyContextualSettings.call(this)};return c});
//# sourceMappingURL=ResponsivePopover.js.map