/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Lib","./library","./Button","./SegmentedButtonItem","./Select","sap/ui/core/Control","sap/ui/core/EnabledPropagator","sap/ui/core/delegate/ItemNavigation","sap/ui/core/ResizeHandler","sap/ui/core/ListItem","sap/ui/core/IconPool","./SegmentedButtonRenderer"],function(t,e,i,n,o,s,r,a,l,u,h,d){"use strict";var c;var g=s.extend("sap.m.SegmentedButton",{metadata:{interfaces:["sap.ui.core.IFormContent","sap.m.IOverflowToolbarContent","sap.m.IToolbarInteractiveControl"],library:"sap.m",designtime:"sap/m/designtime/SegmentedButton.designtime",publicMethods:["createButton"],properties:{width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null},enabled:{type:"boolean",group:"Behavior",defaultValue:true},selectedKey:{type:"string",group:"Data",defaultValue:"",bindable:"bindable"}},defaultAggregation:"buttons",aggregations:{buttons:{type:"sap.m.Button",multiple:true,singularName:"button",deprecated:true},items:{type:"sap.m.SegmentedButtonItem",multiple:true,singularName:"item",bindable:"bindable"},_select:{type:"sap.m.Select",multiple:false,visibility:"hidden"}},associations:{selectedButton:{deprecated:true,type:"sap.m.Button",multiple:false},selectedItem:{type:"sap.m.SegmentedButtonItem",multiple:false},ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{select:{deprecated:true,parameters:{button:{type:"sap.m.Button"},id:{type:"string"},key:{type:"string"}}},selectionChange:{parameters:{item:{type:"sap.m.SegmentedButtonItem"}}}},dnd:{draggable:true,droppable:false}},renderer:d});r.call(g.prototype);g.prototype.init=function(){this._aWidths=[];this._oItemNavigation=new a;this._oItemNavigation.setCycling(false);this._oItemNavigation.setDisabledModifiers({sapnext:["alt","meta"],sapprevious:["alt","meta"],saphome:["alt","meta"],sapend:["meta"]});this.addDelegate(this._oItemNavigation);this.removeButton=function(t){var e=g.prototype.removeButton.call(this,t);this.setSelectedButton(this.getButtons()[0]);this._fireChangeEvent();return e}};g.prototype.onBeforeRendering=function(){var t=this._getVisibleButtons();this._bCustomButtonWidth=t.some(function(t){return t.getWidth()});if(this._sResizeListenerId){l.deregister(this._sResizeListenerId);this._sResizeListenerId=null}this.setSelectedKey(this.getProperty("selectedKey"));if(!this.getSelectedButton()){this._selectDefaultButton()}};g.prototype.onAfterRendering=function(){var t=this._getVisibleButtons(),e;if(!this._sResizeListenerId){e=this.getDomRef().parentNode;if(e){this._sResizeListenerId=l.register(e,this._handleContainerResize.bind(this))}}this._setItemNavigation();this._aWidths=this._getRenderedButtonWidths(t);this._updateWidth()};g.prototype.onThemeChanged=function(){this._handleContainerResize()};g.prototype._handleContainerResize=function(){var t=this._getVisibleButtons();this._clearAutoWidthAppliedToControl();this._aWidths=this._getRenderedButtonWidths(t);this._updateWidth()};g.prototype._clearAutoWidthAppliedToControl=function(){var t=this._getVisibleButtons(),e=t.length,i,n=0;if(!this.getWidth()){this.$().css("width","")}while(n<e){i=t[n];if(!i.getWidth()){i.$().css("width","")}n++}};g.prototype._getRenderedButtonWidths=function(t){return t.map(function(t){var e=t.getDomRef();return e&&e.getBoundingClientRect?e.getBoundingClientRect().width:t.$().outerWidth()})};g.prototype._getButtonWidth=function(t){var e=t.length,i,n=0,o=0,s=0,r,a,l=0;if(this._bCustomButtonWidth){while(l<e){i=t[l].getWidth();if(i){if(i.indexOf("%")!==-1){o+=parseInt(i.slice(0,-1))}else{s+=parseInt(i.slice(0,-2))}}else{n++}l++}if(n===0){return false}r=(100-o)/n;a=s/n;if(r<0){r=0}if(a<0){a=0}if(a>0){return"calc("+r+"% - "+a+"px)"}else{return r+"%"}}else{return 100/e+"%"}};g.prototype._updateWidth=function(){if(this.$().length===0||this.hasStyleClass("sapMSegmentedButtonNoAutoWidth")){return}var t=this.getWidth(),e=this._getVisibleButtons(),i=e.length,n=this._aWidths.length>0?Math.max.apply(Math,this._aWidths):0,o=100/i,s=this.$().parent().innerWidth(),r=this._getButtonWidth(e),a,l,u;if(!t){if(n*i>s){this.addStyleClass("sapMSegBFit")}else if(n>0){this.$().width(n*i+1);this.removeStyleClass("sapMSegBFit")}u=0;while(u<i){l=e[u];l.$().css("width",l.getWidth()?l.getWidth():r);u++}}else if(t&&!this._bCustomButtonWidth){u=0;while(u<i){e[u].$().css("width",o+"%");u++}}a=Math.floor(this.getDomRef().getBoundingClientRect().width);if(this._previousWidth!==undefined&&a!==this._previousWidth&&!this._bInOverflow){this.fireEvent("_containerWidthChanged")}this._previousWidth=a};g.prototype.exit=function(){if(this._sResizeListenerId){l.deregister(this._sResizeListenerId);this._sResizeListenerId=null}if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation}this._bCustomButtonWidth=null;this._aWidths=null};g.prototype._setItemNavigation=function(){var t,e=this.getDomRef();if(e){this._oItemNavigation.setRootDomRef(e);t=this.$().find(".sapMSegBBtn:not(.sapMSegBBtnDis)");this._oItemNavigation.setItemDomRefs(t);this._focusSelectedButton()}};g.prototype.getOverflowToolbarConfig=function(){return{canOverflow:true,listenForEvents:["selectionChange"],autoCloseEvents:["selectionChange"],propsUnrelatedToSize:["enabled","selectedKey"],invalidationEvents:["_containerWidthChanged"],onBeforeEnterOverflow:this._onBeforeEnterOverflow,onAfterExitOverflow:this._onAfterExitOverflow}};g.prototype._onBeforeEnterOverflow=function(t){t._toSelectMode()};g.prototype._onAfterExitOverflow=function(t){if(t._bForcedSelectMode){t._toSelectMode()}else{t._toNormalMode()}};g.prototype.getFormDoNotAdjustWidth=function(){return true};g.prototype.createButton=function(t,e,n,o){var s=new i;if(t!==null){s.setText(t)}if(e!==null){s.setIcon(e)}if(n||n===undefined){s.setEnabled(true)}else{s.setEnabled(false)}if(o){s.setTextDirection(o)}this.addButton(s);return s};(function(){g.prototype.addButton=function(e){if(e){t(e,this);this.addAggregation("buttons",e);this._syncSelect();this._fireChangeEvent()}return this};g.prototype.insertButton=function(e,i){if(e){t(e,this);this.insertAggregation("buttons",e,i);this._syncSelect();this._fireChangeEvent()}return this};function t(t,e){t.attachPress(function(t){e._buttonPressed(t)});t.attachEvent("_change",e._syncSelect,e);t.attachEvent("_change",e._fireChangeEvent,e);var n=i.prototype.setEnabled;t.setEnabled=function(e){t.$().toggleClass("sapMSegBBtnDis",!e).toggleClass("sapMFocusable",e);n.apply(t,arguments)};t.setVisible=function(t){i.prototype.setVisible.apply(this,arguments);e.invalidate()}}})();g.prototype.getSelectedKey=function(){var t=this.getButtons(),e=this.getItems(),i=this.getSelectedButton(),n=0;if(e.length>0){for(;n<t.length;n++){if(t[n]&&t[n].getId()===i){this.setProperty("selectedKey",e[n].getKey(),true);return e[n].getKey()}}}return""};g.prototype.setSelectedKey=function(t){var e=this.getButtons(),i=this.getItems(),n=0;if(!t){this.setProperty("selectedKey",t,true);return this}if(i.length>0&&e.length>0){for(;n<i.length;n++){if(i[n]&&i[n].getKey()===t){this.setSelectedItem(i[n]);break}}}this.setProperty("selectedKey",t,true);return this};g.prototype.getButtons=function(){return this.getAggregation("buttons")||[]};g.prototype.removeButton=function(t){var e=this.removeAggregation("buttons",t);if(e){delete e.setEnabled;e.detachEvent("_change",this._syncSelect,this);e.detachEvent("_change",this._fireChangeEvent,this);this._syncSelect()}return e};g.prototype.removeAllButtons=function(){var t=this.getButtons();if(t){for(var e=0;e<t.length;e++){var i=t[e];if(i){delete i.setEnabled;this.removeAggregation("buttons",i);i.detachEvent("_change",this._syncSelect,this);i.detachEvent("_change",this._fireChangeEvent,this)}}this._syncSelect()}return t};g.prototype.addItem=function(t){this.addAggregation("items",t);this.addButton(t.oButton);return this};g.prototype.removeItem=function(t){var e;if(t!==null&&t!==undefined){e=this.removeAggregation("items",t);this.removeButton(t.oButton)}if(t instanceof n&&this.getSelectedButton()===t.oButton.getId()){this.setSelectedKey("");this.setSelectedButton("");this.setSelectedItem("")}this.setSelectedItem(this.getItems()[0]);return e};g.prototype.insertItem=function(t,e){this.insertAggregation("items",t,e);this.insertButton(t.oButton,e);return this};g.prototype.removeAllItems=function(t){var e=this.removeAllAggregation("items",t);this.removeAllButtons();this.setSelectedKey("");this.setSelectedButton("");this.setSelectedItem("");return e};g.prototype._buttonPressed=function(t){var e=t.getSource(),i;if(this.getSelectedButton()!==e.getId()){this.getButtons().forEach(function(t){t.$().removeClass("sapMSegBBtnSel");t.$().attr("aria-selected",false)});i=this.getItems().filter(function(t){return t.oButton===e})[0];e.$().addClass("sapMSegBBtnSel");e.$().attr("aria-selected",true);this.setAssociation("selectedButton",e,true);this.setProperty("selectedKey",this.getSelectedKey(),true);this.setAssociation("selectedItem",i,true);this.fireSelectionChange({item:i});this.fireSelect({button:e,id:e.getId(),key:this.getSelectedKey()})}};g.prototype._selectDefaultButton=function(){var t=this._getVisibleButtons();if(t.length>0){this.setAssociation("selectedButton",t[0],true);if(this.getItems().length>0){this.setAssociation("selectedItem",this.getItems()[0],true)}}};g.prototype.getSelectedButton=function(){return this.getAssociation("selectedButton")};g.prototype.setSelectedButton=function(t){var e=this.getSelectedButton(),i=this.getButtons();this.setAssociation("selectedButton",t);if(e!==this.getSelectedButton()){if(!this.getSelectedButton()&&i.length>1){this._selectDefaultButton()}this._focusSelectedButton()}this._syncSelect();return this};g.prototype.setSelectedItem=function(t){var e=typeof t==="string"&&t!==""?sap.ui.getCore().byId(t):t,i=e instanceof n,o=i?e.oButton:t;this.setAssociation("selectedItem",t,true);this.setSelectedButton(o);return this};g.prototype._focusSelectedButton=function(){var t=this.getButtons(),e=this.getSelectedButton(),i=0;for(;i<t.length;i++){if(t[i]&&t[i].getId()===e){this._oItemNavigation&&this._oItemNavigation.setFocusedIndex(i);break}}};g.prototype.onsappagedown=function(t){this._oItemNavigation.onsapend(t)};g.prototype.onsappageup=function(t){this._oItemNavigation.onsaphome(t)};g.prototype.onsapspace=function(t){t.preventDefault()};g.prototype._fnSelectFormFactory=function(){return new o(this.getId()+"-select").attachChange(this._selectChangeHandler,this).addStyleClass("sapMSegBSelectWrapper")};g.prototype._selectChangeHandler=function(t){var e=t.getParameter("selectedItem"),i=parseInt(e.getKey()),n=this.getButtons()[i],o=n.getId();n.firePress();this.setSelectedButton(o)};g.prototype._fireChangeEvent=function(){this.fireEvent("_change")};g.prototype._syncSelect=function(){var t=0,e=0,i,n,o=this.getAggregation("_select");if(!o){return}o.destroyItems();this._getVisibleButtons().forEach(function(s){i=s.getText();n=s.getIcon();o.addItem(new u({key:t.toString(),icon:n?n:"",text:i?i:s.getTooltip_AsString(),enabled:s.getEnabled()}));if(s.getId()===this.getSelectedButton()){e=t}t++},this);o.setSelectedKey(e.toString())};g.prototype.getAccessibilityInfo=function(){var e=t.getResourceBundleFor("sap.m"),i=this.getItems().find(function(t){return t.getId()===this.getSelectedItem()}.bind(this));return{role:"listbox",type:e.getText("SEGMENTEDBUTTON_NAME"),description:i.oButton.getAccessibilityInfo().description,focusable:this.getEnabled()}};g.prototype._toSelectMode=function(){this._bInOverflow=true;this.addStyleClass("sapMSegBSelectWrapper");if(!this.getAggregation("_select")){this.setAggregation("_select",this._fnSelectFormFactory(),true)}this._syncSelect();this._syncAriaAssociations()};g.prototype._toNormalMode=function(){delete this._bInOverflow;this.removeStyleClass("sapMSegBSelectWrapper")};g.prototype._syncAriaAssociations=function(){var t=this.getAggregation("_select");this.getAriaLabelledBy().forEach(function(e){if(t.getAriaLabelledBy().indexOf(e)===-1){t.addAriaLabelledBy(e)}});this.getAriaDescribedBy().forEach(function(e){if(t.getAriaLabelledBy().indexOf(e)===-1){t.addAriaLabelledBy(e)}})};g.prototype._overwriteImageOnload=function(t){var e=this;c=c||sap.ui.require("sap/m/Image");if(c&&t.onload===c.prototype.onload){t.onload=function(){if(c.prototype.onload){c.prototype.onload.apply(this,arguments)}setTimeout(function(){e._updateWidth()},20)}}};g.prototype._getIconAriaLabel=function(t){var e=h.getIconInfo(t.getSrc()),i="";if(e){i=e.text?e.text:e.name}return i};g.prototype._getVisibleButtons=function(){return this.getButtons().filter(function(t){return t.getVisible()})};g.prototype._getToolbarInteractive=function(){return true};g.prototype.clone=function(){var t=this.getSelectedButton(),e=this.removeAllAggregation("buttons"),i=s.prototype.clone.apply(this,arguments),n=e.map(function(t){return t.getId()}).indexOf(t),o;if(n>-1){i.setSelectedButton(i.getButtons()[n])}for(o=0;o<e.length;o++){this.addAggregation("buttons",e[o])}return i};return g});
//# sourceMappingURL=SegmentedButton.js.map