/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/Device","sap/ui/base/EventProvider","sap/ui/core/InvisibleText","sap/ui/core/ValueStateSupport","sap/m/library","sap/ui/core/library","sap/m/List","sap/m/inputUtils/scrollToItem","sap/m/inputUtils/SuggestionsPopoverDialogMixin","sap/m/inputUtils/SuggestionsPopoverPopoverMixin"],function(t,e,s,i,a,o,n,r,u,l){"use strict";var p=a.ListMode;var c=a.ListSeparators;var d="sapMSuggestionsPopover",f="sapUiNoContentPadding";var h=o.ValueState;var g=e.extend("sap.m.SuggestionsPopover",{constructor:function(){e.apply(this,arguments);this._sPopoverContentWidth=null;this._sOldValueState=h.None;this._sAreaDescribedById=null;if(t.system.phone){u.apply(g.prototype)}else{l.apply(g.prototype)}},destroy:function(){this._destroySuggestionPopup()}});g.M_EVENTS={SELECTION_CHANGE:"selectionChange"};g.prototype.isOpen=function(){var t=this.getPopover();return t&&t.isOpen()};g.prototype.setPopover=function(t){this._oPopover=t};g.prototype.getPopover=function(){return this._oPopover};g.prototype.destroyPopover=function(){if(this._oPopover){this._oPopover.destroy()}this._oPopover=null};g.prototype.setInputLabels=function(t){this._fnInputLabels=t};g.prototype.createSuggestionPopup=function(t,e,i){var a,o=this.getItemsContainer();e=e||[];a=this.createPopover(t,e,i);this.setPopover(a);a.addStyleClass(d);a.addStyleClass(f);a.addAriaLabelledBy(s.getStaticId("sap.m","INPUT_AVALIABLE_VALUES"));this._sAreaDescribedById=t.getValueStateLinksShortcutsId();if(t.getValueStateLinksForAcc().length>0){a.addAriaDescribedBy(this._sAreaDescribedById)}if(o){this.addContent(o)}this.setValueStateLinksDelegateInitialized(false)};g.prototype.initContent=function(t,e){var s=e,i=this.getPopover();if(!i){return}if(!s){s=new n(t+"-popup-list",{showNoData:false,mode:p.SingleSelectMaster,rememberSelections:false,width:"100%",showSeparators:c.None,busyIndicatorDelay:0});s.applyAriaRole("listbox")}this.addContent(s)};g.prototype._destroySuggestionPopup=function(){this.destroyPopover();this._oValueStateHeader=null};g.prototype.addContent=function(t){this.getPopover().addContent(t)};g.prototype.getItemsContainer=function(){var t=this.getPopover(),e=t&&t.getContent();return e&&e.filter(function(t){return t.isA("sap.m.List")&&t.getId().indexOf("-popup-list")>-1||t.isA("sap.m.Table")})[0]};g.prototype.handleListNavigation=function(e,s){var i=this.getPopover();if(s.isMarked()){return}if(!e.getEnabled()||!e.getEditable()){return}if(!i||!i.isOpen()){return}s.preventDefault();s.stopPropagation();var a=this.getItemsContainer(),o=e.hasStyleClass("sapMFocus"),n=a&&a.getItems().filter(function(t){return t.getVisible&&t.getVisible()}),u=n.indexOf(this.getFocusedListItem()),l;switch(s.type){case"sapdown":l=this.handleArrowDown(n,u,o);break;case"sapup":l=this.handleArrowUp(n,u,o);break;case"sapend":l=this.handleEnd(n);break;case"saphome":l=this.handleHome(n);break;case"sappagedown":l=this.handlePageDown(n,u);break;case"sappageup":l=this.handlePageUp(n,u);break}this.updateFocus(e,l);if(e.handleSelectionFromList){e.handleSelectionFromList(l)}else{this.handleSelectionFromList(l)}this.updateAriaActiveDescendant(e,l);if(t.system.desktop&&l){r(l,this.getPopover())}};g.prototype.handleArrowDown=function(t,e,s){if(s){return t[0]}if(!s){if(e===t.length-1){return t[e]}return t[e+1]}return t[0]};g.prototype.handleArrowUp=function(t,e,s){if(s){return}if(e>0){return t[e-1]}};g.prototype.handleEnd=function(t){return t.length&&t[t.length-1]};g.prototype.handleHome=function(t){return t.length&&t[0]};g.prototype.handlePageDown=function(t,e){return t[Math.min(t.length-1,e+10)]};g.prototype.handlePageUp=function(t,e){if(e-10>=0){return t[e-10]}return t[0]};g.prototype.updateFocus=function(t,e){var s=this.getItemsContainer(),i=this.getFocusedListItem(),a=t._hasTabularSuggestions?.()??false;s&&s.removeStyleClass("sapMListFocus");i&&i.removeStyleClass("sapMLIBFocused");t.hasStyleClass("sapMFocus")&&t.removeStyleClass("sapMFocus");if(e){!a&&e.addStyleClass("sapMLIBFocused");a&&s.setFakeFocus(e);s.addStyleClass("sapMListFocus");this.updateListDataAttributes(s)}else{t.addStyleClass("sapMFocus")}};g.prototype.updateListDataAttributes=function(t){if(!t){return}var e=t.getVisibleItems();if(!e){return}e.forEach(function(t){var e=t.getDomRef();if(e&&e.hasAttribute("data-sap-ui-first-suggestion-item")){e.removeAttribute("data-sap-ui-first-suggestion-item")}if(e&&e.hasAttribute("data-sap-ui-last-suggestion-item")){e.removeAttribute("data-sap-ui-last-suggestion-item")}});if(e[0]){var s=e[0].getDomRef();s&&s.setAttribute("data-sap-ui-first-suggestion-item","")}if(e[e.length-1]){var i=e[e.length-1].getDomRef();i&&i.setAttribute("data-sap-ui-last-suggestion-item","")}};g.prototype.handleSelectionFromList=function(t){var e=this.getItemsContainer(),s=this.getFocusedListItem(),i=t&&t.isA("sap.m.GroupHeaderListItem");if(!t||i){e.removeSelections(true)}else{e.setSelectedItem(t,true)}this.fireEvent(g.M_EVENTS.SELECTION_CHANGE,{previousItem:s,newItem:t})};g.prototype.updateAriaActiveDescendant=function(t,e){var s=t.getFocusDomRef();if(t.hasStyleClass("sapMFocus")){s.removeAttribute("aria-activedescendant");return}if(e){s.setAttribute("aria-activedescendant",e.getId());return}};g.prototype.getFocusedListItem=function(){var t=this.getItemsContainer(),e=t&&t.getItems()||[];for(var s=0;s<e.length;s++){if(e[s].hasStyleClass("sapMLIBFocused")){return e[s]}}};g.prototype.setValueStateActiveState=function(t){this.bMessageValueStateActive=t};g.prototype.getValueStateActiveState=function(){return this.bMessageValueStateActive};g.prototype.fnValueStateLinkDelegate=function(t,e,s){return{onsapup:function(e){t.getFocusDomRef().focus();this.handleListNavigation(t,e)},onsapdown:function(e){t.getFocusDomRef().focus();this.handleListNavigation(t,e)},onfocusout:function(t){if(!e.getDomRef().contains(t.relatedTarget)){s.forEach(function(t){t.getDomRef().setAttribute("tabindex","-1")})}this.setValueStateActiveState(false)},onfocusin:function(){s.forEach(function(t){t.getDomRef().setAttribute("tabindex","0")});this.setValueStateActiveState(true)}}};g.prototype.updateValueState=function(t,e,s,a=false){e=e||i.getAdditionalText(t);if(!this.getPopover()){return this}if(this.getInput()){this.getInput().setValueState(t)}var o=this._getValueStateHeader();o.setValueState(t);if(o&&typeof e==="string"){o.setText(e)}else if(o&&typeof e==="object"){o.setFormattedText(e)}const n=o!==null&&o.getFormattedText()!=null?o.getFormattedText().getControls():[];if(a){this.setValueStateLinksDelegateInitialized(false)}this.updateAriaDescribedBy(n);if(o){o.setValueState(s?t:h.None)}this._alignValueStateStyles(t);return this};g.prototype.updateAriaDescribedBy=function(t){if(!this.getPopover()){return}const e=this.getPopover();const s=e.getAriaDescribedBy();const i=t||[];if(s.some(t=>t===this._sAreaDescribedById)&&i.length===0){e.removeAssociation("ariaDescribedBy",this._sAreaDescribedById,true)}else if(!s.some(t=>t===this._sAreaDescribedById)&&i.length>0){e.addAssociation("ariaDescribedBy",this._sAreaDescribedById,true)}};g.prototype._handleValueStateLinkNav=function(t,e){if(!this.getValueStateActiveState()||this.getValueStateActiveState()&&document.activeElement.tagName==="A"||this.getValueStateLinks().length===0){return}var s=this.getValueStateLinks(),i=this._getValueStateHeader(),a=s[s.length-1],o=s[0];e.preventDefault();if(this.getFocusedListItem()){this.getFocusedListItem().removeStyleClass("sapMLIBFocused")}o.focus();if(!this.getValueStateLinksDelegateInitialized()){s.forEach(function(e){e.removeEventDelegate(this.fnValueStateLinkDelegate(t,i,s),this)},this);s.forEach(function(e){e.addEventDelegate(this.fnValueStateLinkDelegate(t,i,s),this)},this);a.addDelegate({onsaptabnext:function(e){this.setValueStateActiveState(false);t.onsapfocusleave(e);this.getPopover().close();setTimeout(function(){t.closeValueStateMessage()},0)}},this);o.addDelegate({onsaptabprevious:function(e){e.preventDefault();t.getFocusDomRef().focus();this.setValueStateActiveState(false);t.removeStyleClass("sapMFocus")}},this);this.setValueStateLinksDelegateInitialized(true)}};g.prototype.getValueStateLinks=function(){var t=this._getValueStateHeader(),e=t&&typeof t.getFormattedText==="function"&&t.getFormattedText(),s=e&&typeof e.getControls==="function"&&e.getControls();return s||[]};g.prototype.getValueStateLinksDelegateInitialized=function(){return this._bLinkDelegateInitialised};g.prototype.setValueStateLinksDelegateInitialized=function(t){this._bLinkDelegateInitialised=t};g.prototype._alignValueStateStyles=function(t){var e=d+"ValueState",s=d+this._sOldValueState+"State",i=d+t+"State",a=this.getPopover();a.addStyleClass(e);a.removeStyleClass(s);a.addStyleClass(i);this._sOldValueState=t};g.prototype.decorateParent=function(t){t.addEventDelegate({onsaptabnext:this._handleValueStateLinkNav.bind(this,t),onsaptabprevious:this._handleValueStateLinkNav.bind(this,t)},this)};g.prototype.getInput=function(){return null};g.prototype.getPickerTitle=function(){return null};g.prototype.getOkButton=function(){return null};g.prototype.getCancelButton=function(){return null};g.prototype.getFilterSelectedButton=function(){return null};g.prototype.setOkPressHandler=function(){return null};g.prototype.setCancelPressHandler=function(){return null};g.prototype.setShowSelectedPressHandler=function(){return null};g.prototype.resizePopup=function(){};g.prototype._getValueStateHeader=function(){return null};g.prototype._createValueStateHeader=function(){return null};return g});
//# sourceMappingURL=SuggestionsPopover.js.map