/*
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","./TablePersoDialog","sap/ui/base/ManagedObject","sap/ui/base/ManagedObjectRegistry","sap/ui/core/syncStyleClass","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/core/Configuration"],function(e,t,i,o,a,s,jQuery,r){"use strict";var n=e.ResetAllMode;var l=i.extend("sap.m.TablePersoController",{constructor:function(e,t){i.apply(this,arguments)},metadata:{deprecated:true,properties:{contentWidth:{type:"sap.ui.core.CSSSize"},contentHeight:{type:"sap.ui.core.CSSSize",since:"1.22"},componentName:{type:"string",since:"1.20.2"},hasGrouping:{type:"boolean",defaultValue:false,since:"1.22"},showSelectAll:{type:"boolean",defaultValue:true,since:"1.22"},showResetAll:{type:"boolean",defaultValue:true,since:"1.22"},resetAllMode:{type:"sap.m.ResetAllMode",defaultValue:n.Default,since:"1.88"}},aggregations:{_tablePersoDialog:{type:"sap.m.TablePersoDialog",multiple:false,visibility:"hidden"},persoService:{type:"Object",multiple:false}},associations:{table:{type:"sap.m.Table",multiple:false},tables:{type:"sap.m.Table",multiple:true}},events:{personalizationsDone:{}},library:"sap.m"}});o.apply(l,{onDuplicate:function(e,t,i){if(t._sapui_candidateForDestroy){s.debug("destroying dangling template "+t+" when creating new object with same ID");t.destroy()}else{var o="adding TablePersoController with duplicate id '"+e+"'";if(r.getNoDuplicateIds()){s.error(o);throw new Error("Error: "+o)}else{s.warning(o)}}}});l.prototype.init=function(){this._schemaProperty="_persoSchemaVersion";this._schemaVersion="1.0";this._oPersonalizations=null;this._mDelegateMap={};this._mTablePersMap={};this._mInitialTableStateMap={};this._triggersPersDoneEvent=true};l.prototype.setResetAllMode=function(e){if(!this._resetAllModeSet){this.setProperty("resetAllMode",e);this._resetAllModeSet=true}else{s.warning("resetAllMode of the TablePersoController can only be set once.")}};l.prototype.exit=function(){this._callFunctionForAllTables(jQuery.proxy(function(e){e.removeDelegate(this._mDelegateMap[e]);e._hasTablePersoController=function(){return false}},this));delete this._mDelegateMap;delete this._mTablePersMap;delete this._mInitialTableStateMap};l.prototype.activate=function(){if(this.getResetAllMode()===n.Default){this._callFunctionForAllTables(this._rememberInitialTableStates)}this._callFunctionForAllTables(this._createAndAddDelegateForTable);return this};l.prototype.getTablePersoDialog=function(){return this.getAggregation("_tablePersoDialog")};l.prototype.applyPersonalizations=function(e){var t=this.getPersoService().getPersData();var i=this;t.done(function(t){if(t){i._adjustTable(t,e)}});t.fail(function(){s.error("Problem reading persisted personalization data.")});if(this.getResetAllMode()===n.ServiceDefault){this._callFunctionForAllTables(this._rememberInitialTableStates)}};l.prototype._createAndAddDelegateForTable=function(e){if(!this._mDelegateMap[e]){var t={onBeforeRendering:function(){this.applyPersonalizations(e);if(!this.getAggregation("_tablePersoDialog")){this._createTablePersoDialog(e)}}.bind(this)};e.addDelegate(t);t.onBeforeRendering();this._mDelegateMap[e]=t;var i=this;e._hasTablePersoController=function(){return!!i._mDelegateMap[this]}}};l.prototype._createTablePersoDialog=function(e){var i=new t(e.getId()+"-PersoDialog",{persoDialogFor:e,persoMap:this._getPersoColumnMap(e),columnInfoCallback:this._tableColumnInfo.bind(this),initialColumnState:this._mInitialTableStateMap[e],contentWidth:this.getContentWidth(),contentHeight:this.getContentHeight(),hasGrouping:this.getHasGrouping(),showSelectAll:this.getShowSelectAll(),showResetAll:this.getShowResetAll()});if(this.getResetAllMode()===n.ServiceReset&&this.getPersoService().getResetPersData){i.setShowResetAll(false);this.getPersoService().getResetPersData().done(function(e){if(this._bIsBeingDestroyed){return}if(e){var t=e.aColumns;t.forEach(function(e){var t=null;if(this.getPersoService().getGroup){var o=sap.ui.getCore().byId(i.getPersoDialogFor());var a=this._mTablePersMap[o][e.id];t=this.getPersoService().getGroup(a);e.group=t}}.bind(this));i.setInitialColumnState(e.aColumns);i.setShowResetAll(this.getShowResetAll())}}.bind(this))}this.setAggregation("_tablePersoDialog",i);i.attachConfirm(jQuery.proxy(function(){this._oPersonalizations=i.retrievePersonalizations();this._callFunctionForAllTables(this._personalizeTable);this.savePersonalizations();this.firePersonalizationsDone()},this))};l.prototype._adjustTable=function(e,t){if(e&&e.hasOwnProperty(this._schemaProperty)&&e[this._schemaProperty]===this._schemaVersion){this._oPersonalizations=e;if(t){this._personalizeTable(t)}else{this._callFunctionForAllTables(this._personalizeTable)}}};l.prototype._personalizeTable=function(e){var t=this._getPersoColumnMap(e);if(t&&this._oPersonalizations){var i=false;for(var o=0,a=this._oPersonalizations.aColumns.length;o<a;o++){var r=this._oPersonalizations.aColumns[o];var n=t[r.id];if(!n){n=sap.ui.getCore().byId(r.id);if(n){s.info("Migrating personalization persistence id of column "+r.id);r.id=t[n];i=true}}if(n){n.setVisible(r.visible);n.setOrder(r.order)}else{s.warning("Personalization could not be applied to column "+r.id+" - not found!")}}if(i){this.savePersonalizations()}e.invalidate()}};l.prototype.savePersonalizations=function(){var e=this._oPersonalizations;e[this._schemaProperty]=this._schemaVersion;var t=this.getPersoService().setPersData(e);t.done(function(){});t.fail(function(){s.error("Problem persisting personalization data.")})};l.prototype.refresh=function(){var e=function(e){this._mTablePersMap={};e.invalidate()};this._callFunctionForAllTables(e);var t=this.getAggregation("_tablePersoDialog");if(t){t.setPersoMap(this._getPersoColumnMap(sap.ui.getCore().byId(t.getPersoDialogFor())))}};l.prototype.openDialog=function(){var e=this.getAggregation("_tablePersoDialog");if(e){a("sapUiSizeCompact",e.getPersoDialogFor(),e._oDialog);e.open()}else{s.warning("sap.m.TablePersoController: trying to open TablePersoDialog before TablePersoService has been activated.")}};l.prototype.setContentWidth=function(e){this.setProperty("contentWidth",e,true);var t=this.getAggregation("_tablePersoDialog");if(t){t.setContentWidth(e)}return this};l.prototype.setContentHeight=function(e){this.setProperty("contentHeight",e,true);var t=this.getAggregation("_tablePersoDialog");if(t){t.setContentHeight(e)}return this};l.prototype.setHasGrouping=function(e){this.setProperty("hasGrouping",e,true);var t=this.getAggregation("_tablePersoDialog");if(t){t.setHasGrouping(e)}return this};l.prototype.setShowSelectAll=function(e){this.setProperty("showSelectAll",e,true);var t=this.getAggregation("_tablePersoDialog");if(t){t.setShowSelectAll(e)}return this};l.prototype.setShowResetAll=function(e){this.setProperty("showResetAll",e,true);var t=this.getAggregation("_tablePersoDialog");if(t){t.setShowResetAll(e)}return this};l.prototype.setComponentName=function(e){this.setProperty("componentName",e,true);return this};l.prototype._getMyComponentName=function(e){if(this.getComponentName()){return this.getComponentName()}if(e===null){return"empty_component"}var t=e.getMetadata();if(e.getMetadata().getStereotype()==="component"){return t._sComponentName}return this._getMyComponentName(e.getParent())};l.prototype._callFunctionForAllTables=function(e){var t=sap.ui.getCore().byId(this.getAssociation("table"));if(t){e.call(this,t)}var i=this.getAssociation("tables");if(i){for(var o=0,a=this.getAssociation("tables").length;o<a;o++){t=sap.ui.getCore().byId(this.getAssociation("tables")[o]);e.call(this,t)}}};l.prototype._isStatic=function(e){var t=r.getUIDPrefix();var i=new RegExp("^"+t);return!i.test(e)};l.prototype._getPersoColumnMap=function(e){var t=this._mTablePersMap[e];if(!t){t={};var i=function(e){var t=e.lastIndexOf("-");return e.substring(t+1)};var o=i.call(this,e.getId());if(!this._isStatic(o)){s.error("Table "+e.getId()+" must have a static id suffix. Otherwise personalization can not be persisted.");t=null;return null}var a;var r=this._getMyComponentName(e);var n=this;e.getColumns().forEach(function(e){if(t){var l=e.getId();var p=i.call(n,l);if(!n._isStatic(p)){s.error("Suffix "+p+" of table column "+l+" must be static. Otherwise personalization can not be persisted for its table.");t=null;return null}a=r+"-"+o+"-"+p;t[e]=a;t[a]=e}});this._mTablePersMap[e]=t}return t};l.prototype._rememberInitialTableStates=function(e){this._mInitialTableStateMap[e]=this._tableColumnInfo(e,this._getPersoColumnMap(e))};l.prototype._tableColumnInfo=function(e,t){if(t){var i=e.getColumns(),o=[],a=this.getPersoService();i.forEach(function(e){var i=null;if(a.getCaption){i=a.getCaption(e)}var r=null;if(a.getGroup){r=a.getGroup(e)}if(!i){var n=e.getHeader();if(n.getText&&n.getText()){i=n.getText()}else if(n.getTitle&&n.getTitle()){i=n.getTitle()}if(!i){i=e.getId();s.warning("Please 'getCaption' callback implentation in your TablePersoProvider for column "+e+". Table personalization uses column id as fallback value.")}}o.push({text:i,order:e.getOrder(),visible:e.getVisible(),id:t[e],group:r})});o.sort(function(e,t){return e.order-t.order});return o}return null};return l});
//# sourceMappingURL=TablePersoController.js.map