/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Control","./library","sap/ui/core/library","./TitleRenderer","sap/m/HyphenationSupport"],function(t,e,i,o,a){"use strict";var r=i.TextDirection;var n=i.TextAlign;var l=i.TitleLevel;var p=e.WrappingType;var s=t.extend("sap.m.Title",{metadata:{library:"sap.m",interfaces:["sap.ui.core.IShrinkable","sap.m.IHyphenation","sap.m.IToolbarInteractiveControl"],properties:{text:{type:"string",group:"Appearance",defaultValue:null},level:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:l.Auto},titleStyle:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:l.Auto},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:n.Initial},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:r.Inherit},wrapping:{type:"boolean",group:"Appearance",defaultValue:false},wrappingType:{type:"sap.m.WrappingType",group:"Appearance",defaultValue:p.Normal}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.ITitleContent",multiple:false}},associations:{title:{type:"sap.ui.core.Title",multiple:false}},designtime:"sap/m/designtime/Title.designtime"},renderer:o});s.prototype._getTitle=function(){var t=this.getTitle();if(t){var e=sap.ui.getCore().byId(t);if(e&&e.isA("sap.ui.core.Title")){return e}}return null};s.prototype._onTitleChanged=function(){this.invalidate()};s.prototype.setTitle=function(t){var e=this;var i=this._getTitle();if(i){i.invalidate=i.__sapui5_title_originvalidate;i.exit=i.__sapui5_title_origexit;delete i.__sapui5_title_origexit;delete i.__sapui5_title_originvalidate}this.setAssociation("title",t);var o=this._getTitle();if(o){o.__sapui5_title_originvalidate=o.invalidate;o.__sapui5_title_origexit=o.exit;o.exit=function(){e._onTitleChanged();if(this.__sapui5_title_origexit){this.__sapui5_title_origexit.apply(this,arguments)}};o.invalidate=function(){e._onTitleChanged();this.__sapui5_title_originvalidate.apply(this,arguments)}}return this};s.prototype.getAccessibilityInfo=function(){var t=this._getTitle()||this;return{role:"heading",description:t.getText(),focusable:false}};s.prototype.getTextsToBeHyphenated=function(){var t=this._getTitle();return{main:t?t.getText():this.getText()}};s.prototype.getDomRefsForHyphenatedTexts=function(){var t;if(!this._getTitle()){t={main:this.getDomRef("inner")}}return t};s.prototype._getAriaLevel=function(){var t=2,e=1;if(this.getTitleStyle()!==l.Auto){t=parseInt(this.getTitleStyle()[e])}return t};s.prototype._getToolbarInteractive=function(){return false};s.prototype._getTooltipText=function(){const t=this._getTitle();return t&&!this.getContent()?t.getTooltip_AsString():this.getTooltip_AsString()};s.prototype.onmouseover=function(t){const e=this.getDomRef();if(!e||e.offsetWidth>=e.scrollWidth){return}const i=this._getTooltipText();let o=this.getText();if(i){o+=" - "+i}e.setAttribute("title",o)};s.prototype.onmouseout=function(t){const e=this.getDomRef();const i=this._getTooltipText();if(!e){return}if(i){e.setAttribute("title",i)}else{e.removeAttribute("title")}};a.mixInto(s.prototype);return s});
//# sourceMappingURL=Title.js.map