/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/m/library","sap/m/MessageBox","sap/m/Dialog","sap/ui/core/Control","sap/ui/core/Icon","sap/ui/core/IconPool","sap/m/Image","sap/m/Text","sap/m/Title","sap/m/Button","sap/m/List","sap/m/BusyIndicator","sap/m/StandardListItem","sap/ui/unified/FileUploaderParameter","sap/ui/unified/FileUploader","sap/ui/core/format/FileSizeFormat","sap/m/OverflowToolbar","sap/m/ToolbarSpacer","sap/m/ObjectAttribute","sap/m/UploadCollectionItem","sap/m/UploadCollectionParameter","sap/m/UploadCollectionToolbarPlaceholder","sap/ui/core/HTML","sap/ui/core/InvisibleText","sap/m/CustomListItem","sap/ui/core/ResizeHandler","sap/ui/Device","./UploadCollectionRenderer","sap/ui/thirdparty/jquery","sap/ui/events/KeyCodes","sap/base/Log","sap/ui/core/Configuration","sap/ui/dom/jquery/selectText"],function(e,t,i,a,r,s,o,n,l,d,p,h,g,u,m,f,_,c,I,U,y,D,F,v,b,C,T,L,P,jQuery,E,A,N){"use strict";var S=r.extend("sap.m.UploadCollection",{constructor:function(t,i){var a;if(i&&i.instantUpload!==undefined){if(i.instantUpload===false){a=i.instantUpload}delete i.instantUpload}else if(t&&t.instantUpload!==undefined){if(t.instantUpload===false){a=t.instantUpload}delete t.instantUpload}if(i&&i.mode===e.ListMode.MultiSelect&&a===false){i.mode=e.ListMode.None;A.info("sap.m.ListMode.MultiSelect is not supported by UploadCollection for Upload Pending scenario. Value has been resetted to 'None'")}else if(t&&t.mode===e.ListMode.MultiSelect&&a===false){t.mode=e.ListMode.None;A.info("sap.m.ListMode.MultiSelect is not supported by UploadCollection for Upload Pending scenario. Value has been resetted to 'None'")}try{r.apply(this,arguments);if(a===false){this.bInstantUpload=a;this._oFormatDecimal=_.getInstance({binaryFilesize:false,maxFractionDigits:1,maxIntegerDigits:4})}}catch(e){this.destroy();throw e}},metadata:{library:"sap.m",properties:{fileType:{type:"string[]",group:"Data",defaultValue:null},maximumFilenameLength:{type:"int",group:"Data",defaultValue:null},maximumFileSize:{type:"float",group:"Data",defaultValue:null},mimeType:{type:"string[]",group:"Data",defaultValue:null},multiple:{type:"boolean",group:"Behavior",defaultValue:false},noDataText:{type:"string",group:"Appearance",defaultValue:null},noDataDescription:{type:"string",group:"Appearance",defaultValue:null},sameFilenameAllowed:{type:"boolean",group:"Behavior",defaultValue:false},showSeparators:{type:"sap.m.ListSeparators",group:"Appearance",defaultValue:"All"},uploadEnabled:{type:"boolean",group:"Behavior",defaultValue:true},uploadUrl:{type:"string",group:"Data",defaultValue:"../../../upload"},instantUpload:{type:"boolean",group:"Behavior",defaultValue:true},numberOfAttachmentsText:{type:"string",group:"Appearance",defaultValue:null},mode:{type:"sap.m.ListMode",group:"Behavior",defaultValue:"None"},uploadButtonInvisible:{type:"boolean",group:"Appearance",defaultValue:false},terminationEnabled:{type:"boolean",group:"Behavior",defaultValue:true}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.UploadCollectionItem",multiple:true,singularName:"item",bindable:"bindable"},headerParameters:{type:"sap.m.UploadCollectionParameter",multiple:true,singularName:"headerParameter"},parameters:{type:"sap.m.UploadCollectionParameter",multiple:true,singularName:"parameter"},toolbar:{type:"sap.m.OverflowToolbar",multiple:false},infoToolbar:{type:"sap.m.Toolbar",multiple:false,forwarding:{idSuffix:"-list",aggregation:"infoToolbar"}},_list:{type:"sap.m.List",multiple:false,visibility:"hidden"},_noDataIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_dragDropIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_dragDropText:{type:"sap.m.Text",multiple:false,visibility:"hidden"}},events:{change:{parameters:{documentId:{type:"string"},files:{type:"object[]"}}},fileDeleted:{parameters:{documentId:{type:"string"},item:{type:"sap.m.UploadCollectionItem"}}},filenameLengthExceed:{parameters:{documentId:{type:"string"},files:{type:"object[]"}}},fileRenamed:{parameters:{documentId:{type:"string"},fileName:{type:"string"},item:{type:"sap.m.UploadCollectionItem"}}},fileSizeExceed:{parameters:{documentId:{type:"string"},fileSize:{type:"string"},files:{type:"object[]"}}},typeMissmatch:{parameters:{documentId:{type:"string"},fileType:{type:"string"},mimeType:{type:"string"},files:{type:"object[]"}}},uploadComplete:{parameters:{readyStateXHR:{type:"string"},response:{type:"string"},status:{type:"string"},files:{type:"object[]"}}},uploadTerminated:{parameters:{fileName:{type:"string"},getHeaderParameter:{type:"function"}}},beforeUploadStarts:{parameters:{fileName:{type:"string"},addHeaderParameter:{type:"function"},getHeaderParameter:{type:"function"}}},selectionChange:{parameters:{selectedItem:{type:"sap.m.UploadCollectionItem"},selectedItems:{type:"sap.m.UploadCollectionItem[]"},selected:{type:"boolean"}}}}},renderer:P});S._uploadingStatus="uploading";S._displayStatus="display";S._toBeDeletedStatus="toBeDeleted";S._pendingUploadStatus="pendingUploadStatus";S._placeholderCamera="sap-icon://card";S._markerMargin=8;if(L.system.phone){S._resizeTimeoutInterval=500}else{S._resizeTimeoutInterval=100}S.prototype.init=function(){S.prototype._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._headerParamConst={requestIdName:"requestId"+jQuery.now(),fileNameRequestIdName:"fileNameRequestId"+jQuery.now(),acceptLanguage:"accept-language"};this._requestIdValue=0;this._iFUCounter=0;var e=this.getNoDataText()+" "+this.getNoDataDescription();this._oList=new h(this.getId()+"-list",{selectionChange:[this._handleSelectionChange,this],noDataText:e});this.setAggregation("_list",this._oList,true);this._oList.addStyleClass("sapMUCList");this.setAggregation("_noDataIcon",new s(this.getId()+"-no-data-icon",{src:"sap-icon://document",size:"6rem",noTabStop:true}),true);this.setAggregation("_dragDropIcon",new s(this.getId()+"-drag-drop-icon",{src:"sap-icon://upload-to-cloud",size:"4rem",noTabStop:true}),true);this.setAggregation("_dragDropText",new l(this.getId()+"-drag-drop-text",{text:this._oRb.getText("UPLOADCOLLECTION_DRAG_FILE_INDICATOR")}),true);this._iUploadStartCallCounter=0;this.aItems=[];this._aDeletedItemForPendingUpload=[];this._aFileUploadersForPendingUpload=[];this._aFilesFromDragAndDropForPendingUpload=[];this._iFileUploaderPH=null;this._oListEventDelegate=null;this._oItemToUpdate=null;this._sReziseHandlerId=null;this.oInvisibleText=(new b).toStatic()};S.prototype.setFileType=function(e){if(!e){return this}if(!this.getInstantUpload()){A.info("As property instantUpload is false it is not allowed to change fileType at runtime.")}else{var t=e.length;for(var i=0;i<t;i++){e[i]=e[i].toLowerCase()}if(this.getFileType()!==e){this.setProperty("fileType",e,true);this._getFileUploader().setFileType(e)}}return this};S.prototype.setMaximumFilenameLength=function(e){if(!this.getInstantUpload()){A.info("As property instantUpload is false it is not allowed to change maximumFilenameLength at runtime.")}else if(this.getMaximumFilenameLength()!==e){this.setProperty("maximumFilenameLength",e,true);this._getFileUploader().setMaximumFilenameLength(e)}return this};S.prototype.setMaximumFileSize=function(e){if(!this.getInstantUpload()){A.info("As property instantUpload is false it is not allowed to change maximumFileSize at runtime.")}else if(this.getMaximumFileSize()!==e){this.setProperty("maximumFileSize",e,true);this._getFileUploader().setMaximumFileSize(e)}return this};S.prototype.setMimeType=function(e){if(!this.getInstantUpload()){A.info("As property instantUpload is false it is not allowed to change mimeType at runtime.")}else if(this.getMimeType()!==e){this.setProperty("mimeType",e,true);this._getFileUploader().setMimeType(e)}return this};S.prototype.setMultiple=function(e){if(!this.getInstantUpload()){A.info("As property instantUpload is false it is not allowed to change multiple at runtime.")}else if(this.getMultiple()!==e){this.setProperty("multiple",e);this._getFileUploader().setMultiple(e)}return this};S.prototype.setShowSeparators=function(e){if(this.getShowSeparators()!==e){this.setProperty("showSeparators",e);this._oList.setShowSeparators(e)}return this};S.prototype.setUploadEnabled=function(e){if(!this.getInstantUpload()){A.info("As property instantUpload is false it is not allowed to change uploadEnabled at runtime.")}else if(this.getUploadEnabled()!==e){this.setProperty("uploadEnabled",e);this._getFileUploader().setEnabled(e)}return this};S.prototype.setUploadUrl=function(e){if(!this.getInstantUpload()){A.info("As property instantUpload is false it is not allowed to change uploadUrl at runtime.")}else if(this.getUploadUrl()!==e){this.setProperty("uploadUrl",e);this._getFileUploader().setUploadUrl(e)}return this};S.prototype.setInstantUpload=function(){A.error("It is not supported to change the behavior at runtime.");return this};S.prototype.setMode=function(t){if(t===e.ListMode.Delete){this._oList.setMode(e.ListMode.None);A.info("sap.m.ListMode.Delete is not supported by UploadCollection. Value has been resetted to 'None'")}else if(t===e.ListMode.MultiSelect&&!this.getInstantUpload()){this._oList.setMode(e.ListMode.None);A.info("sap.m.ListMode.MultiSelect is not supported by UploadCollection for Pending Upload. Value has been resetted to 'None'")}else{this._oList.setMode(t)}return this};S.prototype.getMode=function(){return this._oList.getMode()};S.prototype.getToolbar=function(){return this._oHeaderToolbar};S.prototype.getNoDataText=function(){var e=this.getProperty("noDataText");e=e||this._oRb.getText("UPLOADCOLLECTION_NO_DATA_TEXT");return e};S.prototype.getNoDataDescription=function(){var e=this.getProperty("noDataDescription");e=e||this._oRb.getText("UPLOADCOLLECTION_NO_DATA_DESCRIPTION");return e};S.prototype.setNoDataText=function(e){this.setProperty("noDataText",e,true);this.$().find("#"+this.getId()+"-no-data-text").text(e);var t=e+" "+this.getNoDataDescription();this._oList.setNoDataText(t);return this};S.prototype.setNoDataDescription=function(e){this.setProperty("noDataDescription",e,true);var t=this.getNoDataText()+" "+e;this._oList.setNoDataText(t);if(this.getUploadEnabled()&&this._oList.getItems().length==0){this.rerender()}return this};S.prototype.setUploadButtonInvisible=function(e){if(this.getUploadButtonInvisible()===e){return this}this.setProperty("uploadButtonInvisible",e,true);if(this.getInstantUpload()){this._getFileUploader().setVisible(!e)}else{this._setFileUploaderVisibility(e)}if(this._bDragDropEnabled){this._unbindDragEnterLeave();this._bDragDropEnabled=false}else{this._bindDragEnterLeave()}return this};S.prototype.getInternalRequestHeaderNames=function(){return[this._headerParamConst.fileNameRequestIdName,this._headerParamConst.requestIdName]};S.prototype.upload=function(){if(this.getInstantUpload()){A.error("Not a valid API call. 'instantUpload' should be set to 'false'.")}var e=this._aFileUploadersForPendingUpload.length;for(var t=0;t<e;t++){this._iUploadStartCallCounter=0;if(this._aFileUploadersForPendingUpload[t].getValue()){this._aFileUploadersForPendingUpload[t].upload()}}if(this._aFilesFromDragAndDropForPendingUpload.length>0){this._oFileUploader._sendFilesFromDragAndDrop(this._aFilesFromDragAndDropForPendingUpload);this._aFilesFromDragAndDropForPendingUpload=[]}};S.prototype.getSelectedItems=function(){var e=this._oList.getSelectedItems();return this._getUploadCollectionItemsByListItems(e)};S.prototype.getSelectedItem=function(){var e=this._oList.getSelectedItem();if(e){return this._getUploadCollectionItemByListItem(e)}return null};S.prototype.setSelectedItemById=function(e,t){this._oList.setSelectedItemById(e+"-cli",t);this._setSelectedForItems([this._getUploadCollectionItemById(e)],t);return this};S.prototype.setSelectedItem=function(e,t){return this.setSelectedItemById(e.getId(),t)};S.prototype.selectAll=function(){var e=this._oList.selectAll();if(e.getItems().length!==this.getItems().length){A.info("Internal 'List' and external 'UploadCollection' are not in sync.")}this._setSelectedForItems(this.getItems(),true);return this};S.prototype.downloadItem=function(e,t){if(!this.getInstantUpload()){A.info("Download is not possible on Pending Upload mode");return false}else{return e.download(t)}};S.prototype.openFileDialog=function(e){if(this._oFileUploader){if(e){if(!this._oFileUploader.getMultiple()){this._oItemToUpdate=e;this._oFileUploader.$().find("input[type=file]").trigger("click")}else{A.warning("Version Upload cannot be used in multiple upload mode")}}else{this._oFileUploader.$().find("input[type=file]").trigger("click")}}return this};S.prototype.removeAggregation=function(e,t,i){var a,s,o;if(!this.getInstantUpload()&&e==="items"&&t){a=t._internalFileIdWithinDragDropArray;if(a){s=this._aFilesFromDragAndDropForPendingUpload.indexOf(a);if(s!==-1){this._aFilesFromDragAndDropForPendingUpload.splice(s,1)}}else if(typeof t==="number"){o=this.getItems();this._aDeletedItemForPendingUpload.push(o[t])}else{this._aDeletedItemForPendingUpload.push(t)}}return r.prototype.removeAggregation.apply(this,arguments)};S.prototype.removeAllAggregation=function(e,t){if(!this.getInstantUpload()&&e==="items"){if(this._aFileUploadersForPendingUpload){for(var i=0;i<this._aFileUploadersForPendingUpload.length;i++){this._aFileUploadersForPendingUpload[i].destroy();this._aFileUploadersForPendingUpload[i]=null}this._aFileUploadersForPendingUpload=[]}}return r.prototype.removeAllAggregation.apply(this,arguments)};S.prototype.onBeforeRendering=function(){this._RenderManager=this._RenderManager||sap.ui.getCore().createRenderManager();var e,t;if(this._oListEventDelegate){this._oList.removeEventDelegate(this._oListEventDelegate);this._oListEventDelegate=null}this._deregisterSizeHandler();this._unbindDragEnterLeave();a.bind(this)();if(!this.getInstantUpload()){this.aItems=this.getItems();this._getListHeader(this.aItems.length);this._clearList();this._fillList(this.aItems);this._oList.setHeaderToolbar(this._oHeaderToolbar);return}if(this.aItems.length>0){t=this.aItems.length;var i=[];for(e=0;e<t;e++){if(this.aItems[e]&&this.aItems[e]._status===S._uploadingStatus){i.push(this.aItems[e])}else if(this.aItems[e]&&this.aItems[e]._status!==S._uploadingStatus&&this.aItems[e]._percentUploaded===100&&this.getItems().length===0){i.push(this.aItems[e])}}if(i.length!==0){this.aItems=[];this.aItems=this.getItems();this.aItems=i.concat(this.aItems)}else{this.aItems=this.getItems()}}else{this.aItems=this.getItems()}this._getListHeader(this.aItems.length);this._clearList();this._fillList(this.aItems);this._oList.setAggregation("headerToolbar",this._oHeaderToolbar,true);if(this.sErrorState!=="Error"){if(this.getUploadEnabled()!==this._oFileUploader.getEnabled()){this._oFileUploader.setEnabled(this.getUploadEnabled())}}else{this._oFileUploader.setEnabled(false)}if(this.sDeletedItemId){jQuery(document.activeElement).trigger("blur")}function a(){if(this.bInstantUpload===false){this.setProperty("instantUpload",this.bInstantUpload,true);delete this.bInstantUpload}}};S.prototype.onAfterRendering=function(){this._bindDragEnterLeave();if(this.getInstantUpload()){if(this.aItems||this.aItems===this.getItems()){if(this.editModeItem){var e=jQuery(document.getElementById(this.editModeItem+"-ta_editFileName-inner"));if(e){var t=this.editModeItem;if(!L.os.ios){e.on("focus",function(){e.selectText(0,e.val().length)})}e.trigger("focus");this.oInvisibleText.setText("");sap.ui.getCore().byId(this.editModeItem+"-cli").removeAllAriaLabelledBy();sap.ui.getCore().byId(this.editModeItem+"-cli").addAriaLabelledBy(this.oInvisibleText.getId());this._oListEventDelegate={onclick:function(e){this._handleClick(e,t)}.bind(this)};this._oList.addDelegate(this._oListEventDelegate)}}else if(this.sFocusId){this._setFocusToLineItem(this.sFocusId);this.sFocusId=null}else if(this.sDeletedItemId){this._setFocusAfterDeletion()}}}else if(this.sFocusId){this._setFocusToLineItem(this.sFocusId);this.sFocusId=null}};S.prototype.exit=function(){var e,t,i;this._unbindDragEnterLeave();if(this._$RootNode){this._$RootNode=null}if(this._oFileUploader){this._oFileUploader.destroy();this._oFileUploader=null}if(this._oHeaderToolbar){this._oHeaderToolbar.destroy();this._oHeaderToolbar=null}if(this._oNumberOfAttachmentsTitle){this._oNumberOfAttachmentsTitle.destroy();this._oNumberOfAttachmentsTitle=null}if(this._RenderManager){this._RenderManager.destroy()}if(this._aFileUploadersForPendingUpload){t=this._aFileUploadersForPendingUpload.length;for(e=0;e<t;e++){this._aFileUploadersForPendingUpload[e].destroy();this._aFileUploadersForPendingUpload[e]=null}this._aFileUploadersForPendingUpload=null}if(this.aItems&&this.aItems.length>0){for(e=0;e<this.aItems.length;e++){if(this.aItems[e]._status===S._uploadingStatus){i=this.aItems.splice(e,1)[0];if(i.destroy){i.destroy()}}}}this._deregisterSizeHandler();if(this.oInvisibleText){this.oInvisibleText.destroy()}};S.prototype._bindDragEnterLeave=function(){this._bDragDropEnabled=this._isDragAndDropAllowed();if(!this._bDragDropEnabled){return}if(!this._oDragDropHandler){this._oDragDropHandler={dragEnterUIArea:this._onDragEnterUIArea.bind(this),dragLeaveUIArea:this._onDragLeaveUIArea.bind(this),dragOverUIArea:this._onDragOverUIArea.bind(this),dropOnUIArea:this._onDropOnUIArea.bind(this),dragEnterUploadCollection:this._onDragEnterUploadCollection.bind(this),dragLeaveUploadCollection:this._onDragLeaveUploadCollection.bind(this),dragOverUploadCollection:this._onDragOverUploadCollection.bind(this),dropOnUploadCollection:this._onDropOnUploadCollection.bind(this)}}this._$RootNode=jQuery(document.body);this._$RootNode.on("dragenter",this._oDragDropHandler.dragEnterUIArea);this._$RootNode.on("dragleave",this._oDragDropHandler.dragLeaveUIArea);this._$RootNode.on("dragover",this._oDragDropHandler.dragOverUIArea);this._$RootNode.on("drop",this._oDragDropHandler.dropOnUIArea);this._$DragDropArea=this.$("drag-drop-area");this.$().on("dragenter",this._oDragDropHandler.dragEnterUploadCollection);this.$().on("dragleave",this._oDragDropHandler.dragLeaveUploadCollection);this.$().on("dragover",this._oDragDropHandler.dragOverUploadCollection);this.$().on("drop",this._oDragDropHandler.dropOnUploadCollection)};S.prototype._unbindDragEnterLeave=function(){if(!this._bDragDropEnabled&&!this._oDragDropHandler){return}if(this._$RootNode){this._$RootNode.off("dragenter",this._oDragDropHandler.dragEnterUIArea);this._$RootNode.off("dragleave",this._oDragDropHandler.dragLeaveUIArea);this._$RootNode.off("dragover",this._oDragDropHandler.dragOverUIArea);this._$RootNode.off("drop",this._oDragDropHandler.dropOnUIArea)}this.$().off("dragenter",this._oDragDropHandler.dragEnterUploadCollection);this.$().off("dragleave",this._oDragDropHandler.dragLeaveUploadCollection);this.$().off("dragover",this._oDragDropHandler.dragOverUploadCollection);this.$().off("drop",this._oDragDropHandler.dropOnUploadCollection)};S.prototype._onDragEnterUIArea=function(e){if(!this._checkForFiles(e)){return}this._oLastEnterUIArea=e.target;this._$DragDropArea.removeClass("sapMUCDragDropOverlayHide");this._adjustDragDropIcon()};S.prototype._onDragOverUIArea=function(e){e.preventDefault();if(!this._checkForFiles(e)){return}this._$DragDropArea.removeClass("sapMUCDragDropOverlayHide")};S.prototype._onDragLeaveUIArea=function(e){if(this._oLastEnterUIArea===e.target){this._$DragDropArea.addClass("sapMUCDragDropOverlayHide")}};S.prototype._onDropOnUIArea=function(e){this._$DragDropArea.addClass("sapMUCDragDropOverlayHide")};S.prototype._onDragEnterUploadCollection=function(e){if(!this._checkForFiles(e)){return}if(e.target===this._$DragDropArea[0]){this._$DragDropArea.addClass("sapMUCDropIndicator");this._adjustDragDropIcon();this.getAggregation("_dragDropText").setText(this._oRb.getText("UPLOADCOLLECTION_DROP_FILE_INDICATOR"))}};S.prototype._onDragOverUploadCollection=function(e){e.preventDefault();e.originalEvent.dataTransfer.dropEffect="copy"};S.prototype._onDragLeaveUploadCollection=function(e){if(e.target===this._$DragDropArea[0]){this._$DragDropArea.removeClass("sapMUCDropIndicator");this.getAggregation("_dragDropText").setText(this._oRb.getText("UPLOADCOLLECTION_DRAG_FILE_INDICATOR"))}};S.prototype._checkForFiles=function(e){var t=e.originalEvent.dataTransfer.types;if(t){for(var i=0;i<t.length;i++){if(t[i]==="Files"){return true}}}return false};S.prototype._isDragAndDropAllowed=function(){return this.getUploadEnabled()&&!this.getUploadButtonInvisible()};S.prototype._onDropOnUploadCollection=function(e){if(!this._checkForFiles(e)){e.preventDefault();return}if(e.target===this._$DragDropArea[0]){e.preventDefault();this._$DragDropArea.removeClass("sapMUCDropIndicator");this._$DragDropArea.addClass("sapMUCDragDropOverlayHide");this.getAggregation("_dragDropText").setText(this._oRb.getText("UPLOADCOLLECTION_DRAG_FILE_INDICATOR"));var t=e.originalEvent.dataTransfer.files;if(t.length>1&&!this.getMultiple()){var a=this._oRb.getText("UPLOADCOLLECTION_MULTIPLE_FALSE");i.error(a);return}if(!this._oFileUploader._areFilesAllowed(t)){return}if(!this.getInstantUpload()){for(var r=0;r<t.length;r++){this._oFileUploader.fireChange({files:[t[r]],fromDragDrop:true});this._aFilesFromDragAndDropForPendingUpload.push(t[r])}}else{this._oFileUploader.fireChange({files:t});this._oFileUploader._sendFilesFromDragAndDrop(t)}}};S.prototype._adjustDragDropIcon=function(){if(this._$DragDropArea[0].offsetHeight<160){this.getAggregation("_dragDropIcon").$().hide()}};S.prototype._deregisterSizeHandler=function(){L.orientation.detachHandler(this._onResize,this);T.deregister(this._sReziseHandlerId)};S.prototype._hideFileUploaders=function(){var e,t;if(!this.getInstantUpload()){e=this._oHeaderToolbar.getContent().length;if(this._aFileUploadersForPendingUpload.length){for(t=0;t<e;t++){if(this._oHeaderToolbar.getContent()[t]instanceof f){if(t===this._iFileUploaderPH&&this._bFocusFileUploader){this._oHeaderToolbar.getContent()[t].$().find("button").trigger("focus")}else{this._oHeaderToolbar.getContent()[t].$().hide()}}}}}};S.prototype._truncateFileName=function(e){if(!e){return}if(e._status==="Edit"){e._oListItem.$().find(".sapMUCObjectMarkerContainer").attr("style","display: none");return}var t=0;var i=e.getMarkers();var a;for(var r=0;r<i.length;r++){t=t+i[r].$().width()+S._markerMargin}if(t>0){var s=e._oFileNameLink.$();if(s){a="max-width: calc(100% - "+t+"px)";if(s.attr("style")!==a){s.attr("style",a)}}}};S.prototype._getListHeader=function(e){var t,i,a;this._setNumberOfAttachmentsTitle(e);if(!this._oHeaderToolbar){if(this._oFileUploader&&!this.getInstantUpload()){this._oFileUploader.destroy()}t=this._getFileUploader();this._oHeaderToolbar=this.getAggregation("toolbar");if(!this._oHeaderToolbar){this._oHeaderToolbar=new c(this.getId()+"-toolbar",{content:[this._oNumberOfAttachmentsTitle,new I,t]}).addEventDelegate({onAfterRendering:this._hideFileUploaders},this);this._iFileUploaderPH=2}else{this._oHeaderToolbar.addEventDelegate({onAfterRendering:this._hideFileUploaders},this);this._iFileUploaderPH=this._getFileUploaderPlaceHolderPosition(this._oHeaderToolbar);if(this._oHeaderToolbar&&this._iFileUploaderPH>-1){this._setFileUploaderInToolbar(t)}else{A.info("A place holder of type 'sap.m.UploadCollectionPlaceholder' needs to be provided.")}}}else if(!this.getInstantUpload()){var r=this._aFileUploadersForPendingUpload.length;for(i=r-1;i>=0;i--){if(this._aFileUploadersForPendingUpload[i].getId()===this._oFileUploader.getId()){t=this._getFileUploader();var s=this.getAggregation("headerParameters");var o=this._requestIdValue.toString();if(s){for(a=0;a<s.length;a++){t.addHeaderParameter(new m({name:s[a].getProperty("name"),value:s[a].getProperty("value")}))}t.addHeaderParameter(new m({name:this._headerParamConst.requestIdName,value:o}))}this._oHeaderToolbar.insertAggregation("content",t,this._iFileUploaderPH,true);break}}}};S.prototype._getFileUploaderPlaceHolderPosition=function(e){for(var t=0;t<e.getContent().length;t++){if(e.getContent()[t]instanceof F){return t}}return-1};S.prototype._setFileUploaderInToolbar=function(e){this._oHeaderToolbar.getContent()[this._iFileUploaderPH].setVisible(false);this._oHeaderToolbar.insertContent(e,this._iFileUploaderPH)};S.prototype._mapItemToListItem=function(e){if(!e||this._oItemToUpdate&&e.getId()===this._oItemToUpdate.getId()){return null}var t,i,a,r,s,o,n,l,d;t=e.getId();i=e._status;a=e.getFileName();if(i===S._uploadingStatus){r=new g({id:t+"-ia_indicator"});r.addStyleClass("sapMUCloadingIcon")}else{d=this._createIcon(e,t,a)}o=t+"-container";n=jQuery(document.getElementById(o));if(n){n.remove();n=null}l=new v(o,{content:"<span class='sapMUCTextButtonContainer'></span>",afterRendering:this._renderContent.bind(this,e,o)});s=new C(t+"-cli",{content:[r,d,l],selected:e.getSelected()});s._oUploadCollectionItem=e;s._status=i;s.addStyleClass("sapMUCItem");s.setTooltip(e.getTooltip_Text());e._oListItem=s;return s};S.prototype._renderContent=function(e,t){var i,a,r,s,o,n,l,d,p,h,g;n=e._percentUploaded;l=e.getAllAttributes();d=e.getStatuses();g=e.getMarkers();i=e.getId();r=l.length;s=d.length;o=g.length;h=e._status;p=this._RenderManager;p.openStart("div");p.class("sapMUCTextContainer");if(h==="Edit"){p.class("sapMUCEditMode")}p.openEnd();p.renderControl(this._getFileNameControl(e));if(h===S._uploadingStatus){p.renderControl(this._createProgressLabel(e,n))}else{if(o>0){p.openStart("div");p.class("sapMUCObjectMarkerContainer");p.openEnd();for(a=0;a<o;a++){p.renderControl(g[a].addStyleClass("sapMUCObjectMarker"))}p.close("div")}if(r>0){p.openStart("div");p.class("sapMUCAttrContainer");p.attr("tabindex","-1");p.openEnd();for(a=0;a<r;a++){l[a].addStyleClass("sapMUCAttr");p.renderControl(l[a]);if(a+1<r){p.openStart("div");p.class("sapMUCSeparator");p.openEnd();p.unsafeHtml("&nbsp&#x00B7&#160");p.close("div")}}p.close("div")}if(s>0){p.openStart("div");p.class("sapMUCStatusContainer");p.attr("tabindex","-1");p.openEnd();for(a=0;a<s;a++){d[a].detachBrowserEvent("hover");d[a].setTooltip(d[a].getTitle()+":"+d[a].getText());p.renderControl(d[a]);for(var u=a+1;u<s;u++){if(!d[a].getVisible()){break}else if(d[u]&&d[u].getVisible()){p.openStart("div");p.class("sapMUCSeparator");p.openEnd();p.unsafeHtml("&nbsp&#x00B7&#160");p.close("div");break}}}p.close("div")}}p.close("div");this._renderButtons(p,e,h,i);p.flush(jQuery(document.getElementById(t))[0],true);this._truncateFileName(e);this._sReziseHandlerId=T.register(this,this._onResize.bind(this));L.orientation.attachHandler(this._onResize,this)};S.prototype._renderButtons=function(e,t,i,a){var r,s;r=this._getButtons(t,i,a);if(r){s=r.length}if(s>0){e.openStart("div");e.class("sapMUCButtonContainer");e.openEnd();for(var o=0;o<s;o++){if(o+1<s){r[o].addStyleClass("sapMUCFirstButton")}e.renderControl(r[o])}e.close("div")}};S.prototype._getFileNameControl=function(t){var i,a,r,s,o,n,l,d,p,h,g;s=t.getFileName();o=t.getId();n=t._status;if(n!=="Edit"){i=t._getFileNameLink?t._getFileNameLink():t._getControl("sap.m.Link",{id:o+"-ta_filenameHL",press:[t,this._onItemPressed,this]},"FileNameLink");i.setEnabled(this._getItemPressEnabled(t));i.addStyleClass("sapMUCFileName");i.setModel(t.getModel());i.setText(s);t._oFileNameLink=i;return i}else{a=S._splitFilename(s);l=this.getMaximumFilenameLength();d="None";p=false;r=a.name;if(t.errorState==="Error"){p=true;d="Error";r=t.changedFileName;if(r.length===0){g=this._oRb.getText("UPLOADCOLLECTION_TYPE_FILENAME")}else{g=this._oRb.getText("UPLOADCOLLECTION_EXISTS")}}h=t._getFileNameEditBox?t._getFileNameEditBox():t._getControl("sap.m.Input",{id:o+"-ta_editFileName",type:e.InputType.Text},"FileNameEditBox");h.addStyleClass("sapMUCEditBox");h.setModel(t.getModel());h.setValue(r);h.setValueState(d);h.setFieldWidth("75%");h.setValueStateText(g);h.setDescription(a.extension);h.setShowValueStateMessage(p);if(l-a.extension.length>0){h.setProperty("maxLength",l-a.extension.length,true)}return h}};S.prototype._getItemPressEnabled=function(e){return e._getPressEnabled()&&this.sErrorState!=="Error"};S.prototype._onItemPressed=function(e,t){if(t.hasListeners("press")){t.firePress()}else if(this.sErrorState!=="Error"&&t._hasUrl()){this._triggerLink(e,t)}};S.prototype._createProgressLabel=function(e,t){var i,a=e.getId();i=e._getProgressLabel?e._getProgressLabel():e._getControl("sap.m.Label",{id:a+"-ta_progress"},"ProgressLabel").addStyleClass("sapMUCProgress");i.setText(this._oRb.getText("UPLOADCOLLECTION_UPLOADING",[t]));return i};S.prototype._createIcon=function(e,t,i){var a,r,l,d;a=e.getThumbnailUrl();if(a){l=o.createControlByURI({id:t+"-ia_imageHL",src:this._getThumbnail(a,i),decorative:false},n).addStyleClass("sapMUCItemImage sapMUCItemIcon");l.setAlt(this._getAriaLabelForPicture(e))}else{r=this._getThumbnail(undefined,i);l=new s(t+"-ia_iconHL",{src:r,decorative:false,useIconTooltip:false});l.setAlt(this._getAriaLabelForPicture(e));if(this.sErrorState!=="Error"&&e._hasUrl()){d="sapMUCItemIcon"}else{d="sapMUCItemIconInactive"}if(r===S._placeholderCamera){if(this.sErrorState!=="Error"&&e._hasUrl()){d=d+" sapMUCItemPlaceholder"}else{d=d+" sapMUCItemPlaceholderInactive"}}l.addStyleClass(d)}if(this._getItemPressEnabled(e)){l.attachPress(e,this._onItemPressed,this)}return l};S.prototype._getButtons=function(t,i,a){var r,s,o,n,l,d,p;r=[];if(!this.getInstantUpload()){n="deleteButton";l=this._createDeleteButton(a,n,t,this.sErrorState);r.push(l);return r}if(i==="Edit"){s=t._getOkButton?t._getOkButton():t._getControl("sap.m.Button",{id:a+"-okButton",text:this._oRb.getText("UPLOADCOLLECTION_RENAMEBUTTON_TEXT"),type:e.ButtonType.Transparent},"OkButton").addStyleClass("sapMUCOkBtn");o=t._getCancelButton?t._getCancelButton():t._getControl("sap.m.Button",{id:a+"-cancelButton",text:this._oRb.getText("UPLOADCOLLECTION_CANCELBUTTON_TEXT"),type:e.ButtonType.Transparent},"CancelButton").addStyleClass("sapMUCCancelBtn");r.push(s);r.push(o)}else if(i===S._uploadingStatus){n="terminateButton";l=this._createDeleteButton(a,n,t,this.sErrorState);r.push(l)}else{d=t.getEnableEdit();if(this.sErrorState==="Error"){d=false}if(t.getVisibleEdit()){p=t._getEditButton?t._getEditButton():t._getControl("sap.m.Button",{id:a+"-editButton",icon:"sap-icon://edit",type:e.ButtonType.Standard,tooltip:this._oRb.getText("UPLOADCOLLECTION_EDITBUTTON_TEXT"),press:[t,this._handleEdit,this]},"EditButton").addStyleClass("sapMUCEditBtn");p.setEnabled(d);p.setVisible(t.getVisibleEdit());r.push(p)}n="deleteButton";if(t.getVisibleDelete()){l=this._createDeleteButton(a,n,t,this.sErrorState);r.push(l)}}return r};S.prototype._createDeleteButton=function(t,i,a,r){var s,o,n,l,d,p,h;s=a.getEnableDelete();if(r==="Error"){s=false}if(i==="deleteButton"){n="DeleteButton";d=a._getDeleteButton;l=this._oRb.getText("UPLOADCOLLECTION_DELETEBUTTON_TEXT");p=a.getVisibleDelete();h=[this,this._handleDelete,this]}else{n="TerminateButton";d=a._getTerminateButton;l=this._oRb.getText("UPLOADCOLLECTION_TERMINATEBUTTON_TEXT");p=this.getTerminationEnabled();h=[a,this._handleTerminate,this]}o=d?d():a._getControl("sap.m.Button",{id:t+"-"+i,icon:"sap-icon://decline",type:e.ButtonType.Standard,press:h},n).addStyleClass("sapMUCDeleteBtn");o.setVisible(p);o.setEnabled(s);o.setTooltip(l);return o};S.prototype._fillList=function(e){var t=this,i=e.length-1,a=this.getBinding("items"),r=false,s,o=this.getBindingInfo("items")?this.getBindingInfo("items").model:undefined,n=this.getBindingInfo("items")?this.getBindingInfo("items").groupHeaderFactory:null;var l=function(e){return e.getBindingContext(o)?a.getGroup(e.getBindingContext(o)):null};var d=function(e){return l(e)&&l(e).key};jQuery.each(e,function(e,o){if(a&&a.isGrouped()&&o){if(!r||s!==d(o)){if(n){t._oList.addItemGroup(l(o),n(l(o)),true)}else if(l(o)){t._oList.addItemGroup(l(o),null,true)}r=true;s=d(o)}}if(!o._status||!o.getVisibleEdit()){o._status=S._displayStatus}else if(t.getInstantUpload()&&t._oItemForDelete&&t._oItemForDelete._status===S._toBeDeletedStatus&&o.getDocumentId()===t._oItemForDelete.documentId){return false}if(!o._percentUploaded&&o._status===S._uploadingStatus){o._percentUploaded=0}var p=t._mapItemToListItem(o);if(p){if(e===0&&i===0){p.addStyleClass("sapMUCListSingleItem")}else if(e===0){p.addStyleClass("sapMUCListFirstItem")}else if(e===i){p.addStyleClass("sapMUCListLastItem")}else{p.addStyleClass("sapMUCListItem")}t._oList.addAggregation("items",p,true);o.attachEvent("selected",t._handleItemSetSelected,t)}return true})};S.prototype._clearList=function(){if(this._oList){this._oList.destroyAggregation("items",true)}};S.prototype._setNumberOfAttachmentsTitle=function(e){var t=e||0;var i;if(this._oItemToUpdate){t--}if(this.getNumberOfAttachmentsText()){i=this.getNumberOfAttachmentsText()}else{i=this._oRb.getText("UPLOADCOLLECTION_ATTACHMENTS",[t])}if(!this._oNumberOfAttachmentsTitle){this._oNumberOfAttachmentsTitle=new d(this.getId()+"-numberOfAttachmentsTitle",{text:i})}else{this._oNumberOfAttachmentsTitle.setText(i)}};S.prototype._setFileUploaderVisibility=function(e){var t=this._oHeaderToolbar.getContent();if(t){var i=t[this._iFileUploaderPH];if(i instanceof f){i.setVisible(!e)}}};S.prototype._handleDelete=function(e){var t=e.getParameters();var a=this.getItems();var r=t.id.split("-deleteButton")[0];var s;var o;var n="";var l;var d;for(var p=0;p<a.length;p++){if(a[p].sId===r){o=p;s={documentId:a[p].getDocumentId(),_iLineNumber:o};break}}if(a[o].hasListeners("deletePress")){a[o].fireDeletePress();return}this.sDeletedItemId=r;if(jQuery(document.getElementById(this.sId)).hasClass("sapUiSizeCompact")){n="sapUiSizeCompact"}if(this.editModeItem){this._handleOk(e,this.editModeItem,true);if(this.sErrorState==="Error"){return}}if(a[o]&&a[o].getEnableDelete()){l=a[o].getFileName();if(!l){d=this._oRb.getText("UPLOADCOLLECTION_DELETE_WITHOUT_FILENAME_TEXT")}else{d=this._oRb.getText("UPLOADCOLLECTION_DELETE_TEXT",l)}this._oItemForDelete=s;i.show(d,{title:this._oRb.getText("UPLOADCOLLECTION_DELETE_TITLE"),actions:[i.Action.OK,i.Action.CANCEL],emphasizedAction:i.Action.OK,onClose:this._onCloseMessageBoxDeleteItem.bind(this),dialogId:"messageBoxDeleteFile",styleClass:n})}};S.prototype._onCloseMessageBoxDeleteItem=function(e){var t=this.getItems();var a;if(this.getInstantUpload()){for(var r=0;r<t.length;r++){if(t[r].getDocumentId()===this._oItemForDelete.documentId){a=t[r]}}}else{a=t[this._oItemForDelete._iLineNumber]}if(e===i.Action.OK){this._oItemForDelete._status=S._toBeDeletedStatus;if(this.getInstantUpload()){this.fireFileDeleted({documentId:this._oItemForDelete.documentId,item:a});this._oItemForDelete=null}else{if(this.aItems.length===1){if(!this.getUploadButtonInvisible()){this.sFocusId=this._oFileUploader.$().find(":button")[0].id}}else if(this._oItemForDelete._iLineNumber<this.aItems.length-1){this.sFocusId=this.aItems[this._oItemForDelete._iLineNumber+1].getId()+"-cli"}else{this.sFocusId=this.aItems[0].getId()+"-cli"}this._aDeletedItemForPendingUpload.push(a);this.aItems.splice(this._oItemForDelete._iLineNumber,1);this.removeAggregation("items",a,false)}}};S.prototype._handleTerminate=function(e,t){var i,r;i=new h({items:[new u({icon:this._getIconFromFilename(t.getFileName())})]});i.getItems()[0].setTitle(t.getFileName());r=new a({id:this.getId()+"deleteDialog",title:this._oRb.getText("UPLOADCOLLECTION_TERMINATE_TITLE"),content:[new l({text:this._oRb.getText("UPLOADCOLLECTION_TERMINATE_TEXT")}),i],buttons:[new p({text:this._oRb.getText("UPLOADCOLLECTION_OKBUTTON_TEXT"),press:[s,this]}),new p({text:this._oRb.getText("UPLOADCOLLECTION_CANCELBUTTON_TEXT"),press:function(){r.close()}})],afterClose:function(){r.destroy()}}).open();function s(){var e=false;for(var i=0;i<this.aItems.length;i++){if(this.aItems[i]._status===S._uploadingStatus&&this.aItems[i]._requestIdName===t._requestIdName){this.aItems[i]._status=S._toBeDeletedStatus;this._oItemForDelete=this.aItems[i];e=true;break}else if(t.getFileName()===this.aItems[i].getFileName()&&this.aItems[i]._status===S._displayStatus){this.aItems[i]._status=S._toBeDeletedStatus;this._oItemForDelete=this.aItems[i];this.fireFileDeleted({documentId:this.aItems[i].getDocumentId(),item:this.aItems[i]});break}}if(e){this._getFileUploader().abort(this._headerParamConst.fileNameRequestIdName,this._encodeToAscii(t.getFileName())+this._oItemForDelete._requestIdName)}r.close();this.invalidate()}};S.prototype._handleEdit=function(e,t){var i,a=t.getId(),r=this.aItems.length;if(this.editModeItem){this._handleOk(e,this.editModeItem,false)}if(this.sErrorState!=="Error"){for(i=0;i<r;i++){if(this.aItems[i].getId()===a){this.aItems[i]._status="Edit";break}}t._status="Edit";this.editModeItem=e.getSource().getId().split("-editButton")[0];this.invalidate()}};S.prototype._handleClick=function(e,t){var i=jQuery(e.target).closest("button");var a="";if(i.length){a=i.prop("id")}if(a.lastIndexOf("editButton")===-1){if(a.lastIndexOf("cancelButton")!==-1){this._handleCancel(e,t)}else if(e.target.id.lastIndexOf("ia_imageHL")<0&&e.target.id.lastIndexOf("ia_iconHL")<0&&e.target.id.lastIndexOf("deleteButton")<0&&e.target.id.lastIndexOf("ta_editFileName-inner")<0){if(e.target.id.lastIndexOf("cli")>0){this.sFocusId=e.target.id}this._handleOk(e,t,true)}}};S.prototype._handleOk=function(e,t,i){var a=document.getElementById(t+"-ta_editFileName-inner");var r;var s=S._findById(t,this.aItems);var o=s.getProperty("fileName");var n=S._splitFilename(o);var l=sap.ui.getCore().byId(t+"-ta_editFileName");var d=s.errorState;var p=s.changedFileName;if(a!==null){r=a.value.replace(/^\s+/,"")}this.sFocusId=t+"-cli";if(!r||r.length===0){if(a!==null){this._setErrorStateOnItem(this,s,r,p,d)}return}s._status=S._displayStatus;if(n.name===r){this._removeErrorStateFromItem(this,s);if(i){this.invalidate()}return}if(this.getSameFilenameAllowed()){this._removeErrorStateFromItem(this,s);this._oItemForRename=s;this._onEditItemOk.bind(this)(r+n.extension);return}if(S._checkDoubleFileName(r+n.extension,this.aItems)){l.setProperty("valueState","Error",true);this._setErrorStateOnItem(this,s,r,p,d)}else{l.setProperty("valueState","None",true);s.changedFileName=null;this._removeErrorStateFromItem(this,s);if(i){this.invalidate()}this._oItemForRename=s;this._onEditItemOk.bind(this)(r+n.extension)}};S.prototype._setErrorStateOnItem=function(e,t,i,a,r){t._status="Edit";t.errorState="Error";e.sErrorState="Error";t.changedFileName=i;if(r!=="Error"||a!==i){e.invalidate()}};S.prototype._removeErrorStateFromItem=function(e,t){t.errorState=null;e.sErrorState=null;e.editModeItem=null};S.prototype._onEditItemOk=function(e){if(this._oItemForRename){this._oItemForRename.setFileName(e);this.fireFileRenamed({documentId:this._oItemForRename.getProperty("documentId"),fileName:e,item:this._oItemForRename})}delete this._oItemForRename};S.prototype._handleCancel=function(e,t){var i=S._findById(t,this.aItems);i._status=S._displayStatus;i.errorState=null;i.changedFileName=i._getFileNameEditBox().getValue();this.sFocusId=this.editModeItem+"-cli";this.sErrorState=null;this.editModeItem=null;this.invalidate()};S.prototype._onChange=function(e){if(e){var t,i=e.getParameter("files").length,a,r,s,o,n;if(i===0){return}this._oFileUploader.removeAllAggregation("headerParameters",true);this.removeAllAggregation("headerParameters",true);this._oFileUploader.removeAllAggregation("parameters",true);this.removeAllAggregation("parameters",true);this.fireChange({getParameter:function(t){if(t){return e.getParameter(t)}return null},getParameters:function(){return e.getParameters()},mParameters:e.getParameters(),files:e.getParameter("files")});var l=this.getAggregation("parameters");if(l){jQuery.each(l,function(e,t){var i=new m({name:t.getProperty("name"),value:t.getProperty("value")});this._oFileUploader.addParameter(i)}.bind(this))}if(!this.getInstantUpload()){this._bFocusFileUploader=true;s=S._pendingUploadStatus}else{s=S._uploadingStatus}this._requestIdValue++;t=this._requestIdValue.toString();var d=this.getAggregation("headerParameters");if(!this.getInstantUpload()){this._aFileUploadersForPendingUpload.push(this._oFileUploader)}for(a=0;a<i;a++){r=new y;r.setFileName(e.getParameter("files")[a].name);if(e.getParameter("fromDragDrop")){r._internalFileIdWithinDragDropArray=e.getParameter("files")[a]}r._status=s;r._internalFileIndexWithinFileUploader=a+1;r._requestIdName=t;if(!this.getInstantUpload()){r.setAssociation("fileUploader",this._oFileUploader,true);o=this._oFormatDecimal.format(e.getParameter("files")[a].size);n=new U({text:o});r.insertAggregation("attributes",n,true);this.insertItem(r)}else{r._percentUploaded=0}this.aItems.unshift(r)}if(d){jQuery.each(d,function(e,t){this._oFileUploader.addHeaderParameter(new m({name:t.getProperty("name"),value:t.getProperty("value")}))}.bind(this))}this._oFileUploader.addHeaderParameter(new m({name:this._headerParamConst.requestIdName,value:t}))}};S.prototype._onFilenameLengthExceed=function(e){var t={name:e.getParameter("fileName")};var i=[t];this.fireFilenameLengthExceed({getParameter:function(t){if(t){return e.getParameter(t)}},getParameters:function(){return e.getParameters()},mParameters:e.getParameters(),files:i})};S.prototype._onFileSizeExceed=function(e){var t={name:e.getParameter("fileName"),fileSize:e.getParameter("fileSize")};this.fireFileSizeExceed({getParameter:function(t){if(t){return e.getParameter(t)}},getParameters:function(){return e.getParameters()},mParameters:e.getParameters(),files:[t]})};S.prototype._onTypeMissmatch=function(e){var t={name:e.getParameter("fileName"),fileType:e.getParameter("fileType"),mimeType:e.getParameter("mimeType")};var i=[t];this.fireTypeMissmatch({getParameter:function(t){if(t){return e.getParameter(t)}},getParameters:function(){return e.getParameters()},mParameters:e.getParameters(),files:i})};S.prototype._onUploadTerminated=function(e){var t;var i=this._getRequestId(e);var a=e.getParameter("fileName");var r=this.aItems.length;for(t=0;t<r;t++){if(this.aItems[t]&&this.aItems[t].getFileName()===a&&this.aItems[t]._requestIdName===i&&(this.aItems[t]._status===S._uploadingStatus||this.aItems[t]._status===S._toBeDeletedStatus)){if(this.getItems()&&this.getItems()[t]===this.aItems[t]){this.removeItem(t)}this.aItems.splice(t,1);break}}this.fireUploadTerminated({fileName:a,getHeaderParameter:this._getHeaderParameterWithinEvent.bind(e)})};S.prototype._onUploadComplete=function(e){if(e){var t,i=this._getRequestId(e),a=e.getParameter("fileName"),r=e.getParameter("id"),s,o,n,l=d();s=this.aItems.length;n=[S._uploadingStatus,S._pendingUploadStatus];for(t=0;t<s;t++){if((!i||this.aItems[t]._requestIdName===i)&&this.aItems[t].getProperty("fileName")===a&&n.indexOf(this.aItems[t]._status)>=0){if(l&&this.aItems[t]._status!==S._pendingUploadStatus){this.aItems[t]._percentUploaded=100;this.aItems[t]._status=S._displayStatus}o=this.aItems.splice(t,1)[0];if(o.destroy){o.destroy()}this._oItemToUpdate=null;break}}for(t=0;t<this._aFileUploadersForPendingUpload.length;t++){if(this._aFileUploadersForPendingUpload[t].getId()===r){this._aFileUploadersForPendingUpload[t].clear();break}}this.fireUploadComplete({getParameter:e.getParameter,getParameters:e.getParameters,mParameters:e.getParameters(),files:[{fileName:e.getParameter("fileName")||a,responseRaw:e.getParameter("responseRaw"),reponse:e.getParameter("response"),response:e.getParameter("response"),status:e.getParameter("status"),headers:e.getParameter("headers")}]})}this.invalidate();function d(){var t=e.getParameter("status").toString()||"200";return t[0]==="2"||t[0]==="3"}};S.prototype._onUploadProgress=function(e){if(!e||!this.getInstantUpload()){return}var t=e.getParameter("fileName"),i,a=Math.round(e.getParameter("loaded")/e.getParameter("total")*100),r=this._getRequestId(e),s=this.aItems.length,o,n,l;if(a===100){i=this._oRb.getText("UPLOADCOLLECTION_UPLOAD_COMPLETED")}else{i=this._oRb.getText("UPLOADCOLLECTION_UPLOADING",[a])}for(var d=0;d<s;d++){l=this.aItems[d];if(l.getProperty("fileName")===t&&l._requestIdName===r&&l._status===S._uploadingStatus){o=l._getProgressLabel?l._getProgressLabel():l._getControl("sap.m.Label",{id:l.getId()+"-ta_progress"},"ProgressLabel");if(o){o.setText(i);o.rerender();l._percentUploaded=a;n=l.$("ia_indicator");if(a===100){n.attr("aria-label",i)}else{n.attr("aria-valuenow",a)}break}}}};S.prototype._getRequestId=function(e){var t;t=e.getParameter("requestHeaders");if(!t){return null}for(var i=0;i<t.length;i++){if(t[i].name===this._headerParamConst.requestIdName){return t[i].value}}return null};S.prototype._getFileUploader=function(){var e=this.getInstantUpload();if(!e||!this._oFileUploader){var t=this.getInstantUpload()?this._oRb.getText("UPLOADCOLLECTION_UPLOAD"):this._oRb.getText("UPLOADCOLLECTION_ADD");this._iFUCounter=this._iFUCounter+1;this._oFileUploader=new f(this.getId()+"-"+this._iFUCounter+"-uploader",{buttonOnly:true,buttonText:t,iconOnly:false,enabled:this.getUploadEnabled(),fileType:this.getFileType(),icon:"",iconFirst:false,style:"Transparent",maximumFilenameLength:this.getMaximumFilenameLength(),maximumFileSize:this.getMaximumFileSize(),mimeType:this.getMimeType(),multiple:this.getMultiple(),name:"uploadCollection",uploadOnChange:e,sameFilenameAllowed:true,uploadUrl:this.getUploadUrl(),useMultipart:false,sendXHR:true,change:[this._onChange,this],filenameLengthExceed:[this._onFilenameLengthExceed,this],fileSizeExceed:[this._onFileSizeExceed,this],typeMissmatch:[this._onTypeMissmatch,this],uploadAborted:[this._onUploadTerminated,this],uploadComplete:[this._onUploadComplete,this],uploadProgress:[this._onUploadProgress,this],uploadStart:[this._onUploadStart,this],visible:!this.getUploadButtonInvisible()})}return this._oFileUploader};S.prototype._onUploadStart=function(e){var t,i,a,r,s,o,n;this._iUploadStartCallCounter++;s=e.getParameter("requestHeaders").length;for(i=0;i<s;i++){if(e.getParameter("requestHeaders")[i].name===this._headerParamConst.requestIdName){a=e.getParameter("requestHeaders")[i].value;break}}o=e.getParameter("fileName");t={name:this._headerParamConst.fileNameRequestIdName,value:this._encodeToAscii(o)+a};e.getParameter("requestHeaders").push(t);r={name:this._headerParamConst.acceptLanguage,value:N.getLanguage()};e.getParameter("requestHeaders").push(r);for(i=0;i<this._aDeletedItemForPendingUpload.length;i++){if(this._aDeletedItemForPendingUpload[i].getAssociation("fileUploader")===e.oSource.sId&&this._aDeletedItemForPendingUpload[i].getFileName()===o&&this._aDeletedItemForPendingUpload[i]._internalFileIndexWithinFileUploader===this._iUploadStartCallCounter){e.getSource().abort(this._headerParamConst.fileNameRequestIdName,this._encodeToAscii(o)+a);return}}this.fireBeforeUploadStarts({fileName:o,addHeaderParameter:l,getHeaderParameter:d.bind(this)});if(Array.isArray(n)){for(i=0;i<n.length;i++){if(e.getParameter("requestHeaders")[i].name===n[i].getName()){e.getParameter("requestHeaders")[i].value=n[i].getValue()}}}else if(n instanceof D){for(i=0;i<e.getParameter("requestHeaders").length;i++){if(e.getParameter("requestHeaders")[i].name===n.getName()){e.getParameter("requestHeaders")[i].value=n.getValue();break}}}function l(t){var i={name:t.getName(),value:t.getValue()};e.getParameter("requestHeaders").push(i)}function d(t){n=this._getHeaderParameterWithinEvent.bind(e)(t);return n}};S.prototype._getIconFromFilename=function(e){var t=S._splitFilename(e).extension;if(typeof t==="string"){t=t.toLowerCase()}switch(t){case".bmp":case".jpg":case".jpeg":case".png":return S._placeholderCamera;case".csv":case".xls":case".xlsx":return"sap-icon://excel-attachment";case".doc":case".docx":case".odt":return"sap-icon://doc-attachment";case".pdf":return"sap-icon://pdf-attachment";case".ppt":case".pptx":return"sap-icon://ppt-attachment";case".txt":return"sap-icon://document-text";default:return"sap-icon://document"}};S.prototype._getThumbnail=function(e,t){if(e){return e}else{return this._getIconFromFilename(t)}};S.prototype._triggerLink=function(e,i){if(this.editModeItem){this._handleOk(e,this.editModeItem,true);if(this.sErrorState==="Error"){return}this.sFocusId=e.getParameter("id")}t.URLHelper.redirect(i.getProperty("url"),true)};S.prototype.onkeydown=function(e){switch(e.keyCode){case E.F2:this._handleF2(e);break;case E.ESCAPE:this._handleESC(e);break;case E.DELETE:this._handleDEL(e);break;case E.ENTER:this._handleENTER(e);break;default:return}e.setMarked()};S.prototype._setFocusAfterDeletion=function(){var e=this.aItems.length;var t;if(e===0){this._oFileUploader.focus()}else{var i=this.sDeletedItemId.split("-").pop();if(i<=e-1){t=this.sDeletedItemId+"-cli"}else{t=this.aItems[this.aItems.length-1].sId+"-cli"}this._setFocusToLineItem(t)}this.sDeletedItemId=null};S.prototype._setFocusToLineItem=function(e){jQuery(document.getElementById(e)).trigger("focus")};S.prototype._handleENTER=function(e){var i,a,r,s;if(this.editModeItem){i=e.target.id.split(this.editModeItem).pop()}else{i=e.target.id.split("-").pop()}switch(i){case"-ta_editFileName-inner":case"-okButton":this._handleOk(e,this.editModeItem,true);break;case"-cancelButton":e.preventDefault();this._handleCancel(e,this.editModeItem);break;case"-ia_iconHL":case"-ia_imageHL":s=this.editModeItem.split("-").pop();t.URLHelper.redirect(this.aItems[s].getProperty("url"),true);break;case"ia_iconHL":case"ia_imageHL":case"cli":a=e.target.id.split(i)[0]+"ta_filenameHL";r=sap.ui.getCore().byId(a);if(r.getEnabled()){s=e.target.id.split("-")[2];t.URLHelper.redirect(this.aItems[s].getProperty("url"),true)}break;default:break}};S.prototype._handleDEL=function(e){if(!this.editModeItem){var t=e.target.id.slice(0,-4),i=sap.ui.getCore().byId(t),a=i&&i._getDeleteButton&&i._getDeleteButton();if(a){a.firePress()}}};S.prototype._handleESC=function(e){if(this.editModeItem){this.sFocusId=this.editModeItem+"-cli";this.aItems[this.editModeItem.split("-").pop()]._status=S._displayStatus;this._handleCancel(e,this.editModeItem)}};S.prototype._handleF2=function(e){var t=sap.ui.getCore().byId(e.target.id);if(t!==undefined){if(t._status===S._displayStatus){var i=jQuery(document.getElementById(e.target.id));var a=i.find("[id$='-editButton']");var r=sap.ui.getCore().byId(a[0].id);if(r.getEnabled()){if(this.editModeItem){this._handleClick(e,this.editModeItem)}if(this.sErrorState!=="Error"){r.firePress()}}}else{this._handleClick(e,this.editModeItem)}}else if(e.target.id.search(this.editModeItem)===0){this._handleOk(e,this.editModeItem,true)}};S._checkDoubleFileName=function(e,t){if(t.length===0||!e){return false}var i=t.length;e=e.replace(/^\s+/,"");for(var a=0;a<i;a++){if(e===t[a].getProperty("fileName")){return true}}return false};S._splitFilename=function(e){var t={};var i=e.split(".");if(i.length===1){t.extension="";t.name=i.pop();return t}t.extension="."+i.pop();t.name=i.join(".");return t};S.prototype._getAriaLabelForPicture=function(e){var t;t=e.getAriaLabelForPicture()||e.getFileName();return t};S.prototype._getHeaderParameterWithinEvent=function(e){var t=[];var i=this.getParameter("requestHeaders");var a=i.length;var r;if(i&&e){for(r=0;r<a;r++){if(i[r].name===e){return new D({name:i[r].name,value:i[r].value})}}return null}else if(i){for(r=0;r<a;r++){t.push(new D({name:i[r].name,value:i[r].value}))}return t}};S.prototype._encodeToAscii=function(e){var t="";for(var i=0;i<e.length;i++){t=t+e.charCodeAt(i)}return t};S.prototype._onResize=function(){var e=this._oList.getItems();for(var t=0;t<e.length;t++){var i=e[t];setTimeout(function(){var e=this._truncateFileName.bind(this);if(typeof e==="string"||e instanceof String){e=this[e]}e.apply(this,[i._oUploadCollectionItem])}.bind(this),S._resizeTimeoutInterval)}};S.prototype._getUploadCollectionItemByListItem=function(e){var t=this.getItems();for(var i=0;i<t.length;i++){if(t[i].getId()===e.getId().replace("-cli","")){return t[i]}}return null};S.prototype._getUploadCollectionItemById=function(e){var t=this.getItems();for(var i=0;i<t.length;i++){if(t[i].getId()===e){return t[i]}}return null};S.prototype._getUploadCollectionItemsByListItems=function(e){var t=[];var i=this.getItems();if(e){for(var a=0;a<e.length;a++){for(var r=0;r<i.length;r++){if(e[a].getId().replace("-cli","")===i[r].getId()){t.push(i[r]);break}}}return t}return null};S.prototype._setSelectedForItems=function(t,i){if(this.getMode()!==e.ListMode.MultiSelect&&i){var a=this.getItems();for(var r=0;r<a.length;r++){a[r].setSelected(false)}}for(var s=0;s<t.length;s++){t[s].setSelected(i)}};S.prototype._handleItemSetSelected=function(e){var t=e.getSource();if(t instanceof y){var i=this._getListItemById(t.getId()+"-cli");if(i){i.setSelected(t.getSelected())}}};S.prototype._handleSelectionChange=function(e){var t=e.getParameter("listItem");var i=e.getParameter("selected");var a=this._getUploadCollectionItemsByListItems(e.getParameter("listItems"));var r=this._getUploadCollectionItemByListItem(t);if(r&&t&&a){this.fireSelectionChange({selectedItem:r,selectedItems:a,selected:i});r.setSelected(t.getSelected())}};S.prototype._getListItemById=function(e){var t=this._oList.getItems();return S._findById(e,t)};S._findById=function(e,t){for(var i=0;i<t.length;i++){if(t[i].getId()===e){return t[i]}}return null};return S});
//# sourceMappingURL=UploadCollection.js.map